# -*- coding: utf-8 -*-

"""
001	2012-08-05
000	2012-08-04
"""

# Import standard libraries
import os

# Import the PyQt and QGIS libraries
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from qgis.gui import *

# Import specific libraries
from cad4qgis_core import *

class pLine4qgisPlineNavDlg(QDialog):	#QtGui.
	"""
		Dialogo per navigazione di una polilinea

		presuppone che il parent abbia queste risorse:
			self.parent.canvas
	"""

	def __init__(self,parent,title,line):
		""" Inizializza la maschera di navigazione """

		self.parent = parent
		self.line = line
		self.marker = ''

		QDialog.__init__(self)	#QtGui.
		self.setObjectName("Dialog")
		self.resize(230, 190)
		self.setWindowTitle(title)

		label = QLabel(self)	#QtGui.
		label.setGeometry(QRect(10, 10, 50, 30))	#QtCore.
		label.setText('vertex')
		self.idxLab = QLabel(self)	#QtGui.
		self.idxLab.setGeometry(QRect(70, 10, 170, 30))	#QtCore.

		label = QLabel(self)	#QtGui.
		label.setGeometry(QRect(10, 50, 30, 30))	#QtCore.
		label.setText('X=')
		self.xEntry = QLineEdit(self)	#QtGui.
		self.xEntry.setGeometry(QRect(50, 50, 170, 30))	#QtCore.

		label = QLabel(self)	#QtGui.
		label.setGeometry(QRect(10, 90, 30, 30))	#QtCore.
		label.setText('Y=')
		self.yEntry = QLineEdit(self)	#QtGui.
		self.yEntry.setGeometry(QRect(50, 90, 170, 30))	#QtCore.

		pbBack = QPushButton(self)	#QtGui.
		pbBack.setGeometry(QRect(50, 130, 20, 20))	#QtCore.
		pbBack.setText('<')

		pbAhead = QPushButton(self)	#QtGui.
		pbAhead.setGeometry(QRect(80, 130, 20, 20))	#QtCore.
		pbAhead.setText('>')

		pbSave = QPushButton(self)	#QtGui.
		pbSave.setGeometry(QRect(120, 130, 100, 20))	#QtCore.
		pbSave.setText('save point')

		buttonBox = QDialogButtonBox(self)	#QtGui.
		buttonBox.setGeometry(QRect(120, 160, 100, 20))	#QtCore.
		buttonBox.setOrientation(Qt.Horizontal)	#QtCore.
		buttonBox.setStandardButtons(QDialogButtonBox.Cancel|QDialogButtonBox.Ok)	#QtGui.,QtGui.
		buttonBox.setObjectName("buttonBox")

		QObject.connect(pbAhead, SIGNAL("clicked()"),self.ahead)
		QObject.connect(pbBack, SIGNAL("clicked()"),self.back)
		QObject.connect(pbSave, SIGNAL("clicked()"),self.save)

		QObject.connect(buttonBox, SIGNAL("accepted()"), self.accept)	#QtCore.,QtCore.
		QObject.connect(buttonBox, SIGNAL("rejected()"), self.reject)	#QtCore.,QtCore.
		QMetaObject.connectSlotsByName(self)	#QtCore.

		# inizializza i valori
		self.idx = 0
		self.setValues()

	def setValues(self):
		if self.marker != '':
			self.parent.markerList.pop()
			self.parent.canvas.scene().removeItem(self.marker)
		pnt = self.line[self.idx]
		x,y = pnt.x(),pnt.y()
		self.marker = pntHighlight(self.parent.canvas,x,y)
		self.parent.markerList.append(self.marker)	# lo salva quì così dall'esterno può essere eliminato
		self.idxLab.setText(str(self.idx))
		self.xEntry.setText(str(x))
		self.yEntry.setText(str(y))

	def ahead(self):
		self.idx += 1
		self.idx = min(self.idx,len(self.line)-1)	# NB: è in base 0
		self.setValues()

	def back(self):
		self.idx -= 1
		self.idx = max(self.idx,0)
		self.setValues()

	def save(self):
		pnt1 = self.line[self.idx]
		x = float(self.xEntry.text())
		y = float(self.yEntry.text())
		pnt2 = QgsPoint(x,y)
		self.line[self.idx] = pnt2
		m = edgeHighlight(self.parent.canvas,pnt1,pnt2)
		self.parent.markerList.append(m)
