# -*- coding: utf-8 -*-

"""
000	2012-08-04
"""

# Import the PyQt and QGIS libraries
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from qgis.gui import *

# Import custom libraries
from cad4qgis_core import *

class polyg4qgisItemsSelectDlg(QDialog):	#QtGui.
	"""
		Dialogo per la selezione di elementi di poligono (polyg4qgis):
		seleziona:
			polygons (da fare)
			edges		(da fare)
			vertices

		presuppone che il parente abbia queste risorse:
			self.parent.clickTool
			self.parent.isClickToolActivated
			self.parent.selectList
			self.parent.markerList
	"""

	def __init__(self,parent,type,msg=''):
		""" Inizializza la maschera di selezione """

		self.parent = parent
		self.type = type

		QDialog.__init__(self)	#QtGui.
		self.setObjectName("Dialog")
		self.resize(220, 110)
		self.setWindowTitle('Select '+type)

		if msg != '':
			lab = QLabel(self)	#QtGui.
			lab.setGeometry(QRect(10, 10, 200, 30))	#QtCore.
			lab.setText(msg)

		self.items = QLabel(self)	#QtGui.
		self.items.setGeometry(QRect(10, 40, 200, 30))	#QtCore.

		pbClear = QPushButton(self)	#QtGui.
		pbClear.setText('Clear')
		pbClear.setGeometry(QRect(10, 80, 50, 20))	#QtCore.
#		pbClear.setText('Clear')
		pbClear.setToolTip("Clear")

		buttonBox = QDialogButtonBox(self)	#QtGui.
		buttonBox.setGeometry(QRect(100, 80, 100, 20))	#QtCore.
		buttonBox.setOrientation(Qt.Horizontal)	#QtCore.
		buttonBox.setStandardButtons(QDialogButtonBox.Cancel|QDialogButtonBox.Ok)	#QtGui.,QtGui.
		buttonBox.setObjectName("buttonBox")

		QObject.connect(pbClear, SIGNAL("clicked()"), self.clear)	#QtCore.,QtCore.
		QObject.connect(buttonBox, SIGNAL("accepted()"), self.accept)	#QtCore.,QtCore.
		QObject.connect(buttonBox, SIGNAL("rejected()"), self.reject)	#QtCore.,QtCore.
		QMetaObject.connectSlotsByName(self)	#QtCore.

		self.clear()

		# try to disconnect previous signals
		if self.parent.isClickToolActivated:
			self.parent.clickTool.canvasClicked.disconnect()
			self.parent.isClickToolActivated = False
		# connect to click signal
		QObject.connect(
			self.parent.clickTool,
			SIGNAL("canvasClicked(const QgsPoint &, Qt::MouseButton)"),
			self.appendSel
		)
		self.parent.isClickToolActivated = True

	def clear(self):
		cleanSelection(self.parent)
		self.items.setText('item: ')

	def appendSel(self,point):
		"""
			Aggiunge il selezionato;
		"""
		searchFeat(self.parent,point)
		feat = QgsFeature()
		self.parent.cLayer.nextFeature(feat)
		if feat.isValid():
			fId = feat.id()
			# salva il contenuto di self.items
			oldText = self.items.text()
			if self.type == 'polygon':
				self.items.setText('not awailable')
			elif self.type == 'edge':
				self.items.setText('not awailable')
			elif self.type == 'vertex':
				tmp = searchPolygVertex(feat,point,self.parent.eps)
				if len(tmp) == 3:
					pId,vId,p = tmp
					self.parent.selectList.append(p)
					m = pntHighlight(self.parent.canvas,p.x(),p.y())
					self.parent.markerList.append(m)
					self.items.setText(oldText + ' %d:%d:%d' % (fId,pId,vId))

