# -*- coding: utf-8 -*-
"""
/***************************************************************************
 BuildShortEvacTimeDialog
                                 A QGIS plugin
 Building level Shortest Evacuation Time
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2025-12-27
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Gaurav Khairnar
        email                : gaurav.b.khairnar@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import processing
from qgis.PyQt import uic
from qgis.PyQt.QtWidgets import QApplication
from qgis.PyQt import QtWidgets
from qgis.core import (
    QgsWkbTypes,
    QgsProject,QgsFeature,
    QgsGeometry,
    QgsCoordinateTransform,
    QgsVectorLayer,
    QgsField,
    Qgis
)
import geopandas as gpd
from PyQt5.QtCore import QVariant
import pandas as pd
from shapely.geometry import shape, box, LineString, Point
import json
import osmnx as ox
import networkx as nx
from qgis.core import QgsApplication
from .Build_Short_Evac_Time_help import BuildShortEvacTimeHelpDialog
from qgis.core import QgsMapLayerProxyModel
from qgis.gui import QgsMapLayerComboBox
import numpy as np

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'Build_Short_Evac_Time_dialog_base.ui'))


class BuildShortEvacTimeDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, iface, parent=None):
        """Constructor."""
        super(BuildShortEvacTimeDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.iface = iface
        self.setupUi(self)
        self._replace_with_layer_combo(self.buildingLayerCombo,QgsMapLayerProxyModel.PolygonLayer)
        self._replace_with_layer_combo(self.shelterLayerCombo,QgsMapLayerProxyModel.PointLayer)
        self._replace_with_layer_combo(self.floodLayerCombo,QgsMapLayerProxyModel.PolygonLayer)
        
  
        ok_button = self.buttonbox.button(QtWidgets.QDialogButtonBox.Ok)
        ok_button.clicked.connect(self.run_evacuation)
        # self.buttonbox.accepted.connect(self.run_evacuation)
        self.progressBar.setValue(0)
        self.progressBar.setVisible(True)
        
        self.buildingLayerCombo.setToolTip(
            "Polygon layer representing buildings or structures to be evacuated."
        )
        
        self.shelterLayerCombo.setToolTip(
            "Point layer representing safe shelters or evacuation centers."
        )
        
        self.floodLayerCombo.setToolTip(
            "Flood or inundation layer used to identify buildings under risk."
        )
        
        self.help_dialog = None
        self.helpButton.clicked.connect(self.open_help)
        #self.statusLabel.setText("Ready").setVisible(False)

    def _replace_with_layer_combo(self, old_combo, layer_filter):
        parent = old_combo.parentWidget()
    
        # Create new QgsMapLayerComboBox
        layer_combo = QgsMapLayerComboBox(parent)
        layer_combo.setFilters(layer_filter)
        layer_combo.setAllowEmptyLayer(True)
    
        # Copy geometry & size
        layer_combo.setGeometry(old_combo.geometry())
        layer_combo.setObjectName(old_combo.objectName())
    
        # Insert into UI
        old_combo.hide()
        old_combo.deleteLater()
    
        layer_combo.show()
    
        # Rebind to self.<objectName>
        setattr(self, layer_combo.objectName(), layer_combo)
        
    def open_help(self):
        if self.help_dialog is None:
            self.help_dialog = BuildShortEvacTimeHelpDialog(self)
    
        self.help_dialog.show()
        self.help_dialog.raise_()
        self.help_dialog.activateWindow()
        
    def flooded_buildings(buildings,flood_patch):
        
        buildings = buildings.to_crs('32644')
        buildings_at_risk = buildings[buildings.geometry.intersects(flood_patch.geometry.iloc[0])]
        buildings_at_risk = buildings_at_risk.to_crs('32644')
        return buildings_at_risk
    
    
    def run_evacuation(self):
        self.show()

        self.progressBar.setVisible(True)
        self.progressBar.setValue(0)
        QApplication.processEvents()
        


        building_layer = self.buildingLayerCombo.currentLayer()
        shelter_layer = self.shelterLayerCombo.currentLayer()
        flood_layer = self.floodLayerCombo.currentLayer()
        output_path = self.outputPathWidget.filePath()
    
        print("Building layer:", building_layer.name() if building_layer else None)
        print("Shelter layer:", shelter_layer.name() if shelter_layer else None)
        print("Flood layer:", flood_layer.name() if flood_layer else None)
        print("Output path:", output_path)
        
        if not all([building_layer, shelter_layer, flood_layer]):
            self.iface.messageBar().pushWarning(
                "Missing Input",
                "Please select all layers"
            )
            return
        self.statusLabel.setVisible(True)
        self.statusLabel.setText("Validating inputs…")
        QApplication.processEvents()
        use_memory = False

        if not output_path:
            use_memory = True
            
        if use_memory:
            output_dest = "memory:"
        else:
            output_dest = output_path
            
        if use_memory:
            self.iface.messageBar().pushInfo("Output","No output path provided. Results will be created as temporary layers." )
        
        if not self._check_geometry(building_layer, QgsWkbTypes.PolygonGeometry, "Building layer"):
            return
    
        if not self._check_geometry(shelter_layer, QgsWkbTypes.PointGeometry, "Shelter layer"):
            return
    
        if not self._check_geometry(flood_layer, QgsWkbTypes.PolygonGeometry, "Flood extent"):
            return
        
        target_crs = building_layer.crs()

        shelter_layer = self._reproject_if_needed(shelter_layer, target_crs)
        flood_layer = self._reproject_if_needed(flood_layer, target_crs)
    
        self.iface.messageBar().pushSuccess(
        "Inputs OK",
        "Geometry and CRS validated successfully"
        )
        
        buildings_gdf = self.qgis_layer_to_gdf(building_layer)
        flood_gdf = self.qgis_layer_to_gdf(flood_layer)
        shelters_gdf = self.qgis_layer_to_gdf(shelter_layer)
        
        shelters_gdf = shelters_gdf.to_crs('EPSG:32644')
        targeted_shelters = shelters_gdf[~shelters_gdf.geometry.intersects(flood_gdf.geometry.iloc[0])]
        targeted_shelters = targeted_shelters.to_crs('32644')
        shelters_gdf = targeted_shelters[~targeted_shelters.geometry.isna()]
        shelters_gdf['id'] = shelters_gdf.index+1

        
        self.statusLabel.setText("Extracting flooded buildings…")
        QApplication.processEvents()

        buildings_gdf = buildings_gdf.to_crs('32644')
        flood_gdf = flood_gdf.to_crs('32644')
        buildings_at_risk = buildings_gdf[buildings_gdf.geometry.intersects(flood_gdf.geometry.iloc[0])]
        flooded_bldgs = buildings_at_risk.to_crs('32644')
        
        print("Buildings in flood zone:", len(flooded_bldgs))
        self.statusLabel.setText("Building road network…")
        QApplication.processEvents()

        extent = building_layer.extent()
        center_x = (extent.xMinimum() + extent.xMaximum()) / 2
        center_y = (extent.yMinimum() + extent.yMaximum()) / 2
        
        width = extent.xMaximum() - extent.xMinimum()
        height = extent.yMaximum() - extent.yMinimum()
        radius = int(max(width, height) / 2 + 1000)  # buffer
        
        ox.settings.log_console = False
        ox.settings.use_cache = True

        
        graph = ox.graph_from_point(
            (center_y, center_x),
            dist=radius,
            network_type="walk",
            simplify=True
        )
         
        graph_proj = ox.project_graph(graph)
        edges = ox.graph_to_gdfs(graph_proj, nodes=False, edges=True)
        nodes = ox.graph_to_gdfs(graph_proj, nodes=True, edges=False)
        
        def shelters_meta(targeted_shelters, graph_proj):
            evac_nodes_list = []
        
            for idx, shelter in targeted_shelters.iterrows():
        
                # print("Shelter ID:", shelter['id'])
        
                centroid = shelter.geometry.centroid
                single_shelter_xy = (centroid.y, centroid.x)
        
                single_shelter_node = ox.distance.nearest_nodes(
                    graph_proj,
                    X=single_shelter_xy[1],
                    Y=single_shelter_xy[0]
                )
        
                single_shelter_df = pd.DataFrame({
                    'id': [shelter['id']],
                    'node': [single_shelter_node]
                })
        
                evac_nodes_list.append(single_shelter_df)
        
            targeted_shelters = pd.concat(evac_nodes_list, ignore_index=True)
            return targeted_shelters
        
        def get_elevation(x, y, raster):
            row, col = raster.index(x, y)
            elevation = raster.read(1)[row, col]
            return elevation
        
        def tobler_function(Evac_route_geom,terrain):
            line = Evac_route_geom.geometry.iloc[0]
            
            coords = list(line.coords)
            elevations = [get_elevation(x, y, terrain) for x, y in coords]
            durations_sec = []
            
            for i in range(len(coords) - 1):
                x1, y1 = coords[i]
                x2, y2 = coords[i + 1]
                
                elev1 = elevations[i]
                elev2 = elevations[i + 1]
            
                horizontal_dist = ((x2 - x1)**2 + (y2 - y1)**2)**0.5  # in meters
                rise = elev2 - elev1
                slope = rise / horizontal_dist if horizontal_dist != 0 else 0
                #print(slope)
                # Tobler's hiking function (speed in km/h)
                speed_kmh = 6 * np.exp(-3.5 * (slope + 0.05))
                
                # Convert speed to m/s
                speed_mps = speed_kmh * 1000 / 3600
                
                # Time = distance / speed
                duration = horizontal_dist / speed_mps if speed_mps != 0 else 0
            
                # Store results
                # distances.append(horizontal_dist)
                # slopes.append(slope)
                # speeds_kmh.append(speed_kmh)
                durations_sec.append(duration)
                
             
            return round(sum(durations_sec) / 60,2)
        
        def short_path(evac_shelters,source):
            all_buildings_shortest_time_list = []
            for evac in range(len(evac_shelters)):
                Evac_route = nx.shortest_path(graph_proj, source = single_buildings_node, target=evac_shelters.iloc[evac].node, weight='length')
                Evac_route_nodes = nodes.loc[Evac_route]
                
                
                
                coords = [(point.x, point.y) for point in Evac_route_nodes.geometry]

                if len(coords) > 1:
                    Evac_route_line = LineString(coords)
                    Evac_route_geom = gpd.GeoDataFrame(crs=edges.crs, geometry=[Evac_route_line])
                    Evac_route_geom['id_assigned'] = evac_shelters.iloc[evac].id
                    
                                     
                    if dem_path:
                        Evac_route_geom['Time'] = tobler_function(Evac_route_geom,terrain)
                    else:
                        Evac_route_geom['Time'] = round(((Evac_route_geom.length/ 1000) / 5.472) * 60,2)
                    Evac_route_geom['X'] = single_buildings_xy[1]
                    Evac_route_geom['Y'] = single_buildings_xy[0]
                    
                    all_buildings_shortest_time_list.append(Evac_route_geom)
                    #print(Evac_route_geom)
            
            min_len_route = pd.concat(all_buildings_shortest_time_list)
            min_len_route = min_len_route.sort_values(by=['Time'])
            min_len_route = min_len_route.reset_index().drop(columns=['index'])
            min_len_route = min_len_route.iloc[[0]]
            
            return min_len_route
            
                    
                    
            
        ##########################################################
        shelter_nodes_df = shelters_meta(shelters_gdf , graph_proj)
        self.statusLabel.setText("Computing evacuation routes…")
        QApplication.processEvents()

        shortest_evacuation_routes = []
        building_cluster = []
        total = len(flooded_bldgs)
        for time,building in enumerate(range(len(flooded_bldgs))):
            
            single_buildings_xy = (flooded_bldgs.iloc[building].geometry.centroid.y, flooded_bldgs.iloc[building].geometry.centroid.x)
            single_buildings_node = ox.distance.nearest_nodes(graph_proj,X= single_buildings_xy[1],Y= single_buildings_xy[0])
            
            
            
            
            shortest_path = short_path(shelter_nodes_df, single_buildings_node)
            shortest_path['X'] = single_buildings_xy[1]
            shortest_path['Y'] = single_buildings_xy[0]
            
            
            shortest_evacuation_routes.append(shortest_path)
            
            shortest_paths = shortest_path.drop(columns=['geometry'])

            shortest_paths['geometry'] = flooded_bldgs.iloc[building].geometry

            building_cluster.append(shortest_paths)
            progress = 60 + int((time + 1) / total * 30)
            self.progressBar.setValue(progress)
            QApplication.processEvents()
             
                    
                
        buildings_with_clusters = pd.concat(building_cluster,ignore_index=True)    
        all_evacuation_routes = pd.concat(shortest_evacuation_routes,ignore_index=True)   
        
        buildings_with_clusters = gpd.GeoDataFrame(buildings_with_clusters,geometry = 'geometry', crs = 'EPSG:32644')
        print("Buildings in buildings_with_clusters zone:", len(buildings_with_clusters))
        all_evacuation_routes = gpd.GeoDataFrame(all_evacuation_routes,geometry = all_evacuation_routes.geometry, crs = 'EPSG:32644')
        all_evacuation_routes =all_evacuation_routes.dissolve(by="id_assigned")
        all_evacuation_routes = all_evacuation_routes.reset_index()
        #buildings_with_clusters['Time'] = buildings_with_clusters['Time'].astype(float)
        #all_evacuation_routes['id_assigned'] = all_evacuation_routes['id_assigned'].astype(int)
        
        self.statusLabel.setText("Finalizing outputs…")
        QApplication.processEvents()

        self.gdf_to_memory_layer(
            buildings_with_clusters,
            "buildings_with_clusters"
        )
        
        self.gdf_to_memory_layer(
            all_evacuation_routes,
            "Evacuation_Routes"
        )
        self.statusLabel.setText("Evacuation analysis completed successfully")
        self.progressBar.setValue(100)
        QApplication.processEvents()

        self.iface.messageBar().pushSuccess(
            "Completed",
            "Evacuation routes generated successfully"
        )
        
        

    
    def reset_ui(self):
        for combo in (
            self.buildingLayerCombo,
            self.shelterLayerCombo,
            self.floodLayerCombo
        ):
            if isinstance(combo, QgsMapLayerComboBox):
                combo.setCurrentIndex(-1)
                combo.setAllowEmptyLayer(True)
            else:
                combo.setCurrentIndex(-1)
    
        self.progressBar.setValue(0)

        self.progressBar.setVisible(False)
        self.statusLabel.setText("Ready")
        self.statusLabel.setVisible(False)
        #self.buildingLayerCombo.setAllowEmptyLayer(True)
        #self.shelterLayerCombo.setAllowEmptyLayer(True)
        #self.floodLayerCombo.setAllowEmptyLayer(True)
    
        self.outputPathWidget.setFilePath("") 

            
    def _check_geometry(self, layer, expected_geom, layer_name):
        if layer is None:
            return False
    
        geom_type = QgsWkbTypes.geometryType(layer.wkbType())
    
        if geom_type != expected_geom:
            self.iface.messageBar().pushCritical(
                "Geometry Error",
                f"{layer_name} has wrong geometry type"
            )
            return False

        return True
    
    def _reproject_if_needed(self, source_layer, target_crs):
        if source_layer.crs() == target_crs:
            return source_layer
    
        params = {
            'INPUT': source_layer,
            'TARGET_CRS': target_crs,
            'OUTPUT': 'memory:'
        }
    
        result = processing.run("native:reprojectlayer", params)
        return result['OUTPUT']
    
    
    def qgis_layer_to_gdf(self, layer):
        features = []
        for feat in layer.getFeatures():
            geom = shape(json.loads(feat.geometry().asJson()))
            attrs = feat.attributes()
            features.append([geom] + attrs)
    
        columns = ['geometry'] + [f.name() for f in layer.fields()]
        gdf = gpd.GeoDataFrame(features, columns=columns)
        gdf.set_crs(layer.crs().authid(), inplace=True)
    
        return gdf
        
    def gdf_to_memory_layer(self, gdf, layer_name):

        # Detect geometry type
        geom_type = gdf.geometry.iloc[0].geom_type
    
        qgis_geom_map = {
            "Point": "Point",
            "MultiPoint": "MultiPoint",
            "LineString": "LineString",
            "MultiLineString": "MultiLineString",
            "Polygon": "Polygon",
            "MultiPolygon": "MultiPolygon"
        }
    
        if geom_type not in qgis_geom_map:
            raise ValueError(f"Unsupported geometry type: {geom_type}")
    
        qgis_geom = qgis_geom_map[geom_type]
    
        vl = QgsVectorLayer(
            f"{qgis_geom}?crs={gdf.crs.to_string()}",
            layer_name,
            "memory"
        )
    
        pr = vl.dataProvider()
    
        # ---- Add fields with correct types ----
        fields = []
        for col in gdf.columns:
            if col == "geometry":
                continue
    
            dtype = gdf[col].dtype
    
            if pd.api.types.is_integer_dtype(dtype):
                qtype = QVariant.Int
            elif pd.api.types.is_float_dtype(dtype):
                qtype = QVariant.Double
            elif pd.api.types.is_bool_dtype(dtype):
                qtype = QVariant.Bool
            else:
                qtype = QVariant.String
    
            fields.append(QgsField(col, qtype))
    
        pr.addAttributes(fields)
        vl.updateFields()
    
        # ---- Add features ----
        features = []
        for _, row in gdf.iterrows():
            feat = QgsFeature()
            feat.setGeometry(QgsGeometry.fromWkt(row.geometry.wkt))
    
            attrs = []
            for col in gdf.columns:
                if col == "geometry":
                    continue
    
                val = row[col]
                attrs.append(None if pd.isna(val) else val)
    
            feat.setAttributes(attrs)
            features.append(feat)
    
        pr.addFeatures(features)
        vl.updateExtents()
    
        QgsProject.instance().addMapLayer(vl)
    
        return vl









