# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Buienradar
                                 A QGIS plugin
 Een simpele plugin die data van de buienradar api haalt
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-04-13
        git sha              : $Format:%H$
        copyright            : (C) 2019 by Peter Schols en Jeroen van der Zwam
        email                : peter@peterschols.com, jeroenvanderzwam@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from PyQt5.QtCore import QSettings, QTranslator, qVersion, QCoreApplication, QVariant
from PyQt5.QtGui import QIcon
from PyQt5.QtWidgets import QAction

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .buienradar_plugin_dialog import BuienradarDialog
import os.path

from qgis.core import *
import qgis.utils

import xml.etree.ElementTree as ET
import csv
import urllib.request

def resolve(name, basepath=None):
    if not basepath:
      basepath = os.path.dirname(os.path.realpath(__file__))
    return os.path.join(basepath, name)

class GetBuienradarData:
    '''Class om de buienradar te activeren'''

    def krijgData(self):
        '''Methode voor het omzetten van xml naar csv'''

        tree = ET.parse(urllib.request.urlopen('https://data.buienradar.nl/1.0/feed/xml'))
        root = tree.getroot()

        # Aanmaken CSV writer
        buienradardata = open(resolve('buienradardata.csv'), 'w', newline='')
        csvwriter = csv.writer(buienradardata)

        # Loop voor alle weerstations
        for station in root.iter('weerstation'):
            header = []
            for child in root.iter('weerstation'):
                for x in child:
                    header.append(x.tag)
                break

            header.insert(0, '@id')
            header.insert(-4, 'zin')
        csvwriter.writerow(header)
            
        for child in root.iter('weerstation'):
            attributen = []
            for attr in header:
                if attr == '@id':
                    var = child.attrib['id']
                elif attr == 'icoonactueel':
                    var = child.find('icoonactueel').attrib['ID']
                elif attr == 'zin':
                    var = child.find('icoonactueel').attrib['zin']
                else:
                    var = child.find(attr).text
                attributen.append(var)   
            csvwriter.writerow(attributen)
        
        # Sluiten CSV bestand
        buienradardata.close()

class Buienradar:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'Buienradar_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Buienradar Plugin')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None
        
        

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('Buienradar', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToWebMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/buienradar_plugin/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Buienradar Plugin'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginWebMenu(
                self.tr(u'&Buienradar Plugin'),
                action)
            self.iface.removeToolBarIcon(action)

    def load_buienradar(self):
        '''Methode voor het laden en stijlen van de buienradar data'''
        # Verkrijgen van data
        buienRadar = GetBuienradarData()
        buienRadar.krijgData()

        # Definiëren en aanmaken van laag
        self.uri = "file:///" + resolve('buienradardata.csv') + "?encoding=%s&delimiter=%s&xField=%s&yField=%s&crs=%s" % ("UTF-8",",", "lon", "lat","epsg:4326")
        self.lyr = QgsVectorLayer(self.uri, 'Buienradar', 'delimitedtext')

        # Aanmaken van data providers
        prov_lyr = self.lyr.dataProvider()

        # Categorieën aanmaken voor de renderer
        stijlveld = prov_lyr.fieldNameIndex('icoonactueel')
        zinveld = prov_lyr.fieldNameIndex('zin')
        
        # Dictionary maken met letter als key en zin als value
        legenda = {}
        it = self.lyr.getFeatures()
        for feat in it:
            att = feat.attributes()
            legenda.setdefault(att[stijlveld],att[zinveld])
        
        # Genereren van de vershillende categorieën op basis van de unieke waardes
        unieke_waardes = prov_lyr.uniqueValues(stijlveld)
        categorieen = []

        for uniek in unieke_waardes:
            symbool = QgsSymbol.defaultSymbol(self.lyr.geometryType())
            svgStyle = {}
            svgStyle['name'] = resolve(r'svg/{}.svg'.format(uniek))
            svgStyle['size'] = '6'
            symboollaag = QgsSvgMarkerSymbolLayer.create(svgStyle)
            if symboollaag is not None:
                symbool.changeSymbolLayer(0, symboollaag)

            categorie = QgsRendererCategory(uniek, symbool, legenda[uniek]) # De dictionary zorgt dat iedere letter de juiste tekst krijgt
            categorieen.append(categorie)

        # Aanmaken van renderer
        stijl = QgsCategorizedSymbolRenderer('icoonactueel', categorieen)
        self.lyr.setRenderer(stijl)

        # Extent updaten en kaarlaag laden
        self.lyr.updateExtents()

        # Laag toevoegen aan project
        QgsProject.instance().addMapLayer(self.lyr)

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = BuienradarDialog()

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        
        # See if OK was pressed
        if result:
            
            if self.dlg.brtBtn.isChecked():
                uritopo = 'tileMatrixSet=EPSG:28992&crs=EPSG:28992&layers=standaard&styles=default&format=image/png&url=https://service.pdok.nl/brt/achtergrondkaart/wmts/v2_0?request%3DGetCapabilities%26service%3DWMTS'

                topolayer = QgsRasterLayer(uritopo, 'BRT achtergrondkaart', 'wms')
                if topolayer.isValid():
                    QgsProject.instance().addMapLayer(topolayer)
                    
            if self.dlg.osmBtn.isChecked():
                uriluchtfoto = 'tileMatrixSet=EPSG:28992&crs=EPSG:28992&layers=Actueel_ortho25&styles=default&format=image/jpeg&url=https://service.pdok.nl/hwh/luchtfotorgb/wmts/v1_0'

                luchtfotolayer = QgsRasterLayer(uriluchtfoto, 'Luchtfoto actueel', 'wms')
                if luchtfotolayer.isValid():
                    QgsProject.instance().addMapLayer(luchtfotolayer)
                    
            self.load_buienradar()
