# -*- coding: utf-8 -*-

"""
/***************************************************************************
 BufferWithoutOverlaps
                                 A QGIS plugin
 This plugin creates a buffer around features of given type, without overlaps and with flat end caps.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-03-20
        copyright            : (C) 2022 by António Sobral Almeida
        email                : sobral.almeida@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'António Sobral Almeida'
__date__ = '2022-03-20'
__copyright__ = '(C) 2022 by António Sobral Almeida'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import (QgsFeatureSink,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterFeatureSink)
from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterNumber
from qgis.core import QgsProcessingParameterField
from qgis.core import QgsProcessingParameterVectorLayer
from qgis.core import QgsFeatureRequest
from qgis.core import QgsProject
from qgis.core import QgsVectorFileWriter
from qgis.core import QgsCoordinateTransformContext
from qgis.core import QgsVectorLayer
from qgis.core import QgsApplication
from qgis.PyQt.QtCore import QVariant
from qgis.core.additions.edit import edit
import processing
import time
from datetime import datetime
import os


class BufferWithoutOverlapsAlgorithm(QgsProcessingAlgorithm):

    def initAlgorithm(self, config=None):
        # Create a time stamp
        tme=time.localtime()
        timeString=datetime.now().strftime('%d-%m-%Y-%H-%M-%S_')
        # Find processing output directory
        u_dir = QgsApplication.qgisSettingsDirPath()
        p_dir = os.path.join(u_dir,'processing/outputs')
        t_dir = p_dir+'/'+timeString
        self.t_dir = t_dir        
        self.addParameter(QgsProcessingParameterVectorLayer('inputvectorlayer', 'Input vector layer', types=[QgsProcessing.TypeVectorPoint,QgsProcessing.TypeVectorLine,QgsProcessing.TypeVectorPolygon], defaultValue=None))        
        self.addParameter(QgsProcessingParameterField('inputvectorfield', 'Input vector field', type=QgsProcessingParameterField.Any, parentLayerParameterName='inputvectorlayer', allowMultiple=False, defaultValue=None))
        self.addParameter(QgsProcessingParameterNumber('bufferingdustance', 'Buffering dustance', type=QgsProcessingParameterNumber.Double, minValue=0, defaultValue=None))

    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        feedback = QgsProcessingMultiStepFeedback(5, model_feedback)
        results = {}
        outputs = {}

        # Fix geometries
        alg_params = {
            'INPUT': parameters['inputvectorlayer'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        results = processing.run('native:fixgeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return {}

        # Get input vector layer type
        EndCapStyle = []
        lyr_str = results['OUTPUT']
        lyr =  context.takeResultLayer(lyr_str)
        if lyr.wkbType() == 1:
            EndCapStyle.append(0)
        else:
            EndCapStyle.append(1)

        # Fix geometries2
        alg_params = {
            'INPUT': parameters['inputvectorlayer'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FixGeometries2'] = processing.run('native:fixgeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return {}

        # Buffer
        alg_params = {
            'DISSOLVE': False,
            'DISTANCE': parameters['bufferingdustance'],
            'END_CAP_STYLE': EndCapStyle[0],  # 0=Round, 1=Flat
            'INPUT': outputs['FixGeometries2']['OUTPUT'],
            'JOIN_STYLE': 0,  # Round
            'MITER_LIMIT': 2,
            'SEGMENTS': 5,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Buffer'] = processing.run('native:buffer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(2)
        if feedback.isCanceled():
            return {}

        # Polygon Self-Intersection
        alg_params = {
            'ID': parameters['inputvectorfield'],
            'POLYGONS': outputs['Buffer']['OUTPUT'],
            'INTERSECT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['PolygonSelfintersection'] = processing.run('saga:polygonselfintersection', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(3)
        if feedback.isCanceled():
            return {}

        # Field calculator
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'Area',
            'FIELD_PRECISION': 7,
            'FIELD_TYPE': 0,  # Float
            'FORMULA': '$area',
            'INPUT': outputs['PolygonSelfintersection']['INTERSECT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FieldCalculator'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(4)
        if feedback.isCanceled():
            return {}

        # Remove null geometries
        alg_params = {
            'INPUT': outputs['FieldCalculator']['OUTPUT'],
            'REMOVE_EMPTY': True,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT 
        }
        res = processing.run('native:removenullgeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(5)
        if feedback.isCanceled():
            return {}

        # Remove features with area <= 0
        lyr_out_str = res['OUTPUT']
        layer =  context.takeResultLayer(lyr_out_str)

        with edit(layer):
            request = QgsFeatureRequest().setFilterExpression('Area <= 0.0000001')
            request.setSubsetOfAttributes([])
            request.setFlags(QgsFeatureRequest.NoGeometry)
            for f in layer.getFeatures(request):
                layer.deleteFeature(f.id())

        options = QgsVectorFileWriter.SaveVectorOptions()
        options.driverName = "ESRI Shapefile"
        QgsVectorFileWriter.writeAsVectorFormatV2(layer, self.t_dir+'_Buffer.shp', QgsCoordinateTransformContext(), options)
        vlayer = QgsVectorLayer(self.t_dir+'_Buffer.shp', "Buffer.shp", "ogr")
        QgsProject.instance().addMapLayer(vlayer)

        return results

    def name(self):
        return 'Buffer without overlaps'

    def displayName(self):
        return 'Buffer without overlaps Vers. 0.1'

    def group(self):
        return None

    def groupId(self):
        return None

    def createInstance(self):
        return BufferWithoutOverlapsAlgorithm()
