# -*- coding: utf-8 -*-
"""
/***************************************************************************
 brdrQSettings
                                 A QGIS plugin
 aligns thematic polygons to reference polygons
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2024-10-08
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Karel Dieussaert
        email                : karel.dieussaert@geosolutions.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

import numpy as np
from brdr.enums import OpenDomainStrategy, SnapStrategy, FullReferenceStrategy
from qgis.PyQt import QtWidgets, uic
from qgis.PyQt.QtCore import pyqtSignal

from .brdrq_utils import (
    ENUM_REFERENCE_OPTIONS,
    ENUM_OD_STRATEGY_OPTIONS,
    ENUM_FULL_REFERENCE_STRATEGY_OPTIONS,
    ENUM_SNAP_STRATEGY_OPTIONS,
    Processor,
    ENUM_PROCESSOR_OPTIONS,
    read_setting,
    write_setting,
)

FORM_CLASS, _ = uic.loadUiType(
    os.path.join(os.path.dirname(__file__), "brdrq_settings.ui")
)


class brdrQSettings(QtWidgets.QDialog, FORM_CLASS):
    closingPlugin = pyqtSignal()
    confirmed = pyqtSignal()

    def __init__(self, parent=None):
        """Constructor."""
        super(brdrQSettings, self).__init__(parent)
        # Set up the user interface from Designer.
        # After setupUI you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://doc.qt.io/qt-5/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        self.prefix = "brdrqfeaturealigner"
        self.minimum = 0
        self.maximum = 2500
        self.small_step = 10
        self.mid_step = 20
        self.big_step = 50
        self.step = self.small_step
        self.relevant_distances = None
        self.threshold_overlap_percentage = None
        self.od_strategy = None
        self.reference_choice = None
        self.reference_id = None
        self.reference_layer = None
        self.max_rel_dist = None
        self.metadata = None
        self.full_strategy = None
        self.processor = None
        self.partial_snapping = None
        self.partial_snapping_strategy = None
        self.snap_max_segment_length = None
        self.DECIMAL = 1
        self.load_settings()

    def closeEvent(self, event):
        self.closingPlugin.emit()
        event.accept()

    def load_settings(self):
        print("load settings")
        for r in ENUM_REFERENCE_OPTIONS:
            self.comboBox_referencelayer.addItem(r)
        for od in ENUM_OD_STRATEGY_OPTIONS:
            self.comboBox_odstrategy.addItem(od)
        for s in ENUM_SNAP_STRATEGY_OPTIONS:
            self.comboBox_snapstrategy.addItem(s)
        for f in ENUM_FULL_REFERENCE_STRATEGY_OPTIONS:
            self.comboBox_fullstrategy.addItem(f)
        for p in ENUM_PROCESSOR_OPTIONS:
            self.comboBox_processor.addItem(p)
        self.comboBox_referencelayer.currentIndexChanged.connect(
            self.update_reference_choice
        )
        self.mMapLayerComboBox_reference.layerChanged.connect(
            self.updateFields_reference
        )
        self.buttonBox_settings.accepted.connect(self.push_settings_ok)

        # Load initial settings into tool (same as pushing OK in settings Dialog)
        self.update_settings()
        return

    def update_reference_choice(self, index):
        if index == 0:
            self.mMapLayerComboBox_reference.setEnabled(True)
            self.mFieldComboBox_reference.setEnabled(True)
        else:
            self.mMapLayerComboBox_reference.setEnabled(False)
            self.mFieldComboBox_reference.setEnabled(False)
        return

    def updateFields_reference(self):
        layer = self.mMapLayerComboBox_reference.currentLayer()
        self.mFieldComboBox_reference.setLayer(layer)

    def push_settings_ok(self):
        print("push settings ok")
        self.update_settings()
        self.confirmed.emit()

    def update_settings(self):
        # s = QgsSettings()
        if self.threshold_overlap_percentage is None:
            self.threshold_overlap_percentage = int(read_setting(self.prefix, "threshold_overlap_percentage", 50))
            self.spinBox_threshold.setValue(self.threshold_overlap_percentage)
        self.threshold_overlap_percentage = self.spinBox_threshold.value()

        if self.max_rel_dist is None:
            self.max_rel_dist = int(read_setting(self.prefix, "max_rel_dist", 5))
            self.spinBox_max_relevant_distance.setValue(self.max_rel_dist)
        self.max_rel_dist = self.spinBox_max_relevant_distance.value()
        self.maximum = self.max_rel_dist * 100

        self.relevant_distances = [
            round(k, self.DECIMAL)
            for k in np.arange(
                self.minimum, self.maximum + self.step, self.step, dtype=int
            )
            / 100
        ]
        if self.od_strategy is None or self.od_strategy not in OpenDomainStrategy:
            default_od = OpenDomainStrategy.SNAP_ALL_SIDE
            od_strategy_name = read_setting(self.prefix, "od_strategy", default_od.name)
            if od_strategy_name not in OpenDomainStrategy.__members__:
                od_strategy_name = default_od.name
            index = self.comboBox_odstrategy.findText(
                OpenDomainStrategy[od_strategy_name].name
            )
            if index == -1:
                index = 0
            self.comboBox_odstrategy.setCurrentIndex(index)
        self.od_strategy = OpenDomainStrategy[self.comboBox_odstrategy.currentText()]

        if (
            self.partial_snapping_strategy is None
            or self.partial_snapping_strategy not in SnapStrategy
        ):
            default_partial_snapping_strategy = SnapStrategy.PREFER_VERTICES
            partial_snapping_strategy_name = read_setting(self.prefix, "partial_snapping_strategy", default_partial_snapping_strategy.name)
            if partial_snapping_strategy_name not in SnapStrategy.__members__:
                partial_snapping_strategy_name = default_partial_snapping_strategy.name
            index = self.comboBox_snapstrategy.findText(
                SnapStrategy[partial_snapping_strategy_name].name
            )
            if index == -1:
                index = 0
            self.comboBox_snapstrategy.setCurrentIndex(index)
        self.partial_snapping_strategy = SnapStrategy[
            self.comboBox_snapstrategy.currentText()
        ]
        if self.processor is None or self.processor not in Processor:
            default_processor = Processor.AlignerGeometryProcessor
            ##!! we set the default processor always to the AlignerGeometryProcessor
            processor_name = default_processor.name
            # processor_name = s.value(
            #     "brdrq/processor", default_processor.name
            # )

            if processor_name not in Processor.__members__:
                processor_name = default_processor.name
            index = self.comboBox_processor.findText(
                Processor[processor_name].name
            )
            if index == -1:
                index = 0
            self.comboBox_processor.setCurrentIndex(index)
        self.processor = Processor[self.comboBox_processor.currentText()]

        if self.full_strategy is None or self.full_strategy not in FullReferenceStrategy:
            default_full_strategy = FullReferenceStrategy.PREFER_FULL_REFERENCE
            full_strategy_name = read_setting(
                self.prefix,
                "full_strategy",
                default_full_strategy.name,
            )
            if full_strategy_name not in FullReferenceStrategy.__members__:
                full_strategy_name = default_full_strategy.name
            index = self.comboBox_fullstrategy.findText(
                FullReferenceStrategy[full_strategy_name].name
            )
            if index == -1:
                index = 0
            self.comboBox_fullstrategy.setCurrentIndex(index)
        self.full_strategy = FullReferenceStrategy[self.comboBox_fullstrategy.currentText()]

        if (
            self.reference_choice is None
            or self.reference_choice not in ENUM_REFERENCE_OPTIONS
        ):
            default_reference_choice = ENUM_REFERENCE_OPTIONS[1]  # ADP
            self.reference_choice = read_setting(
                self.prefix,
                "reference_choice",
                default_reference_choice,
            )
            if self.reference_choice not in ENUM_REFERENCE_OPTIONS:
                self.reference_choice = default_reference_choice
            index = self.comboBox_referencelayer.findText(self.reference_choice)
            self.comboBox_referencelayer.setCurrentIndex(index)
        self.reference_choice = self.comboBox_referencelayer.currentText()
        current_reference_layer_index = self.mMapLayerComboBox_reference.currentIndex()
        if (
            current_reference_layer_index == -1 or current_reference_layer_index == 0):  # :
            try:
                self.reference_layer = read_setting(
                    self.prefix,
                    "reference_layer",
                    None,
                )
                self.mMapLayerComboBox_reference.setLayer(self.reference_layer)
                self.reference_id = read_setting(
                    self.prefix,
                    "reference_id",
                    0,
                )
                self.mFieldComboBox_reference.setField(self.reference_id)
            except:
                self.mMapLayerComboBox_reference.setLayer(None)
                self.mFieldComboBox_reference.setField(None)
        self.reference_layer = self.mMapLayerComboBox_reference.currentLayer()
        self.reference_id = self.mFieldComboBox_reference.currentField()

        if self.metadata is None:
            self.metadata = int(read_setting(
                self.prefix,
                "metadata",
                0,
            ))
            self.checkBox_metadata.setCheckState(self.metadata)
        self.metadata = self.checkBox_metadata.checkState()

        # if self.partial_snapping is None:
        #     self.partial_snapping = int(s.value("brdrq/partial_snapping", 0))
        #     self.checkBox_partial_snapping.setCheckState(
        #         self.partial_snapping
        #     )
        # self.partial_snapping = (
        #     self.checkBox_partial_snapping.checkState()
        # )
        self.partial_snapping = False  # at this moment always set to false as this is not performant and not implemented in brdrQ

        if self.snap_max_segment_length is None:
            self.snap_max_segment_length = int(read_setting(
                self.prefix,
                "snap_max_segment_length",
                2,
            ))
            self.spinBox_snap_max_segment_length.setValue(self.snap_max_segment_length)
        self.snap_max_segment_length = self.spinBox_snap_max_segment_length.value()

        print(
            f"settings updated: Reference choice={self.reference_choice} - od_strategy={self.od_strategy} - threshold overlap percenatge = {str(self.threshold_overlap_percentage)}"
        )
        # write settings
        write_setting(self.prefix,"threshold_overlap_percentage", self.threshold_overlap_percentage)
        write_setting(self.prefix, "od_strategy", self.od_strategy.name)
        write_setting(self.prefix, "reference_choice", self.reference_choice)
        write_setting(self.prefix, "reference_id", self.reference_id)
        write_setting(self.prefix, "reference_layer", self.reference_layer)
        write_setting(self.prefix, "max_rel_dist", self.max_rel_dist)
        write_setting(self.prefix, "metadata", self.metadata)
        write_setting(self.prefix, "full_strategy", self.full_strategy.name)
        write_setting(self.prefix, "processor", self.processor.name)
        write_setting(self.prefix, "partial_snapping", self.partial_snapping)
        write_setting(
            self.prefix,
            "partial_snapping_strategy",
            self.partial_snapping_strategy.name,
        )
        write_setting(
            self.prefix, "snap_max_segment_length", self.snap_max_segment_length
        )
        return


def __init__():
    pass
