# -*- coding: utf-8 -*-

"""
/***************************************************************************
 BrdrQ
                                 A QGIS plugin
 brdrQ, a QGIS-plugin for aligning thematic borders to reference borders.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-10-11
        copyright            : (C) 2024 by Karel Dieussaert / Onroerend Erfgoed
        email                : karel.dieussaert@vlaanderen.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = "Karel Dieussaert / Onroerend Erfgoed"
__date__ = "2024-10-11"
__copyright__ = "(C) 2024 by Karel Dieussaert / Onroerend Erfgoed"

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = "$Format:%H$"

import inspect
import os
import sys

import brdr
# TODO QGIS4
from PyQt5.QtGui import QIcon
from PyQt5.QtWidgets import QAction, QMenu
from qgis import processing
from qgis.PyQt.QtCore import QCoreApplication, QLocale, QTranslator, QSettings
from qgis.core import Qgis
from qgis.core import QgsApplication

from .brdrq_dockwidget_bulkaligner import brdrQDockWidgetBulkAligner
from .brdrq_dockwidget_featurealigner import brdrQDockWidgetFeatureAligner
from .brdrq_provider import BrdrQProvider
from .brdrq_version_dialog import VersionInfoDialog

# #example when upgrading plugin for QGIS4 - compatibility
# try:
#     from PyQt6.QtWidgets import QAction, QMenu
#     from PyQt6.QtGui import QIcon
# except ImportError:
#     from PyQt5.QtWidgets import QAction, QMenu
#     from PyQt5.QtGui import QIcon

cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)

pluginname = "brdrQ"


class BrdrQPlugin(object):

    def __init__(self, iface):
        print(f"init plugin {pluginname} with brdr-version {brdr.__version__}")
        qgis_version = Qgis.QGIS_VERSION_INT
        if Qgis.QGIS_VERSION_INT >= 40000:
            print(f"Plugin has to be verified for qgis-version {str(qgis_version)}")
        else:
            print(f"Plugin compatible with qgis-version {str(qgis_version)}")
        self.translator = None
        self.provider = None
        self.iface = iface
        self.dockwidget_featurealigner = None
        self.dockwidget_bulkaligner = None
        self.actions = []
        self.toolbar = self.iface.addToolBar(pluginname)
        self.toolbar.setObjectName(pluginname)
        self.brdrq_menu = QMenu(pluginname)
        self.vector_menu = self.iface.vectorMenu()
        self.metadata = self.get_metadata()

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        print(f"translation of message {message}")
        print(QCoreApplication.translate(pluginname, message))
        print(QCoreApplication.translate("BrdrQPlugin", message))
        return QCoreApplication.translate(self.__class__.__name__, message)

    def initProcessing(self):
        """Init Processing provider for QGIS >= 3.8."""

        self.provider = BrdrQProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def initGui(self):
        self.init_locale()
        self.initProcessing()

        # Setup menu
        icon_menu = QIcon(os.path.join(os.path.join(cmd_folder, "icon_base.svg")))
        self.brdrq_menu.setIcon(icon_menu)
        self.vector_menu.addMenu(self.brdrq_menu)

        # FEATUREALIGNER
        icon = os.path.join(os.path.join(cmd_folder, "icon_featurealigner.svg"))
        action_featurepredictor = QAction(
            QIcon(icon), "Feature Aligner (individual predictions)", self.iface.mainWindow()
        )
        action_featurepredictor.setObjectName("brdrq_featurealigner")
        action_featurepredictor.triggered.connect(self.openDockFeatureAligner)
        #

        self.brdrq_menu.addAction(action_featurepredictor)

        self.toolbar.addAction(action_featurepredictor)
        self.actions.append(action_featurepredictor)

        # AUTOCORRECTBORDERS
        icon_autocorrectborders = os.path.join(
            os.path.join(cmd_folder, "icon_autocorrectborders.svg")
        )
        action_autocorrectborders = QAction(
            QIcon(icon_autocorrectborders),
            "Autocorrectborders (bulk)",
            self.iface.mainWindow(),
        )
        action_autocorrectborders.setObjectName("brdrq_autocorrectborders")
        action_autocorrectborders.triggered.connect(self.openAutocorrectbordersscript)
        # self.iface.addToolBarIcon(action_autocorrectborders)
        self.brdrq_menu.addAction(action_autocorrectborders)
        self.toolbar.addAction(action_autocorrectborders)
        self.actions.append(action_autocorrectborders)

        # AUTOUPDATEBORDERS -GRBUPDATER
        icon_autoupdateborders = os.path.join(
            os.path.join(cmd_folder, "icon_grbupdater.svg")
        )
        action_autoupdateborders = QAction(
            QIcon(icon_autoupdateborders),
            "GRB Updater (bulk) - Flanders specific",
            self.iface.mainWindow(),
        )
        action_autoupdateborders.setObjectName("brdrq_autoupdateborders")
        action_autoupdateborders.triggered.connect(self.openAutoupdatebordersscript)
        self.brdrq_menu.addAction(action_autoupdateborders)
        self.toolbar.addAction(action_autoupdateborders)
        self.actions.append(action_autoupdateborders)

        # INFO - VERSION
        icon_info = os.path.join(os.path.join(cmd_folder, "icon_info.svg"))
        action_info = QAction(
            QIcon(icon_info),
            self.tr("About brdrQ"),
            self.iface.mainWindow(),
        )
        action_info.setObjectName("brdrq_info")
        action_info.triggered.connect(self.openInfo)
        self.brdrq_menu.addAction(action_info)
        self.toolbar.addAction(action_info)
        self.actions.append(action_info)

    def init_locale(self):
        settings = QSettings()
        ignore_user_locale = settings.value("locale/overrideFlag", False, type=bool)
        if ignore_user_locale:
            # flag true
            # print("QGIS uses UI-setting as locale.")
            locale_code = str(settings.value("locale/userLocale", "en"))
        else:
            # print("QGIS uses system locale.")
            locale_code = QLocale.system().name()
        if not locale_code or str(locale_code) == "NULL":
            print("fallback to system locale")
            locale_code = QLocale.system().name()
        locale_code = locale_code[:2]
        print(f"locale {locale_code}")
        locale_path = os.path.join(os.path.dirname(__file__), "i18n")
        self.translator = QTranslator()
        loaded = self.translator.load(f"{pluginname}_{locale_code}.qm", locale_path)
        if not loaded:
            locale_code = "en"
            self.translator.load(f"{pluginname}_{locale_code}.qm", locale_path)
        QCoreApplication.installTranslator(self.translator)
        print(f"translator loaded with locale {locale_code}")

    def openAutocorrectbordersscript(self):
        processing.execAlgorithmDialog("brdrqprovider:brdrqautocorrectborders")

    def openInfo(self):
        self.dialog = VersionInfoDialog("About brdrQ", self.metadata)
        self.dialog.open()

    def closeInfo(self):
        if self.dialog:
            self.dialog.close()

    def openAutoupdatebordersscript(self):
        processing.execAlgorithmDialog("brdrqprovider:brdrqautoupdateborders")

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)
        for action in self.actions:
            self.iface.removeToolBarIcon(action)
            self.toolbar.removeAction(action)
            self.iface.removePluginMenu(pluginname, action)
            del action
        # remove the toolbar
        del self.toolbar

    def openDockBulkAligner(self):
        print("openDockBulkAligner")
        print(str(self.dockwidget_bulkaligner))
        if self.dockwidget_bulkaligner is None:
            # Create the dockwidget (after translation) and keep reference
            self.dockwidget_bulkaligner = brdrQDockWidgetBulkAligner(self)
            print("brdrQDockWidgetBulkAligner created")
        print(str(self.dockwidget_bulkaligner.active))
        if not self.dockwidget_bulkaligner.active:
            self.dockwidget_bulkaligner.activate()
        return

    def openDockFeatureAligner(self):
        print("openDockFeatureAligner")
        if self.dockwidget_featurealigner is None:
            # Create the dockwidget (after translation) and keep reference
            self.dockwidget_featurealigner = brdrQDockWidgetFeatureAligner(self)
            print("brdrQDockWidgetFeatureAligner created")
        else:
            print("brdrQDockWidgetFeatureAligner reused")
        self.dockwidget_featurealigner.startDock()
        return

    def get_metadata(self):
        metadata = {}
        try:
            metadata_path = os.path.join(os.path.join(cmd_folder, "metadata.txt"))
            with open(metadata_path, "r", encoding="utf-8") as f:
                for line in f:
                    if "=" in line:
                        key, value = line.strip().split("=", 1)
                        metadata[key.strip()] = value.strip()
        except:
            metadata = {
                "version": "N/A",
                "author": "N/A",
                "email": "N/A",
            }
        return metadata
