# -*- coding: utf-8 -*-
"""
/***************************************************************************
 brdrQDockWidget
                                 A QGIS plugin
 aligns thematic polygons to reference polygons
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2024-10-08
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Karel Dieussaert
        email                : karel.dieussaert@geosolutions.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

# TODO QGIS4
from PyQt5.QtCore import QVariant
from brdr.aligner import Aligner
from brdr.be.grb.enums import GRBType
from brdr.be.grb.loader import GRBActualLoader, GRBFiscalParcelLoader
from brdr.constants import PREDICTION_SCORE, EVALUATION_FIELD_NAME
from brdr.enums import AlignerResultType
from brdr.geometry_utils import geom_from_wkt
from brdr.loader import DictLoader
from qgis import processing
from qgis.PyQt import QtWidgets, uic
from qgis.PyQt.QtCore import Qt
from qgis.PyQt.QtCore import pyqtSignal
from qgis.core import QgsFeatureRequest, edit
from qgis.core import QgsMapLayerProxyModel
from qgis.core import QgsProject
from qgis.core import QgsStyle
from qgis.utils import OverrideCursor

from .brdrq_dockwidget_aligner import brdrQDockWidgetAligner
from .brdrq_utils import (
    move_to_group,
    zoom_to_features,
    add_field_to_layer,
    geom_shapely_to_qgis,
    featurecollection_to_layer,
    remove_group_layer,
    geom_qgis_to_shapely,
    GRB_TYPES,
    ADPF_VERSIONS,
    BRDRQ_STATE_FIELDNAME,
    BrdrQState,
)

FORM_CLASS, _ = uic.loadUiType(
    os.path.join(os.path.dirname(__file__), "brdrq_dockwidget_bulkaligner.ui")
)


class brdrQDockWidgetBulkAligner(
    QtWidgets.QDockWidget, FORM_CLASS, brdrQDockWidgetAligner
):
    closingPlugin = pyqtSignal()

    def __init__(self, brdrqplugin, parent=None):
        """Constructor."""
        print(" init brdrQDockWidgetBulkAligner")
        brdrQDockWidgetAligner.__init__(self, brdrqplugin)
        super(brdrQDockWidgetBulkAligner, self).__init__(parent)
        self.setupUi(self)

        self.workinglayer = None
        self.workinggroupname = None
        self.featureItemList = None

    def clearUserInterface(self):
        # Clear progressbar
        self.progressBar.setValue(0)
        self.doubleSpinBox.setValue(0)
        # Clear the featurelist widget
        self.listWidget_features.clear()
        # Clear the predictionlist
        self.listWidget_predictions.clear()

    def activate(self):
        self.active = True
        # connect to provide cleanup on closing of dockwidget
        self.closingPlugin.connect(self.onClosePlugin)
        self.pushButton_help.clicked.connect(self.show_help_dialog)
        self.pushButton_settings.clicked.connect(self.show_settings_dialog)
        self.pushButton_grafiek.clicked.connect(self.get_graphic)
        self.pushButton_visualisatie.clicked.connect(self.get_visualisation)
        self.pushButton_save.clicked.connect(self.change_geometry)
        self.pushButton_reset.clicked.connect(self.reset_geometry)
        self.checkBox_only_manual.stateChanged.connect(self.loadFeaturelist)
        self.pushButton_evaluate.clicked.connect(self.evaluate)
        self.mMapLayerComboBox.setFilters(QgsMapLayerProxyModel.PolygonLayer)
        self.listWidget_features.itemPressed.connect(self.onFeatureActivated)
        self.listWidget_predictions.itemPressed.connect(self.onListItemActivated)
        self.horizontalSlider.sliderMoved.connect(self.onSliderChange)
        self.doubleSpinBox.valueChanged.connect(self.onSpinboxChange)

        # # show the dockwidget
        self.iface.addDockWidget(Qt.RightDockWidgetArea, self)
        # #
        self.settingsDialog.confirmed.connect(self.startDock)
        self.startDock()

    def onClosePlugin(self):
        """Cleanup necessary items here when plugin dockwidget is closed"""
        print("** CLOSING brdrQ")
        remove_group_layer(self.workinggroupname)
        # disconnects
        print("** disconnect dockwidget")
        self.closingPlugin.disconnect(self.onClosePlugin)
        self.active = False

    def evaluate(self, task):
        print("evaluate")
        self.clearUserInterface()

        with OverrideCursor(Qt.WaitCursor):
            self.workinglayer, self.workinggroupname = self.create_workinglayer()
            self.evaluate_layer()
            self.prepareFeatureList()
            self.loadFeaturelist()
        # dlg.hide()
        return

    def create_workinglayer(self):
        remove_group_layer(self.workinggroupname)
        visible = True
        qinst = QgsProject.instance()
        root = qinst.layerTreeRoot()
        layer = self.mMapLayerComboBox.currentLayer()
        # create a new layer from all features
        if self.checkBox_only_selected.checkState():
            new_layer = layer.materialize(
                QgsFeatureRequest().setFilterFids(layer.selectedFeatureIds())
            )
        else:
            new_layer = layer.materialize(
                QgsFeatureRequest().setFilterFids(layer.allFeatureIds())
            )
        # add attribute for automatic/manual correction
        # new_layer.renderer().setSymbol(QgsStyle.defaultStyle().symbol("hashed clbue /"))
        add_field_to_layer(
            layer, BRDRQ_STATE_FIELDNAME, QVariant.String, BrdrQState.TO_UPDATE
        )

        # add a new layer to the map
        QgsProject.instance().addMapLayer(new_layer, False)

        root.insertLayer(0, new_layer)

        node = root.findLayer(new_layer.id())
        if node:
            new_state = Qt.Checked if visible else Qt.Unchecked
            node.setItemVisibilityChecked(new_state)
        groupname = str(new_layer.name()) + "_brdrQ_evaluation"
        move_to_group(new_layer, groupname)
        symbol = QgsStyle.defaultStyle().symbol("outline blue")
        renderer = new_layer.renderer()
        if symbol is not None and renderer is not None:
            renderer.setSymbol(symbol)
        new_layer.triggerRepaint()
        self.iface.layerTreeView().refreshLayerSymbology(new_layer.id())
        return new_layer, groupname

    def evaluate_layer(self):
        self.progressBar.setValue(5)
        self.aligner = Aligner()
        dict_to_load = {}
        for feature in self.getWorkingFeatures():
            feature_geom = feature.geometry()
            wkt = feature_geom.asWkt()
            geom_shapely = geom_from_wkt(wkt)
            dict_to_load[feature.id()] = geom_shapely
        self.progressBar.setValue(10)
        # Load thematic data
        self.aligner.load_thematic_data(DictLoader(dict_to_load))
        self.progressBar.setValue(20)
        # Load reference data for the on-the fly reference versions

        if self.reference_choice in GRB_TYPES:
            self.aligner.load_reference_data(
                GRBActualLoader(
                    grb_type=GRBType[self.reference_choice],
                    partition=1000,
                    aligner=self.aligner,
                )
            )
        elif self.reference_choice in ADPF_VERSIONS:
            year = self.reference_choice.removeprefix("Adpf")
            self.aligner.load_reference_data(
                GRBFiscalParcelLoader(year=year, aligner=self.aligner, partition=1000)
            )
        else:
            # Load reference into a shapely_dict:
            dict_reference = {}
            processing.run(
                "native:selectwithindistance",
                {
                    "INPUT": self.reference_layer,
                    "REFERENCE": self.layer,
                    "DISTANCE": 2 * self.maximum / 100,
                    "METHOD": 0,
                },
            )
            features = self.reference_layer.selectedFeatures()
            for current, feature in enumerate(features):
                id_reference = feature.attribute(self.reference_id)
                dict_reference[id_reference] = geom_qgis_to_shapely(feature.geometry())
            self.reference_layer.removeSelection()
            self.aligner.load_reference_data(DictLoader(dict_reference))
            self.aligner.name_reference_id = self.reference_id
            self.aligner.dict_reference_source["source"] = "local"
            self.aligner.dict_reference_source["version_date"] = "unknown"
        self.progressBar.setValue(50)

        dict_evaluated_predictions = self.aligner.evaluate(
            ids_to_evaluate=None,
            base_metadata_field=None,
            max_predictions=-1,
            relevant_distances=self.relevant_distances,
            full_strategy=self.full_strategy,
        )
        self.progressBar.setValue(75)
        dict_processresults = self.aligner.dict_processresults
        newline = os.linesep
        outputMessage = ""
        for key in dict_evaluated_predictions.keys():

            outputMessage = (
                outputMessage
                + str(key)
                + ": Voorspelde relevante afstanden: "
                + str([str(k) for k in dict_evaluated_predictions[key].keys()])
                + newline
            )
        self.textEdit_output.setText(outputMessage)

        self.dict_processresults = dict_processresults
        self.dict_evaluated_predictions = dict_evaluated_predictions
        self.diffs_dict = self.aligner.get_diff_metrics(
            self.dict_processresults, self.aligner.dict_thematic
        )
        self.add_results_to_grouplayer()
        # set list with predicted values
        self.listWidget_predictions.clear()
        items = []
        items_with_name = []
        best_index = 0
        best_score = 0
        list_predictions = [k for k in (self.dict_evaluated_predictions[key]).keys()]
        for k in list_predictions:
            items.append(str(k))
            score = self.dict_evaluated_predictions[key][k]["properties"][
                PREDICTION_SCORE
            ]
            evaluation = self.dict_evaluated_predictions[key][k]["properties"][
                EVALUATION_FIELD_NAME
            ]
            items_with_name.append(f"{str(k)}: {str(evaluation)} (score: {str(score)})")
            if score > best_score:
                best_score = score
                best_index = list_predictions.index(k)
        self.listWidget_predictions.setFocus()
        self.listWidget_predictions.addItems(items_with_name)
        if len(items) > 0:
            self.listWidget_predictions.setCurrentRow(best_index)
            self.doubleSpinBox.setValue(
                round(float(items[best_index]), self.settingsDialog.DECIMAL)
            )
        else:
            self.textEdit_output.setText("No predictions")
        self.progressBar.setValue(100)
        return

    def add_results_to_grouplayer(self):
        fcs = self.aligner.get_results_as_geojson(
            resulttype=AlignerResultType.PROCESSRESULTS, add_metadata=self.metadata
        )

        featurecollection_to_layer(
            self.LAYER_RESULT_DIFF,
            fcs["result_diff"],
            QgsStyle.defaultStyle().symbol("hashed black X"),
            False,
            self.workinggroupname,
            self.tempfolder,
        )
        featurecollection_to_layer(
            self.LAYER_RESULT_DIFF_PLUS,
            fcs["result_diff_plus"],
            QgsStyle.defaultStyle().symbol("hashed cgreen /"),
            True,
            self.workinggroupname,
            self.tempfolder,
        )
        featurecollection_to_layer(
            self.LAYER_RESULT_DIFF_MIN,
            fcs["result_diff_min"],
            QgsStyle.defaultStyle().symbol("hashed cred /"),
            True,
            self.workinggroupname,
            self.tempfolder,
        )
        featurecollection_to_layer(
            self.LAYER_RESULT,
            fcs["result"],
            QgsStyle.defaultStyle().symbol("outline green"),
            True,
            self.workinggroupname,
            self.tempfolder,
        )
        return

    def prepareFeatureList(self):
        # self.clearUserInterface()
        # Add the selected features to the list widget
        print("list features")
        feature = None
        self.featureItemList = []

        for key in self.dict_processresults.keys():
            for f in self.getWorkingFeatures():
                if f.id() == key:
                    feature = f
                    break
            if feature is None:
                print(f"no feature found for key {str(key)}")
                continue
            qgis_geom = None
            if key in self.dict_evaluated_predictions:
                print(f"keys {str(key)}")
                geom_predictions = self.dict_evaluated_predictions[key]
                nr_predictions = len(geom_predictions.keys())
                print("nr_predictions" + str(nr_predictions))
                if nr_predictions == 1:
                    print(f"auto {str(nr_predictions)}")
                    # update geometry in workinglayer
                    resulting_geom = geom_predictions[list(geom_predictions.keys())[0]][
                        "result"
                    ]
                    qgis_geom = geom_shapely_to_qgis(resulting_geom)
                    attribute_string = "auto"
                else:
                    print(f"to_check {str(nr_predictions)}")
                    attribute_string = "to_check_multi_predictions"
            else:
                attribute_string = "to_check_no_predictions"
            with edit(self.workinglayer):
                self.workinglayer.changeAttributeValue(
                    feature.id(),
                    self.workinglayer.fields().indexOf(BRDRQ_STATE_FIELDNAME),
                    attribute_string,
                )
                if not qgis_geom is None:
                    self.workinglayer.changeGeometry(feature.id(), qgis_geom)

        return

    def getWorkingFeatures(self):
        return [f for f in self.workinglayer.getFeatures()]

    def loadFeaturelist(self):
        self.clearUserInterface()
        for f in self.getWorkingFeatures():
            item = f"ID: *{str(f.id())}*, Attributes: {f[BRDRQ_STATE_FIELDNAME]}"
            if self.checkBox_only_manual.checkState() == 2 and not "to_check" in item:
                continue
            self.listWidget_features.addItem(item)

    def onFeatureActivated(self, currentItem):
        print("_onFeatureChange")
        # Clear the predictionlist
        self.listWidget_predictions.clear()
        if currentItem is None:
            print("currentItem is none")
            return

        # get feature
        self.feature = None
        key = currentItem.text().split("*")[1]
        for feat in self.getWorkingFeatures():
            if str(feat.id()) == key:
                self.feature = feat
                break
        if self.feature is None:
            self.textEdit_output.setText(f"No feature found with ID {key}")
            return
        key = self.feature.id()

        zoom_to_features([self.feature], self.iface,features_crs=self.crs)

        list_predictions = [k for k in (self.dict_evaluated_predictions[key]).keys()]

        items = []
        items_with_name = []
        best_index = 0
        best_score = 0
        for k in list_predictions:
            items.append(str(k))
            score = self.dict_evaluated_predictions[key][k]["properties"][
                PREDICTION_SCORE
            ]
            evaluation = self.dict_evaluated_predictions[key][k]["properties"][
                EVALUATION_FIELD_NAME
            ]
            items_with_name.append(f"{str(k)}: {str(evaluation)} (score: {str(score)})")
            if score > best_score:
                best_score = score
                best_index = list_predictions.index(k)
        self.listWidget_predictions.setFocus()
        self.listWidget_predictions.addItems(items_with_name)
        if len(items) > 0:
            self.listWidget_predictions.setCurrentRow(best_index)
            self.doubleSpinBox.setValue(
                round(float(items[best_index]), self.settingsDialog.DECIMAL)
            )
        else:
            self.textEdit_output.setText("No predictions")

    def change_geometry(self):
        self._change_geometry(self.workinglayer)
        self.loadFeaturelist()

    def reset_geometry(self):
        self._reset_geometry(self.workinglayer)
        self.loadFeaturelist()

    def onListItemActivated(self, currentItem):
        print("onListItemActivated")
        self._listItemActivated(currentItem)

    def startDock(self):
        self.clearUserInterface()
        self.loadSettings()
        self.setHandles()
        return


def __init__():
    pass
