# -*- coding: utf-8 -*-
"""
/***************************************************************************
 brdrQDockWidget
                                 A QGIS plugin
 aligns thematic polygons to reference polygons
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2024-10-08
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Karel Dieussaert
        email                : karel.dieussaert@geosolutions.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from PyQt5.QtGui import QColor
from PyQt5.QtWidgets import QListWidgetItem
from brdr.aligner import Aligner
from brdr.constants import PREDICTION_SCORE, EVALUATION_FIELD_NAME
from brdr.enums import AlignerResultType, GRBType
from brdr.grb import GRBActualLoader, GRBFiscalParcelLoader
from brdr.loader import DictLoader
from qgis import processing
from qgis.PyQt import QtWidgets, uic
from qgis.PyQt.QtCore import Qt
from qgis.PyQt.QtCore import pyqtSignal
from qgis.core import QgsFeature, QgsWkbTypes, QgsVectorLayer, QgsProject
from qgis.core import QgsMapLayerProxyModel
from qgis.gui import QgsMapToolPan
from qgis.gui import QgsRubberBand
from qgis.utils import OverrideCursor, iface

from .brdrq_dockwidget_aligner import brdrQDockWidgetAligner
from .brdrq_utils import (
    SelectTool,
    geojson_to_layer,
    GRB_TYPES,
    ADPF_VERSIONS,
    geom_qgis_to_shapely,
    remove_group_layer,
    get_symbol,
    DICT_REFERENCE_OPTIONS,
    PREFIX_LOCAL_LAYER,
    geom_shapely_to_qgis,
    zoom_to_features,
    BRDRQ_ORIGINAL_WKT_FIELDNAME,
    BRDRQ_STATE_FIELDNAME,
    get_original_geometry,
    PolygonSelectTool,
    BrdrQState,
)

FORM_CLASS, _ = uic.loadUiType(
    os.path.join(os.path.dirname(__file__), "brdrq_dockwidget_featurealigner.ui")
)


class brdrQDockWidgetFeatureAligner(
    QtWidgets.QDockWidget, FORM_CLASS, brdrQDockWidgetAligner
):
    closingPlugin = pyqtSignal()

    def __init__(self, brdrqplugin, parent=None):
        """Constructor."""
        print("init brdrQDockWidgetFeatureAligner")
        brdrQDockWidgetAligner.__init__(self, brdrqplugin)
        super(brdrQDockWidgetFeatureAligner, self).__init__(parent)
        # Set up the user interface from Designer.
        # After setupUI you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://doc.qt.io/qt-5/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        self._initialize()

    def clearUserInterface(self):
        # Clear progressbar
        self.progressBar.setValue(0)
        self.doubleSpinBox.setValue(0)
        # Clear the featurelist widget
        self.listWidget_features.clear()
        # Clear the predictionlist
        self.listWidget_predictions.clear()

        remove_group_layer(self.GROUP_LAYER)
        self.feature = None

    def _initialize(self):
        print("_initialize")
        # connect to provide cleanup on closing of dockwidget
        self._initializeSelectFeatures()
        self.closingPlugin.connect(self.onClosePlugin)
        self.pushButton_help.clicked.connect(self.show_help_dialog)
        self.pushButton_settings.clicked.connect(self.show_settings_dialog)
        self.pushButton_grafiek.clicked.connect(self.get_graphic)
        self.pushButton_visualisatie.clicked.connect(self.get_visualisation)
        self.pushButton_save.clicked.connect(self.change_geometry)
        self.pushButton_reset.clicked.connect(self.reset_geometry)
        self.pushButton_select.clicked.connect(self.activate_selectTool)
        # self.pushButton_select_partial.clicked.connect(self.activate_partialSelectTool)
        self.mMapLayerComboBox.setFilters(
            QgsMapLayerProxyModel.PolygonLayer
            | QgsMapLayerProxyModel.LineLayer
            | QgsMapLayerProxyModel.PointLayer
        )
        self.mMapLayerComboBox.layerChanged.connect(self.themeLayerChanged)
        self.listWidget_features.itemPressed.connect(self.onFeatureActivated)
        self.listWidget_predictions.itemPressed.connect(self.onListItemActivated)
        self.horizontalSlider.sliderMoved.connect(self.onSliderChange)
        self.doubleSpinBox.valueChanged.connect(self.onSpinboxChange)

        # show the dockwidget
        self.iface.addDockWidget(Qt.RightDockWidgetArea, self)
        #
        self.layer = self.mMapLayerComboBox.currentLayer()
        self.settingsDialog.confirmed.connect(self.startDock)
        return

    def _initializeSelectFeatures(self):
        self.comboBox_selectfeatures.addItem("ALL FEATURES",userData="ALL")
        self.comboBox_selectfeatures.addItem("SELECTED FEATURES",userData="SELECTED")
        for x in BrdrQState:
            self.comboBox_selectfeatures.addItem("STATE: "+str(x.value),userData = str(x.value))

        self.comboBox_selectfeatures.currentIndexChanged.connect(self.on_selectfeatures_changed)

    def on_selectfeatures_changed(self,index):
        data = self.comboBox_selectfeatures.itemData(index)
        print("Selected data:", data)
        self.listFeatures(selection=data)

    def onClosePlugin(self):
        """Cleanup necessary items here when plugin dockwidget is closed"""
        print("onClosePlugin")
        print("** CLOSING brdrQ")
        remove_group_layer(self.GROUP_LAYER)
        # disconnects
        print("** disconnect dockwidget")
        self.closingPlugin.disconnect(self.onClosePlugin)

    def activate_selectTool(self):
        # print ("currentlayer:" + str (self.mMapLayerComboBox.currentLayer()))
        self.selectTool = SelectTool(self.iface, self.mMapLayerComboBox.currentLayer())
        self.formerMapTool = self.iface.mapCanvas().mapTool()
        self.iface.mapCanvas().setMapTool(self.selectTool)
        self.selectTool.featuresIdentified.connect(self.onFeaturesIdentified)
        print("end activate_selecttool")

    def activate_partialSelectTool(self):
        # print ("currentlayer:" + str (self.mMapLayerComboBox.currentLayer()))
        canvas = self.iface.mapCanvas()
        self.formerMapTool = canvas.mapTool()
        self.partialSelectTool = PolygonSelectTool(
            canvas, self.layer, self.handlePartialSelection
        )
        canvas.setMapTool(self.partialSelectTool)
        print("end activate_partialSelecttool")

    def deactivateSelectTool(self):
        mapcanvas = self.iface.mapCanvas()
        if self.formerMapTool is None:
            self.formerMapTool = QgsMapToolPan(mapcanvas)
        mapcanvas.setMapTool(self.formerMapTool)

    def onFeaturesIdentified(self, identified_features):
        """Code called when the feature is selected by the user"""
        self.listFeatures(features=identified_features)

    def handlePartialSelection(self, polygon_geom, layer, canvas):

        partial_features = []
        for feat in layer.getFeatures():
            if feat.geometry().intersects(polygon_geom):
                clipped = feat.geometry().intersection(polygon_geom)

                if not clipped.isEmpty():
                    feat.setGeometry(clipped)
                    partial_features.append(feat)

        for feat in partial_features:
            geom = feat.geometry()
            rb = QgsRubberBand(canvas, QgsWkbTypes.PolygonGeometry)
            rb.setToGeometry(geom, None)
            rb.setColor(QColor(0, 255, 0, 100))
            rb.setWidth(2)

        temp_layer = QgsVectorLayer(
            "Polygon?crs=" + layer.crs().authid(), "cut features", "memory"
        )
        prov = temp_layer.dataProvider()
        prov.addFeatures(partial_features)

        QgsProject.instance().addMapLayer(temp_layer)
        print(f"{len(partial_features)} -> #partial features.")
        self.listFeatures(features=partial_features)

    def themeLayerChanged(self):
        print("themelayer changed")
        # reset interface by clearing list, progress_bar
        self.clearUserInterface()
        self.layer = self.mMapLayerComboBox.currentLayer()
        if self.layer is None:
            self.textEdit_output.setText("Please select a layer")
            return
        try:
            self.crs = self.layer.sourceCrs().authid()
        except:
            self.crs = None
        if self.crs is None or self.crs == 'NULL' or self.crs == '':
            iface.messageBar().pushWarning(
                 "CRS", "CRS of the thematic layer is not defined. Please define a CRS to the thematic layer with units in meter")
            self.layer = None
            self.mMapLayerComboBox.setLayer(self.layer)
            return
        if self._check_warn_edit_modus(self.layer):
            iface.messageBar().pushWarning("Edit-session","Please close edit-session of layer")
            self.layer = None
            self.mMapLayerComboBox.setLayer(self.layer)
            return
        if self.layer.selectedFeatureCount() > self.max_feature_count or (
            self.layer.selectedFeatureCount() == 0
            and self.layer.featureCount() > self.max_feature_count
        ):
            self.textEdit_output.setText(
                f"Nr of features bigger than {str(self.max_feature_count)}. Please make a smaller selection of features"
            )
            return

        index = self.comboBox_selectfeatures.currentIndex()
        data = self.comboBox_selectfeatures.itemData(index)
        self.listFeatures(selection=data)

    def listFeatures(self,selection=None,features=None):
        self.clearUserInterface()
        if not features is None:
            self.listed_features = features
        elif selection is None or selection == "ALL":
            self.listed_features = [f for f in self.layer.getFeatures()]
            self.textEdit_output.setText("All features in this layer returned")
        elif selection == "SELECTED":
            ix = self.layer.fields().indexOf(BRDRQ_STATE_FIELDNAME)
            self.listed_features = [f for f in self.layer.getSelectedFeatures()]
            self.textEdit_output.setText("Selected features in this layer returned")
        elif selection in [str(e.value) for e in BrdrQState]:
            listed_features = []
            ix = self.layer.fields().indexOf(BRDRQ_STATE_FIELDNAME)
            for f in self.layer.getFeatures():
                attributes = f.attributes()
                if ix >= 0 and attributes[ix] == selection:
                    listed_features.append(f)
            self.listed_features = listed_features
            self.textEdit_output.setText(
                f"Features filtered by brdrq_STATE = {str(selection)}"
            )

        if len(self.listed_features) > self.max_feature_count:
            self.textEdit_output.setText(
                f"Nr of features bigger than {str(self.max_feature_count)}. Please make a smaller selection of features"
            )
            return

        # Add the selected features to the list widget
        for feature in self.listed_features:
            item = QListWidgetItem(str(feature.id()))
            self.listWidget_features.addItem(item)
        self.updateTextListWidgetItems()
        self.textEdit_output.setText(f"#Features: {str(len(self.listed_features))}")
        if len(self.listed_features) == 1:
            self.onFeatureActivated(self.listWidget_features.item(0))
        return

    def updateTextListWidgetItems(self):
        ix = self.layer.fields().indexOf(BRDRQ_STATE_FIELDNAME)
        for i in range(self.listWidget_features.count()):
            item = self.listWidget_features.item(i)
            feature_id = self.listed_features[i].id()
            feature = self.layer.getFeature(feature_id)
            attributes = feature.attributes()
            if ix >= 0:
                state = attributes[ix]
            else:
                state = str(BrdrQState.NONE.value)
            attribute_string = ", ".join(str(attribute) for attribute in attributes)
            item_text = f"ID: *{feature.id()}*, STATE: *{state} *, Attributes: {attribute_string}"
            item.setText(item_text)

    def onFeatureActivated(self, currentItem):
        print("onFeatureActivated")
        self.deactivateSelectTool()
        self.progressBar.setValue(0)
        self.listWidget_predictions.clear()
        self.textEdit_output.setText("")
        with OverrideCursor(Qt.WaitCursor):
            self._onFeatureChange(currentItem)
        self.progressBar.setValue(100)

    def _onFeatureChange(self, currentItem):
        print("_onFeatureChange")
        self.feature = None
        if currentItem is None:
            print("currentItem is none")
            return
        feature_id = currentItem.text().split("*")[1]
        for feat in self.listed_features:
            if str(feat.id()) == feature_id:
                self.feature = feat
                break
        if self.feature is None:
            self.textEdit_output.setText(f"No feature found with ID {feature_id}")
            return

        original_geometry = get_original_geometry(
            self.feature, BRDRQ_ORIGINAL_WKT_FIELDNAME
        )
        if original_geometry is None:
            original_geometry = self.feature.geometry()

        zoom_to_features([self.feature], self.iface,features_crs=self.crs)
        key = self.feature.id()

        # Check feature on area
        # check area of feature and optimize/block calculation
        area = original_geometry.area()
        max_rel_dist = self.settingsDialog.max_rel_dist
        step = self.settingsDialog.small_step
        if area > self.max_area_optimization:
            if area > self.max_area_limit:
                msg = f"Very big area, {str(area)} m²: The calculation is blocked. Please use the bulk tool for this feature"
                self.textEdit_output.setText(f"{msg}")
                self.doubleSpinBox.setValue(0)
                self.listWidget_predictions.clear()
                return
            else:
                big_step = self.settingsDialog.big_step
                msg = f"Warning - Big area, {str(area)} m²: the calculation will be adapted/optimized. Predictions will be based on steps of {str(big_step)} cm"
                self.textEdit_output.setText(f"{msg}")
                step = big_step
        if max_rel_dist > 2 * self.max_rel_dist_optimization:
            big_step = self.settingsDialog.big_step
            msg = f"Predictions will be based on steps of {str(big_step)} cm"
            self.textEdit_output.setText(f"{msg}")
            step = big_step
        elif max_rel_dist > self.max_rel_dist_optimization:
            mid_step = self.settingsDialog.mid_step
            msg = f"Predictions will be based on steps of {str(mid_step)} cm"
            self.textEdit_output.setText(f"{msg}")
            step = mid_step

        # adapt & reload settings (espacially relevant_distances) before alignment
        self.settingsDialog.step = step
        self.loadSettings()
        self.setHandles()

        # set list with predicted values
        self.listWidget_predictions.clear()
        # do alignment/prediction
        align = self._align()
        if align is None:
            return

        self.add_results_to_grouplayer()

        # loop predictions & add prediction score & evaluation
        items = []
        items_with_name = []
        best_index = 0
        best_score = 0
        list_predictions = [k for k in (self.dict_evaluated_predictions[key]).keys()]
        list_predictions_features = []
        for rd in list_predictions:
            feat = QgsFeature()
            feat.setGeometry(
                geom_shapely_to_qgis(self.dict_evaluated_predictions[key][rd]["result"])
            )
            list_predictions_features.append(feat)
        zoom_to_features(list_predictions_features, self.iface,features_crs=self.crs)
        for k in list_predictions:
            items.append(str(k))
            score = self.dict_evaluated_predictions[key][k]["properties"][
                PREDICTION_SCORE
            ]
            evaluation = self.dict_evaluated_predictions[key][k]["properties"][
                EVALUATION_FIELD_NAME
            ]
            items_with_name.append(f"{str(k)}: {str(evaluation)} (score: {str(score)})")
            if score > best_score:
                best_score = score
                best_index = list_predictions.index(k)
        self.listWidget_predictions.setFocus()
        self.listWidget_predictions.addItems(items_with_name)
        if len(items) > 0:
            self.listWidget_predictions.setCurrentRow(best_index)
            value = round(float(items[best_index]), self.settingsDialog.DECIMAL)
            self.setFilterOnLayers(value)
            self.doubleSpinBox.setValue(value)
        else:
            self.textEdit_output.setText("No predictions")
        return

    def add_results_to_grouplayer(self):
        print("adding results")
        if self.aligner is None:
            return
        fcs = self.aligner.get_results_as_geojson(
            resulttype=AlignerResultType.PROCESSRESULTS, formula=self.formula
        )
        result_diff = "result_diff"
        geojson_result_diff = fcs[result_diff]
        geojson_to_layer(
            self.LAYER_RESULT_DIFF,
            geojson_result_diff,
            get_symbol(geojson_result_diff, result_diff),
            False,
            self.GROUP_LAYER,
            self.tempfolder,
        )
        result_diff_plus = "result_diff_plus"
        geojson_result_diff_plus = fcs[result_diff_plus]
        geojson_to_layer(
            self.LAYER_RESULT_DIFF_PLUS,
            geojson_result_diff_plus,
            get_symbol(geojson_result_diff_plus, result_diff_plus),
            True,
            self.GROUP_LAYER,
            self.tempfolder,
        )
        result_diff_min = "result_diff_min"
        geojson_result_diff_min = fcs[result_diff_min]
        geojson_to_layer(
            self.LAYER_RESULT_DIFF_MIN,
            geojson_result_diff_min,
            get_symbol(geojson_result_diff_min, result_diff_min),
            True,
            self.GROUP_LAYER,
            self.tempfolder,
        )
        result = "result"
        geojson_result = fcs[result]
        geojson_to_layer(
            self.LAYER_RESULT,
            geojson_result,
            get_symbol(geojson_result, result),
            True,
            self.GROUP_LAYER,
            self.tempfolder,
        )
        return

    def onListItemActivated(self, currentItem):
        print("onListItemActivated")
        self.deactivateSelectTool()
        self._listItemActivated(currentItem)

    def _align(self):
        print("_align")
        feat = self.feature
        selectedFeatures = []
        if feat is not None:
            selectedFeatures.append(feat)
        if len(selectedFeatures) == 0:
            self.textEdit_output.setText(
                "No features selected. Please select a feature from the active layer."
            )
            return None

        dict_to_load = {}

        self.progressBar.setValue(0)
        for feature in selectedFeatures:
            original_geometry = get_original_geometry(
                feature, BRDRQ_ORIGINAL_WKT_FIELDNAME
            )
            if original_geometry is None:
                original_geometry = feature.geometry()
            if original_geometry is None:
                print("feature without geometry")
                continue
            geom_shapely = geom_qgis_to_shapely(original_geometry)

            dict_to_load[feature.id()] = geom_shapely

        self.aligner = Aligner(
            crs=self.crs,
            od_strategy=self.od_strategy,
            threshold_overlap_percentage=self.threshold_overlap_percentage,
            snap_strategy=self.partial_snapping_strategy,
            snap_max_segment_length=self.snap_max_segment_length,
            partial_snapping=self.partial_snapping,
            partial_snap_strategy=self.partial_snapping_strategy,
            partial_snap_max_segment_length=self.snap_max_segment_length,
        )

        # Load thematic data
        self.aligner.load_thematic_data(DictLoader(dict_to_load))
        self.progressBar.setValue(25)
        # Load reference data for the on-the fly reference versions
        reference_choice_id = DICT_REFERENCE_OPTIONS[self.reference_choice]
        if self.reference_choice in GRB_TYPES:
            self.aligner.load_reference_data(
                GRBActualLoader(
                    grb_type=GRBType[reference_choice_id],
                    partition=1000,
                    aligner=self.aligner,
                )
            )
        elif self.reference_choice in ADPF_VERSIONS:
            self.aligner.load_reference_data(
                GRBFiscalParcelLoader(
                    year=reference_choice_id, aligner=self.aligner, partition=1000
                )
            )
        else:
            # Load local referencelayer
            # check the CRS of the local layer
            try:
                reference_crs = self.reference_layer.sourceCrs().authid()
            except:
                reference_crs = None
            if reference_crs is None or reference_crs == "NULL"  or reference_crs == '':
                iface.messageBar().pushWarning("CRS",
                    "CRS of the local Reference Layer is not defined. Please define a CRS to the REFERENCE Layer with units in meter"
                )
                return None
            elif reference_crs != self.crs:
                iface.messageBar().pushWarning("CRS",
                    "Thematic layer and ReferenceLayer are in a different CRS. "
                    "Please provide them in the same CRS, with units in meter (f.e. For Belgium in EPSG:31370 or EPSG:3812)"
                )
                return None
            # Load reference-layer into a shapely_dict:
            dict_reference = {}
            processing.run(
                "native:selectwithindistance",
                {
                    "INPUT": self.reference_layer,
                    "REFERENCE": self.layer,
                    "DISTANCE": 2 * self.maximum / 100,
                    "METHOD": 0,
                },
            )
            features = self.reference_layer.selectedFeatures()
            for current, feature in enumerate(features):
                id_reference = feature.attribute(self.reference_id)
                dict_reference[id_reference] = geom_qgis_to_shapely(feature.geometry())
            self.reference_layer.removeSelection()
            self.aligner.load_reference_data(DictLoader(dict_reference))
            self.aligner.name_reference_id = self.reference_id
            self.aligner.dict_reference_source["source"] = PREFIX_LOCAL_LAYER
            self.aligner.dict_reference_source["version_date"] = "unknown"
        self.progressBar.setValue(50)

        dict_evaluated = self.aligner.evaluate(
            ids_to_evaluate=None,
            base_formula_field=None,
            max_predictions=4,
            relevant_distances=self.relevant_distances,
            full_strategy=self.full_strategy,
        )

        self.dict_processresults = self.aligner.dict_processresults
        self.dict_evaluated_predictions = dict_evaluated

        self.diffs_dict = self.aligner.get_diff_metrics(self.dict_processresults)

        outputMessage = "PREDICTIONS (@ relevant distances): " + str(
            [str(k) for k in self.dict_evaluated_predictions[feat.id()].keys()]
        )
        self.textEdit_output.setText(outputMessage)
        return (
            self.dict_processresults,
            self.dict_evaluated_predictions,
            self.diffs_dict,
        )

    def change_geometry(self):
        self._change_geometry(self.layer)
        self.updateTextListWidgetItems()
        remove_group_layer(self.GROUP_LAYER)

    def reset_geometry(self):
        self._reset_geometry(self.layer)
        self.updateTextListWidgetItems()
        remove_group_layer(self.GROUP_LAYER)

    def startDock(self):
        print("start dock")
        self.clearUserInterface()
        self.textEdit_output.setText("Please select a feature to align")
        self.loadSettings()
        self.setHandles()
        self.show()
        return


def __init__():
    pass
