# -*- coding: utf-8 -*-
"""
/***************************************************************************
 brdrQDockWidget
                                 A QGIS plugin
 aligns thematic polygons to reference polygons
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2024-10-08
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Karel Dieussaert
        email                : karel.dieussaert@geosolutions.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import webbrowser

from qgis.core import edit

from .brdrq_help import brdrQHelp
from .brdrq_settings import brdrQSettings
from .brdrq_utils import (
    plot_series,
    show_map,
    get_workfolder,
    geom_shapely_to_qgis,
    get_layer_by_name,
    BRDRQ_ORIGINAL_WKT_FIELDNAME,
    BRDRQ_STATE_FIELDNAME,
    BrdrQState,
    get_original_geometry,
)


class brdrQDockWidgetAligner(object):

    def __init__(self, brdrqplugin):
        print("init brdrQDockWidgetAligner")
        self.brdrqplugin = brdrqplugin
        if not brdrqplugin is None:
            self.iface = self.brdrqplugin.iface
        self.layer = None
        self.crs = None
        self.formula = None
        self.max_feature_count = 5000
        self.max_area_optimization = 100000
        self.max_area_limit = (
            1000000  # maximum m² where the calculation will be done for
        )
        self.max_rel_dist_optimization = 5  # in meters
        self.listed_features = None
        self.feature = None
        self.selectTool = None
        self.partialSelectTool = None
        self.formerMapTool = None
        self.aligner = None

        self.relevant_distances = None
        self.threshold_overlap_percentage = None
        self.od_strategy = None
        self.reference_choice = None
        self.reference_id = None
        self.reference_layer = None
        self.max_rel_dist = None
        self.formula = None
        self.full_strategy = None
        self.partial_snapping = None
        self.partial_snapping_strategy = None
        self.snap_max_segment_length = None
        self.settingsDialog = brdrQSettings()
        self.tempfolder = get_workfolder("", "brdrQ", temporary=True)

        self.dict_processresults = None
        self.dict_evaluated_predictions = None
        self.props_dict_evaluated_predictions = None
        self.diffs_dict = None

        self.GROUP_LAYER = "brdrQ_featurealigner"
        self.LAYER_RESULT = (
            "RESULT"  # parameter that holds the TOC layername of the result
        )
        self.LAYER_RESULT_DIFF = (
            "DIFF"  # parameter that holds the TOC layername of the resulting diff
        )
        self.LAYER_RESULT_DIFF_PLUS = "DIFF_PLUS"  # parameter that holds the TOC layername of the resulting diff_plus
        self.LAYER_RESULT_DIFF_MIN = "DIFF_MIN"  # parameter that holds the TOC layername of the resulting diff_min

        self.helpDialog = brdrQHelp()

    def closeEvent(self, event):
        self.closingPlugin.emit()
        event.accept()

    def _listItemActivated(self, currentItem):
        print("_listItemActivated")
        if currentItem is None:
            print("currentitem zero")
            return
        # print("item activated with rd: " + currentItem.text())
        value = currentItem.text()
        value = value.split(":")[0]
        value = round(float(value), self.settingsDialog.DECIMAL)
        # print("item activated with rd - value: " + str(value))
        self.doubleSpinBox.setValue(value)
        index = self.relevant_distances.index(value)
        self.horizontalSlider.setValue(index)
        return

    def _check_warn_edit_modus(self, layer):
        if layer.isEditable():
            msg = "This layer is in edit-modus. Please close edit-modus before using the feature-aligner"
            self.iface.messageBar().pushWarning("Warning", msg)
            return True
        else:
            return False

    def _change_geometry(self, layer):
        if self._check_warn_edit_modus(layer):
            return
        feat = self.feature
        if feat is None:
            return
        key = feat.id()
        relevant_distance = round(
            self.doubleSpinBox.value(), self.settingsDialog.DECIMAL
        )
        if relevant_distance in self.dict_processresults[key]:
            result = self.dict_processresults[key][relevant_distance]
            resulting_geom = result["result"]
        else:
            errormesssage = "Relevant_distance_result not calculated for: " + str(
                relevant_distance
            )
            print(errormesssage)
            return
        qgis_geom = geom_shapely_to_qgis(resulting_geom)
        ix = layer.fields().indexOf(BRDRQ_STATE_FIELDNAME)
        with edit(layer):
            layer.changeGeometry(feat.id(), qgis_geom)
            if ix >= 0:
                layer.changeAttributeValue(
                    feat.id(), ix, str(BrdrQState.MANUAL_UPDATED.value)
                )
        self.iface.messageBar().pushMessage("geometry saved")

    def _reset_geometry(self, layer):
        if self._check_warn_edit_modus(layer):
            return
        feat = self.feature
        if feat is None:
            return
        original_geometry = get_original_geometry(feat, BRDRQ_ORIGINAL_WKT_FIELDNAME)
        if original_geometry is None:
            key = feat.id()
            relevant_distance = round(0.0, self.settingsDialog.DECIMAL)
            if relevant_distance in self.dict_processresults[key]:
                result = self.dict_processresults[key][relevant_distance]
                original_geometry = geom_shapely_to_qgis(result["result"])
            else:
                errormesssage = (
                    f"problem resetting for reldist {str(relevant_distance)}"
                )
                print(errormesssage)
                return

        ix = layer.fields().indexOf(BRDRQ_STATE_FIELDNAME)
        with edit(layer):
            layer.changeGeometry(feat.id(), original_geometry)
            if ix >= 0:
                layer.changeAttributeValue(
                    feat.id(), ix, str(BrdrQState.TO_UPDATE.value)
                )

        self.iface.messageBar().pushMessage("geometry reset")

    def onSliderChange(self, index):
        print("onSliderChange: index -> " + str(index))
        value = self.relevant_distances[index]
        value = round(value, self.settingsDialog.DECIMAL)
        self.doubleSpinBox.setValue(value)
        return

    def onSpinboxChange(self, value):
        value = round(value, self.settingsDialog.DECIMAL)
        index = self.relevant_distances.index(value)
        self.horizontalSlider.setValue(index)
        print("onSpinboxChange: value -> " + str(value))

        layer_result = get_layer_by_name(self.LAYER_RESULT)
        layer_result_diff = get_layer_by_name(self.LAYER_RESULT_DIFF)
        layer_result_diff_min = get_layer_by_name(self.LAYER_RESULT_DIFF_MIN)
        layer_result_diff_plus = get_layer_by_name(self.LAYER_RESULT_DIFF_PLUS)
        if (
            layer_result is None
            or layer_result_diff is None
            or layer_result_diff_min is None
            or layer_result_diff_plus is None
        ):
            self.add_results_to_grouplayer()
        self.setFilterOnLayers(value)

        self.get_wkt()
        return

    def setFilterOnLayers(self, value):
        layer_result = get_layer_by_name(self.LAYER_RESULT)
        layer_result_diff = get_layer_by_name(self.LAYER_RESULT_DIFF)
        layer_result_diff_min = get_layer_by_name(self.LAYER_RESULT_DIFF_MIN)
        layer_result_diff_plus = get_layer_by_name(self.LAYER_RESULT_DIFF_PLUS)

        # Filter layers based on relevant distance
        layer_result.setSubsetString(f"brdr_relevant_distance = {value}")
        layer_result_diff.setSubsetString(f"brdr_relevant_distance = {value}")
        layer_result_diff_min.setSubsetString(f"brdr_relevant_distance = {value}")
        layer_result_diff_plus.setSubsetString(f"brdr_relevant_distance = {value}")
        return

    def get_wkt(self):
        feat = self.feature
        if feat is None:
            return
        key = feat.id()
        # print("key:" + str(key))
        relevant_distance = round(
            self.doubleSpinBox.value(), self.settingsDialog.DECIMAL
        )
        # print(str(relevant_distance))
        if (
            key is None
            or self.dict_processresults is None
            or not key in self.dict_processresults.keys()
        ):
            msg = f"No prediction-WKT of feature {str(key)}..."
            self.textEdit_output.setText(msg)
            return

        elif relevant_distance in self.dict_processresults[key]:
            result = self.dict_processresults[key][relevant_distance]
            resulting_geom = result["result"]
        else:
            errormesssage = (
                "Relevant_distance_result not calculated for key : "
                + str(key)
                + " at relevant distance-"
                + str(relevant_distance)
            )

            self.textEdit_output.setText(errormesssage)
            return
        wkt = resulting_geom.wkt
        self.textEdit_output.setText(wkt)

    def get_visualisation(self):
        feat = self.feature
        if feat is None:
            return
        key = feat.id()
        show_map(
            {key: self.dict_evaluated_predictions[key]},
            {key: self.aligner.dict_thematic[key]},
            self.aligner.dict_reference,
        )
        return

    def get_graphic(self):
        feat = self.feature
        if feat is None:
            print("no feature")
            return
        key = feat.id()
        plot_series(self.relevant_distances, {key: self.diffs_dict[key]})
        return

    def show_help_dialog(self):
        print("show help dialog")
        # Open link to documentation
        webbrowser.open("https://github.com/OnroerendErfgoed/brdrQ/blob/main/docs/featurealigner.md")
        # self.helpDialog.show()

    def show_settings_dialog(self):
        print("show_settings_dialog")
        self.settingsDialog.show()

    def setHandles(self):
        self.minimum = self.settingsDialog.minimum
        self.maximum = self.settingsDialog.maximum
        self.step = self.settingsDialog.step

        self.doubleSpinBox.setMinimum(self.minimum / 100)
        self.doubleSpinBox.setMaximum(self.maximum / 100)
        self.doubleSpinBox.setSingleStep(self.step / 100)
        self.doubleSpinBox.setDecimals(self.settingsDialog.DECIMAL)
        self.doubleSpinBox.setValue(0.0)
        self.horizontalSlider.setMinimum(0)
        self.horizontalSlider.setMaximum(len(self.relevant_distances) - 1)
        self.horizontalSlider.setSingleStep(1)
        return

    def loadSettings(self):
        self.settingsDialog.update_settings()
        self.threshold_overlap_percentage = (
            self.settingsDialog.threshold_overlap_percentage
        )
        self.od_strategy = self.settingsDialog.od_strategy
        self.reference_choice = self.settingsDialog.reference_choice
        self.reference_id = self.settingsDialog.reference_id
        self.reference_layer = self.settingsDialog.reference_layer
        self.max_rel_dist = self.settingsDialog.max_rel_dist
        self.minimum = self.settingsDialog.minimum
        self.maximum = self.settingsDialog.maximum
        self.step = self.settingsDialog.step
        self.relevant_distances = self.settingsDialog.relevant_distances
        self.formula = self.settingsDialog.formula
        self.full_strategy = self.settingsDialog.full_strategy
        self.partial_snapping = self.settingsDialog.partial_snapping
        self.partial_snapping_strategy = self.settingsDialog.partial_snapping_strategy
        self.snap_max_segment_length = self.settingsDialog.snap_max_segment_length
