# -*- coding: utf-8 -*-
"""
/***************************************************************************
 BrdrQ
                                 A QGIS plugin
 brdrQ, a QGIS-plugin for aligning thematic borders to reference borders.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-10-11
        copyright            : (C) 2024 by Karel Dieussaert / Onroerend Erfgoed
        email                : karel.dieussaert@vlaanderen.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 This script initializes the plugin, making it known to QGIS.
"""

__author__ = "Karel Dieussaert / Onroerend Erfgoed"
__date__ = "2024-10-11"
__copyright__ = "(C) 2024 by Karel Dieussaert / Onroerend Erfgoed"


# noinspection PyPep8Naming
def classFactory(iface):  # pylint: disable=invalid-name
    """Load BrdrQ class from file BrdrQ.

    :param iface: A QGIS interface instance.
    :type iface: QgsInterface
    """
    #
    from .brdrq_module_importer import import_modules

    try:
        import_modules()
        from .brdrq_plugin import BrdrQPlugin

        return BrdrQPlugin(iface)
    except:
        show_error_dialog()
        raise RuntimeError("Error initializing brdrQ-plugin")


def show_error_dialog():
    from PyQt5.QtWidgets import QMessageBox

    msg = QMessageBox()
    msg.setIcon(QMessageBox.Critical)
    msg.setWindowTitle("Problem while initializing the brdrQ-plugin")
    msg.setText(f"The brdrQ-plugin could not be loaded correctly.")
    msg.setInformativeText(
        "Please restart QGIS and retry. If this problem persists, try to upgrade the plugin."
    )
    msg.setStandardButtons(QMessageBox.Ok)
    msg.exec_()
