# -*- coding: utf-8 -*-
"""
/***************************************************************************
 BrandGis
                                 A QGIS plugin
 Plugin till BrandGis projektet
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-03-17
        git sha              : $Format:%H$
        copyright            : (C) 2022 by Daniel Lind
        email                : danolin82@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
try: 
    from asyncio.windows_events import NULL
except:
    pass
from .BrandGisSmhiFunctions import unloadBrandGisSmhiFunctions, initBrandGisSmhiFunctions
from fileinput import filename
from PyQt5.QtCore import QSettings, QTranslator, QCoreApplication, QObject, Qt
from PyQt5.QtGui import QIcon
from PyQt5.QtWidgets import QAction, QFileDialog
from qgis.core import QgsProject, QgsExpressionContextUtils, QgsApplication, QgsLayoutExporter, QgsLayoutItemMap, Qgis, QgsMapLayer, edit, QgsVectorLayerTemporalProperties
from qgis.utils import iface
from qgis import utils
from qgis.PyQt.QtWidgets import QMessageBox
#from zipfile import ZipFile            # Can be used if a projectfil is shipped with plugin
from pathlib import *
from datetime import datetime
import subprocess, os, platform
from osgeo import gdal
import shutil


# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .Brand_Gis_dialog import BrandGisDialog
from .brand_gis_print_dialog import BrandGisPrintDialog
from .brand_gis_import_dialog import BrandGisImportDialog
import os.path



class BrandGis:
    """QGIS Plugin Implementation."""


    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'BrandGis_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Brand Gis')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('BrandGis', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):

        
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)


        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):

        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/Brand_Gis/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Brand-Gis-Start'),
            callback=self.run,
            parent=self.iface.mainWindow())
           
      
        icon_path = ':/plugins/Brand_Gis/pdf.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Brand-Gis-PDF export'),
            callback=self.run2,
            parent=self.iface.mainWindow())

        icon_path = ':/plugins/Brand_Gis/import.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Brand-Gis-import'),
            callback=self.run3,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True
        initBrandGisSmhiFunctions()


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Brand Gis'),
                action)
            self.iface.removeToolBarIcon(action)
            
        unloadBrandGisSmhiFunctions()


    def select_output_logo(self):
        filename, _filter = QFileDialog.getOpenFileName(
            self.dlg, 'Select   output file ','', 'Png (*.png);;Jpg (*.jpg);;All Files (*)', str(QgsProject.instance().homePath()))
        self.dlg.lineEditLogo.setText(filename)


    def select_output_project(self):
        filename2 = QFileDialog.getExistingDirectory(self.dlg, 'Välj mapp', str(QgsProject.instance().homePath()))
        self.dlg.lineEditProject.setText(filename2)

    def symbolElseDict(self):
        layers = QgsProject.instance().mapLayers().values()
        symbolDict = {}
        for layer in layers:
            '''layerOptionList = ['renderType','indexForElse','indexForAktuell', 'elseSymbol']'''
            layerOptionList = ['renderType',-1,-1,-1]

            try:
                if layer.type() == QgsMapLayer.VectorLayer and not layer.renderer().type() == 'singleSymbol' and 'datumtid_start' in layer.fields().names() :
                    # print(layer.renderer().type())
                    if layer.renderer().type() == 'categorizedSymbol':

                        layerOptionList[0] = layer.renderer().type()
                        layerOptionList[1] = layer.renderer().categoryIndexForLabel('Alla andra värden - Timeslide')
                        aktuellIndex = layer.renderer().categoryIndexForLabel('aktuell')
                        layerOptionList[2] = aktuellIndex

                        layerCatClone = layer.renderer().categories()[0]
                        layerCatClone.symbol().clone()

                        layerCatClone.setValue('')
                        layerCatClone.setLabel('Alla andra värden - Timeslide')
                        layerOptionList[3] = layerCatClone
                        
                    elif layer.renderer().type() == 'RuleRenderer':
                        layerOptionList[0] = layer.renderer().type()

                        layerRules = layer.renderer().rootRule().children()
                    
                        for layRule in range(len(layerRules)):
                            if layerRules[layRule].label() == 'aktuell':
                        #        print(layRule, layerRules[layRule].label())
                                layerOptionList[2] = layRule

                                layerRuleClone = layer.renderer().rootRule().children()[layRule].clone()
                                layerRuleClone.setIsElse(True)
                                layerRuleClone.setLabel('Alla andra värden - Timeslide')
                                layerOptionList[3] = layerRuleClone

                            elif layerRules[layRule].label() == 'Alla andra värden - Timeslide':
                                layerOptionList[1] = layRule
                            else:
                                pass

                    else:
                        pass
            
                    symbolDict[layer.id()] = layerOptionList
                    
            except:
                pass
   
        return symbolDict
                                                                                        
    def viewAllFeatures(self, symbolElseDict):


        for layId, laySet in self.symbolElseDict().items():

            layer = QgsProject.instance().mapLayer(layId)
            # print(layId, laySet)
            if laySet[1] == -1:
                


                if laySet[0] == 'RuleRenderer' and laySet[3] != -1:
                    # print(laySet[3])
                    layer.renderer().rootRule().appendChild(laySet[3])
                    iface.layerTreeView().refreshLayerSymbology(layer.id())
                    layer.triggerRepaint()
                    # print(layer.name(), 'RuleRenderer Klar')

                elif laySet[0] == 'categorizedSymbol' and laySet[3] != -1:
                    layer.renderer().addCategory(laySet[3])
                    iface.layerTreeView().refreshLayerSymbology(layer.id())
                    layer.triggerRepaint()
                    # print(layer.name(), 'categorizedSymbol Klar')

            else:
                pass

        return print('Visar "Alla andra värden - Timeslide"')

    def hideAllFeatures(self, symbolElseDict):


        for layId, laySet in self.symbolElseDict().items():

            layer = QgsProject.instance().mapLayer(layId)
            # print(layId, laySet)
            if laySet[1] != -1:
                
                if laySet[0] == 'RuleRenderer':
                    # print(laySet[3])
                    layer.renderer().rootRule().removeChildAt(laySet[1])
                    iface.layerTreeView().refreshLayerSymbology(layer.id())
                    layer.triggerRepaint()
                    # print(layer.name(), 'RuleRenderer Klar')

                elif laySet[0] == 'categorizedSymbol':
                    layer.renderer().deleteCategory(laySet[1])
                    iface.layerTreeView().refreshLayerSymbology(layer.id())
                    layer.triggerRepaint()
                    # print(layer.name(), 'categorizedSymbol Borta')
            else:
                pass

        return print('Stängt av "Alla andra värden - Timeslide"')
    
    def unActivateTemporalController(self):
        iface.mapCanvas().temporalController().setNavigationMode(0)
        pass

    def temporalLayerOn(self):


        layers = QgsProject.instance().mapLayers().values()
        for layer in layers:

            try:
                if layer.type() == QgsMapLayer.VectorLayer and 'datumtid_start' in layer.fields().names() and layer.temporalProperties().isActive() == False:

                    propMode = QgsVectorLayerTemporalProperties.ModeFeatureDateTimeStartAndEndFromFields

                    propLayer = layer.temporalProperties()
                    propLayer.setStartField('datumtid_start')
                    propLayer.setEndField('datumtid_slut')
                    propLayer.setMode(propMode)
                    propLayer.setAccumulateFeatures(True)
                    propLayer.setIsActive(True)
                    iface.layerTreeView().refreshLayerSymbology(layer.id())

            except:

                pass


    def temporalLayerOff(self):

        layers = QgsProject.instance().mapLayers().values()
        for layer in layers:

            try:
                if layer.type() == QgsMapLayer.VectorLayer and 'datumtid_start' in layer.fields().names() and layer.temporalProperties().isActive() == True:

                    propLayer = layer.temporalProperties()

                    propLayer.setIsActive(False)
                    iface.layerTreeView().refreshLayerSymbology(layer.id())

            except:

                pass



            
    #open an existing project
    def run_open_project(self):
        filename3, _filter = QFileDialog.getOpenFileName(
            self.dlg, "Select   output file ","", 'All files (*.*)', str(QgsProject.instance().homePath()))
        print(type(Path(filename3)))
        project = QgsProject.instance()
        project.read(filename3)
        self.getProjectVars()



    def open_pushButton_toolbar(self):
        self.act1 = QAction(QIcon(':/plugins/Brand_Gis/mask.png'), QCoreApplication.translate('BrandGis tool', 'Maskera och avmaskera symboler.\n\n-Används ex med när man har ett ortofoto som bakgrund'), self.iface.mainWindow(),triggered=self.toggleMask)
        self.act2 = QAction(QIcon(':/plugins/Brand_Gis/Brandgis_icon_allaAv.png'), QCoreApplication.translate('BrandGis tool', 'Visa bara aktuell symbologi.\nTar bort symbol som visar alla andra värden.\n\n-Kan användas tillsammans med tidskontroll'), self.iface.mainWindow(),triggered=self.hideAllFeatures)
        self.act3 = QAction(QIcon(':/plugins/Brand_Gis/Brandgis_icon_allaPa.png'), QCoreApplication.translate('BrandGis tool', 'Visa all symbologi.\nLägger till en "aktuell" symbol som visar alla andra värden.\n\n-Kan användas tillsammans med tidskontroll'), self.iface.mainWindow(),triggered=self.viewAllFeatures)
        self.act4 = QAction(QIcon(':/plugins/Brand_Gis/Brandgis_icon_tidPa.png'), QCoreApplication.translate('BrandGis tool', 'Lägger till tidsstyrning i lagerdefenitionen\nOm lagret har attributfältet "Giltig från" så används fälten "Giltig från" och "Giltig till" för tidssyrning.\n\n-Användas tillsammans med tidskontroll\n-Använd knappen "Visa" för att visa alla objekt. Finns det ingen symbol för attributet visas inte objektet.'), self.iface.mainWindow(),triggered=self.temporalLayerOn)
        self.act5 = QAction(QIcon(':/plugins/Brand_Gis/Brandgis_icon_tidOff.png'), QCoreApplication.translate('BrandGis tool', 'Tar bort tidsstyrning i lagerdefenitionen\nOm lagret har attributfältet "Giltig från" så används fälten "Giltig från" och "Giltig till" för tidssyrning.\n\n-Användas tillsammans med tidskontroll\n-Använd knappen "Stäng" för att stänga alla visade objekt. Se till att stänga av tidskontrollen så den är inaktiverad'), self.iface.mainWindow(),triggered=self.temporalLayerOff)
        self.act6 = QAction(QIcon(':/plugins/Brand_Gis/Brandgis_icon_inaktiveraTimeController.png'), QCoreApplication.translate('BrandGis tool', 'Inaktiverar Tidskontrollen\n\n -Om Tidskontrollen inte är inaktiverad så visas inte objekt utanför den aktuella tiden.\n -Funktionen finns i Tidskontrollen och heter "Stäng av tidsnavigering"'), self.iface.mainWindow(),triggered=self.unActivateTemporalController)
       

       
        #adds tools to the toolbar BrandGis-Toolbar.
        self.add_brandtoolbar = self.iface.addToolBar('BrandGis-Toolbar')
        self.add_brandtoolbar.setObjectName('BrandGis-Toolbar')
        self.add_brandtoolbar.addAction(iface.actionPan())
        self.add_brandtoolbar.addSeparator()
        self.add_brandtoolbar.addAction(iface.actionSaveEdits())
        self.add_brandtoolbar.addAction(iface.actionCopyFeatures())
        self.add_brandtoolbar.addSeparator()
        self.add_brandtoolbar.addAction(iface.actionMeasure())
        self.add_brandtoolbar.addAction(iface.actionMeasureArea())
        self.add_brandtoolbar.addSeparator()
        self.add_brandtoolbar.addAction(iface.actionToggleEditing())
        self.add_brandtoolbar.addAction(iface.actionIdentify())
        self.add_brandtoolbar.addAction(iface.actionAddFeature())
        self.add_brandtoolbar.addAction(iface.actionMoveFeature())
        self.add_brandtoolbar.addAction(iface.actionOpenTable())
        self.add_brandtoolbar.addSeparator()
        self.add_brandtoolbar.addAction(iface.actionSaveActiveLayerEdits())
        self.add_brandtoolbar.addAction(iface.actionCancelEdits())
        self.add_brandtoolbar.addSeparator()
        self.add_brandtoolbar.addAction(iface.actionSaveAllEdits())
        self.add_brandtoolbar.addAction(iface.actionCancelAllEdits())
        self.add_brandtoolbar.addSeparator()
        self.add_brandtoolbar.addAction(iface.actionSaveMapAsImage())
        self.add_brandtoolbar.addAction(iface.actionShowLayoutManager())
        self.add_brandtoolbar.addAction(iface.actionSelect())
        self.add_brandtoolbar.addSeparator()
        self.add_brandtoolbar.addSeparator()
        self.add_brandtoolbar.addAction(iface.actionDeleteSelected())
        self.add_brandtoolbar.addSeparator()
        self.add_brandtoolbar.addSeparator()
        self.add_brandtoolbar.addAction(self.act1)
        self.add_brandtoolbar.addSeparator()
        self.add_brandtoolbar.addSeparator()
        self.add_brandtoolbar.addAction(self.act2)
        self.add_brandtoolbar.addAction(self.act3)
        self.add_brandtoolbar.addSeparator()
        self.add_brandtoolbar.addAction(self.act4)
        self.add_brandtoolbar.addAction(self.act5)
        self.add_brandtoolbar.addSeparator()
        self.add_brandtoolbar.addAction(self.act6)
        self.add_brandtoolbar.addSeparator()
        self.add_brandtoolbar.addSeparator()

        # self.iface.messageBar().pushMessage('Info: ','BrandGis-Toolbar öppnad', level=Qgis.Info, duration=6)

    def latlontoolsDep(self):
        if 'latlontools' in utils.active_plugins:
            self.iface.messageBar().pushMessage('Info: ','Lat Lon Tools finns installerat, det kan användas för att hitta koordinater och är ett krav för att MGRS i layouter ska fungera.  Bra jobbat!', level=Qgis.Info, duration=6)
        else:
            QMessageBox.warning(None,'Plugin saknas','Lat Lon Tools måste installeras för att MGRS ska redovisas i layouter!\n- I menyn, öppna Plugins. Sök efter Lat Lon Tools och installera.\n- Den finns också att installera från Zip i BrandGis paketet.')
            self.iface.messageBar().pushMessage('Plugin saknas','Lat Lon Tools måste installeras för att MGRS ska redovisas i layouter!\n- I menyn, öppna Plugins. Sök efter Lat Lon Tools och installera.\n- Den finns också att installera från Zip i BrandGis paketet.', level=Qgis.Critical, duration=30)
            

        

    def del_pushButton_toolbar(self):
        #deletes the toolbar BrandGis-Toolbar
        self.add_brandtoolbar = iface.addToolBar('BrandGis-Toolbar')
        self.add_brandtoolbar.deleteLater()
        self.iface.messageBar().pushMessage('Info: ','BrandGis-Toolbar stängd', level=Qgis.Info, duration=6)

    def exp_pdf(self):
        self.dlg1.close()
        projectInstance = QgsProject.instance()
        #timestamp to pdf filename
        now = datetime.now()
        dateTimeObj = now.strftime("%y%m%d-%H%M")
        
        
        file_pdf_layoutName = str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_handelse_name'))
        file_pdf_path = '/'+file_pdf_layoutName+'-'+dateTimeObj+'-'+self.dlg1.comboBoxLayouts.currentText()
        file_pdf_path_check = file_pdf_path.replace(':','_').replace(' ','_').replace('.','_')
        file_pdf = self.dlg1.lineEditExpFold.text()+file_pdf_path_check+'.pdf' #Selectedpath,layoutname and time of exported PDF
        # print(file_pdf)
        file_folder_pdf = self.dlg1.lineEditExpFold.text()  #text from the selected folderpath
        layout_pdf = self.dlg1.comboBoxLayouts.currentText()    #the selected Layput from the project

        
        layoutmanager = projectInstance.layoutManager()
        layout = layoutmanager.layoutByName(layout_pdf)
        map = layout.itemById('Karta1')

        if self.dlg1.checkBoxcanvascenter.isChecked():
            b_old_extent = map.extent()
            b_extx = iface.mapCanvas().extent()
            b_mapscale = round(map.scale())
            # print(b_mapscale)
            map.zoomToExtent(b_extx)
            map.setScale(b_mapscale)
            exporter_pdf = QgsLayoutExporter(layout)
            layout.refresh()
            exporter_pdf.exportToPdf(file_pdf, QgsLayoutExporter.PdfExportSettings())
            
            QgsExpressionContextUtils.setProjectVariable(projectInstance, 'B_pdf_exp_folder',file_folder_pdf)
            #self.iface.messageBar().pushMessage("Info: ",'Exporterad till '+file_pdf, level=Qgis.Info, duration=10)
            wind = self.dlg1.lineEdit_layout_vind.text()
            QgsExpressionContextUtils.setProjectVariable(projectInstance, 'B_wind',wind)
            map.setExtent(b_old_extent) # Lägger tillbaka den ursprungliga utbredningen. 
            layout.refresh()
        else:
            exporter_pdf = QgsLayoutExporter(layout)
            layout.refresh()
            exporter_pdf.exportToPdf(file_pdf, QgsLayoutExporter.PdfExportSettings())
            QgsExpressionContextUtils.setProjectVariable(projectInstance, 'B_pdf_exp_folder',file_folder_pdf)
            #self.iface.messageBar().pushMessage("Info: ",'Exporterad till '+file_pdf, level=Qgis.Info, duration=10)
            wind = self.dlg1.lineEdit_layout_vind.text()
            QgsExpressionContextUtils.setProjectVariable(projectInstance, 'B_wind',wind)
            # print('no check')

        if self.dlg1.checkBoxcanvasLOpenPdf.isChecked():
            b_filepath=Path(file_pdf)
            if platform.system() == 'Darwin':       # macOS
                subprocess.call(('open', b_filepath))
            elif platform.system() == 'Windows':    # Windows
                os.startfile(b_filepath)
            else:                                   # linux variants
                subprocess.call(('xdg-open', b_filepath))

            # print('check')
        else:
            pass    

        #Logging of pdf exports to the projects folder as CSV      

        now = datetime.now()

        b_logg_user = os.getlogin()

        b_logg_date = now.strftime('%y-%m-%d')
        b_logg_time = now.strftime('%H:%M')

        b_project_path = QgsProject.instance().homePath()
        b_logg_filename = '/brandgis_1_resurser/resurser_qgis/automatlogg_pdf/projektdata_loggbook.csv'
        b_logg_filePath = Path(b_project_path+b_logg_filename)
        b_logg_filePathString = str(b_logg_filePath)

        
        if b_logg_filePath.is_file():

            b_loggFile = open(b_logg_filePath,'a+', encoding='UTF-16 LE')
            b_loggFile.write(file_pdf_layoutName+'_'+layout_pdf+';'+b_logg_user+';'+'Ange beställare'+';'+file_pdf+';'+b_logg_date+';'+b_logg_time+'\n')      
            
        else:

            b_loggFile = open(b_logg_filePath,'a+', encoding='UTF-16 LE')
            b_loggFile.write('Produkt'+';'+'Utförare'+';'+'Beställare'+';'+'Länk till PDF'+';'+'Datum'+';'+'Tid'+';'+'\n')
            b_loggFile.write(file_pdf_layoutName+'_'+layout_pdf+';'+b_logg_user+';'+'Ange beställare'+';'+file_pdf+';'+b_logg_date+';'+b_logg_time+'\n')  

        b_loggFile.close()
        self.iface.messageBar().pushMessage('Info: ','PDF exporterad till: '+file_pdf+'\n'+'Har skrivit in i loggboken: '+b_project_path, level=Qgis.Info, duration=10)

    def exp_pdf_folder(self):
        filename_exppdf = QFileDialog.getExistingDirectory(self.dlg1, 'Välj mapp', QgsProject.instance().homePath())
        self.dlg1.lineEditExpFold.setText(filename_exppdf)

    def text_pushButtonSourceFile(self): 
        
        textSourceFilename, _filter = QFileDialog.getOpenFileName(self.dlg2, "Välj importfil ","", 'Alla filer (*.*)', str(QgsProject.instance().homePath()))
        self.dlg2.lineEditSourceFile.setText(textSourceFilename)

    def text_pushButtonImportFile(self): 
        if self.dlg2.checkBoxArcgis.isChecked():
            textImportFilename = QFileDialog.getExistingDirectory(self.dlg2,'Välj gdb, den visas som en mapp ex. mapp.gdb', QgsProject.instance().homePath())

        else:
            textImportFilename, _filter = QFileDialog.getOpenFileName(self.dlg2, "Välj importfil ","", 'Alla filer (*.*)', str(QgsProject.instance().homePath()))

        self.dlg2.lineEditImportFile.setText((textImportFilename))
        

    def text_pushButtonBackupFile(self): 
        
        textBackupFolder = QFileDialog.getExistingDirectory(self.dlg2,'Välj mapp', QgsProject.instance().homePath())
        self.dlg2.lineEditBackupFolder.setText(textBackupFolder)
    
    def importData(self):

        dt = datetime.now()
        dt_string = str(dt.strftime("%m%d%H%M-%S"))
        fileNameSource = Path(self.dlg2.lineEditSourceFile.text())
        fileNameImport = Path(self.dlg2.lineEditImportFile.text())
        backupFolder = Path(self.dlg2.lineEditBackupFolder.text())
        

        if Path.is_dir(backupFolder):

                if fileNameSource.parent == backupFolder:
                    QMessageBox.warning(None,'Fel:','Backup kan inte sparas till samma mapp som källfilen')
                    return

                else:

                    backupFileName = PurePath(fileNameSource).name

                    backupFileNewName = PurePath(dt_string+str(backupFileName))

                    try:
                        Path.mkdir(backupFolder)
                    except: 
                        pass

                    shutil.copy(fileNameSource, backupFolder)

                    # print(PurePath.joinpath(backupFolder, backupFileName))
                    # print(PurePath.joinpath(backupFolder, backupFileNewName))
                    Path.rename(PurePath.joinpath(backupFolder, backupFileName),PurePath.joinpath(backupFolder, backupFileNewName))

            

        ds = gdal.VectorTranslate(
            str(fileNameSource), str(fileNameImport),
            accessMode='append'
        )

        self.iface.messageBar().pushMessage('Info: ','Importen till '+str(fileNameSource)+' klar', level=Qgis.Info, duration=10)
        iface.mapCanvas().refresh()

    def changeHandelseid(self):
        self.dlg.close()

        QgsProject.instance().reloadAllLayers()

        handelseId = self.dlg.lineEdit_handelse_id.text()
        layerstateList = []
        '''listDict 0layer, 1har blivit ändrad sedan senaste spara, 2antal objekt i lagret.'''
        status = 1
        for bgLayerHandelseId in QgsProject.instance().mapLayers().values():
            if bgLayerHandelseId.type() == QgsMapLayer.VectorLayer and 'handelse_id' in bgLayerHandelseId.fields().names():
                layerstateList.append([bgLayerHandelseId,bgLayerHandelseId.isModified(),bgLayerHandelseId.featureCount()])
                
        print('skapad :', len(layerstateList))

        for checkLayerState in layerstateList:
            if checkLayerState[1] == True:
                QMessageBox.warning(self.iface.mainWindow(), 'Information','Lager får inte ha osparade data, spara dina editeringar och testa igen!', QMessageBox.Ok)
                status = 0
                break
        print('status: ',status)

        for layerState in layerstateList:
            '''Hämtar lager som har objekt och status visar att det inte finns osparade objekt, funktionen fungerar inte om något lager står i editerings läge
            , rollBack gör att vi stänger lagrets editering men statusen visar att inget gjorts sedan senaste sparningen'''
            if layerState[2] > 0 and status == 1:
                features = QgsProject.instance().mapLayersByName(layerState[0].name())
                features[0].rollBack()

                for feature in features[0].getFeatures():
                    '''Uppdaterar händelse id'''
                    with edit(features[0]):
                        feature['handelse_id'] = handelseId
                        features[0].updateFeature(feature)
                        print('Uppdaterar ',features[0],feature)

                self.iface.messageBar().pushMessage('Info','Uppdatering av Händelse ID klar', level=Qgis.Info, duration=6)

        pass


    def set_wind(self):
        wind = self.dlg1.lineEdit_layout_vind.text()
        wind_dir = self.dlg1.comboBoxwindDir.currentText()
        projectInstance = QgsProject.instance()
        QgsExpressionContextUtils.setProjectVariable(projectInstance, 'B_vinddir',wind_dir)
        QgsExpressionContextUtils.setProjectVariable(projectInstance, 'B_wind',wind)
        self.iface.messageBar().pushMessage('Info: ','Projekt variabler för vind tillagda', level=Qgis.Info, duration=3)

    def toggleMask(self):
        projectInstance = QgsProject.instance()
        if QgsExpressionContextUtils.projectScope(projectInstance).variable('B_maska_symoler') == 'ja':
            QgsExpressionContextUtils.setProjectVariable(projectInstance, 'B_maska_symoler','nej')
            iface.mapCanvas().refreshAllLayers()
            self.iface.messageBar().pushMessage('Info: ','Nu är det ingen maskning av symboler', level=Qgis.Info, duration=3)
        else:
            QgsExpressionContextUtils.setProjectVariable(projectInstance, 'B_maska_symoler','ja')
            iface.mapCanvas().refreshAllLayers()
            self.iface.messageBar().pushMessage('Info: ','Nu är vissa symboler maskade', level=Qgis.Info, duration=3)

    def getProjectVars(self):
        projectInstance = QgsProject.instance()
        # self.dlg.lineEdit_handelse_name.setText(str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_handelse_name')))
        # self.dlg.lineEdit_handelse_ID.setText(str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_handelse_ID')))
        # self.dlg.lineEdit_kommun.setText(str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_kommunnamn')))
        # self.dlg.lineEdit_ort.setText(str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_ort')))
        # self.dlg.lineEdit_plats.setText(str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_plats_namn')))
        # self.dlg.lineEditLogo.setText(str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_sokvag_logga')))
        # self.dlg.lineEdit_copyright.setText(str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_bak_copyright')))
        # self.dlg.lineEdit_Organisation.setText(str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_organisation')))
        # self.dlg.lineEdit_OrganisationMail.setText(str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_organisation_mail')))
        # self.dlg.lineEdit_OrganisationTele.setText(str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_organisation_tele')))

        if QgsExpressionContextUtils.projectScope(projectInstance).variable('B_handelse_name') is None or str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_handelse_name')) == 'NULL' or str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_handelse_name')) == '':
            self.dlg.lineEdit_handelse_name.setText('')
        else:
            self.dlg.lineEdit_handelse_name.setText(str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_handelse_name')))
            
        if QgsExpressionContextUtils.projectScope(projectInstance).variable('B_handelse_ID') is None or str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_handelse_ID')) == 'NULL' or str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_handelse_ID')) == '':
            self.dlg.lineEdit_handelse_ID.setText('')
        else:
            self.dlg.lineEdit_handelse_ID.setText(str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_handelse_ID')))
            
        if QgsExpressionContextUtils.projectScope(projectInstance).variable('B_kommunnamn') is None or str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_kommunnamn')) == 'NULL' or str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_kommunnamn')) == '':
            self.dlg.lineEdit_kommun.setText('')
        else:
            self.dlg.lineEdit_kommun.setText(str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_kommunnamn')))
            
        if QgsExpressionContextUtils.projectScope(projectInstance).variable('B_ort') is None or str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_ort')) == 'NULL' or str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_ort')) == '':
            self.dlg.lineEdit_ort.setText('')
        else:
            self.dlg.lineEdit_ort.setText(str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_ort')))
            
        if QgsExpressionContextUtils.projectScope(projectInstance).variable('B_plats_namn') is None or str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_plats_namn')) == 'NULL' or str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_plats_namn')) == '':
            self.dlg.lineEdit_plats.setText('')
        else:
            self.dlg.lineEdit_plats.setText(str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_plats_namn')))
            
        if QgsExpressionContextUtils.projectScope(projectInstance).variable('B_sokvag_logga') is None or str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_sokvag_logga')) == 'NULL' or str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_sokvag_logga')) == '':
            self.dlg.lineEditLogo.setText('')
        else:
            self.dlg.lineEditLogo.setText(str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_sokvag_logga')))
            
        if QgsExpressionContextUtils.projectScope(projectInstance).variable('B_bak_copyright') is None or str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_bak_copyright')) == 'NULL' or str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_bak_copyright')) == '':
            self.dlg.lineEdit_copyright.setText('')
        else:
            self.dlg.lineEdit_copyright.setText(str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_bak_copyright')))
            
        if QgsExpressionContextUtils.projectScope(projectInstance).variable('B_organisation') is None or str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_organisation')) == 'NULL' or str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_organisation')) == '':
            self.dlg.lineEdit_Organisation.setText('')
        else:
            self.dlg.lineEdit_Organisation.setText(str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_organisation')))
            
        if QgsExpressionContextUtils.projectScope(projectInstance).variable('B_organisation_mail') is None or str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_organisation_mail')) == 'NULL' or str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_organisation_mail')) == '':
            self.dlg.lineEdit_OrganisationMail.setText('')
        else:
            self.dlg.lineEdit_OrganisationMail.setText(str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_organisation_mail')))
            
        if QgsExpressionContextUtils.projectScope(projectInstance).variable('B_organisation_tele') is None or str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_organisation_tele')) == 'NULL' or str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_organisation_tele')) == '':
            self.dlg.lineEdit_OrganisationTele.setText('')
        else:
            self.dlg.lineEdit_OrganisationTele.setText(str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_organisation_tele')))

    def getPrintProjVars(self):
        projectInstance = QgsProject.instance()
        if QgsExpressionContextUtils.projectScope(projectInstance).variable('B_pdf_exp_folder') is None or str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_pdf_exp_folder')) == 'NULL' or str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_pdf_exp_folder')) == '':
            self.dlg1.lineEditExpFold.setText('')
        else:
            self.dlg1.lineEditExpFold.setText(str(QgsExpressionContextUtils.projectScope(projectInstance).variable('B_pdf_exp_folder')))
            

    def run2(self):
        self.dlg1 = BrandGisPrintDialog()
        self.dlg1.lineEditExpFold.setText(str(QgsProject.instance().homePath())+'/brandgis_3_export')
        manager = QgsProject.instance().layoutManager()
        layouts = manager.printLayouts()
        projectInstance = QgsProject.instance()
        layouter=[]
        for layout in layouts:
            layouter.append(layout.name())
        
        
         # Fetch the currently loaded layers
        
        # Clear the contents of the comboBox from previous runs
        self.dlg1.setWindowFlags(QtCore.Qt.WindowStaysOnTopHint)
        self.dlg1.comboBoxLayouts.clear()
        
        # '''Kan användas för att komma ihåg tidigare sparat vind info'''

        # vindValueSting = QgsExpressionContextUtils.projectScope(projectInstance).variable('B_wind')
        # if len(vindValueSting) > 1:
        #     vindValue = vindValueSting.split()
        #     self.dlg1.lineEdit_layout_vind.setValue(int(vindValue[0]))
        # else:
        #     self.dlg1.lineEdit_layout_vind.setValue(0)

        
        # Populate the comboBox with names of all the loaded layers
        self.dlg1.comboBoxLayouts.addItems(layouter)    #List of layouts in the project to the GUI comboBox list.
        self.dlg1.comboBoxLayouts.setCurrentIndex(2)
        self.dlg1.pushButtonPdf.clicked.connect(self.exp_pdf)
        self.dlg1.pushButtonExpFold.clicked.connect(self.exp_pdf_folder)
        self.dlg1.pushButtonWind.clicked.connect(self.set_wind)        
        self.dlg1.toolButton_maskSymbolOnOff.clicked.connect(self.toggleMask)    
        
        self.latlontoolsDep()
        # show the dialog
        self.dlg1.show()



    def run3(self):
        self.dlg2 = BrandGisImportDialog()
        self.dlg.setWindowFlags(QtCore.Qt.WindowStaysOnTopHint)
        self.dlg2.pushButtonSourceFile.clicked.connect(self.text_pushButtonSourceFile)
        self.dlg2.pushButtonImportFile.clicked.connect(self.text_pushButtonImportFile)
        self.dlg2.pushButtonBackupFolder.clicked.connect(self.text_pushButtonBackupFile)
        self.dlg2.pushButtonImport.clicked.connect(self.importData)
      


        # show the dialog
        self.dlg2.show()

     

    def run(self):
        """Run method that performs all the real work"""

                                                          # Use if project variables shuld be imported to dialog when open.
            
        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = BrandGisDialog()
            self.dlg.setWindowFlags(QtCore.Qt.WindowStaysOnTopHint)
            # self.getProjectVars() 
            self.open_pushButton_toolbar()
            self.dlg.pushButtonLogo.clicked.connect(self.select_output_logo)
            self.dlg.pushButton_getProjectVars.clicked.connect(self.getProjectVars)
            #self.dlg.pushButtonProject.clicked.connect(self.select_output_project)     #Used in the first GUI, when a Qgis project was included in the plugin
            #self.dlg.pushButtonOpen.clicked.connect(self.run_output_project)           #Used in the first GUI, when a Qgis project was included in the plugin
            self.dlg.pushButton_toolbar_del.clicked.connect(self.del_pushButton_toolbar)
            self.dlg.pushButton_toolbar.clicked.connect(self.open_pushButton_toolbar)
            self.dlg.pushButtonOpen_proj.clicked.connect(self.run_open_project)
            # self.dlg.pushButton_showAllFeatures.clicked.connect(self.viewAllFeatures)
            # self.dlg.pushButton_unShowAllFeatures.clicked.connect(self.hideAllFeatures)

            self.dlg.pushButton_update_handelseid.clicked.connect(self.changeHandelseid)

        self.latlontoolsDep()
            

        

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed

        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            
            handelse_name = self.dlg.lineEdit_handelse_name.text()
            handelse_ID = self.dlg.lineEdit_handelse_ID.text()
            kommun = self.dlg.lineEdit_kommun.text()
            orts_namn = self.dlg.lineEdit_ort.text()
            plats = self.dlg.lineEdit_plats.text()
            bak_copyright = self.dlg.lineEdit_copyright.text()
            sokvag_logga = self.dlg.lineEditLogo.text()
            organisation = self.dlg.lineEdit_Organisation.text()
            organisation_mail = self.dlg.lineEdit_OrganisationMail.text()
            organisation_tele = self.dlg.lineEdit_OrganisationTele.text()


            
            #Use this to set the Variable
            projectInstance = QgsProject.instance()
            QgsExpressionContextUtils.setProjectVariable(projectInstance, 'B_handelse_name',handelse_name)
            QgsExpressionContextUtils.setProjectVariable(projectInstance, 'B_handelse_ID',handelse_ID)
            QgsExpressionContextUtils.setProjectVariable(projectInstance, 'B_organisation',organisation)
            QgsExpressionContextUtils.setProjectVariable(projectInstance, 'B_kommunnamn',kommun)
            QgsExpressionContextUtils.setProjectVariable(projectInstance, 'B_ort',orts_namn)
            QgsExpressionContextUtils.setProjectVariable(projectInstance, 'B_plats_namn',plats)
            QgsExpressionContextUtils.setProjectVariable(projectInstance, 'B_bak_copyright',bak_copyright)
            QgsExpressionContextUtils.setProjectVariable(projectInstance, 'B_sokvag_logga',sokvag_logga)
            QgsExpressionContextUtils.setProjectVariable(projectInstance, 'B_organisation_mail',organisation_mail)
            QgsExpressionContextUtils.setProjectVariable(projectInstance, 'B_organisation_tele',organisation_tele)
            self.iface.messageBar().pushMessage('Info: ','Projekt variabler tillagda', level=Qgis.Info, duration=3)
