# -*- coding: utf-8 -*-
"""
/***************************************************************************
 BPEJRUIANSWATDialog
                                 A QGIS plugin
 Plugin stahuje a upravuje data BPEJ a upravuje data RÚIAN pro model SWAT
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2023-03-26
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Tomáš Hájek
        email                : tomas.hajek123@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import urllib.request
import re
import processing
import webbrowser

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from PyQt5.QtWidgets import QFileDialog, QMessageBox, QAction
from PyQt5.QtCore import QVariant
from qgis.core import edit, QgsProject, QgsVectorLayer, Qgis, QgsCoordinateReferenceSystem, QgsField, QgsExpressionContext, QgsExpression
from qgis.utils import iface

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'BPEJ_RUIAN_SWAT_dialog_base.ui'))


class BPEJRUIANSWATDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(BPEJRUIANSWATDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        self.pbclipBPEJ.clicked.connect(self.clip_bpej)
        self.pbLUparcely.clicked.connect(self.lu_parcely)
        self.pbdownloadBPEJ.clicked.connect(self.download_bpej)
        self.pbCHMU.clicked.connect(self.html_chmu)

    def clip_bpej(self):
        # Let the user select input, output, and clip files using a file dialog
        input_file, _ = QFileDialog.getOpenFileName(None, "Select input file", "", "Shapefile (*.shp)")
        clip_file, _ = QFileDialog.getOpenFileName(None, "Select clip file", "", "Shapefile (*.shp)")
        output_file, _ = QFileDialog.getSaveFileName(None, "Select output file", "", "Shapefile (*.shp)")
        if not input_file or not clip_file or not output_file:
            QMessageBox.critical(None, "Error", "Nebyly správně vložené vstupní a výstupní vrstvy")
            return

        # Ensure the output directory exists
        output_dir = os.path.dirname(output_file)
        if not os.path.exists(output_dir):
            try:
                os.makedirs(output_dir)
            except Exception as e:
                QMessageBox.critical(None, "Error", f"Could not create output directory: {e}")
                return

        # Check if the directory is writable
        if not os.access(output_dir, os.W_OK):
            QMessageBox.critical(None, "Error", f"Output directory is not writable: {output_dir}")
            return

        # Delete the existing file if it exists
        if os.path.exists(output_file):
            try:
                os.remove(output_file)
            except Exception as e:
                QMessageBox.critical(None, "Error", f"Could not delete existing output file: {e}")
                return

        # Load input and clip layers
        layer = QgsVectorLayer(input_file, 'layer_name', 'ogr')
        if not layer.isValid():
            QMessageBox.critical(None, "Error", "Invalid input layer")
            return

        msg_box = QMessageBox()
        msg_box.setText('Právě se chystáte zahájit opravu geometriií u vstupního souboru?')
        msg_box.setStandardButtons(QMessageBox.Ok | QMessageBox.Cancel)
        result = msg_box.exec_()
        if result != QMessageBox.Ok:
            return

        output_file_name = os.path.splitext(os.path.basename(output_file))[0]

        # Run the fix geometries algorithm
        result = processing.run('native:fixgeometries', {
            'INPUT': layer,
            'OUTPUT': 'memory:'
        })
        fixed_layer = result['OUTPUT']
        clip_layer = QgsVectorLayer(clip_file, 'layer_name', 'ogr')
        if not clip_layer.isValid():
            QMessageBox.critical(None, "Error", "Invalid clip layer")
            return

        # Clip the fixed layer with the clip layer
        try:
            processing.run('native:clip', {
                'INPUT': fixed_layer,
                'OVERLAY': clip_layer,
                'OUTPUT': output_file,
            })
        except Exception as e:
            QMessageBox.critical(None, "Error", f"Error during clipping: {e}")
            return

        clipped_layer = QgsVectorLayer(output_file, output_file_name, "ogr")
        if not clipped_layer.isValid():
            QMessageBox.critical(None, "Error", "Clipped layer is not valid")
            return

        clipped_layer.startEditing()

        # Remove unnecessary fields
        field_names_to_keep = ['Kod_B5']
        fields = clipped_layer.fields()
        field_indices_to_remove = [i for i, field in enumerate(fields) if
                                   field.name() not in field_names_to_keep]
        clipped_layer.dataProvider().deleteAttributes(field_indices_to_remove)
        clipped_layer.updateFields()
        clipped_layer.commitChanges()

        # Create a new "No Data" layer from the clip file
        no_data_layer = QgsVectorLayer("Polygon?crs=" + clip_layer.crs().authid(), "No Data Layer", "memory")
        provider = no_data_layer.dataProvider()
        no_data_layer.updateFields()

        # Add geometries from the clip layer to the "No Data" layer
        clip_features = [feat for feat in clip_layer.getFeatures()]
        for clip_feat in clip_features:
            new_feat = QgsFeature(no_data_layer.fields())
            new_feat.setGeometry(clip_feat.geometry())
            provider.addFeature(new_feat)

        # Generate a unique output file name if inside a loop or just ensure uniqueness
        unique_output_file = f"{output_file_name}_{int(time.time())}.shp"

        # Merge Soil Layer and No Data Layer
        params = {
            'INPUT': QgsProcessingFeatureSourceDefinition(output_file),
            'OVERLAY': no_data_layer,
            'OUTPUT': unique_output_file,
        }
        processing.run("qgis:union", params, feedback=QgsProcessingFeedback())

        # Load the merged layer
        merged_layer = QgsVectorLayer(unique_output_file, "bpej_zajmove_uzemi", "ogr")

        if merged_layer.isValid():
            with edit(merged_layer):
                merged_layer.dataProvider().addAttributes([QgsField('HPJ_kod', QVariant.Int)])
                merged_layer.updateFields()

                for feature in merged_layer.getFeatures():
                    b5_value = feature['Kod_B5']
                    if b5_value is not None and isinstance(b5_value, str) and len(b5_value) >= 3:
                        hpj_kod_value = int(b5_value[1:3])
                        feature.setAttribute('HPJ_kod', hpj_kod_value)
                        merged_layer.updateFeature(feature)

            merged_layer.triggerRepaint()
            QgsProject.instance().addMapLayer(merged_layer)
            QMessageBox.information(None, "Gratuluji!", "Oprava, výřez a úprava dat úspěšně provedena.")
        else:
            QMessageBox.critical(None, "Error",
                                 "Oprava geometrií neproběhla nebo výřez neproběhli v pořádku, zkontrolujte vstupní data.")

    def lu_parcely(self):
        # set the path to the original shapefile
        input_path, _ = QFileDialog.getOpenFileName(None, "Select Input Shapefile", "", "Shapefiles (*.shp)")

        # load the shapefile into a QgsVectorLayer object
        layer = QgsVectorLayer(input_path, os.path.basename(input_path), 'ogr')
        if not layer.isValid():
            QMessageBox.critical(None, "Error", "Nepodařilo se nahrát vrstvu")
            return
        # get the current project instance
        project = QgsProject.instance()

        # add the layer to the project
        project.addMapLayer(layer)
        dialog = QFileDialog()
        dialog.setDefaultSuffix('.shp')
        dialog.setAcceptMode(QFileDialog.AcceptSave)
        dialog.setDirectory('.')
        dialog.setNameFilter('Shapefile (*.shp)')
        if dialog.exec_() == QFileDialog.Accepted:
            output_path = dialog.selectedFiles()[0]
        else:
            output_path = None
        if output_path is not None:
            layer = iface.activeLayer()  # Get the active layer
            if layer is not None:
                processing.runAndLoadResults("qgis:fieldcalculator", {
                    'INPUT': layer,
                    'FIELD_NAME': 'SWAT_LU_CO',
                    'FIELD_TYPE': 1,  # Set the data type to String
                    'FIELD_LENGTH': 2,
                    'FIELD_PRECISION': 0,
                    'FORMULA': "CASE WHEN \"ZpusobyVyu\" is '6' or \"ZpusobyVyu\" is '7' or \"ZpusobyVyu\" is '8' or \"ZpusobyVyu\" is '9' or \"ZpusobyVyu\" is '10' or \"ZpusobyVyu\" is '28' THEN 11 WHEN \"ZpusobyVyu\" is '12' or \"ZpusobyVyu\" is '13' or \"ZpusobyVyu\" is '23' or \"ZpusobyVyu\" is '26' THEN 21 WHEN \"ZpusobyVyu\" is '20' or \"ZpusobyVyu\" is '21' THEN 23 WHEN \"ZpusobyVyu\" is '25' THEN 25 WHEN \"ZpusobyVyu\" is '14' or \"ZpusobyVyu\" is '15' or \"ZpusobyVyu\" is '16' or \"ZpusobyVyu\" is '17' or \"ZpusobyVyu\" is '18' or \"ZpusobyVyu\" is '19' THEN 26 WHEN \"ZpusobyVyu\" is '24' THEN 33 WHEN \"ZpusobyVyu\" is '3' or \"ZpusobyVyu\" is '4' or \"ZpusobyVyu\" is '5' THEN 43 WHEN \"ZpusobyVyu\" is '1' or \"ZpusobyVyu\" is '2' THEN 61 WHEN \"ZpusobyVyu\" is '27' THEN 85 WHEN \"ZpusobyVyu\" is '11' THEN 92 WHEN \"DruhPozemk\" is '11' THEN 11 WHEN \"DruhPozemk\" is '5' or \"DruhPozemk\" is '13' or \"DruhPozemk\" is '14' THEN 21 WHEN \"DruhPozemk\" is '10' THEN 43 WHEN \"DruhPozemk\" is '3' or \"DruhPozemk\" is '4' or \"DruhPozemk\" is '6' THEN 61 WHEN \"DruhPozemk\" is '7' THEN 71 WHEN \"DruhPozemk\" is '2' THEN 85 END",
                    'OUTPUT': output_path
                })
                layer.updateFields()
                layer.commitChanges()

        QMessageBox.information(None, "Gratulace", "Vrstva je připravena k dalšímu zpracování")


    def download_bpej(self):
        # URL of the data
        url = "https://geoportal.spucr.cz/api/open-data/data/gis?format=shp&administrativniJednotka=1&typAdministrativniJednotky=1&datovaSada=1"

        # Make the GET request
        response = requests.get(url)

        # Check if the request was successful
        if response.status_code == 200:
            # Determine the downloads directory
            downloads_dir = os.path.join(os.path.expanduser("~"), "downloads")

            # Ensure the downloads directory exists
            if not os.path.exists(downloads_dir):
                os.makedirs(downloads_dir)

            # Save the content to a file in the downloads directory
            file_path = os.path.join(downloads_dir, "bpej.zip")
            with open(file_path, "wb") as file:
                file.write(response.content)
            print(f"Data downloaded and saved as {file_path}")
        else:
            print(f"Failed to download data. HTTP Status code: {response.status_code}")


    def html_chmu(self):
        url = "https://www.chmi.cz/historicka-data/pocasi/denni-data/Denni-data-dle-z.-123-1998-Sb#"
        webbrowser.open_new_tab(url)
