# -*- coding: utf-8 -*-
"""
/***************************************************************************
 blblcd
                                 A QGIS plugin
 按地区归属下载哔哩哔哩视频评论
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-12-11
        git sha              : $Format:%H$
        copyright            : (C) 2025 by WangShihan
        email                : wangshihan751@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
from qgis.core import Qgis, QgsAuthMethodConfig, QgsApplication


# Initialize Qt resources from file resources.py
from .resources import *
from .core.core import Worker, CMT, fetch_comments_count
from qgis.PyQt.QtWidgets import QFileDialog, QAction, QMessageBox
import csv
from datetime import datetime

# Import the code for the dialog
from .blblcd_dialog import blblcdDialog
import os.path

BLBLCD_COOKIE_KEY = 'BLBLCD_COOKIE'
BLBLCD_OUTPUT_DIR_KEY = 'BLBLCD_OUTPUT_DIR'


class blblcd:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir, 'i18n', 'blblcd_{}.qm'.format(locale)
        )

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&blblcd')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None
        self.settings = QSettings()
        self.th = None
        self.running = False
        self.auth_mgr = QgsApplication.authManager()

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('blblcd', message)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None,
    ):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(self.menu, action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/blblcd/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'按地区归属下载哔哩哔哩视频评论'),
            callback=self.run,
            parent=self.iface.mainWindow(),
        )

        self.first_start = True

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(self.tr(u'&blblcd'), action)
            self.iface.removeToolBarIcon(action)

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = blblcdDialog()
            # 绑定信号
            self.dlg.btn_start.clicked.connect(self.on_start)
            self.dlg.btn_cookie_save.clicked.connect(self.on_cookie_save)
            self.dlg.btn_cookie_clear.clicked.connect(self.on_cookie_clear)
            self.dlg.btn_output_dir.clicked.connect(self.on_btn_output_dir_select)

            c = self.get_cookies(self.settings.value(BLBLCD_COOKIE_KEY, ''))
            self.dlg.te_cookie.setPlainText(c)
            self.dlg.pb.setMaximum(100)
            self.dlg.le_output_dir.setText(
                self.settings.value(BLBLCD_OUTPUT_DIR_KEY, '')
            )

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass

    def set_step(self, step: int):
        self.dlg.pb.setValue(step)

    def on_finished(self, data: list[CMT]):
        self.running = False
        self.dlg.btn_start.setEnabled(True)
        self.dlg.pb.setValue(0)

        # 导出CSV功能
        self.export_to_csv(data)

        self.set_tip('下载完成', True)
        self.th = None

    def set_tip(self, tip: str, isSuccess: bool):
        if isSuccess:
            responseType = Qgis.Success
        else:
            responseType = Qgis.Warning
        self.iface.messageBar().pushMessage(self.tr(tip), responseType)

    def on_start(self):
        if self.running:
            self.set_tip('运行中……', False)
            return

        bvid = self.dlg.le_bvid.text()
        if not bvid or bvid == '':
            self.set_tip('请输入bvid', False)
            return
        cookie = self.read_cookie()
        if cookie == '':
            self.set_tip('请设置cookie', False)
            return
        if self.settings.value(BLBLCD_OUTPUT_DIR_KEY, '') == '':
            self.set_tip('请设置输出目录', False)
            return

        self.running = True
        self.dlg.btn_start.setEnabled(not self.running)

        self.th = Worker(bvid, cookie)
        self.th.step_signal.connect(self.set_step)
        self.th.finished_signal.connect(self.on_finished)
        self.th.start()

    def on_cookie_clear(self):
        config_id = self.settings.value(BLBLCD_COOKIE_KEY, None)
        if config_id:
            self.delete_cookies(config_id)
            self.settings.setValue(BLBLCD_COOKIE_KEY, '')
            self.set_tip('清空成功', True)
            self.update_cookie_input()
        else:
            pass

    def on_cookie_save(self):
        c = self.dlg.te_cookie.toPlainText()
        if c == '':
            self.set_tip('cookie不能为空', False)
            return
        else:
            config_id = self.settings.value(BLBLCD_COOKIE_KEY, None)
            # 更新
            if config_id:
                if self.update_cookies(config_id, c):
                    self.set_tip('更新成功', True)
                    self.update_cookie_input()
                else:
                    self.set_tip('更新失败', False)
            # 新建
            else:
                config_id = self.store_cookies('blblcd', c)
                if config_id is not None:
                    self.settings.setValue(BLBLCD_COOKIE_KEY, config_id)
                    self.set_tip('保存成功', True)
                    self.update_cookie_input()
                else:
                    self.set_tip('保存失败', False)

    def on_btn_output_dir_select(self):
        """
        选择目录
        """
        try:
            directory = QFileDialog.getExistingDirectory(
                self.iface.mainWindow(), "选择目录"
            )
            if directory:
                self.settings.setValue(BLBLCD_OUTPUT_DIR_KEY, directory)
                self.dlg.le_output_dir.setText(directory)
        except Exception as e:
            pass

    def export_to_csv(self, data: list[CMT]):
        """
        将评论数据导出为CSV文件

        Args:
            data: 评论数据列表
        """
        if not data:
            return

        # 获取输出目录
        output_dir = self.dlg.le_output_dir.text()
        if not output_dir:
            self.set_tip('未选择输出目录', False)
            return

        # 检查目录是否存在
        if not os.path.exists(output_dir):
            try:
                os.makedirs(output_dir)
            except Exception as e:
                self.set_tip(f'创建目录失败: {str(e)}', False)
                return

        # 使用CMT类属性作为CSV字段
        # 获取所有属性名排除内建属性
        cmt = data[0]
        fieldnames = []

        for attr in dir(cmt):
            if not attr.startswith('_') and not callable(getattr(cmt, attr)):
                fieldnames.append(attr)

        # 生成文件名
        bvid = self.dlg.le_bvid.text()
        timestamp = datetime.now().strftime('%Y%m%d_%H%M%S')
        filename = f'bilibili_comments_{bvid}_{timestamp}.csv'
        filepath = os.path.join(output_dir, filename)

        # 写入CSV文件
        try:
            with open(filepath, 'w', newline='', encoding='utf-8') as csvfile:
                writer = csv.DictWriter(csvfile, fieldnames=fieldnames)

                # 写入表头
                writer.writeheader()

                # 写入数据
                for cmt in data:
                    row = {}
                    for field in fieldnames:
                        row[field] = getattr(cmt, field, '')
                    writer.writerow(row)
            self.iface.messageBar().pushMessage(
                self.tr(f'评论已导出: {filename}'), Qgis.Success
            )

        except Exception as e:
            self.set_tip(f'导出CSV失败: {str(e)}', False)

    def store_cookies(self, config_name: str, cookie: str):
        config = QgsAuthMethodConfig()
        config.setName(config_name)
        config.setMethod('Basic')  # 使用 Basic 方法作为容器

        # 将 Cookie 序列化为 JSON 字符串存储
        config.setConfig('cookies', cookie)

        # 保存配置
        if self.auth_mgr.storeAuthenticationConfig(config):
            return config.id()
        return None

    def get_cookies(self, config_id):
        """
        获取 Cookie
        :param config_id: 配置 ID
        :return: Cookie 字典
        """
        config = QgsAuthMethodConfig()
        if self.auth_mgr.loadAuthenticationConfig(config_id, config, True):
            cookies_json = config.config('cookies')
            if cookies_json:
                return cookies_json
        return ''

    def update_cookies(self, config_id, cookie_str: str):
        """
        更新 Cookie
        :param config_id: 配置 ID
        :param cookie_str: 新的 Cookie
        :return: 是否成功
        """
        config = QgsAuthMethodConfig()
        if self.auth_mgr.loadAuthenticationConfig(config_id, config, True):
            config.setConfig('cookies', cookie_str)
            return self.auth_mgr.updateAuthenticationConfig(config)
        return False

    def delete_cookies(self, config_id):
        """
        删除 Cookie 配置
        :param config_id: 配置 ID
        :return: 是否成功
        """
        return self.auth_mgr.removeAuthenticationConfig(config_id)

    def update_cookie_input(self):
        try:
            c = self.read_cookie()
            self.dlg.te_cookie.setPlainText(c)
        except Exception as e:
            pass
            # print(e)

    def read_cookie(self) -> str:
        config_id = self.settings.value(BLBLCD_COOKIE_KEY, None)
        if config_id:
            return self.get_cookies(config_id)
        else:
            return ''
