from qgis.core import QgsProcessingProvider, QgsApplication
from qgis.PyQt.QtGui import QIcon
import os

class BibliometrikSLRGapFinderPatchedProvider(QgsProcessingProvider):
    def __init__(self, iface=None):
        super().__init__()
        self.iface = iface

    def initGui(self):
        QgsApplication.processingRegistry().addProvider(self)

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self)

    def id(self):
        return 'bibliometrik_slr_gapfinder_plus_heatmaps'

    def name(self):
        return self.tr('Bibliometric Analysis')

    def icon(self):
        path = os.path.join(os.path.dirname(__file__), 'icon.png')
        return QIcon(path)

    def loadAlgorithms(self):
        from .algorithms.bibliometrik_slr_gapfinder_plus_heatmaps import BibliometrikSLRGapFinderPatched
        self.addAlgorithm(BibliometrikSLRGapFinderPatched())

