# -*- coding: utf-8 -*-
"""
/***************************************************************************
 BGTInloopToolDialog
                                 A QGIS plugin
 BGT Inlooptool
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2020-08-12
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Emile de Badts
        email                : emile.debadts@nelen-schuurmans.nl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
from osgeo import ogr

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets

from qgis.core import QgsMapLayerProxyModel
from qgis.gui import QgsFileWidget

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(
    os.path.join(os.path.dirname(__file__), "BGTInloopTool_dialog_base.ui")
)

from .core.defaults import *

ogr.UseExceptions()


def is_valid_ogr_file(path: str, optional: bool = False):
    if path == "":  # optional input
        if optional:
            valid = True
        else:
            valid = False
    elif not os.path.isfile(path):
        valid = False
    else:
        valid = isinstance(ogr.Open(path), ogr.DataSource)
    return valid


class BGTInloopToolDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(BGTInloopToolDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)

        # connect signals
        self.bgt_file.fileChanged.connect(self.validate)
        self.pipe_file.fileChanged.connect(self.validate)
        self.building_file.fileChanged.connect(self.validate)
        self.kolken_file.fileChanged.connect(self.validate)
        self.results_file.fileChanged.connect(self.validate)
        self.stats_file.fileChanged.connect(self.validate)
        self.output_folder.fileChanged.connect(self.validate)
        self.outputFileGroupBox.clicked.connect(self.validate)
        
        self.bgtApiOutput.fileChanged.connect(self.validate_bgt)
        self.BGTExtentCombobox.layerChanged.connect(self.validate_bgt)
        
        self.bagApiOutput.fileChanged.connect(self.validate_bag)
        self.BGTExtentCombobox.layerChanged.connect(self.validate_bag)
        
        self.gwswApiOutput.fileChanged.connect(self.validate_gwsw)
        self.BGTExtentCombobox.layerChanged.connect(self.validate_gwsw)

        # Setting defaults
        self.max_afstand_vlak_afwateringsvoorziening.setValue(
            MAX_AFSTAND_VLAK_AFWATERINGSVOORZIENING
        )
        self.max_afstand_vlak_oppwater.setValue(MAX_AFSTAND_VLAK_OPPWATER)
        self.max_afstand_pand_oppwater.setValue(MAX_AFSTAND_PAND_OPPWATER)
        self.max_afstand_vlak_kolk.setValue(MAX_AFSTAND_VLAK_KOLK)
        self.max_afstand_afgekoppeld.setValue(MAX_AFSTAND_AFGEKOPPELD)
        self.max_afstand_drievoudig.setValue(MAX_AFSTAND_DRIEVOUDIG)
        self.bouwjaar_gescheiden_binnenhuisriolering.setMaximum(10000)
        self.bouwjaar_gescheiden_binnenhuisriolering.setValue(
            BOUWJAAR_GESCHEIDEN_BINNENHUISRIOLERING
        )
        self.verhardingsgraad_erf.setValue(VERHARDINGSGRAAD_ERF)
        self.verhardingsgraad_half_verhard.setValue(VERHARDINGSGRAAD_HALF_VERHARD)
        self.afkoppelen_hellende_daken.setChecked(AFKOPPELEN_HELLENDE_DAKEN)
        self.leidingcodes_koppelen.setChecked(KOPPEL_LEIDINGCODES)
        
        # Run button default disable
        self.pushButtonRun.setEnabled(False)
        self.pushButtonDownloadBGT.setEnabled(False)
        self.pushButtonDownloadGWSW.setEnabled(False)
        self.pushButtonDownloadBAG.setEnabled(False)
        self.validate()
        self.validate_bgt()
        self.validate_bag()
        self.validate_gwsw()

        # Api's extract settings
        self.bgtApiOutput.setStorageMode(QgsFileWidget.SaveFile)
        self.gwswApiOutput.setStorageMode(QgsFileWidget.SaveFile)
        self.bagApiOutput.setStorageMode(QgsFileWidget.SaveFile)

        self.BGTExtentCombobox.setFilters(QgsMapLayerProxyModel.PolygonLayer)

        # Clip extent settings
        self.inputExtentGroupBox.clicked.connect(self.inputExtentGroupBoxChanged)
        self.inputExtentComboBox.setEnabled(False)
        self.inputExtentComboBox.setFilters(QgsMapLayerProxyModel.PolygonLayer)
        
        # Saving results settings
        self.output_folder.setStorageMode(QgsFileWidget.GetDirectory)

    def inputExtentGroupBoxChanged(self):
        state = self.inputExtentGroupBox.isChecked()
        self.inputExtentComboBox.setEnabled(state)
        
    def validate(self):

        valid = True

        # Check bgt file
        bgt_file = self.bgt_file.filePath()
        if not os.path.isfile(bgt_file):
            valid = False
        elif os.path.splitext(bgt_file)[1] != ".zip":
            valid = False

        # Check pipe file
        pipe_file = self.pipe_file.filePath()
        if not is_valid_ogr_file(pipe_file, optional=False):
            valid = False
        elif os.path.splitext(pipe_file)[1] != ".gpkg":
            valid = False

        # Check building (BAG) file (optional)
        building_file = self.building_file.filePath()
        if not is_valid_ogr_file(building_file, optional=True):
            valid = False
        elif building_file != "": 
            if os.path.splitext(building_file)[1] not in [".gpkg", ".shp"]: #To do: kan BAG al gpkg en shp aan?
                valid = False

        # Check kolken file (optional)
        kolken_file = self.kolken_file.filePath()
        if not is_valid_ogr_file(kolken_file, optional=True):
            valid = False
        elif kolken_file != "": 
            if os.path.splitext(kolken_file)[1] not in [".gpkg", ".shp"]: #To do: wat is het input formaat voor kolken?
                valid = False
            
        # Check results file previous analysis (optional)
        results_file = self.results_file.filePath()
        if not is_valid_ogr_file(results_file, optional=True):
            valid = False
        elif results_file != "": 
            if os.path.splitext(results_file)[1] != ".gpkg":
                valid = False
            
        # Check stats file (optional)
        stats_file = self.stats_file.filePath()
        if not is_valid_ogr_file(stats_file, optional=True):
            valid = False
        elif stats_file != "": 
            if os.path.splitext(stats_file)[1] not in [".gpkg", ".shp"]: #To do: zorgen dat het ook gpkg slikt als input
                valid = False
        
        # Check output_folder (optional)
        output_folder = self.output_folder.filePath()
        if self.outputFileGroupBox.isChecked():
            if output_folder == "":
                valid = False
        
        self.pushButtonRun.setEnabled(valid)
    
    def validate_bgt(self):
        valid = True
        
        extent_file = self.BGTExtentCombobox.currentText()
        if extent_file == "":
            valid = False
        
        bgt_file = self.bgtApiOutput.filePath()
        if bgt_file == "":
            valid = False
        elif os.path.splitext(bgt_file)[1] != ".zip":
            valid = False
        
        self.pushButtonDownloadBGT.setEnabled(valid)
        
    def validate_bag(self):
        valid = True
        
        extent_file = self.BGTExtentCombobox.currentText()
        if extent_file == "":
            valid = False
        
        bag_file = self.bagApiOutput.filePath()
        if bag_file == "":
            valid = False
        elif os.path.splitext(bag_file)[1] != ".gpkg":
            valid = False
        
        self.pushButtonDownloadBAG.setEnabled(valid)
        
    def validate_gwsw(self):
        valid = True
        
        extent_file = self.BGTExtentCombobox.currentText()
        if extent_file == "":
            valid = False
        
        gwsw_file = self.gwswApiOutput.filePath()
        if gwsw_file == "":
            valid = False
        elif os.path.splitext(gwsw_file)[1] != ".gpkg":
            valid = False
        
        self.pushButtonDownloadGWSW.setEnabled(valid)
