PSEUDO_INFINITE = float(99999)

SURFACE_TYPE_PAND = 'pand'
SURFACE_TYPE_WEGDEEL = 'wegdeel'
SURFACE_TYPE_ONDERSTEUNENDWEGDEEL = 'ondersteunendwegdeel'
SURFACE_TYPE_BEGROEIDTERREINDEEL = 'begroeidterreindeel'
SURFACE_TYPE_ONBEGROEIDTERREINDEEL = 'onbegroeidterreindeel'
SURFACE_TYPE_WATERDEEL = 'waterdeel'
SURFACE_TYPE_ONDERSTEUNENDWATERDEEL = 'ondersteunendwaterdeel'
SURFACE_TYPE_OVERIGBOUWWERK = 'overigbouwwerk'
SURFACE_TYPE_GEBOUWINSTALLATIE = 'gebouwinstallatie'
SURFACE_TYPE_OVERBRUGGINGSDEEL = 'overbruggingsdeel'

ALL_USED_SURFACE_TYPES = {
    SURFACE_TYPE_PAND,
    SURFACE_TYPE_WEGDEEL,
    SURFACE_TYPE_ONDERSTEUNENDWEGDEEL,
    SURFACE_TYPE_BEGROEIDTERREINDEEL,
    SURFACE_TYPE_ONBEGROEIDTERREINDEEL,
    SURFACE_TYPE_WATERDEEL,
    SURFACE_TYPE_ONDERSTEUNENDWATERDEEL,
    SURFACE_TYPE_OVERIGBOUWWERK,
    SURFACE_TYPE_GEBOUWINSTALLATIE,
    SURFACE_TYPE_OVERBRUGGINGSDEEL
}

CONNECTABLE_SURFACE_TYPES = {
    SURFACE_TYPE_PAND,
    SURFACE_TYPE_WEGDEEL,
    SURFACE_TYPE_ONDERSTEUNENDWEGDEEL,
    SURFACE_TYPE_ONBEGROEIDTERREINDEEL,
    SURFACE_TYPE_OVERIGBOUWWERK
}

NON_CONNECTABLE_SURFACE_TYPES = {
    SURFACE_TYPE_BEGROEIDTERREINDEEL,
    SURFACE_TYPE_WATERDEEL,
    SURFACE_TYPE_ONDERSTEUNENDWATERDEEL,
    SURFACE_TYPE_GEBOUWINSTALLATIE,
    SURFACE_TYPE_OVERBRUGGINGSDEEL
}

assert CONNECTABLE_SURFACE_TYPES.union(NON_CONNECTABLE_SURFACE_TYPES) == ALL_USED_SURFACE_TYPES

KOLK_CONNECTABLE_SURFACE_TYPES = {
    SURFACE_TYPE_WEGDEEL,
    SURFACE_TYPE_ONDERSTEUNENDWEGDEEL,
    SURFACE_TYPE_ONBEGROEIDTERREINDEEL
}

SURFACE_TYPES_MET_FYSIEK_VOORKOMEN = {
    SURFACE_TYPE_WEGDEEL,
    SURFACE_TYPE_ONBEGROEIDTERREINDEEL,
    SURFACE_TYPE_BEGROEIDTERREINDEEL,
    SURFACE_TYPE_ONDERSTEUNENDWEGDEEL
}

MULTIPLE_GEOMETRY_SURFACE_TYPES = {
    SURFACE_TYPE_WEGDEEL,
    SURFACE_TYPE_ONBEGROEIDTERREINDEEL,
    SURFACE_TYPE_BEGROEIDTERREINDEEL,
    SURFACE_TYPE_ONDERSTEUNENDWEGDEEL
}

###############################


VERHARDINGSTYPE_PAND = 'dak'
VERHARDINGSTYPE_WATER = 'water'
VERHARDINGSTYPE_ONVERHARD = 'onverhard'
VERHARDINGSTYPE_OPEN_VERHARD = 'open verhard'
VERHARDINGSTYPE_GESLOTEN_VERHARD = 'gesloten verhard'

SOURCE_PIPES_TABLE_NAME = "default_lijn"

SURFACES_TABLE_NAME = 'bgt_oppervlak'

PIPES_TABLE_NAME = 'pipes'
GWSW_PIPE_TYPE_FIELD = 'type'
GWSW_PIPE_TYPE_AANSLUITLEIDING = 'Aansluitleiding'
GWSW_PIPE_TYPE_BERGINGSLEIDING = 'Bergingsleiding'
GWSW_PIPE_TYPE_DRAIN = 'Drain'
GWSW_PIPE_TYPE_DRUKLEIDING = 'Drukleiding'
GWSW_PIPE_TYPE_DUIKER = 'Duiker'
GWSW_PIPE_TYPE_DWAPERCEELAANSLUITLEIDING = 'DwaPerceelaansluitleiding'
GWSW_PIPE_TYPE_GEMENGDEPERCEELAANSLUITLEIDING = 'GemengdePerceelaansluitleiding'
GWSW_PIPE_TYPE_GEMENGDRIOOL = 'GemengdRiool'
GWSW_PIPE_TYPE_HEMELWATERRIOOL = 'Hemelwaterriool'
GWSW_PIPE_TYPE_HWAPERCEELAANSLUITLEIDING = 'HwaPerceelaansluitleiding'
GWSW_PIPE_TYPE_INFILTRATIERIOOL = 'Infiltratieriool'
GWSW_PIPE_TYPE_LOZELEIDING = 'LozeLeiding'
GWSW_PIPE_TYPE_LUCHTPERSLEIDING = 'Luchtpersleiding'
GWSW_PIPE_TYPE_MANTELBUIS = 'Mantelbuis'
GWSW_PIPE_TYPE_OVERSTORTLEIDING = 'Overstortleiding'
GWSW_PIPE_TYPE_PERCEELAANSLUITLEIDING = 'Perceelaansluitleiding'
GWSW_PIPE_TYPE_PERSLEIDING = 'Persleiding'
GWSW_PIPE_TYPE_TRANSPORTRIOOLLEIDING = 'Transportrioolleiding'
GWSW_PIPE_TYPE_VUILWATERRIOOL = 'Vuilwaterriool'
GWSW_PIPE_TYPE_DITRIOOL = 'DIT_riool'

GWSW_STELSEL_TYPE_FIELD = 'stelseltype'
GWSW_STELSEL_TYPE_VERBETERDHEMELWATERSTELSEL = 'VerbeterdHemelwaterstelsel'

INTERNAL_PIPE_TYPE_FIELD = 'pipe_type'
INTERNAL_PIPE_TYPE_IGNORE = 'negeer'
INTERNAL_PIPE_TYPE_GEMENGD_RIOOL = 'gemengd_riool'
INTERNAL_PIPE_TYPE_HEMELWATERRIOOL = 'hemelwaterriool'
INTERNAL_PIPE_TYPE_VGS_HEMELWATERRIOOL = 'vgs_hemelwaterriool'
INTERNAL_PIPE_TYPE_INFILTRATIEVOORZIENING = 'infiltratievoorziening'

PIPE_MAP = {
    GWSW_PIPE_TYPE_AANSLUITLEIDING: INTERNAL_PIPE_TYPE_IGNORE,
    GWSW_PIPE_TYPE_BERGINGSLEIDING: INTERNAL_PIPE_TYPE_IGNORE,
    GWSW_PIPE_TYPE_DRAIN: INTERNAL_PIPE_TYPE_IGNORE,
    GWSW_PIPE_TYPE_DRUKLEIDING: INTERNAL_PIPE_TYPE_IGNORE,
    GWSW_PIPE_TYPE_DUIKER: INTERNAL_PIPE_TYPE_IGNORE,
    GWSW_PIPE_TYPE_DWAPERCEELAANSLUITLEIDING: INTERNAL_PIPE_TYPE_IGNORE,
    GWSW_PIPE_TYPE_GEMENGDEPERCEELAANSLUITLEIDING: INTERNAL_PIPE_TYPE_IGNORE,
    GWSW_PIPE_TYPE_GEMENGDRIOOL: INTERNAL_PIPE_TYPE_GEMENGD_RIOOL,
    GWSW_PIPE_TYPE_HEMELWATERRIOOL: INTERNAL_PIPE_TYPE_HEMELWATERRIOOL,
    GWSW_PIPE_TYPE_HWAPERCEELAANSLUITLEIDING: INTERNAL_PIPE_TYPE_IGNORE,
    GWSW_PIPE_TYPE_INFILTRATIERIOOL: INTERNAL_PIPE_TYPE_INFILTRATIEVOORZIENING,
    GWSW_PIPE_TYPE_LOZELEIDING: INTERNAL_PIPE_TYPE_IGNORE,
    GWSW_PIPE_TYPE_LUCHTPERSLEIDING: INTERNAL_PIPE_TYPE_IGNORE,
    GWSW_PIPE_TYPE_MANTELBUIS: INTERNAL_PIPE_TYPE_IGNORE,
    GWSW_PIPE_TYPE_OVERSTORTLEIDING: INTERNAL_PIPE_TYPE_IGNORE,
    GWSW_PIPE_TYPE_PERCEELAANSLUITLEIDING: INTERNAL_PIPE_TYPE_IGNORE,
    GWSW_PIPE_TYPE_PERSLEIDING: INTERNAL_PIPE_TYPE_IGNORE,
    GWSW_PIPE_TYPE_TRANSPORTRIOOLLEIDING: INTERNAL_PIPE_TYPE_IGNORE,
    GWSW_PIPE_TYPE_VUILWATERRIOOL: INTERNAL_PIPE_TYPE_IGNORE,
    GWSW_PIPE_TYPE_DITRIOOL: INTERNAL_PIPE_TYPE_INFILTRATIEVOORZIENING
}

KOLK = 'kolk'
OPEN_WATER = 'open_water'

BUILDINGS_TABLE_NAME = 'buildings'
KOLKEN_TABLE_NAME = 'kolken'
RESULT_TABLE_NAME = 'bgt_inlooptabel'

RESULT_TABLE_FIELD_ID = 'id'
RESULT_TABLE_FIELD_LAATSTE_WIJZIGING = 'laatste_wijziging'
RESULT_TABLE_FIELD_BGT_IDENTIFICATIE = 'bgt_identificatie'
RESULT_TABLE_FIELD_TYPE_VERHARDING = 'type_verharding'
RESULT_TABLE_FIELD_GRAAD_VERHARDING = 'graad_verharding'
RESULT_TABLE_FIELD_HELLINGSTYPE = 'hellingstype'
RESULT_TABLE_FIELD_HELLINGSPERCENTAGE = 'hellingspercentage'
# RESULT_TABLE_FIELD_BERGING_DAK = 'berging_dak'
RESULT_TABLE_FIELD_TYPE_PRIVATE_VOORZIENING = 'type_private_voorziening'
RESULT_TABLE_FIELD_BERGING_PRIVATE_VOORZIENING = 'berging_private_voorziening'
RESULT_TABLE_FIELD_PUTCODE = 'putcode'
RESULT_TABLE_FIELD_LEIDINGCODE = 'leidingcode'
RESULT_TABLE_FIELD_CODE_VOORZIENING = 'code_voorziening'

TARGET_TYPE_GEMENGD_RIOOL = 'gemengd_riool'
TARGET_TYPE_HEMELWATERRIOOL = 'hemelwaterriool'
TARGET_TYPE_VGS_HEMELWATERRIOOL = 'vgs_hemelwaterriool'
TARGET_TYPE_VUILWATERRIOOL = 'vuilwaterriool'
TARGET_TYPE_INFILTRATIEVOORZIENING = 'infiltratievoorziening'
TARGET_TYPE_OPEN_WATER = 'open_water'
TARGET_TYPE_MAAIVELD = 'maaiveld'

TARGET_TYPES = {
    TARGET_TYPE_GEMENGD_RIOOL,
    TARGET_TYPE_HEMELWATERRIOOL,
    TARGET_TYPE_VGS_HEMELWATERRIOOL,
    TARGET_TYPE_VUILWATERRIOOL,
    TARGET_TYPE_INFILTRATIEVOORZIENING,
    TARGET_TYPE_OPEN_WATER,
    TARGET_TYPE_MAAIVELD
}

DISTANCE_TYPES = {
    INTERNAL_PIPE_TYPE_GEMENGD_RIOOL,
    INTERNAL_PIPE_TYPE_HEMELWATERRIOOL,
    INTERNAL_PIPE_TYPE_VGS_HEMELWATERRIOOL,
    INTERNAL_PIPE_TYPE_INFILTRATIEVOORZIENING,
    KOLK,
    OPEN_WATER
}
