# -*- coding: utf-8 -*-

"""
/***************************************************************************
 BearingDistance
                                 A QGIS plugin
 This plugin returns the bearing and distance of the sides of polygons.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-04-07
        copyright            : (C) 2022 by Yahaya Isah Makarfi
        email                : ymakarfi.isa@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Yahaya Isah Makarfi'
__date__ = '2022-04-07'
__copyright__ = '(C) 2022 by Yahaya Isah Makarfi'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import (QgsProcessing,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterFeatureSink,
                       QgsProcessingMultiStepFeedback,
                       QgsProcessingParameterVectorLayer,
                       QgsProcessingParameterField,
                       QgsProcessingParameterFileDestination,
                       QgsProcessingParameterString,
                       QgsExpression)
import processing
import os.path

class BearingDistanceAlgorithm(QgsProcessingAlgorithm):
    """
    This is an example algorithm that takes a vector layer and
    creates a new identical one.

    It is meant to be used as an example of how to create your own
    algorithms and explain methods and variables used to do it. An
    algorithm like this will be available in all elements, and there
    is not need for additional work.

    All Processing algorithms should extend the QgsProcessingAlgorithm
    class.
    """

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.

    OUTPUT = 'OUTPUT'
    INPUT = 'INPUT'

    def initAlgorithm(self, config):
        """
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        """

        # We add the input vector features source. It can have any kind of
        # geometry.
        self.addParameter(QgsProcessingParameterVectorLayer('PolygonInput', 'Polygon Input', types=[QgsProcessing.TypeVectorPolygon], defaultValue=None))
        self.addParameter(QgsProcessingParameterField('FieldInput', 'Polygon Search Field', type=QgsProcessingParameterField.Any, parentLayerParameterName='PolygonInput', allowMultiple=False, defaultValue=''))
        self.addParameter(QgsProcessingParameterString('Input', 'Polygon Field Input', multiLine=False, defaultValue=''))
        self.addParameter(QgsProcessingParameterVectorLayer('Point1', 'Point', types=[QgsProcessing.TypeVectorPoint], defaultValue=None))
        self.addParameter(QgsProcessingParameterField('Beacon', 'Point Number Field', type=QgsProcessingParameterField.Any, parentLayerParameterName='Point1', allowMultiple=False, defaultValue=''))
        self.addParameter(QgsProcessingParameterFeatureSink('Parcel', 'Parcel', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, supportsAppend=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('BearingDistance', 'Bearing & Distance', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, supportsAppend=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('OutputPoints', 'Output Points', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))
        
       

    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        feedback = QgsProcessingMultiStepFeedback(89, model_feedback)
        results = {}
        outputs = {}

        # Select by attribute
        alg_params = {
            'FIELD': parameters['FieldInput'],
            'INPUT': parameters['PolygonInput'],
            'METHOD': 0,
            'OPERATOR': 0,
            'VALUE': parameters['Input']
        }
        outputs['SelectByAttribute'] = processing.run('qgis:selectbyattribute', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return {}

        # pointxsp
        alg_params = {
            'INPUT': parameters['Point1']
        }
        outputs['Pointxsp'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(2)
        if feedback.isCanceled():
            return {}

        # spx1
        alg_params = {
            'INPUT': outputs['SelectByAttribute']['OUTPUT']
        }
        outputs['Spx1'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(3)
        if feedback.isCanceled():
            return {}

        # Selection
        alg_params = {
            'INPUT': outputs['Spx1']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Selection'] = processing.run('native:saveselectedfeatures', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(4)
        if feedback.isCanceled():
            return {}

        # Extracted Points
        alg_params = {
            'INPUT': parameters['Point1'],
            'INTERSECT': outputs['Selection']['OUTPUT'],
            'PREDICATE': [0],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ExtractedPoints'] = processing.run('native:extractbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(5)
        if feedback.isCanceled():
            return {}

        # spx2
        alg_params = {
            'INPUT': outputs['Selection']['OUTPUT']
        }
        outputs['Spx2'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(6)
        if feedback.isCanceled():
            return {}

        # Polygons to lines
        alg_params = {
            'INPUT': outputs['Spx2']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['PolygonsToLines'] = processing.run('native:polygonstolines', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(7)
        if feedback.isCanceled():
            return {}

        # Retain fields poly
        alg_params = {
            'FIELDS': [''],
            'INPUT': outputs['Selection']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RetainFieldsPoly'] = processing.run('native:retainfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(8)
        if feedback.isCanceled():
            return {}

        # Retain fields points
        alg_params = {
            'FIELDS': parameters['Beacon'],
            'INPUT': outputs['ExtractedPoints']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RetainFieldsPoints'] = processing.run('native:retainfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(9)
        if feedback.isCanceled():
            return {}

        # Add field to attributes tablexxx
        alg_params = {
            'FIELD_LENGTH': 100,
            'FIELD_NAME': 'ps1',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'INPUT': outputs['ExtractedPoints']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['AddFieldToAttributesTablexxx'] = processing.run('native:addfieldtoattributestable', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(10)
        if feedback.isCanceled():
            return {}

        # polygon_sp1
        alg_params = {
            'INPUT': outputs['PolygonsToLines']['OUTPUT']
        }
        outputs['Polygon_sp1'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(11)
        if feedback.isCanceled():
            return {}

        # Field calculator order
        alg_params = {
            'FIELD_LENGTH': 100,
            'FIELD_NAME': 'point_no',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': parameters['Beacon'],
            'INPUT': outputs['RetainFieldsPoints']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FieldCalculatorOrder'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(12)
        if feedback.isCanceled():
            return {}

        # Extract vertices Points
        alg_params = {
            'INPUT': outputs['Polygon_sp1']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ExtractVerticesPoints'] = processing.run('native:extractvertices', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(13)
        if feedback.isCanceled():
            return {}

        # Add field to attributes table 1
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'plot_no',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'INPUT': outputs['RetainFieldsPoly']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['AddFieldToAttributesTable1'] = processing.run('native:addfieldtoattributestable', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(14)
        if feedback.isCanceled():
            return {}

        # Retain fields poly
        alg_params = {
            'FIELDS': [''],
            'INPUT': outputs['Polygon_sp1']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RetainFieldsPoly'] = processing.run('native:retainfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(15)
        if feedback.isCanceled():
            return {}

        # spinx_poly2
        alg_params = {
            'INPUT': outputs['AddFieldToAttributesTable1']['OUTPUT']
        }
        outputs['Spinx_poly2'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(16)
        if feedback.isCanceled():
            return {}

        # point_sp1
        alg_params = {
            'INPUT': outputs['FieldCalculatorOrder']['OUTPUT']
        }
        outputs['Point_sp1'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(17)
        if feedback.isCanceled():
            return {}

        # centroid_x
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'cx',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'x($geometry)',
            'INPUT': outputs['RetainFieldsPoly']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Centroid_x'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(18)
        if feedback.isCanceled():
            return {}

        # spinx6
        alg_params = {
            'INPUT': outputs['ExtractVerticesPoints']['OUTPUT']
        }
        outputs['Spinx6'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(19)
        if feedback.isCanceled():
            return {}

        # Retain fields Points1
        alg_params = {
            'FIELDS': QgsExpression('\'angle\'').evaluate(),
            'INPUT': outputs['Spinx6']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RetainFieldsPoints1'] = processing.run('native:retainfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(20)
        if feedback.isCanceled():
            return {}

        # centroid_y
        alg_params = {
            'FIELD_LENGTH': 0,
            'FIELD_NAME': 'cy',
            'FIELD_PRECISION': 20,
            'FIELD_TYPE': 2,
            'FORMULA': 'y($geometry)',
            'INPUT': outputs['Centroid_x']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Centroid_y'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(21)
        if feedback.isCanceled():
            return {}

        # Add field to attributes table 2
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'file_no',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'INPUT': outputs['Spinx_poly2']['OUTPUT'],
            'OUTPUT': parameters['Parcel']
        }
        outputs['AddFieldToAttributesTable2'] = processing.run('native:addfieldtoattributestable', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Parcel'] = outputs['AddFieldToAttributesTable2']['OUTPUT']

        feedback.setCurrentStep(22)
        if feedback.isCanceled():
            return {}

        # polygon_sp2
        alg_params = {
            'INPUT': outputs['RetainFieldsPoly']['OUTPUT']
        }
        outputs['Polygon_sp2'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(23)
        if feedback.isCanceled():
            return {}

        # spinx8
        alg_params = {
            'INPUT': outputs['RetainFieldsPoints1']['OUTPUT']
        }
        outputs['Spinx8'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(24)
        if feedback.isCanceled():
            return {}

        # Set layer style
        alg_params = {
            'INPUT': outputs['AddFieldToAttributesTable2']['OUTPUT'],
            'STYLE': os.path.join( os.path.dirname(__file__), "parcel.qml" )
        }
        outputs['SetLayerStyle'] = processing.run('native:setlayerstyle', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(25)
        if feedback.isCanceled():
            return {}

        # start field result
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 's_ref_id',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\'start\'',
            'INPUT': outputs['Point_sp1']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['StartFieldResult'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(26)
        if feedback.isCanceled():
            return {}

        # point_sp2
        alg_params = {
            'INPUT': outputs['StartFieldResult']['OUTPUT']
        }
        outputs['Point_sp2'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(27)
        if feedback.isCanceled():
            return {}

        # Explode lines
        alg_params = {
            'INPUT': outputs['Polygon_sp2']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ExplodeLines'] = processing.run('native:explodelines', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(28)
        if feedback.isCanceled():
            return {}

        # Join attributes by location label
        alg_params = {
            'DISCARD_NONMATCHING': False,
            'INPUT': outputs['FieldCalculatorOrder']['OUTPUT'],
            'JOIN': outputs['Centroid_y']['OUTPUT'],
            'JOIN_FIELDS': [''],
            'METHOD': 0,
            'PREDICATE': [0],
            'PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['JoinAttributesByLocationLabel'] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(29)
        if feedback.isCanceled():
            return {}

        # end field result
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'e_ref_id',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\'end\'',
            'INPUT': outputs['Point_sp2']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['EndFieldResult'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(30)
        if feedback.isCanceled():
            return {}

        # point_x
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'px',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '$x',
            'INPUT': outputs['JoinAttributesByLocationLabel']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Point_x'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(31)
        if feedback.isCanceled():
            return {}

        # polygon_sp3
        alg_params = {
            'INPUT': outputs['ExplodeLines']['OUTPUT']
        }
        outputs['Polygon_sp3'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(32)
        if feedback.isCanceled():
            return {}

        # Delete duplicate geometries 1
        alg_params = {
            'INPUT': outputs['Polygon_sp3']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DeleteDuplicateGeometries1'] = processing.run('native:deleteduplicategeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(33)
        if feedback.isCanceled():
            return {}

        # point_sp4
        alg_params = {
            'INPUT': outputs['EndFieldResult']['OUTPUT']
        }
        outputs['Point_sp4'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(34)
        if feedback.isCanceled():
            return {}

        # point_y
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'py',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '$y',
            'INPUT': outputs['Point_x']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Point_y'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(35)
        if feedback.isCanceled():
            return {}

        # polygon_sp4
        alg_params = {
            'INPUT': outputs['DeleteDuplicateGeometries1']['OUTPUT']
        }
        outputs['Polygon_sp4'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(36)
        if feedback.isCanceled():
            return {}

        # ang_ref_id
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'ang_ref_id',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'floor(case\r\nwhen cy> py and cx>px then 90-( atan ((cy-py)/(cx-px))*180/$pi)\r\nwhen py> cy and cx>px then 90-( atan ((cy-py)/(cx-px))*180/$pi)\r\nwhen py> cy and px>cx then 270-( atan ((cy-py)/(cx-px))*180/$pi)\r\nwhen cy> py and px>cx then 270-( atan ((cy-py)/(cx-px))*180/$pi)\r\nwhen cy>py and px=cx then 0\r\nwhen py=cy and cx>px then 90\r\nwhen py>cy and px=cx then 180\r\nwhen py=cy and px>cx then 270\r\nend) + 90\r\n\r\n',
            'INPUT': outputs['Point_y']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Ang_ref_id'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(37)
        if feedback.isCanceled():
            return {}

        # ps1
        alg_params = {
            'FIELD_LENGTH': 100,
            'FIELD_NAME': 'ps1',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '$x||\',\'||$y',
            'INPUT': outputs['Point_sp4']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Ps1'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(38)
        if feedback.isCanceled():
            return {}

        # point_sp6
        alg_params = {
            'INPUT': outputs['Ps1']['OUTPUT']
        }
        outputs['Point_sp6'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(39)
        if feedback.isCanceled():
            return {}

        # Join attributes by location
        alg_params = {
            'DISCARD_NONMATCHING': False,
            'INPUT': outputs['Polygon_sp3']['OUTPUT'],
            'JOIN': outputs['Point_sp6']['OUTPUT'],
            'JOIN_FIELDS': [''],
            'METHOD': 0,
            'PREDICATE': [0],
            'PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['JoinAttributesByLocation'] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(40)
        if feedback.isCanceled():
            return {}

        # polygon_sp5
        alg_params = {
            'INPUT': outputs['JoinAttributesByLocation']['OUTPUT']
        }
        outputs['Polygon_sp5'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(41)
        if feedback.isCanceled():
            return {}

        # start extraction
        alg_params = {
            'EXPRESSION': 'xat(0)||\',\'||yat(0)!=\"ps1\"',
            'INPUT': outputs['Polygon_sp5']['OUTPUT'],
            'FAIL_OUTPUT': QgsProcessing.TEMPORARY_OUTPUT,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['StartExtraction'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(42)
        if feedback.isCanceled():
            return {}

        # Drop field(s)
        alg_params = {
            'COLUMN': [''],
            'INPUT': outputs['StartExtraction']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DropFields'] = processing.run('native:deletecolumn', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(43)
        if feedback.isCanceled():
            return {}

        # end 2
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'p_ref_id',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': parameters['Beacon'],
            'INPUT': outputs['Point_sp4']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['End2'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(44)
        if feedback.isCanceled():
            return {}

        # point_sp5
        alg_params = {
            'INPUT': outputs['End2']['OUTPUT']
        }
        outputs['Point_sp5'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(45)
        if feedback.isCanceled():
            return {}

        # Drop field(s)
        alg_params = {
            'COLUMN': QgsExpression('\'cx;cy;px;py\'').evaluate(),
            'INPUT': outputs['Ang_ref_id']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DropFields'] = processing.run('native:deletecolumn', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(46)
        if feedback.isCanceled():
            return {}

        # Delete duplicate geometries points final
        alg_params = {
            'INPUT': outputs['DropFields']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DeleteDuplicateGeometriesPointsFinal'] = processing.run('native:deleteduplicategeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(47)
        if feedback.isCanceled():
            return {}

        # polygon_sp6
        alg_params = {
            'INPUT': outputs['StartExtraction']['FAIL_OUTPUT']
        }
        outputs['Polygon_sp6'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(48)
        if feedback.isCanceled():
            return {}

        # delete first extraction
        alg_params = {
            'INPUT': outputs['Polygon_sp6']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DeleteFirstExtraction'] = processing.run('native:deleteduplicategeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(49)
        if feedback.isCanceled():
            return {}

        # spinx7
        alg_params = {
            'INPUT': outputs['DeleteDuplicateGeometriesPointsFinal']['OUTPUT']
        }
        outputs['Spinx7'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(50)
        if feedback.isCanceled():
            return {}

        # polygon_sp7
        alg_params = {
            'INPUT': outputs['DeleteFirstExtraction']['OUTPUT']
        }
        outputs['Polygon_sp7'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(51)
        if feedback.isCanceled():
            return {}

        # bearing_distance join
        alg_params = {
            'DISCARD_NONMATCHING': False,
            'INPUT': outputs['Polygon_sp7']['OUTPUT'],
            'JOIN': outputs['Polygon_sp4']['OUTPUT'],
            'JOIN_FIELDS': [''],
            'METHOD': 0,
            'PREDICATE': [0],
            'PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Bearing_distanceJoin'] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(52)
        if feedback.isCanceled():
            return {}

        # polygon_sp8
        alg_params = {
            'INPUT': outputs['Bearing_distanceJoin']['OUTPUT']
        }
        outputs['Polygon_sp8'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(53)
        if feedback.isCanceled():
            return {}

        # Join attributes by location final
        alg_params = {
            'DISCARD_NONMATCHING': False,
            'INPUT': outputs['Spinx7']['OUTPUT'],
            'JOIN': outputs['Spinx8']['OUTPUT'],
            'JOIN_FIELDS': [''],
            'METHOD': 0,
            'PREDICATE': [0],
            'PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['JoinAttributesByLocationFinal'] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(54)
        if feedback.isCanceled():
            return {}

        # deleted duplicate bearing distance
        alg_params = {
            'INPUT': outputs['Polygon_sp8']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DeletedDuplicateBearingDistance'] = processing.run('native:deleteduplicategeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(55)
        if feedback.isCanceled():
            return {}

        # spinx5
        alg_params = {
            'INPUT': outputs['JoinAttributesByLocationFinal']['OUTPUT']
        }
        outputs['Spinx5'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(56)
        if feedback.isCanceled():
            return {}

        # Delete duplicate geometries fin
        alg_params = {
            'INPUT': outputs['Spinx5']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DeleteDuplicateGeometriesFin'] = processing.run('native:deleteduplicategeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(57)
        if feedback.isCanceled():
            return {}

        # polygon_sp9
        alg_params = {
            'INPUT': outputs['DeletedDuplicateBearingDistance']['OUTPUT']
        }
        outputs['Polygon_sp9'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(58)
        if feedback.isCanceled():
            return {}

        # spinx10
        alg_params = {
            'INPUT': outputs['DeleteDuplicateGeometriesFin']['OUTPUT']
        }
        outputs['Spinx10'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(59)
        if feedback.isCanceled():
            return {}

        # deleted 2
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'p_ref_id_1',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': parameters['Beacon'],
            'INPUT': outputs['Polygon_sp9']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Deleted2'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(60)
        if feedback.isCanceled():
            return {}

        # Field calculator flayer
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'angle_ref_id1',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 1,
            'FORMULA': 'case when \"angle\" < 180 then (\"angle\"+ 180) else (\"angle\"-180) end',
            'INPUT': outputs['Spinx10']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FieldCalculatorFlayer'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['OutputPoints'] = outputs['FieldCalculatorFlayer']['OUTPUT']

        feedback.setCurrentStep(61)
        if feedback.isCanceled():
            return {}
            
        # Retain fields flayer
        alg_params = {
            'FIELDS': QgsExpression('\'point_no;angle_ref_id1\'').evaluate(),
            'INPUT': outputs['FieldCalculatorFlayer']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RetainFieldsFlayer'] = processing.run('native:retainfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['OutputPoints'] = outputs['RetainFieldsFlayer']['OUTPUT']

        feedback.setCurrentStep(66)
        if feedback.isCanceled():
            return {}

        # polygon_sp10
        alg_params = {
            'INPUT': outputs['Deleted2']['OUTPUT']
        }
        outputs['Polygon_sp10'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(62)
        if feedback.isCanceled():
            return {}
            
        # Field calculator xcoord
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'East',
            'FIELD_PRECISION': 3,
            'FIELD_TYPE': 0,
            'FORMULA': '$x',
            'INPUT': outputs['RetainFieldsFlayer']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FieldCalculatorXcoord'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(67)
        if feedback.isCanceled():
            return {}

        # Field calculator ycoord
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'North',
            'FIELD_PRECISION': 3,
            'FIELD_TYPE': 0,
            'FORMULA': '$y',
            'INPUT': outputs['FieldCalculatorXcoord']['OUTPUT'],
            'OUTPUT': parameters['OutputPoints']
        }
        outputs['FieldCalculatorYcoord'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['OutputPoints'] = outputs['FieldCalculatorYcoord']['OUTPUT']

        feedback.setCurrentStep(68)
        if feedback.isCanceled():
            return {}

        # Set layer style
        alg_params = {
            'INPUT': outputs['FieldCalculatorYcoord']['OUTPUT'],
            'STYLE': os.path.join( os.path.dirname(__file__), "survey_layout_labels.qml" )
        }
        outputs['SetLayerStyle'] = processing.run('native:setlayerstyle', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(63)
        if feedback.isCanceled():
            return {}

        # end join
        alg_params = {
            'DISCARD_NONMATCHING': False,
            'INPUT': outputs['Polygon_sp10']['OUTPUT'],
            'JOIN': outputs['Point_sp5']['OUTPUT'],
            'JOIN_FIELDS': [''],
            'METHOD': 0,
            'PREDICATE': [0],
            'PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['EndJoin'] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(64)
        if feedback.isCanceled():
            return {}

        # polygon_sp11
        alg_params = {
            'INPUT': outputs['EndJoin']['OUTPUT']
        }
        outputs['Polygon_sp11'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(65)
        if feedback.isCanceled():
            return {}

        # Final Extract
        alg_params = {
            'EXPRESSION': 'xat(0)||\',\'||yat(0)=\"ps1\"  and    p_ref_id  !=   p_ref_id_1',
            'INPUT': outputs['Polygon_sp11']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FinalExtract'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(66)
        if feedback.isCanceled():
            return {}

        # polygon_sp12
        alg_params = {
            'INPUT': outputs['FinalExtract']['OUTPUT']
        }
        outputs['Polygon_sp12'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(67)
        if feedback.isCanceled():
            return {}

        # c_from
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'from',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\'FROM\'',
            'INPUT': outputs['Polygon_sp12']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['C_from'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(68)
        if feedback.isCanceled():
            return {}

        # polygon_sp13
        alg_params = {
            'INPUT': outputs['C_from']['OUTPUT']
        }
        outputs['Polygon_sp13'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(69)
        if feedback.isCanceled():
            return {}

        # point_start
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'point_start',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'p_ref_id_1',
            'INPUT': outputs['Polygon_sp13']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Point_start'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(70)
        if feedback.isCanceled():
            return {}

        # polygon_sp14
        alg_params = {
            'INPUT': outputs['Point_start']['OUTPUT']
        }
        outputs['Polygon_sp14'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(71)
        if feedback.isCanceled():
            return {}

        # c_to
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'to',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\'TO\'',
            'INPUT': outputs['Polygon_sp14']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['C_to'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(72)
        if feedback.isCanceled():
            return {}

        # polygon_sp15
        alg_params = {
            'INPUT': outputs['C_to']['OUTPUT']
        }
        outputs['Polygon_sp15'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(73)
        if feedback.isCanceled():
            return {}

        # point_end
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'point_end',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'p_ref_id',
            'INPUT': outputs['Polygon_sp15']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Point_end'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(74)
        if feedback.isCanceled():
            return {}

        # polygon_sp16
        alg_params = {
            'INPUT': outputs['Point_end']['OUTPUT']
        }
        outputs['Polygon_sp16'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(75)
        if feedback.isCanceled():
            return {}

        # equality sign
        alg_params = {
            'FIELD_LENGTH': 3,
            'FIELD_NAME': 'equality',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\'=\'',
            'INPUT': outputs['Polygon_sp16']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['EqualitySign'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(76)
        if feedback.isCanceled():
            return {}

        # polygon_sp17
        alg_params = {
            'INPUT': outputs['EqualitySign']['OUTPUT']
        }
        outputs['Polygon_sp17'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(77)
        if feedback.isCanceled():
            return {}

        # c_length
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'length',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'case \r\nwhen round($length,2)like\'%.%\' and right(round($length,2),2)like\'%.%\' then round($length,2)||\'0\'\r\nwhen round($length,2) not like\'%.%\' then round($length,2)||\'.00\'\r\nelse round($length,2) end ||\' m\'\r\n',
            'INPUT': outputs['Polygon_sp17']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['C_length'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(78)
        if feedback.isCanceled():
            return {}

        # polygon_sp18
        alg_params = {
            'INPUT': outputs['C_length']['OUTPUT']
        }
        outputs['Polygon_sp18'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(79)
        if feedback.isCanceled():
            return {}

        # c_at
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'at',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\'AT\'',
            'INPUT': outputs['Polygon_sp18']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['C_at'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(80)
        if feedback.isCanceled():
            return {}

        # polygon_sp19
        alg_params = {
            'INPUT': outputs['C_at']['OUTPUT']
        }
        outputs['Polygon_sp19'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(81)
        if feedback.isCanceled():
            return {}

        # c_bearing
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'angle',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'case when floor(angle_at_vertex($geometry,num_points($geometry)-1))< 10 then \'0\'||floor(angle_at_vertex($geometry,num_points($geometry)-1)) else floor(angle_at_vertex($geometry,num_points($geometry)-1)) end|| \'°\'',
            'INPUT': outputs['Polygon_sp19']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['C_bearing'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(82)
        if feedback.isCanceled():
            return {}

        # polygon_sp20
        alg_params = {
            'INPUT': outputs['C_bearing']['OUTPUT']
        }
        outputs['Polygon_sp20'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(83)
        if feedback.isCanceled():
            return {}

        # c_minutes
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'minutes',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'case when to_int((angle_at_vertex($geometry,num_points($geometry)-1)-floor(angle_at_vertex($geometry,num_points($geometry)-1)))*60)< 10 then \'0\'||to_int((angle_at_vertex($geometry,num_points($geometry)-1)-floor(angle_at_vertex($geometry,num_points($geometry)-1)))*60) else to_int((angle_at_vertex($geometry,num_points($geometry)-1)-floor(angle_at_vertex($geometry,num_points($geometry)-1)))*60) end|| \'\'\'\'',
            'INPUT': outputs['Polygon_sp20']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['C_minutes'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(84)
        if feedback.isCanceled():
            return {}

        # polygon_sp21
        alg_params = {
            'INPUT': outputs['C_minutes']['OUTPUT']
        }
        outputs['Polygon_sp21'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(85)
        if feedback.isCanceled():
            return {}

        # Extract by expression
        alg_params = {
            'EXPRESSION': '\"point_start\" != \"point_end\"',
            'INPUT': outputs['Polygon_sp21']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ExtractByExpression'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(86)
        if feedback.isCanceled():
            return {}

        # polygon_sp22
        alg_params = {
            'INPUT': outputs['ExtractByExpression']['OUTPUT']
        }
        outputs['Polygon_sp22'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(87)
        if feedback.isCanceled():
            return {}

        # Bearing & Distance
        alg_params = {
            'FIELDS': QgsExpression('\'from;point_start;to;point_end;equality;length;at;angle;minutes\'').evaluate(),
            'INPUT': outputs['Polygon_sp22']['OUTPUT'],
            'OUTPUT': parameters['BearingDistance']
        }
        outputs['BearingDistance'] = processing.run('native:retainfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['BearingDistance'] = outputs['BearingDistance']['OUTPUT']

        feedback.setCurrentStep(88)
        if feedback.isCanceled():
            return {}

        # Set layer style
        alg_params = {
            'INPUT': outputs['BearingDistance']['OUTPUT'],
            'STYLE': os.path.join( os.path.dirname(__file__), "bearing_&_distance.qml" )
        }
        outputs['SetLayerStyle'] = processing.run('native:setlayerstyle', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        return results
        
        
    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'B & D(By Attribute_With Points)'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr(self.name())

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr(self.groupId())

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
       

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return BearingDistanceAlgorithm()
        
class BearingDistance2Algorithm(QgsProcessingAlgorithm):

    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterVectorLayer('Polygon1', 'Polygon', types=[QgsProcessing.TypeVectorPolygon], defaultValue=None))
        self.addParameter(QgsProcessingParameterVectorLayer('Point1', 'Point', types=[QgsProcessing.TypeVectorPoint], defaultValue=None))
        self.addParameter(QgsProcessingParameterField('Beacon', 'Point Number Field', type=QgsProcessingParameterField.Any, parentLayerParameterName='Point1', allowMultiple=False, defaultValue=''))
        self.addParameter(QgsProcessingParameterFeatureSink('Parcel', 'Parcel', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, supportsAppend=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('BearingDistance', 'Bearing & Distance', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, supportsAppend=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('OutputPoints', 'Output Points', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))
        
        

    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        feedback = QgsProcessingMultiStepFeedback(91, model_feedback)
        results = {}
        outputs = {}

        # Add field to attributes tablexxx
        alg_params = {
            'FIELD_LENGTH': 100,
            'FIELD_NAME': 'ps1',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'INPUT': parameters['Point1'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['AddFieldToAttributesTablexxx'] = processing.run('native:addfieldtoattributestable', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return {}

        # Extract selected features001
        alg_params = {
            'INPUT': parameters['Polygon1'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ExtractSelectedFeatures001'] = processing.run('native:saveselectedfeatures', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(2)
        if feedback.isCanceled():
            return {}

        # Create spatial index001
        alg_params = {
            'INPUT': outputs['ExtractSelectedFeatures001']['OUTPUT']
        }
        outputs['CreateSpatialIndex001'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(3)
        if feedback.isCanceled():
            return {}

        # Retain fields poly
        alg_params = {
            'FIELDS': [''],
            'INPUT': outputs['CreateSpatialIndex001']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RetainFieldsPoly'] = processing.run('native:retainfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(4)
        if feedback.isCanceled():
            return {}

        # Extract vertices
        alg_params = {
            'INPUT': outputs['CreateSpatialIndex001']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ExtractVertices'] = processing.run('native:extractvertices', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(5)
        if feedback.isCanceled():
            return {}

        # Polygons to lines
        alg_params = {
            'INPUT': outputs['CreateSpatialIndex001']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['PolygonsToLines'] = processing.run('native:polygonstolines', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(6)
        if feedback.isCanceled():
            return {}

        # spinx_poly1
        alg_params = {
            'INPUT': outputs['RetainFieldsPoly']['OUTPUT']
        }
        outputs['Spinx_poly1'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(7)
        if feedback.isCanceled():
            return {}

        # spinx3
        alg_params = {
            'INPUT': outputs['ExtractVertices']['OUTPUT']
        }
        outputs['Spinx3'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(8)
        if feedback.isCanceled():
            return {}

        # Extract by location
        alg_params = {
            'INPUT': parameters['Point1'],
            'INTERSECT': outputs['Spinx3']['OUTPUT'],
            'PREDICATE': [0],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ExtractByLocation'] = processing.run('native:extractbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(9)
        if feedback.isCanceled():
            return {}

        # spinx2
        alg_params = {
            'INPUT': outputs['ExtractByLocation']['OUTPUT']
        }
        outputs['Spinx2'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(10)
        if feedback.isCanceled():
            return {}

        # polygon_sp1
        alg_params = {
            'INPUT': outputs['PolygonsToLines']['OUTPUT']
        }
        outputs['Polygon_sp1'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(11)
        if feedback.isCanceled():
            return {}

        # Add field to attributes table 1
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'plot_no',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'INPUT': outputs['Spinx_poly1']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['AddFieldToAttributesTable1'] = processing.run('native:addfieldtoattributestable', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(12)
        if feedback.isCanceled():
            return {}

        # Retain fields points
        alg_params = {
            'FIELDS': parameters['Beacon'],
            'INPUT': outputs['Spinx2']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RetainFieldsPoints'] = processing.run('native:retainfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(13)
        if feedback.isCanceled():
            return {}

        # spinx_poly2
        alg_params = {
            'INPUT': outputs['AddFieldToAttributesTable1']['OUTPUT']
        }
        outputs['Spinx_poly2'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(14)
        if feedback.isCanceled():
            return {}

        # Extract vertices Points
        alg_params = {
            'INPUT': outputs['Polygon_sp1']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ExtractVerticesPoints'] = processing.run('native:extractvertices', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(15)
        if feedback.isCanceled():
            return {}

        # Field calculator order
        alg_params = {
            'FIELD_LENGTH': 100,
            'FIELD_NAME': 'point_no',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': parameters['Beacon'],
            'INPUT': outputs['RetainFieldsPoints']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FieldCalculatorOrder'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(16)
        if feedback.isCanceled():
            return {}

        # Retain fields poly
        alg_params = {
            'FIELDS': [''],
            'INPUT': outputs['Polygon_sp1']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RetainFieldsPoly'] = processing.run('native:retainfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(17)
        if feedback.isCanceled():
            return {}

        # Add field to attributes table 2
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'file_no',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'INPUT': outputs['Spinx_poly2']['OUTPUT'],
            'OUTPUT': parameters['Parcel']
        }
        outputs['AddFieldToAttributesTable2'] = processing.run('native:addfieldtoattributestable', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Parcel'] = outputs['AddFieldToAttributesTable2']['OUTPUT']

        feedback.setCurrentStep(18)
        if feedback.isCanceled():
            return {}

        # polygon_sp2
        alg_params = {
            'INPUT': outputs['RetainFieldsPoly']['OUTPUT']
        }
        outputs['Polygon_sp2'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(19)
        if feedback.isCanceled():
            return {}

        # spinx6
        alg_params = {
            'INPUT': outputs['ExtractVerticesPoints']['OUTPUT']
        }
        outputs['Spinx6'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(20)
        if feedback.isCanceled():
            return {}

        # Set layer style
        alg_params = {
            'INPUT': outputs['AddFieldToAttributesTable2']['OUTPUT'],
            'STYLE': os.path.join( os.path.dirname(__file__), "parcel.qml" )
        }
        outputs['SetLayerStyle'] = processing.run('native:setlayerstyle', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(21)
        if feedback.isCanceled():
            return {}

        # Select by location
        alg_params = {
            'INPUT': outputs['FieldCalculatorOrder']['OUTPUT'],
            'INTERSECT': outputs['ExtractVertices']['OUTPUT'],
            'METHOD': 0,
            'PREDICATE': [0]
        }
        outputs['SelectByLocation'] = processing.run('native:selectbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(22)
        if feedback.isCanceled():
            return {}

        # Explode lines
        alg_params = {
            'INPUT': outputs['Polygon_sp2']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ExplodeLines'] = processing.run('native:explodelines', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(23)
        if feedback.isCanceled():
            return {}

        # centroid_x
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'cx',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'x($geometry)',
            'INPUT': outputs['RetainFieldsPoly']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Centroid_x'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(24)
        if feedback.isCanceled():
            return {}

        # centroid_y
        alg_params = {
            'FIELD_LENGTH': 0,
            'FIELD_NAME': 'cy',
            'FIELD_PRECISION': 20,
            'FIELD_TYPE': 2,
            'FORMULA': 'y($geometry)',
            'INPUT': outputs['Centroid_x']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Centroid_y'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(25)
        if feedback.isCanceled():
            return {}

        # point_sp1
        alg_params = {
            'INPUT': outputs['FieldCalculatorOrder']['OUTPUT']
        }
        outputs['Point_sp1'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(26)
        if feedback.isCanceled():
            return {}

        # start field result
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 's_ref_id',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\'start\'',
            'INPUT': outputs['Point_sp1']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['StartFieldResult'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(27)
        if feedback.isCanceled():
            return {}

        # point_sp2
        alg_params = {
            'INPUT': outputs['StartFieldResult']['OUTPUT']
        }
        outputs['Point_sp2'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(28)
        if feedback.isCanceled():
            return {}

        # Retain fields Points1
        alg_params = {
            'FIELDS': QgsExpression('\'angle\'').evaluate(),
            'INPUT': outputs['Spinx6']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RetainFieldsPoints1'] = processing.run('native:retainfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(29)
        if feedback.isCanceled():
            return {}

        # Join attributes by location label
        alg_params = {
            'DISCARD_NONMATCHING': False,
            'INPUT': outputs['FieldCalculatorOrder']['OUTPUT'],
            'JOIN': outputs['Centroid_y']['OUTPUT'],
            'JOIN_FIELDS': [''],
            'METHOD': 0,
            'PREDICATE': [0],
            'PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['JoinAttributesByLocationLabel'] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(30)
        if feedback.isCanceled():
            return {}

        # spinx7
        alg_params = {
            'INPUT': outputs['RetainFieldsPoints1']['OUTPUT']
        }
        outputs['Spinx7'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(31)
        if feedback.isCanceled():
            return {}

        # end field result
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'e_ref_id',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\'end\'',
            'INPUT': outputs['Point_sp2']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['EndFieldResult'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(32)
        if feedback.isCanceled():
            return {}

        # polygon_sp3
        alg_params = {
            'INPUT': outputs['ExplodeLines']['OUTPUT']
        }
        outputs['Polygon_sp3'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(33)
        if feedback.isCanceled():
            return {}

        # point_sp4
        alg_params = {
            'INPUT': outputs['EndFieldResult']['OUTPUT']
        }
        outputs['Point_sp4'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(34)
        if feedback.isCanceled():
            return {}

        # point_x
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'px',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '$x',
            'INPUT': outputs['JoinAttributesByLocationLabel']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Point_x'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(35)
        if feedback.isCanceled():
            return {}

        # Delete duplicate geometries 1
        alg_params = {
            'INPUT': outputs['Polygon_sp3']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DeleteDuplicateGeometries1'] = processing.run('native:deleteduplicategeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(36)
        if feedback.isCanceled():
            return {}

        # end 2
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'p_ref_id',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': parameters['Beacon'],
            'INPUT': outputs['Point_sp4']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['End2'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(37)
        if feedback.isCanceled():
            return {}

        # point_y
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'py',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '$y',
            'INPUT': outputs['Point_x']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Point_y'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(38)
        if feedback.isCanceled():
            return {}

        # ps1
        alg_params = {
            'FIELD_LENGTH': 100,
            'FIELD_NAME': 'ps1',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '$x||\',\'||$y',
            'INPUT': outputs['Point_sp4']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Ps1'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(39)
        if feedback.isCanceled():
            return {}

        # ang_ref_id
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'ang_ref_id',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'floor(case\r\nwhen cy> py and cx>px then 90-( atan ((cy-py)/(cx-px))*180/$pi)\r\nwhen py> cy and cx>px then 90-( atan ((cy-py)/(cx-px))*180/$pi)\r\nwhen py> cy and px>cx then 270-( atan ((cy-py)/(cx-px))*180/$pi)\r\nwhen cy> py and px>cx then 270-( atan ((cy-py)/(cx-px))*180/$pi)\r\nwhen cy>py and px=cx then 0\r\nwhen py=cy and cx>px then 90\r\nwhen py>cy and px=cx then 180\r\nwhen py=cy and px>cx then 270\r\nend) + 90\r\n\r\n',
            'INPUT': outputs['Point_y']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Ang_ref_id'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(40)
        if feedback.isCanceled():
            return {}

        # polygon_sp4
        alg_params = {
            'INPUT': outputs['DeleteDuplicateGeometries1']['OUTPUT']
        }
        outputs['Polygon_sp4'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(41)
        if feedback.isCanceled():
            return {}

        # Drop field(s)
        alg_params = {
            'COLUMN': QgsExpression('\'cx;cy;px;py\'').evaluate(),
            'INPUT': outputs['Ang_ref_id']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DropFields'] = processing.run('native:deletecolumn', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(42)
        if feedback.isCanceled():
            return {}

        # point_sp5
        alg_params = {
            'INPUT': outputs['End2']['OUTPUT']
        }
        outputs['Point_sp5'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(43)
        if feedback.isCanceled():
            return {}

        # point_sp6
        alg_params = {
            'INPUT': outputs['Ps1']['OUTPUT']
        }
        outputs['Point_sp6'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(44)
        if feedback.isCanceled():
            return {}

        # Join attributes by location
        alg_params = {
            'DISCARD_NONMATCHING': False,
            'INPUT': outputs['Polygon_sp3']['OUTPUT'],
            'JOIN': outputs['Point_sp6']['OUTPUT'],
            'JOIN_FIELDS': [''],
            'METHOD': 0,
            'PREDICATE': [0],
            'PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['JoinAttributesByLocation'] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(45)
        if feedback.isCanceled():
            return {}

        # Delete duplicate geometries points final
        alg_params = {
            'INPUT': outputs['DropFields']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DeleteDuplicateGeometriesPointsFinal'] = processing.run('native:deleteduplicategeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(46)
        if feedback.isCanceled():
            return {}

        # polygon_sp5
        alg_params = {
            'INPUT': outputs['JoinAttributesByLocation']['OUTPUT']
        }
        outputs['Polygon_sp5'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(47)
        if feedback.isCanceled():
            return {}

        # spinx8
        alg_params = {
            'INPUT': outputs['DeleteDuplicateGeometriesPointsFinal']['OUTPUT']
        }
        outputs['Spinx8'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(48)
        if feedback.isCanceled():
            return {}

        # Join attributes by location final
        alg_params = {
            'DISCARD_NONMATCHING': False,
            'INPUT': outputs['Spinx8']['OUTPUT'],
            'JOIN': outputs['Spinx7']['OUTPUT'],
            'JOIN_FIELDS': [''],
            'METHOD': 0,
            'PREDICATE': [0],
            'PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['JoinAttributesByLocationFinal'] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(49)
        if feedback.isCanceled():
            return {}

        # start extraction
        alg_params = {
            'EXPRESSION': 'xat(0)||\',\'||yat(0)!=\"ps1\"',
            'INPUT': outputs['Polygon_sp5']['OUTPUT'],
            'FAIL_OUTPUT': QgsProcessing.TEMPORARY_OUTPUT,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['StartExtraction'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(50)
        if feedback.isCanceled():
            return {}

        # spinx9
        alg_params = {
            'INPUT': outputs['JoinAttributesByLocationFinal']['OUTPUT']
        }
        outputs['Spinx9'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(51)
        if feedback.isCanceled():
            return {}

        # Delete duplicate geometries final
        alg_params = {
            'INPUT': outputs['Spinx9']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DeleteDuplicateGeometriesFinal'] = processing.run('native:deleteduplicategeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(52)
        if feedback.isCanceled():
            return {}

        # spinx10
        alg_params = {
            'INPUT': outputs['DeleteDuplicateGeometriesFinal']['OUTPUT']
        }
        outputs['Spinx10'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(53)
        if feedback.isCanceled():
            return {}

        # Drop field(s)
        alg_params = {
            'COLUMN': [''],
            'INPUT': outputs['StartExtraction']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DropFields'] = processing.run('native:deletecolumn', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(54)
        if feedback.isCanceled():
            return {}

        # polygon_sp6
        alg_params = {
            'INPUT': outputs['StartExtraction']['FAIL_OUTPUT']
        }
        outputs['Polygon_sp6'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(55)
        if feedback.isCanceled():
            return {}

        # Field calculator flayer
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'angle_ref_id1',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 1,
            'FORMULA': 'case when \"angle\" < 180 then (\"angle\"+ 180) else (\"angle\"-180) end',
            'INPUT': outputs['Spinx10']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FieldCalculatorFlayer'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['OutputPoints'] = outputs['FieldCalculatorFlayer']['OUTPUT']

        feedback.setCurrentStep(56)
        if feedback.isCanceled():
            return {}
            
        # Retain fields flayer
        alg_params = {
            'FIELDS': QgsExpression('\'point_no;angle_ref_id1\'').evaluate(),
            'INPUT': outputs['FieldCalculatorFlayer']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RetainFieldsFlayer'] = processing.run('native:retainfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['OutputPoints'] = outputs['RetainFieldsFlayer']['OUTPUT']

        feedback.setCurrentStep(66)
        if feedback.isCanceled():
            return {}
            
        # Field calculator xcoord
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'East',
            'FIELD_PRECISION': 3,
            'FIELD_TYPE': 0,
            'FORMULA': '$x',
            'INPUT': outputs['RetainFieldsFlayer']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FieldCalculatorXcoord'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(67)
        if feedback.isCanceled():
            return {}

        # Field calculator ycoord
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'North',
            'FIELD_PRECISION': 3,
            'FIELD_TYPE': 0,
            'FORMULA': '$y',
            'INPUT': outputs['FieldCalculatorXcoord']['OUTPUT'],
            'OUTPUT': parameters['OutputPoints']
        }
        outputs['FieldCalculatorYcoord'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['OutputPoints'] = outputs['FieldCalculatorYcoord']['OUTPUT']

        feedback.setCurrentStep(68)
        if feedback.isCanceled():
            return {}

        # Set layer style
        alg_params = {
            'INPUT': outputs['FieldCalculatorYcoord']['OUTPUT'],
            'STYLE': os.path.join( os.path.dirname(__file__), "survey_layout_labels.qml" )
        }
        outputs['SetLayerStyle'] = processing.run('native:setlayerstyle', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(57)
        if feedback.isCanceled():
            return {}

        # delete first extraction
        alg_params = {
            'INPUT': outputs['Polygon_sp6']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DeleteFirstExtraction'] = processing.run('native:deleteduplicategeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(58)
        if feedback.isCanceled():
            return {}

        # polygon_sp7
        alg_params = {
            'INPUT': outputs['DeleteFirstExtraction']['OUTPUT']
        }
        outputs['Polygon_sp7'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(59)
        if feedback.isCanceled():
            return {}

        # bearing_distance join
        alg_params = {
            'DISCARD_NONMATCHING': False,
            'INPUT': outputs['Polygon_sp7']['OUTPUT'],
            'JOIN': outputs['Polygon_sp4']['OUTPUT'],
            'JOIN_FIELDS': [''],
            'METHOD': 0,
            'PREDICATE': [0],
            'PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Bearing_distanceJoin'] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(60)
        if feedback.isCanceled():
            return {}

        # polygon_sp8
        alg_params = {
            'INPUT': outputs['Bearing_distanceJoin']['OUTPUT']
        }
        outputs['Polygon_sp8'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(61)
        if feedback.isCanceled():
            return {}

        # deleted duplicate bearing distance
        alg_params = {
            'INPUT': outputs['Polygon_sp8']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DeletedDuplicateBearingDistance'] = processing.run('native:deleteduplicategeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(62)
        if feedback.isCanceled():
            return {}

        # polygon_sp9
        alg_params = {
            'INPUT': outputs['DeletedDuplicateBearingDistance']['OUTPUT']
        }
        outputs['Polygon_sp9'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(63)
        if feedback.isCanceled():
            return {}

        # deleted 2
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'p_ref_id_1',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': parameters['Beacon'],
            'INPUT': outputs['Polygon_sp9']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Deleted2'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(64)
        if feedback.isCanceled():
            return {}

        # polygon_sp10
        alg_params = {
            'INPUT': outputs['Deleted2']['OUTPUT']
        }
        outputs['Polygon_sp10'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(65)
        if feedback.isCanceled():
            return {}

        # end join
        alg_params = {
            'DISCARD_NONMATCHING': False,
            'INPUT': outputs['Polygon_sp10']['OUTPUT'],
            'JOIN': outputs['Point_sp5']['OUTPUT'],
            'JOIN_FIELDS': [''],
            'METHOD': 0,
            'PREDICATE': [0],
            'PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['EndJoin'] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(66)
        if feedback.isCanceled():
            return {}

        # polygon_sp11
        alg_params = {
            'INPUT': outputs['EndJoin']['OUTPUT']
        }
        outputs['Polygon_sp11'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(67)
        if feedback.isCanceled():
            return {}

        # Final Extract
        alg_params = {
            'EXPRESSION': 'xat(0)||\',\'||yat(0)=\"ps1\"  and    p_ref_id  !=   p_ref_id_1',
            'INPUT': outputs['Polygon_sp11']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FinalExtract'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(68)
        if feedback.isCanceled():
            return {}

        # polygon_sp12
        alg_params = {
            'INPUT': outputs['FinalExtract']['OUTPUT']
        }
        outputs['Polygon_sp12'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(69)
        if feedback.isCanceled():
            return {}

        # c_from
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'from',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\'FROM\'',
            'INPUT': outputs['Polygon_sp12']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['C_from'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(70)
        if feedback.isCanceled():
            return {}

        # polygon_sp13
        alg_params = {
            'INPUT': outputs['C_from']['OUTPUT']
        }
        outputs['Polygon_sp13'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(71)
        if feedback.isCanceled():
            return {}

        # point_start
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'point_start',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'p_ref_id_1',
            'INPUT': outputs['Polygon_sp13']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Point_start'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(72)
        if feedback.isCanceled():
            return {}

        # polygon_sp14
        alg_params = {
            'INPUT': outputs['Point_start']['OUTPUT']
        }
        outputs['Polygon_sp14'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(73)
        if feedback.isCanceled():
            return {}

        # c_to
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'to',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\'TO\'',
            'INPUT': outputs['Polygon_sp14']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['C_to'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(74)
        if feedback.isCanceled():
            return {}

        # polygon_sp15
        alg_params = {
            'INPUT': outputs['C_to']['OUTPUT']
        }
        outputs['Polygon_sp15'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(75)
        if feedback.isCanceled():
            return {}

        # point_end
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'point_end',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'p_ref_id',
            'INPUT': outputs['Polygon_sp15']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Point_end'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(76)
        if feedback.isCanceled():
            return {}

        # polygon_sp16
        alg_params = {
            'INPUT': outputs['Point_end']['OUTPUT']
        }
        outputs['Polygon_sp16'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(77)
        if feedback.isCanceled():
            return {}

        # equality sign
        alg_params = {
            'FIELD_LENGTH': 3,
            'FIELD_NAME': 'equality',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\'=\'',
            'INPUT': outputs['Polygon_sp16']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['EqualitySign'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(78)
        if feedback.isCanceled():
            return {}

        # polygon_sp17
        alg_params = {
            'INPUT': outputs['EqualitySign']['OUTPUT']
        }
        outputs['Polygon_sp17'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(79)
        if feedback.isCanceled():
            return {}

        # c_length
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'length',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'case \r\nwhen round($length,2)like\'%.%\' and right(round($length,2),2)like\'%.%\' then round($length,2)||\'0\'\r\nwhen round($length,2) not like\'%.%\' then round($length,2)||\'.00\'\r\nelse round($length,2) end ||\' m\'\r\n',
            'INPUT': outputs['Polygon_sp17']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['C_length'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(80)
        if feedback.isCanceled():
            return {}

        # polygon_sp18
        alg_params = {
            'INPUT': outputs['C_length']['OUTPUT']
        }
        outputs['Polygon_sp18'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(81)
        if feedback.isCanceled():
            return {}

        # c_at
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'at',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\'AT\'',
            'INPUT': outputs['Polygon_sp18']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['C_at'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(82)
        if feedback.isCanceled():
            return {}

        # polygon_sp19
        alg_params = {
            'INPUT': outputs['C_at']['OUTPUT']
        }
        outputs['Polygon_sp19'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(83)
        if feedback.isCanceled():
            return {}

        # c_bearing
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'angle',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'case when floor(angle_at_vertex($geometry,num_points($geometry)-1))< 10 then \'0\'||floor(angle_at_vertex($geometry,num_points($geometry)-1)) else floor(angle_at_vertex($geometry,num_points($geometry)-1)) end|| \'°\'',
            'INPUT': outputs['Polygon_sp19']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['C_bearing'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(84)
        if feedback.isCanceled():
            return {}

        # polygon_sp20
        alg_params = {
            'INPUT': outputs['C_bearing']['OUTPUT']
        }
        outputs['Polygon_sp20'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(85)
        if feedback.isCanceled():
            return {}

        # c_minutes
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'minutes',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'case when to_int((angle_at_vertex($geometry,num_points($geometry)-1)-floor(angle_at_vertex($geometry,num_points($geometry)-1)))*60)< 10 then \'0\'||to_int((angle_at_vertex($geometry,num_points($geometry)-1)-floor(angle_at_vertex($geometry,num_points($geometry)-1)))*60) else to_int((angle_at_vertex($geometry,num_points($geometry)-1)-floor(angle_at_vertex($geometry,num_points($geometry)-1)))*60) end|| \'\'\'\'',
            'INPUT': outputs['Polygon_sp20']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['C_minutes'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(86)
        if feedback.isCanceled():
            return {}

        # polygon_sp21
        alg_params = {
            'INPUT': outputs['C_minutes']['OUTPUT']
        }
        outputs['Polygon_sp21'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(87)
        if feedback.isCanceled():
            return {}

        # Extract by expression
        alg_params = {
            'EXPRESSION': '\"point_start\" != \"point_end\"',
            'INPUT': outputs['Polygon_sp21']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ExtractByExpression'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(88)
        if feedback.isCanceled():
            return {}

        # polygon_sp22
        alg_params = {
            'INPUT': outputs['ExtractByExpression']['OUTPUT']
        }
        outputs['Polygon_sp22'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(89)
        if feedback.isCanceled():
            return {}

        # Bearing & Distance
        alg_params = {
            'FIELDS': QgsExpression('\'from;point_start;to;point_end;equality;length;at;angle;minutes\'').evaluate(),
            'INPUT': outputs['Polygon_sp22']['OUTPUT'],
            'OUTPUT': parameters['BearingDistance']
        }
        outputs['BearingDistance'] = processing.run('native:retainfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['BearingDistance'] = outputs['BearingDistance']['OUTPUT']

        feedback.setCurrentStep(90)
        if feedback.isCanceled():
            return {}


        # Set layer style
        alg_params = {
            'INPUT': outputs['BearingDistance']['OUTPUT'],
            'STYLE': os.path.join( os.path.dirname(__file__), "bearing_&_distance.qml" )
        }
        outputs['SetLayerStyle'] = processing.run('native:setlayerstyle', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        return results


    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'B & D(Single & Multiple Polygons_With Points)'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr(self.name())

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr(self.groupId())

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
     
    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return BearingDistance2Algorithm()
        
class BearingDistance3Algorithm(QgsProcessingAlgorithm):

    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterVectorLayer('Polygon1', 'Polygon', types=[QgsProcessing.TypeVectorPolygon], defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('Parcel', 'Parcel', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, supportsAppend=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('OutputPoints', 'Output Points', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, supportsAppend=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('BearingDistance', 'Bearing & Distance', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, supportsAppend=True, defaultValue=None))

    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        feedback = QgsProcessingMultiStepFeedback(102, model_feedback)
        results = {}
        outputs = {}

        # Selection
        alg_params = {
            'INPUT': parameters['Polygon1'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Selection'] = processing.run('native:saveselectedfeatures', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return {}

        # Create spatial index001
        alg_params = {
            'INPUT': outputs['Selection']['OUTPUT']
        }
        outputs['CreateSpatialIndex001'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(2)
        if feedback.isCanceled():
            return {}

        # Force right-hand-rule
        alg_params = {
            'INPUT': outputs['CreateSpatialIndex001']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ForceRighthandrule'] = processing.run('native:forcerhr', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(3)
        if feedback.isCanceled():
            return {}

        # Retain fields poly
        alg_params = {
            'FIELDS': [''],
            'INPUT': outputs['CreateSpatialIndex001']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RetainFieldsPoly'] = processing.run('native:retainfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(4)
        if feedback.isCanceled():
            return {}

        # Extract vertices
        alg_params = {
            'INPUT': outputs['CreateSpatialIndex001']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ExtractVertices'] = processing.run('native:extractvertices', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(5)
        if feedback.isCanceled():
            return {}

        # spinx_poly1
        alg_params = {
            'INPUT': outputs['RetainFieldsPoly']['OUTPUT']
        }
        outputs['Spinx_poly1'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(6)
        if feedback.isCanceled():
            return {}

        # csi4
        alg_params = {
            'INPUT': outputs['ForceRighthandrule']['OUTPUT']
        }
        outputs['Csi4'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(7)
        if feedback.isCanceled():
            return {}

        # spinx00
        alg_params = {
            'INPUT': outputs['ExtractVertices']['OUTPUT']
        }
        outputs['Spinx00'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(8)
        if feedback.isCanceled():
            return {}

        # Extract vertices
        alg_params = {
            'INPUT': outputs['Csi4']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ExtractVertices'] = processing.run('native:extractvertices', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(9)
        if feedback.isCanceled():
            return {}

        # Polygons to lines
        alg_params = {
            'INPUT': outputs['Csi4']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['PolygonsToLines'] = processing.run('native:polygonstolines', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(10)
        if feedback.isCanceled():
            return {}

        # Extract by attribute
        alg_params = {
            'FIELD': 'vertex_index',
            'INPUT': outputs['Spinx00']['OUTPUT'],
            'OPERATOR': 0,
            'VALUE': '0',
            'FAIL_OUTPUT': QgsProcessing.TEMPORARY_OUTPUT,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ExtractByAttribute'] = processing.run('native:extractbyattribute', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(11)
        if feedback.isCanceled():
            return {}

        # Add field to attributes table 1
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'plot_no',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'INPUT': outputs['Spinx_poly1']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['AddFieldToAttributesTable1'] = processing.run('native:addfieldtoattributestable', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(12)
        if feedback.isCanceled():
            return {}

        # spinx3
        alg_params = {
            'INPUT': outputs['ExtractVertices']['OUTPUT']
        }
        outputs['Spinx3'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(13)
        if feedback.isCanceled():
            return {}

        # spinx_poly2
        alg_params = {
            'INPUT': outputs['AddFieldToAttributesTable1']['OUTPUT']
        }
        outputs['Spinx_poly2'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(14)
        if feedback.isCanceled():
            return {}

        # spinx001
        alg_params = {
            'INPUT': outputs['ExtractByAttribute']['FAIL_OUTPUT']
        }
        outputs['Spinx001'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(15)
        if feedback.isCanceled():
            return {}

        # polygon_sp1
        alg_params = {
            'INPUT': outputs['PolygonsToLines']['OUTPUT']
        }
        outputs['Polygon_sp1'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(16)
        if feedback.isCanceled():
            return {}

        # Add field to attributes table 2
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'file_no',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'INPUT': outputs['Spinx_poly2']['OUTPUT'],
            'OUTPUT': parameters['Parcel']
        }
        outputs['AddFieldToAttributesTable2'] = processing.run('native:addfieldtoattributestable', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Parcel'] = outputs['AddFieldToAttributesTable2']['OUTPUT']

        feedback.setCurrentStep(17)
        if feedback.isCanceled():
            return {}

        # Set layer style
        alg_params = {
            'INPUT': outputs['AddFieldToAttributesTable2']['OUTPUT'],
            'STYLE': os.path.join( os.path.dirname(__file__), "parcel.qml" )
        }
        outputs['SetLayerStyle'] = processing.run('native:setlayerstyle', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(18)
        if feedback.isCanceled():
            return {}

        # Field calculator id
        alg_params = {
            'FIELD_LENGTH': 100,
            'FIELD_NAME': 'id',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '$id',
            'INPUT': outputs['Spinx001']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FieldCalculatorId'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(19)
        if feedback.isCanceled():
            return {}

        # Extract vertices Points
        alg_params = {
            'INPUT': outputs['Polygon_sp1']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ExtractVerticesPoints'] = processing.run('native:extractvertices', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(20)
        if feedback.isCanceled():
            return {}

        # Retain fields poly
        alg_params = {
            'FIELDS': [''],
            'INPUT': outputs['Polygon_sp1']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RetainFieldsPoly'] = processing.run('native:retainfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(21)
        if feedback.isCanceled():
            return {}

        # polygon_sp2
        alg_params = {
            'INPUT': outputs['RetainFieldsPoly']['OUTPUT']
        }
        outputs['Polygon_sp2'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(22)
        if feedback.isCanceled():
            return {}

        # spinx6
        alg_params = {
            'INPUT': outputs['ExtractVerticesPoints']['OUTPUT']
        }
        outputs['Spinx6'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(23)
        if feedback.isCanceled():
            return {}

        # spinx002
        alg_params = {
            'INPUT': outputs['FieldCalculatorId']['OUTPUT']
        }
        outputs['Spinx002'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(24)
        if feedback.isCanceled():
            return {}

        # Delete duplicate geometries new points
        alg_params = {
            'INPUT': outputs['Spinx002']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DeleteDuplicateGeometriesNewPoints'] = processing.run('native:deleteduplicategeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(25)
        if feedback.isCanceled():
            return {}

        # Explode lines
        alg_params = {
            'INPUT': outputs['Polygon_sp2']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ExplodeLines'] = processing.run('native:explodelines', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(26)
        if feedback.isCanceled():
            return {}

        # spinx003
        alg_params = {
            'INPUT': outputs['DeleteDuplicateGeometriesNewPoints']['OUTPUT']
        }
        outputs['Spinx003'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(27)
        if feedback.isCanceled():
            return {}

        # centroid_x
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'cx',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'x($geometry)',
            'INPUT': outputs['Polygon_sp2']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Centroid_x'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(28)
        if feedback.isCanceled():
            return {}

        # centroid_y
        alg_params = {
            'FIELD_LENGTH': 0,
            'FIELD_NAME': 'cy',
            'FIELD_PRECISION': 20,
            'FIELD_TYPE': 2,
            'FORMULA': 'y($geometry)',
            'INPUT': outputs['Centroid_x']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Centroid_y'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(29)
        if feedback.isCanceled():
            return {}

        # Field calculator New Points
        alg_params = {
            'FIELD_LENGTH': 200,
            'FIELD_NAME': 'point_no',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\'Point \'||vertex_part_index',
            'INPUT': outputs['Spinx003']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FieldCalculatorNewPoints'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(30)
        if feedback.isCanceled():
            return {}

        # Retain fields Points1
        alg_params = {
            'FIELDS': QgsExpression('\'angle\'').evaluate(),
            'INPUT': outputs['Spinx6']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RetainFieldsPoints1'] = processing.run('native:retainfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(31)
        if feedback.isCanceled():
            return {}

        # spinx004
        alg_params = {
            'INPUT': outputs['FieldCalculatorNewPoints']['OUTPUT']
        }
        outputs['Spinx004'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(32)
        if feedback.isCanceled():
            return {}

        # spinx7
        alg_params = {
            'INPUT': outputs['RetainFieldsPoints1']['OUTPUT']
        }
        outputs['Spinx7'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(33)
        if feedback.isCanceled():
            return {}

        # Retain fields points
        alg_params = {
            'FIELDS': QgsExpression('\'point_no\'').evaluate(),
            'INPUT': outputs['Spinx004']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RetainFieldsPoints'] = processing.run('native:retainfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(34)
        if feedback.isCanceled():
            return {}

        # polygon_sp3
        alg_params = {
            'INPUT': outputs['ExplodeLines']['OUTPUT']
        }
        outputs['Polygon_sp3'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(35)
        if feedback.isCanceled():
            return {}

        # point_sp1
        alg_params = {
            'INPUT': outputs['RetainFieldsPoints']['OUTPUT']
        }
        outputs['Point_sp1'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(36)
        if feedback.isCanceled():
            return {}

        # start field result
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 's_ref_id',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\'start\'',
            'INPUT': outputs['Point_sp1']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['StartFieldResult'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(37)
        if feedback.isCanceled():
            return {}

        # point_sp2
        alg_params = {
            'INPUT': outputs['StartFieldResult']['OUTPUT']
        }
        outputs['Point_sp2'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(38)
        if feedback.isCanceled():
            return {}

        # Delete duplicate geometries 1
        alg_params = {
            'INPUT': outputs['Polygon_sp3']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DeleteDuplicateGeometries1'] = processing.run('native:deleteduplicategeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(39)
        if feedback.isCanceled():
            return {}

        # Join attributes by location label
        alg_params = {
            'DISCARD_NONMATCHING': False,
            'INPUT': outputs['Point_sp1']['OUTPUT'],
            'JOIN': outputs['Centroid_y']['OUTPUT'],
            'JOIN_FIELDS': [''],
            'METHOD': 0,
            'PREDICATE': [0],
            'PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['JoinAttributesByLocationLabel'] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(40)
        if feedback.isCanceled():
            return {}

        # end field result
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'e_ref_id',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\'end\'',
            'INPUT': outputs['Point_sp2']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['EndFieldResult'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(41)
        if feedback.isCanceled():
            return {}

        # Select by location
        alg_params = {
            'INPUT': outputs['Point_sp1']['OUTPUT'],
            'INTERSECT': outputs['ExtractVertices']['OUTPUT'],
            'METHOD': 0,
            'PREDICATE': [0]
        }
        outputs['SelectByLocation'] = processing.run('native:selectbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(42)
        if feedback.isCanceled():
            return {}

        # polygon_sp4
        alg_params = {
            'INPUT': outputs['DeleteDuplicateGeometries1']['OUTPUT']
        }
        outputs['Polygon_sp4'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(43)
        if feedback.isCanceled():
            return {}

        # point_sp4
        alg_params = {
            'INPUT': outputs['EndFieldResult']['OUTPUT']
        }
        outputs['Point_sp4'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(44)
        if feedback.isCanceled():
            return {}

        # point_x
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'px',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '$x',
            'INPUT': outputs['JoinAttributesByLocationLabel']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Point_x'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(45)
        if feedback.isCanceled():
            return {}

        # end 2
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'p_ref_id',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'attribute(\'point_no\')',
            'INPUT': outputs['Point_sp4']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['End2'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(46)
        if feedback.isCanceled():
            return {}

        # point_y
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'py',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '$y',
            'INPUT': outputs['Point_x']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Point_y'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(47)
        if feedback.isCanceled():
            return {}

        # ps1
        alg_params = {
            'FIELD_LENGTH': 100,
            'FIELD_NAME': 'ps1',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '$x||\',\'||$y',
            'INPUT': outputs['Point_sp4']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Ps1'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(48)
        if feedback.isCanceled():
            return {}

        # ang_ref_id
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'ang_ref_id',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'floor(case\r\nwhen cy> py and cx>px then 90-( atan ((cy-py)/(cx-px))*180/$pi)\r\nwhen py> cy and cx>px then 90-( atan ((cy-py)/(cx-px))*180/$pi)\r\nwhen py> cy and px>cx then 270-( atan ((cy-py)/(cx-px))*180/$pi)\r\nwhen cy> py and px>cx then 270-( atan ((cy-py)/(cx-px))*180/$pi)\r\nwhen cy>py and px=cx then 0\r\nwhen py=cy and cx>px then 90\r\nwhen py>cy and px=cx then 180\r\nwhen py=cy and px>cx then 270\r\nend) + 90\r\n\r\n',
            'INPUT': outputs['Point_y']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Ang_ref_id'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(49)
        if feedback.isCanceled():
            return {}

        # Drop field(s)
        alg_params = {
            'COLUMN': QgsExpression('\'cx;cy;px;py\'').evaluate(),
            'INPUT': outputs['Ang_ref_id']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DropFields'] = processing.run('native:deletecolumn', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(50)
        if feedback.isCanceled():
            return {}

        # point_sp5
        alg_params = {
            'INPUT': outputs['End2']['OUTPUT']
        }
        outputs['Point_sp5'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(51)
        if feedback.isCanceled():
            return {}

        # point_sp6
        alg_params = {
            'INPUT': outputs['Ps1']['OUTPUT']
        }
        outputs['Point_sp6'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(52)
        if feedback.isCanceled():
            return {}

        # Join attributes by location
        alg_params = {
            'DISCARD_NONMATCHING': False,
            'INPUT': outputs['Polygon_sp3']['OUTPUT'],
            'JOIN': outputs['Point_sp6']['OUTPUT'],
            'JOIN_FIELDS': [''],
            'METHOD': 0,
            'PREDICATE': [0],
            'PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['JoinAttributesByLocation'] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(53)
        if feedback.isCanceled():
            return {}

        # Delete duplicate geometries points final
        alg_params = {
            'INPUT': outputs['DropFields']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DeleteDuplicateGeometriesPointsFinal'] = processing.run('native:deleteduplicategeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(54)
        if feedback.isCanceled():
            return {}

        # polygon_sp5
        alg_params = {
            'INPUT': outputs['JoinAttributesByLocation']['OUTPUT']
        }
        outputs['Polygon_sp5'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(55)
        if feedback.isCanceled():
            return {}

        # spinx8
        alg_params = {
            'INPUT': outputs['DeleteDuplicateGeometriesPointsFinal']['OUTPUT']
        }
        outputs['Spinx8'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(56)
        if feedback.isCanceled():
            return {}

        # Join attributes by location final
        alg_params = {
            'DISCARD_NONMATCHING': False,
            'INPUT': outputs['Spinx8']['OUTPUT'],
            'JOIN': outputs['Spinx7']['OUTPUT'],
            'JOIN_FIELDS': [''],
            'METHOD': 0,
            'PREDICATE': [0],
            'PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['JoinAttributesByLocationFinal'] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(57)
        if feedback.isCanceled():
            return {}

        # start extraction
        alg_params = {
            'EXPRESSION': 'xat(0)||\',\'||yat(0)!=\"ps1\"',
            'INPUT': outputs['Polygon_sp5']['OUTPUT'],
            'FAIL_OUTPUT': QgsProcessing.TEMPORARY_OUTPUT,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['StartExtraction'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(58)
        if feedback.isCanceled():
            return {}

        # spinx9
        alg_params = {
            'INPUT': outputs['JoinAttributesByLocationFinal']['OUTPUT']
        }
        outputs['Spinx9'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(59)
        if feedback.isCanceled():
            return {}

        # Delete duplicate geometries final
        alg_params = {
            'INPUT': outputs['Spinx9']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DeleteDuplicateGeometriesFinal'] = processing.run('native:deleteduplicategeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(60)
        if feedback.isCanceled():
            return {}

        # spinx10
        alg_params = {
            'INPUT': outputs['DeleteDuplicateGeometriesFinal']['OUTPUT']
        }
        outputs['Spinx10'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(61)
        if feedback.isCanceled():
            return {}

        # Drop field(s)
        alg_params = {
            'COLUMN': [''],
            'INPUT': outputs['StartExtraction']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DropFields'] = processing.run('native:deletecolumn', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(62)
        if feedback.isCanceled():
            return {}

        # polygon_sp6
        alg_params = {
            'INPUT': outputs['StartExtraction']['FAIL_OUTPUT']
        }
        outputs['Polygon_sp6'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(63)
        if feedback.isCanceled():
            return {}

        # Field calculator flayer
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'angle_ref_id1',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 1,
            'FORMULA': 'case when \"angle\" < 180 then (\"angle\"+ 180) else (\"angle\"-180) end',
            'INPUT': outputs['Spinx10']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FieldCalculatorFlayer'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['OutputPoints'] = outputs['FieldCalculatorFlayer']['OUTPUT']

        feedback.setCurrentStep(64)
        if feedback.isCanceled():
            return {}
            
        # Retain fields flayer
        alg_params = {
            'FIELDS': QgsExpression('\'point_no;angle_ref_id1\'').evaluate(),
            'INPUT': outputs['FieldCalculatorFlayer']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RetainFieldsFlayer'] = processing.run('native:retainfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['OutputPoints'] = outputs['RetainFieldsFlayer']['OUTPUT']

        feedback.setCurrentStep(66)
        if feedback.isCanceled():
            return {}
            
        # Field calculator xcoord
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'East',
            'FIELD_PRECISION': 3,
            'FIELD_TYPE': 0,
            'FORMULA': '$x',
            'INPUT': outputs['RetainFieldsFlayer']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FieldCalculatorXcoord'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(67)
        if feedback.isCanceled():
            return {}

        # Field calculator ycoord
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'North',
            'FIELD_PRECISION': 3,
            'FIELD_TYPE': 0,
            'FORMULA': '$y',
            'INPUT': outputs['FieldCalculatorXcoord']['OUTPUT'],
            'OUTPUT': parameters['OutputPoints']
        }
        outputs['FieldCalculatorYcoord'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['OutputPoints'] = outputs['FieldCalculatorYcoord']['OUTPUT']

        feedback.setCurrentStep(68)
        if feedback.isCanceled():
            return {}

        # Set layer style
        alg_params = {
            'INPUT': outputs['FieldCalculatorYcoord']['OUTPUT'],
            'STYLE': os.path.join( os.path.dirname(__file__), "survey_layout_labels.qml" )
        }
        outputs['SetLayerStyle'] = processing.run('native:setlayerstyle', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(65)
        if feedback.isCanceled():
            return {}

        # csi5
        alg_params = {
            'INPUT': outputs['FieldCalculatorFlayer']['OUTPUT']
        }
        outputs['Csi5'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(66)
        if feedback.isCanceled():
            return {}

        # delete first extraction
        alg_params = {
            'INPUT': outputs['Polygon_sp6']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DeleteFirstExtraction'] = processing.run('native:deleteduplicategeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(67)
        if feedback.isCanceled():
            return {}

        # Join attributes by location
        alg_params = {
            'DISCARD_NONMATCHING': False,
            'INPUT': outputs['Csi5']['OUTPUT'],
            'JOIN': outputs['Spinx002']['OUTPUT'],
            'JOIN_FIELDS': [''],
            'METHOD': 0,
            'PREDICATE': [0],
            'PREFIX': ''
        }
        outputs['JoinAttributesByLocation'] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(68)
        if feedback.isCanceled():
            return {}

        # polygon_sp7
        alg_params = {
            'INPUT': outputs['DeleteFirstExtraction']['OUTPUT']
        }
        outputs['Polygon_sp7'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(69)
        if feedback.isCanceled():
            return {}

        # bearing_distance join
        alg_params = {
            'DISCARD_NONMATCHING': False,
            'INPUT': outputs['Polygon_sp7']['OUTPUT'],
            'JOIN': outputs['Polygon_sp4']['OUTPUT'],
            'JOIN_FIELDS': [''],
            'METHOD': 0,
            'PREDICATE': [0],
            'PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Bearing_distanceJoin'] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(70)
        if feedback.isCanceled():
            return {}

        # polygon_sp8
        alg_params = {
            'INPUT': outputs['Bearing_distanceJoin']['OUTPUT']
        }
        outputs['Polygon_sp8'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(71)
        if feedback.isCanceled():
            return {}

        # deleted duplicate bearing distance
        alg_params = {
            'INPUT': outputs['Polygon_sp8']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DeletedDuplicateBearingDistance'] = processing.run('native:deleteduplicategeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(72)
        if feedback.isCanceled():
            return {}

        # polygon_sp9
        alg_params = {
            'INPUT': outputs['DeletedDuplicateBearingDistance']['OUTPUT']
        }
        outputs['Polygon_sp9'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(73)
        if feedback.isCanceled():
            return {}

        # deleted 2
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'p_ref_id_1',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'attribute(\'point_no\')',
            'INPUT': outputs['Polygon_sp9']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Deleted2'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(74)
        if feedback.isCanceled():
            return {}

        # polygon_sp10
        alg_params = {
            'INPUT': outputs['Deleted2']['OUTPUT']
        }
        outputs['Polygon_sp10'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(75)
        if feedback.isCanceled():
            return {}

        # end join
        alg_params = {
            'DISCARD_NONMATCHING': False,
            'INPUT': outputs['Polygon_sp10']['OUTPUT'],
            'JOIN': outputs['Point_sp5']['OUTPUT'],
            'JOIN_FIELDS': [''],
            'METHOD': 0,
            'PREDICATE': [0],
            'PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['EndJoin'] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(76)
        if feedback.isCanceled():
            return {}

        # polygon_sp11
        alg_params = {
            'INPUT': outputs['EndJoin']['OUTPUT']
        }
        outputs['Polygon_sp11'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(77)
        if feedback.isCanceled():
            return {}

        # Final Extract
        alg_params = {
            'EXPRESSION': 'xat(0)||\',\'||yat(0)=\"ps1\"  and    p_ref_id  !=   p_ref_id_1',
            'INPUT': outputs['Polygon_sp11']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FinalExtract'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(78)
        if feedback.isCanceled():
            return {}

        # polygon_sp12
        alg_params = {
            'INPUT': outputs['FinalExtract']['OUTPUT']
        }
        outputs['Polygon_sp12'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(79)
        if feedback.isCanceled():
            return {}

        # c_from
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'from',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\'FROM\'',
            'INPUT': outputs['Polygon_sp12']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['C_from'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(80)
        if feedback.isCanceled():
            return {}

        # polygon_sp13
        alg_params = {
            'INPUT': outputs['C_from']['OUTPUT']
        }
        outputs['Polygon_sp13'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(81)
        if feedback.isCanceled():
            return {}

        # point_start
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'point_start',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'p_ref_id_1',
            'INPUT': outputs['Polygon_sp13']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Point_start'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(82)
        if feedback.isCanceled():
            return {}

        # polygon_sp14
        alg_params = {
            'INPUT': outputs['Point_start']['OUTPUT']
        }
        outputs['Polygon_sp14'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(83)
        if feedback.isCanceled():
            return {}

        # c_to
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'to',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\'TO\'',
            'INPUT': outputs['Polygon_sp14']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['C_to'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(84)
        if feedback.isCanceled():
            return {}

        # polygon_sp15
        alg_params = {
            'INPUT': outputs['C_to']['OUTPUT']
        }
        outputs['Polygon_sp15'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(85)
        if feedback.isCanceled():
            return {}

        # point_end
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'point_end',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'p_ref_id',
            'INPUT': outputs['Polygon_sp15']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Point_end'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(86)
        if feedback.isCanceled():
            return {}

        # polygon_sp16
        alg_params = {
            'INPUT': outputs['Point_end']['OUTPUT']
        }
        outputs['Polygon_sp16'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(87)
        if feedback.isCanceled():
            return {}

        # equality sign
        alg_params = {
            'FIELD_LENGTH': 3,
            'FIELD_NAME': 'equality',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\'=\'',
            'INPUT': outputs['Polygon_sp16']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['EqualitySign'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(88)
        if feedback.isCanceled():
            return {}

        # polygon_sp17
        alg_params = {
            'INPUT': outputs['EqualitySign']['OUTPUT']
        }
        outputs['Polygon_sp17'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(89)
        if feedback.isCanceled():
            return {}

        # c_length
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'length',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'case \r\nwhen round($length,2)like\'%.%\' and right(round($length,2),2)like\'%.%\' then round($length,2)||\'0\'\r\nwhen round($length,2) not like\'%.%\' then round($length,2)||\'.00\'\r\nelse round($length,2) end ||\' m\'\r\n',
            'INPUT': outputs['Polygon_sp17']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['C_length'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(78)
        if feedback.isCanceled():
            return {}

        # polygon_sp18
        alg_params = {
            'INPUT': outputs['C_length']['OUTPUT']
        }
        outputs['Polygon_sp18'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(91)
        if feedback.isCanceled():
            return {}

        # c_at
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'at',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\'AT\'',
            'INPUT': outputs['Polygon_sp18']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['C_at'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(92)
        if feedback.isCanceled():
            return {}

        # polygon_sp19
        alg_params = {
            'INPUT': outputs['C_at']['OUTPUT']
        }
        outputs['Polygon_sp19'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(93)
        if feedback.isCanceled():
            return {}

        # c_bearing
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'angle',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'case when floor(angle_at_vertex($geometry,num_points($geometry)-1))< 10 then \'0\'||floor(angle_at_vertex($geometry,num_points($geometry)-1)) else floor(angle_at_vertex($geometry,num_points($geometry)-1)) end|| \'°\'',
            'INPUT': outputs['Polygon_sp19']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['C_bearing'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(94)
        if feedback.isCanceled():
            return {}

        # polygon_sp20
        alg_params = {
            'INPUT': outputs['C_bearing']['OUTPUT']
        }
        outputs['Polygon_sp20'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(95)
        if feedback.isCanceled():
            return {}

        # c_minutes
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'minutes',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'case when to_int((angle_at_vertex($geometry,num_points($geometry)-1)-floor(angle_at_vertex($geometry,num_points($geometry)-1)))*60)< 10 then \'0\'||to_int((angle_at_vertex($geometry,num_points($geometry)-1)-floor(angle_at_vertex($geometry,num_points($geometry)-1)))*60) else to_int((angle_at_vertex($geometry,num_points($geometry)-1)-floor(angle_at_vertex($geometry,num_points($geometry)-1)))*60) end|| \'\'\'\'',
            'INPUT': outputs['Polygon_sp20']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['C_minutes'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(96)
        if feedback.isCanceled():
            return {}

        # polygon_sp21
        alg_params = {
            'INPUT': outputs['C_minutes']['OUTPUT']
        }
        outputs['Polygon_sp21'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(97)
        if feedback.isCanceled():
            return {}

        # Extract by expression
        alg_params = {
            'EXPRESSION': '\"point_start\" != \"point_end\"',
            'INPUT': outputs['Polygon_sp21']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ExtractByExpression'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(98)
        if feedback.isCanceled():
            return {}

        # polygon_sp22
        alg_params = {
            'INPUT': outputs['ExtractByExpression']['OUTPUT']
        }
        outputs['Polygon_sp22'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(99)
        if feedback.isCanceled():
            return {}

        # Bearing & Distance
        alg_params = {
            'FIELDS': QgsExpression('\'from;point_start;to;point_end;equality;length;at;angle;minutes\'').evaluate(),
            'INPUT': outputs['Polygon_sp22']['OUTPUT'],
            'OUTPUT': parameters['BearingDistance']
        }
        outputs['BearingDistance'] = processing.run('native:retainfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['BearingDistance'] = outputs['BearingDistance']['OUTPUT']

        feedback.setCurrentStep(100)
        if feedback.isCanceled():
            return {}

        # Delete duplicate geometries
        alg_params = {
            'INPUT': outputs['BearingDistance']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DeleteDuplicateGeometries'] = processing.run('native:deleteduplicategeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(101)
        if feedback.isCanceled():
            return {}
        
        
        # Set layer style
        alg_params = {
            'INPUT': outputs['BearingDistance']['OUTPUT'],
            'STYLE': os.path.join( os.path.dirname(__file__), "bearing_&_distance.qml" )
        }
        outputs['SetLayerStyle'] = processing.run('native:setlayerstyle', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        return results
        
        # Delete duplicate geometries
        alg_params = {
            'INPUT': outputs['BearingDistance']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DeleteDuplicateGeometries'] = processing.run('native:deleteduplicategeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        return results


    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'B & D(Single Polygon_Without Points)'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr(self.name())

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr(self.groupId())

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
       

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return BearingDistance3Algorithm()
        
        

class BearingDistance4Algorithm(QgsProcessingAlgorithm):

    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterVectorLayer('Polygon1', 'Polygon', types=[QgsProcessing.TypeVectorPolygon], defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('Parcel', 'Parcel', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, supportsAppend=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('BearingDistance', 'Bearing & Distance', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, supportsAppend=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('OutputPoints', 'Output Points', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, supportsAppend=True, defaultValue=None))
        
        

    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        feedback = QgsProcessingMultiStepFeedback(99, model_feedback)
        results = {}
        outputs = {}

        # Selection
        alg_params = {
            'INPUT': parameters['Polygon1'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Selection'] = processing.run('native:saveselectedfeatures', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return {}

        # Create spatial index001
        alg_params = {
            'INPUT': outputs['Selection']['OUTPUT']
        }
        outputs['CreateSpatialIndex001'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(2)
        if feedback.isCanceled():
            return {}

        # Retain fields poly
        alg_params = {
            'FIELDS': [''],
            'INPUT': outputs['CreateSpatialIndex001']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RetainFieldsPoly'] = processing.run('native:retainfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(3)
        if feedback.isCanceled():
            return {}

        # Extract vertices
        alg_params = {
            'INPUT': outputs['CreateSpatialIndex001']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ExtractVertices'] = processing.run('native:extractvertices', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(4)
        if feedback.isCanceled():
            return {}

        # spinx_poly1
        alg_params = {
            'INPUT': outputs['RetainFieldsPoly']['OUTPUT']
        }
        outputs['Spinx_poly1'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(5)
        if feedback.isCanceled():
            return {}

        # Force right-hand-rule
        alg_params = {
            'INPUT': outputs['CreateSpatialIndex001']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ForceRighthandrule'] = processing.run('native:forcerhr', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(6)
        if feedback.isCanceled():
            return {}

        # spinx001
        alg_params = {
            'INPUT': outputs['ExtractVertices']['OUTPUT']
        }
        outputs['Spinx001'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(7)
        if feedback.isCanceled():
            return {}

        # Add field to attributes table 1
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'plot_no',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'INPUT': outputs['Spinx_poly1']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['AddFieldToAttributesTable1'] = processing.run('native:addfieldtoattributestable', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(8)
        if feedback.isCanceled():
            return {}

        # Field calculator id
        alg_params = {
            'FIELD_LENGTH': 100,
            'FIELD_NAME': 'id',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '$id',
            'INPUT': outputs['Spinx001']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FieldCalculatorId'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(9)
        if feedback.isCanceled():
            return {}

        # spinx_poly2
        alg_params = {
            'INPUT': outputs['AddFieldToAttributesTable1']['OUTPUT']
        }
        outputs['Spinx_poly2'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(10)
        if feedback.isCanceled():
            return {}

        # Create spatial index002
        alg_params = {
            'INPUT': outputs['ForceRighthandrule']['OUTPUT']
        }
        outputs['CreateSpatialIndex002'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(11)
        if feedback.isCanceled():
            return {}

        # Extract vertices
        alg_params = {
            'INPUT': outputs['CreateSpatialIndex002']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ExtractVertices'] = processing.run('native:extractvertices', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(12)
        if feedback.isCanceled():
            return {}

        # Polygons to lines
        alg_params = {
            'INPUT': outputs['CreateSpatialIndex002']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['PolygonsToLines'] = processing.run('native:polygonstolines', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(13)
        if feedback.isCanceled():
            return {}

        # Add field to attributes table 2
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'file_no',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'INPUT': outputs['Spinx_poly2']['OUTPUT'],
            'OUTPUT': parameters['Parcel']
        }
        outputs['AddFieldToAttributesTable2'] = processing.run('native:addfieldtoattributestable', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Parcel'] = outputs['AddFieldToAttributesTable2']['OUTPUT']

        feedback.setCurrentStep(14)
        if feedback.isCanceled():
            return {}

        # spinx3
        alg_params = {
            'INPUT': outputs['ExtractVertices']['OUTPUT']
        }
        outputs['Spinx3'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(15)
        if feedback.isCanceled():
            return {}

        # Set layer style
        alg_params = {
            'INPUT': outputs['AddFieldToAttributesTable2']['OUTPUT'],
            'STYLE': os.path.join( os.path.dirname(__file__), "parcel.qml" )
        }
        outputs['SetLayerStyle'] = processing.run('native:setlayerstyle', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(16)
        if feedback.isCanceled():
            return {}

        # spinx002
        alg_params = {
            'INPUT': outputs['FieldCalculatorId']['OUTPUT']
        }
        outputs['Spinx002'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(17)
        if feedback.isCanceled():
            return {}

        # Delete duplicate geometries new points
        alg_params = {
            'INPUT': outputs['Spinx002']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DeleteDuplicateGeometriesNewPoints'] = processing.run('native:deleteduplicategeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(18)
        if feedback.isCanceled():
            return {}

        # spinx003
        alg_params = {
            'INPUT': outputs['DeleteDuplicateGeometriesNewPoints']['OUTPUT']
        }
        outputs['Spinx003'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(19)
        if feedback.isCanceled():
            return {}

        # Field calculator New Points
        alg_params = {
            'FIELD_LENGTH': 200,
            'FIELD_NAME': 'point_no',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\'Point \'||$id',
            'INPUT': outputs['Spinx003']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FieldCalculatorNewPoints'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(20)
        if feedback.isCanceled():
            return {}

        # polygon_sp1
        alg_params = {
            'INPUT': outputs['PolygonsToLines']['OUTPUT']
        }
        outputs['Polygon_sp1'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(21)
        if feedback.isCanceled():
            return {}

        # spinx004
        alg_params = {
            'INPUT': outputs['FieldCalculatorNewPoints']['OUTPUT']
        }
        outputs['Spinx004'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(22)
        if feedback.isCanceled():
            return {}

        # Retain fields points
        alg_params = {
            'FIELDS': QgsExpression('\'point_no\'').evaluate(),
            'INPUT': outputs['Spinx004']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RetainFieldsPoints'] = processing.run('native:retainfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(23)
        if feedback.isCanceled():
            return {}

        # Extract vertices Points
        alg_params = {
            'INPUT': outputs['Polygon_sp1']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ExtractVerticesPoints'] = processing.run('native:extractvertices', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(24)
        if feedback.isCanceled():
            return {}

        # point_sp1
        alg_params = {
            'INPUT': outputs['RetainFieldsPoints']['OUTPUT']
        }
        outputs['Point_sp1'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(25)
        if feedback.isCanceled():
            return {}

        # start field result
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 's_ref_id',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\'start\'',
            'INPUT': outputs['Point_sp1']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['StartFieldResult'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(26)
        if feedback.isCanceled():
            return {}

        # point_sp2
        alg_params = {
            'INPUT': outputs['StartFieldResult']['OUTPUT']
        }
        outputs['Point_sp2'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(27)
        if feedback.isCanceled():
            return {}

        # Retain fields poly
        alg_params = {
            'FIELDS': [''],
            'INPUT': outputs['Polygon_sp1']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RetainFieldsPoly'] = processing.run('native:retainfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(28)
        if feedback.isCanceled():
            return {}

        # polygon_sp2
        alg_params = {
            'INPUT': outputs['RetainFieldsPoly']['OUTPUT']
        }
        outputs['Polygon_sp2'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(29)
        if feedback.isCanceled():
            return {}

        # spinx6
        alg_params = {
            'INPUT': outputs['ExtractVerticesPoints']['OUTPUT']
        }
        outputs['Spinx6'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(30)
        if feedback.isCanceled():
            return {}

        # end field result
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'e_ref_id',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\'end\'',
            'INPUT': outputs['Point_sp2']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['EndFieldResult'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(31)
        if feedback.isCanceled():
            return {}

        # Select by location
        alg_params = {
            'INPUT': outputs['Point_sp1']['OUTPUT'],
            'INTERSECT': outputs['ExtractVertices']['OUTPUT'],
            'METHOD': 0,
            'PREDICATE': [0]
        }
        outputs['SelectByLocation'] = processing.run('native:selectbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(32)
        if feedback.isCanceled():
            return {}

        # Explode lines
        alg_params = {
            'INPUT': outputs['Polygon_sp2']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ExplodeLines'] = processing.run('native:explodelines', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(33)
        if feedback.isCanceled():
            return {}

        # point_sp4
        alg_params = {
            'INPUT': outputs['EndFieldResult']['OUTPUT']
        }
        outputs['Point_sp4'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(34)
        if feedback.isCanceled():
            return {}

        # centroid_x
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'cx',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'x($geometry)',
            'INPUT': outputs['RetainFieldsPoly']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Centroid_x'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(35)
        if feedback.isCanceled():
            return {}

        # centroid_y
        alg_params = {
            'FIELD_LENGTH': 0,
            'FIELD_NAME': 'cy',
            'FIELD_PRECISION': 20,
            'FIELD_TYPE': 2,
            'FORMULA': 'y($geometry)',
            'INPUT': outputs['Centroid_x']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Centroid_y'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(36)
        if feedback.isCanceled():
            return {}

        # Retain fields Points1
        alg_params = {
            'FIELDS': QgsExpression('\'angle\'').evaluate(),
            'INPUT': outputs['Spinx6']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RetainFieldsPoints1'] = processing.run('native:retainfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(37)
        if feedback.isCanceled():
            return {}

        # Join attributes by location label
        alg_params = {
            'DISCARD_NONMATCHING': False,
            'INPUT': outputs['Point_sp1']['OUTPUT'],
            'JOIN': outputs['Centroid_y']['OUTPUT'],
            'JOIN_FIELDS': [''],
            'METHOD': 0,
            'PREDICATE': [0],
            'PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['JoinAttributesByLocationLabel'] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(38)
        if feedback.isCanceled():
            return {}

        # spinx7
        alg_params = {
            'INPUT': outputs['RetainFieldsPoints1']['OUTPUT']
        }
        outputs['Spinx7'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(39)
        if feedback.isCanceled():
            return {}

        # end 2
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'p_ref_id',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'attribute(\'point_no\')',
            'INPUT': outputs['Point_sp4']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['End2'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(40)
        if feedback.isCanceled():
            return {}

        # ps1
        alg_params = {
            'FIELD_LENGTH': 100,
            'FIELD_NAME': 'ps1',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '$x||\',\'||$y',
            'INPUT': outputs['Point_sp4']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Ps1'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(41)
        if feedback.isCanceled():
            return {}

        # polygon_sp3
        alg_params = {
            'INPUT': outputs['ExplodeLines']['OUTPUT']
        }
        outputs['Polygon_sp3'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(42)
        if feedback.isCanceled():
            return {}

        # point_sp5
        alg_params = {
            'INPUT': outputs['End2']['OUTPUT']
        }
        outputs['Point_sp5'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(43)
        if feedback.isCanceled():
            return {}

        # point_x
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'px',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '$x',
            'INPUT': outputs['JoinAttributesByLocationLabel']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Point_x'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(44)
        if feedback.isCanceled():
            return {}

        # Delete duplicate geometries 1
        alg_params = {
            'INPUT': outputs['Polygon_sp3']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DeleteDuplicateGeometries1'] = processing.run('native:deleteduplicategeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(45)
        if feedback.isCanceled():
            return {}

        # point_sp6
        alg_params = {
            'INPUT': outputs['Ps1']['OUTPUT']
        }
        outputs['Point_sp6'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(46)
        if feedback.isCanceled():
            return {}

        # Join attributes by location
        alg_params = {
            'DISCARD_NONMATCHING': False,
            'INPUT': outputs['Polygon_sp3']['OUTPUT'],
            'JOIN': outputs['Point_sp6']['OUTPUT'],
            'JOIN_FIELDS': [''],
            'METHOD': 0,
            'PREDICATE': [0],
            'PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['JoinAttributesByLocation'] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(47)
        if feedback.isCanceled():
            return {}

        # point_y
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'py',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '$y',
            'INPUT': outputs['Point_x']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Point_y'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(48)
        if feedback.isCanceled():
            return {}

        # ang_ref_id
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'ang_ref_id',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'floor(case\r\nwhen cy> py and cx>px then 90-( atan ((cy-py)/(cx-px))*180/$pi)\r\nwhen py> cy and cx>px then 90-( atan ((cy-py)/(cx-px))*180/$pi)\r\nwhen py> cy and px>cx then 270-( atan ((cy-py)/(cx-px))*180/$pi)\r\nwhen cy> py and px>cx then 270-( atan ((cy-py)/(cx-px))*180/$pi)\r\nwhen cy>py and px=cx then 0\r\nwhen py=cy and cx>px then 90\r\nwhen py>cy and px=cx then 180\r\nwhen py=cy and px>cx then 270\r\nend) + 90\r\n\r\n',
            'INPUT': outputs['Point_y']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Ang_ref_id'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(49)
        if feedback.isCanceled():
            return {}

        # polygon_sp4
        alg_params = {
            'INPUT': outputs['DeleteDuplicateGeometries1']['OUTPUT']
        }
        outputs['Polygon_sp4'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(50)
        if feedback.isCanceled():
            return {}

        # Drop field(s)
        alg_params = {
            'COLUMN': QgsExpression('\'cx;cy;px;py\'').evaluate(),
            'INPUT': outputs['Ang_ref_id']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DropFields'] = processing.run('native:deletecolumn', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(51)
        if feedback.isCanceled():
            return {}

        # polygon_sp5
        alg_params = {
            'INPUT': outputs['JoinAttributesByLocation']['OUTPUT']
        }
        outputs['Polygon_sp5'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(52)
        if feedback.isCanceled():
            return {}

        # Delete duplicate geometries points final
        alg_params = {
            'INPUT': outputs['DropFields']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DeleteDuplicateGeometriesPointsFinal'] = processing.run('native:deleteduplicategeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(53)
        if feedback.isCanceled():
            return {}

        # start extraction
        alg_params = {
            'EXPRESSION': 'xat(0)||\',\'||yat(0)!=\"ps1\"',
            'INPUT': outputs['Polygon_sp5']['OUTPUT'],
            'FAIL_OUTPUT': QgsProcessing.TEMPORARY_OUTPUT,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['StartExtraction'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(54)
        if feedback.isCanceled():
            return {}

        # spinx8
        alg_params = {
            'INPUT': outputs['DeleteDuplicateGeometriesPointsFinal']['OUTPUT']
        }
        outputs['Spinx8'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(55)
        if feedback.isCanceled():
            return {}

        # Join attributes by location final
        alg_params = {
            'DISCARD_NONMATCHING': False,
            'INPUT': outputs['Spinx8']['OUTPUT'],
            'JOIN': outputs['Spinx7']['OUTPUT'],
            'JOIN_FIELDS': [''],
            'METHOD': 0,
            'PREDICATE': [0],
            'PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['JoinAttributesByLocationFinal'] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(56)
        if feedback.isCanceled():
            return {}

        # Drop field(s)
        alg_params = {
            'COLUMN': [''],
            'INPUT': outputs['StartExtraction']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DropFields'] = processing.run('native:deletecolumn', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(57)
        if feedback.isCanceled():
            return {}

        # polygon_sp6
        alg_params = {
            'INPUT': outputs['StartExtraction']['FAIL_OUTPUT']
        }
        outputs['Polygon_sp6'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(58)
        if feedback.isCanceled():
            return {}

        # spinx9
        alg_params = {
            'INPUT': outputs['JoinAttributesByLocationFinal']['OUTPUT']
        }
        outputs['Spinx9'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(59)
        if feedback.isCanceled():
            return {}

        # Delete duplicate geometries final
        alg_params = {
            'INPUT': outputs['Spinx9']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DeleteDuplicateGeometriesFinal'] = processing.run('native:deleteduplicategeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(60)
        if feedback.isCanceled():
            return {}

        # spinx10
        alg_params = {
            'INPUT': outputs['DeleteDuplicateGeometriesFinal']['OUTPUT']
        }
        outputs['Spinx10'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(61)
        if feedback.isCanceled():
            return {}

        # delete first extraction
        alg_params = {
            'INPUT': outputs['Polygon_sp6']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DeleteFirstExtraction'] = processing.run('native:deleteduplicategeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(62)
        if feedback.isCanceled():
            return {}

        # Field calculator flayer
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'angle_ref_id1',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 1,
            'FORMULA': 'case when \"angle\" < 180 then (\"angle\"+ 180) else (\"angle\"-180) end',
            'INPUT': outputs['Spinx10']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FieldCalculatorFlayer'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['OutputPoints'] = outputs['FieldCalculatorFlayer']['OUTPUT']

        feedback.setCurrentStep(63)
        if feedback.isCanceled():
            return {}
            
        # Retain fields flayer
        alg_params = {
            'FIELDS': QgsExpression('\'point_no;angle_ref_id1\'').evaluate(),
            'INPUT': outputs['FieldCalculatorFlayer']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RetainFieldsFlayer'] = processing.run('native:retainfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['OutputPoints'] = outputs['RetainFieldsFlayer']['OUTPUT']

        feedback.setCurrentStep(66)
        if feedback.isCanceled():
            return {}
            
        # Field calculator xcoord
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'East',
            'FIELD_PRECISION': 3,
            'FIELD_TYPE': 0,
            'FORMULA': '$x',
            'INPUT': outputs['RetainFieldsFlayer']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FieldCalculatorXcoord'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(67)
        if feedback.isCanceled():
            return {}

        # Field calculator ycoord
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'North',
            'FIELD_PRECISION': 3,
            'FIELD_TYPE': 0,
            'FORMULA': '$y',
            'INPUT': outputs['FieldCalculatorXcoord']['OUTPUT'],
            'OUTPUT': parameters['OutputPoints']
        }
        outputs['FieldCalculatorYcoord'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['OutputPoints'] = outputs['FieldCalculatorYcoord']['OUTPUT']

        feedback.setCurrentStep(68)
        if feedback.isCanceled():
            return {}

        # Set layer style
        alg_params = {
            'INPUT': outputs['FieldCalculatorYcoord']['OUTPUT'],
            'STYLE': os.path.join( os.path.dirname(__file__), "survey_layout_labels.qml" )
        }
        outputs['SetLayerStyle'] = processing.run('native:setlayerstyle', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(64)
        if feedback.isCanceled():
            return {}

        # polygon_sp7
        alg_params = {
            'INPUT': outputs['DeleteFirstExtraction']['OUTPUT']
        }
        outputs['Polygon_sp7'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(65)
        if feedback.isCanceled():
            return {}

        # bearing_distance join
        alg_params = {
            'DISCARD_NONMATCHING': False,
            'INPUT': outputs['Polygon_sp7']['OUTPUT'],
            'JOIN': outputs['Polygon_sp4']['OUTPUT'],
            'JOIN_FIELDS': [''],
            'METHOD': 0,
            'PREDICATE': [0],
            'PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Bearing_distanceJoin'] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(66)
        if feedback.isCanceled():
            return {}

        # Join attributes by location
        alg_params = {
            'DISCARD_NONMATCHING': False,
            'INPUT': outputs['FieldCalculatorFlayer']['OUTPUT'],
            'JOIN': outputs['FieldCalculatorId']['OUTPUT'],
            'JOIN_FIELDS': [''],
            'METHOD': 0,
            'PREDICATE': [0],
            'PREFIX': ''
        }
        outputs['JoinAttributesByLocation'] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(67)
        if feedback.isCanceled():
            return {}

        # polygon_sp8
        alg_params = {
            'INPUT': outputs['Bearing_distanceJoin']['OUTPUT']
        }
        outputs['Polygon_sp8'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(68)
        if feedback.isCanceled():
            return {}

        # deleted duplicate bearing distance
        alg_params = {
            'INPUT': outputs['Polygon_sp8']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DeletedDuplicateBearingDistance'] = processing.run('native:deleteduplicategeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(69)
        if feedback.isCanceled():
            return {}

        # polygon_sp9
        alg_params = {
            'INPUT': outputs['DeletedDuplicateBearingDistance']['OUTPUT']
        }
        outputs['Polygon_sp9'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(70)
        if feedback.isCanceled():
            return {}

        # deleted 2
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'p_ref_id_1',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'attribute(\'point_no\')',
            'INPUT': outputs['Polygon_sp9']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Deleted2'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(71)
        if feedback.isCanceled():
            return {}

        # polygon_sp10
        alg_params = {
            'INPUT': outputs['Deleted2']['OUTPUT']
        }
        outputs['Polygon_sp10'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(72)
        if feedback.isCanceled():
            return {}

        # end join
        alg_params = {
            'DISCARD_NONMATCHING': False,
            'INPUT': outputs['Polygon_sp10']['OUTPUT'],
            'JOIN': outputs['Point_sp5']['OUTPUT'],
            'JOIN_FIELDS': [''],
            'METHOD': 0,
            'PREDICATE': [0],
            'PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['EndJoin'] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(73)
        if feedback.isCanceled():
            return {}

        # polygon_sp11
        alg_params = {
            'INPUT': outputs['EndJoin']['OUTPUT']
        }
        outputs['Polygon_sp11'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(74)
        if feedback.isCanceled():
            return {}

        # Final Extract
        alg_params = {
            'EXPRESSION': 'xat(0)||\',\'||yat(0)=\"ps1\"  and    p_ref_id  !=   p_ref_id_1',
            'INPUT': outputs['Polygon_sp11']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FinalExtract'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(75)
        if feedback.isCanceled():
            return {}

        # polygon_sp12
        alg_params = {
            'INPUT': outputs['FinalExtract']['OUTPUT']
        }
        outputs['Polygon_sp12'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(76)
        if feedback.isCanceled():
            return {}

        # c_from
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'from',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\'FROM\'',
            'INPUT': outputs['Polygon_sp12']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['C_from'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(77)
        if feedback.isCanceled():
            return {}

        # polygon_sp13
        alg_params = {
            'INPUT': outputs['C_from']['OUTPUT']
        }
        outputs['Polygon_sp13'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(78)
        if feedback.isCanceled():
            return {}

        # point_start
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'point_start',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'p_ref_id_1',
            'INPUT': outputs['Polygon_sp13']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Point_start'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(79)
        if feedback.isCanceled():
            return {}

        # polygon_sp14
        alg_params = {
            'INPUT': outputs['Point_start']['OUTPUT']
        }
        outputs['Polygon_sp14'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(80)
        if feedback.isCanceled():
            return {}

        # c_to
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'to',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\'TO\'',
            'INPUT': outputs['Polygon_sp14']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['C_to'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(81)
        if feedback.isCanceled():
            return {}

        # polygon_sp15
        alg_params = {
            'INPUT': outputs['C_to']['OUTPUT']
        }
        outputs['Polygon_sp15'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(82)
        if feedback.isCanceled():
            return {}

        # point_end
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'point_end',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'p_ref_id',
            'INPUT': outputs['Polygon_sp15']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Point_end'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(83)
        if feedback.isCanceled():
            return {}

        # polygon_sp16
        alg_params = {
            'INPUT': outputs['Point_end']['OUTPUT']
        }
        outputs['Polygon_sp16'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(84)
        if feedback.isCanceled():
            return {}

        # equality sign
        alg_params = {
            'FIELD_LENGTH': 3,
            'FIELD_NAME': 'equality',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\'=\'',
            'INPUT': outputs['Polygon_sp16']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['EqualitySign'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(85)
        if feedback.isCanceled():
            return {}

        # polygon_sp17
        alg_params = {
            'INPUT': outputs['EqualitySign']['OUTPUT']
        }
        outputs['Polygon_sp17'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(86)
        if feedback.isCanceled():
            return {}

        # c_length
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'length',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'case \r\nwhen round($length,2)like\'%.%\' and right(round($length,2),2)like\'%.%\' then round($length,2)||\'0\'\r\nwhen round($length,2) not like\'%.%\' then round($length,2)||\'.00\'\r\nelse round($length,2) end ||\' m\'\r\n',
            'INPUT': outputs['Polygon_sp17']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['C_length'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(78)
        if feedback.isCanceled():
            return {}

        # polygon_sp18
        alg_params = {
            'INPUT': outputs['C_length']['OUTPUT']
        }
        outputs['Polygon_sp18'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(88)
        if feedback.isCanceled():
            return {}

        # c_at
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'at',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\'AT\'',
            'INPUT': outputs['Polygon_sp18']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['C_at'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(89)
        if feedback.isCanceled():
            return {}

        # polygon_sp19
        alg_params = {
            'INPUT': outputs['C_at']['OUTPUT']
        }
        outputs['Polygon_sp19'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(90)
        if feedback.isCanceled():
            return {}

        # c_bearing
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'angle',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'case when floor(angle_at_vertex($geometry,num_points($geometry)-1))< 10 then \'0\'||floor(angle_at_vertex($geometry,num_points($geometry)-1)) else floor(angle_at_vertex($geometry,num_points($geometry)-1)) end|| \'°\'',
            'INPUT': outputs['Polygon_sp19']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['C_bearing'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(91)
        if feedback.isCanceled():
            return {}

        # polygon_sp20
        alg_params = {
            'INPUT': outputs['C_bearing']['OUTPUT']
        }
        outputs['Polygon_sp20'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(92)
        if feedback.isCanceled():
            return {}

        # c_minutes
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'minutes',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'case when to_int((angle_at_vertex($geometry,num_points($geometry)-1)-floor(angle_at_vertex($geometry,num_points($geometry)-1)))*60)< 10 then \'0\'||to_int((angle_at_vertex($geometry,num_points($geometry)-1)-floor(angle_at_vertex($geometry,num_points($geometry)-1)))*60) else to_int((angle_at_vertex($geometry,num_points($geometry)-1)-floor(angle_at_vertex($geometry,num_points($geometry)-1)))*60) end|| \'\'\'\'',
            'INPUT': outputs['Polygon_sp20']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['C_minutes'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(93)
        if feedback.isCanceled():
            return {}

        # polygon_sp21
        alg_params = {
            'INPUT': outputs['C_minutes']['OUTPUT']
        }
        outputs['Polygon_sp21'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(94)
        if feedback.isCanceled():
            return {}

        # Extract by expression
        alg_params = {
            'EXPRESSION': '\"point_start\" != \"point_end\"',
            'INPUT': outputs['Polygon_sp21']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ExtractByExpression'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(95)
        if feedback.isCanceled():
            return {}

        # polygon_sp22
        alg_params = {
            'INPUT': outputs['ExtractByExpression']['OUTPUT']
        }
        outputs['Polygon_sp22'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(96)
        if feedback.isCanceled():
            return {}

        # Bearing & Distance
        alg_params = {
            'FIELDS': QgsExpression('\'from;point_start;to;point_end;equality;length;at;angle;minutes\'').evaluate(),
            'INPUT': outputs['Polygon_sp22']['OUTPUT'],
            'OUTPUT': parameters['BearingDistance']
        }
        outputs['BearingDistance'] = processing.run('native:retainfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['BearingDistance'] = outputs['BearingDistance']['OUTPUT']

        feedback.setCurrentStep(97)
        if feedback.isCanceled():
            return {}

        # Delete duplicate geometries
        alg_params = {
            'INPUT': outputs['BearingDistance']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DeleteDuplicateGeometries'] = processing.run('native:deleteduplicategeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(98)
        if feedback.isCanceled():
            return {}
        
        
        # Set layer style
        alg_params = {
            'INPUT': outputs['BearingDistance']['OUTPUT'],
            'STYLE': os.path.join( os.path.dirname(__file__), "bearing_&_distance.qml" )
        }
        outputs['SetLayerStyle'] = processing.run('native:setlayerstyle', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        return results


    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'B & D(Multiple Polygons_Without Points)'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr(self.name())

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr(self.groupId())

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
       

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return BearingDistance4Algorithm()
        
        
class BearingDistance5Algorithm(QgsProcessingAlgorithm):
    
    def initAlgorithm(self, config=None):
        
        self.addParameter(QgsProcessingParameterVectorLayer('Polygon', 'Polygon', types=[QgsProcessing.TypeVectorPolygon], defaultValue=None))
        self.addParameter(QgsProcessingParameterField('FieldInput', 'Polygon Field', type=QgsProcessingParameterField.String, parentLayerParameterName='Polygon', allowMultiple=False, defaultValue=''))
        self.addParameter(QgsProcessingParameterString('Input', 'Polygon Field Input', multiLine=False, defaultValue=''))
        self.addParameter(QgsProcessingParameterFeatureSink('Parcel', 'Parcel', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, supportsAppend=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('OutputPoints', 'Output Points', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, supportsAppend=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('BearingDistance', 'Bearing & Distance', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, supportsAppend=True, defaultValue=None))

    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        feedback = QgsProcessingMultiStepFeedback(104, model_feedback)
        results = {}
        outputs = {}

        # Select by attribute
        alg_params = {
            'FIELD': parameters['FieldInput'],
            'INPUT': parameters['Polygon'],
            'METHOD': 0,
            'OPERATOR': 0,
            'VALUE': parameters['Input']
        }
        outputs['SelectByAttribute'] = processing.run('qgis:selectbyattribute', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return {}

        # Create spatial index001
        alg_params = {
            'INPUT': outputs['SelectByAttribute']['OUTPUT']
        }
        outputs['CreateSpatialIndex001'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(2)
        if feedback.isCanceled():
            return {}

        # Selection
        alg_params = {
            'INPUT': outputs['CreateSpatialIndex001']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Selection'] = processing.run('native:saveselectedfeatures', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(3)
        if feedback.isCanceled():
            return {}

        # Create spatial index002
        alg_params = {
            'INPUT': outputs['Selection']['OUTPUT']
        }
        outputs['CreateSpatialIndex002'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(4)
        if feedback.isCanceled():
            return {}

        # Retain fields poly
        alg_params = {
            'FIELDS': [''],
            'INPUT': outputs['CreateSpatialIndex002']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RetainFieldsPoly'] = processing.run('native:retainfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(5)
        if feedback.isCanceled():
            return {}

        # spinx_poly1
        alg_params = {
            'INPUT': outputs['RetainFieldsPoly']['OUTPUT']
        }
        outputs['Spinx_poly1'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(6)
        if feedback.isCanceled():
            return {}

        # Force right-hand-rule
        alg_params = {
            'INPUT': outputs['CreateSpatialIndex002']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ForceRighthandrule'] = processing.run('native:forcerhr', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(7)
        if feedback.isCanceled():
            return {}

        # Add field to attributes table 1
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'plot_no',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'INPUT': outputs['Spinx_poly1']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['AddFieldToAttributesTable1'] = processing.run('native:addfieldtoattributestable', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(8)
        if feedback.isCanceled():
            return {}

        # Extract vertices
        alg_params = {
            'INPUT': outputs['CreateSpatialIndex002']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ExtractVertices'] = processing.run('native:extractvertices', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(9)
        if feedback.isCanceled():
            return {}

        # csi4
        alg_params = {
            'INPUT': outputs['ForceRighthandrule']['OUTPUT']
        }
        outputs['Csi4'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(10)
        if feedback.isCanceled():
            return {}

        # Polygons to lines
        alg_params = {
            'INPUT': outputs['Csi4']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['PolygonsToLines'] = processing.run('native:polygonstolines', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(11)
        if feedback.isCanceled():
            return {}

        # spinx_poly2
        alg_params = {
            'INPUT': outputs['AddFieldToAttributesTable1']['OUTPUT']
        }
        outputs['Spinx_poly2'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(12)
        if feedback.isCanceled():
            return {}

        # Extract vertices
        alg_params = {
            'INPUT': outputs['Csi4']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ExtractVertices'] = processing.run('native:extractvertices', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(13)
        if feedback.isCanceled():
            return {}

        # spinx00
        alg_params = {
            'INPUT': outputs['ExtractVertices']['OUTPUT']
        }
        outputs['Spinx00'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(14)
        if feedback.isCanceled():
            return {}

        # spinx3
        alg_params = {
            'INPUT': outputs['ExtractVertices']['OUTPUT']
        }
        outputs['Spinx3'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(15)
        if feedback.isCanceled():
            return {}

        # Extract by attribute
        alg_params = {
            'FIELD': 'vertex_index',
            'INPUT': outputs['Spinx00']['OUTPUT'],
            'OPERATOR': 0,
            'VALUE': '0',
            'FAIL_OUTPUT': QgsProcessing.TEMPORARY_OUTPUT,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ExtractByAttribute'] = processing.run('native:extractbyattribute', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(16)
        if feedback.isCanceled():
            return {}

        # Add field to attributes table 2
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'file_no',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'INPUT': outputs['Spinx_poly2']['OUTPUT'],
            'OUTPUT': parameters['Parcel']
        }
        outputs['AddFieldToAttributesTable2'] = processing.run('native:addfieldtoattributestable', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Parcel'] = outputs['AddFieldToAttributesTable2']['OUTPUT']

        feedback.setCurrentStep(17)
        if feedback.isCanceled():
            return {}

        # polygon_sp1
        alg_params = {
            'INPUT': outputs['PolygonsToLines']['OUTPUT']
        }
        outputs['Polygon_sp1'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(18)
        if feedback.isCanceled():
            return {}

        # Retain fields poly
        alg_params = {
            'FIELDS': [''],
            'INPUT': outputs['Polygon_sp1']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RetainFieldsPoly'] = processing.run('native:retainfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(19)
        if feedback.isCanceled():
            return {}

        # Set layer style
        alg_params = {
            'INPUT': outputs['AddFieldToAttributesTable2']['OUTPUT'],
            'STYLE': os.path.join( os.path.dirname(__file__), "parcel.qml" )
        }
        outputs['SetLayerStyle'] = processing.run('native:setlayerstyle', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(20)
        if feedback.isCanceled():
            return {}

        # spinx001
        alg_params = {
            'INPUT': outputs['ExtractByAttribute']['FAIL_OUTPUT']
        }
        outputs['Spinx001'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(21)
        if feedback.isCanceled():
            return {}

        # Extract vertices Points
        alg_params = {
            'INPUT': outputs['Polygon_sp1']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ExtractVerticesPoints'] = processing.run('native:extractvertices', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(22)
        if feedback.isCanceled():
            return {}

        # polygon_sp2
        alg_params = {
            'INPUT': outputs['RetainFieldsPoly']['OUTPUT']
        }
        outputs['Polygon_sp2'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(23)
        if feedback.isCanceled():
            return {}

        # centroid_x
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'cx',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'x($geometry)',
            'INPUT': outputs['Polygon_sp2']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Centroid_x'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(24)
        if feedback.isCanceled():
            return {}

        # Field calculator id
        alg_params = {
            'FIELD_LENGTH': 100,
            'FIELD_NAME': 'id',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '$id',
            'INPUT': outputs['Spinx001']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FieldCalculatorId'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(25)
        if feedback.isCanceled():
            return {}

        # centroid_y
        alg_params = {
            'FIELD_LENGTH': 0,
            'FIELD_NAME': 'cy',
            'FIELD_PRECISION': 20,
            'FIELD_TYPE': 2,
            'FORMULA': 'y($geometry)',
            'INPUT': outputs['Centroid_x']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Centroid_y'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(26)
        if feedback.isCanceled():
            return {}

        # Explode lines
        alg_params = {
            'INPUT': outputs['Polygon_sp2']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ExplodeLines'] = processing.run('native:explodelines', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(27)
        if feedback.isCanceled():
            return {}

        # spinx6
        alg_params = {
            'INPUT': outputs['ExtractVerticesPoints']['OUTPUT']
        }
        outputs['Spinx6'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(28)
        if feedback.isCanceled():
            return {}

        # spinx002
        alg_params = {
            'INPUT': outputs['FieldCalculatorId']['OUTPUT']
        }
        outputs['Spinx002'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(29)
        if feedback.isCanceled():
            return {}

        # Retain fields Points1
        alg_params = {
            'FIELDS': QgsExpression('\'angle\'').evaluate(),
            'INPUT': outputs['Spinx6']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RetainFieldsPoints1'] = processing.run('native:retainfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(30)
        if feedback.isCanceled():
            return {}

        # polygon_sp3
        alg_params = {
            'INPUT': outputs['ExplodeLines']['OUTPUT']
        }
        outputs['Polygon_sp3'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(31)
        if feedback.isCanceled():
            return {}

        # Delete duplicate geometries new points
        alg_params = {
            'INPUT': outputs['Spinx002']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DeleteDuplicateGeometriesNewPoints'] = processing.run('native:deleteduplicategeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(32)
        if feedback.isCanceled():
            return {}

        # spinx003
        alg_params = {
            'INPUT': outputs['DeleteDuplicateGeometriesNewPoints']['OUTPUT']
        }
        outputs['Spinx003'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(33)
        if feedback.isCanceled():
            return {}

        # spinx7
        alg_params = {
            'INPUT': outputs['RetainFieldsPoints1']['OUTPUT']
        }
        outputs['Spinx7'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(34)
        if feedback.isCanceled():
            return {}

        # Delete duplicate geometries 1
        alg_params = {
            'INPUT': outputs['Polygon_sp3']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DeleteDuplicateGeometries1'] = processing.run('native:deleteduplicategeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(35)
        if feedback.isCanceled():
            return {}

        # Field calculator New Points
        alg_params = {
            'FIELD_LENGTH': 200,
            'FIELD_NAME': 'point_no',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\'Point \'||vertex_part_index',
            'INPUT': outputs['Spinx003']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FieldCalculatorNewPoints'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(36)
        if feedback.isCanceled():
            return {}

        # polygon_sp4
        alg_params = {
            'INPUT': outputs['DeleteDuplicateGeometries1']['OUTPUT']
        }
        outputs['Polygon_sp4'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(37)
        if feedback.isCanceled():
            return {}

        # spinx004
        alg_params = {
            'INPUT': outputs['FieldCalculatorNewPoints']['OUTPUT']
        }
        outputs['Spinx004'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(38)
        if feedback.isCanceled():
            return {}

        # Retain fields points
        alg_params = {
            'FIELDS': QgsExpression('\'point_no\'').evaluate(),
            'INPUT': outputs['Spinx004']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RetainFieldsPoints'] = processing.run('native:retainfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(39)
        if feedback.isCanceled():
            return {}

        # point_sp1
        alg_params = {
            'INPUT': outputs['RetainFieldsPoints']['OUTPUT']
        }
        outputs['Point_sp1'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(40)
        if feedback.isCanceled():
            return {}

        # Join attributes by location label
        alg_params = {
            'DISCARD_NONMATCHING': False,
            'INPUT': outputs['Point_sp1']['OUTPUT'],
            'JOIN': outputs['Centroid_y']['OUTPUT'],
            'JOIN_FIELDS': [''],
            'METHOD': 0,
            'PREDICATE': [0],
            'PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['JoinAttributesByLocationLabel'] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(41)
        if feedback.isCanceled():
            return {}

        # point_x
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'px',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '$x',
            'INPUT': outputs['JoinAttributesByLocationLabel']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Point_x'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(42)
        if feedback.isCanceled():
            return {}

        # start field result
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 's_ref_id',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\'start\'',
            'INPUT': outputs['Point_sp1']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['StartFieldResult'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(43)
        if feedback.isCanceled():
            return {}

        # Select by location
        alg_params = {
            'INPUT': outputs['Point_sp1']['OUTPUT'],
            'INTERSECT': outputs['ExtractVertices']['OUTPUT'],
            'METHOD': 0,
            'PREDICATE': [0]
        }
        outputs['SelectByLocation'] = processing.run('native:selectbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(44)
        if feedback.isCanceled():
            return {}

        # point_y
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'py',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '$y',
            'INPUT': outputs['Point_x']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Point_y'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(45)
        if feedback.isCanceled():
            return {}

        # point_sp2
        alg_params = {
            'INPUT': outputs['StartFieldResult']['OUTPUT']
        }
        outputs['Point_sp2'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(46)
        if feedback.isCanceled():
            return {}

        # ang_ref_id
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'ang_ref_id',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'floor(case\r\nwhen cy> py and cx>px then 90-( atan ((cy-py)/(cx-px))*180/$pi)\r\nwhen py> cy and cx>px then 90-( atan ((cy-py)/(cx-px))*180/$pi)\r\nwhen py> cy and px>cx then 270-( atan ((cy-py)/(cx-px))*180/$pi)\r\nwhen cy> py and px>cx then 270-( atan ((cy-py)/(cx-px))*180/$pi)\r\nwhen cy>py and px=cx then 0\r\nwhen py=cy and cx>px then 90\r\nwhen py>cy and px=cx then 180\r\nwhen py=cy and px>cx then 270\r\nend) + 90\r\n\r\n',
            'INPUT': outputs['Point_y']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Ang_ref_id'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(47)
        if feedback.isCanceled():
            return {}

        # end field result
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'e_ref_id',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\'end\'',
            'INPUT': outputs['Point_sp2']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['EndFieldResult'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(48)
        if feedback.isCanceled():
            return {}

        # Drop field(s)
        alg_params = {
            'COLUMN': QgsExpression('\'cx;cy;px;py\'').evaluate(),
            'INPUT': outputs['Ang_ref_id']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DropFields'] = processing.run('native:deletecolumn', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(49)
        if feedback.isCanceled():
            return {}

        # Delete duplicate geometries points final
        alg_params = {
            'INPUT': outputs['DropFields']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DeleteDuplicateGeometriesPointsFinal'] = processing.run('native:deleteduplicategeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(50)
        if feedback.isCanceled():
            return {}

        # point_sp4
        alg_params = {
            'INPUT': outputs['EndFieldResult']['OUTPUT']
        }
        outputs['Point_sp4'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(51)
        if feedback.isCanceled():
            return {}

        # ps1
        alg_params = {
            'FIELD_LENGTH': 100,
            'FIELD_NAME': 'ps1',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '$x||\',\'||$y',
            'INPUT': outputs['Point_sp4']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Ps1'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(52)
        if feedback.isCanceled():
            return {}

        # point_sp6
        alg_params = {
            'INPUT': outputs['Ps1']['OUTPUT']
        }
        outputs['Point_sp6'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(53)
        if feedback.isCanceled():
            return {}

        # Join attributes by location
        alg_params = {
            'DISCARD_NONMATCHING': False,
            'INPUT': outputs['Polygon_sp3']['OUTPUT'],
            'JOIN': outputs['Point_sp6']['OUTPUT'],
            'JOIN_FIELDS': [''],
            'METHOD': 0,
            'PREDICATE': [0],
            'PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['JoinAttributesByLocation'] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(54)
        if feedback.isCanceled():
            return {}

        # spinx8
        alg_params = {
            'INPUT': outputs['DeleteDuplicateGeometriesPointsFinal']['OUTPUT']
        }
        outputs['Spinx8'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(55)
        if feedback.isCanceled():
            return {}

        # end 2
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'p_ref_id',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'attribute(\'point_no\')',
            'INPUT': outputs['Point_sp4']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['End2'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(56)
        if feedback.isCanceled():
            return {}

        # Join attributes by location final
        alg_params = {
            'DISCARD_NONMATCHING': False,
            'INPUT': outputs['Spinx8']['OUTPUT'],
            'JOIN': outputs['Spinx7']['OUTPUT'],
            'JOIN_FIELDS': [''],
            'METHOD': 0,
            'PREDICATE': [0],
            'PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['JoinAttributesByLocationFinal'] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(57)
        if feedback.isCanceled():
            return {}

        # point_sp5
        alg_params = {
            'INPUT': outputs['End2']['OUTPUT']
        }
        outputs['Point_sp5'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(58)
        if feedback.isCanceled():
            return {}

        # spinx9
        alg_params = {
            'INPUT': outputs['JoinAttributesByLocationFinal']['OUTPUT']
        }
        outputs['Spinx9'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(59)
        if feedback.isCanceled():
            return {}

        # polygon_sp5
        alg_params = {
            'INPUT': outputs['JoinAttributesByLocation']['OUTPUT']
        }
        outputs['Polygon_sp5'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(60)
        if feedback.isCanceled():
            return {}

        # Delete duplicate geometries final
        alg_params = {
            'INPUT': outputs['Spinx9']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DeleteDuplicateGeometriesFinal'] = processing.run('native:deleteduplicategeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(61)
        if feedback.isCanceled():
            return {}

        # start extraction
        alg_params = {
            'EXPRESSION': 'xat(0)||\',\'||yat(0)!=\"ps1\"',
            'INPUT': outputs['Polygon_sp5']['OUTPUT'],
            'FAIL_OUTPUT': QgsProcessing.TEMPORARY_OUTPUT,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['StartExtraction'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(62)
        if feedback.isCanceled():
            return {}

        # polygon_sp6
        alg_params = {
            'INPUT': outputs['StartExtraction']['FAIL_OUTPUT']
        }
        outputs['Polygon_sp6'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(63)
        if feedback.isCanceled():
            return {}

        # spinx10
        alg_params = {
            'INPUT': outputs['DeleteDuplicateGeometriesFinal']['OUTPUT']
        }
        outputs['Spinx10'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(64)
        if feedback.isCanceled():
            return {}

        # delete first extraction
        alg_params = {
            'INPUT': outputs['Polygon_sp6']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DeleteFirstExtraction'] = processing.run('native:deleteduplicategeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(65)
        if feedback.isCanceled():
            return {}

        # Field calculator flayer
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'angle_ref_id1',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 1,
            'FORMULA': 'case when \"angle\" < 180 then (\"angle\"+ 180) else (\"angle\"-180) end',
            'INPUT': outputs['Spinx10']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FieldCalculatorFlayer'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['OutputPoints'] = outputs['FieldCalculatorFlayer']['OUTPUT']

        feedback.setCurrentStep(66)
        if feedback.isCanceled():
            return {}
            
        # Retain fields flayer
        alg_params = {
            'FIELDS': QgsExpression('\'point_no;angle_ref_id1\'').evaluate(),
            'INPUT': outputs['FieldCalculatorFlayer']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RetainFieldsFlayer'] = processing.run('native:retainfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['OutputPoints'] = outputs['RetainFieldsFlayer']['OUTPUT']

        feedback.setCurrentStep(66)
        if feedback.isCanceled():
            return {}
            
        # Field calculator xcoord
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'East',
            'FIELD_PRECISION': 3,
            'FIELD_TYPE': 0,
            'FORMULA': '$x',
            'INPUT': outputs['RetainFieldsFlayer']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FieldCalculatorXcoord'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(67)
        if feedback.isCanceled():
            return {}

        # Field calculator ycoord
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'North',
            'FIELD_PRECISION': 3,
            'FIELD_TYPE': 0,
            'FORMULA': '$y',
            'INPUT': outputs['FieldCalculatorXcoord']['OUTPUT'],
            'OUTPUT': parameters['OutputPoints']
        }
        outputs['FieldCalculatorYcoord'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['OutputPoints'] = outputs['FieldCalculatorYcoord']['OUTPUT']

        feedback.setCurrentStep(68)
        if feedback.isCanceled():
            return {}

        # Drop field(s)
        alg_params = {
            'COLUMN': [''],
            'INPUT': outputs['StartExtraction']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DropFields'] = processing.run('native:deletecolumn', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(67)
        if feedback.isCanceled():
            return {}

        # csi5
        alg_params = {
            'INPUT': outputs['FieldCalculatorFlayer']['OUTPUT']
        }
        outputs['Csi5'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(68)
        if feedback.isCanceled():
            return {}

        # polygon_sp7
        alg_params = {
            'INPUT': outputs['DeleteFirstExtraction']['OUTPUT']
        }
        outputs['Polygon_sp7'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(69)
        if feedback.isCanceled():
            return {}

        # Set layer style
        alg_params = {
            'INPUT': outputs['FieldCalculatorYcoord']['OUTPUT'],
            'STYLE': os.path.join( os.path.dirname(__file__), "survey_layout_labels.qml" )
        }
        outputs['SetLayerStyle'] = processing.run('native:setlayerstyle', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(70)
        if feedback.isCanceled():
            return {}

        # Join attributes by location
        alg_params = {
            'DISCARD_NONMATCHING': False,
            'INPUT': outputs['Csi5']['OUTPUT'],
            'JOIN': outputs['Spinx002']['OUTPUT'],
            'JOIN_FIELDS': [''],
            'METHOD': 0,
            'PREDICATE': [0],
            'PREFIX': ''
        }
        outputs['JoinAttributesByLocation'] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(71)
        if feedback.isCanceled():
            return {}

        # bearing_distance join
        alg_params = {
            'DISCARD_NONMATCHING': False,
            'INPUT': outputs['Polygon_sp7']['OUTPUT'],
            'JOIN': outputs['Polygon_sp4']['OUTPUT'],
            'JOIN_FIELDS': [''],
            'METHOD': 0,
            'PREDICATE': [0],
            'PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Bearing_distanceJoin'] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(72)
        if feedback.isCanceled():
            return {}

        # polygon_sp8
        alg_params = {
            'INPUT': outputs['Bearing_distanceJoin']['OUTPUT']
        }
        outputs['Polygon_sp8'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(73)
        if feedback.isCanceled():
            return {}

        # deleted duplicate bearing distance
        alg_params = {
            'INPUT': outputs['Polygon_sp8']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DeletedDuplicateBearingDistance'] = processing.run('native:deleteduplicategeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(74)
        if feedback.isCanceled():
            return {}

        # polygon_sp9
        alg_params = {
            'INPUT': outputs['DeletedDuplicateBearingDistance']['OUTPUT']
        }
        outputs['Polygon_sp9'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(75)
        if feedback.isCanceled():
            return {}

        # deleted 2
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'p_ref_id_1',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'attribute(\'point_no\')',
            'INPUT': outputs['Polygon_sp9']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Deleted2'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(76)
        if feedback.isCanceled():
            return {}

        # polygon_sp10
        alg_params = {
            'INPUT': outputs['Deleted2']['OUTPUT']
        }
        outputs['Polygon_sp10'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(77)
        if feedback.isCanceled():
            return {}

        # end join
        alg_params = {
            'DISCARD_NONMATCHING': False,
            'INPUT': outputs['Polygon_sp10']['OUTPUT'],
            'JOIN': outputs['Point_sp5']['OUTPUT'],
            'JOIN_FIELDS': [''],
            'METHOD': 0,
            'PREDICATE': [0],
            'PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['EndJoin'] = processing.run('native:joinattributesbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(78)
        if feedback.isCanceled():
            return {}

        # polygon_sp11
        alg_params = {
            'INPUT': outputs['EndJoin']['OUTPUT']
        }
        outputs['Polygon_sp11'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(79)
        if feedback.isCanceled():
            return {}

        # Final Extract
        alg_params = {
            'EXPRESSION': 'xat(0)||\',\'||yat(0)=\"ps1\"  and    p_ref_id  !=   p_ref_id_1',
            'INPUT': outputs['Polygon_sp11']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FinalExtract'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(80)
        if feedback.isCanceled():
            return {}

        # polygon_sp12
        alg_params = {
            'INPUT': outputs['FinalExtract']['OUTPUT']
        }
        outputs['Polygon_sp12'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(81)
        if feedback.isCanceled():
            return {}

        # c_from
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'from',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\'FROM\'',
            'INPUT': outputs['Polygon_sp12']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['C_from'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(82)
        if feedback.isCanceled():
            return {}

        # polygon_sp13
        alg_params = {
            'INPUT': outputs['C_from']['OUTPUT']
        }
        outputs['Polygon_sp13'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(83)
        if feedback.isCanceled():
            return {}

        # point_start
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'point_start',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'p_ref_id_1',
            'INPUT': outputs['Polygon_sp13']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Point_start'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(84)
        if feedback.isCanceled():
            return {}

        # polygon_sp14
        alg_params = {
            'INPUT': outputs['Point_start']['OUTPUT']
        }
        outputs['Polygon_sp14'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(85)
        if feedback.isCanceled():
            return {}

        # c_to
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'to',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\'TO\'',
            'INPUT': outputs['Polygon_sp14']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['C_to'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(86)
        if feedback.isCanceled():
            return {}

        # polygon_sp15
        alg_params = {
            'INPUT': outputs['C_to']['OUTPUT']
        }
        outputs['Polygon_sp15'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(87)
        if feedback.isCanceled():
            return {}

        # point_end
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'point_end',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'p_ref_id',
            'INPUT': outputs['Polygon_sp15']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Point_end'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(88)
        if feedback.isCanceled():
            return {}

        # polygon_sp16
        alg_params = {
            'INPUT': outputs['Point_end']['OUTPUT']
        }
        outputs['Polygon_sp16'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(89)
        if feedback.isCanceled():
            return {}

        # equality sign
        alg_params = {
            'FIELD_LENGTH': 3,
            'FIELD_NAME': 'equality',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\'=\'',
            'INPUT': outputs['Polygon_sp16']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['EqualitySign'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(90)
        if feedback.isCanceled():
            return {}

        # polygon_sp17
        alg_params = {
            'INPUT': outputs['EqualitySign']['OUTPUT']
        }
        outputs['Polygon_sp17'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(91)
        if feedback.isCanceled():
            return {}

        # c_length
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'length',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'case \r\nwhen round($length,2)like\'%.%\' and right(round($length,2),2)like\'%.%\' then round($length,2)||\'0\'\r\nwhen round($length,2) not like\'%.%\' then round($length,2)||\'.00\'\r\nelse round($length,2) end ||\' m\'\r\n',
            'INPUT': outputs['Polygon_sp17']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['C_length'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(78)
        if feedback.isCanceled():
            return {}

        # polygon_sp18
        alg_params = {
            'INPUT': outputs['C_length']['OUTPUT']
        }
        outputs['Polygon_sp18'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(93)
        if feedback.isCanceled():
            return {}

        # c_at
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'at',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': '\'AT\'',
            'INPUT': outputs['Polygon_sp18']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['C_at'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(94)
        if feedback.isCanceled():
            return {}

        # polygon_sp19
        alg_params = {
            'INPUT': outputs['C_at']['OUTPUT']
        }
        outputs['Polygon_sp19'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(95)
        if feedback.isCanceled():
            return {}

        # c_bearing
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'angle',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'case when floor(angle_at_vertex($geometry,num_points($geometry)-1))< 10 then \'0\'||floor(angle_at_vertex($geometry,num_points($geometry)-1)) else floor(angle_at_vertex($geometry,num_points($geometry)-1)) end|| \'°\'',
            'INPUT': outputs['Polygon_sp19']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['C_bearing'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(96)
        if feedback.isCanceled():
            return {}

        # polygon_sp20
        alg_params = {
            'INPUT': outputs['C_bearing']['OUTPUT']
        }
        outputs['Polygon_sp20'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(97)
        if feedback.isCanceled():
            return {}

        # c_minutes
        alg_params = {
            'FIELD_LENGTH': 20,
            'FIELD_NAME': 'minutes',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,
            'FORMULA': 'case when to_int((angle_at_vertex($geometry,num_points($geometry)-1)-floor(angle_at_vertex($geometry,num_points($geometry)-1)))*60)< 10 then \'0\'||to_int((angle_at_vertex($geometry,num_points($geometry)-1)-floor(angle_at_vertex($geometry,num_points($geometry)-1)))*60) else to_int((angle_at_vertex($geometry,num_points($geometry)-1)-floor(angle_at_vertex($geometry,num_points($geometry)-1)))*60) end|| \'\'\'\'',
            'INPUT': outputs['Polygon_sp20']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['C_minutes'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(98)
        if feedback.isCanceled():
            return {}

        # polygon_sp21
        alg_params = {
            'INPUT': outputs['C_minutes']['OUTPUT']
        }
        outputs['Polygon_sp21'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(99)
        if feedback.isCanceled():
            return {}

        # Extract by expression
        alg_params = {
            'EXPRESSION': '\"point_start\" != \"point_end\"',
            'INPUT': outputs['Polygon_sp21']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ExtractByExpression'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(100)
        if feedback.isCanceled():
            return {}

        # polygon_sp22
        alg_params = {
            'INPUT': outputs['ExtractByExpression']['OUTPUT']
        }
        outputs['Polygon_sp22'] = processing.run('native:createspatialindex', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(101)
        if feedback.isCanceled():
            return {}

        # Bearing & Distance
        alg_params = {
            'FIELDS': QgsExpression('\'from;point_start;to;point_end;equality;length;at;angle;minutes\'').evaluate(),
            'INPUT': outputs['Polygon_sp22']['OUTPUT'],
            'OUTPUT': parameters['BearingDistance']
        }
        outputs['BearingDistance'] = processing.run('native:retainfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['BearingDistance'] = outputs['BearingDistance']['OUTPUT']

        feedback.setCurrentStep(102)
        if feedback.isCanceled():
            return {}
    
        
        
        # Set layer style
        alg_params = {
            'INPUT': outputs['BearingDistance']['OUTPUT'],
            'STYLE': os.path.join( os.path.dirname(__file__), "bearing_&_distance.qml" )
        }
        outputs['SetLayerStyle'] = processing.run('native:setlayerstyle', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        return results


    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'B & D(By Attributes_Without Points)'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr(self.name())

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr(self.groupId())

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
       

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return BearingDistance5Algorithm()
        
        
























