"""
/***************************************************************************
 BDOT10k
                                 A QGIS plugin
 This plugin operates on BDOT10k.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-01-06
        git sha              : $Format:%H$
        copyright            : (C) 2022 by marylaGIS
        email                : maryla4gis@gmail.com
 ***************************************************************************/
"""

import os

from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction

from .bdot10k_dialog_base import BDOT10kDialogBase
from .bdot10k_dialog_by_layer import BDOT10kDialogByLayer
from .bdot10k_dialog_info import BDOT10kDialogInfo


class BDOT10k:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # Declare instance attributes
        self.actions = []
        self.dlg = None
        self.dlg_by_layer = None
        self.dlg_info = None
        self.menu = "BDOT10k"
        self.plugin_dir = os.path.dirname(__file__)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = os.path.join(self.plugin_dir, "icon.png")
        self.add_action(
            icon_path,
            text="Pobierz paczki .zip BDOT10k",
            callback=self.run,
            parent=self.iface.mainWindow())

        icon_path = os.path.join(self.plugin_dir, "icon2.png")
        self.add_action(
            icon_path,
            text="Pobierz BDOT10k według warstwy",
            callback=self.run_by_layer,
            parent=self.iface.mainWindow()
        )

        self.add_action(
            icon_path=None,
            text="Informacje",
            callback=self.info,
            parent=self.iface.mainWindow(),
            add_to_toolbar=False
        )

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""

        for action in self.actions:
            self.iface.removePluginMenu(
                self.menu,
                action)
            self.iface.removeToolBarIcon(action)

    def run(self):
        """Displays a dialog for downloading BDOT10k data
        by selecting counties."""

        self.dlg = BDOT10kDialogBase()
        self.dlg.show()

    def run_by_layer(self):
        """Displays a dialog for downloading BDOT10k data
        based on intersection with the given layer."""

        self.dlg_by_layer = BDOT10kDialogByLayer()
        self.dlg_by_layer.show()

    def info(self):
        """Displays a dialog with additional information."""

        self.dlg_info = BDOT10kDialogInfo()
        self.dlg_info.show()
