/*

OTD : Of the Dead, l'extension anthropologique de BADASS

Auteurs : Caroline Font, Thomas Guillemard, Florent Mercey, Christelle Seng. Inrap, 2023.

Remarques : les champs en commentaire dans la table t_squelette seront calculés dans une vue et ajoutés en jointure

*/

PRAGMA encoding='UTF-8';

-- les tables pour le mannequin permettant d'initier la saisie
DROP TABLE IF EXISTS mannequin;
CREATE TABLE mannequin(
   "id_man" INTEGER PRIMARY KEY,
   "catego" TEXT, -- la catégorie du mannequin dans une liste de valeurs : squelette, os, contenant, mobilier, analyse...
   "nom" TEXT, -- le nom de l'entité du mannequin, par exemple, le nom de l'os
   "cote" TEXT, -- permet, pour les entités latéralisées de spécifier le côté concerné
   "part_anat" TEXT, -- la partie anatomique de regroupement des os du mannequin
   "ss_catego" TEXT -- un détail supplémentaire sur une catégorie, par exemple, la classe d'âge (adulte, immature, périnatal), ou pour le contenant (fond, couvercle, paroi)
);
SELECT AddGeometryColumn('mannequin','geometry',2154,'MULTIPOLYGON','XY',0);



-- LES TABLES DE OTD
-- geste funéraire : enregistrement créé par trigger conditionné par la saisie dans t_us de BADASS


-- squelette
DROP TABLE IF EXISTS t_squelette;
CREATE TABLE t_squelette(
   "id_squel" INTEGER PRIMARY KEY,
   "id_man" INTEGER, -- clé étrangère qui renvoie à la table du mannequin man_squel
   "sq_numus" INTEGER, -- correspond au n° d'US attribuée
   "numindiv" INTEGER, -- numéro de l'individu, notamment dans le cadre d'une inhumation non primaire
   "alti_squel" FLOAT,
   --"ind_cran_horiz" INTEGER, -- SI crâne adulte ; indice cranien horizontal ; calculé d'après les valeurs saisies dans la table t_mesure : (largeur maximale*100)/ longueur maximale
   --"ind_cran_trans" INTEGER, -- SI crâne adulte ; indice cranien transversal ; calculé d'après les valeurs saisies dans la table t_mesure : (largeur bizygomatique*100)/ largeur maximale
   --"ind_cran_fac_sup" INTEGER,-- SI crâne adulte ; indice cranien facial supérieur ; calculé d'après les valeurs saisies dans la table t_mesure : (hauteur nasion prosthion*100)/largeur bizygomatique
   --"ind_gnatiq_flower" INTEGER, -- SI crâne adulte ; indice gnatique de flower ; calculé d'après les valeurs saisies dans la table t_mesure : (longueur endobasion prosthion*100)/longueur endobasion nasion
   --"ind_mandibul" INTEGER, -- SI crâne adulte ; indice mandibulaire ; calculé d'après les valeurs saisies dans la table t_mesure : (longueur de la mandibule*100)/largeur bicondylienne
   --"ind_goniaq" INTEGER,  -- SI crâne adulte ; indice goniaque ; calculé d'après les valeurs saisies dans la table t_mesure : (largeur bigoniaque*100)/largeur bicondylienne
   --"stature_hum" INTEGER, -- SI humérus adulte ; Stature d’après l’humérus =SI(« sex_def »=1;((« longueur humérus »/10)*3.08+70.45);SI(« sex_def »=2;( « longueur humérus »/10*3.36+57.97);))*10SI « sex_def » = 0 ou 3, ne pas proposer de résultats
   --"robust_hum" INTEGER, -- SI humérus adulte ; Indice de robustesse HUMERUS =  (Périmètre humérus * 100) / Longueur humérus
   --"ind_brachyq" INTEGER, -- SI humérus adulte ; Indice brachyque (humérus) = (Diamètre minimum humérus * 100) / Diamètre maximum humérus
   --"stature_femur" INTEGER, -- SI fémur adulte ; Stature d’après le fémur =SI(« sex_def »=1;((« longueur fémur»/10)*2.38+61.41);SI(« sex_def »=2;( « longueur fémur »/10*2.47+54.1);))*10 SI « sex_def » = 0 ou 3, ne pas proposer de résultats
   --"robust_femur" INTEGER, -- SI fémur adulte ; Indice de robustesse FEMUR = (Périmètre fémur * 100) / Longueur fémur
   --"ind_platymetriq" INTEGER, -- SI fémur adulte ; Indice platymérique (fémur) = (Diamètre sagittal fémur * 100) /Diamètre transversal fémur
   --"stature_tibia" INTEGER, -- SI tibia adulte ; Stature d’après le tibia =SI(« sex_def »=1;((« longueur tibia»/10)*2.52+78.62);SI(« sex_def »=2;( « longueur tibia»/10*2.9+61.53);))*10 SI « sex_def » = 0 ou 3, ne pas proposer de résultats
   --"robust_tibia" INTEGER, -- SI tibia adulte ; Indice de robustesse TIBIA = (Périmètre tibia * 100) / Longueur fémur
   --"ind_cnemiq" INTEGER, -- SI tibia adulte ; Indice cnémique (tibia) = (Diamètre transversal tibia * 100) / Diamètre sagittal tibia 
   "sex_result_dsp" TEXT, -- Indiquer le sexe de l'individu à partir de la DSP
   "sex_result_mob" TEXT, -- Indiquer le sexe archéologique potentiel du sujet (ceci n'est qu'une proposition en l'absence de toute autre méthode)
   "sex_result_adn" TEXT, -- Indiquer le sexe de l'individu à partir de l'ADN mitochondrial
   "sex_result_calva" TEXT, -- Indiquer le sexe de l'individu à partir de la morphologie des os coxaux
   "sex_result_seupf_d" TEXT, -- Résultat sex estimation using the proximal femur. Indiquer le résultat à partir de la méthode Sexe estimation using proximal femur droit.
   "sex_result_seupf_g" TEXT, -- Résultat sex estimation using the proximal femur. Indiquer le résultat à partir de la méthode Sexe estimation using proximal femur gauche.
   "sex_bruzek_terrain" TEXT, -- Résultat de la détermination du sexe selon la méthode de Bruzek sur le terrain
   "sex_bruzek_labo" TEXT, -- Résultat de la détermination du sexe selon la méthode de Bruzek en laboratoire
   "sex_comment" TEXT,
   "age_terrain" TEXT, -- Liste de valeurs : adulte, immature, périnatal
   "age_methode" TEXT, -- Liste de valeurs.
   "age_class" TEXT, -- Liste de valeurs. Indiquer l'âge du sujet et préciser la méthode à partir de la liste proposée
   "age_comment" TEXT,
   "patho_descrip_gen" TEXT, -- Diagnostic paléopathologique général
   "marq_act_comment" TEXT, -- description libre sur les marqueurs d'activités
   "res_pratiq_fun" TEXT, -- Pratique funéraire déduite des informations taphonomiques
   "descr_atlas" TEXT, -- Description du dépôt funéraire (pour catalogue)
   "commentaire" TEXT
);
SELECT AddGeometryColumn('t_squelette','geometry',2154,'MULTIPOLYGON','XY',0);

-- la table consernant les OBSERVATIONS réalisées dans le cas d'un SEPULTURE PRIMAIRE
DROP TABLE IF EXISTS t_obs_sep;
CREATE TABLE t_obs_sep(
   "id_obs_sep" INTEGER PRIMARY KEY,
   "sq_numus" INTEGER, -- relation de 1 à n (création gérée par trigger) avec la table t_squelette où t_squelette.num_squel = t_obs_sep_prim.num_squel
   "sep_nature" TEXT, -- nature de l'observation, cf. liste de Cyrille
   "sep_result_text" TEXT, -- résultat en valeur en chaîne de caractères issue de l'observation, si une valeur numérique est saisie, il faudra utiliser une requête de refactorisation
   "sep_result_num" FLOAT, -- permet de saisir des résultats numériques aux observations (champ temporaire en attendant que QGIS résolve l'issue)
   "sep_result_multi" TEXT, -- permet de saisir des résultats multivalués aux observations (champ temporaire en attendant que QGIS résolve l'issue)
   "sep_comment" TEXT, -- commentaire spécifique au caractère du dépôt du squelette dans la sépulture.
   "id_model" INTEGER -- clé étrangère de la table model_anthropo
);


-- la table qui permet de dénombrer les nombres minimums d'individus dans la sép secondaire en fonction des os
DROP TABLE IF EXISTS nombre_sec;
CREATE TABLE nombre_sec(
   "id_nombre" INTEGER PRIMARY KEY,
   "id_obs_sep" INTEGER, --clé étrangère qui renvoie à la table parente t_obs_sep_sec
   "ad_imm" TEXT, -- choix : adulte ou immature
   "type_nmi" TEXT, -- type de NMI, choix dans une liste de valeurs/types
   "val_nmi" INTEGER -- la valeur en entier du NMI
);

-- OS
DROP TABLE IF EXISTS t_os;
CREATE TABLE t_os(
   "id_os" INTEGER PRIMARY KEY,
   "sq_numus" INTEGER, -- clé étrangère qui renvoie à la table t_squelette
   "numindiv" INTEGER, -- clé étrangère complémentaire qui renvoie au numéro de l'individu, notamment dans le cadre d'une inhumation non primaire
   "nom_part_ana" TEXT, -- nom de la partie anatomique
   "nom_os" TEXT, -- nom de l'os (ex: fémur)
   "id_man" INTEGER, -- clé étrangère qui renvoie à l'os du mannequin
   "cote" TEXT, -- latéralisation de l'os
   "orient" TEXT,
   "ext_proximale" INTEGER, -- permet de préciser si l'extrémité proximale est conservée (booléen), voir si on conserve ce champ à l'usage
   "diaphyse" INTEGER, -- permet de préciser si la partie distale est conservée (booléen), voir si on conserve ce champ à l'usage
   "ext_distale" INTEGER, -- permet de préciser si l'extrémité distale est conservée (booléen), voir si on conserve ce champ à l'usage
   "etat_conservation" TEXT, -- état de conservation de l'os, voir si on conserve ce champ à l'usage
   "raison_absence" TEXT, -- raison de l'absence totale ou partielle de l'os, voir si on conserve ce champ à l'usage
   "comment" TEXT
);
SELECT 
AddGeometryColumn ('t_os','geometry',2154,'MULTIPOLYGON','XY',0);


-- le contenant de la sep
DROP TABLE IF EXISTS t_cont_sep;
CREATE TABLE t_cont_sep(
   "id_cont_sep" INTEGER PRIMARY KEY,
   "id_man" INTEGER, -- permet l'utilisation du mannequin
   "cont_numus" INTEGER, -- N° d'US associé au contenant
   "cont_obs" TEXT, -- nom de l'observation faite sur le contenant
   "cont_result_text" TEXT, -- résultat en valeur en chaîne de caractères issue de l'observation, si une valeur numérique est saisie, il faudra utiliser une requête de refactorisation
   "cont_result_num" FLOAT, -- permet de saisir des résultats numériques aux observations (champ temporaire en attendant que QGIS résolve l'issue)
   "cont_result_multi" TEXT, -- permet de saisir des résultats multivalués aux observations (champ temporaire en attendant que QGIS résolve l'issue)   "cont_comment" TEXT, -- Description libre.
   "cont_comment" TEXT, -- permet de commenter chaque résultat
   "id_model" INTEGER -- clé étrangère de la table model_anthropo
);

SELECT 
AddGeometryColumn ('t_cont_sep','geometry',2154,'MULTIPOLYGON','XY',0);

-- mesure : permet d'enregistrer les mesures
DROP TABLE IF EXISTS t_mesure;
CREATE TABLE t_mesure(
   "id_mesure" INTEGER PRIMARY KEY,
   "sq_numus" INTEGER,-- clé étrangère qui renvoie à la clé primaire archéo "sq_numus" de la table t_squelette
   "id_os" INTEGER, -- clé étrangère qui renvoie à la clé prmiaire "id_os" de la table t_os
   "cat_mesure" TEXT,
   "ss_cat_mesure" TEXT,
   "nom_mesure" TEXT,
   "valeur_mesure" FLOAT,
   "remarque_mesure" TEXT
);

DROP TABLE IF EXISTS matrice_mannequin_nom_mesure;
CREATE TABLE matrice_mannequin_nom_mesure(
	"id_mxmesure" INTEGER PRIMARY KEY,
	"id_thes" INTEGER,
	"id_man" INTEGER,
	"groupe_mesure" TEXT
);	

/*DROP TABLE IF EXISTS t_profil;
CREATE TABLE t_profil(
	"id_profil" INTEGER PRIMARY KEY,
	"numprofil" TEXT,
	"numfait" INTEGER REFERENCES t_fait("numfait") DEFAULT NULL,
	"x_min" FLOAT,
	"x_max" FLOAT,
	"y_min" FLOAT,
	"y_max" FLOAT,
	"comment" TEXT
);
SELECT 
AddGeometryColumn ('t_profil','geom',2154,'MULTILINESTRING','XY',0);*/	
	

/*
-- pathos : permet d'enregistrer les pathologies, les activités, les caractères discrets, les facteurs de stress
DROP TABLE IF EXISTS t_patho;
CREATE TABLE t_patho(
   "id_patho" INTEGER PRIMARY KEY,
   "sq_numus" INTEGER,-- clé étrangère qui renvoie à la clé primaire archéo "sq_numus" de la table t_squelette
   "id_os" INTEGER, -- clé étrangère qui renvoie à la clé prmiaire "id_os" de la table t_os
   "cat_mesure_patho" TEXT, -- par mesure, plutôt entendre observation de pathologie
   "nom_mesure_patho" TEXT, -- par mesure, plutôt entendre observation de pathologie
   "loc_mesure_patho" TEXT, -- par mesure, plutôt entendre observation de pathologie
   "val_mesure_patho" TEXT, -- par mesure, plutôt entendre observation de pathologie
   "commentaire" TEXT
);

-- sexe : permet d'enregistrer les indices de détermination du sexe
DROP TABLE IF EXISTS t_sexe;
CREATE TABLE t_sexe(
   "id_sexe" INTEGER PRIMARY KEY,
   "sq_numus" INTEGER,-- clé étrangère qui renvoie à la clé primaire archéo "sq_numus" de la table t_squelette
   "id_os" INTEGER, -- clé étrangère qui renvoie à la clé prmiaire "id_os" de la table t_os
   "cat_mesure_sex" TEXT,
   "nom_mesure_sex" TEXT,
   "val_mesure_sex" FLOAT,
   "commentaire" TEXT
);

-- age : permet d'enregistrer les indices de détermination de lâge
DROP TABLE IF EXISTS t_age;
CREATE TABLE t_age(
   "id_age" INTEGER PRIMARY KEY,
   "sq_numus" INTEGER,-- clé étrangère qui renvoie à la clé primaire archéo "sq_numus" de la table t_squelette
   "id_os" INTEGER, -- clé étrangère qui renvoie à la clé prmiaire "id_os" de la table t_os
   "cat_mesure_age" TEXT,
   "nom_mesure_age" TEXT,
   "val_mesure_age" TEXT, -- répond à un choix de valeurs pour des cotations de 0 à 3, ou 0 à 4, selon ce qui est rempli dans le champ nom mesure âge + indéterminé ou non observable
   "comment" TEXT
);

REMARQUE : les tables t_patho, t_sex et t_age disparaissent. Tout est dorénavant géré dans la table t_mesure. La structuration est quasi la même. 
Cela va faciliter la mise en place de l'ergonomie dans le projet QGIS puisque tous les champs sont dans une seule table.



*/

-- THESAURUS : rassemble les termes des listes de valeurs
DROP TABLE IF EXISTS otd_thesaurus;
CREATE TABLE otd_thesaurus(
   "id_thes" INTEGER PRIMARY KEY,
   "tabl_thes" TEXT, -- table où on trouve le champs qui propose la valeurs
   "field_thes" TEXT, -- champ qui propose le terme en liste de valeurs
   "val_thes" TEXT, -- il s'agit de la valeur / terme / modalité
   "def_thes" TEXT, -- si possible, définition du terme 
   "cat_thes" TEXT, -- catégorie de regroupement des termes    
   "comment" TEXT -- observations diverses
);

-- MODÈLE D'ENREGISTREMENT ANTHROPOLOGIQUE : liste des enregistrements à créer par défaut dans les tables t_obs_sep ou t_contenant
DROP TABLE IF EXISTS model_anthropo;
CREATE TABLE model_anthropo(
	"id_model" INTEGER PRIMARY KEY,
	"enregistrement" TEXT, -- nom de l'enregsitrement à créer
	"ordre" INTEGER, -- possibilité d'ajouter un numéro d'ordre pour gérer l'ordre d'affichage dans la liste
	"primaire" INTEGER, -- permet de distinguer les enregistrements qui concernent les dépôts primaires
	"secondaire" INTEGER, -- permet de distinguer les enregistrements qui concernent les dépôts secondaires
	"contenant" INTEGER, -- permet de distinguer les enregistrements qui concernent les contenants
	"commentaire" TEXT,
   "affich" INTEGER -- cela permet dans QGIS, d'afficher ou pas l'entité dans le formulaire
);


-- Les valeurs à insérer dans la table de modèle d'enregistrement anthropologique
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (1,'envergure totale (longueur)',12,1,NULL,NULL,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (2,'envergure épaules',13,1,NULL,NULL,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (3,'envergure bassin',14,1,NULL,NULL,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (4,'envergure pieds',15,1,NULL,NULL,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (5,'orientation',1,1,NULL,NULL,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (6,'emplacement de la tête',2,1,NULL,NULL,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (7,'position du corps',3,1,NULL,NULL,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (8,'position des avant-bras',4,1,NULL,NULL,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (9,'position des membres inférieurs',5,1,NULL,NULL,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (10,'stade de conservation',24,1,NULL,NULL,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (11,'connexions',9,1,NULL,NULL,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (12,'migration en dehors du volume corporel originel',16,1,NULL,NULL,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (13,'équilibre instable',17,1,NULL,NULL,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (14,'type de colmatage',21,1,NULL,NULL,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (15,'ouverture du gril costal en corolle',18,1,NULL,NULL,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (16,'linceul',11,1,NULL,NULL,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (17,'effet de compression',10,1,NULL,NULL,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (18,'apparition du crâne',NULL,1,NULL,NULL,NULL,0);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (19,'apparition ceinture scapulaire droite',NULL,1,NULL,NULL,NULL,0);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (20,'apparition ceinture scapulaire gauche',NULL,1,NULL,NULL,NULL,0);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (21,'apparition membres supérieurs droits',NULL,1,NULL,NULL,NULL,0);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (22,'apparition membres supérieurs gauches',NULL,1,NULL,NULL,NULL,0);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (23,'apparition rachis',NULL,1,NULL,NULL,NULL,0);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (24,'apparition ceinture pelvienne',NULL,1,NULL,NULL,NULL,0);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (25,'apparition membres inférieurs droits',NULL,1,NULL,NULL,NULL,0);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (26,'apparition membres inférieurs gauche',NULL,1,NULL,NULL,NULL,0);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (27,'pied droit',19,1,NULL,NULL,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (28,'pied gauche',20,1,NULL,NULL,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (29,'chaussure',22,1,NULL,NULL,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (30,'NMI total',1,NULL,1,NULL,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (31,'NMI total adulte',2,NULL,1,NULL,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (32,'NMI total immature',3,NULL,1,NULL,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (33,'pillage',23,1,1,NULL,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (34,'type de contenant',1,NULL,NULL,1,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (35,'matière(s) ',2,NULL,NULL,1,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (36,'calage extérieur',3,NULL,NULL,1,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (37,'nombre de clous',4,NULL,NULL,1,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (38,'présence de décors ?',5,NULL,NULL,1,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (39,'description du décor',6,NULL,NULL,1,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (40,'présence d''un couvercle ?',9,NULL,NULL,1,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (41,'présence d''enduit de lissage ?',7,NULL,NULL,1,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (42,'épaisseur de l''enduit de lissage',8,NULL,NULL,1,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (43,'présence d''un trou d''évacuation des jus de décomposition ?',10,NULL,NULL,1,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (44,'présence d''un calage du moule interne ?',11,NULL,NULL,1,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (45,'matériau du moule interne',12,NULL,NULL,1,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (46,'nombre de coulées',13,NULL,NULL,1,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (47,'nombre de planches en hauteur du moule externe',15,NULL,NULL,1,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (48,'nombre de planches en hauteur du moule interne',14,NULL,NULL,1,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (49,'longueur totale extérieure',16,NULL,NULL,1,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (50,'longueur totale intérieure',17,NULL,NULL,1,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (51,'largeur de la paroi tête extérieure',18,NULL,NULL,1,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (52,'largeur de la paroi tête intérieure',19,NULL,NULL,1,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (53,'largeur de la paroi pied extérieure',20,NULL,NULL,1,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (54,'largeur de la paroi pied intérieure',21,NULL,NULL,1,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (55,'épaisseur de la paroi tête',22,NULL,NULL,1,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (56,'épaisseur de la paroi latérale droite',23,NULL,NULL,1,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (57,'épaisseur de la paroi latérale gauche',24,NULL,NULL,1,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (58,'épaisseur de la paroi pied',25,NULL,NULL,1,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (59,'épaisseur du fond',26,NULL,NULL,1,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (60,'hauteur maximale de la paroi',27,NULL,NULL,1,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (61,'indice trapézoïdal intérieur',28,NULL,NULL,1,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (62,'calage céphalique',6,1,NULL,NULL,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (63,'contrainte céphalique',7,1,NULL,NULL,NULL,1);
INSERT INTO "model_anthropo" ("id_model","enregistrement","ordre","primaire","secondaire","contenant","commentaire","affich") VALUES (64,'calage mentonnier',8,1,NULL,NULL,NULL,1);




--- LES TRIGGERS !!!

-- trigger qui permet l'ajout d'US dans la table US pour OTD seulement avec l'interprétation
DROP TRIGGER IF EXISTS trgau_t_us_maj_entite_rapide;
CREATE TRIGGER trgau_t_us_maj_entite_rapide
   AFTER UPDATE OF "numentite"
   ON entite_rapide
FOR EACH ROW
	WHEN NEW."numentite" IS NOT NULL AND (SELECT s."tablentite" FROM entite_rapide AS e JOIN serie AS s ON OLD."id_serie" = s."id_serie") like 't_us'
	BEGIN
	INSERT INTO t_us("numus","interpret","geometry") VALUES (NEW."numentite", NEW."interpret",NULL);
END;

-- entre la table t_us et t_squelette de Badass
-- après la création d'une entité dans t_us où le champ "interpret" est renseigné par soit 'dépôt primaire inhumation' soit 'dépôt non primaire inhumation'
DROP TRIGGER IF EXISTS trgai_t_us_maj_t_squelette;
CREATE TRIGGER trgai_t_us_maj_t_squelette
   AFTER INSERT
   ON t_us
FOR EACH ROW
WHEN (NEW."interpret" in('dépôt primaire inhumation' , 'dépôt non primaire inhumation'))
   BEGIN
   INSERT INTO t_squelette ("sq_numus","id_man") VALUES (NEW."numus", '1');
END;



-----------------------------------------------------------------
-- TRIGGERS qui permettent de générer tous les os d'un squelette dans la table t_os, à partir du moment où on précise 
-- dans la table t_squelette s'il sagit d'un 'périnatal', 'immature' ou 'adulte'

-- AFTER INSERT
-- quand le squelette est un 'adulte'
DROP TRIGGER IF EXISTS trgai_t_squelette_adulte_maj_t_os;
CREATE TRIGGER trgai_t_squelette_adulte_maj_t_os 
AFTER INSERT 
ON t_squelette 
FOR EACH ROW 
WHEN (NEW.age_terrain = 'adulte') 
BEGIN 
INSERT INTO t_os("id_man", "nom_os","cote","nom_part_ana", "sq_numus","numindiv","geometry") SELECT "id_man", "nom", "cote","part_anat", NEW."sq_numus", NEW."numindiv", "geometry" FROM mannequin WHERE "ss_catego" LIKE 'adulte'; 
END;

-- quand le squelette est un 'immature'
DROP TRIGGER IF EXISTS trgai_t_squelette_immature_maj_t_os;
CREATE TRIGGER trgai_t_squelette_immature_maj_t_os 
AFTER INSERT 
ON t_squelette 
FOR EACH ROW 
WHEN (NEW.age_terrain = 'immature') 
BEGIN 
INSERT INTO t_os("id_man", "nom_os","cote","nom_part_ana", "sq_numus","numindiv","geometry") SELECT "id_man", "nom", "cote","part_anat", NEW."sq_numus", NEW."numindiv", "geometry" FROM mannequin WHERE "ss_catego" LIKE 'immature'; 
END;

-- quand le squelette est un 'périnatal'
DROP TRIGGER IF EXISTS trgai_t_squelette_perinatal_maj_t_os;
CREATE TRIGGER trgai_t_squelette_perinatal_maj_t_os 
AFTER INSERT 
ON t_squelette 
FOR EACH ROW 
WHEN (NEW.age_terrain = 'périnatal') 
BEGIN 
INSERT INTO t_os("id_man", "nom_os","cote","nom_part_ana", "sq_numus","numindiv","geometry") SELECT "id_man", "nom", "cote","part_anat", NEW."sq_numus", NEW."numindiv", "geometry" FROM mannequin WHERE "ss_catego" LIKE 'périnatal'; 
END;


-- AFTER UPDATE
-- quand le squelette est un 'adulte'
DROP TRIGGER IF EXISTS trgau_t_squelette_adulte_maj_t_os;
CREATE TRIGGER trgau_t_squelette_adulte_maj_t_os 
AFTER UPDATE OF "age_terrain"
ON t_squelette 
FOR EACH ROW 
WHEN (NEW.age_terrain = 'adulte') 
BEGIN 
DELETE FROM t_os WHERE ("sq_numus" = NEW."sq_numus");
INSERT INTO t_os("id_man", "nom_os","cote","nom_part_ana", "sq_numus","numindiv","geometry") SELECT "id_man", "nom", "cote","part_anat", NEW."sq_numus", NEW."numindiv", "geometry" FROM mannequin WHERE "ss_catego" LIKE 'adulte'; 
END;

-- quand le squelette est un 'immature'
DROP TRIGGER IF EXISTS trgau_t_squelette_immature_maj_t_os;
CREATE TRIGGER trgau_t_squelette_immature_maj_t_os 
AFTER UPDATE OF "age_terrain"
ON t_squelette 
FOR EACH ROW 
WHEN (NEW.age_terrain = 'immature') 
BEGIN 
DELETE FROM t_os WHERE ("sq_numus" = NEW."sq_numus");
INSERT INTO t_os("id_man", "nom_os","cote","nom_part_ana", "sq_numus","numindiv","geometry") SELECT "id_man", "nom", "cote","part_anat", NEW."sq_numus", NEW."numindiv", "geometry" FROM mannequin WHERE "ss_catego" LIKE 'immature'; 
END;

-- quand le squelette est un 'périnatal'
DROP TRIGGER IF EXISTS trgau_t_squelette_perinatal_maj_t_os;
CREATE TRIGGER trgau_t_squelette_perinatal_maj_t_os 
AFTER UPDATE OF "age_terrain"
ON t_squelette 
FOR EACH ROW 
WHEN (NEW.age_terrain = 'périnatal') 
BEGIN 
DELETE FROM t_os WHERE ("sq_numus" = NEW."sq_numus");
INSERT INTO t_os("id_man", "nom_os","cote","nom_part_ana", "sq_numus","numindiv","geometry") SELECT "id_man", "nom", "cote","part_anat", NEW."sq_numus", NEW."numindiv", "geometry" FROM mannequin WHERE "ss_catego" LIKE 'périnatal'; 
END;


-- entre la table t_us et la table t_obs_sep
-- AFTER INSERT pour les dépôts primaire inhumation
DROP TRIGGER IF EXISTS tgai_t_us_maj_t_obs_sep_prim;
CREATE TRIGGER tgai_t_us_maj_t_obs_sep_prim
AFTER INSERT
ON t_us
FOR EACH ROW
WHEN (NEW.interpret LIKE 'dépôt primaire inhumation')
BEGIN
INSERT INTO t_obs_sep ("sq_numus", "sep_nature", "id_model") SELECT NEW."numus","enregistrement","id_model" FROM model_anthropo WHERE "primaire" = 1 and "affich" = 1 ORDER BY "ordre";
END;

-- AFTER INSERT pour les dépôts secondaire inhumation
DROP TRIGGER IF EXISTS tgai_t_us_maj_t_obs_sep_sec;
CREATE TRIGGER tgai_t_us_maj_t_obs_sep_sec
AFTER INSERT
ON t_us
FOR EACH ROW
WHEN (NEW.interpret LIKE 'dépôt non primaire inhumation')
BEGIN
INSERT INTO t_obs_sep ("sq_numus", "sep_nature","id_model") SELECT NEW."numus","enregistrement","id_model" FROM model_anthropo WHERE "secondaire" = 1 ORDER BY "ordre";
END;

-- AFTER UPDATE quand dans t_us on passe d'un dépôt primaire à un dépôt non primaire
DROP TRIGGER IF EXISTS tgau_t_us_maj_t_obs_sep_sec;
CREATE TRIGGER tgau_t_us_maj_t_obs_sep_sec
AFTER UPDATE
ON t_us
FOR EACH ROW
WHEN (NEW.interpret LIKE 'dépôt non primaire inhumation')
BEGIN 
DELETE FROM t_obs_sep WHERE NEW."numus" = "sq_numus" ;
INSERT INTO t_obs_sep ("sq_numus", "sep_nature", "id_model") SELECT NEW."numus","enregistrement","id_model" FROM model_anthropo WHERE "secondaire" = 1 ORDER BY "ordre";
END;

-- AFTER UPDATE quand dans t_us on passe d'un dépôt non primaire à un dépôt primaire
DROP TRIGGER IF EXISTS tgau_t_us_maj_t_obs_sep_prim;
CREATE TRIGGER tgau_t_us_maj_t_obs_sep_prim
AFTER UPDATE
ON t_us
FOR EACH ROW
WHEN (NEW.interpret LIKE 'dépôt primaire inhumation')
BEGIN 
DELETE FROM t_obs_sep WHERE NEW."numus" = "sq_numus" ;
INSERT INTO t_obs_sep ("sq_numus", "sep_nature","id_model") SELECT NEW."numus","enregistrement","id_model" FROM model_anthropo WHERE "primaire" = 1 and "affich" = 1 ORDER BY "ordre";
END;


-- entre la table t_us et la table t_cont_sep
-- AFTER INSERT 
DROP TRIGGER IF EXISTS tgai_t_us_maj_t_cont_sep;
CREATE TRIGGER tgai_t_us_maj_t_cont_sep
AFTER INSERT
ON t_us
FOR EACH ROW
WHEN (NEW.interpret LIKE 'contenant inhumation')
BEGIN
INSERT INTO t_cont_sep ("cont_numus", "cont_obs","id_model") SELECT NEW."numus","enregistrement","id_model" FROM model_anthropo WHERE "contenant" = 1;
END;

-- AFTER UPDATE 
DROP TRIGGER IF EXISTS tgau_t_us_maj_t_cont_sep;
CREATE TRIGGER tgau_t_us_maj_t_cont_sep
AFTER UPDATE
ON t_us
FOR EACH ROW
WHEN (NEW.interpret LIKE 'contenant inhumation')
BEGIN
INSERT INTO t_cont_sep ("cont_numus", "cont_obs","id_model") SELECT NEW."numus","enregistrement","id_model" FROM model_anthropo WHERE "contenant" = 1;
END;


-- TRIGGER de calcul d'indices sur la table t_squelette à partir de ce qui a été saisi dans la table t_mesure

-- SI crâne adulte ; indice cranien horizontal ; champ "ind_cran_horiz" dans t_squelette ; calculé d'après les valeurs saisies dans la table t_mesure : (largeur maximale*100)/ longueur maximale
/*CREATE TRIGGER trgai_t_squelette_ind_cran_horiz
AFTER UPDATE 
ON t_mesure
FOR EACH ROW
WHEN (NEW."cat_mesure" LIKE 'mesure crâne adulte')
BEGIN 
select NEW."sq_numus", 
(((select "valeur_mesure" from t_mesure as m1 where m."sq_numus" = m1."sq_numus" and "nom_mesure" like 'largeur maximale')*100)/
(select "valeur_mesure" from t_mesure as m1 where m."sq_numus" = m1."sq_numus" and "nom_mesure" like 'longueur maximale')) as ind_cran_horiz
from t_mesure 
group by NEW."sq_numus";
UPDATE t_squelette
SET "ind_cran_horiz" = (larg_max*100)/long_max
WHERE NEW."sq_numus" = "sq_numus";
END;*/




-- CREATION DES DONNEES DU THESAURUS

INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (1,'t_obs_sep','orientation','est → ouest',NULL,'5','le numéro inscrit en cat_these correspond à l''"id_model" dans la table model_anthropo');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (2,'t_obs_sep','orientation','ouest → est',NULL,'5',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (3,'t_obs_sep','orientation','nord → sud',NULL,'5',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (4,'t_obs_sep','orientation','sud → nord',NULL,'5',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (5,'t_obs_sep','emplac_tete','est',NULL,'6',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (6,'t_obs_sep','emplac_tete','ouest',NULL,'6',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (7,'t_obs_sep','emplac_tete','nord',NULL,'6',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (8,'t_obs_sep','emplac_tete','sud',NULL,'6',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (9,'t_obs_sep','nom_position','décubitus_dorsal',NULL,'7',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (10,'t_obs_sep','nom_position','décubitus_ventral',NULL,'7',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (11,'t_obs_sep','nom_position','décubitus_latéral_D',NULL,'7',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (12,'t_obs_sep','nom_position','décubitus_latéral_G',NULL,'7',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (13,'t_obs_sep','pos_av_bras','1_1',NULL,'8',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (14,'t_obs_sep','pos_av_bras','1_180',NULL,'8',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (15,'t_obs_sep','pos_av_bras','1_135',NULL,'8',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (16,'t_obs_sep','pos_av_bras','1_90',NULL,'8',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (17,'t_obs_sep','pos_av_bras','1_45',NULL,'8',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (18,'t_obs_sep','pos_av_bras','1_0',NULL,'8',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (19,'t_obs_sep','pos_av_bras','180_1',NULL,'8',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (20,'t_obs_sep','pos_av_bras','135_1',NULL,'8',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (21,'t_obs_sep','pos_av_bras','90_1',NULL,'8',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (22,'t_obs_sep','pos_av_bras','45_1',NULL,'8',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (23,'t_obs_sep','pos_av_bras','0_1',NULL,'8',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (24,'t_obs_sep','pos_av_bras','180_180',NULL,'8',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (25,'t_obs_sep','pos_av_bras','180_135',NULL,'8',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (26,'t_obs_sep','pos_av_bras','180_90',NULL,'8',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (27,'t_obs_sep','pos_av_bras','180_45',NULL,'8',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (28,'t_obs_sep','pos_av_bras','180_0',NULL,'8',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (29,'t_obs_sep','pos_av_bras','135_180',NULL,'8',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (30,'t_obs_sep','pos_av_bras','135_135',NULL,'8',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (31,'t_obs_sep','pos_av_bras','135_90',NULL,'8',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (32,'t_obs_sep','pos_av_bras','135_45',NULL,'8',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (33,'t_obs_sep','pos_av_bras','135_0',NULL,'8',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (34,'t_obs_sep','pos_av_bras','90_180',NULL,'8',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (35,'t_obs_sep','pos_av_bras','90_135',NULL,'8',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (36,'t_obs_sep','pos_av_bras','90_90',NULL,'8',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (37,'t_obs_sep','pos_av_bras','90_45',NULL,'8',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (38,'t_obs_sep','pos_av_bras','90_0',NULL,'8',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (39,'t_obs_sep','pos_av_bras','45_180',NULL,'8',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (40,'t_obs_sep','pos_av_bras','45_135',NULL,'8',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (41,'t_obs_sep','pos_av_bras','45_90',NULL,'8',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (42,'t_obs_sep','pos_av_bras','45_45',NULL,'8',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (43,'t_obs_sep','pos_av_bras','45_0',NULL,'8',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (44,'t_obs_sep','pos_av_bras','0_180',NULL,'8',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (45,'t_obs_sep','pos_av_bras','0_135',NULL,'8',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (46,'t_obs_sep','pos_av_bras','0_90',NULL,'8',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (47,'t_obs_sep','pos_av_bras','0_45',NULL,'8',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (48,'t_obs_sep','pos_av_bras','0_0',NULL,'8',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (49,'t_obs_sep','pos_memb_inf','alignés',NULL,'9',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (50,'t_obs_sep','pos_memb_inf','fléchis vers la droite',NULL,'9',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (51,'t_obs_sep','pos_memb_inf','fléchis vers la gauche',NULL,'9',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (52,'t_obs_sep','pos_memb_inf','fléchis position centrale',NULL,'9',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (53,'t_obs_sep','pos_memb_inf','non observable',NULL,'9',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (54,'t_obs_sep','nom_amenag','calage céphalique','s''il y a eu un calage céphalique qui aurait permis d''éviter le basculement latéral de la tête',NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (55,'t_obs_sep','nom_amenag','contrainte céphalique','si un élément aurait pu contrainte la tête par le dessous. Les coussins céphaliques rentrent dans cette catégorie. ',NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (56,'t_obs_sep','nom_amenag','calage mentonnier','si un calage a été placé sous la mandibule du sujet',NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (57,'t_obs_sep','matiere','pierre',NULL,'62','mais aussi 63 et 64');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (58,'t_obs_sep','matiere','os',NULL,'62','mais aussi 63 et 64');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (59,'t_obs_sep','matiere','céramique',NULL,'62','mais aussi 63 et 64');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (60,'t_obs_sep','matiere','fosse',NULL,'62','mais aussi 63 et 64');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (61,'t_obs_sep','matiere','bois',NULL,'62','mais aussi 63 et 64');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (62,'t_obs_sep','connexions','conservées',NULL,'11',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (63,'t_obs_sep','connexions','moyennes',NULL,'11',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (64,'t_obs_sep','connexions','non conservées',NULL,'11',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (65,'t_obs_sep','connexions','indéterminées',NULL,'11',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (66,'t_obs_sep','type_decompo','rapide','si le défunt s''est décomposé au sein d''un espace colmaté rapidement ','14',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (67,'t_obs_sep','type_decompo','progressif','si le défunt s''est décomposé au sein d''un espace laissant le sédiment s''infiltrer progressivement ','14',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (68,'t_obs_sep','type_decompo','différé','si le défunt s''est décomposé au sein d''un espace empêchant le sédiment de sceller les relations ostéo-articulaires','14',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (69,'t_obs_sep','type_decompo','indéterminé','si le manque d''osbervations ne permet pas de répondre quant à la vitesse du colmatage','14',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (70,'t_obs_sep','compression','épaule',NULL,'17',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (71,'t_obs_sep','compression','bassin',NULL,'17',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (72,'t_obs_sep','compression','pieds',NULL,'17',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (73,'t_obs_sep','stad_conserv','1','100% de corticale saine','10',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (74,'t_obs_sep','stad_conserv','2','entre 62,5% et 99% de corticale saine','10',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (75,'t_obs_sep','stad_conserv','3','entre 37,5% et 62,5% de corticale saine','10',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (76,'t_obs_sep','stad_conserv','4','entre 1% et 37,5M% de corticale saine','10',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (77,'t_obs_sep','stad_conserv','5','0% de corticale saine ','10',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (78,'t_obs_sep','apparition','antérieure',NULL,'18','valeur applicable aus champs "crane_face", "ceint_scap_d", "ceint_scap_g", "m_sup_d", "m_sup_g", "rachis", "ceint_pelv", "m_inf_d" et "m_inf_g"');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (79,'t_obs_sep','apparition','antéro_sup',NULL,'18','valeur applicable aus champs "crane_face", "ceint_scap_d", "ceint_scap_g", "m_sup_d", "m_sup_g", "rachis", "ceint_pelv", "m_inf_d" et "m_inf_g"');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (80,'t_obs_sep','apparition','antéro_inf',NULL,'18','valeur applicable aus champs "crane_face", "ceint_scap_d", "ceint_scap_g", "m_sup_d", "m_sup_g", "rachis", "ceint_pelv", "m_inf_d" et "m_inf_g"');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (81,'t_obs_sep','apparition','antéro_lat',NULL,'18','valeur applicable aus champs "crane_face", "ceint_scap_d", "ceint_scap_g", "m_sup_d", "m_sup_g", "rachis", "ceint_pelv", "m_inf_d" et "m_inf_g"');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (82,'t_obs_sep','apparition','antéro_lat_D',NULL,'18','valeur applicable aus champs "crane_face", "ceint_scap_d", "ceint_scap_g", "m_sup_d", "m_sup_g", "rachis", "ceint_pelv", "m_inf_d" et "m_inf_g"');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (83,'t_obs_sep','apparition','antéro_lat_G',NULL,'18','valeur applicable aus champs "crane_face", "ceint_scap_d", "ceint_scap_g", "m_sup_d", "m_sup_g", "rachis", "ceint_pelv", "m_inf_d" et "m_inf_g"');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (84,'t_obs_sep','apparition','antéro_méd',NULL,'18','valeur applicable aus champs "crane_face", "ceint_scap_d", "ceint_scap_g", "m_sup_d", "m_sup_g", "rachis", "ceint_pelv", "m_inf_d" et "m_inf_g"');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (85,'t_obs_sep','apparition','postérieure',NULL,'18','valeur applicable aus champs "crane_face", "ceint_scap_d", "ceint_scap_g", "m_sup_d", "m_sup_g", "rachis", "ceint_pelv", "m_inf_d" et "m_inf_g"');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (86,'t_obs_sep','apparition','postéro-sup',NULL,'18','valeur applicable aus champs "crane_face", "ceint_scap_d", "ceint_scap_g", "m_sup_d", "m_sup_g", "rachis", "ceint_pelv", "m_inf_d" et "m_inf_g"');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (87,'t_obs_sep','apparition','postéro_inf',NULL,'18','valeur applicable aus champs "crane_face", "ceint_scap_d", "ceint_scap_g", "m_sup_d", "m_sup_g", "rachis", "ceint_pelv", "m_inf_d" et "m_inf_g"');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (88,'t_obs_sep','apparition','postéro_lat',NULL,'18','valeur applicable aus champs "crane_face", "ceint_scap_d", "ceint_scap_g", "m_sup_d", "m_sup_g", "rachis", "ceint_pelv", "m_inf_d" et "m_inf_g"');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (89,'t_obs_sep','apparition','postéro_med',NULL,'18','valeur applicable aus champs "crane_face", "ceint_scap_d", "ceint_scap_g", "m_sup_d", "m_sup_g", "rachis", "ceint_pelv", "m_inf_d" et "m_inf_g"');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (90,'t_obs_sep','apparition','latérale',NULL,'18','valeur applicable aus champs "crane_face", "ceint_scap_d", "ceint_scap_g", "m_sup_d", "m_sup_g", "rachis", "ceint_pelv", "m_inf_d" et "m_inf_g"');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (91,'t_obs_sep','apparition','latérale_G',NULL,'18','valeur applicable aus champs "crane_face", "ceint_scap_d", "ceint_scap_g", "m_sup_d", "m_sup_g", "rachis", "ceint_pelv", "m_inf_d" et "m_inf_g"');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (92,'t_obs_sep','apparition','latérale_D',NULL,'18','valeur applicable aus champs "crane_face", "ceint_scap_d", "ceint_scap_g", "m_sup_d", "m_sup_g", "rachis", "ceint_pelv", "m_inf_d" et "m_inf_g"');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (93,'t_obs_sep','apparition','médiale',NULL,'18','valeur applicable aus champs "crane_face", "ceint_scap_d", "ceint_scap_g", "m_sup_d", "m_sup_g", "rachis", "ceint_pelv", "m_inf_d" et "m_inf_g"');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (94,'t_obs_sep','apparition','inférieure',NULL,'18','valeur applicable aus champs "crane_face", "ceint_scap_d", "ceint_scap_g", "m_sup_d", "m_sup_g", "rachis", "ceint_pelv", "m_inf_d" et "m_inf_g"');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (95,'t_obs_sep','apparition','supérieure',NULL,'18','valeur applicable aus champs "crane_face", "ceint_scap_d", "ceint_scap_g", "m_sup_d", "m_sup_g", "rachis", "ceint_pelv", "m_inf_d" et "m_inf_g"');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (96,'t_obs_sep','apparition','non observable',NULL,'18','valeur applicable aus champs "crane_face", "ceint_scap_d", "ceint_scap_g", "m_sup_d", "m_sup_g", "rachis", "ceint_pelv", "m_inf_d" et "m_inf_g"');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (97,'t_obs_sep','apparition','indéterminé',NULL,'18','valeur applicable aus champs "crane_face", "ceint_scap_d", "ceint_scap_g", "m_sup_d", "m_sup_g", "rachis", "ceint_pelv", "m_inf_d" et "m_inf_g"');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (98,'nombre_sec','ad_imm','adulte',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (99,'nombre_sec','ad_imm','immature',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (100,'nombre_sec','type_nmi','frontal',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (101,'nombre_sec','type_nmi','occipital',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (102,'nombre_sec','type_nmi','maxillaire',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (103,'nombre_sec','type_nmi','mandibule',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (104,'nombre_sec','type_nmi','sacrum',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (105,'nombre_sec','type_nmi','atlas',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (106,'nombre_sec','type_nmi','axis',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (107,'nombre_sec','type_nmi','pariétale droit',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (108,'nombre_sec','type_nmi','pariétale gauche',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (109,'nombre_sec','type_nmi','temporal droit',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (110,'nombre_sec','type_nmi','temporal gauche',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (111,'nombre_sec','type_nmi','clavicule droite',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (112,'nombre_sec','type_nmi','clavicule gauche',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (113,'nombre_sec','type_nmi','scapula droite',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (114,'nombre_sec','type_nmi','scapula gauche',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (115,'nombre_sec','type_nmi','extrémité proximale haumérus droit',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (116,'nombre_sec','type_nmi','extrémité proximale haumérus gauche',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (117,'nombre_sec','type_nmi','diaphyse humérale droite',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (118,'nombre_sec','type_nmi','diaphyse humérale gauche',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (119,'nombre_sec','type_nmi','extrémité distale humérus droit',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (120,'nombre_sec','type_nmi','extrémité distale humérus gauche',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (121,'nombre_sec','type_nmi','extrémité proximale radius droit',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (122,'nombre_sec','type_nmi','extrémité proximale radius gauche',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (123,'nombre_sec','type_nmi','diaphyse radius droit',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (124,'nombre_sec','type_nmi','diaphyse radius gauche',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (125,'nombre_sec','type_nmi','extrémité distale radius droit',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (126,'nombre_sec','type_nmi','extrémité distale radius gauche',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (127,'nombre_sec','type_nmi','extrémité proximale ulna droit',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (128,'nombre_sec','type_nmi','extrémité proximale ulna gauche',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (129,'nombre_sec','type_nmi','diaphyse ulna droite',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (130,'nombre_sec','type_nmi','diaphyse ulna gauche',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (131,'nombre_sec','type_nmi','extrémité distale ulna droite',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (132,'nombre_sec','type_nmi','extrémité distale ulna gauche',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (133,'nombre_sec','type_nmi','ilium droit',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (134,'nombre_sec','type_nmi','ilium gauche',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (135,'nombre_sec','type_nmi','pubis droit',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (136,'nombre_sec','type_nmi','pubis gauche',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (137,'nombre_sec','type_nmi','ischium droit',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (138,'nombre_sec','type_nmi','ischium gauche',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (139,'nombre_sec','type_nmi','extrémité proximale fémur droit',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (140,'nombre_sec','type_nmi','extrémité proximale fémur gauche',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (141,'nombre_sec','type_nmi','diaphyse fémur droit',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (142,'nombre_sec','type_nmi','diaphyse fémur gauche',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (143,'nombre_sec','type_nmi','extrémité distale fémur droit',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (144,'nombre_sec','type_nmi','extrémité distale fémur gauche',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (145,'nombre_sec','type_nmi','patella droite',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (146,'nombre_sec','type_nmi','patella gauche',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (147,'nombre_sec','type_nmi','extrémité proximale tibia droit',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (148,'nombre_sec','type_nmi','extrémité proximale tibia gauche',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (149,'nombre_sec','type_nmi','diaphyse tibia droite',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (150,'nombre_sec','type_nmi','diaphyse tibia gauche',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (151,'nombre_sec','type_nmi','extrémité distale tibia droit',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (152,'nombre_sec','type_nmi','extrémité distale tibia gauche',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (153,'nombre_sec','type_nmi','extrémité proximale fibula droite',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (154,'nombre_sec','type_nmi','extrémité proximale fibula gauche',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (155,'nombre_sec','type_nmi','diaphyse fibula droite',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (156,'nombre_sec','type_nmi','diaphyse fibula gauche',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (157,'nombre_sec','type_nmi','extrémité distale fibula droite',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (158,'nombre_sec','type_nmi','extrémité distale fibula gauche',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (159,'nombre_sec','type_nmi','calcanéus droit',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (160,'nombre_sec','type_nmi','calcanéus gauche',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (161,'nombre_sec','type_nmi','talus droit',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (162,'nombre_sec','type_nmi','talus gauche',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (163,'nombre_sec','type_nmi','naviculaire droit',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (164,'nombre_sec','type_nmi','naviculaire gauche',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (165,'nombre_sec','type_nmi','cuboïde droit',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (166,'nombre_sec','type_nmi','cuboïde gauche',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (167,'t_cont_sep','type_cont','sarcophage',NULL,'34',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (168,'t_cont_sep','type_cont','cercueil',NULL,'34',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (169,'t_cont_sep','type_cont','coffrage',NULL,'34',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (170,'t_cont_sep','type_cont','monoxyle',NULL,'34',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (171,'t_cont_sep','type_cont','sans contenant apparent',NULL,'34',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (172,'t_cont_sep','type_cont','fosse maçonnée',NULL,'34',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (173,'t_cont_sep','type_cont','indéterminé',NULL,'34',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (174,NULL,'matiere','alios',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (175,NULL,'matiere','alliage cuivreux',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (176,NULL,'matiere','argent',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (177,NULL,'matiere','fer',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (178,NULL,'matiere','or',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (179,NULL,'matiere','étain',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (180,NULL,'matiere','ambre',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (181,NULL,'matiere','argent',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (182,NULL,'matiere','bois',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (183,NULL,'matiere','charbon de bois',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (184,NULL,'matiere','cheveux',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (185,NULL,'matiere','cire',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (186,NULL,'matiere','coprolithe',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (187,NULL,'matiere','coquille',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (188,NULL,'matiere','corail',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (189,NULL,'matiere','corne',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (190,NULL,'matiere','cuir',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (191,NULL,'matiere','écaille',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (192,NULL,'matiere','écorce',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (193,NULL,'matiere','enduit peint',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (194,NULL,'matiere','os animal',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (195,NULL,'matiere','fossile',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (196,NULL,'matiere','fourrure',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (197,NULL,'matiere','galalithe',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (198,NULL,'matiere','insecte',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (199,NULL,'matiere','ivoire',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (200,NULL,'matiere','jais',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (201,NULL,'matiere','lichen',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (202,NULL,'matiere','lignite',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (203,NULL,'matiere','métal indifférencié',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (204,NULL,'matiere','mortier',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (205,NULL,'matiere','nacre',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (206,NULL,'matiere','os humain',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (207,NULL,'matiere','papier',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (208,NULL,'matiere','parchemin',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (209,NULL,'matiere','pierre indifférencié',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (210,NULL,'matiere','peau',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (211,NULL,'matiere','perle fine',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (212,NULL,'matiere','pierre indifférenciée fine',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (213,NULL,'matiere','pisé',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (214,NULL,'matiere','plâtre',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (215,NULL,'matiere','plomb',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (216,NULL,'matiere','plomb ou étain',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (217,NULL,'matiere','scorie',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (218,NULL,'matiere','stuc',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (219,NULL,'matiere','terre crue',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (220,NULL,'matiere','terre cuite',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (221,NULL,'matiere','textile',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (222,NULL,'matiere','torchis',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (223,NULL,'matiere','vannerie',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (224,NULL,'matiere','végétal',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (225,NULL,'matiere','verre',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (226,NULL,'matiere','zinc',NULL,'matière(s)',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (227,'t_mob_sep','typobj','accessoire vestimentaire',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (228,'t_mob_sep','typobj','arme',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (229,'t_mob_sep','typobj','contenant, suspension',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (230,'t_mob_sep','typobj','fibule',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (231,'t_mob_sep','typobj','jarretière, chausse',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (232,'t_mob_sep','typobj','parure',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (233,'t_mob_sep','typobj','petit objet',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (234,'t_mob_sep','typobj','petit outillage',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (235,'t_mob_sep','typobj','récipient',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (236,'t_mob_sep','typobj','autre',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (237,'t_mob_sep','ss_typobj','arme défensive',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (238,'t_mob_sep','ss_typobj','arme offensive',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (239,'t_mob_sep','ss_typobj','aumônière',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (240,'t_mob_sep','ss_typobj','bague',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (241,'t_mob_sep','ss_typobj','boucle',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (242,'t_mob_sep','ss_typobj','boucle d''oreille',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (243,'t_mob_sep','ss_typobj','boucle simple',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (244,'t_mob_sep','ss_typobj','bracelet',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (245,'t_mob_sep','ss_typobj','briquet',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (246,'t_mob_sep','ss_typobj','chaînes',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (247,'t_mob_sep','ss_typobj','coffret, pyxide',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (248,'t_mob_sep','ss_typobj','collier de perles',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (249,'t_mob_sep','ss_typobj','contre-plaque',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (250,'t_mob_sep','ss_typobj','épingle',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (251,'t_mob_sep','ss_typobj','fibule unique',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (252,'t_mob_sep','ss_typobj','fiche bélière',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (253,'t_mob_sep','ss_typobj','force',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (254,'t_mob_sep','ss_typobj','monnaie',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (255,'t_mob_sep','ss_typobj','paire de fibules',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (256,'t_mob_sep','ss_typobj','pince à écharder',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (257,'t_mob_sep','ss_typobj','plaque de châtelaines',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (258,'t_mob_sep','ss_typobj','plaque-boucle',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (259,'t_mob_sep','ss_typobj','plaque-dorsale',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (260,'t_mob_sep','ss_typobj','autre',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (261,'t_mesure','ss_cat_mesure_sex','DSP',NULL,'mesure sexe',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (262,'t_mesure','ss_cat_mesure_sex','FNAL',NULL,'mesure sexe',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (263,'t_mesure','ss_cat_mesure_sex','FNW',NULL,'mesure sexe',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (264,'t_mesure','nom_mesure_sex','PUM droit',NULL,'DSP','mesure relative à l''os coxal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (265,'t_mesure','nom_mesure_sex','PUM gauche',NULL,'DSP','mesure relative à l''os coxal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (266,'t_mesure','nom_mesure_sex','SPU droit',NULL,'DSP','mesure relative à l''os coxal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (267,'t_mesure','nom_mesure_sex','SPU gauche',NULL,'DSP','mesure relative à l''os coxal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (268,'t_mesure','nom_mesure_sex','DCOX droit',NULL,'DSP','mesure relative à l''os coxal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (269,'t_mesure','nom_mesure_sex','DCOX gauche',NULL,'DSP','mesure relative à l''os coxal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (270,'t_mesure','nom_mesure_sex','IIMT droit',NULL,'DSP','mesure relative à l''os coxal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (271,'t_mesure','nom_mesure_sex','IIMT gauche',NULL,'DSP','mesure relative à l''os coxal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (272,'t_mesure','nom_mesure_sex','ISMM droit',NULL,'DSP','mesure relative à l''os coxal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (273,'t_mesure','nom_mesure_sex','ISMM gauche',NULL,'DSP','mesure relative à l''os coxal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (274,'t_mesure','nom_mesure_sex','SCOX droit',NULL,'DSP','mesure relative à l''os coxal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (275,'t_mesure','nom_mesure_sex','SCOX gauche',NULL,'DSP','mesure relative à l''os coxal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (276,'t_mesure','nom_mesure_sex','SS droit',NULL,'DSP','mesure relative à l''os coxal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (277,'t_mesure','nom_mesure_sex','SS gauche',NULL,'DSP','mesure relative à l''os coxal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (278,'t_mesure','nom_mesure_sex','SA droit',NULL,'DSP','mesure relative à l''os coxal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (279,'t_mesure','nom_mesure_sex','SA gauche',NULL,'DSP','mesure relative à l''os coxal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (280,'t_mesure','nom_mesure_sex','SIS droit',NULL,'DSP','mesure relative à l''os coxal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (281,'t_mesure','nom_mesure_sex','SIS gauche',NULL,'DSP','mesure relative à l''os coxal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (282,'t_mesure','nom_mesure_sex','VEAC droit',NULL,'DSP','mesure relative à l''os coxal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (283,'t_mesure','nom_mesure_sex','VEAC gauche',NULL,'DSP','mesure relative à l''os coxal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (284,'t_mesure','nom_mesure_sex','FNAL droit','mesure femoral neck axis length droit','FNAL','mesure relative au fémur');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (285,'t_mesure','nom_mesure_sex','FNAL gauche','mesure femoral neck axis length gauche','FNAL','mesure relative au fémur');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (286,'t_mesure','nom_mesure_sex','FNW droit','mesure femoral neck width droit','FNW','mesure relative au fémur');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (287,'t_mesure','nom_mesure_sex','FNW gauche','mesure femoral neck width gauche','FNW','mesure relative au fémur');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (288,'t_squelette','age_class','f',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (289,'t_squelette','age_class','p',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (290,'t_squelette','age_class','0 à 1 an',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (291,'t_squelette','age_class','1 à 4 ans',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (292,'t_squelette','age_class','5 à 9 ans',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (293,'t_squelette','age_class','10 à 14 ans',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (294,'t_squelette','age_class','15 à 19 ans',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (295,'t_squelette','age_class','20 à 29 ans',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (296,'t_squelette','age_class','adulte',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (297,'t_squelette','age_class','non observable',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (298,'t_squelette','age_method','Moorrees 1963',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (299,'t_squelette','age_method','Ubelaker 1984',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (300,'t_squelette','age_method','Birkner 1982',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (301,'t_squelette','age_method','Ferembach 1979 ',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (302,'t_squelette','age_method','Stloukal Hanakova 79',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (303,'t_squelette','age_method','Coqueniot Weaver 2007-2010 ',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (304,'t_squelette','age_method','Cémentochronologie',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (305,'t_mesure','ss_cat_mesure_age','mesure diaphyse',NULL,'mesure âge',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (306,'t_mesure','ss_cat_mesure_age','surface sacro-pelvienne',NULL,'mesure âge',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (307,'t_mesure','ss_cat_mesure_age','sutures crâniennes',NULL,'mesure âge',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (308,'t_mesure','nom_mesure_age','diaphyse fémur',NULL,'mesure diaphyse','mesure relative au fémur adulte');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (309,'t_mesure','nom_mesure_age','diaphyse tibia',NULL,'mesure diaphyse','mesure relative au tibia adulte');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (310,'t_mesure','nom_mesure_age','SSPIA droite','organisation transverse droite','surface sacro-pelvienne','mesure relative à l''os coxal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (311,'t_mesure','nom_mesure_age','SSPIA gauche','organisation transverse gauche','surface sacro-pelvienne','mesure relative à l''os coxal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (312,'t_mesure','nom_mesure_age','SSPIB droite','modification de la surface articulaire droite','surface sacro-pelvienne','mesure relative à l''os coxal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (313,'t_mesure','nom_mesure_age','SSPIB gauche','modification de la surface articulaire gauche','surface sacro-pelvienne','mesure relative à l''os coxal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (314,'t_mesure','nom_mesure_age','SSPIC droite','modification apicale droite','surface sacro-pelvienne','mesure relative à l''os coxal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (315,'t_mesure','nom_mesure_age','SSPIC gauche','modification apicale gauche','surface sacro-pelvienne','mesure relative à l''os coxal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (316,'t_mesure','nom_mesure_age','SSPID droite','modification de la tubérosité iliaque droite','surface sacro-pelvienne','mesure relative à l''os coxal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (317,'t_mesure','nom_mesure_age','SSPID gauche','modification de la tubérosité iliaque gauche','surface sacro-pelvienne','mesure relative à l''os coxal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (318,'t_mesure','nom_mesure_age','C1 droite','suture coronale 1 droite','sutures crâniennes','suture entre l''os frontal et l''os pariétal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (319,'t_mesure','nom_mesure_age','C1 gauche','suture coronale 1 gauche','sutures crâniennes','suture entre l''os frontal et l''os pariétal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (320,'t_mesure','nom_mesure_age','C2 droite','suture coronale 2 droite','sutures crâniennes','suture entre l''os frontal et l''os pariétal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (321,'t_mesure','nom_mesure_age','C2 gauche','suture coronale 2 gauche','sutures crâniennes','suture entre l''os frontal et l''os pariétal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (322,'t_mesure','nom_mesure_age','C3 droite','suture coronale 3 droite','sutures crâniennes','suture entre l''os frontal et l''os pariétal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (323,'t_mesure','nom_mesure_age','C3 gauche','suture coronale 3 gauche','sutures crâniennes','suture entre l''os frontal et l''os pariétal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (324,'t_mesure','nom_mesure_age','S1','suture sagittale 1','sutures crâniennes','suture entre l''os pariétal droit et l''os pariétal gauche');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (325,'t_mesure','nom_mesure_age','S2','suture sagittale 2','sutures crâniennes','suture entre l''os pariétal droit et l''os pariétal gauche');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (326,'t_mesure','nom_mesure_age','S3','suture sagittale 3','sutures crâniennes','suture entre l''os pariétal droit et l''os pariétal gauche');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (327,'t_mesure','nom_mesure_age','S4','suture sagittale 4','sutures crâniennes','suture entre l''os pariétal droit et l''os pariétal gauche');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (328,'t_mesure','nom_mesure_age','L1 droite','suture lambdoïde 1 droite','sutures crâniennes','suture entre l''os occipital et l''os pariétal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (329,'t_mesure','nom_mesure_age','L1 gauche','suture lambdoïde 1 gauche','sutures crâniennes','suture entre l''os occipital et l''os pariétal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (330,'t_mesure','nom_mesure_age','L2 droite','suture lambdoïde 2 droite','sutures crâniennes','suture entre l''os occipital et l''os pariétal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (331,'t_mesure','nom_mesure_age','L2 gauche','suture lambdoïde 2 gauche','sutures crâniennes','suture entre l''os occipital et l''os pariétal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (332,'t_mesure','nom_mesure_age','L3 droite','suture lambdoïde 3 droite','sutures crâniennes','suture entre l''os occipital et l''os pariétal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (333,'t_mesure','nom_mesure_age','L3 gauche','suture lambdoïde 3 gauche','sutures crâniennes','suture entre l''os occipital et l''os pariétal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (336,'t_mesure','ss_cat_mesure_patho','stress',NULL,'mesure pathologie',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (337,'t_mesure','ss_cat_mesure_patho','pathologies',NULL,'mesure pathologie',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (338,'t_mesure','ss_cat_mesure_patho','pathologies, appareil compensatoire',NULL,'mesure pathologie',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (339,'t_mesure','ss_cat_mesure_patho','marqueurs d''activité',NULL,'mesure pathologie',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (340,'t_mesure','ss_cat_mesure_patho','caractère discret',NULL,'mesure pathologie',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (341,'t_mesure','loc_mesure_patho','crâne',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (342,'t_mesure','loc_mesure_patho','membre supérieur droit',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (343,'t_mesure','loc_mesure_patho','membre supérieur gauche',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (344,'t_mesure','loc_mesure_patho','rachis / coxaux',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (345,'t_mesure','loc_mesure_patho','membre inférieur droit',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (346,'t_mesure','loc_mesure_patho','membre inférieur gauche',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (347,'t_mesure','nom_mesure_patho','HLED','hypoplasies linéraires de l''émail dentaire (valeur :  absence, faible, moyenne, forte, non visible)','stress','pathologie visible sur les dents (stries dues à une carence lors de la croissance)');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (348,'t_mesure','nom_mesure_patho','cribra','cribra orbitalia (valeur :  absence, faible, moyenne, forte, non visible)','stress','pathologie visible sur le crâne ou niveau des orbites (carence)');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (349,'t_mesure','nom_mesure_patho','carie','nombre de caries','stress','pathologie visible sur les dents');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (350,'t_mesure','nom_mesure_patho','perte dents ante-mortem','nombre de dents concernées','stress','pathologie visible sur la maniduble ou le maxillaire');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (351,'t_mesure','nom_mesure_patho','arthrose','0 ou 1','pathologies',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (352,'t_mesure','nom_mesure_patho','Trépanation','0 ou 1','pathologies','pathologie associé au crâne');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (353,'t_mesure','nom_mesure_patho','Édentement complet ','0 ou 1','pathologies','pathologie visible sur la maniduble ou le maxillaire');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (354,'t_mesure','nom_mesure_patho','Atteinte neurale','0 ou 1','pathologies','');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (355,'t_mesure','nom_mesure_patho','Scoliose sévère','0 ou 1','pathologies','pathologie associé au rachis');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (356,'t_mesure','nom_mesure_patho','Maladie de Paget ou Ostéite déformante','0 ou 1','pathologies',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (357,'t_mesure','nom_mesure_patho','DISH','0 ou 1','pathologies','pathologie visible sur les os du rachis');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (358,'t_mesure','nom_mesure_patho','Rachitisme','0 ou 1','pathologies',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (359,'t_mesure','nom_mesure_patho','Nanisme','0 ou 1','pathologies',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (360,'t_mesure','nom_mesure_patho','Pathologies infectieuses (lèpre, syphilis, variole, etc.)','0 ou 1','pathologies',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (361,'t_mesure','nom_mesure_patho','Fracture non réduite ','0 ou 1','pathologies',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (362,'t_mesure','nom_mesure_patho','Amputation','0 ou 1','pathologies',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (363,'t_mesure','nom_mesure_patho','Pathologie dégénérative sévère','0 ou 1','pathologies',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (364,'t_mesure','nom_mesure_patho','Autres','0 ou 1','pathologies',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (365,'t_mesure','nom_mesure_patho','attèle','0 ou 1','pathologies, appareil compensatoire',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (366,'t_mesure','nom_mesure_patho','prothèse','0 ou 1','pathologies, appareil compensatoire',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (367,'t_mesure','nom_mesure_patho','orthèse','0 ou 1','pathologies, appareil compensatoire',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (368,'t_mesure','nom_mesure_patho','béquillage','0 ou 1','pathologies, appareil compensatoire',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (369,'t_mesure','nom_mesure_patho','autre','0 ou 1','pathologies, appareil compensatoire',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (370,'t_mesure','nom_mesure_patho','clav : insertion en creux du ligamentcosto-claviculaire','valeur : oui, non, non visible','marqueurs d''activité','marqueurs d''activité lié au clavicule');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (371,'t_mesure','nom_mesure_patho','hum : dvp de la crête du tubercule majeur','valeur : oui, non, non visible','marqueurs d''activité','marqueurs d''activité lié au fémur');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (372,'t_mesure','nom_mesure_patho','hum : dvp de la crête du tubercule mineur','valeur : oui, non, non visible','marqueurs d''activité','marqueurs d''activité lié au fémur');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (373,'t_mesure','nom_mesure_patho','hum : dvp de la tubérosité deltoïdienne','valeur : oui, non, non visible','marqueurs d''activité','marqueurs d''activité lié à l''humérus');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (374,'t_mesure','nom_mesure_patho','hum : dvp de la crête supracondylaire','valeur : oui, non, non visible','marqueurs d''activité','marqueurs d''activité lié au fémur');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (375,'t_mesure','nom_mesure_patho','rad : creux de la tubérosité bicipitale','valeur : oui, non, non visible','marqueurs d''activité','marqueurs d''activité lié au radius');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (376,'t_mesure','nom_mesure_patho','ulna: présence marquée de la crête du muscle supinateur','valeur : oui, non, non visible','marqueurs d''activité','marqueurs d''activité lié à l''ulna');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (377,'t_mesure','nom_mesure_patho','ulna : dvp de la tubérosité ulnaire','valeur : oui, non, non visible','marqueurs d''activité','marqueurs d''activité lié à l''ulna');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (378,'t_mesure','nom_mesure_patho','cox : bursite','valeur : oui, non, non visible','marqueurs d''activité','marqueurs d''activité lié au coxal');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (379,'t_mesure','nom_mesure_patho','patella : présence d''enthésopathie','valeur : oui, non, non visible','marqueurs d''activité','marqueurs d''activité lié à la patella');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (380,'t_mesure','nom_mesure_patho','tibia : développement et enthésopathie de la ligne du muscle soléaire','valeur : oui, non, non visible','marqueurs d''activité','marqueurs d''activité lié au tibia');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (381,'t_mesure','nom_mesure_patho','tibia : réactions périsostées diaphysaires','valeur : oui, non, non visible','marqueurs d''activité','marqueurs d''activité lié au tibia');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (382,'t_mesure','nom_mesure_patho','tibia : présence de facette d''accroupissement','valeur : oui, non, non visible','marqueurs d''activité','marqueurs d''activité lié au tibia');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (383,'t_mesure','nom_mesure_patho','talus : présence de facette d''accroupissement','valeur : oui, non, non visible','marqueurs d''activité','marqueurs d''activité lié au talus');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (384,'t_mesure','nom_mesure_patho','calca : enthésopathie de la face postérieure','valeur : oui, non, non visible','marqueurs d''activité','marqueurs d''activité lié au calcaneus');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (385,'t_mesure','nom_mesure_patho','ostéophyte sur vertèbre(s)','valeur : oui, non, non visible','marqueurs d''activité','pathologie visible sur les os du rachis');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (386,'t_mesure','nom_mesure_patho','enthésopathie du muscle adducteur (grand trochanter)','valeur : oui, non, non visible','marqueurs d''activité','marqueurs d''activité lié au fémur');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (387,'t_mesure','nom_mesure_patho','enthésopathie du muscle obturateur interne','valeur : oui, non, non visible','marqueurs d''activité','marqueurs d''activité lié au fémur');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (388,'t_mesure','nom_mesure_patho','enthésopathie du ligament ilio-fémoral (petit trochanter)','valeur : oui, non, non visible','marqueurs d''activité','marqueurs d''activité lié au fémur');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (389,'t_mesure','nom_mesure_patho','présence d''ostéophyte périfovéale','valeur : oui, non, non visible','marqueurs d''activité','marqueurs d''activité lié au fémur');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (390,'t_mesure','nom_mesure_patho','insertion marquée du muscle grand fessier (ligne âpre)','valeur : oui, non, non visible','marqueurs d''activité','marqueurs d''activité lié au fémur');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (391,'t_mesure','nom_mesure_patho','métopisme','valeur : oui, non, non visible','caractère discret','caractère discret relatif au crâne');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (392,'t_mesure','nom_mesure_patho','foramen sternal','valeur : oui, non, non visible','caractère discret','caractère discret relatif aux sternèbres (immature) et sternum (adulte)');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (393,'t_mesure','nom_mesure_patho','foramen huméral','valeur : oui, non, non visible','caractère discret','caractère discret relatif à l''humérus');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (394,'t_mesure','nom_mesure','porion-bregma','en millimètre','mesure crâne adulte','mesure relative au crâne à saisir sur la représentation du crâne');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (395,'t_mesure','nom_mesure','longueur maximale','en millimètre','mesure crâne adulte','mesure relative au crâne à saisir sur la représentation du crâne');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (396,'t_mesure','nom_mesure','largeur maximale','en millimètre','mesure crâne adulte','mesure relative au crâne à saisir sur la représentation du crâne');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (397,'t_mesure','nom_mesure','endobasion-prosthion','en millimètre','mesure crâne adulte','mesure relative au crâne à saisir sur la représentation du crâne');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (398,'t_mesure','nom_mesure','endobasion-nasion','en millimètre','mesure crâne adulte','mesure relative au crâne à saisir sur la représentation du crâne');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (399,'t_mesure','nom_mesure','largeur bizygomatique','en millimètre','mesure crâne adulte','mesure relative au crâne à saisir sur la représentation du crâne');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (400,'t_mesure','nom_mesure','hauteur nasion prosthion','en millimètre','mesure crâne adulte','mesure relative au crâne à saisir sur la représentation du crâne');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (401,'t_mesure','nom_mesure','basion-bregma','en millimètre','mesure crâne adulte','mesure relative au crâne à saisir sur la représentation du crâne');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (402,'t_mesure','nom_mesure','largeur frontale minimale','en millimètre','mesure crâne adulte','mesure relative au crâne à saisir sur la représentation du crâne');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (403,'t_mesure','nom_mesure','distance inter-orbitaire','en millimètre','mesure crâne adulte','mesure relative au crâne à saisir sur la représentation du crâne');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (404,'t_mesure','nom_mesure','dimension orbite gauche','en millimètre','mesure crâne adulte','mesure relative au crâne à saisir sur la représentation du crâne');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (405,'t_mesure','nom_mesure','dimension orbite droite','en millimètre','mesure crâne adulte','mesure relative au crâne à saisir sur la représentation du crâne');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (406,'t_mesure','nom_mesure','longueur mandibule','en millimètre','mesure crâne adulte','mesure relative au crâne à saisir sur la représentation du crâne - mesure sur la mandibule');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (407,'t_mesure','nom_mesure','largeur bicondylienne','en millimètre','mesure crâne adulte','mesure relative au crâne à saisir sur la représentation du crâne - mesure sur la mandibule');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (408,'t_mesure','nom_mesure','largeur bigoniaque','en millimètre','mesure crâne adulte','mesure relative au crâne à saisir sur la représentation du crâne - mesure sur la mandibule');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (409,'t_mesure','nom_mesure','hauteur branche montante','en millimètre','mesure crâne adulte','mesure relative au crâne à saisir sur la représentation du crâne - mesure sur la mandibule');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (410,'t_mesure','nom_mesure','angle goniaque','en millimètre','mesure crâne adulte','mesure relative au crâne à saisir sur la représentation du crâne - mesure sur la mandibule');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (411,'t_mesure','nom_mesure','longueur','en millimètre','mesure humerus adulte','mesure relative à l''humérus adulte');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (412,'t_mesure','nom_mesure','périmètre','en millimètre','mesure humerus adulte','mesure relative à l''humérus adulte');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (413,'t_mesure','nom_mesure','diamètre minimum','en millimètre','mesure humerus adulte','mesure relative à l''humérus adulte');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (414,'t_mesure','nom_mesure','diamètre maximum','en millimètre','mesure humerus adulte','mesure relative à l''humérus adulte');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (415,'t_mesure','nom_mesure','taille d’après fémur','en millimètre','mesure fémur adulte','mesure relative au fémur adulte');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (416,'t_mesure','nom_mesure','longueur','en millimètre','mesure fémur adulte','mesure relative au fémur adulte');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (417,'t_mesure','nom_mesure','périmètre','en millimètre','mesure fémur adulte','mesure relative au fémur adulte');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (418,'t_mesure','nom_mesure','diamètre sagital','en millimètre','mesure fémur adulte','mesure relative au fémur adulte');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (419,'t_mesure','nom_mesure','diamètre transversal','en millimètre','mesure fémur adulte','mesure relative au fémur adulte');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (420,'t_mesure','nom_mesure','diaphyse','en millimètre','mesure fémur adulte','mesure relative au fémur adulte');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (421,'t_mesure','nom_mesure','taille d’après tibia','en millimètre','mesure tibia adulte','mesure relative au tibia adulte');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (422,'t_mesure','nom_mesure','longueur','en millimètre','mesure tibia adulte','mesure relative au tibia adulte');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (423,'t_mesure','nom_mesure','périmètre','en millimètre','mesure tibia adulte','mesure relative au tibia adulte');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (424,'t_mesure','nom_mesure','diamètre sagital','en millimètre','mesure tibia adulte','mesure relative au tibia adulte');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (425,'t_mesure','nom_mesure','diamètre transversal','en millimètre','mesure tibia adulte','mesure relative au tibia adulte');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (426,'t_mesure','nom_mesure','diaphyse','en millimètre','mesure tibia adulte','mesure relative au tibia adulte');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (427,'t_mesure','nom_mesure','longueur humérus droit','en millimètre','mesure immature','mesure relative à l''humérus immature');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (428,'t_mesure','nom_mesure','longueur humérus gauche','en millimètre','mesure immature','mesure relative à l''humérus immature');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (429,'t_mesure','nom_mesure','longueur radius droit','en millimètre','mesure immature','mesure relative au radius immature');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (430,'t_mesure','nom_mesure','longueur radius gauche','en millimètre','mesure immature','mesure relative au radius immature');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (431,'t_mesure','nom_mesure','longueur fémur droit','en millimètre','mesure immature','mesure relative au fémur immature');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (432,'t_mesure','nom_mesure','longueur fémur gauche','en millimètre','mesure immature','mesure relative au fémur immature');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (433,'t_mesure','nom_mesure','longueur tibia droit','en millimètre','mesure immature','mesure relative au tibia immature');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (434,'t_mesure','nom_mesure','longueur tibia gauche','en millimètre','mesure immature','mesure relative au tibia immature');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (435,'t_squelette','age_terrain','adulte',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (436,'t_squelette','age_terrain','immature',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (437,'t_squelette','age_terrain','périnatal',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (438,'t_squelette','sexe','masculin',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (439,'t_squelette','sexe','féminin',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (440,'t_squelette','sexe','indéterminé',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (441,'t_mesure','ss_cat_mesure_patho','état sanitaire',NULL,'mesure pathologie',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (442,'t_mesure','val_mesure_age','0',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (443,'t_mesure','val_mesure_age','1',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (444,'t_mesure','val_mesure_age','2',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (445,'t_mesure','val_mesure_age','3',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (446,'t_mesure','val_mesure_age','4',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (447,'t_mesure','val_mesure_age','indéterminé ou non observable',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (448,'toutes tables','champ booléen plus','oui',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (449,'toutes tables','champ booléen plus','non',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (450,'toutes tables','champ booléen plus','non observable',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (451,'t_obs_sep','pied','hyperflexion',NULL,'27',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (452,'t_obs_sep','pied','hyperextension',NULL,'27',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (453,'t_obs_sep','pied','normale',NULL,'27',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (454,'t_obs_sep','pied','fagot',NULL,'27',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (455,'t_obs_sep','pied','absent',NULL,'27',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (456,'t_mesure','ss_cat_mesure','mesure crâne adulte',NULL,'mesure',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (457,'t_mesure','ss_cat_mesure','mesure humérus adulte',NULL,'mesure',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (458,'t_mesure','ss_cat_mesure','mesure fémur adulte',NULL,'mesure',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (459,'t_mesure','ss_cat_mesure','mesure tibia adulte',NULL,'mesure',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (460,'t_mesure','ss_cat_mesure','mesure immature',NULL,'mesure',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (461,'t_obs_sep','pied','non observable',NULL,'27',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (462,'t_obs_sep','pied','superposé sur gauche',NULL,'27',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (463,'t_obs_sep','pied','superposé sur droit',NULL,'28',NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (464,'t_obs_sep','matiere','non observable',NULL,'62','mais aussi 63 et 64');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (465,'t_mesure','cat_mesure','mesure',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (466,'t_mesure','cat_mesure','âge',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (467,'t_mesure','cat_mesure','sexe',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (468,'t_mesure','cat_mesure','pathologie',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (469,'t_squelette','res_pratiq_fun','fosse à banquette',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (470,'t_squelette','res_pratiq_fun','pierres et plâtre',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (471,'t_squelette','res_pratiq_fun','sans contenant',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (472,'t_squelette','res_pratiq_fun','sarcophage',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (473,'t_squelette','res_pratiq_fun','indéterminé',NULL,NULL,NULL);
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (474,'t_obs_sep','matiere','sans',NULL,'62','mais aussi 63 et 64');
INSERT INTO "otd_thesaurus" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (475,'t_obs_sep','matiere','main',NULL,'62','mais aussi 63 et 64');



-- GENERATION DE LA DONNEE NECESSAIRE AU MANNEQUIN

-- les os du mannequin

INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (1,'squelette','squelette',NULL,NULL,NULL,X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (2,'contenant','paroi','droite',NULL,NULL,X'00016a0800002903bd268ed8234128498605392a5a41cc73fa308ed823415b7cb918392a5a417c060000000100000069030000000100000005000000cc73fa308ed8234128498605392a5a412903bd268ed8234128498605392a5a412903bd268ed823415b7cb918392a5a41cc73fa308ed823415b7cb918392a5a41cc73fa308ed8234128498605392a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (3,'contenant','paroi','tête',NULL,NULL,X'00016a0800002903bd268ed823415b7cb918392a5a41f6cf89738ed82341702a011a392a5a417c0600000001000000690300000001000000050000002903bd268ed82341702a011a392a5a41f6cf89738ed82341702a011a392a5a41f6cf89738ed823415b7cb918392a5a412903bd268ed823415b7cb918392a5a412903bd268ed82341702a011a392a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (4,'contenant','paroi','tête',NULL,NULL,X'00016a0800002903bd268ed82341139b3e04392a5a41f6cf89738ed8234128498605392a5a417c0600000001000000690300000001000000050000002903bd268ed8234128498605392a5a41f6cf89738ed8234128498605392a5a41f6cf89738ed82341139b3e04392a5a412903bd268ed82341139b3e04392a5a412903bd268ed8234128498605392a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (5,'contenant','paroi','gauche',NULL,NULL,X'00016a080000535f4c698ed8234128498605392a5a41f6cf89738ed823415b7cb918392a5a417c060000000100000069030000000100000005000000f6cf89738ed8234128498605392a5a41535f4c698ed8234128498605392a5a41535f4c698ed823415b7cb918392a5a41f6cf89738ed823415b7cb918392a5a41f6cf89738ed8234128498605392a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (6,'mobilier','mobilier',NULL,NULL,NULL,X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (7,'contenant','couvercle',NULL,NULL,NULL,X'00016a08000008cd377f8ed82341139b3e04392a5a41d59904cc8ed82341702a011a392a5a417c06000000010000006903000000010000000500000008cd377f8ed82341702a011a392a5a41d59904cc8ed82341702a011a392a5a41d59904cc8ed82341139b3e04392a5a4108cd377f8ed82341139b3e04392a5a4108cd377f8ed82341702a011a392a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (8,'contenant','fond',NULL,NULL,NULL,X'00016a080000cc73fa308ed8234128498605392a5a41535f4c698ed823415b7cb918392a5a417c060000000100000069030000000100000005000000535f4c698ed823415b7cb918392a5a41535f4c698ed8234128498605392a5a41cc73fa308ed8234128498605392a5a41cc73fa308ed823415b7cb918392a5a41535f4c698ed823415b7cb918392a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (13,'os','clavicule','droit','ceinture scapulaire','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (14,'os','scapula','droit','ceinture scapulaire','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (15,'os','côte 1','droit','thorax','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (16,'os','côte 2','droit','thorax','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (17,'os','côte 3','droit','thorax','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (18,'os','côte 4','droit','thorax','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (19,'os','côte 5','droit','thorax','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (20,'os','côte 6','droit','thorax','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (21,'os','côte 7','droit','thorax','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (22,'os','côte 8','droit','thorax','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (23,'os','côte 9','droit','thorax','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (24,'os','côte 10','droit','thorax','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (25,'os','côte 11','droit','thorax','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (26,'os','côte 12','droit','thorax','adulte',X'00016a08000092235e858dd82341313ddcaa382a5a410f5ff8ca8dd82341b78e93b0382a5a417c06000000010000006903000000010000003a0000000dcc73918dd823417d2c18b0382a5a4132f4e8918dd82341360506b0382a5a41d4c604928dd82341badef2af382a5a419126df918dd82341b19cdeaf382a5a41a26ed4908dd82341f2159aaf382a5a4102dd97908dd823415a4a80af382a5a41984591908dd8234187d564af382a5a418c35ef908dd82341118544af382a5a418bb5bb918dd82341aaca1daf382a5a41ac9224948dd8234184d2c6ae382a5a417e7999998dd8234193f11fae382a5a412854d79b8dd823417fcce7ad382a5a41f4ef08a18dd82341cccc7bad382a5a411e9bcca58dd82341193a25ad382a5a412241f3a98dd82341e136dfac382a5a41424070ad8dd82341024eaeac382a5a41a99bb5b08dd82341ae4f8eac382a5a4155a13cb28dd8234169eb7bac382a5a4180afd5ba8dd823412744f2ab382a5a41c33fd0bd8dd823412ee9c5ab382a5a41a6f434c18dd82341b20298ab382a5a41703757c88dd82341427d40ab382a5a41e33636ca8dd8234197ed1fab382a5a410f5ff8ca8dd82341801a07ab382a5a41eda5eaca8dd823418405f5aa382a5a4176015aca8dd823412ab0e8aa382a5a41cf2b98c88dd82341313ddcaa382a5a41d82997c28dd823410f5bf2aa382a5a41cfc859be8dd82341aa8e07ab382a5a4104ead7b98dd82341e38a27ab382a5a4165770bb78dd82341463e42ab382a5a41aa08bfb08dd82341b27088ab382a5a41e3c780aa8dd82341f43dd9ab382a5a4163fb80a58dd823416b8026ac382a5a4173f3979a8dd823416affeeac382a5a414391d5948dd82341954962ad382a5a419d506f928dd823419e2e97ad382a5a41984591908dd82341f9aac5ad382a5a41a21d328f8dd8234156caefad382a5a41de7c1b8e8dd823415e9419ae382a5a41bd7c838a8dd82341e275c8ae382a5a41316c49898dd823414de0f8ae382a5a41d21a54868dd8234190005daf382a5a41eea697858dd82341257285af382a5a4192235e858dd823414428a6af382a5a413f6882858dd82341d6afbfaf382a5a41744cdf858dd82341c495d2af382a5a41b2a74f868dd82341f966dfaf382a5a41d24f85878dd823411f74f2af382a5a410a369f888dd82341e0650db0382a5a41d11e1c8a8dd82341ed3244b0382a5a41e1d7f68a8dd82341aa156db0382a5a41d29ceb8b8dd82341efa58cb0382a5a41d028f98c8dd82341b78e93b0382a5a41b3c90d8e8dd82341441d88b0382a5a4153cd178f8dd82341d79e70b0382a5a41888105908dd82341b26053b0382a5a410dcc73918dd823417d2c18b0382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (27,'os','fémur','droit','membre inférieur','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (28,'os','sacrum','axial','rachis','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (29,'os','coccyx','axial','rachis','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (30,'os','humérus','droit','membre supérieur','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (31,'os','ulna','droit','membre supérieur','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (32,'os','radius','droit','membre supérieur','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (33,'os','métacarpien','droit','membre supérieur','adulte',X'00016a0800009a45a19f8cd8234108deef9d382a5a41512d6cc28cd823410a1409a2382a5a417c060000000100000069030000000100000033000000611d02bc8cd82341932072a0382a5a419efaa8b78cd823410ac64aa0382a5a41d0c02cb48cd82341704112a0382a5a413f3876b18cd82341b74ccd9f382a5a412e296eaf8cd82341d0a1809f382a5a41e35bfdad8cd82341aefa309f382a5a41a3980cad8cd823414211e39e382a5a41b2a784ac8cd823417e9f9b9e382a5a4157514eac8cd82341545f5f9e382a5a41efd7f0ab8cd82341a293309e382a5a41114a15ab8cd82341fb640e9e382a5a412786d7a98cd823412ed3f89d382a5a419d6a53a88cd8234108deef9d382a5a41ddd5a4a68cd823415985f39d382a5a4152a6e7a48cd82341eec8039e382a5a4167ba37a38cd8234195a8209e382a5a4187f0b0a18cd823411c244a9e382a5a4149408ca08cd82341df4d779e382a5a4127ffe29f8cd823418a7d9f9e382a5a419a45a19f8cd823412a08c39e382a5a411e2cb39f8cd82341ce42e29e382a5a4130cb04a08cd823418482fd9e382a5a414a3b82a08cd82341591c159f382a5a41fce488a28cd82341201d569f382a5a4143a8cba38cd82341f8ee839f382a5a414165cbab8cd82341a377baa0382a5a41f32051ac8cd82341d1d7d9a0382a5a41d5b87fad8cd82341e19969a1382a5a41acab12ae8cd823413ef192a1382a5a41b3e4f5ae8cd823418dc7bea1382a5a41045e17b08cd823414244e4a1382a5a4195164ab18cd8234148d1fba1382a5a4134767fb28cd82341906c07a2382a5a41b0e4a8b38cd823410a1409a2382a5a41d7c9b7b48cd82341a9c502a2382a5a41798d9db58cd823415c7ff6a1382a5a4163974bb68cd82341153fe6a1382a5a4181ea2bb78cd823415cd7c0a1382a5a41145e05b88cd823417fd8aca1382a5a41027526b98cd823415c8598a1382a5a4181b8dabb8cd8234105df70a1382a5a416ce459c18cd823413a1229a1382a5a415efba5c18cd82341b72422a1382a5a41321909c28cd82341649b04a1382a5a41512d6cc28cd82341e5e8bfa0382a5a41a66256c28cd82341b40598a0382a5a41b042b3c18cd823419e0e7ea0382a5a417742afc08cd82341be5c6fa0382a5a4101d776bf8cd82341334969a0382a5a41567536be8cd82341182d69a0382a5a41611d02bc8cd82341932072a0382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (34,'os','phalange','droit','membre supérieur','adulte',X'00016a080000330fb9918cd8234151f8f79a382a5a41a9e3dba48cd823416caabc9d382a5a417c0600000001000000690300000001000000280000009945af9b8cd82341cc18ce9b382a5a41ccb5059b8cd82341a3542b9b382a5a419166b09a8cd82341877d0d9b382a5a41e4cf0e9a8cd82341a801fd9a382a5a4113df2e998cd8234151f8f79a382a5a416b811e988cd82341cb78fc9a382a5a413aa4eb968cd82341619a089b382a5a41cc34a4958cd823415d741a9b382a5a4173540f938cd82341afae479b382a5a4127df1e928cd823417bd65f9b382a5a41330fb9918cd82341fc52789b382a5a41fd05c4918cd8234194cf909b382a5a41ebe425928cd82341a2f7a89b382a5a4164cdc4928cd823418876c09b382a5a41100e0d958cd8234110aeff9b382a5a41e55fa7958cd82341cbe8179c382a5a410e8724968cd82341a2163a9c382a5a41652987968cd82341e739649c382a5a41f97607978cd82341fd69c89c382a5a41f0a160978cd82341bc7c929d382a5a412d21af978cd82341bdd9ac9d382a5a41921e20988cd82341ac1bba9d382a5a41c301a5988cd823416caabc9d382a5a4164322f998cd82341ddedb69d382a5a411818b0998cd82341e24dab9d382a5a41831a199a8cd823415c329c9d382a5a41f7ee9b9a8cd8234184be7b9d382a5a4190000a9b8cd8234105ba6a9d382a5a41dbb57c9c8cd82341b41d469d382a5a41ed4dce9e8cd82341a2861d9d382a5a419fdaa5a38cd823411193da9c382a5a4188da89a48cd82341c77ec89c382a5a41a9e3dba48cd82341c411b99c382a5a416884b2a48cd82341714dab9c382a5a412d4b24a48cd823413a339e9c382a5a419513fea08cd8234171ef709c382a5a4162e9cf9f8cd8234165b45b9c382a5a41ce8ec39e8cd82341b693429c382a5a41f344189d8cd82341d6ec0c9c382a5a419945af9b8cd82341cc18ce9b382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (35,'os','phalange','droit','membre supérieur','adulte',X'00016a080000409bc3848cd8234167a3f597382a5a4101001b938cd823412db9529a382a5a417c060000000100000069030000000100000024000000a126348c8cd82341d15a4b98382a5a413467d68b8cd82341ec531a98382a5a416d94438b8cd82341c0f1fe97382a5a41364b868a8cd8234167a3f597382a5a417928a9898cd82341f8d7fa97382a5a4121c9b6888cd823418efe0a98382a5a4119cab9878cd8234140862298382a5a41a260ca858cd823415b755998382a5a41513916858cd82341462c7298382a5a41409bc3848cd823419cd18798382a5a416697c4848cd82341b64e9b98382a5a41b93e0b858cd82341ef8cad98382a5a4131a289858cd82341a075bf98382a5a4117dfc7878cd82341014cfc98382a5a41dcef87888cd82341a0361599382a5a412e8723898cd82341795e3099382a5a417e9ca0898cd8234139034e99382a5a41dd1e578a8cd823411ec29199382a5a416b3d198b8cd823411241109a382a5a41d574728b8cd82341b38e369a382a5a41fac7fa8b8cd8234121c64b9a382a5a418c3eac8c8cd823412db9529a382a5a4139e0808d8cd82341a9394e9a382a5a41b2b4728e8cd823416719419a382a5a41beafbb918cd823415e26029a382a5a41c7eba2928cd82341492dea99382a5a413e0d12938cd82341f9b9cd99382a5a4101001b938cd82341824aae99382a5a41ecafcf928cd82341f75c8d99382a5a41dd0842928cd823416c6f6c99382a5a41b1f683918cd82341f5ff4c99382a5a414465a7908cd82341a58c3099382a5a415d7ee48e8cd82341ba7fff98382a5a4159e9298e8cd82341859ee098382a5a4197a20f8d8cd8234196ba9c98382a5a41a126348c8cd82341d15a4b98382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (36,'os','métacarpien','droit','membre supérieur','adulte',X'00016a080000f9afa8b78cd823411c70dd99382a5a41ac76c3da8cd8234130ecdca0382a5a417c06000000010000006903000000010000003700000007ce85d48cd823418151749f382a5a41004926d08cd8234151d29a9e382a5a41d78703cd8cd82341cb13d89d382a5a416feae9ca8cd82341d8022e9d382a5a41aed0a5c98cd82341618c9e9c382a5a41779a03c98cd82341529d2b9c382a5a41b0a7cfc88cd823419322d79b382a5a41fe0be4c88cd82341af3d919b382a5a41711183c88cd823416095509b382a5a414be622c88cd8234198feb29a382a5a41e19fecc78cd82341ae878a9a382a5a415aab7fc78cd823411711689a382a5a4141e4c1c68cd8234104964b9a382a5a4149bc25c18cd82341b6a7e899382a5a41517d19c08cd82341d203df99382a5a41047cefbe8cd823411c70dd99382a5a41ed8495bd8cd823412810e699382a5a419564f9bb8cd823418907fb99382a5a41ed167fba8cd82341c057189a382a5a41c3917bb98cd82341e839369a382a5a41e046d6b88cd823416543559a382a5a4110a876b88cd823419f09769a382a5a41f9afa8b78cd823410468419b382a5a41341cf1b78cd823415b56659b382a5a4117cb8fb88cd823413aa0849b382a5a41b87975b98cd82341edeca19b382a5a41fce637bd8cd82341e76c089c382a5a417ff7a0be8cd82341d44d389c382a5a41984004c08cd823414cd7729c382a5a4172eb5ac18cd823411040b69c382a5a414f74dac38cd82341336a4b9d382a5a4111b4eac78cd82341ec3b599e382a5a417ec0b1c88cd823416322959e382a5a41f1445ec98cd823418b61df9e382a5a412fb367ca8cd823413a61839f382a5a415ab86dcb8cd82341730d7ea0382a5a412af5f4cb8cd823413a6da5a0382a5a41a636bdcc8cd823411ab1c0a0382a5a411aebb1cd8cd82341c2c1d1a0382a5a41d080bece8cd82341e487daa0382a5a411266cecf8cd8234130ecdca0382a5a412a09cdd08cd8234156d7daa0382a5a41d8e70fd88cd8234149bfaba0382a5a41150707d98cd82341a0b2a2a0382a5a415bc0c5d98cd823411c4097a0382a5a41e5114eda8cd8234183fd88a0382a5a41ecf9a1da8cd823419a8077a0382a5a41ac76c3da8cd82341265f62a0382a5a415e86b4da8cd82341ee2e49a0382a5a4182570dda8cd8234147f908a0382a5a41d0006fd98cd82341b923e69f382a5a418be0a0d88cd823417af2c79f382a5a412133b8d78cd82341bf65ae9f382a5a419a22ecd58cd82341b83a899f382a5a4107ce85d48cd823418151749f382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (37,'os','métacarpien','droit','membre supérieur','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (38,'os','métacarpien','droit','membre supérieur','adulte',X'00016a080000015197fd8cd82341fafe1f99382a5a413457800e8dd82341138e39a0382a5a417c0600000001000000690300000001000000320000007cafea088dd823414443e29e382a5a410e74b0078dd8234175880a9e382a5a41676c19078dd823411a534f9d382a5a414c0a0f078dd8234146fcad9c382a5a4184bf7a078dd823410bdd239c382a5a41d5fd45088dd823417d4eae9b382a5a4105375a098dd82341afa94a9b382a5a41dadca00a8dd82341b447f69a382a5a413ae6370d8dd82341c0fd6f9a382a5a413a3f060e8dd823417e6f389a382a5a41b166720e8dd8234155d8069a382a5a413457800e8dd82341c039da99382a5a41570b340e8dd823413c95b199382a5a41b07d910d8dd8234143ec8b99382a5a41d4a89c0c8dd8234153406899382a5a415a87590b8dd82341e7924599382a5a41eff2d3098dd823411a282b99382a5a41ede721088dd82341fafe1f99382a5a418fa556068dd8234126c42299382a5a410e6b85048dd823413f243299382a5a41a477c1028dd82341e3cb4c99382a5a418c0a1e018dd82341b3677199382a5a41ff62aeff8cd823414ea49e99382a5a4138c085fe8cd82341552ed399382a5a417ff1d8fd8cd823419745039a382a5a41196eb9fd8cd8234195c1269a382a5a413c6105fe8cd82341a59d419a382a5a4119f69afe8cd8234120d5579a382a5a41d0b11b008dd82341b043869a382a5a41102fc3008dd823417671a69a382a5a41d8fa2c018dd8234103e8d19a382a5a41ce7e4c018dd8234180d6159b382a5a412e42f4008dd823418350ed9b382a5a4198e06cff8cd82341b6d4ed9d382a5a414ab002ff8cd82341abb8989e382a5a41bf569efe8cd82341ad190c9f382a5a41c439a3fd8cd82341f3fce09f382a5a41015197fd8cd82341baef08a0382a5a4125bdcdfd8cd823414b0723a0382a5a41c6754efe8cd82341c90032a0382a5a417d7221ff8cd82341569938a0382a5a41e2aa4e008dd82341138e39a0382a5a41126643068dd82341caf835a0382a5a4196b868088dd82341fb6529a0382a5a41eed0a9098dd823418fdd03a0382a5a41ff73360a8dd823413395cd9f382a5a41ae663e0a8dd8234197c28e9f382a5a41e06df1098dd82341699b4f9f382a5a417a4e7f098dd823415755189f382a5a417cafea088dd823414443e29e382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (39,'os','métacarpien','droit','membre supérieur','adulte',X'00016a080000043c26118dd82341ab9ef79b382a5a4153f41b2b8dd82341e12b99a1382a5a417c06000000010000006903000000010000002f000000ec335b1b8dd82341f3a52da1382a5a4117bea01c8dd823418f5ab5a0382a5a41d331c81d8dd8234166d938a0382a5a41f7457c1f8dd8234106dc599f382a5a41d04f43208dd823417b52049f382a5a41971f3a218dd82341de23aa9e382a5a4193b360228dd82341aea24d9e382a5a41060ab7238dd823416921f19d382a5a4135213d258dd8234190f2969d382a5a4166f7f2268dd82341a168419d382a5a41e3e05f2a8dd8234128eaaf9c382a5a41572f142b8dd82341b6ab7a9c382a5a4153f41b2b8dd82341c887519c382a5a41f2ad9d2a8dd8234162eb329c382a5a4150dabf298dd8234188431d9c382a5a4187f7a8288dd8234140fd0e9c382a5a41b3837f278dd823418d85069c382a5a41c5687b248dd82341e04bfa9b382a5a41a4aebc228dd82341ab9ef79b382a5a41d788f7218dd82341eb3ffd9b382a5a418d4648218dd82341b82d0a9c382a5a41c536b2208dd823418f65209c382a5a417fa838208dd82341ece4419c382a5a412777571e8dd82341927df59c382a5a41b2d6101a8dd82341197ea09e382a5a410b7602198dd82341f101fb9e382a5a411869f5178dd823413794499f382a5a41adb3e7168dd8234154dd8d9f382a5a41a259d7158dd82341b085c99f382a5a41cb5ec2148dd82341b635fe9f382a5a4113ff9e118dd82341c6fe7ea0382a5a41232b34118dd82341fbe49ba0382a5a41043c26118dd823410a2ab1a0382a5a41775359118dd82341fdf6bfa0382a5a413d93b1118dd82341e074c9a0382a5a41171d13128dd82341bdcccea0382a5a4123b032138dd823410f69d5a0382a5a410b2750148dd823411103eea0382a5a41a25d07158dd82341fd6a07a1382a5a414426d5158dd82341b66f2ca1382a5a41e530b6168dd823415e395fa1382a5a41011b9c178dd823414fcd89a1382a5a4170bc76188dd82341e12b99a1382a5a41b71c40198dd8234100f893a1382a5a415c43f2198dd8234197d480a1382a5a41e237871a8dd823418f6466a1382a5a41ec335b1b8dd82341f3a52da1382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (40,'os','phalange','droit','membre supérieur','adulte',X'00016a0800006cf6bb248dd82341f651be96382a5a417a2d0c3b8dd82341f765c19a382a5a417c06000000010000006903000000010000002d0000005af027328dd8234164904b9a382a5a41485fe8318dd823415917da99382a5a41ae3b1e328dd823414a277399382a5a41af43ba328dd8234159ad1499382a5a416b35ad338dd82341a796bc98382a5a4105cfe7348dd8234154d06898382a5a419cce5a368dd8234183471798382a5a414af8ac398dd82341eba27297382a5a416fa3db3a8dd82341d7c12997382a5a417a2d0c3b8dd82341ccaff696382a5a41b9066f3a8dd823413306d696382a5a41799f34398dd82341735ec496382a5a4109688d378dd82341f651be96382a5a41b7d0a9358dd82341237ac096382a5a41d149ba338dd823416370c796382a5a41a543ef318dd823411fcecf96382a5a41fc3e98308dd82341c1cbdb96382a5a41768fcc2f8dd8234142e8ef96382a5a41ac61682f8dd82341614e0c97382a5a4133e2472f8dd82341dc283197382a5a4191a0422f8dd82341e1e59497382a5a419537162f8dd82341e81dd497382a5a41462f9e2e8dd8234145751c98382a5a418e60e22d8dd82341e4116898382a5a41d365052d8dd823414ac5b098382a5a41b63a0b2c8dd823416c50f698382a5a41d241cf298dd82341baf17699382a5a414a6b95288dd82341cf89b199382a5a41995d09258dd823416fb0449a382a5a416cf6bb248dd823415fca659a382a5a41a03ff3248dd823411a6f7e9a382a5a4132ba8c258dd8234150b28f9a382a5a411de765268dd82341aea79a9a382a5a41ee5b4d288dd82341a0f7a19a382a5a41cba516298dd823419179a09a382a5a41d286de2a8dd823416128959a382a5a4156534c2c8dd82341903c949a382a5a413ee3732e8dd823411a3da49a382a5a41fbd3f12f8dd823411ab3b59a382a5a41bd3d4f318dd82341f765c19a382a5a4197f627328dd82341ca01bd9a382a5a41648896328dd823411101ad9a382a5a41fe7cb5328dd823414ade959a382a5a413c5e9f328dd82341f1137c9a382a5a415af027328dd8234164904b9a382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (41,'os','phalange','droit','membre supérieur','adulte',X'00016a080000703534368dd82341629ba892382a5a41c5bdbf458dd8234142b5de94382a5a417c060000000100000069030000000100000021000000efc8ab418dd823417f953f94382a5a41ca904e428dd82341bf3bfd93382a5a41badb41438dd82341c33fb393382a5a418bdd75458dd8234195502993382a5a41c5bdbf458dd82341f8f80693382a5a41ef60af458dd82341dc6aed92382a5a41bc0c52458dd823416913db92382a5a41e106b5448dd82341c45fce92382a5a411395e5438dd8234116bdc592382a5a41f2648b3f8dd82341bee3a892382a5a41c19d123f8dd82341629ba892382a5a41e55fb43e8dd8234143f7ae92382a5a415fb6683e8dd82341af49be92382a5a4155599c3d8dd8234133d92c93382a5a4129d9343d8dd823416ab55193382a5a41e3ccb23c8dd82341976d7193382a5a4131145f3b8dd823412168a893382a5a41607e9a388dd823410dd5ff93382a5a411c4af6368dd8234121773894382a5a41d91380368dd82341fe7b4c94382a5a41abee40368dd8234136db5b94382a5a41703534368dd82341a23e6794382a5a41074355368dd823411c506f94382a5a4151729f368dd823417db97494382a5a4136a18a388dd8234115aa8594382a5a416343963d8dd823419fd8bd94382a5a41b9df90408dd82341fc3adb94382a5a411c93c1418dd8234142b5de94382a5a419ef06a428dd823410ad9d194382a5a412729aa428dd82341dd8ab994382a5a419f6d9c428dd8234146af9a94382a5a41eeee5e428dd82341ce2a7a94382a5a41efc8ab418dd823417f953f94382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (42,'os','phalange','droit','membre supérieur','adulte',X'00016a08000028afad428dd8234150787290382a5a412e07334d8dd82341285db591382a5a417c06000000010000006903000000010000001d0000001feafc4a8dd82341285db591382a5a41da76504b8dd823417a7eb391382a5a41d3b1a24b8dd82341f531a791382a5a4101e4bf4b8dd82341af008891382a5a418ada944b8dd82341711b5491382a5a41dbd1ac4b8dd8234141d33d91382a5a418f3ecd4c8dd823414538ec90382a5a4119130d4d8dd82341f7fad090382a5a412e07334d8dd82341a584af90382a5a418e3f124d8dd8234186b49090382a5a411b44974c8dd82341a06b7d90382a5a41f19cdc4b8dd8234127ec7390382a5a412dd2fc4a8dd8234150787290382a5a41e96b124a8dd8234150527790382a5a4141f237498dd823415cbc8090382a5a4152ed87488dd82341a9f88c90382a5a4137e51c488dd823416d499a90382a5a4190b05a478dd8234175dcbf90382a5a41313ba4468dd82341a4ccd790382a5a417b998b458dd823419367f090382a5a415ec170438dd823416b6e1891382a5a4182bc01438dd823417a822591382a5a4145d4bf428dd823415c833191382a5a4128afad428dd8234151dc3b91382a5a41b1f3cd428dd8234199f84391382a5a41614823438dd8234173434991382a5a4167b182448dd8234167b84f91382a5a417da7c6468dd82341e7c26c91382a5a411feafc4a8dd82341285db591382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (43,'os','phalange','droit','membre supérieur','adulte',X'00016a080000961463fc8cd82341c2eac392382a5a411e3c8a108dd823417a981398382a5a417c060000000100000069030000000100000037000000987eed0a8dd8234133ed1397382a5a41a410510a8dd82341d2edbd96382a5a41024bfa098dd82341db6d5596382a5a410bd7e9098dd823414dcfe195382a5a41185e200a8dd8234128746a95382a5a4184899e0a8dd823416abef694382a5a41a802650b8dd8234114108e94382a5a41de72740c8dd8234125cb3794382a5a418083cd0d8dd823419b51fb93382a5a41adfd0e0f8dd82341415ece93382a5a418bfee20f8dd82341d569a293382a5a410a705b108dd8234143737893382a5a411e3c8a108dd823417a795193382a5a41b84c81108dd82341667b2e93382a5a41ca8b52108dd82341f6771093382a5a411e3dcb0f8dd82341b55ce792382a5a41e52c4d0f8dd823412997da92382a5a412e4c620e8dd8234117a7cf92382a5a41ec7d220d8dd8234157b5c792382a5a4115a5a50b8dd82341c2eac392382a5a419ba4030a8dd823413170c592382a5a41735f54088dd823417f6ecd92382a5a4192b8af068dd82341830edd92382a5a41ec922d058dd823411879f592382a5a41c91f19048dd8234134921293382a5a416da396038dd82341b5bd3193382a5a41429d83038dd8234138625693382a5a41104a8e048dd82341f0270794382a5a41d316e0048dd823419eb26394382a5a41dcd6f4048dd8234161b7d694382a5a41b2d0ab048dd8234134ee5195382a5a41f3840a048dd82341be04c495382a5a41a62e28038dd8234121d22b96382a5a41d1081c028dd823417b2d8896382a5a41794efd008dd82341ededd796382a5a41a53ae3ff8cd8234195ea1997382a5a415a08e5fe8cd8234195fa4c97382a5a414bd573fd8cd82341a81e8c97382a5a418946e4fc8cd82341ce1daa97382a5a4151d681fc8cd82341a2c9c797382a5a41961463fc8cd8234147f9e297382a5a414f919efc8cd82341e283f997382a5a4171dc4afd8cd8234196400998382a5a41f2857efe8cd8234189061098382a5a41cd5233028dd82341b1fd0498382a5a41be13a3038dd82341f6990498382a5a41251777078dd823417a981398382a5a41043a97088dd823413be20f98382a5a4124f80a0a8dd82341588c0498382a5a41b3ce590b8dd823418405ee97382a5a4190110c0c8dd82341000bcd97382a5a419d40440c8dd823417ec2a597382a5a41bddb240c8dd82341ae517c97382a5a41d062d00b8dd8234141de5497382a5a41987eed0a8dd8234133ed1397382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (44,'os','phalange','droit','membre supérieur','adulte',X'00016a0800005171b2d88cd82341a0eeca92382a5a416f9c6fec8cd82341fc231398382a5a417c0600000001000000690300000001000000350000007ac170eb8cd8234107b13c97382a5a416f066dea8cd82341a05f1497382a5a419c16c1e98cd8234119d3ee96382a5a41dc44fde88cd82341115ab996382a5a4177d82ce88cd823413da27196382a5a41b8185be78cd8234153591596382a5a41e74c93e68cd823410b2da295382a5a41bbb108e68cd823411d8c2c95382a5a41b856dae58cd823411557c894382a5a41d2fcf4e58cd8234193667294382a5a41fa6445e68cd8234138932794382a5a411bad1fe88cd82341c6552c93382a5a414faef8e78cd82341a314f892382a5a417066fde68cd823417ca2d892382a5a4151e862e58cd82341a0eeca92382a5a41c9465ee38cd823415ce8cb92382a5a41ac9424e18cd82341007fd892382a5a41cfe4eade8cd82341daa1ed92382a5a41094ae6dc8cd823413a400893382a5a412fd74bdb8cd823416d492593382a5a41bc5a48da8cd82341e9b54693382a5a4113e3d2d98cd8234132427093382a5a413d90cfd98cd82341e66ea193382a5a41468222da8cd82341a0bcd993382a5a41fc350adc8cd823411872a894382a5a41e47b9fdc8cd823410d4af894382a5a41cfb8f3dc8cd8234104134e95382a5a41b2aaf9dc8cd823416801a995382a5a418a43bddc8cd82341e1420696382a5a4152754adc8cd8234118056396382a5a410732addb8cd82341b675bc96382a5a41a66bf1da8cd8234163c20f97382a5a412a1423da8cd82341c7185a97382a5a4146e8c1d88cd82341e70ac997382a5a415171b2d88cd82341fad3eb97382a5a418c8502d98cd823419faa0298382a5a41d1f194d98cd82341ad370f98382a5a41f7824cda8cd82341fc231398382a5a41d9050cdb8cd8234166181098382a5a414e47b6db8cd82341c2bd0798382a5a41fac4b8dc8cd823418dfaed97382a5a416efca6dd8cd8234186f9df97382a5a41e4c8ecde8cd8234179cdd297382a5a41b1387ee08cd82341098ac797382a5a412d5a4fe28cd82341d842bf97382a5a41ac3b54e48cd823418a0bbb97382a5a4186eb80e68cd82341c2f7bb97382a5a41f6d1adea8cd823416e78c597382a5a41286bd0eb8cd823418c10ba97382a5a41e61359ec8cd823412209a597382a5a416f9c6fec8cd82341d9878a97382a5a4103d53bec8cd8234158b26e97382a5a417ac170eb8cd8234107b13c97382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (45,'os','phalange','droit','membre supérieur','adulte',X'00016a080000fa4bd1a78cd823416a9b1f94382a5a41356083c08cd82341a5392099382a5a417c060000000100000069030000000100000030000000003c68be8cd823410cda1998382a5a41f79fe5ba8cd823410092b697382a5a41dc2063b88cd8234133f34497382a5a41c79bb7b68cd82341d28bca96382a5a41d1edb9b58cd823410dea4c96382a5a4112f440b58cd82341119cd195382a5a41a38b23b58cd823410b305e95382a5a4116e356b58cd823419b36a594382a5a410ac746b58cd8234141a56894382a5a4135a2f5b48cd823411f3c4094382a5a41fd0d72b48cd823416fe92894382a5a41c8a3cab38cd823416a9b1f94382a5a41fefc0db38cd8234148402194382a5a4104b34ab28cd8234142c62a94382a5a41bc8a3ab08cd8234155b55694382a5a4165b55aaf8cd8234109816094382a5a41ff05d2aa8cd8234135e88194382a5a418499a2a98cd8234129b29094382a5a41ef1b83a88cd823419b36a594382a5a419bf4d2a78cd823410543c194382a5a41fa4bd1a78cd82341ad33e594382a5a41925058a88cd8234167481095382a5a417bc9d6ac8cd82341af00f595382a5a41eee9d1ad8cd8234143873896382a5a414b3395ae8cd82341895c7f96382a5a41ad0232af8cd823413117c996382a5a4197b5a1af8cd8234198a31497382a5a4189a9ddaf8cd823411aee6097382a5a41033cdfaf8cd8234114e3ac97382a5a4188ca9faf8cd82341e36ef797382a5a4198b218af8cd82341e27d3f98382a5a414ffe93ad8cd823419407be98382a5a4169056ead8cd82341eeb9e898382a5a41a2e3b0ad8cd8234134fc0599382a5a419d153cae8cd823411cb71799382a5a41f917efae8cd823415ad31f99382a5a415867a9af8cd82341a5392099382a5a415a804ab08cd82341b2d21a99382a5a4124e422b18cd823417bb40599382a5a41b121f2b18cd8234131e3f798382a5a41cbbb90b48cd823418becd898382a5a41bb9558b88cd823416df2b998382a5a41221d1bbf8cd82341e55e9298382a5a4184202ec08cd8234140557f98382a5a41356083c08cd82341064f6998382a5a41f89a50c08cd823412f745298382a5a41918fcbbf8cd82341b3ec3c98382a5a41003c68be8cd823410cda1998382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (46,'os','phalange','droit','membre supérieur','adulte',X'00016a0800002f3874a18cd82341f3df4890382a5a4115d4b7b18cd82341d58b1393382a5a417c060000000100000069030000000100000028000000839845ac8cd82341f1136291382a5a41c55203ac8cd8234160d2f290382a5a41c3be9bab8cd82341d3a17f90382a5a4112e356ab8cd8234169706190382a5a414199ddaa8cd8234176d94f90382a5a41b48c30aa8cd82341f3df4890382a5a41d06850a98cd82341d8864a90382a5a41f8d83da88cd823411cd15290382a5a41a753dea38cd82341d3a17f90382a5a41f1c97aa28cd823410a649190382a5a418d25b7a18cd82341b537a690382a5a412f3874a18cd823418533bd90382a5a418bd392a18cd823412e6ed590382a5a4153c9f3a18cd8234160feed90382a5a413dfa6ca38cd8234129933091382a5a410b5222a48cd823416d5c6f91382a5a41b5aa7aa48cd8234187049e91382a5a41513a02a58cd82341dd960c92382a5a418ed922a58cd8234160324792382a5a41309efba48cd82341f389e092382a5a41060876a58cd823417a33fd92382a5a418b9f56a68cd823418b980d93382a5a41207b8ba78cd82341d58b1393382a5a4126b102a98cd8234103e01093382a5a41108670ac8cd82341c6f5f892382a5a41b55143ae8cd82341b55ce792382a5a41eb3ed3af8cd8234198bdd292382a5a411574e4b08cd823410338bb92382a5a41a83882b18cd82341c189a292382a5a4115d4b7b18cd823419d708a92382a5a41d18d90b18cd8234162aa7492382a5a414ead17b18cd82341dbf46292382a5a41ff7958b08cd82341d40d5792382a5a41583b5eaf8cd8234116b35292382a5a4110df68ae8cd823413f5c4892382a5a41e4e5abad8cd82341381a2d92382a5a41fa0320ad8cd82341bb900692382a5a4179edbdac8cd823418363da91382a5a4187567eac8cd823414b36ae91382a5a41839845ac8cd82341f1136291382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (47,'os','phalange','droit','membre supérieur','adulte',X'00016a080000189f389d8cd823417cb9ad8d382a5a41ef1b83a88cd823410c4e3b8f382a5a417c0600000001000000690300000001000000260000008152749d8cd82341dd4af38e382a5a41189f389d8cd823414bb2098f382a5a4156b83b9d8cd8234142b2168f382a5a41a646699d8cd8234139b2238f382a5a4128ddd39d8cd8234157092f8f382a5a41fe0e8e9e8cd82341c40e378f382a5a41476faa9f8cd82341a7193a8f382a5a41c76d8aa28cd823410c4e3b8f382a5a41940d05a48cd8234150b4398f382a5a4168736aa58cd82341c1df338f382a5a418263a5a68cd8234139be278f382a5a4122a2a0a78cd82341913d138f382a5a4186f346a88cd82341a34bf48e382a5a41ef1b83a88cd8234147d6c88e382a5a41bca359a88cd823410e84a28e382a5a418dd4eba78cd82341afc58f8e382a5a4180944fa78cd823416ea3898e382a5a41465ae3a58cd823415954878e382a5a41552c3fa58cd823410d387d8e382a5a410126c4a48cd82341f1d8638e382a5a41fcc065a48cd82341d278ff8d382a5a41e87829a48cd823411cc9d98d382a5a41f8fdd3a38cd82341db08c18d382a5a41fdf865a38cd82341bf10b38d382a5a41c612e0a28cd823417cb9ad8d382a5a4122f442a28cd82341c3dbae8d382a5a4172deee9f8cd82341c750c38d382a5a41d6921e9f8cd823416e6ccb8d382a5a41c21e669e8cd82341f002d78d382a5a41f6d2d69d8cd8234194d4e88d382a5a413300829d8cd823419fa1038e382a5a413af7789d8cd82341572a2a8e382a5a41cc08cd9d8cd82341002f5f8e382a5a41d74ec49e8cd82341161cbd8e382a5a4132b7c29e8cd823417e78cf8e382a5a411156999e8cd823412a2fdd8e382a5a41c6c2569e8cd823412beae68e382a5a418152749d8cd82341dd4af38e382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (48,'os','phalange','droit','membre supérieur','adulte',X'00016a080000e32906da8cd823417bc2138e382a5a4183bc30eb8cd823414a7e4291382a5a417c0600000001000000690300000001000000300000001bad1fe88cd8234131db9490382a5a410c8edae68cd82341c1536890382a5a4120cad7e58cd823414cbb3890382a5a41716a0fe58cd8234110a50790382a5a41187879e48cd823414da4d68f382a5a412ffc0de48cd82341414ca78f382a5a41148c96e38cd8234145e3538f382a5a410dff73e38cd82341da1b138f382a5a417066a6e38cd82341d619c98e382a5a41d1db19e48cd82341c0ff5c8e382a5a41097524e48cd823414f202d8e382a5a41bdf5cee38cd82341fccd1f8e382a5a414ffe0be38cd82341bc75178e382a5a412516f8e18cd823417bc2138e382a5a41a8c4afe08cd82341265f148e382a5a414b03f4dd8cd82341f033218e382a5a413aa2b9dc8cd82341e8c12c8e382a5a416ff5bcdb8cd823417c4b3b8e382a5a4187f800db8cd82341ab744a8e382a5a41926777da8cd823416209598e382a5a41a8ea22da8cd823418b72688e382a5a41e32906da8cd823410e197a8e382a5a415bcd23da8cd82341d5658f8e382a5a41287d7eda8cd82341cac1a98e382a5a41292741dd8cd823416b4f3b8f382a5a41b680f3dd8cd82341f7f77e8f382a5a4162e829de8cd8234128bebd8f382a5a41c29701de8cd82341a81bf78f382a5a416fc897dd8cd823411f8a2a90382a5a41099474dc8cd8234192807d90382a5a413b7e63da8cd823415046f590382a5a41ff7622da8cd823410bb91091382a5a41bf4946da8cd8234195dd2691382a5a41a4c4f6da8cd82341d7363591382a5a41dbb55bdc8cd82341bb473991382a5a4197c9dae08cd823416cdd2591382a5a418ba047e28cd82341fddc2391382a5a41e47426e38cd82341afff2791382a5a41a02746e48cd82341c4653891382a5a41f40e0de58cd82341cf843f91382a5a418a0552e68cd823414a7e4291382a5a41dd0f58e88cd8234108c03e91382a5a41c75c3dea8cd8234164553191382a5a4104e81beb8cd823417f371b91382a5a4183bc30eb8cd82341fba1ff90382a5a4139e5b8ea8cd8234179d0e190382a5a41176df1e98cd823419cfec490382a5a411bad1fe88cd8234131db9490382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (49,'os','phalange','droit','membre supérieur','adulte',X'00016a080000e38c5cd88cd823419864418b382a5a41956acfe38cd82341e3650f8d382a5a417c06000000010000006903000000010000002400000015d4cfdd8cd82341b4dd038d382a5a4193977ce08cd8234176ebfe8c382a5a41ee1a4be28cd823418e84f18c382a5a417ee05be38cd82341b8d0dd8c382a5a41956acfe38cd82341aff7c58c382a5a418a3bc6e38cd823412f21ac8c382a5a41b1d560e38cd82341f474928c382a5a415fbbbfe28cd82341b91a7b8c382a5a419bb75de18cd8234130b6538c382a5a41a6c7e5e08cd8234123a9378c382a5a41555294e08cd82341d979168c382a5a41f30a62e08cd823411b8ff28b382a5a41bdba3ee08cd823413b99778b382a5a41fe0a14e08cd82341c11d668b382a5a41e6b69ddf8cd82341de4a578b382a5a412e57eade8cd823410fca4b8b382a5a418c8408de8cd82341ce44448b382a5a41bad706dd8cd823419864418b382a5a416fe9f3db8cd82341e8d2438b382a5a416252deda8cd823413a394c8b382a5a414dabd4d98cd8234108415b8b382a5a4105ec05d98cd8234174296e8b382a5a413d6a8dd88cd8234107a6818b382a5a41e38c5cd88cd823418fa1958b382a5a41e6ba64d88cd82341db06aa8b382a5a41375b97d88cd82341b9c0be8b382a5a41397fe3d98cd82341c0b6108c382a5a411e5620da8cd82341b6b12d8c382a5a412e12ebd98cd82341e9a84f8c382a5a41ceb2b9d88cd82341dd02b68c382a5a41dcdc7fd88cd823414ffddf8c382a5a41a8f5ddd88cd823415cf1fa8c382a5a418e89a7d98cd82341ecc6098d382a5a41ea24b0da8cd82341e3650f8d382a5a411654cbdb8cd8234127b60e8d382a5a4115d4cfdd8cd82341b4dd038d382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (50,'os','phalange','droit','membre supérieur','adulte',X'00016a080000f3324d088dd8234112041f8e382a5a411144cf178dd8234130e45e91382a5a417c060000000100000069030000000100000025000000721cc6138dd8234165f1f790382a5a410a1523138dd8234138299190382a5a418a6efd128dd82341b36a3590382a5a41def03d138dd82341e621e38f382a5a41f363cd138dd82341dfba988f382a5a41b58f94148dd82341aea1548f382a5a41433650178dd82341b0619e8e382a5a411144cf178dd82341ff7d6c8e382a5a41f5b4b7178dd8234145c8498e382a5a41b56427178dd82341ce83338e382a5a41192f3c168dd82341e9f3268e382a5a41e6ef13158dd82341e25b218e382a5a41878e57118dd8234112041f8e382a5a41939f6b108dd823419dfb258e382a5a4121b7c60f8dd82341e79f3d8e382a5a41b9e35a0f8dd823418f0a628e382a5a41e6331a0f8dd8234138558f8e382a5a412bfbaf0e8dd8234163404f8f382a5a41fb0a260e8dd823419f31a28f382a5a4101e6310d8dd82341b66cfe8f382a5a41da8ad30b8dd8234103ff5790382a5a418788fc0a8dd823410a0d8090382a5a41bc1131098dd823416fd9c090382a5a4110779f088dd82341b2d5da90382a5a41a12b54088dd823410800f190382a5a41f3324d088dd82341cb6d0391382a5a41879088088dd8234158341291382a5a41de4704098dd823410b691d91382a5a417d5cbe098dd8234140212591382a5a41b2caef0e8dd82341704e3a91382a5a415263e5108dd82341b35a4891382a5a41d333ab128dd8234199075b91382a5a4137e959138dd8234130e45e91382a5a416242c6138dd82341517a5791382a5a416585fd138dd82341051b4891382a5a4139e101148dd823414ac01e91382a5a41721cc6138dd8234165f1f790382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (51,'os','phalange','droit','membre supérieur','adulte',X'00016a080000c1bcd2108dd82341b4bd6b8b382a5a414e70551b8dd823411328e28c382a5a417c060000000100000069030000000100000023000000c8acc8118dd82341f76ad98c382a5a414a7b94138dd823410415d08c382a5a41e4cbf3158dd82341b8dbc98c382a5a41480b32178dd823410c7bca8c382a5a413f6658188dd823419340cf8c382a5a41f8850a1a8dd8234129fae18c382a5a41164a9a1a8dd823411328e28c382a5a41d198ff1a8dd823415e88db8c382a5a41b6183d1b8dd82341b9aecf8c382a5a414e70551b8dd82341cd2ec08c382a5a4125464b1b8dd82341489cae8c382a5a41c640211b8dd82341d68a9c8c382a5a4182b24a1a8dd823416bda668c382a5a4118b6051a8dd82341c1323a8c382a5a4100e22a1a8dd82341043e088c382a5a413b386f1a8dd82341e51aee8b382a5a4162f32b1b8dd82341292dba8b382a5a413c472c1b8dd823417d49a38b382a5a41c1efe81a8dd82341c88c8f8b382a5a416ada6f1a8dd82341be8b7f8b382a5a41aff4ce198dd8234114db738b382a5a41062c14198dd823417f0f6d8b382a5a41e96d4d188dd82341b4bd6b8b382a5a41cfa788178dd82341667a708b382a5a412759e4168dd82341f1117d8b382a5a41afd16b168dd82341588b918b382a5a41e97910168dd8234156d3ab8b382a5a41bfa51b158dd8234107c2088c382a5a41bf21a3148dd823419183258c382a5a41cc9ac7118dd823411fc4898c382a5a4189273b118dd823412d7ea38c382a5a41a2c7e3108dd82341593aba8c382a5a41c1bcd2108dd823419410cc8c382a5a41944819118dd82341ce18d78c382a5a41c8acc8118dd82341f76ad98c382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (52,'os','os coxal','droit','ceinture pelvienne','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (53,'os','patella','droit','membre inférieur','adulte',X'00016a0800003867be978dd823413570a18a382a5a419f611eb68dd823419015528e382a5a417c060000000100000069030000000100000027000000fd7203af8dd82341cf6e048e382a5a41161f34b28dd823413bcfae8d382a5a41df5d61b48dd82341bfe0648d382a5a41e062a6b58dd82341bd68228d382a5a419f611eb68dd82341942ce38c382a5a41a48de4b58dd82341a4f1a28c382a5a41761a14b58dd823414d7d5d8c382a5a419a241cb28dd82341effdb18b382a5a410e5933b08dd823413c81558b382a5a419cf328ae8dd823414fa20a8b382a5a41f2cc0bac8dd823415bc0d28a382a5a41b8bdeaa98dd82341973aaf8a382a5a419a9ed4a78dd823413570a18a382a5a414248d8a58dd823416ac0aa8a382a5a415b9304a48dd823416c8acc8a382a5a41905868a28dd823416d2d088b382a5a41c25bc4a08dd82341933b588b382a5a4137eb9b9f8dd8234183f9848b382a5a41ad441c9e8dd823412a93a78b382a5a41e6a5729b8dd823417334d98b382a5a417a89649a8dd823412f6ef38b382a5a410c6d9b998dd82341929e138c382a5a4152b30b998dd823410466378c382a5a4106bfa9988dd82341ee645c8c382a5a4119efd6978dd82341e7a2e28c382a5a413867be978dd823411127028d382a5a415d98dd978dd8234117a2298d382a5a41055858988dd823410d16578d382a5a41ae7b52998dd823410785888d382a5a41d6d8ef9a8dd823411af1bb8d382a5a41fb44549d8dd823415a5cef8d382a5a419a95a3a08dd82341dbc8208e382a5a413a692da48dd82341e121448e382a5a41463c2da78dd823419015528e382a5a41e75da8a98dd8234142c84f8e382a5a41411da4ab8dd823414d5e428e382a5a417ec925ad8dd8234109fc2e8e382a5a41c2b132ae8dd82341cec51a8e382a5a41fd7203af8dd82341cf6e048e382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (54,'os','tibia','droit','membre inférieur','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (55,'os','fibula','droit','membre inférieur','adulte',X'00016a0800006effc38a8dd82341011fd16d382a5a41a4fdc29c8dd82341388f6785382a5a417c060000000100000069030000000100000055000000d800ff8e8dd823417e182085382a5a4127609f8f8dd82341a5e14785382a5a41196e17908dd823411dd65985382a5a41bbdbad908dd82341f8046685382a5a41d0e760918dd82341388f6785382a5a411dd12e928dd82341de955985382a5a416f0d09958dd823418cdae684382a5a4187ec02978dd823419287ad84382a5a41c1bbe5988dd8234149e48984382a5a41f233c5998dd823418dc77f84382a5a418c45bc9b8dd8234114207584382a5a4123fd0f9c8dd8234136f06f84382a5a414d21409c8dd8234199db6684382a5a414248529c8dd82341a3315884382a5a4115ac0c9c8dd82341b5cdf983382a5a41c0b2c49b8dd823413a67cc83382a5a41e37e4e9b8dd82341ee7ea283382a5a41e6bf02998dd82341ac680a83382a5a41b7eaa9988dd823411b6de382382a5a41a545f1978dd8234159303681382a5a41107972978dd82341b797547f382a5a41763f65978dd823415c75387e382a5a41450293978dd823412ee7097d382a5a41e76e8f988dd823410841a47a382a5a413641c6988dd82341b3609479382a5a41cc09bf988dd8234135509e78382a5a41167385988dd823416c39bf77382a5a41802725988dd823413446f476382a5a4176d1a9978dd823416da03a76382a5a41baaf90968dd82341a8e4ef74382a5a412c6339968dd8234179cd5474382a5a418e7c3f968dd82341469dba73382a5a4116e28f968dd823410ad32373382a5a41f87917978dd82341bfed9272382a5a41a4d97f988dd82341e2cd8c71382a5a413fcddf998dd823417f35bc70382a5a411a90ec9b8dd82341c25ba76f382a5a411a30779c8dd82341a0534c6f382a5a41a4fdc29c8dd823410da3f66e382a5a41ba2ab59c8dd823416f1ea96e382a5a415de9329c8dd823412c9a666e382a5a41916b219b8dd82341abea316e382a5a410ffab9998dd82341bf170a6e382a5a41cbe74a988dd82341cb81ec6d382a5a415fe6d8968dd823415d6dd96d382a5a4167a768958dd82341011fd16d382a5a417ddcfe938dd8234145dbd36d382a5a413c37a0928dd82341b4e6e16d382a5a41416951918dd82341db85fb6d382a5a416164aa8d8dd82341bebe706e382a5a41e18e5a8d8dd82341fc94816e382a5a4125174a8d8dd823418987956e382a5a4152e2788d8dd82341d860b16e382a5a41eed5938e8dd8234190f1136f382a5a41fa9e4b8f8dd82341e323646f382a5a41dedada8f8dd82341f064ca6f382a5a412fc442908dd82341cc204470382a5a41819584908dd8234189c3ce70382a5a416989a1908dd8234139b96771382a5a417bda9a908dd82341f16d0c72382a5a414cc371908dd82341c24dba72382a5a41ca37fe8f8dd82341a2f4f673382a5a41a95220908dd82341f5143c74382a5a4188dcbc908dd823413a5a9b74382a5a415063f2908dd82341d5980475382a5a412f7be9908dd8234130fbc875382a5a4109b07f908dd82341200e1077382a5a416db3788f8dd82341b5363b79382a5a41bc90e18e8dd82341fa0fba7a382a5a41619b418e8dd823414c8ceb7c382a5a41b5b91c8e8dd823415bb0047e382a5a4161532d8e8dd823417b94fa7e382a5a4166f8858e8dd82341c695b27f382a5a41e223e18f8dd82341aea96a81382a5a412d5548908dd82341b6526b82382a5a41fb4e39908dd82341bb56d082382a5a41b45cf18f8dd82341dce61b83382a5a41b21c678f8dd823416c944883382a5a41b9e7b28c8dd823414f24ac83382a5a41d36dd08b8dd82341b25dd383382a5a414c90218b8dd82341c388fc83382a5a416effc38a8dd823417d002784382a5a41866bd58a8dd82341db1f5284382a5a41dd84738b8dd82341d8417d84382a5a41d800ff8e8dd823417e182085382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (56,'os','calcanéus','droit','membre inférieur','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (57,'os','talus','droit','membre inférieur','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (58,'os','cuboïde','droit','membre inférieur','adulte',X'00016a0800002a681f8d8dd82341ad88e35b382a5a417117bead8dd82341a48e385f382a5a417c06000000010000006903000000010000002c00000070efd3ab8dd82341b384105e382a5a412d108ca88dd823412bc0605d382a5a41a809fba58dd82341530ace5c382a5a41d5d2e9a48dd823411f458b5c382a5a410d6991a38dd82341462a2c5c382a5a410a1ee7a28dd82341a62c0d5c382a5a4193e52ca28dd823413641f75b382a5a413b6765a18dd82341e9a1e95b382a5a41964a93a08dd82341ad88e35b382a5a413737b99f8dd82341742fe45b382a5a41b1d4d99e8dd823412fd0ea5b382a5a41d217ee9c8dd8234158a4055c382a5a4175ef6c958dd823419b6c635c382a5a41512ac3928dd82341388f8d5c382a5a418ce729918dd82341f550b35c382a5a419c69b4908dd82341614fc55c382a5a4126e25d908dd823418612d95c382a5a41f499488f8dd8234101a8305d382a5a419a25f58d8dd8234156b38d5d382a5a414a487a8d8dd82341d9aebb5d382a5a41cebd328d8dd82341035ae65d382a5a412a681f8d8dd8234195ee0c5e382a5a416029418d8dd823414da62e5e382a5a4176e3988d8dd82341ebba4a5e382a5a416f78278e8dd823412f66605e382a5a414ecaed8e8dd82341d7e16e5e382a5a413733ce908dd82341e1c6815e382a5a4167790e928dd823417847945e382a5a4167a401968dd82341b384e95e382a5a4169d029988dd823410e40105f382a5a416d9f999a8dd82341ce5f295f382a5a4152ba3c9d8dd823417d54365f382a5a41f4c9fe9f8dd82341a48e385f382a5a413377cba28dd82341cc7e315f382a5a41eb6a8ea58dd823417f95225f382a5a41fb4d33a88dd8234146430d5f382a5a4141c9a5aa8dd82341aaf8f25e382a5a41e2f279ac8dd823418893d35e382a5a4115d571ad8dd8234119c1af5e382a5a417117bead8dd82341f7288a5e382a5a418f618fad8dd82341ba72655e382a5a41055b16ad8dd82341fc45445e382a5a416dab83ac8dd82341564a295e382a5a4170efd3ab8dd82341b384105e382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (59,'os','scaphoïde','droit','membre inférieur','adulte',X'00016a08000065e58db58dd8234131fb0f5d382a5a41c4a281e08dd823416905295f382a5a417c06000000010000006903000000010000003100000038e121bb8dd82341f967c05e382a5a41709686bc8dd823411930c65e382a5a418ddd1ebe8dd82341e43cc15e382a5a4161ca94c18dd82341f2ce9f5e382a5a4194c96dc38dd82341f9c1995e382a5a418b4a9bc58dd82341b055995e382a5a41e99afec78dd8234130ca9d5e382a5a41510879ca8dd82341925fa65e382a5a41cc7038cf8dd8234161edc05e382a5a41250740d18dd82341ff65d15e382a5a415002dbd28dd823417fe3e25e382a5a41918604d68dd823419c13135f382a5a41e63814d78dd82341d5901e5f382a5a4105596cd88dd82341f831265f382a5a4155cd37da8dd823416905295f382a5a413c7ca1dc8dd823418f19265f382a5a414258dede8dd8234152cf145f382a5a41a8a11de08dd823412588f05e382a5a41c4a281e08dd82341873ebe5e382a5a41eda52ce08dd82341f2ec825e382a5a417af540df8dd82341e48d435e382a5a41c2dbe0dd8dd82341d81b055e382a5a411ca32edc8dd823414c91cc5d382a5a41de954cda8dd82341bce89e5d382a5a415a6bccd68dd82341af535e5d382a5a41f13621d58dd8234134a1465d382a5a41358458d38dd823410cf2335d382a5a41fbc351d18dd82341b0bc255d382a5a411867ecce8dd823419a771b5d382a5a4162de07cc8dd823414299145d382a5a4110911bc58dd8234131fb0f5d382a5a41f6e681c28dd82341fdaa135d382a5a41d5a887c08dd823415cb01b5d382a5a4126e3fdbe8dd823412614285d382a5a4162a2b5bd8dd8234130df385d382a5a4102f37fbc8dd82341521a4e5d382a5a414389dcb68dd823419612b75d382a5a4175681fb68dd8234168d8c75d382a5a41e541b5b58dd823418426d75d382a5a4165e58db58dd82341d2c3e75d382a5a41c62299b58dd823413977fc5d382a5a4172aa06b68dd82341ef3b3d5e382a5a41232696b68dd823414c5e7a5e382a5a41413753b78dd823411947a35e382a5a4189eb29b88dd82341ffaebb5e382a5a41b95006b98dd82341a64ec75e382a5a418c74d4b98dd82341b7dec95e382a5a41bf6480ba8dd82341da17c75e382a5a4138e121bb8dd82341f967c05e382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (60,'os','cunéiforme médial','droit','membre inférieur','adulte',X'00016a0800000389e6a48dd8234185bf445a382a5a4131e1bcb68dd8234115b9435d382a5a417c060000000100000069030000000100000020000000a99950b28dd823416946085d382a5a4123cdcab38dd823412f61f25c382a5a41a619a3b48dd82341d22be05c382a5a41a2da77b58dd8234163c5c75c382a5a41c4dd2bb68dd82341bcbca85c382a5a41baf0a1b68dd82341b6a0825c382a5a4131e1bcb68dd823412800555c382a5a41ffab9bb68dd82341f20ade5b382a5a4131e1bcb68dd823414f921d5b382a5a41e9688db68dd823410fc9045b382a5a41014107b68dd823417246e15a382a5a41e5ca36b58dd82341d43cb85a382a5a41006828b48dd8234192de8e5a382a5a41bb79e8b28dd82341075e6a5a382a5a41816183b18dd823418eed4f5a382a5a41bd8005b08dd8234185bf445a382a5a41da387bae8dd8234147064e5a382a5a419d4fd0ab8dd823416d26735a382a5a411cf0b9a98dd8234132c2945a382a5a41d109cea78dd823419874bd5a382a5a41358ca2a58dd82341a1d8f75a382a5a410389e6a48dd823416b12215b382a5a41ca4503a58dd82341e394545b382a5a41b2a3cba58dd823416a46905b382a5a41e28312a78dd823415d0dd25b382a5a419afd1aac8dd823417ce2a65c382a5a4180bbd0ae8dd8234115ae205d382a5a412fabd3af8dd82341eb0a3c5d382a5a416b0ca5b08dd8234115b9435d382a5a412a6a48b18dd823414f5c3d5d382a5a41654fc1b18dd8234153982e5d382a5a41a99950b28dd823416946085d382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (61,'os','cunéiforme intermédiaire','droit','membre inférieur','adulte',X'00016a080000701bfbc08dd823416c2bc85a382a5a419be927cb8dd823414224665c382a5a417c0600000001000000690300000001000000170000005e24a9c48dd82341a249605c382a5a4114074cc78dd82341a2445a5c382a5a41c2fef0c88dd823419574465c382a5a41646dd2c98dd82341fc36275c382a5a41f6b42aca8dd8234158e9fe5b382a5a41dd5629ca8dd82341f5939c5b382a5a41297544ca8dd823413847675b382a5a419be927cb8dd8234186ab065b382a5a415d2df5ca8dd82341ea7be95a382a5a41504645ca8dd82341dee7d75a382a5a4128bb35c98dd823419e05cf5a382a5a419a12e4c78dd823416aebcb5a382a5a41a7ab89c38dd823416c2bc85a382a5a41520170c28dd82341d20ccc5a382a5a4159e0b8c18dd82341ced4e05a382a5a4190804fc18dd82341a12b035b382a5a41c8191fc18dd823418ab92f5b382a5a41701bfbc08dd82341f7e42e5c382a5a41ffcd54c18dd82341caec4a5c382a5a415df8e9c18dd8234161d15b5c382a5a410ee69fc28dd82341960f645c382a5a4197e25bc38dd823414224665c382a5a415e24a9c48dd82341a249605c382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (62,'os','cunéiforme latéral','droit','membre inférieur','adulte',X'00016a0800001e6ab5cf8dd82341d55f385a382a5a418a4b6dde8dd82341b3eeb35c382a5a417c06000000010000006903000000010000001d000000471e7dd48dd82341f235a95c382a5a41492f52d88dd823410d2fb05c382a5a41ea9690d98dd823413ca8ac5c382a5a41b6b270da8dd823418d8ca35c382a5a413fda01db8dd82341092e945c382a5a41166553db8dd82341b7de7d5c382a5a41cdaa74db8dd82341a0f05f5c382a5a4176dd8edb8dd82341a52c0c5c382a5a413714e5db8dd82341720ada5b382a5a41d79803de8dd82341c8fe0a5b382a5a41312857de8dd823410679df5a382a5a418a4b6dde8dd823414831bb5a382a5a414e0323de8dd82341ae389e5a382a5a41cc1f6ddd8dd82341fea6865a382a5a41ce0c5bdc8dd823414296735a382a5a412036fcda8dd823417f20645a382a5a418c0760d98dd82341be5f575a382a5a4151a2b5d38dd82341d55f385a382a5a41aa4b0cd28dd823417b9e3d5a382a5a41250cf1d08dd82341d03c5e5a382a5a41a72b47d08dd82341809e945a382a5a4110f2f1cf8dd823413a27db5a382a5a4144a7d4cf8dd82341ac3a2c5b382a5a411e6ab5cf8dd823413ae3645c382a5a41c1fc2bd08dd82341f5488e5c382a5a41868deed08dd8234130aca65c382a5a4189c3dad18dd82341ceedb15c382a5a41e845ced28dd82341b3eeb35c382a5a41471e7dd48dd82341f235a95c382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (63,'os','métatarsien','droit','membre inférieur','adulte',X'00016a0800007c9693688dd823419b153056382a5a41c87bba838dd82341d1b03d5f382a5a417c06000000010000006903000000010000002f00000011cc80818dd823419a19265d382a5a41513e08838dd823418b06c25c382a5a41c87bba838dd823412f06685c382a5a413e06ba838dd82341bce2145c382a5a417f5f29838dd823416b66c55b382a5a4153092b828dd82341745b765b382a5a41ddceeb788dd82341a6002b59382a5a4117fa4a778dd823417d17bc58382a5a41bb61ed758dd82341534c4c58382a5a41bc4bf7748dd823417b49dc57382a5a410bfe8c748dd8234149b96c57382a5a4139b310758dd82341642ca256382a5a41fb2a9a748dd823411f5d6556382a5a414e3ba4738dd823413ffc4156382a5a419bf963728dd82341bf2d3256382a5a414d7b0e718dd823419b153056382a5a41cfd5d86f8dd82341d0d73556382a5a41a17f806c8dd8234188435156382a5a418227136b8dd823419a7d6356382a5a4135e3c3698dd82341edff7f56382a5a41d4b2d7688dd82341be55a956382a5a417c9693688dd823414a0ae256382a5a41478e3c698dd82341cea82c57382a5a41d4093f6e8dd8234197e13158382a5a41d2d077708dd82341d7cbeb58382a5a41be4fea718dd82341a7a1b059382a5a410ce7be728dd823416689775a382a5a4131f71d738dd8234176a9375b382a5a41a3e02f738dd823413828e85b382a5a418107de728dd823417cbc045e382a5a419ad10d738dd82341ac75505e382a5a41888692738dd82341c8c6935e382a5a4196fd8b748dd82341efe9cd5e382a5a410e0e1a768dd823413d19fe5e382a5a413d8f5c788dd82341d08e235f382a5a41d2259f7a8dd823416da3395f382a5a41a5412d7c8dd82341d1b03d5f382a5a4137bc267d8dd823418109325f382a5a410c6fab7d8dd823410400195f382a5a41a833db7d8dd82341e0e6f45e382a5a41426bab7d8dd82341be765d5e382a5a416b96d57d8dd8234121bc245e382a5a4162c2447e8dd823417e1ded5d382a5a41e3eee17e8dd823412298b85d382a5a41a91b967f8dd823415529895d382a5a416f484a808dd8234163ce605d382a5a4111cc80818dd823419a19265d382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (64,'os','métatarsien','droit','membre inférieur','adulte',X'00016a08000013fef77e8dd823418a785f53382a5a41777233988dd823412b7b305b382a5a417c0600000001000000690300000001000000330000007cbe6a958dd8234113f0c35a382a5a418a10f1968dd823415d4f9d5a382a5a41ebe0a3978dd82341053d875a382a5a41386e1b988dd8234126506a5a382a5a41777233988dd82341d8c5425a382a5a41aaa7c7978dd8234132db0c5a382a5a41d7c7b3968dd823414ccdc459382a5a41b88cca928dd823416554fa58382a5a4199ae42918dd823413a638a58382a5a41546a21908dd82341dae61858382a5a4197374c8f8dd8234160c0a757382a5a4165b58b8d8dd823416a1b6956382a5a41bf1e568c8dd82341ebcab455382a5a414cb33a8c8dd8234159ec6055382a5a41eda9708c8dd8234141241255382a5a414e79dd8c8dd82341001bca54382a5a411b98668d8dd82341f5788a54382a5a41ba73a28e8dd82341c0910e54382a5a4104778d8e8dd82341fc21f253382a5a41c52d178e8dd82341f0f5cb53382a5a41b85c418d8dd823417f21a353382a5a4199c80d8c8dd8234187b87e53382a5a4122367e8a8dd82341ebce6553382a5a41106a94888dd823418a785f53382a5a411e2952868dd8234144c97253382a5a410638b9838dd82341fad4a653382a5a41485066818dd82341231be453382a5a41ce10e57f8dd8234125031354382a5a4173961d7f8dd82341fc673a54382a5a4113fef77e8dd82341a3246154382a5a418a645c7f8dd8234119148e54382a5a4192b1d6828dd8234126a17e55382a5a4116da40858dd8234173783f56382a5a41a833ac868dd82341512bc456382a5a418c4fa6878dd823415ecb4157382a5a4105bfbc888dd82341396aed57382a5a41610936898dd8234142c55358382a5a41929d60898dd823417b64b358382a5a41ff421a898dd8234122fdb559382a5a41622c1c898dd82341f4ce065a382a5a418b7658898dd82341e3f5565a382a5a41778cea898dd8234183a8a75a382a5a410bf8bd8a8dd823412e24eb5a382a5a41ab66a88b8dd82341d8a3155b382a5a412e89a48c8dd82341825a2b5b382a5a416f10ad8d8dd823412b7b305b382a5a4146adbc8e8dd82341d238295b382a5a418d10ce8f8dd8234177c6195b382a5a4164098d938dd8234155d7d75a382a5a41ae91a4948dd82341c8d5c95a382a5a417cbe6a958dd8234113f0c35a382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (65,'os','métatarsien','droit','membre inférieur','adulte',X'00016a080000adfc399d8dd82341987bf951382a5a418c5bb2b18dd823410109e559382a5a417c0600000001000000690300000001000000380000005b789daf8dd82341947e2959382a5a413bbb19b08dd82341ff6a1a59382a5a4124e41cb18dd8234122560359382a5a4175a07eb18dd823419095f558382a5a418c5bb2b18dd82341b486e258382a5a418c80a5b18dd82341eb49c758382a5a419b7a45b18dd8234190ffa058382a5a41b0010daf8dd823411aa40258382a5a41fbb4eaad8dd823416f318b57382a5a41c19a0aad8dd823419c640a57382a5a41077f5eac8dd8234141328456382a5a41cf2dd8ab8dd82341fe8efc55382a5a412b0448aa8dd8234144942254382a5a410f3b32aa8dd823412b65d553382a5a41a20c55aa8dd8234166059953382a5a417befacaa8dd823419e796953382a5a41315a36ab8dd823417dc64253382a5a415dc3edab8dd82341a9f02053382a5a41736bd8ad8dd8234190efdb52382a5a419cd1aaae8dd823410fc9b452382a5a41c452f2ae8dd82341b0138e52382a5a4136abb8ae8dd8234175236952382a5a413f9707ae8dd82341604c4752382a5a412bd3e8ac8dd8234172e22952382a5a41461b66ab8dd82341ab391252382a5a41dd2b89a98dd823410da60152382a5a413ac15ba78dd82341987bf951382a5a410cd30da58dd82341cea3fe51382a5a418c50dba28dd823410cd61252382a5a41cda6dfa08dd8234161883252382a5a41df42369f8dd82341db305a52382a5a41d491fa9d8dd8234185458652382a5a41bd00489d8dd823416f3cb352382a5a41adfc399d8dd82341a48bdd52382a5a41b4f2eb9d8dd8234132a90153382a5a41c61be59e8dd8234120b71f53382a5a41bf8226a08dd82341e3c45053382a5a41a501d3a08dd823413f0d7d53382a5a419466c1a18dd82341e50be353382a5a4151a491a28dd8234171567654382a5a4177123fa38dd82341a53c3055382a5a41393db9a38dd823417d5b0156382a5a41c7b0efa38dd82341f54fda56382a5a4156f9d1a38dd8234108b7ab57382a5a4117a34fa38dd82341b22d6658382a5a41485d9ea18dd82341ce296359382a5a418071bba18dd82341ba9ea959382a5a415e8179a28dd82341c41ad359382a5a415897a2a38dd823410109e559382a5a41e6bd00a58dd8234183d4e459382a5a4181ff5da68dd823415de8d759382a5a41a06684a78dd82341a3afc359382a5a41f7d7e5a88dd823418da69759382a5a4150fb17ab8dd82341f9e76a59382a5a41a0ed97ad8dd82341ad5b4459382a5a415b789daf8dd82341947e2959382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (66,'os','métatarsien','droit','membre inférieur','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (67,'os','métatarsien','droit','membre inférieur','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (68,'os','sésamoïde','droit','membre inférieur','adulte',X'00016a080000b25ff2d08dd8234140f85a54382a5a41486fedd68dd823417d28ac55382a5a417c06000000010000006903000000010000001b00000003926cd18dd823411d6c1455382a5a41a55a0cd18dd8234111f34d55382a5a41b25ff2d08dd82341106f7855382a5a411d7718d18dd8234104549555382a5a41d87678d18dd82341da15a655382a5a41d7340cd28dd823417d28ac55382a5a410e87cdd28dd82341d7ffa855382a5a416e43b6d38dd82341d50f9e55382a5a41ec3fc0d48dd8234160cc8c55382a5a41fd4db1d58dd8234101497755382a5a41ffd958d68dd823414ce05e55382a5a41cf64bfd68dd82341b9f24355382a5a41486fedd68dd82341c2e02655382a5a41487aebd68dd82341df0a0855382a5a41aa06c2d68dd8234187d1e754382a5a4106a71ad68dd823415cb6a454382a5a4169519ed58dd82341a2058754382a5a41af2f01d58dd82341f6907154382a5a4169a750d48dd82341d7946354382a5a41261e9ad38dd82341c54d5c54382a5a4178f9ead28dd8234140f85a54382a5a41ed9e50d28dd82341c6d05e54382a5a411874d8d18dd82341d9136754382a5a4186de8fd18dd82341f7fd7254382a5a41616a6cd18dd8234187418454382a5a4193c150d18dd823417fe0b554382a5a4103926cd18dd823411d6c1455382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (69,'os','sésamoïde','droit','membre inférieur','adulte',X'00016a080000091901eb8dd823412fcec754382a5a416306fcf08dd823415bfa1756382a5a417c060000000100000069030000000100000013000000afd847ef8dd823419a170c56382a5a419c76f7f08dd82341a8081c55382a5a416306fcf08dd823412518f854382a5a41e94287f08dd8234143b2de54382a5a415a3abcef8dd82341f5e8ce54382a5a41e3fabdee8dd823412fcec754382a5a41b292afed8dd82341e473c854382a5a41f40fb4ec8dd8234106eccf54382a5a41d580eeeb8dd823418948dd54382a5a4184f381eb8dd823415f9bef54382a5a41321c2eeb8dd823413f0c1e55382a5a41091901eb8dd82341b7225655382a5a4104d307eb8dd8234111b7db55382a5a41585142eb8dd82341c769f955382a5a410115c3eb8dd823418cdb0b56382a5a41f50d72ec8dd82341e64b1556382a5a41292c37ed8dd823415bfa1756382a5a41945ffaed8dd823416e261656382a5a41afd847ef8dd823419a170c56382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (70,'os','phalange','droit','membre inférieur','adulte',X'00016a080000fa1521dd8dd8234172292d4f382a5a4153dc21f58dd82341c593fd51382a5a417c06000000010000006903000000010000002c000000018640f38dd82341c593fd51382a5a41915c2ff48dd8234176a3f251382a5a41513494f48dd82341595be851382a5a414796cef48dd8234117a6d951382a5a411baabef48dd8234166d9c551382a5a41769744f48dd82341ff4aac51382a5a415a6c0df28dd8234131a06751382a5a41bb6e1ef18dd82341ec454051382a5a4148fa77f08dd8234141421651382a5a41277c1ef08dd82341ac95e950382a5a417e6116f08dd82341a540ba50382a5a41711764f08dd82341a7438850382a5a41270b0cf18dd823412c9f5350382a5a41984b24f48dd823413950b14f382a5a41dffccdf48dd82341f16c834f382a5a4153dc21f58dd823411b465d4f382a5a41661c0ff58dd82341d6d9404f382a5a418bef84f48dd823413e26304f382a5a41348872f38dd8234172292d4f382a5a41d418c7f18dd823418fe1394f382a5a417654c1ee8dd82341ea0d5b4f382a5a41ee29aced8dd82341e92b644f382a5a4129159eec8dd82341a1de674f382a5a41a68a65eb8dd82341b8d1654f382a5a41e3fed0e98dd82341cfb05d4f382a5a4198b5cde48dd823418fe1394f382a5a415f5c2ce28dd8234183b7334f382a5a416431bce08dd8234134a04d4f382a5a41175437e08dd8234199dd7f4f382a5a41e9e357e08dd82341acb1c24f382a5a41855cdfe18dd82341a549a150382a5a413ddbdae18dd823411e0cd950382a5a41a73333e18dd82341b84a0851382a5a41b76f19e08dd82341e3fb3751382a5a41dd6ac3dd8dd82341e6528c51382a5a41fa1521dd8dd823413ec7aa51382a5a41d17c40dd8dd82341254bbd51382a5a4163956ede8dd82341d9c5c051382a5a41d8a04be48dd823417263a251382a5a4176ff8ee78dd82341cf07a251382a5a41f45da4ea8dd8234132f4ac51382a5a41b5a86ded8dd823411811bf51382a5a411accccef8dd823410247d451382a5a41018640f38dd82341c593fd51382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (71,'os','phalange','droit','membre inférieur','adulte',X'00016a0800005dd6e3e88dd82341b7801a4b382a5a41bd8f9ffd8dd823418b96b34d382a5a417c06000000010000006903000000010000002e00000049c9feec8dd823413a74a94d382a5a41df3ce3ef8dd82341d1fe9c4d382a5a415f76eff38dd823418ab0944d382a5a41f18033f68dd823412b85954d382a5a41730274f88dd8234150e39b4d382a5a414ba531fc8dd823418b96b34d382a5a41057e2efd8dd82341a33ab04d382a5a41bd8f9ffd8dd823418ecfa14d382a5a41cf829efd8dd8234159c48a4d382a5a4198ff44fd8dd8234112886d4d382a5a4177aeacfc8dd82341c7894c4d382a5a41ea4326fb8dd823415a03094d382a5a4174d194f98dd823413f83cd4c382a5a418a10f1f88dd82341ff00b04c382a5a4196498af88dd823410515904c382a5a41e9bb7bf88dd8234121d16b4c382a5a41d1a6e0f88dd823412247414c382a5a41a049d4f98dd82341d6880e4c382a5a41a5e371fb8dd823410ea8d14b382a5a412167e0fc8dd82341c6e88f4b382a5a415461f2fc8dd8234177515e4b382a5a412ce5f3fb8dd823412a553b4b382a5a41980531fa8dd82341ea66254b382a5a4185d5f5f78dd82341c0f91a4b382a5a41e1678ef58dd82341b7801a4b382a5a4199cf46f38dd82341d86e224b382a5a419c1f6bf18dd823412e37314b382a5a41ee00abee8dd82341f07b554b382a5a41682ba1ed8dd823410e47694b382a5a416c85e2ec8dd82341da0f7f4b382a5a41b7557cec8dd823413980974b382a5a410ae37bec8dd823411142b34b382a5a412274eeec8dd8234145ffd24b382a5a4195b5e0ee8dd8234147d0184c382a5a41276772ef8dd823412a2e324c382a5a41dbed99ef8dd8234123cb474c382a5a411ad35aef8dd82341f2f65d4c382a5a414ca0b8ee8dd823415601794c382a5a412a1859ec8dd82341d9f0ce4c382a5a41a8d5a2ea8dd823417875124d382a5a415e5b4ce98dd82341a789544d382a5a415dd6e3e88dd82341229d814d382a5a41d4012ee98dd82341ed719d4d382a5a41ee98efe98dd823410ecaab4d382a5a41da56edea8dd823418767b04d382a5a4149c9feec8dd823413a74a94d382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (72,'os','phalange','droit','membre inférieur','adulte',X'00016a080000cadcf3bf8dd823416f7da64c382a5a41e665d5d38dd82341c976ae4f382a5a417c06000000010000006903000000010000002d00000075a1efce8dd8234179fb264f382a5a411f6818ce8dd823414483f14e382a5a417a8e92cd8dd8234137cdc04e382a5a417b9e61cd8dd823419586924e382a5a41182289cd8dd82341a35c644e382a5a4146a30cce8dd82341a3fc334e382a5a41fbabefce8dd82341d913ff4d382a5a41f9114ad38dd8234168233c4d382a5a41e665d5d38dd8234154d7084d382a5a4170f6a6d38dd823419697e24c382a5a416f42e1d28dd823410e83c74c382a5a41bac8a6d18dd823419ab8b54c382a5a4129081ad08dd823411b57ab4c382a5a41947f5dce8dd823416f7da64c382a5a4186acd1ca8dd823414394a74c382a5a41ad6021c98dd82341d7bcae4c382a5a412f7a94c78dd82341f534bb4c382a5a41f3a83cc68dd82341626dcd4c382a5a41e19c2bc58dd82341e0d6e54c382a5a41e00573c48dd8234134e2044d382a5a41d99324c48dd8234121002b4d382a5a41b2f651c48dd823416ba1584d382a5a41cca1b3c48dd82341c4b0884d382a5a41c320f0c48dd82341a5fbb64d382a5a41079bfec48dd823410147e54d382a5a410a38d6c48dd82341c757154e382a5a413c1f6ec48dd82341eaf2484e382a5a410e78bdc38dd823415bdd814e382a5a41f269bbc28dd823410adcc14e382a5a41c66b46c08dd82341f02c4b4f382a5a41cadcf3bf8dd823411dfa734f382a5a4108e735c08dd82341e9c0894f382a5a412502dbc08dd82341ce26914f382a5a41c8a5b1c18dd8234144d18e4f382a5a41bf8afdc48dd8234139fa6b4f382a5a412bbf29c68dd8234198ad664f382a5a4108cfa3c78dd823413ecd654f382a5a41ef3068c98dd8234145006c4f382a5a41775b73cb8dd82341c6ed7b4f382a5a41cd8cabcf8dd82341c976ae4f382a5a41af8dadd08dd82341ef59ae4f382a5a413517fbd08dd8234119df9d4f382a5a41b878c7d08dd8234118ff824f382a5a418e0146d08dd82341b8b2634f382a5a4175a1efce8dd8234179fb264f382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (73,'os','phalange','droit','membre inférieur','adulte',X'00016a0800009482d2c68dd82341103e6d4a382a5a41ad0e79d38dd823411007ba4b382a5a417c060000000100000069030000000100000022000000e75029d28dd823411007ba4b382a5a416b8d04d38dd823412352ac4b382a5a4184af6dd38dd82341de7f9f4b382a5a41ad0e79d38dd823410a90934b382a5a415d023bd38dd823416e82884b382a5a410be2c7d28dd82341d4567e4b382a5a41c273fbd08dd82341e21d654b382a5a41953c8fd08dd82341b4125d4b382a5a410a675dd08dd8234124d2524b382a5a414e9059d08dd82341d3ea454b382a5a41c0701ed18dd823419eeeee4a382a5a418bc946d18dd82341fa20ce4a382a5a4115ea2dd18dd823419698ae4a382a5a419724b8d08dd82341e33f964a382a5a411dd2f9cf8dd82341e450844a382a5a41b14b07cf8dd823419b05784a382a5a415ceaf4cd8dd823410898704a382a5a4122fbc1cb8dd82341103e6d4a382a5a41521fcaca8dd82341aec56f4a382a5a41a4720fca8dd82341ff7c794a382a5a416cc599c98dd8234168b58d4a382a5a41cc2b59c98dd8234102aba94a382a5a41001c2bc98dd8234100972f4b382a5a41691205c98dd82341d5c3484b382a5a414bdcb3c88dd82341b1555a4b382a5a41982440c88dd82341ccd2654b382a5a414f1af3c68dd82341a698764b382a5a419482d2c68dd82341cc8d7c4b382a5a4169fcfdc68dd82341b9d3854b382a5a413ca58bc78dd82341884b944b382a5a41f21f98c88dd82341ba76a34b382a5a41b13113ca8dd82341df18ae4b382a5a4114a0a0cd8dd823411cdbb84b382a5a41e75029d28dd823411007ba4b382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (74,'os','phalange','droit','membre inférieur','adulte',X'00016a0800003425a9c98dd823412e763e49382a5a41acca47d38dd823411631f349382a5a417c060000000100000069030000000100000017000000baef74d28dd823414b67cf49382a5a41a2b8f9d28dd82341ac3fc149382a5a411f2c3cd38dd823410f36b349382a5a41acca47d38dd823418c66a549382a5a41e48ae8d28dd823413de68a49382a5a4137faddd18dd8234108986749382a5a4113f2ead08dd82341620b5249382a5a41bfd494cf8dd823412ed14149382a5a414abddace8dd823412e763e49382a5a41526c22ce8dd823416bc03f49382a5a411cbb74cd8dd82341c4ca4649382a5a41537738cc8dd823412a346549382a5a4168b029ca8dd82341dbac8f49382a5a41730dc2c98dd823412d6b9e49382a5a413425a9c98dd8234183edae49382a5a41499ef8c98dd823410816c249382a5a41521fcaca8dd82341ecc6d849382a5a413930f7cb8dd823410259eb49382a5a4162443bcd8dd823411631f349382a5a419de482ce8dd8234126daf249382a5a41be99bacf8dd8234133dfec49382a5a4199ecced08dd823413ecbe349382a5a41baef74d28dd823414b67cf49382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (75,'os','phalange','droit','membre inférieur','adulte',X'00016a080000f801549f8dd82341f3aaf449382a5a41bc1931aa8dd823414dc3bc4a382a5a417c06000000010000006903000000010000001a0000007325a0a88dd823419af09f4a382a5a4172b55ca98dd82341d18f8e4a382a5a41c381d9a98dd8234109ee7c4a382a5a41fedc1daa8dd82341564e6b4a382a5a41bc1931aa8dd82341cbf3594a382a5a41968a1aaa8dd823417921494a382a5a412382e1a98dd82341741a394a382a5a41bb4f25a98dd823419d7a1c4a382a5a41d46efba78dd823411195054a382a5a4199d437a78dd823412f15fd49382a5a41550573a58dd82341f3aaf449382a5a419b807ea48dd82341b1d3f549382a5a41055e86a38dd82341be47fb49382a5a41029ea7a18dd823419d04124a382a5a41a47e10a08dd82341d0d72c4a382a5a41f97a8c9f8dd8234150643c4a382a5a41f801549f8dd8234143264e4a382a5a419ef57b9f8dd823414ab4624a382a5a41e83719a08dd8234108a57a4a382a5a41d3aa40a18dd823411f8f964a382a5a41c14daea28dd8234198fbad4a382a5a4129ad09a48dd82341e0d9b94a382a5a416e6349a58dd823414dc3bc4a382a5a41f50a64a68dd823413751b94a382a5a41223e50a78dd82341f51cb24a382a5a417325a0a88dd823419af09f4a382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (76,'os','phalange','droit','membre inférieur','adulte',X'00016a08000028e747a08dd823416968f34b382a5a41cd0f0aab8dd82341ef7c264d382a5a417c06000000010000006903000000010000002000000028e747a08dd8234110b0064d382a5a4181c7d4a28dd82341ef95184d382a5a41ee1319a68dd8234175fb254d382a5a419cc4bea78dd82341ef7c264d382a5a4161eb32a98dd82341fdea1f4d382a5a41959b4eaa8dd82341b20f104d382a5a4163ebe8aa8dd82341bbd6fc4c382a5a41cd0f0aab8dd82341c3d3ec4c382a5a41d587d4aa8dd82341f4cede4c382a5a41d5db84a98dd823411387b44c382a5a4186984da98dd823417e4ca24c382a5a41b4e7a4a98dd8234101c3714c382a5a41deefa5a98dd823415ce3554c382a5a413d1e70a98dd823417c3b3a4c382a5a41a85404a98dd82341e9ac204c382a5a41f27463a88dd823412e190b4c382a5a41f1608ea78dd82341d661fb4b382a5a4179fa85a68dd823416968f34b382a5a4161234ba58dd82341730ef54b382a5a410f3a10a48dd823419d68fd4b382a5a41ded906a38dd823416f32084c382a5a4199022fa28dd82341f632154c382a5a410eb488a18dd823413c31244c382a5a4108ee13a18dd823414cf4344c382a5a4153b0d0a08dd823413243474c382a5a41bcfabea08dd82341f9e45a4c382a5a41d77c31a18dd8234191c79d4c382a5a41d2543da18dd82341dcd1cc4c382a5a41274424a18dd82341bba2e14c382a5a41722ff4a08dd823416707f34c382a5a410352aba08dd82341dac8ff4c382a5a4128e747a08dd8234110b0064d382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (77,'os','phalange','droit','membre inférieur','adulte',X'00016a08000098e6f3768dd823413ccd824c382a5a410a94c27f8dd8234134d4274d382a5a417c0600000001000000690300000001000000180000006f897d7e8dd82341b20f104d382a5a413765167f8dd82341edb6014d382a5a4140907b7f8dd82341712af34c382a5a4188fab27f8dd823414ca1e44c382a5a410a94c27f8dd823418952d64c382a5a41c64cb07f8dd823413675c84c382a5a41b714827f8dd823415f40bb4c382a5a413192e97e8dd8234159aca34c382a5a41e921f87d8dd8234175c5904c382a5a41088b597d8dd8234142c1894c382a5a415c63ea7b8dd823413ccd824c382a5a413ff35a7a8dd82341383c884c382a5a413bc6d6788dd8234139fb9a4c382a5a4171ab8c778dd82341f31bb14c382a5a4178a721778dd8234181eebd4c382a5a4198e6f3768dd823415e93cc4c382a5a41715614778dd823412d87dd4c382a5a419ee493778dd823419146f14c382a5a41bf7e83788dd823412d4e084d382a5a4187d0ab798dd8234177a11b4d382a5a41715ec57a8dd82341896c254d382a5a411288c87b8dd8234134d4274d382a5a41d12c6d7d8dd823418b0c1f4d382a5a416f897d7e8dd82341b20f104d382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (78,'os','phalange','droit','membre inférieur','adulte',X'00016a080000f4fff5788dd823415094d54d382a5a4129dbae818dd8234152fbd24e382a5a417c06000000010000006903000000010000001e000000f4fff5788dd8234138aeb84e382a5a41664d077b8dd82341b077c74e382a5a41cb48ad7d8dd82341768cd24e382a5a411d21037f8dd8234152fbd24e382a5a4106cc30808dd82341a193cd4e382a5a4128ba16818dd823413a82c04e382a5a4145ec93818dd8234102a3b04e382a5a4129dbae818dd823414e6aa34e382a5a419a7f83818dd82341e5d6974e382a5a41cc6573808dd8234128f0744e382a5a41089846808dd82341aae5654e382a5a415c4f8d808dd823412bdb3d4e382a5a416c1c8e808dd82341bfdb264e382a5a41ec7762808dd823419b09104e382a5a41fa160b808dd8234144f2fa4d382a5a41b3ae887f8dd823414223e94d382a5a4136f4db7e8dd82341192adc4d382a5a419f9c057e8dd823415094d54d382a5a410e5d067d8dd823416defd64d382a5a414514077c8dd82341a4d7dd4d382a5a4187f12f7b8dd823410dc0e64d382a5a415222fa798dd8234138d9fd4d382a5a41ef779b798dd82341dcad0b4e382a5a41c0f764798dd8234176ca1a4e382a5a41cea256798dd82341f6002b4e382a5a41a36cb3798dd82341d13b624e382a5a4169fbbc798dd823411909894e382a5a41d2a6a8798dd82341fc319a4e382a5a41869846798dd823412a05b34e382a5a41f4fff5788dd8234138aeb84e382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (79,'os','phalange','droit','membre inférieur','adulte',X'00016a080000c11eac568dd823411c466350382a5a4179cfaa5d8dd82341e6ddf450382a5a417c0600000001000000690300000001000000160000003285145d8dd823419673c450382a5a4172ef9d5d8dd82341b26ea550382a5a4179cfaa5d8dd82341e0229850382a5a4171306e5d8dd8234157e08150382a5a4170cf2e5d8dd82341f5df7850382a5a419035875c8dd82341cf086b50382a5a41bf17a45b8dd823415dc66350382a5a41273a1a5b8dd823411c466350382a5a41f06eee598dd82341ca786950382a5a41cd4ac3588dd82341b2867a50382a5a41d97fbc578dd8234194bf9550382a5a4122d7e9568dd8234183c5b150382a5a417246b1568dd823414f55bf50382a5a41c11eac568dd82341a463cc50382a5a41f78ce8568dd82341fcc8d850382a5a41fcbd74578dd82341d55de450382a5a41bbde5e588dd82341a9faee50382a5a41de706d598dd82341e6ddf450382a5a414fb45c5a8dd82341a9abf350382a5a41c8302b5b8dd82341f354ed50382a5a41c1f35f5c8dd8234124fed850382a5a413285145d8dd823419673c450382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (80,'os','phalange','droit','membre inférieur','adulte',X'00016a0800002294b95b8dd823416eb4d551382a5a41e7ca4d638dd8234190a6b452382a5a417c06000000010000006903000000010000001c000000159bab5c8dd8234190a6b452382a5a4123d2655e8dd82341107daf52382a5a41daeb8b608dd82341d8a5a252382a5a41c19396618dd82341bc169852382a5a4103de75628dd823413a2f8a52382a5a41e1760d638dd82341c67e7852382a5a41e7ca4d638dd8234184f16752382a5a410c3a47638dd82341a79e5c52382a5a414c6e0d638dd8234129d65452382a5a419c4df1618dd823417eda4152382a5a41323aaf618dd82341175b3752382a5a413b0293618dd823412d5a1552382a5a419bd163618dd82341b2170352382a5a419a7312618dd82341c063f251382a5a41d6afa2608dd82341ac73e451382a5a41f24d18608dd82341ca7cda51382a5a418e15775f8dd823416eb4d551382a5a414bcec25e8dd82341ec4fd751382a5a41ca3fff5d8dd823419884e051382a5a41fa41b25c8dd823419b0efc51382a5a41ff65f15b8dd8234101431852382a5a41488dc45b8dd8234189402652382a5a412294b95b8dd8234195f93352382a5a419517d05b8dd8234120494152382a5a415af48a5c8dd823411a106a52382a5a4198f7f65c8dd823412cc59652382a5a412f6ede5c8dd823411b97ad52382a5a41159bab5c8dd8234190a6b452382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (81,'os','phalange','droit','membre inférieur','adulte',X'00016a0800005a910a9e8dd823411f9e024e382a5a4156c4eeab8dd82341775cb550382a5a417c06000000010000006903000000010000002800000082e716ab8dd82341098e9550382a5a410f21baab8dd82341f43e7f50382a5a4156c4eeab8dd82341cc236d50382a5a4157b5ccab8dd8234186215e50382a5a4114d86bab8dd82341151d5150382a5a41ca52bfa98dd8234148f42a50382a5a418c2452a98dd82341b1d81a50382a5a418c4108a98dd8234182490550382a5a41dd41d6a88dd82341fd4ee84f382a5a4133ccbea88dd823411f77c44f382a5a41c819eaa88dd823414e676a4f382a5a41712a32a98dd82341564b354f382a5a410d6134aa8dd823413ab1bd4e382a5a41428393aa8dd823416012844e382a5a416d8369aa8dd823416f0f564e382a5a416bf6c8a98dd823412be2324e382a5a411671c4a88dd8234159c4194e382a5a4149886ea78dd82341beef094e382a5a41e1d0d9a58dd823411f9e024e382a5a41b7df18a48dd823414109034e382a5a41a7493ea28dd82341e86a0a4e382a5a410528b7a08dd82341ced7184e382a5a41ca5ece9f8dd823416f3e2e4e382a5a41c832639f8dd82341309f494e382a5a41d0e8549f8dd8234179fa694e382a5a415b0710a08dd8234183efde4e382a5a41c1f52da08dd82341ed38094f382a5a418acd49a08dd82341cb237e4f382a5a4185f838a08dd82341cf42c34f382a5a41b70e0ea08dd82341cc29e44f382a5a417988c19f8dd8234149660450382a5a41981e2a9e8dd8234167756950382a5a415a910a9e8dd8234130097850382a5a418a6a0e9e8dd82341d5668450382a5a413e70379e8dd8234198c58f50382a5a418419009f8dd823417c63a850382a5a413771f19f8dd823411f69b250382a5a41c3e382a18dd82341775cb550382a5a41740999a58dd82341641ead50382a5a4182e716ab8dd82341098e9550382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (82,'os','phalange','droit','membre inférieur','adulte',X'00016a080000dc04d67b8dd82341d853e54f382a5a411c3f428a8dd8234158b4c652382a5a417c060000000100000069030000000100000033000000f27e147f8dd8234158b4c652382a5a4129b8947f8dd82341f13bb852382a5a41409336808dd823419914af52382a5a41815eff808dd82341ec78a952382a5a41377078848dd82341e9359c52382a5a41951ded878dd823419da08452382a5a41ba3d73898dd82341ffcf7152382a5a417d5c2a8a8dd82341e28f5d52382a5a411c3f428a8dd823417d174952382a5a41d5aaea898dd82341079e3552382a5a418d32ac888dd82341bd841652382a5a419be0f6868dd82341aefaf951382a5a41241842868dd8234184aee051382a5a41be62c2858dd823415c4fc051382a5a414dab30858dd82341a3307351382a5a41b7a2ae848dd823419ebd0151382a5a41f1429d848dd82341c3d8e050382a5a417257cd848dd823414ff4be50382a5a410206a4858dd82341facf7e50382a5a4158960a878dd8234137913b50382a5a4192096f868dd82341557f2150382a5a41f40cb8858dd82341caf40b50382a5a413c84e6848dd82341600efb4f382a5a412753fb838dd82341e3e8ee4f382a5a41715df7828dd823411ca1e74f382a5a41d886db818dd82341d853e54f382a5a4119b3a8808dd82341e11de84f382a5a41f0c55f7f8dd82341011cf04f382a5a41b5cd347e8dd8234188e7fd4f382a5a415122547d8dd82341c3ad1050382a5a418026b37c8dd82341ac542650382a5a41ff3c477c8dd8234140c23c50382a5a41e12be47b8dd8234153896350382a5a41dc04d67b8dd82341d4327450382a5a418581497c8dd8234197287d50382a5a4102ac007d8dd82341804b9650382a5a41e4f9f37d8dd82341f712c950382a5a416f897d7e8dd8234189d7ee50382a5a41d109ec7e8dd82341a9891851382a5a41a02e207f8dd823413e204151382a5a41a2451f7f8dd8234121456951382a5a41989cee7e8dd823412ba29151382a5a414781937e8dd8234136e1ba51382a5a417341137e8dd823411dace551382a5a41518bb87c8dd82341e28c4252382a5a4138b53a7c8dd82341e82b6e52382a5a418de0377c8dd82341b2f38e52382a5a41894f8f7c8dd82341b670a652382a5a416444207d8dd823416a2fb652382a5a415701ca7d8dd8234144bcbf52382a5a41f27e147f8dd8234158b4c652382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (83,'os','phalange','droit','membre inférieur','adulte',X'00016a0800008823ea5e8dd82341e213ad53382a5a41e6dea66d8dd823411c249f55382a5a417c0600000001000000690300000001000000260000006f0a7e658dd823411c249f55382a5a4137fe686c8dd823419ecb2e55382a5a41469a4b6d8dd82341c9441a55382a5a41e6dea66d8dd82341fb3b0555382a5a4108339b6d8dd8234138b1f054382a5a419efd486d8dd8234182a4dd54382a5a41f591526c8dd823414b05c054382a5a417fd3c66b8dd823416c5eb454382a5a416efe5f6a8dd82341595cb354382a5a4159178d698dd823413b70ab54382a5a412729b7688dd82341f3429b54382a5a4102c6f7678dd823413a278054382a5a41108068678dd82341cb6f5754382a5a4102a2e8668dd82341858ce753382a5a41c41773668dd8234177a9c453382a5a413993cf658dd823417f52b253382a5a41dc5c0b658dd82341e213ad53382a5a4128bd33648dd82341ea79b153382a5a4196fc55638dd82341dc10bc53382a5a419b3301618dd82341c056e353382a5a41e8a243608dd82341d6aef453382a5a41aac69b5f8dd8234105530954382a5a41e0dc205f8dd823416e8b2054382a5a418823ea5e8dd8234135a03954382a5a41a1d80e5f8dd8234179d95354382a5a41293aa65f8dd823415e7f6e54382a5a41520afa618dd82341f7c3a154382a5a415d05c2628dd82341df1db954382a5a41202f32638dd823415ea6cf54382a5a41783f5d638dd82341151ce654382a5a4142ee55638dd82341a33dfd54382a5a41fbdfcc628dd82341a41b4e55382a5a41f123ce628dd82341eb8f6955382a5a4177e70e638dd8234178fe7d55382a5a41f78a7b638dd823418e708c55382a5a41da6e00648dd823416fef9555382a5a4189f389648dd823415f849b55382a5a416f0a7e658dd823411c249f55382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (84,'os','calcanéus','gauche','membre inférieur','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (85,'os','talus','gauche','membre inférieur','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (86,'os','cuboïde','gauche','membre inférieur','adulte',X'00016a08000075a8f47f8ed8234193324e5b382a5a41171b93a08ed82341c730a35e382a5a417c06000000010000006903000000010000002c000000a1c5de818ed82341c0277b5d382a5a41a7122f818ed8234180ea935d382a5a41de689c808ed8234195e3ae5d382a5a41266423808ed82341ee0dd05d382a5a4175a8f47f8ed82341a5c2f45d382a5a41bfd940808ed82341d25a1a5e382a5a41f89b38818ed823418d2f3e5e382a5a4113930c838ed82341f0995d5e382a5a41733c7f858ed823419ae4775e382a5a41493c24888ed8234104378d5e382a5a41863de78a8ed823419a209c5e382a5a411debb38d8ed82341c730a35e382a5a4101f075908ed82341f6f6a05e382a5a4123f718938ed823419202945e382a5a4177ab88958ed8234107e37a5e382a5a41edb7b0978ed82341c027545e382a5a41dd0da49b8ed8234107e0fe5d382a5a41c352e49c8ed82341cb5eec5d382a5a41c5dcc49e8ed823418f70d95d382a5a411c1b8b9f8ed82341d8fbca5d382a5a4108a319a08ed823413957b55d382a5a41665771a08ed823417848995d382a5a41171b93a08ed823415b95775d382a5a41f9d07fa08ed82341a803515d382a5a41ec5b38a08ed823412659265d382a5a41ce9ebd9f8ed823419a5bf85c382a5a41983f6a9e8ed82341c74b9b5c382a5a41f5b3549d8ed8234127be435c382a5a41f618fe9c8ed8234149fe2f5c382a5a41568a889c8ed82341db021e5c382a5a410332ef9a8ed82341c244f85b382a5a4188c345988ed823412517ce5b382a5a41bcb4c4908ed82341b445705b382a5a41baf0d88e8ed82341cc76555b382a5a418094f98d8ed82341bfd84e5b382a5a41cd7f1f8d8ed8234193324e5b382a5a41a05c4d8c8ed82341f24a545b382a5a41fbd4858b8ed8234187e8615b382a5a41de92cb8a8ed82341fad1775b382a5a414a40218a8ed82341f6cd965b382a5a416ed4c8888ed823419ae7f55b382a5a41729fb7878ed8234192ac385c382a5a41f39d26858ed823418562cb5c382a5a41a1c5de818ed82341c0277b5d382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (87,'os','scaphoïde','gauche','membre inférieur','adulte',X'00016a08000066fc304d8ed82341af9d7a5c382a5a4192b324788ed82341bb9a935e382a5a417c0600000001000000690300000001000000310000001c7b90728ed8234189f82a5e382a5a41620c32738ed82341e0ad315e382a5a41c80ede738ed82341e879345e382a5a411243ac748ed8234129ef315e382a5a41cab188758ed82341df53265e382a5a4178635f768ed8234148ee0d5e382a5a41a8601c778ed82341a004e55d382a5a41e2b1ab778ed8234123dda75d382a5a41a36619788ed82341de16675d382a5a4192b324788ed823417361525d382a5a41ae62fd778ed823412cc2415d382a5a41524493778ed82341c972325d382a5a41d628d6768ed8234108ad215d382a5a416bc132718ed8234195c3b85c382a5a41220ffd6f8ed823410189a35c382a5a41f8c8b46e8ed82341fabc925c382a5a4187fa2a6d8ed823414157865c382a5a416aaf306b8ed82341934f7e5c382a5a413df396688ed82341af9d7a5c382a5a41b18baa618ed82341b4397f5c382a5a419a06c65e8ed823413416865c382a5a4191b0605c8ed823410559905c382a5a41cff7595a8ed82341538c9e5c382a5a41904a91588ed823414d3ab15c382a5a410e17e6568ed823411eedc85c382a5a412cd665538ed82341008a095d382a5a41e4e083518ed823419438375d382a5a4158b9d14f8ed8234137c76f5d382a5a41dca9714e8ed823413b3bae5d382a5a41c5fc854d8ed82341f299ed5d382a5a4166fc304d8ed82341ace8285e382a5a4113f3944d8ed82341bb2c5b5e382a5a41202bd44e8ed82341716b7f5e382a5a41e2ee10518ed8234120aa905e382a5a4109c77a538ed82341bb9a935e382a5a41a75446558ed82341d7c9905e382a5a4137809e568ed82341242a895e382a5a413332ae578ed8234151ae7d5e382a5a417f83d75a8ed82341fb8c4d5e382a5a41f963725c8ed82341891b3c5e382a5a41580e7a5e8ed82341729b2b5e382a5a414d9039638ed82341d900115e382a5a412002b4658ed82341fa66085e382a5a41ac5017688ed82341cfef035e382a5a410fc9446a8ed82341ab5b045e382a5a4166b81d6c8ed82341dd6a0a5e382a5a41428b936f8ed8234146dc2b5e382a5a4149cd2b718ed82341adc9305e382a5a411c7b90728ed8234189f82a5e382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (88,'os','cunéiforme médial','gauche','membre inférieur','adulte',X'00016a080000237bf5768ed823419762af59382a5a418a1ecc888ed82341c655ae5c382a5a417c0600000001000000690300000001000000200000009156627b8ed823419ee7725c382a5a419da1f17b8ed823418d38995c382a5a41e9876a7c8ed8234133fba75c382a5a416ce70d7d8ed82341c655ae5c382a5a41484bdf7d8ed8234152a4a65c382a5a41a23ee27e8ed82341e7428b5c382a5a4181e497818ed82341b07c115c382a5a41672ea0868ed82341e2b33c5b382a5a413d08e7878ed8234154ecfa5a382a5a41e762af888ed823412f39bf5a382a5a418a1ecc888ed82341e0b48b5a382a5a41471b10888ed82341d579625a382a5a417bbee4858ed82341de16285a382a5a4172d9f8838ed823410565ff59382a5a418f6de2818ed8234173c9dd59382a5a41377c377f8ed8234154a9b859382a5a411642ad7d8ed823419762af59382a5a41855f2f7c8ed82341a290ba59382a5a41283aca7a8ed823411b01d559382a5a41a6378a798ed82341a581f959382a5a41a6bd7b788ed82341e6df225a382a5a41cc31ab778ed8234182e94b5a382a5a41bef924778ed823411d6c6f5a382a5a41237bf5768ed823415d35885a382a5a4154f116778ed82341c7b4485b382a5a41237bf5768ed8234125a3bf5b382a5a41029d10778ed82341a443ed5b382a5a41eed486778ed82341795f135c382a5a4162f23a788ed82341d767325c382a5a41dbc40f798ed82341f0cd4a5c382a5a41d41be8798ed82341f8025d5c382a5a419156627b8ed823419ee7725c382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (89,'os','cunéiforme intermédiaire','gauche','membre inférieur','adulte',X'00016a08000097a78a628ed8234179ce325a382a5a416f95b76c8ed823413bbad05b382a5a417c060000000100000069030000000100000017000000db9109698ed8234143daca5b382a5a415fcf566a8ed823413bbad05b382a5a410bca126b8ed82341bba8ce5b382a5a4192b6c86b8ed82341ca6dc65b382a5a4104e15d6c8ed823412f8cb55b382a5a416f95b76c8ed82341b286995b382a5a41289e936c8ed82341f1549a5a382a5a41164d636c8ed82341b7c56d5a382a5a418b01fa6b8ed82341416f4b5a382a5a416cee426b8ed8234104aa365a382a5a419e46296a8ed8234179ce325a382a5a41bb92ce658ed823412a8d365a382a5a41e4d87c648ed8234149a7395a382a5a417a436d638ed823419e89425a382a5a41e75abd628ed82341ed1d545a382a5a4197a78a628ed82341f84d715a382a5a412a206e638ed823413cead15a382a5a41b53689638ed82341b936075b382a5a4120dd87638ed82341188a695b382a5a412f2de0638ed823418ad5915b382a5a41eea5c1648ed82341dc0fb15b382a5a4175a766668ed8234157dbc45b382a5a41db9109698ed8234143daca5b382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (90,'os','cunéiforme latéral','gauche','membre inférieur','adulte',X'00016a08000097b4454f8ed82341e202a359382a5a4146fafc5d8ed823416aa11e5c382a5a417c06000000010000006903000000010000001d000000ca9635598ed82341a2e9135c382a5a41fc56e45a8ed823416aa11e5c382a5a41b6cad75b8ed823412f9f1c5c382a5a4162f1c35c8ed823415d5b115c382a5a41ae73865d8ed82341d9f4f85b382a5a4146fafc5d8ed82341888acf5b382a5a415eeddd5d8ed82341b9d8965a382a5a41f5a7c05d8ed82341aac8455a382a5a412c6c6b5d8ed823416843ff59382a5a415c81c15c8ed82341ffe3c859382a5a41df2ea65b8ed823417945a859382a5a410ebcfc598ed82341e202a359382a5a4137bd52548ed823417ff4c159382a5a419099b6528ed823414cb4ce59382a5a41c2c957518ed82341032bde59382a5a411dbe45508ed823419c3ef159382a5a41f4e68f4f8ed823410fd5085a382a5a4197b4454f8ed8234156d4255a382a5a412bc25b4f8ed823413d164a5a382a5a411046af4f8ed823414299755a382a5a41fbbacd518ed82341a4aa445b382a5a4113e323528ed82341ddce765b382a5a41a0fe3d528ed82341e293ca5b382a5a411c4c5f528ed823419f83e85b382a5a41d9e0b0528ed8234195d5fe5b382a5a41e91142538ed8234147370e5c382a5a415e3422548ed823413856175c382a5a414a9d60558ed82341ebdf1a5c382a5a41ca9635598ed82341a2e9135c382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (91,'os','métatarsien','gauche','membre inférieur','adulte',X'00016a080000c548f8a98ed82341edb09a55382a5a4167021fc58ed823413b58a85e382a5a417c06000000010000006903000000010000002f00000001e931ac8ed82341a7bc905c382a5a416f8468ad8ed82341db70cb5c382a5a4105bf1cae8ed8234176cbf35c382a5a419af9d0ae8ed82341eb39235d382a5a4127326eaf8ed82341fdbe575d382a5a41a466ddaf8ed823416a5d8f5d382a5a41099507b08ed82341f317c85d382a5a41b29cd7af8ed82341d2815f5e382a5a419a4807b08ed82341809d835e382a5a413be68bb08ed8234142ab9c5e382a5a41d35385b18ed823413b58a85e382a5a419a6f13b38ed823418d51a45e382a5a41cc1756b58ed823415a448e5e382a5a41d3a098b78ed8234173cd685e382a5a413cbd26b98ed82341c69b385e382a5a41bf4220ba8ed823419075fe5d382a5a410f07a5ba8ed823410b21bb5d382a5a41e3dfd4ba8ed8234173646f5d382a5a41551383ba8ed8234136ca525b382a5a415bf094ba8ed82341904ba25a382a5a41cef1f3ba8ed82341872be259382a5a41af79c8bb8ed82341ce431b59382a5a41ffe93abd8ed823411a6e5658382a5a41c2a473bf8ed823411f849c57382a5a418b0a76c48ed82341cb4b9756382a5a4167021fc58ed8234113ad4c56382a5a41c5eddac48ed823413bf81356382a5a41ddc6eec38ed8234112a2ea55382a5a41e8879fc28ed82341641fce55382a5a411f2b32c18ed8234102e5bb55382a5a41bcaad9bd8ed823411576a055382a5a41711aa4bc8ed82341edb09a55382a5a4170b44ebb8ed82341aec59c55382a5a410b8b0eba8ed82341cb90ac55382a5a4190b018b98ed82341b8eecf55382a5a415137a2b88ed82341e6bb0c56382a5a4138f425b98ed823415a4dd756382a5a41bba2bbb88ed8234150e04657382a5a41ba85c5b78ed823413de4b657382a5a41c8e567b68ed82341aeaf2658382a5a41770bc7b48ed8234134999558382a5a4149a987ab8ed8234191f5e05a382a5a416c5789aa8ed82341d801305b382a5a4172b8f8a98ed823416d807f5b382a5a41c548f8a98ed8234160a6d25b382a5a41d184aaaa8ed82341c3a82c5c382a5a4101e931ac8ed82341a7bc905c382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (92,'os','métatarsien','gauche','membre inférieur','adulte',X'00016a080000df277f958ed823418b07ca52382a5a419bdcbaae8ed8234199199b5a382a5a417c06000000010000006903000000010000003300000099e847988ed8234130932e5a382a5a4184020e998ed82341327b345a382a5a41049d259a8ed823413882425a382a5a4117bce49d8ed823418469845a382a5a418f11f69e8ed8234143d8935a382a5a41f0a005a08ed8234199199b5a382a5a4158190ea18ed82341a9f9955a382a5a41e4290aa28ed823419644805a382a5a41b181f4a28ed8234182c6555a382a5a41decfc7a38ed82341904b125a382a5a4138035aa48ed823419599c159382a5a41676496a48ed8234107747159382a5a414f6098a48ed8234180a32059382a5a414f3552a48ed82341f9051e58382a5a410edd7ca48ed82341775fbe57382a5a410040f6a48ed82341f1f85757382a5a4155ae0ca68ed82341f25cac56382a5a4146c206a78ed82341a9c12e56382a5a41450672a88ed82341bf0faa55382a5a41c304dcaa8ed82341dd2fe954382a5a41936856ae8ed82341b6b4f853382a5a419bdcbaae8ed823412cc8cb53382a5a41cc5195ae8ed82341d60ba553382a5a4137e3cdad8ed8234111a47d53382a5a41edab4cac8ed823413bb54e53382a5a41fec6f9a98ed82341b2631153382a5a41cda760a78ed823410558dd52382a5a41f6491ea58ed823418b07ca52382a5a41ec6f34a38ed823419c5ed052382a5a4122dca4a18ed823418e49e952382a5a410b5171a08ed82341bab40d53382a5a411c919b9f8ed82341748c3653382a5a41c75e259f8ed8234116bd5c53382a5a41807c109f8ed82341f5327953382a5a41e74b4ca08ed823419920f553382a5a419662d5a08ed823415fc63454382a5a41502d42a18ed823415cd37c54382a5a410d2678a18ed82341b69ecb54382a5a41c3c65ca18ed82341967f1f55382a5a419f2f27a08ed82341efd0d355382a5a41a997669e8ed82341a2731257382a5a41f364919d8ed82341e8978357382a5a419e1e709c8ed82341ff10f557382a5a41e838e89a8ed8234197fd6458382a5a41ece5fe968ed823414f6b2f59382a5a418cfcea958ed823414b787759382a5a41df277f958ed82341da64ad59382a5a41d32397958ed8234186f2d459382a5a4157ac0e968ed82341dbe2f159382a5a415b7dc1968ed8234162f7075a382a5a4199e847988ed8234130932e5a382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (93,'os','métatarsien','gauche','membre inférieur','adulte',X'00016a080000165e007c8ed82341290c6451382a5a41f0b478908ed8234157ab4f59382a5a417c060000000100000069030000000100000038000000df77157e8ed82341a1219458382a5a419bdb1a808ed823413dfeae58382a5a415ea89a828ed82341368ad558382a5a4182c0cc848ed8234113490259382a5a419f3c2e868ed8234198522e59382a5a41659c54878ed82341218b4259382a5a41f2d4b1888ed823410d774f59382a5a415bf30f8a8ed8234157ab4f59382a5a41b604398b8ed82341febc3d59382a5a411816f78b8ed82341fe401459382a5a419534148c8ed8234153cccd58382a5a41d101638a8ed82341e9cad057382a5a417ca5e0898ed8234183511657382a5a4190e6c2898ed8234116ea4456382a5a415653f9898ed82341eff66b55382a5a41197a738a8ed823415bda9a54382a5a4124e9208b8ed82341a7f6e053382a5a41c02ef18b8ed8234120ae4d53382a5a41e2a4df8c8ed8234102b0e752382a5a4171278c8d8ed823416e63bb52382a5a413b95cd8e8ed82341cb4d8a52382a5a4196c3c68f8ed82341c3396c52382a5a41f0b478908ed82341991b4852382a5a4160ae6a908ed82341f5cb1d52382a5a41431cb88f8ed82341c9d4f051382a5a41f56a7c8e8ed8234108c0c451382a5a41d306d38c8ed82341a5179d51382a5a41385cd78a8ed8234192657d51382a5a4182d7a4888ed82341c3336951382a5a410de556868ed82341290c6451382a5a41649729848ed82341dc3b6c51382a5a41c3bb4c828ed82341c5d17c51382a5a419b0dca808ed82341947a9451382a5a415748ab7f8ed82341fbe2b151382a5a416827fa7e8ed82341a8b7d351382a5a413c66c07e8ed823414ca5f851382a5a413fc0077f8ed8234198581f52382a5a41e2f0d97f8ed823413c7e4652382a5a4130e0c4818ed823419e7f8b52382a5a410f4e7c828ed82341ae55ad52382a5a41daaf05838ed823410609d452382a5a4168815d838ed82341ed940353382a5a418e3e80838ed82341aaf43f53382a5a4121636a838ed8234184238d53382a5a41046ada818ed8234146286755382a5a417a1c54818ed8234188cfee55382a5a4174fda7808ed8234110047556382a5a419fd9c77f8ed8234103d0f556382a5a41aa7da57e8ed82341833d6d57382a5a41130c6d7c8ed82341c5990b58382a5a41a6200d7c8ed8234169eb3158382a5a41165e007c8ed823411b2c4d58382a5a417e2e347c8ed82341503c6058382a5a41f8fb957c8ed8234180fc6d58382a5a418e36997d8ed82341b20e8558382a5a41df77157e8ed82341a1219458382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (94,'os','métatarsien','gauche','membre inférieur','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (95,'os','métatarsien','gauche','membre inférieur','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (96,'os','sésamoïde','gauche','membre inférieur','adulte',X'00016a0800003d40c5568ed823415791c553382a5a412c66c05c8ed8234124bd1655382a5a417c06000000010000006903000000010000001b000000375e465c8ed82341510d7f54382a5a413520625c8ed82341b3812054382a5a41375e465c8ed82341bce2ee53382a5a418bd6225c8ed823412b9fdd53382a5a41e855da5b8ed82341bfafd153382a5a41cd33625b8ed82341306ac953382a5a41e5d8c75a8ed823415791c553382a5a41dead185a8ed823410fe8c653382a5a41651b62598ed823413131ce53382a5a41268ab1588ed82341962fdc53382a5a41cf6214588ed8234118a6f153382a5a410b0e98578ed8234190570f54382a5a415e93f0568ed82341ff725254382a5a414a27c7568ed82341a2ac7254382a5a413d40c5568ed82341dd829154382a5a415c59f3568ed823412a95ae54382a5a41caed59578ed823410883c954382a5a41ac7801588ed82341f0ebe154382a5a412675f2588ed82341606ff754382a5a413a6dfc598ed823412fac0855382a5a411927e55a8ed823416b971355382a5a417279a65b8ed8234124bd1655382a5a41f43a3a5c8ed823416aa91055382a5a414d429a5c8ed823414fe8ff54382a5a412c66c05c8ed82341e105e354382a5a41407da65c8ed82341328eb854382a5a41375e465c8ed82341510d7f54382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (97,'os','sésamoïde','gauche','membre inférieur','adulte',X'00016a0800001aa1b63c8ed823417b6b3254382a5a41e992b1428ed82341069f8255382a5a417c06000000010000006903000000010000001300000099cd6a3e8ed8234124cd7655382a5a41c046b83f8ed82341c2d08055382a5a413c7a7b408ed82341069f8255382a5a418e9840418ed82341ddeb7f55382a5a41ad91ef418ed82341e9787655382a5a41925570428ed82341c9076455382a5a4136d4aa428ed823411f5a4655382a5a41e992b1428ed823418ac5c054382a5a41569084428ed8234185ae8854382a5a41c3b230428ed82341933c5a54382a5a41d210c4418ed823418be44754382a5a413679fe408ed82341fc853a54382a5a41fcf602408ed82341720e3354382a5a413595f43e8ed823417b6b3254382a5a41ee5ef63d8ed82341a38a3954382a5a41355f2b3d8ed8234177594954382a5a411aa1b63c8ed8234185c56254382a5a41ac2fbb3c8ed8234159bc8654382a5a4199cd6a3e8ed8234124cd7655382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (98,'os','phalange','gauche','membre inférieur','adulte',X'00016a080000cecb90388ed82341e5c9974e382a5a4163d791508ed8234105356851382a5a417c06000000010000006903000000010000002c000000102f723a8ed8234105356851382a5a414be8e53d8ed82341c1e73e51382a5a41770e45408ed82341b4b02951382a5a418e5f0e438ed82341b6911751382a5a412fc923468ed8234100a20c51382a5a41fa3867498ed82341ccf80c51382a5a41255c444f8ed82341085c2b51382a5a41687372508ed8234130e82751382a5a4163d791508ed823411c6a1551382a5a41247def4f8ed823411cfaf650382a5a413562994d8ed82341a4a5a250382a5a41a08b7f4c8ed82341cdf17250382a5a410acbd74b8ed8234152ad4350382a5a41c349d34b8ed82341ecea0b50382a5a415ec25a4d8ed8234192532d4f382a5a4131527b4d8ed823419d7fea4e382a5a41e474f64c8ed823412f42b84e382a5a41e849864b8ed823413f599e4e382a5a41b0f0e4488ed82341c382a44e382a5a41ddade1438ed82341fe57c84e382a5a41e9224d428ed82341fc76d04e382a5a41839814418ed823418780d24e382a5a41dc8306408ed8234159cace4e382a5a41235af13e8ed823412eaac54e382a5a413e9ceb3b8ed82341c382a44e382a5a41fc27403a8ed82341e5c9974e382a5a41fabc2d398ed82341e0c49a4e382a5a417e8da3388ed823414376ab4e382a5a41cecb90388ed823419be0c74e382a5a4130aae4388ed823417806ee4e382a5a41eb5a8e398ed8234168ea1b4f382a5a41279ba63c8ed823416c41be4f382a5a41118f4e3d8ed823411be4f24f382a5a4191459c3d8ed8234136df2450382a5a41f92b943d8ed823412d335450382a5a419caf3a3d8ed823416fe08050382a5a41ca3d943c8ed823416ae7aa50382a5a41d543a53b8ed823418d48d250382a5a41e21d6e398ed823411ef91651382a5a415f0bf4388ed8234131833051382a5a41371fe4388ed82341a24c4451382a5a411d811e398ed8234194ff5251382a5a41c15883398ed8234128465d51382a5a41102f723a8ed8234105356851382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (99,'os','phalange','gauche','membre inférieur','adulte',X'00016a0800000d1e13308ed823417d24854a382a5a414fd0ce448ed823410e261e4d382a5a417c06000000010000006903000000010000002e000000fedcb3408ed82341f102144d382a5a41ad4fc5428ed8234111011b4d382a5a41b30dc3438ed823412d69164d382a5a41dda484448ed82341db15084d382a5a414fd0ce448ed823410644ec4c382a5a412e4b66448ed823419b30bf4c382a5a41a0d00f438ed8234185187d4c382a5a4158a359418ed82341a994394c382a5a417a26fa3e8ed8234143a9e34b382a5a41e8ee573e8ed82341eea0c84b382a5a41eccb183e8ed823415076b24b382a5a418649403e8ed8234104d99c4b382a5a41baf3d13e8ed82341a378834b382a5a41c932c4408ed823413ea23d4b382a5a4191c536418ed82341d4e41d4b382a5a414d5536418ed82341b122024b382a5a416328d0408ed82341fab1e94a382a5a413f8511408ed82341d8e8d34a382a5a4149b2073f8ed823416e1dc04a382a5a418b96473c8ed8234162d89b4a382a5a4197e56b3a8ed82341d8108d4a382a5a41914b24388ed823417d24854a382a5a41eadbbc358ed82341579f854a382a5a4110aa81338ed823416e0d904a382a5a4174c9be318ed82341cafaa54a382a5a41854dc0308ed8234173f3c84a382a5a41b249d2308ed823416e83fa4a382a5a416cd140328ed82341c5363c4b382a5a412b67de338ed823417e23794b382a5a41c807d2348ed823411de9ab4b382a5a41e1f136358ed82341c176d64b382a5a41166428358ed823418abbfa4b382a5a41059dc1348ed8234196a61a4c382a5a414cdb1d348ed823410627384c382a5a415d628c328ed823418ea4734c382a5a4148fe05318ed823411828b74c382a5a41f6ad6d308ed823416d23d84c382a5a41de2a14308ed823414e5cf54c382a5a410d1e13308ed823411e640c4d382a5a41943084308ed823413ecc1a4d382a5a41800b81318ed823410e261e4d382a5a41bdad3e358ed82341a57c064d382a5a41932b7f378ed823417c23004d382a5a418433c3398ed82341814fff4c382a5a41306acf3d8ed823414897074d382a5a41fedcb3408ed82341f102144d382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (100,'os','phalange','gauche','membre inférieur','adulte',X'00016a0800002e21dd598ed823417b20114c382a5a413915bf6d8ed82341061a194f382a5a417c06000000010000006903000000010000002d000000aac9c25e8ed823412aaf914e382a5a4115846c5d8ed82341a960ce4e382a5a41c51eeb5c8ed82341c5a9ed4e382a5a41e894b75c8ed823419a86084f382a5a41ca34055d8ed82341cefe184f382a5a41b84c075e8ed82341061a194f382a5a4196913f628ed823411691e64e382a5a41bdb34a648ed823416ea5d64e382a5a41cc090f668ed823415475d04e382a5a41160c89678ed823413259d14e382a5a41ee32b5688ed823416da9d64e382a5a41de1c016c8ed823417e7bf94e382a5a41f9d0d76c8ed823413ecbfb4e382a5a4193fc7c6d8ed823416d60f44e382a5a413915bf6d8ed82341b296de4e382a5a4176906c6d8ed82341b5c9b54e382a5a414c7df76a8ed82341527d2c4e382a5a418b5bf5698ed82341d97eec4d382a5a4145a444698ed82341b494b34d382a5a412d7ddc688ed82341e8f97f4d382a5a41f20bb4688ed8234178e94f4d382a5a414876c2688ed82341699e214d382a5a41e1e1fe688ed82341bd53f34c382a5a416d7460698ed823417944c34c382a5a4139d68d698ed823412fa3954c382a5a417d6a3f698ed8234141856f4c382a5a41aade86688ed82341ed79504c382a5a412fe075678ed823416f10384c382a5a417c1c1e668ed8234102d8254c382a5a41014191648ed82341e45f194c382a5a412efbe0628ed823415037124c382a5a418e26555f8ed823417b20114c382a5a41f79c985d8ed8234121fa154c382a5a41a7d90b5c8ed823418f5b204c382a5a419a5ad15a8ed82341e025324c382a5a41c99d0b5a8ed82341303a4d4c382a5a412e21dd598ed823419979734c382a5a41c462685a8ed8234138c5a64c382a5a414ed6c25e8ed82341fbb8694d382a5a415fe1a55f8ed82341fda49e4d382a5a41205e29608ed823417808cf4d382a5a41c1d950608ed82341b935fd4d382a5a416fe11f608ed823410e7f2b4e382a5a4158029a5f8ed82341c4365c4e382a5a41aac9c25e8ed823412aaf914e382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (101,'os','phalange','gauche','membre inférieur','adulte',X'00016a080000c89b395a8ed8234144dfd749382a5a416e15e0668ed8234144a8244b382a5a417c0600000001000000690300000001000000220000004856895b8ed8234144a8244b382a5a4178f011608ed823418b7c234b382a5a41c55b9f638ed82341dbba184b382a5a4163751a658ed823412b190e4b382a5a410b0127668ed8234195eefe4a382a5a41009cb4668ed82341d076f04a382a5a416e15e0668ed823412431e74a382a5a410286bf668ed82341ad3ce14a382a5a416c9972658ed82341a67dd04a382a5a4161ddfe648ed823412105c54a382a5a41de93ad648ed823415f79b34a382a5a41697c87648ed823416f469a4a382a5a41478c59648ed82341954e144a382a5a4198f818648ed82341f857f849382a5a410747a3638ed82341d81ee449382a5a41f586e8628ed82341e266da49382a5a416899f0618ed8234144dfd749382a5a41ebaebd5f8ed823413c39db49382a5a41e456ab5e8ed82341cfa6e249382a5a419bd5b85d8ed8234118f2ee49382a5a41877dfa5c8ed8234117e1004a382a5a411aa1845c8ed82341ca39194a382a5a41ca926b5c8ed823412ec2384a382a5a415104945c8ed823415b90594a382a5a41a712595d8ed82341f78cb04a382a5a41b93e555d8ed823416274bd4a382a5a415c6a235d8ed8234138b5c74a382a5a41a833b75c8ed82341f0c0cf4a382a5a410fcbea5a8ed82341c8f9e84a382a5a41b8a9775a8ed823414025f34a382a5a41c89b395a8ed82341a432fe4a382a5a413ef9445a8ed8234124220a4b382a5a41141aae5a8ed82341f3f3164b382a5a414856895b8ed8234144a8244b382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (102,'os','phalange','gauche','membre inférieur','adulte',X'00016a0800009edc6a5a8ed82341ac17a948382a5a41517e09648ed8234161c85d49382a5a417c06000000010000006903000000010000001700000057c53d5b8ed8234102f63949382a5a4107c4e35c8ed82341075b4e49382a5a414414f85d8ed8234175705749382a5a41bec62f5f8ed82341d46d5d49382a5a41966477608ed8234161c85d49382a5a41f376bb618ed8234159f55549382a5a41f586e8628ed82341fa694349382a5a416109ba638ed823412cb32c49382a5a41517e09648ed82341b9871949382a5a418e90f0638ed82341ce040949382a5a41e4ea88638ed823419647fa48382a5a4161567a618ed82341dad5cf48382a5a41e3403e608ed82341b36db148382a5a418686905f8ed82341e462aa48382a5a41122ad85e8ed82341ac17a948382a5a41af071e5e8ed82341ff70ac48382a5a41c2e1c75c8ed8234113a5bc48382a5a4103f6d45b8ed82341bf26d248382a5a411f3fca5a8ed823417182f548382a5a419edc6a5a8ed8234113031049382a5a41fe72765a8ed82341f4cf1d49382a5a41bfe9b85a8ed82341fcd42b49382a5a4157c53d5b8ed8234102f63949382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (103,'os','phalange','gauche','membre inférieur','adulte',X'00016a080000d07081838ed82341bd515f49382a5a412aa55e8e8ed82341cd60274a382a5a417c06000000010000006903000000010000001a000000d48012858ed82341ce910a4a382a5a412a7062868ed82341adbd1c4a382a5a416caa4e878ed82341ccf0234a382a5a41c45b69888ed82341cd60274a382a5a41e81ea9898ed823410f74244a382a5a418d8e048b8ed82341f290184a382a5a416745728c8ed82341d71d014a382a5a41be8f998d8ed823417e3ae549382a5a417cba368e8ed82341054fcd49382a5a412aa55e8e8ed823413ac5b849382a5a41502f268e8ed82341e706a749382a5a417738a28d8ed82341da7d9749382a5a41eb450b8c8ed82341c5b27c49382a5a419c882c8a8ed823415ff56549382a5a41995334898ed82341037d6049382a5a4154c13f888ed82341bd515f49382a5a414ae17a868ed8234154bc6749382a5a41a941b7858ed82341233f7049382a5a418c568d848ed8234127308749382a5a41be19d1838ed82341a3c1a349382a5a41320898838ed82341c4c2b349382a5a41d07081838ed823419b90c449382a5a41caa894838ed823417de8d549382a5a415205d9838ed82341c287e749382a5a419adb55848ed82341c02bf949382a5a41d48012858ed82341ce910a4a382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (104,'os','phalange','gauche','membre inférieur','adulte',X'00016a080000e09da8828ed8234168f85d4b382a5a41af186b8d8ed82341cf1c914c382a5a417c060000000100000069030000000100000020000000af186b8d8ed82341c83e714c382a5a414490078d8ed82341125f6a4c382a5a419e9cbe8c8ed82341bca45d4c382a5a41fe778e8c8ed8234192464c4c382a5a41a75c758c8ed82341617b374c382a5a41d62a818c8ed823411f79084c382a5a41ddc2f38c8ed823414b8dc54b382a5a41a713e28c8ed8234166e4b14b382a5a41cad09e8c8ed8234180919f4b382a5a4179ff298c8ed823416ecc8e4b382a5a41e8a4838b8ed8234104cd7f4b382a5a414ac6ab8a8ed8234117cb724b382a5a41d168a2898ed823417afe674b382a5a41b19167888ed82341039f5f4b382a5a41f1b52c878ed8234168f85d4b382a5a41294b24868ed82341a6f1654b382a5a415a324f858ed823416ca9754b382a5a41874cae848ed82341663e8b4b382a5a41b17a42848ed8234143cfa44b382a5a41db9d0c848ed82341af7ac04b382a5a4106970d848ed82341595fdc4b382a5a41faea64848ed8234164ea0c4c382a5a41cfb92d848ed82341e3231f4c382a5a41b925de828ed82341f573494c382a5a41e09da8828ed82341f97a574c382a5a41a1bfc9828ed82341b97d674c382a5a41b30a64838ed82341bfb27a4c382a5a41fbd37f848ed823412a8d8a4c382a5a41dd0ef4858ed82341cf1c914c382a5a412fcf99878ed823411398904c382a5a417f2fde8a8ed82341162b834c382a5a41af186b8d8ed82341c83e714c382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (105,'os','phalange','gauche','membre inférieur','adulte',X'00016a0800003d12f0ad8ed82341fa64ed4b382a5a4176dabeb68ed823414177924c382a5a417c060000000100000069030000000100000018000000beb035af8ed82341bfb27a4c382a5a4110f245b08ed8234198af894c382a5a41806deab18ed823414177924c382a5a41257eedb28ed82341970f904c382a5a4156f106b48ed823418444864c382a5a4188272fb58ed823413af1724c382a5a41f8c81eb68ed82341d1e85b4c382a5a41b5609eb68ed82341a127484c382a5a4176dabeb68ed82341ef31374c382a5a41f02191b68ed82341028c284c382a5a41d82226b68ed8234120ba1b4c382a5a41ccffdbb48ed8234195a3054c382a5a41bac057b38ed82341b4e3f24b382a5a41d461c8b18ed82341fa64ed4b382a5a41145559b08ed82341ec51f44b382a5a413bc9baaf8ed82341c054fb4b382a5a41095ec9ae8ed82341113b0e4c382a5a41e09330ae8ed8234195da254c382a5a41dd5202ae8ed82341cf12334c382a5a413d12f0ad8ed823415af2404c382a5a4142c0ffad8ed8234176424f4c382a5a412d4b37ae8ed8234165cc5d4c382a5a4141a19cae8ed8234168596c4c382a5a41beb035af8ed82341bfb27a4c382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (106,'os','phalange','gauche','membre inférieur','adulte',X'00016a080000c1db03ac8ed823416637404d382a5a4154a6bcb48ed82341989d3d4e382a5a417c06000000010000006903000000010000001e00000054a6bcb48ed823414551234e382a5a41a4126cb48ed82341d9a61d4e382a5a41b40a0ab48ed82341c4ce044e382a5a41f8b7f5b38ed823419aa3f34d382a5a41bd48ffb38ed823413fd5cc4d382a5a41350b5cb48ed8234101a8954d382a5a41e9aa4db48ed823414574854d382a5a41c51e17b48ed823411958764d382a5a413d6ab8b38ed823414882684d382a5a41ce9582b28ed82341e564514d382a5a41cf7cabb18ed82341ea7a484d382a5a413949acb08ed823417a92414d382a5a41a809adaf8ed823416637404d382a5a4111b2d6ae8ed8234170cd464d382a5a4194f729ae8ed8234148c7534d382a5a414d8fa7ad8ed82341a197654d382a5a415b2e50ad8ed823412cb17a4d382a5a41dc8924ad8ed823419986914d382a5a41ec5625ad8ed823419b8aa84d382a5a4116246cad8ed82341c995d04d382a5a41c2613fad8ed82341599ddf4d382a5a41ad402fac8ed823413b82024e382a5a41c1db03ac8ed82341aa140e4e382a5a414ac11eac8ed82341e04a1b4e382a5a411fec9bac8ed8234147252b4e382a5a4112f081ad8ed823412636384e382a5a4139a5afae8ed82341989d3d4e382a5a41e17e05b08ed82341b32e3d4e382a5a41ea6cabb28ed82341411a324e382a5a4154a6bcb48ed823414551234e382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (107,'os','phalange','gauche','membre inférieur','adulte',X'00016a080000cfbc07d08ed8234157d9cd4f382a5a41348c06d78ed82341a07f5f50382a5a417c06000000010000006903000000010000001600000015219ed08ed8234126042f50382a5a4146ca52d18ed8234111944350382a5a41149d87d28ed8234156f15750382a5a41f81756d38ed823410b4b5e50382a5a41464f45d48ed82341a07f5f50382a5a418cc753d58ed82341b69d5950382a5a41ede83dd68ed8234151054f50382a5a41a01bcad68ed82341a9704350382a5a41348c06d78ed8234161083750382a5a413a6701d78ed8234120f52950382a5a4142d9c8d68ed82341895f1c50382a5a419634f6d58ed82341ed4f0050382a5a410c78efd48ed823417215e54f382a5a41f347c4d38ed823417b08d44f382a5a415a5498d28ed8234157d9cd4f382a5a4102610ed28ed82341e05cce4f382a5a41c4262bd18ed8234103aad54f382a5a4190b583d08ed82341f181e34f382a5a41af5a44d08ed82341f781ec4f382a5a41cfbc07d08ed8234151c10250382a5a41cd9e14d08ed82341eb091050382a5a4115219ed08ed8234126042f50382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (108,'os','phalange','gauche','membre inférieur','adulte',X'00016a08000090ca64ca8ed8234103664051382a5a4145fbf8d18ed8234191491f52382a5a417c06000000010000006903000000010000001c000000870c07d18ed8234191491f52382a5a41494fd4d08ed823414a341852382a5a419bbebbd08ed823414a5f0152382a5a41088027d18ed8234155b0d451382a5a410262e2d18ed82341a8ebab51382a5a4145fbf8d18ed82341ee9b9e51382a5a415811eed18ed823414ee39051382a5a412142c1d18ed8234105e78251382a5a41776b00d18ed8234172b86651382a5a417d66b3cf8ed82341223a4b51382a5a4191c6efce8ed823410f044251382a5a41647f3bce8ed8234103664051382a5a41ea539acd8ed82341162b4551382a5a41140710cd8ed823415b1e4f51382a5a41d75ba0cc8ed82341e90a5d51382a5a4125154fcc8ed82341d6bb6d51382a5a41f1f51fcc8ed8234136fc7f51382a5a411ba503cc8ed823411df7a151382a5a41ca75c1cb8ed823413b74ac51382a5a41a922a5ca8ed82341c973bf51382a5a41a9546bca8ed82341d83ec751382a5a4190ca64ca8ed82341be93d251382a5a41672fa5ca8ed82341d421e351382a5a4117b33ccb8ed8234146d2f451382a5a4189f31bcc8ed82341c7b90252382a5a41599a26cd8ed82341e2480d52382a5a418dc14ccf8ed8234115201a52382a5a41870c07d18ed8234191491f52382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (109,'os','phalange','gauche','membre inférieur','adulte',X'00016a08000018f6c3818ed823412c416d4d382a5a41ab25a88f8ed823418a062050382a5a417c060000000100000069030000000100000028000000f9bf9b828ed8234117310050382a5a4166c219888ed8234125c81750382a5a411901308c8ed823418a062050382a5a41e37bc18d8ed823413e101d50382a5a41b6d6b28e8ed82341b0041350382a5a41b75b7b8f8ed823419367fa4f382a5a411d55a48f8ed82341d908ef4f382a5a41ab25a88f8ed8234116abe24f382a5a414b93888f8ed823411817d44f382a5a41052af18d8ed8234153086f4f382a5a41569ba48d8ed82341dccd4e4f382a5a41bca5798d8ed823415fe92d4f382a5a41dab5688d8ed82341efcde84e382a5a419576848d8ed8234121da734e382a5a417064a28d8ed823412c8c494e382a5a41c4845d8e8ed82341e89bd44d382a5a41ab404f8e8ed823411844b44d382a5a413d1fe48d8ed823419ee5984d382a5a418966fb8c8ed82341cc7e834d382a5a41a05c748b8ed82341f50d754d382a5a4167b299898ed8234143ac6d4d382a5a41e3b0d8878ed823412c416d4d382a5a4199ec43868ed823412f93744d382a5a4109faed848ed82341c968844d382a5a41b66de9838ed8234178889d4d382a5a4124dc48838ed82341b9b8c04d382a5a41d3d91e838ed823410bc0ee4d382a5a4147fb7d838ed82341eb64284e382a5a417c5b80848ed82341c5f19f4e382a5a418b76c8848ed823413f08d54e382a5a4120c4f3848ed82341a0112f4f382a5a411044dc848ed8234176e9524f382a5a410c33aa848ed82341aee66f4f382a5a41c83760848ed82341be7b854f382a5a41c10ff3838ed823414297954f382a5a411bc546828ed8234171bfbb4f382a5a4155fae5818ed82341c3c3c84f382a5a4118f6c3818ed8234112c6d74f382a5a411398f8818ed8234179e1e94f382a5a41f9bf9b828ed8234117310050382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (110,'os','phalange','gauche','membre inférieur','adulte',X'00016a0800001d9270a38ed82341b2fe4f4f382a5a4128fadcb18ed823415a573152382a5a417c06000000010000006903000000010000003300000058819eae8ed823415a573152382a5a4140e3e8af8ed8234126602a52382a5a41be9092b08ed8234181d42052382a5a41d67623b18ed82341ca171152382a5a4108da7ab18ed82341be9df951382a5a41d6fe77b18ed8234117dad851382a5a41c129fab08ed823419340ad51382a5a411a4c9faf8ed82341aa555051382a5a41d0061faf8ed8234164882551382a5a41a7f1c3ae8ed82341af48fc50382a5a41f05b93ae8ed82341a2ecd350382a5a41009592ae8ed8234150caab50382a5a4129ecc6ae8ed82341d1378350382a5a41beb035af8ed823413a8b5950382a5a41a513bfaf8ed82341a2c03350382a5a41043bb2b08ed82341cef10050382a5a418e6969b18ed8234108cce74f382a5a4128fadcb18ed82341e1d5de4f382a5a41c1d1ceb18ed82341602cce4f382a5a41eeb66bb18ed823414e65a74f382a5a41dac2ffb08ed82341baf7904f382a5a4144b75eb08ed82341d0507b4f382a5a41dcf57daf8ed82341958a684f382a5a4157e052ae8ed823410ebf5a4f382a5a41dbe209ad8ed823413dc6524f382a5a41bc08d7ab8ed82341b2fe4f4f382a5a411233bbaa8ed823414a4c524f382a5a41f642b7a98ed82341df92594f382a5a418019cca88ed823414db6654f382a5a41c797faa78ed82341719a764f382a5a41e49e43a78ed8234124238c4f382a5a41ef0fa8a68ed823414434a64f382a5a410faf0ea88ed823411a72e94f382a5a414574e5a88ed82341cd952950382a5a41209915a98ed823410c7a4b50382a5a41834d04a98ed82341d25e6c50382a5a41892482a88ed82341fed8dd50382a5a417c7af0a78ed82341f0f02a51382a5a418cce70a78ed823418a4a4b51382a5a41f50dbca68ed8234149906451382a5a4124b506a58ed8234163168151382a5a413d2bc8a38ed823410736a051382a5a411d9270a38ed82341e1b2b351382a5a410f7688a38ed82341392ec851382a5a41f49e3fa48ed823416b70dc51382a5a41afd4c5a58ed82341d141ef51382a5a41214d3aa98ed82341cdda0652382a5a414241b3ac8ed8234100241452382a5a41fe1a7cad8ed8234168bf1952382a5a4156151eae8ed8234144e42252382a5a4158819eae8ed823415a573152382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (111,'os','phalange','gauche','membre inférieur','adulte',X'00016a08000023be0bc08ed823412fb41753382a5a41e64ac8ce8ed82341c6b20955382a5a417c060000000100000069030000000100000026000000a2aa34c88ed82341c6b20955382a5a4175a528c98ed8234163190655382a5a41d919b2c98ed8234110880055382a5a4171ed36ca8ed82341b50cf754382a5a41bb82a3ca8ed823418e9de854382a5a41343ce4ca8ed82341db30d454382a5a41597ce5ca8ed82341d8bcb854382a5a41c0725cca8ed823411de56754382a5a41422455ca8ed82341d6c55054382a5a41513780ca8ed8234173513a54382a5a417263f0ca8ed82341b2c82354382a5a412a60b8cb8ed82341536c0c54382a5a411a310cce8ed823410421d953382a5a418493a3ce8ed823419278be53382a5a41e64ac8ce8ed82341033ca453382a5a41e99591ce8ed82341a0238b53382a5a4136b316ce8ed82341afe77353382a5a4179e16ecd8ed8234178405f53382a5a415a5fb1cc8ed8234143e64d53382a5a41e5945cca8ed8234150ab2653382a5a4120dc7ec98ed82341eb171c53382a5a416b49a7c88ed823412fb41753382a5a410e20e3c78ed823410cf41c53382a5a4150a33fc78ed82341714b2f53382a5a417816cac68ed823414f2e5253382a5a41070f4ac68ed82341ff10c253382a5a41b1b8bac58ed823416cc8ea53382a5a41ce4afbc48ed8234123e40554382a5a41635625c48ed8234169111654382a5a41726c52c38ed8234185fd1d54382a5a419f97ebc18ed8234193ff1e54382a5a4168e25fc18ed82341d9a32a54382a5a41158b69c08ed82341bc3e4854382a5a41886017c08ed82341424a5b54382a5a4123be0bc08ed823415bd56f54382a5a41760967c08ed82341aae08454382a5a4110a849c18ed82341d26c9954382a5a41a2aa34c88ed82341c6b20955382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (112,'os','clavicule','gauche','ceinture scapulaire','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (113,'os','scapula','gauche','ceinture scapulaire','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (114,'os','côte 1','gauche','thorax','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (115,'os','côte 2','gauche','thorax','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (116,'os','côte 3','gauche','thorax','adulte',X'00016a080000b5c602468ed823414cd5e0c7382a5a41ba27cc7d8ed823416e0fe7d0382a5a417c060000000100000069030000000100000047000000a83a82468ed82341a282d8c8382a5a41efe161478ed82341cfe1dcc8382a5a4178a548538ed8234166b116c9382a5a410ec3cd5c8ed823413ab157c9382a5a415a2fa6638ed8234180569cc9382a5a414a8666688ed823419775e5c9382a5a41cb63a36b8ed82341e0e233ca382a5a41cc63f16d8ed82341be7288ca382a5a41043b13728ed82341b64b47cb382a5a4199e6f5738ed82341c405c4cb382a5a410a82cc748ed8234177d661cc382a5a413f17d4748ed82341f0b912cd382a5a4120b049748ed823414dacc8cd382a5a4196566a738ed82341afa975ce382a5a41891473728ed8234135ae0bcf382a5a41a674f9708ed823414c87d6cf382a5a4102baa8708ed823412245ebcf382a5a41ba1f40708ed823411a8afacf382a5a41f3f6c06f8ed823419ee905d0382a5a41bd19fd6c8ed823418ff52bd0382a5a41789c326c8ed8234130d842d0382a5a41b93f8d6b8ed8234133aa67d0382a5a41be8e276b8ed823415c7592d0382a5a41c3141c6b8ed823417143bbd0382a5a41045d856b8ed82341351edad0382a5a41bef27d6c8ed823416e0fe7d0382a5a412d61206e8ed82341e020dad0382a5a418e3387708ed823414f5cabd0382a5a411505da728ed82341844379d0382a5a41ca875a748ed82341f35e62d0382a5a4127694a758ed8234147b85ed0382a5a41bbfd7e768ed823414f4b71d0382a5a41e60b47778ed823415c9877d0382a5a419d2e85788ed82341ff4971d0382a5a415b137b7a8ed82341e46956d0382a5a411276637c8ed823410d152cd0382a5a413c946d7d8ed823419b83fecf382a5a419addc97d8ed823414c72d0cf382a5a41edc1a87d8ed82341dd9da4cf382a5a41f9b03a7d8ed823410dc37dcf382a5a41801ab07c8ed82341999e5ecf382a5a41021c077c8ed82341bf6b42cf382a5a41fc68447b8ed82341aa5afcce382a5a41b02feb7a8ed823416eebabce382a5a41dd8be57a8ed823411aaf54ce382a5a4141991d7b8ed82341bd36facd382a5a4199737d7b8ed823416713a0cd382a5a41c7e5b07c8ed823411d52b7cc382a5a4179e26d7d8ed82341a7e903cc382a5a41ba27cc7d8ed82341c30487cb382a5a414a149f7d8ed82341afea42cb382a5a41336ccd7c8ed82341f4f3f2ca382a5a410820677b8ed8234128879aca382a5a415d207c798ed82341e10a3dca382a5a41c55d1c778ed82341b5e5ddc9382a5a41d1c857748ed82341387e80c9382a5a4115523e718ed82341003b28c9382a5a4124eadf6d8ed82341a282d8c8382a5a41f600e5698ed82341179095c8382a5a41f8be21658ed82341873660c8382a5a41b013e75f8ed8234196cd36c8382a5a41a2ee855a8ed82341e4ac17c8382a5a41533f4f558ed82341152c01c8382a5a4146f593508ed82341cba2f1c7382a5a41084fd3498ed823414cd5e0c7382a5a41953408488ed82341d167e7c7382a5a41f2a5e1468ed82341638d01c8382a5a41c5c93f468ed823415bf828c8382a5a41b5c602468ed82341155b57c8382a5a416ac30a468ed82341eb6786c8382a5a41a83a82468ed82341a282d8c8382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (117,'os','côte 4','gauche','thorax','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (118,'os','côte 5','gauche','thorax','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (119,'os','côte 6','gauche','thorax','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (120,'os','côte 7','gauche','thorax','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (121,'os','côte 8','gauche','thorax','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (122,'os','côte 9','gauche','thorax','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (123,'os','côte 10','gauche','thorax','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (124,'os','côte 11','gauche','thorax','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (125,'os','côte 12','gauche','thorax','adulte',X'00016a0800000e099a658ed82341313ddcaa382a5a419e0434ab8ed82341b78e93b0382a5a417c06000000010000006903000000010000003a00000030951e9f8ed823417d2c18b0382a5a4169c48ca08ed82341b26053b0382a5a41b2657aa18ed82341d79e70b0382a5a41ef5284a28ed82341441d88b0382a5a41d6da98a38ed82341b78e93b0382a5a411c4ca6a48ed82341efa58cb0382a5a4176f59aa58ed82341aa156db0382a5a4158df75a68ed82341ed3244b0382a5a411807f3a78ed82341e0650db0382a5a419e090da98ed823411f74f2af382a5a41e9ab42aa8ed82341f966dfaf382a5a417df9b2aa8ed82341c495d2af382a5a4179ce0fab8ed82341d6afbfaf382a5a419e0434ab8ed823414428a6af382a5a41ad75faaa8ed82341257285af382a5a4166fb3daa8ed8234190005daf382a5a41e3db48a78ed823414de0f8ae382a5a4130ee0ea68ed82341e275c8ae382a5a410fee76a28ed823415e9419ae382a5a41722a60a18ed8234156caefad382a5a41b2d100a08ed82341f9aac5ad382a5a4134df229e8ed823419e2e97ad382a5a41b9b1bc9b8ed82341954962ad382a5a41186cfa958ed823416affeeac382a5a4139a2118b8ed823416b8026ac382a5a41b9af11868ed82341f43dd9ab382a5a41c351d37f8ed82341b27088ab382a5a4115c686798ed82341463e42ab382a5a416342ba768ed82341e38a27ab382a5a41127c38728ed82341aa8e07ab382a5a415f41fb6d8ed823410f5bf2aa382a5a41a426fa678ed82341313ddcaa382a5a41ab5538668ed823412ab0e8aa382a5a419db7a7658ed823418405f5aa382a5a410e099a658ed82341801a07ab382a5a41ff405c668ed8234197ed1fab382a5a4176563b688ed82341427d40ab382a5a41269b5d6f8ed82341b20298ab382a5a417236c2728ed823412ee9c5ab382a5a419cb0bc758ed823412744f2ab382a5a4129ab557e8ed8234169eb7bac382a5a4194c5dc7f8ed82341ae4f8eac382a5a41aee921838ed82341024eaeac382a5a41cad79e868ed82341e136dfac382a5a412c7cc58a8ed82341193a25ad382a5a416052898f8ed82341cccc7bad382a5a41150abb948ed823417fcce7ad382a5a4130e8f8968ed8234193f11fae382a5a41956c6d9c8ed8234184d2c6ae382a5a414452d69e8ed82341aaca1daf382a5a419bdaa29f8ed82341118544af382a5a41b2d100a08ed8234187d564af382a5a416d3afa9f8ed823415a4a80af382a5a41d0a9bd9f8ed82341f2159aaf382a5a41c702b39e8ed82341b19cdeaf382a5a41a96f8d9e8ed82341badef2af382a5a41a254a99e8ed82341360506b0382a5a4130951e9f8ed823417d2c18b0382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (126,'os','fémur','gauche','membre inférieur','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (127,'os','humérus','gauche','membre supérieur','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (128,'os','ulna','gauche','membre supérieur','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (129,'os','radius','gauche','membre supérieur','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (130,'os','os coxal','gauche','ceinture pelvienne','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (131,'os','patella','gauche','membre inférieur','adulte',X'00016a080000d974c2688ed8234170f3be89382a5a41985022878ed82341c7926f8d382a5a417c0600000001000000690300000001000000270000009868dd6f8ed82341d7fa218d382a5a416235ae708ed82341354f388d382a5a417e29bb718ed82341b5824c8d382a5a414de33c738ed82341c9e15f8d382a5a413cb038758ed8234177486d8d382a5a41b4ddb3778ed82341c7926f8d382a5a4121b9b37a8ed82341c09c618d382a5a41ee8f3d7e8ed8234167423e8d382a5a4171c78c818ed8234143d70c8d382a5a41e11ef1838ed82341496ed98c382a5a417a6a8e858ed82341bf04a68c382a5a41797e88868ed82341ea97748c382a5a41192f03878ed823410f25478c382a5a41985022878ed8234174a91f8c382a5a4131b709878ed823415d22008c382a5a41fd3f37868ed8234148e9798b382a5a412c5bd5858ed82341e9ed548b382a5a4192a345858ed823418329318b382a5a419b777c848ed8234143fb108b382a5a41b0356e838ed8234154c2f68a382a5a413a9fc4808ed823417720c58a382a5a418e06457f8ed823412984a28a382a5a41c8981c7e8ed8234119c0758a382a5a410583787c8ed82341f9a6258a382a5a416946dc7a8ed823416409ea89382a5a41689508798ed823415642c889382a5a4115460c778ed8234170f3be89382a5a41812ef6748ed823414dbecc89382a5a41bd24d5728ed823418e44f089382a5a41dafeb7708ed82341d027288a382a5a41e992ad6e8ed82341b109738a382a5a41fbb6c46c8ed82341d08bcf8a382a5a415fbbcc698ed823411e0a7b8b382a5a41f347fc688ed82341207ec08b382a5a41d974c2688ed82341d7b8008c382a5a411d753a698ed82341def43f8c382a5a41cc7b7f6a8ed82341cf6c828c382a5a41f1bbac6c8ed82341445bcc8c382a5a419868dd6f8ed82341d7fa218d382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (132,'os','tibia','gauche','membre inférieur','adulte',X'00016a080000d47105568ed823416bb0c26d382a5a41a9aa9b7e8ed8234160265b86382a5a417c06000000010000006903000000010000006300000064fbfe698ed8234147000686382a5a415013df6d8ed8234148ac1f86382a5a41093544708ed823416bf52986382a5a41db7ed3728ed82341c60e2f86382a5a411c8151758ed82341f0562b86382a5a4120cc82778ed82341812c1b86382a5a413ff02b798ed8234111eefa85382a5a41781ff37b8ed82341b2baa185382a5a413d83337d8ed82341b2fd7285382a5a411060247e8ed82341fb104585382a5a41a9aa9b7e8ed823416ba21985382a5a41be576f7e8ed82341e15ff284382a5a41075c757d8ed823413bf7d084382a5a413bac837b8ed823415816b784382a5a4108550f798ed82341319b9b84382a5a41fb3cb5768ed82341dcde7684382a5a41991f87748ed82341b1dc4c84382a5a4166b896728ed8234108902184382a5a41e6c2f5708ed8234138f4f883382a5a41c6dfa06e8ed823414a17b783382a5a416fe1846e8ed82341ff51f182382a5a418b51c26e8ed82341070a3280382a5a4114b012708ed82341ab0fc877382a5a41028cc3708ed8234114087875382a5a41e63be1718ed8234119571473382a5a410df28b728ed8234170821172382a5a41405542738ed8234174074b71382a5a413138ff738ed823417ca7d670382a5a41ac8e20758ed82341c6487970382a5a41433d2c768ed82341656e3370382a5a418a511d778ed82341296d0070382a5a4136781f798ed8234161d0a96f382a5a41f6aa74798ed82341c983936f382a5a41438796798ed823415db8786f382a5a41be1c26798ed82341270e546f382a5a41cf0fe9778ed823413698266f382a5a41db5d11768ed82341452ef56e382a5a414404d1738ed8234112a8c46e382a5a416d005a718ed8234158dd996e382a5a41bb4fde6e8ed82341d4a5796e382a5a4191ef8f6c8ed8234142d9686e382a5a4151dda06a8ed823415e4f6c6e382a5a412c49fe688ed8234166d8786e382a5a41055e19668ed823411d96846e382a5a41d81ceb638ed8234104e7846e382a5a41fce18a628ed82341f39d806e382a5a417e158d628ed82341c58a3a6e382a5a4190a24c628ed823413b41066e382a5a41c7d0d8618ed823412003e26d382a5a41b4e740618ed823414212cc6d382a5a41ec2e94608ed823416bb0c26d382a5a4102eee15f8ed82341671fc46d382a5a418a6c395f8ed8234101a1ce6d382a5a4116f2a95e8ed823410777e06d382a5a41c26ef15d8ed8234179920a6e382a5a41f70a5c5d8ed82341b09a396e382a5a41a3c9e85c8ed82341d3f9746e382a5a41b0d5cd5c8ed82341d1f3b86e382a5a41085a415d8ed823419ccc016f382a5a419481795e8ed8234124c84b6f382a5a413f77ac608ed823415a2a936f382a5a41bb59cb638ed82341f6430970382a5a4146dbd0658ed82341c871a770382a5a411e93f3668ed8234144945f71382a5a4180186a678ed82341e08b2372382a5a41a6026b678ed823411239e572382a5a411906ce668ed82341b7468f74382a5a41358699668ed823416a1ffd74382a5a413d210f648ed82341942c8177382a5a4111c21f638ed8234158a59578382a5a4143f66b628ed82341a47cb379382a5a414e421e628ed8234147c8cd7a382a5a41ed32ae628ed8234137a4e37c382a5a41a73e7c628ed82341818f037e382a5a41ec3bf1618ed8234108e4287f382a5a41d21833618ed82341e6254580382a5a41123a415f8ed8234194a4d282382a5a4149381e5f8ed82341c8e67083382a5a41a4199c5e8ed82341f0819783382a5a4196b0cf5d8ed8234153dcb183382a5a415f5d165b8ed823411223e283382a5a4119718a5a8ed823419236f683382a5a41a10d695a8ed8234166671384382a5a419543655a8ed82341b14d3784382a5a412e40225a8ed8234143645c84382a5a41d810ad598ed8234123458284382a5a411b6460588ed82341e6cdce84382a5a4145673b568ed82341f1923d85382a5a41d47105568ed82341f9476085382a5a416fd18b568ed823411b418285382a5a4174bea9578ed82341948da385382a5a4144713a598ed823419e3cc485382a5a41da5d19618ed8234117034286382a5a410721de628ed823412cec5686382a5a4159b986648ed8234160265b86382a5a41083a09668ed8234115fa5286382a5a414bb65b678ed82341a9af4286382a5a41584174688ed823417f8f2e86382a5a4164fbfe698ed8234147000686382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (133,'os','fibula','gauche','membre inférieur','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (134,'os','lombaire 2','axial','rachis','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (135,'os','lombaire 3','axial','rachis','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (136,'os','lombaire 4','axial','rachis','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (137,'os','thoracique 6','axial','rachis','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (138,'os','thoracique 7','axial','rachis','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (139,'os','thoracique 8','axial','rachis','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (140,'os','thoracique 9','axial','rachis','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (141,'os','cervicale 7','axial','rachis','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (142,'os','thoracique 1','axial','rachis','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (143,'os','thoracique 2','axial','rachis','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (144,'os','thoracique 5','axial','rachis','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (145,'os','thoracique 11','axial','rachis','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (146,'os','thoracique 12','axial','rachis','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (147,'os','lombaire 1','axial','rachis','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (148,'os','sternum','axial','thorax','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (149,'os','sternum','axial','thorax','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (150,'os','sternum','axial','thorax','adulte',X'00016a080000f53196088ed823417e19e1ae382a5a418f424d1a8ed82341ad7ac6b1382a5a417c0600000001000000690300000001000000300000002033a1118ed82341047cb7b1382a5a419d5aab128ed82341dc38b8b1382a5a416a4fc2168ed82341d9b1c5b1382a5a410a3d11188ed82341ad7ac6b1382a5a41a2b128198ed8234142aec1b1382a5a412b9ceb198ed82341b20fb5b1382a5a419deb3c1a8ed8234118629eb1382a5a418f424d1a8ed8234108995cb1382a5a41dd0c151a8ed8234180f30fb1382a5a41c5fec7198ed82341f7bae8b0382a5a41b6b54e198ed82341cd9ac2b0382a5a41147fa0188ed823412ad89eb0382a5a413cd91a168ed8234189a647b0382a5a410399a1158ed82341b2442eb0382a5a41c74e54158ed82341511915b0382a5a41a22f1a158ed823415fbbdfaf382a5a41a97027158ed8234131b47eaf382a5a4147a012158ed823417bec60af382a5a41592ae2148ed82341816246af382a5a41d50791148ed8234167982eaf382a5a41b1311a148ed82341501019af382a5a41e3a078138ed823415f4c05af382a5a41614ea7128ed82341b8cef2ae382a5a412033a1118ed823417e19e1ae382a5a4173c03e118ed823417e19e1ae382a5a41ca5d34108ed82341b8cef2ae382a5a414209610f8ed823415f4c05af382a5a414734bf0e8ed82341501019af382a5a414150490e8ed8234167982eaf382a5a419ccef90d8ed82341816246af382a5a411bb8b70d8ed8234131b47eaf382a5a410dacc50d8ed823415fbbdfaf382a5a41a3a58b0d8ed82341511915b0382a5a410d603e0d8ed82341b2442eb0382a5a417e20c50c8ed8234189a647b0382a5a415e783f0a8ed823412ad89eb0382a5a41674591098ed82341cd9ac2b0382a5a41f9fe17098ed82341f7bae8b0382a5a41a4f2ca088ed8234180f30fb1382a5a41fb6da1088ed823413eff36b1382a5a41f53196088ed82341b37b7fb1382a5a41bd15a3088ed8234118629eb1382a5a41ea60f4088ed82341b20fb5b1382a5a414449b7098ed8234142aec1b1382a5a4116bdce0a8ed82341ad7ac6b1382a5a41abaa1d0c8ed82341d9b1c5b1382a5a41e79c34108ed82341dc38b8b1382a5a412033a1118ed82341047cb7b1382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (151,'os','thoracique 4','axial','rachis','adulte',X'00016a080000275975e88fd82341b838c5c8382a5a419916a11f90d82341a28288d0382a5a417c06000000010000006903000000020000007b00000062620b0490d82341c8cf82d0382a5a419abd4e0590d82341a28288d0382a5a41acc8050690d82341e48085d0382a5a41c2abb70690d82341e1647bd0382a5a4113bb4a0790d82341726467d0382a5a41d64aa50790d8234171b546d0382a5a4140afad0790d82341b78d16d0382a5a41b5a07c0790d823419e6d9acf382a5a411ab28e0790d82341ba8e58cf382a5a41dfbacc0790d823418cc117cf382a5a413668420890d82341c8badace382a5a415267fb0890d82341222fa4ce382a5a416465030a90d8234150d376ce382a5a41a00f660b90d82341055c55ce382a5a41d790ef0c90d82341181c40ce382a5a41429c5f0e90d82341524534ce382a5a41e7dead0f90d82341b6d02fce382a5a41f9bdc31190d8234108f234ce382a5a416510171390d82341895541ce382a5a4154841c1690d8234178dd79ce382a5a41ac4adb1990d82341081eb3ce382a5a4120c5a91b90d82341390bc6ce382a5a410f602a1d90d823419d95cbce382a5a4133282b1e90d82341a38cbece382a5a4176ab531f90d8234187a892ce382a5a4120a69f1f90d82341d9bd7cce382a5a419916a11f90d82341bb1364ce382a5a41b738441f90d82341ea9646ce382a5a415248751e90d82341243422ce382a5a414081201d90d8234124d8f4cd382a5a41581f321b90d82341a86fbccd382a5a4106c23c1990d8234181739ccd382a5a41f3d5141890d82341992685cd382a5a41e147e71690d82341368468cd382a5a41815ad71590d82341b82347cd382a5a418450081590d823417e9c21cd382a5a419b6c9d1490d82341e685f8cc382a5a413338191490d823417602edcc382a5a4143d4571390d823419bf0e1cc382a5a4165df701290d8234165aedecc382a5a4195ccfb1190d82341f8cce2cc382a5a41f64b651290d8234199f7aecc382a5a4188987a1290d82341632e8dcc382a5a416cfd621290d82341c33867cc382a5a4132b2071290d8234182893fcc382a5a416aee511190d82341669318cc382a5a41a4e92a1090d8234136c9f4cb382a5a410f46fb1090d82341d0feedcb382a5a41a29bca1190d82341afa2e0cb382a5a410e7faf1290d823415d4dc8cb382a5a410787861390d8234171bfa1cb382a5a41404a2c1490d823417cb969cb382a5a416d5f7d1490d8234112fc1ccb382a5a41435d561490d82341c847b8ca382a5a4130bda41390d82341e01a4cca382a5a41e5ba761290d823411a93ebc9382a5a412b6cd91090d823419e6897c9382a5a41c9e6d90e90d82341925350c9382a5a418840850c90d823411b0c17c9382a5a41318fe80990d82341604aecc8382a5a418de8100790d8234188c6d0c8382a5a4162620b0490d82341b838c5c8382a5a415aa6050190d8234188c6d0c8382a5a414eda2dfe8fd82341604aecc8382a5a41281391fb8fd823411b0c17c9382a5a41d4653cf98fd82341925350c9382a5a413ce73cf78fd823419e6897c9382a5a414bac9ff58fd823411a93ebc9382a5a41edc971f48fd82341e01a4cca382a5a410b55c0f38fd82341c847b8ca382a5a417e2899f38fd8234112fc1ccb382a5a41f329eaf38fd823417cb969cb382a5a41dfea8ff48fd8234171bfa1cb382a5a41b7fc66f58fd823415d4dc8cb382a5a41f2f04bf68fd82341afa2e0cb382a5a4104591bf78fd82341d0feedcb382a5a4185caebf78fd8234136c9f4cb382a5a4122c5c4f68fd82341669318cc382a5a41e4000ff68fd8234182893fcc382a5a4156b5b3f58fd82341c33867cc382a5a41011a9cf58fd82341632e8dcc382a5a417166b1f58fd8234199f7aecc382a5a41b9e51af68fd82341f8cce2cc382a5a4136d8a5f58fd8234165aedecc382a5a4128e6bef48fd823419bf0e1cc382a5a41f97efdf38fd823417602edcc382a5a41b34579f38fd82341e685f8cc382a5a41f6370ef38fd823417e9c21cd382a5a41b81b3ff28fd82341b82347cd382a5a411d2e2ff18fd82341368468cd382a5a414aac01f08fd82341992685cd382a5a4165d3d9ee8fd8234181739ccd382a5a41c0a1e4ec8fd82341a86fbccd382a5a41d110f6ea8fd8234124d8f4cd382a5a419931a1e98fd82341243422ce382a5a414e38d2e88fd82341ea9646ce382a5a41275975e88fd82341bb1364ce382a5a415ac876e88fd82341d9bd7cce382a5a411fbac2e88fd8234187a892ce382a5a4135f6eae98fd82341a38cbece382a5a4134f4ebea8fd823419d95cbce382a5a41e9b76cec8fd82341390bc6ce382a5a41dd4f3bee8fd82341081eb3ce382a5a41b236faf18fd8234178dd79ce382a5a4160b4fff48fd82341895541ce382a5a41a8e552f68fd8234108f234ce382a5a41dbc268f88fd82341b6d02fce382a5a412b1fb7f98fd82341524534ce382a5a411e5f27fb8fd82341181c40ce382a5a419336b1fc8fd82341055c55ce382a5a41908913fe8fd8234150d376ce382a5a412c4f1bff8fd82341222fa4ce382a5a41642cd4ff8fd82341c8badace382a5a4134c6490090d823418cc117cf382a5a419ac1870090d82341ba8e58cf382a5a4191c3990090d823419e6d9acf382a5a41286f680090d82341b78d16d0382a5a41b8da700090d8234171b546d0382a5a41537dcb0090d82341726467d0382a5a4149a75e0190d82341e1647bd0382a5a41eba8100290d82341e48085d0382a5a4187d2c70290d82341a28288d0382a5a4162620b0490d82341c8cf82d0382a5a4131000000b748ce0090d8234109b3c5cb382a5a41ebddc40190d8234151b9b9cb382a5a412c20230390d823412e0db4cb382a5a41966ef30490d823412e0db4cb382a5a41e774510690d8234151b9b9cb382a5a418409480790d8234109b3c5cb382a5a41ab2be60890d82341f54cf0cb382a5a415f4b590990d823416947f8cb382a5a418485350a90d82341635a00cc382a5a417ef11e0b90d82341653c01cc382a5a41979ba90a90d8234192a321cc382a5a413ee4810a90d82341f9a943cc382a5a41b56e9e0a90d8234108f361cc382a5a41c180e60a90d82341e68d7ccc382a5a41229ecc0b90d82341c6e0b6cc382a5a414088cb0b90d823414d5ac3cc382a5a41d0567a0b90d823415a71cccc382a5a4157c75f0a90d823414731e0cc382a5a4199e5b80990d823414236f3cc382a5a41e7586a0990d82341e24c05cd382a5a4193c8580990d82341bf4116cd382a5a41f88a800990d82341a65340cd382a5a414975510990d823415bbf4acd382a5a4115178e0890d82341744a61cd382a5a41ba5f6c0790d823411e007ecd382a5a41a4bdee0690d8234127da85cd382a5a4154b6cb0590d8234150c38ccd382a5a4162620b0490d8234181918dcd382a5a41fd47ad0190d82341f97d8acd382a5a415f93270190d8234127da85cd382a5a4171cc240090d82341211872cd382a5a41d93ec5fe8fd823415bbf4acd382a5a41942d96fe8fd82341a65340cd382a5a419fdebdfe8fd82341bf4116cd382a5a41b43aacfe8fd82341e24c05cd382a5a41b5915dfe8fd823414236f3cc382a5a41de89b6fd8fd823414731e0cc382a5a416bc99bfc8fd823415a71cccc382a5a410dcd4afc8fd823414d5ac3cc382a5a41ddde49fc8fd82341c6e0b6cc382a5a413f3430fd8fd82341e68d7ccc382a5a41a34978fd8fd8234108f361cc382a5a41a1d294fd8fd82341f9a943cc382a5a41b7166dfd8fd8234192a321cc382a5a41ea2cf7fc8fd82341653c01cc382a5a419de8e0fd8fd82341635a00cc382a5a41d656bdfe8fd823416947f8cb382a5a41c18530ff8fd82341f54cf0cb382a5a41b748ce0090d8234109b3c5cb382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (152,'os','cervicale 1','axial','rachis','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (153,'os','thoracique 10','axial','rachis','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (154,'os','cervicale 2','axial','rachis','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (155,'os','cervicale 3','axial','rachis','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (156,'os','cervicale 4','axial','rachis','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (157,'os','cervicale 5','axial','rachis','adulte',X'00016a080000f1350c648fd82341242b41c8382a5a41855914a28fd8234138d8b0ce382a5a417c0600000001000000690300000002000000810000000c2127838fd823414d0a4dce382a5a413ac0b0848fd82341a18f4dce382a5a4131015d858fd823419be254ce382a5a41e2701a868fd82341da008ece382a5a4112c47a868fd823415b4fa0ce382a5a414e51f3868fd823412e2badce382a5a41b3c884878fd8234138d8b0ce382a5a415cda2f888fd823415f9aa7ce382a5a416636f5888fd8234188b58dce382a5a411aa387898fd82341e9956bce382a5a411654b8898fd823414dc349ce382a5a4175e8aa898fd82341bd90f8cd382a5a41a4fec7898fd8234195f6c1cd382a5a41afbe398a8fd823410a357dcd382a5a41fac12d8b8fd8234103af26cd382a5a411a62b98e8fd8234146b241cc382a5a41e6412d8f8fd8234195971bcc382a5a41cd7a5a8f8fd82341865601cc382a5a41c1e07e8f8fd82341d1b00dcc382a5a410376c68f8fd82341c81416cc382a5a41707b45908fd8234150a71dcc382a5a41ec670b918fd82341e7ff21cc382a5a415ab227928fd823410bb620cc382a5a419bd1a9938fd82341386117cc382a5a41943ca1958fd82341ec9803cc382a5a410606c4978fd82341de3be7cb382a5a41061fb7998fd8234119e5c6cb382a5a416aa76f9b8fd82341323ca4cb382a5a410abfe29c8fd82341c0e880cb382a5a41bb85059e8fd8234159925ecb382a5a41541bcd9e8fd8234193e03ecb382a5a41aa9f2e9f8fd82341047b23cb382a5a4195321f9f8fd8234142090ecb382a5a41d4fbe59e8fd8234195c2fcca382a5a412de5999e8fd82341cabacfca382a5a41488b6c9e8fd823411e8cc2ca382a5a4172471b9e8fd82341550fb6ca382a5a41678c969d8fd82341cb22aaca382a5a41e5ccce9c8fd82341d9a49eca382a5a4123a6819d8fd82341a4787aca382a5a41e93c679e8fd8234106c658ca382a5a41dca0af9f8fd8234113e836ca382a5a41e21c6ba18fd82341417f13ca382a5a418c10d5a18fd82341d84c06ca382a5a416b3e12a28fd82341d9f4f6c9382a5a41855914a28fd823418d98e4c9382a5a41e214cda18fd823413e59cec9382a5a41a4631ca08fd823418f1688c9382a5a41e6a0619f8fd82341b64e63c9382a5a41ddac339e8fd82341ae1617c9382a5a410544cd9d8fd82341c17a07c9382a5a41fc0a3a9d8fd82341fefafbc8382a5a417da55f9c8fd82341441ef4c8382a5a41d1a74e998fd8234166e2e5c8382a5a4184aaaa968fd823411b3ee1c8382a5a41755772948fd8234148d2e3c8382a5a418358a4928fd82341d13febc8382a5a418e573f918fd823419b27f5c8382a5a4155eb788f8fd823416a050ac9382a5a41abe5d68d8fd823416038d1c8382a5a419cb5888c8fd82341e931afc8382a5a419f6fd38a8fd823413ef88bc8382a5a4100aeb3888fd82341155a6bc8382a5a410b0b26868fd82341252651c8382a5a410c2127838fd82341242b41c8382a5a414aeefa7f8fd82341252651c8382a5a419e376d7d8fd82341155a6bc8382a5a416d734d7b8fd823413ef88bc8382a5a41de3698798fd82341e931afc8382a5a4118174a788fd823416038d1c8382a5a410038a8768fd823416a050ac9382a5a41fd75e1748fd823419b27f5c8382a5a416a497c738fd82341d13febc8382a5a41c825ae718fd8234148d2e3c8382a5a41a3bd756f8fd823411b3ee1c8382a5a4183c3d16c8fd8234166e2e5c8382a5a41f2e9c0698fd82341441ef4c8382a5a41848ae6688fd82341fefafbc8382a5a41376053688fd82341c17a07c9382a5a419209ed678fd82341ae1617c9382a5a41ee2cbf668fd82341b64e63c9382a5a41425604668fd823418f1688c9382a5a418f7a53648fd823413e59cec9382a5a41f1350c648fd823418d98e4c9382a5a411a510e648fd82341d9f4f6c9382a5a41167f4b648fd82341d84c06ca382a5a41f072b5648fd82341417f13ca382a5a4128f070668fd8234113e836ca382a5a41dc53b9678fd8234106c658ca382a5a4116ea9e688fd82341a4787aca382a5a418bc251698fd82341d9a49eca382a5a4148078a688fd82341cb22aaca382a5a41424e05688fd82341550fb6ca382a5a41bd0ab4678fd823411e8cc2ca382a5a4101b086678fd82341cabacfca382a5a4145953a678fd8234195c2fcca382a5a416f5e01678fd8234142090ecb382a5a41941bf2668fd82341047b23cb382a5a417bb553678fd8234193e03ecb382a5a41e2521b688fd8234159925ecb382a5a418b1a3e698fd82341c0e880cb382a5a413533b16a8fd82341323ca4cb382a5a41a2c3696c8fd8234119e5c6cb382a5a4190f25c6e8fd82341de3be7cb382a5a41c1e67f708fd82341ec9803cc382a5a41ab4777728fd82341386117cc382a5a419654f9738fd823410bb620cc382a5a415c8715758fd82341e7ff21cc382a5a41d759db758fd8234150a71dcc382a5a41e1455a768fd82341c81416cc382a5a4155c5a1768fd82341d1b00dcc382a5a411225c6768fd82341865601cc382a5a418e90f3768fd8234195971bcc382a5a415d5467778fd8234146b241cc382a5a41626af27a8fd8234103af26cd382a5a416392e67b8fd823410a357dcd382a5a41c66c587c8fd8234195f6c1cd382a5a41b294757c8fd82341bd90f8cd382a5a41bb39687c8fd823414dc349ce382a5a4123ed987c8fd82341e9956bce382a5a41ac5a2b7d8fd8234188b58dce382a5a412c8cf07d8fd823415f9aa7ce382a5a41b7899b7e8fd8234138d8b0ce382a5a413ffe2c7f8fd823412e2badce382a5a41b794a57f8fd823415b4fa0ce382a5a4112f805808fd82341da008ece382a5a41d898c3808fd823419be254ce382a5a41810470818fd82341a18f4dce382a5a410c2127838fd823414d0a4dce382a5a4129000000de6734858fd82341f4be6ecc382a5a410c2127838fd823411cfb6acc382a5a41f765ec808fd82341f4be6ecc382a5a41632e28808fd82341f3e36bcc382a5a418a4ff67e8fd82341d1135ecc382a5a412272377c8fd82341cb5619cc382a5a4153ea45798fd82341f6ded7cb382a5a41f7ef46788fd823416b3c83cb382a5a415e8fe9768fd8234192c51dcb382a5a41bb762a768fd82341a52aefca382a5a414e0e71758fd823410027cbca382a5a4169cec9748fd82341da9bb7ca382a5a41b176c9758fd82341644ea9ca382a5a41d44ff5768fd8234150d490ca382a5a4132627a778fd823414a7380ca382a5a41ce79db778fd8234185766dca382a5a41b20706788fd823412ffb57ca382a5a41698da5788fd82341f30965ca382a5a4198aeb6798fd8234116fd72ca382a5a41ec83417b8fd8234130c27aca382a5a4140443e7d8fd823415c8875ca382a5a410c2127838fd823414c9959ca382a5a41ed18e2888fd823415c8875ca382a5a41f97dde8a8fd8234130c27aca382a5a41bd7b698c8fd8234116fd72ca382a5a413bd37a8d8fd82341f30965ca382a5a41bd871a8e8fd823412ffb57ca382a5a41a215458e8fd8234185766dca382a5a413e2da68e8fd823414a7380ca382a5a419b3f2b8f8fd8234150d490ca382a5a41bf1857908fd82341644ea9ca382a5a4107c156918fd82341da9bb7ca382a5a412281af908fd823410027cbca382a5a41b518f68f8fd82341a52aefca382a5a411200378f8fd8234192c51dcb382a5a41799fd98d8fd823416b3c83cb382a5a411da5da8c8fd82341f6ded7cb382a5a414e1de9898fd82341cb5619cc382a5a41b3472a878fd82341d1135ecc382a5a412885f8858fd82341f3e36bcc382a5a41de6734858fd82341f4be6ecc382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (162,'os','denture','axial','crâne','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (165,'os','trapèze','droit','membre supérieur','adulte',X'00016a080000279d7cba8cd82341eeb370a2382a5a416543e9cb8cd82341a428dea4382a5a417c0600000001000000690300000001000000290000002626fec98cd8234109c046a3382a5a41f0f926ca8cd82341f6450ea3382a5a413c6c22ca8cd8234197beeca2382a5a416d18fec98cd82341d85ccaa2382a5a41ee60acc98cd82341e406aba2382a5a412ca81fc98cd82341e9a292a2382a5a4193504ac88cd82341141785a2382a5a4152e22fc68cd82341eeb370a2382a5a4194e5ebc58cd82341f8ef73a2382a5a41b9d99ac58cd823411f7c7da2382a5a413a05b9c38cd823413b8ac7a2382a5a41b4986fc18cd823415d4c0da3382a5a4166c425c08cd823413bcb2aa3382a5a416db636bf8cd82341afb03aa3382a5a4141a2d5be8cd82341227a3da3382a5a416d1f7dbd8cd823413eeb3ca3382a5a41885887bc8cd82341e1ff43a3382a5a41421d10bc8cd82341be3d4ea3382a5a4168c79fba8cd8234104d486a3382a5a41279d7cba8cd823415e9a8ea3382a5a413bc27dba8cd82341cb1896a3382a5a41bb3108bb8cd82341df31aaa3382a5a41fc3d7bbe8cd82341352a09a4382a5a41dd710fc08cd8234153fd3da4382a5a41ab4e59c08cd82341f3e74aa4382a5a41692facc18cd823419f1fb7a4382a5a41f4a039c28cd823411b36d0a4382a5a412ed6e6c28cd82341a428dea4382a5a41a958b8c38cd82341efc9dba4382a5a41f7b1b2c48cd82341b2ecc3a4382a5a41f2c496c68cd82341a12b63a4382a5a41ddbd2dca8cd823412fa432a4382a5a4102ed50cb8cd823416b871aa4382a5a4129b19fcb8cd8234115b70ca4382a5a4166cbd3cb8cd82341ee4afaa3382a5a416543e9cb8cd82341ebc1e3a3382a5a41d120dccb8cd82341079bc9a3382a5a41556ba8cb8cd823413a55aca3382a5a419d2a4acb8cd823417a6f8ca3382a5a415466bdca8cd82341c2686aa3382a5a412626fec98cd8234109c046a3382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (166,'os','trapézoïde','droit','membre supérieur','adulte',X'00016a0800002ab2fcce8cd8234103cd38a2382a5a415204dfd88cd823415a8aaca3382a5a417c060000000100000069030000000100000022000000842456d48cd823415bf174a2382a5a410f09e5d28cd82341e2206ea2382a5a41a109ddd18cd823410b1063a2382a5a41aabf7ed18cd823413bdf5aa2382a5a415ce41ed18cd82341ffd845a2382a5a414926bfd08cd82341c2563da2382a5a416b4c45d08cd8234103cd38a2382a5a415055c6cf8cd8234124ef39a2382a5a41883f57cf8cd82341857042a2382a5a41a1090dcf8cd82341850454a2382a5a412ab2fcce8cd82341855e70a2382a5a4192db4bd08cd82341f01844a3382a5a418f4096d08cd82341cb385ba3382a5a41765708d18cd8234125a670a3382a5a41d94cb0d18cd823411c3b85a3382a5a4145d781d28cd823411ea596a3382a5a414f0061d38cd823413287a2a3382a5a41d4dc23d58cd823415a8aaca3382a5a419967f5d58cd82341d516aca3382a5a4165504bd78cd823411bd2a3a3382a5a41b885bdd78cd823414c6c9da3382a5a419a7711d88cd823415fa993a3382a5a418fcb57d88cd82341c7bb84a3382a5a416c8190d88cd8234130b371a3382a5a412a12d9d88cd82341ba8f43a3382a5a415204dfd88cd823411bab9fa2382a5a416f31c0d88cd82341946263a2382a5a41ce5c87d88cd82341332f4ea2382a5a41d68d24d88cd8234105eb42a2382a5a415cfe8cd78cd82341009144a2382a5a4152ca21d78cd823413db840a2382a5a415862cbd68cd82341aa8341a2382a5a4193c1cbd58cd8234119bd4ea2382a5a41842456d48cd823415bf174a2382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (167,'os','scaphoïde','droit','membre supérieur','adulte',X'00016a08000011fcfdca8cd82341f0ed4da4382a5a419dffacdc8cd82341f0a2d9a6382a5a417c0600000001000000690300000001000000220000007e5f36d98cd82341b8ad72a5382a5a4100c4bed88cd82341c11938a5382a5a41a67769d88cd823410520fda4382a5a41a9013ed88cd8234107c2c8a4382a5a414e5e5dd88cd823412e709aa4382a5a417a3e32d88cd823417f5c7ea4382a5a4163e0edd78cd82341c22172a4382a5a41edf77ed78cd8234136f567a4382a5a416a04ddd68cd82341f17960a4382a5a41a36a30d38cd82341856f4fa4382a5a414c8b55d28cd82341f0ed4da4382a5a417f0786d18cd82341243f51a4382a5a411d70c2d08cd82341ba715ba4382a5a4107560bd08cd823414a946ea4382a5a414d0f9dce8cd82341963cb0a4382a5a41689fdbcb8cd823419dd914a5382a5a411de03ccb8cd82341d9d135a5382a5a4111fcfdca8cd82341613757a5382a5a416c8b41cb8cd823416c7779a5382a5a4152262acc8cd823412fff9ca5382a5a4124cca4ce8cd82341d690e6a5382a5a41894dd2d08cd82341e6ba2ca6382a5a411e9d77d28cd82341038967a6382a5a417cad59d38cd82341d3068fa6382a5a41b630f9d38cd8234136c9a0a6382a5a415c0f40d58cd823416cf1b6a6382a5a41e12deed68cd8234173aecba6382a5a41b870c3d88cd823414a2fd9a6382a5a4152bc7fda8cd82341f0a2d9a6382a5a4123f5e2db8cd823416238c7a6382a5a419dffacdc8cd823419e1e9ca6382a5a4133c09ddc8cd82341a48452a6382a5a41bb7b09db8cd82341be59f1a5382a5a417e5f36d98cd82341b8ad72a5382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (168,'os','capitatum','droit','membre supérieur','adulte',X'00016a080000d5b775dd8cd8234196443ba2382a5a414c9141ec8cd82341f56002a5382a5a417c06000000010000006903000000010000002f000000324c0ee78cd823418c228da2382a5a414e442ae58cd82341baf896a2382a5a41649fb4e38cd823412ecf94a2382a5a4123621ce38cd82341b6bd8da2382a5a41ccf6c8e18cd82341d8355fa2382a5a41325323e18cd823414b7c4fa2382a5a41271170e08cd82341360643a2382a5a411bcfbcdf8cd82341a1ab3ba2382a5a41812b17df8cd8234196443ba2382a5a41cac48cde8cd823411fa943a2382a5a41d4afe7dd8cd82341944568a2382a5a417fa9b0dd8cd823414a956ea2382a5a41d5b775dd8cd823417b1a6ea2382a5a418b0ca5de8cd823416629fda2382a5a41055c21e08cd82341bba961a3382a5a41d8746ae08cd82341bc0a80a3382a5a4153687be08cd82341d14ea4a3382a5a418ea042e08cd82341f4edd2a3382a5a419f87aedf8cd82341206010a4382a5a4144a393de8cd82341fc5572a4382a5a41bcdd5bde8cd823411e138aa4382a5a411fb05bde8cd82341170997a4382a5a410bf691de8cd823416dc19da4382a5a41f24a9ddf8cd823414d9faaa4382a5a41019736e38cd82341c7b5f0a4382a5a4101f519e48cd823417a61fca4382a5a4138faf1e48cd82341f56002a5382a5a4159afbae58cd82341294901a5382a5a411a1d70e68cd8234107aff7a4382a5a41324c0ee78cd823418127e4a4382a5a4180024fe88cd82341bc13aba4382a5a41f6d0eae88cd82341efb688a4382a5a41ec636be98cd82341b51762a4382a5a411b95bee98cd82341b3ed36a4382a5a413b3ed2e98cd823418df006a4382a5a41033994e98cd82341e5d7d1a3382a5a412e5ff2e88cd82341615b97a3382a5a41c1524bea8cd82341a15959a3382a5a4147a742eb8cd82341a6d61ca3382a5a4112689beb8cd82341bc29fca2382a5a414c9141ec8cd82341ac3f7da2382a5a41efc42cec8cd82341c7d971a2382a5a41b7c6e3eb8cd8234124566ca2382a5a41d0b456eb8cd82341b0336da2382a5a415135bbe88cd82341ee7c85a2382a5a41e4b4b1e78cd82341be628ca2382a5a41324c0ee78cd823418c228da2382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (169,'os','hamatum','droit','membre supérieur','adulte',X'00016a08000054e9f8ec8cd823414c604ea2382a5a4101c58c068dd82341808757a4382a5a417c0600000001000000690300000001000000350000006c8e72fa8cd82341d2e7a9a2382a5a41630571f98cd82341515c84a2382a5a411699baf88cd8234120656fa2382a5a41dda7f2f78cd82341ca1c61a2382a5a41dcb26af78cd8234189185ca2382a5a41da7325f68cd823415ef355a2382a5a410e10cef48cd82341c87655a2382a5a418216a4f38cd823418a345ba2382a5a41e5ecf6f28cd823411aa263a2382a5a41f846c4f28cd82341172971a2382a5a41f467f4f28cd82341aada0aa3382a5a41a919cef28cd82341587032a3382a5a412b0203f28cd8234109a25ca3382a5a419fc1ebf08cd8234173c2a8a3382a5a41fa0a7cee8cd82341d6b4f6a3382a5a414939b5ed8cd82341486c13a4382a5a41252227ed8cd82341b4702ea4382a5a4154e9f8ec8cd8234111c844a4382a5a419db251ed8cd82341587853a4382a5a41c9a158ee8cd82341808757a4382a5a41136afcef8cd82341e1ff50a4382a5a41a86bf6f18cd82341401843a4382a5a41e0b949f68cd8234147f817a4382a5a41175651f88cd823419827fea3382a5a41c3ca0bfa8cd8234135c6e3a3382a5a41ae3f50fb8cd82341f487caa3382a5a41a3dcf5fb8cd82341a820b4a3382a5a4122b08bfc8cd8234198bc96a3382a5a41e1af3cfd8cd8234139108ca3382a5a414d1e24fe8cd8234101dc8da3382a5a41aa363f008dd82341e4479aa3382a5a41a02264018dd823410fd49da3382a5a414c32f3038dd82341b6f49ea3382a5a412d851b058dd8234158d69aa3382a5a41882903068dd82341f47692a3382a5a41f23689068dd823411cfd84a3382a5a4101c58c068dd82341658f71a3382a5a41f8e35f068dd82341e4385ea3382a5a41167962068dd82341c6253ba3382a5a41edc23f068dd82341490430a3382a5a411d9e32058dd8234197d70da3382a5a414fd8e2028dd8234165b6d2a2382a5a416fd2ed018dd82341e4bbb3a2382a5a411ec203008dd82341621b6aa2382a5a4120ae84ff8cd823419bb95ca2382a5a415e0b01ff8cd823410d4957a2382a5a41be3b6bfe8cd823418a345ba2382a5a4107ac8ffd8cd82341016b4fa2382a5a416a2200fd8cd823414c604ea2382a5a4122715efc8cd8234154db53a2382a5a4180ceb4fb8cd8234131e862a2382a5a41d3700dfb8cd82341fd927ea2382a5a416c8e72fa8cd82341d2e7a9a2382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (170,'os','triquetrum','droit','membre supérieur','adulte',X'00016a080000260980f58cd82341eaea16a4382a5a41668a09058dd82341c1e438a6382a5a417c06000000010000006903000000010000002800000027dd79028dd82341fbe860a4382a5a415fb4f7018dd823416a4f3aa4382a5a4145089a018dd82341433328a4382a5a41a0f127018dd82341e8e91aa4382a5a417646a4008dd82341eaea16a4382a5a41ccdc11008dd82341daad20a4382a5a41ab8a73ff8cd8234149aa3ca4382a5a4138c6c5fd8cd82341e664b6a4382a5a41c2c85bfd8cd823419325cca4382a5a417d79d1fc8cd82341f722dfa4382a5a412d6516fc8cd82341d4b7efa4382a5a4195181afb8cd82341e83efea4382a5a41d89fe9f78cd82341cdbd1aa5382a5a413b0b32f78cd82341e7132ea5382a5a4149b5c0f68cd8234163d240a5382a5a41f820e3f58cd82341bda76ca5382a5a41fbe19cf58cd82341ae4c82a5382a5a41260980f58cd82341148498a5382a5a41815d97f58cd82341a9deafa5382a5a4115a6edf58cd8234125edc8a5382a5a41e9a98df68cd823413d40e4a5382a5a41063082f78cd82341ac6802a6382a5a4171158ef88cd82341e8701da6382a5a41d23976f98cd82341643f2fa6382a5a41f9cb48fa8cd823418a4138a6382a5a41b8fa13fb8cd82341c1e438a6382a5a41e0f4e5fb8cd82341719631a6382a5a4141e9ccfc8cd8234102c422a6382a5a41ef1759008dd823415fc1d5a5382a5a41133d7a018dd82341f9f2c3a5382a5a41bf9df1038dd82341979ba8a5382a5a41cfa171048dd82341c26f9fa5382a5a412c8cc6048dd8234197dc91a5382a5a4138d001058dd8234154a962a5382a5a41668a09058dd82341a95f24a5382a5a41651ee9048dd82341bc4001a5382a5a412f20a2048dd8234169dcdba4382a5a41a5c629048dd82341ae7bb4a4382a5a41ac4875038dd823418a678ba4382a5a4127dd79028dd82341fbe860a4382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (171,'os','pisiforme','droit','membre supérieur','adulte',X'00016a080000a6aae1fe8cd8234173a20ca6382a5a41a4a7f50a8dd82341a8dd7da7382a5a417c060000000100000069030000000100000022000000489318028dd823412a5461a6382a5a41deeb20018dd823413aca4fa6382a5a41fe358f008dd82341c8e549a6382a5a413e3dfbff8cd8234144d348a6382a5a41e79876ff8cd82341947a4fa6382a5a4146e012ff8cd823419dc360a6382a5a41a6aae1fe8cd8234147967fa6382a5a41527be2fe8cd823414926a1a6382a5a41c5a503ff8cd823410022baa6382a5a415da63cff8cd82341fdbbcca6382a5a417abd64008dd82341f34503a7382a5a41b361c9008dd82341f62b2ea7382a5a4128b91c018dd82341b75745a7382a5a41f7ac8e018dd8234165ab5aa7382a5a4172ad1e028dd823415f616ca7382a5a41ea2acc028dd8234100b478a7382a5a41b39596038dd82341a8dd7da7382a5a411d5e7d048dd82341b2187aa7382a5a417bf47f058dd823417c9f6ba7382a5a41beb177078dd82341297e3da7382a5a41c59b0b098dd8234152d00aa7382a5a415c6d200a8dd82341e4a7dca6382a5a414fe19a0a8dd82341cd16bca6382a5a41f429d80a8dd823410d5d91a6382a5a41a4a7f50a8dd823417f3852a6382a5a41e633d20a8dd82341303534a6382a5a4140df780a8dd8234101261ca6382a5a414f5ada098dd823418eba0da6382a5a41ae55e7088dd8234173a20ca6382a5a410ee1d3078dd8234184fe15a6382a5a41ef1adb068dd823419c3f23a6382a5a41889c9c038dd823418dc55ba6382a5a41b395dc028dd8234140eb61a6382a5a41489318028dd823412a5461a6382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (172,'os','lunatum','droit','membre supérieur','adulte',X'00016a080000083725e28cd823419dcea5a5382a5a41fe6a1af48cd82341fcc9d7a7382a5a417c06000000010000006903000000010000002400000020989eee8cd823412e82faa5382a5a41322f67ed8cd82341e71bdea5382a5a41f1bb7feb8cd82341fef0bda5382a5a414ee04fea8cd82341887bb0a5382a5a41358402e98cd8234179b4a7a5382a5a4151989fe78cd823419dcea5a5382a5a41706afee48cd82341d4c3aea5382a5a415a3fe8e38cd82341cfc1b7a5382a5a4172ab09e38cd8234172cbc4a5382a5a412f2a6fe28cd82341caa7d6a5382a5a41083725e28cd82341e71deea5382a5a41734d38e28cd82341d4f40ba6382a5a41e6e8b4e28cd82341a2f330a6382a5a416b94f2e38cd8234162d36da6382a5a4173e424e58cd82341368497a6382a5a41dfa57fe58cd82341f1afaca6382a5a41cbbb88e58cd823414d0b53a7382a5a411280c1e58cd823417d1367a7382a5a410f9b94e68cd823415dee81a7382a5a41015d61e88cd82341dc21a8a7382a5a414d7695e98cd82341ed72bca7382a5a416fbac6ea8cd823412997cba7382a5a41de52f2eb8cd82341c6ead4a7382a5a410e6915ed8cd82341fcc9d7a7382a5a4173262dee8cd823410191d3a7382a5a4182b436ef8cd823410e9cc7a7382a5a41b03c2ff08cd823415947b3a7382a5a4170e813f18cd823411aef95a7382a5a41c1effef18cd8234181326da7382a5a419660edf28cd823419a9a39a7382a5a41fcb5b0f38cd823410a0effa6382a5a41fe6a1af48cd823417873c1a6382a5a41aafafbf38cd823418cb184a6382a5a410be026f38cd82341ecae4ca6382a5a412f966cf18cd8234140521da6382a5a4120989eee8cd823412e82faa5382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (173,'os','métacarpien','gauche','membre supérieur','adulte',X'00016a08000007f8283f8fd823418a73a59b382a5a4187bff3618fd823418ca9be9f382a5a417c060000000100000069030000000100000033000000e95193458fd82341fdba279e382a5a4175e65e438fd82341adc31e9e382a5a41dc781e428fd823411adf1e9e382a5a41c700e6408fd82341b6f3249e382a5a4173f4e13f8fd8234141a9339e382a5a411eca3e3f8fd823417ba74d9e382a5a4107f8283f8fd823412596759e382a5a414e0d8c3f8fd82341983dba9e382a5a413933ef3f8fd82341f2c0d79e382a5a41fa523b408fd82341feacde9e382a5a41e4b2ba458fd823418f78269f382a5a413be86e488fd82341641b4e9f382a5a4105f28f498fd82341436b629f382a5a414053694a8fd823418f65769f382a5a414791494b8fd823412ecd9b9f382a5a4195a4f74b8fd82341a111ac9f382a5a41cd76dd4c8fd823415f5ab89f382a5a41e06eec4d8fd823418ca9be9f382a5a41bff3154f8fd823414e01bd9f382a5a415a6c4b508fd82341c963b19f382a5a41a33f7e518fd8234123d3999f382a5a418ad49f528fd823418151749f382a5a4131f882538fd823412680489f382a5a410fe015548fd82341a62c1f9f382a5a41b26e44558fd82341d0718f9e382a5a416a1fca558fd823411112709e382a5a41d5a7c95d8fd823415d91399d382a5a41c5580c5f8fd823411ac40b9d382a5a41e1df12618fd823414ec6ca9c382a5a41f04690618fd82341e928b39c382a5a41cbdde1618fd82341a0e4979c382a5a4187bff3618fd823419ea4789c382a5a413807b2618fd823411214559c382a5a41f5cf08618fd8234129de2c9c382a5a41d134e45f8fd8234110aeff9b382a5a4195985d5e8fd82341ea37d69b382a5a41f9c8ad5c8fd82341f45bb99b382a5a41dfa7f05a8fd823416a1aa99b382a5a412a1742598fd823418a73a59b382a5a41bdf8bd578fd823419167ae9b382a5a41782e80568fd82341bbf6c39b382a5a413f9aa4558fd823414621e69b382a5a41f41d47558fd823416fe7149c382a5a415db210558fd823416428519c382a5a4175b788548fd823413f9c989c382a5a41e8f297538fd82341a088e69c382a5a41622a27528fd823412433369d382a5a418c231f508fd823416ae1829d382a5a4114a4684d8fd8234111d9c79d382a5a41a571ec498fd82341b85f009e382a5a41e95193458fd82341fdba279e382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (174,'os','phalange','gauche','membre supérieur','adulte',X'00016a080000aa51b95c8fd823413f9ead98382a5a412b5edc6f8fd823410345729b382a5a417c060000000100000069030000000100000028000000cc95e5658fd82341e0c58399382a5a4102bc7c648fd82341f996c299382a5a41a68bd1628fd823414838f899382a5a413c39c5618fd823419b54119a382a5a41c31197608fd82341098a269a382a5a4140f4705d8fd8234102cd539a382a5a4151b7e25c8fd8234157e7609a382a5a41aa51b95c8fd82341deab6e9a382a5a41cb530b5d8fd823411c197e9a382a5a41324eef5d8fd82341952d909a382a5a41a3e3c6628fd823410629d39a382a5a41b59418658fd823413bbffb9a382a5a415e638b668fd823413657209b382a5a416a7df9668fd82341de59319b382a5a41163d7c678fd82341f3cc519b382a5a41472de5678fd8234179e8609b382a5a41cc0566688fd8234175886c9b382a5a41772df0688fd823410345729b382a5a411c0b75698fd8234144b66f9b382a5a418e05e6698fd823415474629b382a5a419d83346a8fd823415317489b382a5a4144d98d6a8fd823418e047e9a382a5a41ff4e0e6b8fd8234116d4199a382a5a41e1fb706b8fd8234178b0ef99382a5a417421ee6b8fd823412882cd99382a5a413a61886c8fd82341cf46b599382a5a41e78bd06e8fd82341cc187699382a5a417b726f6f8fd82341ed985e99382a5a412057d16f8fd82341f26e4699382a5a412b5edc6f8fd8234126f02d99382a5a41f2ab766f8fd82341d4711599382a5a41ca64866e8fd823414749fd98382a5a416363f16b8fd82341ce10d098382a5a4109f1a96a8fd823418539be98382a5a41231777698fd823413e1bb298382a5a41ddc066688fd823413f9ead98382a5a4160d986678fd82341ceaab298382a5a41d94be5668fd823413429c398382a5a41710390668fd82341b701e198382a5a41cc95e5658fd82341e0c58399382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (175,'os','phalange','gauche','membre supérieur','adulte',X'00016a08000075367a6e8fd82341f83eab95382a5a41ecd3d17c8fd823413e580898382a5a417c06000000010000006903000000010000002400000015ff60758fd8234169f50096382a5a41458985748fd823418d575296382a5a4148436b738fd82341fa409696382a5a410facb0728fd82341c026b596382a5a417fabed708fd82341a033e696382a5a411c1211708fd8234159a20297382a5a411f04536f8fd82341870e2297382a5a41906cc56e8fd82341def94297382a5a4175367a6e8fd8234113e66397382a5a41d44c836e8fd82341db548397382a5a41b29af26e8fd82341eac79f97382a5a41170bda6f8fd82341f5c0b797382a5a4105e822738fd82341f6b4f697382a5a419eaf14748fd823418bd60398382a5a411945e9748fd823413e580898382a5a4166b19a758fd8234174680198382a5a4177fd22768fd823419135ec97382a5a413e327c768fd82341fbedc597382a5a41e54c3e778fd823414f694797382a5a411cc1f4778fd82341a8a30397382a5a4147c971788fd82341f4fbe596382a5a41414e0d798fd8234103d2ca96382a5a419d46cd798fd8234198e6b196382a5a41e4ab0b7c8fd8234111167596382a5a4165158a7c8fd82341c5306396382a5a414dc6d07c8fd82341f1f55096382a5a41ecd3d17c8fd82341cc7b3d96382a5a4193537f7c8fd823418fd82796382a5a41945acb7b8fd823416f220f96382a5a41ae9adb798fd82341a428d895382a5a411481de788fd82341a99dc095382a5a41ec0fec778fd82341e074b095382a5a4162e20e778fd82341f83eab95382a5a419f9351768fd82341a28cb495382a5a41ccbebe758fd823418deecf95382a5a4115ff60758fd8234169f50096382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (176,'os','métacarpien','gauche','membre supérieur','adulte',X'00016a0800007fe6d1268fd82341b7119397382a5a4116aaec498fd823410086929e382a5a417c06000000010000006903000000010000003700000051570f2d8fd823413fea299d382a5a41ee31a92b8fd823410cd43e9d382a5a41f757dd298fd82341c1ff639d382a5a4136c2f4288fd82341c78c7d9d382a5a417fb226288fd823413cbe9b9d382a5a41bb6188278fd82341de93be9d382a5a41fbe7e0268fd8234104ccfe9d382a5a417fe6d1268fd8234171fe179e382a5a41d359f3268fd82341d4212d9e382a5a41e13b47278fd82341bb9f3e9e382a5a419186cf278fd82341b2e14c9e382a5a41cd338e288fd823414851589e382a5a41803d85298fd823410758619e382a5a417366c8308fd823416671909e382a5a416d09c7318fd823410086929e382a5a4199eed6328fd82341ac21909e382a5a414084e3338fd82341a85b879e382a5a41ab38d8348fd82341344b769e382a5a41237aa0358fd823418f075b9e382a5a41f1b627368fd82341f7a7339e382a5a4130812d378fd82341d1fb389d382a5a4164d336388fd8234122fc949c382a5a417d57e3388fd82341fabc4a9c382a5a41be71aa398fd8234184d60e9c382a5a4182baba3d8fd82341c90b019b382a5a41f76d3a408fd8234147dd6b9a382a5a41822891418fd82341a772289a382a5a41cc77f4428fd823416ce8ed99382a5a4146855d448fd823417e07be99382a5a41d7d91f488fd8234144875799382a5a41b58305498fd82341543a3a99382a5a41e433a4498fd8234119f01a99382a5a4116aaec498fd823414201f798382a5a41da6a1e498fd8234108aa2b98382a5a41fbc1be488fd8234190e10a98382a5a41bb7519488fd8234193d5eb97382a5a41a1f915478fd8234160f1cd97382a5a4136c19b458fd8234147a0b097382a5a41eaa6ff438fd82341d2ae9b97382a5a4181bea5428fd82341b7119397382a5a4155cf7b418fd8234108a69497382a5a41bfa06f408fd82341d6489e97382a5a41a559d33a8fd823419d2e0198382a5a41e6a5153a8fd823414ca81d98382a5a4142c1a8398fd82341e41c4098382a5a41008972398fd82341da916898382a5a413f8f12398fd8234177290699382a5a4140adb1388fd823416dd64699382a5a410cf0c5388fd8234194bb8c99382a5a417bdc91388fd823418d36e199382a5a41e282ef378fd82341d125549a382a5a413549ab368fd82341669ce39a382a5a416b9591348fd8234151ad8d9b382a5a4177cd6e318fd82341976b509c382a5a4151570f2d8fd823413fea299d382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (177,'os','métacarpien','gauche','membre supérieur','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (178,'os','métacarpien','gauche','membre supérieur','adulte',X'00016a08000054e414f38ed823418098d596382a5a41f3ecfd038fd82341c928ef9d382a5a417c060000000100000069030000000100000032000000c209abf88ed82341dcdd979c382a5a41f75516f88ed82341eeefcd9c382a5a415f24a4f78ed82341fe35059d382a5a411a1b57f78ed82341295d449d382a5a4140045ff78ed82341c02f839d382a5a41eba9ebf78ed823411378b99d382a5a4131d62cf98ed823417500df9d382a5a412b5352fb8ed823413493eb9d382a5a412fd346018fd82341c928ef9d382a5a4155fd73028fd823418635ee9d382a5a41bdeb46038fd82341659fe79d382a5a414e94c7038fd823416ca9d89d382a5a41f3ecfd038fd82341a096be9d382a5a4194ebf1038fd8234107aa969d382a5a410926f7028fd8234175b8c19c382a5a41a1d292028fd82341135f4e9c382a5a41597428028fd82341b97ba39b382a5a41b2d8a0008fd8234197f0a299382a5a41ffc248008fd82341847dcb98382a5a41737468008fd8234117958798382a5a414040d2008fd8234167185c98382a5a418ebd79018fd82341cae53b98382a5a416779fa028fd82341b76f0d98382a5a414d0e90038fd82341b334f797382a5a416d01dc038fd82341aa54dc97382a5a41f57dbc038fd82341d6d3b897382a5a4113af0f038fd8234170b68897382a5a41720fe7018fd8234182325497382a5a41127077008fd8234177fa2697382a5a41450ed4fe8ed82341de610297382a5a415d2710fd8ed823414bbce796382a5a41adf83efb8ed82341505dd896382a5a4185bf73f98ed823418098d596382a5a4139b9c1f78ed823416bc1e096382a5a411a233cf68ed82341a52bfb96382a5a41efd9f8f48ed82341b7d91d97382a5a410de603f48ed823415d864197382a5a41004161f38ed8234159306797382a5a4154e414f38ed823416cd68f97382a5a4192c922f38ed823415777bc97382a5a4146ea8ef38ed82341db11ee97382a5a41fc3f5df48ed82341b9a42598382a5a41d14bf4f68ed823413af3ab98382a5a4109fb3af88ed8234146510099382a5a41cf424ff98ed82341d8f06399382a5a410b941afa8ed82341f279d999382a5a41a75f86fa8ed823419794639a382a5a4188167cfa8ed82341c9e8049b382a5a419929e5f98ed823418a1ec09b382a5a41c209abf88ed82341dcdd979c382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (179,'os','métacarpien','gauche','membre supérieur','adulte',X'00016a080000e42d8cd88ed823419dd7a899382a5a4144d081f28ed8234179544a9f382a5a417c06000000010000006903000000010000002f00000012d04ce88ed82341e8cdde9e382a5a41dee320e98ed823418f8c179f382a5a411fe6b5e98ed82341b1fc319f382a5a416e1a68ea8ed823414b20459f382a5a41878631eb8ed8234179544a9f382a5a4127300cec8ed8234157f63a9f382a5a410c1df2ec8ed823410063109f382a5a416129d3ed8ed82341c398dd9e382a5a414deda0ee8ed82341c593b89e382a5a41ad1a58ef8ed82341cf2b9f9e382a5a41437975f08ed823412892869e382a5a419cf394f18ed82341f9f87f9e382a5a41a57bf6f18ed82341c6a37a9e382a5a41c6b94ef28ed82341f128719e382a5a4144d081f28ed823410c5f629e382a5a4167e173f28ed82341a71c4d9e382a5a41760f09f28ed823415438309e382a5a4143d2e5ee8ed82341626daf9d382a5a41a6d9d0ed8ed8234116bb7a9d382a5a41887ec0ec8ed82341ab103f9d382a5a41bec8b2eb8ed823415dc6fa9c382a5a4118c0a5ea8ed823416a34ac9c382a5a41696c97e98ed8234110b3519c382a5a4108e050e58ed8234177b2a69a382a5a413cb46fe38ed823410a21f399382a5a41701ef6e28ed823419ca1d199382a5a41ce0360e28ed823415569bb99382a5a41cfb5b0e18ed823418d7aae99382a5a41ed85ebe08ed823419dd7a899382a5a4166c62cdf8ed82341a97eab99382a5a41acc728dc8ed82341e8adb799382a5a41f54cffda8ed823412226c099382a5a413360e8d98ed82341346dce99382a5a41bc800ad98ed823416716e499382a5a41e42d8cd88ed8234104b5029a382a5a4103e793d88ed8234155dc2b9a382a5a416e2b48d98ed82341a41f619a382a5a41c53bb5dc8ed823412a9ef29a382a5a419c2f6bde8ed823414823489b382a5a415e57f1df8ed82341cf4ea29b382a5a416bb447e18ed82341f8cdfe9b382a5a4121486ee28ed82341fd4d5b9c382a5a41df1365e38ed82341187cb59c382a5a4105192ce48ed8234181050b9d382a5a416017e0e58ed82341ea01ea9d382a5a413c6d07e78ed82341a382669e382a5a4112d04ce88ed82341e8cdde9e382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (180,'os','phalange','gauche','membre supérieur','adulte',X'00016a08000073439cc88ed82341cfc70994382a5a4142f1ebde8ed82341d2dd0c98382a5a417c06000000010000006903000000010000002d000000eb5e80d18ed8234196069797382a5a41ffd908d18ed82341b78ac797382a5a417daef2d08ed823416455e197382a5a41079711d18ed823417d78f897382a5a41671f80d18ed823417a790898382a5a4166d358d28ed82341d2dd0c98382a5a41cd3eb6d38ed82341fb2a0198382a5a419b3534d58ed8234114b5ef97382a5a4171e65bd78ed823418ab4df97382a5a41f5ccc9d88ed8234101a0e097382a5a41fd6c91da8ed82341c3efeb97382a5a413db35adb8ed82341656eed97382a5a41d91342dd8ed823414d1ee697382a5a41f8351bde8ed82341d027db97382a5a4125a9b4de8ed8234189e2c997382a5a4142f1ebde8ed82341963ab197382a5a412f929ede8ed82341171c9097382a5a41c2c212db8ed8234175f7fc96382a5a41a5f5d8d98ed823416360c296382a5a41e50e9dd78ed823415fbf4196382a5a4184f5a2d68ed823413f35fc95382a5a415018c6d58ed823419784b395382a5a4168770ad58ed8234151ed6795382a5a41712892d48ed8234131951f95382a5a41558f65d48ed823414c5be094382a5a41cb2160d48ed82341be997c94382a5a41e99e3fd48ed82341d9bd5794382a5a41fe74dbd38ed82341ba573b94382a5a41cfcc0fd38ed82341413d2794382a5a4123cfb8d18ed8234151441b94382a5a412ecfedcf8ed82341a2e61294382a5a410b58fecd8ed823415bf00b94382a5a41b6d51acc8ed82341cfc70994382a5a412eb473ca8ed8234152d30f94382a5a416e5f39c98ed8234137792194382a5a4173439cc88ed82341d21f4294382a5a413bccccc88ed82341772d7594382a5a41c265fbc98ed823417a08be94382a5a41316d4dcd8ed82341f3b66295382a5a41ed68c0ce8ed82341f342b495382a5a418404fbcf8ed82341760b0896382a5a41d5fbedd08ed823417b236096382a5a41c10a8ad18ed82341029ebe96382a5a4128edbfd18ed823410b8e2597382a5a41eb5e80d18ed8234196069797382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (181,'os','phalange','gauche','membre supérieur','adulte',X'00016a080000b09aa1be8ed82341b6d59590382a5a41bb942cce8ed82341d6f2cb92382a5a417c0600000001000000690300000001000000210000008dfcb4c28ed82341cac32c92382a5a41a7f901c28ed82341dd5d6792382a5a41df94c4c18ed823412ce58792382a5a417df9b6c18ed82341aec3a692382a5a41e557f6c18ed823418614bf92382a5a4179e09fc28ed82341d6f2cb92382a5a419cc3d0c38ed82341c279c892382a5a4117eacac68ed82341b50fab92382a5a41f046d6cb8ed823417ae67292382a5a415853c1cd8ed823416ef26192382a5a41d8830bce8ed82341e7845c92382a5a41bb942cce8ed823410e715492382a5a41e9e11fce8ed82341f90c4992382a5a414dc7e0cd8ed82341bdae3992382a5a41d0a06acd8ed8234171ac2592382a5a41d99fc6cb8ed82341fc13ed91382a5a41211302c98ed823417c9d9591382a5a414832aec78ed823415ca25e91382a5a4111112cc78ed823413be93e91382a5a412781c4c68ed823418f0a1a91382a5a41db33f8c58ed823419780ab90382a5a41469facc58ed82341be309c90382a5a4139774ec58ed82341b6d59590382a5a4161c2d5c48ed82341321d9690382a5a415aab7bc08ed82341dcf1b290382a5a411044acbf8ed82341c295bb90382a5a4141450fbf8ed82341bb49c890382a5a4155f5b1be8ed8234170a1da90382a5a41b09aa1be8ed823418730f490382a5a41b97bebbe8ed82341a88a1691382a5a41c96c1fc18ed82341187ca091382a5a41308412c28ed823415c72ea91382a5a418dfcb4c28ed82341cac32c92382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (182,'os','phalange','gauche','membre supérieur','adulte',X'00016a080000e4522eb78ed8234100ae5f8e382a5a419878b3c18ed82341738ba28f382a5a417c06000000010000006903000000010000001d0000001a3464b98ed82341738ba28f382a5a41bc769abd8ed8234192fc598f382a5a41d36cdebf8ed823419ef63c8f382a5a4107e83dc18ed823416282368f382a5a41093e93c18ed823418737318f382a5a419878b3c18ed823413e1b298f382a5a41ca43a1c18ed8234146c21e8f382a5a41b34b5fc18ed823415fc1128f382a5a41683cf0c08ed8234149ad058f382a5a412f90d5be8ed8234128a5dd8e382a5a410a03bdbd8ed823415c05c58e382a5a41d38e06bd8ed82341110fad8e382a5a412b7444bc8ed82341df75878e382a5a41eb70d9bb8ed82341732a7a8e382a5a41756f29bb8ed82341e4f06d8e382a5a41e9f74eba8ed82341db87648e382a5a41639264b98ed8234100ae5f8e382a5a4101c784b88ed82341fc21618e382a5a41e21dcab78ed8234178a26a8e382a5a41241f4fb78ed823411dee7d8e382a5a41e4522eb78ed8234193c39c8e382a5a41383354b78ed823418f34be8e382a5a41ecf893b78ed82341246fd98e382a5a41984db4b88ed8234191082b8f382a5a414344ccb88ed82341784e418f382a5a41aa4ba1b88ed82341c133758f382a5a419086beb88ed823419067948f382a5a4101b710b98ed8234128b1a08f382a5a411a3464b98ed82341738ba28f382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (183,'os','phalange','gauche','membre supérieur','adulte',X'00016a080000002c0bf18ed82341b1907990382a5a41206432058fd82341d23ac995382a5a417c060000000100000069030000000100000037000000b3f0a7f68ed823411e9ac994382a5a4115f5c4f58ed82341ec840a95382a5a41956e70f58ed82341c8f43195382a5a4120fc50f58ed823411a625b95382a5a41551f89f58ed82341ada78295382a5a41d2593bf68ed823414da0a395382a5a41342d8af78ed82341c626ba95382a5a419febfdf88ed823410782c595382a5a4188101efa8ed82341d23ac995382a5a419750f2fd8ed823413837ba95382a5a41913662ff8ed823411699ba95382a5a41d51b17038fd823415aa1c595382a5a41a5b24a048fd8234100ddbe95382a5a4162f0f6048fd823418922af95382a5a41206432058fd823411c9a9895382a5a41f39c13058fd82341dd6b7d95382a5a41ef29b1048fd82341f0bf5f95382a5a41269a21048fd823417bbe4195382a5a415779b0028fd8234199940295382a5a41cd4ab2018fd823415484cf94382a5a41173298008fd82341a2878d94382a5a413f7079ff8ed8234152c73d94382a5a4150466dfe8ed82341316ce193382a5a4155f58afd8ed823410e9f7993382a5a4158bee9fc8ed82341b6880793382a5a4162e2a0fc8ed82341f9518c92382a5a41328ab5fc8ed82341354d1992382a5a41c14407fd8ed8234180c2bc91382a5a4178d611fe8ed823415cfc0b91382a5a4194cdfefd8ed823418557e790382a5a4137507cfd8ed823418f2bc890382a5a41f0dc67fc8ed82341d611ab90382a5a4144b7e5fa8ed82341e5ad9290382a5a41531041f98ed823416b128390382a5a4114cb91f78ed823415d167b90382a5a417fcaeff58ed82341b1907990382a5a418df172f48ed823415b587d90382a5a41342333f38ed8234151448590382a5a416c4248f28ed82341882b9090382a5a412d32caf18ed82341f6e49c90382a5a41d4e242f18ed823419e12c690382a5a41b61f14f18ed82341a419e490382a5a41002c0bf18ed82341b5180791382a5a41f7f039f18ed82341c3112e91382a5a41e057b2f18ed82341bc065891382a5a41024a86f28ed8234192f98391382a5a41a2b0c7f38ed8234133ecb091382a5a4196bf20f58ed82341b265ed91382a5a41903430f68ed82341b3aa4392382a5a41fdb6f6f68ed823417d59ac92382a5a414aee74f78ed8234158102093382a5a41e381abf78ed823418e6d9793382a5a4134199bf78ed82341660f0b94382a5a41ab5b44f78ed8234128947394382a5a41b3f0a7f68ed823411e9ac994382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (184,'os','phalange','gauche','membre supérieur','adulte',X'00016a0800008cbb25158fd82341b18c8090382a5a417adce2288fd82341aab9c895382a5a417c0600000001000000690300000001000000350000004f6524168fd823419e4bf294382a5a416a7459158fd82341e94d2495382a5a418cbb25158fd82341c1244095382a5a41654c3c158fd823413da85a95382a5a4191f2c4158fd82341f0b26f95382a5a41a979e7168fd82341681f7b95382a5a41ae39141b8fd82341bc9e7195382a5a4186e8401d8fd82341eead7095382a5a414cc7451f8fd82341f1e17495382a5a4178e316218fd82341eb267d95382a5a41854aa8228fd8234100698895382a5a41ed09ee238fd8234156949595382a5a412a2fdc248fd823411195a395382a5a4119c5de258fd823417c57bd95382a5a411b2a89268fd8234153b0c595382a5a4171c448278fd82341aab9c895382a5a41cf6100288fd8234150cbc495382a5a41ebcf92288fd82341143db895382a5a417adce2288fd82341c466a195382a5a413155d3288fd823412fa07e95382a5a41bb2972278fd8234129b40f95382a5a41a8e4a3268fd82341d75fc594382a5a416e2be8258fd823410e167294382a5a41eaf04a258fd82341b3a81894382a5a41fc27d8248fd82341a8e9bb93382a5a4183c39b248fd82341d1aa5e93382a5a415cb6a1248fd8234110be0393382a5a4167f3f5248fd8234148f5ad92382a5a4154398b258fd823414c175e92382a5a4134ed72278fd823415f588f91382a5a4145dfc5278fd823416d095791382a5a416d8cc2278fd8234102dc2591382a5a41b3144d278fd82341384ffc90382a5a411c9849268fd823412ce2da90382a5a418311af248fd8234148debd90382a5a419666aa228fd823416c42a390382a5a41dfa970208fd82341f71f8e90382a5a41e6ed361e8fd8234144888190382a5a413645321c8fd82341b18c8090382a5a4159c2971a8fd823419c3e8e90382a5a41d8779c198fd8234161afad90382a5a413d7875198fd823415df0e190382a5a4157e54f1b8fd823415c36dd91382a5a41134ea01b8fd82341510d2892382a5a4138f8ba1b8fd8234103017e92382a5a4130a88c1b8fd823415238e292382a5a416422021b8fd823411fda5793382a5a4176533a1a8fd823414100cb93382a5a41808b68198fd823418f442794382a5a417e1398188fd823411af96e94382a5a416e34d4178fd82341f16fa494382a5a414b3728178fd8234126fbc994382a5a414f6524168fd823419e4bf294382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (185,'os','phalange','gauche','membre supérieur','adulte',X'00016a080000685912418fd823410f35d591382a5a41da0cc4598fd82341add2d596382a5a417c0600000001000000690300000001000000300000003e7d2d438fd823417a74cf95382a5a41c229ca418fd823412888f295382a5a41771e45418fd8234102110896382a5a41685912418fd8234114ee1e96382a5a415e9967418fd823419ef73496382a5a41219d7a428fd82341de054896382a5a4173073d498fd8234136926f96382a5a41b7ae044d8fd8234157828e96382a5a41ec18a34f8fd823418f75ad96382a5a41054772508fd823419c48bb96382a5a4133d54a518fd82341856bd096382a5a418210ec518fd82341add2d596382a5a41a975a6528fd82341ae6cd596382a5a41ab8259538fd82341c650cd96382a5a418db5e4538fd823413696bb96382a5a41528c27548fd823413c549e96382a5a41ff8401548fd8234117a27396382a5a41c0bf7c528fd823417018f595382a5a413aaff5518fd823418209ad95382a5a41e946b6518fd82341297e6295382a5a41b4e1b7518fd82341508a1695382a5a417ddaf3518fd82341e341ca94382a5a412c8c63528fd82341cdb87e94382a5a41a35100538fd82341fb023594382a5a41c985c3538fd823415834ee93382a5a4112b7be548fd8234128a3aa93382a5a41ae1c3d598fd8234139e7c592382a5a41da0cc4598fd82341b6d39a92382a5a41fd4bc2598fd823411ae27692382a5a41d30912598fd823410ad15a92382a5a410a77f2578fd82341284c4692382a5a418b01c3568fd82341fe813792382a5a41ef843a528fd823419b1a1692382a5a413dc95a518fd823419e4e0c92382a5a4111d14a4f8fd823414a5fe091382a5a41f37e874e8fd8234199d9d691382a5a414bcaca4d8fd823410f35d591382a5a417a51234d8fd823416783de91382a5a41e1b29f4c8fd823415cd6f591382a5a41e18c4e4c8fd82341a93f1e92382a5a41da7d3e4c8fd823410ad15a92382a5a41d7ac714c8fd8234148ca1393382a5a410638544c8fd8234114368793382a5a41483bdb4b8fd82341d9830294382a5a41d296dd4a8fd823417c258094382a5a41da2a32498fd82341df8cfa94382a5a4197d7af468fd82341e82b6c95382a5a413e7d2d438fd823417a74cf95382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (186,'os','phalange','gauche','membre supérieur','adulte',X'00016a0800007376dd4f8fd823416b7ffe8d382a5a41432121608fd82341102bc990382a5a417c060000000100000069030000000100000028000000262150558fd8234188ae178f382a5a41ba4717558fd82341e3d0638f382a5a41d09dd7548fd823411bfe8f8f382a5a41e57075548fd82341532bbc8f382a5a410176e9538fd82341cfb4e28f382a5a412c622c538fd82341d7f6fd8f382a5a416dea36528fd82341ad4d0890382a5a4122c13c518fd8234162a80c90382a5a41c1987d508fd823412a8f1890382a5a4138bc04508fd8234102442a90382a5a417376dd4f8fd82341ea084090382a5a41601213508fd82341de1f5890382a5a41eddab0508fd82341deca7090382a5a41051bc2518fd82341e64b8890382a5a41961d52538fd82341f6e49c90382a5a41a0e824558fd82341d784ae90382a5a413eba92588fd82341007bc690382a5a419fee095a8fd82341102bc990382a5a4140c93e5b8fd823414b3ac390382a5a4108611f5c8fd8234195d5b290382a5a41dccc995c8fd82341d0299690382a5a41ad92725c8fd82341c3d4fc8f382a5a415c2d935c8fd823419239c28f382a5a4124ac1a5d8fd82341f5a3538f382a5a41dff7725d8fd823418ef9248f382a5a411b2b285e8fd823419a2de68e382a5a413190a15f8fd823417298a38e382a5a416a8902608fd823410f088b8e382a5a41432121608fd823414bcd728e382a5a417229de5f8fd8234184d15b8e382a5a41af731a5f8fd8234119fe468e382a5a41b1d1b65d8fd823416a3c358e382a5a41186757598fd82341d373088e382a5a411ce944588fd823415e28008e382a5a41d9d964578fd823416b7ffe8d382a5a41aee3b7568fd82341a776058e382a5a41fab03e568fd82341c20b178e382a5a411becf9558fd823416a3c358e382a5a41196392558fd82341f76ca88e382a5a41262150558fd8234188ae178f382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (187,'os','phalange','gauche','membre supérieur','adulte',X'00016a080000d30912598fd82341215c638b382a5a4152cc5c648fd823418de9f08c382a5a417c060000000100000069030000000100000026000000c91c21648fd82341f1f7a88c382a5a4184ac3e638fd82341018e9c8c382a5a413a19fc628fd823419bcf928c382a5a4118b8d2628fd82341f915858c382a5a417420d1628fd8234179b7728c382a5a411e51c8638fd8234164ca148c382a5a41b6571c648fd8234197c7df8b382a5a41b24a13648fd823412541b98b382a5a415b77be638fd8234123769e8b382a5a41fb2a2f638fd82341a8a58c8b382a5a41dcb276628fd82341c70e818b382a5a41475ca6618fd8234196f0788b382a5a410a5b525f8fd823410c7e648b382a5a41774ab55e8fd82341215c638b382a5a41c2702f5e8fd823413cb2688b382a5a41fb78c15d8fd823414da8768b382a5a41310e6c5d8fd8234147668f8b382a5a4175db2f5d8fd823411b14b58b382a5a417062d15c8fd823413274198c382a5a417837565c8fd823412ed5328c382a5a414fefb15b8fd82341c7f33c8c382a5a41ed98455a8fd8234124463f8c382a5a417453a9598fd823411368458c382a5a414b823b598fd82341f423588c382a5a41d30912598fd82341de707e8c382a5a4140354e598fd8234173eba98c382a5a41f88df4598fd82341a6dfc88c382a5a41a4d5ef5a8fd823414f60dd8c382a5a41edcd2a5c8fd823414880e98c382a5a417e38905d8fd823416a52ef8c382a5a41ffd60a5f8fd823418de9f08c382a5a4178b6ea618fd823413fb2ef8c382a5a41082f07638fd823413ea8ec8c382a5a411b73c1638fd8234123a5e48c382a5a41b0162c648fd823414c51d98c382a5a41c3ad59648fd823411855cc8c382a5a4152cc5c648fd82341e458bf8c382a5a41c91c21648fd82341f1f7a88c382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (188,'os','phalange','gauche','membre supérieur','adulte',X'00016a080000d56864168fd82341535bc98b382a5a411a338f278fd823415712f88e382a5a417c0600000001000000690300000001000000300000003d7875198fd82341c9754a8e382a5a4141b8a3178fd823411b997a8e382a5a411f40dc168fd82341d66a978e382a5a41d56864168fd823411f3cb58e382a5a41543d79168fd823414fd1d08e382a5a4191c857178fd82341beeee68e382a5a417b153d198fd82341c758f48e382a5a41ec37431b8fd823415712f88e382a5a41d53e881c8fd82341d716f58e382a5a41d02d4f1d8fd82341d0f7ed8e382a5a4165d26e1e8fd823415595dd8e382a5a41338f4d1f8fd82341f374d98e382a5a417b42ba208fd823413277db8e382a5a41f26539258fd82341a7e1ee8e382a5a4147779e268fd823414dd0ea8e382a5a4197fb4e278fd823415a76dc8e382a5a41a1ca72278fd823419d50c68e382a5a4128bc31278fd82341e6dbaa8e382a5a410bc620258fd823410e0e338e382a5a417e86fd238fd823414d1ce08d382a5a41febb93238fd8234151afac8d382a5a41a3736b238fd823412a54738d382a5a4165e4a1238fd823414492348d382a5a413e4554248fd823410df1f08c382a5a411ed416278fd82341c7665f8c382a5a416b8571278fd82341d009458c382a5a411a338f278fd82341e4bc2f8c382a5a418d8372278fd823413c161e8c382a5a41241d1e278fd8234111ac0e8c382a5a4142a694268fd823419b14008c382a5a4146c5d8258fd8234114e6f08b382a5a419efcdb248fd82341e35be28b382a5a419f81a1238fd8234176cdd68b382a5a41e198e5208fd8234120f8c98b382a5a41443d9d1f8fd82341535bc98b382a5a419553891e8fd82341820ecd8b382a5a41e364c61d8fd82341bb66d58b382a5a4142fa701d8fd823410db9e28b382a5a41e27e7b1d8fd82341749c128c382a5a417f16ef1d8fd82341f8c07e8c382a5a41dc82211e8fd8234122c8c88c382a5a4137c51a1e8fd82341e7a5e88c382a5a41ba44d01d8fd8234184d1308d382a5a417eb61b1d8fd82341d23f8c8d382a5a41cdbe851c8fd82341553fbd8d382a5a41605cbd1b8fd823412355ee8d382a5a417197ba1a8fd82341c6ed1d8e382a5a413d7875198fd82341c9754a8e382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (189,'os','phalange','gauche','membre supérieur','adulte',X'00016a080000c3bac51d8fd823419c03f788382a5a4184f238298fd823412705c58a382a5a417c06000000010000006903000000010000002400000028e5c5238fd82341ec8ab98a382a5a41bc51ca258fd823419259c48a382a5a41c878e5268fd823412705c58a382a5a418c0fee278fd82341c363bf8a382a5a4102a5b7288fd82341cd8eb08a382a5a4123c815298fd82341ae9f958a382a5a41e907dc288fd82341cdaf6b8a382a5a41224baa278fd82341e34b058a382a5a4199f774278fd82341ea50e389382a5a41a4bbb1278fd82341654ac689382a5a413223fe288fd82341dd557489382a5a417fc730298fd823412d9e5f89382a5a4184f238298fd82341353a4b89382a5a41b70e08298fd82341463f3789382a5a418e868f288fd82341b0c22389382a5a417dc4c0278fd82341c6d91089382a5a41bf2bb7268fd8234156d30189382a5a410396a1258fd82341526ff988382a5a416e9f8e248fd823419c03f788382a5a4124e48c238fd8234119e6f988382a5a414c00ab228fd82341ad6c0189382a5a410a90f7218fd823413bed0c89382a5a41822f81218fd82341a6bd1b89382a5a41db7a56218fd82341d3332d89382a5a417e4733218fd82341e22fa889382a5a41b50a01218fd82341031ccc89382a5a41a19eaf208fd82341354bed89382a5a4135b537208fd82341f955098a382a5a419286d51e8fd8234195b5308a382a5a41f751341e8fd82341ad11488a382a5a4129e3ce1d8fd82341dcc0618a382a5a41c3bac51d8fd82341e69a7b8a382a5a415d59391e8fd823418f77938a382a5a41903f4a1f8fd823419b2ea78a382a5a41f6ed18218fd82341ce97b48a382a5a4128e5c5238fd82341ec8ab98a382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (190,'os','phalange','gauche','membre supérieur','adulte',X'00016a080000a040c6e98ed82341849ed48b382a5a41e31348f98ed82341037d148f382a5a417c0600000001000000690300000001000000250000000e44cfed8ed82341fd8bad8e382a5a413f8093ed8ed823414c5ad48e382a5a4191d397ed8ed8234159b4fd8e382a5a41e70bcfed8ed823415a130d8f382a5a4178543bee8ed82341037d148f382a5a411cf2e9ee8ed8234157a0108f382a5a41b7e1aff08ed82341b6f3fd8e382a5a41ac76a5f28ed823410ce8ef8e382a5a41b8ded6f78ed82341e1bbda8e382a5a41d5fe90f88ed82341ec03d38e382a5a415eb90cf98ed82341e7cfc78e382a5a41e31348f98ed82341ad0ab98e382a5a41f61341f98ed82341199fa68e382a5a412abff5f88ed823410678908e382a5a410e1b64f88ed823414f80768e382a5a41d7b798f68ed823412cb4358e382a5a41e3cdc1f58ed823416da30d8e382a5a41aa9663f48ed823411712b48d382a5a41717c6ff38ed82341c7db578d382a5a412074e5f28ed8234177ed048d382a5a41e8287bf28ed8234109f9448c382a5a41217d3af28ed8234137ae178c382a5a412ab8cef18ed823418542f38b382a5a4106ec29f18ed82341749bdb8b382a5a41b62a3ef08ed82341849ed48b382a5a4135a581ec8ed82341f4f5d68b382a5a41646559eb8ed82341ca8ddc8b382a5a41232f6eea8ed82341931de98b382a5a41c6dadde98ed823411462ff8b382a5a41a040c6e98ed823410f18228c382a5a41083945ea8ed8234148fc538c382a5a41cd1201ed8ed8234145400a8d382a5a41f540c8ed8ed82341a65b4e8d382a5a41cfae57ee8ed8234116c4988d382a5a411c2498ee8ed82341cf0ceb8d382a5a419c6872ee8ed8234109c9468e382a5a410e44cfed8ed82341fd8bad8e382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (191,'os','phalange','gauche','membre supérieur','adulte',X'00016a080000b02440e68ed823411d642189382a5a41fca6c2f08ed82341c6cb978a382a5a417c06000000010000006903000000010000002300000083c2ccef8ed82341b5038f8a382a5a4189237cf08ed8234120b28c8a382a5a41fca6c2f08ed8234170aa818a382a5a414390b1f08ed8234101d56f8a382a5a41c8225af08ed82341301a598a382a5a41f2a1cdef8ed8234157623f8a382a5a41c606f2ec8ed823417d2adb89382a5a41278b79ec8ed82341ab64be89382a5a41fcdd84eb8ed8234178736189382a5a410e9229eb8ed82341152e4789382a5a41f712b1ea8ed82341feb83289382a5a417cc70cea8ed823417b272689382a5a41ba1348e98ed823411d642189382a5a413b5981e88ed82341d2b02289382a5a418a8bc6e78ed8234166782989382a5a41329e25e78ed82341a4253589382a5a41bd84ace68ed8234159234589382a5a41b63269e68ed823414fdc5889382a5a41a89b69e68ed8234154bb6f89382a5a41627e26e78ed82341e6a9a389382a5a411bcd6ae78ed82341b3d3bd89382a5a4191e78fe78ed823414cd4ef89382a5a41cce74ae78ed8234161841c8a382a5a417f6374e68ed82341da37528a382a5a41ff524ae68ed82341c848648a382a5a41b02440e68ed823414bda758a382a5a41a27b58e68ed823418758858a382a5a41e7fa95e68ed82341a42f918a382a5a419245fbe68ed82341c6cb978a382a5a41b3fe8ae78ed823411599978a382a5a41fcf33ce98ed823411edf848a382a5a41114563ea8ed823414f1c808a382a5a412b83a1eb8ed82341557d7f8a382a5a41aae000ee8ed8234115b3858a382a5a4183c2ccef8ed82341b5038f8a382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (192,'os','trapèze','gauche','membre supérieur','adulte',X'00016a080000cc2fac358fd823410f4e26a0382a5a4178a918478fd8234185c393a2382a5a417c060000000100000069030000000100000029000000189397378fd82341726bfca0382a5a41813ad8368fd82341860e20a1382a5a41e1634b368fd823411e1142a1382a5a410416ed358fd8234154f461a1382a5a41b957b9358fd8234146397fa1382a5a41cc2fac358fd823410d6199a1382a5a410ca5c1358fd82341c7ecafa1382a5a4147bef5358fd823418e5dc2a1382a5a41498244368fd823417f34d0a1382a5a416eb167378fd823414a46e8a1382a5a4158aafe3a8fd823415fc418a2382a5a41d6bee23c8fd82341c69979a2382a5a417f17dd3d8fd82341a36b91a2382a5a419798ae3e8fd8234185c393a2382a5a41ceca5b3f8fd8234110ce85a2382a5a41d436e93f8fd82341e6b76ca2382a5a41add63b418fd82341079500a2382a5a41b4a485418fd82341bca3f3a1382a5a41e6131a438fd8234115c4bea1382a5a410c4d8d468fd8234136c05fa1382a5a41a18a17478fd82341d3b34ba1382a5a4178a918478fd82341213b44a1382a5a417485f5468fd82341bd793ca1382a5a41426185458fd82341d5ea03a1382a5a41f7040e458fd8234182acf9a0382a5a418e1618448fd823416895f2a0382a5a415a83bf428fd82341591af3a0382a5a41eb6e5e428fd82341474bf0a0382a5a413db36f418fd823419065e0a0382a5a4173ff25408fd82341e0e4c2a0382a5a41f37edc3d8fd82341ad197da0382a5a416b96fa3b8fd82341b90f33a0382a5a417b8aa93b8fd82341fc8629a0382a5a41b98d653b8fd823410f4e26a0382a5a41b81e4b398fd8234128c43aa0382a5a4111b575388fd823419c4a48a0382a5a41b8fae8378fd82341e9ab60a0382a5a41c44d97378fd82341450180a0382a5a414d0c73378fd82341e763a2a0382a5a4168946e378fd8234106edc3a0382a5a41189397378fd82341726bfca0382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (193,'os','trapézoïde','gauche','membre supérieur','adulte',X'00016a0800006c49aa288fd823416868ee9f382a5a41537498328fd82341402462a1382a5a417c060000000100000069030000000100000023000000c64a3f2d8fd82341f28b2aa0382a5a41139ac92b8fd82341965704a0382a5a413116ca2a8fd823411a1ef79f382a5a4106c4732a8fd82341a952f69f382a5a41e1ba082a8fd823416a2bfa9f382a5a41a72a71298fd823415c85f89f382a5a4133590e298fd823415ac903a0382a5a410280d5288fd8234176fc18a0382a5a415e9cb6288fd82341614455a0382a5a416c49aa288fd82341b851c7a0382a5a41a070bc288fd823416e27f9a0382a5a41ec1905298fd823416c5127a1382a5a41e3db3d298fd82341cd5b3aa1382a5a41383a84298fd82341964849a1382a5a418633d8298fd82341e40653a1382a5a4157424a2a8fd823412a6c59a1382a5a415a0fa02b8fd823419cb061a1382a5a410398712c8fd82341402462a1382a5a41d167342e8fd82341872158a1382a5a416e79132f8fd82341a23f4ca1382a5a417fd8e42f8fd82341b3d53aa1382a5a4194e68c308fd82341d54626a1382a5a41090fff308fd823410bde10a1382a5a41817e49318fd8234168c1f9a0382a5a41537498328fd823414d0426a0382a5a41801d88328fd823412da609a0382a5a4113ea3d328fd82341310ff89f382a5a4176d9ce318fd82341ca8bef9f382a5a410feb4f318fd823416868ee9f382a5a41471ed6308fd823417bf1f29f382a5a41877276308fd823417473fb9f382a5a41a0af16308fd82341b47910a0382a5a41aa65b82f8fd823418faa18a0382a5a413c66b02e8fd8234174bb23a0382a5a41c64a3f2d8fd82341f28b2aa0382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (194,'os','scaphoïde','gauche','membre supérieur','adulte',X'00016a0800003b5ee8248fd82341298f03a2382a5a41d36897368fd823417c428fa4382a5a417c060000000100000069030000000100000022000000744b5f288fd82341504828a3382a5a41a0e18b268fd8234120faa6a3382a5a4118aff7248fd82341883108a4382a5a413b5ee8248fd823416ec551a4382a5a414660b2258fd82341b9da7ca4382a5a41f99815278fd823417c428fa4382a5a4116ecd1288fd82341cacd8ea4382a5a415e3da72a8fd82341b54d81a4382a5a419270552c8fd8234151936ca4382a5a4173699c2d8fd82341b16f56a4382a5a41c20b3c2e8fd82341e8b344a4382a5a41c7c71d2f8fd82341a92d1da4382a5a418af3c2308fd82341ce5de2a3382a5a41b67af0328fd8234102329ca3382a5a41f9486b358fd82341ed9752a3382a5a41d7e053368fd8234114162fa3382a5a41d36897368fd82341f6d80ca3382a5a41af7b58368fd823410474eba2382a5a4128b4b9358fd82341ad7acaa2382a5a41c34af8328fd82341b2d665a2382a5a41701c8a318fd82341e63224a2382a5a41cd09d3308fd82341431311a2382a5a41957b0f308fd8234153e106a2382a5a411800402f8fd82341298f03a2382a5a41a425652e8fd82341d70e05a2382a5a41b168b82a8fd82341881416a2382a5a416f6c162a8fd82341c68f1da2382a5a41de77a7298fd8234141bc27a2382a5a41060c63298fd82341dcf633a2382a5a419ed237298fd82341fe0950a2382a5a41032a57298fd82341635b7ea2382a5a41bddb2b298fd8234135bab2a2382a5a41f5c2d6288fd8234154b4eda2382a5a41744b5f288fd82341504828a3382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (195,'os','capitatum','gauche','membre supérieur','adulte',X'00016a08000078cf53158fd823411ddef09f382a5a417c921f248fd8234137feb7a2382a5a417c06000000010000006903000000010000002f0000001923871a8fd8234123bd42a0382a5a41eaa7e3198fd82341a4fc41a0382a5a41fa39da188fd82341be163ba0382a5a4107db3e168fd823416bce22a0382a5a41abaeb1158fd8234181f221a0382a5a41cda168158fd82341d77827a0382a5a4178cf53158fd823410ee232a0382a5a416fe8f9158fd82341fad0b1a0382a5a41cda252168fd82341267bd2a0382a5a4106ff49178fd8234115ff0ea1382a5a411d10a3188fd8234175084da1382a5a41152401188fd82341337e87a1382a5a41441cc3178fd82341ad90bca1382a5a4130cdd6178fd82341e388eca1382a5a415e0b2a188fd82341d3af17a2382a5a4154abaa188fd823417c4e3ea2382a5a41978146198fd82341dcad60a2382a5a411923871a8fd82341bcd299a2382a5a41ee39251b8fd823412854ada2382a5a416096da1b8fd82341b4e9b6a2382a5a412841a31c8fd8234137feb7a2382a5a4102437b1d8fd8234188fcb1a2382a5a41a7a45e1e8fd823417e4fa6a2382a5a415425f8218fd82341e13360a2382a5a41ae7903238fd82341425453a2382a5a4189bf39238fd82341369d4ca2382a5a41fe9139238fd823413aa93fa2382a5a41abcc01238fd8234135ee27a2382a5a4122e9e6218fd82341b7fac5a1382a5a4191b452218fd82341d98d88a1382a5a41bed419218fd823412ef159a1382a5a4136b72a218fd823415aad35a1382a5a4182c973218fd82341064b17a1382a5a41cc66f0228fd8234182c3b2a0382a5a417c921f248fd82341c3ba23a0382a5a41c1a7e4238fd82341fd3524a0382a5a41afc6ad238fd8234194e31da0382a5a41b3c908238fd823415342f99f382a5a41084d7e228fd823411ddef09f382a5a4157a1d8218fd823414545f19f382a5a41245e25218fd82341db9ff89f382a5a41f11a72208fd82341ef1505a0382a5a41406fcc1f8fd8234193cf14a0382a5a419edb781e8fd823414e5843a0382a5a41b4b0e01d8fd82341c5694aa0382a5a41be216b1c8fd8234151934ca0382a5a411923871a8fd8234123bd42a0382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (196,'os','hamatum','gauche','membre supérieur','adulte',X'00016a0800003df408fb8ed82341f7f903a0382a5a41db7a9c148fd8234118220da2382a5a417c060000000100000069030000000100000035000000fa4c22078fd823416a825fa0382a5a41288687068fd82341812d34a0382a5a413343e0058fd823417f8218a0382a5a418eb936058fd82341567509a0382a5a41a91e95048fd82341f7f903a0382a5a41f8a705048fd82341550405a0382a5a418d332a038fd8234148cd10a0382a5a41675394028fd82341b6e70ca0382a5a4100a910028fd82341315b12a0382a5a412b9491018fd8234190bd1fa0382a5a415595a7ff8ed82341595869a0382a5a410595b2fe8ed823419f5088a0382a5a4196e962fc8ed823413d70c3a0382a5a4143e455fb8ed823415c99e5a0382a5a41e93633fb8ed82341d6b8f0a0382a5a4121d535fb8ed82341c0cc13a1382a5a413df408fb8ed82341f42727a1382a5a41f2690cfb8ed823419b9b3aa1382a5a41286592fb8ed823417d1848a1382a5a418afc79fc8ed82341f47850a1382a5a41c446a2fd8ed823415e9754a1382a5a416b4e31008fd82341767753a1382a5a412d3956018fd82341dbed4fa1382a5a41c14d71038fd823411b7643a1382a5a41a0b058048fd8234146a841a1382a5a41b99909058fd82341a55c4ca1382a5a41b5489f058fd82341bccd69a1382a5a410f0f45068fd823413d3480a1382a5a414b9e89078fd82341667099a1382a5a41252144098fd82341d2ceb3a1382a5a415cc24b0b8fd823411d9ccda1382a5a41cc0a9f0f8fd82341bbb5f8a1382a5a41800799118fd82341449b06a2382a5a4182cd3c138fd8234118220da2382a5a41b6b943148fd82341481809a2382a5a41db7a9c148fd82341bf6afaa1382a5a416f366e148fd823416514e4a1382a5a41f211e0138fd823411e10c9a1382a5a41e23219138fd82341d158aca1382a5a41dd67a9108fd82341ec6e5ea1382a5a41f369920f8fd82341253612a1382a5a414661c70e8fd82341bb05e8a0382a5a41423aa10e8fd82341127cc0a0382a5a41e156d10e8fd8234138c326a0382a5a4175ad9e0e8fd82341e33b19a0382a5a4146a3f10d8fd8234148cd10a0382a5a411b73c70c8fd8234155100ba0382a5a41c7df6f0b8fd82341098d0ba0382a5a41347f2a0a8fd8234152b211a0382a5a41cd80a2098fd82341d9b616a0382a5a411589da088fd82341060525a0382a5a418f0824088fd8234108ff39a0382a5a41fa4c22078fd823416a825fa0382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (197,'os','triquetrum','gauche','membre supérieur','adulte',X'00016a080000ead28bfc8ed823419980cca1382a5a412566150c8fd823410c86eea3382a5a417c0600000001000000690300000001000000280000008b931bff8ed823410f9616a2382a5a416b2720fe8ed82341da1341a2382a5a4116a86bfd8ed8234122266aa2382a5a418e4bf3fc8ed82341918491a2382a5a41d447acfc8ed82341d0e6b6a2382a5a41ead28bfc8ed823418904daa2382a5a418a6d93fc8ed823410c5118a3382a5a41449ccefc8ed82341098347a3382a5a41228e23fd8ed823415f1155a3382a5a41779ba3fd8ed82341e2395ea3382a5a410f081b008fd82341988d79a3382a5a410b233c018fd82341ed5b8ba3382a5a417c7ac8048fd823415e66d8a3382a5a417671af058fd823410f39e7a3382a5a41166281068fd823410c86eea3382a5a415e804c078fd823418ee0eda3382a5a4153001f088fd82341cedbe4a3382a5a41f81507098fd82341040bd3a3382a5a4152f5120a8fd823416a01b8a3382a5a41fd93070b8fd82341a9df99a3382a5a412baba70b8fd823415a917ea3382a5a41a203fe0b8fd82341cb8565a3382a5a412566150c8fd82341482c4ea3382a5a41779bf80b8fd8234120f437a3382a5a415e6cb20b8fd82341a04c22a3382a5a41f503d50a8fd82341cb6cf6a2382a5a419a95630a8fd823416aaee3a2382a5a4180e1ab098fd823416458d0a2382a5a41b6567b068fd82341aed9b3a2382a5a41c4f47e058fd823415557a5a2382a5a4187d5c3048fd8234171c494a2382a5a41488239048fd82341a1c681a2382a5a414e84cf038fd8234182036ca2382a5a41ad9a21028fd823416432f2a1382a5a41c84b83018fd82341db3cd6a1382a5a41a8eaf0008fd823419980cca1382a5a41904b6d008fd82341d685d0a1382a5a41c042fbff8ed82341cad4dda1382a5a417ca49dff8ed82341abf5efa1382a5a418b931bff8ed823410f9616a2382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (198,'os','pisiforme','gauche','membre supérieur','adulte',X'00016a080000d2639ff68ed82341313bc2a3382a5a41a5c4b3028fd82341048033a5382a5a417c06000000010000006903000000010000002200000042a27cff8ed823416d0117a4382a5a4178cab8fe8ed82341669217a4382a5a4112e1f8fd8ed82341116811a4382a5a41185ebafa8ed82341bdd9d8a3382a5a41ad7ac1f98ed82341ea97cba3382a5a4174deadf88ed82341313bc2a3382a5a41b6bfbaf78ed82341b254c3a3382a5a41222d1cf78ed82341aec2d1a3382a5a418fd4c2f68ed8234121d5e9a3382a5a41d2639ff68ed8234107dc07a4382a5a4139f1bcf68ed82341220747a4382a5a410944faf68ed82341e1c371a4382a5a41bce274f78ed82341494a92a4382a5a4147ca89f88ed823413a6dc0a4382a5a4165bc1dfa8ed823410b19f3a4382a5a41d07a15fc8ed82341143a21a5382a5a41951118fd8ed8234197b82fa5382a5a4130dafefd8ed82341048033a5382a5a41ff44c9fe8ed823419f562ea5382a5a4160c276ff8ed82341aa0222a5382a5a41b3c206008fd82341694a10a5382a5a4155b678008fd8234120f4faa4382a5a41a60dcc008fd8234112c6e3a4382a5a41fb9b30018fd8234143dfb8a4382a5a41efae58028fd82341bb5982a4382a5a41e2b891028fd82341cec26fa4382a5a41b1ecb2028fd823417dcb56a4382a5a41a5c4b3028fd82341824135a4382a5a414e7782028fd82341286a16a4382a5a412bae1e028fd823411b1f05a4382a5a4148ff99018fd82341d477fea3382a5a41b10006018fd82341ca8bffa3382a5a41734874008fd82341767205a4382a5a4142a27cff8ed823416d0117a4382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (199,'os','lunatum','gauche','membre supérieur','adulte',X'00016a08000083f57a0d8fd8234135695ba3382a5a4100ef6f1f8fd82341e2638da5382a5a417c0600000001000000690300000001000000240000002bd7f6128fd82341c51cb0a3382a5a413ec828108fd82341e5ecd2a3382a5a4137776e0e8fd82341984902a4382a5a41c05d990d8fd82341384c3aa4382a5a4183f57a0d8fd82341210e77a4382a5a4127b8e40d8fd82341aea8b4a4382a5a41581fa80e8fd823413835efa4382a5a41bea4960f8fd823411bcd22a5382a5a4103c281108fd82341b1894ba5382a5a41345766118fd8234169e168a5382a5a4158c95e128fd82341de357da5382a5a41ca4368138fd82341c92a89a5382a5a41e7f17f148fd82341e2638da5382a5a410cffa2158fd82341e1848aa5382a5a419696ce168fd823417e3181a5382a5a41e1e3ff178fd82341710d72a5382a5a414a1234198fd8234173bc5da5382a5a41aec8001b8fd82341b28837a5382a5a4140cad31b8fd8234163ad1ca5382a5a411b750c1c8fd823411da508a5382a5a417e7f151c8fd82341a65762a4382a5a410841701c8fd82341f2284da4382a5a412591a21d8fd823410e7d23a4382a5a41723ce01e8fd823410b9fe6a3382a5a4155d85c1f8fd82341739bc1a3382a5a4100ef6f1f8fd8234130c2a3a3382a5a41effb251f8fd823415d4b8ca3382a5a41a47a8b1e8fd82341126f7aa3382a5a419be6ac1d8fd8234169656da3382a5a4154bb961c8fd823417b6664a3382a5a41078df5198fd8234135695ba3382a5a4150a492188fd82341104f5da3382a5a41985045178fd82341201666a3382a5a41cd8015168fd82341968b73a3382a5a41b3282e148fd823417eb693a3382a5a412bd7f6128fd82341c51cb0a3382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (200,'os','cervicale 6','axial','rachis','adulte',X'00016a080000084b9a628fd82341037632bd382a5a415b7ba1a38fd823413e8742c4382a5a417c0600000001000000690300000002000000750000007844a17d8fd82341157eebc3382a5a4120acb07d8fd82341ff0815c4382a5a41128d3b7e8fd8234101692fc4382a5a41a7361b7f8fd82341d7953dc4382a5a4137f828808fd823413e8742c4382a5a4117213e818fd82341f13441c4382a5a41a10034828fd82341ad963cc4382a5a412be6e3828fd823412da437c4382a5a41d61d1e838fd8234168a435c4382a5a414a5558838fd823412da437c4382a5a41c43808848fd82341ad963cc4382a5a417612fe848fd82341f13441c4382a5a41c32f13868fd823413e8742c4382a5a410bde20878fd82341d7953dc4382a5a41af6a00888fd8234101692fc4382a5a410f238b888fd82341ff0815c4382a5a418d549a888fd82341157eebc3382a5a4157d2e7878fd82341fd4894c3382a5a419011a4878fd82341e04d59c3382a5a41b09e88878fd8234195e514c3382a5a411222b0878fd823416f61cac2382a5a41104435888fd82341bd127dc2382a5a4105ad32898fd82341d24a30c2382a5a41f4c2378a8fd82341f7a5fac1382a5a419192c58c8fd823413b8e82c1382a5a417912638e8fd82341fbbb40c1382a5a4191f019908fd82341da4505c1382a5a416ee7d1918fd823411dd4d7c0382a5a41a9b172938fd823410e0fc0c0382a5a419cc212958fd823419404c2c0382a5a415917c3958fd823415afdbcc0382a5a4158653c998fd823412ee48dc0382a5a41cd066c9d8fd82341cbec4bc0382a5a412c1a5c9f8fd8234173f726c0382a5a411c30e0a08fd82341483302c0382a5a413629bba18fd8234101c2dfbf382a5a418d6784a28fd823412ca3a3bf382a5a41f9a70da38fd82341737e67bf382a5a4190d81aa38fd823416a6f4cbf382a5a41964ff2a28fd8234125ff34bf382a5a41b07987a28fd823410f6322bf382a5a4180c3cda18fd8234192d015bf382a5a41d2319fa38fd82341c9d79cbe382a5a415b7ba1a38fd82341bbe78cbe382a5a41ea6a84a38fd82341b6b480be382a5a412a46dda28fd8234140755fbe382a5a41b7e70ba18fd82341885220be382a5a4149924da08fd8234172c6fbbd382a5a4197faf09f8fd823411cc9d9bd382a5a419a87e29f8fd8234151b7a3bd382a5a41aae9c39f8fd82341cdc58dbd382a5a416c13739f8fd82341d7f978bd382a5a41e597dc9e8fd82341f69a68bd382a5a411a0aed9d8fd82341b0f05fbd382a5a410ffd909c8fd823418c4262bd382a5a41c903b59a8fd8234111d872bd382a5a4155fd17948fd823411301d3bd382a5a41c6c1d9928fd82341a7ebe1bd382a5a41ca8095918fd82341fcc4eabd382a5a4148125f918fd823414430e9bd382a5a41ffbd55908fd823418b81cabd382a5a4139df248f8fd82341a3edaebd382a5a41ca11848d8fd823414b0e8fbd382a5a41f51c798b8fd823416dc66ebd382a5a41fcc709898fd82341f5f851bd382a5a4121da3b868fd82341cd883cbd382a5a41951d1e838fd82341037632bd382a5a41c23000808fd82341cd883cbd382a5a41391e327d8fd82341f5f851bd382a5a41f7aec27a8fd823416dc66ebd382a5a4182a8b7788fd823414b0e8fbd382a5a4163d016778fd82341a3edaebd382a5a414815eb748fd823415f3be5bd382a5a41ae93dc748fd823414430e9bd382a5a418e23a6748fd82341fcc4eabd382a5a411cf92f748fd823413418e9bd382a5a41efa423728fd823411301d3bd382a5a411cce866b8fd8234111d872bd382a5a41a4e5aa698fd823418c4262bd382a5a411dd44e688fd82341b0f05fbd382a5a4187305f678fd82341f69a68bd382a5a41e391c8668fd82341d7f978bd382a5a41338f77668fd82341cdc58dbd382a5a4177bf58668fd8234151b7a3bd382a5a41c47b4a668fd823411cc9d9bd382a5a414423ee658fd8234172c6fbbd382a5a41a2bc2f658fd82341885220be382a5a4195295e638fd8234140755fbe382a5a412c65f5628fd823412e9571be382a5a41084b9a628fd82341bbe78cbe382a5a418258a8628fd8234199bca0be382a5a4186d56d648fd8234192d015bf382a5a41ad29b4638fd823410f6322bf382a5a41b46449638fd8234125ff34bf382a5a41bcee20638fd823416a6f4cbf382a5a41e72f2e638fd82341737e67bf382a5a412f78b7638fd823412ca3a3bf382a5a41997e80648fd8234101c2dfbf382a5a4104985b658fd82341483302c0382a5a4159afdf668fd8234173f726c0382a5a4167adcf688fd82341cbec4bc0382a5a41fa7aee6a8fd823419cf16ec0382a5a41ded800708fd82341c30bb7c0382a5a41cea628718fd823419404c2c0382a5a4127f6c8728fd823410e0fc0c0382a5a4190f069748fd823411dd4d7c0382a5a41700a22768fd82341da4505c1382a5a417200d9778fd82341fbbb40c1382a5a41428f76798fd823413b8e82c1382a5a418b73e27a8fd823415214c3c1382a5a41e67f097d8fd82341d24a30c2382a5a4181b8067e8fd82341bd127dc2382a5a4107b68b7e8fd823416f61cac2382a5a41271fb37e8fd8234195e514c3382a5a418d9a977e8fd82341e04d59c3382a5a41e8ce537e8fd82341fd4894c3382a5a417844a17d8fd82341157eebc3382a5a4127000000728edd818fd82341d733fac0382a5a41a53caf808fd82341b2d8f7c0382a5a413fd69d7f8fd823417e4aefc0382a5a41ad819e7e8fd823413a48e0c0382a5a415c65a67d8fd82341ea90cac0382a5a41b8a7aa7c8fd823418ee3adc0382a5a4126e27c7a8fd82341bba25ec0382a5a4134e970798fd82341f8e32dc0382a5a410c85ad788fd8234157a2fbbf382a5a41f05927788fd82341e955cabf382a5a41ea3fa5778fd82341ea7c74bf382a5a414c4f91778fd823410ca038bf382a5a411947d9788fd82341b18337bf382a5a4137f5127a8fd823413de02dbf382a5a4109e1937e8fd823418766edbe382a5a417dbe55808fd8234128cadbbe382a5a418b4337828fd82341bbc8d2be382a5a4100d01d848fd82341bbc8d2be382a5a41145812858fd823417afdd5be382a5a411407e4868fd8234192bde3be382a5a4107e095888fd82341d253f8be382a5a4183a76c8a8fd82341572413bf382a5a41e904428c8fd823413de02dbf382a5a41c9a97b8d8fd82341b18337bf382a5a41e160c38e8fd823410ca038bf382a5a41f718c28e8fd823417ae054bf382a5a4186b6818e8fd82341bf769cbf382a5a41597a2d8e8fd82341e955cabf382a5a418669a78d8fd8234157a2fbbf382a5a410d2ae48c8fd82341f8e32dc0382a5a41ed61d88b8fd82341bba25ec0382a5a416549aa898fd823418ee3adc0382a5a412777ae888fd82341ea90cac0382a5a411654b6878fd823413a48e0c0382a5a418e06b7868fd823417e4aefc0382a5a41edb4a5858fd82341b2d8f7c0382a5a41918577848fd82341d733fac0382a5a413ba533838fd82341ea9cf6c0382a5a41728edd818fd82341d733fac0382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (201,'os','thoracique 3','axial','rachis','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (202,'os','lombaire 5','axial','rachis','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (223,'os','dent 18',NULL,'crâne','adulte',X'00016a08000024b5a3798cd823418abea2e2382a5a411adeff888cd82341a9438ee4382a5a417c06000000010000006903000000010000000500000024b5a3798cd82341a9438ee4382a5a411adeff888cd82341a9438ee4382a5a411adeff888cd823418abea2e2382a5a4124b5a3798cd823418abea2e2382a5a4124b5a3798cd82341a9438ee4382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (224,'os','dent 17',NULL,'crâne','adulte',X'00016a0800001adeff888cd823418abea2e2382a5a4110075c988cd82341a9438ee4382a5a417c0600000001000000690300000001000000050000001adeff888cd82341a9438ee4382a5a4110075c988cd82341a9438ee4382a5a4110075c988cd823418abea2e2382a5a411adeff888cd823418abea2e2382a5a411adeff888cd82341a9438ee4382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (225,'os','dent 16',NULL,'crâne','adulte',X'00016a08000010075c988cd823418abea2e2382a5a410630b8a78cd82341a9438ee4382a5a417c06000000010000006903000000010000000500000010075c988cd82341a9438ee4382a5a410630b8a78cd82341a9438ee4382a5a410630b8a78cd823418abea2e2382a5a4110075c988cd823418abea2e2382a5a4110075c988cd82341a9438ee4382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (226,'os','dent 15',NULL,'crâne','adulte',X'00016a0800000630b8a78cd823418abea2e2382a5a41fc5814b78cd82341a9438ee4382a5a417c0600000001000000690300000001000000050000000630b8a78cd82341a9438ee4382a5a41fc5814b78cd82341a9438ee4382a5a41fc5814b78cd823418abea2e2382a5a410630b8a78cd823418abea2e2382a5a410630b8a78cd82341a9438ee4382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (227,'os','dent 14',NULL,'crâne','adulte',X'00016a080000fc5814b78cd823418abea2e2382a5a41f28170c68cd82341a9438ee4382a5a417c060000000100000069030000000100000005000000fc5814b78cd82341a9438ee4382a5a41f28170c68cd82341a9438ee4382a5a41f28170c68cd823418abea2e2382a5a41fc5814b78cd823418abea2e2382a5a41fc5814b78cd82341a9438ee4382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (228,'os','dent 47',NULL,'crâne','adulte',X'00016a0800001adeff888cd823416b39b7e0382a5a4110075c988cd823418abea2e2382a5a417c0600000001000000690300000001000000050000001adeff888cd823418abea2e2382a5a4110075c988cd823418abea2e2382a5a4110075c988cd823416b39b7e0382a5a411adeff888cd823416b39b7e0382a5a411adeff888cd823418abea2e2382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (229,'os','dent 46',NULL,'crâne','adulte',X'00016a08000010075c988cd823416b39b7e0382a5a410630b8a78cd823418abea2e2382a5a417c06000000010000006903000000010000000500000010075c988cd823418abea2e2382a5a410630b8a78cd823418abea2e2382a5a410630b8a78cd823416b39b7e0382a5a4110075c988cd823416b39b7e0382a5a4110075c988cd823418abea2e2382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (230,'os','dent 45',NULL,'crâne','adulte',X'00016a0800000630b8a78cd823416b39b7e0382a5a41fc5814b78cd823418abea2e2382a5a417c0600000001000000690300000001000000050000000630b8a78cd823418abea2e2382a5a41fc5814b78cd823418abea2e2382a5a41fc5814b78cd823416b39b7e0382a5a410630b8a78cd823416b39b7e0382a5a410630b8a78cd823418abea2e2382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (231,'os','dent 44',NULL,'crâne','adulte',X'00016a080000fc5814b78cd823416b39b7e0382a5a41f28170c68cd823418abea2e2382a5a417c060000000100000069030000000100000005000000fc5814b78cd823418abea2e2382a5a41f28170c68cd823418abea2e2382a5a41f28170c68cd823416b39b7e0382a5a41fc5814b78cd823416b39b7e0382a5a41fc5814b78cd823418abea2e2382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (232,'os','dent 48',NULL,'crâne','adulte',X'00016a08000024b5a3798cd823416b39b7e0382a5a411adeff888cd823418abea2e2382a5a417c06000000010000006903000000010000000500000024b5a3798cd823418abea2e2382a5a411adeff888cd823418abea2e2382a5a411adeff888cd823416b39b7e0382a5a4124b5a3798cd823416b39b7e0382a5a4124b5a3798cd823418abea2e2382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (233,'os','dent 13',NULL,'crâne','adulte',X'00016a080000f28170c68cd82341fbfbace1382a5a41e8aaccd58cd82341a9438ee4382a5a417c060000000100000069030000000100000005000000f28170c68cd82341a9438ee4382a5a41e8aaccd58cd82341a9438ee4382a5a41e8aaccd58cd82341949546e3382a5a41f28170c68cd82341fbfbace1382a5a41f28170c68cd82341a9438ee4382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (234,'os','dent 43',NULL,'crâne','adulte',X'00016a080000f28170c68cd823416b39b7e0382a5a41e8aaccd58cd82341949546e3382a5a417c060000000100000069030000000100000006000000f28170c68cd823416b39b7e0382a5a41f28170c68cd82341fbfbace1382a5a41e8aaccd58cd82341949546e3382a5a41e8aaccd58cd823418abea2e2382a5a41e8aaccd58cd823416b39b7e0382a5a41f28170c68cd823416b39b7e0382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (235,'os','dent 12',NULL,'crâne','adulte',X'00016a080000e8aaccd58cd823418abea2e2382a5a41ded328e58cd82341a9438ee4382a5a417c060000000100000069030000000100000005000000e8aaccd58cd82341a9438ee4382a5a41ded328e58cd82341a9438ee4382a5a41ded328e58cd823418abea2e2382a5a41e8aaccd58cd823418abea2e2382a5a41e8aaccd58cd82341a9438ee4382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (236,'os','dent 11',NULL,'crâne','adulte',X'00016a080000ded328e58cd823418abea2e2382a5a41d4fc84f48cd82341a9438ee4382a5a417c060000000100000069030000000100000005000000ded328e58cd82341a9438ee4382a5a41d4fc84f48cd82341a9438ee4382a5a41d4fc84f48cd823418abea2e2382a5a41ded328e58cd823418abea2e2382a5a41ded328e58cd82341a9438ee4382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (237,'os','dent 42',NULL,'crâne','adulte',X'00016a080000e8aaccd58cd823416b39b7e0382a5a41ded328e58cd823418abea2e2382a5a417c060000000100000069030000000100000005000000e8aaccd58cd823418abea2e2382a5a41ded328e58cd823418abea2e2382a5a41ded328e58cd823416b39b7e0382a5a41e8aaccd58cd823416b39b7e0382a5a41e8aaccd58cd823418abea2e2382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (238,'os','dent 41',NULL,'crâne','adulte',X'00016a080000ded328e58cd823416b39b7e0382a5a41d4fc84f48cd823418abea2e2382a5a417c060000000100000069030000000100000005000000ded328e58cd823418abea2e2382a5a41d4fc84f48cd823418abea2e2382a5a41d4fc84f48cd823416b39b7e0382a5a41ded328e58cd823416b39b7e0382a5a41ded328e58cd823418abea2e2382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (239,'os','dent 23',NULL,'crâne','adulte',X'00016a080000c04e3d138dd82341fbfbace1382a5a41b67799228dd82341a9438ee4382a5a417c060000000100000069030000000100000005000000c04e3d138dd82341a9438ee4382a5a41b67799228dd82341a9438ee4382a5a41b67799228dd82341fbfbace1382a5a41c04e3d138dd82341959546e3382a5a41c04e3d138dd82341a9438ee4382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (240,'os','dent 33',NULL,'crâne','adulte',X'00016a080000c04e3d138dd823416b39b7e0382a5a41b67799228dd82341959546e3382a5a417c060000000100000069030000000100000005000000c04e3d138dd82341959546e3382a5a41b67799228dd82341fbfbace1382a5a41b67799228dd823416b39b7e0382a5a41c04e3d138dd823416b39b7e0382a5a41c04e3d138dd82341959546e3382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (241,'os','dent 24',NULL,'crâne','adulte',X'00016a080000b67799228dd823418abea2e2382a5a41aca0f5318dd82341a9438ee4382a5a417c060000000100000069030000000100000005000000b67799228dd82341a9438ee4382a5a41aca0f5318dd82341a9438ee4382a5a41aca0f5318dd823418abea2e2382a5a41b67799228dd823418abea2e2382a5a41b67799228dd82341a9438ee4382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (242,'os','dent 25',NULL,'crâne','adulte',X'00016a080000aca0f5318dd823418abea2e2382a5a41a2c951418dd82341a9438ee4382a5a417c060000000100000069030000000100000005000000aca0f5318dd82341a9438ee4382a5a41a2c951418dd82341a9438ee4382a5a41a2c951418dd823418abea2e2382a5a41aca0f5318dd823418abea2e2382a5a41aca0f5318dd82341a9438ee4382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (243,'os','dent 27',NULL,'crâne','adulte',X'00016a08000098f2ad508dd823418abea2e2382a5a418e1b0a608dd82341a9438ee4382a5a417c06000000010000006903000000010000000500000098f2ad508dd82341a9438ee4382a5a418e1b0a608dd82341a9438ee4382a5a418e1b0a608dd823418abea2e2382a5a4198f2ad508dd823418abea2e2382a5a4198f2ad508dd82341a9438ee4382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (244,'os','dent 26',NULL,'crâne','adulte',X'00016a080000a2c951418dd823418abea2e2382a5a4198f2ad508dd82341a9438ee4382a5a417c060000000100000069030000000100000005000000a2c951418dd82341a9438ee4382a5a4198f2ad508dd82341a9438ee4382a5a4198f2ad508dd823418abea2e2382a5a41a2c951418dd823418abea2e2382a5a41a2c951418dd82341a9438ee4382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (245,'os','dent 34',NULL,'crâne','adulte',X'00016a080000b67799228dd823416b39b7e0382a5a41aca0f5318dd823418abea2e2382a5a417c060000000100000069030000000100000005000000b67799228dd823418abea2e2382a5a41aca0f5318dd823418abea2e2382a5a41aca0f5318dd823416b39b7e0382a5a41b67799228dd823416b39b7e0382a5a41b67799228dd823418abea2e2382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (246,'os','dent 35',NULL,'crâne','adulte',X'00016a080000aca0f5318dd823416b39b7e0382a5a41a2c951418dd823418abea2e2382a5a417c060000000100000069030000000100000005000000aca0f5318dd823418abea2e2382a5a41a2c951418dd823418abea2e2382a5a41a2c951418dd823416b39b7e0382a5a41aca0f5318dd823416b39b7e0382a5a41aca0f5318dd823418abea2e2382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (247,'os','dent 36',NULL,'crâne','adulte',X'00016a080000a2c951418dd823416b39b7e0382a5a4198f2ad508dd823418abea2e2382a5a417c060000000100000069030000000100000005000000a2c951418dd823418abea2e2382a5a4198f2ad508dd823418abea2e2382a5a4198f2ad508dd823416b39b7e0382a5a41a2c951418dd823416b39b7e0382a5a41a2c951418dd823418abea2e2382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (248,'os','dent 37',NULL,'crâne','adulte',X'00016a08000098f2ad508dd823416b39b7e0382a5a418e1b0a608dd823418abea2e2382a5a417c06000000010000006903000000010000000500000098f2ad508dd823418abea2e2382a5a418e1b0a608dd823418abea2e2382a5a418e1b0a608dd823416b39b7e0382a5a4198f2ad508dd823416b39b7e0382a5a4198f2ad508dd823418abea2e2382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (249,'os','dent 38',NULL,'crâne','adulte',X'00016a0800008e1b0a608dd823416b39b7e0382a5a418444666f8dd823418abea2e2382a5a417c0600000001000000690300000001000000050000008e1b0a608dd823418abea2e2382a5a418444666f8dd823418abea2e2382a5a418444666f8dd823416b39b7e0382a5a418e1b0a608dd823416b39b7e0382a5a418e1b0a608dd823418abea2e2382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (250,'os','dent 21',NULL,'crâne','adulte',X'00016a080000d4fc84f48cd823418abea2e2382a5a41ca25e1038dd82341a9438ee4382a5a417c060000000100000069030000000100000005000000d4fc84f48cd82341a9438ee4382a5a41ca25e1038dd82341a9438ee4382a5a41ca25e1038dd823418abea2e2382a5a41d4fc84f48cd823418abea2e2382a5a41d4fc84f48cd82341a9438ee4382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (251,'os','dent 22',NULL,'crâne','adulte',X'00016a080000ca25e1038dd823418abea2e2382a5a41c04e3d138dd82341a9438ee4382a5a417c060000000100000069030000000100000006000000ca25e1038dd82341a9438ee4382a5a41c04e3d138dd82341a9438ee4382a5a41c04e3d138dd82341959546e3382a5a41c04e3d138dd823418abea2e2382a5a41ca25e1038dd823418abea2e2382a5a41ca25e1038dd82341a9438ee4382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (252,'os','dent 31',NULL,'crâne','adulte',X'00016a080000d4fc84f48cd823416b39b7e0382a5a41ca25e1038dd823418abea2e2382a5a417c060000000100000069030000000100000005000000d4fc84f48cd823418abea2e2382a5a41ca25e1038dd823418abea2e2382a5a41ca25e1038dd823416b39b7e0382a5a41d4fc84f48cd823416b39b7e0382a5a41d4fc84f48cd823418abea2e2382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (253,'os','dent 32',NULL,'crâne','adulte',X'00016a080000ca25e1038dd823416b39b7e0382a5a41c04e3d138dd823418abea2e2382a5a417c060000000100000069030000000100000005000000ca25e1038dd823418abea2e2382a5a41c04e3d138dd823418abea2e2382a5a41c04e3d138dd823416b39b7e0382a5a41ca25e1038dd823416b39b7e0382a5a41ca25e1038dd823418abea2e2382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (254,'os','dent 28',NULL,'crâne','adulte',X'00016a0800008e1b0a608dd823418abea2e2382a5a418444666f8dd82341a9438ee4382a5a417c0600000001000000690300000001000000050000008e1b0a608dd82341a9438ee4382a5a418444666f8dd82341a9438ee4382a5a418444666f8dd823418abea2e2382a5a418e1b0a608dd823418abea2e2382a5a418e1b0a608dd82341a9438ee4382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (255,'os','os frontal',NULL,'crâne','adulte',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (256,'os','dent','gauche','crâne','immature',X'00016a0800006c2fbd9a90d82341d9199231382a5a416e58d7bd90d82341e62c4435382a5a417c0600000001000000690300000001000000050000006c2fbd9a90d82341e62c4435382a5a416e58d7bd90d82341e62c4435382a5a416e58d7bd90d82341d9199231382a5a416c2fbd9a90d82341d9199231382a5a416c2fbd9a90d82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (257,'os','dent','gauche','crâne','immature',X'00016a0800001398a37790d82341d9199231382a5a416c2fbd9a90d82341e62c4435382a5a417c0600000001000000690300000001000000050000001398a37790d82341e62c4435382a5a416c2fbd9a90d82341e62c4435382a5a416c2fbd9a90d82341d9199231382a5a411398a37790d82341d9199231382a5a411398a37790d82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (258,'os','dent','gauche','crâne','immature',X'00016a08000008248b5490d82341d9199231382a5a411398a37790d82341e62c4435382a5a417c06000000010000006903000000010000000500000008248b5490d82341e62c4435382a5a411398a37790d82341e62c4435382a5a411398a37790d82341d9199231382a5a4108248b5490d82341d9199231382a5a4108248b5490d82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (259,'os','dent','gauche','crâne','immature',X'00016a0800001269f43190d82341d9199231382a5a4108248b5490d82341e62c4435382a5a417c0600000001000000690300000001000000050000001269f43190d82341e62c4435382a5a4108248b5490d82341e62c4435382a5a4108248b5490d82341d9199231382a5a411269f43190d82341d9199231382a5a411269f43190d82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (260,'os','dent','gauche','crâne','immature',X'00016a0800001ed1e20f90d82341d9199231382a5a411269f43190d82341e62c4435382a5a417c0600000001000000690300000001000000050000001ed1e20f90d82341e62c4435382a5a411269f43190d82341e62c4435382a5a411269f43190d82341d9199231382a5a411ed1e20f90d82341d9199231382a5a411ed1e20f90d82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (261,'os','dent','gauche','crâne','immature',X'00016a080000cdf75fec8fd82341d9199231382a5a411ed1e20f90d82341be221b36382a5a417c060000000100000069030000000100000005000000cdf75fec8fd82341be221b36382a5a411ed1e20f90d823416bc69034382a5a411ed1e20f90d82341d9199231382a5a41cdf75fec8fd82341d9199231382a5a41cdf75fec8fd82341be221b36382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (262,'os','dent','gauche','crâne','immature',X'00016a0800006c2fbd9a90d82341e62c4435382a5a416e58d7bd90d82341f43ff638382a5a417c0600000001000000690300000001000000050000006c2fbd9a90d82341e62c4435382a5a416c2fbd9a90d82341f43ff638382a5a416e58d7bd90d82341f43ff638382a5a416e58d7bd90d82341e62c4435382a5a416c2fbd9a90d82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (263,'os','dent','gauche','crâne','immature',X'00016a0800001398a37790d82341e62c4435382a5a416c2fbd9a90d82341f43ff638382a5a417c0600000001000000690300000001000000050000001398a37790d82341e62c4435382a5a411398a37790d82341f43ff638382a5a416c2fbd9a90d82341f43ff638382a5a416c2fbd9a90d82341e62c4435382a5a411398a37790d82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (264,'os','dent','gauche','crâne','immature',X'00016a08000008248b5490d82341e62c4435382a5a411398a37790d82341f43ff638382a5a417c06000000010000006903000000010000000500000008248b5490d82341e62c4435382a5a4108248b5490d82341f43ff638382a5a411398a37790d82341f43ff638382a5a411398a37790d82341e62c4435382a5a4108248b5490d82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (265,'os','dent','gauche','crâne','immature',X'00016a0800001269f43190d82341e62c4435382a5a4108248b5490d82341f43ff638382a5a417c0600000001000000690300000001000000050000001269f43190d82341e62c4435382a5a411269f43190d82341f43ff638382a5a4108248b5490d82341f43ff638382a5a4108248b5490d82341e62c4435382a5a411269f43190d82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (266,'os','dent','gauche','crâne','immature',X'00016a0800001ed1e20f90d82341e62c4435382a5a411269f43190d82341f43ff638382a5a417c0600000001000000690300000001000000050000001ed1e20f90d82341e62c4435382a5a411ed1e20f90d82341f43ff638382a5a411269f43190d82341f43ff638382a5a411269f43190d82341e62c4435382a5a411ed1e20f90d82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (267,'os','dent','gauche','crâne','immature',X'00016a080000cdf75fec8fd823416bc69034382a5a411ed1e20f90d82341f43ff638382a5a417c060000000100000069030000000100000005000000cdf75fec8fd82341be221b36382a5a41cdf75fec8fd82341f43ff638382a5a411ed1e20f90d82341f43ff638382a5a411ed1e20f90d823416bc69034382a5a41cdf75fec8fd82341be221b36382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (268,'os','dent','droit','crâne','immature',X'00016a0800001b8e8aab8ed82341d9199231382a5a411ab7a4ce8ed82341e62c4435382a5a417c0600000001000000690300000001000000050000001ab7a4ce8ed82341e62c4435382a5a411ab7a4ce8ed82341d9199231382a5a411b8e8aab8ed82341d9199231382a5a411b8e8aab8ed82341e62c4435382a5a411ab7a4ce8ed82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (269,'os','dent','droit','crâne','immature',X'00016a0800001ab7a4ce8ed82341d9199231382a5a411be0bef18ed82341e62c4435382a5a417c0600000001000000690300000001000000050000001be0bef18ed82341e62c4435382a5a411be0bef18ed82341d9199231382a5a411ab7a4ce8ed82341d9199231382a5a411ab7a4ce8ed82341e62c4435382a5a411be0bef18ed82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (270,'os','dent','droit','crâne','immature',X'00016a0800001be0bef18ed82341d9199231382a5a411ca8ac148fd82341e62c4435382a5a417c0600000001000000690300000001000000050000001ca8ac148fd82341e62c4435382a5a411ca8ac148fd82341d9199231382a5a411be0bef18ed82341d9199231382a5a411be0bef18ed82341e62c4435382a5a411ca8ac148fd82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (271,'os','dent','droit','crâne','immature',X'00016a0800001ca8ac148fd82341d9199231382a5a41a6fd1a378fd82341e62c4435382a5a417c060000000100000069030000000100000005000000a6fd1a378fd82341e62c4435382a5a41a6fd1a378fd82341d9199231382a5a411ca8ac148fd82341d9199231382a5a411ca8ac148fd82341e62c4435382a5a41a6fd1a378fd82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (272,'os','dent','droit','crâne','immature',X'00016a080000a6fd1a378fd82341d9199231382a5a41571e56598fd82341e62c4435382a5a417c060000000100000069030000000100000005000000571e56598fd82341e62c4435382a5a41571e56598fd82341d9199231382a5a41a6fd1a378fd82341d9199231382a5a41a6fd1a378fd82341e62c4435382a5a41571e56598fd82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (273,'os','dent','droit','crâne','immature',X'00016a080000571e56598fd82341d9199231382a5a416280027d8fd82341be221b36382a5a417c0600000001000000690300000001000000050000006280027d8fd82341be221b36382a5a416280027d8fd82341d9199231382a5a41571e56598fd82341d9199231382a5a41571e56598fd823416bc69034382a5a416280027d8fd82341be221b36382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (274,'os','dent','droit','crâne','immature',X'00016a0800001b8e8aab8ed82341e62c4435382a5a411ab7a4ce8ed82341f43ff638382a5a417c0600000001000000690300000001000000050000001ab7a4ce8ed82341e62c4435382a5a411b8e8aab8ed82341e62c4435382a5a411b8e8aab8ed82341f43ff638382a5a411ab7a4ce8ed82341f43ff638382a5a411ab7a4ce8ed82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (275,'os','dent','droit','crâne','immature',X'00016a0800001ab7a4ce8ed82341e62c4435382a5a411be0bef18ed82341f43ff638382a5a417c0600000001000000690300000001000000050000001be0bef18ed82341e62c4435382a5a411ab7a4ce8ed82341e62c4435382a5a411ab7a4ce8ed82341f43ff638382a5a411be0bef18ed82341f43ff638382a5a411be0bef18ed82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (276,'os','dent','droit','crâne','immature',X'00016a0800001be0bef18ed82341e62c4435382a5a411ca8ac148fd82341f43ff638382a5a417c0600000001000000690300000001000000050000001ca8ac148fd82341e62c4435382a5a411be0bef18ed82341e62c4435382a5a411be0bef18ed82341f43ff638382a5a411ca8ac148fd82341f43ff638382a5a411ca8ac148fd82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (277,'os','dent','droit','crâne','immature',X'00016a0800001ca8ac148fd82341e62c4435382a5a41a6fd1a378fd82341f43ff638382a5a417c060000000100000069030000000100000005000000a6fd1a378fd82341e62c4435382a5a411ca8ac148fd82341e62c4435382a5a411ca8ac148fd82341f43ff638382a5a41a6fd1a378fd82341f43ff638382a5a41a6fd1a378fd82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (278,'os','dent','droit','crâne','immature',X'00016a080000a6fd1a378fd82341e62c4435382a5a41571e56598fd82341f43ff638382a5a417c060000000100000069030000000100000005000000571e56598fd82341e62c4435382a5a41a6fd1a378fd82341e62c4435382a5a41a6fd1a378fd82341f43ff638382a5a41571e56598fd82341f43ff638382a5a41571e56598fd82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (279,'os','dent','droit','crâne','immature',X'00016a080000571e56598fd823416bc69034382a5a416280027d8fd82341f43ff638382a5a417c0600000001000000690300000001000000050000006280027d8fd82341be221b36382a5a41571e56598fd823416bc69034382a5a41571e56598fd82341f43ff638382a5a416280027d8fd82341f43ff638382a5a416280027d8fd82341be221b36382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (280,'os','dent','gauche','crâne','immature',X'00016a080000c02b47d08fd82341d9199231382a5a41cdf75fec8fd82341e62c4435382a5a417c060000000100000069030000000100000005000000c02b47d08fd82341e62c4435382a5a41cdf75fec8fd82341e62c4435382a5a41cdf75fec8fd82341d9199231382a5a41c02b47d08fd82341d9199231382a5a41c02b47d08fd82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (281,'os','dent','gauche','crâne','immature',X'00016a080000183cb1b48fd82341d9199231382a5a41c02b47d08fd82341e62c4435382a5a417c060000000100000069030000000100000005000000183cb1b48fd82341e62c4435382a5a41c02b47d08fd82341e62c4435382a5a41c02b47d08fd82341d9199231382a5a41183cb1b48fd82341d9199231382a5a41183cb1b48fd82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (282,'os','dent','gauche','crâne','immature',X'00016a080000c02b47d08fd82341e62c4435382a5a41cdf75fec8fd82341f43ff638382a5a417c060000000100000069030000000100000005000000c02b47d08fd82341e62c4435382a5a41c02b47d08fd82341f43ff638382a5a41cdf75fec8fd82341f43ff638382a5a41cdf75fec8fd82341e62c4435382a5a41c02b47d08fd82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (283,'os','dent','gauche','crâne','immature',X'00016a080000183cb1b48fd82341e62c4435382a5a41c02b47d08fd82341f43ff638382a5a417c060000000100000069030000000100000005000000183cb1b48fd82341e62c4435382a5a41183cb1b48fd82341f43ff638382a5a41c02b47d08fd82341f43ff638382a5a41c02b47d08fd82341e62c4435382a5a41183cb1b48fd82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (284,'os','dent','droit','crâne','immature',X'00016a0800006280027d8fd82341d9199231382a5a41c7ba1a998fd82341e62c4435382a5a417c060000000100000069030000000100000005000000c7ba1a998fd82341e62c4435382a5a41c7ba1a998fd82341d9199231382a5a416280027d8fd82341d9199231382a5a416280027d8fd82341e62c4435382a5a41c7ba1a998fd82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (285,'os','dent','droit','crâne','immature',X'00016a080000c7ba1a998fd82341d9199231382a5a41183cb1b48fd82341e62c4435382a5a417c060000000100000069030000000100000005000000183cb1b48fd82341e62c4435382a5a41183cb1b48fd82341d9199231382a5a41c7ba1a998fd82341d9199231382a5a41c7ba1a998fd82341e62c4435382a5a41183cb1b48fd82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (286,'os','dent','droit','crâne','immature',X'00016a0800006280027d8fd82341e62c4435382a5a41c7ba1a998fd82341f43ff638382a5a417c060000000100000069030000000100000005000000c7ba1a998fd82341e62c4435382a5a416280027d8fd82341e62c4435382a5a416280027d8fd82341f43ff638382a5a41c7ba1a998fd82341f43ff638382a5a41c7ba1a998fd82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (287,'os','dent','droit','crâne','immature',X'00016a080000c7ba1a998fd82341e62c4435382a5a41183cb1b48fd82341f43ff638382a5a417c060000000100000069030000000100000005000000183cb1b48fd82341e62c4435382a5a41c7ba1a998fd82341e62c4435382a5a41c7ba1a998fd82341f43ff638382a5a41183cb1b48fd82341f43ff638382a5a41183cb1b48fd82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (289,'os','os temporal','gauche','crâne','immature',X'00016a0800009f0c7a938ed82341e414c718382a5a41f754e0d18ed8234115c6ea1e382a5a417c0600000001000000690300000001000000240000009a2ed3be8ed82341e414c718382a5a41b6aaaeb78ed823416ab8cf18382a5a411b6133b68ed82341fa1e6d19382a5a417449d3b18ed823419fd45219382a5a4121ff8cae8ed823417cc78b19382a5a41b17339ad8ed823418f3ee819382a5a4181d825b08ed82341e96db41a382a5a4131585baf8ed82341560c151b382a5a41a56998ab8ed8234133251b1b382a5a4171c83da98ed82341b522ac1a382a5a4169005ca68ed82341150b891a382a5a41106f66a18ed823416661951a382a5a41f0588e9d8ed823416873dc1a382a5a419fde189b8ed823412b4ba51b382a5a4160e0c7988ed823417f2eba1b382a5a411b3374978ed82341a819f61b382a5a41ae8414978ed82341cbe2061d382a5a41436aee958ed8234189bb3a1d382a5a418b61b4938ed82341c8044f1d382a5a419f0c7a938ed8234184b3331e382a5a411f8467998ed823413cf5a51e382a5a41a6b61da18ed823418699e71e382a5a417a6aadb48ed8234115c6ea1e382a5a4100e0ebc18ed823419ca5961e382a5a41a65d49cb8ed823419a4d951d382a5a41a3b0cecc8ed823419e82061d382a5a4112d7f6c98ed82341995bbe1b382a5a41d5c6ffca8ed823416c36a01b382a5a416134dad08ed82341b183a31b382a5a41f754e0d18ed823419c1a591b382a5a4166bc98d18ed823413310fc1a382a5a41c26a75cf8ed8234105ab961a382a5a41abadd3cb8ed823412b1b471a382a5a41402605c48ed823413a24161a382a5a41e3ec98c28ed82341cacc6f19382a5a419a2ed3be8ed82341e414c718382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (292,'os','os pariétal','gauche','crâne','immature',X'00016a0800008c2ee3a38ed82341918f651b382a5a41fe1c57ed8ed823410a04bc22382a5a417c060000000100000069030000000100000015000000d8471eb58ed82341e8d0b922382a5a41ab0211c68ed823410a04bc22382a5a41e2999fd38ed82341e3786d22382a5a41e1e949e18ed82341cab04121382a5a41047502ea8ed82341bffbd81f382a5a41fe1c57ed8ed823414459981e382a5a4195f376e08ed823410a2d2e1d382a5a413e3c02db8ed82341a5f1151c382a5a41d2e2c3d48ed8234184a7f51b382a5a41a435cfd18ed82341918f651b382a5a4171b22dd08ed82341f617af1b382a5a41d01c14ca8ed82341ccceb31b382a5a411ab6a9cc8ed82341c99b461d382a5a41a65d49cb8ed823419a4d951d382a5a41acd422c38ed8234156f7801e382a5a4164c39ab88ed82341e285dd1e382a5a418c2ee3a38ed82341c19cf31e382a5a41f7e6afa88ed823416907e11f382a5a41bfd4b6b38ed8234101d45921382a5a410b1f58b58ed82341b5c5ff21382a5a41d8471eb58ed82341e8d0b922382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (300,'os','os pariétal','droit','crâne','immature',X'00016a080000a7c7195c8dd82341bd3d261b382a5a411ab68da58dd8234135b27c22382a5a417c060000000100000069030000000100000015000000cf9c52948dd82341127f7a22382a5a419cc518948dd82341e173c021382a5a41e70fba958dd823412d821a21382a5a41b0fdc0a08dd8234195b5a11f382a5a411ab68da58dd82341ec4ab41e382a5a414321d6908dd823410e349e1e382a5a41fb0f4e868dd8234182a5411e382a5a410087277e8dd82341c6fb551d382a5a418d2ec77c8dd82341f449071d382a5a41d8c75c7f8dd82341f87c741b382a5a41363243798dd8234120c66f1b382a5a4103afa1778dd82341bd3d261b382a5a41d501ad748dd82341b055b61b382a5a4169a86e6e8dd82341cf9fd61b382a5a4112f1f9688dd8234135dbee1c382a5a41a7c7195c8dd823417007591e382a5a41a26f6e5f8dd82341eba9991f382a5a41c6fa26688dd82341f55e0221382a5a41c54ad1758dd823410c272e22382a5a41fbe15f838dd8234135b27c22382a5a41cf9c52948dd82341127f7a22382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (314,'os','phalange','gauche','membre supérieur','immature',X'00016a080000bdb8a2e98ed823412bd848c9372a5a41588cc4f58ed8234149c343ca372a5a417c0600000001000000690300000001000000070000003eb6e7ed8ed823412bd848c9372a5a41bdb8a2e98ed8234179eca8c9372a5a4174b0fbe98ed8234149c343ca372a5a4136f878f58ed82341f72b0eca372a5a41588cc4f58ed8234186e0b9c9372a5a4166fe34f38ed8234190b453c9372a5a413eb6e7ed8ed823412bd848c9372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (315,'os','phalange','gauche','membre supérieur','immature',X'00016a0800008f7fa8e98ed8234111259fcc372a5a41bf1b55f68ed823419206f9cf372a5a417c06000000010000006903000000010000001000000041d819f08ed823412b77d7cc372a5a41777f06ef8ed823410ee1efcc372a5a412a19a3eb8ed82341de2de0cc372a5a418f7fa8e98ed82341b80c1fcd372a5a4110d637ec8ed82341a29d9acd372a5a4114e06aed8ed8234134ce1fce372a5a41bc11e8ea8ed823419d4b9dcf372a5a41efc2ceec8ed823419206f9cf372a5a41e96565f08ed82341efa3afcf372a5a41491edaf58ed823413cab96cf372a5a41bf1b55f68ed82341c4ed76cf372a5a41d3a682f38ed82341b6e1c4ce372a5a4142f5b6f28ed8234127463fce372a5a41026864f58ed82341f13bf0cc372a5a410cfabaf38ed8234111259fcc372a5a4141d819f08ed823412b77d7cc372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (316,'os','phalange','gauche','membre supérieur','immature',X'00016a080000c8f622ec8ed82341ff6d09d0372a5a414de028f78ed82341ab0a18d1372a5a417c06000000010000006903000000010000000a000000185420f78ed82341fd5e66d0372a5a41b63d82f58ed823418e5518d0372a5a41400bedef8ed82341ff6d09d0372a5a411a289dec8ed8234169b464d0372a5a41c8f622ec8ed823418dc499d0372a5a41ad21edec8ed8234172c4e7d0372a5a41e43a6aef8ed82341ab0a18d1372a5a41dcecdff28ed82341013bd4d0372a5a414de028f78ed82341c801bed0372a5a41185420f78ed82341fd5e66d0372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (317,'os','phalange','gauche','membre supérieur','immature',X'00016a080000aa76c2ce8ed8234132041fd1372a5a41b03449d88ed823419a435dd2372a5a417c0600000001000000690300000001000000090000004aa1aad58ed82341bdeb27d2372a5a41b03449d88ed8234145f5c0d1372a5a418d534ed78ed82341bc7b4ad1372a5a4106e527d28ed8234132041fd1372a5a41fd6f09cf8ed823414d0c98d1372a5a41aa76c2ce8ed82341f7fad0d1372a5a41f8b35ed38ed823419a435dd2372a5a4129d4f5d48ed82341f9fe5bd2372a5a414aa1aad58ed82341bdeb27d2372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (318,'os','métacarpien','gauche','membre supérieur','immature',X'00016a08000083519ed38ed82341235cf6d3372a5a417c324ae28ed823414235afd5372a5a417c06000000010000006903000000010000000c0000002f4cc4d78ed82341537340d4372a5a41fba4ccd48ed82341457882d4372a5a4183519ed38ed823413c72d8d4372a5a41e5f444d48ed8234100603ed5372a5a410d785ad68ed8234110739cd5372a5a41b41bfad98ed823414235afd5372a5a419f1009dd8ed82341d25b32d5372a5a417c324ae28ed823414abc07d5372a5a412d989ce18ed823412322acd4372a5a416c9205de8ed823414866fdd3372a5a412dbd66db8ed82341235cf6d3372a5a412f4cc4d78ed82341537340d4372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (319,'os','métacarpien','gauche','membre supérieur','immature',X'00016a0800005a6c78ed8ed82341f7671ed2372a5a417b91c7fc8ed823418d72b8d3372a5a417c06000000010000006903000000010000000c000000cd1434f28ed8234194ba43d2372a5a41ca4bcbee8ed82341193097d2372a5a415a6c78ed8ed823416f0eead2372a5a41c48dc2ed8ed82341c0ee43d3372a5a415577ccef8ed8234101b7a0d3372a5a415a1572f28ed823418d72b8d3372a5a41c70c9df68ed823418c3e66d3372a5a411136cffb8ed82341840053d3372a5a417b91c7fc8ed82341da8e01d3372a5a411b0231fc8ed8234120564fd2372a5a413b586df68ed82341f7671ed2372a5a41cd1434f28ed8234194ba43d2372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (320,'os','métacarpien','gauche','membre supérieur','immature',X'00016a0800002fc0ce048fd82341c55126d1372a5a41370fff118fd82341a332a7d2372a5a417c06000000010000006903000000010000000b000000370fff118fd82341f0b349d2372a5a41f7f9dc118fd823416717c3d1372a5a4110c6ae0f8fd82341dfb046d1372a5a41a3fb090e8fd82341c55126d1372a5a41002b05078fd823410af789d1372a5a412fc0ce048fd823410f1cf2d1372a5a41969326058fd8234146fe77d2372a5a41b47393078fd823410542a5d2372a5a41fae2610d8fd823416c6a7dd2372a5a4104e2ba108fd82341a332a7d2372a5a41370fff118fd82341f0b349d2372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (321,'os','métacarpien','gauche','membre supérieur','immature',X'00016a0800004930afd88ed82341219897d5372a5a4112088eea8ed823410dc9ebd9372a5a417c06000000010000006903000000010000000e0000007af592dc8ed8234109b12fd7372a5a4153ffc4de8ed8234184070ad8372a5a417636f5df8ed82341e44abcd9372a5a41f3060ce28ed823410dc9ebd9372a5a415677cce58ed823417fb184d9372a5a411f5dd8e98ed823412d8055d9372a5a4112088eea8ed8234158521bd9372a5a41e7a6cae18ed82341c71decd6372a5a419696b3e08ed82341b9e0e5d5372a5a415bcb5bde8ed82341219897d5372a5a412db8e5db8ed823413758fad5372a5a41e8f475d98ed82341354922d6372a5a414930afd88ed82341d7f35fd6372a5a417af592dc8ed8234109b12fd7372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (322,'os','métacarpien','gauche','membre supérieur','immature',X'00016a0800007dd6d6ec8ed82341b87ef1d3372a5a416f5983f98ed8234180f206d9372a5a417c06000000010000006903000000010000000d0000003fd88ff78ed82341a62fe0d4372a5a41fed4f9f88ed82341b3a463d4372a5a4119d3c6f78ed823419f6a14d4372a5a418b3244f38ed82341b87ef1d3372a5a417a22c9ef8ed82341986938d4372a5a41fb9f2df08ed823416bb9a0d6372a5a417dd6d6ec8ed823419713c4d8372a5a414b9245ef8ed8234180f206d9372a5a41f773e7f78ed82341e402f0d8372a5a416f5983f98ed82341f234b7d8372a5a41d99777f68ed8234187ec29d7372a5a414e8015f68ed8234137fc95d5372a5a413fd88ff78ed82341a62fe0d4372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (323,'os','métacarpien','gauche','membre supérieur','immature',X'00016a0800007a4e8b018fd8234189a955d3372a5a41ba78d10e8fd82341bcf69fd8372a5a417c06000000010000006903000000010000000e0000003209cc058fd82341d9534cd4372a5a41006c67058fd823419af079d6372a5a417a4e8b018fd8234133ba50d8372a5a41122fe7018fd82341bd788ad8372a5a4184051a038fd82341bcf69fd8372a5a411f1af8078fd823410eb424d8372a5a41ff22f40b8fd82341ca44eed7372a5a415123060d8fd82341c4d2bad7372a5a4146834f0b8fd82341aabff6d4372a5a41ba78d10e8fd82341cecab2d3372a5a413427090e8fd8234189a955d3372a5a41b67fac048fd823417f1f62d3372a5a41923e01048fd82341546fd0d3372a5a413209cc058fd82341d9534cd4372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (324,'os','métacarpien','gauche','membre supérieur','immature',X'00016a0800005d9f77228fd82341cf7fdfd1372a5a41472072308fd82341d03949d3372a5a417c06000000010000006903000000010000000b0000008d3e662a8fd823410e5ee9d2372a5a411aad8d2c8fd82341d03949d3372a5a41677ac22f8fd823412cdd09d3372a5a41472072308fd8234164e5a0d2372a5a41d60e122f8fd823411efcfcd1372a5a41cfa026278fd82341cf7fdfd1372a5a413f2286238fd823415be905d2372a5a415d9f77228fd82341d2db5cd2372a5a411832c0228fd8234132edd2d2372a5a412917d1278fd82341df4caad2372a5a418d3e662a8fd823410e5ee9d2372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (325,'os','métacarpien','gauche','membre supérieur','immature',X'00016a0800006843c8118fd82341ba9221d3372a5a4189e3fa2a8fd823415f6e1fd8372a5a417c06000000010000006903000000010000000f000000e4060c208fd82341da2711d4372a5a419e1bc81b8fd8234182fac4d5372a5a416843c8118fd82341d7f494d7372a5a418e9aa7138fd82341eadfc2d7372a5a41e5bfc2178fd823410f15aad7372a5a41f77f70188fd823417baafad7372a5a417e61ed1a8fd823415f6e1fd8372a5a41b837041d8fd82341e59e0fd8372a5a4133ff6a1e8fd8234182e1d2d7372a5a419f900e218fd82341f57d78d6372a5a4189e3fa2a8fd82341963483d3372a5a418df961278fd823418cdb86d3372a5a41580ec0218fd82341ba9221d3372a5a4182388d208fd82341dc096dd3372a5a41e4060c208fd82341da2711d4372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (326,'os','métacarpien','gauche','membre supérieur','immature',X'00016a080000564b1c2e8fd8234143733fd4372a5a414faa6e498fd82341834b64d8372a5a417c060000000100000069030000000100000010000000f4e2ea3e8fd82341a56d87d4372a5a412e85703e8fd82341127050d5372a5a41b597953b8fd823410bf0fcd5372a5a415a6c1e368fd82341b86dd5d6372a5a4157301c308fd82341b0d721d7372a5a41564b1c2e8fd82341cdee61d7372a5a413a63dd2e8fd82341eba38fd7372a5a41e19319338fd8234125fecdd7372a5a418253f7358fd82341834b64d8372a5a413e0142388fd82341bd5847d8372a5a4154fef13b8fd823412c28bfd7372a5a414faa6e498fd82341bfd53ad5372a5a41edb90d498fd823416048c3d4372a5a4117bc4f458fd82341c0b04fd4372a5a416832ae418fd8234143733fd4372a5a41f4e2ea3e8fd82341a56d87d4372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (327,'os','métacarpien','gauche','membre supérieur','immature',X'00016a080000d5706b258fd823417d2d88d7372a5a41c1e81e358fd82341949128d9372a5a417c060000000100000069030000000100000009000000c1e81e358fd82341a22ab0d8372a5a419565a02b8fd823417d2d88d7372a5a41d176d2268fd82341cac2f4d7372a5a41d5706b258fd823413f2066d8372a5a41f9fe172e8fd82341d44489d8372a5a41fab5ef2f8fd82341433affd8372a5a416e8ce4338fd82341949128d9372a5a41f9220f358fd823417bfc0dd9372a5a41c1e81e358fd82341a22ab0d8372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (328,'os','trapézoïde','gauche','membre supérieur','immature',X'00016a080000736c6f128fd82341f09790d9372a5a41934bd31b8fd82341cda9f3da372a5a417c06000000010000006903000000010000000a000000e471cb168fd823411e16cad9372a5a41443774148fd82341ad2898d9372a5a4141868e128fd8234189baaed9372a5a41736c6f128fd82341516ea0da372a5a4147890e148fd82341cda9f3da372a5a4154fc58188fd823418600e9da372a5a41238bc91a8fd823412bc88fda372a5a41934bd31b8fd823412c0a9fd9372a5a412c8f8e1a8fd82341f09790d9372a5a41e471cb168fd823411e16cad9372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (329,'os','scaphoïde','gauche','membre supérieur','immature',X'00016a0800002f20280f8fd82341c7ff92db372a5a41ad317e208fd823411f6a10de372a5a417c06000000010000006903000000010000000b000000ad179c128fd82341924bb0dc372a5a412f20280f8fd8234169cda5dd372a5a4197079a0f8fd82341e896efdd372a5a41d9b0ab118fd823411f6a10de372a5a41ae2409188fd82341dd9dd0dd372a5a410140b91f8fd82341306bcedc372a5a41ad317e208fd82341159b8ddc372a5a415a44611b8fd8234111d6abdb372a5a4156cfaa188fd82341c7ff92db372a5a414079b5138fd82341997dbbdb372a5a41ad179c128fd82341924bb0dc372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (330,'os','phalange','gauche','membre supérieur','immature',X'00016a080000168131158fd823419d9864c2372a5a4188efde1e8fd823411bdeadc3372a5a417c06000000010000006903000000010000000900000003bc55188fd823417665adc2372a5a41168131158fd823411bdeadc3372a5a412318341e8fd82341b379a1c3372a5a4188efde1e8fd8234190ed6fc3372a5a41ea55411c8fd82341658a22c3372a5a41a34a921c8fd82341d9b2d3c2372a5a4172465f1b8fd82341f9d074c2372a5a4175daee198fd823419d9864c2372a5a4103bc55188fd823417665adc2372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (331,'os','phalange','gauche','membre supérieur','immature',X'00016a0800005081c8148fd82341614620c4372a5a417f69831d8fd823412f76c1c4372a5a417c0600000001000000690300000001000000080000007f69831d8fd823411ba045c4372a5a41d89fcc1a8fd82341614620c4372a5a4137f4bc158fd823417ada3dc4372a5a415081c8148fd82341366869c4372a5a41d55d63158fd8234139a7bcc4372a5a413ecf131a8fd823416d95a1c4372a5a419fb87e1d8fd823412f76c1c4372a5a417f69831d8fd823411ba045c4372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (332,'os','phalange','gauche','membre supérieur','immature',X'00016a080000105bd10f8fd8234182928ac6372a5a4172ccd7198fd82341d4c890c8372a5a417c06000000010000006903000000010000000d00000068e722128fd8234134772ec7372a5a41202e8c118fd823416911bcc7372a5a41105bd10f8fd8234164cf2ec8372a5a4123231b108fd823411af673c8372a5a4108d2eb118fd82341d4c890c8372a5a410243b6188fd82341776680c8372a5a417a667f198fd823412c6b36c8372a5a4146d39a188fd8234150a66dc7372a5a4172ccd7198fd82341232fefc6372a5a41fcae19198fd8234182928ac6372a5a4132c3e0158fd823410234acc6372a5a410681a6118fd82341de46a5c6372a5a4168e722128fd8234134772ec7372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (333,'os','phalange','gauche','membre supérieur','immature',X'00016a080000d6e1a0488fd823416f5788c2372a5a41a7a10a548fd8234125f037c4372a5a417c06000000010000006903000000010000000b000000abf0044d8fd82341ab3906c3372a5a41d6e1a0488fd82341a2adb4c3372a5a4191b9c0488fd82341a9dd1ec4372a5a4165481b4a8fd8234125f037c4372a5a4123db474f8fd82341c04718c4372a5a419b016d528fd82341555c2bc4372a5a419b2eba518fd8234182768bc3372a5a41a7a10a548fd82341794dd5c2372a5a41de9b774f8fd823416f5788c2372a5a41b249cc4d8fd823414bc4b0c2372a5a41abf0044d8fd82341ab3906c3372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (334,'os','phalange','gauche','membre supérieur','immature',X'00016a0800002ba298458fd82341df2079c4372a5a41387329508fd82341915c49c5372a5a417c060000000100000069030000000100000007000000387329508fd823416cc6c7c4372a5a41f161244e8fd82341df2079c4372a5a412b5138478fd823417bab7bc4372a5a41e39bf7458fd8234100af9bc4372a5a412ba298458fd82341378909c5372a5a41f083d34d8fd82341915c49c5372a5a41387329508fd823416cc6c7c4372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (335,'os','phalange','gauche','membre supérieur','immature',X'00016a0800007f38c93b8fd82341c8400ac7372a5a4195f54b488fd82341477736c9372a5a417c060000000100000069030000000100000009000000f4669c3f8fd8234134fbdfc7372a5a417f38c93b8fd823416b71edc8372a5a419f3b06468fd82341477736c9372a5a41e73bd9468fd823415d5feec8372a5a41c559eb458fd82341c9e626c8372a5a4195f54b488fd82341f45b4dc7372a5a41e7c2eb478fd82341c8400ac7372a5a41c5d7e93f8fd82341d27d21c7372a5a41f4669c3f8fd8234134fbdfc7372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (336,'os','phalange','gauche','membre supérieur','immature',X'00016a08000063a63f388fd8234123d282c9372a5a41666580468fd8234161a0a3ca372a5a417c06000000010000006903000000010000000a000000662af8448fd82341a64fb3c9372a5a41a2741f428fd8234123d282c9372a5a4117727e3f8fd8234152c185c9372a5a41a4f9a3398fd823414a78e8c9372a5a4163a63f388fd82341cf4f26ca372a5a4141db683a8fd82341d05f77ca372a5a41646be93e8fd823418ef254ca372a5a413b0edf428fd8234161a0a3ca372a5a41666580468fd82341cc7643ca372a5a41662af8448fd82341a64fb3c9372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (337,'os','phalange','gauche','membre supérieur','immature',X'00016a08000019e390648fd82341c4b972ca372a5a41aaa434758fd82341d946f4cc372a5a417c06000000010000006903000000010000000e0000006317876c8fd823418f6b04cb372a5a412ba75d6b8fd82341562350cb372a5a415f7d9a658fd82341fde9edcb372a5a4119e390648fd82341876f2fcc372a5a41f00b376c8fd823416b02dfcc372a5a418a85e76e8fd82341d946f4cc372a5a41e9bc1a718fd82341a8b17bcc372a5a415e8da2728fd82341ce2097cb372a5a41aaa434758fd8234112d17acb372a5a4114c411758fd82341fbfda5ca372a5a41e72d03738fd82341c4b972ca372a5a419e25e86d8fd82341fa6181ca372a5a41a76b576c8fd823417787b2ca372a5a416317876c8fd823418f6b04cb372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (338,'os','phalange','gauche','membre supérieur','immature',X'00016a0800000bb78f5e8fd823418bbcb3cc372a5a412c58a06c8fd82341110a2bce372a5a417c06000000010000006903000000010000000a000000a65a49638fd8234179f99acd372a5a4162efbb688fd82341110a2bce372a5a41b8eb806b8fd8234133b2ffcd372a5a412c58a06c8fd823416cf4b1cd372a5a414e1f066c8fd82341e52d55cd372a5a4199781c658fd823418bbcb3cc372a5a41fc82c9618fd823410927d3cc372a5a410bb78f5e8fd82341f9d636cd372a5a416129585f8fd823416c2ea6cd372a5a41a65a49638fd8234179f99acd372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (339,'os','phalange','gauche','membre supérieur','immature',X'00016a080000cc86a74b8fd8234192e9bace372a5a414ca1fa618fd82341904db9d1372a5a417c0600000001000000690300000001000000100000008f31b2568fd82341dfc632cf372a5a412b6b5c548fd8234153e2fbcf372a5a41c75ec14c8fd823415bfdd5d0372a5a41cc86a74b8fd8234130b71ad1372a5a417128284d8fd82341fefb69d1372a5a41c37f85508fd823415b2167d1372a5a417c1a14568fd82341904db9d1372a5a4197cd35588fd823411d0879d1372a5a41668dba588fd82341807b8dd0372a5a41b1fa93608fd8234167ef96cf372a5a414ca1fa618fd82341a6053fcf372a5a4116328e5d8fd8234101a90fcf372a5a41e05eb85c8fd82341b69ac7ce372a5a41a3811d588fd8234192e9bace372a5a41101b3b568fd823413ae6dcce372a5a418f31b2568fd82341dfc632cf372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (340,'os','phalange','gauche','membre supérieur','immature',X'00016a0800001e66fc468fd82341de42b8d1372a5a41d57716548fd82341c0d018d3372a5a417c06000000010000006903000000010000000a000000fb8e014e8fd823416dcd08d3372a5a4197d1fd508fd82341c0d018d3372a5a41d57716548fd82341681e97d2372a5a4149ac7e518fd823411edf0cd2372a5a41ca03414c8fd82341de42b8d1372a5a41028bb7478fd8234192ec2cd2372a5a411e66fc468fd82341e5ea70d2372a5a417b21f4478fd82341f374abd2372a5a417248f24b8fd823410496bad2372a5a41fb8e014e8fd823416dcd08d3372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (341,'os','phalange','gauche','membre supérieur','immature',X'00016a080000b585c0288fd82341443c5dcf372a5a41a3e4b7348fd8234152998ed0372a5a417c0600000001000000690300000001000000090000001b57a82d8fd82341d3e142d0372a5a41c3bdc8318fd8234152998ed0372a5a41a3e4b7348fd82341a6803ad0372a5a41497479318fd823410e817ccf372a5a419bfe852b8fd82341443c5dcf372a5a417b262d2a8fd82341f6e487cf372a5a41b585c0288fd8234194c230d0372a5a41874e542a8fd82341a3cc51d0372a5a411b57a82d8fd82341d3e142d0372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (342,'os','phalange','gauche','membre supérieur','immature',X'00016a0800002fd1782b8fd823419c7c94cb372a5a41ce5e253f8fd82341717735cf372a5a417c06000000010000006903000000010000000c000000f2d2ae348fd8234100385bcc372a5a41f14c022c8fd823415851b2ce372a5a412fd1782b8fd823418a81ffce372a5a4113bf3a2c8fd82341717735cf372a5a41d29b8b388fd82341c36811cf372a5a4136a50d398fd823414d7590cd372a5a410b9f933b8fd8234187b1c0cc372a5a41ce5e253f8fd823417df854cc372a5a41d507223f8fd823412805cccb372a5a41035f75358fd823419c7c94cb372a5a41e11e40348fd82341aaf4d5cb372a5a41f2d2ae348fd8234100385bcc372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (343,'os','phalange','gauche','membre supérieur','immature',X'00016a08000081adc2078fd82341b76990cb372a5a417a3534168fd8234160290acf372a5a417c0600000001000000690300000001000000100000006b73c10c8fd823417a574fcc372a5a41903f440c8fd82341c7bd25cd372a5a4181adc2078fd823411ebfc8ce372a5a419f5bb8088fd8234160290acf372a5a41a9740b0c8fd823417b8beace372a5a41fd009a118fd82341871ef8ce372a5a4115da25138fd82341dfaacace372a5a4103cfd3128fd823413ea6becc372a5a41f8ad2d168fd8234137ca51cc372a5a417a3534168fd823419f43fecb372a5a414245e0148fd82341f4eebbcb372a5a4198ec51118fd82341aa96d0cb372a5a41da70410f8fd823415e3992cb372a5a410d09c40d8fd82341b76990cb372a5a417949d40a8fd823411a4fe4cb372a5a416b73c10c8fd823417a574fcc372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (344,'os','phalange','gauche','membre supérieur','immature',X'00016a080000b80224088fd82341ab4a50cf372a5a41c9f27c138fd82341015a30d0372a5a417c060000000100000069030000000100000009000000086b030c8fd82341ab4a50cf372a5a41f9a9a5088fd82341d84a98cf372a5a41b80224088fd823410919ebcf372a5a41b26211098fd82341951b20d0372a5a41c379bf0b8fd82341015a30d0372a5a4131c516138fd823418a90f5cf372a5a41c9f27c138fd82341fcedb5cf372a5a418ca5ba118fd82341f18468cf372a5a41086b030c8fd82341ab4a50cf372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (345,'os','phalange','gauche','membre supérieur','immature',X'00016a080000f5fa4b0d8fd823411adbd4c8372a5a417ae3391a8fd82341ceccd6c9372a5a417c060000000100000069030000000100000009000000271e93168fd82341ceccd6c9372a5a41e5222c198fd823413787c1c9372a5a417ae3391a8fd82341092295c9372a5a41637482188fd8234195f0f8c8372a5a412bad24178fd823411adbd4c8372a5a41489d6b118fd82341cfe1e7c8372a5a41f5fa4b0d8fd8234111d990c9372a5a41909e770e8fd82341e8c3d4c9372a5a41271e93168fd82341ceccd6c9372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (346,'os','côte 3','gauche','thorax','immature',X'00016a08000027d1044f8ed82341c8e833fb372a5a412e01d1818ed82341a8efdb02382a5a417c06000000010000006903000000010000001a0000008d4c73818ed8234151a8feff372a5a410bcd4a818ed823417d83bffe372a5a41f38ea97f8ed82341b0e2e3fd372a5a41429e2d7c8ed82341cf311cfd372a5a41a9f2cf758ed82341a8ee34fc372a5a41a4f5786a8ed82341de0087fb372a5a41356f70648ed8234119274dfb372a5a417c61415b8ed82341c8e833fb372a5a41e0cb064f8ed823412c804dfb372a5a4127d1044f8ed82341d4d2dcfb372a5a41560e32508ed8234113b009fc372a5a4125d359668ed82341d09a5efc372a5a41b5f9006c8ed82341d2eba4fc372a5a419fc1d7708ed82341fdbd33fd372a5a4123b168788ed8234119ff88fe372a5a4178dc9a7a8ed82341ced63eff372a5a418e36dd798ed823411abc8f00382a5a4186fbaf778ed823416e9a9c01382a5a41714a0b738ed8234141b07602382a5a410c6842748ed82341a8efdb02382a5a414aa099778ed82341f300c602382a5a41d934a87c8ed82341a54f4602382a5a412e01d1818ed82341cef42f02382a5a417a79b97f8ed82341ae165601382a5a41986c7d818ed82341d526b100382a5a418d4c73818ed8234151a8feff372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (347,'os','côte 5','gauche','thorax','immature',X'00016a080000c3e48b4e8ed82341227768f6372a5a416f1f81a08ed82341e9bf6bfd372a5a417c06000000010000006903000000010000001b000000c4d91e948ed82341501698f9372a5a41e2cb4a8e8ed82341e4248ff8372a5a417ec087878ed823411b6dc5f7372a5a41ec68de808ed82341c85151f7372a5a41fd0b21738ed82341f537c2f6372a5a411ce9fa688ed82341634a78f6372a5a41cd00745f8ed82341227768f6372a5a412d3da9528ed823419762baf6372a5a41c3e48b4e8ed8234135220df7372a5a417b67f94e8ed8234139dee0f7372a5a41ba00a6508ed823410dd814f8372a5a412c7c29598ed8234185d5b3f7372a5a417e4c0c648ed8234194f89af7372a5a41c6b5e8748ed82341122ecff7372a5a413989cd7c8ed82341f67630f8372a5a414fe3fe888ed82341fb4055f9372a5a41d5ad4f8d8ed82341940301fa372a5a4110205f918ed8234148aa67fb372a5a41559f87918ed823411d9834fd372a5a414ab42d958ed82341e9bf6bfd372a5a41385912988ed8234199a831fd372a5a41b752a89b8ed8234162974efc372a5a4106618c9f8ed82341b20a18fc372a5a416f1f81a08ed82341f853e1fb372a5a4105fa409e8ed823414a3828fb372a5a41fc9b3c9a8ed823417cf5ccfa372a5a41c4d91e948ed82341501698f9372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (348,'os','côte 6','gauche','thorax','immature',X'00016a08000066a7064f8ed8234158448af3372a5a413aa323ad8ed82341b74ecbf9372a5a417c06000000010000006903000000010000001e00000031f498588ed823411dc208f5372a5a41286c69668ed82341fcf7a2f4372a5a419ec14a708ed8234183faa7f4372a5a4121b619808ed8234106ac1af5372a5a418d6bad918ed8234141fcfbf5372a5a415946479a8ed82341e7a2c2f6372a5a41920b3fa08ed82341210cd5f7372a5a41af2e9aa18ed8234198ec9cf8372a5a41739aff9d8ed82341ae7b86f9372a5a418880c7a08ed82341b74ecbf9372a5a417337f1a28ed823418354b4f9372a5a411e8bdba68ed8234199e518f9372a5a419bff73ab8ed82341a871f8f8372a5a413aa323ad8ed823418478abf8372a5a415cd25eac8ed82341b09260f8372a5a41ef57b4a68ed823418dbae3f7372a5a4159be21a18ed8234101836cf6372a5a416fea019b8ed82341713670f5372a5a41cdd7ce918ed82341e106a3f4372a5a41b12483848ed823415702ecf3372a5a41d4ad8c7c8ed82341dc02aaf3372a5a41ff247f728ed8234158448af3372a5a41d12921608ed823416492aef3372a5a411a64cc588ed82341e7d7faf3372a5a41636b3e518ed82341926c7ff4372a5a41b011224f8ed82341cb73daf4372a5a4166a7064f8ed82341747d58f5372a5a41d52105508ed823416b8080f5372a5a410553df518ed82341ec977ef5372a5a4131f498588ed823411dc208f5372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (349,'os','côte 6','droit','thorax','immature',X'00016a080000d3cd4a988dd82341589983f3372a5a4154b41cf58dd82341e1b005fa372a5a417c06000000010000006903000000010000001e0000000f7770eb8dd82341386adcf4372a5a4111c852f28dd823413e7148f5372a5a4182142df48dd8234160af47f5372a5a4154b41cf58dd823418b4a1ef5372a5a4172f1d3f48dd823419486a0f4372a5a41c46e97f28dd82341f19e48f4372a5a4119dadbea8dd82341ac0ecff3372a5a412d7f6de38dd82341906d8df3372a5a41061307d18dd82341589983f3372a5a41e3ab07c78dd823417dc6b1f3372a5a4137252bbf8dd82341b62cfff3372a5a41ad8e24b28dd82341d12ac9f4372a5a41e5ef3da98dd823414364a3f5372a5a417e9c7aa38dd82341d242a8f6372a5a41d777709e8dd823412a2427f8372a5a418e7ef4988dd823417effabf8372a5a41d3cd4a988dd82341c0ecf7f8372a5a414d8a159a8dd82341256842f9372a5a419bc3b89e8dd82341b2355cf9372a5a41dcbed9a28dd8234116d7f1f9372a5a412a3a0ba58dd82341e1b005fa372a5a416a9ab9a78dd82341d2ebbcf9372a5a4199f5cba38dd82341e3cad8f8372a5a4114a9dea48dd82341382e0ff8372a5a41ffed71aa8dd823418f74f4f6372a5a415c18c2b28dd82341559721f6372a5a416d4e00c48dd82341e53027f5372a5a4149d6a1d38dd82341d8d59df4372a5a41b9c37edd8dd823418c9c8af4372a5a410f7770eb8dd82341386adcf4372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (350,'os','côte 7','gauche','thorax','immature',X'00016a080000f3e1b34d8ed823418fe677f0372a5a4150b26bb88ed823412806cbf6372a5a417c06000000010000006903000000010000001c000000427326ac8ed82341f46653f4372a5a41f0b8e0a38ed82341e30de9f2372a5a416119829b8ed82341263eeaf1372a5a417b5427908ed82341b63318f1372a5a41b13089838ed82341d907a1f0372a5a4191efa0758ed823418fe677f0372a5a410096ac668ed82341715cb4f0372a5a41c63b88548ed82341d68468f1372a5a410f8e894f8ed82341ead0c1f1372a5a41f3e1b34d8ed82341629516f2372a5a41d43c004e8ed823415c58c2f2372a5a411b31f74f8ed82341a31ae2f2372a5a4189540c538ed823410b07cdf2372a5a41672c2d638ed8234108acd1f1372a5a4105a871698ed82341153ba3f1372a5a410ebeaf778ed82341be87aaf1372a5a4170d3c4858ed82341839fdbf1372a5a4176cebc8b8ed82341cf280ff2372a5a411b04509c8ed8234101c03ef3372a5a4167a1a8a98ed823411b4420f5372a5a41e59a4aab8ed823415552a4f5372a5a415c0959aa8ed823416a9294f6372a5a41924a02ac8ed823412806cbf6372a5a41289c1db78ed82341c72d0df6372a5a4150b26bb88ed823418c01bbf5372a5a418a3e97b68ed82341cb3574f5372a5a41950f66b08ed82341f4e726f5372a5a41427326ac8ed82341f46653f4372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (351,'os','côte 9','gauche','thorax','immature',X'00016a0800008d4f0e4f8ed82341fcef45ea372a5a41be5f39ba8ed823415d3acbef372a5a417c06000000010000006903000000010000001a000000d30511b28ed823417af39fed372a5a41c05e25aa8ed82341d3e4adec372a5a41c91870988ed82341a28156eb372a5a41e23e1b8c8ed82341c659c9ea372a5a41f5bde47a8ed8234186b34dea372a5a41a634186e8ed82341fcef45ea372a5a4113012d608ed82341cc6ba5ea372a5a41200a35538ed82341f4194aeb372a5a4101496b508ed82341cb4397eb372a5a418d4f0e4f8ed823417c7d03ec372a5a419a6e394f8ed82341bbe89bec372a5a418943eb508ed82341ab7bbaec372a5a4198f0425f8ed82341c98eabeb372a5a414752706e8ed82341725357eb372a5a41de75a8788ed82341229d63eb372a5a41f0e9788d8ed823413cfe02ec372a5a418e59289b8ed8234157dac9ec372a5a41840454ab8ed82341209429ee372a5a41085b99ae8ed82341645d98ee372a5a41f82df7af8ed823419b9f83ef372a5a41db4f1bb28ed823415d3acbef372a5a415a1e7db98ed823413353ecee372a5a41be5f39ba8ed82341b8b190ee372a5a415aec6bb98ed8234158782fee372a5a412c6005b58ed82341fca1f2ed372a5a41d30511b28ed823417af39fed372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (352,'os','côte 10','gauche','thorax','immature',X'00016a08000068284f528ed82341cf6bb2e7372a5a41c32bcbb58ed823411add6fec372a5a417c06000000010000006903000000010000001a0000002c2e90a98ed82341997634ea372a5a416ddb7b958ed823412fb5d6e8372a5a41ec33ae838ed8234175750de8372a5a415c3a937b8ed8234158e6d4e7372a5a41b3c1b26c8ed82341cf6bb2e7372a5a413c1b545c8ed82341b55acbe7372a5a41a2bee2548ed8234187e10ce8372a5a4168284f528ed82341d24b8fe8372a5a41ea8a6c528ed8234104a31fe9372a5a4131318d538ed82341c43657e9372a5a418b0739578ed82341c65c0be9372a5a41f96fa35d8ed82341fa22d6e8372a5a41c3fdd96f8ed823417abab7e8372a5a411931b27b8ed82341d3def4e8372a5a41bb1996918ed82341b769bae9372a5a4157ac6b9a8ed823419a2836ea372a5a41260d69ac8ed82341ef1f7ceb372a5a416648d3ad8ed823412805b0eb372a5a415d00baad8ed82341fa2934ec372a5a415d5861af8ed823411add6fec372a5a414e770db28ed8234124b397eb372a5a412ca192b48ed8234150c076eb372a5a41c32bcbb58ed82341e61532eb372a5a4157ee87b38ed82341aa43fcea372a5a4160fd52ae8ed823419b99d2ea372a5a412c2e90a98ed82341997634ea372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (353,'os','côte 11','gauche','thorax','immature',X'00016a0800001619f86e8ed823412437dae4372a5a41d6d87aac8ed82341077f14e9372a5a417c060000000100000069030000000100000011000000122947a38ed8234178f756e7372a5a41bbd14a958ed82341aad43ee6372a5a41086374838ed823410dfa3be5372a5a41a4ceb8778ed823412437dae4372a5a411619f86e8ed82341db0ae9e4372a5a41de101b738ed823417aef2ae5372a5a418e14997e8ed8234162c78be5372a5a4146321e978ed82341b27c01e7372a5a41b165ad9e8ed82341039ab3e7372a5a410cadf2a48ed82341e5f8d3e8372a5a41039c28aa8ed82341077f14e9372a5a41f66149ac8ed82341b21e0fe9372a5a41d6d87aac8ed8234142efd8e8372a5a41f7632daa8ed82341c196a1e8372a5a4192397ba98ed823410194d2e7372a5a414bcfe7a68ed82341f89786e7372a5a41122947a38ed8234178f756e7372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (354,'os','côte 12','gauche','thorax','immature',X'00016a080000aa04f57b8ed823411fb515e2372a5a413030a6a38ed823412c3e2ae6372a5a417c06000000010000006903000000010000000d000000e49e1a9e8ed82341c34f85e4372a5a41c8de3d958ed82341a7b5a9e3372a5a414ff3f7858ed82341b0737fe2372a5a41aa04f57b8ed823411fb515e2372a5a4101760f7e8ed82341947166e2372a5a413382cf868ed82341824b20e3372a5a41c29a51998ed82341e2a3fbe4372a5a41b644a29c8ed82341bdfb0be6372a5a41f2f070a28ed823412c3e2ae6372a5a413030a6a38ed82341f4b8f5e5372a5a4132dc6ba28ed82341d5f899e5372a5a41f70f65a28ed8234183e915e5372a5a41e49e1a9e8ed82341c34f85e4372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (355,'os','phalange','gauche','membre supérieur','immature',X'00016a08000085ac41bb8ed8234131057bc6372a5a41c5e042c38ed82341f873c1c7372a5a417c06000000010000006903000000010000000a00000085ac41bb8ed8234140e0cfc6372a5a415458cfbb8ed82341012787c7372a5a4137cf02bd8ed82341f873c1c7372a5a41c700d2bf8ed82341d4c978c7372a5a41c5e042c38ed82341b40b55c7372a5a41d22a13c38ed82341099a27c7372a5a412f00cfc08ed823418a0d0cc7372a5a41df6fa0bd8ed8234131057bc6372a5a411d7322bc8ed82341cd167ec6372a5a4185ac41bb8ed8234140e0cfc6372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (356,'os','phalange','gauche','membre supérieur','immature',X'00016a080000422031bd8ed823419f92f2c7372a5a41820931c58ed82341912ac1c8372a5a417c060000000100000069030000000100000009000000b7a60dc58ed82341a31b15c8372a5a41b57dcdc28ed823419f92f2c7372a5a412109edbe8ed8234141700cc8372a5a414d0758bd8ed82341f27a3fc8372a5a41422031bd8ed82341a13d8dc8372a5a4100247cbf8ed82341912ac1c8372a5a41ea1f5cc28ed823414d7a78c8372a5a41820931c58ed823412de878c8372a5a41b7a60dc58ed82341a31b15c8372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (357,'os','phalange','gauche','membre supérieur','immature',X'00016a0800002a04e3bd8ed8234128bdeac8372a5a41271697c98ed823410b86deca372a5a417c06000000010000006903000000010000000a000000b4e65ac18ed823419b124dca372a5a41d81055c18ed82341ebccb9ca372a5a418a3e91c28ed823410b86deca372a5a4112f3dfc78ed823418069b5ca372a5a41271697c98ed823411c286fca372a5a4158bf0ac78ed82341c46bcdc9372a5a41190f28c58ed8234128bdeac8372a5a412a04e3bd8ed823412c4a75c9372a5a41e0e881c08ed823415665ddc9372a5a41b4e65ac18ed823419b124dca372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (358,'os','phalange','gauche','membre supérieur','immature',X'00016a080000bfc6a5c18ed82341edd810cb372a5a415e51a4cc8ed82341aa273ecc372a5a417c060000000100000069030000000100000009000000cd3bb7c68ed8234167b039cb372a5a414cdde6c28ed82341a5585fcb372a5a41bfc6a5c18ed823418bbe8fcb372a5a41ca52ddc28ed8234169d400cc372a5a419b92fdc48ed82341aa273ecc372a5a415e51a4cc8ed823419edcb4cb372a5a41d1fb69ca8ed82341651a1ccb372a5a4179cdb2c88ed82341edd810cb372a5a41cd3bb7c68ed8234167b039cb372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (359,'os','phalange','gauche','membre supérieur','immature',X'00016a08000006f8f8e88ed82341a864e6c2372a5a41db97a7f28ed823411ca041c4372a5a417c06000000010000006903000000010000000a000000da449aeb8ed82341251b53c3372a5a41f60c9aeb8ed823411800a1c3372a5a419adc38e98ed82341cc45f0c3372a5a4106f8f8e88ed823411ca041c4372a5a41731439f28ed82341586341c4372a5a41db97a7f28ed8234194d8fec3372a5a41bc6836f08ed823411218d1c3372a5a412474ffed8ed82341a864e6c2372a5a41ec92ceec8ed82341f83ef0c2372a5a41da449aeb8ed82341251b53c3372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (360,'os','phalange','gauche','membre supérieur','immature',X'00016a0800003786a4e88ed823416c9a8cc4372a5a41daf77ff38ed8234197ee43c5372a5a417c060000000100000069030000000100000009000000924125f18ed823416c9a8cc4372a5a4129d996ea8ed8234165b18cc4372a5a415cbeb2e88ed823410d15dbc4372a5a413786a4e88ed823419c840fc5372a5a414b56dcea8ed8234197ee43c5372a5a41a57c49ef8ed8234126ac25c5372a5a41111dbdf28ed8234123f636c5372a5a41daf77ff38ed82341139ec6c4372a5a41924125f18ed823416c9a8cc4372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (361,'os','phalange','gauche','membre supérieur','immature',X'00016a08000078ee3fe98ed8234105f5f7c6372a5a41e99ad8f28ed82341eb29edc8372a5a417c06000000010000006903000000010000000b0000006cfa93ea8ed82341b084b6c7372a5a4178ee3fe98ed823419fcc7ec8372a5a416a413fea8ed823415268c6c8372a5a416e06f5ec8ed82341eb29edc8372a5a4137a78bf28ed823415065bfc8372a5a41e99ad8f28ed82341cf1898c8372a5a4184ca68f18ed82341ff3b4dc8372a5a41bf8e4ef28ed8234123fa5cc7372a5a41b01838f18ed8234105f5f7c6372a5a418912f3e98ed823415d7e33c7372a5a416cfa93ea8ed82341b084b6c7372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (369,'os','patella','gauche','membre inférieur','immature',X'00016a08000067cdba798ed823418c0128c1372a5a41b6ef82918ed823416de9d5c4372a5a417c0600000001000000690300000001000000110000006e022e7c8ed823411c7a48c2372a5a410b4e267a8ed82341d637b7c2372a5a4167cdba798ed82341fde938c3372a5a41b6436b7b8ed82341275238c4372a5a417bf97c7d8ed82341cfa7bfc4372a5a410c8655808ed823416de9d5c4372a5a41b8b38e858ed82341852888c4372a5a41706edd8b8ed82341325f65c4372a5a4144f6458e8ed8234123f92ec4372a5a41a123d5908ed82341761b9ec3372a5a41b6ef82918ed823415caa07c3372a5a413a8d5c908ed82341e8114fc2372a5a41b3328e8d8ed8234196d7cdc1372a5a41674ffa848ed823413eaf34c1372a5a415ccd45828ed823418c0128c1372a5a41340f51808ed82341800057c1372a5a416e022e7c8ed823411c7a48c2372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (376,'os','côte 1','gauche','thorax','immature',X'00016a08000003005c468ed82341e4cbe3fe372a5a41feaca05f8ed8234157872103382a5a417c06000000010000006903000000010000001600000035b6c04d8ed82341afa2b9ff372a5a41cb56aa538ed82341c787ceff372a5a41ab9847578ed82341f4711600382a5a412be819598ed8234103159b00382a5a41ebc18f588ed82341f1215501382a5a416ae81a578ed8234191a9b901382a5a41b74349538ed82341726d0502382a5a41cd9d5c4d8ed82341ae002702382a5a4103005c468ed823411d092102382a5a4193ccd9468ed82341c4c5ae02382a5a419716f04b8ed8234141c0ae02382a5a4167b6d34f8ed823417cb41503382a5a412bcac9528ed8234157872103382a5a4152671c558ed823414b59ff02382a5a41b446b8568ed82341b8e49602382a5a41feac125e8ed823415668aa01382a5a41feaca05f8ed82341bf070101382a5a410989945f8ed82341bd085e00382a5a411c76fc5b8ed8234131ee6cff372a5a419b3f74558ed82341e4cbe3fe372a5a4123c2c14d8ed82341c779ecfe372a5a4135b6c04d8ed82341afa2b9ff372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (377,'os','côte 2','gauche','thorax','immature',X'00016a080000bcb7c14e8ed823414db62ffd372a5a4143e101728ed8234196237203382a5a417c06000000010000006903000000010000001c00000036facb648ed8234158e03403382a5a41c05ef2678ed8234196237203382a5a41587df06c8ed823416dcd6603382a5a415ef2fa6d8ed82341fb794703382a5a41785f036f8ed82341a698b601382a5a417234e9718ed8234159193500382a5a4143e101728ed8234141d95cff372a5a41b8c6dd708ed823415478cffe372a5a418e03066d8ed823415d1e33fe372a5a4172f672638ed823418b9f57fd372a5a4169e0f75b8ed823414db62ffd372a5a41d190c04f8ed823410ed049fd372a5a41bcb7c14e8ed82341ee9a8afd372a5a41e4a9b24f8ed82341897302fe372a5a41ac151b5b8ed82341b2611afe372a5a411f5da95f8ed82341a24e46fe372a5a41c5ce7f658ed82341e60dbdfe372a5a41eea6096c8ed82341ca2790ff372a5a41db84be6c8ed82341755a8f00382a5a41e4fbc0678ed82341cb652c02382a5a415f82b1648ed82341d1068202382a5a41c053115d8ed823413aa38902382a5a41e0e8cd5a8ed823410a21cb02382a5a411a6c0a5b8ed823411dd93a03382a5a411f19225c8ed8234191565803382a5a4184b6405f8ed82341350e6403382a5a4167f678618ed8234158e03403382a5a4136facb648ed8234158e03403382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (378,'os','dent','droit','crâne','immature',X'00016a0800006280027d8fd82341e62c4435382a5a41c7ba1a998fd82341f43ff638382a5a417c060000000100000069030000000100000005000000c7ba1a998fd82341e62c4435382a5a416280027d8fd82341e62c4435382a5a416280027d8fd82341f43ff638382a5a41c7ba1a998fd82341f43ff638382a5a41c7ba1a998fd82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (379,'os','dent','droit','crâne','immature',X'00016a080000c7ba1a998fd82341e62c4435382a5a41183cb1b48fd82341f43ff638382a5a417c060000000100000069030000000100000005000000183cb1b48fd82341e62c4435382a5a41c7ba1a998fd82341e62c4435382a5a41c7ba1a998fd82341f43ff638382a5a41183cb1b48fd82341f43ff638382a5a41183cb1b48fd82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (393,'os','os temporal','droit','crâne','immature',X'00016a080000af8f90778dd8234110c38718382a5a4108d8f6b58dd823414174ab1e382a5a417c0600000001000000690300000001000000240000000bb69d8a8dd8234110c38718382a5a41c4f7d7868dd82341f67a3019382a5a4167be6b858dd8234166d2d619382a5a41fd369d7d8dd8234156c9071a382a5a41e579fb798dd823412e59571a382a5a414128d8778dd823415dbebc1a382a5a41af8f90778dd82341c7c8191b382a5a4147b096788dd82341dd31641b382a5a41d21d717e8dd8234198e4601b382a5a41940d7a7f8dd82341c5097f1b382a5a410434a27c8dd82341ca30c71c382a5a410087277e8dd82341c6fb551d382a5a41a70485878dd82341c853571e382a5a412c7ac3948dd823414174ab1e382a5a41012e53a88dd82341b047a81e382a5a41886009b08dd8234168a3661e382a5a4108d8f6b58dd82341ae61f41d382a5a411b83bcb58dd82341f4b20f1d382a5a41647a82b38dd82341b569fb1c382a5a41f95f5cb28dd82341f690c71c382a5a418cb1fcb18dd82341d3c7b61b382a5a414704a9b08dd82341abdc7a1b382a5a41080658ae8dd8234157f9651b382a5a41b78be2ab8dd8234192219d1a382a5a4196750aa88dd82341920f561a382a5a413ee414a38dd823413fb9491a382a5a41361c33a08dd82341e0d06c1a382a5a41027bd89d8dd823415cd3db1a382a5a41758c159a8dd8234180bad51a382a5a41260c4b998dd82341151c751a382a5a41f670379c8dd82341bbeca819382a5a4184e5e39a8dd82341a5754c19382a5a41319b9d978dd82341cb821319382a5a418a833d938dd8234126cd2d19382a5a41f139c2918dd8234196669018382a5a410bb69d8a8dd8234110c38718382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (394,'os','dent','droit','crâne','immature',X'00016a0800001be0bef18ed82341d9199231382a5a411ca8ac148fd82341e62c4435382a5a417c0600000001000000690300000001000000050000001ca8ac148fd82341e62c4435382a5a411ca8ac148fd82341d9199231382a5a411be0bef18ed82341d9199231382a5a411be0bef18ed82341e62c4435382a5a411ca8ac148fd82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (395,'os','dent','droit','crâne','immature',X'00016a0800001ca8ac148fd82341d9199231382a5a41a6fd1a378fd82341e62c4435382a5a417c060000000100000069030000000100000005000000a6fd1a378fd82341e62c4435382a5a41a6fd1a378fd82341d9199231382a5a411ca8ac148fd82341d9199231382a5a411ca8ac148fd82341e62c4435382a5a41a6fd1a378fd82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (396,'os','dent','droit','crâne','immature',X'00016a080000a6fd1a378fd82341d9199231382a5a41571e56598fd82341e62c4435382a5a417c060000000100000069030000000100000005000000571e56598fd82341e62c4435382a5a41571e56598fd82341d9199231382a5a41a6fd1a378fd82341d9199231382a5a41a6fd1a378fd82341e62c4435382a5a41571e56598fd82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (397,'os','dent','droit','crâne','immature',X'00016a080000571e56598fd82341d9199231382a5a416280027d8fd82341be221b36382a5a417c0600000001000000690300000001000000050000006280027d8fd82341be221b36382a5a416280027d8fd82341d9199231382a5a41571e56598fd82341d9199231382a5a41571e56598fd823416bc69034382a5a416280027d8fd82341be221b36382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (398,'os','dent','droit','crâne','immature',X'00016a0800001b8e8aab8ed82341e62c4435382a5a411ab7a4ce8ed82341f43ff638382a5a417c0600000001000000690300000001000000050000001ab7a4ce8ed82341e62c4435382a5a411b8e8aab8ed82341e62c4435382a5a411b8e8aab8ed82341f43ff638382a5a411ab7a4ce8ed82341f43ff638382a5a411ab7a4ce8ed82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (399,'os','dent','droit','crâne','immature',X'00016a0800001ab7a4ce8ed82341e62c4435382a5a411be0bef18ed82341f43ff638382a5a417c0600000001000000690300000001000000050000001be0bef18ed82341e62c4435382a5a411ab7a4ce8ed82341e62c4435382a5a411ab7a4ce8ed82341f43ff638382a5a411be0bef18ed82341f43ff638382a5a411be0bef18ed82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (400,'os','dent','droit','crâne','immature',X'00016a0800001be0bef18ed82341e62c4435382a5a411ca8ac148fd82341f43ff638382a5a417c0600000001000000690300000001000000050000001ca8ac148fd82341e62c4435382a5a411be0bef18ed82341e62c4435382a5a411be0bef18ed82341f43ff638382a5a411ca8ac148fd82341f43ff638382a5a411ca8ac148fd82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (401,'os','dent','droit','crâne','immature',X'00016a0800001ca8ac148fd82341e62c4435382a5a41a6fd1a378fd82341f43ff638382a5a417c060000000100000069030000000100000005000000a6fd1a378fd82341e62c4435382a5a411ca8ac148fd82341e62c4435382a5a411ca8ac148fd82341f43ff638382a5a41a6fd1a378fd82341f43ff638382a5a41a6fd1a378fd82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (402,'os','dent','droit','crâne','immature',X'00016a080000a6fd1a378fd82341e62c4435382a5a41571e56598fd82341f43ff638382a5a417c060000000100000069030000000100000005000000571e56598fd82341e62c4435382a5a41a6fd1a378fd82341e62c4435382a5a41a6fd1a378fd82341f43ff638382a5a41571e56598fd82341f43ff638382a5a41571e56598fd82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (403,'os','dent','droit','crâne','immature',X'00016a080000571e56598fd823416bc69034382a5a416280027d8fd82341f43ff638382a5a417c0600000001000000690300000001000000050000006280027d8fd82341be221b36382a5a41571e56598fd823416bc69034382a5a41571e56598fd82341f43ff638382a5a416280027d8fd82341f43ff638382a5a416280027d8fd82341be221b36382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (404,'os','dent','gauche','crâne','immature',X'00016a080000c02b47d08fd82341d9199231382a5a41cdf75fec8fd82341e62c4435382a5a417c060000000100000069030000000100000005000000c02b47d08fd82341e62c4435382a5a41cdf75fec8fd82341e62c4435382a5a41cdf75fec8fd82341d9199231382a5a41c02b47d08fd82341d9199231382a5a41c02b47d08fd82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (405,'os','dent','gauche','crâne','immature',X'00016a080000183cb1b48fd82341d9199231382a5a41c02b47d08fd82341e62c4435382a5a417c060000000100000069030000000100000005000000183cb1b48fd82341e62c4435382a5a41c02b47d08fd82341e62c4435382a5a41c02b47d08fd82341d9199231382a5a41183cb1b48fd82341d9199231382a5a41183cb1b48fd82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (406,'os','dent','gauche','crâne','immature',X'00016a080000c02b47d08fd82341e62c4435382a5a41cdf75fec8fd82341f43ff638382a5a417c060000000100000069030000000100000005000000c02b47d08fd82341e62c4435382a5a41c02b47d08fd82341f43ff638382a5a41cdf75fec8fd82341f43ff638382a5a41cdf75fec8fd82341e62c4435382a5a41c02b47d08fd82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (407,'os','dent','gauche','crâne','immature',X'00016a080000183cb1b48fd82341e62c4435382a5a41c02b47d08fd82341f43ff638382a5a417c060000000100000069030000000100000005000000183cb1b48fd82341e62c4435382a5a41183cb1b48fd82341f43ff638382a5a41c02b47d08fd82341f43ff638382a5a41c02b47d08fd82341e62c4435382a5a41183cb1b48fd82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (408,'os','dent','droit','crâne','immature',X'00016a0800006280027d8fd82341d9199231382a5a41c7ba1a998fd82341e62c4435382a5a417c060000000100000069030000000100000005000000c7ba1a998fd82341e62c4435382a5a41c7ba1a998fd82341d9199231382a5a416280027d8fd82341d9199231382a5a416280027d8fd82341e62c4435382a5a41c7ba1a998fd82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (409,'os','dent','droit','crâne','immature',X'00016a080000c7ba1a998fd82341d9199231382a5a41183cb1b48fd82341e62c4435382a5a417c060000000100000069030000000100000005000000183cb1b48fd82341e62c4435382a5a41183cb1b48fd82341d9199231382a5a41c7ba1a998fd82341d9199231382a5a41c7ba1a998fd82341e62c4435382a5a41183cb1b48fd82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (412,'os','dent','gauche','crâne','immature',X'00016a0800006c2fbd9a90d82341d9199231382a5a416e58d7bd90d82341e62c4435382a5a417c0600000001000000690300000001000000050000006c2fbd9a90d82341e62c4435382a5a416e58d7bd90d82341e62c4435382a5a416e58d7bd90d82341d9199231382a5a416c2fbd9a90d82341d9199231382a5a416c2fbd9a90d82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (413,'os','dent','gauche','crâne','immature',X'00016a0800001398a37790d82341d9199231382a5a416c2fbd9a90d82341e62c4435382a5a417c0600000001000000690300000001000000050000001398a37790d82341e62c4435382a5a416c2fbd9a90d82341e62c4435382a5a416c2fbd9a90d82341d9199231382a5a411398a37790d82341d9199231382a5a411398a37790d82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (414,'os','dent','gauche','crâne','immature',X'00016a08000008248b5490d82341d9199231382a5a411398a37790d82341e62c4435382a5a417c06000000010000006903000000010000000500000008248b5490d82341e62c4435382a5a411398a37790d82341e62c4435382a5a411398a37790d82341d9199231382a5a4108248b5490d82341d9199231382a5a4108248b5490d82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (415,'os','dent','gauche','crâne','immature',X'00016a0800001269f43190d82341d9199231382a5a4108248b5490d82341e62c4435382a5a417c0600000001000000690300000001000000050000001269f43190d82341e62c4435382a5a4108248b5490d82341e62c4435382a5a4108248b5490d82341d9199231382a5a411269f43190d82341d9199231382a5a411269f43190d82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (416,'os','dent','gauche','crâne','immature',X'00016a0800001ed1e20f90d82341d9199231382a5a411269f43190d82341e62c4435382a5a417c0600000001000000690300000001000000050000001ed1e20f90d82341e62c4435382a5a411269f43190d82341e62c4435382a5a411269f43190d82341d9199231382a5a411ed1e20f90d82341d9199231382a5a411ed1e20f90d82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (417,'os','dent','gauche','crâne','immature',X'00016a080000cdf75fec8fd82341d9199231382a5a411ed1e20f90d82341be221b36382a5a417c060000000100000069030000000100000005000000cdf75fec8fd82341be221b36382a5a411ed1e20f90d823416bc69034382a5a411ed1e20f90d82341d9199231382a5a41cdf75fec8fd82341d9199231382a5a41cdf75fec8fd82341be221b36382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (418,'os','dent','gauche','crâne','immature',X'00016a0800006c2fbd9a90d82341e62c4435382a5a416e58d7bd90d82341f43ff638382a5a417c0600000001000000690300000001000000050000006c2fbd9a90d82341e62c4435382a5a416c2fbd9a90d82341f43ff638382a5a416e58d7bd90d82341f43ff638382a5a416e58d7bd90d82341e62c4435382a5a416c2fbd9a90d82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (419,'os','dent','gauche','crâne','immature',X'00016a0800001398a37790d82341e62c4435382a5a416c2fbd9a90d82341f43ff638382a5a417c0600000001000000690300000001000000050000001398a37790d82341e62c4435382a5a411398a37790d82341f43ff638382a5a416c2fbd9a90d82341f43ff638382a5a416c2fbd9a90d82341e62c4435382a5a411398a37790d82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (420,'os','dent','gauche','crâne','immature',X'00016a08000008248b5490d82341e62c4435382a5a411398a37790d82341f43ff638382a5a417c06000000010000006903000000010000000500000008248b5490d82341e62c4435382a5a4108248b5490d82341f43ff638382a5a411398a37790d82341f43ff638382a5a411398a37790d82341e62c4435382a5a4108248b5490d82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (421,'os','dent','gauche','crâne','immature',X'00016a0800001269f43190d82341e62c4435382a5a4108248b5490d82341f43ff638382a5a417c0600000001000000690300000001000000050000001269f43190d82341e62c4435382a5a411269f43190d82341f43ff638382a5a4108248b5490d82341f43ff638382a5a4108248b5490d82341e62c4435382a5a411269f43190d82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (422,'os','dent','gauche','crâne','immature',X'00016a0800001ed1e20f90d82341e62c4435382a5a411269f43190d82341f43ff638382a5a417c0600000001000000690300000001000000050000001ed1e20f90d82341e62c4435382a5a411ed1e20f90d82341f43ff638382a5a411269f43190d82341f43ff638382a5a411269f43190d82341e62c4435382a5a411ed1e20f90d82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (423,'os','dent','gauche','crâne','immature',X'00016a080000cdf75fec8fd823416bc69034382a5a411ed1e20f90d82341f43ff638382a5a417c060000000100000069030000000100000005000000cdf75fec8fd82341be221b36382a5a41cdf75fec8fd82341f43ff638382a5a411ed1e20f90d82341f43ff638382a5a411ed1e20f90d823416bc69034382a5a41cdf75fec8fd82341be221b36382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (424,'os','dent','droit','crâne','immature',X'00016a0800001b8e8aab8ed82341d9199231382a5a411ab7a4ce8ed82341e62c4435382a5a417c0600000001000000690300000001000000050000001ab7a4ce8ed82341e62c4435382a5a411ab7a4ce8ed82341d9199231382a5a411b8e8aab8ed82341d9199231382a5a411b8e8aab8ed82341e62c4435382a5a411ab7a4ce8ed82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (425,'os','dent','droit','crâne','immature',X'00016a0800001ab7a4ce8ed82341d9199231382a5a411be0bef18ed82341e62c4435382a5a417c0600000001000000690300000001000000050000001be0bef18ed82341e62c4435382a5a411be0bef18ed82341d9199231382a5a411ab7a4ce8ed82341d9199231382a5a411ab7a4ce8ed82341e62c4435382a5a411be0bef18ed82341e62c4435382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (426,'os','capitatum','gauche','membre supérieur','immature',X'00016a0800003df281fc8ed82341007ca5d9372a5a41a473f80a8fd823416e385ddc372a5a417c06000000010000006903000000010000000e0000007c4995018fd82341acf7f5d9372a5a413df281fc8ed823411b17e2d9372a5a41eb4366fd8ed823419c967cda372a5a4128e1bbff8ed823410b43fada372a5a4165c7e2fe8ed82341e1e562db372a5a418a3d59ff8ed823413178c7db372a5a41a268ce018fd823411d4d48dc372a5a41a64ca1038fd823416e385ddc372a5a41e049170a8fd8234116bcf3db372a5a417b2703088fd823415c46f3da372a5a41a473f80a8fd823415551d8d9372a5a4123b2eb088fd82341007ca5d9372a5a412b9127058fd82341eac5fad9372a5a417c4995018fd82341acf7f5d9372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (427,'os','hamatum','gauche','membre supérieur','immature',X'00016a0800003da063e28ed82341835bd9d9372a5a4143dd40fb8ed823415a49c7db372a5a417c06000000010000006903000000010000000e00000049f82fee8ed8234110cd2cda372a5a41480a5bec8ed82341835bd9d9372a5a41575f30e98ed823418f3de2d9372a5a4133b8c7e28ed823410913aada372a5a413da063e28ed823414be903db372a5a41384048e58ed8234144e21cdb372a5a413fc4a0eb8ed823410ff20adb372a5a4175c2b0ed8ed82341b3dc4edb372a5a4131831df28ed82341e80691db372a5a4143dd40fb8ed823415a49c7db372a5a41dcdda6f58ed82341e18bb1da372a5a416ea28bf58ed82341d92fe9d9372a5a41a1f0d8f08ed823416b5ae3d9372a5a4149f82fee8ed8234110cd2cda372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (428,'os','triquetrum','gauche','membre supérieur','immature',X'00016a08000077e22be68ed8234138c6a3db372a5a41693313f58ed823418c2bafdd372a5a417c06000000010000006903000000010000000b000000113571e88ed8234150f4e6db372a5a4177e22be68ed823415d5f72dc372a5a41117544e68ed82341fe4c15dd372a5a4145b409ef8ed823418c2bafdd372a5a41c53d2ef28ed82341309098dd372a5a41693313f58ed82341f8ae29dd372a5a419a1ec1f38ed82341211bbbdc372a5a413a57d5ed8ed823414d085edc372a5a41900fa2ea8ed8234138c6a3db372a5a418f687fe98ed82341585ca8db372a5a41113571e88ed8234150f4e6db372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (429,'os','pisiforme','gauche','membre supérieur','immature',X'00016a0800000ea997de8ed82341f4d061dd372a5a4172a72fea8ed82341039bc7de372a5a417c060000000100000069030000000100000009000000851226e78ed823412d3db4dd372a5a415c9b8de08ed82341f4d061dd372a5a410ea997de8ed823415b988bdd372a5a41dab058df8ed823412f3c2fde372a5a4128c8e9e48ed82341039bc7de372a5a41a385a3e78ed823410b5ea9de372a5a4172a72fea8ed8234191f607de372a5a418951bde98ed82341d742a3dd372a5a41851226e78ed823412d3db4dd372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (430,'os','lunatum','gauche','membre supérieur','immature',X'00016a080000f8acf7f48ed82341c832fddc372a5a4184bf58068fd82341a8b81edf372a5a417c06000000010000006903000000010000000b0000001c5b30fa8ed8234110bf4fdd372a5a410cb3dbf58ed82341e9fe9bdd372a5a41f8acf7f48ed82341373f2fde372a5a41a88e55f88ed823414662f5de372a5a41c70bf0fc8ed82341a8b81edf372a5a41c820e3028fd82341e95db2de372a5a41c4d221038fd82341137dfadd372a5a4184bf58068fd823414d8e3ddd372a5a419f4b8b048fd823415e360ddd372a5a41df0527008fd82341c832fddc372a5a411c5b30fa8ed8234110bf4fdd372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (439,'os','clavicule','gauche','ceinture scapulaire','immature',X'00016a08000083d4bc7a8ed82341f8e01506382a5a41b2f05db88ed82341d56d6a08382a5a417c060000000100000069030000000100000014000000228de9878ed82341aaf72407382a5a41e278db918ed8234130175d07382a5a41b740fda48ed82341d56d6a08382a5a41e9b723a78ed823411a675c08382a5a41d48572a88ed82341c33f2908382a5a41b70a88b58ed8234110daac07382a5a4143a5cbb78ed823417ac97c07382a5a41b2f05db88ed8234170df4407382a5a41887202b78ed82341548cc506382a5a41735c12b58ed8234125429b06382a5a418f3085af8ed823415c92c106382a5a4159ef6aa88ed82341e30d5707382a5a411a50e9a38ed823419b646207382a5a4112e5c6978ed82341c2710d07382a5a414f37f68a8ed823410fe54b06382a5a41c8d0977c8ed82341f8e01506382a5a4183d4bc7a8ed823418bba2706382a5a41968afd7a8ed82341b40e4c07382a5a41cedec67b8ed82341d3fb6f07382a5a41228de9878ed82341aaf72407382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (450,'os','cuboïde','droit','membre inférieur','immature',X'00016a0800000932b69c8dd82341aec63398372a5a41c01165be8dd823414419cc9c372a5a417c060000000100000069030000000100000011000000cc7e62b58dd8234144c3bb98372a5a411032bdb18dd82341aec63398372a5a417ab405ae8dd823419c4e3798372a5a418b85f3a48dd82341fe451399372a5a410932b69c8dd823411aa68b9a372a5a4137b8099d8dd823418ed9ec9a372a5a41491479a58dd823417ca5b79b372a5a4138a5a9aa8dd823414419cc9c372a5a412d7e6eac8dd82341aa31b89c372a5a418822e2af8dd8234196121e9c372a5a41a1416eb28dd8234184431e9c372a5a41052414b98dd82341fb5c6d9c372a5a417f6bafbb8dd8234132ff569c372a5a41a76b79bd8dd82341b5220b9c372a5a41c01165be8dd8234136e7bd99372a5a41b00a80bc8dd8234170e36399372a5a41cc7e62b58dd8234144c3bb98372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (451,'os','cunéiforme médial','droit','membre inférieur','immature',X'00016a08000066f04db68dd82341d2085e96372a5a41966c75ce8dd82341c8e75299372a5a417c06000000010000006903000000010000000d0000006dcc74b88dd8234197194d98372a5a413063a8c28dd82341c8e75299372a5a411c9881c48dd82341f6c64199372a5a41c20838c98dd823410827ad98372a5a41966c75ce8dd8234148d57798372a5a4113dc69c58dd82341cce63597372a5a41cf1e2cc58dd82341fc39fe96372a5a4109216ec78dd82341944b9796372a5a4196923fc48dd82341d2085e96372a5a4192042cbc8dd8234181676e96372a5a415b336cba8dd82341b9bb8f96372a5a4166f04db68dd82341c58e7997372a5a416dcc74b88dd8234197194d98372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (452,'os','cunéiforme intermédiaire','droit','membre inférieur','immature',X'00016a080000294bcacd8dd823410d7be795372a5a416629eedb8dd8234136473c98372a5a417c06000000010000006903000000010000000a000000f0efa5d98dd82341b2308c96372a5a41614f97d68dd823410d7be795372a5a41443bd5d48dd823413ab4f995372a5a41d38d4dd28dd8234153ee5a96372a5a4160711acf8dd82341dc3f5196372a5a41294bcacd8dd8234174801397372a5a413e641cd38dd8234136473c98372a5a41bd4ac6db8dd8234132219397372a5a416629eedb8dd8234138363097372a5a41f0efa5d98dd82341b2308c96372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (453,'os','cunéiforme latéral','droit','membre inférieur','immature',X'00016a0800000cf26cdd8dd823413d9e2595372a5a41ba96c4ed8dd8234106066e97372a5a417c06000000010000006903000000010000000e00000082a515e08dd82341a6c83d95372a5a41c4adb2de8dd823413d9e2595372a5a412cafd7dd8dd82341e8813b95372a5a410cf26cdd8dd8234145013996372a5a41197df1df8dd8234190fca996372a5a41f6b061e08dd82341f8c65397372a5a41ef9134e28dd8234106066e97372a5a41ef4b58e88dd823417e196b97372a5a41e34d2aea8dd8234117563197372a5a41b718b9ed8dd82341c1a43396372a5a41ba96c4ed8dd82341f5c88795372a5a41e3ad4dec8dd82341ac856795372a5a4112de9be68dd82341cebf6c95372a5a4182a515e08dd82341a6c83d95372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (454,'os','scaphoïde','droit','membre inférieur','immature',X'00016a080000ccc546ca8dd823418ff58d98372a5a417f953bf18dd82341d210329b372a5a417c060000000100000069030000000100000012000000f8fe71cb8dd823410ba8fc99372a5a41dd6c91ce8dd82341735ab39a372a5a41c84f30d58dd823415194969a372a5a417df15ad98dd8234199ff3d9a372a5a41236317dc8dd823416117369a372a5a41e60f73e28dd82341adaf769a372a5a41363f3aea8dd82341d210329b372a5a4195ea8cf08dd8234171f4a19a372a5a417f953bf18dd82341fe43749a372a5a41ce7512f08dd82341ddcad299372a5a414e4f83ec8dd8234154902699372a5a4187edb4e88dd82341da60c798372a5a41587712e48dd823414df0a198372a5a41b23b8fdb8dd823418ff58d98372a5a41045833d58dd823414200c498372a5a41a1b42acb8dd8234176119799372a5a41ccc546ca8dd82341b81cce99372a5a41f8fe71cb8dd823410ba8fc99372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (455,'os','talus','droit','membre inférieur','immature',X'00016a080000696317ca8dd823414d76339b372a5a419fc297f28dd8234173fb37a2372a5a417c06000000010000006903000000010000001500000090848be38dd82341f4ef889b372a5a41b80588e28dd823417bf74f9b372a5a413eef7fe08dd823414d76339b372a5a41de9807d48dd82341f51c519b372a5a41bac568cd8dd82341d3d3259c372a5a41696317ca8dd823415c38e89c372a5a41443ee1cc8dd82341896ed89d372a5a41d8635dcd8dd82341ac134e9f372a5a412a4039d88dd823416e5ac3a0372a5a4140844cda8dd8234146d832a1372a5a413acf27dc8dd823412b9b05a2372a5a41ba7d10de8dd8234173fb37a2372a5a41e90926e68dd823418de7b1a1372a5a417e02f6ed8dd8234181bed8a0372a5a4168db0ff18dd82341cfa62ea0372a5a41c02d90f28dd82341e5ce2d9f372a5a419fc297f28dd823413552619e372a5a414c3e1ef18dd8234136d5c79d372a5a41041472ee8dd82341c33e5a9d372a5a41073cc3e48dd82341ca26629c372a5a4190848be38dd82341f4ef889b372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (510,'os','phalange','droit','membre supérieur','immature',X'00016a080000f530047c8dd82341ea0db7ca372a5a41498202878dd82341a963e4cb372a5a417c060000000100000069030000000100000009000000d10df1818dd823414cdddfca372a5a41b772f57f8dd82341ea0db7ca372a5a41a1963e7e8dd823414a47c2ca372a5a41f530047c8dd8234161175bcb372a5a41021aab838dd82341a963e4cb372a5a41352fcb858dd823417901a7cb372a5a41498202878dd823412bfb35cb372a5a41c6a3c1858dd82341f08c05cb372a5a41d10df1818dd823414cdddfca372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (511,'os','phalange','droit','membre supérieur','immature',X'00016a080000be9ce3528dd82341dcf2eec8372a5a4123af055f8dd82341a4f5e9c9372a5a417c0600000001000000690300000001000000070000005f93c05a8dd82341dcf2eec8372a5a4154c073558dd8234123f1f9c8372a5a41be9ce3528dd82341a22360c9372a5a413f742f538dd82341126bb4c9372a5a417183ac5e8dd82341a4f5e9c9372a5a4123af055f8dd82341d0174fc9372a5a415f93c05a8dd82341dcf2eec8372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (512,'os','métacarpien','droit','membre supérieur','immature',X'00016a080000d1a345128dd8234189a13cd7372a5a417f2af9218dd82341070addd8372a5a417c060000000100000069030000000100000009000000d1a345128dd8234115a364d8372a5a414a3655128dd82341ee74c2d8372a5a41a8b77f138dd82341070addd8372a5a417b6f74178dd82341b7aab3d8372a5a419f6c4c198dd8234106bd3dd8372a5a417f2af9218dd82341ae941ad8372a5a4165f891208dd823411c29a9d7372a5a4152a9c31b8dd8234189a13cd7372a5a41d1a345128dd8234115a364d8372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (527,'os','clavicule','droit','ceinture scapulaire','immature',X'00016a0800002324638b8dd823413ce0ef05382a5a41974904c98dd823411d774408382a5a417c0600000001000000690300000001000000140000003f53d7bb8dd8234144fdfe06382a5a41ee0cfac78dd823416d014a07382a5a414c57c3c88dd8234150142607382a5a41974904c98dd82341e6ba0106382a5a41e03b29c78dd823413ce0ef05382a5a4188d0cab88dd823417ee62506382a5a41fe00faab8dd823418174e706382a5a41d488d79f8dd8234108673c07382a5a4152c0559b8dd82341de103107382a5a41f1c63b948dd82341ec969b06382a5a413bdaae8e8dd82341e9427506382a5a41f8bbbe8c8dd823418d899f06382a5a412324638b8dd82341a5dd1e07382a5a41ed7cf58b8dd82341a6c95607382a5a41ae56de8d8dd82341bc7b8107382a5a4161a34e9b8dd823415f450308382a5a414c719d9c8dd82341ce6d3608382a5a417ee8c39e8dd823411d774408382a5a41f4aae5b18dd8234180193707382a5a413f53d7bb8dd8234144fdfe06382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (533,'os','manubrium','axial','thorax','immature',X'00016a080000627b39118ed82341e3e47ef4372a5a4154ab1a358ed8234180598cf9372a5a417c060000000100000069030000000100000013000000a8ef28238ed82341e93f8df4372a5a4144cb091d8ed8234195527ff4372a5a417627e4168ed8234164b611f6372a5a41627b39118ed823410802d7f6372a5a417fcc88138ed8234167e5bbf7372a5a4196ffad138ed82341d37170f8372a5a411018a9188ed82341c782faf8372a5a41407b131b8ed82341fd2d8cf9372a5a41c941771e8ed823410feb54f9372a5a41e161ce248ed82341513d4af9372a5a41eb7088288ed82341d1b15af9372a5a41154d3f2b8ed8234180598cf9372a5a4175c97d2d8ed8234118f200f9372a5a41d267a0328ed82341a3ae70f8372a5a410c33dc328ed82341ecdfaef7372a5a4154ab1a358ed823411253d6f6372a5a41a63ab22f8ed8234139261ff6372a5a41ec2446298ed82341e3e47ef4372a5a41a8ef28238ed82341e93f8df4372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (539,'os','côte 1','droit','thorax','immature',X'00016a080000896ea7e28dd82341e4cbe3fe372a5a416539ecfb8dd8234157872103382a5a417c060000000100000069030000000100000016000000538387f48dd82341afa2b9ff372a5a41657786f48dd82341c779ecfe372a5a413c0bd4ec8dd82341e4cbe3fe372a5a418d004ce68dd8234131ee6cff372a5a41dcbcb3e28dd82341bd085e00382a5a41896ea7e28dd82341bf070101382a5a41df8235e48dd823415668aa01382a5a41b72790eb8dd82341b8e49602382a5a41ab142ced8dd823414b59ff02382a5a4188977eef8dd8234157872103382a5a41968e74f28dd823417cb41503382a5a413d1658f68dd8234141c0ae02382a5a4123246efb8dd82341c4c5ae02382a5a416539ecfb8dd823411d092102382a5a41cab4ebf48dd82341ae002702382a5a41dc15ffee8dd82341726d0502382a5a41da612deb8dd8234191a9b901382a5a419c77b8e98dd82341f1215501382a5a415d512ee98dd8234103159b00382a5a41dda000eb8dd82341f4711600382a5a41bce29dee8dd82341c787ceff372a5a41538387f48dd82341afa2b9ff372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (540,'os','côte 2','droit','thorax','immature',X'00016a080000245846d08dd823414db62ffd372a5a413aca86f38dd8234196237203382a5a417c06000000010000006903000000010000001c000000523f7cdd8dd8234158e03403382a5a415dfacee08dd8234158e03403382a5a410de507e38dd82341350e6403382a5a41964726e68dd8234191565803382a5a41fbcd3de78dd823411dd93a03382a5a4118737ae78dd823410a21cb02382a5a41372a37e58dd823413aa38902382a5a4171ae96dd8dd82341d1068202382a5a41d62887da8dd82341cb652c02382a5a4102bb89d58dd82341755a8f00382a5a411ec63ed68dd82341ca2790ff372a5a41ac7cc8dc8dd82341e60dbdfe372a5a415ade9ee28dd82341a24e46fe372a5a41ec232de78dd82341b2611afe372a5a4149c395f28dd82341897302fe372a5a413aca86f38dd82341ee9a8afd372a5a41a1df87f28dd823410ed049fd372a5a41b95050e68dd823414db62ffd372a5a41bc1bd5de8dd823418b9f57fd372a5a41b22142d58dd823415d1e33fe372a5a414e706ad18dd823415478cffe372a5a41245846d08dd8234141d95cff372a5a41071a5fd08dd8234159193500382a5a411bda44d38dd82341a698b601382a5a411e194dd48dd82341fb794703382a5a4150bb57d58dd823416dcd6603382a5a41f2ed55da8dd8234196237203382a5a41523f7cdd8dd8234158e03403382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (541,'os','côte 3','droit','thorax','immature',X'00016a08000079af77c08dd82341c8e833fb372a5a41edad43f38dd82341a8efdb02382a5a417c06000000010000006903000000010000001a000000ce35d5c08dd8234151a8feff372a5a4154f8cac08dd82341d526b100382a5a411cb18ec28dd82341ae165601382a5a4179af77c08dd82341cef42f02382a5a41f744a0c58dd82341a54f4602382a5a4112e2aeca8dd82341f300c602382a5a41d10906ce8dd82341a8efdb02382a5a41ce663dcf8dd8234141b07602382a5a41054a98ca8dd823416e9a9c01382a5a41d5286bc88dd823411abc8f00382a5a41a09badc78dd82341ced63eff372a5a412e9edfc98dd8234119ff88fe372a5a41167b70d18dd82341fdbd33fd372a5a418e1347d68dd82341d2eba4fc372a5a41921eeedb8dd82341d09a5efc372a5a41825416f28dd8234113b009fc372a5a41edad43f38dd82341d4d2dcfb372a5a41e4ab41f38dd823412c804dfb372a5a41de0f07e78dd82341c8e833fb372a5a416611d8dd8dd8234119274dfb372a5a41ad8ccfd78dd82341de0087fb372a5a41b28f78cc8dd82341a8ee34fc372a5a411ae41ac68dd82341cf311cfd372a5a4169f39ec28dd82341b0e2e3fd372a5a4150b5fdc08dd823417d83bffe372a5a41ce35d5c08dd8234151a8feff372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (542,'os','côte 4','droit','thorax','immature',X'00016a0800001d5498ae8dd8234145cc5df9372a5a4127b0b8f38dd82341786ed800382a5a417c06000000010000006903000000010000001a000000b0fd85b38dd8234166dcc0fd372a5a41d85fa1b28dd823418a84f1fe372a5a4143d8afae8dd823415b748aff372a5a411d5498ae8dd823415055d3ff372a5a41cbfe5ab08dd823415c6d2400382a5a417447b7b38dd82341ffa55000382a5a41ebefc5b78dd823414bbbc500382a5a41fa07b0ba8dd82341786ed800382a5a41844606bd8dd82341ab4e9200382a5a41f37a59b88dd82341d1d09bff372a5a41b76788ba8dd8234122b6e2fd372a5a41e18616bd8dd8234166aa1dfd372a5a41d06ab6c58dd823414f5bb2fb372a5a41842255cc8dd8234150921afb372a5a411a15e0da8dd8234144a274fa372a5a4137e254e48dd8234143e74ffa372a5a41eefbd4f18dd82341ff165afa372a5a4100703df38dd823416cbd2efa372a5a4127b0b8f38dd823418d4584f9372a5a41003505e88dd8234145cc5df9372a5a41c5317ed88dd8234136fd73f9372a5a41ee1ef1cf8dd82341b715b5f9372a5a41465c84c68dd82341afee4cfa372a5a417aaee9bf8dd82341ae62d5fa372a5a41f45eecba8dd82341ecee86fb372a5a41b0fd85b38dd8234166dcc0fd372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (543,'os','côte 4','gauche','thorax','immature',X'00016a080000cb83da4c8ed82341f6ab4bf9372a5a411b7214938ed8234135ada500382a5a417c06000000010000006903000000010000001a0000004850c98d8ed82341a33589fd372a5a410e1ffe858ed8234196ac54fb372a5a411fbde1808ed82341d8b1a6fa372a5a41a4662f7a8ed82341baf422fa372a5a41f920a8708ed8234141d591f9372a5a41d56a10688ed82341ded156f9372a5a410eb086588ed82341f6ab4bf9372a5a41cb83da4c8ed82341db697af9372a5a419e0a744d8ed823410f8324fa372a5a417414e44e8ed8234111d74efa372a5a410036615c8ed823414a183bfa372a5a41f8b9db658ed82341402059fa372a5a410b2083748ed82341f4b1f4fa372a5a416c703c7b8ed82341c3c087fb372a5a4141841c848ed82341cbd7ecfc372a5a413f5bcd868ed823412a0ab0fd372a5a41647b4a898ed82341c67a67ff372a5a41ac94c9848ed82341cd386100382a5a41a04b2c878ed8234135ada500382a5a418abe128a8ed8234164e89000382a5a4127660c8e8ed82341c3f61800382a5a4146ea5f918ed823413f5eeaff372a5a411b7214938ed82341ba1098ff372a5a410221f0928ed82341a4474fff372a5a418701e48e8ed823415324b9fe372a5a414850c98d8ed82341a33589fd372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (544,'os','côte 5','droit','thorax','immature',X'00016a0800007909c7a18dd82341227768f6372a5a412465bcf38dd82341e9bf6bfd372a5a417c06000000010000006903000000010000001b000000c35f29ae8dd82341501698f9372a5a4164b80ba88dd823417cf5ccfa372a5a41dba507a48dd823414a3828fb372a5a417909c7a18dd82341f853e1fb372a5a4156c1bba28dd82341b20a18fc372a5a41a3f29fa68dd8234162974efc372a5a41481136aa8dd8234199a831fd372a5a4105771aad8dd82341e9bf6bfd372a5a41a2bec0b08dd823411d9834fd372a5a41601fe9b08dd8234148aa67fb372a5a41589ff8b48dd82341940301fa372a5a41436749b98dd82341fb4055f9372a5a41199e7ac58dd82341f67630f8372a5a410ba95fcd8dd82341122ecff7372a5a41a7013cde8dd8234194f89af7372a5a418fe31ee98dd8234185d5b3f7372a5a41a281a2f18dd823410dd814f8372a5a41e01a4ff38dd8234139dee0f7372a5a412465bcf38dd8234135220df7372a5a41f2fc9eef8dd823419762baf6372a5a416139d4e28dd82341227768f6372a5a411a594dd98dd82341634a78f6372a5a416e5527cf8dd82341f537c2f6372a5a411df769c18dd82341c85151f7372a5a41689dc0ba8dd823411b6dc5f7372a5a417d8afdb38dd82341e4248ff8372a5a41c35f29ae8dd82341501698f9372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (545,'os','côte 7','droit','thorax','immature',X'00016a0800006293dc898dd823418fe677f0372a5a41325194f48dd823412806cbf6372a5a417c06000000010000006903000000010000001c000000717d21968dd82341f46653f4372a5a41fb65e2918dd82341f4e726f5372a5a4119efb08b8dd82341cb3574f5372a5a416293dc898dd823418c01bbf5372a5a4172b72a8b8dd82341c72d0df6372a5a41d53b46968dd823412806cbf6372a5a410379ef978dd823416a9294f6372a5a4160c9fd968dd823415552a4f5372a5a415acd9f988dd823411b4420f5372a5a414b4af8a58dd8234101c03ef3372a5a41608b8bb68dd82341cf280ff2372a5a41767383bc8dd82341839fdbf1372a5a41699b98ca8dd82341be87aaf1372a5a414899d6d88dd82341153ba3f1372a5a41230d1bdf8dd8234108acd1f1372a5a4108e53bef8dd823410b07cdf2372a5a41f32551f28dd82341a31ae2f2372a5a41f91148f48dd823415c58c2f2372a5a41325194f48dd82341629516f2372a5a411c8fbef28dd82341ead0c1f1372a5a4129babfed8dd82341d68468f1372a5a41ccce9bdb8dd82341715cb4f0372a5a41e867a7cc8dd823418fe677f0372a5a412400bfbe8dd82341d907a1f0372a5a4163e220b28dd82341b63318f1372a5a410f61c6a68dd82341263eeaf1372a5a417a61679e8dd82341e30de9f2372a5a41717d21968dd82341f46653f4372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (546,'os','côte 8','droit','thorax','immature',X'00016a080000ec8dae868dd82341c3fc69ed372a5a41e6bf82f18dd82341696640f4372a5a417c06000000010000006903000000010000001a000000fb1c53918dd8234175b0c8f1372a5a412680f08b8dd823415562a2f2372a5a41ec8dae868dd8234175ac07f3372a5a41c17166888dd8234154a277f3372a5a413109c28e8dd82341696640f4372a5a41fb1c53918dd82341c9bdf4f3372a5a41f1a3cd918dd82341022d33f3372a5a413ca213938dd8234151ebd8f2372a5a41b2a9319f8dd823413c5b4ef1372a5a41a00f6da88dd82341814a5bf0372a5a41558ab0b88dd8234190923eef372a5a415601e3c48dd82341d951b8ee372a5a41c82c0ad58dd82341a77c7fee372a5a41635b79df8dd82341fe90b3ee372a5a4149444ef08dd82341529a62ef372a5a41e6bf82f18dd82341b19031ef372a5a41a296e8f08dd8234198cd7cee372a5a413533b3ef8dd82341e85538ee372a5a4127f13bed8dd82341dd2107ee372a5a41e13af7df8dd823418d2094ed372a5a41cd360ed38dd82341c3fc69ed372a5a4117a20ac88dd823410d1c94ed372a5a41b17f51b68dd82341820f3aee372a5a415c8130ad8dd82341dae9b7ee372a5a4163e0cc988dd82341aa8a97f0372a5a41fb1c53918dd8234175b0c8f1372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (547,'os','côte 8','gauche','thorax','immature',X'00016a08000039fcce4a8ed82341836b8eed372a5a4115f9d4b88ed82341bf4240f3372a5a417c06000000010000006903000000010000001a0000001216feac8ed823410369d8f0372a5a41bd335aa48ed8234196a1c8ef372a5a4104a2338e8ed823412c0a41ee372a5a416b6ea4848ed82341d2e6e9ed372a5a41287265728ed82341836b8eed372a5a412bfb4d678ed82341de0d92ed372a5a416f08ac5a8ed82341bb12f1ed372a5a41a575fa4d8ed82341abcd99ee372a5a415b34bb4b8ed8234166c2d4ee372a5a4139fcce4a8ed82341c3a51def372a5a417980f04a8ed823415b66d3ef372a5a41a801554c8ed823414a11ffef372a5a41528b515c8ed823418a0f0cef372a5a41b2f274668ed823416768adee372a5a41f6d6b3768ed82341f826a3ee372a5a41c4ef56838ed82341b404f6ee372a5a4191e19c948ed823417056cdef372a5a414526bf9e8ed823418c4498f0372a5a41296a5aac8ed82341d292edf1372a5a41126afaad8ed823412cd441f2372a5a4181073baf8ed82341cfcdfff2372a5a41b9c214b28ed82341bf4240f3372a5a41a50b94b78ed82341dbf65ef2372a5a4115f9d4b88ed823419edae8f1372a5a419d7535b38ed8234190159af1372a5a411216feac8ed823410369d8f0372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (548,'os','côte 9','droit','thorax','immature',X'00016a080000702b0f888dd82341fcef45ea372a5a41d8273af38dd823415d3acbef372a5a417c06000000010000006903000000010000001a000000b53337908dd823417af39fed372a5a415cd9428d8dd82341fca1f2ed372a5a410a8bdc888dd8234158782fee372a5a41702b0f888dd82341b8b190ee372a5a41895fcb888dd823413353ecee372a5a4191322d908dd823415d3acbef372a5a41c29851928dd823419b9f83ef372a5a41d605af938dd82341645d98ee372a5a412344f4968dd82341209429ee372a5a416ae71fa78dd8234157dac9ec372a5a414294cfb48dd823413cfe02ec372a5a4196b99fc98dd82341229d63eb372a5a41531fd8d38dd82341725357eb372a5a41f26c05e38dd82341c98eabeb372a5a4163305df18dd82341ab7bbaec372a5a4162120ff38dd82341bbe89bec372a5a41d8273af38dd823417c7d03ec372a5a419911ddf18dd82341cb4397eb372a5a41c53813ef8dd82341f4194aeb372a5a41dd661be28dd82341cc6ba5ea372a5a41ee3430d48dd82341fcef45ea372a5a41208463c78dd8234186b34dea372a5a4144fe2cb68dd82341c659c9ea372a5a419c4ed8a98dd82341a28156eb372a5a41f5bc22988dd82341d3e4adec372a5a41b53337908dd823417af39fed372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (549,'os','côte 10','droit','thorax','immature',X'00016a080000e8027d8c8dd82341cf6bb2e7372a5a41732ff9ef8dd823411add6fec372a5a417c06000000010000006903000000010000001a0000005c0bb8988dd82341997634ea372a5a419f6cf5938dd823419b99d2ea372a5a41d820c08e8dd82341aa43fcea372a5a41e8027d8c8dd82341e61532eb372a5a417686b58d8dd8234150c076eb372a5a41b4df3a908dd8234124b397eb372a5a41682ce7928dd823411add6fec372a5a41252e8e948dd82341fa2934ec372a5a419bfe74948dd823412805b0eb372a5a411b3edf958dd82341ef1f7ceb372a5a41337bdca78dd823419a2836ea372a5a41a036b2b08dd82341b769bae9372a5a41df2396c68dd82341d3def4e8372a5a41a96d6ed28dd823417abab7e8372a5a410ff2a4e48dd82341fa22d6e8372a5a417a790feb8dd82341c65c0be9372a5a41d638bbee8dd82341c43657e9372a5a4131bbdbef8dd8234104a31fe9372a5a41732ff9ef8dd82341d24b8fe8372a5a418a9f65ed8dd8234187e10ce8372a5a410b58f4e58dd82341b55acbe7372a5a41158e95d58dd82341cf6bb2e7372a5a414201b5c68dd8234158e6d4e7372a5a41a0059abe8dd8234175750de8372a5a415140ccac8dd823412fb5d6e8372a5a415c0bb8988dd82341997634ea372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (550,'os','côte 11','droit','thorax','immature',X'00016a080000015acd958dd823412437dae4372a5a414a2e50d38dd82341077f14e9372a5a417c0600000001000000690300000001000000110000007710019f8dd8234178f756e7372a5a415891609b8dd82341f89786e7372a5a41b541cd988dd823410194d2e7372a5a418af91a988dd82341c196a1e8372a5a41015acd958dd8234142efd8e8372a5a4176d5fe958dd82341b21e0fe9372a5a41ede51f988dd82341077f14e9372a5a41a29d559d8dd82341e5f8d3e8372a5a41f4ee9aa38dd82341039ab3e7372a5a41090c2aab8dd82341b27c01e7372a5a41d60aafc38dd8234162c78be5372a5a41be332dcf8dd823417aef2ae5372a5a414a2e50d38dd82341db0ae9e4372a5a41776f8fca8dd823412437dae4372a5a4180e6d3be8dd823410dfa3be5372a5a41fa2efdac8dd82341aad43ee6372a5a417710019f8dd8234178f756e7372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (551,'os','côte 12','droit','thorax','immature',X'00016a0800006c16a29e8dd823411fb515e2372a5a41194753c68dd823412c3e2ae6372a5a417c06000000010000006903000000010000000d0000004c2c2ea48dd82341c34f85e4372a5a4147e4e29f8dd8234183e915e5372a5a41693cdc9f8dd82341d5f899e5372a5a416c16a29e8dd82341f4b8f5e5372a5a41a533d79f8dd823412c3e2ae6372a5a417822a6a58dd82341bdfb0be6372a5a41649ff6a88dd82341e2a3fbe4372a5a41e6d578bb8dd82341824b20e3372a5a418ff338c48dd82341947166e2372a5a41194753c68dd823411fb515e2372a5a41504750bc8dd82341b0737fe2372a5a4139880aad8dd82341a7b5a9e3372a5a414c2c2ea48dd82341c34f85e4372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (563,'os','sésamoïde','gauche','membre inférieur','immature',X'00016a080000d56e03588ed823419a2dde8f372a5a410083f35d8ed82341fa070b91372a5a417c060000000100000069030000000100000008000000028eba598ed82341c145d090372a5a4199f81d5c8ed82341fa070b91372a5a410083f35d8ed823414aacc590372a5a41aebbea5b8ed823419a2dde8f372a5a410b3e48598ed823411decde8f372a5a416a6f94588ed8234120e4fd8f372a5a41d56e03588ed8234150f16990372a5a41028eba598ed82341c145d090372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (564,'os','sésamoïde','gauche','membre inférieur','immature',X'00016a080000f551b3728ed82341bf59978f372a5a41af0416788ed82341a957ce90372a5a417c0600000001000000690300000001000000080000000219de738ed823414ddf8790372a5a412dbbeb758ed82341a957ce90372a5a41af0416788ed8234158889390372a5a410fb644778ed823411b80a48f372a5a41ae84aa748ed82341bf59978f372a5a417f21d0738ed82341e836b28f372a5a41f551b3728ed82341d6d11990372a5a410219de738ed823414ddf8790372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (565,'os','sésamoïde','droit','membre inférieur','immature',X'00016a080000517548f58dd823419f3f9a8f372a5a41546038fb8dd82341c310c790372a5a417c0600000001000000690300000001000000080000004f6a81f98dd82341535a8c90372a5a41546038fb8dd8234121f52590372a5a414e83a7fa8dd8234182f9b98f372a5a412dbaf3f98dd823416cf49a8f372a5a414c2051f78dd823419f3f9a8f372a5a41517548f58dd8234193b68190372a5a41b8ff1df78dd82341c310c790372a5a414f6a81f98dd82341535a8c90372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (566,'os','sésamoïde','droit','membre inférieur','immature',X'00016a08000084b725db8dd823417861538f372a5a41b77388e08dd82341bd5d8a90372a5a417c06000000010000006903000000010000000800000022285edf8dd82341abe14390372a5a41b77388e08dd8234132d4d58f372a5a415d856bdf8dd823419e466e8f372a5a413e7e91de8dd823417861538f372a5a41ea25f7db8dd82341a892608f372a5a4184b725db8dd8234168924f90372a5a416e4350dd8dd82341bd5d8a90372a5a4122285edf8dd82341abe14390372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (570,'os','pisiforme','droit','membre supérieur','immature',X'00016a08000093904f5b8dd823410d1008dd372a5a41d88ee7668dd8234110da6dde372a5a417c0600000001000000690300000001000000090000007bde585e8dd823417d8e5add372a5a414ca0c15b8dd82341e68449dd372a5a4193904f5b8dd82341f833aedd372a5a41517edb5d8dd82341e5984fde372a5a41c25a95608dd8234110da6dde372a5a419a9626668dd82341a770d5dd372a5a41d88ee7668dd8234187cf31dd372a5a41769ef1648dd823410d1008dd372a5a417bde585e8dd823417d8e5add372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (571,'os','lunatum','droit','membre supérieur','immature',X'00016a080000b778263f8dd823418d71a3dc372a5a41995b87508dd8234114eac4de372a5a417c06000000010000006903000000010000000b000000b9de4e4b8dd82341f7ebf5dc372a5a4140fb57458dd823418d71a3dc372a5a411fdbf3408dd82341607eb3dc372a5a41b778263f8dd8234149d7e3dc372a5a418a1e5d428dd8234142bca0dd372a5a4155e09b428dd82341e99358de372a5a41eaf98e488dd8234114eac4de372a5a413937294d8dd82341df929bde372a5a41995b87508dd82341a573d5dd372a5a417c66a34f8dd82341342e42dd372a5a41b9de4e4b8dd82341f7ebf5dc372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (586,'os','métacarpien','droit','membre supérieur','immature',X'00016a080000d50e1a658dd8234196d4aad3372a5a41fddec5738dd82341f7ab63d5372a5a417c06000000010000006903000000010000000c000000bcae9f6f8dd82341c6ebf4d3372a5a41aa7cfd6b8dd8234196d4aad3372a5a410fe05e698dd82341bbdeb1d3372a5a41869ec7658dd82341028460d4372a5a41d50e1a658dd823415c2fbcd4372a5a416d285b6a8dd82341bccfe6d4372a5a41a7566a6d8dd82341f7ab63d5372a5a4190de09718dd8234152e850d5372a5a4192621f738dd82341e1c8f2d4372a5a41fddec5738dd8234138e38cd4372a5a41806497728dd82341d4ee36d4372a5a41bcae9f6f8dd82341c6ebf4d3372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (587,'os','métacarpien','droit','membre supérieur','immature',X'00016a080000afee9c4a8dd8234169e8d2d1372a5a41a4dceb598dd8234174e46cd3372a5a417c06000000010000006903000000010000000c000000c57730558dd823410533f8d1372a5a419f52f7508dd8234169e8d2d1372a5a41ff7c334b8dd823415cc103d2372a5a41afee9c4a8dd82341bf05b6d2372a5a412c6a954b8dd82341e57807d3372a5a41768dc7508dd8234133b01ad3372a5a415726f2548dd8234174e46cd3372a5a416bcc97578dd82341742f55d3372a5a417ac7a1598dd823413367f8d2372a5a41a4dceb598dd82341e2869ed2372a5a41460899588dd823418ea84bd2372a5a41c57730558dd823410533f8d1372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (588,'os','métacarpien','droit','membre supérieur','immature',X'00016a080000893465358dd823416cc6dad0372a5a41c29c95428dd8234100ab5bd2372a5a417c06000000010000006903000000010000000b000000893465358dd823412f1afed1372a5a41d571a9368dd8234100ab5bd2372a5a413298023a8dd8234160d431d2372a5a413d18d13f8dd823416bb259d2372a5a4165153e428dd8234166762cd2372a5a41c29c95428dd823416d9aa6d1372a5a412f595f408dd82341936f3ed1372a5a41ec535a398dd823416cc6dad0372a5a41ce53b5378dd823410029fbd0372a5a410d3a87358dd82341708977d1372a5a41893465358dd823412f1afed1372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (589,'os','métacarpien','droit','membre supérieur','immature',X'00016a080000892cd65c8dd8234158104cd5372a5a41d65ab56e8dd82341973ea0d9372a5a417c06000000010000006903000000010000000e000000464ed16a8dd823417e29e4d6372a5a41d65ab56e8dd82341916914d6372a5a4108c9ee6d8dd82341c9bbd6d5372a5a41f4ed7e6b8dd82341d8c4aed5372a5a41557908698dd8234158104cd5372a5a41d0e5b0668dd823412e599ad5372a5a41627b99658dd82341be94a0d6372a5a41892cd65c8dd82341c9cacfd8372a5a411d208c5d8dd82341a0f809d9372a5a41efee97618dd82341c72739d9372a5a41fe7958658dd82341973ea0d9372a5a41cb1f6f678dd82341c3b570d9372a5a41dc569f688dd823416f72bed7372a5a41464ed16a8dd823417e29e4d6372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (590,'os','métacarpien','droit','membre supérieur','immature',X'00016a080000d50ee14d8dd8234185eaa5d3372a5a413a328d5a8dd82341f46abbd8372a5a417c06000000010000006903000000010000000d000000ac22d44f8dd8234119a894d4372a5a41adbc4e518dd8234128644ad5372a5a415612ed508dd82341de56ded6372a5a41d50ee14d8dd82341c0a56bd8372a5a41fb137d4f8dd82341307aa4d8372a5a4191c31e588dd82341f46abbd8372a5a413a328d5a8dd823410a8c78d8372a5a4118d336578dd823417d2b55d6372a5a4151ee9a578dd82341edd3ecd3372a5a41653c20548dd8234185eaa5d3372a5a4169869d4f8dd8234118ddc8d3372a5a41d35a6a4e8dd82341861c18d4372a5a41ac22d44f8dd8234119a894d4372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (591,'os','métacarpien','droit','membre supérieur','immature',X'00016a0800007c0493388dd82341fe210ad3372a5a41a9ded8458dd82341786054d8372a5a417c06000000010000006903000000010000000f0000008c3a98418dd8234118ba00d4372a5a4198be62438dd823411fcd84d3372a5a41f9a8b7428dd823415f9516d3372a5a41e3a65b398dd82341fe210ad3372a5a417c0493388dd823413d3a67d3372a5a419bc4143c8dd82341e925abd4372a5a41f5b77e3b8dd82341a80da9d6372a5a41e4265e3a8dd82341374b6fd7372a5a4174e36f3b8dd823413dbda2d7372a5a41a11b6c3f8dd82341c31ad9d7372a5a413f304a448dd82341786054d8372a5a41b4f47c458dd8234143ea3ed8372a5a41a9ded8458dd82341c82d05d8372a5a411df7fc418dd82341b05e2ed6372a5a418c3a98418dd8234118ba00d4372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (592,'os','métacarpien','droit','membre supérieur','immature',X'00016a0800000739f2168dd8234142f893d1372a5a41a196ec248dd8234153aefdd2372a5a417c06000000010000006903000000010000000b000000d996fe1c8dd823417fd69dd2372a5a41e88c931f8dd8234187ba5ed2372a5a411923a4248dd82341a16587d2372a5a41a196ec248dd823412e4d11d2372a5a416f66de238dd823411b5ebad1372a5a41c5e63d208dd8234142f893d1372a5a41335a52188dd823419274b1d1372a5a410739f2168dd82341ad5c55d2372a5a411ccba1178dd82341d44abed2372a5a41427bd61a8dd8234153aefdd2372a5a41d996fe1c8dd823417fd69dd2372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (593,'os','métacarpien','droit','membre supérieur','immature',X'00016a080000907a691c8dd823412f0bd6d2372a5a413a349c358dd8234187e3d3d7372a5a417c06000000010000006903000000010000000f000000ae8558278dd823414da0c5d3372a5a41ce46d7268dd823414f8221d3372a5a417851a4258dd823412f0bd6d2372a5a41e15502208dd823418c443bd3372a5a41907a691c8dd82341a2a437d3372a5a413bf055268dd8234168f62cd6372a5a414a46f9288dd82341f45987d7372a5a418116602a8dd82341b814c4d7372a5a4166ef762c8dd8234187e3d3d7372a5a418d8af32e8dd82341fa2cafd7372a5a416365a12f8dd8234121835ed7372a5a410ad6bc338dd82341d65477d7372a5a413a349c358dd82341316d49d7372a5a416f6d9c2b8dd82341f77279d5372a5a41ae8558278dd823414da0c5d3372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (594,'os','métacarpien','droit','membre supérieur','immature',X'00016a0800008bd0f5fd8cd82341c6dff3d3372a5a419b4648198dd82341d5c218d8372a5a417c060000000100000069030000000100000010000000cb6079088dd823411ae63bd4372a5a418021b6058dd82341c6dff3d3372a5a41e6c114028dd82341431704d4372a5a41cff056fe8cd823410fb777d4372a5a418bd0f5fd8cd823410c46efd4372a5a41be8c720b8dd823419fa073d7372a5a416f38220f8dd8234119cafbd7372a5a419e176d118dd82341d5c218d8372a5a41b1f84a148dd82341647482d7372a5a41821787188dd82341a21a44d7372a5a419b4648198dd823419a5e16d7372a5a41b08e48178dd82341fc42d6d6372a5a41f50646118dd82341afdb89d6372a5a410188ce0b8dd823417464b1d5372a5a41ec93f3088dd823411de804d5372a5a41cb6079088dd823411ae63bd4372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (596,'os','trapèze','droit','membre supérieur','immature',X'00016a080000aec553188dd82341cfd980d9372a5a4155c530298dd82341681fe0db372a5a417c06000000010000006903000000010000000d000000745980278dd8234126a451da372a5a41065a1f278dd82341983ab5d9372a5a41fb8cb3238dd82341cfd980d9372a5a41ce8f141f8dd8234130ed1ada372a5a41ec49221a8dd8234169be52da372a5a41aec553188dd82341ed3c9cda372a5a41b164851d8dd823414a2139db372a5a4151559b1f8dd82341c45bc6db372a5a411fd424218dd82341681fe0db372a5a41a1112d248dd823415ec267db372a5a41792f10298dd82341fa2f15db372a5a4155c530298dd823416b16bcda372a5a41745980278dd8234126a451da372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (597,'os','trapézoïde','droit','membre supérieur','immature',X'00016a0800006126952c8dd82341c31f4bd9372a5a417abef8358dd82341f43faeda372a5a417c06000000010000006903000000010000000a000000801e9d318dd82341239a84d9372a5a418fc0d92d8dd82341c31f4bd9372a5a416126952c8dd82341479659d9372a5a410fd69e2d8dd823410e544ada372a5a4130690f308dd82341f68ba3da372a5a41fa315a348dd82341f43faeda372a5a417abef8358dd82341cff95ada372a5a417ab4d9358dd82341724a69d9372a5a41e436f4338dd82341c8b352d9372a5a41801e9d318dd82341239a84d9372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (598,'os','scaphoïde','droit','membre supérieur','immature',X'00016a0800004ce17e288dd823414ee553db372a5a4187efd4398dd82341694ad1dd372a5a417c06000000010000006903000000010000000b000000314161368dd82341fe2371dc372a5a41cc8347358dd8234192577cdb372a5a41be6052308dd823414ee553db372a5a4196bd9b2d8dd82341d4b56cdb372a5a414ce17e288dd82341627d4edc372a5a41a89743298dd82341cf538fdc372a5a414615f4308dd823419c7691dd372a5a41e24e51378dd82341694ad1dd372a5a410a0263398dd823415376b0dd372a5a4187efd4398dd82341d6a766dd372a5a41314161368dd82341fe2371dc372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (599,'os','capitatum','droit','membre supérieur','immature',X'00016a080000e582863a8dd82341b2b14bd9372a5a41001dfd488dd82341ca6f03dc372a5a417c06000000010000006903000000010000000e00000058f0e9438dd82341fb489cd9372a5a41aaa857408dd82341be06a1d9372a5a41284e933c8dd82341b2b14bd9372a5a41e582863a8dd82341c98e7ed9372a5a4188e77b3d8dd82341918799da372a5a418bcb673b8dd8234175049adb372a5a4123cddd418dd82341ca6f03dc372a5a4197c7b0438dd82341437aeedb372a5a4136c825468dd8234195ad6ddb372a5a41f8359c468dd823415c2209db372a5a41ac58c3458dd823412682a0da372a5a41adba18488dd823414bcd22da372a5a41001dfd488dd82341e94688d9372a5a4158f0e9438dd82341fb489cd9372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (600,'os','hamatum','droit','membre supérieur','immature',X'00016a0800005d5cce498dd8234198f164d9372a5a410ecdab628dd82341eedc52db372a5a417c06000000010000006903000000010000000e000000e9e2de568dd82341a460b8d9372a5a41082e36548dd82341bbe86ed9372a5a41abbc834f8dd8234194bc74d9372a5a41fa82684f8dd8234103183dda372a5a415d5cce498dd82341eedc52db372a5a411f0df2528dd8234189931cdb372a5a41e2895e578dd82341f769dada372a5a4152ad6e598dd82341408196da372a5a41a6cdc65f8dd823412c7da8da372a5a410ecdab628dd8234175768fda372a5a4102b747628dd823412a9a35da372a5a415ecdde5b8dd8234102c26dd9372a5a41551db4588dd8234198f164d9372a5a41e9e2de568dd82341a460b8d9372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (601,'os','triquetrum','droit','membre supérieur','immature',X'00016a0800009f4c16528dd82341b77122db372a5a41629cfd608dd82341bfd22ddd372a5a417c06000000010000006903000000010000000b0000005574b85e8dd82341108465db372a5a416845aa5d8dd8234106fa26db372a5a412c5c875c8dd82341b77122db372a5a41b16e54598dd82341abb5dcdb372a5a415c4a68538dd823410fad39dc372a5a419f4c16528dd823410055a8dc372a5a415c9afb548dd82341383717dd372a5a419aca1f588dd82341bfd22ddd372a5a41b4dde4608dd82341eafa93dc372a5a41629cfd608dd82341adfff0db372a5a415574b85e8dd82341108465db372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (602,'os','phalange','droit','membre supérieur','immature',X'00016a080000e2af2cfa8cd82341515a1fc4372a5a41a5a2bd048dd82341399cefc4372a5a417c060000000100000069030000000100000007000000e2af2cfa8cd8234151f36dc4372a5a41cd7882fc8cd82341399cefc4372a5a41a5a2bd048dd823412ad2afc4372a5a41ca8e5e048dd82341e4e641c4372a5a410bd21d038dd8234147dd21c4372a5a4167e131fc8cd82341515a1fc4372a5a41e2af2cfa8cd8234151f36dc4372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (603,'os','phalange','droit','membre supérieur','immature',X'00016a080000741b5c008dd823414187b0c6372a5a412423df0c8dd8234144afdcc8372a5a417c060000000100000069030000000100000009000000aae20b098dd823411b2886c7372a5a41efdebe088dd82341b9aac7c6372a5a41e84ebc008dd823414187b0c6372a5a41741b5c008dd823417ca6f3c6372a5a419f19bd028dd823412d23cdc7372a5a41c472cf018dd82341909d94c8372a5a41f427a2028dd8234144afdcc8372a5a412423df0c8dd82341429f93c8372a5a41aae20b098dd823411b2886c7372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (604,'os','phalange','droit','membre supérieur','immature',X'00016a0800007e0a28028dd823411c0029c9372a5a415eb068108dd823417edf49ca372a5a417c06000000010000006903000000010000000a000000908daf038dd82341576a59c9372a5a417e0a28028dd82341febce9c9372a5a415c97c9058dd823417edf49ca372a5a4175febe098dd823416c39fbc9372a5a4193a93f0e8dd82341eb9e1dca372a5a415eb068108dd82341ae94ccc9372a5a419ba2040f8dd8234147ab8ec9372a5a41cffb29098dd823419cf22bc9372a5a41ffc088068dd823411c0029c9372a5a41908daf038dd82341576a59c9372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (605,'os','phalange','droit','membre supérieur','immature',X'00016a0800002fff73d38cd82341f8f518ca372a5a41942117e48cd8234183809acc372a5a417c06000000010000006903000000010000000e00000094a020dc8cd82341a8aaaaca372a5a41938c50dc8cd823417ec258ca372a5a41fc14c0da8cd82341609227ca372a5a410d25a5d58cd82341f8f518ca372a5a41feea96d38cd82341fb3c4cca372a5a412fff73d38cd82341f2f620cb372a5a41dfdf05d68cd8234144463dcb372a5a41a0a28dd78cd82341dfef21cc372a5a41c6b0c0d98cd8234183809acc372a5a41333f71dc8cd82341254185cc372a5a41942117e48cd82341a1a6d5cb372a5a416c830de38cd82341722894cb372a5a4191974add8cd823417162f6ca372a5a4194a020dc8cd82341a8aaaaca372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (606,'os','phalange','droit','membre supérieur','immature',X'00016a080000b9df07dc8cd8234162f159cc372a5a41c1ac18ea8cd823418d47d1cd372a5a417c06000000010000006903000000010000000a00000023a65ee58cd823415e2641cd372a5a41109650e98cd8234132654ccd372a5a41c1ac18ea8cd82341591dddcc372a5a4112badee68cd82341fa4f79cc372a5a41f8d08be38cd8234162f159cc372a5a410107a2dc8cd823415773fbcc372a5a41b9df07dc8cd823419c3e58cd372a5a41573727dd8cd8234108e4a5cd372a5a419029ecdf8cd823418d47d1cd372a5a4123a65ee58cd823415e2641cd372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (607,'os','phalange','droit','membre supérieur','immature',X'00016a080000081ce5e58cd82341b21661ce372a5a41f81138fc8cd82341d6835fd1372a5a417c060000000100000069030000000100000010000000e7d12df18cd82341fa05d9ce372a5a410aa9a4f18cd823414e1983ce372a5a418668c2ef8cd82341b21661ce372a5a4166ad27eb8cd8234136cb6dce372a5a415f6951ea8cd82341bdf5b5ce372a5a41081ce5e58cd82341483ce5ce372a5a413cec4be78cd823415b2b3dcf372a5a41f34325ef8cd82341a5b533d0372a5a4165d6a9ef8cd82341dd511fd1372a5a4192d6cbf18cd82341d6835fd1372a5a4126fa59f78cd8234163550dd1372a5a41dcc9b7fa8cd82341723210d1372a5a41f81138fc8cd82341d2fac0d0372a5a41cb161efb8cd82341e6497cd0372a5a418e4f83f38cd82341061da2cf372a5a41e7d12df18cd82341fa05d9ce372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (608,'os','phalange','droit','membre supérieur','immature',X'00016a0800003a45c9f38cd82341a6735ed1372a5a41195be3008dd823414805bfd2372a5a417c06000000010000006903000000010000000a000000d4e2ddf98cd823411ee8aed2372a5a41b8b5edfb8cd8234104c460d2372a5a4124c8ebff8cd82341eca651d2372a5a41195be3008dd823416e2217d2372a5a41c20428008dd823413a30d3d1372a5a4101019ffb8cd82341a6735ed1372a5a41061061f68cd823418c1db3d1372a5a413a45c9f38cd8234114503dd2372a5a4190d4e1f68cd823414805bfd2372a5a41d4e2ddf98cd823411ee8aed2372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (609,'os','phalange','droit','membre supérieur','immature',X'00016a0800008ace27138dd82341d27203cf372a5a41ac301f1f8dd82341b2ce34d0372a5a417c0600000001000000690300000001000000090000008663371a8dd82341ba0ee9cf372a5a4104858b1d8dd823417e04f8cf372a5a41ac301f1f8dd82341e004d7cf372a5a41cb93b21d8dd82341c12a2ecf372a5a411c94591c8dd82341d27203cf372a5a41632266168dd8234129ba22cf372a5a418ace27138dd82341c1bfe0cf372a5a41e5c816168dd82341b2ce34d0372a5a418663371a8dd82341ba0ee9cf372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (610,'os','phalange','droit','membre supérieur','immature',X'00016a0800006a37ba088dd823417fbb3acb372a5a41b9f8661c8dd823417ab2dbce372a5a417c06000000010000006903000000010000000c000000833031138dd82341e76401cc372a5a41d2539f138dd823419f2d7ccb372a5a4192cc69128dd823417fbb3acb372a5a418273bd088dd82341a63c72cb372a5a416a37ba088dd82341af40fbcb372a5a41d72a4c0c8dd82341a5ed66cc372a5a4170c0d10e8dd8234180b336cd372a5a4191c9530f8dd8234161a1b7ce372a5a419ee6a41b8dd823417ab2dbce372a5a41b9f8661c8dd8234160afa5ce372a5a417068dd1b8dd82341df8658ce372a5a41833031138dd82341e76401cc372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (611,'os','phalange','droit','membre supérieur','immature',X'00016a0800004374ab318dd823419d9636cb372a5a4100431d408dd82341e063b0ce372a5a417c060000000100000069030000000100000010000000ddd81e3b8dd823419596f5cb372a5a4168450b3d8dd82341db858acb372a5a41c1681b3a8dd823419d9636cb372a5a41f4009e388dd82341436638cb372a5a4171bc8d368dd823418fc376cb372a5a413579ff328dd82341802662cb372a5a414374ab318dd82341bb7ba4cb372a5a41bb44b2318dd82341560ff8cb372a5a414f0f0c358dd8234150e964cc372a5a412416ba348dd823412dda70ce372a5a410ea145368dd823419b579ece372a5a41ad35d43b8dd8234194ca90ce372a5a413971273f8dd82341e063b0ce372a5a4100431d408dd823413a0b6fce372a5a4166a89b3b8dd82341c2f8cbcc372a5a41ddd81e3b8dd823419596f5cb372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (612,'os','phalange','droit','membre supérieur','immature',X'00016a080000efb862348dd82341fa9bf6ce372a5a418300bc3f8dd823411d99d6cf372a5a417c060000000100000069030000000100000009000000c606dc3b8dd82341fa9bf6ce372a5a41d61d25368dd82341aab60ecf372a5a41efb862348dd82341d52b5ccf372a5a415fe2c8348dd823411fce9bcf372a5a415d44203c8dd823411d99d6cf372a5a411988ce3e8dd82341ae5ac6cf372a5a418300bc3f8dd82341245891cf372a5a412b1b3a3f8dd823416f8f3ecf372a5a41c606dc3b8dd82341fa9bf6ce372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (613,'os','phalange','droit','membre supérieur','immature',X'00016a08000094486e2e8dd823416c1b7bc8372a5a41fe675c3b8dd82341b5f97cc9372a5a417c0600000001000000690300000001000000090000001dbd15328dd82341b5f97cc9372a5a417e86303a8dd82341cff07ac9372a5a41fe675c3b8dd82341f60537c9372a5a417af33c378dd823412b1d8ec8372a5a41c6c383318dd823416c1b7bc8372a5a41371d26308dd82341f3209fc8372a5a4194486e2e8dd82341ee4e3bc9372a5a4136587c2f8dd823411cb467c9372a5a411dbd15328dd82341b5f97cc9372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (614,'os','phalange','droit','membre supérieur','immature',X'00016a08000091b18a518dd82341d45b45cc372a5a4113f7365e8dd82341a8359fcf372a5a417c06000000010000006903000000010000001000000061e2c5578dd8234110a47dcc372a5a419cf424548dd82341d45b45cc372a5a41f9a67b528dd82341787696cc372a5a416de028558dd82341f279e5cd372a5a4142d25c548dd823416b106bce372a5a4191b18a518dd823411e1b1dcf372a5a4127dc05528dd8234147e13ccf372a5a417a447a578dd82341b4e555cf372a5a41a8dc105b8dd82341a8359fcf372a5a410ad6f75c8dd823410d8243cf372a5a41f414755a8dd823413803c6cd372a5a41bf9ba75b8dd82341bddc40cd372a5a4113f7365e8dd82341d34bc5cc372a5a41b6c33c5c8dd82341786d86cc372a5a416930d9588dd82341ef1f96cc372a5a4161e2c5578dd8234110a47dcc372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (615,'os','phalange','droit','membre supérieur','immature',X'00016a08000006c6b6508dd8234163acafcf372a5a41bf9bbc5b8dd82341a057bed0372a5a417c06000000010000006903000000010000000a0000008a66bf508dd82341189e0cd0372a5a4106c6b6508dd82341262d64d0372a5a4142faff548dd82341c4797ad0372a5a41357d75588dd82341a057bed0372a5a417f2ff25a8dd8234114fa8dd0372a5a41bf9bbc5b8dd82341a00540d0372a5a41ad9e425b8dd82341a6e50ad0372a5a41630cf3578dd8234163acafcf372a5a41d09a5d528dd82341a994becf372a5a418a66bf508dd82341189e0cd0372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (616,'os','phalange','droit','membre supérieur','immature',X'00016a080000ad8cc9728dd82341630c4ece372a5a413164637f8dd82341f48fdad0372a5a417c06000000010000006903000000010000000f000000cdc916768dd82341ee70fcce372a5a41595937758dd8234134bdaecf372a5a41ad8cc9728dd823412e4f54d0372a5a41a21830778dd82341b17b72d0372a5a41bc6373788dd82341bf2fc9d0372a5a415521f3798dd82341f48fdad0372a5a419a7df27a8dd8234112e1add0372a5a41c78fd17b8dd82341a65996cf372a5a41062f207f8dd82341f1931ccf372a5a413164637f8dd823415958e7ce372a5a4182c7037d8dd82341042d9ace372a5a417679657a8dd823411ebfa1ce372a5a416e5cc9778dd82341630c4ece372a5a41fa5c67758dd82341020a94ce372a5a41cdc916768dd82341ee70fcce372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (617,'os','phalange','droit','membre supérieur','immature',X'00016a080000f456966f8dd82341bd3ac5d0372a5a4135861d798dd82341ce7403d2372a5a417c060000000100000069030000000100000009000000571935728dd82341d82aced1372a5a4130b7e9728dd823413a3a02d2372a5a41d41e81748dd82341ce7403d2372a5a4135861d798dd823416c3877d1372a5a41b556d6788dd82341363c3ed1372a5a41ae14b8758dd82341bd3ac5d0372a5a41605691708dd82341f5b2f0d0372a5a41f456966f8dd823416a2567d1372a5a41571935728dd82341d82aced1372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (619,'os','patella','droit','membre inférieur','immature',X'00016a080000cb0afeb08dd82341334129c1372a5a419143c6c88dd823412531d7c4372a5a417c060000000100000069030000000100000011000000014252c68dd823419eaf49c2372a5a41d0082fc28dd82341904358c1372a5a4107073ac08dd82341334129c1372a5a41716585bd8dd82341a4f335c1372a5a41755cf2b48dd82341ff38cfc1372a5a41203524b28dd82341767250c2372a5a41cb0afeb08dd823416e0d09c3372a5a413f2cacb18dd8234124839fc3372a5a41a0a23bb48dd82341885730c4372a5a41df26a4b68dd8234141b366c4372a5a4185cdf2bc8dd823413d7089c4372a5a41b4812cc28dd823412531d7c4372a5a414bff04c58dd8234187efc0c4372a5a413f4e16c78dd82341109639c4372a5a419143c6c88dd823418d213ac3372a5a4177735ac88dd823419b6db8c2372a5a41014252c68dd823419eaf49c2372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (623,'os','phalange','droit','membre supérieur','immature',X'00016a080000677e65858dd82341293721c6372a5a41c12e678d8dd823419faf67c7372a5a417c06000000010000006903000000010000000a000000c12e678d8dd82341270d76c6372a5a41f738868c8dd82341924b24c6372a5a417825088b8dd82341293721c6372a5a41fa73d9878dd82341d33cb2c6372a5a410a2495858dd8234158cdcdc6372a5a41677e65858dd82341e948fbc6372a5a419050d6888dd823410b191fc7372a5a411098a58b8dd823419faf67c7372a5a411d3ad98c8dd823411c662dc7372a5a41c12e678d8dd82341270d76c6372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (624,'os','phalange','droit','membre supérieur','immature',X'00016a0800000ec277838dd82341fcd298c7372a5a412b27778b8dd82341ca6667c8372a5a417c0600000001000000690300000001000000090000008e349b838dd82341f36cbbc7372a5a410ec277838dd82341aa271fc8372a5a4121014c868dd8234168b91ec8372a5a4154262c898dd82341ca6667c8372a5a412b27778b8dd82341208533c8372a5a41385d508b8dd8234123b8e5c7372a5a4125c4bb898dd82341e69eb2c7372a5a41140ddb858dd82341fcd298c7372a5a418e349b838dd82341f36cbbc7372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (625,'os','phalange','droit','membre supérieur','immature',X'00016a0800001a76117f8dd82341d1f890c8372a5a414e49c58a8dd823414ac184ca372a5a417c06000000010000006903000000010000000a000000ea624d878dd82341803ff3c9372a5a414b4526888dd823413d9283c9372a5a414e49c58a8dd82341c87d1bc9372a5a417d8780838dd82341d1f890c8372a5a41d88f9d818dd82341189a73c9372a5a411a76117f8dd82341846015ca372a5a41547fc8808dd8234199a05bca372a5a41172517868dd823414ac184ca372a5a41784053878dd82341c30260ca372a5a41ea624d878dd82341803ff3c9372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (626,'os','phalange','droit','membre supérieur','immature',X'00016a0800000269ae578dd823412b398cc2372a5a41434f5d618dd823418dcde7c3372a5a417c06000000010000006903000000010000000a0000001427bc5e8dd82341405af9c2372a5a4132f57b5d8dd82341e61696c2372a5a4152184a5c8dd823412b398cc2372a5a4155f2f1598dd823419bc57cc3372a5a410269ae578dd823412c17a5c3372a5a4120e61c588dd82341049be7c3372a5a41434f5d618dd823418dcde7c3372a5a413a851d618dd82341d07296c3372a5a417113bc5e8dd82341c23b47c3372a5a411427bc5e8dd82341405af9c2372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (627,'os','phalange','droit','membre supérieur','immature',X'00016a0800006de2d5568dd8234151c732c4372a5a4126bdb1618dd82341b22deac4372a5a417c060000000100000069030000000100000009000000b69830598dd8234151c732c4372a5a416de2d5568dd82341dfd86cc4372a5a41720599578dd82341c418ddc4372a5a410e2e0c5b8dd823413febcbc4372a5a41d9cc795f8dd82341b22deac4372a5a4126bdb1618dd82341b7c3b5c4372a5a41816ba3618dd82341285481c4372a5a419525bf5f8dd82341ede832c4372a5a41b69830598dd8234151c732c4372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (628,'os','phalange','droit','membre supérieur','immature',X'00016a080000b5aecf558dd8234199189ec6372a5a4194d7685f8dd82341006193c8372a5a417c06000000010000006903000000010000000b0000000598145e8dd82341c9c35cc7372a5a41f18cb55e8dd8234135bad9c6372a5a41f84170578dd8234199189ec6372a5a418dd959568dd82341892f03c7372a5a411b7f3f578dd823411a7bf3c7372a5a41b5aecf558dd82341ea573ec8372a5a4167a21c568dd823416ba465c8372a5a418f59b35b8dd82341006193c8372a5a41d23e695e8dd823416da76cc8372a5a4194d7685f8dd82341ba0b25c8372a5a410598145e8dd82341c9c35cc7372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (629,'os','phalange','droit','membre supérieur','immature',X'00016a080000786e772b8dd8234110e20ac2372a5a410d8224358dd82341721754c3372a5a417c060000000100000069030000000100000009000000441e00328dd82341c5b653c2372a5a41042f67308dd8234110e20ac2372a5a41b828f72e8dd82341351d1bc2372a5a41ca33c42d8dd82341d6027ac2372a5a41470b152e8dd823412fc6c8c2372a5a41786e772b8dd82341632216c3372a5a417c20222c8dd8234121ab47c3372a5a410d8224358dd82341721754c3372a5a41441e00328dd82341c5b653c2372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (630,'os','phalange','droit','membre supérieur','immature',X'00016a0800006f02d32c8dd823418592c6c3372a5a41117b8d358dd8234193be67c4372a5a417c0600000001000000690300000001000000080000006f02d32c8dd8234134dfebc3372a5a416314d72c8dd8234193be67c4372a5a41866e42308dd8234193d747c4372a5a41f4c6f2348dd823418dd462c4372a5a41117b8d358dd82341b7980fc4372a5a41e95d99348dd823415916e4c3372a5a416983892f8dd823418592c6c3372a5a416f02d32c8dd8234134dfebc3372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (631,'os','phalange','droit','membre supérieur','immature',X'00016a080000d186d02e8dd823419be130c6372a5a41750ed7388dd823415b0a37c8372a5a417c06000000010000006903000000010000000d000000376285368dd823414fb6d4c6372a5a411b2202378dd823410f804bc6372a5a419e03c8328dd82341488552c6372a5a4157d98e2f8dd823419be130c6372a5a41d186d02e8dd82341b26495c6372a5a4150790d308dd823416ee013c7372a5a41a2a2282f8dd823415d98dcc7372a5a4130fef12f8dd82341679226c8372a5a416f93bc368dd823415b0a37c8372a5a41a4288d388dd823413b351ac8372a5a41750ed7388dd823418507d5c7372a5a417e1b1c378dd823412f5a62c7372a5a41376285368dd823414fb6d4c6372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (632,'os','phalange','droit','membre supérieur','immature',X'00016a08000053814bf68cd82341cb8d2ec2372a5a41c32db5018dd823410825dec3372a5a417c06000000010000006903000000010000000b0000009ce950fd8cd823419066acc2372a5a41dcc189fc8cd82341caf356c2372a5a41cca5defa8cd82341cb8d2ec2372a5a4153814bf68cd82341ae8b7bc2372a5a41780e9cf88cd823413eab31c3372a5a4133dae8f78cd82341538cd1c3372a5a419f020efb8cd823410e7bbec3372a5a41c7123b008dd823410825dec3372a5a419a6a95018dd823418d11c5c3372a5a41c32db5018dd82341aae45ac3372a5a419ce950fd8cd823419066acc2372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (669,'os','cuboïde','gauche','membre inférieur','immature',X'00016a08000023a0b0908ed82341fb610699372a5a418cf706b28ed82341c6d7a89d372a5a417c06000000010000006903000000010000001100000073e3219a8ed823416b298899372a5a4160d5c1928ed82341e456249a372a5a413c20b8908ed82341d62d7b9a372a5a4123a0b0908ed823418533c99c372a5a4122f65a928ed82341ebde179d372a5a41b34dec948ed823419b7c329d372a5a4166abb09b8ed82341a76fee9c372a5a41fe163c9e8ed82341ba6ff29c372a5a413b756fa18ed82341260a929d372a5a41369f2ba38ed82341c6d7a89d372a5a41c0a6cba88ed82341df4a9d9c372a5a414f618bb18ed82341ea89e09b372a5a418cf706b28ed823414d04809b372a5a41966a67aa8ed82341cfa4fa99372a5a417835b2a18ed823412a0d1099372a5a419292fd9d8ed82341fb610699372a5a4173e3219a8ed823416b298899372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (670,'os','cunéiforme médial','gauche','membre inférieur','immature',X'00016a08000045daf0808ed8234109750b97372a5a41eac378998ed82341b502029a372a5a417c06000000010000006903000000010000000d000000efabfb968ed823412f440d99372a5a41eac378998ed82341b2903d98372a5a41a6a8bb958ed823415d464d97372a5a412dfe09948ed8234101192997372a5a41348a008c8ed8234109750b97372a5a41b36abb888ed82341856f3f97372a5a416af8d18a8ed823419df9a997372a5a416eb07d8a8ed82341da27e197372a5a4145daf0808ed823416ac41399372a5a41d96b16868ed82341a5a25199372a5a4167398e8a8ed82341cadaed99372a5a414a8c5f8c8ed82341b502029a372a5a41efabfb968ed823412f440d99372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (671,'os','cunéiforme intermédiaire','gauche','membre inférieur','immature',X'00016a080000f70d1e748ed82341e6417d96372a5a41e4da49828ed82341dbfcd698372a5a417c06000000010000006903000000010000000a0000008ed9a9768ed82341c7b41c97372a5a41d0fc1e748ed82341bfbfbc97372a5a41f70d1e748ed8234147cc1f98372a5a41e8397f7c8ed82341dbfcd698372a5a41e4da49828ed82341cd5bb797372a5a416dbe49818ed823412a32f396372a5a41fa17147e8ed823410c99f796372a5a41cbedb47b8ed82341a75c9296372a5a41e403fb798ed82341e6417d96372a5a418ed9a9768ed82341c7b41c97372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (672,'os','cunéiforme latéral','gauche','membre inférieur','immature',X'00016a080000881aa8628ed82341506ac795372a5a410a0bed728ed823417e490998372a5a417c06000000010000006903000000010000000e0000009837ac708ed82341584edd95372a5a4196dd146a8ed82341a5780196372a5a41944467648ed8234191def295372a5a419070e3628ed823413bad1096372a5a41881aa8628ed82341a655bc96372a5a4158c0cd658ed82341d483bf97372a5a416d3c87678ed823416b26fc97372a5a41626aa76d8ed823417e490998372a5a41ecc8846f8ed82341bf0ff297372a5a41458e3a708ed82341f72a4997372a5a410a0bed728ed823416882dc96372a5a413a3cea728ed82341b4a4de95372a5a410ca218728ed82341506ac795372a5a419837ac708ed82341584edd95372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (673,'os','scaphoïde','gauche','membre inférieur','immature',X'00016a0800003028655d8ed8234180531499372a5a41615191848ed8234115729f9b372a5a417c060000000100000069030000000100000012000000943753838ed8234139089d9a372a5a41615191848ed82341af75709a372a5a41f498c4838ed823411007389a372a5a4172cc157a8ed8234122c75499372a5a410b4dd2738ed8234180531499372a5a4138dd496b8ed82341bd4a1a99372a5a4142a299668ed823410c1b3899372a5a412834a5628ed8234146e99099372a5a41474dd05e8ed82341fc05379a372a5a413028655d8ed823417d52d69a372a5a4198b0005e8ed82341f00c059b372a5a41183d16648ed8234115729f9b372a5a414406286c8ed823416d14f19a372a5a41b9e99b728ed823414209bb9a372a5a41b2e653758ed82341b77bc79a372a5a411fe258798ed82341a2c1269b372a5a41f5d3e97f8ed82341f0514e9b372a5a41943753838ed8234139089d9a372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (674,'os','talus','gauche','membre inférieur','immature',X'00016a08000003f91f5a8ed823417bd6b09b372a5a410a557a838ed82341590bb7a2372a5a417c0600000001000000690300000001000000150000004fa79e6a8ed823415421019c372a5a41a6000e698ed82341a718d89c372a5a4164d6fc5e8ed82341a9edbf9d372a5a415180245c8ed82341b4f8289e372a5a41fd6a6c5a8ed82341fed7bf9e372a5a4103f91f5a8ed82341a41f8c9f372a5a418328365b8ed823416c188fa0372a5a41f3f5085e8ed82341ee113ea1372a5a41dff47c658ed8234186d023a2372a5a4178f4586d8ed82341590bb7a2372a5a41b1b6556f8ed82341ccda87a2372a5a41180587718ed82341ac62b8a1372a5a412421c7738ed82341606e4ca1372a5a41c80a397f8ed823412883e99f372a5a41e1834e808ed82341a326759e372a5a410a557a838ed823412fd5899d372a5a4117f979808ed82341e247c29c372a5a417aa2347a8ed8234174f0e29b372a5a41fbeecc6d8ed823417bd6b09b372a5a4197a3b96b8ed8234169edc99b372a5a414fa79e6a8ed823415421019c372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (679,'os','phalange','gauche','membre supérieur','immature',X'00016a0800001a117cc88ed823415fcfa7ce372a5a41c1f115d58ed82341f65034d1372a5a417c06000000010000006903000000010000000f000000a939c9d18ed82341074456cf372a5a417e4d78d28ed82341c6d6edce372a5a41d24916d08ed823415fcfa7ce372a5a41a5697acd8ed823413792fbce372a5a41300ddcca8ed8234145faf3ce372a5a411a117cc88ed823411d1a41cf372a5a41f559bfc88ed82341a35a76cf372a5a41ae730ecc8ed823415708f0cf372a5a41073dedcc8ed82341f3ab07d1372a5a414c99eccd8ed82341f65034d1372a5a41e9386ccf8ed8234138f822d1372a5a41e981afd08ed823413b3fccd0372a5a41c1f115d58ed82341430daed0372a5a411caaa8d28ed82341227e08d0372a5a41a939c9d18ed82341074456cf372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (680,'os','trapèze','gauche','membre supérieur','immature',X'00016a08000098b9e41e8fd8234135baa9d9372a5a4181bcc12f8fd823412bfe08dc372a5a417c06000000010000006903000000010000000d000000782595208fd8234105897ada372a5a4198b9e41e8fd8234175f3e4da372a5a41734f051f8fd8234143143edb372a5a418524e8238fd82341dd8290db372a5a41f6aff0268fd823412bfe08dc372a5a41e64d7a288fd823411c39efdb372a5a413e76902a8fd82341540d62db372a5a4181bcc12f8fd82341df2ac5da372a5a411bf8cc2d8fd82341d5d978da372a5a41eebf00298fd8234134d443da372a5a41cec261248fd8234135baa9d9372a5a413728f6208fd82341781fded9372a5a41782595208fd8234105897ada372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (697,'os','thoracique 5 arc droit','axial','rachis','périnatal',X'00016a080000050f2f968fd8234109a95a32372a5a41379ebac18fd82341b8b3cd34372a5a417c060000000100000069030000000100000005000000379ebac18fd8234109a95a32372a5a41050f2f968fd8234109a95a32372a5a41050f2f968fd82341b8b3cd34372a5a41379ebac18fd82341b8b3cd34372a5a41379ebac18fd8234109a95a32372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (698,'os','thoracique 5 corps','axial','rachis','périnatal',X'00016a080000379ebac18fd8234109a95a32372a5a4102a146ed8fd82341b8b3cd34372a5a417c06000000010000006903000000010000000500000002a146ed8fd8234109a95a32372a5a41379ebac18fd8234109a95a32372a5a41379ebac18fd82341b8b3cd34372a5a4102a146ed8fd82341b8b3cd34372a5a4102a146ed8fd8234109a95a32372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (699,'os','thoracique 5 arc gauche','axial','rachis','périnatal',X'00016a08000002a146ed8fd8234109a95a32372a5a413330d21890d82341b8b3cd34372a5a417c0600000001000000690300000001000000050000003330d21890d8234109a95a32372a5a4102a146ed8fd8234109a95a32372a5a4102a146ed8fd82341b8b3cd34372a5a413330d21890d82341b8b3cd34372a5a413330d21890d8234109a95a32372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (700,'os','thoracique 6 arc droit','axial','rachis','périnatal',X'00016a080000050f2f968fd82341599ee72f372a5a41379ebac18fd8234109a95a32372a5a417c060000000100000069030000000100000005000000379ebac18fd82341599ee72f372a5a41050f2f968fd82341599ee72f372a5a41050f2f968fd8234109a95a32372a5a41379ebac18fd8234109a95a32372a5a41379ebac18fd82341599ee72f372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (701,'os','thoracique 6 corps','axial','rachis','périnatal',X'00016a080000379ebac18fd82341599ee72f372a5a4102a146ed8fd8234109a95a32372a5a417c06000000010000006903000000010000000500000002a146ed8fd82341599ee72f372a5a41379ebac18fd82341599ee72f372a5a41379ebac18fd8234109a95a32372a5a4102a146ed8fd8234109a95a32372a5a4102a146ed8fd82341599ee72f372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (702,'os','thoracique 6 arc gauche','axial','rachis','périnatal',X'00016a08000002a146ed8fd82341599ee72f372a5a413330d21890d8234109a95a32372a5a417c0600000001000000690300000001000000050000003330d21890d82341599ee72f372a5a4102a146ed8fd82341599ee72f372a5a4102a146ed8fd8234109a95a32372a5a413330d21890d8234109a95a32372a5a413330d21890d82341599ee72f372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (703,'os','thoracique 3 corps','axial','rachis','périnatal',X'00016a080000379ebac18fd82341a2c54037372a5a4102a146ed8fd8234152d0b339372a5a417c06000000010000006903000000010000000500000002a146ed8fd82341a2c54037372a5a41379ebac18fd82341a2c54037372a5a41379ebac18fd8234152d0b339372a5a4102a146ed8fd8234152d0b339372a5a4102a146ed8fd82341a2c54037372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (704,'os','thoracique 3 arc gauche','axial','rachis','périnatal',X'00016a08000002a146ed8fd82341a2c54037372a5a413330d21890d8234152d0b339372a5a417c0600000001000000690300000001000000050000003330d21890d82341a2c54037372a5a4102a146ed8fd82341a2c54037372a5a4102a146ed8fd8234152d0b339372a5a413330d21890d8234152d0b339372a5a413330d21890d82341a2c54037372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (705,'os','thoracique 4 arc droit','axial','rachis','périnatal',X'00016a080000050f2f968fd82341b8b3cd34372a5a41379ebac18fd8234168be4037372a5a417c060000000100000069030000000100000005000000379ebac18fd82341b8b3cd34372a5a41050f2f968fd82341b8b3cd34372a5a41050f2f968fd8234168be4037372a5a41379ebac18fd8234168be4037372a5a41379ebac18fd82341b8b3cd34372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (706,'os','thoracique 4 corps','axial','rachis','périnatal',X'00016a080000379ebac18fd82341b8b3cd34372a5a4102a146ed8fd8234168be4037372a5a417c06000000010000006903000000010000000500000002a146ed8fd82341b8b3cd34372a5a41379ebac18fd82341b8b3cd34372a5a41379ebac18fd8234168be4037372a5a4102a146ed8fd8234168be4037372a5a4102a146ed8fd82341b8b3cd34372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (707,'os','thoracique 4 arc gauche','axial','rachis','périnatal',X'00016a08000002a146ed8fd82341b8b3cd34372a5a413330d21890d8234168be4037372a5a417c0600000001000000690300000001000000050000003330d21890d82341b8b3cd34372a5a4102a146ed8fd82341b8b3cd34372a5a4102a146ed8fd8234168be4037372a5a413330d21890d8234168be4037372a5a413330d21890d82341b8b3cd34372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (708,'os','rang indéterminé','axial','rachis','périnatal',X'00016a080000050f2f968fd823411c86c21e372a5a41379ebac18fd82341c64f3521372a5a417c060000000100000069030000000100000005000000379ebac18fd823411c86c21e372a5a41050f2f968fd823411c86c21e372a5a41050f2f968fd82341c64f3521372a5a41379ebac18fd82341c64f3521372a5a41379ebac18fd823411c86c21e372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (709,'os','rang indéterminé corps','axial','rachis','périnatal',X'00016a080000379ebac18fd823411c86c21e372a5a4102a146ed8fd82341c64f3521372a5a417c06000000010000006903000000010000000500000002a146ed8fd823411c86c21e372a5a41379ebac18fd823411c86c21e372a5a41379ebac18fd82341c64f3521372a5a4102a146ed8fd82341c64f3521372a5a4102a146ed8fd823411c86c21e372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (710,'os','rang indéterminé arc gauche','axial','rachis','périnatal',X'00016a08000002a146ed8fd823411c86c21e372a5a413330d21890d82341c64f3521372a5a417c0600000001000000690300000001000000050000003330d21890d823411c86c21e372a5a4102a146ed8fd823411c86c21e372a5a4102a146ed8fd82341c64f3521372a5a413330d21890d82341c64f3521372a5a413330d21890d823411c86c21e372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (711,'os','thoracique 11 arc droit','axial','rachis','périnatal',X'00016a080000050f2f968fd82341765aa823372a5a41379ebac18fd823415f6c1b26372a5a417c060000000100000069030000000100000005000000379ebac18fd82341765aa823372a5a41050f2f968fd82341765aa823372a5a41050f2f968fd823415f6c1b26372a5a41379ebac18fd823415f6c1b26372a5a41379ebac18fd82341765aa823372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (712,'os','thoracique 11 corps','axial','rachis','périnatal',X'00016a080000379ebac18fd82341765aa823372a5a4102a146ed8fd823415f6c1b26372a5a417c06000000010000006903000000010000000500000002a146ed8fd82341765aa823372a5a41379ebac18fd82341765aa823372a5a41379ebac18fd823415f6c1b26372a5a4102a146ed8fd823415f6c1b26372a5a4102a146ed8fd82341765aa823372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (713,'os','thoracique 11 arc gauche','axial','rachis','périnatal',X'00016a08000002a146ed8fd82341765aa823372a5a413330d21890d823415f6c1b26372a5a417c0600000001000000690300000001000000050000003330d21890d82341765aa823372a5a4102a146ed8fd82341765aa823372a5a4102a146ed8fd823415f6c1b26372a5a413330d21890d823415f6c1b26372a5a413330d21890d82341765aa823372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (714,'os','thoracique 12 arc droit','axial','rachis','périnatal',X'00016a080000050f2f968fd82341c64f3521372a5a41379ebac18fd82341765aa823372a5a417c060000000100000069030000000100000005000000379ebac18fd82341c64f3521372a5a41050f2f968fd82341c64f3521372a5a41050f2f968fd82341765aa823372a5a41379ebac18fd82341765aa823372a5a41379ebac18fd82341c64f3521372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (715,'os','thoracique 12 corps','axial','rachis','périnatal',X'00016a080000379ebac18fd82341c64f3521372a5a4102a146ed8fd82341765aa823372a5a417c06000000010000006903000000010000000500000002a146ed8fd82341c64f3521372a5a41379ebac18fd82341c64f3521372a5a41379ebac18fd82341765aa823372a5a4102a146ed8fd82341765aa823372a5a4102a146ed8fd82341c64f3521372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (716,'os','thoracique 12 arc gauche','axial','rachis','périnatal',X'00016a08000002a146ed8fd82341c64f3521372a5a413330d21890d82341765aa823372a5a417c0600000001000000690300000001000000050000003330d21890d82341c64f3521372a5a4102a146ed8fd82341c64f3521372a5a4102a146ed8fd82341765aa823372a5a413330d21890d82341765aa823372a5a413330d21890d82341c64f3521372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (717,'os','thoracique 9 arc droit','axial','rachis','périnatal',X'00016a080000050f2f968fd823410f778e28372a5a41379ebac18fd82341bf81012b372a5a417c060000000100000069030000000100000005000000379ebac18fd823410f778e28372a5a41050f2f968fd823410f778e28372a5a41050f2f968fd82341bf81012b372a5a41379ebac18fd82341bf81012b372a5a41379ebac18fd823410f778e28372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (718,'os','thoracique 9 corps','axial','rachis','périnatal',X'00016a080000379ebac18fd823410f778e28372a5a4102a146ed8fd82341bf81012b372a5a417c06000000010000006903000000010000000500000002a146ed8fd823410f778e28372a5a41379ebac18fd823410f778e28372a5a41379ebac18fd82341bf81012b372a5a4102a146ed8fd82341bf81012b372a5a4102a146ed8fd823410f778e28372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (719,'os','thoracique 9 arc gauche','axial','rachis','périnatal',X'00016a08000002a146ed8fd823410f778e28372a5a413330d21890d82341bf81012b372a5a417c0600000001000000690300000001000000050000003330d21890d823410f778e28372a5a4102a146ed8fd823410f778e28372a5a4102a146ed8fd82341bf81012b372a5a413330d21890d82341bf81012b372a5a413330d21890d823410f778e28372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (720,'os','thoracique 10 arc droit','axial','rachis','périnatal',X'00016a080000050f2f968fd823415f6c1b26372a5a41379ebac18fd823410f778e28372a5a417c060000000100000069030000000100000005000000379ebac18fd823415f6c1b26372a5a41050f2f968fd823415f6c1b26372a5a41050f2f968fd823410f778e28372a5a41379ebac18fd823410f778e28372a5a41379ebac18fd823415f6c1b26372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (721,'os','thoracique 10 corps','axial','rachis','périnatal',X'00016a080000379ebac18fd823415f6c1b26372a5a4102a146ed8fd823410f778e28372a5a417c06000000010000006903000000010000000500000002a146ed8fd823415f6c1b26372a5a41379ebac18fd823415f6c1b26372a5a41379ebac18fd823410f778e28372a5a4102a146ed8fd823410f778e28372a5a4102a146ed8fd823415f6c1b26372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (722,'os','thoracique 10 arc gauche','axial','rachis','périnatal',X'00016a08000002a146ed8fd823415f6c1b26372a5a413330d21890d823410f778e28372a5a417c0600000001000000690300000001000000050000003330d21890d823415f6c1b26372a5a4102a146ed8fd823415f6c1b26372a5a4102a146ed8fd823410f778e28372a5a413330d21890d823410f778e28372a5a413330d21890d823415f6c1b26372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (723,'os','thoracique 7 arc droit','axial','rachis','périnatal',X'00016a080000050f2f968fd823416f8c742d372a5a41379ebac18fd82341599ee72f372a5a417c060000000100000069030000000100000005000000379ebac18fd823416f8c742d372a5a41050f2f968fd823416f8c742d372a5a41050f2f968fd82341599ee72f372a5a41379ebac18fd82341599ee72f372a5a41379ebac18fd823416f8c742d372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (724,'os','thoracique 7 corps','axial','rachis','périnatal',X'00016a080000379ebac18fd823416f8c742d372a5a4102a146ed8fd82341599ee72f372a5a417c06000000010000006903000000010000000500000002a146ed8fd823416f8c742d372a5a41379ebac18fd823416f8c742d372a5a41379ebac18fd82341599ee72f372a5a4102a146ed8fd82341599ee72f372a5a4102a146ed8fd823416f8c742d372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (725,'os','thoracique 7 arc gauche','axial','rachis','périnatal',X'00016a08000002a146ed8fd823416f8c742d372a5a413330d21890d82341599ee72f372a5a417c0600000001000000690300000001000000050000003330d21890d823416f8c742d372a5a4102a146ed8fd823416f8c742d372a5a4102a146ed8fd82341599ee72f372a5a413330d21890d82341599ee72f372a5a413330d21890d823416f8c742d372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (726,'os','thoracique 8 arc droit','axial','rachis','périnatal',X'00016a080000050f2f968fd82341bf81012b372a5a41379ebac18fd823416f8c742d372a5a417c060000000100000069030000000100000005000000379ebac18fd82341bf81012b372a5a41050f2f968fd82341bf81012b372a5a41050f2f968fd823416f8c742d372a5a41379ebac18fd823416f8c742d372a5a41379ebac18fd82341bf81012b372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (727,'os','thoracique 8 corps','axial','rachis','périnatal',X'00016a080000379ebac18fd82341bf81012b372a5a4102a146ed8fd823416f8c742d372a5a417c06000000010000006903000000010000000500000002a146ed8fd82341bf81012b372a5a41379ebac18fd82341bf81012b372a5a41379ebac18fd823416f8c742d372a5a4102a146ed8fd823416f8c742d372a5a4102a146ed8fd82341bf81012b372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (728,'os','thoracique 8 arc gauche','axial','rachis','périnatal',X'00016a08000002a146ed8fd82341bf81012b372a5a413330d21890d823416f8c742d372a5a417c0600000001000000690300000001000000050000003330d21890d82341bf81012b372a5a4102a146ed8fd82341bf81012b372a5a4102a146ed8fd823416f8c742d372a5a413330d21890d823416f8c742d372a5a413330d21890d82341bf81012b372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (729,'os','étrier','gauche','crâne','périnatal',X'00016a080000b222b2ef8ed8234136f61e37372a5a410f162a078fd823418b9bb838372a5a417c0600000001000000690300000001000000050000000f162a078fd823418b9bb838372a5a410f162a078fd8234136f61e37372a5a41b222b2ef8ed8234136f61e37372a5a41b222b2ef8ed823418b9bb838372a5a410f162a078fd823418b9bb838372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (730,'os','enclume','gauche','crâne','périnatal',X'00016a080000b222b2ef8ed823418d4d293a372a5a410f162a078fd82341e2f2c23b372a5a417c0600000001000000690300000001000000050000000f162a078fd82341e2f2c23b372a5a410f162a078fd823418d4d293a372a5a41b222b2ef8ed823418d4d293a372a5a41b222b2ef8ed82341e2f2c23b372a5a410f162a078fd82341e2f2c23b372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (731,'os','marteau','gauche','crâne','périnatal',X'00016a080000b222b2ef8ed823410cfc253d372a5a410f162a078fd823419aa8bf3e372a5a417c0600000001000000690300000001000000050000000f162a078fd823419aa8bf3e372a5a410f162a078fd823410cfc253d372a5a41b222b2ef8ed823410cfc253d372a5a41b222b2ef8ed823419aa8bf3e372a5a410f162a078fd823419aa8bf3e372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (732,'os','côte 9 droite','axial','thorax','périnatal',X'00016a080000e81479958fd8234191534edc362a5a41eb5900c18fd82341cd4fc1de362a5a417c060000000100000069030000000100000005000000eb5900c18fd8234191534edc362a5a41e81479958fd8234191534edc362a5a41e81479958fd82341cd4fc1de362a5a41eb5900c18fd82341cd4fc1de362a5a41eb5900c18fd8234191534edc362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (733,'os','côte 10 droite','axial','thorax','périnatal',X'00016a080000e81479958fd82341e148dbd9362a5a41eb5900c18fd8234191534edc362a5a417c060000000100000069030000000100000005000000eb5900c18fd82341e148dbd9362a5a41e81479958fd82341e148dbd9362a5a41e81479958fd8234191534edc362a5a41eb5900c18fd8234191534edc362a5a41eb5900c18fd82341e148dbd9362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (734,'os','côte 11 droite','axial','thorax','périnatal',X'00016a080000e81479958fd82341be2f68d7362a5a41eb5900c18fd82341e148dbd9362a5a417c060000000100000069030000000100000005000000eb5900c18fd82341be2f68d7362a5a41e81479958fd82341be2f68d7362a5a41e81479958fd82341e148dbd9362a5a41eb5900c18fd82341e148dbd9362a5a41eb5900c18fd82341be2f68d7362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (735,'os','côte 12 droite','axial','thorax','périnatal',X'00016a080000e81479958fd823418133f5d4362a5a41eb5900c18fd82341be2f68d7362a5a417c060000000100000069030000000100000005000000eb5900c18fd823418133f5d4362a5a41e81479958fd823418133f5d4362a5a41e81479958fd82341be2f68d7362a5a41eb5900c18fd82341be2f68d7362a5a41eb5900c18fd823418133f5d4362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (736,'os','rang indéterminé droite','axial','thorax','périnatal',X'00016a080000e81479958fd82341fcf68ad2362a5a41eb5900c18fd823418133f5d4362a5a417c060000000100000069030000000100000005000000eb5900c18fd82341fcf68ad2362a5a41e81479958fd82341fcf68ad2362a5a41e81479958fd823418133f5d4362a5a41eb5900c18fd823418133f5d4362a5a41eb5900c18fd82341fcf68ad2362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (737,'os','enclume','droit','crâne','périnatal',X'00016a0800001e1e56548dd823418d4d293a372a5a41474bce6b8dd82341e2f2c23b372a5a417c060000000100000069030000000100000005000000474bce6b8dd82341e2f2c23b372a5a41474bce6b8dd823418d4d293a372a5a411e1e56548dd823418d4d293a372a5a411e1e56548dd82341e2f2c23b372a5a41474bce6b8dd82341e2f2c23b372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (738,'os','marteau','droit','crâne','périnatal',X'00016a0800001e1e56548dd823410cfc253d372a5a41474bce6b8dd823419aa8bf3e372a5a417c060000000100000069030000000100000005000000474bce6b8dd823419aa8bf3e372a5a41474bce6b8dd823410cfc253d372a5a411e1e56548dd823410cfc253d372a5a411e1e56548dd823419aa8bf3e372a5a41474bce6b8dd823419aa8bf3e372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (739,'os','étrier','droit','crâne','périnatal',X'00016a0800001e1e56548dd8234136f61e37372a5a41474bce6b8dd823418b9bb838372a5a417c060000000100000069030000000100000005000000474bce6b8dd823418b9bb838372a5a41474bce6b8dd8234136f61e37372a5a411e1e56548dd8234136f61e37372a5a411e1e56548dd823418b9bb838372a5a41474bce6b8dd823418b9bb838372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (740,'os','côte 1 droite','axial','thorax','périnatal',X'00016a080000e81479958fd8234110a9e6ef362a5a41eb5900c18fd82341466b60f2362a5a417c060000000100000069030000000100000005000000eb5900c18fd8234110a9e6ef362a5a41e81479958fd8234110a9e6ef362a5a41e81479958fd82341466b60f2362a5a41eb5900c18fd82341466b60f2362a5a41eb5900c18fd8234110a9e6ef362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (741,'os','côte 2 droite','axial','thorax','périnatal',X'00016a080000e81479958fd82341609e73ed362a5a41eb5900c18fd8234110a9e6ef362a5a417c060000000100000069030000000100000005000000eb5900c18fd82341609e73ed362a5a41e81479958fd82341609e73ed362a5a41e81479958fd8234110a9e6ef362a5a41eb5900c18fd8234110a9e6ef362a5a41eb5900c18fd82341609e73ed362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (742,'os','côte 3 droite','axial','thorax','périnatal',X'00016a080000e81479958fd82341b09300eb362a5a41eb5900c18fd82341609e73ed362a5a417c060000000100000069030000000100000005000000eb5900c18fd82341b09300eb362a5a41e81479958fd82341b09300eb362a5a41e81479958fd82341609e73ed362a5a41eb5900c18fd82341609e73ed362a5a41eb5900c18fd82341b09300eb362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (743,'os','côte 4 droite','axial','thorax','périnatal',X'00016a080000e81479958fd8234100898de8362a5a41eb5900c18fd82341b09300eb362a5a417c060000000100000069030000000100000005000000eb5900c18fd8234100898de8362a5a41e81479958fd8234100898de8362a5a41e81479958fd82341b09300eb362a5a41eb5900c18fd82341b09300eb362a5a41eb5900c18fd8234100898de8362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (744,'os','côte 5 droite','axial','thorax','périnatal',X'00016a080000e81479958fd82341507e1ae6362a5a41eb5900c18fd8234100898de8362a5a417c060000000100000069030000000100000005000000eb5900c18fd82341507e1ae6362a5a41e81479958fd82341507e1ae6362a5a41e81479958fd8234100898de8362a5a41eb5900c18fd8234100898de8362a5a41eb5900c18fd82341507e1ae6362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (745,'os','côte 6 droite','axial','thorax','périnatal',X'00016a080000e81479958fd82341a073a7e3362a5a41eb5900c18fd82341507e1ae6362a5a417c060000000100000069030000000100000005000000eb5900c18fd82341a073a7e3362a5a41e81479958fd82341a073a7e3362a5a41e81479958fd82341507e1ae6362a5a41eb5900c18fd82341507e1ae6362a5a41eb5900c18fd82341a073a7e3362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (746,'os','côte 7 droite','axial','thorax','périnatal',X'00016a080000e81479958fd82341f16834e1362a5a41eb5900c18fd82341a073a7e3362a5a417c060000000100000069030000000100000005000000eb5900c18fd82341f16834e1362a5a41e81479958fd82341f16834e1362a5a41e81479958fd82341a073a7e3362a5a41eb5900c18fd82341a073a7e3362a5a41eb5900c18fd82341f16834e1362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (747,'os','côte 8 droite','axial','thorax','périnatal',X'00016a080000e81479958fd82341cd4fc1de362a5a41eb5900c18fd82341f16834e1362a5a417c060000000100000069030000000100000005000000eb5900c18fd82341cd4fc1de362a5a41e81479958fd82341cd4fc1de362a5a41e81479958fd82341f16834e1362a5a41eb5900c18fd82341f16834e1362a5a41eb5900c18fd82341cd4fc1de362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (748,'os','cervicale 5 corps','axial','rachis','périnatal',X'00016a080000379ebac18fd82341ab176648372a5a4102a146ed8fd823415b22d94a372a5a417c06000000010000006903000000010000000500000002a146ed8fd82341ab176648372a5a41379ebac18fd82341ab176648372a5a41379ebac18fd823415b22d94a372a5a4102a146ed8fd823415b22d94a372a5a4102a146ed8fd82341ab176648372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (749,'os','cervicale 5 arc gauche','axial','rachis','périnatal',X'00016a08000002a146ed8fd82341ab176648372a5a413330d21890d823415b22d94a372a5a417c0600000001000000690300000001000000050000003330d21890d82341ab176648372a5a4102a146ed8fd82341ab176648372a5a4102a146ed8fd823415b22d94a372a5a413330d21890d823415b22d94a372a5a413330d21890d82341ab176648372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (750,'os','cervicale 2 arc droit','axial','rachis','périnatal',X'00016a080000050f2f968fd82341f43ebf4f372a5a41379ebac18fd82341a4493252372a5a417c060000000100000069030000000100000005000000379ebac18fd82341f43ebf4f372a5a41050f2f968fd82341f43ebf4f372a5a41050f2f968fd82341a4493252372a5a41379ebac18fd82341a4493252372a5a41379ebac18fd82341f43ebf4f372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (751,'os','cervicale 2 corps','axial','rachis','périnatal',X'00016a0800009c9f80d78fd82341f43ebf4f372a5a4102a146ed8fd82341a4493252372a5a417c06000000010000006903000000010000000500000002a146ed8fd82341f43ebf4f372a5a419c9f80d78fd82341f43ebf4f372a5a419c9f80d78fd82341a4493252372a5a4102a146ed8fd82341a4493252372a5a4102a146ed8fd82341f43ebf4f372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (752,'os','cervicale 2 corps','axial','rachis','périnatal',X'00016a080000379ebac18fd82341f43ebf4f372a5a419c9f80d78fd82341a4493252372a5a417c0600000001000000690300000001000000050000009c9f80d78fd82341f43ebf4f372a5a41379ebac18fd82341f43ebf4f372a5a41379ebac18fd82341a4493252372a5a419c9f80d78fd82341a4493252372a5a419c9f80d78fd82341f43ebf4f372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (753,'os','cervicale 2 arc gauche','axial','rachis','périnatal',X'00016a08000002a146ed8fd82341f43ebf4f372a5a413330d21890d82341a4493252372a5a417c0600000001000000690300000001000000050000003330d21890d82341f43ebf4f372a5a4102a146ed8fd82341f43ebf4f372a5a4102a146ed8fd82341a4493252372a5a413330d21890d82341a4493252372a5a413330d21890d82341f43ebf4f372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (754,'os','cervicale 3 arc droit','axial','rachis','périnatal',X'00016a080000050f2f968fd823410b2d4c4d372a5a41379ebac18fd82341f43ebf4f372a5a417c060000000100000069030000000100000005000000379ebac18fd823410b2d4c4d372a5a41050f2f968fd823410b2d4c4d372a5a41050f2f968fd82341f43ebf4f372a5a41379ebac18fd82341f43ebf4f372a5a41379ebac18fd823410b2d4c4d372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (755,'os','cervicale 1 arc droit','axial','rachis','périnatal',X'00016a080000050f2f968fd82341a4493252372a5a41379ebac18fd823415454a554372a5a417c060000000100000069030000000100000005000000379ebac18fd82341a4493252372a5a41050f2f968fd82341a4493252372a5a41050f2f968fd823415454a554372a5a41379ebac18fd823415454a554372a5a41379ebac18fd82341a4493252372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (756,'os','cervicale 1 arc gauche','axial','rachis','périnatal',X'00016a08000002a146ed8fd82341a4493252372a5a413330d21890d823415454a554372a5a417c0600000001000000690300000001000000050000003330d21890d82341a4493252372a5a4102a146ed8fd82341a4493252372a5a4102a146ed8fd823415454a554372a5a413330d21890d823415454a554372a5a413330d21890d82341a4493252372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (757,'os','lombaire 3 arc gauche','axial','rachis','périnatal',X'00016a08000002a146ed8fd823411d13f614372a5a413330d21890d82341cd1d6917372a5a417c0600000001000000690300000001000000050000003330d21890d823411d13f614372a5a4102a146ed8fd823411d13f614372a5a4102a146ed8fd82341cd1d6917372a5a413330d21890d82341cd1d6917372a5a413330d21890d823411d13f614372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (758,'os','lombaire 4 arc droit','axial','rachis','périnatal',X'00016a080000050f2f968fd82341faf98212372a5a41379ebac18fd823411d13f614372a5a417c060000000100000069030000000100000005000000379ebac18fd82341faf98212372a5a41050f2f968fd82341faf98212372a5a41050f2f968fd823411d13f614372a5a41379ebac18fd823411d13f614372a5a41379ebac18fd82341faf98212372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (759,'os','lombaire 4 corps','axial','rachis','périnatal',X'00016a080000379ebac18fd82341faf98212372a5a4102a146ed8fd823411d13f614372a5a417c06000000010000006903000000010000000500000002a146ed8fd82341faf98212372a5a41379ebac18fd82341faf98212372a5a41379ebac18fd823411d13f614372a5a4102a146ed8fd823411d13f614372a5a4102a146ed8fd82341faf98212372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (760,'os','lombaire 4 arc gauche','axial','rachis','périnatal',X'00016a08000002a146ed8fd82341faf98212372a5a413330d21890d823411d13f614372a5a417c0600000001000000690300000001000000050000003330d21890d82341faf98212372a5a4102a146ed8fd82341faf98212372a5a4102a146ed8fd823411d13f614372a5a413330d21890d823411d13f614372a5a413330d21890d82341faf98212372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (761,'os','lombaire 5 arc droit','axial','rachis','périnatal',X'00016a080000050f2f968fd82341bdfd0f10372a5a41379ebac18fd82341faf98212372a5a417c060000000100000069030000000100000005000000379ebac18fd82341bdfd0f10372a5a41050f2f968fd82341bdfd0f10372a5a41050f2f968fd82341faf98212372a5a41379ebac18fd82341faf98212372a5a41379ebac18fd82341bdfd0f10372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (762,'os','lombaire 5 corps','axial','rachis','périnatal',X'00016a080000379ebac18fd82341bdfd0f10372a5a4102a146ed8fd82341faf98212372a5a417c06000000010000006903000000010000000500000002a146ed8fd82341bdfd0f10372a5a41379ebac18fd82341bdfd0f10372a5a41379ebac18fd82341faf98212372a5a4102a146ed8fd82341faf98212372a5a4102a146ed8fd82341bdfd0f10372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (763,'os','lombaire 5 arc gauche','axial','rachis','périnatal',X'00016a08000002a146ed8fd82341bdfd0f10372a5a413330d21890d82341faf98212372a5a417c0600000001000000690300000001000000050000003330d21890d82341bdfd0f10372a5a4102a146ed8fd82341bdfd0f10372a5a4102a146ed8fd82341faf98212372a5a413330d21890d82341faf98212372a5a413330d21890d82341bdfd0f10372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (764,'os','rang indéterminé','axial','rachis','périnatal',X'00016a080000050f2f968fd82341ae7f950d372a5a41379ebac18fd82341bdfd0f10372a5a417c060000000100000069030000000100000005000000379ebac18fd82341ae7f950d372a5a41050f2f968fd82341ae7f950d372a5a41050f2f968fd82341bdfd0f10372a5a41379ebac18fd82341bdfd0f10372a5a41379ebac18fd82341ae7f950d372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (765,'os','lombaire 1 arc droit','axial','rachis','périnatal',X'00016a080000050f2f968fd823417d28dc19372a5a41379ebac18fd82341cea54d1c372a5a417c060000000100000069030000000100000005000000379ebac18fd823417d28dc19372a5a41050f2f968fd823417d28dc19372a5a41050f2f968fd82341cea54d1c372a5a41379ebac18fd82341cea54d1c372a5a41379ebac18fd823417d28dc19372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (766,'os','lombaire 1 corps','axial','rachis','périnatal',X'00016a080000379ebac18fd823417d28dc19372a5a4102a146ed8fd82341cea54d1c372a5a417c06000000010000006903000000010000000500000002a146ed8fd823417d28dc19372a5a41379ebac18fd823417d28dc19372a5a41379ebac18fd82341cea54d1c372a5a4102a146ed8fd82341cea54d1c372a5a4102a146ed8fd823417d28dc19372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (767,'os','lombaire 1 arc gauche','axial','rachis','périnatal',X'00016a08000002a146ed8fd823417d28dc19372a5a413330d21890d82341cea54d1c372a5a417c0600000001000000690300000001000000050000003330d21890d823417d28dc19372a5a4102a146ed8fd823417d28dc19372a5a4102a146ed8fd82341cea54d1c372a5a413330d21890d82341cea54d1c372a5a413330d21890d823417d28dc19372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (768,'os','lombaire 2 arc droit','axial','rachis','périnatal',X'00016a080000050f2f968fd82341cd1d6917372a5a41379ebac18fd823417d28dc19372a5a417c060000000100000069030000000100000005000000379ebac18fd82341cd1d6917372a5a41050f2f968fd82341cd1d6917372a5a41050f2f968fd823417d28dc19372a5a41379ebac18fd823417d28dc19372a5a41379ebac18fd82341cd1d6917372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (769,'os','lombaire 2 corps','axial','rachis','périnatal',X'00016a080000379ebac18fd82341cd1d6917372a5a4102a146ed8fd823417d28dc19372a5a417c06000000010000006903000000010000000500000002a146ed8fd82341cd1d6917372a5a41379ebac18fd82341cd1d6917372a5a41379ebac18fd823417d28dc19372a5a4102a146ed8fd823417d28dc19372a5a4102a146ed8fd82341cd1d6917372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (770,'os','lombaire 2 arc gauche','axial','rachis','périnatal',X'00016a08000002a146ed8fd82341cd1d6917372a5a413330d21890d823417d28dc19372a5a417c0600000001000000690300000001000000050000003330d21890d82341cd1d6917372a5a4102a146ed8fd82341cd1d6917372a5a4102a146ed8fd823417d28dc19372a5a413330d21890d823417d28dc19372a5a413330d21890d82341cd1d6917372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (771,'os','lombaire 3 arc droit','axial','rachis','périnatal',X'00016a080000050f2f968fd823411d13f614372a5a41379ebac18fd82341cd1d6917372a5a417c060000000100000069030000000100000005000000379ebac18fd823411d13f614372a5a41050f2f968fd823411d13f614372a5a41050f2f968fd82341cd1d6917372a5a41379ebac18fd82341cd1d6917372a5a41379ebac18fd823411d13f614372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (772,'os','lombaire 3 corps','axial','rachis','périnatal',X'00016a080000379ebac18fd823411d13f614372a5a4102a146ed8fd82341cd1d6917372a5a417c06000000010000006903000000010000000500000002a146ed8fd823411d13f614372a5a41379ebac18fd823411d13f614372a5a41379ebac18fd82341cd1d6917372a5a4102a146ed8fd82341cd1d6917372a5a4102a146ed8fd823411d13f614372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (773,'os','côte 9 gauche','axial','thorax','périnatal',X'00016a080000eb5900c18fd8234191534edc362a5a4150af8bec8fd82341cd4fc1de362a5a417c06000000010000006903000000010000000500000050af8bec8fd8234191534edc362a5a41eb5900c18fd8234191534edc362a5a41eb5900c18fd82341cd4fc1de362a5a4150af8bec8fd82341cd4fc1de362a5a4150af8bec8fd8234191534edc362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (774,'os','côte 10 gauche','axial','thorax','périnatal',X'00016a080000eb5900c18fd82341e148dbd9362a5a4150af8bec8fd8234191534edc362a5a417c06000000010000006903000000010000000500000050af8bec8fd82341e148dbd9362a5a41eb5900c18fd82341e148dbd9362a5a41eb5900c18fd8234191534edc362a5a4150af8bec8fd8234191534edc362a5a4150af8bec8fd82341e148dbd9362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (775,'os','côte 11 gauche','axial','thorax','périnatal',X'00016a080000eb5900c18fd82341be2f68d7362a5a4150af8bec8fd82341e148dbd9362a5a417c06000000010000006903000000010000000500000050af8bec8fd82341be2f68d7362a5a41eb5900c18fd82341be2f68d7362a5a41eb5900c18fd82341e148dbd9362a5a4150af8bec8fd82341e148dbd9362a5a4150af8bec8fd82341be2f68d7362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (776,'os','côte 12 gauche','axial','thorax','périnatal',X'00016a080000eb5900c18fd823418133f5d4362a5a4150af8bec8fd82341be2f68d7362a5a417c06000000010000006903000000010000000500000050af8bec8fd823418133f5d4362a5a41eb5900c18fd823418133f5d4362a5a41eb5900c18fd82341be2f68d7362a5a4150af8bec8fd82341be2f68d7362a5a4150af8bec8fd823418133f5d4362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (777,'os','rang indéterminé gauche','axial','thorax','périnatal',X'00016a080000eb5900c18fd82341fcf68ad2362a5a4150af8bec8fd823418133f5d4362a5a417c06000000010000006903000000010000000500000050af8bec8fd82341fcf68ad2362a5a41eb5900c18fd82341fcf68ad2362a5a41eb5900c18fd823418133f5d4362a5a4150af8bec8fd823418133f5d4362a5a4150af8bec8fd82341fcf68ad2362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (778,'os','côté indéterminé','axial','thorax','périnatal',X'00016a080000e81479958fd82341eac820d0362a5a4150af8bec8fd82341fcf68ad2362a5a417c06000000010000006903000000010000000500000050af8bec8fd82341eac820d0362a5a41e81479958fd82341eac820d0362a5a41e81479958fd82341fcf68ad2362a5a4150af8bec8fd82341fcf68ad2362a5a4150af8bec8fd82341eac820d0362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (779,'os','manubrium','axial','thorax','périnatal',X'00016a080000b9ca74958fd823416ef3fec9362a5a4150af8bec8fd82341227a6dcc362a5a417c06000000010000006903000000010000000500000050af8bec8fd823416ef3fec9362a5a41b9ca74958fd823416ef3fec9362a5a41b9ca74958fd82341227a6dcc362a5a4150af8bec8fd82341227a6dcc362a5a4150af8bec8fd823416ef3fec9362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (780,'os','sternèbres','axial','thorax','périnatal',X'00016a080000b9ca74958fd823412c7b90c7362a5a4150af8bec8fd823416ef3fec9362a5a417c06000000010000006903000000010000000500000050af8bec8fd823412c7b90c7362a5a41b9ca74958fd823412c7b90c7362a5a41b9ca74958fd823416ef3fec9362a5a4150af8bec8fd823416ef3fec9362a5a4150af8bec8fd823412c7b90c7362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (781,'os','côte 1 gauche','axial','thorax','périnatal',X'00016a080000eb5900c18fd8234110a9e6ef362a5a4150af8bec8fd82341466b60f2362a5a417c06000000010000006903000000010000000500000050af8bec8fd8234110a9e6ef362a5a41eb5900c18fd8234110a9e6ef362a5a41eb5900c18fd82341466b60f2362a5a4150af8bec8fd82341466b60f2362a5a4150af8bec8fd8234110a9e6ef362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (782,'os','côte 2 gauche','axial','thorax','périnatal',X'00016a080000eb5900c18fd82341609e73ed362a5a4150af8bec8fd8234110a9e6ef362a5a417c06000000010000006903000000010000000500000050af8bec8fd82341609e73ed362a5a41eb5900c18fd82341609e73ed362a5a41eb5900c18fd8234110a9e6ef362a5a4150af8bec8fd8234110a9e6ef362a5a4150af8bec8fd82341609e73ed362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (783,'os','côte 3 gauche','axial','thorax','périnatal',X'00016a080000eb5900c18fd82341b09300eb362a5a4150af8bec8fd82341609e73ed362a5a417c06000000010000006903000000010000000500000050af8bec8fd82341b09300eb362a5a41eb5900c18fd82341b09300eb362a5a41eb5900c18fd82341609e73ed362a5a4150af8bec8fd82341609e73ed362a5a4150af8bec8fd82341b09300eb362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (784,'os','côte 4 gauche','axial','thorax','périnatal',X'00016a080000eb5900c18fd8234100898de8362a5a4150af8bec8fd82341b09300eb362a5a417c06000000010000006903000000010000000500000050af8bec8fd8234100898de8362a5a41eb5900c18fd8234100898de8362a5a41eb5900c18fd82341b09300eb362a5a4150af8bec8fd82341b09300eb362a5a4150af8bec8fd8234100898de8362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (785,'os','côte 5 gauche','axial','thorax','périnatal',X'00016a080000eb5900c18fd82341507e1ae6362a5a4150af8bec8fd8234100898de8362a5a417c06000000010000006903000000010000000500000050af8bec8fd82341507e1ae6362a5a41eb5900c18fd82341507e1ae6362a5a41eb5900c18fd8234100898de8362a5a4150af8bec8fd8234100898de8362a5a4150af8bec8fd82341507e1ae6362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (786,'os','côte 6 gauche','axial','thorax','périnatal',X'00016a080000eb5900c18fd82341a073a7e3362a5a4150af8bec8fd82341507e1ae6362a5a417c06000000010000006903000000010000000500000050af8bec8fd82341a073a7e3362a5a41eb5900c18fd82341a073a7e3362a5a41eb5900c18fd82341507e1ae6362a5a4150af8bec8fd82341507e1ae6362a5a4150af8bec8fd82341a073a7e3362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (787,'os','côte 7 gauche','axial','thorax','périnatal',X'00016a080000eb5900c18fd82341f16834e1362a5a4150af8bec8fd82341a073a7e3362a5a417c06000000010000006903000000010000000500000050af8bec8fd82341f16834e1362a5a41eb5900c18fd82341f16834e1362a5a41eb5900c18fd82341a073a7e3362a5a4150af8bec8fd82341a073a7e3362a5a4150af8bec8fd82341f16834e1362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (788,'os','côte 8 gauche','axial','thorax','périnatal',X'00016a080000eb5900c18fd82341cd4fc1de362a5a4150af8bec8fd82341f16834e1362a5a417c06000000010000006903000000010000000500000050af8bec8fd82341cd4fc1de362a5a41eb5900c18fd82341cd4fc1de362a5a41eb5900c18fd82341f16834e1362a5a4150af8bec8fd82341f16834e1362a5a4150af8bec8fd82341cd4fc1de362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (789,'os','sacrée 5 corps','axial','rachis','périnatal',X'00016a08000002a146ed8fd82341ca9977fc362a5a413330d21890d823417aa4eafe362a5a417c0600000001000000690300000001000000050000003330d21890d82341ca9977fc362a5a4102a146ed8fd82341ca9977fc362a5a4102a146ed8fd823417aa4eafe362a5a413330d21890d823417aa4eafe362a5a413330d21890d82341ca9977fc362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (790,'os','sacrée 5 arc gauche','axial','rachis','périnatal',X'00016a0800003330d21890d82341ca9977fc362a5a4165bf5d4490d823417aa4eafe362a5a417c06000000010000006903000000010000000500000065bf5d4490d82341ca9977fc362a5a413330d21890d82341ca9977fc362a5a413330d21890d823417aa4eafe362a5a4165bf5d4490d823417aa4eafe362a5a4165bf5d4490d82341ca9977fc362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (791,'os','sacrée 5 aileron gauche','axial','rachis','périnatal',X'00016a08000065bf5d4490d82341ca9977fc362a5a41ca14e96f90d823417aa4eafe362a5a417c060000000100000069030000000100000005000000ca14e96f90d82341ca9977fc362a5a4165bf5d4490d82341ca9977fc362a5a4165bf5d4490d823417aa4eafe362a5a41ca14e96f90d823417aa4eafe362a5a41ca14e96f90d82341ca9977fc362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (792,'os','rang indéterminé aileron droit','axial','rachis','périnatal',X'00016a080000050f2f968fd823411a8f04fa362a5a41379ebac18fd82341ca9977fc362a5a417c060000000100000069030000000100000005000000379ebac18fd823411a8f04fa362a5a41050f2f968fd823411a8f04fa362a5a41050f2f968fd82341ca9977fc362a5a41379ebac18fd82341ca9977fc362a5a41379ebac18fd823411a8f04fa362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (793,'os','rang indéterminé arc droit','axial','rachis','périnatal',X'00016a080000379ebac18fd823411a8f04fa362a5a4102a146ed8fd82341ca9977fc362a5a417c06000000010000006903000000010000000500000002a146ed8fd823411a8f04fa362a5a41379ebac18fd823411a8f04fa362a5a41379ebac18fd82341ca9977fc362a5a4102a146ed8fd82341ca9977fc362a5a4102a146ed8fd823411a8f04fa362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (794,'os','rang indéterminé corps','axial','rachis','périnatal',X'00016a08000002a146ed8fd823411a8f04fa362a5a413330d21890d82341ca9977fc362a5a417c0600000001000000690300000001000000050000003330d21890d823411a8f04fa362a5a4102a146ed8fd823411a8f04fa362a5a4102a146ed8fd82341ca9977fc362a5a413330d21890d82341ca9977fc362a5a413330d21890d823411a8f04fa362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (795,'os','rang indéterminé arc gauche','axial','rachis','périnatal',X'00016a0800003330d21890d823411a8f04fa362a5a4165bf5d4490d82341ca9977fc362a5a417c06000000010000006903000000010000000500000065bf5d4490d823411a8f04fa362a5a413330d21890d823411a8f04fa362a5a413330d21890d82341ca9977fc362a5a4165bf5d4490d82341ca9977fc362a5a4165bf5d4490d823411a8f04fa362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (796,'os','rang indéterminé aileron gauche','axial','rachis','périnatal',X'00016a08000065bf5d4490d823411a8f04fa362a5a41ca14e96f90d82341ca9977fc362a5a417c060000000100000069030000000100000005000000ca14e96f90d823411a8f04fa362a5a4165bf5d4490d823411a8f04fa362a5a4165bf5d4490d82341ca9977fc362a5a41ca14e96f90d82341ca9977fc362a5a41ca14e96f90d823411a8f04fa362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (797,'os','sacrée 3 aileron gauche','axial','rachis','périnatal',X'00016a08000065bf5d4490d82341b7a05d01372a5a41ca14e96f90d82341dab9d003372a5a417c060000000100000069030000000100000005000000ca14e96f90d82341b7a05d01372a5a4165bf5d4490d82341b7a05d01372a5a4165bf5d4490d82341dab9d003372a5a41ca14e96f90d82341dab9d003372a5a41ca14e96f90d82341b7a05d01372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (798,'os','sacrée 4 aileron droit','axial','rachis','périnatal',X'00016a080000050f2f968fd823417aa4eafe362a5a41379ebac18fd82341b7a05d01372a5a417c060000000100000069030000000100000005000000379ebac18fd823417aa4eafe362a5a41050f2f968fd823417aa4eafe362a5a41050f2f968fd82341b7a05d01372a5a41379ebac18fd82341b7a05d01372a5a41379ebac18fd823417aa4eafe362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (799,'os','sacrée 4 arc droit','axial','rachis','périnatal',X'00016a080000379ebac18fd823417aa4eafe362a5a4102a146ed8fd82341b7a05d01372a5a417c06000000010000006903000000010000000500000002a146ed8fd823417aa4eafe362a5a41379ebac18fd823417aa4eafe362a5a41379ebac18fd82341b7a05d01372a5a4102a146ed8fd82341b7a05d01372a5a4102a146ed8fd823417aa4eafe362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (800,'os','sacrée 4 corps','axial','rachis','périnatal',X'00016a08000002a146ed8fd823417aa4eafe362a5a413330d21890d82341b7a05d01372a5a417c0600000001000000690300000001000000050000003330d21890d823417aa4eafe362a5a4102a146ed8fd823417aa4eafe362a5a4102a146ed8fd82341b7a05d01372a5a413330d21890d82341b7a05d01372a5a413330d21890d823417aa4eafe362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (801,'os','sacrée 4 arc gauche','axial','rachis','périnatal',X'00016a0800003330d21890d823417aa4eafe362a5a4165bf5d4490d82341b7a05d01372a5a417c06000000010000006903000000010000000500000065bf5d4490d823417aa4eafe362a5a413330d21890d823417aa4eafe362a5a413330d21890d82341b7a05d01372a5a4165bf5d4490d82341b7a05d01372a5a4165bf5d4490d823417aa4eafe362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (802,'os','sacrée 4 aileron gauche','axial','rachis','périnatal',X'00016a08000065bf5d4490d823417aa4eafe362a5a41ca14e96f90d82341b7a05d01372a5a417c060000000100000069030000000100000005000000ca14e96f90d823417aa4eafe362a5a4165bf5d4490d823417aa4eafe362a5a4165bf5d4490d82341b7a05d01372a5a41ca14e96f90d82341b7a05d01372a5a41ca14e96f90d823417aa4eafe362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (803,'os','sacrée 5 aileron droit','axial','rachis','périnatal',X'00016a080000050f2f968fd82341ca9977fc362a5a41379ebac18fd823417aa4eafe362a5a417c060000000100000069030000000100000005000000379ebac18fd82341ca9977fc362a5a41050f2f968fd82341ca9977fc362a5a41050f2f968fd823417aa4eafe362a5a41379ebac18fd823417aa4eafe362a5a41379ebac18fd82341ca9977fc362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (804,'os','sacrée 5 arc droit','axial','rachis','périnatal',X'00016a080000379ebac18fd82341ca9977fc362a5a4102a146ed8fd823417aa4eafe362a5a417c06000000010000006903000000010000000500000002a146ed8fd82341ca9977fc362a5a41379ebac18fd82341ca9977fc362a5a41379ebac18fd823417aa4eafe362a5a4102a146ed8fd823417aa4eafe362a5a4102a146ed8fd82341ca9977fc362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (805,'os','sacrée 2 arc droit','axial','rachis','périnatal',X'00016a080000379ebac18fd82341dab9d003372a5a4102a146ed8fd823418ac44306372a5a417c06000000010000006903000000010000000500000002a146ed8fd82341dab9d003372a5a41379ebac18fd82341dab9d003372a5a41379ebac18fd823418ac44306372a5a4102a146ed8fd823418ac44306372a5a4102a146ed8fd82341dab9d003372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (806,'os','sacrée 2 corps','axial','rachis','périnatal',X'00016a08000002a146ed8fd82341dab9d003372a5a413330d21890d823418ac44306372a5a417c0600000001000000690300000001000000050000003330d21890d82341dab9d003372a5a4102a146ed8fd82341dab9d003372a5a4102a146ed8fd823418ac44306372a5a413330d21890d823418ac44306372a5a413330d21890d82341dab9d003372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (807,'os','sacrée 2 arc gauche','axial','rachis','périnatal',X'00016a0800003330d21890d82341dab9d003372a5a4165bf5d4490d823418ac44306372a5a417c06000000010000006903000000010000000500000065bf5d4490d82341dab9d003372a5a413330d21890d82341dab9d003372a5a413330d21890d823418ac44306372a5a4165bf5d4490d823418ac44306372a5a4165bf5d4490d82341dab9d003372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (808,'os','sacrée 2 aileron gauche','axial','rachis','périnatal',X'00016a08000065bf5d4490d82341dab9d003372a5a41ca14e96f90d823418ac44306372a5a417c060000000100000069030000000100000005000000ca14e96f90d82341dab9d003372a5a4165bf5d4490d82341dab9d003372a5a4165bf5d4490d823418ac44306372a5a41ca14e96f90d823418ac44306372a5a41ca14e96f90d82341dab9d003372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (809,'os','sacrée 3 aileron droit','axial','rachis','périnatal',X'00016a080000050f2f968fd82341b7a05d01372a5a41379ebac18fd82341dab9d003372a5a417c060000000100000069030000000100000005000000379ebac18fd82341b7a05d01372a5a41050f2f968fd82341b7a05d01372a5a41050f2f968fd82341dab9d003372a5a41379ebac18fd82341dab9d003372a5a41379ebac18fd82341b7a05d01372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (810,'os','sacrée 3 arc droit','axial','rachis','périnatal',X'00016a080000379ebac18fd82341b7a05d01372a5a4102a146ed8fd82341dab9d003372a5a417c06000000010000006903000000010000000500000002a146ed8fd82341b7a05d01372a5a41379ebac18fd82341b7a05d01372a5a41379ebac18fd82341dab9d003372a5a4102a146ed8fd82341dab9d003372a5a4102a146ed8fd82341b7a05d01372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (811,'os','sacrée 3 corps','axial','rachis','périnatal',X'00016a08000002a146ed8fd82341b7a05d01372a5a413330d21890d82341dab9d003372a5a417c0600000001000000690300000001000000050000003330d21890d82341b7a05d01372a5a4102a146ed8fd82341b7a05d01372a5a4102a146ed8fd82341dab9d003372a5a413330d21890d82341dab9d003372a5a413330d21890d82341b7a05d01372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (812,'os','sacrée 3 arc gauche','axial','rachis','périnatal',X'00016a0800003330d21890d82341b7a05d01372a5a4165bf5d4490d82341dab9d003372a5a417c06000000010000006903000000010000000500000065bf5d4490d82341b7a05d01372a5a413330d21890d82341b7a05d01372a5a413330d21890d82341dab9d003372a5a4165bf5d4490d82341dab9d003372a5a4165bf5d4490d82341b7a05d01372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (813,'os','rang indéterminé corps','axial','rachis','périnatal',X'00016a080000379ebac18fd82341ae7f950d372a5a4102a146ed8fd82341bdfd0f10372a5a417c06000000010000006903000000010000000500000002a146ed8fd82341ae7f950d372a5a41379ebac18fd82341ae7f950d372a5a41379ebac18fd82341bdfd0f10372a5a4102a146ed8fd82341bdfd0f10372a5a4102a146ed8fd82341ae7f950d372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (814,'os','rang indéterminé arc gauche','axial','rachis','périnatal',X'00016a08000002a146ed8fd82341ae7f950d372a5a413330d21890d82341bdfd0f10372a5a417c0600000001000000690300000001000000050000003330d21890d82341ae7f950d372a5a4102a146ed8fd82341ae7f950d372a5a4102a146ed8fd82341bdfd0f10372a5a413330d21890d82341bdfd0f10372a5a413330d21890d82341ae7f950d372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (815,'os','sacrée 1 aileron droit','axial','rachis','périnatal',X'00016a080000050f2f968fd823418ac44306372a5a41379ebac18fd823418eb2af08372a5a417c060000000100000069030000000100000005000000379ebac18fd823418ac44306372a5a41050f2f968fd823418ac44306372a5a41050f2f968fd823418eb2af08372a5a41379ebac18fd823418eb2af08372a5a41379ebac18fd823418ac44306372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (816,'os','sacrée 1 arc droit','axial','rachis','périnatal',X'00016a080000379ebac18fd823418ac44306372a5a4102a146ed8fd823418eb2af08372a5a417c06000000010000006903000000010000000500000002a146ed8fd823418ac44306372a5a41379ebac18fd823418ac44306372a5a41379ebac18fd823418eb2af08372a5a4102a146ed8fd823418eb2af08372a5a4102a146ed8fd823418ac44306372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (817,'os','sacrée 1 corps','axial','rachis','périnatal',X'00016a08000002a146ed8fd823418ac44306372a5a413330d21890d823418eb2af08372a5a417c0600000001000000690300000001000000050000003330d21890d823418ac44306372a5a4102a146ed8fd823418ac44306372a5a4102a146ed8fd823418eb2af08372a5a413330d21890d823418eb2af08372a5a413330d21890d823418ac44306372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (818,'os','sacrée 1 arc gauche','axial','rachis','périnatal',X'00016a0800003330d21890d823418ac44306372a5a4165bf5d4490d823418eb2af08372a5a417c06000000010000006903000000010000000500000065bf5d4490d823418ac44306372a5a413330d21890d823418ac44306372a5a413330d21890d823418eb2af08372a5a4165bf5d4490d823418eb2af08372a5a4165bf5d4490d823418ac44306372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (819,'os','sacrée 1 aileron gauche','axial','rachis','périnatal',X'00016a08000065bf5d4490d823418ac44306372a5a41ca14e96f90d823418eb2af08372a5a417c060000000100000069030000000100000005000000ca14e96f90d823418ac44306372a5a4165bf5d4490d823418ac44306372a5a4165bf5d4490d823418eb2af08372a5a41ca14e96f90d823418eb2af08372a5a41ca14e96f90d823418ac44306372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (820,'os','sacrée 2 aileron droit','axial','rachis','périnatal',X'00016a080000050f2f968fd82341dab9d003372a5a41379ebac18fd823418ac44306372a5a417c060000000100000069030000000100000005000000379ebac18fd82341dab9d003372a5a41050f2f968fd82341dab9d003372a5a41050f2f968fd823418ac44306372a5a41379ebac18fd823418ac44306372a5a41379ebac18fd82341dab9d003372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (821,'os','rang indéterminé arc gauche','axial','rachis','périnatal',X'00016a08000002a146ed8fd823411d331841372a5a413330d21890d82341c1b48343372a5a417c0600000001000000690300000001000000050000003330d21890d823411d331841372a5a4102a146ed8fd823411d331841372a5a4102a146ed8fd82341c1b48343372a5a413330d21890d82341c1b48343372a5a413330d21890d823411d331841372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (822,'os','thoracique 1 arc droit','axial','rachis','périnatal',X'00016a080000050f2f968fd82341c8d3263c372a5a41379ebac18fd82341f775a13e372a5a417c060000000100000069030000000100000005000000379ebac18fd82341c8d3263c372a5a41050f2f968fd82341c8d3263c372a5a41050f2f968fd82341f775a13e372a5a41379ebac18fd82341f775a13e372a5a41379ebac18fd82341c8d3263c372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (823,'os','thoracique 1 corps','axial','rachis','périnatal',X'00016a080000379ebac18fd82341c8d3263c372a5a4102a146ed8fd82341f775a13e372a5a417c06000000010000006903000000010000000500000002a146ed8fd82341c8d3263c372a5a41379ebac18fd82341c8d3263c372a5a41379ebac18fd82341f775a13e372a5a4102a146ed8fd82341f775a13e372a5a4102a146ed8fd82341c8d3263c372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (824,'os','thoracique 1 arc gauche','axial','rachis','périnatal',X'00016a08000002a146ed8fd82341c8d3263c372a5a413330d21890d82341f775a13e372a5a417c0600000001000000690300000001000000050000003330d21890d82341c8d3263c372a5a4102a146ed8fd82341c8d3263c372a5a4102a146ed8fd82341f775a13e372a5a413330d21890d82341f775a13e372a5a413330d21890d82341c8d3263c372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (825,'os','thoracique 2 arc droit','axial','rachis','périnatal',X'00016a080000050f2f968fd8234152d0b339372a5a41379ebac18fd82341c8d3263c372a5a417c060000000100000069030000000100000005000000379ebac18fd8234152d0b339372a5a41050f2f968fd8234152d0b339372a5a41050f2f968fd82341c8d3263c372a5a41379ebac18fd82341c8d3263c372a5a41379ebac18fd8234152d0b339372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (826,'os','thoracique 2 corps','axial','rachis','périnatal',X'00016a080000379ebac18fd8234152d0b339372a5a4102a146ed8fd82341c8d3263c372a5a417c06000000010000006903000000010000000500000002a146ed8fd8234152d0b339372a5a41379ebac18fd8234152d0b339372a5a41379ebac18fd82341c8d3263c372a5a4102a146ed8fd82341c8d3263c372a5a4102a146ed8fd8234152d0b339372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (827,'os','thoracique 2 arc gauche','axial','rachis','périnatal',X'00016a08000002a146ed8fd8234152d0b339372a5a413330d21890d82341c8d3263c372a5a417c0600000001000000690300000001000000050000003330d21890d8234152d0b339372a5a4102a146ed8fd8234152d0b339372a5a4102a146ed8fd82341c8d3263c372a5a413330d21890d82341c8d3263c372a5a413330d21890d8234152d0b339372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (828,'os','thoracique 3 arc droit','axial','rachis','périnatal',X'00016a080000050f2f968fd82341a2c54037372a5a41379ebac18fd8234152d0b339372a5a417c060000000100000069030000000100000005000000379ebac18fd82341a2c54037372a5a41050f2f968fd82341a2c54037372a5a41050f2f968fd8234152d0b339372a5a41379ebac18fd8234152d0b339372a5a41379ebac18fd82341a2c54037372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (829,'os','cervicale 6 arc droit','axial','rachis','périnatal',X'00016a080000050f2f968fd82341fb0cf345372a5a41379ebac18fd82341ab176648372a5a417c060000000100000069030000000100000005000000379ebac18fd82341fb0cf345372a5a41050f2f968fd82341fb0cf345372a5a41050f2f968fd82341ab176648372a5a41379ebac18fd82341ab176648372a5a41379ebac18fd82341fb0cf345372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (830,'os','cervicale 6 corps','axial','rachis','périnatal',X'00016a080000379ebac18fd82341fb0cf345372a5a4102a146ed8fd82341ab176648372a5a417c06000000010000006903000000010000000500000002a146ed8fd82341fb0cf345372a5a41379ebac18fd82341fb0cf345372a5a41379ebac18fd82341ab176648372a5a4102a146ed8fd82341ab176648372a5a4102a146ed8fd82341fb0cf345372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (831,'os','cervicale 6 arc gauche','axial','rachis','périnatal',X'00016a08000002a146ed8fd82341fb0cf345372a5a413330d21890d82341ab176648372a5a417c0600000001000000690300000001000000050000003330d21890d82341fb0cf345372a5a4102a146ed8fd82341fb0cf345372a5a4102a146ed8fd82341ab176648372a5a413330d21890d82341ab176648372a5a413330d21890d82341fb0cf345372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (832,'os','cervicale 7 arc droit','axial','rachis','périnatal',X'00016a080000050f2f968fd82341c1b48343372a5a41379ebac18fd82341fb0cf345372a5a417c060000000100000069030000000100000005000000379ebac18fd82341c1b48343372a5a41050f2f968fd82341c1b48343372a5a41050f2f968fd82341fb0cf345372a5a41379ebac18fd82341fb0cf345372a5a41379ebac18fd82341c1b48343372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (833,'os','cervicale 7 corps','axial','rachis','périnatal',X'00016a080000379ebac18fd82341c1b48343372a5a4102a146ed8fd82341fb0cf345372a5a417c06000000010000006903000000010000000500000002a146ed8fd82341c1b48343372a5a41379ebac18fd82341c1b48343372a5a41379ebac18fd82341fb0cf345372a5a4102a146ed8fd82341fb0cf345372a5a4102a146ed8fd82341c1b48343372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (834,'os','cervicale 7 arc gauche','axial','rachis','périnatal',X'00016a08000002a146ed8fd82341c1b48343372a5a413330d21890d82341fb0cf345372a5a417c0600000001000000690300000001000000050000003330d21890d82341c1b48343372a5a4102a146ed8fd82341c1b48343372a5a4102a146ed8fd82341fb0cf345372a5a413330d21890d82341fb0cf345372a5a413330d21890d82341c1b48343372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (835,'os','rang indéterminé','axial','rachis','périnatal',X'00016a080000050f2f968fd823411d331841372a5a41379ebac18fd82341c1b48343372a5a417c060000000100000069030000000100000005000000379ebac18fd823411d331841372a5a41050f2f968fd823411d331841372a5a41050f2f968fd82341c1b48343372a5a41379ebac18fd82341c1b48343372a5a41379ebac18fd823411d331841372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (836,'os','rang indéterminé corps','axial','rachis','périnatal',X'00016a080000379ebac18fd823411d331841372a5a4102a146ed8fd82341c1b48343372a5a417c06000000010000006903000000010000000500000002a146ed8fd823411d331841372a5a41379ebac18fd823411d331841372a5a41379ebac18fd82341c1b48343372a5a4102a146ed8fd82341c1b48343372a5a4102a146ed8fd823411d331841372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (837,'os','cervicale 3 corps','axial','rachis','périnatal',X'00016a080000379ebac18fd823410b2d4c4d372a5a4102a146ed8fd82341f43ebf4f372a5a417c06000000010000006903000000010000000500000002a146ed8fd823410b2d4c4d372a5a41379ebac18fd823410b2d4c4d372a5a41379ebac18fd82341f43ebf4f372a5a4102a146ed8fd82341f43ebf4f372a5a4102a146ed8fd823410b2d4c4d372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (838,'os','cervicale 3 arc gauche','axial','rachis','périnatal',X'00016a08000002a146ed8fd823410b2d4c4d372a5a413330d21890d82341f43ebf4f372a5a417c0600000001000000690300000001000000050000003330d21890d823410b2d4c4d372a5a4102a146ed8fd823410b2d4c4d372a5a4102a146ed8fd82341f43ebf4f372a5a413330d21890d82341f43ebf4f372a5a413330d21890d823410b2d4c4d372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (839,'os','cervicale 4 arc droit','axial','rachis','périnatal',X'00016a080000050f2f968fd823415b22d94a372a5a41379ebac18fd823410b2d4c4d372a5a417c060000000100000069030000000100000005000000379ebac18fd823415b22d94a372a5a41050f2f968fd823415b22d94a372a5a41050f2f968fd823410b2d4c4d372a5a41379ebac18fd823410b2d4c4d372a5a41379ebac18fd823415b22d94a372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (840,'os','cervicale 4 corps','axial','rachis','périnatal',X'00016a080000379ebac18fd823415b22d94a372a5a4102a146ed8fd823410b2d4c4d372a5a417c06000000010000006903000000010000000500000002a146ed8fd823415b22d94a372a5a41379ebac18fd823415b22d94a372a5a41379ebac18fd823410b2d4c4d372a5a4102a146ed8fd823410b2d4c4d372a5a4102a146ed8fd823415b22d94a372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (841,'os','cervicale 4 arc gauche','axial','rachis','périnatal',X'00016a08000002a146ed8fd823415b22d94a372a5a413330d21890d823410b2d4c4d372a5a417c0600000001000000690300000001000000050000003330d21890d823415b22d94a372a5a4102a146ed8fd823415b22d94a372a5a4102a146ed8fd823410b2d4c4d372a5a413330d21890d823410b2d4c4d372a5a413330d21890d823415b22d94a372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (842,'os','cervicale 5 arc droit','axial','rachis','périnatal',X'00016a080000050f2f968fd82341ab176648372a5a41379ebac18fd823415b22d94a372a5a417c060000000100000069030000000100000005000000379ebac18fd82341ab176648372a5a41050f2f968fd82341ab176648372a5a41050f2f968fd823415b22d94a372a5a41379ebac18fd823415b22d94a372a5a41379ebac18fd82341ab176648372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (843,'os','dent','gauche','crâne','périnatal',X'00016a080000240928658ed823413242f754372a5a41c57a52818ed8234131f98b58372a5a417c060000000100000069030000000100000005000000240928658ed8234131f98b58372a5a41c57a52818ed8234163a75457372a5a41c57a52818ed823413242f754372a5a41240928658ed823413242f754372a5a41240928658ed8234131f98b58372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (844,'os','dent','gauche','crâne','périnatal',X'00016a080000c57a52818ed823413242f754372a5a41a59d069d8ed823416ef6e157372a5a417c060000000100000069030000000100000005000000c57a52818ed823416ef6e157372a5a41a59d069d8ed823416ef6e157372a5a41a59d069d8ed823413242f754372a5a41c57a52818ed823413242f754372a5a41c57a52818ed823416ef6e157372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (845,'os','dent','gauche','crâne','périnatal',X'00016a080000fe6ef0388ed823413242f754372a5a41222cfa4e8ed82341214de257372a5a417c060000000100000069030000000100000005000000fe6ef0388ed82341214de257372a5a41222cfa4e8ed82341214de257372a5a41222cfa4e8ed823413242f754372a5a41fe6ef0388ed823413242f754372a5a41fe6ef0388ed82341214de257372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (846,'os','dent','gauche','crâne','périnatal',X'00016a080000222cfa4e8ed823413242f754372a5a41240928658ed82341214de257372a5a417c060000000100000069030000000100000005000000222cfa4e8ed82341214de257372a5a41240928658ed82341214de257372a5a41240928658ed823413242f754372a5a41222cfa4e8ed823413242f754372a5a41222cfa4e8ed82341214de257372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (847,'os','dent','gauche','crâne','périnatal',X'00016a080000c57a52818ed823416ef6e157372a5a41a59d069d8ed82341d10fcd5a372a5a417c060000000100000069030000000100000005000000c57a52818ed823416ef6e157372a5a41c57a52818ed82341d10fcd5a372a5a41a59d069d8ed82341d10fcd5a372a5a41a59d069d8ed823416ef6e157372a5a41c57a52818ed823416ef6e157372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (848,'os','dent','gauche','crâne','périnatal',X'00016a080000a59d069d8ed823416ef6e157372a5a41ea8ebcb88ed82341d10fcd5a372a5a417c060000000100000069030000000100000005000000a59d069d8ed823416ef6e157372a5a41a59d069d8ed82341d10fcd5a372a5a41ea8ebcb88ed82341d10fcd5a372a5a41ea8ebcb88ed823416ef6e157372a5a41a59d069d8ed823416ef6e157372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (849,'os','dent','gauche','crâne','périnatal',X'00016a080000222cfa4e8ed82341214de257372a5a41240928658ed82341d10fcd5a372a5a417c060000000100000069030000000100000005000000222cfa4e8ed82341214de257372a5a41222cfa4e8ed82341d10fcd5a372a5a41240928658ed82341d10fcd5a372a5a41240928658ed82341214de257372a5a41222cfa4e8ed82341214de257372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (850,'os','dent','gauche','crâne','périnatal',X'00016a080000240928658ed8234163a75457372a5a41c57a52818ed82341d10fcd5a372a5a417c060000000100000069030000000100000005000000240928658ed8234131f98b58372a5a41240928658ed82341d10fcd5a372a5a41c57a52818ed82341d10fcd5a372a5a41c57a52818ed8234163a75457372a5a41240928658ed8234131f98b58372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (851,'os','dent','droit','crâne','périnatal',X'00016a080000c49dbd888dd823413242f754372a5a41a20274a48dd823416ef6e157372a5a417c060000000100000069030000000100000005000000a20274a48dd823416ef6e157372a5a41a20274a48dd823413242f754372a5a41c49dbd888dd823413242f754372a5a41c49dbd888dd823416ef6e157372a5a41a20274a48dd823416ef6e157372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (852,'os','dent','gauche','crâne','périnatal',X'00016a080000fe6ef0388ed82341214de257372a5a41222cfa4e8ed82341d10fcd5a372a5a417c060000000100000069030000000100000005000000fe6ef0388ed82341214de257372a5a41fe6ef0388ed82341d10fcd5a372a5a41222cfa4e8ed82341d10fcd5a372a5a41222cfa4e8ed82341214de257372a5a41fe6ef0388ed82341214de257372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (853,'os','dent','droit','crâne','périnatal',X'00016a0800007f672ac08dd823413242f754372a5a41ec3356dc8dd8234131f98b58372a5a417c060000000100000069030000000100000005000000ec3356dc8dd8234131f98b58372a5a41ec3356dc8dd823413242f754372a5a417f672ac08dd823413242f754372a5a417f672ac08dd8234163a75457372a5a41ec3356dc8dd8234131f98b58372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (854,'os','dent','droit','crâne','périnatal',X'00016a080000a20274a48dd823413242f754372a5a417f672ac08dd823416ef6e157372a5a417c0600000001000000690300000001000000050000007f672ac08dd823416ef6e157372a5a417f672ac08dd823413242f754372a5a41a20274a48dd823413242f754372a5a41a20274a48dd823416ef6e157372a5a417f672ac08dd823416ef6e157372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (855,'os','dent','droit','crâne','périnatal',X'00016a08000020f884f28dd823413242f754372a5a41ab418e088ed82341214de257372a5a417c060000000100000069030000000100000005000000ab418e088ed82341214de257372a5a41ab418e088ed823413242f754372a5a4120f884f28dd823413242f754372a5a4120f884f28dd82341214de257372a5a41ab418e088ed82341214de257372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (856,'os','dent','droit','crâne','périnatal',X'00016a080000ec3356dc8dd823413242f754372a5a4120f884f28dd82341214de257372a5a417c06000000010000006903000000010000000500000020f884f28dd82341214de257372a5a4120f884f28dd823413242f754372a5a41ec3356dc8dd823413242f754372a5a41ec3356dc8dd82341214de257372a5a4120f884f28dd82341214de257372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (857,'os','dent','droit','crâne','périnatal',X'00016a080000a20274a48dd823416ef6e157372a5a417f672ac08dd82341d10fcd5a372a5a417c0600000001000000690300000001000000050000007f672ac08dd823416ef6e157372a5a41a20274a48dd823416ef6e157372a5a41a20274a48dd82341d10fcd5a372a5a417f672ac08dd82341d10fcd5a372a5a417f672ac08dd823416ef6e157372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (858,'os','dent','droit','crâne','périnatal',X'00016a080000c49dbd888dd823416ef6e157372a5a41a20274a48dd82341d10fcd5a372a5a417c060000000100000069030000000100000005000000a20274a48dd823416ef6e157372a5a41c49dbd888dd823416ef6e157372a5a41c49dbd888dd82341d10fcd5a372a5a41a20274a48dd82341d10fcd5a372a5a41a20274a48dd823416ef6e157372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (859,'os','dent','droit','crâne','périnatal',X'00016a080000ec3356dc8dd82341214de257372a5a4120f884f28dd82341d10fcd5a372a5a417c06000000010000006903000000010000000500000020f884f28dd82341214de257372a5a41ec3356dc8dd82341214de257372a5a41ec3356dc8dd82341d10fcd5a372a5a4120f884f28dd82341d10fcd5a372a5a4120f884f28dd82341214de257372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (860,'os','dent','droit','crâne','périnatal',X'00016a0800007f672ac08dd8234163a75457372a5a41ec3356dc8dd82341d10fcd5a372a5a417c060000000100000069030000000100000005000000ec3356dc8dd8234131f98b58372a5a417f672ac08dd8234163a75457372a5a417f672ac08dd82341d10fcd5a372a5a41ec3356dc8dd82341d10fcd5a372a5a41ec3356dc8dd8234131f98b58372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (861,'os','dent','droit','crâne','périnatal',X'00016a08000020f884f28dd82341214de257372a5a41ab418e088ed82341d10fcd5a372a5a417c060000000100000069030000000100000005000000ab418e088ed82341214de257372a5a4120f884f28dd82341214de257372a5a4120f884f28dd82341d10fcd5a372a5a41ab418e088ed82341d10fcd5a372a5a41ab418e088ed82341214de257372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (862,'os','dent','gauche','crâne','périnatal',X'00016a080000a59d069d8ed823413242f754372a5a41ea8ebcb88ed823416ef6e157372a5a417c060000000100000069030000000100000005000000a59d069d8ed823416ef6e157372a5a41ea8ebcb88ed823416ef6e157372a5a41ea8ebcb88ed823413242f754372a5a41a59d069d8ed823413242f754372a5a41a59d069d8ed823416ef6e157372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (863,'os','phalange','gauche','membre supérieur','périnatal',X'00016a08000057da18d48ed82341bd1dc8fc362a5a41d4dae3dc8ed82341d8143fff362a5a417c06000000010000006903000000010000000900000030bb48db8ed8234104bb2fff362a5a4134528edc8ed82341d7e003ff362a5a414c4149db8ed823419d8e72fe362a5a41d4dae3dc8ed823419acae6fc362a5a41317360db8ed82341bd1dc8fc362a5a410b8a58d58ed82341fdd7cefc362a5a4157da18d48ed82341e89423fd362a5a41ba1b12d58ed82341d8143fff362a5a4130bb48db8ed8234104bb2fff362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (864,'os','phalange','gauche','membre supérieur','périnatal',X'00016a0800008efae6c78ed82341739052fd362a5a41a21aa7d08ed82341cd524eff362a5a417c06000000010000006903000000010000000a0000002c85dbce8ed82341cd524eff362a5a4148950ecf8ed8234103c3a0fe362a5a41a21aa7d08ed82341c2c705fe362a5a4143a769d08ed823419abdaffd362a5a410f742ece8ed82341eeed5dfd362a5a41a94b3aca8ed82341739052fd362a5a4187678fc88ed8234112de7bfd362a5a418efae6c78ed8234104fabffd362a5a4138f82ac88ed8234166184eff362a5a412c85dbce8ed82341cd524eff362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (865,'os','phalange','gauche','membre supérieur','périnatal',X'00016a080000bfee53f38ed8234186fa35fb362a5a41866445fb8ed82341ac0accfc362a5a417c060000000100000069030000000100000008000000f673d3fa8ed82341ac0accfc362a5a41866445fb8ed8234119136afb362a5a41155bf7f88ed8234189d538fb362a5a41f9b18df58ed8234186fa35fb362a5a41fe730bf48ed82341acd767fb362a5a41bfee53f38ed8234130f7b8fb362a5a41d828a8f38ed8234115a1bcfc362a5a41f673d3fa8ed82341ac0accfc362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (866,'os','phalange','gauche','membre supérieur','périnatal',X'00016a0800007be499e28ed823414586e9fa362a5a41e2908bea8ed82341a99d7ffc362a5a417c060000000100000069030000000100000008000000e5cc19ea8ed82341a99d7ffc362a5a41e2908bea8ed82341a3971dfb362a5a41d2903de88ed82341a75fecfa362a5a4103d4d3e48ed823414586e9fa362a5a41146b51e38ed82341225c1bfb362a5a417be499e28ed8234187786cfb362a5a41b781eee28ed823419e2570fc362a5a41e5cc19ea8ed82341a99d7ffc362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (867,'os','phalange','gauche','membre supérieur','périnatal',X'00016a080000ec538dd28ed82341861f12fb362a5a412a9ab3d98ed82341a99d7ffc362a5a417c0600000001000000690300000001000000080000001abb4cd98ed82341a99d7ffc362a5a412a9ab3d98ed82341eafd40fb362a5a412b69a0d78ed823418cae14fb362a5a41c4138ed48ed82341861f12fb362a5a41087832d38ed82341eefe3efb362a5a41ec538dd28ed82341360088fb362a5a41d83cd9d28ed82341bdae71fc362a5a411abb4cd98ed82341a99d7ffc362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (868,'os','phalange','gauche','membre supérieur','périnatal',X'00016a080000d48b44c78ed82341218791fb362a5a41530ab4cd8ed82341eb60dafc362a5a417c0600000001000000690300000001000000070000003ca257cd8ed82341eb60dafc362a5a41530ab4cd8ed823416cafbbfb362a5a414f14d6cb8ed82341e0cf93fb362a5a41fa4312c98ed82341218791fb362a5a41d48b44c78ed82341cf9ffbfb362a5a4141f988c78ed823415deccdfc362a5a413ca257cd8ed82341eb60dafc362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (869,'os','os nasal','gauche','crâne','périnatal',X'00016a08000085cabe2f8ed82341139fbb2c372a5a41863c3e358ed823415e85822e372a5a417c06000000010000006903000000010000000a0000008fd90e308ed82341075d122d372a5a41ea4b73308ed82341a45fc62d372a5a4185cabe2f8ed82341d9ad382e372a5a414e6688308ed823418204742e372a5a41fde5ae318ed823415e85822e372a5a41a1c7de338ed82341ae6e552e372a5a41863c3e358ed823412ee7052e372a5a4115c023358ed82341139fbb2c372a5a411d275b308ed823415bebc52c372a5a418fd90e308ed82341075d122d372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (870,'os','vomer','axial','crâne','périnatal',X'00016a0800000c7297288ed8234144157a26372a5a41fea8f4308ed823417233492c372a5a417c060000000100000069030000000100000012000000870dc62c8ed823414c38e926372a5a41f211e22b8ed823419a5dd626372a5a414efe182b8ed82341886b8026372a5a41c9e0332a8ed8234144157a26372a5a410c7297288ed82341d5c4f226372a5a41a284e3288ed823415a724028372a5a4164afdd298ed82341edb78828372a5a41c3911d2a8ed82341ca611829372a5a41d7779d288ed823410e3e632a372a5a41ffbdc42c8ed823417233492c372a5a4138a3ee308ed823410e3e632a372a5a4139176e2f8ed82341ca611829372a5a41b1c4ad2f8ed82341edb78828372a5a412423a8308ed823415a724028372a5a41fea8f4308ed82341d5c4f226372a5a41f682572f8ed8234144157a26372a5a41b7226c2e8ed82341f88c8026372a5a41870dc62c8ed823414c38e926372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (871,'os','maximillaire','gauche','crâne','périnatal',X'00016a0800007f7265368ed8234181025e28372a5a41b8d1ce6a8ed8234101cede2d372a5a417c06000000010000006903000000010000002800000098b47f3d8ed82341075d122d372a5a413377333c8ed823410a6bb02d372a5a410fdfa93c8ed8234101cede2d372a5a412a0e79438ed8234185e9c72d372a5a419ad230448ed8234151cff42c372a5a410c3e47478ed82341da464c2c372a5a4100fabe4c8ed82341bcf5f32b372a5a413c9720528ed823415b30f32b372a5a41c2881e568ed8234132d6632b372a5a412f0a7e598ed8234176222b2b372a5a4172f745618ed823410bf0312b372a5a41b8d1ce6a8ed823415f04a92b372a5a414beacd6a8ed8234155fb3d2b372a5a41700639688ed82341a3fab72a372a5a414615e8698ed823413574812a372a5a4185fb0c6a8ed823413790512a372a5a4118bbe9678ed82341ff1cf929372a5a41c9b422638ed8234198e1222a372a5a413345e45e8ed82341df84fb29372a5a417e52635b8ed823415c5b8329372a5a4126dec8598ed82341d6fbe828372a5a41a40ff5558ed8234191aa9928372a5a41d19701538ed823416a709728372a5a41a6adcf518ed82341de3dda28372a5a410d48b84f8ed823415f1d7128372a5a41550ac0498ed8234142045e28372a5a41971f8d488ed82341b4dca028372a5a414bf375468ed8234181025e28372a5a41128920388ed8234161b16728372a5a41c8dcf9388ed82341553ade28372a5a417f7265368ed823411ff1c329372a5a415fe3a4368ed8234133210b2a372a5a4195418d388ed823416333252a372a5a4199db23408ed82341cfec162a372a5a41dbb6d4418ed82341a11e3a2a372a5a41f5ff69428ed82341e5a06d2a372a5a4158794a408ed823416750542b372a5a41cc8fd93e8ed82341d0be952b372a5a4198b47f3d8ed8234162b69d2b372a5a4198b47f3d8ed82341075d122d372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (873,'os','clavicule','gauche','ceinture scapulaire','périnatal',X'00016a080000479000a88ed82341f4b5fa24372a5a414b98b1f18ed82341feb80c27372a5a417c06000000010000006903000000010000001b0000000323b5dc8ed82341605e0d26372a5a4131d41de68ed823418c454d26372a5a41e5f436ec8ed82341164ef226372a5a41717788ef8ed82341e068b626372a5a414b98b1f18ed8234164eb2126372a5a41713131f18ed823412ca2e825372a5a41dd8407ed8ed823412623a625372a5a4192dd6de88ed823411533a525372a5a4163be96e48ed8234139a16425372a5a41092213e08ed82341fae64c25372a5a411911eed88ed823415f796925372a5a41057b02ca8ed823413a31ff25372a5a41bb80c6c18ed82341813e1726372a5a415253bbba8ed823410a470a26372a5a41990b16b48ed823417f81dd25372a5a415c22c7b08ed823416cb33a25372a5a41ebe6a3ad8ed82341f4b5fa24372a5a41146b52ac8ed82341f1d80925372a5a41f39e5caa8ed82341008c5e25372a5a41479000a88ed8234173341b26372a5a41ab8544a98ed82341bf055e26372a5a41c7e4b9b08ed8234157dc6226372a5a418561e3b98ed823410ca7dd26372a5a4199f6c8c28ed82341feb80c27372a5a413f41f2c78ed82341e236f726372a5a41de2386d88ed82341f92c2826372a5a410323b5dc8ed82341605e0d26372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (874,'os','scapula','gauche','ceinture scapulaire','périnatal',X'00016a080000d8ae23aa8ed82341e4323f1c372a5a4136ac6ddb8ed823416dbef923372a5a417c06000000010000006903000000010000001f0000008ea6e3b28ed82341134cc623372a5a41ac2142b48ed8234118a5f723372a5a4161f186b68ed823416dbef923372a5a416cf67bc18ed82341a0f04f23372a5a415d9156c68ed82341d7b32123372a5a4108e8dbcd8ed823413ec62223372a5a41d9a16dd78ed8234136289323372a5a412e209cd98ed823411cb48323372a5a418c89ffda8ed8234137884523372a5a4136ac6ddb8ed823415cc4a322372a5a41a57686da8ed823411b9d4b22372a5a41bd431fd98ed82341a2e84322372a5a4110125fd58ed823414d5a7022372a5a41319d41d28ed8234146104822372a5a41620d91d48ed82341b9535621372a5a41bb8267d48ed82341c6768d20372a5a41c8d121d38ed823410ee34d20372a5a41fbf349ce8ed823414379ee1f372a5a415e03cfcb8ed8234193d67e1f372a5a41279dfdc78ed8234166c6de1d372a5a41c2ad4ac68ed823414fbe981c372a5a4107b1ebc38ed82341c2d0431c372a5a418fa0a7c18ed82341e4323f1c372a5a414d8a61be8ed82341614c641c372a5a4194a8a4b58ed8234175f52b1d372a5a41a67d34b08ed82341c313031e372a5a419397faab8ed82341cb292e1f372a5a41d8ae23aa8ed82341c3ff6120372a5a41ee8735aa8ed8234168a0b221372a5a4151966cad8ed823413b13cd22372a5a418ea6e3b28ed82341134cc623372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (875,'os','humérus','gauche','membre supérieur','périnatal',X'00016a08000064594bd68ed823412036eb12372a5a413521e4ef8ed82341f7861f20372a5a417c06000000010000006903000000010000001d000000ebba51da8ed823413bd0a81e372a5a41b4733fd88ed8234165370a1f372a5a4137dfa6d78ed82341a337671f372a5a41c915add88ed823416991b81f372a5a418b3ae7da8ed82341d90df21f372a5a4124f4b0de8ed8234197811c20372a5a41b23dd2e28ed82341f7861f20372a5a41903486e68ed82341b653f51f372a5a41ac8ea9e88ed82341db1daf1f372a5a41faecd8e98ed82341fe9ff01e372a5a41917aafe78ed8234100e2d21d372a5a413bafafe68ed82341a661bc1c372a5a413fd03ce58ed823414f9bdf16372a5a41d06174e68ed82341dc1fd915372a5a4117123fe88ed8234151002d15372a5a4190d247ea8ed82341fd8ec014372a5a413266caee8ed82341bc693014372a5a413521e4ef8ed823417b7bdb13372a5a418a6ae7ed8ed82341988e8513372a5a41771e68ea8ed82341d7646313372a5a416cd1bae58ed823410fa85f13372a5a4148a033e38ed8234178ae0413372a5a4160321fe18ed823412036eb12372a5a417ce648de8ed82341f8d5fb12372a5a4164594bd68ed82341d9289013372a5a41ee2bb8da8ed82341d94f9a15372a5a414196cfdb8ed823419a1d9d16372a5a4129085bda8ed82341d152331a372a5a41ebba51da8ed823413bd0a81e372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (876,'os','fémur','gauche','membre inférieur','périnatal',X'00016a080000dbb02f568ed82341c33d7100372a5a41429588778ed8234156519c0e372a5a417c06000000010000006903000000010000001d0000005b46c55a8ed82341659a190d372a5a4154fd02588ed823416fcd690d372a5a41947911588ed823411f67d70d372a5a41918e9f5b8ed82341c58a560e372a5a41890dbd608ed8234156519c0e372a5a41adcc3c658ed82341fba1980e372a5a414c2cde698ed82341c579680e372a5a410e3df2708ed82341cda9e20d372a5a41649f2f728ed8234115be9c0d372a5a41b69bf7718ed82341070b2a0d372a5a41b466dd6f8ed823418371730c372a5a418157406f8ed823411ae4b00b372a5a41186fb46e8ed8234140f15d06372a5a41a8033d718ed823417d23a402372a5a412a9023738ed8234172dcdf01372a5a41429588778ed8234174d30e01372a5a412802f5768ed823419684ca00372a5a417d6c69748ed8234106e48d00372a5a4196ae0f5e8ed82341c33d7100372a5a41ec3c93588ed82341bfe0ac00372a5a41dbb02f568ed82341bcc4ff00372a5a4173ab61568ed82341565e5001372a5a412398855b8ed823418b914802372a5a418bbafa5d8ed823412c452903372a5a41aa7041628ed823417cc01308372a5a41f65054628ed8234151579d09372a5a412e2ef0608ed82341c5901e0b372a5a41a80c915e8ed823417ad62a0c372a5a415b46c55a8ed82341659a190d372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (877,'os','patella','gauche','membre inférieur','périnatal',X'00016a080000b349b2618ed823416cb20efe362a5a418e00c96e8ed82341b9d921ff362a5a417c06000000010000006903000000010000000b000000d0a8cf688ed823415a2510fe362a5a419b8cdf648ed823416cb20efe362a5a415eb6bf628ed82341be163cfe362a5a41b349b2618ed8234165fec9fe362a5a413d6605638ed82341339a21ff362a5a41a06ae5678ed82341b9d921ff362a5a4177d2f66b8ed82341e67bedfe362a5a410b94446e8ed823419b0db2fe362a5a418e00c96e8ed82341bda776fe362a5a41adc4eb6d8ed8234182a44bfe362a5a41d0a8cf688ed823415a2510fe362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (878,'os','fibula','gauche','membre inférieur','périnatal',X'00016a080000fee0ee6c8ed8234184c883f1362a5a41b0d6e67c8ed82341c2e1d3fc362a5a417c060000000100000069030000000100000010000000dd6b29748ed82341f40ec8fb362a5a416a13dc728ed82341b78562fc362a5a41cd63b3748ed82341e43ebffc362a5a4170c7ef788ed82341c2e1d3fc362a5a41b0d6e67c8ed82341acfc86fc362a5a41bfd1797b8ed823412b453bfb362a5a41050ebf7a8ed823410e8c03f8362a5a41afdddb7a8ed82341f59210f2362a5a41210e407a8ed823410da8b7f1362a5a4135f7fa788ed82341abb393f1362a5a41d817a3738ed82341b117a9f1362a5a41db9a266f8ed8234184c883f1362a5a41fe67716d8ed8234105bea3f1362a5a41fee0ee6c8ed823418fd10cf2362a5a4151d1d9718ed823419587baf5362a5a41dd6b29748ed82341f40ec8fb362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (879,'os','phalange','droit','membre supérieur','périnatal',X'00016a080000666d0b6e8dd823414586e9fa362a5a41b346fd758dd82341a99d7ffc362a5a417c06000000010000006903000000010000000800000016567d6e8dd82341a99d7ffc362a5a4109dba8758dd823419e2570fc362a5a41b346fd758dd8234187786cfb362a5a41c7c045758dd82341225c1bfb362a5a41526dc3738dd823414586e9fa362a5a41419459708dd82341a75fecfa362a5a41666d0b6e8dd82341a3971dfb362a5a4116567d6e8dd82341a99d7ffc362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (880,'os','phalange','droit','membre supérieur','périnatal',X'00016a080000054fe37e8dd82341861f12fb362a5a41dbc609868dd82341a99d7ffc362a5a417c0600000001000000690300000001000000080000007cba497f8dd82341a99d7ffc362a5a415facbd858dd82341bdae71fc362a5a41dbc609868dd82341360088fb362a5a4113a264858dd82341eefe3efb362a5a41ddf008848dd82341861f12fb362a5a410380f6808dd823418cae14fb362a5a41054fe37e8dd82341eafd40fb362a5a417cba497f8dd82341a99d7ffc362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (881,'os','phalange','droit','membre supérieur','périnatal',X'00016a080000dbdee28a8dd82341218791fb362a5a41c12b52918dd82341eb60dafc362a5a417c060000000100000069030000000100000007000000f2463f8b8dd82341eb60dafc362a5a41e5ef0d918dd823415deccdfc362a5a41c12b52918dd82341cf9ffbfb362a5a41c289848f8dd82341218791fb362a5a41e0d4c08c8dd82341e0cf93fb362a5a41dbdee28a8dd823416cafbbfb362a5a41f2463f8b8dd82341eb60dafc362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (882,'os','métacarpien','gauche','membre supérieur','périnatal',X'00016a080000ff0bbdfa8ed82341a6c13001372a5a4177609e048fd8234115cbaa03372a5a417c06000000010000006903000000010000000900000019d34dfb8ed82341b47f9b03372a5a4197cdfe018fd8234115cbaa03372a5a415edae2028fd82341085d7e02372a5a4177609e048fd82341a93ed301372a5a4182af6f028fd82341e8306301372a5a412700a1ff8ed82341a6c13001372a5a41b04789fc8ed8234122294201372a5a41ff0bbdfa8ed8234122738f01372a5a4119d34dfb8ed82341b47f9b03372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (883,'os','métacarpien','gauche','membre supérieur','périnatal',X'00016a0800004995eded8ed82341f663e8ff362a5a419422fbf88ed82341ebe77c03372a5a417c06000000010000006903000000010000000a0000005a869df48ed82341ebe77c03372a5a4178089cf68ed823415e889e01372a5a419422fbf88ed8234179874a00372a5a4193fd56f78ed823410bf3feff362a5a41463d1ff28ed82341f663e8ff362a5a41713904f08ed82341fa9e0a00372a5a41494214ef8ed8234196674f00372a5a41f7a42af08ed823411e607901372a5a414995eded8ed82341e99e6d03372a5a415a869df48ed82341ebe77c03372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (884,'os','métacarpien','gauche','membre supérieur','périnatal',X'00016a0800002a6dc3e18ed823418704c2ff362a5a414f12f8ea8ed823419f4f5e03372a5a417c06000000010000006903000000010000000a000000136773e28ed823413e044f03372a5a417650b5e78ed823419f4f5e03372a5a41562500e98ed823419fce7f01372a5a414f12f8ea8ed82341a3789c00372a5a414ba33cea8ed8234170272900372a5a416a43afe58ed823418704c2ff362a5a412f2668e38ed82341cca9e3ff362a5a412a6dc3e18ed8234174f74900372a5a419b7b0ce38ed823418d2c2901372a5a41136773e28ed823413e044f03372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (885,'os','métacarpien','gauche','membre supérieur','périnatal',X'00016a08000028aa94d48ed823413c64d6ff362a5a41caf131dd8ed8234159b83f03372a5a417c060000000100000069030000000100000006000000cc0381d68ed8234159b83f03372a5a41118b3ddc8ed82341da7b3f03372a5a41caf131dd8ed823410786f7ff362a5a4195ebaad58ed823413c64d6ff362a5a4128aa94d48ed8234146fbe5ff362a5a41cc0381d68ed8234159b83f03372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (886,'os','métacarpien','gauche','membre supérieur','périnatal',X'00016a0800002bfc52c88ed82341c5cf0500372a5a418e4a89d18ed8234120d03e03372a5a417c06000000010000006903000000010000000900000077d43fd18ed82341e87a3003372a5a418e4a89d18ed823418fdd7e00372a5a41890296cf8ed82341f9bf1c00372a5a414b5b88cb8ed82341c5cf0500372a5a41abd342c98ed8234197b83900372a5a412bfc52c88ed8234110038f00372a5a419e0714ca8ed823416c201901372a5a417aeffccb8ed8234120d03e03372a5a4177d43fd18ed82341e87a3003372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (887,'os','phalange','gauche','membre supérieur','périnatal',X'00016a08000065f59aff8ed82341e0546aff362a5a4199968d098fd823413870bd00372a5a417c0600000001000000690300000001000000090000006b2d57058fd823413870bd00372a5a41609f81088fd8234124f52900372a5a4199968d098fd82341e37bcbff362a5a412bd6fc088fd823419c178eff362a5a41f0d55b068fd82341e0546aff362a5a4108fdbf028fd82341f1079eff362a5a41dc7918028fd823418e800f00372a5a4165f59aff8ed82341fabe9e00372a5a416b2d57058fd823413870bd00372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (888,'os','phalange','gauche','membre supérieur','périnatal',X'00016a080000f340ca028fd82341ed8d44fd362a5a415816f80a8fd82341755ce3fe362a5a417c06000000010000006903000000010000000a000000cee41e0a8fd82341755ce3fe362a5a415816f80a8fd82341becac7fe362a5a412ff51e0a8fd82341ce513cfe362a5a419a33990a8fd82341022fa2fd362a5a4191b011098fd82341631c53fd362a5a4131c331078fd82341ed8d44fd362a5a41bc936f038fd823411be3a1fd362a5a41ebc0f0038fd82341d5720afe362a5a41f340ca028fd82341838dc7fe362a5a41cee41e0a8fd82341755ce3fe362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (889,'os','phalange','gauche','membre supérieur','périnatal',X'00016a0800003e2c64e18ed823415d6342f9362a5a4158d206e98ed82341e4b8b4fa362a5a417c06000000010000006903000000010000000a000000e50d3ce88ed82341e4b8b4fa362a5a4158d206e98ed8234138239cfa362a5a412f1d3ce88ed82341459d1ffa362a5a418bb0aee88ed8234181f895f9362a5a4175d240e78ed82341f7614ff9362a5a41a39c80e58ed823415d6342f9362a5a41116ffee18ed82341bcb495f9362a5a41401b77e28ed823419420f3f9362a5a413e2c64e18ed8234120fe9bfa362a5a41e50d3ce88ed82341e4b8b4fa362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (890,'os','phalange','gauche','membre supérieur','périnatal',X'00016a080000a638b9d08ed82341102d72f9362a5a416c9e5bd88ed823413241b3fa362a5a417c06000000010000006903000000010000000a000000f9d990d78ed823413241b3fa362a5a416c9e5bd88ed82341e5c69dfa362a5a4143e990d78ed8234181f930fa362a5a41a07c03d88ed823412dbcb8f9362a5a41a8d395d68ed8234125077bf9362a5a41a0097cd48ed82341102d72f9362a5a41bfae53d18ed82341f380b8f9362a5a41ed5accd18ed82341931f0afa362a5a41a638b9d08ed823410eac9dfa362a5a41f9d990d78ed823413241b3fa362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (891,'os','phalange','gauche','membre supérieur','périnatal',X'00016a08000018e903f58ed82341928055f9362a5a416a61a6fc8ed82341b49496fa362a5a417c06000000010000006903000000010000000a000000f79cdbfb8ed82341b49496fa362a5a416a61a6fc8ed82341681a81fa362a5a4141acdbfb8ed82341034d14fa362a5a4114cc4dfc8ed82341af0f9cf9362a5a412b58e0fa8ed82341a75a5ef9362a5a4182b6c6f88ed82341928055f9362a5a41bc719ef58ed8234175d49bf9362a5a41923c17f68ed82341a96cedf9362a5a4118e903f58ed82341830381fa362a5a41f79cdbfb8ed82341b49496fa362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (892,'os','phalange','gauche','membre supérieur','périnatal',X'00016a080000d91423c58ed8234105350efa362a5a411cbd44cb8ed823411bae42fb362a5a417c060000000100000069030000000100000009000000400ba2ca8ed823411bae42fb362a5a411cbd44cb8ed8234191342efb362a5a4176a9fdca8ed82341bfd753fa362a5a4149fcd7c98ed82341880819fa362a5a41f02170c88ed8234105350efa362a5a41f2e49ec58ed823414b9f53fa362a5a4114ebffc58ed82341c36fa1fa362a5a41d91423c58ed82341a51a2efb362a5a41400ba2ca8ed823411bae42fb362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (893,'os','phalange','gauche','membre supérieur','périnatal',X'00016a080000c48c0bf08ed823412f4d40fd362a5a41f4d88afa8ed82341e45a93ff362a5a417c06000000010000006903000000010000000d0000007c2474f98ed82341e45a93ff362a5a41f4d88afa8ed8234190d76bff362a5a41803974f98ed823410db2a3fe362a5a41b53311fa8ed82341779cc6fd362a5a41968d1af88ed82341bb2e55fd362a5a41a1a7b2f58ed823412f4d40fd362a5a41192267f38ed823417e1369fd362a5a41a842e0f08ed82341942fc6fd362a5a41a2b985f18ed82341de485cfe362a5a41c48c0bf08ed823412f9c6bff362a5a419ffdc8f08ed82341e97284ff362a5a41c3e21ff48ed82341168f6eff362a5a417c2474f98ed82341e45a93ff362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (894,'os','phalange','gauche','membre supérieur','périnatal',X'00016a0800004dcea1e28ed82341fbaadffc362a5a413ead8bec8ed8234124e151ff362a5a417c06000000010000006903000000010000000d000000546684eb8ed8234124e151ff362a5a413ead8bec8ed82341814828ff362a5a412e7a84eb8ed82341f6c655fe362a5a4154e218ec8ed8234195096dfd362a5a41ba5c3eea8ed8234183a5f5fc362a5a4130a5f8e78ed82341fbaadffc362a5a41ad95cde58ed82341f7950afd362a5a4127566ae38ed82341f8966cfd362a5a41fc2d07e48ed82341cc7a0afe362a5a414dcea1e28ed82341860628ff362a5a418fc954e38ed82341e13242ff362a5a41deea7be68ed8234112242bff362a5a41546684eb8ed8234124e151ff362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (895,'os','métacarpien','droit','membre supérieur','périnatal',X'00016a080000d3e9f8538dd82341a6c13001372a5a413c97d95d8dd8234115cbaa03372a5a417c0600000001000000690300000001000000090000007ca2485d8dd82341b47f9b03372a5a413c97d95d8dd8234122738f01372a5a4199550d5c8dd8234122294201372a5a4151eff5588dd82341a6c13001372a5a41359927568dd82341e8306301372a5a41d3e9f8538dd82341a93ed301372a5a4176fdb3558dd82341085d7e02372a5a41931b98568dd8234115cbaa03372a5a417ca2485d8dd82341b47f9b03372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (896,'os','métacarpien','droit','membre supérieur','périnatal',X'00016a080000c3989b5f8dd82341f663e8ff362a5a41f153a96a8dd82341ebe77c03372a5a417c06000000010000006903000000010000000a000000a19cf9638dd82341ebe77c03372a5a41f153a96a8dd82341e99e6d03372a5a41c65e6c688dd823411e607901372a5a416ab582698dd8234196674f00372a5a4152c692688dd82341fa9e0a00372a5a41e7dd77668dd82341f663e8ff362a5a418cd23f618dd823410bf3feff362a5a41c3989b5f8dd8234179874a00372a5a411fbcfa618dd823415e889e01372a5a41a19cf9638dd82341ebe77c03372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (897,'os','métacarpien','droit','membre supérieur','périnatal',X'00016a080000b9989e6d8dd823418704c2ff362a5a416089d3768dd823419f4f5e03372a5a417c06000000010000006903000000010000000a000000830e23768dd823413e044f03372a5a41c5b58a758dd823418d2c2901372a5a416089d3768dd8234174f74900372a5a41b71f2f758dd82341cca9e3ff362a5a4189a4e7728dd823418704c2ff362a5a4161725a6e8dd8234170272900372a5a41b9989e6d8dd82341a3789c00372a5a4184db966f8dd823419fce7f01372a5a411f25e1708dd823419f4f5e03372a5a41830e23768dd823413e044f03372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (898,'os','métacarpien','droit','membre supérieur','périnatal',X'00016a08000064f7647b8dd823413c64d6ff362a5a41c2ce01848dd8234159b83f03372a5a417c06000000010000006903000000010000000600000062e515828dd8234159b83f03372a5a41c2ce01848dd8234146fbe5ff362a5a4166cbeb828dd823413c64d6ff362a5a4164f7647b8dd823410786f7ff362a5a411d5e597c8dd82341da7b3f03372a5a4162e515828dd8234159b83f03372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (899,'os','métacarpien','droit','membre supérieur','périnatal',X'00016a0800003c4f0d878dd82341c5cf0500372a5a4149ab43908dd8234120d03e03372a5a417c060000000100000069030000000100000009000000508857878dd82341e87a3003372a5a4184f9998c8dd8234120d03e03372a5a41fc6d828e8dd823416c201901372a5a4149ab43908dd8234110038f00372a5a41ddc9538f8dd8234197b83900372a5a419f1a0e8d8dd82341c5cf0500372a5a412fa400898dd82341f9bf1c00372a5a413c4f0d878dd823418fdd7e00372a5a41508857878dd82341e87a3003372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (900,'os','phalange','droit','membre supérieur','périnatal',X'00016a08000050a0094f8dd82341e0546aff362a5a417846fb588dd823413870bd00372a5a417c0600000001000000690300000001000000090000002b483f538dd823413870bd00372a5a417846fb588dd82341fabe9e00372a5a4159557e568dd823418e800f00372a5a4167aad6558dd82341f1079eff362a5a41ffcd3a528dd82341e0546aff362a5a41e95f9a4f8dd823419c178eff362a5a4150a0094f8dd82341e37bcbff362a5a41055915508dd8234124f52900372a5a412b483f538dd823413870bd00372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (901,'os','phalange','droit','membre supérieur','périnatal',X'00016a080000d6d29e4d8dd82341ed8d44fd362a5a41f5c8cc558dd82341755ce3fe362a5a417c06000000010000006903000000010000000a0000006004784e8dd82341755ce3fe362a5a41f5c8cc558dd82341838dc7fe362a5a415524a6548dd82341d5720afe362a5a41508f27558dd823411be3a1fd362a5a418d6b65518dd82341ed8d44fd362a5a418268854f8dd82341631c53fd362a5a4194b5fd4d8dd82341022fa2fd362a5a4100f4774e8dd82341ce513cfe362a5a41d6d29e4d8dd82341becac7fe362a5a416004784e8dd82341755ce3fe362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (902,'os','phalange','droit','membre supérieur','périnatal',X'00016a0800007c30906f8dd823415d6342f9362a5a4136f032778dd82341e4b8b4fa362a5a417c06000000010000006903000000010000000a0000004adb5a708dd82341e4b8b4fa362a5a4136f032778dd8234120fe9bfa362a5a41efcd1f768dd823419420f3f9362a5a411d7a98768dd82341bcb495f9362a5a418d6716738dd823415d6342f9362a5a41345556718dd82341f7614ff9362a5a412dace86f8dd8234181f895f9362a5a4101cc5a708dd82341459d1ffa362a5a417c30906f8dd8234138239cfa362a5a414adb5a708dd82341e4b8b4fa362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (903,'os','phalange','droit','membre supérieur','périnatal',X'00016a080000c24a3b808dd82341102d72f9362a5a41437ddd878dd823413241b3fa362a5a417c06000000010000006903000000010000000a000000350f06818dd823413241b3fa362a5a41437ddd878dd823410eac9dfa362a5a41a0c1ca868dd82341931f0afa362a5a41703a43878dd82341f380b8f9362a5a418edf1a848dd82341102d72f9362a5a41871501828dd8234125077bf9362a5a418f6c93808dd823412dbcb8f9362a5a41ebff05818dd8234181f930fa362a5a41c24a3b808dd82341e5c69dfa362a5a41350f06818dd823413241b3fa362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (904,'os','phalange','droit','membre supérieur','périnatal',X'00016a080000d12df05b8dd82341928055f9362a5a41b50d93638dd82341b49496fa362a5a417c06000000010000006903000000010000000a0000009fd8ba5c8dd82341b49496fa362a5a41b50d93638dd82341830381fa362a5a4147f47f628dd82341a96cedf9362a5a417277f8628dd8234175d49bf9362a5a41901cd05f8dd82341928055f9362a5a418952b65d8dd82341a75a5ef9362a5a4182a9485c8dd82341af0f9cf9362a5a4156c9ba5c8dd82341034d14fa362a5a41d12df05b8dd82341681a81fa362a5a419fd8ba5c8dd82341b49496fa362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (905,'os','phalange','droit','membre supérieur','périnatal',X'00016a080000c7f8518d8dd8234105350efa362a5a4135d373938dd823411bae42fb362a5a417c060000000100000069030000000100000009000000efddf48d8dd823411bae42fb362a5a4135d373938dd82341a51a2efb362a5a41d21297928dd82341c36fa1fa362a5a413d04f8928dd823414b9f53fa362a5a413dac26908dd8234105350efa362a5a416aaebe8e8dd82341880819fa362a5a412ecc988d8dd82341bfd753fa362a5a41c7f8518d8dd8234191342efb362a5a41efddf48d8dd823411bae42fb362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (906,'os','phalange','droit','membre supérieur','périnatal',X'00016a080000e0290c5e8dd823412f4d40fd362a5a416b328b688dd82341e45a93ff362a5a417c06000000010000006903000000010000000d000000b3c4225f8dd82341e45a93ff362a5a41ad1f77648dd82341168f6eff362a5a4127dacd678dd82341e97284ff362a5a416b328b688dd823412f9c6bff362a5a41cc4111678dd82341de485cfe362a5a410e1ab7678dd82341942fc6fd362a5a41e52430658dd823417e1369fd362a5a41628ee4628dd823412f4d40fd362a5a419e9a7c608dd82341bb2e55fd362a5a413fef855e8dd82341779cc6fd362a5a41b1af225f8dd823410db2a3fe362a5a41e0290c5e8dd8234190d76bff362a5a41b3c4225f8dd82341e45a93ff362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (907,'os','phalange','droit','membre supérieur','périnatal',X'00016a080000638f0b6c8dd82341fbaadffc362a5a4157b4f4758dd8234124e151ff362a5a417c06000000010000006903000000010000000d000000a7bc126d8dd8234124e151ff362a5a4130d71a728dd8234112242bff362a5a4121e241758dd82341e13242ff362a5a4157b4f4758dd82341860628ff362a5a4132bb8f748dd82341cc7a0afe362a5a412a932c758dd82341f8966cfd362a5a41e27ac9728dd82341f7950afd362a5a4107849e708dd82341fbaadffc362a5a415cd6586e8dd8234183a5f5fc362a5a41a7407e6c8dd8234195096dfd362a5a41cfa8126d8dd82341f6c655fe362a5a41638f0b6c8dd82341814828ff362a5a41a7bc126d8dd8234124e151ff362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (908,'os','phalange','droit','membre supérieur','périnatal',X'00016a08000079dfb27b8dd82341bd1dc8fc362a5a41fa247e848dd82341d8143fff362a5a417c060000000100000069030000000100000009000000ff2d4e7d8dd8234104bb2fff362a5a41df5984838dd82341d8143fff362a5a41fa247e848dd82341e89423fd362a5a4193823e838dd82341fdd7cefc362a5a41ee4a367d8dd82341bd1dc8fc362a5a4179dfb27b8dd823419acae6fc362a5a41e3a74d7d8dd823419d8e72fe362a5a41af63087c8dd82341d7e003ff362a5a41ff2d4e7d8dd8234104bb2fff362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (909,'os','phalange','droit','membre supérieur','périnatal',X'00016a0800005d1af0878dd82341739052fd362a5a41c240b0908dd82341cd524eff362a5a417c06000000010000006903000000010000000a00000069f0ba898dd82341cd524eff362a5a418f646c908dd8234166184eff362a5a41c240b0908dd8234104fabffd362a5a4161c307908dd8234112de7bfd362a5a4137e45c8e8dd82341739052fd362a5a41aee8688a8dd82341eeed5dfd362a5a41a2ac2d888dd823419abdaffd362a5a415d1af0878dd82341c2c705fe362a5a415ea388898dd8234103c3a0fe362a5a4169f0ba898dd82341cd524eff362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (910,'os','phalange','droit','membre supérieur','périnatal',X'00016a0800001937515d8dd8234186fa35fb362a5a4171e542658dd82341ac0accfc362a5a417c0600000001000000690300000001000000080000006c3bc35d8dd82341ac0accfc362a5a418e86ee648dd8234115a1bcfc362a5a4171e542658dd8234130f7b8fb362a5a41006c8b648dd82341acd767fb362a5a41ae3509638dd8234186fa35fb362a5a41ad769f5f8dd8234189d538fb362a5a411937515d8dd8234119136afb362a5a416c3bc35d8dd82341ac0accfc362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (911,'os','os pariétal','droit','crâne','périnatal',X'00016a0800005895386c8dd82341ab907c3f372a5a416b2708f18dd823410f73c350372a5a417c06000000010000006903000000010000002b000000f7fb18e28dd8234148ca414d372a5a41ba8554eb8dd8234195979849372a5a410855a3ed8dd8234184374d47372a5a416b2708f18dd823413daa2946372a5a41528fbaeb8dd823413e0e6a45372a5a4166cd2be98dd823411979ca44372a5a4120d2d2e48dd82341bdbb9044372a5a416074f1e28dd8234184c3fd43372a5a4127fb24e18dd8234170d3bd43372a5a415aadc8db8dd8234167d27243372a5a41d30babd88dd823413c00fa42372a5a41825678d58dd8234104cb7a43372a5a41b0dea1d28dd82341e0b18143372a5a41bae0abbf8dd82341b0ec1142372a5a414ea99db78dd82341d3d2c640372a5a41340cc6b38dd82341e28c5640372a5a4114e7a4b08dd82341e07e3540372a5a411ec85fa98dd8234199e72240372a5a41f9a0aea18dd82341eef7a13f372a5a41be3dbd9d8dd82341ab907c3f372a5a4166be9c998dd82341527fa43f372a5a41822038958dd82341f08c4840372a5a411065dd8d8dd82341c2cacb40372a5a415908b2798dd82341fb8ef842372a5a41a1fd97758dd823418e4f4044372a5a41b07e976e8dd823418ef13945372a5a41d950ec6c8dd82341ba029b45372a5a415895386c8dd82341a1243b46372a5a41c0732c6d8dd82341d0811347372a5a4168de69738dd82341def04f49372a5a4107c2507b8dd823416948514b372a5a4126f33c848dd8234148c9e34c372a5a41bea5148f8dd82341112f344e372a5a41193e0d978dd82341c6b9df4e372a5a41d837faa28dd823418f13964f372a5a419b0890b88dd82341a7aa9f50372a5a41041faac08dd823410f73c350372a5a41ec703fd28dd823417fbe7250372a5a41181f60dd8dd8234135257a4f372a5a419a341ade8dd823410c6f604f372a5a410fe443df8dd82341888e584e372a5a4148958ade8dd823412da1984d372a5a41f7fb18e28dd8234148ca414d372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (912,'os','os pariétal','gauche','crâne','périnatal',X'00016a08000079cd2c5a8ed82341ab907c3f372a5a41b58afcde8ed823410f73c350372a5a417c06000000010000006903000000010000002b000000866c1c698ed8234148ca414d372a5a418360aa6c8ed823412da1984d372a5a41d510f16b8ed82341888e584e372a5a41d2141b6d8ed823410c6f604f372a5a418816d56d8ed8234135257a4f372a5a4187a9f5788ed823417fbe7250372a5a415ee28a8a8ed823410f73c350372a5a416ceca4928ed82341a7aa9f50372a5a41b7fb3aa88ed823418f13964f372a5a41d8d727b48ed82341c6b9df4e372a5a415dad20bc8ed82341112f344e372a5a41753ff8c68ed8234148c9e34c372a5a41be6be4cf8ed823416948514b372a5a418524cbd78ed82341def04f49372a5a4148a708de8ed82341d0811347372a5a41b58afcde8ed82341a1243b46372a5a417fc548de8ed82341ba029b45372a5a4147859ddc8ed823418ef13945372a5a4143f79cd58ed823418e4f4044372a5a41e03e83d18ed82341fb8ef842372a5a417d0158bd8ed82341c2cacb40372a5a417019fdb58ed82341f08c4840372a5a41307998b18ed82341527fa43f372a5a4171f077ad8ed82341ab907c3f372a5a41f37186a98ed82341eef7a13f372a5a410ff1d4a18ed8234199e72240372a5a41363e909a8ed82341e07e3540372a5a4126f16e978ed82341e28c5640372a5a41964b97938ed82341d3d2c640372a5a41c606898b8ed82341b0ec1142372a5a41556e93788ed82341e0b18143372a5a413dedbc758ed8234104cb7a43372a5a41b0b589728ed823413c00fa42372a5a41c0466c6f8ed8234167d27243372a5a41c242106a8ed8234170d3bd43372a5a4170aa43688ed8234184c3fd43372a5a41d89b62668ed82341bdbb9044372a5a419d8f09628ed823411979ca44372a5a4125d77a5f8ed823413e0e6a45372a5a4179cd2c5a8ed823413daa2946372a5a4179d5915d8ed8234184374d47372a5a41c3e2e05f8ed8234195979849372a5a41866c1c698ed8234148ca414d372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (913,'os','os nasal','droit','crâne','périnatal',X'00016a08000018594d248ed82341139fbb2c372a5a41bea3cc298ed823415e85822e372a5a417c06000000010000006903000000010000000a000000e6cd7c298ed82341075d122d372a5a41588030298ed823415bebc52c372a5a4161e767248ed82341139fbb2c372a5a4118594d248ed823412ee7052e372a5a41c197ac258ed82341ae6e552e372a5a41b670dc278ed823415e85822e372a5a41210503298ed823418204742e372a5a41bea3cc298ed82341d9ad382e372a5a41118e18298ed82341a45fc62d372a5a41e6cd7c298ed82341075d122d372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (914,'os','maxillaire','droit','crâne','périnatal',X'00016a0800009f94bcee8dd8234181025e28372a5a414bd525238ed8234101cede2d372a5a417c060000000100000069030000000100000028000000447f0b1c8ed82341075d122d372a5a41447f0b1c8ed8234162b69d2b372a5a417d0fb21a8ed82341d0be952b372a5a41f24d41198ed823416750542b372a5a41878921178ed82341e5a06d2a372a5a411cd3b6178ed82341a11e3a2a372a5a4165c967198ed82341cfec162a372a5a4120acfe208ed823416333252a372a5a419ebae6228ed8234133210b2a372a5a414bd525238ed823411ff1c329372a5a4101a591208ed82341553ade28372a5a412c1e6b218ed8234161b16728372a5a412fb415138ed8234181025e28372a5a41de87fe108ed82341b4dca028372a5a41139dcb0f8ed8234142045e28372a5a41d0ebd2098ed823415f1d7128372a5a41596dbc078ed82341de3dda28372a5a41ca0f8a068ed823416a709728372a5a416db896038ed8234191aa9928372a5a41cecbc2ff8dd82341d6fbe828372a5a413ffb27fe8dd823415c5b8329372a5a411d61a7fa8dd82341df84fb29372a5a418e0f69f68dd8234198e1222a372a5a416ceca1f18dd82341ff1cf929372a5a4172387eef8dd823413790512a372a5a41b23ea3ef8dd823413574812a372a5a419ca052f18dd82341a3fab72a372a5a416a52bdee8dd8234155fb3d2b372a5a419f94bcee8dd823415f04a92b372a5a41626845f88dd823410bf0312b372a5a4137800d008ed8234176222b2b372a5a411df06c038ed8234132d6632b372a5a41b6026b078ed823415b30f32b372a5a411255cc0c8ed82341bcf5f32b372a5a41514044128ed82341da464c2c372a5a4185c95a158ed8234151cff42c372a5a414b9912168ed8234185e9c72d372a5a4145f2e11c8ed8234101cede2d372a5a414e33581d8ed823410a6bb02d372a5a41447f0b1c8ed82341075d122d372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (917,'os','clavicule','droit','ceinture scapulaire','périnatal',X'00016a080000efd5d9678dd82341f4b5fa24372a5a41f92e8bb18dd82341feb80c27372a5a417c06000000010000006903000000010000001b000000d910d67c8dd82341605e0d26372a5a41b02605818dd82341f92c2826372a5a41236699918dd82341e236f726372a5a4144a7c2968dd82341feb80c27372a5a41d912a89f8dd823410ca7dd26372a5a415c5dd1a88dd8234157dc6226372a5a411c6f47b08dd82341bf055e26372a5a41f92e8bb18dd8234173341b26372a5a41db082faf8dd82341008c5e25372a5a41d55039ad8dd82341f1d80925372a5a4190fee7ab8dd82341f4b5fa24372a5a41b91ac5a88dd823416cb33a25372a5a410a8376a58dd823417f81dd25372a5a4128d7d09e8dd823410a470a26372a5a412a7ac5978dd82341813e1726372a5a41376a898f8dd823413a31ff25372a5a41118e9d808dd823415f796925372a5a418f5a78798dd82341fae64c25372a5a4187baf4748dd8234139a16425372a5a41e3c91d718dd823411533a525372a5a418c14846c8dd823412623a625372a5a413a3c5a688dd823412ca2e825372a5a41efd5d9678dd8234164eb2126372a5a4141ff026a8dd82341e068b626372a5a41f898546d8dd82341164ef226372a5a41a7856d738dd823418c454d26372a5a41d910d67c8dd82341605e0d26372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (918,'os','scapula','droit','ceinture scapulaire','périnatal',X'00016a0800006d091e7e8dd82341e4323f1c372a5a41268867af8dd823416dbef923372a5a417c06000000010000006903000000010000001f000000e800a8a68dd82341134cc623372a5a41d8ff1eac8dd823413b13cd22372a5a41f0d255af8dd8234168a0b221372a5a41268867af8dd82341c3ff6120372a5a41ceaf90ad8dd82341cb292e1f372a5a41dae956a98dd82341c313031e372a5a4116e1e6a38dd8234175f52b1d372a5a41241d2a9b8dd82341614c641c372a5a41750ee4978dd82341e4323f1c372a5a412a12a0958dd82341c2d0431c372a5a41145241938dd823414fbe981c372a5a4145188e918dd8234166c6de1d372a5a417a4ebc8d8dd8234193d67e1f372a5a41fe7b418b8dd823414379ee1f372a5a41f2eb69868dd823410ee34d20372a5a41104524858dd82341c6768d20372a5a41d18dfa848dd82341b9535621372a5a41d09649878dd8234146104822372a5a41237e2c848dd823414d5a7022372a5a411c906c808dd82341a2e84322372a5a416960057f8dd823411b9d4b22372a5a416d091e7e8dd823415cc4a322372a5a41af2f8c7e8dd8234137884523372a5a4104c1ef7f8dd823411cb48323372a5a41f7501e828dd8234136289323372a5a411279af8b8dd823413ec62223372a5a410c1635938dd82341d7b32123372a5a41ce8c0f988dd82341a0f04f23372a5a41e99204a38dd823416dbef923372a5a41dca049a58dd8234118a5f723372a5a41e800a8a68dd82341134cc623372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (919,'os','humérus','droit','membre supérieur','périnatal',X'00016a080000cd61a7698dd823412036eb12372a5a41114e40838dd82341f7861f20372a5a417c06000000010000006903000000010000001d00000024603a7f8dd823413bd0a81e372a5a41ca11317f8dd82341d152331a372a5a41f428bc7d8dd823419a1d9d16372a5a41117ed37e8dd82341d94f9a15372a5a41114e40838dd82341d9289013372a5a41bade427b8dd82341f8d5fb12372a5a413d876c788dd823412036eb12372a5a41e5c957768dd8234178ae0413372a5a414568d0738dd823410fa85f13372a5a41da88236f8dd82341d7646313372a5a412128a46b8dd82341988e8513372a5a41cd61a7698dd823417b7bdb13372a5a41ba3ac16a8dd82341bc693014372a5a4138e9436f8dd82341fd8ec014372a5a418d7a4c718dd8234151002d15372a5a41edfe16738dd82341dc1fd915372a5a41286e4e748dd823414f9bdf16372a5a417ae7db728dd82341a661bc1c372a5a410f2cdc718dd8234100e2d21d372a5a418a7eb26f8dd82341fe9ff01e372a5a415bcce1708dd82341db1daf1f372a5a41c94905738dd82341b653f51f372a5a41df5ab9768dd82341f7861f20372a5a4125b0da7a8dd8234197811c20372a5a41cf6ca47e8dd82341d90df21f372a5a410d93de808dd823416991b81f372a5a41addce4818dd82341a337671f372a5a419d6f4c818dd8234165370a1f372a5a4124603a7f8dd823413bd0a81e372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (920,'os','fémur','droit','membre inférieur','périnatal',X'00016a080000bb1003e28dd82341c33d7100372a5a4179265c038ed8234156519c0e372a5a417c06000000010000006903000000010000001d00000081edc5fe8dd82341659a190d372a5a415c4cfafa8dd823417ad62a0c372a5a41aa459bf88dd82341c5901e0b372a5a41963637f78dd8234151579d09372a5a4139184af78dd823417cc01308372a5a4183af90fb8dd823412c452903372a5a4179d605fe8dd823418b914802372a5a4128122a038ed82341565e5001372a5a4179265c038ed82341bcc4ff00372a5a417197f8008ed82341bfe0ac00372a5a41d6f87bfb8dd82341c33d7100372a5a41f93a22e58dd8234106e48d00372a5a41af8496e28dd823419684ca00372a5a41bb1003e28dd8234174d30e01372a5a414b1768e68dd8234172dcdf01372a5a41cea34ee88dd823417d23a402372a5a415e38d7ea8dd8234140f15d06372a5a41f44f4bea8dd823411ae4b00b372a5a41c140aee98dd823418371730c372a5a41c00b94e78dd82341070b2a0d372a5a4112085ce78dd8234115be9c0d372a5a41686a99e88dd82341cda9e20d372a5a41e8adadef8dd82341c579680e372a5a4192064ff48dd82341fba1980e372a5a41f8afcef88dd8234156519c0e372a5a41fa19ecfd8dd82341c58a560e372a5a4187f879018ed823411f67d70d372a5a41a04788018ed823416fcd690d372a5a4181edc5fe8dd82341659a190d372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (921,'os','patella','droit','membre inférieur','périnatal',X'00016a080000e8a6c2ea8dd823416cb20efe362a5a41085ed9f78dd82341b9d921ff362a5a417c06000000010000006903000000010000000b000000a5febbf08dd823415a2510fe362a5a41c8e29feb8dd8234182a44bfe362a5a41e8a6c2ea8dd82341bda776fe362a5a416b1347eb8dd823419b0db2fe362a5a41ffd494ed8dd82341e67bedfe362a5a412d45a6f18dd82341b9d921ff362a5a41797086f68dd82341339a21ff362a5a41085ed9f78dd8234165fec9fe362a5a412e8ecbf68dd82341be163cfe362a5a41c1fbabf48dd823416cb20efe362a5a41a5febbf08dd823415a2510fe362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (922,'os','fibula','droit','membre inférieur','périnatal',X'00016a0800007fa1a4dc8dd8234184c883f1362a5a4177c69cec8dd82341c2e1d3fc362a5a417c060000000100000069030000000100000010000000983b62e58dd82341f40ec8fb362a5a418865b1e78dd823419587baf5362a5a4177c69cec8dd823418fd10cf2362a5a41783f1aec8dd8234105bea3f1362a5a419a0c65ea8dd8234184c883f1362a5a4123e3e8e58dd82341b117a9f1362a5a41a00491e08dd82341abb393f1362a5a41ccc74bdf8dd823410da8b7f1362a5a417bdbafde8dd82341f59210f2362a5a417199ccde8dd823410e8c03f8362a5a412e0412de8dd823412b453bfb362a5a417fa1a4dc8dd82341acfc86fc362a5a412dae9be08dd82341c2e1d3fc362a5a416a47d8e48dd82341e43ebffc362a5a41c1cfafe68dd82341b78562fc362a5a41983b62e58dd82341f40ec8fb362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (923,'os','tibia','droit','membre inférieur','périnatal',X'00016a08000062d3e1ec8dd82341ca733ff1362a5a419f1c39038ed8234117b80cfd362a5a417c06000000010000006903000000010000001900000054015fff8dd823418cd85efb362a5a417f593bfd8dd82341bc5585f9362a5a4144e737fd8dd82341a334acf6362a5a4196da2dff8dd8234170211ff4362a5a419f1c39038ed823415e31a2f1362a5a4167b9b8028ed823412f7d87f1362a5a419c7bbdff8dd82341112b80f1362a5a4163f4bcfc8dd82341b1a44cf1362a5a419a6704fa8dd82341ca733ff1362a5a41620886f28dd82341aacf7cf1362a5a41cb8f03f18dd82341c6cfc4f1362a5a4105d947f18dd8234114cb61f2362a5a41844cd6f38dd823412ad2e3f3362a5a413569b0f38dd82341a2e72cf6362a5a4157f16ef18dd82341c107def9362a5a414b5096ef8dd82341cfb144fb362a5a4162d3e1ec8dd82341d7774bfc362a5a41ded642ed8dd82341bafccbfc362a5a418dd91aef8dd82341bf11f8fc362a5a4193a07df28dd82341b9050cfd362a5a416ae2f9fb8dd8234117b80cfd362a5a417709cf008ed82341c94feefc362a5a41b41d4c028ed82341567096fc362a5a4189d986028ed823411c4e4afc362a5a4154015fff8dd823418cd85efb362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (924,'os','ulna','droit','membre supérieur','périnatal',X'00016a080000a84d53758dd823410e27f905372a5a41fb572a868dd82341f2fd3a12372a5a417c06000000010000006903000000010000001a0000006339e9828dd823411c181d12372a5a4139ec4c848dd8234192cd8911372a5a41770e8c858dd82341c56d2f10372a5a41fb572a868dd82341055df40b372a5a41e9eb6e858dd82341125abe09372a5a410c377b838dd82341c3f36507372a5a417ce11e848dd82341cfb95606372a5a41308941838dd82341ba971106372a5a41ab00dc808dd823410e27f905372a5a412d129d7a8dd82341e60c4d06372a5a41fbee1c798dd823419f959106372a5a412c2a9e798dd82341f66b0607372a5a410bbc217c8dd823415b68a807372a5a41c32ac37d8dd82341ae00dc08372a5a4186a8407e8dd8234156f2ef0b372a5a41bc30e87b8dd823418cc34b0e372a5a41f98762798dd8234142d33d0f372a5a41a84d53758dd82341429f4710372a5a4163acca758dd82341ea715f10372a5a41254faf788dd8234174b26910372a5a4128350f7a8dd8234193bfa010372a5a41cb8c877a8dd8234167891f11372a5a41b932c0798dd82341efccc311372a5a4106bbba7a8dd8234181ade911372a5a417a94f47e8dd82341f2fd3a12372a5a416339e9828dd823411c181d12372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (925,'os','radius','droit','membre supérieur','périnatal',X'00016a0800001e4bdd628dd823415bc1f605372a5a41ba5c3a738dd823418bd36b10372a5a417c0600000001000000690300000001000000100000002f55996e8dd823418bd36b10372a5a410137fb6f8dd82341dd86800e372a5a4134f08b6d8dd823417353fb0a372a5a4139a67d6d8dd82341dffcdf09372a5a41e4b1296f8dd8234135624908372a5a41ba5c3a738dd82341a6446206372a5a41eee980718dd823418c792406372a5a41fddd796b8dd82341fa5c3b06372a5a419a1794658dd823415bc1f605372a5a413b4c90638dd82341c8cd3406372a5a411e4bdd628dd82341f2a9de06372a5a41482b20668dd82341319e7209372a5a41e3b80e698dd8234178b1140e372a5a411f403c668dd8234138022c10372a5a41616ae5688dd8234155e65c10372a5a412f55996e8dd823418bd36b10372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (926,'os','os temporal','droit','crâne','périnatal',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (927,'os','os temporal','gauche','crâne','périnatal',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (928,'os','os frontal','axial','crâne','périnatal',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (929,'os','mandibule','axial','crâne','périnatal',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (930,'os','os hyoïde','axial','crâne','périnatal',X'00016a0800005238c10e8ed823418e599a1f372a5a41236fca4a8ed823419406b221372a5a417c060000000300000069030000000100000009000000a869b0118ed823419406b221372a5a4180c7e6158ed82341b6fe9821372a5a419f80a51b8ed82341fd3f3f21372a5a415e4abf1b8ed82341857b7a20372a5a4145fdef1a8ed82341b6b92820372a5a416f15b8178ed82341a99d5520372a5a4132b0ca0e8ed82341a3d41d21372a5a415238c10e8ed82341ea857521372a5a41a869b0118ed823419406b221372a5a416903000000010000000e000000aa9628308ed82341b91ee620372a5a416217b7348ed8234100ca2b21372a5a410e2a47378ed82341bf512621372a5a410d5ab4388ed8234186607720372a5a41c8cc2d388ed823412230fc1f372a5a418b97a6318ed823414c92ac1f372a5a411e821e2c8ed823418e599a1f372a5a41635f22268ed823412d02bd1f372a5a41558c11218ed8234124530c20372a5a4143d70b218ed823410272a320372a5a415368a3228ed82341caac2e21372a5a41cf3426258ed823416ba02821372a5a410f77142b8ed823415efcd220372a5a41aa9628308ed82341b91ee620372a5a4169030000000100000009000000ce3ddb478ed823419406b221372a5a41236fca4a8ed82341ea857521372a5a4143f7c04a8ed82341a3d41d21372a5a41a75ed3418ed82341a99d5520372a5a4125979b3e8ed82341b6b92820372a5a418c06cc3d8ed82341857b7a20372a5a413db3e53d8ed82341fd3f3f21372a5a41cea6a4438ed82341b6fe9821372a5a41ce3ddb478ed823419406b221372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (931,'os','coxal','droit','ceinture pelvienne','périnatal',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (932,'os','coxal','gauche','ceinture pelvienne','périnatal',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (933,'os','phalange','droit','membre inférieur','périnatal',X'00016a080000a4eb9aef8dd82341b965a9e3362a5a415b669ef78dd823419ad92ee5362a5a417c060000000100000069030000000100000009000000de4a81f08dd82341264022e5362a5a41d60de7f38dd82341b71414e5362a5a415b669ef78dd823419ad92ee5362a5a413ec6bcf68dd8234112e01fe4362a5a41ef8d94f48dd82341b965a9e3362a5a4186a4aaf18dd823415481c9e3362a5a417f8cfdef8dd8234184500ee4362a5a41a4eb9aef8dd82341464375e4362a5a41de4a81f08dd82341264022e5362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (934,'os','phalange','droit','membre inférieur','périnatal',X'00016a0800007a1e3f028ed82341c40778e0362a5a411730980b8ed82341ec01ade2362a5a417c060000000100000069030000000100000008000000049e63028ed82341ec01ade2362a5a41399ac20a8ed82341a8e8a4e2362a5a411730980b8ed823416a693ee1362a5a41ef4bb5098ed82341950eb7e0362a5a41dad977078ed82341c40778e0362a5a4107ef49048ed8234198d391e0362a5a417a1e3f028ed823419d55e7e0362a5a41049e63028ed82341ec01ade2362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (935,'os','phalange','droit','membre inférieur','périnatal',X'00016a080000fc4d83018ed82341b73045e3362a5a415a3edd0a8ed82341eb307ae5362a5a417c06000000010000006903000000010000000800000052aca8018ed82341eb307ae5362a5a411e35070a8ed82341c7fa71e5362a5a415a3edd0a8ed82341f7890be4362a5a4174e6f9088ed82341a73184e3362a5a410c55bc068ed82341b73045e3362a5a4160bc3f038ed82341a18665e3362a5a41fc4d83018ed823411271b4e3362a5a4152aca8018ed82341eb307ae5362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (936,'os','phalange','droit','membre inférieur','périnatal',X'00016a0800009a8902ca8dd82341d9c5a4e2362a5a415204e1cf8dd8234183069ee3362a5a417c0600000001000000690300000001000000070000009a8902ca8dd8234183069ee3362a5a4107fddccf8dd8234183069ee3362a5a415204e1cf8dd823419227fee2362a5a41199863ce8dd82341d9c5a4e2362a5a41b959f3cb8dd823418526a7e2362a5a41c00c1fca8dd823410667cde2362a5a419a8902ca8dd8234183069ee3362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (937,'os','phalange','droit','membre inférieur','périnatal',X'00016a080000ce8497c98dd82341d0f753e1362a5a41d4ff75cf8dd82341061f27e2362a5a417c060000000100000069030000000100000007000000ce8497c98dd82341061f27e2362a5a41c66b72cf8dd82341061f27e2362a5a41d4ff75cf8dd82341d5e3a1e1362a5a41912a45ce8dd82341aab45ce1362a5a4119875dcc8dd82341d0f753e1362a5a4176d7d2c98dd82341330474e1362a5a41ce8497c98dd82341061f27e2362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (938,'os','phalange','droit','membre inférieur','périnatal',X'00016a08000016bbfbd68dd82341e40611e1362a5a412cf2d9dc8dd82341942de4e1362a5a417c06000000010000006903000000010000000700000016bbfbd68dd82341942de4e1362a5a41832ed6dc8dd82341942de4e1362a5a412cf2d9dc8dd823416dec5ee1362a5a41db16a9db8dd8234104be19e1362a5a41d649c1d98dd82341e40611e1362a5a416bbb36d78dd82341a41531e1362a5a4116bbfbd68dd82341942de4e1362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (939,'os','phalange','droit','membre inférieur','périnatal',X'00016a0800006005f4e38dd823412d8eefe0362a5a41763cd2e98dd82341dab4c2e1362a5a417c0600000001000000690300000001000000070000006005f4e38dd82341dab4c2e1362a5a41cd78cee98dd82341dab4c2e1362a5a41763cd2e98dd82341b4733de1362a5a412561a1e88dd823414b45f8e0362a5a416798b9e68dd823412d8eefe0362a5a41ee382fe48dd823416ea00fe1362a5a416005f4e38dd82341dab4c2e1362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (940,'os','phalange','droit','membre inférieur','périnatal',X'00016a08000011dcebf08dd82341dae7c2e0362a5a4159facaf68dd82341120f96e1362a5a417c06000000010000006903000000010000000700000011dcebf08dd82341120f96e1362a5a419436c7f68dd82341120f96e1362a5a4159facaf68dd82341e1d310e1362a5a41081f9af58dd82341b6a4cbe0362a5a412e56b2f38dd82341dae7c2e0362a5a4147b427f18dd82341bbf0e2e0362a5a4111dcebf08dd82341120f96e1362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (941,'os','phalange','droit','membre inférieur','périnatal',X'00016a080000c09e85d68dd8234127845ee2362a5a413bc36adc8dd823413b3583e3362a5a417c06000000010000006903000000010000000700000016bbfbd68dd8234143d675e3362a5a413bc36adc8dd823413b3583e3362a5a41f4d529dc8dd82341fef7bae2362a5a4131ea7fda8dd8234127845ee2362a5a41b75dedd78dd823411c7c6de2362a5a41c09e85d68dd823419cf49be2362a5a4116bbfbd68dd8234143d675e3362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (942,'os','phalange','droit','membre inférieur','périnatal',X'00016a080000014fe9e38dd82341458c36e2362a5a41ce85cee98dd82341b3f969e3362a5a417c06000000010000006903000000010000000700000093965ee48dd823412cb658e3362a5a41ce85cee98dd82341b3f969e3362a5a41a3988de98dd823412bab97e2362a5a41e0ace3e78dd82341458c36e2362a5a415f1f51e58dd82341662146e2362a5a41014fe9e38dd82341428c76e2362a5a4193965ee48dd823412cb658e3362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (943,'os','phalange','droit','membre inférieur','périnatal',X'00016a080000dfb7e1f08dd823417bc0f3e1362a5a41b143c7f68dd82341fae14ee3362a5a417c060000000100000069030000000100000007000000765457f18dd8234185073fe3362a5a41b143c7f68dd82341fae14ee3362a5a41865686f68dd82341eb6a61e2362a5a41c36adcf48dd823417bc0f3e1362a5a4194ad49f28dd82341477b05e2362a5a41dfb7e1f08dd82341b9983ce2362a5a41765457f18dd8234185073fe3362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (944,'os','ulna','gauche','membre supérieur','périnatal',X'00016a080000644261d38ed823410e27f905372a5a41089a38e48ed82341f2fd3a12372a5a417c06000000010000006903000000010000001a00000079faa1d68ed823411c181d12372a5a41bb1d97da8ed82341f2fd3a12372a5a4190ffd0de8ed8234181ade911372a5a41b074cbdf8ed82341efccc311372a5a415bfe03df8ed8234167891f11372a5a410e677cdf8ed8234193bfa010372a5a41f27edce08ed8234174b26910372a5a41a54ec1e38ed82341ea715f10372a5a41089a38e48ed82341429f4710372a5a41022229e08ed8234142d33d0f372a5a417b65a3dd8ed823418cc34b0e372a5a4166dc4adb8ed8234156f2ef0b372a5a41c53cc8db8ed82341ae00dc08372a5a41f57769dd8ed823415b68a807372a5a418a44eddf8ed82341f66b0607372a5a4149a66ee08ed823419f959106372a5a417d94eede8ed82341e60c4d06372a5a41ddc2afd88ed823410e27f905372a5a41d6174ad68ed82341ba971106372a5a4177526cd58ed82341cfb95606372a5a41e62d10d68ed82341c3f36507372a5a410d931cd48ed82341125abe09372a5a41644261d38ed82341055df40b372a5a41514dffd38ed82341c56d2f10372a5a41a0503ed58ed8234192cd8911372a5a4179faa1d68ed823411c181d12372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (945,'os','radius','gauche','membre supérieur','périnatal',X'00016a080000bd7951e68ed823415bc1f605372a5a41c08caef68ed823418bd36b10372a5a417c060000000100000069030000000100000010000000148cf2ea8ed823418bd36b10372a5a41ec37a6f08ed8234155e65c10372a5a41862d4ff38ed8234138022c10372a5a4136ab7cf08ed8234178b1140e372a5a41f6976bf38ed82341319e7209372a5a41c08caef68ed82341f2a9de06372a5a4114a1fbf58ed82341c8cd3406372a5a4162c5f7f38ed823415bc1f605372a5a411ae211ee8ed82341fa5c3b06372a5a4125ec0ae88ed823418c792406372a5a41bd7951e68ed82341a6446206372a5a4191f561ea8ed8234135624908372a5a413d010eec8ed82341dffcdf09372a5a418facffeb8ed823417353fb0a372a5a41297690e98ed82341dd86800e372a5a41148cf2ea8ed823418bd36b10372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (947,'os','occipital','axial','crâne','périnatal',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (948,'os','os sphénoïde','axial','crâne','périnatal',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (949,'os','phalange','gauche','membre inférieur','périnatal',X'00016a080000d1da62798ed82341e40611e1362a5a419041417f8ed82341942de4e1362a5a417c0600000001000000690300000001000000070000009041417f8ed82341942de4e1362a5a41020e067f8ed82341a41531e1362a5a4189ae7b7c8ed82341e40611e1362a5a4130bc937a8ed8234104be19e1362a5a41d1da62798ed823416dec5ee1362a5a4123ce66798ed82341942de4e1362a5a419041417f8ed82341942de4e1362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (950,'os','phalange','gauche','membre inférieur','périnatal',X'00016a08000090606a6c8ed823412d8eefe0362a5a4146f748728ed82341dab4c2e1362a5a417c06000000010000006903000000010000000700000046f748728ed82341dab4c2e1362a5a417e900d728ed823416ea00fe1362a5a41f75f836f8ed823412d8eefe0362a5a414b689b6d8ed823414b45f8e0362a5a4190606a6c8ed82341b4733de1362a5a414e106e6c8ed82341dab4c2e1362a5a4146f748728ed82341dab4c2e1362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (951,'os','phalange','gauche','membre inférieur','périnatal',X'00016a0800004d02725f8ed82341dae7c2e0362a5a41fcac50658ed82341120f96e1362a5a417c060000000100000069030000000100000007000000fcac50658ed82341120f96e1362a5a411a2715658ed82341bbf0e2e0362a5a416aa68a628ed82341dae7c2e0362a5a419edda2608ed82341b6a4cbe0362a5a414d02725f8ed82341e1d310e1362a5a4105c6755f8ed82341120f96e1362a5a41fcac50658ed82341120f96e1362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (952,'os','phalange','gauche','membre inférieur','périnatal',X'00016a080000e0c5d1798ed8234127845ee2362a5a41e208b77f8ed823413b3583e3362a5a417c0600000001000000690300000001000000070000009041417f8ed8234143d675e3362a5a41e208b77f8ed823419cf49be2362a5a41426f4f7e8ed823411c7c6de2362a5a41240fbd7b8ed8234127845ee2362a5a4129fd127a8ed82341fef7bae2362a5a41e0c5d1798ed823413b3583e3362a5a419041417f8ed8234143d675e3362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (953,'os','phalange','gauche','membre inférieur','périnatal',X'00016a0800004e036e6c8ed82341458c36e2362a5a41a15853728ed82341b3f969e3362a5a417c0600000001000000690300000001000000070000001366de718ed823412cb658e3362a5a41a15853728ed82341428c76e2362a5a419aadeb708ed82341662146e2362a5a411730596e8ed82341458c36e2362a5a41c208af6c8ed823412bab97e2362a5a414e036e6c8ed82341b3f969e3362a5a411366de718ed823412cb658e3362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (954,'os','phalange','gauche','membre inférieur','périnatal',X'00016a080000f6b8755f8ed823417bc0f3e1362a5a41c7445b658ed82341fae14ee3362a5a417c06000000010000006903000000010000000700000030a8e5648ed8234185073fe3362a5a41c7445b658ed82341b9983ce2362a5a41124ff3638ed82341477b05e2362a5a41e39160618ed823417bc0f3e1362a5a4120a6b65f8ed82341eb6a61e2362a5a41f6b8755f8ed82341fae14ee3362a5a4130a8e5648ed8234185073fe3362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (955,'os','talus','droit','membre inférieur','périnatal',X'00016a080000cbdbfee48dd82341132982ee362a5a4199d393f68dd823410f9265f0362a5a417c060000000100000069030000000100000010000000d6ea25eb8dd823418a9b49f0362a5a4150d7e7ed8dd823410f9265f0362a5a41728cbcf08dd8234191a05ef0362a5a415772baf48dd82341728826f0362a5a412de477f68dd823414678ecef362a5a4199d393f68dd823419fb79aef362a5a4180eb7cf58dd82341a35a3eef362a5a41d65eabf28dd8234196fcbdee362a5a415595b6f08dd8234134f792ee362a5a4147d6b3ed8dd82341132982ee362a5a41159b6aea8dd823417f5c92ee362a5a418c2dade78dd82341be1ff2ee362a5a41ce5785e58dd82341052978ef362a5a41cbdbfee48dd82341ab72c6ef362a5a41c876e1e58dd823413d9709f0362a5a41d6ea25eb8dd823418a9b49f0362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (956,'os','calcanéus','droit','membre inférieur','périnatal',X'00016a0800004c3011e08dd8234135408deb362a5a41d737caf78dd823417ce4f5ed362a5a417c06000000010000006903000000010000000f000000d737caf78dd8234198e553ed362a5a4108f25ff78dd8234164a999ec362a5a41854807f38dd82341e2890fec362a5a41bacfd7ec8dd823416ba0e6eb362a5a41ea5375e68dd8234135408deb362a5a412377a6e38dd82341602ea7eb362a5a41be19bde18dd8234188dfeeeb362a5a414c3011e08dd823417ea19dec362a5a41251a18e08dd82341fa4fefec362a5a416002e0e28dd82341ef825eed362a5a41eaffd0e78dd82341c661c1ed362a5a41b12181eb8dd823417ce4f5ed362a5a4100f528f28dd8234115aef2ed362a5a4123e122f58dd8234168dec1ed362a5a41d737caf78dd8234198e553ed362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (957,'os','métatarsien','droit','membre inférieur','périnatal',X'00016a080000372354fe8dd82341563104e6362a5a4138e85f0d8ed82341365794e9362a5a417c06000000010000006903000000010000000f000000baa2d2008ed8234178e3d8e8362a5a410e0cb6ff8dd823417f4f4be9362a5a41321f4e008ed823410e7f87e9362a5a4138e85f0d8ed82341365794e9362a5a415aae3f0b8ed823412ceb5be8362a5a41adaf150c8ed82341b61891e6362a5a4122f14a0b8ed82341fe4d54e6362a5a41d1a47f098ed82341d00c2fe6362a5a41736dc8018ed82341563104e6362a5a41d03f8fff8dd823410c0f19e6362a5a41e5f45bfe8dd823419c3246e6362a5a41372354fe8dd8234162ccc1e6362a5a41b7ec82008ed823417d7437e7362a5a4186273d018ed823416e9c96e7362a5a41baa2d2008ed8234178e3d8e8362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (958,'os','métatarsien','droit','membre inférieur','périnatal',X'00016a0800003a60ffed8dd823419a71a8e5362a5a41372b41fa8dd82341af4fabe9362a5a417c06000000010000006903000000010000000f0000009905dff88dd8234143c6a1e9362a5a410e2f13fa8dd82341cb2a9ae9362a5a41372b41fa8dd82341585775e9362a5a419954c0f78dd82341d317a2e8362a5a4117dbfaf68dd823411a14b6e7362a5a417c717cf88dd823414e9dede5362a5a418b083af68dd823419a71a8e5362a5a413b8318f18dd82341b12bace5362a5a41b144d9ee8dd82341c570d5e5362a5a413a60ffed8dd82341d47526e6362a5a417e1da7ef8dd823410ddf42e7362a5a41dca442ef8dd823411e6f94e9362a5a4102deb7ef8dd82341af4fabe9362a5a41fa4921f28dd823412e4690e9362a5a419905dff88dd8234143c6a1e9362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (959,'os','métatarsien','droit','membre inférieur','périnatal',X'00016a0800009a6796e08dd823417cd7c3e5362a5a4163f92feb8dd8234143c6a1e9362a5a417c06000000010000006903000000010000000d000000ee2a64e98dd8234143c6a1e9362a5a417d53c7ea8dd8234197596ae9362a5a4163f92feb8dd823411a7e0be9362a5a41b7fa04ea8dd82341f93e4fe7362a5a41452e58ea8dd823416dd030e6362a5a41090589e88dd823415177cce5362a5a41a12090e48dd823417cd7c3e5362a5a41074a62e28dd823416cd2e5e5362a5a41f0d190e18dd82341513f1fe6362a5a41dbe3f0e28dd82341200fa1e7362a5a419a6796e08dd82341a22066e9362a5a41a54571e18dd8234143c6a1e9362a5a41ee2a64e98dd8234143c6a1e9362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (960,'os','métatarsien','droit','membre inférieur','périnatal',X'00016a080000bb252dd38dd823411c9be4e5362a5a4108db8edd8dd823411ca375e9362a5a417c06000000010000006903000000010000000e00000040d22adb8dd82341dd436ce9362a5a4121a5d3dc8dd82341063c5ae9362a5a4193378cdd8dd82341ceb110e9362a5a41918815dc8dd823413f2582e7362a5a4108db8edd8dd82341cece3be6362a5a418ca777dc8dd82341ff91f4e5362a5a41a2793dda8dd823411c9be4e5362a5a412d6a18d58dd8234124be14e6362a5a41db018ad38dd823418cce52e6362a5a41914a79d58dd82341d8072de7362a5a41bb252dd38dd8234142bf1be9362a5a416dfca2d38dd82341b1b153e9362a5a41912108d58dd823411ca375e9362a5a4140d22adb8dd82341dd436ce9362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (961,'os','métatarsien','droit','membre inférieur','périnatal',X'00016a080000e9777bc58dd82341025bf2e5362a5a41f3ca7dd08dd82341a323dbe9362a5a417c06000000010000006903000000010000000e000000c12273cf8dd8234190a436e9362a5a41f3ca7dd08dd82341ff065be8362a5a41099566d08dd823414df816e6362a5a4157e8ecce8dd82341025bf2e5362a5a41407fa1c98dd823411689f9e5362a5a4137e3f3c78dd82341e9c55de6362a5a41b6bf71c78dd823412670b8e7362a5a41ad8200c88dd823411b6f50e8362a5a41b721b6c58dd82341a1f2cae8362a5a41e9777bc58dd823413c6013e9362a5a410879c0c78dd823410b3f8de9362a5a4136dd37cb8dd82341a323dbe9362a5a411c97b1cd8dd82341f9d7afe9362a5a41c12273cf8dd8234190a436e9362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (962,'os','phalange','droit','membre inférieur','périnatal',X'00016a080000464cc1c88dd8234119ad57e4362a5a41c12273cf8dd823417cc19ae5362a5a417c06000000010000006903000000010000000700000002802cc98dd82341d8618de5362a5a41c12273cf8dd823417cc19ae5362a5a41f2b66fcf8dd82341127dc2e4362a5a4184e421cd8dd8234119ad57e4362a5a41f4671ecb8dd82341786e5be4362a5a41464cc1c88dd823412e9f8fe4362a5a4102802cc98dd82341d8618de5362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (963,'os','phalange','droit','membre inférieur','périnatal',X'00016a080000c613f0d48dd82341b16516e4362a5a41744e6bdc8dd82341329272e5362a5a417c0600000001000000690300000001000000080000001b4d4ed58dd82341329272e5362a5a41847ea6d98dd82341613347e5362a5a41f16f00dc8dd8234127cd57e5362a5a41744e6bdc8dd82341f7c259e4362a5a41c2826dd98dd82341980a1fe4362a5a41110cb4d68dd82341b16516e4362a5a41c613f0d48dd823419de354e4362a5a411b4d4ed58dd82341329272e5362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (964,'os','phalange','droit','membre inférieur','périnatal',X'00016a080000f6c247e28dd823417f3b07e4362a5a41ee2a64e98dd823411cce57e5362a5a417c0600000001000000690300000001000000080000006383b2e28dd8234166704ae5362a5a41097a69e78dd82341198136e5362a5a41ee2a64e98dd823411cce57e5362a5a412a3463e98dd82341938f66e4362a5a41cb3b64e68dd823417f3b07e4362a5a41278b18e48dd823415e1f15e4362a5a41f6c247e28dd8234133145ae4362a5a416383b2e28dd8234166704ae5362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (965,'os','tibia','gauche','membre inférieur','périnatal',X'00016a0800003caf52568ed82341ca733ff1362a5a4103cfa96c8ed8234117b80cfd362a5a417c06000000010000006903000000010000001900000022a62c5a8ed823418cd85efb362a5a41edcd04578ed823411c4e4afc362a5a41c1893f578ed82341567096fc362a5a41fe9dbc588ed82341c94feefc362a5a41b3b7915d8ed8234117b80cfd362a5a418ffc0d678ed82341b9050cfd362a5a413ab5706a8ed82341bf11f8fc362a5a415fcb486c8ed82341bafccbfc362a5a4103cfa96c8ed82341d7774bfc362a5a419c09f5698ed82341cfb144fb362a5a4160971c688ed82341c107def9362a5a416e1bdb658ed82341a2e72cf6362a5a41e329b5658ed823412ad2e3f3362a5a41708a43688ed8234114cb61f2362a5a41a8b687688ed82341c6cfc4f1362a5a41ba2b05678ed82341aacf7cf1362a5a414fe8865f8ed82341ca733ff1362a5a41058bce5c8ed82341b1a44cf1362a5a414506ce598ed82341112b80f1362a5a419ddcd2568ed823412f7d87f1362a5a413caf52568ed823415e31a2f1362a5a41abd55d5a8ed8234170211ff4362a5a4132c0535c8ed82341a334acf6362a5a41f74d505c8ed82341bc5585f9362a5a4122a62c5a8ed823418cd85efb362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (966,'os','talus','gauche','membre inférieur','périnatal',X'00016a080000dc05a95f8ed82341132982ee362a5a41331b3e718ed823410f9265f0362a5a417c060000000100000069030000000100000010000000379e166b8ed823418a9b49f0362a5a414d685b708ed823413d9709f0362a5a41331b3e718ed82341ab72c6ef362a5a41a7a4b7708ed82341052978ef362a5a4152b08f6e8ed82341be1ff2ee362a5a414eeed16b8ed823417f5c92ee362a5a41fcef88688ed82341132982ee362a5a41c45a86658ed8234134f792ee362a5a41cb9d91638ed8234196fcbdee362a5a41d5ddbf608ed82341a35a3eef362a5a41dc05a95f8ed823419fb79aef362a5a41290fc55f8ed823414678ecef362a5a414b8a82618ed82341728826f0362a5a41c06580658ed8234191a05ef0362a5a4164f954688ed823410f9265f0362a5a41379e166b8ed823418a9b49f0362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (967,'os','calcanéus','gauche','membre inférieur','périnatal',X'00016a0800003651725e8ed8234135408deb362a5a4192bf2b768ed823417ce4f5ed362a5a417c06000000010000006903000000010000000f0000003651725e8ed8234198e553ed362a5a41eaa719618ed8234168dec1ed362a5a410d9413648ed8234115aef2ed362a5a418f4ebc6a8ed823417ce4f5ed362a5a412d4e6c6e8ed82341c661c1ed362a5a416e1c5d738ed82341ef825eed362a5a4119e724768ed82341fa4fefec362a5a4192bf2b768ed823417ea19dec362a5a41e5b57f748ed8234188dfeeeb362a5a416a7a96728ed82341602ea7eb362a5a414868c76f8ed8234135408deb362a5a41d72865698ed823416ba0e6eb362a5a41fb8835638ed82341e2890fec362a5a411eeadc5e8ed8234164a999ec362a5a413651725e8ed8234198e553ed362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (968,'os','métatarsien','gauche','membre inférieur','périnatal',X'00016a0800006e14dd488ed82341563104e6362a5a41e6d6e8578ed82341365794e9362a5a417c06000000010000006903000000010000000f000000ec596a558ed8234178e3d8e8362a5a4120d5ff548ed823416e9c96e7362a5a41ef0fba558ed823417d7437e7362a5a41e6d6e8578ed8234162ccc1e6362a5a41c9eee0578ed823419c3246e6362a5a41188aad568ed823410c0f19e6362a5a412f3574548ed82341563104e6362a5a412c16bd4c8ed82341d00c2fe6362a5a41afb4f14a8ed82341fe4d54e6362a5a416bdb264a8ed82341b61891e6362a5a41b3dafc4a8ed823412ceb5be8362a5a416e14dd488ed82341365794e9362a5a4175ddee558ed823410e7f87e9362a5a4198f086568ed823417f4f4be9362a5a41ec596a558ed8234178e3d8e8362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (969,'os','métatarsien','gauche','membre inférieur','périnatal',X'00016a080000f7cdfb5b8ed823419a71a8e5362a5a419f623d688ed82341af4fabe9362a5a417c06000000010000006903000000010000000f00000074835d5d8ed8234143c6a1e9362a5a41396a1b648ed823412e4690e9362a5a41301785668ed82341af4fabe9362a5a413132fa668ed823411e6f94e9362a5a4129df95668ed823410ddf42e7362a5a419f623d688ed82341d47526e6362a5a41087663678ed82341c570d5e5362a5a419c1224658ed82341b12bace5362a5a419cb702608ed823419a71a8e5362a5a411054c05d8ed823414e9dede5362a5a41582e425f8ed823411a14b6e7362a5a4192ec7c5e8ed82341d317a2e8362a5a41f7cdfb5b8ed82341585775e9362a5a41739c295c8ed82341cb2a9ae9362a5a4174835d5d8ed8234143c6a1e9362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (970,'os','métatarsien','gauche','membre inférieur','périnatal',X'00016a08000047740c6b8ed823417cd7c3e5362a5a417321a6758ed8234143c6a1e9362a5a417c06000000010000006903000000010000000d0000001f5ed86c8ed8234143c6a1e9362a5a416843cb748ed8234143c6a1e9362a5a417321a6758ed82341a22066e9362a5a41f9de4b738ed82341200fa1e7362a5a414618ac748ed82341513f1fe6362a5a416aaada738ed823416cd2e5e5362a5a4188b2ac718ed823417cd7c3e5362a5a4106a2b36d8ed823415177cce5362a5a41388ae46b8ed823416dd030e6362a5a4162ae376c8ed82341f93e4fe7362a5a4147740c6b8ed823411a7e0be9362a5a41f115756b8ed8234197596ae9362a5a411f5ed86c8ed8234143c6a1e9362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (971,'os','métatarsien','gauche','membre inférieur','périnatal',X'00016a0800006401ae788ed823411c9be4e5362a5a4156bd0f838ed823411ca375e9362a5a417c06000000010000006903000000010000000e000000662a127b8ed82341dd436ce9362a5a41466b34818ed823411ca375e9362a5a41f9b099828ed82341b1b153e9362a5a4156bd0f838ed8234142bf1be9362a5a41916dc3808ed82341d8072de7362a5a4102f7b2828ed823418cce52e6362a5a416a9224818ed8234124be14e6362a5a417859ff7b8ed823411c9be4e5362a5a41c921c5798ed82341ff91f4e5362a5a416401ae788ed82341cece3be6362a5a417c4e277a8ed823413f2582e7362a5a413995b0788ed82341ceb110e9362a5a41212b69798ed82341063c5ae9362a5a41662a127b8ed82341dd436ce9362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (972,'os','métatarsien','gauche','membre inférieur','périnatal',X'00016a080000bd42bf858ed82341025bf2e5362a5a416340c1908ed82341a323dbe9362a5a417c06000000010000006903000000010000000e000000e5d9c9868ed8234190a436e9362a5a4105188b888ed82341f9d7afe9362a5a41ad7c048b8ed82341a323dbe9362a5a419bcd7b8e8ed823410b3f8de9362a5a416340c1908ed823413c6013e9362a5a41abce86908ed82341a1f2cae8362a5a4128b63c8e8ed823411b6f50e8362a5a4177faca8e8ed823412670b8e7362a5a416fa7488e8ed82341e9c55de6362a5a4194589b8c8ed823411689f9e5362a5a4182da4f878ed82341025bf2e5362a5a415521d6858ed823414df816e6362a5a41bd42bf858ed82341ff065be8362a5a41e5d9c9868ed8234190a436e9362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (973,'os','phalange','gauche','membre inférieur','périnatal',X'00016a080000e5d9c9868ed8234119ad57e4362a5a41c2c97a8d8ed823417cc19ae5362a5a417c060000000100000069030000000100000007000000a47c108d8ed82341d8618de5362a5a41c2c97a8d8ed823412e9f8fe4362a5a4137e61d8b8ed82341786e5be4362a5a4128a81a898ed8234119ad57e4362a5a418d44cd868ed82341127dc2e4362a5a41e5d9c9868ed823417cc19ae5362a5a41a47c108d8ed82341d8618de5362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (974,'os','phalange','gauche','membre inférieur','périnatal',X'00016a080000993ad1798ed82341b16516e4362a5a4195784c818ed82341329272e5362a5a417c060000000100000069030000000100000008000000f23bee808ed82341329272e5362a5a4195784c818ed823419de354e4362a5a4141ad887f8ed82341b16516e4362a5a415830cf7c8ed82341980a1fe4362a5a41993ad1798ed82341f7c259e4362a5a411c193c7a8ed8234127cd57e5362a5a41e63d967c8ed82341613347e5362a5a41f23bee808ed82341329272e5362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (975,'os','phalange','gauche','membre inférieur','périnatal',X'00016a0800001f5ed86c8ed823417f3b07e4362a5a416639f5738ed823411cce57e5362a5a417c060000000100000069030000000100000008000000aa058a738ed8234166704ae5362a5a416639f5738ed8234133145ae4362a5a41166924728ed823415e1f15e4362a5a417d98d86f8ed823417f3b07e4362a5a410455d96c8ed82341938f66e4362a5a411f5ed86c8ed823411cce57e5362a5a416142d36e8ed82341198136e5362a5a41aa058a738ed8234166704ae5362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (976,'os','phalange','gauche','membre inférieur','périnatal',X'00016a0800004b969e5e8ed82341b965a9e3362a5a41b4daa1668ed823419ad92ee5362a5a417c060000000100000069030000000100000009000000c8b1bb658ed82341264022e5362a5a41b4daa1668ed82341464375e4362a5a4133363f668ed8234184500ee4362a5a41e00c92648ed823415481c9e3362a5a41cc1aa8618ed82341b965a9e3362a5a41101e805f8ed8234112e01fe4362a5a414b969e5e8ed823419ad92ee5362a5a41d0ee55628ed82341b71414e5362a5a41c8b1bb658ed82341264022e5362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (977,'os','phalange','gauche','membre inférieur','périnatal',X'00016a080000fb58a44a8ed82341c40778e0362a5a412cdefd538ed82341ec01ade2362a5a417c0600000001000000690300000001000000080000007077d8538ed82341ec01ade2362a5a412cdefd538ed823419d55e7e0362a5a41a00df3518ed8234198d391e0362a5a415c1ac54e8ed82341c40778e0362a5a411c81874c8ed82341950eb7e0362a5a41fb58a44a8ed823416a693ee1362a5a413d627a4b8ed82341a8e8a4e2362a5a417077d8538ed82341ec01ade2362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (978,'os','phalange','gauche','membre inférieur','périnatal',X'00016a0800004cbe5f4b8ed82341b73045e3362a5a41de4bb9548ed82341eb307ae5362a5a417c060000000100000069030000000100000008000000bbdc93548ed82341eb307ae5362a5a41de4bb9548ed823411271b4e3362a5a4102baae528ed8234133fc5ee3362a5a41d1ea804f8ed82341b73045e3362a5a41652a434d8ed82341a73184e3362a5a414cbe5f4b8ed82341f7890be4362a5a412054354c8ed82341c7fa71e5362a5a41bbdc93548ed82341eb307ae5362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (979,'os','phalange','gauche','membre inférieur','périnatal',X'00016a0800006d845b868ed82341d9c5a4e2362a5a4173ff398c8ed8234183069ee3362a5a417c06000000010000006903000000010000000700000073ff398c8ed8234183069ee3362a5a41104a1d8c8ed823410667cde2362a5a41ce15498a8ed823418526a7e2362a5a41a20ed9878ed82341d9c5a4e2362a5a416d845b868ed823419227fee2362a5a417b185f868ed8234183069ee3362a5a4173ff398c8ed8234183069ee3362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (980,'os','phalange','gauche','membre inférieur','périnatal',X'00016a08000029cdc6868ed82341d0f753e1362a5a41d877a58c8ed82341061f27e2362a5a417c060000000100000069030000000100000007000000d877a58c8ed82341061f27e2362a5a4130256a8c8ed82341330474e1362a5a418d75df898ed82341d0f753e1362a5a417aa8f7878ed82341aab45ce1362a5a4129cdc6868ed82341d5e3a1e1362a5a41e090ca868ed82341061f27e2362a5a41d877a58c8ed82341061f27e2362a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (981,'os','scapula','gauche','ceinture scapulaire','immature',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (982,'os','scapula','droit','ceinture scapulaire','immature',X'00016a080000c6ff1a5a8dd82341d17b85fc372a5a41733287a18dd8234118ef1007382a5a417c06000000030000006903000000010000000c00000025ef51658dd82341ecb09e05382a5a410d9a115c8dd823417b5a0106382a5a41ab79e75a8dd82341ae953406382a5a41c6ff1a5a8dd823411721fc06382a5a419cb2825d8dd82341fba80b07382a5a41f8d03e648dd823415e61ea06382a5a410bba50668dd8234118ef1007382a5a41c489ef688dd82341ae9b0d07382a5a410a3ecc6a8dd82341703ac006382a5a41a17465698dd82341f4aa4106382a5a41fbc59d678dd82341e77bcf05382a5a4125ef51658dd82341ecb09e05382a5a416903000000010000000a0000000ad891678dd82341c890aa04382a5a411589bd728dd8234101231105382a5a418cd7fc788dd82341f0e3ee04382a5a4168a49e7c8dd823412fce9704382a5a414a7c4b798dd82341bfb01504382a5a41673fd3718dd823419b2a7804382a5a417838536f8dd82341a5f76e04382a5a418e62d56d8dd823414dfb4404382a5a41473e81698dd8234153201e04382a5a410ad891678dd82341c890aa04382a5a4169030000000200000021000000462e107e8dd82341e7271d05382a5a41af6399768dd8234130164a05382a5a413bdfc76f8dd82341b3334905382a5a415c35916c8dd823413de66e05382a5a411a5af16b8dd823412014a005382a5a412dba7a6d8dd823411f4c5a06382a5a41e8cf44708dd8234111fd6206382a5a4147927e768dd823413c50ff05382a5a41b8891b848dd823410721f205382a5a414edf398c8dd823415da64a05382a5a41e792dd8c8dd8234182050e05382a5a41eb714d8a8dd82341ac20f004382a5a41c858ad958dd823414d4a7005382a5a41fa2cb19a8dd823415a0e3205382a5a41874a159f8dd8234192045904382a5a41ea3429a18dd82341f737e801382a5a41733287a18dd82341011bdcff372a5a418003cd9a8dd82341ca73ecfc372a5a41f12472988dd82341d17b85fc372a5a416b0d00928dd82341f51daafc372a5a414cdc548c8dd82341eee328fd372a5a413a3163868dd823412f647afd372a5a41da16cb838dd82341a1aae7fe372a5a41905453808dd8234148baefff372a5a41b52b96748dd82341e5de9901382a5a4139c6d76a8dd8234107fdab02382a5a41e3291b698dd82341ff6e0503382a5a4172142b698dd82341f6cd8303382a5a4174509d6b8dd82341fc7ada03382a5a41eb24e1798dd82341ba6ae403382a5a41949b0e818dd82341754c2d04382a5a41052c16808dd82341d91ec504382a5a41462e107e8dd82341e7271d05382a5a410400000079d181888dd82341c32fdb04382a5a41b66367868dd82341bca7c204382a5a41949b0e818dd82341754c2d04382a5a4179d181888dd82341c32fdb04382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (983,'os','os hyoïde','axial','crâne','immature',X'00016a0800006c6a45ff8dd823415630a103382a5a41d906db478ed82341ea0b4807382a5a417c06000000030000006903000000010000000d0000000e2390238ed82341f2a6b203382a5a41c530931b8ed823415630a103382a5a41a0b475198ed82341687bba03382a5a41d8e7ea168ed823412d5e9704382a5a41f28a40178ed8234111a91505382a5a4152fafb198ed82341f7253405382a5a4111a48e238ed82341ab931505382a5a41da59572d8ed823419f0e3405382a5a41c4b9df2f8ed8234111a91505382a5a41444c35308ed823412d5e9704382a5a413bb4aa2d8ed82341687bba03382a5a419f1a8d2b8ed823415630a103382a5a410e2390238ed82341f2a6b203382a5a416903000000010000000900000045004f358ed8234163392d05382a5a419d1aae448ed82341b8a40307382a5a41d906db478ed82341ea0b4807382a5a413f6e51448ed82341ea010106382a5a411a1c7c3a8ed82341be70da04382a5a418b13543a8ed823411e274304382a5a4171929b358ed82341f7bb4f04382a5a41c0d2c1338ed823411bebe104382a5a4145004f358ed8234163392d05382a5a4169030000000100000008000000d845d1118ed8234163392d05382a5a41f7845e138ed823411bebe104382a5a412bfb84118ed82341f7bb4f04382a5a419332cc0c8ed823411e274304382a5a41032aa40c8ed82341be70da04382a5a4177d9ce028ed82341ea010106382a5a416c6a45ff8dd82341ea0b4807382a5a41d845d1118ed8234163392d05382a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (984,'os','humérus','droit','membre supérieur','immature',X'00016a0800009cd808438dd82341a16890f1372a5a41ea606c6a8dd82341fe340504382a5a417c060000000400000069030000000100000013000000ead0f6478dd823418eac7400382a5a412ac5ad478dd8234175a35f01382a5a414259534b8dd8234162010d02382a5a41aa79f54d8dd82341b26b3802382a5a41ce7eef558dd823416e21ce01382a5a41d63fdc538dd823414014a700382a5a41ac8dbb568dd8234121a9fffc372a5a413f59a8558dd82341fdfb28f8372a5a418a5749578dd823413b3bc5f4372a5a41d678a25a8dd82341671d66f3372a5a41211b6c598dd823417b4422f3372a5a41736bd1518dd823417e0a50f3372a5a41133cc2468dd8234139d847f3372a5a417aa103448dd82341d3c170f3372a5a419cd808438dd8234183dcaaf3372a5a417be427498dd82341fd59ccf5372a5a41107eb44b8dd82341fe08a9f7372a5a418296464a8dd8234191250aff372a5a41ead0f6478dd823418eac7400382a5a416903000000010000000c000000273843458dd8234141889802382a5a41d4df55448dd8234181cc1e03382a5a41128b55458dd82341ede1ad03382a5a412a97bb478dd82341fe340504382a5a41a39b184f8dd8234184e4fe03382a5a413df9c5538dd82341aa3e8c03382a5a41d062e7548dd8234117032103382a5a41d73be5538dd82341fd18dd02382a5a41381c1c518dd823419755cb02382a5a41982e194b8dd82341ea940903382a5a419d677b478dd823411d20a902382a5a41273843458dd8234141889802382a5a416903000000010000000a000000ea606c6a8dd82341420b64f2372a5a410a13cb698dd823417b3f36f2372a5a41aadfdf648dd823412cdb07f2372a5a412ed8dd628dd82341db3eb2f1372a5a411fbe30618dd82341bfe6caf1372a5a41050e3b608dd823412506a7f2372a5a413698ea618dd8234181a93bf3372a5a41b55b57648dd82341617039f3372a5a41d3e2a6698dd82341fd9aa1f2372a5a41ea606c6a8dd82341420b64f2372a5a416903000000010000000c00000096c8265a8dd82341bc63b0f2372a5a41b760c75b8dd823418a0378f2372a5a41194c525b8dd823414731dff1372a5a419a9bde598dd82341a16890f1372a5a417a91bd528dd82341ec93cff1372a5a41d966a3508dd82341ffc7b4f1372a5a416f9c8c498dd823414588bdf1372a5a41a52ddf468dd82341522a24f2372a5a41514516478dd82341cc138df2372a5a41a671394a8dd82341c596ccf2372a5a413f4a89578dd823414f69adf2372a5a4196c8265a8dd82341bc63b0f2372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (985,'os','humérus','gauche','membre supérieur','immature',X'00016a0800000fb577da8ed823415677a9f1372a5a41257a80008fd82341fe340504382a5a417c0600000004000000690300000001000000130000007f5a38fb8ed823412eb1fffe372a5a41111e92f78ed823416f9ca1f7372a5a41a60c8ff98ed82341d633c2f5372a5a41bfeb08ff8ed8234198c199f3372a5a41edc2fcfd8ed823416be160f3372a5a41d00f32fb8ed82341bf493bf3372a5a41fc6d27f08ed8234101ca50f3372a5a41727180e88ed8234109342cf3372a5a417bd45ee78ed82341dd7671f3372a5a415cec20eb8ed823417244ccf4372a5a41bac7c6ed8ed8234170772df8372a5a41f43528ee8ed823410a9404fd372a5a41459820f28ed82341cddca700382a5a41318866f08ed82341d334d101382a5a41b0cf7ef88ed8234118d03102382a5a41f79b13fb8ed82341433c0302382a5a41907f84fe8ed823418f9f5101382a5a41f4cef4fd8ed82341d22a6700382a5a417f5a38fb8ed823412eb1fffe372a5a416903000000010000000c000000338e5afd8ed823411d20a902382a5a419d0ebdf98ed82341ea940903382a5a4198d9b9f38ed823419755cb02382a5a4152a7f0f08ed82341fd18dd02382a5a4102b8eeef8ed8234117032103382a5a41701f10f18ed82341aa3e8c03382a5a41ad9fbdf58ed8234184e4fe03382a5a414c931afd8ed82341fe340504382a5a41c4ea80ff8ed82341ede1ad03382a5a41257a80008fd8234181cc1e03382a5a4145d092ff8ed8234141889802382a5a41338e5afd8ed823411d20a902382a5a416903000000010000000c000000169c5aed8ed823412e7bc6f2372a5a41f6a5aafa8ed8234194a3e5f2372a5a411ccccdfd8ed823414720a6f2372a5a41cbe504fe8ed8234118333df2372a5a41734b57fb8ed82341d094d6f1372a5a413ebd40f48ed82341c5d0cdf1372a5a41e1d826f28ed8234142a0e8f1372a5a410d4b05eb8ed823415677a9f1372a5a41d64591e98ed823418d3af8f1372a5a41cc741ce98ed823416a1091f2372a5a412c38bdea8ed823411671c9f2372a5a41169c5aed8ed823412e7bc6f2372a5a416903000000010000000a00000029953ddb8ed82341c2a3baf2372a5a41980e8de08ed823418b8052f3372a5a4179bff9e28ed82341f2b654f3372a5a416269a9e48ed823413810c0f2372a5a41dbb7b3e38ed823419ef8e3f1372a5a41656006e28ed82341ba50cbf1372a5a41ec8504e08ed82341e3e420f2372a5a411ad518db8ed823413f484ff2372a5a410fb577da8ed8234108147df2372a5a4129953ddb8ed82341c2a3baf2372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (986,'os','ulna','droit','membre supérieur','immature',X'00016a0800007156fe368dd82341c7a4c8df372a5a417c5080508dd823417c6ae9ee372a5a417c06000000030000006903000000010000000a000000f16606428dd8234119addfee372a5a41b4db5d458dd823414552abee372a5a41dab6b84b8dd823417c6ae9ee372a5a41a9741b508dd8234176ccbbee372a5a417c5080508dd823415acf17ee372a5a41d5e99d4b8dd82341de20c4ed372a5a414c3fad458dd82341300c1cee372a5a41aaffd0428dd8234144a9f5ed372a5a41126097418dd82341e64f12ee372a5a41f16606428dd8234119addfee372a5a416903000000010000000b0000007156fe368dd82341768d5ae0372a5a416694b6398dd82341fa7ef0e0372a5a416d8e123a8dd82341046656e1372a5a41b8562a4b8dd82341f44f66e1372a5a4173f2c24d8dd823413f342fe1372a5a414fec544f8dd82341c3f98be0372a5a419501474c8dd82341562a6be0372a5a41e22b9e4a8dd82341d62d33e0372a5a41b381143e8dd82341db0929e0372a5a41e62d26398dd82341c7a4c8df372a5a417156fe368dd82341768d5ae0372a5a41690300000001000000160000009f0804408dd8234105aba9e6372a5a419d6043418dd8234192a987ea372a5a4100c63d438dd8234157361cec372a5a4100b4a3428dd82341d3841fed372a5a41e9034e438dd82341315d38ed372a5a41e9781e478dd823413bba0ced372a5a41054cf14b8dd82341db1e4ded372a5a41c7662d4a8dd823410c9931ec372a5a41b5cdb84d8dd82341b581a6eb372a5a41622eeb4d8dd82341c25e70eb372a5a41009392478dd82341f8e6a2e9372a5a41a1b5cc468dd82341fd2a40e8372a5a41bd2f73488dd82341acca5de4372a5a41c161e54c8dd82341de6172e2372a5a4188470f4c8dd82341877526e2372a5a413a1160438dd82341586927e2372a5a4198563f3f8dd82341790cdde1372a5a414115023d8dd823412412ffe1372a5a41f8b4093d8dd823414e3951e2372a5a41ed9f8a408dd82341536257e3372a5a41bd5919418dd823418d8b2ee4372a5a419f0804408dd8234105aba9e6372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (987,'os','radius','droit','membre supérieur','immature',X'00016a08000021c968548dd82341b3f89fdf372a5a4189a2226a8dd823419220f4f0372a5a417c0600000003000000690300000001000000160000009ebde0638dd823417111c5ed372a5a41098c6f688dd823418f3a41ed372a5a41f809186a8dd82341689bd5ec372a5a41d27c16648dd82341ad826deb372a5a41b3220b5f8dd823418a89d3e8372a5a41cc6e575f8dd8234182f702e6372a5a4173df1d618dd823412f43d6e2372a5a41f74978628dd823410d0af0e1372a5a41c409d9608dd8234155f7c0e1372a5a41ad8cdb598dd823414c46a5e1372a5a4192e415598dd82341225cbde1372a5a41a77a595a8dd823418eb196e3372a5a417b4e0f5a8dd8234139b2b5e5372a5a4121c968548dd8234198dc38eb372a5a41baccba548dd823412803e8eb372a5a412f3bae578dd82341ba10caec372a5a41b9b86b588dd8234143eb8eed372a5a411249bd558dd8234118d31aee372a5a41ea9db1558dd823414e4ff7ee372a5a415f6899658dd82341046a51ef372a5a416024e0658dd82341b7b8a2ee372a5a419ebde0638dd823417111c5ed372a5a4169030000000100000007000000c7a218578dd82341991a07f0372a5a41b6a7ef5e8dd823419220f4f0372a5a4162c1c2648dd8234150b286f0372a5a41415849678dd823414646d3ef372a5a41b97f7e5a8dd8234150d66cef372a5a41f15d59568dd82341bc33bdef372a5a41c7a218578dd82341991a07f0372a5a416903000000010000000c00000089a2226a8dd8234175f08be0372a5a41961f79688dd823416bd30ce0372a5a41fa2734638dd823415d8b18e0372a5a4100b5c05f8dd82341b3f89fdf372a5a411af6585e8dd823414d141be0372a5a412fb9315b8dd82341b5c602e0372a5a41688932598dd8234168b329e0372a5a41c82991578dd82341aae315e1372a5a41c89fb2588dd82341835e37e1372a5a41dd631f688dd8234185f860e1372a5a41d9ebbf698dd82341403a3fe1372a5a4189a2226a8dd8234175f08be0372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (988,'os','radius','gauche','membre supérieur','immature',X'00016a080000fe9625d88ed82341b3f89fdf372a5a418856dfed8ed823419220f4f0372a5a417c060000000300000069030000000100000007000000ed4d2feb8ed82341991a07f0372a5a41d315efeb8ed82341bc33bdef372a5a41a3cac9e78ed8234150d66cef372a5a414ff9feda8ed823414646d3ef372a5a41e57b85dd8ed8234150b286f0372a5a41777158e38ed823419220f4f0372a5a41ed4d2feb8ed82341991a07f0372a5a4169030000000100000016000000635b67de8ed823417111c5ed372a5a410c3968dc8ed82341b7b8a2ee372a5a41689baedc8ed82341046a51ef372a5a4141a996ec8ed823414e4ff7ee372a5a4194338bec8ed8234118d31aee372a5a419f93dce98ed8234143eb8eed372a5a416f069aea8ed82341ba10caec372a5a4162288ded8ed823412803e8eb372a5a418856dfed8ed8234198dc38eb372a5a41594639e88ed8234139b2b5e5372a5a4126b2eee78ed823418eb196e3372a5a4192cc32e98ed82341225cbde1372a5a41a5dc6ce88ed823414c46a5e1372a5a41f6586fe18ed8234155f7c0e1372a5a41e732d0df8ed823410d0af0e1372a5a41dc602ae18ed823412f43d6e2372a5a41bbcaf0e28ed8234182f702e6372a5a41d5163de38ed823418a89d3e8372a5a41a79c31de8ed82341ad826deb372a5a41af2030d88ed82341689bd5ec372a5a410bf1d8d98ed823418f3a41ed372a5a41635b67de8ed823417111c5ed372a5a416903000000010000000c000000fe9625d88ed8234175f08be0372a5a41729688d88ed82341403a3fe1372a5a41f8fa28da8ed8234185f860e1372a5a41e62796e98ed82341835e37e1372a5a41414fb7ea8ed82341aae315e1372a5a41333916e98ed8234168b329e0372a5a413cb716e78ed82341b5c602e0372a5a418457efe38ed823414d141be0372a5a41f18387e28ed82341b3f89fdf372a5a41ee0514df8ed823415d8b18e0372a5a413c1dcfd98ed823416bd30ce0372a5a41fe9625d88ed8234175f08be0372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (989,'os','ulna','gauche','membre supérieur','immature',X'00016a080000f114c8f18ed82341c7a4c8df372a5a4131104a0b8fd823417c6ae9ee372a5a417c06000000030000006903000000010000000a000000004d77ff8ed8234144a9f5ed372a5a41da2c9bfc8ed82341300c1cee372a5a41db13aaf68ed82341de20c4ed372a5a41f114c8f18ed823415acf17ee372a5a4108ad2cf28ed8234176ccbbee372a5a4147668ff68ed823417c6ae9ee372a5a41a67aeafc8ed823414552abee372a5a41e5f441008fd8234119addfee372a5a414b22b1008fd82341e64f12ee372a5a41004d77ff8ed8234144a9f5ed372a5a416903000000010000000b00000059a933048fd82341db0929e0372a5a416c62aaf78ed82341d62d33e0372a5a41798b01f68ed82341562a6be0372a5a41a8def3f28ed82341c3f98be0372a5a411f3885f48ed823413f342fe1372a5a4127a01df78ed82341f44f66e1372a5a414ddd35088fd82341046656e1372a5a4173d891088fd82341fa7ef0e0372a5a4131104a0b8fd82341768d5ae0372a5a41a20b22098fd82341c7a4c8df372a5a4159a933048fd82341db0929e0372a5a4169030000000100000016000000edaabd018fd82341536257e3372a5a41103d3e058fd823414e3951e2372a5a41140a46058fd823412412ffe1372a5a41eee208038fd82341790cdde1372a5a41b957e8fe8ed82341586927e2372a5a41eef138f68ed82341877526e2372a5a41532963f58ed82341de6172e2372a5a41a9f0d4f98ed82341acca5de4372a5a41fb957bfb8ed82341fd2a40e8372a5a41e4a8b5fa8ed82341f8e6a2e9372a5a41270c5df48ed82341c25e70eb372a5a4163378ff48ed82341b581a6eb372a5a41f1c81af88ed823410c9931ec372a5a41df5b56f68ed82341db1e4ded372a5a41b98f29fb8ed823413bba0ced372a5a41acf9f9fe8ed82341315d38ed372a5a41176ca4ff8ed82341d3841fed372a5a41d95d0aff8ed8234157361cec372a5a411d6205018fd8234192a987ea372a5a418fc244028fd8234105aba9e6372a5a4172712f018fd823418d8b2ee4372a5a41edaabd018fd82341536257e3372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (990,'os','sternèbres','axial','thorax','immature',X'00016a08000022ec56118ed82341cc2c72e1372a5a41b31d08358ed82341dbdcd1f2372a5a417c06000000050000006903000000010000000e0000005d3f352e8ed82341eacdd3eb372a5a4163211e188ed82341eacdd3eb372a5a41aeca4f178ed82341daec25ec372a5a419d1fcd138ed82341408f75ec372a5a4152f535128ed823413abdceec372a5a4122ec56118ed82341eead5cee372a5a413239fc148ed823410bae3eef372a5a41ac0a53318ed82341c1693fef372a5a411c8b8f348ed8234145aa96ee372a5a41b31d08358ed8234137e1e8ed372a5a4115c7fc338ed8234135a5bcec372a5a41b0fc2c308ed823412ab038ec372a5a419d04d72e8ed82341a42c1eec372a5a415d3f352e8ed82341eacdd3eb372a5a416903000000010000000b0000009ad6fa208ed8234114746de2372a5a413d6e801d8ed82341d2f715e3372a5a412c9cac1e8ed82341914077e3372a5a41501373278ed82341883f78e3372a5a415e79a9288ed82341ab844ee3372a5a41e8148d288ed823417f32f7e2372a5a414dd350258ed8234125366ae2372a5a4172eeb1258ed8234182fe9be1372a5a4167ca29238ed82341cc2c72e1372a5a4186f091208ed8234126b6a0e1372a5a419ad6fa208ed8234114746de2372a5a416903000000010000000b000000fc40342e8ed82341723fd6ea372a5a4138fb7c2c8ed823410fc08bea372a5a41c2fea22b8ed8234156d516ea372a5a41bfa63b2c8ed82341094adee8372a5a412fce151a8ed82341f551dee8372a5a419235ac1a8ed82341baee19ea372a5a415f65cb198ed82341cb5d8eea372a5a41df391d188ed823410248d6ea372a5a414bb919188ed82341c9cd1eeb372a5a41f94f372e8ed82341763a1eeb372a5a41fc40342e8ed82341723fd6ea372a5a416903000000010000000e000000f8744c318ed82341d573cfef372a5a4163ab02158ed82341d573cfef372a5a41b6dbad138ed82341c20d8af0372a5a416e10f2158ed823419929fdf0372a5a4155992a168ed82341fa7b96f1372a5a41a3aeee1b8ed8234198bb08f2372a5a4170ec071e8ed82341dbdcd1f2372a5a4149fa49288ed8234167dcd1f2372a5a41789e6c2a8ed82341c41f07f2372a5a41e82128308ed82341c17596f1372a5a41d88062308ed8234131d8fbf0372a5a41af64a3328ed82341ef438af0372a5a4155a1a7318ed82341c2cc1bf0372a5a41f8744c318ed82341d573cfef372a5a416903000000010000000f000000e0cf181a8ed82341f1a148e8372a5a41bfa63b2c8ed82341ec5848e8372a5a4104ac3b2c8ed823416c53d9e7372a5a418996332e8ed823415cce7ae7372a5a4151569f2c8ed823419da497e6372a5a414de7372d8ed823412f7aa1e5372a5a410e6cd92a8ed82341fb863de5372a5a4168d2c7288ed82341dd3a56e4372a5a41a375891d8ed82341e43a56e4372a5a41dc4b721b8ed823414d213fe5372a5a419ca719198ed823415087a1e5372a5a41511fb1198ed82341bff599e6372a5a415c211e188ed82341ebda7ae7372a5a412fce151a8ed823416854d9e7372a5a41e0cf181a8ed82341f1a148e8372a5a41fe');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (991,'os','coxal','droit','ceinture pelvienne','immature',X'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');
INSERT INTO "mannequin" ("id_man","catego","nom","cote","part_anat","ss_catego","geometry") VALUES (992,'os','coxal','gauche','ceinture pelvienne','immature',X'00016a08000004d2f6328ed82341d068a4cc372a5a41045e618b8ed82341768fd4dd372a5a417c06000000050000006903000000010000001c000000daf9506d8ed82341241bb8cf372a5a41602a956d8ed82341657012d0372a5a41cf790d6b8ed8234139688cd0372a5a4133b017658ed82341246205d1372a5a41ae1b5d5d8ed82341768a60d1372a5a416f18105c8ed82341471d9fd1372a5a4114d20d5d8ed823414f45fbd1372a5a412b407c608ed82341a6f17cd2372a5a414c5afb618ed82341b29e4cd3372a5a41c3fbcb6c8ed82341bd4239d3372a5a41efc15d6d8ed823419bfdbfd2372a5a41a55278718ed823419be895d2372a5a41623bb5738ed823417cd220d2372a5a41dcb67c778ed82341c53001d2372a5a41f8c63f798ed82341ac3d9fd1372a5a412133c1798ed82341e80d58d0372a5a41e45475788ed8234194939ece372a5a41fab941778ed82341635c29ce372a5a4157026b748ed823416556b9cd372a5a411055a3708ed823411a5471cd372a5a41d6b047638ed823415b920ccd372a5a419b03ea5b8ed823417d3e1ecd372a5a4174aaae528ed82341fadd71cd372a5a41c3d12c538ed823414ba73ece372a5a41af4995598ed8234134541fce372a5a411a939b5e8ed823418d451ece372a5a4114f416638ed823414c674fce372a5a41daf9506d8ed82341241bb8cf372a5a4169030000000100000017000000937b9f448ed82341894c47d0372a5a41b330ec448ed823412606d0cf372a5a41db6b02478ed82341dd665acf372a5a413c686a4e8ed8234122cabcce372a5a411832b94e8ed8234141c838ce372a5a414079ca4d8ed8234138bbeacd372a5a41e8140a438ed82341638fcace372a5a4133da3e368ed8234108d488cf372a5a4104d2f6328ed8234193c14bd1372a5a4124efe2338ed8234134e0a5d1372a5a41abaa19368ed82341d011e7d1372a5a410c9aca438ed82341b79f5dd2372a5a41b52234578ed82341e5ad40d3372a5a41ebdea65b8ed8234123bf4bd3372a5a41983be45b8ed82341a17615d3372a5a418cb8c1598ed82341e94b91d2372a5a411b84c15a8