/*

BADASS : Base Archéologique de Données Attributaires et SpatialeS

Auteurs : Caroline Font, Thomas Guillemard, Florent Mercey, Christelle Seng (cheffe d'orchestre). Inrap, 2023.
			Pour les tables liées à la photogrammétrie : Camille Mangier, Rachid El-Hajaoui
			Avec la collaboration de Mathias Cunault, Clément Féliu, Bertrand Houdusse

MAJ 2023 : ajouts de tables de gestion d'équipe, inscriptions des relations dans le code, ajout des tables fantômes pour les références géographiques des vues géométriques et ajouts de plusieurs vues, dont vues géométriques.

*/

PRAGMA encoding='UTF-8';

-- LES 6 COUCHES

-- EMPRISE : unité technique ; emprise de l’opération
DROP TABLE IF EXISTS emprise; -- Supprime la table (et ses données) si elle existe déjà. 
CREATE TABLE emprise(
   "id_emprise" INTEGER PRIMARY KEY,
   "numope" TEXT,
   "nomope" TEXT,
   "typope" TEXT,
   "typemp" TEXT,
   "numoa" TEXT,
   "numprescr" TEXT,
   "ro" TEXT,
   "annee" INTEGER,
   "surface" FLOAT,
   "gid_caviar" INTEGER --clé primaire dans Caviar
);
SELECT 
AddGeometryColumn ('emprise','geometry',2154,'MULTIPOLYGON','XY',0); -- ajoute la colonne geométrie. Attention, fonction de Spatialite uniquement !!! 

-- OUVERTURE : unité technique : tout creusement réalisé à des fins d’observation (sondage, tranchée, décapage...)
DROP TABLE IF EXISTS ouverture;
CREATE TABLE ouverture(
   "id_ouverture" INTEGER PRIMARY KEY,
   "numouvert" TEXT,
   "typouvert" TEXT,
   "surface" FLOAT,
   "date_leve" INTEGER
);
SELECT 
AddGeometryColumn ('ouverture','geometry',2154,'MULTIPOLYGON','XY',0);

-- POLY : unité d’observation archéologique représentée sous forme de polygone (us, fait, ens...)
DROP TABLE IF EXISTS poly;
CREATE TABLE poly(
   "id_poly" INTEGER PRIMARY KEY,
   "numpoly" INTEGER,
   "typoly" TEXT,
   "interpret" TEXT,
   "datedebut" INTEGER,
   "datefin" INTEGER,
   "date_leve" INTEGER
);
SELECT 
AddGeometryColumn ('poly','geometry',2154,'MULTIPOLYGON','XY',0);

-- POINT : unité d’observation archéologique représentée sous forme de point (isolat...)
DROP TABLE IF EXISTS point;
CREATE TABLE point(
   "id_point" INTEGER PRIMARY KEY,
   "numpoint" INTEGER UNIQUE,
   "typoint" TEXT,
   "interpret" TEXT,
   "datedebut" INTEGER,
   "datefin" INTEGER,
   "z_point" FLOAT,
   "date_leve" INTEGER
);
SELECT 
AddGeometryColumn ('point','geometry',2154,'POINT','XY',0);

-- AXE : unité technique matérialisant l’axe de coupe, sous forme de ligne
DROP TABLE IF EXISTS axe;
CREATE TABLE axe(
   "id_axe" INTEGER PRIMARY KEY,
   "numaxe" TEXT,
   "typaxe" TEXT,
   "z_axe" FLOAT,
   "long_axe" FLOAT,
   "date_leve" INTEGER
);
SELECT 
AddGeometryColumn ('axe','geometry',2154,'LINESTRING','XY',0);

-- LOG : unité technique ponctuelle localisant l’emplacement des prélèvements, des logs géomorphologiques (lieux d’observation ponctuels)
DROP TABLE IF EXISTS log;
CREATE TABLE log(
   "id_log" INTEGER PRIMARY KEY,
   "numlog" TEXT,
   "typlog" TEXT,
   "alti" FLOAT,
   "typalti" TEXT,
   "date_leve" INTEGER
);
SELECT 
AddGeometryColumn ('log','geometry',2154,'POINT','XY',0);

-- PTS_TOPO : unité technique ponctuelle localisant l’emplacement de l'ensemble des points levés par le topographe
DROP TABLE IF EXISTS pts_topo;
CREATE TABLE pts_topo(
   "id_ptopo" INTEGER PRIMARY KEY,
   "m" TEXT,
   "x" FLOAT,
   "y" FLOAT,
   "z" FLOAT,
   "code" TEXT,
   "method_acquisition" TEXT,
   "creator" TEXT,
   "date_leve" INTEGER, -- à saisir sous la forme yymmdd (ex : 230212 pour 12 février 2023)
   "note" TEXT
);
SELECT 
AddGeometryColumn ('pts_topo','geometry',2154,'POINT','XYZ',0);

-- LES COUPES DANS QGIS : tables nécessaires pour réaliser les coupes des faits dans QGIS (Caro POWAAAAA)

-- La table coupe_axe
DROP TABLE IF EXISTS coupe_axe;
CREATE TABLE coupe_axe(
   "id_coupe" INTEGER PRIMARY KEY,
   "id_axe" INTEGER REFERENCES t_axe("id_axe") DEFAULT NULL,
   "numaxe" INTEGER,
   "numinute" INTEGER,
   "azimuth" FLOAT,
   "alti" FLOAT,
   "note" TEXT	
);
SELECT 
AddGeometryColumn ('coupe_axe','geometry',2154,'LINESTRING','XY',0);

-- La table coupe_line
DROP TABLE IF EXISTS coupe_line;
CREATE TABLE coupe_line(
   "id_cpline" INTEGER PRIMARY KEY,
   "id_axe" INTEGER REFERENCES t_axe("id_axe") DEFAULT NULL,
   "numfait" INTEGER REFERENCES t_fait("numfait") DEFAULT NULL,
   "numus" INTEGER REFERENCES t_us("numus") DEFAULT NULL,
   "typline" TEXT,
   "numsd" INTEGER REFERENCES t_sondage("numsd") DEFAULT NULL,
   "note" TEXT
);
SELECT 
AddGeometryColumn ('coupe_line','geometry',2154,'MULTILINESTRING','XY',0); -- mieux vaut prévoir une géométrie multiple dans le cas où une US négative serait interrompue (sondage, perturbation diverse)

-- La table coupe_poly
DROP TABLE IF EXISTS coupe_poly;
CREATE TABLE coupe_poly(
   "id_cpoly" INTEGER PRIMARY KEY,
   "id_axe" INTEGER REFERENCES t_axe("id_axe") DEFAULT NULL,
   "numfait" INTEGER REFERENCES t_fait("numfait") DEFAULT NULL,
   "numus" INTEGER REFERENCES t_us("numus") DEFAULT NULL,
   "typoly" TEXT,
   "detail" TEXT,
   "numsd" INTEGER REFERENCES t_sondage("numsd") DEFAULT NULL,
   "note" TEXT
);
SELECT 
AddGeometryColumn ('coupe_poly','geometry',2154,'MULTIPOLYGON','XY',0);

-- Quelques tables de gestion des équipes
-- Table de liste des personnels de l'équipe
DROP TABLE IF EXISTS t_equipe;
CREATE TABLE t_equipe(
   "id_equipe" INTEGER PRIMARY KEY,
   "prenom" TEXT,
   "nom" TEXT,
   "fonction" TEXT); --cf thésaurus

--Table de liste des tâches attribuées
DROP TABLE IF EXISTS t_tache;
CREATE TABLE t_tache(
   "id_tache" INTEGER PRIMARY KEY,
   "tache" TEXT);

--Les tâches possibles, ajouter les diverses études spécifiques à l'opération
INSERT INTO "t_tache" ("id_tache","tache") VALUES (1,'responsable scientifique');
INSERT INTO "t_tache" ("id_tache","tache") VALUES (2,'prescription et contrôle scientifique');
INSERT INTO "t_tache" ("id_tache","tache") VALUES (3,'montage du projet et suivi scientifique');
INSERT INTO "t_tache" ("id_tache","tache") VALUES (4,'mise en place et suivi de l''opération');
INSERT INTO "t_tache" ("id_tache","tache") VALUES (5,'montage du projet');
INSERT INTO "t_tache" ("id_tache","tache") VALUES (6,'archivage et mise à disposition des données numériques');
INSERT INTO "t_tache" ("id_tache","tache") VALUES (7,'fouille');
INSERT INTO "t_tache" ("id_tache","tache") VALUES (8,'photographie');
INSERT INTO "t_tache" ("id_tache","tache") VALUES (9,'enregistrement des données');
INSERT INTO "t_tache" ("id_tache","tache") VALUES (10,'relevé archéologique');
INSERT INTO "t_tache" ("id_tache","tache") VALUES (11,'levé topographique');
INSERT INTO "t_tache" ("id_tache","tache") VALUES (12,'coordination scientifique');
INSERT INTO "t_tache" ("id_tache","tache") VALUES (13,'rédaction');
INSERT INTO "t_tache" ("id_tache","tache") VALUES (14,'traitement primaire du mobilier');
INSERT INTO "t_tache" ("id_tache","tache") VALUES (15,'saisie des données d''enregistrement');
INSERT INTO "t_tache" ("id_tache","tache") VALUES (16,'dessin assisté par ordinateur');
INSERT INTO "t_tache" ("id_tache","tache") VALUES (17,'infographie');
INSERT INTO "t_tache" ("id_tache","tache") VALUES (18,'exploitation de système d''informations géographiques');
INSERT INTO "t_tache" ("id_tache","tache") VALUES (19,'mise en page du rapport');


--Tables de jonctions entre personnels et tâches
DROP TABLE IF EXISTS j_equipe_tache;
CREATE TABLE j_equipe_tache(
   "id_equipe_tache" INTEGER PRIMARY KEY,
   "id_equipe" INTEGER REFERENCES t_equipe("id_equipe") DEFAULT NULL,
   "id_tache" INTEGER REFERENCES t_tache("id_tache") DEFAULT NULL
   );

--Tables de jonctions entre personnels et autres tables référençant un ou plusieurs auteurs
DROP TABLE IF EXISTS j_equipe;
CREATE TABLE j_equipe(
   "id_jequipe" INTEGER PRIMARY KEY,
   "id_us" INTEGER REFERENCES t_us("id_us") DEFAULT NULL,
   "id_photo" INTEGER REFERENCES t_photo("id_photo") DEFAULT NULL,
   "id_minut" INTEGER REFERENCES t_minute("id_minut") DEFAULT NULL,
   "id_prel" INTEGER REFERENCES t_prelevement("id_prel") DEFAULT NULL,
   "id_photogram" INTEGER REFERENCES t_photogram("id_photogram") DEFAULT NULL
);


-- LA BASE ARCHEO : les tables des faits, sondage, us, etc. La géométrie peut être associée. 

-- FAIT : la table des faits archéologique qui récupère la géométrie par trigger de la table poly (6 couches) pour "typoly" LIKE 'fait'
DROP TABLE IF EXISTS t_fait;
CREATE TABLE t_fait(
   "id_fait" INTEGER PRIMARY KEY,
   "numfait" INTEGER UNIQUE,
   "interpret_alter" TEXT,
   "interpret" TEXT,
   "douteux" INTEGER,
   "equiv_diag" TEXT,
   "statut" TEXT,
   "rais_annule" TEXT,
   "fouille" TEXT,
   "enr_fini" INTEGER,
   "relev_fini" INTEGER,
   "photo_fini" INTEGER,
   "topo_fini" INTEGER,
   "profil" TEXT,
   "forme" TEXT,
   "orient" TEXT,
   "orient_calc" FLOAT,
   "descrip" TEXT,
   "prof_app" FLOAT,
   "diam" FLOAT,
   "dim_max" FLOAT,
   "dim_min" FLOAT,
   "epais" FLOAT,
   "prof_haut" FLOAT,
   "periode" TEXT,
   "note" TEXT
);
SELECT 
AddGeometryColumn ('t_fait','geometry',2154,'MULTIPOLYGON','XY',0);

-- US : unité stratitgraphique qui récupère la géométrie par trigger de la table poly (6 couches) pour "typoly" LIKE 'us'
DROP TABLE IF EXISTS t_us;
CREATE TABLE t_us(
   "id_us" INTEGER PRIMARY KEY,
   "numus" INTEGER UNIQUE,
   "numfait" INTEGER REFERENCES t_fait("numfait") DEFAULT NULL,
   "type_us" TEXT,
   "nature_us" TEXT,
   "interpret" TEXT, -- liste de valeurs : avec notamment les valeurs OTD 'dépôt inhumation primaire' et  'dépôt inhumation non primaire' et 'contenant inhumation'
   "description" TEXT,
   "datsup_interpret" INTEGER,
   "datinf_interpret" INTEGER,
   "datsup_mobilier" INTEGER,
   "datinf_mobilier" INTEGER,
   "datsup_14c" INTEGER,
   "datinf_14c" INTEGER,
   "note_dat" TEXT,
   "forme" TEXT,
   "diam" FLOAT,
   "dim_max" FLOAT,
   "dim_min" FLOAT,
   "prof_app" FLOAT,
   "zmin" FLOAT,
   "zmax" FLOAT,
   "epais" FLOAT,
   "compo_sediment" TEXT,
   "texture" TEXT,
   "couleur" TEXT,
   "valeur_couleur" TEXT,
   "creator" TEXT,
   "datcreation" DATE,
   "note" TEXT,
   "num_seq" INTEGER REFERENCES t_seq("numseq") DEFAULT NULL,
   "ordre_seq" INTEGER
);
SELECT 
AddGeometryColumn ('t_us','geometry',2154,'MULTIPOLYGON','XY',0);

-- ENSEMBLE : les ensembles regroupant des faits et/ou des us (bâtiment...)
DROP TABLE IF EXISTS t_ens;
CREATE TABLE t_ens(
   "id_ens" INTEGER PRIMARY KEY,
   "numens" INTEGER UNIQUE,
   "typens" TEXT, -- liste de valeurs Thesaurus (archéo, technique...)
   "interpret" TEXT, -- liste de valeurs
   "description" TEXT,
   "note" TEXT,
   "ens_englob" INTEGER -- renvoie vers le num d'un super ensemble qui englobe l'entité (et d'autres...)
   );
SELECT 
AddGeometryColumn ('t_ens','geometry',2154,'MULTIPOLYGON','XY',0);

-- SONDAGE : pour les ouvertures (unité technique) de type sondage qui récupère la géométrie par trigger de la table ouverture (6 couches) pour "typouvert" LIKE 'sondage'
DROP TABLE IF EXISTS t_sondage;
CREATE TABLE t_sondage(
   "id_sd" INTEGER PRIMARY KEY,
   "numsd" INTEGER UNIQUE,
   "numtr" INTEGER REFERENCES t_tranchee("numtr") DEFAULT NULL,
   "type" TEXT,
   "prof" FLOAT,
   "note" TEXT
);
SELECT 
AddGeometryColumn ('t_sondage','geometry',2154,'MULTIPOLYGON','XY',0);

--TRANCHEE : pour les ouvertures (unité technique) de type tranchée qui récupère la géométrie par trigger de la table ouverture (6 couches) pour "typouvert" LIKE 'tranchée'
DROP TABLE IF EXISTS t_tranchee;
CREATE TABLE t_tranchee(
   "id_tr" INTEGER PRIMARY KEY,
   "numtr" INTEGER UNIQUE,
   "long" FLOAT,
   "larg" FLOAT,
   "surface" FLOAT,
   "prof_max" FLOAT,
   "prof_min" FLOAT,
   "note" TEXT
   );
SELECT 
AddGeometryColumn('t_tranchee','geometry',2154,'MULTIPOLYGON','XY',0);

-- PHOTO : les photographies numériques (pas de géométrie)
DROP TABLE IF EXISTS t_photo;
CREATE TABLE t_photo(
   "id_photo" INTEGER PRIMARY KEY,
   "numphoto" INTEGER UNIQUE, -- numéro de 1 à n enregistré par l'archéo
   "nomfichier" TEXT, -- le nom du fichier photo avec son extension (attention à la casse)
   "chemin_url" TEXT, -- chemin d'accès du fichier
   "legend" TEXT, -- peut correspondre au titre de la figure dans le rapport
   "vue_vers" TEXT, -- liste de valeurs
   "creator" TEXT, -- liste de valeurs
   "datephoto" TEXT, -- date du cliché
   "type" TEXT, -- coupe, plan, mobilier, ambiance....
   "support" TEXT, -- numérique, argentique...
   "destination" TEXT, -- rapport, valorisation, publi...
   "note" TEXT
);

-- MINUTE : les relevés de terrain sur minute de chantier (pas de géométrie)
DROP TABLE IF EXISTS t_minute;
CREATE TABLE t_minute(
   "id_minut" INTEGER PRIMARY KEY,
   "numinute" INTEGER UNIQUE,
   "descr" TEXT,
   "echelle" TEXT,
   "contenu" TEXT,
   "creator" TEXT,
   "format" TEXT,
   "support" TEXT,
   "chemin_url" TEXT,
   "scan" INTEGER, -- booléen
   "min_dao" INTEGER, -- booléen
   "note" TEXT,
   "id_photogram" INTEGER REFERENCES t_photogram("id_photogram") DEFAULT NULL -- renvoie à l'id du modèle 3D 
);

-- MOBILIER : CETTE TABLE EST A REVOIR COMPLETEMENT
DROP TABLE IF EXISTS t_mobilier;
CREATE TABLE t_mobilier( 
   "id_mob" INTEGER PRIMARY KEY,
   "numiso" INTEGER UNIQUE,
   "numpoint" INTEGER REFERENCES point("numpoint") DEFAULT NULL,
   "numus" INTEGER REFERENCES t_us("numus") DEFAULT NULL,
   "numfait" INTEGER REFERENCES t_fait("numfait") DEFAULT NULL,
   "iso_lot" TEXT, -- soit iso, soit lot
   "iso_ident" TEXT,
   "iso_ssident" TEXT, -- à repenser !!!!!!!!!!!!!!!!!!!!
   "matiere" TEXT, -- hérité de OTD à repenser !!!!!!!!!!!!!!!!!!!! CADoc : 3 champs "matiere", "identification" et "categorie" (cf Instrumentum 2013)
   "catego" TEXT, -- à repenser !!!!!!!!!!!!!!!!!!!!
   "sscatego" TEXT, -- à repenser !!!!!!!!!!!!!!!!!!!
   "alt" FLOAT,
   "dim_min" FLOAT,
   "dim_max" FLOAT,
   "diam" FLOAT,
   "epaiss" FLOAT,
   "masse" FLOAT,
   "nr" INTEGER, -- nombre de restes
   "pr" INTEGER, -- poids des restes
   "etatcons" TEXT,
   "note" TEXT,
   "datesup" INTEGER,
   "dateinf" INTEGER,
   "dat_note" TEXT
 );
SELECT 
AddGeometryColumn ('t_mobilier','geometry',2154,'POINT','XY',0);

-- SEQUENCE : regroupement des US en séquences stratigraphiques (pas de géométrie)
DROP TABLE IF EXISTS t_seq;
CREATE TABLE t_seq(
   "numseq" INTEGER PRIMARY KEY,
   "titre" TEXT,
   "datation" TEXT,
   "crit_dat" TEXT, -- éléments sur lesquels se base la datation
   "note" TEXT
);

-- PHASE : regroupement des séquences en phases chrono-stratigraphiques (pas de géométrie)
DROP TABLE IF EXISTS t_phase;
CREATE TABLE t_phase(
   "id_phase" INTEGER PRIMARY KEY,
   "numphase" INTEGER UNIQUE,
   "titre" TEXT,
   "datation" TEXT,
   "tpq" INTEGER,
   "taq" INTEGER,
   "note" TEXT -- précision sur la nature de la phase, sur la datation...
);

-- PERIODE : regroupement des phases en périodes chronologiques (pas de géométrie)
DROP TABLE IF EXISTS t_periode;
CREATE TABLE t_periode(
   "id_period" INTEGER PRIMARY KEY,
   "numperiod" INTEGER UNIQUE,
   "titre" TEXT,
   "datation" TEXT,
   "date_inf" INTEGER,
   "date_sup" INTEGER,
   "note" TEXT
);

-- LOG : les logs enregistrés/décrits sur le terrain qui récupère la géométrie par trigger de la table plog (6 couches)
DROP TABLE IF EXISTS t_log; 
CREATE TABLE t_log(
   "id_log" INTEGER PRIMARY KEY,
   "numlog" INTEGER UNIQUE,
   "numtr" INTEGER REFERENCES t_tranchee("numtr") DEFAULT NULL,
   "numsd" INTEGER REFERENCES t_sondage("numsd") DEFAULT NULL,
   "alti" FLOAT,
   "prof_log" FLOAT,
   "zmin_log" FLOAT,
   "objectif_log" TEXT,
   "note_log" TEXT,
   "numaxe" INTEGER REFERENCES t_axe("numaxe") DEFAULT NULL -- dans le cas par exemple d'un transect 
);
SELECT 
AddGeometryColumn ('t_log','geometry',2154,'POINT','XY',0);

-- PRELEVEMENTS : pour enregistrer les prélèvements
DROP TABLE IF EXISTS t_prelevement;
CREATE TABLE t_prelevement( 
   "id_prel" INTEGER PRIMARY KEY,
   "numprel" INTEGER UNIQUE,
   "numus" INTEGER REFERENCES t_us("numus") DEFAULT NULL,
   "numfait" INTEGER REFERENCES t_fait("numfait") DEFAULT NULL,
   "type" TEXT,
   "alti" FLOAT,
   "objectif" TEXT,
   "volume" FLOAT,
   "contenant" TEXT,
   "creator" TEXT,
   "note" TEXT
 );
SELECT 
AddGeometryColumn ('t_prelevement','geometry',2154,'POINT','XY',0);


-- AXE : les axes de relevé de plan et/ou coupe effectués sur le terrain qu'il peut être nécessaire d'enregistrer (en relation de n à n avec fait, us, sd, tr)
DROP TABLE IF EXISTS t_axe;
CREATE TABLE t_axe(
   "id_axe" INTEGER PRIMARY KEY,
   "numaxe" INTEGER UNIQUE,
   "note" TEXT,
   "long" FLOAT,
   "alti" FLOAT
);
SELECT 
AddGeometryColumn ('t_axe','geometry',2154,'LINESTRING','XY',0);

-- TABLE DE RELATION / JOINCTION / JOINTURE (de 1 à n, permettant la relation de n à n entre deux tables utiles comme t_fait et t_photo)

-- gestion de la relation entre les axes et les sujets du relevé (faits, us, sd, tr)
DROP TABLE IF EXISTS j_rel_axe;
CREATE TABLE j_rel_axe(
   "id_rel_axe" INTEGER PRIMARY KEY,
   "numaxe" INTEGER REFERENCES t_axe("numaxe") DEFAULT NULL,
   "numfait" INTEGER REFERENCES t_fait("numfait") DEFAULT NULL,
   "numus" INTEGER REFERENCES t_us("numus") DEFAULT NULL,
   "numsd" INTEGER REFERENCES t_sondage("numsd") DEFAULT NULL,
   "numtr" INTEGER REFERENCES t_tranchee("numtr") DEFAULT NULL
);

-- gestion de la relation entre les US et les LOG, cette table permet de générer les box par US des logs automatiquement dans QGIS
DROP TABLE IF EXISTS j_us_log;
CREATE TABLE j_us_log(
   "id_us_log" INTEGER PRIMARY KEY,
   "numus" INTEGER REFERENCES t_us("numus") DEFAULT NULL,
   "numlog" INTEGER REFERENCES t_log("numlog") DEFAULT NULL,
   "prof_toit" FLOAT,
   "prof_base" FLOAT,
   "epais_uslog" FLOAT,
   "zmax_uslog" FLOAT,
   "zmin_uslog" FLOAT,
   "commentaire" TEXT
);

-- gestion de la relation, les US (relation stratigraphique inter-US)
DROP TABLE IF EXISTS j_rel_us;
CREATE TABLE j_rel_us(
   "id_rel_us" INTEGER PRIMARY KEY,
   "numus1" INTEGER REFERENCES t_us("numus") DEFAULT NULL,
   "numus2" INTEGER REFERENCES t_us("numus") DEFAULT NULL,
   "typrel" TEXT,
   "incert" INTEGER, -- 0 = sûre ; 1 = incertain
   "naturelat" TEXT -- selon Desachy 2008 : rupture, continuité, indéfinie
);

-- gestion de la relation, les faits (relation stratigraphique inter-faits)
DROP TABLE IF EXISTS j_rel_fait;
CREATE TABLE j_rel_fait(
   "id_rel_fait" INTEGER PRIMARY KEY,
   "numfait1" INTEGER REFERENCES t_fait("numfait") DEFAULT NULL,
   "numfait2" INTEGER REFERENCES t_fait("numfait") DEFAULT NULL,
   "typrel" TEXT,
   "incert" INTEGER,
   "naturelat" TEXT -- selon Desachy 2008 : rupture, continuité, indéfinie
);

-- gestion de la relation entre les sondages et les US, faits et logs
DROP TABLE IF EXISTS j_rel_sondage;
CREATE TABLE j_rel_sondage(
   "id_rel_sd" INTEGER PRIMARY KEY,
   "numsd" INTEGER REFERENCES t_sondage("numsd") DEFAULT NULL,
   "numus" INTEGER REFERENCES t_us("numus") DEFAULT NULL,
   "numlog" INTEGER REFERENCES t_log("numlog") DEFAULT NULL,
   "numfait" INTEGER REFERENCES t_fait("numfait") DEFAULT NULL
);

-- gestion de la relation entre les tranchées et les US, faits et les logs
DROP TABLE IF EXISTS j_rel_tranchee;
CREATE TABLE j_rel_tranchee(
   "id_rel_tr" INTEGER PRIMARY KEY,
   "numtr" INTEGER REFERENCES t_tranchee("numtr") DEFAULT NULL,
   "numus" INTEGER REFERENCES t_us("numus") DEFAULT NULL,
   "numfait" INTEGER REFERENCES t_fait("numfait") DEFAULT NULL,
   "numlog" INTEGER REFERENCES t_log("numlog") DEFAULT NULL
);

--gestion de la relation entre les ensembles et les US et faits
DROP TABLE IF EXISTS j_rel_ens;
CREATE TABLE j_rel_ens(
   "id_rel_ens" INTEGER PRIMARY KEY,
   "numens1" INTEGER REFERENCES t_ens("numens") DEFAULT NULL,
   "numens2" INTEGER REFERENCES t_ens("numens") DEFAULT NULL,
   "numus" INTEGER REFERENCES t_us("numus") DEFAULT NULL,
   "numfait" INTEGER REFERENCES t_fait("numfait") DEFAULT NULL,
   "typrel" TEXT,
   "incert" INTEGER
);

-- gestion de la relation entre les séquences et les phases
DROP TABLE IF EXISTS j_seq_phase;
CREATE TABLE j_seq_phase(
   "id_rel_phase" INTEGER PRIMARY KEY,
   "numseq" INTEGER REFERENCES t_seq("numseq") DEFAULT NULL,
   "numphase" INTEGER REFERENCES t_phase("numphase") DEFAULT NULL,
   "ordre" INTEGER -- ordre de la séquence dans la phase
);

-- gestion de la relation les phases et les périodes
DROP TABLE IF EXISTS j_phase_per;
CREATE TABLE j_phase_per(
   "id_rel_periode" INTEGER PRIMARY KEY,
   "numphase" INTEGER REFERENCES t_phase("numphase") DEFAULT NULL,
   "numperiod" INTEGER REFERENCES t_periode("numperiod") DEFAULT NULL,
   "ordre" INTEGER -- ordre éventuel de la phase dans la période
);

-- gestion de la relation entre les minutes de terrain et les US, faits, ensembles, les axes, isolats, les sondages et tranchées
DROP TABLE IF EXISTS j_rel_minute;
CREATE TABLE j_rel_minute(
   "id_rel_minute" INTEGER PRIMARY KEY,
   "numinute" INTEGER REFERENCES t_minute("numinute") DEFAULT NULL,
   "numsd" INTEGER REFERENCES t_sondage("numsd") DEFAULT NULL,
   "numtr" INTEGER REFERENCES t_tranchee("numtr") DEFAULT NULL,
   "numens" INTEGER REFERENCES t_ens("numens") DEFAULT NULL,
   "numfait" INTEGER REFERENCES t_fait("numfait") DEFAULT NULL,
   "numus" INTEGER REFERENCES t_us("numus") DEFAULT NULL,
   "numiso" INTEGER REFERENCES t_mobilier("numiso") DEFAULT NULL,
   "numlog" INTEGER REFERENCES t_log("numlog") DEFAULT NULL,
   "numaxe" INTEGER REFERENCES t_axe("numaxe") DEFAULT NULL
);

--gestion de la relation entre les photos et les US, faits, les ensembles et isolats et les sondages et tranchées
DROP TABLE IF EXISTS j_rel_photo;
CREATE TABLE j_rel_photo(
   "id_rel_photo" INTEGER PRIMARY KEY,
   "numphoto" INTEGER REFERENCES t_photo("numphoto") DEFAULT NULL,
   "numsd" INTEGER REFERENCES t_sondage("numsd") DEFAULT NULL,
   "numtr" INTEGER REFERENCES t_tranchee("numtr") DEFAULT NULL,
   "numens" INTEGER REFERENCES t_ens("numens") DEFAULT NULL,
   "numfait" INTEGER REFERENCES t_fait("numfait") DEFAULT NULL,
   "numus" INTEGER REFERENCES t_us("numus") DEFAULT NULL, -- clé étrangère à spécifier lorsque la photo représente un lot de mobilier
   "numiso" INTEGER REFERENCES t_mobilier("numiso") DEFAULT NULL,
   "numlog" INTEGER REFERENCES t_log("numlog") DEFAULT NULL,
   "id_photogram" INTEGER REFERENCES t_photogram("id_photogram") DEFAULT NULL
);

-- PHOTOGRAMMETRIE : permet le suivi des prises de vues et des traitements photogrammétriques
DROP TABLE IF EXISTS t_photogram;
CREATE TABLE t_photogram(
-- Suivi des prises de vues 
	"id_photogram" INTEGER PRIMARY KEY, -- clé primaire
	"marqueAPN" TEXT, -- marque appareil photo thesaurus
	"modelcam" TEXT, -- modèle d'appareil photo thesaurus 
	"larg_captmm" FLOAT, -- largeur du capteur en mm
	"haut_captmm" FLOAT, -- hauteur du capteur en mm
	"larg_impx" INTEGER, -- largeur de l'image en px
	"haut_impx" INTEGER, -- hauteur de l'image en px
	"iso" INTEGER, -- iso de l'APN
	"ouverture" TEXT, -- ouverture de l'APN
	"focale" INTEGER, -- focale de l'APN
	"wb" TEXT, -- balance des blancs 
	"modecam" TEXT, -- mode de l'APN lors des prises de vues, multivarié (manuel, priorité ouverture, priorité vitesse, automatique)
	"obj_model" TEXT, -- multivarié, objectif(s) du modèle (calibration, ortho zenithale, ortho coupe, mns, profils)
-- Suivi du traitement
	"legend" TEXT, -- description du ou des sujet(s) de la scène aussi bref et limpide que possible
	"nomodel" TEXT, -- nom du modèle (concaténation d'un prefixe, id_photogram, legend)
	"urljob" TEXT, -- url du dossier de travail
	"datemodel" DATE, -- date du début du traitement du modèle
	"creator" TEXT,-- auteur du traitement d'après liste de valeurs
	"convers" INTEGER, -- étape de conversion raw réalisée = 1
	"calib" INTEGER, -- étape de calibration réalisée = 1
	"aerotr" INTEGER, -- étape d'aérotriangulation réalisée = 1
	"georef" INTEGER, -- étape géoréférencement réalisée = 1
	"nuagedense" INTEGER, -- nombre de nuage dense crées 
	"mns" INTEGER, -- nombre de mns crées
	"orthoimage" INTEGER, -- nombre d'orthoimages créees
	"maillage" INTEGER, -- nombre de maillages crées
	"texture" INTEGER, -- nombre de textures créees
	"comment" TEXT -- commentaires sur les étapes de calcul (erreur, réussites etc.)
);
SELECT 
AddGeometryColumn('t_photogram','geometry',2154,'MULTIPOLYGON','XYZ',0); -- correspond à l'emprise du modèle

-- table de relation (n à n) entre la table de modèle 3d (t_photogram) et une table de points topo
DROP TABLE IF EXISTS j_rel_photogram;
CREATE TABLE j_rel_photogram(
	"id_rel_photogram" INTEGER PRIMARY KEY, -- clé primaire
	"id_photogram" INTEGER REFERENCES t_photogram("id_photogram") DEFAULT NULL, -- id du modèle
	"id_ptopo" INTEGER REFERENCES pts_topo("id_ptopo") DEFAULT NULL -- ce champ est une clé étrangère vers la table de points topo
);

DROP TABLE IF EXISTS t_prodphotogram;
CREATE TABLE t_prodphotogram(
	"id_prodphotogram" INTEGER PRIMARY KEY,
	"id_photogram" INTEGER  REFERENCES t_photogram("id_photogram") DEFAULT NULL, -- id du modèle
	"url_prod" TEXT, -- chemin vers le produit
	"nomprod" TEXT, -- nom du produit
	"typrod" TEXT, -- multivarié (orthoimage, mns, nuage de points etc.)
	"note" TEXT  --(orthoimage, mns, nuage de points etc.)
);	
SELECT 
AddGeometryColumn('t_prodphotogram','geometry',2154,'MULTIPOLYGON','XYZ',0); -- correspond à l'emprise du produit issu du traitement photogrammétrique

/*Les tables fantômes de géométrie pour les vues avec géométrie*/
--multipolygon
DROP TABLE IF EXISTS ghost_polygon_2154; -- Supprime la table (et ses données) si elle existe déjà. 
CREATE TABLE ghost_polygon_2154(
   "id" INTEGER PRIMARY KEY
);
SELECT 
AddGeometryColumn ('ghost_polygon_2154','geometry',2154,'MULTIPOLYGON','XY',0);

--multipolyline
DROP TABLE IF EXISTS ghost_polyline_2154; -- Supprime la table (et ses données) si elle existe déjà. 
CREATE TABLE ghost_polyline_2154(
   "id" INTEGER PRIMARY KEY
);
SELECT 
AddGeometryColumn ('ghost_polyline_2154','geometry',2154,'MULTILINESTRING','XY',0);

--point
DROP TABLE IF EXISTS ghost_point_2154; -- Supprime la table (et ses données) si elle existe déjà. 
CREATE TABLE ghost_point_2154(
   "id" INTEGER PRIMARY KEY
);
SELECT 
AddGeometryColumn ('ghost_point_2154','geometry',2154,'POINT','XY',0);



----------------------------------------------------------------------------------------------------------------------
-- THESAURUS : rassemble les termes des listes de valeurs
DROP TABLE IF EXISTS thesaurus_badass;
CREATE TABLE thesaurus_badass(
   "id_thes" INTEGER PRIMARY KEY,
   "tabl_thes" TEXT, -- table où on trouve le champs qui propose la valeurs
   "field_thes" TEXT, -- champ qui propose le terme en liste de valeurs
   "val_thes" TEXT, -- il s'agit de la valeur / terme / modalité
   "def_thes" TEXT, -- si possible, définition du terme 
   "cat_thes" TEXT, -- catégorie de regroupement des termes    
   "comment" TEXT -- observations diverses
);

-- les valeurs du thésaurus
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (1,NULL,'couleur','blanc',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (2,NULL,'couleur','noir',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (3,NULL,'couleur','bleu',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (4,NULL,'couleur','rouge',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (5,NULL,'couleur','jaune',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (6,NULL,'couleur','vert',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (7,NULL,'couleur','beige',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (8,NULL,'couleur','gris',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (9,NULL,'couleur','brun',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (10,NULL,'couleur','orange',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (11,NULL,'forme','circulaire',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (12,NULL,'forme','ovale',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (13,NULL,'forme','quadrangulaire',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (14,NULL,'forme','carré',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (15,NULL,'forme','indéterminée',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (16,NULL,'forme','irrégulière',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (17,NULL,'forme','oblongue',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (18,NULL,'forme','rectiligne',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (19,NULL,'forme','incomplète',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (20,NULL,'forme','trapézoiïdale',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (21,NULL,'forme','anthropomorphe',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (22,NULL,'forme','banquette',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (23,NULL,'forme','non visible',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (24,'t_fait','fouille','50 %',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (25,'t_fait','fouille','100 %',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (26,'t_fait','fouille','sondage',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (27,'t_us','interpret','terre végétale',NULL,NULL,'ne pas modifier, nécessaire au fonctionnement');
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (28,'t_us','interpret','dépôt primaire inhumation',NULL,NULL,'ne pas modifier, nécessaire au fonctionnement');
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (29,'t_us','interpret','dépôt non primaire inhumation',NULL,NULL,'ne pas modifier, nécessaire au fonctionnement');
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (30,'t_us','interpret','contenant',NULL,NULL,'ne pas modifier, nécessaire au fonctionnement');
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (31,'t_us','interpret','dépôt mobilier',NULL,NULL,'ne pas modifier, nécessaire au fonctionnement');
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (32,'t_fait','interpret','silo',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (33,'t_fait','interpret','trou de poteau',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (34,'t_fait','interpret','fosse',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (35,'t_fait','interpret','fossé',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (36,'t_fait','interpret','four',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (37,'t_fait','interpret','maçonnerie',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (38,'t_fait','interpret','cave',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (39,'t_fait','interpret','réseau',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (40,'t_fait','interpret','puits',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (41,'t_fait','interpret','citerne',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (42,'t_fait','interpret','tranchée',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (43,'t_fait','interpret','sépulture',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (44,'t_fait','interpret','voie',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (45,'t_fait','interpret','fond de cabane',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (46,'t_fait','interpret','plate-forme',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (47,'t_fait','interpret','sablière',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (48,'t_fait','interpret','chablis',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (49,'t_fait','interpret','mare',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (50,'t_fait','interpret','anomalie géologique',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (51,'t_fait','interpret','incinération',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (52,'t_fait','interpret','cellier',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (53,'t_fait','interpret','radier',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (54,'t_fait','interpret','séchoir',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (55,'t_fait','interpret','trou de plantation',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (56,'t_fait','interpret','drain',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (57,'t_fait','interpret','indéterminée',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (58,'t_fait','interpret','sol',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (59,'t_mobilier','matiere','albâtre',NULL,'lapidaire',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (60,'t_mobilier','matiere','ardoise',NULL,'lapidaire',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (61,'t_mobilier','matiere','calcaire',NULL,'lapidaire',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (62,'t_mobilier','matiere','dolérite',NULL,'lapidaire',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (63,'t_mobilier','matiere','granit',NULL,'lapidaire',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (64,'t_mobilier','matiere','grès',NULL,'lapidaire',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (65,'t_mobilier','matiere','gypse',NULL,'lapidaire',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (66,'t_mobilier','matiere','marbre',NULL,'lapidaire',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (67,'t_mobilier','matiere','obsidienne',NULL,'lapidaire',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (68,'t_mobilier','matiere','pierre',NULL,'lapidaire',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (69,'t_mobilier','matiere','porphyre',NULL,'lapidaire',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (70,'t_mobilier','matiere','quartz',NULL,'lapidaire',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (71,'t_mobilier','matiere','quartzite',NULL,'lapidaire',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (72,'t_mobilier','matiere','schiste',NULL,'lapidaire',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (73,'t_mobilier','matiere','silex',NULL,'lapidaire',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (74,'t_mobilier','matiere','tuf',NULL,'lapidaire',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (75,'t_mobilier','matiere','fossile',NULL,'fossiles et résines fossiles',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (76,'t_mobilier','matiere','ambre',NULL,'fossiles et résines fossiles',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (77,'t_mobilier','matiere','poix',NULL,'fossiles et résines fossiles',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (78,'t_mobilier','matiere','corail',NULL,'fossiles et résines fossiles',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (79,'t_mobilier','matiere','houille',NULL,'lignite et apparentés',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (80,'t_mobilier','matiere','jais',NULL,'lignite et apparentés',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (81,'t_mobilier','matiere','lignite',NULL,'lignite et apparentés',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (82,'t_mobilier','matiere','roche charbonneuse',NULL,'lignite et apparentés',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (83,'t_mobilier','matiere','schiste bitumeux',NULL,'lignite et apparentés',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (84,'t_mobilier','matiere','terre indéterminée',NULL,'terre indéterminée',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (85,'t_mobilier','matiere','céramique',NULL,'céramique',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (86,'t_mobilier','matiere','céramique commune',NULL,'céramique',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (87,'t_mobilier','matiere','céramique fine',NULL,'céramique',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (88,'t_mobilier','matiere','céramique glaçurée',NULL,'céramique',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (89,'t_mobilier','matiere','céramique peinte',NULL,'céramique',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (90,'t_mobilier','matiere','céramique sigillée',NULL,'céramique',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (91,'t_mobilier','matiere','faïence',NULL,'céramique',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (92,'t_mobilier','matiere','grès',NULL,'céramique',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (93,'t_mobilier','matiere','protogrès',NULL,'céramique',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (94,'t_mobilier','matiere','porcelaine',NULL,'céramique',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (95,'t_mobilier','matiere','ardoise',NULL,'lithique',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (96,'t_mobilier','matiere','calcaire',NULL,'lithique',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (97,'t_mobilier','matiere','tuf',NULL,'lithique',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (98,'t_mobilier','matiere','dolérite',NULL,'lithique',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (99,'t_mobilier','matiere','granit',NULL,'lithique',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (100,'t_mobilier','matiere','grès',NULL,'lithique',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (101,'t_mobilier','matiere','grès schisteux',NULL,'lithique',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (102,'t_mobilier','matiere','gypse',NULL,'lithique',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (103,'t_mobilier','matiere','marbre',NULL,'lithique',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (104,'t_mobilier','matiere','obsidienne',NULL,'lithique',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (105,'t_mobilier','matiere','poudingue',NULL,'lithique',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (106,'t_mobilier','matiere','porphyre',NULL,'lithique',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (107,'t_mobilier','matiere','quartz',NULL,'lithique',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (108,'t_mobilier','matiere','quartzite',NULL,'lithique',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (109,'t_mobilier','matiere','schiste',NULL,'lithique',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (110,'t_mobilier','matiere','silex',NULL,'lithique',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (111,'t_mobilier','matiere','os indéterminé',NULL,'matériau osseux indéterminé',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (112,'t_mobilier','matiere','os humain',NULL,'os humain',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (113,'t_us','nature_us','construction',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (114,'t_us','nature_us','occupation',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (115,'t_us','nature_us','destruction',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (116,'t_us','nature_us','abandon',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (117,'t_us','nature_us','remblai',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (118,'t_us','nature_us','colluvions naturels',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (119,'t_us','nature_us','alluvions naturels',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (120,'t_us','nature_us','naturel',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (121,'t_us','nature_us','technique/mécanique',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (122,'t_us','nature_us','autre',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (123,'t_fait','profil','en cuvette',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (124,'t_fait','profil','piriforme',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (125,'t_fait','profil','en "V"',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (126,'t_fait','profil','en "U"',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (127,'t_fait','profil','en auge',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (128,'t_fait','profil','irrégulier',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (129,'t_fait','profil','à fond plat',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (130,'t_fait','profil','indéterminé',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (131,'t_fait','profil','évasé',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (132,'t_fait','profil','concave',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (133,'t_fait','profil','cylindrique',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (134,'t_fait','profil','incomplet',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (135,'t_fait','statut','en cours',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (136,'t_fait','statut','fouillé',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (137,'t_fait','statut','non fouillé',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (138,'t_fait','statut','annulé',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (139,'t_us','type_us','couche',NULL,NULL,'ne pas modifier');
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (140,'t_us','type_us','négatif',NULL,NULL,'ne pas modifier');
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (141,'t_us','type_us','altération',NULL,NULL,'ne pas modifier, nécessaire au fonctionnement');
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (142,'t_us','valeur','clair',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (143,'t_us','valeur','moyen',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (144,'t_us','valeur','foncé',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (145,'j_rel_us','jru_typrel','sous',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (146,'j_rel_us','jru_typrel','sur',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (147,'j_rel_us','jru_typrel','égale',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (148,'j_rel_us','jru_typrel','équivalente',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (149,'j_rel_us','jru_typrel','synchrone',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (150,'t_fait','f_periode','Paléolithique','-3300000 à -10000',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (151,'t_fait','f_periode','Paléolithique inférieur','-3300000 à -300000',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (152,'t_fait','f_periode','Paléolithique moyen','-300000 à -40000',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (153,'t_fait','f_periode','Paléolithique supérieur','-40000 à -10000',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (154,'t_fait','f_periode','Mésolithique et Épipaléolithique','-10000 à -5500',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (155,'t_fait','f_periode','Néolithique','-5500 à -2200',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (156,'t_fait','f_periode','Néolithique ancien','-5500 à -2200',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (157,'t_fait','f_periode','Néolithique moyen','-5500 à -4600',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (158,'t_fait','f_periode','Néolithique récent','-4600 à -3400',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (159,'t_fait','f_periode','Chalcolithique','-3400 à -2900',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (160,'t_fait','f_periode','Protohistoire','-2900 à -50',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (161,'t_fait','f_periode','Âge du Bronze','-2200 à -800',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (162,'t_fait','f_periode','Âge du Bronze ancien','-2200 à -1600',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (163,'t_fait','f_periode','Âge du Bronze moyen','-1600 à -1400',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (164,'t_fait','f_periode','Âge du Bronze récent','-1400 à -800',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (165,'t_fait','f_periode','Âge du Fer','-800 à -50',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (166,'t_fait','f_periode','Hallstatt','-800 à -450',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (167,'t_fait','f_periode','La Tène','-450 à -50',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (168,'t_fait','f_periode','Antiquité romaine','-50 à 476',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (169,'t_fait','f_periode','République romaine','-50 à 10',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (170,'t_fait','f_periode','Empire romain','-37 à 476',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (171,'t_fait','f_periode','Haut-Empire','-37 à 235',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (172,'t_fait','f_periode','Bas-Empire','235 à 476',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (173,'t_fait','f_periode','Époque médiévale','476 à 1492',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (174,'t_fait','f_periode','haut Moyen Âge','476 à 999',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (175,'t_fait','f_periode','Moyen Âge','1000 à 1299',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (176,'t_fait','f_periode','bas Moyen Âge','1299 à 1492',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (177,'t_fait','f_periode','Temps modernes','1492 à 1789',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (178,'t_fait','f_periode','Époque contemporaine','1789 à aujourd''hui',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (179,'t_fait','f_periode','Ère industrielle','1800 à 1914',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (180,'t_us','u_compo_sediment','limon',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (181,'t_us','u_compo_sediment','argile',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (182,'t_us','u_compo_sediment','sable',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (183,'t_us','u_texture','très compact',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (184,'t_us','u_texture','compact',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (185,'t_us','u_texture','meuble',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (186,'t_us','u_texture','très meuble',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (187,'t_us','interpret','aménagement inhumation',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (188,'t_us','interpret','contenant inhumation',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (189,'t_fait','orientation','nord/sud',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (190,'t_fait','orientation','sud/nord',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (191,'t_fait','orientation','est/ouest',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (192,'t_fait','orientation','ouest/est',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (193,'t_fait','orientation','nord-ouest/sud-est',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (194,'t_fait','orientation','sud-est/nord-ouest',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (195,'t_fait','orientation','nord-est/sud-ouest',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (196,'t_fait','orientation','sud-ouest/nord-est',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (197,'t_us','nature_us','technique',NULL,NULL,'ne pas modifier');
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (198,'t_us','interpret','décapage',NULL,NULL,'ne pas modifier');
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (199,'t_us','interpret','nettoyage',NULL,NULL,'ne pas modifier');
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (200,'t_us','interpret','remblai',NULL,NULL,'ne pas modifier');
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (201,'t_us','interpret','creusement',NULL,NULL,'ne pas modifier');
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (202,'t_us','interpret','comblement',NULL,NULL,'ne pas modifier');
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (203,'t_us','interpret','radier',NULL,NULL,'ne pas modifier');
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (204,'t_mobilier','mob_iso_ident','amphore',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (205,'t_mobilier','mob_iso_ident','anneau',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (206,'t_mobilier','mob_iso_ident','arme',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (207,'t_mobilier','mob_iso_ident','bobine',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (208,'t_mobilier','mob_iso_ident','bracelet',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (209,'t_mobilier','mob_iso_ident','charnière',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (210,'t_mobilier','mob_iso_ident','clef',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (211,'t_mobilier','mob_iso_ident','clou',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (212,'t_mobilier','mob_iso_ident','culot de four',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (213,'t_mobilier','mob_iso_ident','élément lithique',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (214,'t_mobilier','mob_iso_ident','enduit peint',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (215,'t_mobilier','mob_iso_ident','épingle',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (216,'t_mobilier','mob_iso_ident','fibule',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (217,'t_mobilier','mob_iso_ident','hache',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (218,'t_mobilier','mob_iso_ident','indéterminé',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (219,'t_mobilier','mob_iso_ident','jeton',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (220,'t_mobilier','mob_iso_ident','lame',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (221,'t_mobilier','mob_iso_ident','meule',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (222,'t_mobilier','mob_iso_ident','meule rotative',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (223,'t_mobilier','mob_iso_ident','molette',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (224,'t_mobilier','mob_iso_ident','monnaie',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (225,'t_mobilier','mob_iso_ident','mortier',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (226,'t_mobilier','mob_iso_ident','outil lithique',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (227,'t_mobilier','mob_iso_ident','perle',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (228,'t_mobilier','mob_iso_ident','peson',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (229,'t_mobilier','mob_iso_ident','poids',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (230,'t_mobilier','mob_iso_ident','scorie de forge',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (231,'t_mobilier','mob_iso_ident','scorie de réduction',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (232,'t_mobilier','mob_iso_ident','statuette',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (233,'t_mobilier','mob_iso_ident','TCA indéterminée',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (234,'t_mobilier','mob_iso_ident','tuile',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (235,'t_mobilier','mob_iso_ident','brique',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (236,'t_mobilier','mob_iso_ident','pilette',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (237,'t_mobilier','mob_iso_ident','torchis',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (238,'t_mobilier','mob_iso_ident','verre de construction',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (239,'t_mobilier','mob_iso_ident','vaisselle',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (240,'t_mobilier','mob_catego','roche ou minéral indéterminé et minerais',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (241,'t_mobilier','mob_catego','lapidaire','éléments d''architecture, sculpture, statuaire...',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (242,'t_mobilier','mob_catego','lithique','industrie sur roche et minéraux, hors lignite',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (243,'t_mobilier','mob_catego','fossiles et résines fossiles',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (244,'t_mobilier','mob_catego','lignite et apparentés','roche charbonneuse',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (245,'t_mobilier','mob_catego','terre indéterminée',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (246,'t_mobilier','mob_catego','céramique','vaisselle, récipients, vases...',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (247,'t_mobilier','mob_catego','terre cuite architecturale utilitaire, décorative ou votive','peson, statuette, lampe à huile...',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (248,'t_mobilier','mob_catego','terre cuite architecturale','tuile, brique...',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (249,'t_mobilier','mob_etatcons','très mauvais',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (250,'t_mobilier','mob_etatcons','mauvais',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (251,'t_mobilier','mob_etatcons','moyen',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (252,'t_mobilier','mob_etatcons','bon',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (253,'t_mobilier','mob_etatcons','très bon',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (254,'t_mobilier','mob_etatcons','complet',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (255,'t_mobilier','mob_catego','argile crue ou cuite accidentellement','torchis...',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (256,'t_mobilier','mob_catego','matériau osseux indéterminé',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (257,'t_mobilier','mob_catego','os humain','non travaillé',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (258,'t_mobilier','mob_catego','faune','non travaillé',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (259,'t_mobilier','mob_catego','ichtyologie','non travaillé',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (260,'t_mobilier','mob_catego','malacologie','non travaillé',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (261,'t_mobilier','mob_catego','os travaillé',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (262,'t_mobilier','mob_catego','coquillage, coquille, corail travaillé',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (263,'t_mobilier','mob_catego','matériau organique indéterminé',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (264,'t_mobilier','mob_catego','bois et vannerie',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (265,'t_mobilier','mob_catego','textile','fibres animales et végétales',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (266,'t_mobilier','mob_catego','cuir et peau',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (267,'t_mobilier','mob_catego','métal et alliage indéterminé ou métaux composites',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (268,'t_mobilier','mob_catego','or',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (269,'t_mobilier','mob_catego','argent',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (270,'t_mobilier','mob_catego','cuivre et alliages cuivreux','bronze, laiton',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (271,'t_mobilier','mob_catego','fer et alliages ferreux',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (272,'t_mobilier','mob_catego','plomb et alliages plombifères',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (273,'t_mobilier','mob_catego','étain',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (274,'t_mobilier','mob_catego','zinc',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (275,'t_mobilier','mob_catego','monnaies',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (276,'t_mobilier','mob_catego','verre',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (277,'t_mobilier','mob_catego','matériau composite connu ou indéterminé ou matériaux divers',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (278,'t_mobilier','mob_catego','émaux sur métaux',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (279,'t_mobilier','mob_catego','mosaïque',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (280,'t_mobilier','mob_catego','enduit peint',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (281,'t_mobilier','mob_catego','matériaux pierreux','mortier, plâtre, stuc...',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (282,'t_mobilier','mob_catego','industrie du métal ou du verre','scorie, creuset...',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (283,'t_prelevement','pvt_type','prélèvement brut non trié',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (284,'t_prelevement','pvt_type','anthracologie','charbons de bois',NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (285,'t_prelevement','pvt_type','carpologie',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (286,'t_prelevement','pvt_type','palynologie',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (287,'t_prelevement','pvt_type','granulométrie',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (288,'t_prelevement','pvt_type','micromorphologie',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (289,'t_prelevement','pvt_type','dendochronologie',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (290,'t_prelevement','pvt_type','thermoluminescence',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (291,'t_prelevement','pvt_type','datation carbone 14',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (292,'t_prelevement','pvt_type','phosphates',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (293,'t_prelevement','pvt_type','parasitologie',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (294,'t_mobilier','matiere','roche indéterminée',NULL,'roche ou minéral indéterminé et minerais',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (295,'t_mobilier','matiere','minéral indéterminé',NULL,'roche ou minéral indéterminé et minerais',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (296,'t_mobilier','matiere','minerai indéterminé',NULL,'roche ou minéral indéterminé et minerais',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (297,'t_mobilier','matiere','terre cuite utilitaire',NULL,'terre cuite architecturale utilitaire, décorative ou votive',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (298,'t_mobilier','matiere','terre cuite décorative',NULL,'terre cuite architecturale utilitaire, décorative ou votive',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (299,'t_mobilier','matiere','fusaïole',NULL,'terre cuite architecturale utilitaire, décorative ou votive',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (300,'t_mobilier','matiere','peson',NULL,'terre cuite architecturale utilitaire, décorative ou votive',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (301,'t_mobilier','matiere','creuset',NULL,'terre cuite architecturale utilitaire, décorative ou votive',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (302,'t_mobilier','matiere','parure',NULL,'terre cuite architecturale utilitaire, décorative ou votive',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (303,'t_mobilier','matiere','bracelet',NULL,'terre cuite architecturale utilitaire, décorative ou votive',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (304,'t_mobilier','matiere','perle',NULL,'terre cuite architecturale utilitaire, décorative ou votive',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (305,'t_mobilier','matiere','terre cuite votive',NULL,'terre cuite architecturale utilitaire, décorative ou votive',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (306,'t_mobilier','matiere','ex-voto',NULL,'terre cuite architecturale utilitaire, décorative ou votive',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (307,'t_mobilier','matiere','statuette',NULL,'terre cuite architecturale utilitaire, décorative ou votive',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (308,'t_mobilier','matiere','brique',NULL,'terre cuite architecturale',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (309,'t_mobilier','matiere','tuile',NULL,'terre cuite architecturale',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (310,'t_mobilier','matiere','tuile vernissée',NULL,'terre cuite architecturale',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (311,'t_mobilier','matiere','grès',NULL,'terre cuite architecturale',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (312,'t_mobilier','matiere','porcelaine',NULL,'terre cuite architecturale',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (313,'t_mobilier','matiere','faïence',NULL,'terre cuite architecturale',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (314,'t_mobilier','matiere','terre crue',NULL,'argile crue ou cuite accidentellement',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (315,'t_mobilier','matiere','terre rubéfiée',NULL,'argile crue ou cuite accidentellement',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (316,'t_mobilier','matiere','adobe',NULL,'argile crue ou cuite accidentellement',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (317,'t_mobilier','matiere','argile',NULL,'argile crue ou cuite accidentellement',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (318,'t_mobilier','matiere','bauge',NULL,'argile crue ou cuite accidentellement',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (319,'t_mobilier','matiere','ocre',NULL,'argile crue ou cuite accidentellement',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (320,'t_mobilier','matiere','pisé',NULL,'argile crue ou cuite accidentellement',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (321,'t_mobilier','matiere','torchis',NULL,'argile crue ou cuite accidentellement',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (322,'t_mobilier','matiere','os animal',NULL,'faune',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (323,'t_mobilier','matiere','corne',NULL,'faune',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (324,'t_mobilier','matiere','bovidé',NULL,'faune',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (325,'t_mobilier','matiere','canidé',NULL,'faune',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (326,'t_mobilier','matiere','caprin',NULL,'faune',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (327,'t_mobilier','matiere','équidé',NULL,'faune',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (328,'t_mobilier','matiere','félin',NULL,'faune',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (329,'t_mobilier','matiere','mammifère marin',NULL,'faune',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (330,'t_mobilier','matiere','ovidé',NULL,'faune',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (331,'t_mobilier','matiere','porcin',NULL,'faune',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (332,'t_mobilier','matiere','rongeur',NULL,'faune',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (333,'t_mobilier','matiere','volatile',NULL,'faune',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (334,'t_mobilier','matiere','poisson',NULL,'ichtyologie',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (335,'t_mobilier','matiere','écaille',NULL,'ichtyologie',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (336,'t_mobilier','matiere','arête',NULL,'ichtyologie',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (337,'t_mobilier','matiere','coquillage',NULL,'malacologie',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (338,'t_mobilier','matiere','coquille',NULL,'malacologie',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (339,'t_mobilier','matiere','corail',NULL,'malacologie',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (340,'t_mobilier','matiere','nacre',NULL,'malacologie',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (341,'t_mobilier','matiere','coque',NULL,'malacologie',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (342,'t_mobilier','matiere','bernique',NULL,'malacologie',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (343,'t_mobilier','matiere','huître',NULL,'malacologie',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (344,'t_mobilier','matiere','moule',NULL,'malacologie',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (345,'t_mobilier','matiere','os animal travaillé',NULL,'os travaillé',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (346,'t_mobilier','matiere','os humain travaillé',NULL,'os travaillé',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (347,'t_mobilier','matiere','os indéterminé travaillé',NULL,'os travaillé',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (348,'t_mobilier','matiere','corne',NULL,'os travaillé',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (349,'t_mobilier','matiere','ivoire',NULL,'os travaillé',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (350,'t_mobilier','matiere','coquillage travaillé',NULL,'coquillage, coquille, corail travaillé',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (351,'t_mobilier','matiere','coquille travaillée',NULL,'coquillage, coquille, corail travaillé',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (352,'t_mobilier','matiere','nacre',NULL,'coquillage, coquille, corail travaillé',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (353,'t_mobilier','matiere','corail',NULL,'coquillage, coquille, corail travaillé',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (354,'t_mobilier','matiere','matériau organique indéterminé',NULL,'matériau organique indéterminé',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (355,'t_mobilier','matiere','bois',NULL,'bois et vannerie',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (356,'t_mobilier','matiere','vannerie',NULL,'bois et vannerie',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (357,'t_mobilier','matiere','textile',NULL,'textile',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (358,'t_mobilier','matiere','fibre animale',NULL,'textile',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (359,'t_mobilier','matiere','fibre végétale',NULL,'textile',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (360,'t_mobilier','matiere','chanvre',NULL,'textile',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (361,'t_mobilier','matiere','coton',NULL,'textile',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (362,'t_mobilier','matiere','lin',NULL,'textile',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (363,'t_mobilier','matiere','cuir',NULL,'cuir et peau',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (364,'t_mobilier','matiere','peau',NULL,'cuir et peau',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (365,'t_mobilier','matiere','métal indéterminé',NULL,'métal et alliage indéterminé ou métaux composites',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (366,'t_mobilier','matiere','alliage indéterminé',NULL,'métal et alliage indéterminé ou métaux composites',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (367,'t_mobilier','matiere','métal composite',NULL,'métal et alliage indéterminé ou métaux composites',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (368,'t_mobilier','matiere','alliage composite',NULL,'métal et alliage indéterminé ou métaux composites',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (369,'t_mobilier','matiere','or',NULL,'or',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (370,'t_mobilier','matiere','argent',NULL,'argent',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (371,'t_mobilier','matiere','cuivre',NULL,'cuivre et alliages cuivreux',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (372,'t_mobilier','matiere','alliage cuivreux',NULL,'cuivre et alliages cuivreux',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (373,'t_mobilier','matiere','bronze',NULL,'cuivre et alliages cuivreux',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (374,'t_mobilier','matiere','laiton',NULL,'cuivre et alliages cuivreux',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (375,'t_mobilier','matiere','fer',NULL,'fer et alliages ferreux',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (376,'t_mobilier','matiere','alliage ferreux',NULL,'fer et alliages ferreux',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (377,'t_mobilier','matiere','acier',NULL,'fer et alliages ferreux',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (378,'t_mobilier','matiere','fonte',NULL,'fer et alliages ferreux',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (379,'t_mobilier','matiere','hématite',NULL,'fer et alliages ferreux',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (380,'t_mobilier','matiere','manganèse',NULL,'fer et alliages ferreux',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (381,'t_mobilier','matiere','plomb',NULL,'plomb et alliages plombifères',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (382,'t_mobilier','matiere','alliage plombifère',NULL,'plomb et alliages plombifères',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (383,'t_mobilier','matiere','antimoine',NULL,'plomb et alliages plombifères',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (384,'t_mobilier','matiere','étain',NULL,'étain',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (385,'t_mobilier','matiere','zinc',NULL,'zinc',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (386,'t_mobilier','matiere','monnaie',NULL,'monnaies',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (387,'t_mobilier','matiere','verre',NULL,'verre',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (388,'t_mobilier','matiere','verre mécanique',NULL,'verre',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (389,'t_mobilier','matiere','verre soufflé',NULL,'verre',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (390,'t_mobilier','matiere','verre indéterminé',NULL,'verre',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (391,'t_mobilier','matiere','pâte de verre',NULL,'verre',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (392,'t_mobilier','matiere','matériau composite',NULL,'matériau composite connu ou indéterminé ou matériaux divers',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (393,'t_mobilier','matiere','matériau composite indéterminé',NULL,'matériau composite connu ou indéterminé ou matériaux divers',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (394,'t_mobilier','matiere','divers',NULL,'matériau composite connu ou indéterminé ou matériaux divers',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (395,'t_mobilier','matiere','émail',NULL,'émaux sur métaux',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (396,'t_mobilier','matiere','mosaïque',NULL,'mosaïque',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (397,'t_mobilier','matiere','enduit peint',NULL,'enduit peint',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (398,'t_mobilier','matiere','matériel pierreux',NULL,'matériaux pierreux',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (399,'t_mobilier','matiere','mortier',NULL,'matériaux pierreux',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (400,'t_mobilier','matiere','plâtre',NULL,'matériaux pierreux',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (401,'t_mobilier','matiere','stuc',NULL,'matériaux pierreux',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (402,'t_mobilier','matiere','scorie',NULL,'industrie du métal ou du verre',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (403,'t_mobilier','matiere','creuset',NULL,'industrie du métal ou du verre',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (404,'t_mobilier','matiere','culot',NULL,'industrie du métal ou du verre',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (405,'t_mobilier','matiere','battiture',NULL,'industrie du métal ou du verre',NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (406,'t_minute','échelle','1/10e',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (407,'t_minute','échelle','1/20e',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (408,'t_minute','échelle','1/40e',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (409,'t_minute','échelle','1/50e',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (410,'t_minute','échelle','1/100e',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (411,'t_minute','support','calque',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (412,'t_minute','support','numérique',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (413,'t_minute','format','A4',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (414,'t_minute','format','A3',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (415,NULL,'auteur','M.X',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (416,NULL,'auteur','Mme Y.',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (417,'t_minute','format','autre',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (418,'t_sondage','sd_type','manuel',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (419,'t_sondage','sd_type','mécanique',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes","tabl_thes","field_thes","val_thes","def_thes","cat_thes","comment") VALUES (420,'t_sondage','sd_type','profond',NULL,NULL,NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (421, 't_ens', 'typens', 'archéologique', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (422, 't_ens', 'typens', 'technique', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (423, 't_ens', 'typens', 'entité architecturale', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (424, 't_ens', 'interpret', 'bâtiment', NULL, 'archéologique', NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (425, 't_ens', 'interpret', 'enclos', NULL, 'archéologique', NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (426, 't_ens', 'interpret', 'palissade', NULL, 'archéologique', NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (427, 't_ens', 'interpret', 'cave', NULL, 'archéologique', NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (428, 't_ens', 'interpret', 'nécropole', NULL, 'archéologique', NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (429, 't_ens', 'interpret', 'zone', NULL, 'technique', NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (430, 't_ens', 'interpret', 'secteur', NULL, 'technique', NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (431, 't_ens', 'interpret', 'groupe', NULL, 'technique', NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (432, 't_photo', 'support', 'numérique', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (433, 't_photo', 'support', 'argentique', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (434, 't_photo', 'vue_vers', 'nord', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (435, 't_photo', 'vue_vers', 'sud', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (436, 't_photo', 'vue_vers', 'est', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (437, 't_photo', 'vue_vers', 'ouest', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (438, 't_photo', 'vue_vers', 'nord-est', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (439, 't_photo', 'vue_vers', 'nord-ouest', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (440, 't_photo', 'vue_vers', 'sud-est', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (441, 't_photo', 'vue_vers', 'sud-ouest', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (442, 't_photogram', 'obj_model', 'orthoimage', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (443, 't_photogram', 'obj_model', 'coupe', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (444, 't_photogram', 'obj_model', 'profil', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (445, 't_photogram', 'obj_model', 'modèle 3D', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (446, 't_photogram', 'suivi', 'aérotriangulation', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (447, 't_photogram', 'suivi', 'génération du nuage dense', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (448, 't_photogram', 'suivi', 'génération du MNS', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (449, 't_photogram', 'suivi', 'génération d''une orthoimage', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (450, 't_equipe', 'fonction', 'conservateur·rice régional·e de l''archéologie', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (451, 't_equipe', 'fonction', 'conservateur·rice régional·e de l''archéologie adjoint', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (452, 't_equipe', 'fonction', 'conservateur·rice du patrimoine', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (453, 't_equipe', 'fonction', 'ingénieur·e d''études', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (454, 't_equipe', 'fonction', 'directeur·rice adjoint·e scientifiques et techniques', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (455, 't_equipe', 'fonction', 'délégué·e au directeur·trice adjoint scientifiques et techniques', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (456, 't_equipe', 'fonction', 'administrateur·rice', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (457, 't_equipe', 'fonction', 'gestionnaire de conventions, de contrats et marchés publics', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (458, 't_equipe', 'fonction', 'gestionnaire de collection', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (459, 't_equipe', 'fonction', 'documentaliste', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (460, 't_equipe', 'fonction', 'responsable de recherches archéologiques', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (461, 't_equipe', 'fonction', 'assistant·e de prévention', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (462, 't_equipe', 'fonction', 'topographe', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (463, 't_equipe', 'fonction', 'assistant·e de recherches archéologiques', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (464, 't_equipe', 'fonction', 'technicien·ne de recherches archéologiques', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (465, 't_equipe', 'fonction', 'spécialiste', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (466, 't_equipe', 'fonction', 'topographe', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (467, 't_equipe', 'fonction', 'infographe', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (468, 'j_rel_us', 'naturelat', 'rupture', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (469, 'j_rel_us', 'naturelat', 'continuité', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (470, 'j_rel_us', 'naturelat', 'indéfinie', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (471, 'coupe_line', 'typline', 'TV', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (472, 'coupe_line', 'typline', 'US négative', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (473, 'coupe_line', 'typline', 'US négative restituée', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (474, 'coupe_line', 'typline', 'US', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (475, 'coupe_line', 'typline', 'restitution', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (476, 'coupe_line', 'typline', 'limite d''observation', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (477, 'coupe_line', 'typline', 'non visible', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (478, 'coupe_poly', 'typoly', 'US', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (479, 'coupe_poly', 'typoly', 'non visible', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (480, 'coupe_poly', 'detail', 'calcaire', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (481, 'coupe_poly', 'detail', 'torchis', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (482, 'coupe_poly', 'detail', 'calcaire brûlé', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (483, 'coupe_poly', 'detail', 'céramique', NULL, NULL, NULL);
INSERT INTO "thesaurus_badass" ("id_thes", "tabl_thes", "field_thes", "val_thes", "def_thes", "cat_thes", "comment") VALUES (484, 'coupe_poly', 'detail', 'terre cuite', NULL, NULL, NULL);


----------------------------------------------------------------------------------------------------------------------
-- LES TRIGGERS --
 
-- pour les préfixes :
-- trg pour TRIGGER
-- a pour AFTER
-- b pour BEFORE
-- i pour INSERT
-- u pour UPDATE
-- d pour DELETE


-- les triggers à mettre en place pour la table poly (qui doivent mettre à jour les tables t_fait et t_us)

-- AFTER INSERT
-- qui met à jour la table t_fait après CREATION d'une entité dans poly
CREATE TRIGGER trgai_poly_maj_t_fait /*déclaration de création d'un nouveau trigger qui a pour nom...*/
    AFTER INSERT /*qui sera exécuté après l'ajout d'une nouvelle entité*/
    ON poly /*sur/dans la table*/
FOR EACH ROW /*commande obligatoire : pour tous les enregistrement*/
WHEN (NEW.typoly = 'fait') /*cette condition permet de restreindre les enregistrements concernés aux seuls 'fait' ; NEW correspond à une copie temporaire des nouveaux éléments de la table t_poly effectuée lors de l'exécution du trigger*/
BEGIN /* debut de l'action déclenchée*/
UPDATE t_fait /*avec une modification de la table t_fait*/
SET geometry = NEW.geometry /*qui redéfini la valeur du champ "geom" de la table t_fait par la valeur du champ "geom" de la copie temporaire NEW de la table t_poly*/
WHERE NEW.numpoly = numfait ; /*à chaque fois que la valeur du champ "num_fait" de la table t_fait est égale à la valeur du champ "numpoly" de la copie temporaire NEW de la table t_poly*/
END ; /*fin de l'action et fin du trigger*/

-- qui met à jour la table t_us après CREATION d'une entité dans poly
CREATE TRIGGER trgai_poly_maj_t_us 
    AFTER INSERT 
    ON poly 
FOR EACH ROW 
WHEN (NEW.typoly IN('US','us'))
   BEGIN
   UPDATE t_us
   SET geometry = NEW.geometry 
   WHERE NEW.numpoly = numus ;
END ; 

-- AFTER UPDATE
-- qui met à jour la table t_fait après MODIFICATION d'une entité dans poly
CREATE TRIGGER trgau_poly_maj_t_fait
   AFTER UPDATE /*qui sera exécuté après la modification de la géométrie d'une entité*/
   ON poly
FOR EACH ROW
WHEN (NEW.typoly = 'fait')
BEGIN
UPDATE t_fait
SET geometry = NEW.geometry
WHERE NEW.numpoly = numfait ;
END ;

-- qui met à jour la table t_us après MODIFICATION d'une entité dans poly
CREATE TRIGGER trgau_poly_maj_t_us
   AFTER UPDATE 
   ON poly
FOR EACH ROW
WHEN (NEW.typoly IN('US','us') )
   BEGIN
UPDATE t_us
SET geometry = NEW.geometry
WHERE NEW.numpoly = numus ;
END ;


-- AFTER DELETE
-- pas utile, parce que dans le cas d'une annulation, on préfère indiquer que l'objet est annulé plutôt que de supprimer l'enregitrement et dans le cas de mise à jour des entités dans la couche poly après un lever topo, il ne doit pas y avoir de conséquence sur l'enregistrement dans t_fait ou t_us


-- les triggers à mettre en place pour la table t_fait (qui doivent mettre à jour la table poly)

-- AFTER INSERT
-- on n'en fait pas de celui là car une création d'entité 
-- dans t_fait ne doit pas forcément induire une création équivalente dans t_poly

-- AFTER UPDATE
CREATE TRIGGER trgau_t_fait_maj_poly /*déclaration de création d'un nouveau trigger qui a pour nom...*/
   AFTER UPDATE /*qui sera exécuté après la modification de la géométrie d'une entité*/
   ON t_fait /*sur la table*/
FOR EACH ROW /*commande obligatoire : pour tous les enregistrement*/
BEGIN /* debut de l'action déclenchée*/
UPDATE poly /*avec une modification de la table t_poly*/
SET geometry = NEW.geometry /*qui redéfini la valeur du champ "geom" de la table t_poly par la valeur du champ "geom" de la copie temporaire des nouveaux éléments NEW de la table t_fait*/
WHERE NEW.numfait = numpoly AND typoly = 'fait' ; /*pour les entités dont la valeur du champ "numpoly" de la table t_poly est égale à la valeur du champ "num_fait" de la copie temporaire NEW de la table t_fait et pour lesquels la valeur 'fait' est renseignée dans le champ "typoly"*/
END ; /*fin de l'action et fin du trigger*/

-- AFTER DELETE
-- inutile, voir supra

-- les triggers à mettre en place pour la table t_us (qui doivent mettre à jour la table poly)
-- AFTER UPDATE
CREATE TRIGGER trgau_t_us_maj_poly 
   AFTER UPDATE 
   ON t_us 
FOR EACH ROW 
BEGIN 
UPDATE poly 
SET geometry = NEW.geometry 
WHERE NEW.numus = numpoly AND typoly = 'us' ; 
END ; 

-- AFTER DELETE
-- inutile, voir supra


-- les triggers à mettre en place pour la table ouverture (qui doivent mettre à jour les tables t_sondage et t_tranchee)

-- AFTER INSERT
-- qui met à jour la table t_sondage après CREATION d'une entité dans ouverture
CREATE TRIGGER trgai_ouverture_maj_t_sondage 
    AFTER INSERT 
    ON ouverture 
FOR EACH ROW 
WHEN (NEW.typouvert = 'sondage') 
BEGIN 
UPDATE t_sondage 
SET geometry = NEW.geometry 
WHERE NEW.numouvert = numsd ; 
END ; 

-- qui met à jour la table t_tranchee après CREATION d'une entité dans ouverture
CREATE TRIGGER trgai_ouverture_maj_t_tranchee 
    AFTER INSERT 
    ON ouverture 
FOR EACH ROW 
WHEN (NEW.typouvert = 'tranchée') 
   BEGIN
   UPDATE t_tranchee
   SET geometry = NEW.geometry 
   WHERE NEW.numouvert = numtr ;
END ; 

-- AFTER UPDATE
-- qui met à jour la table t_sondage après MODIFICATION d'une entité dans ouverture
CREATE TRIGGER trgau_ouverture_maj_t_sondage
   AFTER UPDATE 
   ON ouverture
FOR EACH ROW
WHEN (NEW.typouvert = 'sondage')
BEGIN
UPDATE t_sondage
SET geometry = NEW.geometry
WHERE NEW.numouvert = numsd ;
END ;

-- qui met à jour la table t_tranchee après MODIFICATION d'une entité dans ouverture
CREATE TRIGGER trgau_ouverture_maj_t_tranchee
   AFTER UPDATE 
   ON ouverture
FOR EACH ROW
WHEN (NEW.typouvert = 'tranchée')
BEGIN
UPDATE t_tranchee
SET geometry = NEW.geometry
WHERE NEW.numouvert = numtr ;
END ;

-- AFTER DELETE
-- inutile, voir supra 


-- les triggers à mettre en place pour la table t_sondage (qui doivent mettre à jour la table ouverture)
-- AFTER UPDATE
CREATE TRIGGER trgau_t_sondage_maj_ouverture 
   AFTER UPDATE 
   ON t_sondage 
FOR EACH ROW 
BEGIN 
UPDATE ouverture 
SET geometry = NEW.geometry 
WHERE NEW.numsd = numouvert AND typouvert = 'sondage' ; 
END ; 

-- AFTER DELETE
-- inutile, voir supra


-- les triggers à mettre en place pour la table t_tranchee (qui doivent mettre à jour la table ouverture)
-- AFTER UPDATE
CREATE TRIGGER trgau_t_tranchee_maj_ouverture 
   AFTER UPDATE 
   ON t_tranchee 
FOR EACH ROW 
BEGIN 
UPDATE ouverture 
SET geometry = NEW.geometry 
WHERE NEW.numtr = numouvert AND typouvert = 'tranchée' ; 
END ; 

-- AFTER DELETE
-- inutile, voir supra


-- les triggers à mettre en place pour la table axe (qui doivent mettre à jour la tables t_axe)

-- AFTER INSERT
-- qui met à jour la table t_axe après CREATION d'une entité dans axe
CREATE TRIGGER trgai_axe_maj_t_axe 
    AFTER INSERT 
    ON axe 
FOR EACH ROW 
BEGIN 
UPDATE t_axe 
SET geometry = NEW.geometry 
WHERE NEW.numaxe = numaxe ; 
END ; 

-- AFTER UPDATE
-- qui met à jour la table t_axe après MODIFICATION d'une entité dans axe
CREATE TRIGGER trgau_axe_maj_t_axe
   AFTER UPDATE 
   ON axe
FOR EACH ROW
BEGIN
UPDATE t_axe
SET geometry = NEW.geometry
WHERE NEW.numaxe = numaxe ;
END ;

-- AFTER DELETE
-- inutile, voir supra

-- les triggers à mettre en place pour la table t_axe (qui doivent mettre à jour la table axe)
-- AFTER UPDATE
CREATE TRIGGER trgau_t_axe_maj_axe 
   AFTER UPDATE 
   ON t_axe 
FOR EACH ROW 
BEGIN 
UPDATE axe 
SET geometry = NEW.geometry 
WHERE NEW.numaxe = numaxe ; 
END ; 

-- AFTER DELETE
-- inutile, voir supra 


-- les triggers à mettre en place pour la table point (qui doivent mettre à jour la tables t_mobilier)

-- AFTER INSERT
-- qui met à jour la table t_mobilier après CREATION d'une entité dans point
CREATE TRIGGER trgai_point_maj_t_mobilier 
    AFTER INSERT 
    ON point
FOR EACH ROW 
BEGIN 
UPDATE t_mobilier 
SET geometry = NEW.geometry 
WHERE NEW.numpoint = numpoint ; 
END ; 

-- AFTER UPDATE
-- qui met à jour la table t_mobilier après MODIFICATION d'une entité dans point
CREATE TRIGGER trgau_point_maj_t_mobilier
   AFTER UPDATE 
   ON point
FOR EACH ROW
BEGIN
UPDATE t_mobilier
SET geometry = NEW.geometry
WHERE NEW.numpoint = numpoint ;
END ;

-- AFTER DELETE
-- inutile, voir supra

-- les triggers à mettre en place pour la table t_point (qui doivent mettre à jour la table point)
-- AFTER UPDATE
CREATE TRIGGER trgau_t_mobilier_maj_point 
   AFTER UPDATE 
   ON t_mobilier 
FOR EACH ROW 
BEGIN 
UPDATE point 
SET geometry = NEW.geometry 
WHERE NEW.numpoint = numpoint ; 
END ; 

-- AFTER DELETE
-- inutile, voir supra

-- les triggers à mettre en place pour la table log (qui doivent mettre à jour la tables t_log)

-- AFTER INSERT
-- qui met à jour la table t_log après CREATION d'une entité dans log
CREATE TRIGGER trgai_log_maj_t_log 
    AFTER INSERT 
    ON log
FOR EACH ROW 
BEGIN 
UPDATE t_log 
SET geometry = NEW.geometry 
WHERE NEW.numlog = numlog ; 
END ; 

-- AFTER UPDATE
-- qui met à jour la table t_log après MODIFICATION d'une entité dans log
CREATE TRIGGER trgau_log_maj_t_log
   AFTER UPDATE 
   ON log
FOR EACH ROW
BEGIN
UPDATE t_log
SET geometry = NEW.geometry
WHERE NEW.numlog = numlog ;
END ;

-- AFTER DELETE
-- inutile, voir supra

-- les triggers à mettre en place pour la table t_log (qui doivent mettre à jour la table plog)
-- AFTER UPDATE
CREATE TRIGGER trgau_t_log_maj_log 
   AFTER UPDATE 
   ON t_log 
FOR EACH ROW 
BEGIN 
UPDATE log 
SET geometry = NEW.geometry 
WHERE NEW.numlog = numlog ; 
END ; 

-- AFTER DELETE
-- inutile, voir supra

-- les triggers qui vont doubler les relations horizontales entre les US
-- après la création d'une relation entre US
CREATE TRIGGER trgai_j_rel_us
   AFTER INSERT
   ON j_rel_us
FOR EACH ROW
WHEN (NEW."typrel" like 'égale' OR NEW."typrel" like 'équivalente' OR NEW."typrel" like 'synchrone')
BEGIN
   INSERT INTO j_rel_us ("numus1","numus2","typrel","incert") VALUES (NEW."numus2", NEW."numus1", NEW."typrel", NEW."incert");
END;

-- après la mise à jour d'une relation entre US. ATTENTION : ce trigger est passé en commentaire car au final il semble redondant avec le INSERT (à voir...)
/*CREATE TRIGGER trgau_j_rel_us
   AFTER UPDATE
   ON j_rel_us
FOR EACH ROW
WHEN (NEW."jru_typrel" like 'égale' OR NEW."jru_typrel" like 'équivalente' OR NEW."jru_typrel" like 'synchrone')
BEGIN
   INSERT INTO j_rel_us ("jru_us1","jru_us2","jru_typrel","jru_incert") VALUES (NEW."jru_us2", NEW."jru_us1", NEW."jru_typrel", NEW."jru_incert");
end;*/

-- après la suppression d'une relation entre US
CREATE TRIGGER trgad_j_rel_us 
   AFTER DELETE 
   ON j_rel_us 
FOR EACH ROW 
WHEN (OLD."typrel" like 'égale' OR OLD."typrel" like 'équivalente' OR OLD."typrel" like 'synchrone') 
BEGIN 
DELETE FROM j_rel_us 
WHERE ("numus1" = OLD."numus2" and "numus2" = OLD."numus1" and "typrel" = OLD."typrel" and "incert" = OLD."incert"); 
END ; 


--Les vues
--Vue de récapitulation des logs, faits et US enregistrés par tranchée
DROP VIEW IF EXISTS vue_recap_tranchee;
CREATE VIEW vue_recap_tranchee AS
SELECT j."numtr",
REPLACE(GROUP_CONCAT(DISTINCT j."numlog"),',',', ') AS recap_log, -- l'argument DISTINCT dans le GROUP_CONCAT permet de générer une liste de valeurs uniques, le REPLACE permet de modifier le symbole par défaut de la fonction GROUP_CONCAT (merci Bertrand d'avoir trouver l'astuce !)
REPLACE(GROUP_CONCAT(DISTINCT j."numfait"),',',', ') AS recap_fait,
REPLACE(GROUP_CONCAT(DISTINCT j."numus"),',',', ') AS recap_us
FROM (SELECT * FROM j_rel_tranchee ORDER BY "numlog","numfait","numus") AS j
GROUP BY j."numtr"
ORDER BY j."numtr";

--Vue de récapitulation des US enregistrées par fait
DROP VIEW IF EXISTS vue_recap_us_fait;
CREATE VIEW vue_recap_us_fait AS
SELECT "numfait" as numfait,
REPLACE(GROUP_CONCAT(DISTINCT "numus"),',',', ') as recap_us
FROM (SELECT * FROM t_us ORDER BY "numus")
GROUP BY "numfait"
ORDER BY "numus";

--Vue de récapitulation des relations stratigraphiques par US
DROP VIEW IF EXISTS vue_recap_relationus;
CREATE VIEW vue_recap_relationus AS
SELECT "numus1" as numus,
REPLACE(GROUP_CONCAT(DISTINCT CASE WHEN "typrel" LIKE 'sous' THEN "numus2" ELSE null END),',', ', ') AS us_posterieur,
REPLACE(GROUP_CONCAT(DISTINCT CASE WHEN "typrel" LIKE 'sur' THEN "numus2" ELSE null END),',', ', ') AS us_anterieur,
REPLACE(GROUP_CONCAT(DISTINCT CASE WHEN "typrel" IN('égale','équivalente','synchrone') THEN "numus2" ELSE null END),',', ', ') AS rel_horizontal
FROM (SELECT * FROM j_rel_us ORDER BY "numus2")
GROUP BY numus1
ORDER BY numus1;

--Vue d'inversion des relations stratigraphiques à partir de la table j_rel_us
DROP VIEW IF EXISTS vue_j_rel_us_inverse;
CREATE VIEW vue_j_rel_us_inverse AS
SELECT "id_rel_us", "numus2" as numus1,
CASE WHEN "typrel" LIKE 'sur' THEN 'sous'
WHEN "typrel" LIKE 'sous' THEN 'sur' end as typrel,
"numus1" as numus2, incert
FROM j_rel_us
WHERE "typrel" IN ('sur','sous');

--Vue de récapitulation des relations stratigraphiques inversées par US
DROP VIEW IF EXISTS vue_recap_relationus_deduite;
CREATE VIEW vue_recap_relationus_deduite AS
SELECT "numus1" as numus,
REPLACE(GROUP_CONCAT(DISTINCT CASE WHEN "typrel" LIKE 'sous' THEN "numus2" ELSE null END),',', ', ') AS us_posterieur,
REPLACE(GROUP_CONCAT(DISTINCT CASE WHEN "typrel" LIKE 'sur' THEN "numus2" ELSE null END),',', ', ') AS us_anterieur,
REPLACE(GROUP_CONCAT(CASE WHEN "typrel" IN('égale','équivalente','synchrone') THEN "numus2" ELSE null END),',', ', ') AS rel_horizontal
FROM (SELECT * FROM vue_j_rel_us_inverse ORDER BY "numus2")
GROUP BY numus1
ORDER BY numus1;

--Vue de récapitulation des US par log stratigraphique
DROP VIEW IF EXISTS vue_recap_us_log;
CREATE VIEW vue_recap_us_log AS 
SELECT "numlog", 
REPLACE(GROUP_CONCAT(DISTINCT "numus"),',',', ') as recap_us,
MAX("prof_base") AS prof_max,
MIN("zmin_uslog") AS z_min 
FROM (SELECT * FROM j_us_log ORDER BY "numus") 
GROUP BY "numlog" 
ORDER BY "numlog";

--Vue de récapitulation des tranchées, sondages, faits, us, log et iso par minute
DROP VIEW IF EXISTS vue_recap_minute;
CREATE VIEW vue_recap_minute AS
SELECT m.*,
REPLACE(GROUP_CONCAT(DISTINCT r1."numtr"),',', ', ') AS recap_tr, 
REPLACE(GROUP_CONCAT(DISTINCT r2."numsd"),',', ', ') AS recap_sd, 
REPLACE(GROUP_CONCAT(DISTINCT r3."numlog"),',', ', ') AS recap_log,
REPLACE(GROUP_CONCAT(DISTINCT r4."numens"),',', ', ') AS recap_ens,
REPLACE(GROUP_CONCAT(DISTINCT r5."numfait"),',', ', ') AS recap_fait, 
REPLACE(GROUP_CONCAT(DISTINCT r6."numus"),',', ', ') AS recap_us, 
REPLACE(GROUP_CONCAT(DISTINCT r7."numiso"),',', ', ') AS recap_iso
FROM -- la succession de sous-requêtes permet de replacer les numéros dans l'ordre croissant
	(SELECT * FROM j_rel_minute ORDER BY "numtr") AS r1
	,(SELECT * FROM j_rel_minute ORDER BY "numsd") AS r2
	,(SELECT * FROM j_rel_minute ORDER BY "numlog") AS r3
	,(SELECT * FROM j_rel_minute ORDER BY "numens") AS r4
	,(SELECT * FROM j_rel_minute ORDER BY "numfait") AS r5
	,(SELECT * FROM j_rel_minute ORDER BY "numus") AS r6
	,(SELECT * FROM j_rel_minute ORDER BY "numiso") AS r7
JOIN t_minute AS m ON r1."numinute" = m."numinute"
GROUP BY m."numinute"
ORDER BY m."numinute";

--Vue de récapitulation des tranchées, sondages, faits, us et iso par photo 
DROP VIEW IF EXISTS vue_recap_photo;
CREATE VIEW vue_recap_photo AS
SELECT p.*, 
REPLACE(GROUP_CONCAT(DISTINCT r1."numtr"),',', ', ') AS recap_tr, 
REPLACE(GROUP_CONCAT(DISTINCT r2."numsd"),',', ', ') AS recap_sd,
REPLACE(GROUP_CONCAT(DISTINCT r3."numlog"),',', ', ') AS recap_log,
REPLACE(GROUP_CONCAT(DISTINCT r4."numens"),',', ', ') AS recap_ens,
REPLACE(GROUP_CONCAT(DISTINCT r5."numfait"),',', ', ') AS recap_fait, 
REPLACE(GROUP_CONCAT(DISTINCT r6."numus"),',', ', ') AS recap_us, 
REPLACE(GROUP_CONCAT(DISTINCT r7."numiso"),',', ', ') AS recap_iso
FROM 
	(SELECT * FROM j_rel_photo ORDER BY "numtr") AS r1
	,(SELECT * FROM j_rel_photo ORDER BY "numsd") AS r2
	,(SELECT * FROM j_rel_photo ORDER BY "numlog") AS r3
	,(SELECT * FROM j_rel_photo ORDER BY "numens") AS r4
	,(SELECT * FROM j_rel_photo ORDER BY "numfait") AS r5
	,(SELECT * FROM j_rel_photo ORDER BY "numus") AS r6
	,(SELECT * FROM j_rel_photo ORDER BY "numiso") AS r7
JOIN t_photo AS p ON r1."numphoto" = p."numphoto"
GROUP BY p."numphoto"
ORDER BY p."numphoto";

--Vue de récapitulation des tranchées, sondages, faits, us et iso par photo 
DROP VIEW IF EXISTS vue_recap_photo_photogram;
CREATE VIEW vue_recap_photo_photogram AS
SELECT r1."numphoto", 
REPLACE(GROUP_CONCAT(DISTINCT r1."numtr"),',', '_') AS recap_tr, 
REPLACE(GROUP_CONCAT(DISTINCT r2."numsd"),',', '_') AS recap_sd,
REPLACE(GROUP_CONCAT(DISTINCT r3."numlog"),',', '_') AS recap_log,
REPLACE(GROUP_CONCAT(DISTINCT r4."numens"),',', '_') AS recap_ens,
REPLACE(GROUP_CONCAT(DISTINCT r5."numfait"),',', '_') AS recap_fait, 
REPLACE(GROUP_CONCAT(DISTINCT r6."numus"),',', '_') AS recap_us, 
REPLACE(GROUP_CONCAT(DISTINCT r7."numiso"),',', '_') AS recap_iso,
r1."id_photogram"
FROM 
	(SELECT * FROM j_rel_photo ORDER BY "numtr") AS r1
	,(SELECT * FROM j_rel_photo ORDER BY "numsd") AS r2
	,(SELECT * FROM j_rel_photo ORDER BY "numlog") AS r3
	,(SELECT * FROM j_rel_photo ORDER BY "numens") AS r4
	,(SELECT * FROM j_rel_photo ORDER BY "numfait") AS r5
	,(SELECT * FROM j_rel_photo ORDER BY "numus") AS r6
	,(SELECT * FROM j_rel_photo ORDER BY "numiso") AS r7
GROUP BY r1."numphoto"
ORDER BY r1."numphoto";

--Vue de récapitulation des tranchées, sondages, faits, us et iso par photogrammétrie 
DROP VIEW IF EXISTS vue_recap_photogram;
CREATE VIEW vue_recap_photogram AS
SELECT r1."id_photogram",
	COALESCE(NULL, 'tr'||REPLACE(GROUP_CONCAT(DISTINCT r1."recap_tr"),',','_')) AS p_recap_tr,
	COALESCE(NULL,'sd'||REPLACE(GROUP_CONCAT(DISTINCT r2."recap_sd"),',','_')) AS p_recap_sd,
	COALESCE(NULL,'log'||REPLACE(GROUP_CONCAT(DISTINCT r3."recap_log"),',','_')) AS p_recap_log,
	COALESCE(NULL,'ens'||REPLACE(GROUP_CONCAT(DISTINCT r4."recap_ens"),',','_')) AS p_recap_ens,
	COALESCE(NULL,'f'||REPLACE(GROUP_CONCAT(DISTINCT r5."recap_fait"),',','_')) AS p_recap_fait,
	COALESCE(NULL,'us'||REPLACE(GROUP_CONCAT(DISTINCT r6."recap_us"),',','_')) AS p_recap_us,
	COALESCE(NULL,'iso'||REPLACE(GROUP_CONCAT(DISTINCT r7."recap_iso"),',','_')) AS p_recap_iso
FROM 
	(SELECT * FROM vue_recap_photo_photogram ORDER BY "recap_tr") AS r1
	,(SELECT * FROM vue_recap_photo_photogram ORDER BY "recap_sd") AS r2
	,(SELECT * FROM vue_recap_photo_photogram ORDER BY "recap_log") AS r3
	,(SELECT * FROM vue_recap_photo_photogram ORDER BY "recap_ens") AS r4
	,(SELECT * FROM vue_recap_photo_photogram ORDER BY "recap_fait") AS r5
	,(SELECT * FROM vue_recap_photo_photogram ORDER BY "recap_us") AS r6
	,(SELECT * FROM vue_recap_photo_photogram ORDER BY "recap_iso") AS r7
GROUP BY r1."id_photogram"
ORDER BY r1."id_photogram";

-- Vue d'exportation de la table t_us pour le stratifiant. Manque quelques champs : FPAestime (date estimée au plus ancien de fin de formation de l'US) ; FPRestime (date estimée au plus récent de fin de formation de l'US) ; REF_PhaseDebut (n° d'ordre de la phase au plus ancien attribué à l'US) ; REF_PhaseFin (n° d'ordre de la phase au plus récent attribué à l'US). Pour ces requêtes, j'ai besoin d'aide...
DROP VIEW IF EXISTS ExportUS;
CREATE VIEW ExportUS AS
SELECT "numus" AS ID_US, REPLACE(REPLACE( "type_us",'couche physique','couche'),'négative','négatif') AS Type_US, "datinf_interpret" AS FPA, "datsup_interpret" AS FPR
FROM t_us; 

-- Vue d'exportation de la table de relations stratigraphiques pour les relations d'antériorité/postériorié. Manque le champ RelationIncertaine rempli par NULL ou '?'
DROP VIEW IF EXISTS ExportRelations;
CREATE VIEW ExportRelations AS
SELECT DISTINCT CASE WHEN "typrel" LIKE 'sur' THEN "numus2" WHEN "typrel" LIKE 'sous' THEN "numus1" END AS REF_USanterieure, CASE WHEN "typrel" LIKE 'sur' THEN "numus1" WHEN "typrel" LIKE 'sous' THEN "numus2" END AS REF_USposterieure
FROM j_rel_us
WHERE "typrel" IN ('sur', 'sous');

-- Vue d'exportation de la table de relations stratigraphiques pour les relations horizontales. Manque le champ RelationIncertaine rempli par NULL ou '?'
DROP VIEW IF EXISTS ExportSynchros;
CREATE VIEW ExportSynchros AS
SELECT DISTINCT CASE WHEN "typrel" IN ('égal','équivalent','égale','équivalente','synchrone') THEN "numus1" END AS REF_USsynchro1, CASE WHEN "typrel" IN ('égal','équivalent','égale','équivalente','synchrone') THEN "numus2" END AS REF_USsynchro2
FROM j_rel_us
WHERE "typrel" IN ('égal','équivalent','égale','équivalente','synchrone');

-- Vue de détection des erreurs d'écritures de relations stratigraphiques : sur une même US ou relations contradictoires 
DROP VIEW IF EXISTS erreur_saisie_strati;
CREATE VIEW erreur_saisie_strati AS
SELECT *, CASE WHEN r."REF_USanterieure" = r."REF_USposterieure"  THEN 'relation verticale sur la même US' WHEN s."REF_USsynchro1" = s."REF_USsynchro2" THEN 'relation horizontale sur la même US' WHEN r."REF_USanterieure"||r."REF_USposterieure" = r."REF_USposterieure"||r."REF_USanterieure" THEN 'relations stratigraphiques contradictoires' END AS nature_erreur
FROM ExportRelations AS r, ExportSynchros AS s
WHERE r."REF_USanterieure" = r."REF_USposterieure"
OR r."REF_USanterieure"||r."REF_USposterieure" = r."REF_USposterieure"||r."REF_USanterieure"
OR s."REF_USsynchro1" = s."REF_USsynchro2";

-- Vue recapitulative des us par sequence
DROP VIEW IF EXISTS recap_us_seq;
CREATE VIEW recap_us_seq AS
SELECT "num_seq", REPLACE(GROUP_CONCAT(DISTINCT "numus"),',',', ') AS recap_us 
FROM (SELECT * FROM t_us ORDER BY "numus") 
GROUP BY "num_seq" 
ORDER BY "numus";

-- Vue recapitulative des séquences par phase
DROP VIEW IF EXISTS recap_pha_seq;
CREATE VIEW recap_pha_seq AS
SELECT "numphase" as numphase, REPLACE(GROUP_CONCAT(DISTINCT "numseq"),',',', ') AS recap_seq
FROM (SELECT * FROM j_seq_phase ORDER BY "numseq")
GROUP BY "numphase" 
ORDER BY "numseq";

-- Vue recapitulative des phases par période
DROP VIEW IF EXISTS recap_per_pha;
CREATE VIEW recap_per_pha AS
SELECT "numperiode" as periode, REPLACE(GROUP_CONCAT(DISTINCT "numphase"),',',', ') as recap_phases
FROM (SELECT * FROM j_phase_per ORDER BY "numphase") as p
GROUP BY "numphase" 
ORDER BY "numperiod";

--Vue d'inventaire d'US
DROP VIEW IF EXISTS inventaire_us;
CREATE VIEW inventaire_us AS
SELECT t."numtr",u."numus",u."numfait",u."type_us",u."nature_us",u."interpret",u."description",u."forme",u."diam",u."dim_max",u."dim_min",u."epais",u."prof_app",
u."datinf_interpret",u."datsup_interpret",
CASE WHEN v."us_anterieur" IS NULL AND d."us_anterieur" IS NULL THEN '' 
WHEN v."us_anterieur" IS NULL THEN d."us_anterieur"
WHEN d."us_anterieur" IS NULL THEN v."us_anterieur"
WHEN d."us_anterieur"=v."us_anterieur" THEN d."us_anterieur"
ELSE v."us_anterieur"||', '||d."us_anterieur" END 
AS sur, 
CASE WHEN v."us_posterieur" IS NULL AND d."us_posterieur" IS NULL THEN '' 
WHEN v."us_posterieur" IS NULL THEN d."us_posterieur"
WHEN d."us_posterieur" IS NULL THEN v."us_posterieur"
WHEN d."us_posterieur"=v."us_posterieur" THEN d."us_posterieur"
ELSE v."us_posterieur"||', '||d."us_posterieur" END 
AS sous, 
CASE WHEN v."rel_horizontal" IS NULL AND d."rel_horizontal" IS NULL THEN '' 
WHEN v."rel_horizontal" IS NULL THEN d."rel_horizontal"
WHEN d."rel_horizontal" IS NULL THEN v."rel_horizontal"
WHEN d."rel_horizontal"=v."rel_horizontal" THEN d."rel_horizontal"
ELSE v."rel_horizontal"||', '||d."rel_horizontal" END 
AS synch, 
u."note",
u."num_seq" as numseq, ph."numphase", pe."numperiod"
FROM t_us AS u
LEFT JOIN j_rel_tranchee as t
ON u."numus"=t."numus"
LEFT JOIN vue_recap_relationus as v
ON u."numus"=v."numus"
LEFT JOIN vue_recap_relationus_deduite AS d
ON u."numus" =d."numus"
JOIN j_seq_phase AS ph ON ph."numseq" = u."num_seq"
JOIN j_phase_per AS pe ON ph."numphase" = pe."numphase" 
JOIN j_rel_us AS ur ON ur."numus1" = u."numus"
GROUP BY u."numus"
ORDER BY u."numus";

/*Vue de relations spatiales entre la table des faits et les tables t_tranchee, t_sondage et t_axe*/
DROP VIEW IF EXISTS vue_intersects_fait;
CREATE VIEW vue_intersects_fait AS
SELECT e."numens", f."numfait", t."numtr", s."numsd", a."id_axe", a."numaxe", "x_min_coupe", "y_min_coupe", "x_max_coupe", "y_max_coupe"
FROM t_fait AS f
JOIN t_tranchee AS t ON st_intersects(f.geometry, t.geometry)
JOIN t_sondage AS s ON st_intersects(f.geometry, s.geometry)
JOIN t_ens AS e ON st_intersects(f.geometry, e.geometry)
JOIN t_axe AS a ON st_intersects(f.geometry, a.geometry)
JOIN (SELECT "id_coupe", x(startpoint(geometry)) AS x_min_coupe, y(startpoint(geometry)) AS y_min_coupe, x(endpoint(geometry)) AS x_max_coupe, y(endpoint(geometry)) AS y_max_coupe FROM coupe_axe) AS c --sous-requête utilisée pour calculer les emprises des coupes pour lé généreation d'atlas mixte plan/coupe
ON c."id_coupe" = a."id_axe"
;

/*Vue de relations spatiales entre la table des US et les tranchées, sondages et axe*/
DROP VIEW IF EXISTS vue_intersects_us;
CREATE VIEW vue_intersects_us AS
SELECT u."numus", u."numfait", t."numtr", s."numsd", a."id_axe", a."numaxe"
FROM t_us AS u
JOIN t_fait AS f ON f."numfait" = u."numfait"
JOIN t_tranchee AS t ON CASE WHEN u.geometry IS NULL THEN st_intersects(f.geometry, t.geometry) ELSE st_intersects(u.geometry, t.geometry) END
JOIN t_sondage AS s ON CASE WHEN u.geometry IS NULL THEN st_intersects(f.geometry, s.geometry) ELSE st_intersects(u.geometry, s.geometry) END
JOIN t_axe AS a ON CASE WHEN u.geometry IS NULL THEN st_intersects(f.geometry, a.geometry) ELSE st_intersects(u.geometry, a.geometry) END
;


/*Les vues géométriques*/

-- Vue de visualisation des logs stratigraphiques
DROP VIEW IF EXISTS vue_log_stratigraphique;
CREATE VIEW vue_log_stratigraphique AS
SELECT t.*,l.numtr,l.zmin_log, CASE WHEN "zmin_uslog" is null THEN BuildMbr(t."numlog"-1, l."zmin_log", t."numlog"-0.75, "zmax_uslog", 2154) ELSE BuildMbr(t."numlog"-1, "zmin_uslog", t."numlog"-0.75, "zmax_uslog", 2154) END AS geometry 
FROM j_us_log AS t JOIN t_log AS l 
ON t."numlog" = l."numlog";
--Interprétation de la géométrie de la vue, voir ici : http://www.gaia-gis.it/gaia-sins/spatialite-cookbook/html/sp-view.html et référencement de la géométrie dans la table views_geometry_columns d'après la couche fantôme ghost_polygon_2154
INSERT INTO views_geometry_columns
    (view_name, view_geometry, view_rowid, f_table_name, f_geometry_column, read_only)
  VALUES ('vue_log_stratigraphique', 'geometry', 'id_us_log', 'ghost_polygon_2154', 'geometry','1');


--Pour Caviar table prescription
DROP VIEW IF EXISTS caviar_prescription;
CREATE VIEW caviar_prescription AS
   SELECT 
   "gid_caviar" as gid,
   "typemp",
   "numoa",
   "tranche",
   "geometry"
   FROM emprise;
 -- interprétation de la géométrie de la vue
INSERT INTO views_geometry_columns
    (view_name, view_geometry, view_rowid, f_table_name, f_geometry_column, read_only)
  VALUES ('caviar_prescription', 'geometry', 'numope', 'ghost_polygon_2154', 'geometry','1'); 

--Pour Caviar table ouverture
DROP VIEW IF EXISTS caviar_ouverture;
CREATE VIEW caviar_ouverture AS
   SELECT 
   e."gid_caviar" as gidoperef,
   o."numouvert",
   o."typouvert",
   o."geometry",
   o."id_ouverture"
   FROM emprise AS e, ouverture AS o;
 -- interprétation de la géométrie de la vue
INSERT INTO views_geometry_columns
    (view_name, view_geometry, view_rowid, f_table_name, f_geometry_column, read_only)
  VALUES ('caviar_ouverture', 'geometry', 'id_ouverture', 'ghost_polygon_2154', 'geometry','1');
  
--Pour Caviar table uniteobservation
DROP VIEW IF EXISTS caviar_uniteobservation;
CREATE VIEW caviar_uniteobservation AS
   SELECT 
   e."gid_caviar" as gidoperef,
   p."numpoly" AS "numunobs",
   p."typoly" AS "typunobs",
   p."interpret",
   p."datedebut",
   p."datefin",
   p."geometry",
   p."id_poly"
   FROM emprise AS e, poly AS p;
 -- interprétation de la géométrie de la vue
INSERT INTO views_geometry_columns
    (view_name, view_geometry, view_rowid, f_table_name, f_geometry_column, read_only)
  VALUES ('caviar_uniteobservation', 'geometry', 'id_poly', 'ghost_polygon_2154', 'geometry','1');
  
--Pour Caviar table uniteobservation point
DROP VIEW IF EXISTS caviar_uniteobservation_point;
CREATE VIEW caviar_uniteobservation_point AS
   SELECT 
   e."gid_caviar" as gidoperef,
   p."numpoint" AS "numunobs",
   p."typoint" AS "typunobs",
   p."interpret",
   p."datedebut",
   p."datefin",
   p."geometry",
   p."id_point"
   FROM emprise AS e, point AS p;
 -- interprétation de la géométrie de la vue
INSERT INTO views_geometry_columns
    (view_name, view_geometry, view_rowid, f_table_name, f_geometry_column, read_only)
  VALUES ('caviar_uniteobservation_point', 'geometry', 'id_point', 'ghost_point_2154', 'geometry','1');  
  
--Vue de translation des coupes sur le plan
--pour les axes
DROP VIEW IF EXISTS vue_axe_coupe_translate;
CREATE VIEW vue_axe_coupe_translate AS 
SELECT c."id_axe",a."numaxe",c."numinute",c."azimuth",c."alti", 
st_translate(c."geometry", x(startpoint(a."geometry"))-x(startpoint(c."geometry")),y(startpoint(a."geometry"))-y(startpoint(c."geometry")),0) AS geometry --requête de translation des coordonnées en coupe vers les coordonnées en plan
FROM coupe_axe AS c 
JOIN t_axe AS a ON a."id_axe" = c."id_axe";
--interprétation de la géométrie de la vue
INSERT INTO views_geometry_columns
    (view_name, view_geometry, view_rowid, f_table_name, f_geometry_column, read_only)
  VALUES ('vue_axe_coupe_translate', 'geometry', 'id_axe', 'ghost_polyline_2154', 'geometry','1');    
  
--pour les lignes
DROP VIEW IF EXISTS vue_line_coupe_translate;
CREATE VIEW vue_line_coupe_translate AS 
SELECT l."id_cpline",l."id_axe",a."numaxe","numfait","numus","typline","numsd", 
st_translate(l."geometry", x(startpoint(a."geometry"))-x(startpoint(c."geometry")),y(startpoint(a."geometry"))-y(startpoint(c."geometry")),0) AS geometry --requête de translation des coordonnées en coupe vers les coordonnées en plan
FROM coupe_line AS l 
JOIN coupe_axe AS c ON c."id_axe" = l."id_axe" 
JOIN t_axe AS a ON a."id_axe" = l."id_axe" ;
--interprétation de la géométrie de la vue
INSERT INTO views_geometry_columns
    (view_name, view_geometry, view_rowid, f_table_name, f_geometry_column, read_only)
  VALUES ('vue_line_coupe_translate', 'geometry', 'id_cpline', 'ghost_polyline_2154', 'geometry','1');    

--pour les polygones
DROP VIEW IF EXISTS vue_poly_coupe_translate;
CREATE VIEW vue_poly_coupe_translate AS 
SELECT p."id_cpoly",p."id_axe",a."numaxe","numfait","numus","typoly","detail","numsd", 
st_translate(p."geometry", x(startpoint(a."geometry"))-x(startpoint(c."geometry")),y(startpoint(a."geometry"))-y(startpoint(c."geometry")),0) as geometry --requête de translation des coordonnées en coupe vers les coordonnées en plan
FROM coupe_poly AS p 
JOIN coupe_axe AS c ON c."id_axe" = p."id_axe" 
JOIN t_axe AS a ON a."id_axe" = c."id_axe";
--interprétation de la géométrie de la vue
INSERT INTO views_geometry_columns
    (view_name, view_geometry, view_rowid, f_table_name, f_geometry_column, read_only)
  VALUES ('vue_poly_coupe_translate', 'geometry', 'id_cpoly', 'ghost_polygon_2154', 'geometry','1');   

--Vue de translation et rotation des coupes sur le plan
--pour les lignes
DROP VIEW IF EXISTS vue_line_coupe_translate_rotate;
CREATE VIEW vue_line_coupe_translate_rotate AS 
SELECT l."id_cpline",l."id_axe",a."numaxe","numfait","numus","typline","numsd", 
shiftcoords( rotatecoords( shiftcoords(l.geometry,-x(startpoint(a.geometry)),-y(startpoint(a.geometry))) ,c.azimuth-90) ,x(startpoint(a.geometry)),y(startpoint(a.geometry))) AS geometry --requête de translation des coordonnées en coupe vers les coordonnées en plan
FROM vue_line_coupe_translate AS l 
JOIN coupe_axe AS c ON c."id_axe" = l."id_axe" 
JOIN t_axe AS a ON a."id_axe" = l."id_axe" ;
--interprétation de la géométrie de la vue
INSERT INTO views_geometry_columns
    (view_name, view_geometry, view_rowid, f_table_name, f_geometry_column, read_only)
  VALUES ('vue_line_coupe_translate_rotate', 'geometry', 'id_cpline', 'ghost_polyline_2154', 'geometry','1');    

--pour les polygones
DROP VIEW IF EXISTS vue_poly_coupe_translate_rotate;
CREATE VIEW vue_poly_coupe_translate_rotate AS 
SELECT p."id_cpoly",p."id_axe",a."numaxe","numfait","numus","typoly","detail","numsd", 
shiftcoords(rotatecoords( shiftcoords(p.geometry,-x(startpoint(a.geometry)),-y(startpoint(a.geometry))) ,c.azimuth-90) ,x(startpoint(a.geometry)),y(startpoint(a.geometry))) as geometry --requête de translation des coordonnées en coupe vers les coordonnées en plan
FROM vue_poly_coupe_translate AS p 
JOIN coupe_axe AS c ON c."id_axe" = p."id_axe" 
JOIN t_axe AS a ON a."id_axe" = c."id_axe";
--interprétation de la géométrie de la vue
INSERT INTO views_geometry_columns
    (view_name, view_geometry, view_rowid, f_table_name, f_geometry_column, read_only)
  VALUES ('vue_poly_coupe_translate_rotate', 'geometry', 'id_cpoly', 'ghost_polygon_2154', 'geometry','1');  
  
--Vue de translation des US négatives en coupe sur un axe médian  
DROP VIEW IF EXISTS vue_cumulcoupe_us_negative;
CREATE VIEW vue_cumulcoupe_us_negative AS 
SELECT l."id_cpline",l."id_axe", "numaxe", "numus", "numfait", "numsd", 
shiftcoords(l."geometry", -x(st_centroid(l."geometry"))-10 ,0) AS geometry --requête de translation vers un axe médian à -10 m en X et en y = z
FROM coupe_line AS l 
JOIN coupe_axe AS a ON a.id_axe = l.id_axe 
WHERE "typline" LIKE 'US négative';
--interprétation de la géométrie de la vue
INSERT INTO views_geometry_columns
    (view_name, view_geometry, view_rowid, f_table_name, f_geometry_column, read_only)
  VALUES ('vue_cumulcoupe_us_negative', 'geometry', 'id_cpline', 'ghost_polyline_2154', 'geometry','1'); 

--Vue de pointage des erreurs de géométrie
DROP VIEW IF EXISTS erreur_geometry;
CREATE VIEW erreur_geometry AS
SELECT rowid, 'coupe_line' as "table", ST_ISVALIDREASON(geometry) as erreur_geometrie, ST_ISVALIDDETAIL(geometry) as geometry
FROM coupe_line
WHERE ST_ISVALID(geometry) = 0 
UNION
SELECT rowid, 'coupe_poly' as "table", ST_ISVALIDREASON(geometry) as erreur_geometrie, ST_ISVALIDDETAIL(geometry) as geometry
FROM coupe_poly
UNION
SELECT rowid, 'emprise' as "table", ST_ISVALIDREASON(geometry) as erreur_geometrie, ST_ISVALIDDETAIL(geometry) as geometry
FROM emprise
WHERE ST_ISVALID(geometry) = 0
UNION
SELECT rowid, 'ouverture' as "table", ST_ISVALIDREASON(geometry) as erreur_geometrie, ST_ISVALIDDETAIL(geometry) as geometry
FROM ouverture
WHERE ST_ISVALID(geometry) = 0
UNION
SELECT rowid, 'poly' as "table", ST_ISVALIDREASON(geometry) as erreur_geometrie, ST_ISVALIDDETAIL(geometry) as geometry
FROM poly
WHERE ST_ISVALID(geometry) = 0
UNION
SELECT rowid, 't_ens' as "table", ST_ISVALIDREASON(geometry) as erreur_geometrie, ST_ISVALIDDETAIL(geometry) as geometry
FROM t_ens
WHERE ST_ISVALID(geometry) = 0
UNION
SELECT rowid, 't_fait' as "table", ST_ISVALIDREASON(geometry) as erreur_geometrie, ST_ISVALIDDETAIL(geometry) as geometry
FROM t_fait
WHERE ST_ISVALID(geometry) = 0
UNION
SELECT rowid, 't_prodphotogram' as "table", ST_ISVALIDREASON(geometry) as erreur_geometrie, ST_ISVALIDDETAIL(geometry) as geometry
FROM t_prodphotogram
WHERE ST_ISVALID(geometry) = 0
UNION
SELECT rowid, 't_photogram' as "table", ST_ISVALIDREASON(geometry) as erreur_geometrie, ST_ISVALIDDETAIL(geometry) as geometry
FROM t_photogram
WHERE ST_ISVALID(geometry) = 0
UNION
SELECT rowid, 't_sondage' as "table", ST_ISVALIDREASON(geometry) as erreur_geometrie, ST_ISVALIDDETAIL(geometry) as geometry
FROM t_sondage
WHERE ST_ISVALID(geometry) = 0
UNION
SELECT rowid, 't_tranchee' as "table", ST_ISVALIDREASON(geometry) as erreur_geometrie, ST_ISVALIDDETAIL(geometry) as geometry
FROM t_tranchee
WHERE ST_ISVALID(geometry) = 0
UNION
SELECT rowid, 't_us' as "table", ST_ISVALIDREASON(geometry) as erreur_geometrie, ST_ISVALIDDETAIL(geometry) as geometry
FROM t_us
WHERE ST_ISVALID(geometry) = 0;
--interprétation de la géométrie de la vue
INSERT INTO views_geometry_columns
    (view_name, view_geometry, view_rowid, f_table_name, f_geometry_column, read_only)
  VALUES ('erreur_geometry', 'geometry', 'rowid', 'ghost_point_2154', 'geometry','1');  
  
/*Vue de projection des axes en plan en coupe. Attention ! Cette vue ne doit pas servir de support pour le dessin des coupes, son contenu, une fois consolider, doit intégrer la couche coupe_axe*/
DROP VIEW IF EXISTS vue_coupe_axe;
CREATE VIEW vue_coupe_axe AS 
SELECT "id_axe", "numaxe",
degrees(st_azimuth(st_startpoint(geometry),st_endpoint(geometry))) as azimuth,
st_length(geometry) as long_axe,
"alti",
"note",
makeline(makepoint((SUM(st_length(geometry)) OVER(ORDER BY "id_axe" ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW))-st_length(geometry)+"id_axe"* 5 - 5 , "alti"),
makepoint((SUM(st_length(geometry)) OVER(ORDER BY "id_axe" ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW))+"id_axe"* 5 - 5 ,"alti")) as geometry
FROM t_axe;
--interprétation de la géométrie de la vue
INSERT INTO views_geometry_columns
    (view_name, view_geometry, view_rowid, f_table_name, f_geometry_column, read_only)
  VALUES ('vue_coupe_axe', 'geometry', 'id_axe', 'ghost_polyline_2154', 'geometry','1'); 
  
----------------------------------------------------------------------------------------------------------------------
--LES TABLES, VUES ET TRIGGERS CI-APRÈS PERMETTENT LA CRÉATION D'ENTITÉ EN SÉRIES

/*Tables de création d'entité rapide pour le terrain*/
--Table de création
DROP TABLE IF EXISTS entite_rapide;
CREATE TABLE entite_rapide(
	"id_entite" INTEGER PRIMARY KEY,
	"id_serie" INTEGER REFERENCES "serie"("id_serie") DEFAULT NULL,
	"numentite" INTEGER, -- l'incrément créé à partir de la série sélectionnée dans "id_serie"
	"interpret" TEXT, -- permet d'ajouter une interprétation rapide
	"note" TEXT
	);
	
--Table de création de séries d'incrément par spécification du nombre de départ et du pas
DROP TABLE IF EXISTS serie;
CREATE TABLE serie(
	"id_serie" INTEGER PRIMARY KEY,
	"nombre_depart" INTEGER,
	"nombre_arrivee" INTEGER,
	"pas" INTEGER,
	"tablentite" TEXT,
	"note" TEXT
	); 

--Vue de récapitulation des numéros déjà saisi et à saisir sur les tables par série
DROP VIEW IF EXISTS vue_numaximum_serie;
CREATE VIEW vue_numaximum_serie AS
SELECT s."id_serie", 't_us' AS "tablentite", max(t."numus") AS "numaximum",
				CASE WHEN max(t."numus") IS NULL THEN s."nombre_depart" ELSE max(t."numus")+s."pas" END AS "new_numentite"
				FROM serie AS s 
				LEFT JOIN t_us AS t ON t."numus" >= s."nombre_depart" AND t."numus" <= s."nombre_arrivee"
				WHERE s."tablentite" like 't_us'
				GROUP BY s."id_serie"
				UNION
				SELECT s."id_serie", 't_fait' AS "tablentite", max(t."numfait") AS "numaximum",
				CASE WHEN max(t."numfait") IS NULL THEN s."nombre_depart" ELSE max(t."numfait")+s."pas" END AS "new_numentite"
				FROM serie AS s 
				LEFT JOIN t_fait AS t ON t."numfait" >= s."nombre_depart" AND t."numfait" <= s."nombre_arrivee"
				WHERE s."tablentite" like 't_fait'
				GROUP BY s."id_serie"
				UNION
				SELECT s."id_serie", 't_axe' AS "tablentite", max(t."numaxe") AS "numaximum",
				CASE WHEN max(t."numaxe") IS NULL THEN s."nombre_depart" ELSE max(t."numaxe")+s."pas" END AS "new_numentite"
				FROM serie AS s
				LEFT JOIN t_axe AS t ON t."numaxe" >= s."nombre_depart" AND t."numaxe" <= s."nombre_arrivee"
				WHERE s."tablentite" like 't_axe'
				GROUP BY s."id_serie"
				UNION
				SELECT s."id_serie", 't_ens' AS "tablentite", max(t."numens") AS "numaximum",
				CASE WHEN max(t."numens") IS NULL THEN s."nombre_depart" ELSE max(t."numens")+s."pas" END AS "new_numentite"
				FROM serie AS s
				LEFT JOIN t_ens AS t ON t."numens" >= s."nombre_depart" AND t."numens" <= s."nombre_arrivee"
				WHERE s."tablentite" like 't_ens'
				GROUP BY s."id_serie"
				UNION
				SELECT s."id_serie", 't_log' AS "tablentite", max(t."numlog") AS "numaximum",
				CASE WHEN max(t."numlog") IS NULL THEN s."nombre_depart" ELSE max(t."numlog")+s."pas" END AS "new_numentite"
				FROM serie AS s
				LEFT JOIN t_log AS t ON t."numlog" >= s."nombre_depart" AND t."numlog" <= s."nombre_arrivee"
				WHERE s."tablentite" like 't_log'
				GROUP BY s."id_serie"
				UNION
				SELECT s."id_serie", 't_mobilier' AS "tablentite", max(t."numiso") AS "numaximum",
				CASE WHEN max(t."numiso") IS NULL THEN s."nombre_depart" ELSE max(t."numiso")+s."pas" END AS "new_numentite"
				FROM serie AS s
				LEFT JOIN t_mobilier AS t ON t."numiso" >= s."nombre_depart" AND t."numiso" <= s."nombre_arrivee"
				WHERE s."tablentite" like 't_mobilier'
				GROUP BY s."id_serie"
				UNION
				SELECT s."id_serie", 't_prelevement' AS "tablentite", max(t."numprel") AS "numaximum",
				CASE WHEN max(t."numprel") IS NULL THEN s."nombre_depart" ELSE max(t."numprel")+s."pas" END AS "new_numentite"
				FROM serie AS s
				LEFT JOIN t_prelevement AS t ON t."numprel" >= s."nombre_depart" AND t."numprel" <= s."nombre_arrivee"
				WHERE s."tablentite" like 't_prelevement'
				GROUP BY s."id_serie"
				UNION
				SELECT s."id_serie", 't_sondage' AS "tablentite", max(t."numsd") AS "numaximum",
				CASE WHEN max(t."numsd") IS NULL THEN s."nombre_depart" ELSE max(t."numsd")+s."pas" END AS "new_numentite"
				FROM serie AS s
				LEFT JOIN t_sondage AS t ON t."numsd" >= s."nombre_depart" AND t."numsd" <= s."nombre_arrivee"
				WHERE s."tablentite" like 't_sondage'
				GROUP BY s."id_serie"
				UNION
				SELECT s."id_serie", 't_tranchee' AS "tablentite", max(t."numtr") AS "numaximum",
				CASE WHEN max(t."numtr") IS NULL THEN s."nombre_depart" ELSE max(t."numtr")+s."pas" END AS "new_numentite"
				FROM serie AS s
				LEFT JOIN t_tranchee AS t ON t."numtr" >= s."nombre_depart" AND t."numtr" <= s."nombre_arrivee"
				WHERE s."tablentite" like 't_tranchee'
				GROUP BY s."id_serie"
;

/*Trigger associé aux tables de création rapide pour l'ajout du nouveau numéro d'entité*/
DROP TRIGGER IF EXISTS trgai_entite_rapide_newnumentite;
CREATE TRIGGER trgai_entite_rapide_newnumentite
	AFTER INSERT
	ON entite_rapide
	FOR EACH ROW
	WHEN NEW."id_serie" IS NOT NULL
		BEGIN
		UPDATE entite_rapide SET "numentite" = 
			(SELECT "new_numentite" 
			FROM (
				SELECT e."id_entite", 't_us' AS "tablentite", max(t."numus") AS "numaximum",
				CASE WHEN max(t."numus") IS NULL THEN s."nombre_depart" ELSE max(t."numus")+s."pas" END AS "new_numentite"
				FROM entite_rapide AS e 
				LEFT JOIN serie AS s ON e."id_serie" = s."id_serie"
				LEFT JOIN t_us AS t ON t."numus" >= s."nombre_depart" AND t."numus" <= s."nombre_arrivee"
				WHERE s."tablentite" like 't_us'
				GROUP BY s."id_serie"
				UNION
				SELECT e."id_entite", 't_fait' AS "tablentite", max(t."numfait") AS "numaximum",
				CASE WHEN max(t."numfait") IS NULL THEN s."nombre_depart" ELSE max(t."numfait")+s."pas" END AS "new_numentite"
				FROM entite_rapide AS e
				LEFT JOIN serie AS s ON e."id_serie" = s."id_serie"
				LEFT JOIN t_fait AS t ON t."numfait" >= s."nombre_depart" AND t."numfait" <= s."nombre_arrivee"
				WHERE s."tablentite" like 't_fait'
				GROUP BY s."id_serie"
				UNION
				SELECT e."id_entite", 't_axe' AS "tablentite", max(t."numaxe") AS "numaximum",
				CASE WHEN max(t."numaxe") IS NULL THEN s."nombre_depart" ELSE max(t."numaxe")+s."pas" END AS "new_numentite"
				FROM entite_rapide AS e 
				LEFT JOIN serie AS s ON e."id_serie" = s."id_serie"
				LEFT JOIN t_axe AS t ON t."numaxe" >= s."nombre_depart" AND t."numaxe" <= s."nombre_arrivee"
				WHERE s."tablentite" like 't_axe'
				GROUP BY s."id_serie"
				UNION
				SELECT e."id_entite", 't_ens' AS "tablentite", max(t."numens") AS "numaximum",
				CASE WHEN max(t."numens") IS NULL THEN s."nombre_depart" ELSE max(t."numens")+s."pas" END AS "new_numentite"
				FROM entite_rapide AS e
				LEFT JOIN serie AS s ON e."id_serie" = s."id_serie"
				LEFT JOIN t_ens AS t ON t."numens" >= s."nombre_depart" AND t."numens" <= s."nombre_arrivee"
				WHERE s."tablentite" like 't_ens'
				GROUP BY s."id_serie"
				UNION
				SELECT e."id_entite", 't_log' AS "tablentite", max(t."numlog") AS "numaximum",
				CASE WHEN max(t."numlog") IS NULL THEN s."nombre_depart" ELSE max(t."numlog")+s."pas" END AS "new_numentite"
				FROM entite_rapide AS e
				LEFT JOIN serie AS s ON e."id_serie" = s."id_serie"
				LEFT JOIN t_log AS t ON t."numlog" >= s."nombre_depart" AND t."numlog" <= s."nombre_arrivee"
				WHERE s."tablentite" like 't_log'
				GROUP BY s."id_serie"
				UNION
				SELECT e."id_entite", 't_mobilier' AS "tablentite", max(t."numiso") AS "numaximum",
				CASE WHEN max(t."numiso") IS NULL THEN s."nombre_depart" ELSE max(t."numiso")+s."pas" END AS "new_numentite"
				FROM entite_rapide AS e
				LEFT JOIN serie AS s ON e."id_serie" = s."id_serie"
				LEFT JOIN t_mobilier AS t ON t."numiso" >= s."nombre_depart" AND t."numiso" <= s."nombre_arrivee"
				WHERE s."tablentite" like 't_mobilier'
				GROUP BY s."id_serie"
				UNION
				SELECT e."id_entite", 't_prelevement' AS "tablentite", max(t."numprel") AS "numaximum",
				CASE WHEN max(t."numprel") IS NULL THEN s."nombre_depart" ELSE max(t."numprel")+s."pas" END AS "new_numentite"
				FROM entite_rapide AS e
				LEFT JOIN serie AS s ON e."id_serie" = s."id_serie"
				LEFT JOIN t_prelevement AS t ON t."numprel" >= s."nombre_depart" AND t."numprel" <= s."nombre_arrivee"
				WHERE s."tablentite" like 't_prelevement'
				GROUP BY s."id_serie"
				UNION
				SELECT e."id_entite", 't_sondage' AS "tablentite", max(t."numsd") AS "numaximum",
				CASE WHEN max(t."numsd") IS NULL THEN s."nombre_depart" ELSE max(t."numsd")+s."pas" END AS "new_numentite"
				FROM entite_rapide AS e
				LEFT JOIN serie AS s ON e."id_serie" = s."id_serie"
				LEFT JOIN t_sondage AS t ON t."numsd" >= s."nombre_depart" AND t."numsd" <= s."nombre_arrivee"
				WHERE s."tablentite" like 't_sondage'
				GROUP BY s."id_serie"
				UNION
				SELECT e."id_entite", 't_tranchee' AS "tablentite", max(t."numtr") AS "numaximum",
				CASE WHEN max(t."numtr") IS NULL THEN s."nombre_depart" ELSE max(t."numtr")+s."pas" END AS "new_numentite"
				FROM entite_rapide AS e
				LEFT JOIN serie AS s ON e."id_serie" = s."id_serie"
				LEFT JOIN t_tranchee AS t ON t."numtr" >= s."nombre_depart" AND t."numtr" <= s."nombre_arrivee"
				WHERE s."tablentite" like 't_tranchee'
				GROUP BY s."id_serie")
			WHERE NEW."id_entite" = "id_entite");
			DELETE FROM entite_rapide;
END;


				
/*Trigger associé à la table de création d'entité rapide qui permet d'ajouter les enregistrements dans les tables ciblées*/

--pour t_axe
CREATE TRIGGER trgau_t_axe_maj_entite_rapide
   AFTER UPDATE OF "numentite"
   ON entite_rapide
FOR EACH ROW
	WHEN NEW."numentite" IS NOT NULL AND (SELECT s."tablentite" FROM entite_rapide AS e JOIN serie AS s ON OLD."id_serie" = s."id_serie") like 't_axe'
	BEGIN
	INSERT INTO t_axe("numaxe","geometry","note") VALUES (NEW."numentite", NULL,NEW."note");
END;

--pour t_ens
CREATE TRIGGER trgau_t_ens_maj_entite_rapide
   AFTER UPDATE OF "numentite"
   ON entite_rapide
FOR EACH ROW
	WHEN NEW."numentite" IS NOT NULL AND (SELECT s."tablentite" FROM entite_rapide AS e JOIN serie AS s ON OLD."id_serie" = s."id_serie") like 't_ens'
	BEGIN
	INSERT INTO t_ens("numens","typens","geometry","note") VALUES (NEW."numentite", NEW."interpret",NULL,NEW."note");
END;

--pour t_fait
CREATE TRIGGER trgau_t_fait_maj_entite_rapide
   AFTER UPDATE OF "numentite"
   ON entite_rapide
FOR EACH ROW
	WHEN NEW."numentite" IS NOT NULL AND (SELECT s."tablentite" FROM entite_rapide AS e JOIN serie AS s ON OLD."id_serie" = s."id_serie") like 't_fait'
	BEGIN
	INSERT INTO t_fait("numfait","interpret","geometry","note") VALUES (NEW."numentite",NEW."interpret",NULL,NEW."note");
END;

--pour t_log
CREATE TRIGGER trgau_t_log_maj_entite_rapide
   AFTER UPDATE OF "numentite"
   ON entite_rapide
FOR EACH ROW
	WHEN NEW."numentite" IS NOT NULL AND (SELECT s."tablentite" FROM entite_rapide AS e JOIN serie AS s ON OLD."id_serie" = s."id_serie") like 't_log'
	BEGIN
	INSERT INTO t_log("numlog","geometry","note_log") VALUES (NEW."numentite", NULL,NEW."note");
END;

--pour t_mobilier
CREATE TRIGGER trgau_t_mobilier_maj_entite_rapide
   AFTER UPDATE OF "numentite"
   ON entite_rapide
FOR EACH ROW
	WHEN NEW."numentite" IS NOT NULL AND (SELECT s."tablentite" FROM entite_rapide AS e JOIN serie AS s ON OLD."id_serie" = s."id_serie") like 't_mobilier'
	BEGIN
	INSERT INTO t_mobilier("numiso","matiere","geometry","note") VALUES (NEW."numentite", NEW."interpret",NULL,NEW."note");
END;

--pour t_prelevement
CREATE TRIGGER trgau_t_prelevement_maj_entite_rapide
   AFTER UPDATE OF "numentite"
   ON entite_rapide
FOR EACH ROW
	WHEN NEW."numentite" IS NOT NULL AND (SELECT s."tablentite" FROM entite_rapide AS e JOIN serie AS s ON OLD."id_serie" = s."id_serie") like 't_prelevement'
	BEGIN
	INSERT INTO t_prelevement("numprel","geometry","note") VALUES (NEW."numentite", NULL,NEW."note");
END;

--pour t_sondage
CREATE TRIGGER trgau_t_sondage_maj_entite_rapide
   AFTER UPDATE OF "numentite"
   ON entite_rapide
FOR EACH ROW
	WHEN NEW."numentite" IS NOT NULL AND (SELECT s."tablentite" FROM entite_rapide AS e JOIN serie AS s ON OLD."id_serie" = s."id_serie") like 't_sondage'
	BEGIN
	INSERT INTO t_sondage("numsd","geometry","note") VALUES (NEW."numentite", NULL,NEW."note");
END;

--pour t_tranchee
CREATE TRIGGER trgau_t_tranchee_maj_entite_rapide
   AFTER UPDATE OF "numentite"
   ON entite_rapide
FOR EACH ROW
	WHEN NEW."numentite" IS NOT NULL AND (SELECT s."tablentite" FROM entite_rapide AS e JOIN serie AS s ON OLD."id_serie" = s."id_serie") like 't_tranchee'
	BEGIN
	INSERT INTO t_tranchee("numtr","geometry","note") VALUES (NEW."numentite", NULL,NEW."note");
END;

--pour t_us
CREATE TRIGGER trgau_t_us_maj_entite_rapide
   AFTER UPDATE OF "numentite"
   ON entite_rapide
FOR EACH ROW
	WHEN NEW."numentite" IS NOT NULL AND (SELECT s."tablentite" FROM entite_rapide AS e JOIN serie AS s ON OLD."id_serie" = s."id_serie") like 't_us'
	BEGIN
	INSERT INTO t_us("numus","nature_us","geometry","note") VALUES (NEW."numentite", NEW."interpret",NULL,NEW."note");
END;
