# -*- coding: utf-8 -*-
"""
/***************************************************************************
 BAD
                                 A QGIS plugin
 BAD_Burned Area Detector
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-01-24
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Thomas Martinoli
        email                : th.martinoli96@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
from osgeo import gdal
import numpy as np
from datetime import datetime

#new libraries
import requests
import pandas as pd
from pyproj import CRS, Transformer
import json


# Initialize Qt resources from file resources.py
from .resources import *
class SentinelSearch:
    def __init__(self,aoi,Start_date,End_date,Cloud,Limit_num,order):
        
        catalogue_odata_url = "https://catalogue.dataspace.copernicus.eu/odata/v1"
        collection_name = "SENTINEL-2"
        product_type = "S2MSI2A"
        search_period_start = f"{Start_date}T00:00:00.000Z"
        search_period_end = f"{End_date}T00:00:00.000Z"

        search_query = f"{catalogue_odata_url}/Products?$filter=Collection/Name eq '{collection_name}' and Attributes/OData.CSC.StringAttribute/any(att:att/Name eq 'productType' and att/OData.CSC.StringAttribute/Value eq '{product_type}') and Attributes/OData.CSC.DoubleAttribute/any(att:att/Name eq 'cloudCover' and att/OData.CSC.DoubleAttribute/Value le {Cloud}) and OData.CSC.Intersects(area=geography'SRID=4326;{aoi}') and ContentDate/Start gt {search_period_start} and ContentDate/Start lt {search_period_end}&$top={Limit_num}&$orderby=ContentDate/Start {order}"

        print(f"""\n{search_query.replace(' ', "%20")}\n""")
        response = requests.get(search_query).json()
        self.result = pd.DataFrame.from_dict(response["value"])
        if not self.result.empty:
            print(self.result['Name'])
            print(self.result.columns)
        else:
            self.result = pd.DataFrame({'Name': ["No available data for the given dates. Please select a different time period."]})
            print(self.result['Name'])

def get_sorted_percentage(table_widget):
    row_count = table_widget.rowCount()
    
    data_to_sort = []
    for row in range(row_count):
        item_col0 = table_widget.item(row, 0).text()
        item_col2 = table_widget.item(row, 2).text().replace("%","")

        value_col2_for_sort = float(item_col2) if item_col2 else float('inf') 

        # Conserva la tupla: (valore_ordinamento, valore_estratto)
        data_to_sort.append((value_col2_for_sort, item_col0))

    sorted_data = sorted(data_to_sort)
    result_list = [item[1] for item in sorted_data]
    
    return result_list

def get_sorted_date(table_widget):
    row_count = table_widget.rowCount()
    data_to_sort = []
    for row in range(row_count):
        item_col0 = table_widget.item(row, 0).text()
        data_to_sort.append(item_col0)
    sorted_data = sorted(data_to_sort, key=lambda x: datetime.strptime(x, "%Y-%m-%d"))
    print("Sorted data:",sorted_data)
    return sorted_data
            
def transform_bbox_to_utm(bbox):
        lon_center = (bbox[0] + bbox[2]) / 2
        lat_center = (bbox[1] + bbox[3]) / 2
        
        # Find UTM zone
        utm_zone = int((lon_center + 180) / 6) + 1
        epsg_code = 32600 + utm_zone if lat_center >= 0 else 32700 + utm_zone
        utm_crs_url = f"http://www.opengis.net/def/crs/EPSG/0/{epsg_code}"
        
        crs_wgs84 = CRS.from_epsg(4326)
        crs_utm = CRS.from_epsg(epsg_code)
        transformer = Transformer.from_crs(crs_wgs84, crs_utm, always_xy=True)
        
        utm_w, utm_s = transformer.transform(bbox[0], bbox[1])
        utm_e, utm_n = transformer.transform(bbox[2], bbox[3])
        utm_bbox_list = [utm_w, utm_s, utm_e, utm_n]
        
        return utm_crs_url, utm_bbox_list

def calculate_ndvi(red_band, nir_band):

    np.seterr(divide='ignore', invalid='ignore')
    
    denominator = nir_band + red_band
    ndvi = np.divide(nir_band - red_band, 
                     denominator, 
                     out=np.full_like(denominator, -2.0), 
                     where=denominator != 0)

    np.seterr(divide='warn', invalid='warn')
    
    ndvi[~np.isfinite(ndvi)] = -2.0 
    return ndvi
def calculate_nbr(swir_band,nir_band):

    np.seterr(divide='ignore', invalid='ignore')

    denominator = nir_band + swir_band
    nbr = np.divide(nir_band - swir_band, 
                    denominator, 
                    out=np.full_like(denominator, -2.0), 
                    where=denominator != 0)

    np.seterr(divide='warn', invalid='warn')

    nbr[~np.isfinite(nbr)] = -2.0 
    return nbr

#Creates the composite based on the maximum NDVI/NBR values
def create_composite(raster_file_list, output_file_path,ChoiceMosaicking, pre=True):
    print("Choice mosaicking",ChoiceMosaicking)

    if not raster_file_list:
        print("Error: list of input raster is empty")
        return

    try:
        print(f"Initializing first raster: {raster_file_list[0]}")
        ds_first = gdal.Open(raster_file_list[0], gdal.GA_ReadOnly)
        if ds_first is None:
            raise Exception(f"Unable to open file: {raster_file_list[0]}")

        # Get metadata
        x_size = ds_first.RasterXSize
        y_size = ds_first.RasterYSize
        geotransform = ds_first.GetGeoTransform()
        projection = ds_first.GetProjection()
        band_count = ds_first.RasterCount

        # Determine the output data type (es. GDT_UInt16)
        output_dtype = ds_first.GetRasterBand(1).DataType
        numpy_dtype = gdal.GetDataTypeName(output_dtype).lower()
        output_bands_data = np.zeros((band_count, y_size, x_size), dtype=np.dtype(numpy_dtype))
        for b in range(1, band_count + 1):
            output_bands_data[b-1] = ds_first.GetRasterBand(b).ReadAsArray()
        ds_first = None
        
        # If pre is True, calculate NDVI; else calculate NBR
        if pre and ChoiceMosaicking=="Index":
            red_data = output_bands_data[3].astype(np.float32)
            nir_data = output_bands_data[7].astype(np.float32)
            reference_grid = calculate_ndvi(red_data, nir_data)
        elif not pre and ChoiceMosaicking=="Index":
            nir_data = output_bands_data[7].astype(np.float32)
            swir_data = output_bands_data[11].astype(np.float32)
            reference_grid = calculate_nbr(swir_data, nir_data)
        scl_data = output_bands_data[12]
        old_mask_with_clouds = (scl_data == 0) |(scl_data == 1) |(scl_data == 3) | (scl_data == 8) | (scl_data == 9) | (scl_data == 10)

    except Exception as e:
        print(f"Fatal error while processing first raster file: {e}")
        return

    # --- 2. Iteration on the remaining raster files ---
    for raster_path in raster_file_list[1:]:
        try:
            print(f"Analysis of: {raster_path}")
            ds = gdal.Open(raster_path, gdal.GA_ReadOnly)
            if ds is None:
                print(f" Warning, impossible opening {raster_path}. Skipping.")
                continue

            if ds.RasterXSize != x_size or ds.RasterYSize != y_size or ds.RasterCount != band_count:
                print(f"  Warning: {raster_path} has uncoherent metadata. Skipping.")
                ds = None
                continue

            scl_data = ds.GetRasterBand(13).ReadAsArray()
            cloud_shadow_mask = (scl_data == 0) |(scl_data == 1) |(scl_data == 3) | (scl_data == 8) | (scl_data == 9) | (scl_data == 10)
            if ChoiceMosaicking=="Index":
                if pre:
                    red_data = ds.GetRasterBand(4).ReadAsArray().astype(np.float32)
                    nir_data = ds.GetRasterBand(8).ReadAsArray().astype(np.float32)
                    current_value = calculate_ndvi(red_data, nir_data)
                    update_mask = (((current_value >= reference_grid) & (~cloud_shadow_mask)))|old_mask_with_clouds
                else:
                    nir_data = ds.GetRasterBand(8).ReadAsArray().astype(np.float32)
                    swir_data = ds.GetRasterBand(12).ReadAsArray().astype(np.float32)
                    current_value = calculate_nbr(swir_data, nir_data)
                    update_mask = (((current_value <= reference_grid) & (~cloud_shadow_mask)))|old_mask_with_clouds
                # Update the grid to the maximum NDVI/minimum NBR
                reference_grid[update_mask] = current_value[update_mask]
            elif ChoiceMosaicking=="Date":
                update_mask = old_mask_with_clouds & (~cloud_shadow_mask)

            # If there are no pixels to update, pass to the next file
            if not np.any(update_mask):
                ds = None
                continue
            # Update the output band data using the mask
            for b in range(1, band_count + 1):
                current_band_data = ds.GetRasterBand(b).ReadAsArray()
                output_bands_data[b-1][update_mask] = current_band_data[update_mask]
            ds = None 
            scl_data = output_bands_data[12]
            old_mask_with_clouds = (scl_data == 0) |(scl_data == 1) |(scl_data == 3) | (scl_data == 8) | (scl_data == 9) | (scl_data == 10)

        except Exception as e:
            print(f"  Error during the processing of {raster_path}: {e}. Skipping.")
            continue

    # --- 3. Writing of the output file ---
    try:
        print(f"\nWriting final raster: {output_file_path}")
        driver = gdal.GetDriverByName("GTiff")
        out_ds = driver.Create(output_file_path, x_size, y_size, band_count, output_dtype,
                               options=['COMPRESS=LZW', 'TILED=YES'])
        
        if out_ds is None:
            raise Exception("Impossible to create the GEOFiff file.")

        out_ds.SetGeoTransform(geotransform)
        out_ds.SetProjection(projection)

        for b in range(1, band_count + 1):
            out_band = out_ds.GetRasterBand(b)
            # Write the data from the NumPy array to memory
            out_band.WriteArray(output_bands_data[b-1])
            out_band.FlushCache()
        
        out_ds = None # Close and save the file definitively
        print("Process completed")

    except Exception as e:
        print(f"Fatal error while writing the output: {e}")

def Downloadsh(BBOX,date,cloud,output_name,username,password,choice,pre,ChoiceMosaicking):
    token_url = "https://identity.dataspace.copernicus.eu/auth/realms/CDSE/protocol/openid-connect/token"
    token_data = {
        "grant_type": "client_credentials",
        "client_id": username,
        "client_secret": password
    }
    token_response = requests.post(token_url, data=token_data)
    access_token = token_response.json().get("access_token")
    PROCESS_API_URL = "https://sh.dataspace.copernicus.eu/api/v1/process"
    UTM_CRS_URL, UTM_BBOX = transform_bbox_to_utm(BBOX)
    EVALSCRIPT = """
    function setup() {
    return {
        input: [
        {
            bands: ["B01", "B02", "B03", "B04", "B05", "B06", "B07", "B08", "B8A", "B09", "B11", "B12", "SCL"],
            units: "DN" 
        }
        ],
        output: [
        {
            id: "default",
            bands: 13,
            sampleType: "UINT16"
        }
        ]
    }
    }
    function evaluatePixel(samples) {
        return [
            samples.B01, samples.B02, samples.B03, samples.B04, samples.B05, samples.B06,
            samples.B07, samples.B08, samples.B8A, samples.B09, samples.B11, samples.B12, samples.SCL
        ];
    }
    """
    if choice==1:
        request_payload = {
            "input": {
                "bounds": {
                    "bbox": UTM_BBOX,
                    "properties": {
                        "crs": UTM_CRS_URL
                    }
                },
                "data": [
                    {
                        "type": "sentinel-2-l2a",
                        "dataFilter": {
                            "timeRange": {
                                "from": f"{date}T00:00:00Z",
                                "to": f"{date}T23:59:59Z",
                            }
                        },
                        "maxCloudCoverage": cloud,
                    }
                ],
            },
            "output": {
                "resx": 10,  
                "resy": 10,  
                "crs": UTM_CRS_URL,
                "responses": [
                    {
                        "identifier": "default",
                        "format": {
                            "type": "image/tiff"
                        }
                    }
                ]
            },
            "evalscript": EVALSCRIPT
        }
    if choice==0:
        request_payload=[]
        for date_item in date:
            request_payload.append({
                "input": {
                    "bounds": {
                    "bbox": UTM_BBOX,
                    "properties": {
                        "crs": UTM_CRS_URL
                    }
                },
                "data": [
                    {
                        "type": "sentinel-2-l2a",
                        "dataFilter": {
                            "timeRange": {
                                "from": f"{date_item}T00:00:00Z",
                                "to": f"{date_item}T23:59:59Z",
                            }
                        },
                        "maxCloudCoverage": cloud,
                    }
                ],
            },
            "output": {
                "resx": 10,  
                "resy": 10,  
                "crs": UTM_CRS_URL,
                "responses": [
                    {
                        "identifier": "default",
                        "format": {
                            "type": "image/tiff"
                        }
                    }
                ]
            },
            "evalscript": EVALSCRIPT
            })
    headers = {
        "Content-Type": "application/json",
        "Authorization": f"Bearer {access_token}"
    }
    if choice==1:
        try:
            response = requests.post(
                PROCESS_API_URL,
                headers=headers,
                json=request_payload,
                stream=True 
            )
            response.raise_for_status()

            with open(output_name, 'wb') as f:
                for chunk in response.iter_content(chunk_size=8192):
                    f.write(chunk)

        except requests.exceptions.HTTPError as e:
            print(f"Error HTTP: {e}")
            try:
                error_details = response.json()
                print(f"Error (Sentinel Hub): {json.dumps(error_details, indent=2)}")
                return error_details
            except Exception:
                print("No details about the error.")
                return e

        except requests.exceptions.RequestException as e:
            print(f"Connection error: {e}")
    if choice==0:
        list_outputs=[]
        for idx, payload in enumerate(request_payload):
            try:
                response = requests.post(
                    PROCESS_API_URL,
                    headers=headers,
                    json=payload,
                    stream=True 
                )
                response.raise_for_status()

                output_file = f"{output_name.split('.tif')[0]}_{idx+1}.tif"
                with open(output_file, 'wb') as f:
                    for chunk in response.iter_content(chunk_size=8192):
                        f.write(chunk)
                list_outputs.append(output_file)

            except requests.exceptions.HTTPError as e:
                print(f"Error HTTP: {e}")
                try:
                    error_details = response.json()
                    print(f"Error (Sentinel Hub): {json.dumps(error_details, indent=2)}")
                    return error_details
                except Exception:
                    print("No details about the error.")
                    return e

            except requests.exceptions.RequestException as e:
                print(f"Connection error: {e}")
        create_composite(list_outputs, output_name, ChoiceMosaicking, pre)
        for file in list_outputs:
            os.remove(file)
    return 1
class ReadingData:
    def __init__(self,First_path,Second_path):

        First_raster = gdal.Open(First_path, gdal.GA_ReadOnly) 
        Second_raster = gdal.Open(Second_path, gdal.GA_ReadOnly) 
        # Note GetRasterBand() takes band no. starting from 1 not 0

        First_matrix=First_raster.ReadAsArray()
        Second_matrix=Second_raster.ReadAsArray()

        self.FirstMatrix=First_matrix.astype(float)
        self.SecondMatrix=Second_matrix.astype(float)

        #self.Delta_matrix=S-F
      
        self.Bands=First_raster.RasterCount
        self.gt = First_raster.GetGeoTransform()
        self.proj= First_raster.GetProjection()

class MembershipFunction:
    def __init__(self,Matrix,K,x):
        
        self.MD=1/(1+np.exp(-K*(Matrix/10000-x)))
        
class OrderedWeigthAverage:
    def __init__(self,FinalBandMatix,w=None):
        
        Row=FinalBandMatix.shape[1]
        Column=FinalBandMatix.shape[2]
        self.Integrated_matrix=np.empty([Row,Column])
        for i in range (Row):
            for j in range (Column):
                vector=FinalBandMatix[:,i,j] 
                if (np.isnan(vector).any()):
                    value=np.nan
                else:
                    value=np.dot(np.sort(vector)[::-1],w)
                self.Integrated_matrix[i,j]=value

def Qfunction(a,b,x):
    if x>=b:
        return 1
    if x<=a:
        return 0
    return (x-a)/(b-a)
        
class WriteLayer:
    def __init__(self,index,path,Matrix,NameBands,Nband,Xsize,Ysize,filename,gt,proj):
    
        if index==0:
            # if index zero means that the user has not specified anything
            # so I must transform the path to save the file in .tif format
            array_path=path.split('/')
            array_path[-1]=filename
            splitter="/"
            self.output_path=splitter.join(array_path)
        else:
            self.output_path=path

        driver = gdal.GetDriverByName("GTiff")
        driver.Register()
        outds = driver.Create(self.output_path, xsize=Xsize,ysize=Ysize,bands=Nband, eType= gdal.GDT_Float32)
        outds.SetGeoTransform(gt)
        outds.SetProjection(proj)
        if Nband==1:
            outband = outds.GetRasterBand(Nband)
            outband.WriteArray(Matrix)
            outband.SetDescription(NameBands)
            outband.FlushCache()
            outband= None
        else:
            for i in range(Nband):
                outband = outds.GetRasterBand(i+1)
                outband.WriteArray(Matrix[i])
                outband.SetDescription(NameBands[i])
                outband.FlushCache()
                outband= None
        outds = None

class RegionGrowing:
    def __init__(self,Seed_threshold,Grow_threshold,Seed_matrix,Grow_matrix):

        Mask = np.isnan(Seed_matrix)  # True where there are NaN

        Seed_binary = np.where(Seed_matrix < Seed_threshold, 0, 1)
        Grow_binary = np.where(Grow_matrix < Grow_threshold, 0, 1)

        # Set to NaN where there is Mask
        Seed_binary[Mask] = 999
        Grow_binary[Mask] = 999

        self.Raster=np.array([Seed_binary,Grow_binary])

        RasterPP=self.Raster.copy()

        sizeRow=RasterPP[0].shape[0]
        sizeColumn=RasterPP[0].shape[1]
        
        M=0
        N=np.count_nonzero(RasterPP[0])
        i=0
    
        while N!=M:
            M=N
            print('Iteration:',i,', Number of seeds:',N)
            i=i+1
            for j in range(sizeRow):
                for k in range(sizeColumn):
                                    
                    # Insertion of the neighbors that are not considered yet
                    
                    if RasterPP[0,j,k]==1:
                                            
                        # neighbor examination                
                        
                        # above-left   
                        if j>0 and k>0 and RasterPP[0,j-1,k-1]==0 and RasterPP[1,j-1,k-1]==1:
                            RasterPP[0,j-1,k-1]=1
                            
                        
                        # above
                        if j>0 and RasterPP[0,j-1,k]==0 and RasterPP[1,j-1,k]==1:
                            RasterPP[0,j-1,k]=1
                            
                        
                        #above-right
                        if j>0 and k<=sizeColumn-2 and RasterPP[0,j-1,k+1]==0 and RasterPP[1,j-1,k+1]==1:
                            RasterPP[0,j-1,k+1]=1
                            
                            
                        #left
                        if k>0 and RasterPP[0,j,k-1]==0 and RasterPP[1,j,k-1]==1:
                            RasterPP[0,j,k-1]=1
                            
                        #right
                        if k<=sizeColumn-2 and RasterPP[0,j,k+1]==0 and RasterPP[1,j,k+1]==1:
                            RasterPP[0,j,k+1]=1
                            
                        
                        #below-left    
                        if j<=sizeRow-2 and k>0 and RasterPP[0,j+1,k-1]==0 and RasterPP[1,j+1,k-1]==1:
                            RasterPP[0,j+1,k-1]=1
                            
                        
                        #below    
                        if j<=sizeRow-2 and RasterPP[0,j+1,k]==0 and RasterPP[1,j+1,k]==1:
                            RasterPP[0,j+1,k]=1
                            
                        
                        #below-right    
                        if j<=sizeRow-2 and k<=sizeColumn-2 and RasterPP[0,j+1,k+1]==0 and RasterPP[1,j+1,k+1]==1:
                            RasterPP[0,j+1,k+1]=1
                                                                                          
            # condition that blocks the while
            N=np.count_nonzero(RasterPP[0])
            
        self.Result_matrix=RasterPP[0]
        self.Result_matrix=np.where(self.Result_matrix==999,np.nan,self.Result_matrix)

class Classification:
    def __init__(self,Matrix,LowerLevelList,UpperLevelList):

        Matrix=np.round(Matrix,3)
        M_ERH = np.where((Matrix>=LowerLevelList[0])&(Matrix<=UpperLevelList[0]),1,0)
        M_ERL = np.where((Matrix>=LowerLevelList[1])&(Matrix<=UpperLevelList[1]),2,0)
        M_U = np.where((Matrix>=LowerLevelList[2])&(Matrix<=UpperLevelList[2]),3,0)
        M_L = np.where((Matrix>=LowerLevelList[3])&(Matrix<=UpperLevelList[3]),4,0)
        M_ML = np.where((Matrix>=LowerLevelList[4])&(Matrix<=UpperLevelList[4]),5,0)
        M_MH = np.where((Matrix>=LowerLevelList[5])&(Matrix<=UpperLevelList[5]),6,0)
        M_H = np.where((Matrix>=LowerLevelList[6])&(Matrix<=UpperLevelList[6]),7,0)
        Matrix_class = M_ERH + M_ERL + M_U + M_L + M_ML + M_MH + M_H
        self.Final_Matrix = np.where(Matrix_class==0,np.nan,Matrix_class)