# -*- coding: utf-8 -*-
"""
/***************************************************************************
 BADDialog
                                 A QGIS plugin
 BAD_Burned Area Detector
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2023-01-24
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Thomas Martinoli
        email                : th.martinoli96@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from PyQt5.QtWidgets import QMessageBox
from .preview_window import PreviewWindow
from .Mosaicking_options_window import PreviewMosaicking
from .preview_fetchimages import PreviewFetchImages
from .owa_parameters_window import OwaParametersWindow

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'BAD_dialog_base.ui'))


class BADDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(BADDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.pre_fire_path = None
        self.post_fire_path = None
        self.setupUi(self)
        
        self.setup_custom_connections()
        self.Preview.clicked.connect(self.open_preview_window)
        
        self.Preview_FI_pre.clicked.connect(self.open_preview_fetchimages_pre)
        self.Preview_FI_post.clicked.connect(self.open_preview_fetchimages_post)
        self.Preview_FI_pre_mos.clicked.connect(self.open_mosaicking_pre)
        self.Preview_FI_post_mos.clicked.connect(self.open_mosaicking_post)

        self.pushButton_parameters_UC1.clicked.connect(self.open_owa_parameters_UC1_window)
        self.pushButton_parameters_UC2.clicked.connect(self.open_owa_parameters_UC2_window)

    def enableRunALL(self):
        if self.pre_fire_path and self.post_fire_path:
                self.button_box.button(QtWidgets.QDialogButtonBox.Ok).setEnabled(True)
    
    def setup_custom_connections(self):
        """Connects the OK button to the custom action after removing the default."""
        
        # Find the QDialogButtonBox by its name ('button_box') from the UI file
        self.button_box = self.findChild(QtWidgets.QDialogButtonBox, 'button_box')
        run_all = self.button_box.button(QtWidgets.QDialogButtonBox.Ok)
        next_button=self.button_box.button(QtWidgets.QDialogButtonBox.YesToAll)
        if next_button:
            next_button.setText("Next")
        if run_all:
            run_all.setText("RunAll")

        self.button_box.button(QtWidgets.QDialogButtonBox.YesToAll).clicked.connect(self.handle_Next_button_click)

    def handle_Next_button_click(self):
        """Handles the Next button click: progresses through tabs or accepts (closes) the dialog."""
        
        current_index = self.tabWidget.currentIndex()
        if current_index != 9:
            # If not the last tab, move to the next one (and the dialog stays open)
            self.tabWidget.setCurrentIndex(current_index + 1)
        else:
            # If it is the last tab (index 9), close the dialog
            self.accept()

    def open_preview_window(self):
        self.preview_dialog = PreviewWindow(self)
        self.preview_dialog.show()

    def open_preview_fetchimages_pre(self):
        image_list = []
        for row in range(self.download_images_pre.rowCount()):
            date = self.download_images_pre.item(row, 0).text()
            image_list.append(date)

        self.last_pre=1
        self.pushButton_FI_download_pre.setEnabled(True)
        selected_index = self.download_images_pre.currentRow() if self.download_images_pre.currentRow() >= 0 else 0
        bbox=[float(self.lineEdit_West.text()), float(self.lineEdit_South.text()), float(self.lineEdit_East.text()), float(self.lineEdit_North.text())]
        user=self.lineEdit_User.text()
        password=self.lineEdit_Password.text()

        # Open preview with the selected image 
        self.preview_dialog = PreviewFetchImages(bbox=bbox, date=date, image_list=image_list, current_index=selected_index, cloud=self.horizontalSlider_cloud_pre.value(), user=user, password=password, parent=self.download_images_pre)
        self.preview_dialog.exec_()


    def open_preview_fetchimages_post(self):
        image_list = []
        for row in range(self.download_images_post.rowCount()):
            date = self.download_images_post.item(row, 0).text()
            image_list.append(date)

        self.last_post=1
        self.pushButton_FI_download_post.setEnabled(True)
        selected_index = self.download_images_post.currentRow() if self.download_images_post.currentRow()>=0 else 0
        bbox=[float(self.lineEdit_West.text()), float(self.lineEdit_South.text()), float(self.lineEdit_East.text()), float(self.lineEdit_North.text())]
        user=self.lineEdit_User.text()
        password=self.lineEdit_Password.text()

        # Open preview with the selected image 
        self.preview_dialog = PreviewFetchImages(bbox=bbox, date=date, image_list=image_list, current_index=selected_index, cloud=self.horizontalSlider_cloud_post.value(), user=user, password=password, parent=self.download_images_post)
        self.preview_dialog.exec_()

    def open_owa_parameters_UC1_window(self):
        if not self.Nband:
            self.Nband = 7  # Default value if Nband is not computed
        self.preview_dialog = OwaParametersWindow(int(self.Nband))
        if self.preview_dialog.exec_():
            self.lineEdit_OWA_a_UC1.setText(str(self.preview_dialog.result[0]))
            self.lineEdit_OWA_b_UC1.setText(str(self.preview_dialog.result[1]))

    def open_owa_parameters_UC2_window(self):
        if not self.Nband:
            self.Nband = 7  # Default value if Nband is not computed
        self.preview_dialog = OwaParametersWindow(int(self.Nband))
        if self.preview_dialog.exec_():
            self.lineEdit_OWA_a_UC2.setText(str(self.preview_dialog.result[0]))
            self.lineEdit_OWA_b_UC2.setText(str(self.preview_dialog.result[1]))

    def open_mosaicking_pre(self):
        if self.lineEdit_User.text()!="" and self.lineEdit_Password.text()!="":
            self.last_pre=0
        else:
            QMessageBox.warning(self, "Missing credential", "Please insert your credential to proced with the mosaicking")
            return
        self.preview_dialog = PreviewMosaicking(type="Pre")
        self.preview_dialog.exec_()
        self.ChoicheMosaicking_pre=self.preview_dialog.choice
        print("choice mosaicking",self.ChoicheMosaicking_pre)
        self.pushButton_FI_download_pre.setEnabled(True)

    def open_mosaicking_post(self):
        if self.lineEdit_User.text()!="" and self.lineEdit_Password.text()!="":
            self.last_post=0
        else:
            QMessageBox.warning(self, "Missing credential", "Please insert your credential to proced with the mosaicking")
            return
        self.preview_dialog = PreviewMosaicking(type="Post")
        self.preview_dialog.exec_()
        self.ChoicheMosaicking_post=self.preview_dialog.choice
        print("choice mosaicking",self.ChoicheMosaicking_post)
        self.pushButton_FI_download_post.setEnabled(True)
