# -*- coding: utf-8 -*-
"""
/***************************************************************************
 BAD
                                 A QGIS plugin
 BAD_Burned Area Detector
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-01-24
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Thomas Martinoli
        email                : th.martinoli96@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os
import time
import numpy as np
from PyQt5 import QtWidgets, QtCore
from PyQt5.QtCore import Qt, QDate
from PyQt5.QtGui import QIcon, QColor, QImage, QPixmap, QTextCharFormat
from PyQt5.QtWidgets import (
    QAction, QFileDialog, QMessageBox, QGraphicsScene,
    QGraphicsPixmapItem, QTableWidgetItem
)
import requests
import json
from shapely.geometry import Polygon
from shapely import wkt

from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt import uic
from qgis.core import (
    QgsRasterLayer, QgsProject, QgsRasterBlock, QgsRasterDataProvider,
    QgsRasterPipe, QgsRasterFileWriter, QgsRasterShader,
    QgsColorRampShader, QgsSingleBandPseudoColorRenderer,
    QgsCoordinateReferenceSystem, QgsVectorLayer, QgsWkbTypes,QgsCoordinateTransform
)
from qgis.utils import iface
from osgeo import gdal
from .resources import *
from .BAD_dialog import BADDialog
from .DoMagic import *
from .Message import Ui_Message


class BAD:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'BAD_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Burned Area Detector')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('BAD', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/BAD/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Burned Area Detector'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Burned Area Detector'),
                action)
            self.iface.removeToolBarIcon(action)
    

    def show_progress_bar(self, message="Processing..."):
        self.dlg.progressBar.setVisible(True)
        self.dlg.progressBar.setValue(0)
        self.dlg.progressBar.setFormat(message + " %p%")

    def update_progress(self, percent):
        self.dlg.progressBar.setValue(percent)
        QtWidgets.QApplication.processEvents() 

    def hide_progress_bar(self):
        self.dlg.progressBar.setVisible(False)
        self.dlg.progressBar.setValue(0)
            # Define a single handler function to check the button role
    
    def handle_Run_ALL(self):
        print("Run all started")
        self.run_masking_pre(True)
        self.run_masking_post(True)
        self.ComputeFeature(True)
        print("Feature computed")
        self.ComputeMD(True)
        print("MD computed")
        self.ComputeOWA(True)
        print("OWA computed")
        self.ComputeRG(True)
        print("Run computed")
        self.ComputeSeverity(True)
        print("Severity computed")
        self.ComputeRGSeverity(True)
        print("RGSeverity computed")
        self.window = QtWidgets.QDialog()
        self.ui = Ui_Message()
        self.ui.setupUi(self.window)
        self.window.show()


###################################################################################################
###################################################################################################
###################################################################################################

#  This part of the script contains the code about the restore buttons that are      
#  present inside the plug-in.                                            
#  In this way the user is able to restore the default value and         
#  the state of each spinbox, checkbox, radiusbox in the related page. 
    def reset_variables_buttons(self):
        self.dlg.pre_fire_path = None
        self.dlg.post_fire_path = None
        self.dlg.ChoicheMosaicking_pre=None
        self.dlg.ChoicheMosaicking_post=None
        self.MD_path=None
        self.Grow_file=None
        self.Seed_file=None
        self.dlg.last_pre=None
        self.dlg.last_post=None
        self.dlg.button_box.button(QtWidgets.QDialogButtonBox.Ok).setEnabled(False)

# Sentinel input tab:
    def reset_sentinel_fields(self):
        self.dlg.ChoicheMosaicking_pre=None
        self.dlg.ChoicheMosaicking_post=None
        self.dlg.lineEdit_North.clear()
        self.dlg.lineEdit_South.clear()
        self.dlg.lineEdit_East.clear()
        self.dlg.lineEdit_West.clear()
        link_4326 = f'<a href="https://epsg.io/4326">EPSG:4326</a>'
        self.dlg.checkBox_Coord_editing.setChecked(True)
        self.dlg.label_CRS.setText(link_4326)
        self.dlg.lineEdit_AOI.setVisible(False)
        self.dlg.lineEdit_AOI.setText("")
        self.dlg.comboBox_AOI_layer.setVisible(True)
        self.dlg.comboBox_AOI_layer.setCurrentIndex(0)
        self.dlg.lineEdit_FI_result_pre.clear()
        self.dlg.lineEdit_FI_result_post.clear()
        self.dlg.lineEdit_User.clear()
        self.dlg.lineEdit_Password.clear()
        self.dlg.checkBox_FI_display.setChecked(True)
        self.dlg.pushButton_FI_download_pre.setEnabled(False)
        self.dlg.pushButton_FI_download_post.setEnabled(False)
        self.dlg.Preview_FI_pre.setEnabled(False)
        self.dlg.Preview_FI_post.setEnabled(False)
        self.dlg.Preview_FI_pre_mos.setEnabled(False)
        self.dlg.Preview_FI_post_mos.setEnabled(False)
        self.dlg.download_images_pre.setRowCount(0)
        self.dlg.download_images_post.setRowCount(0)
        self.dlg.horizontalSlider_cloud_pre.setValue(10)
        self.dlg.horizontalSlider_cloud_post.setValue(10)
        self.dlg.spinBox_FI_limit_pre.setValue(10)
        self.dlg.spinBox_FI_limit_post.setValue(10)

# reset preprocessing
    def reset_fields(self):
        self.dlg.lineEdit_OutputPreFire.clear()
        self.dlg.lineEdit_OutputPostFire.clear()

        for index in range(self.dlg.listWidgetClassesPreFire.count()):
            if index in [0,1,5,6,8,9,11]:
                self.dlg.listWidgetClassesPreFire.item(index).setCheckState(QtCore.Qt.Checked)
            else:
                self.dlg.listWidgetClassesPreFire.item(index).setCheckState(QtCore.Qt.Unchecked)

        for index in range(self.dlg.listWidgetClassesPostFire.count()):
            if index in [0,1,6,8,9,11]:
                self.dlg.listWidgetClassesPostFire.item(index).setCheckState(QtCore.Qt.Checked)
            else:
                self.dlg.listWidgetClassesPostFire.item(index).setCheckState(QtCore.Qt.Unchecked)

        self.dlg.checkBoxDisplayInQGIS.setChecked(True)
        self.dlg.listWidgetClassesPreFire.setCurrentRow(-1)
        self.dlg.listWidgetClassesPostFire.setCurrentRow(-1)

    # INPUT TAB #
    def reset_input_tab(self):

        # Band reset value
        Bands = [
        self.dlg.spinBox_input_B1,
        self.dlg.spinBox_input_B2,
        self.dlg.spinBox_input_B3,
        self.dlg.spinBox_input_B4,
        self.dlg.spinBox_input_B5,
        self.dlg.spinBox_input_B6,
        self.dlg.spinBox_input_B7,
        self.dlg.spinBox_input_B8,
        self.dlg.spinBox_input_B8A,
        self.dlg.spinBox_input_B9,
        self.dlg.spinBox_input_B11,
        self.dlg.spinBox_input_B12,
        self.dlg.spinBox_input_B13]

        Nband=1
        for Band in Bands:
            Band.setValue(Nband)
            Nband=Nband+1

        # Band reset check
        self.dlg.checkBox_input_B1.setChecked(True)
        self.dlg.checkBox_input_B2.setChecked(True)
        self.dlg.checkBox_input_B3.setChecked(True)
        self.dlg.checkBox_input_B4.setChecked(True)
        self.dlg.checkBox_input_B5.setChecked(True)
        self.dlg.checkBox_input_B6.setChecked(True)
        self.dlg.checkBox_input_B7.setChecked(True)
        self.dlg.checkBox_input_B8.setChecked(True)
        self.dlg.checkBox_input_B8A.setChecked(True)
        self.dlg.checkBox_input_B9.setChecked(True)
        self.dlg.checkBox_input_B11.setChecked(True)
        self.dlg.checkBox_input_B12.setChecked(True)
        self.dlg.checkBox_input_B13.setChecked(True)

        self.dlg.comboBox_prefire.setCurrentIndex(0)
        self.dlg.comboBox_postfire.setCurrentIndex(0)
        self.dlg.comboBox_prefire.setVisible(True)
        self.dlg.comboBox_postfire.setVisible(True)
        self.dlg.lineEdit_Pre.setVisible(False)
        self.dlg.lineEdit_Post.setVisible(False)

        listspinbox=[self.dlg.spinBox_input_B1,self.dlg.spinBox_input_B2,self.dlg.spinBox_input_B3,self.dlg.spinBox_input_B4,self.dlg.spinBox_input_B5,self.dlg.spinBox_input_B6,self.dlg.spinBox_input_B7,self.dlg.spinBox_input_B8,self.dlg.spinBox_input_B8A,self.dlg.spinBox_input_B9,self.dlg.spinBox_input_B11,self.dlg.spinBox_input_B12,self.dlg.spinBox_input_B13]
        for spin in listspinbox:
            spin.setEnabled(True)
    # FEATURES TAB default #
    def reset_Features(self):
        CheckBoxes = [
        self.dlg.checkBox_FD_postB6,
        self.dlg.checkBox_FD_postB7,
        self.dlg.checkBox_FD_postNIR,
        self.dlg.checkBox_FD_deltaB6,
        self.dlg.checkBox_FD_deltaB7,
        self.dlg.checkBox_FD_deltaNIR,
        self.dlg.checkBox_FD_deltaB12]

        # Reset check
        for CKbox in CheckBoxes:
            CKbox.setChecked(True)

        # Reset value K
        self.dlg.doubleSpinBox_FD_postB6_K.setValue(-125.89400)
        self.dlg.doubleSpinBox_FD_postB7_K.setValue(-115.77500)
        self.dlg.doubleSpinBox_FD_postNIR_K.setValue(-123.65800)
        self.dlg.doubleSpinBox_FD_deltaB6_K.setValue(-120.29100)
        self.dlg.doubleSpinBox_FD_deltaB7_K.setValue(-93.72060)
        self.dlg.doubleSpinBox_FD_deltaNIR_K.setValue(-87.14430)
        self.dlg.doubleSpinBox_FD_deltaB12_K.setValue(236.98400)
        
        # Reset value x
        self.dlg.doubleSpinBox_FD_postB6_x.setValue(0.11090)
        self.dlg.doubleSpinBox_FD_postB7_x.setValue(0.11659)
        self.dlg.doubleSpinBox_FD_postNIR_x.setValue(0.10986)
        self.dlg.doubleSpinBox_FD_deltaB6_x.setValue(-0.05980)
        self.dlg.doubleSpinBox_FD_deltaB7_x.setValue(-0.07527)
        self.dlg.doubleSpinBox_FD_deltaNIR_x.setValue(-0.08657)
        self.dlg.doubleSpinBox_FD_deltaB12_x.setValue(0.04381)

        CheckBoxes = [
        self.dlg.checkBox_FAP_B1,
        self.dlg.checkBox_FAP_B2,
        self.dlg.checkBox_FAP_B3,
        self.dlg.checkBox_FAP_B4,
        self.dlg.checkBox_FAP_B5,
        self.dlg.checkBox_FAP_B8A,
        self.dlg.checkBox_FAP_B9,
        self.dlg.checkBox_FAP_B11,
        self.dlg.checkBox_FAP_B12,
        self.dlg.checkBox_FAP_NDVI,
        self.dlg.checkBox_FAP_NBR,
        self.dlg.checkBox_FAP_NBR2,
        self.dlg.checkBox_FAP_MIRBI]

        DoubleSpinBoxes_K = [
        self.dlg.doubleSpinBox_FAP_B1_K,
        self.dlg.doubleSpinBox_FAP_B2_K,
        self.dlg.doubleSpinBox_FAP_B3_K,
        self.dlg.doubleSpinBox_FAP_B4_K,
        self.dlg.doubleSpinBox_FAP_B5_K,
        self.dlg.doubleSpinBox_FAP_B8A_K,
        self.dlg.doubleSpinBox_FAP_B9_K,
        self.dlg.doubleSpinBox_FAP_B11_K,
        self.dlg.doubleSpinBox_FAP_B12_K,
        self.dlg.doubleSpinBox_FAP_NDVI_K,
        self.dlg.doubleSpinBox_FAP_NBR_K,
        self.dlg.doubleSpinBox_FAP_NBR2_K,
        self.dlg.doubleSpinBox_FAP_MIRBI_K]
        
        DoubleSpinBoxes_x = [
        self.dlg.doubleSpinBox_FAP_B1_x,
        self.dlg.doubleSpinBox_FAP_B2_x,
        self.dlg.doubleSpinBox_FAP_B3_x,
        self.dlg.doubleSpinBox_FAP_B4_x,
        self.dlg.doubleSpinBox_FAP_B5_x,
        self.dlg.doubleSpinBox_FAP_B8A_x,
        self.dlg.doubleSpinBox_FAP_B9_x,
        self.dlg.doubleSpinBox_FAP_B11_x,
        self.dlg.doubleSpinBox_FAP_B12_x,
        self.dlg.doubleSpinBox_FAP_NDVI_x,
        self.dlg.doubleSpinBox_FAP_NBR_x,
        self.dlg.doubleSpinBox_FAP_NBR2_x,
        self.dlg.doubleSpinBox_FAP_MIRBI_x]

        # Reset value K
        for DSbox in DoubleSpinBoxes_K:
            DSbox.setValue(0)

        # Reset value x
        for DSbox in DoubleSpinBoxes_x:
            DSbox.setValue(0)

        # Reset checkbox
        for CKbox in CheckBoxes:
            CKbox.setChecked(False)
        
        CheckBoxes = [
        self.dlg.checkBox_FAD_B1,
        self.dlg.checkBox_FAD_B2,
        self.dlg.checkBox_FAD_B3,
        self.dlg.checkBox_FAD_B4,
        self.dlg.checkBox_FAD_B5,
        self.dlg.checkBox_FAD_B8A,
        self.dlg.checkBox_FAD_B9,
        self.dlg.checkBox_FAD_B11,
        self.dlg.checkBox_FAD_NDVI,
        self.dlg.checkBox_FAD_NBR,
        self.dlg.checkBox_FAD_NBR2,
        self.dlg.checkBox_FAD_MIRBI,
        ]

        DoubleSpinBoxes_K = [
        self.dlg.doubleSpinBox_FAD_B1_K,
        self.dlg.doubleSpinBox_FAD_B2_K,
        self.dlg.doubleSpinBox_FAD_B3_K,
        self.dlg.doubleSpinBox_FAD_B4_K,
        self.dlg.doubleSpinBox_FAD_B5_K,
        self.dlg.doubleSpinBox_FAD_B8A_K,
        self.dlg.doubleSpinBox_FAD_B9_K,
        self.dlg.doubleSpinBox_FAD_B11_K,
        self.dlg.doubleSpinBox_FAD_NDVI_K,
        self.dlg.doubleSpinBox_FAD_NBR_K,
        self.dlg.doubleSpinBox_FAD_NBR2_K,
        self.dlg.doubleSpinBox_FAD_MIRBI_K]
        
        DoubleSpinBoxes_x = [
        self.dlg.doubleSpinBox_FAD_B1_x,
        self.dlg.doubleSpinBox_FAD_B2_x,
        self.dlg.doubleSpinBox_FAD_B3_x,
        self.dlg.doubleSpinBox_FAD_B4_x,
        self.dlg.doubleSpinBox_FAD_B5_x,
        self.dlg.doubleSpinBox_FAD_B8A_x,
        self.dlg.doubleSpinBox_FAD_B9_x,
        self.dlg.doubleSpinBox_FAD_B11_x,
        self.dlg.doubleSpinBox_FAD_NDVI_x,
        self.dlg.doubleSpinBox_FAD_NBR_x,
        self.dlg.doubleSpinBox_FAD_NBR2_x,
        self.dlg.doubleSpinBox_FAD_MIRBI_x]

        # Reset value K
        for DSbox in DoubleSpinBoxes_K:
            DSbox.setValue(0)

        # Reset value x
        for DSbox in DoubleSpinBoxes_x:
            DSbox.setValue(0)

        # Reset checkbox
        for CKbox in CheckBoxes:
            CKbox.setChecked(False)

        self.dlg.lineEdit_Feature.clear()
        self.dlg.lineEdit_MD.clear()
        self.dlg.checkBox_Feature_display.setChecked(True)
        self.dlg.checkBox_MD_display.setChecked(True)
        self.dlg.pushButton_MD_run.setEnabled(False)

    # OWA TAB #
    def reset_OWA_tab(self):

        #self.dlg.mMapLayerComboBox_OWA_MD.setCurrentIndex(0)

        # OWA reset check
        self.dlg.checkBox_OWA_AND.setChecked(False)
        self.dlg.checkBox_OWA_almostAND.setChecked(False)
        self.dlg.checkBox_OWA_AVERAGE.setChecked(False)
        self.dlg.checkBox_OWA_almostOR.setChecked(False)
        self.dlg.checkBox_OWA_OR.setChecked(False)
        self.dlg.checkBox_OWA_UserChoice1.setChecked(False)
        self.dlg.checkBox_OWA_UserChoice2.setChecked(False)
        
        # OWA reset radiobutton for Seed
        self.dlg.radioButton_OWA_S_AND.setChecked(True)
        self.dlg.radioButton_OWA_S_almostAND.setChecked(False)
        self.dlg.radioButton_OWA_S_AVERAGE.setChecked(False)
        self.dlg.radioButton_OWA_S_almostOR.setChecked(False)
        self.dlg.radioButton_OWA_S_OR.setChecked(False)
        self.dlg.radioButton_OWA_S_UserChoice1.setChecked(False)
        self.dlg.radioButton_OWA_S_UserChoice2.setChecked(False)

        # OWA reset radiobutton for Grow
        self.dlg.radioButton_OWA_G_AND.setChecked(False)
        self.dlg.radioButton_OWA_G_almostAND.setChecked(False)
        self.dlg.radioButton_OWA_G_AVERAGE.setChecked(False)
        self.dlg.radioButton_OWA_G_almostOR.setChecked(False)
        self.dlg.radioButton_OWA_G_OR.setChecked(True)
        self.dlg.radioButton_OWA_G_UserChoice1.setChecked(False)
        self.dlg.radioButton_OWA_G_UserChoice2.setChecked(False)

        self.dlg.lineEdit_OWA_a_UC1.clear()
        self.dlg.lineEdit_OWA_a_UC2.clear()
        self.dlg.lineEdit_OWA_b_UC1.clear()
        self.dlg.lineEdit_OWA_b_UC2.clear()

        # OWA reset line edit
        self.dlg.lineEdit_OWA_AND.clear()
        self.dlg.lineEdit_OWA_almostAND.clear()
        self.dlg.lineEdit_OWA_AVERAGE.clear()
        self.dlg.lineEdit_OWA_almostOR.clear()
        self.dlg.lineEdit_OWA_OR.clear()
        self.dlg.lineEdit_OWA_UserChoice1.clear()
        self.dlg.lineEdit_OWA_UserChoice2.clear()

        # OWA reset check for display results
        self.dlg.checkBox_OWA_display.setChecked(True)


    # REGION GROWING TAB #
    def reset_RG_tab(self):

        # RG reset threshold value
        self.dlg.doubleSpinBox_RG_seed.setValue(0.9)
        self.dlg.doubleSpinBox_RG_grow.setValue(0.1)
        self.dlg.comboBox_RG_seed.setCurrentIndex(0)
        self.dlg.comboBox_RG_grow.setCurrentIndex(0)

        # RG reset check for display result
        self.dlg.checkBox_RG_display.setCheckState(True)
        
        # RG reset line edit
        self.dlg.lineEdit_RG_result.clear()

    # SEVERITY TAB #
    def reset_Severity_tab(self):

        # Severity levels reset
        
        self.dlg.doubleSpinBox_Severity_ERH_1.setValue(-0.5)
        self.dlg.doubleSpinBox_Severity_ERH_2.setValue(-0.251)

        self.dlg.doubleSpinBox_Severity_ERL_1.setValue(-0.25)
        self.dlg.doubleSpinBox_Severity_ERL_2.setValue(-0.101)

        self.dlg.doubleSpinBox_Severity_U_1.setValue(-0.1)
        self.dlg.doubleSpinBox_Severity_U_2.setValue(0.099)

        self.dlg.doubleSpinBox_Severity_L_1.setValue(0.1)
        self.dlg.doubleSpinBox_Severity_L_2.setValue(0.269)

        self.dlg.doubleSpinBox_Severity_ML_1.setValue(0.27)
        self.dlg.doubleSpinBox_Severity_ML_2.setValue(0.439)

        self.dlg.doubleSpinBox_Severity_MH_1.setValue(0.44)
        self.dlg.doubleSpinBox_Severity_MH_2.setValue(0.659)

        self.dlg.doubleSpinBox_Severity_H_1.setValue(0.66)
        self.dlg.doubleSpinBox_Severity_H_2.setValue(1.3)

        
        # Severity reset check for display result
        self.dlg.checkBox_Severity.setChecked(True)
        self.dlg.checkBox_CombinedSeverity.setChecked(True)
        
        # Severity reset line edit
        self.dlg.lineEdit_Severity.clear() 
        self.dlg.lineEdit_CombinedSeverity.clear()
 

###################################################################################################     
###################################################################################################
###################################################################################################
# lines of code in order to save output, manage browse button and comboBox

    def select_output_file(self, target_lineedit):
        filename, _filter = QFileDialog.getSaveFileName(self.dlg, "Select output file", "", '*.tif')
        target_lineedit.setText(filename)

    def browse_vectorfile(self, comboBox, target_lineedit):
        file_path, _ = QFileDialog.getOpenFileName(self.dlg, "Select vector layer", "",
                                                    "Vector Files (*.shp *.gpkg *.kml *.gml *.dxf);;All Files (*)"
                                                )
        if file_path:
            target_lineedit.setVisible(True)
            comboBox.setVisible(False)
            target_lineedit.setText(file_path)
    
    def browse_rasterfile(self, comboBox, target_lineedit):
        file_path, _ = QFileDialog.getOpenFileName(self.dlg, "Select raster file", "",
                                                    "Raster Files (*.tif *.img *.jp2 *.bil *.hdr);;All Files (*)"
                                                )
        if file_path:
            target_lineedit.setVisible(True)
            comboBox.setVisible(False)
            target_lineedit.setText(file_path)

    def browse_rasterfile_OWA(self, comboBox, target_lineedit):
        file_path, _ = QFileDialog.getOpenFileName(self.dlg, "Select raster file", "",
                                                    "Raster Files (*.tif *.img *.jp2 *.bil *.hdr);;All Files (*)"
                                                )
        if file_path:
            target_lineedit.setVisible(True)
            comboBox.setVisible(False)
            target_lineedit.setText(file_path)
            self.MD_path=file_path

    def browse_rasterfile_pre(self, comboBox, target_lineedit):
        file_path, _ = QFileDialog.getOpenFileName(self.dlg, "Select raster file", "",
                                                    "Raster Files (*.tif *.img *.jp2 *.bil *.hdr);;All Files (*)"
                                                )
        if file_path:
            target_lineedit.setVisible(True)
            comboBox.setVisible(False)
            target_lineedit.setText(file_path)
            self.dlg.pre_fire_path=file_path
            self.dlg.enableRunALL()

    def browse_rasterfile_post(self, comboBox, target_lineedit):
        file_path, _ = QFileDialog.getOpenFileName(self.dlg, "Select raster file", "",
                                                    "Raster Files (*.tif *.img *.jp2 *.bil *.hdr);;All Files (*)"
                                                )
        if file_path:
            target_lineedit.setVisible(True)
            comboBox.setVisible(False)
            target_lineedit.setText(file_path)
            self.dlg.post_fire_path=file_path
            self.dlg.enableRunALL()

    def handle_combobox_click_pre(self,comboBox):
        print("pre current index",comboBox.currentIndex())
        if comboBox.currentIndex()!=0:
            layer = str(comboBox.currentText())
            layer = QgsProject.instance().mapLayersByName(layer)
            layer_path = layer[0].dataProvider().dataSourceUri()
            self.dlg.pre_fire_path=layer_path
        self.dlg.enableRunALL()

    def handle_combobox_click_post(self,comboBox):
        print("post current index",comboBox.currentIndex())
        if comboBox.currentIndex()!=0:
            layer = str(comboBox.currentText())
            layer = QgsProject.instance().mapLayersByName(layer)
            layer_path = layer[0].dataProvider().dataSourceUri()
            self.dlg.post_fire_path=layer_path
        self.dlg.enableRunALL()

    def handle_combobox_click_OWA(self,comboBox):
        if comboBox.currentIndex()!=0:
            layer = str(comboBox.currentText())
            layer = QgsProject.instance().mapLayersByName(layer)
            layer_path = layer[0].dataProvider().dataSourceUri()
            self.MD_path=layer_path

    def handle_combobox_click_seed(self,comboBox):
        if comboBox.currentIndex()!=0:
            layer = str(comboBox.currentText())
            layer = QgsProject.instance().mapLayersByName(layer)
            layer_path = layer[0].dataProvider().dataSourceUri()
            self.Seed_file=layer_path

    def handle_combobox_click_grow(self,comboBox):
        if comboBox.currentIndex()!=0:
            layer = str(comboBox.currentText())
            layer = QgsProject.instance().mapLayersByName(layer)
            layer_path = layer[0].dataProvider().dataSourceUri()
            self.Grow_file=layer_path

    def update_comboBox(self):
        #Fetch the currently loaded poly and raster layers
        poly_layers = []
        raster_layers = []

        #Iterate to get polygon layers
        for node in QgsProject.instance().layerTreeRoot().children():
            layer = node.layer()
            if isinstance(layer, QgsVectorLayer) and layer.geometryType() == QgsWkbTypes.PolygonGeometry:
                poly_layers.append(layer)
            elif isinstance(layer, QgsRasterLayer):
                raster_layers.append(layer)
        #Clear the contents of the comboBox from previous runs
        self.dlg.comboBox_AOI_layer.clear()

        self.dlg.comboBox_prefire.clear()
        self.dlg.comboBox_postfire.clear()

        self.dlg.comboBox_InputOWA.clear()
        self.dlg.comboBox_RG_seed.clear()
        self.dlg.comboBox_RG_grow.clear()
        
        #populate the comboBox with names of all the loaded layers
        self.dlg.comboBox_AOI_layer.addItems(['Select a Layer'])
        self.dlg.comboBox_AOI_layer.addItems([layer.name() for layer in poly_layers])

        self.dlg.comboBox_prefire.addItems(['Select a Layer'])
        self.dlg.comboBox_postfire.addItems(['Select a Layer'])
        self.dlg.comboBox_prefire.addItems([layer.name() for layer in raster_layers])
        self.dlg.comboBox_postfire.addItems([layer.name() for layer in raster_layers])

        self.dlg.comboBox_InputOWA.addItems(['Select a Layer'])
        self.dlg.comboBox_InputOWA.addItems([layer.name() for layer in raster_layers])

        self.dlg.comboBox_RG_seed.addItems(['Select a Layer'])
        self.dlg.comboBox_RG_grow.addItems(['Select a Layer'])
        self.dlg.comboBox_RG_seed.addItems([layer.name() for layer in raster_layers])
        self.dlg.comboBox_RG_grow.addItems([layer.name() for layer in raster_layers])

 

###################################################################################################     
###################################################################################################
###################################################################################################
#  This part of the script contains the code about BBOX definition and calendar visualization

# BBOX definition
    def get_BBOX(self):

        layer_name = None
        AOI_layer = None
        
        if self.dlg.lineEdit_AOI.isVisible():
            # Get layer path from line edit
            layer_path = self.dlg.lineEdit_AOI.text()
            # Load the vector layer
            AOI_layer = QgsVectorLayer(layer_path, "AOI_Layer", "ogr")

        elif self.dlg.comboBox_AOI_layer.isVisible():
            # Get layer selected
            layer_name = self.dlg.comboBox_AOI_layer.currentText()
            # Search for the layer in the project
            AOI_layer = next(
                (l for l in QgsProject.instance().mapLayers().values() if l.name() == layer_name),
                None
            )

        if AOI_layer is None or layer_name=="Select a Layer":
            return # No layer selected 
        elif not AOI_layer.isValid():
            print("Layer not valid.")
        elif AOI_layer.geometryType() != QgsWkbTypes.PolygonGeometry:
            print("Selected layer is not a polygon.")

        else:
            crs_source = AOI_layer.crs()
            crs_target = QgsCoordinateReferenceSystem("EPSG:4326")
            transform = QgsCoordinateTransform(crs_source, crs_target, QgsProject.instance())
            extent = AOI_layer.extent()
            print("Extent 1",extent)
            extent_4326 = transform.transform(extent)
            print("Extent 2",extent_4326)

            South = extent_4326.yMinimum()
            North = extent_4326.yMaximum()
            West = extent_4326.xMinimum()
            East = extent_4326.xMaximum()
            #BBOX = (South, North, West, East)
            self.dlg.lineEdit_South.setText(str(South))
            self.dlg.lineEdit_North.setText(str(North))
            self.dlg.lineEdit_West.setText(str(West))
            self.dlg.lineEdit_East.setText(str(East))
            epsg_code = AOI_layer.crs().authid() 
            epsg_number = epsg_code.split(":")[1] 

            link_html = f'<a href="https://epsg.io/{epsg_number}">{epsg_code}</a>'
            link_4326 = f'<a href="https://epsg.io/4326">EPSG:4326</a>'
            if epsg_code != "EPSG:4326":
                self.dlg.label_CRS.setText("Origin CRS: " + link_html+ " converted to " + link_4326)
            else:
                self.dlg.label_CRS.setText(link_4326)
            self.dlg.label_CRS.setOpenExternalLinks(True)

# Calendar visualization
    def update_calendar(self, start_widget, end_widget):
        start_date = start_widget.date()
        end_date = end_widget.date()
        calendar = end_widget.calendarWidget()
        
        # Reset format 
        calendar.setDateTextFormat(QDate(), QTextCharFormat())

        # Gray not available data
        gray_fmt = QTextCharFormat()
        gray_fmt.setForeground(Qt.gray)

        # Selected period lightblue
        highlight_fmt = QTextCharFormat()
        highlight_fmt.setBackground(QColor("#cceeff"))

        # Apply grey on dates before the start (only on the current month)
        visible = calendar.monthShown()
        year = calendar.yearShown()
        for day in range(1, 32):
            date = QDate(year, visible, day)
            if date.isValid() and date < start_date:
                calendar.setDateTextFormat(date, gray_fmt)

        # Highlight selected period
        d = start_date
        while d <= end_date:
            calendar.setDateTextFormat(d, highlight_fmt)
            d = d.addDays(1)

        calendar.setMinimumDate(start_date)



###################################################################################################     
###################################################################################################
###################################################################################################
#  This part of the script contains the code about fetching sentinel images

# The process is executed when the button "Search Pre-fire" is clicked  
    def search_sentinel_pre(self):

        print("Search Pre-fire button clicked, wait until the process end")
        self.show_progress_bar("Searching Pre-fire Sentinel-2 images")
        self.update_progress(5)
        start = time.process_time()       
        
        North=self.dlg.lineEdit_North.text()
        South=self.dlg.lineEdit_South.text()
        East=self.dlg.lineEdit_East.text()
        West=self.dlg.lineEdit_West.text()

        try:
            #check on coordinate values
            if not (-90 <= float(South) <= 90 and -90 <= float(North) <= 90):
                raise ValueError("Latitude must be between -90° and 90°")
            if not (-180 <= float(West) <= 180 and -180 <= float(East) <= 180):
                raise ValueError("Longitude must be between -180° and 180°")
    
            self.aoi = f"POLYGON(({West} {South}, {East} {South}, {East} {North}, {West} {North}, {West} {South}))"
            aoi_pol = wkt.loads(self.aoi)
        except Exception as e:
            QMessageBox.warning(self.dlg, "Not valid AOI", f"Please check the inserted coordinates and input a valid area of interest\n\nError: {e}")
            self.hide_progress_bar()
            return
        #Check if the BBOX respect the 25x25 km contrains of the sentinel hub download

        BBOX = [float(West), float(South), float(East), float(North)]
        _,BBOX=transform_bbox_to_utm(BBOX)
        utm_w=BBOX[0]
        utm_s=BBOX[1]
        utm_e=BBOX[2]
        utm_n=BBOX[3]
        print(f"HEIGHT{abs(utm_n-utm_s):.1f}")
        print(f"WIDTH{abs(utm_w-utm_e):.1f}")
        if abs(utm_n-utm_s)>=25000:
            QMessageBox.warning(self.dlg, f"Not valid AOI", f"The selected AOI seems to have a height of {abs(utm_n-utm_s):.1f} m, which is greater than the 25000 m limit allowed by the download.\n The preview should work, but be aware that the download will most likely fail, reduce the height of the AOI to prevent this. ")
        if abs(utm_w-utm_e)>=25000:
            QMessageBox.warning(self.dlg, f"Not valid AOI", f"The selected AOI seems to have a width of {abs(utm_w-utm_e):.1f} m, which is greater than the 25000 m limit allowed by the download.\n The preview should work, but be aware that the download will most likely fail, reduce the width of the AOI to prevent this. ")

        Start_date=self.dlg.dateEdit_Start_pre.date().toString("yyyy-MM-dd")
        End_date=self.dlg.dateEdit_End_pre.date().toString("yyyy-MM-dd")

        Cloud=self.dlg.horizontalSlider_cloud_pre.value()
        Limit_num=self.dlg.spinBox_FI_limit_pre.value()
        self.dlg.download_images_pre.setRowCount(0) 

        self.List_pre=SentinelSearch(self.aoi,Start_date,End_date,Cloud,Limit_num,"desc").result

        self.update_progress(70)
        d=dict()
        for index, row in self.List_pre.iterrows():
            date=row['Name'][11:19]
            date_formatted = f"{date[:4]}-{date[4:6]}-{date[6:]}"
            time_im=row['Name'][20:26]
            time_formatted = f"{time_im[:2]}:{time_im[2:4]}:{time_im[4:]}"
            key = f"{date_formatted} {time_formatted}"
            if key in d:
                d[key].append(row['Name'])
            else:
                d[key] = [row['Name']]
        for key, names in d.items():
            row_position = self.dlg.download_images_pre.rowCount()
            self.dlg.download_images_pre.insertRow(row_position)
            self.dlg.download_images_pre.setItem(row_position, 0, QTableWidgetItem(key.split()[0]))
            self.dlg.download_images_pre.setItem(row_position, 1, QTableWidgetItem(key.split()[1]))
            totFootprint=None
            for name in names:
                List_pre_row = self.List_pre[self.List_pre['Name'] == name].iloc[0]
                poly_coords = List_pre_row['GeoFootprint']['coordinates'][0]
                footprint = Polygon(poly_coords)
                totFootprint = footprint if totFootprint is None else totFootprint.union(footprint)
            intersection = totFootprint.intersection(aoi_pol)
            coverage_percentage = (intersection.area / aoi_pol.area) * 100
            self.dlg.download_images_pre.setItem(row_position, 2, QTableWidgetItem(f"{coverage_percentage:.2f}%"))

        self.dlg.Preview_FI_pre.setEnabled(True)
        if len(d.keys())>1:
            self.dlg.Preview_FI_pre_mos.setEnabled(True) 

        self.update_progress(100)
        self.hide_progress_bar()
        end = time.process_time()
        print("Process end")
        print('Computational time Search Pre-fire [s]: ',(end - start),"start=", start,"end=",end) 
        print('\n') 

# The process is executed when the button "Search Post-fire" is clicked 
    def search_sentinel_post(self):

        print("Search Post-fire button clicked, wait until the process end")
        self.show_progress_bar("Searching Post-fire Sentinel-2 images")
        self.update_progress(5)
        start = time.process_time()  
  
        North=self.dlg.lineEdit_North.text()
        South=self.dlg.lineEdit_South.text()
        East=self.dlg.lineEdit_East.text()
        West=self.dlg.lineEdit_West.text()
        
        try:
            #check on coordinate values
            if not (-90 <= float(South) <= 90 and -90 <= float(North) <= 90):
                raise ValueError("Latitude must be between -90° and 90°")
            if not (-180 <= float(West) <= 180 and -180 <= float(East) <= 180):
                raise ValueError("Longitude must be between -180° and 180°")
    
            self.aoi = f"POLYGON(({West} {South}, {East} {South}, {East} {North}, {West} {North}, {West} {South}))"
            aoi_pol = wkt.loads(self.aoi)
        except Exception as e:
            QMessageBox.warning(self.dlg, "Not valid AOI", f"Please check the inserted coordinates and input a valid area of interest\n\nError: {e}")
            self.hide_progress_bar()
            return

        BBOX = [float(West), float(South), float(East), float(North)]
        _,BBOX=transform_bbox_to_utm(BBOX)
        utm_w=BBOX[0]
        utm_s=BBOX[1]
        utm_e=BBOX[2]
        utm_n=BBOX[3]
        if abs(utm_n-utm_s)>=25000:
            QMessageBox.warning(self.dlg, f"Not valid AOI", f"The selected AOI seems to have a height of {abs(utm_n-utm_s):.1f} m, which is greater than the 25000 m limit allowed by the download.\n The preview should work, but be aware that the download will most likely fail. \nReduce the height of the AOI to prevent this. ")
        if abs(utm_w-utm_e)>=25000:
            QMessageBox.warning(self.dlg, f"Not valid AOI", f"The selected AOI seems to have a width of {abs(utm_w-utm_e):.1f} m, which is greater than the 25000 m limit allowed by the download.\n The preview should work, but be aware that the download will most likely fail. \nReduce the width of the AOI to prevent this. ")


        Start_date=self.dlg.dateEdit_Start_post.date().toString("yyyy-MM-dd")
        End_date=self.dlg.dateEdit_End_post.date().toString("yyyy-MM-dd")

        Cloud=self.dlg.horizontalSlider_cloud_post.value()
        Limit_num=self.dlg.spinBox_FI_limit_post.value()
        self.dlg.download_images_post.setRowCount(0) 

        self.List_post=SentinelSearch(self.aoi,Start_date,End_date,Cloud,Limit_num,"asc").result
        
        self.update_progress(70)
        d=dict()
        for index, row in self.List_post.iterrows():
            date=row['Name'][11:19]
            date_formatted = f"{date[:4]}-{date[4:6]}-{date[6:]}"
            time_im=row['Name'][20:26]
            time_formatted = f"{time_im[:2]}:{time_im[2:4]}:{time_im[4:]}"
            key = f"{date_formatted} {time_formatted}"
            if key in d:
                d[key].append(row['Name'])
            else:
                d[key] = [row['Name']]
        for key, names in d.items():
            row_position = self.dlg.download_images_post.rowCount()
            self.dlg.download_images_post.insertRow(row_position)
            self.dlg.download_images_post.setItem(row_position, 0, QTableWidgetItem(key.split()[0]))
            self.dlg.download_images_post.setItem(row_position, 1, QTableWidgetItem(key.split()[1]))
            totFootprint=None
            for name in names:
                List_post_row = self.List_post[self.List_post['Name'] == name].iloc[0]
                poly_coords = List_post_row['GeoFootprint']['coordinates'][0]
                footprint = Polygon(poly_coords)
                totFootprint = footprint if totFootprint is None else totFootprint.union(footprint)
            intersection = totFootprint.intersection(aoi_pol)
            coverage_percentage = (intersection.area / aoi_pol.area) * 100
            self.dlg.download_images_post.setItem(row_position, 2, QTableWidgetItem(f"{coverage_percentage:.2f}%"))
        
        self.dlg.Preview_FI_post.setEnabled(True)
        if len(d.keys())>1:
            self.dlg.Preview_FI_post_mos.setEnabled(True)

        self.update_progress(100)
        self.hide_progress_bar()
        end = time.process_time()
        print("Process end")
        print('Computational time Search Post-fire [s]: ',(end - start),"start=", start,"end=",end) 
        print('\n') 

    # The process is executed when the button "Download Pre-fire" is clicked 
    def download_sentinel_pre(self):
        if self.dlg.last_pre==0:
            reply = QMessageBox.question(
                self.dlg, 
                'Download confermation', 
                "Since the last Pre-Fire button pressed was \"Compute Mosaicking Pre\" you are about to download the mosaick image according to your selected criteria, do you conferm the download? ",
                QMessageBox.Yes | QMessageBox.No, 
                QMessageBox.Yes  # Predefined
            )
        else: 
            reply = QMessageBox.question(
                self.dlg, 
                'Download confermation', 
                "Since the last Pre-Fire button pressed was \"Single image preview pre\" you are about to download the currently selected row in the Pre-fire table, do you conferm the download?",
                QMessageBox.Yes | QMessageBox.No, 
                QMessageBox.Yes  # Predefined
            )

        if reply == QMessageBox.No:
            return

        self.show_progress_bar("Downloading Pre-fire Sentinel-2 images")
        self.update_progress(5)
        start = time.process_time()
        
        selected_row = self.dlg.download_images_pre.currentRow()
        BBOX = [float(self.dlg.lineEdit_West.text()), float(self.dlg.lineEdit_South.text()), float(self.dlg.lineEdit_East.text()), float(self.dlg.lineEdit_North.text())]
        # If the last button pressed was "Single Image Preview" it downloads just the selected image, otherwise it downloads the mosaic of all the images found
        if self.dlg.last_pre==0:
            if self.dlg.ChoicheMosaicking_pre=="Date":
                date = get_sorted_date(self.dlg.download_images_pre)
                date = date[::-1]
            elif self.dlg.ChoicheMosaicking_pre=="Index":
                date = get_sorted_percentage(self.dlg.download_images_pre)
        else:
            date=self.dlg.download_images_pre.item(selected_row, 0).text()
        print("date",date)
        cloud=self.dlg.horizontalSlider_cloud_pre.value()
        if self.dlg.lineEdit_FI_result_pre.text():
            output_name = self.dlg.lineEdit_FI_result_pre.text()
        else:
            QMessageBox.warning(self.dlg, "Missing output path", "Please select a valid output path.")
            self.hide_progress_bar()
            return

        username = self.dlg.lineEdit_User.text()
        password = self.dlg.lineEdit_Password.text()
        self.update_progress(15)
        res=Downloadsh(BBOX,date,cloud,output_name,username,password, self.dlg.last_pre, True, self.dlg.ChoicheMosaicking_pre)
        if res==1:
            self.update_progress(100)

            if self.dlg.checkBox_FI_display.isChecked():
                    self.display_in_qgis(output_name)
                    self.dlg.lineEdit_Pre.setVisible(False)
                    self.dlg.comboBox_prefire.insertItems(1, [os.path.splitext(os.path.basename(output_name))[0]])
                    self.dlg.comboBox_prefire.setCurrentIndex(1)
            self.dlg.pre_fire_path = output_name
            self.dlg.enableRunALL()
            self.hide_progress_bar()
            end = time.process_time()
            print("Process end")
            print('Computational time Download Pre-fire [s]: ',(end - start),"start=", start,"end=",end) 
            print('\n')
            self.window = QtWidgets.QDialog()
            self.ui = Ui_Message()
            self.ui.setupUi(self.window)
            self.window.show()
        else:
            QMessageBox.warning(self.dlg, "An error occurred during the download request", f"Error (Sentinel Hub): {json.dumps(res, indent=2)}")
            self.hide_progress_bar()

# The process is executed when the button "Download Post-fire" is clicked 
    def download_sentinel_post(self):
        if self.dlg.last_post==0:
            reply = QMessageBox.question(
                self.dlg, 
                'Download confermation', 
                "Since the last Post-Fire button pressed was \"Compute Mosaicking Post\" you are about to download the mosaick image according to your selected criteria, do you conferm the download? ",
                QMessageBox.Yes | QMessageBox.No, 
                QMessageBox.Yes  # Predefined
            )
        else: 
            reply = QMessageBox.question(
                self.dlg, 
                'Download confermation', 
                "Since the last Post-Fire button pressed was \"Single image preview post\" you are about to download the currently selected row in the Post-fire table, do you conferm the download?",
                QMessageBox.Yes | QMessageBox.No, 
                QMessageBox.Yes  # Predefined
            )

        if reply == QMessageBox.No:
            return

        self.show_progress_bar("Downloading Post-fire Sentinel-2 images")
        self.update_progress(5)
        start = time.process_time()
        
        selected_row = self.dlg.download_images_post.currentRow()
        BBOX = [float(self.dlg.lineEdit_West.text()), float(self.dlg.lineEdit_South.text()), float(self.dlg.lineEdit_East.text()), float(self.dlg.lineEdit_North.text())]
        # If the last button pressed was "Single Image Preview" it downloads just the selected image, otherwise it downloads the mosaic of all the images found
        if self.dlg.last_post==0:
            if self.dlg.ChoicheMosaicking_post=="Date":
                date = get_sorted_date(self.dlg.download_images_post)
            elif self.dlg.ChoicheMosaicking_post=="Index":
                date = get_sorted_percentage(self.dlg.download_images_post)
        else:
            date=self.dlg.download_images_post.item(selected_row, 0).text()
        cloud=self.dlg.horizontalSlider_cloud_post.value()

        if self.dlg.lineEdit_FI_result_post.text():
            output_name = self.dlg.lineEdit_FI_result_post.text()
        else:
            QMessageBox.warning(self.dlg, "Missing output path", "Please select a valid output path.")
            self.hide_progress_bar()
            return

        username = self.dlg.lineEdit_User.text()
        password = self.dlg.lineEdit_Password.text()
        self.update_progress(15)
        res=Downloadsh(BBOX,date,cloud,output_name,username,password, self.dlg.last_post,False,self.dlg.ChoicheMosaicking_post)
        if res==1:
            self.update_progress(100)

            if self.dlg.checkBox_FI_display.isChecked():
                    self.display_in_qgis(output_name)
                    self.dlg.lineEdit_Post.setVisible(False)
                    self.dlg.comboBox_postfire.insertItems(1, [os.path.splitext(os.path.basename(output_name))[0]])
                    self.dlg.comboBox_postfire.setCurrentIndex(1)
            self.dlg.post_fire_path = output_name
            self.dlg.enableRunALL()
            self.hide_progress_bar()
            end = time.process_time()
            print("Process end")
            print('Computational time Download Post-fire [s]: ',(end - start),"start=", start,"end=",end) 
            print('\n')
            self.window = QtWidgets.QDialog()
            self.ui = Ui_Message()
            self.ui.setupUi(self.window)
            self.window.show()
        else:
            QMessageBox.warning(self.dlg, "An error occurred during the download request", f"Error (Sentinel Hub): {json.dumps(res, indent=2)}")
            self.hide_progress_bar()

###################################################################################################     
###################################################################################################
###################################################################################################
#  This part of the script contains the code about the preprocessing tab,
#  The process is executed when the button "RUN MASKING" is clicked  
    def update_text(self):
        value=self.dlg.spinBox_input_B13.value()
        self.dlg.label_104.setText(f"Masking based on SCL Band ({value})")
    def deactivatespinnbox(self,checkbox,spinbox):
        if not checkbox.isChecked():
            spinbox.setEnabled(False)
        else:
            spinbox.setEnabled(True)
    
    def populate_mask_classes(self):
        """Populate the class selection lists for pre-fire and post-fire."""
        classes = [
            "0 - No Data",
            "1 - Saturated / Defective Pixel",
            "2 - Topographic casted Shadows",
            "3 - Cloud Shadows",
            "4 - Vegetation",
            "5 - Not Vegetated",
            "6 - Water",
            "7 - Unclassified",
            "8 - Cloud Medium Probability",
            "9 - Cloud High Probability",
            "10 - Thin Cirrus",
            "11 - Snow / Ice"
        ]

        for i in range(len(classes)):
            item = QtWidgets.QListWidgetItem(classes[i])
            if i in [0,1,5,6,8,9,11]:
                item.setCheckState(QtCore.Qt.Checked)
            else:
                item.setCheckState(QtCore.Qt.Unchecked)
            self.dlg.listWidgetClassesPreFire.addItem(item)

        for i in range(len(classes)):
            item = QtWidgets.QListWidgetItem(classes[i])
            if i in [0,1,6,8,9,11]:
                item.setCheckState(QtCore.Qt.Checked)
            else:
                item.setCheckState(QtCore.Qt.Unchecked)
            self.dlg.listWidgetClassesPostFire.addItem(item)

    def run_masking_pre(self,flag=False):

        pre_fire_classes = self.get_selected_classes(self.dlg.listWidgetClassesPreFire)

        try:
            if (not pre_fire_classes or not self.dlg.pre_fire_path):
                QMessageBox.warning(self.dlg, "Input incomplete", "Please select at least one input file and its class to mask.")
                return
            self.output_pre_fire_path=self.dlg.lineEdit_OutputPreFire.text()
            if not self.output_pre_fire_path:
                self.output_pre_fire_path=os.path.join(os.path.dirname(self.dlg.pre_fire_path.strip()), "Masked_pre_fire.tif")
            self.mask_raster(self.dlg.pre_fire_path, self.dlg.spinBox_input_B13.value()-1, pre_fire_classes, self.output_pre_fire_path, flag)
            ##This updated the comboBox of the "input tab"

            if self.dlg.checkBoxDisplayInQGIS.isChecked():
                self.display_in_qgis(self.output_pre_fire_path)

            self.dlg.pre_fire_path = self.output_pre_fire_path
            self.dlg.enableRunALL()

            #Fetch the currently loaded layers
            layers = QgsProject.instance().layerTreeRoot().children()
            self.dlg.comboBox_prefire.clear()

            #populate the comboBox with names of all the loaded layers
            self.dlg.comboBox_prefire.addItems(['Select a Layer'])
            self.dlg.comboBox_prefire.addItems([layer.name() for layer in layers])
            self.dlg.comboBox_prefire.setCurrentText(os.path.splitext(os.path.basename(self.dlg.pre_fire_path))[0])

        except Exception as e:
            QMessageBox.critical(self.dlg, "Error", f"Masking failed: {e}")

    def run_masking_post(self,flag=False):
        post_fire_classes = self.get_selected_classes(self.dlg.listWidgetClassesPostFire)

        try:
            if (not post_fire_classes or not self.dlg.post_fire_path):
                QMessageBox.warning(self.dlg, "Input incomplete", "Please select at least one input file and its class to mask.")
                return
            self.output_post_fire_path=self.dlg.lineEdit_OutputPostFire.text()
            if not self.output_post_fire_path:
                self.output_post_fire_path=os.path.join(os.path.dirname(self.dlg.post_fire_path.strip()), "Masked_post_fire.tif")

            self.mask_raster(self.dlg.post_fire_path, self.dlg.spinBox_input_B13.value()-1, post_fire_classes, self.output_post_fire_path, flag)

            ##This updated the comboBox of the "input tab"

            if self.dlg.checkBoxDisplayInQGIS.isChecked():
                self.display_in_qgis(self.output_post_fire_path)

            self.dlg.post_fire_path = self.output_post_fire_path
            self.dlg.enableRunALL()

            #Fetch the currently loaded layers
            layers = QgsProject.instance().layerTreeRoot().children()
            self.dlg.comboBox_postfire.clear()

            #populate the comboBox with names of all the loaded layers
            self.dlg.comboBox_postfire.addItems(['Select a Layer'])
            self.dlg.comboBox_postfire.addItems([layer.name() for layer in layers])
            self.dlg.comboBox_postfire.setCurrentText(os.path.splitext(os.path.basename(self.dlg.post_fire_path))[0])

        except Exception as e:
            QMessageBox.critical(self.dlg, "Error", f"Masking failed: {e}")

    def get_selected_classes(self, list_widget):
        selected_classes = []
        for index in range(list_widget.count()):
            item = list_widget.item(index)
            if item.checkState() == QtCore.Qt.Checked:
                class_index = int(item.text().split(" - ")[0])
                selected_classes.append(class_index)
        return selected_classes

    def mask_raster(self, input_path, scl_band_index, mask_classes, output_path, flag=False):
        self.show_progress_bar("Computing Pre-Processing")
        self.update_progress(5)
        start = time.process_time()
        print("input path",input_path)
        if input_path:
            raster_layer = QgsRasterLayer(input_path, os.path.basename(input_path))
            if not raster_layer.isValid():
                raise ValueError(f"Failed to load raster: {input_path}")
            crs=raster_layer.crs().authid()
            dataset = gdal.Open(input_path)
            print("dataset creato:",dataset)

        scl_band = dataset.GetRasterBand(scl_band_index + 1)
        scl_array = scl_band.ReadAsArray()
        mask = np.isin(scl_array, mask_classes)

        masked_bands = []
        for band_index in range(1, dataset.RasterCount + 1):
            if band_index - 1 == scl_band_index:
                continue
            band = dataset.GetRasterBand(band_index).ReadAsArray()
            band = band.astype(np.float32)
            band[mask] = np.nan
            masked_bands.append(band)

        if not output_path:
            path_index = 0
            path = self.dlg.pre_fire_path
            filename = "masking_result.tif"     
        else:
            path_index = 1
            path = output_path
            filename="null"
        if path_index==0:
            # se indice zero significa che l'utente non ha specificato nulla per 
            # cui devo trasformare il path per salvare il file in formato .tif
            array_path=path.split('/')
            array_path[-1]=filename
            splitter="/"
            path=splitter.join(array_path)
        self.save_raster(path, dataset.RasterXSize, dataset.RasterYSize, crs, dataset.GetGeoTransform(), masked_bands)
        self.update_progress(100)
        self.hide_progress_bar()
        end = time.process_time()
        print("Process end")
        print('Computational time Pre-Processing [s]: ',(end - start),"start=", start,"end=",end) 
        print('\n') 
        if not flag:
            self.window = QtWidgets.QDialog()
            self.ui = Ui_Message()
            self.ui.setupUi(self.window)
            self.window.show()

    def save_raster(self, output_path, cols, rows, crs, transform, bands):
        driver = gdal.GetDriverByName("GTiff")
        dataset = driver.Create(output_path, cols, rows, len(bands), gdal.GDT_Float32)
        dataset.SetGeoTransform(transform)
        dataset.SetProjection(QgsCoordinateReferenceSystem(crs).toWkt())

        for i, band_data in enumerate(bands, start=1):
            dataset.GetRasterBand(i).WriteArray(band_data)
            dataset.GetRasterBand(i).SetNoDataValue(np.nan)

        dataset.FlushCache()
        del dataset

    # Display in QGIS used everytime the display botton is checked
    def display_in_qgis(self, file_path):
        layer = QgsRasterLayer(file_path, os.path.splitext(os.path.basename(file_path))[0])
        if layer.isValid():
            QgsProject.instance().addMapLayer(layer)
###################################################################################################     
###################################################################################################
###################################################################################################
#  This part of the script contains the code about the reading of the input layers,
#  the computation of the features (post and delta)
#  The process is executed when the button "COMPUTE FEATURE" is clicked  

    def ComputeFeature(self,flag=False):
        
        print("ComputeFeature button clicked, wait until the process end")
        self.show_progress_bar("Computing Features")
        self.update_progress(5)
        start = time.process_time()        
        
        self.dlg.enableRunALL()
        self.update_progress(10)

        if self.dlg.checkBox_input_B1.isChecked():
            Band1=self.dlg.spinBox_input_B1.value()
        else:
            Band1=np.nan

        if self.dlg.checkBox_input_B2.isChecked():
            Band2=self.dlg.spinBox_input_B2.value()
        else:
            Band2=np.nan

        if self.dlg.checkBox_input_B3.isChecked():
            Band3=self.dlg.spinBox_input_B3.value()
        else:
            Band3=np.nan

        if self.dlg.checkBox_input_B4.isChecked():
            Band4=self.dlg.spinBox_input_B4.value()
        else:
            Band4=np.nan

        if self.dlg.checkBox_input_B5.isChecked():
            Band5=self.dlg.spinBox_input_B5.value()
        else:
            Band5=np.nan

        if self.dlg.checkBox_input_B6.isChecked():
            Band6=self.dlg.spinBox_input_B6.value()
        else:
            Band6=np.nan

        if self.dlg.checkBox_input_B7.isChecked():
            Band7=self.dlg.spinBox_input_B7.value()
        else:
            Band7=np.nan

        if self.dlg.checkBox_input_B8.isChecked():
            Band8=self.dlg.spinBox_input_B8.value()
        else:
            Band8=np.nan

        if self.dlg.checkBox_input_B8A.isChecked():
            Band8A=self.dlg.spinBox_input_B8A.value()
        else:
            Band8A=np.nan

        if self.dlg.checkBox_input_B9.isChecked():
            Band9=self.dlg.spinBox_input_B9.value()
        else:
            Band9=np.nan 

        Band10=np.nan

        if self.dlg.checkBox_input_B11.isChecked():
            Band11=self.dlg.spinBox_input_B11.value()
        else:
            Band11=np.nan

        if self.dlg.checkBox_input_B12.isChecked():
            Band12=self.dlg.spinBox_input_B12.value()
        else:
            Band12=np.nan

        self.BandsList=[Band1,Band2,Band3,Band4,Band5,Band6,Band7,Band8,Band8A,Band9,Band10,Band11,Band12]
        Data=ReadingData(self.dlg.pre_fire_path,self.dlg.post_fire_path)

        self.update_progress(20)


        self.PreMatrix=Data.FirstMatrix
        self.PostMatrix=Data.SecondMatrix
        self.DeltaMatrix=self.PostMatrix-self.PreMatrix
        
        self.GeoTrans=Data.gt
        self.proj=Data.proj

        FinalFeatureList=[]
        NameBandsList=[]
        
        if self.dlg.checkBox_FD_postB6.isChecked():
            layer=self.PostMatrix[Band6-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('postB6')

        if self.dlg.checkBox_FD_postB7.isChecked():
            layer=self.PostMatrix[Band7-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('postB7')

        if self.dlg.checkBox_FD_postNIR.isChecked():
            layer=self.PostMatrix[Band8-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('postB8')

        if self.dlg.checkBox_FD_deltaB6.isChecked():
            layer=self.DeltaMatrix[Band6-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('deltaB6')
            
        if self.dlg.checkBox_FD_deltaB7.isChecked():
            layer=self.DeltaMatrix[Band7-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('deltaB7')

        if self.dlg.checkBox_FD_deltaNIR.isChecked():
            layer=self.DeltaMatrix[Band8-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('deltaB8')

        if self.dlg.checkBox_FD_deltaB12.isChecked():
            layer=self.DeltaMatrix[Band12-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('deltaB12')

        # FEATURES ADVANCED POST
        if self.dlg.checkBox_FAP_B1.isChecked():
            layer=self.PostMatrix[Band1-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('postB1')

        if self.dlg.checkBox_FAP_B2.isChecked():
            layer=self.PostMatrix[Band2-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('postB2')

        if self.dlg.checkBox_FAP_B3.isChecked():
            layer=self.PostMatrix[Band3-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('postB3')

        if self.dlg.checkBox_FAP_B4.isChecked():
            layer=self.PostMatrix[Band4-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('postB4')

        if self.dlg.checkBox_FAP_B5.isChecked():
            layer=self.PostMatrix[Band5-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('postB5')

        if self.dlg.checkBox_FAP_B8A.isChecked():
            layer=self.PostMatrix[Band8A-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('postB8A')

        if self.dlg.checkBox_FAP_B9.isChecked():
            layer=self.PostMatrix[Band9-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('postB9')

        if self.dlg.checkBox_FAP_B11.isChecked():
            layer=self.PostMatrix[Band11-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('postB11')

        if self.dlg.checkBox_FAP_B12.isChecked():
            layer=self.PostMatrix[Band12-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('postB12')

        if self.dlg.checkBox_FAP_NDVI.isChecked():
            nir=self.PostMatrix[Band8-1]
            red=self.PostMatrix[Band4-1]
            layer=(nir-red)/(nir+red)
            FinalFeatureList.append(layer)
            NameBandsList.append('postNDVI')

        if self.dlg.checkBox_FAP_NBR.isChecked():
            nir=self.PostMatrix[Band8-1]
            swir=self.PostMatrix[Band12-1]
            layer=(nir-swir)/(nir+swir)
            FinalFeatureList.append(layer)
            NameBandsList.append('postNBR')

        if self.dlg.checkBox_FAP_NBR2.isChecked():
            swir1=self.PostMatrix[Band11-1]
            swir=self.PostMatrix[Band12-1]
            layer=(swir1-swir)/(swir1+swir)
            FinalFeatureList.append(layer)
            NameBandsList.append('postNBR2')

        if self.dlg.checkBox_FAP_MIRBI.isChecked():
            swir1=(self.PostMatrix[Band11-1])/10000
            swir=(self.PostMatrix[Band12-1])/10000
            layer=10*swir-9.5*swir1+2
            FinalFeatureList.append(layer)
            NameBandsList.append('postMIRBI')

        # FEATURES ADVANCED DELTA
        if self.dlg.checkBox_FAD_B1.isChecked():
            layer=self.DeltaMatrix[Band1-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('deltaB1')

        if self.dlg.checkBox_FAD_B2.isChecked():
            layer=self.DeltaMatrix[Band2-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('deltaB2')

        if self.dlg.checkBox_FAD_B3.isChecked():
            layer=self.DeltaMatrix[Band3-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('deltaB3')

        if self.dlg.checkBox_FAD_B4.isChecked():
            layer=self.DeltaMatrix[Band4-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('deltaB4')

        if self.dlg.checkBox_FAD_B5.isChecked():
            layer=self.DeltaMatrix[Band5-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('deltaB5')

        if self.dlg.checkBox_FAD_B8A.isChecked():
            layer=self.DeltaMatrix[Band8A-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('deltaB8A')

        if self.dlg.checkBox_FAD_B9.isChecked():
            layer=self.DeltaMatrix[Band9-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('deltaB9')

        if self.dlg.checkBox_FAD_B11.isChecked():
            layer=self.DeltaMatrix[Band11-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('deltaB11')

        if self.dlg.checkBox_FAD_NDVI.isChecked():
            nir=self.PostMatrix[Band8-1]
            red=self.PostMatrix[Band4-1]
            post=(nir-red)/(nir+red)
            nir=self.PreMatrix[Band8-1]
            red=self.PreMatrix[Band4-1]
            pre=(nir-red)/(nir+red)
            layer=post-pre
            FinalFeatureList.append(layer)
            NameBandsList.append('deltaNDVI')

        if self.dlg.checkBox_FAD_NBR.isChecked():
            nir=self.PostMatrix[Band8-1]
            swir=self.PostMatrix[Band12-1]
            post=(nir-swir)/(nir+swir)
            nir=self.PreMatrix[Band8-1]
            swir=self.PreMatrix[Band12-1]
            pre=(nir-swir)/(nir+swir)
            layer=post-pre
            FinalFeatureList.append(layer)
            NameBandsList.append('deltaNBR')

        if self.dlg.checkBox_FAD_NBR2.isChecked():
            swir1=self.PostMatrix[Band11-1]
            swir=self.PostMatrix[Band12-1]
            post=(swir1-swir)/(swir1+swir)
            swir1=self.PreMatrix[Band11-1]
            swir=self.PreMatrix[Band12-1]
            pre=(swir1-swir)/(swir1+swir)
            layer=post-pre
            FinalFeatureList.append(layer)
            NameBandsList.append('deltaNBR2')

        if self.dlg.checkBox_FAD_MIRBI.isChecked():
            swir1=(self.PostMatrix[Band11-1])/10000
            swir=(self.PostMatrix[Band12-1])/10000
            post=10*swir-9.5*swir1+2
            swir1=(self.PreMatrix[Band11-1])/10000
            swir=(self.PreMatrix[Band12-1])/10000
            pre=10*swir-9.5*swir1+2
            layer=post-pre
            FinalFeatureList.append(layer)
            NameBandsList.append('deltaMIRBI')

        self.update_progress(95)

        FinalFeatureMatix=np.array(FinalFeatureList)      

        Nband=FinalFeatureMatix.shape[0]
        Xsize=FinalFeatureMatix.shape[2]
        Ysize=FinalFeatureMatix.shape[1]

        Feature_outputfile = self.dlg.lineEdit_Feature.text()
        
        if not Feature_outputfile:
                path_index = 0
                path = self.dlg.pre_fire_path
                filename = "Feature_result.tif"     
        else:
                path_index = 1
                path = Feature_outputfile
                filename="null"
        
        self.Feature_result = WriteLayer(path_index,path,FinalFeatureMatix,NameBandsList,Nband,Xsize,Ysize,filename,self.GeoTrans,self.proj)
        self.dlg.pushButton_MD_run.setEnabled(True)
        if self.dlg.checkBox_Feature_display.isChecked():
                self.display_in_qgis(self.Feature_result.output_path)
        
        self.update_progress(100)
        self.hide_progress_bar()

        end=time.process_time()
        print("Process end")
        print('Computational time Feature [s]: ',(end - start),"start=", start,"end=",end)
        print('\n') 
        if not flag:
            self.window = QtWidgets.QDialog()
            self.ui = Ui_Message()
            self.ui.setupUi(self.window)
            self.window.show()
       
###################################################################################################     
###################################################################################################
###################################################################################################
#  This part of the script contains the code about Membership Degree computation
#  The process is executed when the button "COMPUTE MD" is clicked  
   
    def ComputeMD(self,flag=False):
        print("ComputeMD button clicked, wait until the process end")
        self.show_progress_bar("Computing MD")
        self.update_progress(10)
        start=time.process_time()
        ###################################################################################################
        # Apply the Membership Function (K and x0 come from the user as input) on the selected layer 
        # MF = 1/(1+np.exp(-K*(Matrix/10000-x)))
        ###################################################################################################
    
        FinalBandList=[]
        NameBandsList=[]

        # FEATURES DEFAULT
        if self.dlg.checkBox_FD_postB6.isChecked():
            K=self.dlg.doubleSpinBox_FD_postB6_K.value()
            x=self.dlg.doubleSpinBox_FD_postB6_x.value()
            # -1 is necessary in order to allign the order of the bands
            # user starts to count from 1 (B1,B2...), instead pyhton starts to count from 0
            layer=self.PostMatrix[self.BandsList[5]-1]
            MD_postB6 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_postB6)
            NameBandsList.append('MD_postB6')

        if self.dlg.checkBox_FD_postB7.isChecked():
            K=self.dlg.doubleSpinBox_FD_postB7_K.value()
            x=self.dlg.doubleSpinBox_FD_postB7_x.value()
            layer=self.PostMatrix[self.BandsList[6]-1]
            MD_postB7 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_postB7)
            NameBandsList.append('MD_postB7')

        if self.dlg.checkBox_FD_postNIR.isChecked():
            K=self.dlg.doubleSpinBox_FD_postNIR_K.value()
            x=self.dlg.doubleSpinBox_FD_postNIR_x.value()
            layer=self.PostMatrix[self.BandsList[7]-1]
            MD_postB8 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_postB8)
            NameBandsList.append('MD_postB8')

        if self.dlg.checkBox_FD_deltaB6.isChecked():
            K=self.dlg.doubleSpinBox_FD_deltaB6_K.value()
            x=self.dlg.doubleSpinBox_FD_deltaB6_x.value()
            layer=self.DeltaMatrix[self.BandsList[5]-1]
            MD_deltaB6 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_deltaB6)
            NameBandsList.append('MD_deltaB6')

        if self.dlg.checkBox_FD_deltaB7.isChecked():
            K=self.dlg.doubleSpinBox_FD_deltaB7_K.value()
            x=self.dlg.doubleSpinBox_FD_deltaB7_x.value()
            layer=self.DeltaMatrix[self.BandsList[6]-1]
            MD_deltaB7 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_deltaB7)
            NameBandsList.append('MD_deltaB7')

        if self.dlg.checkBox_FD_deltaNIR.isChecked():
            K=self.dlg.doubleSpinBox_FD_deltaNIR_K.value()
            x=self.dlg.doubleSpinBox_FD_deltaNIR_x.value()
            layer=self.DeltaMatrix[self.BandsList[7]-1]
            MD_deltaB8 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_deltaB8)
            NameBandsList.append('MD_deltaB8')

        if self.dlg.checkBox_FD_deltaB12.isChecked():
            K=self.dlg.doubleSpinBox_FD_deltaB12_K.value()
            x=self.dlg.doubleSpinBox_FD_deltaB12_x.value()
            layer=self.DeltaMatrix[self.BandsList[12]-1]                    
            MD_deltaB12 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_deltaB12)
            NameBandsList.append('MD_deltaB12')

        # FEATURES ADVANCED POST
        if self.dlg.checkBox_FAP_B1.isChecked():
            K=self.dlg.doubleSpinBox_FAP_B1_K.value()
            x=self.dlg.doubleSpinBox_FAP_B1_x.value()
            layer=self.PostMatrix[self.BandsList[0]-1]
            MD_postB1 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_postB1)
            NameBandsList.append('MD_postB1')

        if self.dlg.checkBox_FAP_B2.isChecked():
            K=self.dlg.doubleSpinBox_FAP_B2_K.value()
            x=self.dlg.doubleSpinBox_FAP_B2_x.value()
            layer=self.PostMatrix[self.BandsList[1]-1]
            MD_postB2 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_postB2)
            NameBandsList.append('MD_postB2')

        if self.dlg.checkBox_FAP_B3.isChecked():
            K=self.dlg.doubleSpinBox_FAP_B3_K.value()
            x=self.dlg.doubleSpinBox_FAP_B3_x.value()
            layer=self.PostMatrix[self.BandsList[2]-1]
            MD_postB3 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_postB3)
            NameBandsList.append('MD_postB3')

        if self.dlg.checkBox_FAP_B4.isChecked():
            K=self.dlg.doubleSpinBox_FAP_B4_K.value()
            x=self.dlg.doubleSpinBox_FAP_B4_x.value()
            layer=self.PostMatrix[self.BandsList[3]-1]
            MD_postB4 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_postB4)
            NameBandsList.append('MD_postB4')

        if self.dlg.checkBox_FAP_B5.isChecked():
            K=self.dlg.doubleSpinBox_FAP_B5_K.value()
            x=self.dlg.doubleSpinBox_FAP_B5_x.value()
            layer=self.PostMatrix[self.BandsList[4]-1]
            MD_postB5 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_postB5)
            NameBandsList.append('MD_postB5')

        if self.dlg.checkBox_FAP_B8A.isChecked():
            K=self.dlg.doubleSpinBox_FAP_B8A_K.value()
            x=self.dlg.doubleSpinBox_FAP_B8A_x.value()
            layer=self.PostMatrix[self.BandsList[8]-1]
            MD_postB8A = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_postB8A)
            NameBandsList.append('MD_postB8A')

        if self.dlg.checkBox_FAP_B9.isChecked():
            K=self.dlg.doubleSpinBox_FAP_B9_K.value()
            x=self.dlg.doubleSpinBox_FAP_B9_x.value()
            layer=self.PostMatrix[self.BandsList[9]-1]
            MD_postB9 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_postB9)
            NameBandsList.append('MD_postB9')

        if self.dlg.checkBox_FAP_B11.isChecked():
            K=self.dlg.doubleSpinBox_FAP_B11_K.value()
            x=self.dlg.doubleSpinBox_FAP_B11_x.value()
            layer=self.PostMatrix[self.BandsList[11]-1]
            MD_postB11 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_postB11)
            NameBandsList.append('MD_postB11')

        if self.dlg.checkBox_FAP_B12.isChecked():
            K=self.dlg.doubleSpinBox_FAP_B12_K.value()
            x=self.dlg.doubleSpinBox_FAP_B12_x.value()
            layer=self.PostMatrix[self.BandsList[12]-1]
            MD_postB12 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_postB12)
            NameBandsList.append('MD_postB12')
        
        if self.dlg.checkBox_FAP_NDVI.isChecked():
            K=self.dlg.doubleSpinBox_FAP_NDVI_K.value()
            x=self.dlg.doubleSpinBox_FAP_NDVI_x.value()
            nir=self.PostMatrix[self.BandsList[7]-1]
            red=self.PostMatrix[self.BandsList[3]-1]
            layer=(nir-red)/(nir+red)
            MD_postNDVI = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_postNDVI)
            NameBandsList.append('MD_postNDVI')

        if self.dlg.checkBox_FAP_NBR.isChecked():
            K=self.dlg.doubleSpinBox_FAP_NBR_K.value()
            x=self.dlg.doubleSpinBox_FAP_NBR_x.value()
            nir=self.PostMatrix[self.BandsList[7]-1]
            swir=self.PostMatrix[self.BandsList[12]-1]
            layer=(nir-swir)/(nir+swir)
            MD_postNBR = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_postNBR)
            NameBandsList.append('MD_postNBR')

        if self.dlg.checkBox_FAP_NBR2.isChecked():
            K=self.dlg.doubleSpinBox_FAP_NBR2_K.value()
            x=self.dlg.doubleSpinBox_FAP_NBR2_x.value()
            swir1=self.PostMatrix[self.BandsList[11]-1]
            swir=self.PostMatrix[self.BandsList[12]-1]
            layer=(swir1-swir)/(swir1+swir)
            MD_postNBR2 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_postNBR2)
            NameBandsList.append('MD_postNBR2')

        if self.dlg.checkBox_FAP_MIRBI.isChecked():
            K=self.dlg.doubleSpinBox_FAP_MIRBI_K.value()
            x=self.dlg.doubleSpinBox_FAP_MIRBI_x.value()
            swir1=(self.PostMatrix[self.BandsList[11]-1])/10000
            swir=(self.PostMatrix[self.BandsList[12]-1])/10000
            layer=10*swir-9.5*swir1+2
            MD_postMIRBI = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_postMIRBI)
            NameBandsList.append('MD_postMIRBI')

        # FEATURES ADVANCED DELTA
        if self.dlg.checkBox_FAD_B1.isChecked():
            K=self.dlg.doubleSpinBox_FAD_B1_K.value()
            x=self.dlg.doubleSpinBox_FAD_B1_x.value()
            layer=self.DeltaMatrix[self.BandsList[0]-1]  
            MD_deltaB1 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_deltaB1)
            NameBandsList.append('MD_deltaB1')

        if self.dlg.checkBox_FAD_B2.isChecked():
            K=self.dlg.doubleSpinBox_FAD_B2_K.value()
            x=self.dlg.doubleSpinBox_FAD_B2_x.value()
            layer=self.DeltaMatrix[self.BandsList[1]-1]  
            MD_deltaB2 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_deltaB2)
            NameBandsList.append('MD_deltaB2')

        if self.dlg.checkBox_FAD_B3.isChecked():
            K=self.dlg.doubleSpinBox_FAD_B3_K.value()
            x=self.dlg.doubleSpinBox_FAD_B3_x.value()
            layer=self.DeltaMatrix[self.BandsList[2]-1]  
            MD_deltaB3 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_deltaB3)
            NameBandsList.append('MD_deltaB3')

        if self.dlg.checkBox_FAD_B4.isChecked():
            K=self.dlg.doubleSpinBox_FAD_B4_K.value()
            x=self.dlg.doubleSpinBox_FAD_B4_x.value()
            layer=self.DeltaMatrix[self.BandsList[3]-1]  
            MD_deltaB4 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_deltaB4)
            NameBandsList.append('MD_deltaB4')

        if self.dlg.checkBox_FAD_B5.isChecked():
            K=self.dlg.doubleSpinBox_FAD_B5_K.value()
            x=self.dlg.doubleSpinBox_FAD_B5_x.value()
            layer=self.DeltaMatrix[self.BandsList[4]-1]  
            MD_deltaB5 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_deltaB5)
            NameBandsList.append('MD_deltaB5')

        if self.dlg.checkBox_FAD_B8A.isChecked():
            K=self.dlg.doubleSpinBox_FAD_B8A_K.value()
            x=self.dlg.doubleSpinBox_FAD_B8A_x.value()
            layer=self.DeltaMatrix[self.BandsList[8]-1]  
            MD_deltaB8A = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_deltaB8A)
            NameBandsList.append('MD_deltaB8A')

        if self.dlg.checkBox_FAD_B9.isChecked():
            K=self.dlg.doubleSpinBox_FAD_B9_K.value()
            x=self.dlg.doubleSpinBox_FAD_B9_x.value()
            layer=self.DeltaMatrix[self.BandsList[9]-1]  
            MD_deltaB9 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_deltaB9)
            NameBandsList.append('MD_deltaB9')

        if self.dlg.checkBox_FAD_B11.isChecked():
            K=self.dlg.doubleSpinBox_FAD_B11_K.value()
            x=self.dlg.doubleSpinBox_FAD_B11_x.value()
            layer=self.DeltaMatrix[self.BandsList[11]-1]  
            MD_deltaB11 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_deltaB11)
            NameBandsList.append('MD_deltaB11')
        
        if self.dlg.checkBox_FAD_NDVI.isChecked():
            K=self.dlg.doubleSpinBox_FAD_NDVI_K.value()
            x=self.dlg.doubleSpinBox_FAD_NDVI_x.value()
            nir=self.PostMatrix[self.BandsList[7]-1]
            red=self.PostMatrix[self.BandsList[3]-1]
            post=(nir-red)/(nir+red)
            nir=self.PreMatrix[self.BandsList[7]-1]
            red=self.PreMatrix[self.BandsList[3]-1]
            pre=(nir-red)/(nir+red)
            layer=post-pre
            MD_deltaNDVI = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_deltaNDVI)
            NameBandsList.append('MD_deltaNDVI')

        if self.dlg.checkBox_FAD_NBR.isChecked():
            K=self.dlg.doubleSpinBox_FAD_NBR_K.value()
            x=self.dlg.doubleSpinBox_FAD_NBR_x.value()
            nir=self.PostMatrix[self.BandsList[7]-1]
            swir=self.PostMatrix[self.BandsList[12]-1]
            post=(nir-swir)/(nir+swir)
            nir=self.PreMatrix[self.BandsList[7]-1]
            swir=self.PreMatrix[self.BandsList[12]-1]
            pre=(nir-swir)/(nir+swir)
            layer=post-pre
            MD_deltaNBR = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_deltaNBR)
            NameBandsList.append('MD_deltaNBR')

        if self.dlg.checkBox_FAD_NBR2.isChecked():
            K=self.dlg.doubleSpinBox_FAD_NBR2_K.value()
            x=self.dlg.doubleSpinBox_FAD_NBR2_x.value()
            swir1=self.PostMatrix[self.BandsList[11]-1]
            swir=self.PostMatrix[self.BandsList[12]-1]
            post=(swir1-swir)/(swir1+swir)
            swir1=self.PreMatrix[self.BandsList[11]-1]
            swir=self.PreMatrix[self.BandsList[12]-1]
            pre=(swir1-swir)/(swir1+swir)
            layer=post-pre
            MD_deltaNBR2 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_deltaNBR2)
            NameBandsList.append('MD_deltaNBR2')

        if self.dlg.checkBox_FAD_MIRBI.isChecked():
            K=self.dlg.doubleSpinBox_FAD_MIRBI_K.value()
            x=self.dlg.doubleSpinBox_FAD_MIRBI_x.value()
            swir1=(self.PostMatrix[self.BandsList[11]-1])/10000
            swir=(self.PostMatrix[self.BandsList[12]-1])/10000
            post=10*swir-9.5*swir1+2
            swir1=(self.PreMatrix[self.BandsList[11]-1])/10000
            swir=(self.PreMatrix[self.BandsList[12]-1])/10000
            pre=10*swir-9.5*swir1+2
            layer=post-pre
            MD_deltaMIRBI = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_deltaMIRBI)
            NameBandsList.append('MD_deltaMIRBI')


        # from list to an array
        self.update_progress(90)
        self.FinalBandMatix=np.array(FinalBandList)

        Nband=self.FinalBandMatix.shape[0]
        Xsize=self.FinalBandMatix.shape[2]
        Ysize=self.FinalBandMatix.shape[1]

        self.dlg.Nband = int(Nband) # save Nband for OWA use in parameters window

        MD_outputfile = self.dlg.lineEdit_MD.text()
        
        if not MD_outputfile:
                path_index = 0
                path = self.dlg.pre_fire_path
                filename = "MD_result.tif"     
        else:
                path_index = 1
                path = MD_outputfile
                filename="null"
        
        self.MD_result = WriteLayer(path_index,path,self.FinalBandMatix,NameBandsList,Nband,Xsize,Ysize,filename,self.GeoTrans,self.proj)
        self.MD_path=self.MD_result.output_path

        if self.dlg.checkBox_MD_display.isChecked():
                self.display_in_qgis(self.MD_result.output_path)
                self.dlg.comboBox_InputOWA.insertItems(1, [os.path.splitext(os.path.basename(self.MD_path))[0]])
                self.dlg.comboBox_InputOWA.setCurrentIndex(1)
        
        self.update_progress(100)
        self.hide_progress_bar()

        end=time.process_time()
        print("Process end")
        print('Computational time MD [s]: ',(end - start),"start=", start,"end=",end)
        print('\n') 
        if not flag:
            self.window = QtWidgets.QDialog()
            self.ui = Ui_Message()
            self.ui.setupUi(self.window)
            self.window.show()

###################################################################################################     
###################################################################################################
###################################################################################################
#  This part of the script contains the code about OWA computation
   
#  The process is executed when the button "COMPUTE OWA" is clicked
    def ComputeOWA(self,flag=False):   
        print("ComputeOWA button clicked, wait until the process end")
        self.show_progress_bar("Computing OWA")
        self.update_progress(3)
        start=time.process_time()
           
    ############
    # OWA input from User
    ############
        # Get layer path
        if not self.MD_path:
            print("Please select a valid MD layer before running OWA")
            return None
        else:
            MD_path = self.MD_path
        # Read the MD layer
            dataset = gdal.Open(MD_path)
            if dataset is None:
                print(f"Unable to open {MD_path}")
                return None

            # Read all bands into a list
            FinalBandList = []
            for i in range(1, dataset.RasterCount + 1):
                band = dataset.GetRasterBand(i)
                FinalBandList.append(band.ReadAsArray())

            FinalBandMatix = np.array(FinalBandList)
            self.FinalBandMatix = FinalBandMatix
            Xsize = FinalBandMatix.shape[2]
            Ysize = FinalBandMatix.shape[1]
            self.GeoTrans = dataset.GetGeoTransform()
            self.proj = dataset.GetProjection()

            # Close the dataset
            dataset = None

        self.update_progress(20)

        if self.dlg.checkBox_OWA_AND.isChecked() or self.dlg.radioButton_OWA_S_AND.isChecked() or \
            self.dlg.radioButton_OWA_G_AND.isChecked():

            n_bands=self.FinalBandMatix.shape[0]
            w = np.zeros(n_bands)
            w[-1]=1

            OWA=OrderedWeigthAverage(self.FinalBandMatix,w=w)

            # Save weights to compute orness
            if self.dlg.radioButton_OWA_S_AND.isChecked():
                w_Seed = w
            if self.dlg.radioButton_OWA_G_AND.isChecked():
                w_Grow = w
              
            outputfile = self.dlg.lineEdit_OWA_AND.text()
            filename="OWA_AND.tif"
            
            # if the outputfile path is not specified the plugin uses the same path of one of the two input
            # files, in particular the seed layer path
            if not outputfile:
                path_index=0
                path= MD_path if MD_path else self.dlg.pre_fire_path
            # otherwise it uses the path specified by the user
            else:
                path_index=1    
                path=outputfile

            NameBandsList='OWA AND'
            Nband=1
            Xsize=OWA.Integrated_matrix.shape[1]
            Ysize=OWA.Integrated_matrix.shape[0]
            self.OWA_AND = WriteLayer(path_index,path,OWA.Integrated_matrix,NameBandsList,Nband,Xsize,Ysize,filename,self.GeoTrans,self.proj)
            
            if self.dlg.checkBox_OWA_display.isChecked():
                self.display_in_qgis(self.OWA_AND.output_path)

        self.update_progress(30)

        if self.dlg.checkBox_OWA_almostAND.isChecked() or self.dlg.radioButton_OWA_S_almostAND.isChecked() or \
            self.dlg.radioButton_OWA_G_almostAND.isChecked():

            n_bands=self.FinalBandMatix.shape[0]
            
            w = np.zeros(n_bands)
            w[-1]=0.5
            w[-2]=0.5
            OWA=OrderedWeigthAverage(self.FinalBandMatix,w=w)

            # Save weights to compute orness
            if self.dlg.radioButton_OWA_S_almostAND.isChecked():
                w_Seed = w
            if self.dlg.radioButton_OWA_G_almostAND.isChecked():
                w_Grow = w
            
            outputfile = self.dlg.lineEdit_OWA_almostAND.text()
            filename="OWA_almostAND.tif"

            if not outputfile:
                path_index=0
                path= MD_path if MD_path else self.dlg.pre_fire_path
            else:
                path_index=1
                path=outputfile
                
            NameBandsList='OWA almost AND'
            Nband=1
            Xsize=OWA.Integrated_matrix.shape[1]
            Ysize=OWA.Integrated_matrix.shape[0]
            self.OWA_almostAND = WriteLayer(path_index,path,OWA.Integrated_matrix,NameBandsList,Nband,Xsize,Ysize,filename,self.GeoTrans,self.proj)
    
            if self.dlg.checkBox_OWA_display.isChecked():
                self.display_in_qgis(self.OWA_almostAND.output_path)

        self.update_progress(40)
        
        if self.dlg.checkBox_OWA_AVERAGE.isChecked() or self.dlg.radioButton_OWA_S_AVERAGE.isChecked() or \
            self.dlg.radioButton_OWA_G_AVERAGE.isChecked():
            n_bands=self.FinalBandMatix.shape[0]

            w = np.ones(n_bands)/n_bands
            OWA=OrderedWeigthAverage(self.FinalBandMatix,w=w)

            # Save weights to compute orness
            if self.dlg.radioButton_OWA_S_AVERAGE.isChecked():
                w_Seed = w
            if self.dlg.radioButton_OWA_G_AVERAGE.isChecked():
                w_Grow = w

            outputfile = self.dlg.lineEdit_OWA_AVERAGE.text()
            filename="OWA_AVERAGE.tif"

            if not outputfile:
                path_index=0
                path=MD_path if MD_path else self.dlg.pre_fire_path
            else:
                path_index=1
                path=outputfile
                
            NameBandsList='OWA AVERAGE'
            Nband=1
            Xsize=OWA.Integrated_matrix.shape[1]
            Ysize=OWA.Integrated_matrix.shape[0]
            self.OWA_AVERAGE = WriteLayer(path_index,path,OWA.Integrated_matrix,NameBandsList,Nband,Xsize,Ysize,filename,self.GeoTrans,self.proj)
    
            if self.dlg.checkBox_OWA_display.isChecked():
                self.display_in_qgis(self.OWA_AVERAGE.output_path)

        self.update_progress(50)
                   
        if self.dlg.checkBox_OWA_almostOR.isChecked() or self.dlg.radioButton_OWA_S_almostOR.isChecked() or \
            self.dlg.radioButton_OWA_G_almostOR.isChecked():
            n_bands=self.FinalBandMatix.shape[0]
            
            w = np.zeros(n_bands)
            w[0]=0.5
            w[1]=0.5
            OWA=OrderedWeigthAverage(self.FinalBandMatix,w=w)

            # Save weights to compute orness
            if self.dlg.radioButton_OWA_S_almostOR.isChecked():
                w_Seed = w
            if self.dlg.radioButton_OWA_G_almostOR.isChecked():
                w_Grow = w

            outputfile = self.dlg.lineEdit_OWA_almostOR.text()
            filename="OWA_almostOR.tif"

            if not outputfile:
                path_index=0
                path=MD_path if MD_path else self.dlg.pre_fire_path
            else:
                path_index=1
                path=outputfile
                
            NameBandsList='OWA almost OR'
            Nband=1
            Xsize=OWA.Integrated_matrix.shape[1]
            Ysize=OWA.Integrated_matrix.shape[0]
            self.OWA_almostOR = WriteLayer(path_index,path,OWA.Integrated_matrix,NameBandsList,Nband,Xsize,Ysize,filename,self.GeoTrans,self.proj)
    
            if self.dlg.checkBox_OWA_display.isChecked():
                self.display_in_qgis(self.OWA_almostOR.output_path)

        self.update_progress(60)
        
        if self.dlg.checkBox_OWA_OR.isChecked() or self.dlg.radioButton_OWA_S_OR.isChecked() or \
            self.dlg.radioButton_OWA_G_OR.isChecked():
            n_bands=self.FinalBandMatix.shape[0]
            w = np.zeros(n_bands)
            w[0]=1
            OWA=OrderedWeigthAverage(self.FinalBandMatix,w=w)

            # Save weights to compute orness
            if self.dlg.radioButton_OWA_S_OR.isChecked():
                w_Seed = w
            if self.dlg.radioButton_OWA_G_OR.isChecked():
                w_Grow = w

            outputfile = self.dlg.lineEdit_OWA_OR.text()
            filename="OWA_OR.tif"

            if not outputfile:
                path_index=0
                path=MD_path if MD_path else self.dlg.pre_fire_path
            else:
                path_index=1
                path=outputfile
                
            NameBandsList='OWA OR'
            Nband=1
            Xsize=OWA.Integrated_matrix.shape[1]
            Ysize=OWA.Integrated_matrix.shape[0]
            self.OWA_OR = WriteLayer(path_index,path,OWA.Integrated_matrix,NameBandsList,Nband,Xsize,Ysize,filename,self.GeoTrans,self.proj)
    
    
            if self.dlg.checkBox_OWA_display.isChecked():
                self.display_in_qgis(self.OWA_OR.output_path)

        self.update_progress(70)

        if self.dlg.checkBox_OWA_UserChoice1.isChecked() or self.dlg.radioButton_OWA_S_UserChoice1.isChecked() or \
            self.dlg.radioButton_OWA_G_UserChoice1.isChecked():
            n_bands=self.FinalBandMatix.shape[0]
            
            w = np.zeros(n_bands)
            a = int(self.dlg.lineEdit_OWA_a_UC1.text())/n_bands
            b = int(self.dlg.lineEdit_OWA_b_UC1.text())/n_bands
            for i in range(1,n_bands+1): #i starts from 0 to n_bands-1
                w[i-1] = Qfunction(a,b,i/n_bands)-Qfunction(a,b,(i-1)/n_bands)
    
            
            print("Weights OWA User Choice 1:", w)
            OWA=OrderedWeigthAverage(self.FinalBandMatix,w=w)

            # Save weights to compute orness
            if self.dlg.radioButton_OWA_S_UserChoice1.isChecked():
                w_Seed = w
            if self.dlg.radioButton_OWA_G_UserChoice1.isChecked():
                w_Grow = w

            outputfile = self.dlg.lineEdit_OWA_UserChoice1.text()
            filename="OWA_UserChoice1.tif"

            if not outputfile:
                path_index=0
                path=MD_path if MD_path else self.dlg.pre_fire_path
            else:
                path_index=1
                path=outputfile
                
            NameBandsList='OWA UserChoice1'
            Nband=1
            Xsize=OWA.Integrated_matrix.shape[1]
            Ysize=OWA.Integrated_matrix.shape[0]
            self.OWA_UserChoice1 = WriteLayer(path_index,path,OWA.Integrated_matrix,NameBandsList,Nband,Xsize,Ysize,filename,self.GeoTrans,self.proj)
    
    
            if self.dlg.checkBox_OWA_display.isChecked():
                self.display_in_qgis(self.OWA_UserChoice1.output_path)

        self.update_progress(80)

        if self.dlg.checkBox_OWA_UserChoice2.isChecked() or self.dlg.radioButton_OWA_S_UserChoice2.isChecked() or \
            self.dlg.radioButton_OWA_G_UserChoice2.isChecked():
            n_bands=self.FinalBandMatix.shape[0]
 
            w = np.zeros(n_bands)
            a = int(self.dlg.lineEdit_OWA_a_UC2.text())/n_bands
            b = int(self.dlg.lineEdit_OWA_b_UC2.text())/n_bands
            for i in range(1,n_bands+1): #i starts from 0 to n_bands-1
                w[i-1] = Qfunction(a,b,i/n_bands)-Qfunction(a,b,(i-1)/n_bands)
    
                    
            print("Weights OWA User Choice 2:", w)
            OWA=OrderedWeigthAverage(self.FinalBandMatix,w=w)

            # Save weights to compute orness
            if self.dlg.radioButton_OWA_S_UserChoice2.isChecked():
                w_Seed = w
            if self.dlg.radioButton_OWA_G_UserChoice2.isChecked():
                w_Grow = w
            
            outputfile = self.dlg.lineEdit_OWA_UserChoice2.text()
            filename="OWA_UserChoice2.tif"

            if not outputfile:
                path_index=0
                path=MD_path if MD_path else self.dlg.pre_fire_path
            else:
                path_index=1
                path=outputfile
                
            NameBandsList='OWA UserChoice2'
            Nband=1
            Xsize=OWA.Integrated_matrix.shape[1]
            Ysize=OWA.Integrated_matrix.shape[0]
            self.OWA_UserChoice2 = WriteLayer(path_index,path,OWA.Integrated_matrix,NameBandsList,Nband,Xsize,Ysize,filename,self.GeoTrans,self.proj)
    
    
            if self.dlg.checkBox_OWA_display.isChecked():
                self.display_in_qgis(self.OWA_UserChoice2.output_path)

        self.dlg.comboBox_RG_seed.clear()
        self.dlg.comboBox_RG_grow.clear()
        self.dlg.comboBox_RG_seed.addItems(['Select a Layer'])
        self.dlg.comboBox_RG_grow.addItems(['Select a Layer'])
        poly_layers = []
        raster_layers = []
        for node in QgsProject.instance().layerTreeRoot().children():
            layer = node.layer()
            if isinstance(layer, QgsVectorLayer) and layer.geometryType() == QgsWkbTypes.PolygonGeometry:
                poly_layers.append(layer)
            elif isinstance(layer, QgsRasterLayer):
                raster_layers.append(layer)
        self.dlg.comboBox_RG_seed.addItems([layer.name() for layer in raster_layers])
        self.dlg.comboBox_RG_grow.addItems([layer.name() for layer in raster_layers])

        if not self.Seed_file:
            if self.dlg.radioButton_OWA_S_AND.isChecked():
                self.Seed_file = self.OWA_AND.output_path

            if self.dlg.radioButton_OWA_S_almostAND.isChecked():
                self.Seed_file = self.OWA_almostAND.output_path

            if self.dlg.radioButton_OWA_S_AVERAGE.isChecked():
                self.Seed_file = self.OWA_AVERAGE.output_path

            if self.dlg.radioButton_OWA_S_almostOR.isChecked():
                self.Seed_file = self.OWA_almostOR.output_path

            if self.dlg.radioButton_OWA_S_OR.isChecked():
                self.Seed_file = self.OWA_OR.output_path

            if self.dlg.radioButton_OWA_S_UserChoice1.isChecked():
                self.Seed_file = self.OWA_UserChoice1.output_path

            if self.dlg.radioButton_OWA_S_UserChoice2.isChecked():
                self.Seed_file = self.OWA_UserChoice2.output_path


        if not self.Grow_file:
            if self.dlg.radioButton_OWA_G_AND.isChecked():
                self.Grow_file = self.OWA_AND.output_path

            if self.dlg.radioButton_OWA_G_almostAND.isChecked():
                self.Grow_file = self.OWA_almostAND.output_path

            if self.dlg.radioButton_OWA_G_AVERAGE.isChecked():
                self.Grow_file = self.OWA_AVERAGE.output_path

            if self.dlg.radioButton_OWA_G_almostOR.isChecked():
                self.Grow_file = self.OWA_almostOR.output_path

            if self.dlg.radioButton_OWA_G_OR.isChecked():
                self.Grow_file = self.OWA_OR.output_path 

            if self.dlg.radioButton_OWA_G_UserChoice1.isChecked():
                self.Grow_file = self.OWA_UserChoice1.output_path

            if self.dlg.radioButton_OWA_G_UserChoice2.isChecked():
                self.Grow_file = self.OWA_UserChoice2.output_path

        self.dlg.comboBox_RG_seed.setCurrentText(os.path.splitext(os.path.basename(self.Seed_file))[0])
        self.dlg.comboBox_RG_grow.setCurrentText(os.path.splitext(os.path.basename(self.Grow_file))[0])
        self.update_progress(100)
        self.hide_progress_bar()   
        end=time.process_time()
        print("Process end")
        print('Computational time OWA [s]: ',(end - start),"start=", start,"end=",end)   
        print('\n') 

        if not self.check_orness(w_Seed, w_Grow):
            self.dlg.lineEdit_OWA.setVisible(True)
            self.dlg.lineEdit_OWA.setStyleSheet("color: red; font-weight: bold;")
        elif not flag:
            self.window = QtWidgets.QDialog()
            self.ui = Ui_Message()
            self.ui.setupUi(self.window)
            self.window.show()
    
    # function to check the orness of the two selected OWA weights
    def check_orness(self, w_Seed, w_Grow):
        n = len(w_Seed)
        coeff = np.arange(n - 1, -1, -1) / (n - 1)
        orness_Seed = np.sum(w_Seed * coeff)
        orness_Grow = np.sum(w_Grow*coeff)
        #orness_Seed = np.sum(w_Seed*(len(w_Seed)-1))/(len(w_Seed)-1)
        #orness_Grow = np.sum(w_Grow*(len(w_Grow)-1))/(len(w_Grow)-1)
        print("OWA orness seed and grow:", orness_Seed, orness_Grow)
        if orness_Seed < orness_Grow:
            return True
        else:
            return False
###################################################################################################
###################################################################################################
###################################################################################################
#  This part of the script contains the code about the application of the Region Growing Algorithm 
#  The process is executed when the button "COMPUTE RG" is clicked 
#

    def ComputeRG(self,flag=False):
        print("ComputeRG button clicked, wait until the process end")
        self.show_progress_bar("Computing RG")
        self.update_progress(5)
        start=time.process_time()
               
        Seed_value = round(self.dlg.doubleSpinBox_RG_seed.value(),2)
        Grow_value = round(self.dlg.doubleSpinBox_RG_grow.value(),2)
        self.update_progress(20)

        DataRG = ReadingData(self.Seed_file,self.Grow_file) 
        Seed_matrix = DataRG.FirstMatrix
        Grow_matrix = DataRG.SecondMatrix
 
        RG=RegionGrowing(Seed_value,Grow_value,Seed_matrix,Grow_matrix)

        self.Burned_matrix= RG.Result_matrix

        RG_outputfile = self.dlg.lineEdit_RG_result.text()
        
        if not RG_outputfile:
                path_index = 0
                path = self.Seed_file
                filename = "RegionGrowing_result.tif"     
        else:
                path_index = 1
                path = RG_outputfile
                filename="null"
        

        NameBandsList='Region Growing Result'
        Nband=1
        Xsize=self.Burned_matrix.shape[1]
        Ysize=self.Burned_matrix.shape[0]  

        self.RG_result = WriteLayer(path_index,path,self.Burned_matrix,NameBandsList,Nband,Xsize,Ysize,filename,DataRG.gt,DataRG.proj)
        self.update_progress(95)
        
        if self.dlg.checkBox_RG_display.isChecked():
                self.display_in_qgis(self.RG_result.output_path)
        self.update_progress(100)
        self.hide_progress_bar()
        end=time.process_time()
        print("Process end")
        print('Computational time RG [s]: ',(end - start),"start=", start,"end=",end) 
        print('\n') 
        if not flag:
            self.window = QtWidgets.QDialog()
            self.ui = Ui_Message()
            self.ui.setupUi(self.window)
            self.window.show()

###################################################################################################
###################################################################################################
###################################################################################################
#  This part of the script contains the code about the Severity computation 
#  The process is executed when the button "COMPUTE SEVERITY" is clicked  

    def ComputeSeverity(self,flag=False):

        print("ComputeSeverity button clicked, wait until the process end")
        self.show_progress_bar("Computing Severity")
        self.update_progress(5)
        start=time.process_time()
        
        #NIR=BANDA8
        #SWIR=BANDA12
        # NBR = (NIR-SWIR)/(NIR+SWIR)
        # prefireNBR-postfireNBR
        
        NIR_pre=self.PreMatrix[self.BandsList[7]-1]
        NIR_post=self.PostMatrix[self.BandsList[7]-1]
        SWIR_pre=self.PreMatrix[self.BandsList[12]-1]
        SWIR_post=self.PostMatrix[self.BandsList[12]-1]

        NBR_pre=(NIR_pre-SWIR_pre)/(NIR_pre+SWIR_pre)
        NBR_post=(NIR_post-SWIR_post)/(NIR_post+SWIR_post)

        Delta_NBR = NBR_pre-NBR_post

        LowerLevelList=[]
        UpperLevelList=[]

        # Enhanced Regrowth, high
        ERH_1=self.dlg.doubleSpinBox_Severity_ERH_1.value()
        ERH_2=self.dlg.doubleSpinBox_Severity_ERH_2.value()
        LowerLevelList.append(ERH_1)
        UpperLevelList.append(ERH_2)
        
        
        # Enhanced Regrowth, low
        ERL_1=self.dlg.doubleSpinBox_Severity_ERL_1.value()
        ERL_2=self.dlg.doubleSpinBox_Severity_ERL_2.value()
        LowerLevelList.append(ERL_1)
        UpperLevelList.append(ERL_2)

        # Unburned
        U_1=self.dlg.doubleSpinBox_Severity_U_1.value()
        U_2=self.dlg.doubleSpinBox_Severity_U_2.value()
        LowerLevelList.append(U_1)
        UpperLevelList.append(U_2)

        # Low Severity
        L_1=self.dlg.doubleSpinBox_Severity_L_1.value()
        L_2=self.dlg.doubleSpinBox_Severity_L_2.value()
        LowerLevelList.append(L_1)
        UpperLevelList.append(L_2)

        # Moderate-low Severity
        ML_1=self.dlg.doubleSpinBox_Severity_ML_1.value()
        ML_2=self.dlg.doubleSpinBox_Severity_ML_2.value()
        LowerLevelList.append(ML_1)
        UpperLevelList.append(ML_2)

        # Miderate-high Severity
        MH_1=self.dlg.doubleSpinBox_Severity_MH_1.value()
        MH_2=self.dlg.doubleSpinBox_Severity_MH_2.value()
        LowerLevelList.append(MH_1)
        UpperLevelList.append(MH_2)

        # High Severity
        H_1=self.dlg.doubleSpinBox_Severity_H_1.value()
        H_2=self.dlg.doubleSpinBox_Severity_H_2.value()
        LowerLevelList.append(H_1)
        UpperLevelList.append(H_2)
        
        Severity_classification=Classification(Delta_NBR,LowerLevelList,UpperLevelList)
        
        self.Class_matrix=Severity_classification.Final_Matrix
        self.update_progress(45)
        
        NameBandsList='Severity Level'
        Nband=1        
        Xsize=self.Class_matrix.shape[1]
        Ysize=self.Class_matrix.shape[0]

        Severity_outputfile = self.dlg.lineEdit_Severity.text()

        if not Severity_outputfile:
                path_index = 0
                path = self.dlg.pre_fire_path
                filename = "Severity_result.tif"     
        else:
                path_index = 1
                path = Severity_outputfile
                filename="null"
        self.update_progress(97)
        self.Severity_result = WriteLayer(path_index,path,self.Class_matrix,NameBandsList,Nband,Xsize,Ysize,filename,self.GeoTrans,self.proj)
        
        if self.dlg.checkBox_Severity.isChecked():
                self.display_in_qgis(self.Severity_result.output_path)

        self.update_progress(100)
        self.hide_progress_bar()
        end=time.process_time()
        print("Process end")
        print('Computational time Severity [s]: ',(end - start),"start=", start,"end=",end) 
        print('\n') 
        if not flag:
            self.window = QtWidgets.QDialog()
            self.ui = Ui_Message()
            self.ui.setupUi(self.window)
            self.window.show()
###################################################################################################
###################################################################################################
###################################################################################################
#  This part of the script contains the code about the RG Severity computation 
#  The process is executed when the button "COMPUTE RG SEVERITY" is clicked 
    
    def ComputeRGSeverity(self,flag=False):

        print("ComputeRG_Severity button clicked, wait until the process end")
        self.show_progress_bar("Computing RGSeverity")
        self.update_progress(5)
        start=time.process_time()
        
        Class_Matrix = self.Class_matrix
        Burned_Matrix = self.Burned_matrix
        Class_Burned = Class_Matrix*Burned_Matrix

        NameBandsList='RG severity class'
        Nband=1        
        Xsize=Class_Matrix.shape[1]
        Ysize=Class_Matrix.shape[0]

        RGSeverity_outputfile = self.dlg.lineEdit_CombinedSeverity.text()
        self.update_progress(25)
        if not RGSeverity_outputfile:
                path_index = 0
                path = self.dlg.pre_fire_path
                filename = "RG_Severity_result.tif"     
        else:
                path_index = 1
                path = RGSeverity_outputfile
                filename="null"
        self.update_progress(87)
        self.RGSeverity_result = WriteLayer(path_index,path,Class_Burned,NameBandsList,Nband,Xsize,Ysize,filename,self.GeoTrans,self.proj)
        
        if self.dlg.checkBox_CombinedSeverity.isChecked():
                self.display_in_qgis(self.RGSeverity_result.output_path)

        self.update_progress(100)
        self.hide_progress_bar()
        end=time.process_time()
        print("Process end")
        print('Computational time Severity+RG [s]: ',(end - start),"start=", start,"end=",end)
        print('\n') 
        if not flag:
            self.window = QtWidgets.QDialog()
            self.ui = Ui_Message()
            self.ui.setupUi(self.window)
            self.window.show()

    # RG_Validation tab
    def browseRGFile(self):
        file_path, _ = QFileDialog.getOpenFileName(self.dlg, "Select RG Raster File", "", "Raster Files (*.tif *.tiff)")
        if file_path:
            self.dlg.lineEditRGFile.setText(file_path)

    def browseReferenceFile(self):
        file_path, _ = QFileDialog.getOpenFileName(self.dlg, "Select Reference Raster File", "", "Raster Files (*.tif *.tiff)")
        if file_path:
            self.dlg.lineEditReferenceFile.setText(file_path)

    def ComputeRGValidation(self):
        self.show_progress_bar("Computing RGValidation")
        self.update_progress(5)
        start=time.process_time()
        rg_raster_path = self.dlg.lineEditRGFile.text()
        reference_raster_path = self.dlg.lineEditReferenceFile.text()

        if not os.path.exists(rg_raster_path) or not os.path.exists(reference_raster_path):
            QMessageBox.warning(self.dlg, "Missing Input", "Please select both RG and Reference raster files.")
            return

        try:
            rg_raster_ds = gdal.Open(rg_raster_path)
            reference_raster_ds = gdal.Open(reference_raster_path)

            if not rg_raster_ds or not reference_raster_ds:
                QMessageBox.critical(self.dlg, "Error", "Failed to load raster files.")
                return

            width = rg_raster_ds.RasterXSize
            height = rg_raster_ds.RasterYSize

            rg_band = rg_raster_ds.GetRasterBand(1)

            reference_band = reference_raster_ds.GetRasterBand(1)

            rg_data = rg_band.ReadAsArray(0, 0, width, height)
            Mask = np.isnan(rg_data)  # True dove ci sono NaN
            rg_data[Mask] = 999
            rg_data = rg_data.astype(int)
            reference_data = reference_band.ReadAsArray(0, 0, width, height).astype(int)

            # Class Mapping
            class_mapping = {0: 'Unburned', 1: 'Burned'}

            # Initialize Confusion Matrix
            conf_matrix = np.zeros((2, 2), dtype=int)

            # Populate Confusion Matrix
            for i in range(height):
                for j in range(width):
                    reference_val = reference_data[i, j]  # REF raster value
                    rg_val = rg_data[i, j]  # BAD raster value

                    if reference_val in class_mapping and rg_val in class_mapping:
                        ref_class = class_mapping[reference_val]
                        rg_class = class_mapping[rg_val]

                        # Fixed Confusion Matrix Assignment
                        if rg_class == 'Burned' and ref_class == 'Burned':
                            conf_matrix[0, 0] += 1  # True Positive (TP)
                        elif rg_class == 'Burned' and ref_class == 'Unburned':
                            conf_matrix[1, 0] += 1  # False Negative (FN) 
                        elif rg_class == 'Unburned' and ref_class == 'Burned':
                            conf_matrix[0, 1] += 1  # False Positive (FP) 
                        elif rg_class == 'Unburned' and ref_class == 'Unburned':
                            conf_matrix[1, 1] += 1  # True Negative (TN)
            self.update_progress(100)
            self.hide_progress_bar()
            end=time.process_time()
            print("Process end")
            print('Computational time RGValidation [s]: ',(end - start),"start=", start,"end=",end) 
            print('\n') 
            self.window = QtWidgets.QDialog()
            self.ui = Ui_Message()
            self.ui.setupUi(self.window)
            self.window.show()
            print("\nConfusion Matrix:")
            print(conf_matrix)

            
            self.dlg.tableWidgetConfusionMatrixRG.setRowCount(2)
            self.dlg.tableWidgetConfusionMatrixRG.setColumnCount(2)

            for row in range(2):
                for col in range(2):
                    self.dlg.tableWidgetConfusionMatrixRG.setItem(row, col, QTableWidgetItem(str(conf_matrix[row][col])))

            # Extract Matrix Values 
            TP = conf_matrix[0, 0]  # Burned (BAD), Burned (REF) - True Positive
            FP = conf_matrix[1, 0]  # Burned (BAD), Unburned (REF) - False Negative 
            FN = conf_matrix[0, 1]  # Unburned (BAD), Burned (REF) - False Positive 
            TN = conf_matrix[1, 1]  # Unburned (BAD), Unburned (REF) - True Negative

            # Compute Validation Metrics
            CE = (FP / (TP + FP)*100) if (TP + FP) != 0 else 0  # Commission Error
            OE = (FN / (TP + FN)*100) if (TP + FN) != 0 else 0  # Omission Error
            DC = ((2 * TP) / ((2 * TP) + FP + FN)*100) if ((2 * TP) + FP + FN) != 0 else 0  # Dice Coefficient
            bias = ((FP + FN) / (TP + TN)*100) if (TP + TN) != 0 else 0  # Bias
            relative_bias = ((FP - FN) / (TP + TN)*100) if (TP + TN) != 0 else 0  # Relative Bias
            OA = ((TP + TN) / (TP + FP + FN + TN)*100) if (TP + FP + FN + TN) != 0 else 0  # Overall Accuracy

            # Display Metrics
            self.dlg.textEditMetricsRG.setPlainText(f"""
            Commission Error (CE): {CE:.2f}%
            Omission Error (OE): {OE:.2f}%
            Dice Coefficient (DC): {DC:.2f}%
            Bias: {bias:.4f}
            Relative Bias: {relative_bias:.4f}
            Overall Accuracy (OA): {OA:.2f}%
            """)

        except Exception as e:
            QMessageBox.critical(self.dlg, "Error", f"Validation failed: {e}")

    # Function to create the agreement map
    def create_agreement_map(self, rg_data, reference_data):
        height, width = rg_data.shape
        agreement_map = np.full((height, width), np.nan)

        # Iterate through the data arrays to assign values to the agreement map
        for i in range(height):
            for j in range(width):
                reference_val = reference_data[i, j]
                rg_val = rg_data[i, j]

                if reference_val == 1 and rg_val == 1:
                    agreement_map[i, j] = 1  # TP
                elif reference_val == 0 and rg_val == 1:
                    agreement_map[i, j] = 2  # FP
                elif reference_val == 1 and rg_val == 0:
                    agreement_map[i, j] = 3  # FN
                elif reference_val == 0 and rg_val == 0:
                    agreement_map[i, j] = 4  # TN

        return agreement_map

    # Function to generate the agreement map and save it
    def generateAgreementMap(self):
        self.show_progress_bar("Computing agreement_map")
        self.update_progress(5)
        rg_raster_path = self.dlg.lineEditRGFile.text()
        reference_raster_path = self.dlg.lineEditReferenceFile.text()

        if not os.path.exists(rg_raster_path) or not os.path.exists(reference_raster_path):
            QMessageBox.warning(self.dlg, "Missing Input", "Please select both RG and Reference raster files.")
            return

        try:
            rg_raster_ds = gdal.Open(rg_raster_path)
            reference_raster_ds = gdal.Open(reference_raster_path)

            if not rg_raster_ds or not reference_raster_ds:
                QMessageBox.critical(self.dlg, "Error", "Failed to load raster files.")
                return

            width = rg_raster_ds.RasterXSize
            height = rg_raster_ds.RasterYSize

            rg_band = rg_raster_ds.GetRasterBand(1)

            reference_band = reference_raster_ds.GetRasterBand(1)

            rg_data = rg_band.ReadAsArray(0, 0, width, height)
            Mask = np.isnan(rg_data)
            rg_data[Mask] = 999
            rg_data = rg_data.astype(int)
            reference_data = reference_band.ReadAsArray(0, 0, width, height).astype(int)
            agreement_map = self.create_agreement_map(rg_data, reference_data)
            save_path, _ = QFileDialog.getSaveFileName(self.dlg, "Save Agreement Map", "", "GeoTIFF (*.tif)")
            if not save_path:
                return  
            # Saving the agreement map as GeoTIFF
            driver = gdal.GetDriverByName("GTiff")
            output_ds = driver.Create(save_path, rg_data.shape[1], rg_data.shape[0], 1, gdal.GDT_Byte)
            output_ds.SetGeoTransform(rg_raster_ds.GetGeoTransform())
            output_ds.SetProjection(rg_raster_ds.GetProjection())

            output_band = output_ds.GetRasterBand(1)
            output_band.WriteArray(agreement_map)
            output_band.SetNoDataValue(np.nan)

            output_ds.FlushCache()
            output_ds = None

            QMessageBox.information(self.dlg, "Agreement Map", f"Agreement Map saved at:\n{save_path}")

            # If the checkbox is checked, load the agreement map into QGIS
            if self.dlg.checkBox.isChecked():
                agreement_layer = QgsRasterLayer(save_path, "Agreement Map")
                if agreement_layer.isValid():
                    # Applying color ramp
                    self.applyColorRamp(agreement_layer)
                    QgsProject.instance().addMapLayer(agreement_layer)
                else:
                    QMessageBox.warning(self.dlg, "Error", "Failed to load the Agreement Map in QGIS.")

        except Exception as e:
            QMessageBox.critical(self.dlg, "Error", f"Failed to generate Agreement Map: {e}")
    def applyColorRamp(self, raster_layer):
        provider = raster_layer.dataProvider()
        shader = QgsRasterShader()
        color_ramp = QgsColorRampShader()
        color_ramp.setColorRampType(QgsColorRampShader.Interpolated)
        color_ramp_items = [
        QgsColorRampShader.ColorRampItem(0, QColor(255, 255, 255), "No Agreement"),  # White
        QgsColorRampShader.ColorRampItem(1, QColor(255, 0, 0), "Burned Agreement"),    # Red
        QgsColorRampShader.ColorRampItem(2, QColor(0, 0, 255), "Medium Agreement"), # Blue
        QgsColorRampShader.ColorRampItem(3, QColor(255, 255, 0), "High Agreement"), # Yellow
        QgsColorRampShader.ColorRampItem(4, QColor(0, 255, 0), "Unburned Agreement")    # Green
        
        ]
        color_ramp.setColorRampItemList(color_ramp_items)
        shader.setRasterShaderFunction(color_ramp)
        renderer = QgsSingleBandPseudoColorRenderer(provider, 1, shader)
        raster_layer.setRenderer(renderer)
        raster_layer.triggerRepaint()
        self.update_progress(100)
        self.hide_progress_bar()

    #exporting the validation
    def exportRGReport(self):
        conf_matrix = [
            [self.dlg.tableWidgetConfusionMatrixRG.item(0, 0).text(), self.dlg.tableWidgetConfusionMatrixRG.item(0, 1).text()],
            [self.dlg.tableWidgetConfusionMatrixRG.item(1, 0).text(), self.dlg.tableWidgetConfusionMatrixRG.item(1, 1).text()]
        ]
        metrics_text = self.dlg.textEditMetricsRG.toPlainText()
        html_content = f"""
        <html>
        <head>
            <title>RG Validation Report</title>
            <style>
                body {{ font-family: Arial, sans-serif; }}
                table {{ width: 50%; border-collapse: collapse; margin: 20px 0; }}
                th, td {{ border: 1px solid black; padding: 8px; text-align: center; }}
                th {{ background-color: #f2f2f2; }}
            </style>
        </head>
        <body>
            <h2>🔥RG Validation Report</h2>
            
            <h3>Confusion Matrix</h3>
            <table>
                <tr>
                    <th></th>
                    <th>Burned(REF)</th>
                    <th>Unburned(REF)</th>
                </tr>
                <tr>
                    <th>Burned(BAD)</th>
                    <td>{conf_matrix[0][0]}</td>
                    <td>{conf_matrix[0][1]}</td>
                </tr>
                <tr>    
                    <th>Unburned(BAD)</th>
                    <td>{conf_matrix[1][0]}</td>
                    <td>{conf_matrix[1][1]}</td>
                </tr>
            </table>

            <h3>Error Metrics</h3>
            <pre>{metrics_text}</pre>
        </body>
        </html>
        """
        file_path, _ = QFileDialog.getSaveFileName(self.dlg, "Save Report", "", "HTML Files (*.html)")
        if file_path:
            with open(file_path, "w", encoding="utf-8") as file:
                file.write(html_content)
           # QMessageBox.information(self.dlg, "Export Successful", "RG Validation Report exported successfully!")

    # Sev_Validation tab
    def browseBADFile(self):
        file_path, _ = QFileDialog.getOpenFileName(self.dlg, "Select BAD Raster File", "", "Raster Files (*.tif *.tiff)")
        if file_path:
            self.dlg.lineEditBADFile.setText(file_path)

    def browseRefFile(self):
        file_path, _ = QFileDialog.getOpenFileName(self.dlg, "Select Ref Raster File", "", "Raster Files (*.tif *.tiff)")
        if file_path:
            self.dlg.lineEditRefFile.setText(file_path)

    def ComputeValidation(self):
        self.show_progress_bar("Computing Features")
        self.update_progress(5)
        start = time.process_time()

        bad_raster_path = self.dlg.lineEditBADFile.text()
        ref_raster_path = self.dlg.lineEditRefFile.text()

        if not os.path.exists(bad_raster_path) or not os.path.exists(ref_raster_path):
            QMessageBox.warning(self.dlg, "Missing Input", "Please select both BAD and Ref raster files.")
            return

        try:
            bad_raster_ds = gdal.Open(bad_raster_path)
            ref_raster_ds = gdal.Open(ref_raster_path)

            if not bad_raster_ds or not ref_raster_ds:
                QMessageBox.critical(self.dlg, "Error", "Failed to load raster files.")
                return

            width = bad_raster_ds.RasterXSize
            height = bad_raster_ds.RasterYSize

            bad_band = bad_raster_ds.GetRasterBand(1)
            ref_band = ref_raster_ds.GetRasterBand(1)
            bad_data = bad_band.ReadAsArray(0, 0, width, height)
            ref_data = ref_band.ReadAsArray(0, 0, width, height)

            bad_classification = {
                0: 'Unburned', 1: 'Enhanced Regrowth High', 2: 'Enhanced Regrowth Low',
                3: 'Unburned', 4: 'Low Severity', 5: 'Low Severity',
                6: 'High Severity', 7: 'High Severity', 99: 'Masked'
            }

            ref_classification = {
                1: 'High Severity', 2: 'High Severity', 3: 'High Severity',
                4: 'Medium Severity', 5: 'Low Severity', 6: 'Unburned',
                7: 'Masked', 8: 'Low Severity'
            }

            bad_index = {'Unburned': 0, 'Low Severity': 1, 'High Severity': 2, 'Masked': 3}
            ref_index = {'Unburned': 0, 'Low Severity': 1, 'High Severity': 2, 'Masked': 3}

            conf_matrix = [[0] * 4 for _ in range(4)]

            for i in range(height):
                for j in range(width):
                    bad_val = bad_data[i][j]
                    ref_val = ref_data[i][j]
                    bad_class = bad_classification.get(bad_val, 'Unknown')
                    ref_class = ref_classification.get(ref_val, 'Unknown')
                    if bad_class in bad_index and ref_class in ref_index:
                        conf_matrix[bad_index[bad_class]][ref_index[ref_class]] += 1

            self.dlg.tableWidgetConfusionMatrix.setRowCount(4)
            self.dlg.tableWidgetConfusionMatrix.setColumnCount(4)
            for row in range(4):
                for col in range(4):
                    self.dlg.tableWidgetConfusionMatrix.setItem(row, col, QTableWidgetItem(str(conf_matrix[row][col])))

            metrics_output = ""
            for idx, class_name in enumerate(['Unburned', 'Low Severity', 'High Severity', 'Masked']):
                row_sum = sum(conf_matrix[idx])
                col_sum = sum(conf_matrix[r][idx] for r in range(4))
                correct = conf_matrix[idx][idx]
                false_positive = row_sum - correct
                false_negative = col_sum - correct

                CE = (false_positive / row_sum * 100) if row_sum != 0 else 0
                OE = (false_negative / col_sum * 100) if col_sum != 0 else 0
                DC = (2 * correct / (2 * correct + false_positive + false_negative) * 100) if (2 * correct + false_positive + false_negative) != 0 else 0
                bias = false_positive - false_negative
                relative_bias = (bias / col_sum) if col_sum != 0 else 0

                metrics_output += f"""
                Class: {class_name}
                -------------------------
                Commission Error (CE): {CE:.2f}%
                Omission Error (OE): {OE:.2f}%
                Dice Coefficient (DC): {DC:.2f}%
                Relative Bias: {relative_bias:.4f}\n"""

            self.dlg.textEditMetrics.setPlainText(metrics_output)

        except Exception as e:
            QMessageBox.critical(self.dlg, "Error", f"Validation failed: {e}")

        self.update_progress(100)
        self.hide_progress_bar()
        end = time.process_time()
        print("Process end")
        print('Computational time Sev_Validation [s]: ',(end - start),"start=", start,"end=",end) 
        print('\n') 
        self.window = QtWidgets.QDialog()
        self.ui = Ui_Message()
        self.ui.setupUi(self.window)
        self.window.show()
    def export_sev_validation_report(self):

        # Prompt user to choose a file save location
        file_path, _ = QFileDialog.getSaveFileName(self.dlg, "Save Report", "", "HTML Files (*.html)")
        if not file_path:
            return

        # Get confusion matrix and metrics from the UI
        matrix_html = "<table border='1' cellpadding='4' cellspacing='0'>"
        matrix_html += "<tr><th>BAD↓ / REF→</th><th>Unburned</th><th>Low Severity</th><th>High Severity</th><th>Masked</th></tr>"

        row_labels = ['Unburned', 'Low Severity', 'High Severity', 'Masked']
        for row in range(4):
            matrix_html += f"<tr><td><b>{row_labels[row]}</b></td>"
            for col in range(4):
                item = self.dlg.tableWidgetConfusionMatrix.item(row, col)
                val = item.text() if item else "0"
                matrix_html += f"<td>{val}</td>"
            matrix_html += "</tr>"
        matrix_html += "</table>"

        metrics_text = self.dlg.textEditMetrics.toPlainText().replace('\n', '<br>')

        # Exporting the validation results
        html_content = f"""
        <html>
        <head><title>Burn Severity Validation Report</title></head>
        <body>
            <h1>🔥 Burn Severity Validation Report</h1>
            <h2>Confusion Matrix</h2>
            {matrix_html}
            <br><h2>Error Metrics</h2>
            <p>{metrics_text}</p>
        </body>
        </html>
        """

        try:
            with open(file_path, 'w', encoding='utf-8') as f:
                f.write(html_content)
            QMessageBox.information(self.dlg, "Export Successful", f"Validation report exported to:\n{file_path}")
        except Exception as e:
            QMessageBox.critical(self.dlg, "Export Failed", f"Failed to save report: {e}")


###################################################################################################
###################################################################################################
###################################################################################################

    def run(self):
        """Run method that performs all the real work"""
        
        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = BADDialog()

            self.dlg.progressBar.setVisible(False)  
            self.dlg.progressBar.setValue(0)
            self.dlg.pre_fire_path = None
            self.dlg.post_fire_path = None
            self.dlg.ChoicheMosaicking_pre=None
            self.dlg.ChoicheMosaicking_post=None
            self.MD_path=None
            self.Grow_file=None
            self.Seed_file=None
            self.dlg.button_box.button(QtWidgets.QDialogButtonBox.Ok).setEnabled(False)

            # Input Sentinel
            link_4326 = f'<a href="https://epsg.io/4326">EPSG:4326</a>'
            self.dlg.label_CRS.setText(link_4326)
            self.dlg.pushButton_FI_search_pre.clicked.connect(self.search_sentinel_pre)
            self.dlg.pushButton_FI_search_post.clicked.connect(self.search_sentinel_post)
            self.dlg.pushButton_FI_reset.clicked.connect(self.reset_sentinel_fields)
            self.dlg.lineEdit_AOI.setVisible(False)
            self.dlg.checkBox_Coord_editing.stateChanged.connect(
                lambda state: [
                    self.dlg.lineEdit_North.setReadOnly(not self.dlg.checkBox_Coord_editing.isChecked()),
                    self.dlg.lineEdit_South.setReadOnly(not self.dlg.checkBox_Coord_editing.isChecked()),
                    self.dlg.lineEdit_East.setReadOnly(not self.dlg.checkBox_Coord_editing.isChecked()),
                    self.dlg.lineEdit_West.setReadOnly(not self.dlg.checkBox_Coord_editing.isChecked())
                ]
            )
            self.dlg.toolButton_AOI_path.clicked.connect(lambda: self.browse_vectorfile(self.dlg.comboBox_AOI_layer, self.dlg.lineEdit_AOI))
            self.dlg.toolButton_AOI_path.clicked.connect(lambda:self.dlg.checkBox_Coord_editing.setChecked(False))
            self.dlg.comboBox_AOI_layer.activated.connect(lambda:self.dlg.checkBox_Coord_editing.setChecked(False))
            self.dlg.lineEdit_AOI.textChanged.connect(self.get_BBOX) 
            self.dlg.comboBox_AOI_layer.currentTextChanged.connect(self.get_BBOX)
            
            self.dlg.dateEdit_Start_pre.dateChanged.connect(lambda: self.update_calendar(self.dlg.dateEdit_Start_pre, self.dlg.dateEdit_End_pre))
            self.dlg.dateEdit_End_pre.dateChanged.connect(lambda: self.update_calendar(self.dlg.dateEdit_Start_pre, self.dlg.dateEdit_End_pre))
            self.dlg.dateEdit_End_pre.calendarWidget().currentPageChanged.connect(lambda y, m: self.update_calendar(self.dlg.dateEdit_Start_pre, self.dlg.dateEdit_End_pre))
            self.dlg.dateEdit_Start_post.dateChanged.connect(lambda: self.update_calendar(self.dlg.dateEdit_Start_post, self.dlg.dateEdit_End_post))
            self.dlg.dateEdit_End_post.dateChanged.connect(lambda: self.update_calendar(self.dlg.dateEdit_Start_post, self.dlg.dateEdit_End_post))
            self.dlg.dateEdit_End_post.calendarWidget().currentPageChanged.connect(lambda y, m: self.update_calendar(self.dlg.dateEdit_Start_post, self.dlg.dateEdit_End_post))

            self.dlg.pushButton_FI_download_pre.clicked.connect(self.download_sentinel_pre)
            self.dlg.pushButton_FI_download_post.clicked.connect(self.download_sentinel_post)
            self.dlg.pushButton_FI_download_pre.setEnabled(False)
            self.dlg.pushButton_FI_download_post.setEnabled(False)
            self.dlg.Preview_FI_pre.setEnabled(False)
            self.dlg.Preview_FI_post.setEnabled(False)
            self.dlg.Preview_FI_pre_mos.setEnabled(False)
            self.dlg.Preview_FI_post_mos.setEnabled(False)

            self.dlg.toolButton_FI_result_pre.clicked.connect(lambda:self.select_output_file(self.dlg.lineEdit_FI_result_pre))
            self.dlg.toolButton_FI_result_post.clicked.connect(lambda:self.select_output_file(self.dlg.lineEdit_FI_result_post))
            

            # Mask
            self.populate_mask_classes()
            self.dlg.btnBrowseOutputPreFire.clicked.connect(lambda:self.select_output_file(self.dlg.lineEdit_OutputPreFire))
            self.dlg.btnBrowseOutputPostFire.clicked.connect(lambda:self.select_output_file(self.dlg.lineEdit_OutputPostFire))
            self.dlg.btnRunMasking_pre.clicked.connect(self.run_masking_pre)
            self.dlg.btnRunMasking_post.clicked.connect(self.run_masking_post)
            self.dlg.btnReset.clicked.connect(self.reset_fields)
            
            # Input tab
            self.dlg.lineEdit_Pre.setVisible(False)
            self.dlg.lineEdit_Post.setVisible(False)
            self.dlg.comboBox_prefire.activated.connect(lambda:self.handle_combobox_click_pre(self.dlg.comboBox_prefire))
            self.dlg.comboBox_postfire.activated.connect(lambda:self.handle_combobox_click_post(self.dlg.comboBox_postfire))
            self.dlg.toolButton_browse_prefire.clicked.connect(lambda:self.browse_rasterfile_pre(self.dlg.comboBox_prefire, self.dlg.lineEdit_Pre))
            self.dlg.toolButton_browse_postfire.clicked.connect(lambda:self.browse_rasterfile_post(self.dlg.comboBox_postfire, self.dlg.lineEdit_Post))
            self.dlg.checkBox_input_B13.stateChanged.connect(lambda state: self.dlg.tab_Masking.setEnabled(self.dlg.checkBox_input_B13.isChecked()))
            self.dlg.spinBox_input_B13.valueChanged.connect(self.update_text)
            listcheckbox=[self.dlg.checkBox_input_B1,self.dlg.checkBox_input_B2,self.dlg.checkBox_input_B3,self.dlg.checkBox_input_B4,self.dlg.checkBox_input_B5,self.dlg.checkBox_input_B6,self.dlg.checkBox_input_B7,self.dlg.checkBox_input_B8,self.dlg.checkBox_input_B8A,self.dlg.checkBox_input_B9,self.dlg.checkBox_input_B11,self.dlg.checkBox_input_B12,self.dlg.checkBox_input_B13]
            listspinbox=[self.dlg.spinBox_input_B1,self.dlg.spinBox_input_B2,self.dlg.spinBox_input_B3,self.dlg.spinBox_input_B4,self.dlg.spinBox_input_B5,self.dlg.spinBox_input_B6,self.dlg.spinBox_input_B7,self.dlg.spinBox_input_B8,self.dlg.spinBox_input_B8A,self.dlg.spinBox_input_B9,self.dlg.spinBox_input_B11,self.dlg.spinBox_input_B12,self.dlg.spinBox_input_B13]
            for i in range(len(listcheckbox)):
                cb = listcheckbox[i]
                sb = listspinbox[i]

                listcheckbox[i].stateChanged.connect(lambda state, checkbox_widget=cb, spinbox_widget=sb: self.deactivatespinnbox(checkbox_widget, spinbox_widget)
            )
            # save NBand for OWA use in parameters window
            self.dlg.Nband=None
            #self.dlg.pushButton_Error.clicked.connect(self.test)
            self.dlg.toolButton_Feature.clicked.connect(lambda:self.select_output_file(self.dlg.lineEdit_Feature))
            self.dlg.toolButton_MD.clicked.connect(lambda:self.select_output_file(self.dlg.lineEdit_MD))
            
            self.dlg.pushButton_MD_run.setEnabled(False)
            self.dlg.pushButton_Feature_run.clicked.connect(self.ComputeFeature)
            self.dlg.pushButton_MD_run.clicked.connect(self.ComputeMD)
            
            self.dlg.lineEdit_OWA.setVisible(False)
            self.dlg.lineEdit_OWA_2.setVisible(False)
            self.dlg.toolButton_OWA_AND.clicked.connect(lambda:self.select_output_file(self.dlg.lineEdit_OWA_AND))
            self.dlg.toolButton_OWA_almostAND.clicked.connect(lambda:self.select_output_file(self.dlg.lineEdit_OWA_almostAND))
            self.dlg.toolButton_OWA_AVERAGE.clicked.connect(lambda:self.select_output_file(self.dlg.lineEdit_OWA_AVERAGE))
            self.dlg.toolButton_OWA_almostOR.clicked.connect(lambda:self.select_output_file(self.dlg.lineEdit_OWA_almostOR))
            self.dlg.toolButton_OWA_OR.clicked.connect(lambda:self.select_output_file(self.dlg.lineEdit_OWA_OR))
            self.dlg.toolButton_OWA_UserChoice1.clicked.connect(lambda:self.select_output_file(self.dlg.lineEdit_OWA_UserChoice1))
            self.dlg.toolButton_OWA_UserChoice2.clicked.connect(lambda:self.select_output_file(self.dlg.lineEdit_OWA_UserChoice2))
            self.dlg.toolButton_InputOWA.clicked.connect(lambda:self.browse_rasterfile_OWA(self.dlg.comboBox_InputOWA, self.dlg.lineEdit_OWA_2))
            self.dlg.comboBox_InputOWA.activated.connect(lambda:self.handle_combobox_click_OWA(self.dlg.comboBox_InputOWA))
            self.dlg.pushButton_OWA_run.clicked.connect(self.ComputeOWA)          
            
            # RG tab
            self.dlg.lineEdit_RG_seed.setVisible(False)
            self.dlg.lineEdit_RG_grow.setVisible(False)
            self.dlg.toolButton_browse_RG_seed.clicked.connect(lambda:self.browse_rasterfile(self.dlg.comboBox_RG_seed, self.dlg.lineEdit_RG_seed))
            self.dlg.toolButton_browse_RG_grow.clicked.connect(lambda:self.browse_rasterfile(self.dlg.comboBox_RG_grow, self.dlg.lineEdit_RG_grow))
            self.dlg.toolButton_RG_result.clicked.connect(lambda:self.select_output_file(self.dlg.lineEdit_RG_result))
            self.dlg.toolButton_Severity.clicked.connect(lambda:self.select_output_file(self.dlg.lineEdit_Severity))
            self.dlg.toolButton_CombinedSeverity.clicked.connect(lambda:self.select_output_file(self.dlg.lineEdit_CombinedSeverity))
            self.dlg.comboBox_RG_seed.activated.connect(lambda:self.handle_combobox_click_seed(self.dlg.comboBox_RG_seed))
            self.dlg.comboBox_RG_grow.activated.connect(lambda:self.handle_combobox_click_grow(self.dlg.comboBox_RG_grow))
            self.dlg.pushButton_RG_run.clicked.connect(self.ComputeRG)
            
            self.dlg.pushButton_Severity_run.clicked.connect(self.ComputeSeverity)
            self.dlg.pushButton_RGSeverity_run.clicked.connect(self.ComputeRGSeverity)
            self.dlg.buttonBrowseRGFile.clicked.connect(self.browseRGFile)
            self.dlg.buttonBrowseReferenceFile.clicked.connect(self.browseReferenceFile)
            self.dlg.buttonRunRGValidation.clicked.connect(self.ComputeRGValidation)
            self.dlg.GenerateAgreementMap.clicked.connect(self.generateAgreementMap)
            self.dlg.buttonExportRGReport.clicked.connect(self.exportRGReport)


            self.dlg.buttonBrowseBADFile.clicked.connect(self.browseBADFile)
            self.dlg.buttonBrowseRefFile.clicked.connect(self.browseRefFile)
            self.dlg.buttonRunValidation.clicked.connect(self.ComputeValidation)
            self.dlg.buttonExportSEVReport.clicked.connect(self.export_sev_validation_report)

            # Reset
            self.dlg.pushButton_input_reset.clicked.connect(self.reset_input_tab)
            self.dlg.pushButton_Features.clicked.connect(self.reset_Features)
            self.dlg.pushButton_OWA_reset.clicked.connect(self.reset_OWA_tab)
            self.dlg.pushButton_RG_reset.clicked.connect(self.reset_RG_tab)
            self.dlg.pushButton_Severity_reset.clicked.connect(self.reset_Severity_tab)

            self.dlg.button_box.button(QtWidgets.QDialogButtonBox.Ok).clicked.connect(self.handle_Run_ALL)

        # update comboBox
        self.update_comboBox()

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        print("result",result)

        if result == self.dlg.Rejected:
            self.reset_variables_buttons()
            self.reset_sentinel_fields()
            self.reset_fields()
            self.reset_input_tab()
            self.reset_Features()
            self.reset_OWA_tab()
            self.reset_RG_tab()
            self.reset_Severity_tab()
            self.update_comboBox()

            
        

        




           