# -*- coding: utf-8 -*-
"""
/***************************************************************************
 BAD
                                 A QGIS plugin
 BAD_Burned Area Detector
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-01-24
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Thomas Martinoli
        email                : th.martinoli96@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os
import os.path
import time
import numpy as np
from PyQt5 import QtWidgets, QtCore
from PyQt5.QtCore import Qt
from PyQt5.QtGui import QIcon, QColor, QImage, QPixmap
from PyQt5.QtWidgets import (
    QAction, QFileDialog, QMessageBox, QGraphicsScene,
    QGraphicsPixmapItem, QTableWidgetItem
)

from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt import uic
from qgis.core import (
    QgsRasterLayer, QgsProject, QgsRasterBlock, QgsRasterDataProvider,
    QgsRasterPipe, QgsRasterFileWriter, QgsRasterShader,
    QgsColorRampShader, QgsSingleBandPseudoColorRenderer,
    QgsCoordinateReferenceSystem
)
from qgis.utils import iface
from osgeo import gdal
from .resources import *
from .BAD_dialog import BADDialog
from .DoMagic import *
from .Message import Ui_Message


class BAD:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'BAD_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Burned Area Detector')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('BAD', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/BAD/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Burned Area Detector'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Burned Area Detector'),
                action)
            self.iface.removeToolBarIcon(action)
    

    def show_progress_bar(self, message="Processing..."):
        self.dlg.progressBar.setVisible(True)
        self.dlg.progressBar.setValue(0)
        self.dlg.progressBar.setFormat(message + " %p%")

    def update_progress(self, percent):
        self.dlg.progressBar.setValue(percent)
        QtWidgets.QApplication.processEvents() 

    def hide_progress_bar(self):
        self.dlg.progressBar.setVisible(False)
        self.dlg.progressBar.setValue(0)



###################################################################################################
###################################################################################################
###################################################################################################

#  This part of the script contains the code about the restore buttons that are      
#  present inside the plug-in.                                            
#  In this way the user is able to restore the default value and         
#  the state of each spinbox, checkbox, radiusbox in the related page.  
# Pre-Processing tab:
    def select_pre_fire_raster(self):
        file_path, _ = QFileDialog.getOpenFileName(self.dlg, "Select Pre-fire Raster", "", "GeoTIFF Files (*.tif)")
        if file_path:
            self.pre_fire_path = file_path
            self.dlg.lineEditPreFire.setText(file_path)
    def select_post_fire_raster(self):
        file_path, _ = QFileDialog.getOpenFileName(self.dlg, "Select Post-fire Raster", "", "GeoTIFF Files (*.tif)")
        if file_path:
            self.post_fire_path = file_path
            self.dlg.lineEditPostFire.setText(file_path)
    def select_output_pre_fire(self):
        file_path, _ = QFileDialog.getSaveFileName(self.dlg, "Select Output File for Pre-fire", "", "GeoTIFF Files (*.tif)")
        if file_path:
            self.output_pre_fire_path = file_path
            self.dlg.lineEditOutputPreFire.setText(file_path)

    def select_output_post_fire(self):
        file_path, _ = QFileDialog.getSaveFileName(self.dlg, "Select Output File for Post-fire", "", "GeoTIFF Files (*.tif)")
        if file_path:
            self.output_post_fire_path = file_path
            self.dlg.lineEditOutputPostFire.setText(file_path)
    def populate_mask_classes(self):
        """Populate the class selection lists for pre-fire and post-fire."""
        classes = [
            "0 - No Data",
            "1 - Saturated / Defective Pixel",
            "2 - Topographic casted Shadows",
            "3 - Cloud Shadows",
            "4 - Vegetation",
            "5 - Not Vegetated",
            "6 - Water",
            "7 - Unclassified",
            "8 - Cloud Medium Probability",
            "9 - Cloud High Probability",
            "10 - Thin Cirrus",
            "11 - Snow / Ice"
        ]

        for cls in classes:
            item = QtWidgets.QListWidgetItem(cls)
            item.setCheckState(QtCore.Qt.Unchecked)
            self.dlg.listWidgetClassesPreFire.addItem(item)

        for cls in classes:
            item = QtWidgets.QListWidgetItem(cls)
            item.setCheckState(QtCore.Qt.Unchecked)
            self.dlg.listWidgetClassesPostFire.addItem(item)

    def run_masking(self):
        if not self.pre_fire_path or not self.post_fire_path:
            QMessageBox.warning(self.dlg, "Missing Files", "Please select both pre-fire and post-fire rasters.")
            return

        pre_fire_classes = self.get_selected_classes(self.dlg.listWidgetClassesPreFire)
        post_fire_classes = self.get_selected_classes(self.dlg.listWidgetClassesPostFire)

        if not pre_fire_classes or not post_fire_classes:
            QMessageBox.warning(self.dlg, "No Classes Selected", "Please select at least one class to mask.")
            return

        try:
            self.mask_raster(self.pre_fire_path, 9, pre_fire_classes, self.output_pre_fire_path)
            self.mask_raster(self.post_fire_path, 9, post_fire_classes, self.output_post_fire_path)

            if self.dlg.checkBoxDisplayInQGIS.isChecked():
                self.display_in_qgis(self.output_pre_fire_path)
                self.display_in_qgis(self.output_post_fire_path)

        except Exception as e:
            QMessageBox.critical(self.dlg, "Error", f"Masking failed: {e}")

    def get_selected_classes(self, list_widget):
        selected_classes = []
        for index in range(list_widget.count()):
            item = list_widget.item(index)
            if item.checkState() == QtCore.Qt.Checked:
                class_index = int(item.text().split(" - ")[0])
                selected_classes.append(class_index)
        return selected_classes

    def mask_raster(self, input_path, scl_band_index, mask_classes, output_path):
        self.show_progress_bar("Computing Pre-Processing")
        self.update_progress(5)
        start = time.process_time()
        raster_layer = QgsRasterLayer(input_path, "InputRaster")
        if not raster_layer.isValid():
            raise ValueError(f"Failed to load raster: {input_path}")

        dataset = gdal.Open(input_path)
        if dataset is None:
            raise ValueError("Failed to open raster with GDAL.")

        scl_band = dataset.GetRasterBand(scl_band_index + 1)
        scl_array = scl_band.ReadAsArray()
        mask = np.isin(scl_array, mask_classes)

        masked_bands = []
        for band_index in range(1, dataset.RasterCount + 1):
            if band_index - 1 == scl_band_index:
                continue
            band = dataset.GetRasterBand(band_index).ReadAsArray()
            band = band.astype(np.float32)
            band[mask] = np.nan
            masked_bands.append(band)

        self.save_raster(output_path, dataset.RasterXSize, dataset.RasterYSize, raster_layer.crs().authid(), dataset.GetGeoTransform(), masked_bands)
        self.update_progress(100)
        self.hide_progress_bar()
        end = time.process_time()
        print("Process end")
        print('Computational time Pre-Processing [s]: ',(end - start),"start=", start,"end=",end) 
        print('\n') 
        self.window = QtWidgets.QDialog()
        self.ui = Ui_Message()
        self.ui.setupUi(self.window)
        self.window.show()
    def save_raster(self, output_path, cols, rows, crs, transform, bands):
        driver = gdal.GetDriverByName("GTiff")
        dataset = driver.Create(output_path, cols, rows, len(bands), gdal.GDT_Float32)
        dataset.SetGeoTransform(transform)
        dataset.SetProjection(QgsCoordinateReferenceSystem(crs).toWkt())

        for i, band_data in enumerate(bands, start=1):
            dataset.GetRasterBand(i).WriteArray(band_data)
            dataset.GetRasterBand(i).SetNoDataValue(np.nan)

        dataset.FlushCache()
        del dataset

    def display_in_qgis(self, raster_path):
        layer = QgsRasterLayer(raster_path, os.path.basename(raster_path))
        if layer.isValid():
            QgsProject.instance().addMapLayer(layer)

    def reset_fields(self):
        self.pre_fire_path = None
        self.post_fire_path = None
        self.output_pre_fire_path = None
        self.output_post_fire_path = None

        self.dlg.lineEditPreFire.clear()
        self.dlg.lineEditPostFire.clear()
        self.dlg.lineEditOutputPreFire.clear()
        self.dlg.lineEditOutputPostFire.clear()

        for index in range(self.dlg.listWidgetClassesPreFire.count()):
            self.dlg.listWidgetClassesPreFire.item(index).setCheckState(QtCore.Qt.Unchecked)

        for index in range(self.dlg.listWidgetClassesPostFire.count()):
            self.dlg.listWidgetClassesPostFire.item(index).setCheckState(QtCore.Qt.Unchecked)

        self.dlg.checkBoxDisplayInQGIS.setChecked(False)
    # INPUT TAB #
    def reset_input_tab(self):

        # Band reset value
        Bands = [
        self.dlg.spinBox_input_B1,
        self.dlg.spinBox_input_B2,
        self.dlg.spinBox_input_B3,
        self.dlg.spinBox_input_B4,
        self.dlg.spinBox_input_B5,
        self.dlg.spinBox_input_B6,
        self.dlg.spinBox_input_B7,
        self.dlg.spinBox_input_B8,
        self.dlg.spinBox_input_B8A,
        self.dlg.spinBox_input_B9,
        self.dlg.spinBox_input_B10,
        self.dlg.spinBox_input_B11,
        self.dlg.spinBox_input_B12]

        Nband=1
        for Band in Bands:
            Band.setValue(Nband)
            Nband=Nband+1

        # Band reset check
        self.dlg.checkBox_input_B1.setCheckState(False)
        self.dlg.checkBox_input_B2.setCheckState(False)
        self.dlg.checkBox_input_B3.setCheckState(False)
        self.dlg.checkBox_input_B4.setCheckState(False)
        self.dlg.checkBox_input_B5.setCheckState(False)
        self.dlg.checkBox_input_B6.setCheckState(True)
        self.dlg.checkBox_input_B7.setCheckState(True)
        self.dlg.checkBox_input_B8.setCheckState(True)
        self.dlg.checkBox_input_B8A.setCheckState(False)
        self.dlg.checkBox_input_B9.setCheckState(False)
        self.dlg.checkBox_input_B10.setCheckState(False)
        self.dlg.checkBox_input_B11.setCheckState(False)
        self.dlg.checkBox_input_B12.setCheckState(True)

        print("restored input tab")   

    # FEATURES TAB default #
    def reset_Features_D_tab(self):
        CheckBoxes = [
        self.dlg.checkBox_FD_postB6,
        self.dlg.checkBox_FD_postB7,
        self.dlg.checkBox_FD_postNIR,
        self.dlg.checkBox_FD_deltaB6,
        self.dlg.checkBox_FD_deltaB7,
        self.dlg.checkBox_FD_deltaNIR,
        self.dlg.checkBox_FD_deltaB12]

        # Reset check
        for CKbox in CheckBoxes:
            CKbox.setCheckState(True)

        # Reset value K
        self.dlg.doubleSpinBox_FD_postB6_K.setValue(-125.89400)
        self.dlg.doubleSpinBox_FD_postB7_K.setValue(-115.77500)
        self.dlg.doubleSpinBox_FD_postNIR_K.setValue(-123.65800)
        self.dlg.doubleSpinBox_FD_deltaB6_K.setValue(-120.29100)
        self.dlg.doubleSpinBox_FD_deltaB7_K.setValue(-93.72060)
        self.dlg.doubleSpinBox_FD_deltaNIR_K.setValue(-87.14430)
        self.dlg.doubleSpinBox_FD_deltaB12_K.setValue(236.98400)
        
        # Reset value x
        self.dlg.doubleSpinBox_FD_postB6_x.setValue(0.11090)
        self.dlg.doubleSpinBox_FD_postB7_x.setValue(0.11659)
        self.dlg.doubleSpinBox_FD_postNIR_x.setValue(0.10986)
        self.dlg.doubleSpinBox_FD_deltaB6_x.setValue(-0.05980)
        self.dlg.doubleSpinBox_FD_deltaB7_x.setValue(-0.07527)
        self.dlg.doubleSpinBox_FD_deltaNIR_x.setValue(-0.08657)
        self.dlg.doubleSpinBox_FD_deltaB12_x.setValue(0.04381)

        print("restored Features D tab")  

    # FEATURES TAB advanced post #    
    def reset_Features_AP_tab(self):

        CheckBoxes = [
        self.dlg.checkBox_FAP_B1,
        self.dlg.checkBox_FAP_B2,
        self.dlg.checkBox_FAP_B3,
        self.dlg.checkBox_FAP_B4,
        self.dlg.checkBox_FAP_B5,
        self.dlg.checkBox_FAP_B8A,
        self.dlg.checkBox_FAP_B9,
        self.dlg.checkBox_FAP_B10,
        self.dlg.checkBox_FAP_B11,
        self.dlg.checkBox_FAP_B12]

        DoubleSpinBoxes_K = [
        self.dlg.doubleSpinBox_FAP_B1_K,
        self.dlg.doubleSpinBox_FAP_B2_K,
        self.dlg.doubleSpinBox_FAP_B3_K,
        self.dlg.doubleSpinBox_FAP_B4_K,
        self.dlg.doubleSpinBox_FAP_B5_K,
        self.dlg.doubleSpinBox_FAP_B8A_K,
        self.dlg.doubleSpinBox_FAP_B9_K,
        self.dlg.doubleSpinBox_FAP_B10_K,
        self.dlg.doubleSpinBox_FAP_B11_K,
        self.dlg.doubleSpinBox_FAP_B12_K]
        
        DoubleSpinBoxes_x = [
        self.dlg.doubleSpinBox_FAP_B1_x,
        self.dlg.doubleSpinBox_FAP_B2_x,
        self.dlg.doubleSpinBox_FAP_B3_x,
        self.dlg.doubleSpinBox_FAP_B4_x,
        self.dlg.doubleSpinBox_FAP_B5_x,
        self.dlg.doubleSpinBox_FAP_B8A_x,
        self.dlg.doubleSpinBox_FAP_B9_x,
        self.dlg.doubleSpinBox_FAP_B10_x,
        self.dlg.doubleSpinBox_FAP_B11_x,
        self.dlg.doubleSpinBox_FAP_B12_x]

        # Reset value K
        for DSbox in DoubleSpinBoxes_K:
            DSbox.setValue(0)

        # Reset value x
        for DSbox in DoubleSpinBoxes_x:
            DSbox.setValue(0)

        # Reset checkbox
        for CKbox in CheckBoxes:
            CKbox.setCheckState(False)

        print("restored Features AP tab")  
    
    # FEATURES TAB advanced delta # 
    def reset_Features_AD_tab(self):
        
        CheckBoxes = [
        self.dlg.checkBox_FAD_B1,
        self.dlg.checkBox_FAD_B2,
        self.dlg.checkBox_FAD_B3,
        self.dlg.checkBox_FAD_B4,
        self.dlg.checkBox_FAD_B5,
        self.dlg.checkBox_FAD_B8A,
        self.dlg.checkBox_FAD_B9,
        self.dlg.checkBox_FAD_B10,
        self.dlg.checkBox_FAD_B11]

        DoubleSpinBoxes_K = [
        self.dlg.doubleSpinBox_FAD_B1_K,
        self.dlg.doubleSpinBox_FAD_B2_K,
        self.dlg.doubleSpinBox_FAD_B3_K,
        self.dlg.doubleSpinBox_FAD_B4_K,
        self.dlg.doubleSpinBox_FAD_B5_K,
        self.dlg.doubleSpinBox_FAD_B8A_K,
        self.dlg.doubleSpinBox_FAD_B9_K,
        self.dlg.doubleSpinBox_FAD_B10_K,
        self.dlg.doubleSpinBox_FAD_B11_K]
        
        DoubleSpinBoxes_x = [
        self.dlg.doubleSpinBox_FAD_B1_x,
        self.dlg.doubleSpinBox_FAD_B2_x,
        self.dlg.doubleSpinBox_FAD_B3_x,
        self.dlg.doubleSpinBox_FAD_B4_x,
        self.dlg.doubleSpinBox_FAD_B5_x,
        self.dlg.doubleSpinBox_FAD_B8A_x,
        self.dlg.doubleSpinBox_FAD_B9_x,
        self.dlg.doubleSpinBox_FAD_B10_x,
        self.dlg.doubleSpinBox_FAD_B11_x]

        # Reset value K
        for DSbox in DoubleSpinBoxes_K:
            DSbox.setValue(0)

        # Reset value x
        for DSbox in DoubleSpinBoxes_x:
            DSbox.setValue(0)

        # Reset checkbox
        for CKbox in CheckBoxes:
            CKbox.setCheckState(False)

        print("restored Features AD tab")  

    # OWA TAB #
    def reset_OWA_tab(self):

        # OWA reset check
        self.dlg.checkBox_OWA_AND.setCheckState(False)
        self.dlg.checkBox_OWA_almostAND.setCheckState(False)
        self.dlg.checkBox_OWA_AVERAGE.setCheckState(False)
        self.dlg.checkBox_OWA_almostOR.setCheckState(False)
        self.dlg.checkBox_OWA_OR.setCheckState(False)
        
        # OWA reset radiobutton for Seed
        self.dlg.radioButton_OWA_S_AND.setChecked(True)
        self.dlg.radioButton_OWA_S_almostAND.setChecked(False)
        self.dlg.radioButton_OWA_S_AVERAGE.setChecked(False)
        self.dlg.radioButton_OWA_S_almostOR.setChecked(False)
        self.dlg.radioButton_OWA_S_OR.setChecked(False)

        # OWA reset radiobutton for Grow
        self.dlg.radioButton_OWA_G_AND.setChecked(False)
        self.dlg.radioButton_OWA_G_almostAND.setChecked(False)
        self.dlg.radioButton_OWA_G_AVERAGE.setChecked(False)
        self.dlg.radioButton_OWA_G_almostOR.setChecked(False)
        self.dlg.radioButton_OWA_G_OR.setChecked(True)
        
        # OWA reset line edit
        self.dlg.lineEdit_OWA_AND.clear()
        self.dlg.lineEdit_OWA_almostAND.clear()
        self.dlg.lineEdit_OWA_AVERAGE.clear()
        self.dlg.lineEdit_OWA_almostOR.clear()
        self.dlg.lineEdit_OWA_OR.clear()

        # OWA reset check for display results
        self.dlg.checkBox_OWA_display.setCheckState(False)
       
        print("restored OWA tab")  

    # REGION GROWING TAB #
    def reset_RG_tab(self):

        # RG reset threshold value
        threshold_seed = 0.9
        threshold_grow = 0.1
        self.dlg.doubleSpinBox_RG_seed.setValue(threshold_seed)
        self.dlg.doubleSpinBox_RG_grow.setValue(threshold_grow)
        
        # RG reset check for display result
        self.dlg.checkBox_RG_display.setCheckState(False)
        
        # RG reset line edit
        self.dlg.lineEdit_RG_result.clear()
        print("restored RG tab") 

    # SEVERITY TAB #
    def reset_Severity_tab(self):

        # Severity levels reset
        
        self.dlg.doubleSpinBox_Severity_ERH_1.setValue(-0.5)
        self.dlg.doubleSpinBox_Severity_ERH_2.setValue(-0.251)

        self.dlg.doubleSpinBox_Severity_ERL_1.setValue(-0.25)
        self.dlg.doubleSpinBox_Severity_ERL_2.setValue(-0.101)

        self.dlg.doubleSpinBox_Severity_U_1.setValue(-0.1)
        self.dlg.doubleSpinBox_Severity_U_2.setValue(0.099)

        self.dlg.doubleSpinBox_Severity_L_1.setValue(0.1)
        self.dlg.doubleSpinBox_Severity_L_2.setValue(0.269)

        self.dlg.doubleSpinBox_Severity_ML_1.setValue(0.27)
        self.dlg.doubleSpinBox_Severity_ML_2.setValue(0.439)

        self.dlg.doubleSpinBox_Severity_MH_1.setValue(0.44)
        self.dlg.doubleSpinBox_Severity_MH_2.setValue(0.659)

        self.dlg.doubleSpinBox_Severity_H_1.setValue(0.66)
        self.dlg.doubleSpinBox_Severity_H_2.setValue(1.3)

        
        # Severity reset check for display result
        self.dlg.checkBox_Severity.setCheckState(False)
        
        # Severity reset line edit
        self.dlg.lineEdit_Severityt_RG_result.clear()
        print("restored Severity tab")  
 

###################################################################################################     
###################################################################################################
###################################################################################################
# lines of code in order to save output using tool button

    def select_output_file_Feature(self):
        filename_Feature, _filter = QFileDialog.getSaveFileName(self.dlg, "Select output file","",'*.tif')
        self.dlg.lineEdit_Feature.setText(filename_Feature)

    def select_output_file_MD(self):
        filename_MD, _filter = QFileDialog.getSaveFileName(self.dlg, "Select output file","",'*.tif')
        self.dlg.lineEdit_MD.setText(filename_MD)

    def select_output_file_AND(self):
        filename_AND, _filter = QFileDialog.getSaveFileName(self.dlg, "Select output file","",'*.tif')
        self.dlg.lineEdit_OWA_AND.setText(filename_AND)

    def select_output_file_almostAND(self):
        filename_almostAND, _filter = QFileDialog.getSaveFileName(self.dlg, "Select output file","",'*.tif')
        self.dlg.lineEdit_OWA_almostAND.setText(filename_almostAND)
   
    def select_output_file_AVERAGE(self):
        filename_AVERAGE, _filter = QFileDialog.getSaveFileName(self.dlg, "Select output file","",'*.tif')
        self.dlg.lineEdit_OWA_AVERAGE.setText(filename_AVERAGE)
  
    def select_output_file_almostOR(self):
        filename_almostOR, _filter = QFileDialog.getSaveFileName(self.dlg, "Select output file","",'*.tif')
        self.dlg.lineEdit_OWA_almostOR.setText(filename_almostOR)
   
    def select_output_file_OR(self):
        filename_OR, _filter = QFileDialog.getSaveFileName(self.dlg, "Select output file","",'*.tif')
        self.dlg.lineEdit_OWA_OR.setText(filename_OR)

    def select_output_file_RG(self):
        filename_RG, _filter = QFileDialog.getSaveFileName(self.dlg, "Select output file","",'*.tif')
        self.dlg.lineEdit_RG_result.setText(filename_RG)

    def select_output_file_Severity(self):
        filename_Severity, _filter = QFileDialog.getSaveFileName(self.dlg, "Select output file","",'*.tif')
        self.dlg.lineEdit_Severity.setText(filename_Severity)

    def select_output_file_CombinedSeverity(self):
        filename_CombinedSeverity, _filter = QFileDialog.getSaveFileName(self.dlg, "Select output file","",'*.tif')
        self.dlg.lineEdit_CombinedSeverity.setText(filename_CombinedSeverity)
    

###################################################################################################     
###################################################################################################
###################################################################################################
#  This part of the script contains the code about the reading of the input layers,
#  the computation of the features (post and delta)
#  The process is executed when the button "COMPUTE FEATURE" is clicked  

    def ComputeFeature(self):
        
        print("ComputeFeature button clicked, wait until the process end")
        self.show_progress_bar("Computing Features")
        self.update_progress(5)
        start = time.process_time()        
        
        Pre_name= str(self.dlg.comboBox_prefire.currentText())
        Pre_info = QgsProject.instance().mapLayersByName(Pre_name)
        self.Pre_path = Pre_info[0].dataProvider().dataSourceUri()


        Post_name = str(self.dlg.comboBox_postfire.currentText())       
        Post_info = QgsProject.instance().mapLayersByName(Post_name)
        self.Post_path = Post_info[0].dataProvider().dataSourceUri()    

        self.update_progress(10)

        if self.dlg.checkBox_input_B1.isChecked():
            Band1=self.dlg.spinBox_input_B1.value()
        else:
            Band1=np.nan

        if self.dlg.checkBox_input_B2.isChecked():
            Band2=self.dlg.spinBox_input_B2.value()
        else:
            Band2=np.nan

        if self.dlg.checkBox_input_B3.isChecked():
            Band3=self.dlg.spinBox_input_B3.value()
        else:
            Band3=np.nan

        if self.dlg.checkBox_input_B4.isChecked():
            Band4=self.dlg.spinBox_input_B4.value()
        else:
            Band4=np.nan

        if self.dlg.checkBox_input_B5.isChecked():
            Band5=self.dlg.spinBox_input_B5.value()
        else:
            Band5=np.nan

        if self.dlg.checkBox_input_B6.isChecked():
            Band6=self.dlg.spinBox_input_B6.value()
        else:
            Band6=np.nan

        if self.dlg.checkBox_input_B7.isChecked():
            Band7=self.dlg.spinBox_input_B7.value()
        else:
            Band7=np.nan

        if self.dlg.checkBox_input_B8.isChecked():
            Band8=self.dlg.spinBox_input_B8.value()
        else:
            Band8=np.nan

        if self.dlg.checkBox_input_B8A.isChecked():
            Band8A=self.dlg.spinBox_input_B8A.value()
        else:
            Band8A=np.nan

        if self.dlg.checkBox_input_B9.isChecked():
            Band9=self.dlg.spinBox_input_B9.value()
        else:
            Band9=np.nan 

        if self.dlg.checkBox_input_B10.isChecked():
            Band10=self.dlg.spinBox_input_B10.value()
        else:
            Band10=np.nan

        if self.dlg.checkBox_input_B11.isChecked():
            Band11=self.dlg.spinBox_input_B11.value()
        else:
            Band11=np.nan

        if self.dlg.checkBox_input_B12.isChecked():
            Band12=self.dlg.spinBox_input_B12.value()
        else:
            Band12=np.nan

        self.BandsList=[Band1,Band2,Band3,Band4,Band5,Band6,Band7,Band8,Band8A,Band9,Band10,Band11,Band12]
        
        Data=ReadingData(self.Pre_path,self.Post_path)

        self.update_progress(20)


        self.PreMatrix=Data.FirstMatrix
        self.PostMatrix=Data.SecondMatrix
        self.DeltaMatrix=self.PostMatrix-self.PreMatrix
        
        self.GeoTrans=Data.gt
        self.proj=Data.proj
        numBand=Data.Bands


        FinalFeatureList=[]
        NameBandsList=[]
        
        if self.dlg.checkBox_FD_postB6.isChecked():
            layer=self.PostMatrix[Band6-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('postB6')

        if self.dlg.checkBox_FD_postB7.isChecked():
            layer=self.PostMatrix[Band7-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('postB7')

        if self.dlg.checkBox_FD_postNIR.isChecked():
            layer=self.PostMatrix[Band8-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('postB8')

        if self.dlg.checkBox_FD_deltaB6.isChecked():
            layer=self.DeltaMatrix[Band6-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('deltaB6')
            
        if self.dlg.checkBox_FD_deltaB7.isChecked():
            layer=self.DeltaMatrix[Band7-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('deltaB7')

        if self.dlg.checkBox_FD_deltaNIR.isChecked():
            layer=self.DeltaMatrix[Band8-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('deltaB8')

        if self.dlg.checkBox_FD_deltaB12.isChecked():
            layer=self.DeltaMatrix[Band12-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('deltaB12')

        # FEATURES ADVANCED POST
        if self.dlg.checkBox_FAP_B1.isChecked():
            layer=self.PostMatrix[Band1-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('postB1')

        if self.dlg.checkBox_FAP_B2.isChecked():
            layer=self.PostMatrix[Band2-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('postB2')

        if self.dlg.checkBox_FAP_B3.isChecked():
            layer=self.PostMatrix[Band3-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('postB3')

        if self.dlg.checkBox_FAP_B4.isChecked():
            layer=self.PostMatrix[Band4-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('postB4')

        if self.dlg.checkBox_FAP_B5.isChecked():
            layer=self.PostMatrix[Band5-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('postB5')

        if self.dlg.checkBox_FAP_B8A.isChecked():
            layer=self.PostMatrix[Band8A-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('postB8A')

        if self.dlg.checkBox_FAP_B9.isChecked():
            layer=self.PostMatrix[Band9-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('postB9')

        if self.dlg.checkBox_FAP_B10.isChecked():
            layer=self.PostMatrix[Band10-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('postB10')

        if self.dlg.checkBox_FAP_B11.isChecked():
            layer=self.PostMatrix[Band11-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('postB11')

        if self.dlg.checkBox_FAP_B12.isChecked():
            layer=self.PostMatrix[Band12-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('postB12')

        # FEATURES ADVANCED DELTA
        if self.dlg.checkBox_FAD_B1.isChecked():
            layer=self.DeltaMatrix[Band1-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('deltaB1')

        if self.dlg.checkBox_FAD_B2.isChecked():
            layer=self.DeltaMatrix[Band2-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('deltaB2')

        if self.dlg.checkBox_FAD_B3.isChecked():
            layer=self.DeltaMatrix[Band3-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('deltaB3')

        if self.dlg.checkBox_FAD_B4.isChecked():
            layer=self.DeltaMatrix[Band4-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('deltaB4')

        if self.dlg.checkBox_FAD_B5.isChecked():
            layer=self.DeltaMatrix[Band5-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('deltaB5')

        if self.dlg.checkBox_FAD_B8A.isChecked():
            layer=self.DeltaMatrix[Band8A-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('deltaB8A')

        if self.dlg.checkBox_FAD_B9.isChecked():
            layer=self.DeltaMatrix[Band9-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('deltaB9')

        if self.dlg.checkBox_FAD_B10.isChecked():
            layer=self.DeltaMatrix[Band10-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('deltaB10')

        if self.dlg.checkBox_FAD_B11.isChecked():
            layer=self.DeltaMatrix[Band11-1]
            FinalFeatureList.append(layer)
            NameBandsList.append('deltaB11')

        self.update_progress(95)

        
        FinalFeatureMatix=np.array(FinalFeatureList)      

        Nband=FinalFeatureMatix.shape[0]
        Xsize=FinalFeatureMatix.shape[2]
        Ysize=FinalFeatureMatix.shape[1]


        Feature_outputfile = self.dlg.lineEdit_Feature.text()
        
        if not Feature_outputfile:
                path_index = 0
                path = self.Pre_path
                filename = "Feature_result.tif"     
        else:
                path_index = 1
                path = Feature_outputfile
                filename="null"
        
        self.Feature_result = WriteLayer(path_index,path,FinalFeatureMatix,NameBandsList,Nband,Xsize,Ysize,filename,self.GeoTrans,self.proj)
  
        if self.dlg.checkBox_Feature_display.isChecked():
                iface.addRasterLayer(self.Feature_result.output_path, "Feature_result")
        
        self.update_progress(100)
        self.hide_progress_bar()

        end=time.process_time()
        print("Process end")
        print('Computational time Feature [s]: ',(end - start),"start=", start,"end=",end)
        print('\n') 
        self.window = QtWidgets.QDialog()
        self.ui = Ui_Message()
        self.ui.setupUi(self.window)
        self.window.show()
       
###################################################################################################     
###################################################################################################
###################################################################################################
#  This part of the script contains the code about Membership Degree computation
#  The process is executed when the button "COMPUTE MD" is clicked  
   
    def ComputeMD(self):
        print("ComputeMD button clicked, wait until the process end")
        self.show_progress_bar("Computing MD")
        self.update_progress(10)
        start=time.process_time()
        ###################################################################################################
        # Apply the Membership Function (K and x0 come from the user as input) on the selected layer 
        # MF = 1/(1+np.exp(-K*(Matrix/10000-x)))
        ###################################################################################################
    
        FinalBandList=[]
        NameBandsList=[]

        # FEATURES DEFAULT
        if self.dlg.checkBox_FD_postB6.isChecked():
            K=self.dlg.doubleSpinBox_FD_postB6_K.value()
            x=self.dlg.doubleSpinBox_FD_postB6_x.value()
            # -1 is necessary in order to allign the order of the bands
            # user starts to count from 1 (B1,B2...), instead pyhton starts to count from 0
            layer=self.PostMatrix[self.BandsList[5]-1]
            MD_postB6 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_postB6)
            NameBandsList.append('MD_postB6')

        if self.dlg.checkBox_FD_postB7.isChecked():
            K=self.dlg.doubleSpinBox_FD_postB7_K.value()
            x=self.dlg.doubleSpinBox_FD_postB7_x.value()
            layer=self.PostMatrix[self.BandsList[6]-1]
            MD_postB7 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_postB7)
            NameBandsList.append('MD_postB7')

        if self.dlg.checkBox_FD_postNIR.isChecked():
            K=self.dlg.doubleSpinBox_FD_postNIR_K.value()
            x=self.dlg.doubleSpinBox_FD_postNIR_x.value()
            layer=self.PostMatrix[self.BandsList[7]-1]
            MD_postB8 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_postB8)
            NameBandsList.append('MD_postB8')

        if self.dlg.checkBox_FD_deltaB6.isChecked():
            K=self.dlg.doubleSpinBox_FD_deltaB6_K.value()
            x=self.dlg.doubleSpinBox_FD_deltaB6_x.value()
            layer=self.DeltaMatrix[self.BandsList[5]-1]
            MD_deltaB6 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_deltaB6)
            NameBandsList.append('MD_deltaB6')

        if self.dlg.checkBox_FD_deltaB7.isChecked():
            K=self.dlg.doubleSpinBox_FD_deltaB7_K.value()
            x=self.dlg.doubleSpinBox_FD_deltaB7_x.value()
            layer=self.DeltaMatrix[self.BandsList[6]-1]
            MD_deltaB7 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_deltaB7)
            NameBandsList.append('MD_deltaB7')

        if self.dlg.checkBox_FD_deltaNIR.isChecked():
            K=self.dlg.doubleSpinBox_FD_deltaNIR_K.value()
            x=self.dlg.doubleSpinBox_FD_deltaNIR_x.value()
            layer=self.DeltaMatrix[self.BandsList[7]-1]
            MD_deltaB8 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_deltaB8)
            NameBandsList.append('MD_deltaB8')

        if self.dlg.checkBox_FD_deltaB12.isChecked():
            K=self.dlg.doubleSpinBox_FD_deltaB12_K.value()
            x=self.dlg.doubleSpinBox_FD_deltaB12_x.value()
            layer=self.DeltaMatrix[self.BandsList[12]-1]                    
            MD_deltaB12 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_deltaB12)
            NameBandsList.append('MD_deltaB12')

        # FEATURES ADVANCED POST
        if self.dlg.checkBox_FAP_B1.isChecked():
            K=self.dlg.doubleSpinBox_FAP_B1_K.value()
            x=self.dlg.doubleSpinBox_FAP_B1_x.value()
            layer=self.PostMatrix[self.BandsList[0]-1]
            MD_postB1 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_postB1)
            NameBandsList.append('MD_postB1')

        if self.dlg.checkBox_FAP_B2.isChecked():
            K=self.dlg.doubleSpinBox_FAP_B2_K.value()
            x=self.dlg.doubleSpinBox_FAP_B2_x.value()
            layer=self.PostMatrix[self.BandsList[1]-1]
            MD_postB2 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_postB2)
            NameBandsList.append('MD_postB2')

        if self.dlg.checkBox_FAP_B3.isChecked():
            K=self.dlg.doubleSpinBox_FAP_B3_K.value()
            x=self.dlg.doubleSpinBox_FAP_B3_x.value()
            layer=self.PostMatrix[self.BandsList[2]-1]
            MD_postB3 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_postB3)
            NameBandsList.append('MD_postB3')

        if self.dlg.checkBox_FAP_B4.isChecked():
            K=self.dlg.doubleSpinBox_FAP_B4_K.value()
            x=self.dlg.doubleSpinBox_FAP_B4_x.value()
            layer=self.PostMatrix[self.BandsList[3]-1]
            MD_postB4 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_postB4)
            NameBandsList.append('MD_postB4')

        if self.dlg.checkBox_FAP_B5.isChecked():
            K=self.dlg.doubleSpinBox_FAP_B5_K.value()
            x=self.dlg.doubleSpinBox_FAP_B5_x.value()
            layer=self.PostMatrix[self.BandsList[4]-1]
            MD_postB5 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_postB5)
            NameBandsList.append('MD_postB5')

        if self.dlg.checkBox_FAP_B8A.isChecked():
            K=self.dlg.doubleSpinBox_FAP_B8A_K.value()
            x=self.dlg.doubleSpinBox_FAP_B8A_x.value()
            layer=self.PostMatrix[self.BandsList[8]-1]
            MD_postB8A = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_postB8A)
            NameBandsList.append('MD_postB8A')

        if self.dlg.checkBox_FAP_B9.isChecked():
            K=self.dlg.doubleSpinBox_FAP_B9_K.value()
            x=self.dlg.doubleSpinBox_FAP_B9_x.value()
            layer=self.PostMatrix[self.BandsList[9]-1]
            MD_postB9 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_postB9)
            NameBandsList.append('MD_postB9')

        if self.dlg.checkBox_FAP_B10.isChecked():
            K=self.dlg.doubleSpinBox_FAP_B10_K.value()
            x=self.dlg.doubleSpinBox_FAP_B10_x.value()
            layer=self.PostMatrix[self.BandsList[10]-1]
            MD_postB10 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_postB10)
            NameBandsList.append('MD_postB10')

        if self.dlg.checkBox_FAP_B11.isChecked():
            K=self.dlg.doubleSpinBox_FAP_B11_K.value()
            x=self.dlg.doubleSpinBox_FAP_B11_x.value()
            layer=self.PostMatrix[self.BandsList[11]-1]
            MD_postB11 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_postB11)
            NameBandsList.append('MD_postB11')

        if self.dlg.checkBox_FAP_B12.isChecked():
            K=self.dlg.doubleSpinBox_FAP_B12_K.value()
            x=self.dlg.doubleSpinBox_FAP_B12_x.value()
            layer=self.PostMatrix[self.BandsList[12]-1]
            MD_postB12 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_postB12)
            NameBandsList.append('MD_postB12')

        # FEATURES ADVANCED DELTA
        if self.dlg.checkBox_FAD_B1.isChecked():
            K=self.dlg.doubleSpinBox_FAD_B1_K.value()
            x=self.dlg.doubleSpinBox_FAD_B1_x.value()
            layer=self.DeltaMatrix[self.BandsList[0]-1]  
            MD_deltaB1 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_deltaB1)
            NameBandsList.append('MD_deltaB1')

        if self.dlg.checkBox_FAD_B2.isChecked():
            K=self.dlg.doubleSpinBox_FAD_B2_K.value()
            x=self.dlg.doubleSpinBox_FAD_B2_x.value()
            layer=self.DeltaMatrix[self.BandsList[1]-1]  
            MD_deltaB2 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_deltaB2)
            NameBandsList.append('MD_deltaB2')

        if self.dlg.checkBox_FAD_B3.isChecked():
            K=self.dlg.doubleSpinBox_FAD_B3_K.value()
            x=self.dlg.doubleSpinBox_FAD_B3_x.value()
            layer=self.DeltaMatrix[self.BandsList[2]-1]  
            MD_deltaB3 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_deltaB3)
            NameBandsList.append('MD_deltaB3')

        if self.dlg.checkBox_FAD_B4.isChecked():
            K=self.dlg.doubleSpinBox_FAD_B4_K.value()
            x=self.dlg.doubleSpinBox_FAD_B4_x.value()
            layer=self.DeltaMatrix[self.BandsList[3]-1]  
            MD_deltaB4 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_deltaB4)
            NameBandsList.append('MD_deltaB4')

        if self.dlg.checkBox_FAD_B5.isChecked():
            K=self.dlg.doubleSpinBox_FAD_B5_K.value()
            x=self.dlg.doubleSpinBox_FAD_B5_x.value()
            layer=self.DeltaMatrix[self.BandsList[4]-1]  
            MD_deltaB5 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_deltaB5)
            NameBandsList.append('MD_deltaB5')

        if self.dlg.checkBox_FAD_B8A.isChecked():
            K=self.dlg.doubleSpinBox_FAD_B8A_K.value()
            x=self.dlg.doubleSpinBox_FAD_B8A_x.value()
            layer=self.DeltaMatrix[self.BandsList[8]-1]  
            MD_deltaB8A = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_deltaB8A)
            NameBandsList.append('MD_deltaB8A')

        if self.dlg.checkBox_FAD_B9.isChecked():
            K=self.dlg.doubleSpinBox_FAD_B9_K.value()
            x=self.dlg.doubleSpinBox_FAD_B9_x.value()
            layer=self.DeltaMatrix[self.BandsList[9]-1]  
            MD_deltaB9 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_deltaB9)
            NameBandsList.append('MD_deltaB9')

        if self.dlg.checkBox_FAD_B10.isChecked():
            K=self.dlg.doubleSpinBox_FAD_B10_K.value()
            x=self.dlg.doubleSpinBox_FAD_B10_x.value()
            layer=self.DeltaMatrix[self.BandsList[10]-1]  
            MD_deltaB10 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_deltaB10)
            NameBandsList.append('MD_deltaB10')

        if self.dlg.checkBox_FAD_B11.isChecked():
            K=self.dlg.doubleSpinBox_FAD_B11_K.value()
            x=self.dlg.doubleSpinBox_FAD_B11_x.value()
            layer=self.DeltaMatrix[self.BandsList[11]-1]  
            MD_deltaB11 = MembershipFunction(layer,K,x).MD
            FinalBandList.append(MD_deltaB11)
            NameBandsList.append('MD_deltaB11')


        # from list to an array
        self.update_progress(90)
        self.FinalBandMatix=np.array(FinalBandList)

        Nband=self.FinalBandMatix.shape[0]
        Xsize=self.FinalBandMatix.shape[2]
        Ysize=self.FinalBandMatix.shape[1]

        MD_outputfile = self.dlg.lineEdit_MD.text()
        
        if not MD_outputfile:
                path_index = 0
                path = self.Pre_path
                filename = "MD_result.tif"     
        else:
                path_index = 1
                path = MD_outputfile
                filename="null"
        
        self.MD_result = WriteLayer(path_index,path,self.FinalBandMatix,NameBandsList,Nband,Xsize,Ysize,filename,self.GeoTrans,self.proj)


        if self.dlg.checkBox_MD_display.isChecked():
                iface.addRasterLayer(self.MD_result.output_path, "MD_result")
        
        self.update_progress(100)
        self.hide_progress_bar()

        end=time.process_time()
        print("Process end")
        print('Computational time MD [s]: ',(end - start),"start=", start,"end=",end)
        print('\n') 
        self.window = QtWidgets.QDialog()
        self.ui = Ui_Message()
        self.ui.setupUi(self.window)
        self.window.show()

###################################################################################################     
###################################################################################################
###################################################################################################
#  This part of the script contains the code about OWA computation
#  The process is executed when the button "COMPUTE OWA" is clicked
    def ComputeOWA(self):   
        print("ComputeOWA button clicked, wait until the process end")
        self.show_progress_bar("Computing OWA")
        self.update_progress(3)
        start=time.process_time()
           
    ############
    # OWA input from User
    ############
        if self.dlg.groupBox_InputOWA.isChecked():

            if self.dlg.groupBox_InputOWA.isChecked():
                MD_layer = self.dlg.mMapLayerComboBox_OWA_MD.currentLayer()
            if not MD_layer:
                print("Please select a valid MD layer before running OWA")
                return None
        # Get layer path
            MD_path = MD_layer.dataProvider().dataSourceUri()
        # Read the MD layer
            dataset = gdal.Open(MD_path)
            if dataset is None:
                print(f"Unable to open {MD_path}")
                return None

            # Read all bands into a list
            FinalBandList = []
            for i in range(1, dataset.RasterCount + 1):
                band = dataset.GetRasterBand(i)
                FinalBandList.append(band.ReadAsArray())

            FinalBandMatix = np.array(FinalBandList)
            self.FinalBandMatix = FinalBandMatix
            Xsize = FinalBandMatix.shape[2]
            Ysize = FinalBandMatix.shape[1]
            self.GeoTrans = dataset.GetGeoTransform()
            self.proj = dataset.GetProjection()

            # Close the dataset
            dataset = None

        self.update_progress(20)

        if self.dlg.checkBox_OWA_AND.isChecked() or self.dlg.radioButton_OWA_S_AND.isChecked() or \
            self.dlg.radioButton_OWA_G_AND.isChecked():

            OWA_index=1
            OWA=OrderedWeigthAverage(OWA_index,self.FinalBandMatix)
              
            outputfile = self.dlg.lineEdit_OWA_AND.text()
            
            # if the outputfile path is not specified the plugin uses the same path of one of the two input
            # files, in particular the seed layer path
            if not outputfile:
                path_index=0
                path= MD_path if self.dlg.groupBox_InputOWA.isChecked() else self.Pre_path
            # otherwise it uses the path specified by the user
            else:
                path_index=1    
                path=outputfile

            NameBandsList='OWA AND'
            Nband=1
            Xsize=OWA.Integrated_matrix.shape[1]
            Ysize=OWA.Integrated_matrix.shape[0]
            self.OWA_AND = WriteLayer(path_index,path,OWA.Integrated_matrix,NameBandsList,Nband,Xsize,Ysize,OWA.filename,self.GeoTrans,self.proj)
            
            if self.dlg.checkBox_OWA_display.isChecked():
                iface.addRasterLayer(self.OWA_AND.output_path, "OWA_AND")

        if self.dlg.checkBox_OWA_almostAND.isChecked() or self.dlg.radioButton_OWA_S_almostAND.isChecked() or \
            self.dlg.radioButton_OWA_G_almostAND.isChecked():

            OWA_index=2
            OWA=OrderedWeigthAverage(OWA_index,self.FinalBandMatix)
            
            outputfile = self.dlg.lineEdit_OWA_almostAND.text()

            if not outputfile:
                path_index=0
                path= MD_path if self.dlg.groupBox_InputOWA.isChecked() else self.Pre_path
            else:
                path_index=1
                path=outputfile
                
            NameBandsList='OWA almost AND'
            Nband=1
            Xsize=OWA.Integrated_matrix.shape[1]
            Ysize=OWA.Integrated_matrix.shape[0]
            self.OWA_almostAND = WriteLayer(path_index,path,OWA.Integrated_matrix,NameBandsList,Nband,Xsize,Ysize,OWA.filename,self.GeoTrans,self.proj)
    
            if self.dlg.checkBox_OWA_display.isChecked():
                iface.addRasterLayer(self.OWA_almostAND.output_path, "OWA_almostAND")
        
        if self.dlg.checkBox_OWA_AVERAGE.isChecked() or self.dlg.radioButton_OWA_S_AVERAGE.isChecked() or \
            self.dlg.radioButton_OWA_G_AVERAGE.isChecked():
            OWA_index=3
            OWA=OrderedWeigthAverage(OWA_index,self.FinalBandMatix)
            outputfile = self.dlg.lineEdit_OWA_AVERAGE.text()

            if not outputfile:
                path_index=0
                path=MD_path if self.dlg.groupBox_InputOWA.isChecked() else self.Pre_path
            else:
                path_index=1
                path=outputfile
                
            NameBandsList='OWA AVERAGE'
            Nband=1
            Xsize=OWA.Integrated_matrix.shape[1]
            Ysize=OWA.Integrated_matrix.shape[0]
            self.OWA_AVERAGE = WriteLayer(path_index,path,OWA.Integrated_matrix,NameBandsList,Nband,Xsize,Ysize,OWA.filename,self.GeoTrans,self.proj)
    
            if self.dlg.checkBox_OWA_display.isChecked():
                iface.addRasterLayer(self.OWA_AVERAGE.output_path, "OWA_AVERAGE")
                   
        if self.dlg.checkBox_OWA_almostOR.isChecked() or self.dlg.radioButton_OWA_S_almostOR.isChecked() or \
            self.dlg.radioButton_OWA_G_almostOR.isChecked():
            OWA_index=4
            OWA=OrderedWeigthAverage(OWA_index,self.FinalBandMatix)
            outputfile = self.dlg.lineEdit_OWA_almostOR.text()

            if not outputfile:
                path_index=0
                path=MD_path if self.dlg.groupBox_InputOWA.isChecked() else self.Pre_path
            else:
                path_index=1
                path=outputfile
                
            NameBandsList='OWA almost OR'
            Nband=1
            Xsize=OWA.Integrated_matrix.shape[1]
            Ysize=OWA.Integrated_matrix.shape[0]
            self.OWA_almostOR = WriteLayer(path_index,path,OWA.Integrated_matrix,NameBandsList,Nband,Xsize,Ysize,OWA.filename,self.GeoTrans,self.proj)
    
            if self.dlg.checkBox_OWA_display.isChecked():
                iface.addRasterLayer(self.OWA_almostOR.output_path, "OWA_almostOR")
        
        if self.dlg.checkBox_OWA_OR.isChecked() or self.dlg.radioButton_OWA_S_OR.isChecked() or \
            self.dlg.radioButton_OWA_G_OR.isChecked():
            OWA_index=5
            OWA=OrderedWeigthAverage(OWA_index,self.FinalBandMatix)
            outputfile = self.dlg.lineEdit_OWA_OR.text()

            if not outputfile:
                path_index=0
                path=MD_path if self.dlg.groupBox_InputOWA.isChecked() else self.Pre_path
            else:
                path_index=1
                path=outputfile
                
            NameBandsList='OWA OR'
            Nband=1
            Xsize=OWA.Integrated_matrix.shape[1]
            Ysize=OWA.Integrated_matrix.shape[0]
            self.OWA_OR = WriteLayer(path_index,path,OWA.Integrated_matrix,NameBandsList,Nband,Xsize,Ysize,OWA.filename,self.GeoTrans,self.proj)
    
    
            if self.dlg.checkBox_OWA_display.isChecked():
                iface.addRasterLayer(self.OWA_OR.output_path, "OWA_OR")

        self.update_progress(100)
        self.hide_progress_bar()   
        end=time.process_time()
        print("Process end")
        print('Computational time OWA [s]: ',(end - start),"start=", start,"end=",end)   
        print('\n') 
        self.window = QtWidgets.QDialog()
        self.ui = Ui_Message()
        self.ui.setupUi(self.window)
        self.window.show()
###################################################################################################
###################################################################################################
###################################################################################################
#  This part of the script contains the code about the application of the Region Growing Algorithm 
#  The process is executed when the button "COMPUTE RG" is clicked 
#

    def ComputeRG(self):
        print("ComputeRG button clicked, wait until the process end")
        self.show_progress_bar("Computing RG")
        self.update_progress(5)
        start=time.process_time()
               
        Seed_value = round(self.dlg.doubleSpinBox_RG_seed.value(),2)
        Grow_value = round(self.dlg.doubleSpinBox_RG_grow.value(),2)
        

        if self.dlg.groupBox_RG_input.isChecked():
        
            Seed_name = str(self.dlg.comboBox_RG_seed.currentText())
            Seed_info = QgsProject.instance().mapLayersByName(Seed_name)
            Seed_path = Seed_info[0].dataProvider().dataSourceUri()

            Grow_name = str(self.dlg.comboBox_RG_grow.currentText())       
            Grow_info = QgsProject.instance().mapLayersByName(Grow_name)
            Grow_path = Grow_info[0].dataProvider().dataSourceUri()
            
            Seed_file = Seed_path 
            Grow_file = Grow_path
        
        else:
            if self.dlg.radioButton_OWA_S_AND.isChecked():
                Seed_file = self.OWA_AND.output_path

            if self.dlg.radioButton_OWA_S_almostAND.isChecked():
                Seed_file = self.OWA_almostAND.output_path

            if self.dlg.radioButton_OWA_S_AVERAGE.isChecked():
                Seed_file = self.OWA_AVERAGE.output_path

            if self.dlg.radioButton_OWA_S_almostOR.isChecked():
                Seed_file = self.OWA_almostOR.output_path

            if self.dlg.radioButton_OWA_S_OR.isChecked():
                Seed_file = self.OWA_OR.output_path

            if self.dlg.radioButton_OWA_G_AND.isChecked():
                Grow_file = self.OWA_AND.output_path

            if self.dlg.radioButton_OWA_G_almostAND.isChecked():
                Grow_file = self.OWA_almostAND.output_path

            if self.dlg.radioButton_OWA_G_AVERAGE.isChecked():
                Grow_file = self.OWA_AVERAGE.output_path

            if self.dlg.radioButton_OWA_G_almostOR.isChecked():
                Grow_file = self.OWA_almostOR.output_path

            if self.dlg.radioButton_OWA_G_OR.isChecked():
                Grow_file = self.OWA_OR.output_path 

        self.update_progress(20)

        DataRG = ReadingData(Seed_file,Grow_file) 
        Seed_matrix = DataRG.FirstMatrix
        Grow_matrix = DataRG.SecondMatrix
 
        RG=RegionGrowing(Seed_value,Grow_value,Seed_matrix,Grow_matrix)

        self.Burned_matrix= RG.Result_matrix

        RG_outputfile = self.dlg.lineEdit_RG_result.text()
        
        if not RG_outputfile:
                path_index = 0
                path = Seed_file
                filename = "RegionGrowing_result.tif"     
        else:
                path_index = 1
                path = RG_outputfile
                filename="null"
        

        NameBandsList='Region Growing Result'
        Nband=1
        Xsize=self.Burned_matrix.shape[1]
        Ysize=self.Burned_matrix.shape[0]  

        self.RG_result = WriteLayer(path_index,path,self.Burned_matrix,NameBandsList,Nband,Xsize,Ysize,filename,DataRG.gt,DataRG.proj)
        self.update_progress(95)
        
        if self.dlg.checkBox_RG_display.isChecked():
                iface.addRasterLayer(self.RG_result.output_path, "RG_result")
        self.update_progress(100)
        self.hide_progress_bar()
        end=time.process_time()
        print("Process end")
        print('Computational time RG [s]: ',(end - start),"start=", start,"end=",end) 
        print('\n') 
        self.window = QtWidgets.QDialog()
        self.ui = Ui_Message()
        self.ui.setupUi(self.window)
        self.window.show()

###################################################################################################
###################################################################################################
###################################################################################################
#  This part of the script contains the code about the Severity computation 
#  The process is executed when the button "COMPUTE SEVERITY" is clicked  

    def ComputeSeverity(self):

        print("ComputeSeverity button clicked, wait until the process end")
        self.show_progress_bar("Computing Severity")
        self.update_progress(5)
        start=time.process_time()
        
        #NIR=BANDA8
        #SWIR=BANDA12
        # NBR = (NIR-SWIR)/(NIR+SWIR)
        # prefireNBR-postfireNBR
        
        NIR_pre=self.PreMatrix[self.BandsList[7]-1]
        NIR_post=self.PostMatrix[self.BandsList[7]-1]
        SWIR_pre=self.PreMatrix[self.BandsList[12]-1]
        SWIR_post=self.PostMatrix[self.BandsList[12]-1]

        NBR_pre=(NIR_pre-SWIR_pre)/(NIR_pre+SWIR_pre)
        NBR_post=(NIR_post-SWIR_post)/(NIR_post+SWIR_post)

        Delta_NBR = NBR_pre-NBR_post

        LowerLevelList=[]
        UpperLevelList=[]

        # Enhanced Regrowth, high
        ERH_1=self.dlg.doubleSpinBox_Severity_ERH_1.value()
        ERH_2=self.dlg.doubleSpinBox_Severity_ERH_2.value()
        LowerLevelList.append(ERH_1)
        UpperLevelList.append(ERH_2)
        
        
        # Enhanced Regrowth, low
        ERL_1=self.dlg.doubleSpinBox_Severity_ERL_1.value()
        ERL_2=self.dlg.doubleSpinBox_Severity_ERL_2.value()
        LowerLevelList.append(ERL_1)
        UpperLevelList.append(ERL_2)

        # Unburned
        U_1=self.dlg.doubleSpinBox_Severity_U_1.value()
        U_2=self.dlg.doubleSpinBox_Severity_U_2.value()
        LowerLevelList.append(U_1)
        UpperLevelList.append(U_2)

        # Low Severity
        L_1=self.dlg.doubleSpinBox_Severity_L_1.value()
        L_2=self.dlg.doubleSpinBox_Severity_L_2.value()
        LowerLevelList.append(L_1)
        UpperLevelList.append(L_2)

        # Moderate-low Severity
        ML_1=self.dlg.doubleSpinBox_Severity_ML_1.value()
        ML_2=self.dlg.doubleSpinBox_Severity_ML_2.value()
        LowerLevelList.append(ML_1)
        UpperLevelList.append(ML_2)

        # Miderate-high Severity
        MH_1=self.dlg.doubleSpinBox_Severity_MH_1.value()
        MH_2=self.dlg.doubleSpinBox_Severity_MH_2.value()
        LowerLevelList.append(MH_1)
        UpperLevelList.append(MH_2)

        # High Severity
        H_1=self.dlg.doubleSpinBox_Severity_H_1.value()
        H_2=self.dlg.doubleSpinBox_Severity_H_2.value()
        LowerLevelList.append(H_1)
        UpperLevelList.append(H_2)
        
        Severity_classification=Classification(Delta_NBR,LowerLevelList,UpperLevelList)
        
        self.Class_matrix=Severity_classification.Final_Matrix
        self.update_progress(45)
        
        NameBandsList='Severity Level'
        Nband=1        
        Xsize=self.Class_matrix.shape[1]
        Ysize=self.Class_matrix.shape[0]

        Severity_outputfile = self.dlg.lineEdit_Severity.text()

        if not Severity_outputfile:
                path_index = 0
                path = self.Pre_path
                filename = "Severity_result.tif"     
        else:
                path_index = 1
                path = Severity_outputfile
                filename="null"
        self.update_progress(97)
        self.Severity_result = WriteLayer(path_index,path,self.Class_matrix,NameBandsList,Nband,Xsize,Ysize,filename,self.GeoTrans,self.proj)
        
        if self.dlg.checkBox_Severity.isChecked():
                iface.addRasterLayer(self.Severity_result.output_path, "Severity_result")

        self.update_progress(100)
        self.hide_progress_bar()
        end=time.process_time()
        print("Process end")
        print('Computational time Severity [s]: ',(end - start),"start=", start,"end=",end) 
        print('\n') 
        self.window = QtWidgets.QDialog()
        self.ui = Ui_Message()
        self.ui.setupUi(self.window)
        self.window.show()
###################################################################################################
###################################################################################################
###################################################################################################
#  This part of the script contains the code about the RG Severity computation 
#  The process is executed when the button "COMPUTE RG SEVERITY" is clicked 
    
    def ComputeRGSeverity(self):

        print("ComputeRG_Severity button clicked, wait until the process end")
        self.show_progress_bar("Computing RGSeverity")
        self.update_progress(5)
        start=time.process_time()
        
        Class_Matrix = self.Class_matrix
        Burned_Matrix = self.Burned_matrix
        Class_Burned = Class_Matrix*Burned_Matrix
        Class_Burned = np.where(Class_Burned>10,99,Class_Burned)

        NameBandsList='RG severity class'
        Nband=1        
        Xsize=Class_Matrix.shape[1]
        Ysize=Class_Matrix.shape[0]

        RGSeverity_outputfile = self.dlg.lineEdit_CombinedSeverity.text()
        self.update_progress(25)
        if not RGSeverity_outputfile:
                path_index = 0
                path = self.Pre_path
                filename = "RG_Severity_result.tif"     
        else:
                path_index = 1
                path = RGSeverity_outputfile
                filename="null"
        self.update_progress(87)
        self.RGSeverity_result = WriteLayer(path_index,path,Class_Burned,NameBandsList,Nband,Xsize,Ysize,filename,self.GeoTrans,self.proj)
        
        if self.dlg.checkBox_CombinedSeverity.isChecked():
                iface.addRasterLayer(self.RGSeverity_result.output_path, "RG_Severity_result")

        self.update_progress(100)
        self.hide_progress_bar()
        end=time.process_time()
        print("Process end")
        print('Computational time Severity+RG [s]: ',(end - start),"start=", start,"end=",end)
        print('\n') 
        self.window = QtWidgets.QDialog()
        self.ui = Ui_Message()
        self.ui.setupUi(self.window)
        self.window.show()

    # RG_Validation tab
    def browseRGFile(self):
        file_path, _ = QFileDialog.getOpenFileName(self.dlg, "Select RG Raster File", "", "Raster Files (*.tif *.tiff)")
        if file_path:
            self.dlg.lineEditRGFile.setText(file_path)

    def browseReferenceFile(self):
        file_path, _ = QFileDialog.getOpenFileName(self.dlg, "Select Reference Raster File", "", "Raster Files (*.tif *.tiff)")
        if file_path:
            self.dlg.lineEditReferenceFile.setText(file_path)

    def ComputeRGValidation(self):
        self.show_progress_bar("Computing RGValidation")
        self.update_progress(5)
        start=time.process_time()
        rg_raster_path = self.dlg.lineEditRGFile.text()
        reference_raster_path = self.dlg.lineEditReferenceFile.text()

        if not os.path.exists(rg_raster_path) or not os.path.exists(reference_raster_path):
            QMessageBox.warning(self.dlg, "Missing Input", "Please select both RG and Reference raster files.")
            return

        try:
            rg_raster_ds = gdal.Open(rg_raster_path)
            reference_raster_ds = gdal.Open(reference_raster_path)

            if not rg_raster_ds or not reference_raster_ds:
                QMessageBox.critical(self.dlg, "Error", "Failed to load raster files.")
                return

            width = rg_raster_ds.RasterXSize
            height = rg_raster_ds.RasterYSize

            rg_band = rg_raster_ds.GetRasterBand(1)
            reference_band = reference_raster_ds.GetRasterBand(1)

            rg_data = rg_band.ReadAsArray(0, 0, width, height).astype(int)
            reference_data = reference_band.ReadAsArray(0, 0, width, height).astype(int)

            # Class Mapping
            class_mapping = {0: 'Unburned', 1: 'Burned'}

            # Initialize Confusion Matrix
            conf_matrix = np.zeros((2, 2), dtype=int)

            # Populate Confusion Matrix
            for i in range(height):
                for j in range(width):
                    reference_val = reference_data[i, j]  # REF raster value
                    rg_val = rg_data[i, j]  # BAD raster value

                    if reference_val in class_mapping and rg_val in class_mapping:
                        ref_class = class_mapping[reference_val]
                        rg_class = class_mapping[rg_val]

                        # Fixed Confusion Matrix Assignment
                        if rg_class == 'Burned' and ref_class == 'Burned':
                            conf_matrix[0, 0] += 1  # True Positive (TP)
                        elif rg_class == 'Burned' and ref_class == 'Unburned':
                            conf_matrix[1, 0] += 1  # False Negative (FN) 
                        elif rg_class == 'Unburned' and ref_class == 'Burned':
                            conf_matrix[0, 1] += 1  # False Positive (FP) 
                        elif rg_class == 'Unburned' and ref_class == 'Unburned':
                            conf_matrix[1, 1] += 1  # True Negative (TN)
            self.update_progress(100)
            self.hide_progress_bar()
            end=time.process_time()
            print("Process end")
            print('Computational time RGValidation [s]: ',(end - start),"start=", start,"end=",end) 
            print('\n') 
            self.window = QtWidgets.QDialog()
            self.ui = Ui_Message()
            self.ui.setupUi(self.window)
            self.window.show()
            print("\nConfusion Matrix:")
            print(conf_matrix)

            
            self.dlg.tableWidgetConfusionMatrixRG.setRowCount(2)
            self.dlg.tableWidgetConfusionMatrixRG.setColumnCount(2)

            for row in range(2):
                for col in range(2):
                    self.dlg.tableWidgetConfusionMatrixRG.setItem(row, col, QTableWidgetItem(str(conf_matrix[row][col])))

            # Extract Matrix Values 
            TP = conf_matrix[0, 0]  # Burned (BAD), Burned (REF) - True Positive
            FP = conf_matrix[1, 0]  # Burned (BAD), Unburned (REF) - False Negative 
            FN = conf_matrix[0, 1]  # Unburned (BAD), Burned (REF) - False Positive 
            TN = conf_matrix[1, 1]  # Unburned (BAD), Unburned (REF) - True Negative

            # Compute Validation Metrics
            CE = (FP / (TP + FP)*100) if (TP + FP) != 0 else 0  # Commission Error
            OE = (FN / (TP + FN)*100) if (TP + FN) != 0 else 0  # Omission Error
            DC = ((2 * TP) / ((2 * TP) + FP + FN)*100) if ((2 * TP) + FP + FN) != 0 else 0  # Dice Coefficient
            bias = ((FP + FN) / (TP + TN)*100) if (TP + TN) != 0 else 0  # Bias
            relative_bias = ((FP - FN) / (TP + TN)*100) if (TP + TN) != 0 else 0  # Relative Bias
            OA = ((TP + TN) / (TP + FP + FN + TN)*100) if (TP + FP + FN + TN) != 0 else 0  # Overall Accuracy

            # Display Metrics
            self.dlg.textEditMetricsRG.setPlainText(f"""
            Commission Error (CE): {CE:.2f}%
            Omission Error (OE): {OE:.2f}%
            Dice Coefficient (DC): {DC:.2f}%
            Bias: {bias:.4f}
            Relative Bias: {relative_bias:.4f}
            Overall Accuracy (OA): {OA:.2f}%
            """)

        except Exception as e:
            QMessageBox.critical(self.dlg, "Error", f"Validation failed: {e}")

    # Function to create the agreement map
    def create_agreement_map(self, rg_data, reference_data):
        height, width = rg_data.shape
        agreement_map = np.full((height, width), np.nan)

        # Iterate through the data arrays to assign values to the agreement map
        for i in range(height):
            for j in range(width):
                reference_val = reference_data[i, j]
                rg_val = rg_data[i, j]

                if reference_val == 1 and rg_val == 1:
                    agreement_map[i, j] = 1  # TP
                elif reference_val == 0 and rg_val == 1:
                    agreement_map[i, j] = 2  # FP
                elif reference_val == 1 and rg_val == 0:
                    agreement_map[i, j] = 3  # FN
                elif reference_val == 0 and rg_val == 0:
                    agreement_map[i, j] = 4  # TN

        return agreement_map

    # Function to generate the agreement map and save it
    def generateAgreementMap(self):
        self.show_progress_bar("Computing agreement_map")
        self.update_progress(5)
        rg_raster_path = self.dlg.lineEditRGFile.text()
        reference_raster_path = self.dlg.lineEditReferenceFile.text()

        if not os.path.exists(rg_raster_path) or not os.path.exists(reference_raster_path):
            QMessageBox.warning(self.dlg, "Missing Input", "Please select both RG and Reference raster files.")
            return

        try:
            rg_raster_ds = gdal.Open(rg_raster_path)
            reference_raster_ds = gdal.Open(reference_raster_path)

            if not rg_raster_ds or not reference_raster_ds:
                QMessageBox.critical(self.dlg, "Error", "Failed to load raster files.")
                return

            width = rg_raster_ds.RasterXSize
            height = rg_raster_ds.RasterYSize

            rg_band = rg_raster_ds.GetRasterBand(1)
            reference_band = reference_raster_ds.GetRasterBand(1)

            rg_data = rg_band.ReadAsArray(0, 0, width, height).astype(int)
            reference_data = reference_band.ReadAsArray(0, 0, width, height).astype(int)
            agreement_map = self.create_agreement_map(rg_data, reference_data)
            save_path, _ = QFileDialog.getSaveFileName(self.dlg, "Save Agreement Map", "", "GeoTIFF (*.tif)")
            if not save_path:
                return  
            # Saving the agreement map as GeoTIFF
            driver = gdal.GetDriverByName("GTiff")
            output_ds = driver.Create(save_path, rg_data.shape[1], rg_data.shape[0], 1, gdal.GDT_Byte)
            output_ds.SetGeoTransform(rg_raster_ds.GetGeoTransform())
            output_ds.SetProjection(rg_raster_ds.GetProjection())

            output_band = output_ds.GetRasterBand(1)
            output_band.WriteArray(agreement_map)
            output_band.SetNoDataValue(np.nan)

            output_ds.FlushCache()
            output_ds = None

            QMessageBox.information(self.dlg, "Agreement Map", f"Agreement Map saved at:\n{save_path}")

            # If the checkbox is checked, load the agreement map into QGIS
            if self.dlg.checkBox.isChecked():
                agreement_layer = QgsRasterLayer(save_path, "Agreement Map")
                if agreement_layer.isValid():
                    # Applying color ramp
                    self.applyColorRamp(agreement_layer)
                    QgsProject.instance().addMapLayer(agreement_layer)
                else:
                    QMessageBox.warning(self.dlg, "Error", "Failed to load the Agreement Map in QGIS.")

        except Exception as e:
            QMessageBox.critical(self.dlg, "Error", f"Failed to generate Agreement Map: {e}")
    def applyColorRamp(self, raster_layer):
        provider = raster_layer.dataProvider()
        shader = QgsRasterShader()
        color_ramp = QgsColorRampShader()
        color_ramp.setColorRampType(QgsColorRampShader.Interpolated)
        color_ramp_items = [
        QgsColorRampShader.ColorRampItem(0, QColor(255, 255, 255), "No Agreement"),  # White
        QgsColorRampShader.ColorRampItem(1, QColor(255, 0, 0), "Burned Agreement"),    # Red
        QgsColorRampShader.ColorRampItem(2, QColor(0, 0, 255), "Medium Agreement"), # Blue
        QgsColorRampShader.ColorRampItem(3, QColor(255, 255, 0), "High Agreement"), # Yellow
        QgsColorRampShader.ColorRampItem(4, QColor(0, 255, 0), "Unburned Agreement")    # Green
        
        ]
        color_ramp.setColorRampItemList(color_ramp_items)
        shader.setRasterShaderFunction(color_ramp)
        renderer = QgsSingleBandPseudoColorRenderer(provider, 1, shader)
        raster_layer.setRenderer(renderer)
        raster_layer.triggerRepaint()
        self.update_progress(100)
        self.hide_progress_bar()

    #exporting the validation
    def exportRGReport(self):
        conf_matrix = [
            [self.dlg.tableWidgetConfusionMatrixRG.item(0, 0).text(), self.dlg.tableWidgetConfusionMatrixRG.item(0, 1).text()],
            [self.dlg.tableWidgetConfusionMatrixRG.item(1, 0).text(), self.dlg.tableWidgetConfusionMatrixRG.item(1, 1).text()]
        ]
        metrics_text = self.dlg.textEditMetricsRG.toPlainText()
        html_content = f"""
        <html>
        <head>
            <title>RG Validation Report</title>
            <style>
                body {{ font-family: Arial, sans-serif; }}
                table {{ width: 50%; border-collapse: collapse; margin: 20px 0; }}
                th, td {{ border: 1px solid black; padding: 8px; text-align: center; }}
                th {{ background-color: #f2f2f2; }}
            </style>
        </head>
        <body>
            <h2>🔥RG Validation Report</h2>
            
            <h3>Confusion Matrix</h3>
            <table>
                <tr>
                    <th></th>
                    <th>Burned(REF)</th>
                    <th>Unburned(REF)</th>
                </tr>
                <tr>
                    <th>Burned(BAD)</th>
                    <td>{conf_matrix[0][0]}</td>
                    <td>{conf_matrix[0][1]}</td>
                </tr>
                <tr>    
                    <th>Unburned(BAD)</th>
                    <td>{conf_matrix[1][0]}</td>
                    <td>{conf_matrix[1][1]}</td>
                </tr>
            </table>

            <h3>Error Metrics</h3>
            <pre>{metrics_text}</pre>
        </body>
        </html>
        """
        file_path, _ = QFileDialog.getSaveFileName(self.dlg, "Save Report", "", "HTML Files (*.html)")
        if file_path:
            with open(file_path, "w", encoding="utf-8") as file:
                file.write(html_content)
           # QMessageBox.information(self.dlg, "Export Successful", "RG Validation Report exported successfully!")

    # Sev_Validation tab
    def browseBADFile(self):
        file_path, _ = QFileDialog.getOpenFileName(self.dlg, "Select BAD Raster File", "", "Raster Files (*.tif *.tiff)")
        if file_path:
            self.dlg.lineEditBADFile.setText(file_path)

    def browseRefFile(self):
        file_path, _ = QFileDialog.getOpenFileName(self.dlg, "Select Ref Raster File", "", "Raster Files (*.tif *.tiff)")
        if file_path:
            self.dlg.lineEditRefFile.setText(file_path)

    def ComputeValidation(self):
        self.show_progress_bar("Computing Features")
        self.update_progress(5)
        start = time.process_time()

        bad_raster_path = self.dlg.lineEditBADFile.text()
        ref_raster_path = self.dlg.lineEditRefFile.text()

        if not os.path.exists(bad_raster_path) or not os.path.exists(ref_raster_path):
            QMessageBox.warning(self.dlg, "Missing Input", "Please select both BAD and Ref raster files.")
            return

        try:
            bad_raster_ds = gdal.Open(bad_raster_path)
            ref_raster_ds = gdal.Open(ref_raster_path)

            if not bad_raster_ds or not ref_raster_ds:
                QMessageBox.critical(self.dlg, "Error", "Failed to load raster files.")
                return

            width = bad_raster_ds.RasterXSize
            height = bad_raster_ds.RasterYSize

            bad_band = bad_raster_ds.GetRasterBand(1)
            ref_band = ref_raster_ds.GetRasterBand(1)
            bad_data = bad_band.ReadAsArray(0, 0, width, height)
            ref_data = ref_band.ReadAsArray(0, 0, width, height)

            bad_classification = {
                0: 'Unburned', 1: 'Enhanced Regrowth High', 2: 'Enhanced Regrowth Low',
                3: 'Unburned', 4: 'Low Severity', 5: 'Low Severity',
                6: 'High Severity', 7: 'High Severity', 99: 'Masked'
            }

            ref_classification = {
                1: 'High Severity', 2: 'High Severity', 3: 'High Severity',
                4: 'Medium Severity', 5: 'Low Severity', 6: 'Unburned',
                7: 'Masked', 8: 'Low Severity'
            }

            bad_index = {'Unburned': 0, 'Low Severity': 1, 'High Severity': 2, 'Masked': 3}
            ref_index = {'Unburned': 0, 'Low Severity': 1, 'High Severity': 2, 'Masked': 3}

            conf_matrix = [[0] * 4 for _ in range(4)]

            for i in range(height):
                for j in range(width):
                    bad_val = bad_data[i][j]
                    ref_val = ref_data[i][j]
                    bad_class = bad_classification.get(bad_val, 'Unknown')
                    ref_class = ref_classification.get(ref_val, 'Unknown')
                    if bad_class in bad_index and ref_class in ref_index:
                        conf_matrix[bad_index[bad_class]][ref_index[ref_class]] += 1

            self.dlg.tableWidgetConfusionMatrix.setRowCount(4)
            self.dlg.tableWidgetConfusionMatrix.setColumnCount(4)
            for row in range(4):
                for col in range(4):
                    self.dlg.tableWidgetConfusionMatrix.setItem(row, col, QTableWidgetItem(str(conf_matrix[row][col])))

            metrics_output = ""
            for idx, class_name in enumerate(['Unburned', 'Low Severity', 'High Severity', 'Masked']):
                row_sum = sum(conf_matrix[idx])
                col_sum = sum(conf_matrix[r][idx] for r in range(4))
                correct = conf_matrix[idx][idx]
                false_positive = row_sum - correct
                false_negative = col_sum - correct

                CE = (false_positive / row_sum * 100) if row_sum != 0 else 0
                OE = (false_negative / col_sum * 100) if col_sum != 0 else 0
                DC = (2 * correct / (2 * correct + false_positive + false_negative) * 100) if (2 * correct + false_positive + false_negative) != 0 else 0
                bias = false_positive - false_negative
                relative_bias = (bias / col_sum) if col_sum != 0 else 0

                metrics_output += f"""
                Class: {class_name}
                -------------------------
                Commission Error (CE): {CE:.2f}%
                Omission Error (OE): {OE:.2f}%
                Dice Coefficient (DC): {DC:.2f}%
                Relative Bias: {relative_bias:.4f}\n"""

            self.dlg.textEditMetrics.setPlainText(metrics_output)

        except Exception as e:
            QMessageBox.critical(self.dlg, "Error", f"Validation failed: {e}")

        self.update_progress(100)
        self.hide_progress_bar()
        end = time.process_time()
        print("Process end")
        print('Computational time Sev_Validation [s]: ',(end - start),"start=", start,"end=",end) 
        print('\n') 
        self.window = QtWidgets.QDialog()
        self.ui = Ui_Message()
        self.ui.setupUi(self.window)
        self.window.show()
    def export_sev_validation_report(self):

        # Prompt user to choose a file save location
        file_path, _ = QFileDialog.getSaveFileName(self.dlg, "Save Report", "", "HTML Files (*.html)")
        if not file_path:
            return

        # Get confusion matrix and metrics from the UI
        matrix_html = "<table border='1' cellpadding='4' cellspacing='0'>"
        matrix_html += "<tr><th>BAD↓ / REF→</th><th>Unburned</th><th>Low Severity</th><th>High Severity</th><th>Masked</th></tr>"

        row_labels = ['Unburned', 'Low Severity', 'High Severity', 'Masked']
        for row in range(4):
            matrix_html += f"<tr><td><b>{row_labels[row]}</b></td>"
            for col in range(4):
                item = self.dlg.tableWidgetConfusionMatrix.item(row, col)
                val = item.text() if item else "0"
                matrix_html += f"<td>{val}</td>"
            matrix_html += "</tr>"
        matrix_html += "</table>"

        metrics_text = self.dlg.textEditMetrics.toPlainText().replace('\n', '<br>')

        # Exporting the validation results
        html_content = f"""
        <html>
        <head><title>Burn Severity Validation Report</title></head>
        <body>
            <h1>🔥 Burn Severity Validation Report</h1>
            <h2>Confusion Matrix</h2>
            {matrix_html}
            <br><h2>Error Metrics</h2>
            <p>{metrics_text}</p>
        </body>
        </html>
        """

        try:
            with open(file_path, 'w', encoding='utf-8') as f:
                f.write(html_content)
            QMessageBox.information(self.dlg, "Export Successful", f"Validation report exported to:\n{file_path}")
        except Exception as e:
            QMessageBox.critical(self.dlg, "Export Failed", f"Failed to save report: {e}")





###################################################################################################
###################################################################################################
###################################################################################################

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = BADDialog()

            self.dlg.progressBar.setVisible(False)  
            self.dlg.progressBar.setValue(0)

            self.populate_mask_classes()
            self.dlg.btnBrowsePreFire.clicked.connect(self.select_pre_fire_raster)
            self.dlg.btnBrowsePostFire.clicked.connect(self.select_post_fire_raster)
            self.dlg.btnBrowseOutputPreFire.clicked.connect(self.select_output_pre_fire)
            self.dlg.btnBrowseOutputPostFire.clicked.connect(self.select_output_post_fire)
            self.dlg.btnRunMasking.clicked.connect(self.run_masking)
            self.dlg.btnReset.clicked.connect(self.reset_fields)

            
            self.dlg.pushButton_input_reset.clicked.connect(self.reset_input_tab)
            self.dlg.pushButton_Features_D_reset.clicked.connect(self.reset_Features_D_tab)
            self.dlg.pushButton_Features_AP_reset.clicked.connect(self.reset_Features_AP_tab)
            self.dlg.pushButton_Features_AD_reset.clicked.connect(self.reset_Features_AD_tab)
            self.dlg.pushButton_OWA_reset.clicked.connect(self.reset_OWA_tab)
            self.dlg.pushButton_RG_reset.clicked.connect(self.reset_RG_tab)
            self.dlg.pushButton_Severity_reset.clicked.connect(self.reset_Severity_tab)
            
            #self.dlg.pushButton_Error.clicked.connect(self.test)
            self.dlg.toolButton_Feature.clicked.connect(self.select_output_file_Feature)
            self.dlg.toolButton_MD.clicked.connect(self.select_output_file_MD)

            self.dlg.toolButton_OWA_AND.clicked.connect(self.select_output_file_AND)
            self.dlg.toolButton_OWA_almostAND.clicked.connect(self.select_output_file_almostAND)
            self.dlg.toolButton_OWA_AVERAGE.clicked.connect(self.select_output_file_AVERAGE)
            self.dlg.toolButton_OWA_almostOR.clicked.connect(self.select_output_file_almostOR)
            self.dlg.toolButton_OWA_OR.clicked.connect(self.select_output_file_OR)
            self.dlg.toolButton_RG_result.clicked.connect(self.select_output_file_RG)
            self.dlg.toolButton_Severity.clicked.connect(self.select_output_file_Severity)
            self.dlg.toolButton_CombinedSeverity.clicked.connect(self.select_output_file_CombinedSeverity)

            self.dlg.pushButton_Feature_run.clicked.connect(self.ComputeFeature)
            self.dlg.pushButton_MD_run.clicked.connect(self.ComputeMD)
            self.dlg.pushButton_OWA_run.clicked.connect(self.ComputeOWA)          
            self.dlg.pushButton_RG_run.clicked.connect(self.ComputeRG)
            
            self.dlg.pushButton_Severity_run.clicked.connect(self.ComputeSeverity)
            self.dlg.pushButton_RGSeverity_run.clicked.connect(self.ComputeRGSeverity)
            self.dlg.buttonBrowseRGFile.clicked.connect(self.browseRGFile)
            self.dlg.buttonBrowseReferenceFile.clicked.connect(self.browseReferenceFile)
            self.dlg.buttonRunRGValidation.clicked.connect(self.ComputeRGValidation)
            self.dlg.GenerateAgreementMap.clicked.connect(self.generateAgreementMap)
            self.dlg.buttonExportRGReport.clicked.connect(self.exportRGReport)


            self.dlg.buttonBrowseBADFile.clicked.connect(self.browseBADFile)
            self.dlg.buttonBrowseRefFile.clicked.connect(self.browseRefFile)
            self.dlg.buttonRunValidation.clicked.connect(self.ComputeValidation)
            self.dlg.buttonExportSEVReport.clicked.connect(self.export_sev_validation_report)

            

        
        #Fetch the currently loaded layers
        layers = QgsProject.instance().layerTreeRoot().children()
        
        #Clear the contents of the comboBox from previous runs
        self.dlg.comboBox_prefire.clear()
        self.dlg.comboBox_postfire.clear()

        self.dlg.comboBox_RG_seed.clear()
        self.dlg.comboBox_RG_grow.clear()

        
        #populate the comboBox with names of all the loaded layers
        self.dlg.comboBox_prefire.addItems(['Select a Layer'])
        self.dlg.comboBox_postfire.addItems(['Select a Layer'])

        self.dlg.comboBox_prefire.addItems([layer.name() for layer in layers])
        self.dlg.comboBox_postfire.addItems([layer.name() for layer in layers])
      
        self.dlg.comboBox_RG_seed.addItems(['Select a Layer'])
        self.dlg.comboBox_RG_grow.addItems(['Select a Layer'])
        self.dlg.comboBox_RG_seed.addItems([layer.name() for layer in layers])
        self.dlg.comboBox_RG_grow.addItems([layer.name() for layer in layers])
               

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            
            self.ComputeFeature()
            self.ComputeMD()
            self.ComputeOWA()
            self.ComputeRG()
            self.ComputeSeverity()
            self.ComputeRGSeverity()
            self.window = QtWidgets.QDialog()
            self.ui = Ui_Message()
            self.ui.setupUi(self.window)
            self.window.show()
           