# -*- coding: utf-8 -*-
"""
/***************************************************************************
 BAD
                                 A QGIS plugin
 BAD_Burned Area Detector
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-01-24
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Thomas Martinoli
        email                : th.martinoli96@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""


from osgeo import gdal
import numpy as np
# Initialize Qt resources from file resources.py
from .resources import *


class ReadingData:
    def __init__(self,First_path,Second_path):

        First_raster = gdal.Open(First_path, gdal.GA_ReadOnly) 
        Second_raster = gdal.Open(Second_path, gdal.GA_ReadOnly) 
        # Note GetRasterBand() takes band no. starting from 1 not 0

        First_matrix=First_raster.ReadAsArray()
        Second_matrix=Second_raster.ReadAsArray()

        self.FirstMatrix=First_matrix.astype(float)
        self.SecondMatrix=Second_matrix.astype(float)

        #self.Delta_matrix=S-F
      
        self.Bands=First_raster.RasterCount
        self.gt = First_raster.GetGeoTransform()
        self.proj= First_raster.GetProjection()

class MembershipFunction:
    def __init__(self,Matrix,K,x):
        
        self.MD=1/(1+np.exp(-K*(Matrix/10000-x)))
        
class OrderedWeigthAverage:
    def __init__(self,index,FinalBandMatix):
        
        Row=FinalBandMatix.shape[1]
        Column=FinalBandMatix.shape[2]
        self.Integrated_matrix=np.empty([Row,Column])

        #AND
        if index==1:
            self.filename="OWA_AND.tif"
            for i in range (Row):
                for j in range (Column):
                    vector=FinalBandMatix[:,i,j]
                    if (np.isnan(vector).any()):
                        value=np.nan
                    else:
                        value=min(vector)
                    self.Integrated_matrix[i,j]=value
            self.Integrated_matrix=np.nan_to_num(self.Integrated_matrix,nan=999)

        #almost AND
        if index==2:
            self.filename="OWA_almostAND.tif"
            for i in range (Row):
                for j in range (Column):
                    vector=FinalBandMatix[:,i,j]
                    if (np.isnan(vector).any()):
                        value=np.nan
                    else:
                        value=(np.sort(vector)[-1]+np.sort(vector)[-2])/2
                    self.Integrated_matrix[i,j]=value
            self.Integrated_matrix=np.nan_to_num(self.Integrated_matrix,nan=999)

        #AVERAGE
        if index==3:
            self.filename="OWA_AVERAGE.tif"
            for i in range (Row):
                for j in range (Column):
                    vector=FinalBandMatix[:,i,j]
                    if (np.isnan(vector).any()):
                        value=np.nan
                    else:
                        value=np.mean(vector)
                    self.Integrated_matrix[i,j]=value
            self.Integrated_matrix=np.nan_to_num(self.Integrated_matrix,nan=999)

        #almost OR:
        if index==4:
            self.filename="OWA_almostOR.tif"
            for i in range (Row):
                for j in range (Column):
                    vector=FinalBandMatix[:,i,j]
                    if (np.isnan(vector).any()):
                        value=np.nan
                    else:
                        value=(np.sort(vector)[0]+np.sort(vector)[1])/2
                    self.Integrated_matrix[i,j]=value
            self.Integrated_matrix=np.nan_to_num(self.Integrated_matrix,nan=999)
        #OR
        if index==5:      
            self.filename="OWA_OR.tif" 
            for i in range (Row):
                for j in range (Column):
                    vector=FinalBandMatix[:,i,j]
                    if (np.isnan(vector).any()):
                        value=np.nan
                    else:
                        value=max(vector)
                    self.Integrated_matrix[i,j]=value
            self.Integrated_matrix=np.nan_to_num(self.Integrated_matrix,nan=999)

class WriteLayer:
    def __init__(self,index,path,Matrix,NameBands,Nband,Xsize,Ysize,filename,gt,proj):
    
        if index==0:
            # se indice zero significa che l'utente non ha specificato nulla per 
            # cui devo trasformare il path per salvare il file in formato .tif
            array_path=path.split('/')
            array_path[-1]=filename
            splitter="/"
            self.output_path=splitter.join(array_path)
        else:
            self.output_path=path

        driver = gdal.GetDriverByName("GTiff")
        driver.Register()
        outds = driver.Create(self.output_path, xsize=Xsize,ysize=Ysize,bands=Nband, eType= gdal.GDT_Float32)
        outds.SetGeoTransform(gt)
        outds.SetProjection(proj)
        if Nband==1:
            outband = outds.GetRasterBand(Nband)
            outband.WriteArray(Matrix)
            outband.SetDescription(NameBands)
            outband.FlushCache()
            outband= None
        else:
            for i in range(Nband):
                outband = outds.GetRasterBand(i+1)
                outband.WriteArray(Matrix[i])
                outband.SetDescription(NameBands[i])
                outband.FlushCache()
                outband= None
        outds = None

class RegionGrowing:
    def __init__(self,Seed_threshold,Grow_threshold,Seed_matrix,Grow_matrix):

        Mask=np.where(Seed_matrix==999,999,0)     
        Seed_binary = np.where(Seed_matrix<Seed_threshold,0,1)+Mask
        Grow_binary = np.where(Grow_matrix<Grow_threshold,0,1)+Mask
        
        self.Raster=np.array([Seed_binary,Grow_binary])

        RasterPP=self.Raster.copy()

        sizeRow=RasterPP[0].shape[0]
        sizeColumn=RasterPP[0].shape[1]
        
        M=0
        N=np.count_nonzero(RasterPP[0])
        i=0
    
        while N!=M:
            M=N
            print('Iteration:',i,', Number of seeds:',N)
            i=i+1
            for j in range(sizeRow):
                for k in range(sizeColumn):
                                    
                    #insertion of the neighbors that are not considered yet
                    
                    if RasterPP[0,j,k]==1:
                                            
                        # neighbor examination                
                        
                        # above-left   
                        if j>0 and k>0 and RasterPP[0,j-1,k-1]==0 and RasterPP[1,j-1,k-1]==1:
                            RasterPP[0,j-1,k-1]=1
                            
                        
                        # above
                        if j>0 and RasterPP[0,j-1,k]==0 and RasterPP[1,j-1,k]==1:
                            RasterPP[0,j-1,k]=1
                            
                        
                        #above-right
                        if j>0 and k<=sizeColumn-2 and RasterPP[0,j-1,k+1]==0 and RasterPP[1,j-1,k+1]==1:
                            RasterPP[0,j-1,k+1]=1
                            
                            
                        #left
                        if k>0 and RasterPP[0,j,k-1]==0 and RasterPP[1,j,k-1]==1:
                            RasterPP[0,j,k-1]=1
                            
                        #right
                        if k<=sizeColumn-2 and RasterPP[0,j,k+1]==0 and RasterPP[1,j,k+1]==1:
                            RasterPP[0,j,k+1]=1
                            
                        
                        #below-left    
                        if j<=sizeRow-2 and k>0 and RasterPP[0,j+1,k-1]==0 and RasterPP[1,j+1,k-1]==1:
                            RasterPP[0,j+1,k-1]=1
                            
                        
                        #below    
                        if j<=sizeRow-2 and RasterPP[0,j+1,k]==0 and RasterPP[1,j+1,k]==1:
                            RasterPP[0,j+1,k]=1
                            
                        
                        #below-right    
                        if j<=sizeRow-2 and k<=sizeColumn-2 and RasterPP[0,j+1,k+1]==0 and RasterPP[1,j+1,k+1]==1:
                            RasterPP[0,j+1,k+1]=1
                                                                                          
            #condition that blocks the while
            N=np.count_nonzero(RasterPP[0])
            
        self.Result_matrix=RasterPP[0]

class Classification:
    def __init__(self,Matrix,LowerLevelList,UpperLevelList):

        Matrix=np.round(Matrix,3)
        M_ERH = np.where((Matrix>=LowerLevelList[0])&(Matrix<=UpperLevelList[0]),1,0)
        M_ERL = np.where((Matrix>=LowerLevelList[1])&(Matrix<=UpperLevelList[1]),2,0)
        M_U = np.where((Matrix>=LowerLevelList[2])&(Matrix<=UpperLevelList[2]),3,0)
        M_L = np.where((Matrix>=LowerLevelList[3])&(Matrix<=UpperLevelList[3]),4,0)
        M_ML = np.where((Matrix>=LowerLevelList[4])&(Matrix<=UpperLevelList[4]),5,0)
        M_MH = np.where((Matrix>=LowerLevelList[5])&(Matrix<=UpperLevelList[5]),6,0)
        M_H = np.where((Matrix>=LowerLevelList[6])&(Matrix<=UpperLevelList[6]),7,0)
        Matrix_class = M_ERH + M_ERL + M_U + M_L + M_ML + M_MH + M_H
        self.Final_Matrix = np.where(Matrix_class==0,99,Matrix_class)