# -*- coding: utf-8 -*-
"""
/***************************************************************************
 AwaP
                                 A QGIS plugin
 This plugin takes in outlines of building blocks and the boundaray of area of interest, and calculates area-weighted average parameter (AwaP).
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2018-05-05
        git sha              : $Format:%H$
        copyright            : (C) 2018 by Ivan Majic
        email                : imajicos@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtCore import (QSettings, QTranslator, qVersion, QCoreApplication,
                          QObject, QThread, QThreadPool, QRunnable, pyqtRemoveInputHook, pyqtSignal,
                          QVariant, Qt)
from PyQt5.QtGui import QIcon, QColor, QBrush
from PyQt5.QtWidgets import QAction, QTableWidgetItem

from qgis.core import *
from qgis.gui import *

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .awap_dialog import AwaPDialog
import os.path
import processing
from osgeo import ogr, osr
from processing.tools.general import execAlgorithmDialog
from .awap_worker import AwaPWorker

class AwaP:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'AwaP_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

        # Create the dialog (after translation) and keep reference
        self.dlg = AwaPDialog()

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&AwaP')
        # TODO: We are going to let the user set this up in a future iteration
        self.toolbar = self.iface.addToolBar(u'AwaP')
        self.toolbar.setObjectName(u'AwaP')

        # this is where I define the threadpool for the threaded running of the plugin
        self.threadpool = QThreadPool()


##############################################################################
        # Initially disable by awap coloring option - only works with multi-boundary
        # Check if multiple boundary option is selected
        if self.dlg.radioButton_2.isChecked():
            # If yes, enable by awap coloring
            self.dlg.comboBox.model().item(2).setEnabled(True)
        else:
            # If not, disable by awap coloring
            self.dlg.comboBox.model().item(2).setEnabled(False)

        # this is where i define that qgsmaplayercombobox should only
        # list line and polygon layers
        vector_layers_filter = QgsMapLayerProxyModel.LineLayer | QgsMapLayerProxyModel.PolygonLayer
        self.dlg.mMapLayerComboBox.setFilters(vector_layers_filter)
        self.dlg.mMapLayerComboBox_2.setFilters(vector_layers_filter)
        self.dlg.checkBox_4.setCheckState(QtCore.Qt.Checked)
        self.dlg.checkBox_3.setCheckState(QtCore.Qt.Checked)

        # this is my line where I define that checkbox click should call a
        # function
        self.dlg.checkBox.stateChanged.connect(self.checkbox_on_change)
        self.dlg.checkBox_2.stateChanged.connect(self.checkbox2_on_change)
        self.dlg.checkBox_3.stateChanged.connect(self.checkbox3_on_change)
        self.dlg.checkBox_4.stateChanged.connect(self.checkbox4_on_change)
        self.dlg.checkBox_5.stateChanged.connect(self.checkbox5_on_change)
        self.dlg.pushButton.clicked.connect(self.pushbutton_on_press)

        # row manipulation in the style table:
        self.dlg.pushButton_2.clicked.connect(self.add_row)
        self.dlg.pushButton_3.clicked.connect(self.delete_row)
        self.dlg.pushButton_4.clicked.connect(self.move_row_up)
        self.dlg.pushButton_5.clicked.connect(self.move_row_down)
        self.dlg.pushButton_6.clicked.connect(self.open_color_dialog_button)
        self.dlg.tableWidget.itemClicked.connect(self.open_color_dialog)
        self.dlg.tableWidget.itemChanged.connect(self.check_number_value)

        self.dlg.button_box.accepted.connect(self.showRunning)
        self.dlg.button_box.accepted.connect(self.execute)
        self.dlg.button_box.rejected.connect(self.close_dialog)

        self.dlg.radioButton_2.toggled.connect(self.enable_by_awap_coloring)
    
    def enable_by_awap_coloring(self):
        # Check if multiple boundary option is selected
        if self.dlg.radioButton_2.isChecked():
            # If yes, enable by awap coloring
            self.dlg.comboBox.model().item(2).setEnabled(True)
        else:
            # If not, disable by awap coloring
            self.dlg.comboBox.model().item(2).setEnabled(False)
            # Also change the selected coloring method to by perimeter
            # In case that by awap was selected before disabling
            self.dlg.comboBox.setCurrentIndex(0)


    

    def check_number_value(self, item: QTableWidgetItem):
        """A method that makes sure that the entered value
        can be turned to float. If not, change the current
        value to 0."""
        if item is None:
            self.log('Item (%s, %s) is None' %(item.row(), item.column()))
        elif item.column() < 2:
            try:
                float(item.text())
            except ValueError as e:
                self.log('Invalid value "%s" entered, value changed to 0.' %item.text())
                item.setText('0')
            finally:
                if None not in (self.dlg.tableWidget.item(item.row(), 0), self.dlg.tableWidget.item(item.row(), 1), self.dlg.tableWidget.item(item.row(), 2)) and ' - ' in self.dlg.tableWidget.item(item.row(), 2).text():
                    legend = self.dlg.tableWidget.item(item.row(), 2).text()
                    legend_split = legend.split(' - ')
                    legend_split[item.column()] = item.text()
                    legend = ' - '.join(legend_split)
                    self.dlg.tableWidget.item(item.row(), 2).setText(legend)
                # else:
                #     legend_low = self.dlg.tableWidget.item(item.row(), 0).text()
                #     legend_high = self.dlg.tableWidget.item(item.row(), 1).text()
                #     legend = ' - '.join([legend_low, legend_high])
                #     self.dlg.tableWidget.setItem(item.row(), 2, QTableWidgetItem().setText(legend))


    def open_color_dialog_button(self, signal: bool):
        """A method that creates a color dialog window and shows it
        when the user presses the 'Color' button. At the confirmation
        of the color dialog, set the color in the current row."""
        row = self.dlg.tableWidget.currentRow()
        if row >= 0:
            initial_color = self.dlg.tableWidget.item(row, 3).background().color()
            color = QgsColorDialog.getColor(
                initialColor=initial_color,
                parent=self.dlg.tableWidget,
                allowOpacity=False
            )
            if color.isValid():
                self.dlg.tableWidget.item(row,3).setBackground(color)

    def open_color_dialog(self, item: QTableWidgetItem):
        """A method that creates a color dialog window and shows it
        when the user presses the 'Color' button. At the confirmation
        of the color dialog, set the color in the current row."""
        if item.column() == 3:
            initial_color = item.background().color()
            color = QgsColorDialog.getColor(
                initialColor=initial_color,
                parent=self.dlg.tableWidget,
                allowOpacity=False
            )
            self.log(str(color.getRgb()))
            if color.isValid():
                item.setBackground(color)

    def add_row(self, signal):
        """A method that adds a row to the end of the table that defines
        the output layer styling in the GUI. When the 'Add row' button is
        pressed, a new row is added to the bottom of the tableWidget."""
        row = self.dlg.tableWidget.currentRow()
        self.log(str(row))
        self.dlg.tableWidget.insertRow(row+1)
        for col in range(0,self.dlg.tableWidget.columnCount()):
            self.dlg.tableWidget.setItem(row+1,col,QTableWidgetItem())
        self.dlg.tableWidget.item(row+1,3).setFlags(Qt.ItemIsEnabled)

        if self.dlg.tableWidget.item(row,3) is not None:
            bground = self.dlg.tableWidget.item(row,3).background()
        else:
            bground = QBrush(QColor(255,255,255),1)
        self.dlg.tableWidget.item(row+1,0).setText('0')
        self.dlg.tableWidget.item(row+1,1).setText('0')
        self.dlg.tableWidget.item(row+1,2).setText('0 - 0')
        self.dlg.tableWidget.item(row+1,3).setBackground(bground)

        
    def delete_row(self, signal):
        """A method that removes the selected rows from the table.
        When the 'Delete row' button is pressed, this method removes
        all currently selected rows from the tableWidget."""
        self.dlg.tableWidget.removeRow(self.dlg.tableWidget.currentRow())

    def move_row_up(self, signal):    
        """A method that moves the selected row up 1 place."""
        row = self.dlg.tableWidget.currentRow()
        column = self.dlg.tableWidget.currentColumn()
        if row > 0:
            self.dlg.tableWidget.insertRow(row-1)
            for i in range(self.dlg.tableWidget.columnCount()):
               self.dlg.tableWidget.setItem(row-1,i,self.dlg.tableWidget.takeItem(row+1,i))
               self.dlg.tableWidget.setCurrentCell(row-1,column)
            self.dlg.tableWidget.removeRow(row+1)        

    def move_row_down(self, signal):
        """A method that moves the selected down up 1 place."""
        row = self.dlg.tableWidget.currentRow()
        column = self.dlg.tableWidget.currentColumn()
        if row >= 0 and row < self.dlg.tableWidget.rowCount()-1:
            self.dlg.tableWidget.insertRow(row + 2)
            for i in range(self.dlg.tableWidget.columnCount()):
               self.dlg.tableWidget.setItem(row+2,i,self.dlg.tableWidget.takeItem(row,i))
               self.dlg.tableWidget.setCurrentCell(row+2,column)
            self.dlg.tableWidget.removeRow(row)        


    def checkbox4_on_change(self, signal):
        """A method that disables other options for blocks intersecting
        boundary when checkBox4 is clicked.
        It takes in a dialog and a signal that says if the changed state
        is True of False as parameters. If True, the other cbox and a spinbox
        are disabled."""
        if signal:
            self.dlg.checkBox.setCheckState(QtCore.Qt.Unchecked)
            self.dlg.checkBox_2.setCheckState(QtCore.Qt.Unchecked)
        elif not self.dlg.checkBox.isChecked() and not self.dlg.checkBox_2.isChecked():
            self.dlg.checkBox_4.setCheckState(QtCore.Qt.Checked)


    def checkbox_on_change(self, signal):
        """A method that disables other options when checkBox is clicked.
        It takes in a dialog and a signal that says if the changed state
        is True of False as parameters. If True, the other cbox and a spinbox
        are disabled."""
        if signal:
            self.dlg.checkBox_2.setCheckState(QtCore.Qt.Unchecked)
            self.dlg.checkBox_4.setCheckState(QtCore.Qt.Unchecked)
        elif not self.dlg.checkBox_2.isChecked():
            self.dlg.checkBox_4.setCheckState(QtCore.Qt.Checked)

    def checkbox2_on_change(self, signal):
        """A method that disables other options when checkBox_2 is clicked.
        It takes in a dialog and a signal that says if the changed state
        is True of False as parameters. If True, the other cbox and a spinbox
        are disabled."""
        if signal:
            self.dlg.checkBox.setCheckState(QtCore.Qt.Unchecked)
            self.dlg.checkBox_4.setCheckState(QtCore.Qt.Unchecked)
        elif not self.dlg.checkBox.isChecked():
            self.dlg.checkBox_4.setCheckState(QtCore.Qt.Checked)

    def checkbox3_on_change(self, signal):
        """A method that disables other options when checkBox_3 is clicked.
        It takes in a dialog and a signal that says if the changed state
        is True of False as parameters. If True, the buffer distance spinbox
        is enabled, otherwise it's disabled."""
        if signal:
            self.dlg.checkBox_5.setCheckState(QtCore.Qt.Unchecked)
        elif not self.dlg.checkBox_5.isChecked():
            self.dlg.checkBox_3.setCheckState(QtCore.Qt.Checked)

    def checkbox5_on_change(self, signal):
        """A method that disables other options when checkBox_3 is clicked.
        It takes in a dialog and a signal that says if the changed state
        is True of False as parameters. If True, the buffer distance spinbox
        is enabled, otherwise it's disabled."""
        if signal:
            self.dlg.checkBox_3.setCheckState(QtCore.Qt.Unchecked)
        elif not self.dlg.checkBox_3.isChecked():
            self.dlg.checkBox_5.setCheckState(QtCore.Qt.Checked)

    def pushbutton_on_press(self, signal):
        """A method that opens a qgis:creategrid algorithm window with preset
        parameters so that users can create a grid of polygons to use as
        boundaries for AwaP calculation."""
        params = {
            'TYPE':2,
            'HSPACING':1000,
            'VSPACING':1000
        }
        results = execAlgorithmDialog('qgis:creategrid', params)
        if 'OUTPUT' in results.keys():
            # automatically set the plugin to use the multi-boundary option
            self.dlg.radioButton_2.setChecked(True)
            added_layer = QgsProject.instance().mapLayers()[results['OUTPUT']]
            added_layer.renderer().symbol().setColor(QColor(255,0,0,0))
            added_layer.triggerRepaint()
            self.iface.layerTreeView().refreshLayerSymbology(added_layer.id())

    def close_dialog(self):
        """Method for closing the plugin dialog when button cancel is
        pressed"""
        self.dlg.close()
    
    def showRunning(self):
        """Method that shows the label when the plugin is running to
        notify the user"""
        # self.dlg.label_9.setVisible(True)
        pass

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('AwaP', message)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
            parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/awap/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'AwaP'),
            callback=self.run,
            parent=self.
            iface.mainWindow())

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&AwaP'),
                action)
            self.iface.removeToolBarIcon(action)
        # remove the toolbar
        del self.toolbar

    def run(self):
        """Run method that performs all the real work"""
        # show the dialog
        self.dlg.show()

    def log(self, message: str):
        QgsMessageLog.logMessage(message, 'AwaP', level=Qgis.Info)

    def showLayer(self, layer, params):
        '''A method for showing layers on the map without any user
        defined custom styling options. Layers are rendered in the 
        stock red color.'''
        added_layer = QgsProject.instance().addMapLayer(layer)
        color = params.get('color')
        width = params.get('width')
        if added_layer is not None:
            if color:
                added_layer.renderer().symbol().setColor(QColor(color))
            if width:
                added_layer.renderer().symbol().setWidth(width)
            added_layer.triggerRepaint()
            self.iface.layerTreeView().refreshLayerSymbology(added_layer.id())
            self.log('Added layer "%s" with color: %s, width: %s to the map.' %(layer.sourceName(),color,width))
        else:
            self.log('Could not add the layer because it had 0 features (layer was None)!')

    def showStyledLayer(self, layer, colorby):
        '''A method for showing layers on the map, styled with the user defined
        colors through the plugin gui, and the user defined coloring options.'''
        added_layer = QgsProject.instance().addMapLayer(layer)
        if added_layer is not None:
            table = self.dlg.tableWidget
            range_list = []
            # iterate through the table with user defined colors and categories
            for row in range(0, table.rowCount()):
                # The "Lower value" column of the current row
                lowerbound = float(table.item(row,0).text())
                # The "Upper value" column of the current row
                upperbound = float(table.item(row,1).text())
                # The "Legend" column of the current row
                legend = table.item(row,2).text()
                # The "Color" column of the current row
                # Fetch the actual QgsColor object
                color = table.item(row,3).background().color()
                # Create a new QgsSymbol
                sym = QgsSymbol.defaultSymbol(layer.geometryType())
                # Give it a QgsColor fetched earlier from the current row
                sym.setColor(color)
                # Put the information about the row together into
                # a QgsRendererRange object
                rng = QgsRendererRange(lowerbound, upperbound, sym, legend)
                range_list.append(rng)
            # create a graduated renderer from the user defined color table
            renderer = QgsGraduatedSymbolRenderer(colorby, range_list)
            # convert it to rule based renderer that has the ability to define
            # an "ELSE" rule
            rule_based_renderer = QgsRuleBasedRenderer.convertFromRenderer(renderer)
            # create a QgsSymbol for the ELSE rule
            else_sym = QgsSymbol.defaultSymbol(layer.geometryType())
            # give it a color of the last row from the table
            color = table.item(table.rowCount()-1,3).background().color()
            else_sym.setColor(color)
            # create the ELSE rule
            else_rule = QgsRuleBasedRenderer.Rule(
                else_sym,
                label='else',
                elseRule=True)
            # append it to the rule based renderer
            rule_based_renderer.rootRule().appendChild(else_rule)
            # show the layer in the map with the rule based renderer
            added_layer.setRenderer(rule_based_renderer)
            added_layer.triggerRepaint()
            self.iface.layerTreeView().refreshLayerSymbology(added_layer.id())
            self.log('Added layer "%s" to the map.' %layer.sourceName())
        else:
            self.log('Could not add the layer because it had 0 features (layer was None)!')

    def update_task_number_label(self):
        active_tasks = QgsApplication.taskManager().activeTasks()
        awap_task_count = sum([1 for t in active_tasks if type(t)==AwaPWorker])
        if awap_task_count == 1:
            self.dlg.label_9.setText(
                'There is %s AwaP plugin task running in the background. Please wait!' %awap_task_count
            )
        elif awap_task_count == 0:
            self.dlg.label_9.setText('')
        elif awap_task_count > 1:
            self.dlg.label_9.setText(
                'There are %s AwaP plugin tasks running in the background. Please wait!' %awap_task_count
            )

    def delete_task_number_label(self):
       self.dlg.label_9.setText('')

    def execute(self):
        try:
            myworker = self.myworker = AwaPWorker(self, 'AwaP plugin')
            myworker.layerPrint.connect(self.showLayer)
            myworker.layerPrintStyled.connect(self.showStyledLayer)
            QgsApplication.taskManager().countActiveTasksChanged.connect(self.update_task_number_label)
            QgsApplication.taskManager().allTasksFinished.connect(self.delete_task_number_label)
            QgsApplication.taskManager().addTask(myworker)
        except Exception as e:
            self.log(str(e))