# -*- coding: utf-8 -*-
"""
/***************************************************************************
 AwaP
                                 A QGIS plugin
 This plugin takes in outlines of building blocks and the boundaray of area of interest, and calculates area-weighted average parameter (AwaP).
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2018-05-05
        git sha              : $Format:%H$
        copyright            : (C) 2018 by Ivan Majic
        email                : imajicos@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtCore import (QSettings, QTranslator, qVersion, QCoreApplication,
                          QObject, QThread, pyqtRemoveInputHook, pyqtSignal,
                          QVariant)
from PyQt5.QtGui import QIcon, QColor
from PyQt5.QtWidgets import QAction

from qgis.core import *
from qgis.gui import *

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .awap_dialog import AwaPDialog
import os.path
import processing
from osgeo import ogr, osr

class AwaP:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'AwaP_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

        # Create the dialog (after translation) and keep reference
        self.dlg = AwaPDialog()

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&AwaP')
        # TODO: We are going to let the user set this up in a future iteration
        self.toolbar = self.iface.addToolBar(u'AwaP')
        self.toolbar.setObjectName(u'AwaP')

##############################################################################
        # this is where i define that qgsmaplayercombobox should only
        # list line and polygon layers
        vector_layers_filter = QgsMapLayerProxyModel.Filter(8 | 16)
        self.dlg.mMapLayerComboBox.setFilters(vector_layers_filter)
        self.dlg.mMapLayerComboBox_2.setFilters(vector_layers_filter)
        self.dlg.checkBox_4.setCheckState(QtCore.Qt.Checked)
        self.dlg.checkBox_3.setCheckState(QtCore.Qt.Checked)

        # this is my line where I define that checkbox click should call a
        # function
        self.dlg.checkBox.stateChanged.connect(self.checkbox_on_change)
        self.dlg.checkBox_2.stateChanged.connect(self.checkbox2_on_change)
        self.dlg.checkBox_3.stateChanged.connect(self.checkbox3_on_change)
        self.dlg.checkBox_4.stateChanged.connect(self.checkbox4_on_change)
        self.dlg.checkBox_5.stateChanged.connect(self.checkbox5_on_change)


        self.dlg.button_box.accepted.connect(self.execute)
        self.dlg.button_box.rejected.connect(self.close_dialog)

    def checkbox4_on_change(self, signal):
        """A method that disables other options for blocks intersecting
        boundary when checkBox4 is clicked.
        It takes in a dialog and a signal that says if the changed state
        is True of False as parameters. If True, the other cbox and a spinbox
        are disabled."""
        if signal:
            self.dlg.checkBox.setCheckState(QtCore.Qt.Unchecked)
            self.dlg.checkBox_2.setCheckState(QtCore.Qt.Unchecked)
        elif not self.dlg.checkBox.isChecked() and not self.dlg.checkBox_2.isChecked():
            self.dlg.checkBox_4.setCheckState(QtCore.Qt.Checked)


    def checkbox_on_change(self, signal):
        """A method that disables other options when checkBox is clicked.
        It takes in a dialog and a signal that says if the changed state
        is True of False as parameters. If True, the other cbox and a spinbox
        are disabled."""
        if signal:
            self.dlg.checkBox_2.setCheckState(QtCore.Qt.Unchecked)
            self.dlg.checkBox_4.setCheckState(QtCore.Qt.Unchecked)
        elif not self.dlg.checkBox_2.isChecked():
            self.dlg.checkBox_4.setCheckState(QtCore.Qt.Checked)

    def checkbox2_on_change(self, signal):
        """A method that disables other options when checkBox_2 is clicked.
        It takes in a dialog and a signal that says if the changed state
        is True of False as parameters. If True, the other cbox and a spinbox
        are disabled."""
        if signal:
            self.dlg.checkBox.setCheckState(QtCore.Qt.Unchecked)
            self.dlg.checkBox_4.setCheckState(QtCore.Qt.Unchecked)
        elif not self.dlg.checkBox.isChecked():
            self.dlg.checkBox_4.setCheckState(QtCore.Qt.Checked)

    def checkbox3_on_change(self, signal):
        """A method that disables other options when checkBox_3 is clicked.
        It takes in a dialog and a signal that says if the changed state
        is True of False as parameters. If True, the buffer distance spinbox
        is enabled, otherwise it's disabled."""
        if signal:
            self.dlg.checkBox_5.setCheckState(QtCore.Qt.Unchecked)
        elif not self.dlg.checkBox_5.isChecked():
            self.dlg.checkBox_3.setCheckState(QtCore.Qt.Checked)

    def checkbox5_on_change(self, signal):
        """A method that disables other options when checkBox_3 is clicked.
        It takes in a dialog and a signal that says if the changed state
        is True of False as parameters. If True, the buffer distance spinbox
        is enabled, otherwise it's disabled."""
        if signal:
            self.dlg.checkBox_3.setCheckState(QtCore.Qt.Unchecked)
        elif not self.dlg.checkBox_3.isChecked():
            self.dlg.checkBox_5.setCheckState(QtCore.Qt.Checked)

    def close_dialog(self):
        """Method for closing the plugin dialog when button cancel is
        pressed"""
        self.dlg.close()

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('AwaP', message)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
            parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/awap/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'AwaP'),
            callback=self.run,
            parent=self.
            iface.mainWindow())

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&AwaP'),
                action)
            self.iface.removeToolBarIcon(action)
        # remove the toolbar
        del self.toolbar

    def run(self):
        """Run method that performs all the real work"""
        # show the dialog
        self.dlg.show()

    def log(self, message: str):
        QgsMessageLog.logMessage(message, 'AwaP', level=Qgis.Info)

    def showLayer(self, layer, params):
        added_layer = QgsProject.instance().addMapLayer(layer)
        color = params.get('color')
        width = params.get('width')
        if color:
            added_layer.renderer().symbol().setColor(QColor(color))
        if width:
            added_layer.renderer().symbol().setWidth(width)
        added_layer.triggerRepaint()
        self.iface.layerTreeView().refreshLayerSymbology(added_layer.id())
        self.log('Added layer "%s" with color: %s, width: %s to the map.' %(layer.sourceName(),color,width))

    def execute(self):
        """This is where I execute all my code - the real plugin that does the
        work."""

        self.log('AWAP PLUGIN STARTED')

        # abort parameter for stopping function in loop execution
        self.abort = False
        self.debug = False

        # THIS IS WHERE I GET THE PARAMETERS FROM THE PLUGIN DIALOG
        self.blocks_layer = self.dlg.mMapLayerComboBox.currentLayer()
        self.log('blocks_layer = %s' %self.blocks_layer.sourceName())

        self.boundary_layer = self.dlg.mMapLayerComboBox_2.currentLayer()
        self.log('boundary_layer = %s' %self.boundary_layer.sourceName())

        self.deadend_solution = self.dlg.checkBox_3.checkState()
        self.log('deadend solution enabled: %s' %self.deadend_solution)

        self.buffering_distance = self.dlg.mQgsDoubleSpinBox.value()/2
        if self.deadend_solution:
            self.log('buffering distance: %s' %self.buffering_distance)

        self.always_in = self.dlg.checkBox.checkState()
        self.always_out = self.dlg.checkBox_2.checkState()
        self.percent_in = self.dlg.mQgsSpinBox.value()

        self.canvas = self.iface.mapCanvas()
        self.project_crs = self.canvas.mapSettings().destinationCrs().authid()
        self.log('The plugin is working on the project CRS: %s' %self.project_crs)

        # Preliminary fix the blocks layer
        self.blocks_layer = processing.run(
            'qgis:fixgeometries',
            {
                'INPUT': self.blocks_layer,
                'OUTPUT': 'memory:',
            }
        )['OUTPUT']

        # REPROJECT both boundary and sp layers
        self.blocks_layer = processing.run(
            'qgis:reprojectlayer',
            {
                'INPUT': self.blocks_layer,
                'TARGET_CRS': self.project_crs,
                'OUTPUT': 'memory:',
            }
        )['OUTPUT']

        self.boundary_layer = processing.run(
            'qgis:reprojectlayer',
            {
                'INPUT': self.boundary_layer,
                'TARGET_CRS': self.project_crs,
                'OUTPUT': 'memory:boundary',
            }
        )['OUTPUT']

        # first check if the boundary layer == lines
        if self.boundary_layer.geometryType() == 1:
            self.boundary_layer = processing.run(
                'qgis:linestopolygons',
                {
                    'INPUT': self.boundary_layer,
                    'OUTPUT': 'memory:boundary',
                }
            )['OUTPUT']

        # this is where I need to select from the blocks layer only those features which intersect with the boundary
        self.blocks_layer = processing.run(
            'qgis:extractbylocation',
            {
                'INPUT' : self.blocks_layer,
                'PREDICATE' : [0],
                'INTERSECT' : self.boundary_layer,
                'OUTPUT' : 'memory:',
            }
        )['OUTPUT']

###################################################################
####### HANDLING THE BLOCKS LAYER

        # check if the blocks layer == lines
        if self.blocks_layer.geometryType() == 1:
            self.blocks_layer = processing.run(
                'qgis:linestopolygons',
                {
                    'INPUT': self.blocks_layer,
                    'OUTPUT': 'memory:',
                }
            )['OUTPUT']

        # dissolve the created polygons in order to make touching polyigons
        # into one block
        pathdissolve = processing.run(
            'qgis:dissolve',
            {
                'INPUT':self.blocks_layer,
                'OUTPUT': 'memory:dissolve',
            }
        )['OUTPUT']

        # convert dissolve result from multipart to singleparts
        self.blocks_layer = processing.run(
            'qgis:multiparttosingleparts',
            {
                'INPUT': pathdissolve,
                'OUTPUT': 'memory:singleparts',
            }
        )['OUTPUT']

        # see if the deadend solution has been selected when the plugin was run
        # if true, run the whole buffering solution for removing deadends from
        # the results
        if self.deadend_solution:
            # first I need to buffer out the blocks by the given distance
            # amount
            buffer_out_layer = processing.run(
                'qgis:buffer',
                {
                    'INPUT' : self.blocks_layer,
                    'END_CAP_STYLE' : 1,
                    'OUTPUT' : 'memory:bufferout',
                    'SEGMENTS' : 90,
                    'DISTANCE' : self.buffering_distance,
                    'JOIN_STYLE' : 0,
                    'MITER_LIMIT': 2,
                    'DISSOLVE' : False,
                }
            )['OUTPUT']

            # # finally, fill in any wholes that are left in the blocks
            # buffer_out_layer = processing.run(
            #     'qgis:deleteholes',
            #     {
            #         'INPUT' : buffer_out_layer,
            #         'MIN_AREA' : 0,
            #         'OUTPUT' : 'memory:deleteholes_buffer',
            #     }
            # )['OUTPUT']

            # buffer_out_layer = processing.run(
            #     'qgis:fixgeometries',
            #     {
            #         'INPUT': buffer_out_layer,
            #         'OUTPUT': 'memory:',
            #     }
            # )['OUTPUT']

            # then I need to buffer back in by the same distance amount
            buffer_in_layer = processing.run(
                'qgis:buffer',
                {
                    'INPUT' : buffer_out_layer,
                    'END_CAP_STYLE' : 1,
                    'OUTPUT' : 'memory:bufferin',
                    'SEGMENTS' : 90,
                    'DISTANCE' : -self.buffering_distance,
                    'JOIN_STYLE' : 0,
                    'MITER_LIMIT': 2,
                    'DISSOLVE' : False,
                }
            )['OUTPUT']

            self.blocks_layer = buffer_in_layer

        # finally, fill in any wholes that are left in the blocks
        self.blocks_layer = processing.run(
            'qgis:deleteholes',
            {
                'INPUT' : self.blocks_layer,
                'MIN_AREA' : 0,
                'OUTPUT' : 'memory:deleteholes',
            }
        )['OUTPUT']


        self.final_blocks_layer =  QgsVectorLayer('Polygon?crs='+self.project_crs, 'IC_blocks' , "memory")

        # get the data provider of the blocks layer
        provider = self.final_blocks_layer.dataProvider()

        # Create attribute fields to hold area, and parimeter values
        provider.addAttributes(
            [
                QgsField('awap_id', QVariant.Int),
                QgsField('Area', QVariant.Double),
                QgsField('Perimeter', QVariant.Double),
                QgsField('AwaP', QVariant.Double)
            ]
        )

        # Tell vector layer to update fields in order to get the new layers
        # from data provider
        self.final_blocks_layer.updateFields()

        # AwaP is calculated as sum(Perimeter x Area) / sum(Area)
        # keep track of both numerator and denominator of this equation
        numerator_sumPxA = 0
        denominator_sumA = 0

        # Now I need to fetch column numbers of these new attributes for when
        # I need to update them later on
        awap_id_id = provider.fieldNameIndex('awap_id')
        area_id = provider.fieldNameIndex('Area')
        perimeter_id = provider.fieldNameIndex('Perimeter')

        i = 1

        if self.always_in:
            for boundary in self.boundary_layer.getFeatures():
                boundary_geom = boundary.geometry()

                with edit(self.final_blocks_layer):
                    for block in self.blocks_layer.getFeatures():
                        block_geom = block.geometry()

                        if block_geom.intersects(boundary_geom):

                            # Calculate area and perimeter of the block
                            P = block_geom.length()
                            A = block_geom.area()

                            # Create a new feature with the geometry of the
                            # block and the id, perimeter and area attributes
                            feature = QgsFeature()
                            feature.setGeometry(block_geom)
                            feature.setId(i)
                            provider.addFeatures( [feature] )

                            # Add area and perimtere of the block to the attribute
                            # table
                            self.final_blocks_layer.changeAttributeValue(
                                i,
                                awap_id_id,
                                i
                            )
                            self.final_blocks_layer.changeAttributeValue(
                                i,
                                area_id,
                                A
                            )
                            self.final_blocks_layer.changeAttributeValue(
                                i,
                                perimeter_id,
                                P
                            )

                            # Finally, keep incrementing (summing) num & denum
                            numerator_sumPxA += P * A
                            denominator_sumA += A
                            #  print("Area:", block_geom.area())

                            i += 1

        elif self.always_out:
            for boundary in self.boundary_layer.getFeatures():
                boundary_geom = boundary.geometry()

                with edit(self.final_blocks_layer):
                    for block in self.blocks_layer.getFeatures():
                        block_geom = block.geometry()

                        if block_geom.within(boundary_geom):
                            P = block_geom.length()
                            A = block_geom.area()

                            # Create a new feature with the geometry of the
                            # block and the id, perimeter and area attributes
                            feature = QgsFeature()
                            feature.setGeometry(block_geom)
                            feature.setId(i)
                            provider.addFeatures( [feature] )

                            # Add area and perimtere of the block to the attribute
                            # table
                            self.final_blocks_layer.changeAttributeValue(
                                i,
                                awap_id_id,
                                i
                            )
                            self.final_blocks_layer.changeAttributeValue(
                                i,
                                area_id,
                                A
                            )
                            self.final_blocks_layer.changeAttributeValue(
                                i,
                                perimeter_id,
                                P
                            )

                            # Finally, keep incrementing (summing) num & denum
                            numerator_sumPxA += P * A
                            denominator_sumA += A
                            #  print("Area:", block_geom.area())

                            i += 1

        else:
            for boundary in self.boundary_layer.getFeatures():
                boundary_geom = boundary.geometry()

                with edit(self.final_blocks_layer):
                    for block in self.blocks_layer.getFeatures():
                        block_geom = block.geometry()

                        block_intersection = block_geom.intersection(boundary_geom)

                        A = block_geom.area()
                        if A > 0:
                            block_percent = block_intersection.area() / A * 100
                            #  print('block_percent: ', block_percent)
                            #  print('percent_in: ', self.percent_in)
                        else:
                            block_percent = 0

                        if block_percent >= self.percent_in:
                            P = block_geom.length()

                            # Create a new feature with the geometry of the
                            # block and the id, perimeter and area attributes
                            feature = QgsFeature()
                            feature.setGeometry(block_geom)
                            feature.setId(i)
                            provider.addFeatures( [feature] )

                            # Add area and perimtere of the block to the attribute
                            # table
                            self.final_blocks_layer.changeAttributeValue(
                                i,
                                awap_id_id,
                                i
                            )
                            self.final_blocks_layer.changeAttributeValue(
                                i,
                                area_id,
                                A
                            )
                            self.final_blocks_layer.changeAttributeValue(
                                i,
                                perimeter_id,
                                P
                            )

                            # Finally, keep incrementing (summing) num & denum
                            numerator_sumPxA += P * A
                            denominator_sumA += A
                            print("Area:", block_geom.area())

                            i += 1

        if denominator_sumA:
            AwaP = numerator_sumPxA / denominator_sumA
        else:
            AwaP = 0
        #  print('AwaP: ', AwaP)

        # Put the calculated AwaP into the label that shows the result
        self.dlg.label_6.setText('%s m' %round(AwaP,1))
        self.dlg.label_7.setVisible(True)
        self.dlg.label_6.setVisible(True)

        # show the blocks layer in the qgis map
        awap_id = provider.fieldNameIndex('AwaP')
        with edit(self.final_blocks_layer):
            for block in self.blocks_layer.getFeatures():
                    self.final_blocks_layer.changeAttributeValue(
                        block.id(),
                        awap_id,
                        AwaP
                    )
        self.final_blocks_layer.updateFields()
        self.final_blocks_layer.setName('AwaP_' + str(int(round(AwaP,0))))
        # self.showLayer(self.boundary_layer, {'color' : 'dark gray'})
        self.showLayer(self.final_blocks_layer, {'color' : QColor(128, 55, 55).rgb()})