# -*- coding: utf-8 -*hhhj

"""
/***************************************************************************
 AvaFrameRunCom1DFA
                                 A QGIS plugin
 Connects to AvaFrame
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-08-26
        copyright            : (C) 2021 by AvaFrame Team
        email                : felix@avaframe.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = "AvaFrame Team"
__date__ = "2022"
__copyright__ = "(C) 2022 by AvaFrame Team"

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = "$Format:%H$"


import pathlib
import subprocess
from qgis import processing
from pathlib import Path

from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import (
    QgsProcessing,
    QgsVectorLayer,
    QgsProcessingException,
    QgsProcessingAlgorithm,
    QgsProcessingContext,
    QgsProcessingParameterFeatureSource,
    QgsProcessingParameterRasterLayer,
    QgsProcessingParameterMultipleLayers,
    QgsProcessingParameterFolderDestination,
    QgsProcessingOutputVectorLayer,
    QgsProcessingOutputMultipleLayers,
    QgsProcessingContext,
)


class runCom5GlideSnowAlgorithm(QgsProcessingAlgorithm):
    """
    This is the AvaFrame Connection, i.e. the part running with QGis. For this
    connector to work, more installation is needed. See instructions at docs.avaframe.org
    """

    DEM = "DEM"
    REL = "REL"
    RES = "RES"
    OUTPUT = "OUTPUT"
    OUTPPR = "OUTPPR"
    FOLDEST = "FOLDEST"

    def initAlgorithm(self, config):
        """
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        """

        self.addParameter(
            QgsProcessingParameterRasterLayer(self.DEM, self.tr("DEM layer"))
        )

        self.addParameter(
            QgsProcessingParameterMultipleLayers(
                self.REL,
                self.tr("Release layer(s)"),
                layerType=QgsProcessing.TypeVectorAnyGeometry,
            )
        )

        self.addParameter(
            QgsProcessingParameterFeatureSource(
                self.RES,
                self.tr("Resistance layer"),
                optional=True,
                defaultValue="",
                types=[QgsProcessing.TypeVectorAnyGeometry],
            )
        )

        self.addParameter(
            QgsProcessingParameterFolderDestination(
                self.FOLDEST, self.tr("Destination folder")
            )
        )

        self.addOutput(
            QgsProcessingOutputVectorLayer(
                self.OUTPUT,
                self.tr("Output layer"),
                QgsProcessing.TypeVectorAnyGeometry,
            )
        )

        self.addOutput(
            QgsProcessingOutputMultipleLayers(
                self.OUTPPR,
            )
        )

    def flags(self):
        return super().flags()
        # return super().flags() | QgsProcessingAlgorithm.FlagNoThreading

    def processAlgorithm(self, parameters, context, feedback):
        """
        Here is where the processing itself takes place.
        """

        from avaframe.in3Utils import initializeProject as iP
        import avaframe.version as gv
        from . import avaframeConnector_commonFunc as cF

        feedback.pushInfo("AvaFrame Version: " + gv.getVersion())

        sourceDEM = self.parameterAsRasterLayer(parameters, self.DEM, context)
        if sourceDEM is None:
            raise QgsProcessingException(self.invalidSourceError(parameters, self.DEM))

        # Release files
        allREL = self.parameterAsLayerList(parameters, self.REL, context)
        if allREL is None:
            raise QgsProcessingException(self.invalidSourceError(parameters, self.REL))

        relDict = {}
        if allREL:
            relDict = {lyr.source(): lyr for lyr in allREL}

        sourceRES = self.parameterAsVectorLayer(parameters, self.RES, context)

        sourceFOLDEST = self.parameterAsFile(parameters, self.FOLDEST, context)

        # create folder structure
        targetDir = pathlib.Path(sourceFOLDEST)
        iP.initializeFolderStruct(targetDir, removeExisting=False)

        feedback.pushInfo(sourceDEM.source())

        # copy DEM
        cF.copyDEM(sourceDEM, targetDir)

        # copy all release shapefile parts
        cF.copyMultipleShp(relDict, targetDir / "Inputs" / "REL")

        # copy all resistance shapefile parts
        if sourceRES is not None:
            cF.copyShp(sourceRES.source(), targetDir / "Inputs" / "RES")

        feedback.pushInfo("Starting the simulations")
        feedback.pushInfo("This might take a while")
        feedback.pushInfo("See console for more info")

        subprocess.call(['python', '-m', 'avaframe.runCom5GlideSnow', str(targetDir)])

        feedback.pushInfo("Done, start loading the results")

        # Get peakfiles to return to QGIS
        rasterResults = cF.getLatestPeak(targetDir)
        allRasterLayers = cF.addStyleToCom1DFAResults(rasterResults)
        # context = cF.addLayersToContext(context, allRasterLayers, self.OUTPPR)

        vectorResults = list()
        # Iterate through all raster layers
        for layer in allRasterLayers:

            # Get layer crs
            thisLayerCRS = layer.crs()

            # Get source layer dir
            cuLayerName = layer.name()
            sourcePath = Path(layer.source())
            sourceDir = sourcePath.parent
            sourceFileName = sourcePath.stem

            # Set new layer name
            newLayerName = cuLayerName
            newLayerPath = sourceDir.joinpath(sourceFileName+'.shp')

            params = {'FIELD_NAME': 'VALUE',
                      'INPUT_RASTER': layer,
                      'OUTPUT': str(newLayerPath),
                      'RASTER_BAND': 1}
            result = processing.run("native:pixelstopolygons", params)

            vectorResults.append({'file': result['OUTPUT'],
                                  'name': newLayerName,
                                  'crs': thisLayerCRS})

        feedback.pushInfo("Done, start loading the results")

        scriptDir = Path(__file__).parent
        qmls = dict()
        qmls["ppr"] = str(scriptDir / "QGisStyles" / "pprGlideSnowShape.qml")
        qmls["pft"] = str(scriptDir / "QGisStyles" / "pftGlideSnowShape.qml")
        qmls["pfv"] = str(scriptDir / "QGisStyles" / "pfvGlideSnowShape.qml")

        allVectorLayers = list()
        for row in vectorResults:
            vectorLayer = QgsVectorLayer(row["file"], row["name"], "ogr")
            vectorLayer.setCrs(row["crs"])
            vectorLayer.setName(row["name"])
            try:
                resType = row["name"].split('_')[-1]
                vectorLayer.loadNamedStyle(qmls[resType])
            except:
                feedback.pushInfo("No matching layer style found")
                pass

            allVectorLayers.append(vectorLayer)

        context.temporaryLayerStore().addMapLayers(allVectorLayers)

        for item in allVectorLayers:
            context.addLayerToLoadOnCompletion(
                item.id(),
                QgsProcessingContext.LayerDetails(
                    item.name(), context.project(), self.OUTPUT
                ),
            )

        return {self.OUTPUT: allVectorLayers}



        # allRasterLayers = cF.addStyleToCom1DFAResults(rasterResults)

        # context = cF.addLayersToContext(context, allRasterLayers, self.OUTPPR)

        # feedback.pushInfo("\n---------------------------------")
        # feedback.pushInfo("Done, find results and logs here:")
        # feedback.pushInfo(str(targetDir.resolve()))
        # feedback.pushInfo("---------------------------------\n")

        # return {self.OUTPPR: allRasterLayers}

    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return "com5glidesnow"

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr("Glide Snow (com5)")

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr(self.groupId())

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return "Experimental"

    def tr(self, string):
        return QCoreApplication.translate("Processing", string)

    def shortHelpString(self) -> str:
        hstring = "Runs glide snow simulations via module com1DFA. \n\
                For more information go to (or use the help button below): \n\
                AvaFrame Documentation: https://docs.avaframe.org\n\
                Homepage: https://avaframe.org\n\
                Praxisleitfaden: https://avaframe.org/reports\n"

        return self.tr(hstring)
        # Praxisleitfaden: https://info.bml.gv.at/dam/jcr:edebd872-2a86-4edf-ac5e-635ef11e35fe/Praxisleitfaden%20LawSim%20WLV%202022%20Gr%C3%BCn.pdf\n'

    def helpUrl(self):
        return "https://docs.avaframe.org/en/latest/connector.html"

    def createInstance(self):
        return runCom5GlideSnowAlgorithm()
