# -*- coding: utf-8 -*-

"""
/***************************************************************************
 AvaFrameConnector
                                 A QGIS plugin
 Connects to AvaFrame
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-08-26
        copyright            : (C) 2021 by AvaFrame Team
        email                : felix@avaframe.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'AvaFrame Team'
__date__ = '2022'
__copyright__ = '(C) 2022 by AvaFrame Team'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import shutil
import pathlib
import subprocess
from pathlib import Path

from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import (QgsProcessing,
                       QgsProcessingException,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterRasterLayer,
                       QgsProcessingParameterMultipleLayers,
                       QgsProcessingParameterFolderDestination,
                       QgsProcessingOutputVectorLayer,
                       QgsProcessingOutputMultipleLayers,
                       )


class AvaFrameConnectorAlgorithm(QgsProcessingAlgorithm):
    """
    This is the AvaFrame Connection, i.e. the part running with QGis. For this
    connector to work, more installation is needed. See instructions at docs.avaframe.org
    """

    DEM = 'DEM'
    REL = 'REL'
    SECREL = 'SECREL'
    ENT = 'ENT'
    RES = 'RES'
    PROFILE = 'PROFILE'
    SPLITPOINTS = 'SPLITPOINTS'
    OUTPUT = 'OUTPUT'
    OUTPPR = 'OUTPPR'
    FOLDEST = 'FOLDEST'
    SMALLAVA = 'SMALLAVA'

    def initAlgorithm(self, config):
        """
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        """

        self.addParameter(QgsProcessingParameterRasterLayer(
            self.DEM,
            self.tr("DEM layer")))

        self.addParameter(QgsProcessingParameterMultipleLayers(
            self.REL,
            self.tr('Release layer(s)'),
            layerType=QgsProcessing.TypeVectorAnyGeometry
            ))

        self.addParameter(QgsProcessingParameterFeatureSource(
            self.SECREL,
            self.tr('Secondary release layer (only one is allowed)'),
            optional=True,
            defaultValue="",
            types=[QgsProcessing.TypeVectorAnyGeometry]
            ))

        self.addParameter(QgsProcessingParameterFeatureSource(
                self.ENT,
                self.tr('Entrainment layer'),
                optional=True,
                defaultValue = "",
                types=[QgsProcessing.TypeVectorAnyGeometry]
            ))

        self.addParameter(QgsProcessingParameterFeatureSource(
                self.RES,
                self.tr('Resistance layer'),
                optional=True,
                defaultValue = "",
                types=[QgsProcessing.TypeVectorAnyGeometry]
            ))

        self.addParameter(QgsProcessingParameterFeatureSource(
            self.PROFILE,
            self.tr("Profile layer"),
            optional=True,
            defaultValue = "",
            types=[QgsProcessing.TypeVectorLine]))

        self.addParameter(QgsProcessingParameterFeatureSource(
            self.SPLITPOINTS,
            self.tr("Splitpoint layer"),
            defaultValue = "",
            optional=True,
            types=[QgsProcessing.TypeVectorPoint]))


        self.addParameter(QgsProcessingParameterFolderDestination(
                self.FOLDEST,
                self.tr('Destination folder')
            ))

   #          self.addParameter(QgsProcessingParameterBoolean(
#                  self.SMALLAVA,
#                  self.tr('Small Avalanche (for com2AB) '),
#                  optional=True
#              ))
#  #
        self.addOutput(QgsProcessingOutputVectorLayer(
            self.OUTPUT,
            self.tr("Output layer"),
            QgsProcessing.TypeVectorAnyGeometry))

        self.addOutput(
        QgsProcessingOutputMultipleLayers(
                self.OUTPPR,
            )
        )


    def processAlgorithm(self, parameters, context, feedback):
        """
        Here is where the processing itself takes place.
        """

        from avaframe.in3Utils import initializeProject as iP
        import avaframe.version as gv
        from . import avaframeConnector_commonFunc as cF

        feedback.pushInfo('AvaFrame Version: ' + gv.getVersion())

        # targetADDTONAME = self.parameterAsString(parameters, self.ADDTONAME, context)
        targetADDTONAME = ''

        sourceDEM = self.parameterAsRasterLayer(parameters, self.DEM, context)
        if sourceDEM is None:
            raise QgsProcessingException(self.invalidSourceError(parameters, self.DEM))

        # Release files
        allREL = self.parameterAsLayerList(parameters, self.REL, context)
        if allREL is None:
            raise QgsProcessingException(self.invalidSourceError(parameters, self.REL))

        relDict = {}
        if allREL:
            relDict = {lyr.source(): lyr for lyr in allREL}

        # Secondary release files
        allSecREL = self.parameterAsLayerList(parameters, self.SECREL, context)

        # Secondary release files
        sourceSecREL = self.parameterAsVectorLayer(parameters, self.SECREL, context)
        if sourceSecREL is not None:
            srInfo = '_SR' + Path(sourceSecREL.source()).stem
            targetADDTONAME = targetADDTONAME + srInfo

        sourceENT = self.parameterAsVectorLayer(parameters, self.ENT, context)

        sourceRES = self.parameterAsVectorLayer(parameters, self.RES, context)

        sourceFOLDEST = self.parameterAsFile(parameters, self.FOLDEST, context)

        sourcePROFILE = self.parameterAsVectorLayer(parameters, self.PROFILE, context)

        sourceSPLITPOINTS= self.parameterAsVectorLayer(parameters, self.SPLITPOINTS, context)

        # create folder structure
        finalTargetDir = pathlib.Path(sourceFOLDEST)
        targetDir = finalTargetDir / 'tmp'
        iP.initializeFolderStruct(targetDir, removeExisting=True)

        # copy DEM
        cF.copyDEM(sourceDEM, targetDir)

        # copy all release shapefile parts
        cF.copyMultipleShp(relDict, targetDir / 'Inputs' / 'REL', targetADDTONAME)

        # copy all secondary release shapefile parts
        if sourceSecREL is not None:
            cF.copyShp(sourceSecREL.source(), targetDir / 'Inputs' / 'SECREL')


        # copy all entrainment shapefile parts
        if sourceENT is not None:
            cF.copyShp(sourceENT.source(), targetDir / 'Inputs' / 'ENT')

        # copy all resistance shapefile parts
        if sourceRES is not None:
            cF.copyShp(sourceRES.source(), targetDir / 'Inputs' / 'RES')

        # copy all Splitpoint shapefile parts
        if sourceSPLITPOINTS is not None:
            cF.copyShp(sourceSPLITPOINTS.source(), targetDir / 'Inputs' / 'POINTS')

        # copy all Profile shapefile parts
        if sourcePROFILE is not None:
            sourcePROFILEPath = pathlib.Path(sourcePROFILE.source())
            targetPROFILEPath = targetDir / 'Inputs' / 'LINES'

            shpParts = cF.getSHPParts(sourcePROFILEPath)

            for shpPart in shpParts:
                try:
                    # make sure this file contains AB (for com2AB)
                    if 'AB' not in str(shpPart):
                        newName = shpPart.stem + '_AB' + shpPart.suffix
                        newName = targetPROFILEPath / newName
                        shutil.copy(shpPart, newName)
                    else:
                        shutil.copy(shpPart, targetPROFILEPath)
                except shutil.SameFileError:
                    pass

        feedback.pushInfo('Starting the simulations')
        feedback.pushInfo('This might take a while')
        feedback.pushInfo('See console for progress')

        # abResultsSource, rasterResults = runOp.runOperational(str(targetDir))
        subprocess.call(['python', '-m', 'avaframe.runOperational', str(targetDir)])

        feedback.pushInfo('Done, start loading the results')

        # Move input and output folders to finalTargetDir

        # Get peakfiles to return to QGIS
        rasterResults = cF.getLatestPeak(targetDir)

        allRasterLayers = cF.addStyleToCom1DFAResults(rasterResults)

        context = cF.addLayersToContext(context, allRasterLayers, self.OUTPPR)

        # Get alphabeta shapefile to return to QGIS
        abResultsLayer = cF.getAlphaBetaResults(targetDir)

        context = cF.addSingleLayerToContext(context, abResultsLayer, self.OUTPUT)

        feedback.pushInfo('\n---------------------------------')
        feedback.pushInfo('Done, find results and logs here:')
        feedback.pushInfo(str(targetDir.resolve()))
        feedback.pushInfo('---------------------------------\n')

        if abResultsLayer is None:
            return {self.OUTPPR: allRasterLayers}
        else:
            return {self.OUTPUT: abResultsLayer, self.OUTPPR: allRasterLayers}

    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'fulloperationalrun'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr('Full Operational Run')

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr(self.groupId())

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'Operational'

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def shortHelpString(self) -> str:
        hstring = 'Runs the operational workflow (com1DFA and com2AB). \n\
                For more information go to: \n\
                AvaFrame Documentation: https://docs.avaframe.org\n\
                Homepage: https://avaframe.org\n\
                Praxisleitfaden: https://avaframe.org/reports\n'

        return self.tr(hstring) 

    def helpUrl(self):
        return "https://docs.avaframe.org/en/latest/connector.html"

    def createInstance(self):
        return AvaFrameConnectorAlgorithm()
