# -*- coding: utf-8 -*-

"""
/***************************************************************************
 AvaFrameRunCom1DFA
                                 A QGIS plugin
 Connects to AvaFrame
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-08-26
        copyright            : (C) 2021 by AvaFrame Team
        email                : felix@avaframe.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = "AvaFrame Team"
__date__ = "2025"
__copyright__ = "(C) 2025 by AvaFrame Team"

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = "$Format:%H$"


from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import (
    QgsProcessing,
    QgsProcessingException,
    QgsProcessingAlgorithm,
    QgsProcessingParameterFeatureSource,
    QgsProcessingParameterRasterLayer,
    QgsProcessingParameterEnum,
    QgsProcessingParameterFolderDestination,
    QgsProcessingOutputVectorLayer,
)


class runCom6ScarpAlgorithm(QgsProcessingAlgorithm):
    """
    This is the AvaFrame Connection, i.e. the part running with QGis. For this
    connector to work, more installation is needed. See instructions at docs.avaframe.org
    """

    DEM = "DEM"
    COORDINATES = "COORDINATES"
    PERIMETER = "PERIMETER"
    SCARPMETHOD = "SCARPMETHOD"
    OUTPUT = "OUTPUT"
    FOLDEST = "FOLDEST"

    def initAlgorithm(self, config):
        """
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        """

        self.addParameter(QgsProcessingParameterRasterLayer(self.DEM, self.tr("DEM layer")))

        self.addParameter(
            QgsProcessingParameterEnum(
                self.SCARPMETHOD,
                self.tr("Scarp method"),
                options=[
                    self.tr("Plane (requires zseed, dip(dir), slopeangle)"),
                    self.tr(
                        "Ellipsoid (requires zseed, maxdepth, semimajor, semiminor, tilt, direc, dip(dir), offset"
                    ),
                ],
                defaultValue=0,
                allowMultiple=False,
            )
        )

        self.addParameter(
            QgsProcessingParameterFeatureSource(
                self.COORDINATES,
                self.tr("Coordinate layer (Point shapefile with attributes)"),
                defaultValue="",
                types=[QgsProcessing.TypeVectorPoint],
            )
        )

        self.addParameter(
            QgsProcessingParameterFeatureSource(
                self.PERIMETER,
                self.tr("Perimeter Layer (Polygon shapefile defining boundary area"),
                defaultValue="",
                types=[QgsProcessing.TypeVectorAnyGeometry],
            )
        )


        self.addParameter(
            QgsProcessingParameterFolderDestination(self.FOLDEST, self.tr("Destination folder"))
        )

        self.addOutput(
            QgsProcessingOutputVectorLayer(
                self.OUTPUT,
                self.tr("Output layer"),
                QgsProcessing.TypeVectorAnyGeometry,
            )
        )

    def flags(self):
        return super().flags()

    def processAlgorithm(self, parameters, context, feedback):
        """
        Here is where the processing itself takes place.
        """

        import avaframe.version as gv
        from . import avaframeConnector_commonFunc as cF

        feedback.pushInfo("AvaFrame Version: " + gv.getVersion())

        sourceDEM = self.parameterAsRasterLayer(parameters, self.DEM, context)
        if sourceDEM is None:
            raise QgsProcessingException(self.invalidSourceError(parameters, self.DEM))

        sourcePerimeter = self.parameterAsVectorLayer(parameters, self.PERIMETER, context)

        sourceCoordinates = self.parameterAsVectorLayer(parameters, self.COORDINATES, context)

        sourceFOLDEST = self.parameterAsFile(parameters, self.FOLDEST, context)

        # Get the scarp method
        scarpMethod = self.parameterAsInt(parameters, self.SCARPMETHOD, context)
        scarpOptions = ["plane", "ellipsoid"]
        scarpString = scarpOptions[scarpMethod]

        finalTargetDir, targetDir = cF.createFolderStructure(sourceFOLDEST)

        feedback.pushInfo(sourceDEM.source())

        cF.copyDEM(sourceDEM, targetDir)

        cF.copyShp(sourcePerimeter.source(), targetDir / "Inputs" / "POLYGONS", addToName="_perimeter")

        cF.copyShp(sourceCoordinates.source(), targetDir / "Inputs" / "POINTS", addToName="_coordinates")

        feedback.pushInfo("Starting the tool")
        feedback.pushInfo("This might take a while")
        feedback.pushInfo("See console for progress")
        #
        command = ["python", "-m", "avaframe.runCom6Scarp", str(targetDir), "-m", scarpString]
        cF.runAndCheck(command, self, feedback)

        feedback.pushInfo("Done, start loading the results")

        cF.moveInputAndOutputFoldersToFinal(targetDir, finalTargetDir)

        try:
            allRasterResults = cF.getCom6ScarpResults(finalTargetDir)
        except:
            raise QgsProcessingException(
                self.tr("Something went wrong with com6Scarp, please check log files")
            )

        context = cF.addLayersToContext(context, allRasterResults, self.OUTPUT)

        feedback.pushInfo("\n---------------------------------")
        feedback.pushInfo("Done, find results and logs here:")
        feedback.pushInfo(str(finalTargetDir.resolve()))
        feedback.pushInfo("---------------------------------\n")

        return {self.OUTPUT: allRasterResults}
        # return

    def name(self):
        return "com6scarp"

    def displayName(self):
        return self.tr("Scarp (com6)")

    def group(self):
        return self.tr(self.groupId())

    def groupId(self):
        return "Experimental"

    def tr(self, string):
        return QCoreApplication.translate("Processing", string)

    def shortHelpString(self) -> str:
        hstring = "Runs scarp  via module com6RockAvalanche. \n\
                For more information go to (or use the help button below): \n\
                AvaFrame Documentation: https://docs.avaframe.org\n\
                Homepage: https://avaframe.org\n\
                Praxisleitfaden: https://avaframe.org/reports\n"

        return self.tr(hstring)

    def helpUrl(self):
        return "https://docs.avaframe.org/en/latest/connector.html"

    def createInstance(self):
        return runCom6ScarpAlgorithm()
