# -*- coding: utf-8 -*-
"""
/***************************************************************************
 autoesdaPluginDialog
                                 A QGIS plugin
 This plugin automates the exploratory spatial data analysis (ESDA) process by summarizing numerous statistics in an HTML report.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2022-04-30
        git sha              : $Format:%H$
        copyright            : (C) 2022 by Nicholas De Kock
        email                : nicholas.dekock@tuks.co.za
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os, tempfile, webbrowser
import geopandas as gpd
import autoesda

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'autoesda_plugin_dialog_base.ui'))


class autoesdaPluginDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(autoesdaPluginDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)

        self.filepathOutput.setFilter("HTML files (*.html)")
        self.dialogBox.accepted.connect(self.generate_output_report)

    def generate_output_report(self):
        
        inputLayer = self.mapLayerInput.currentLayer().source()
        outputFilepath = self.filepathOutput.filePath()
        
        gdf = gpd.read_file(inputLayer)
        report_content = autoesda.generate_html_string(gdf)

        file = open(outputFilepath, 'w')
        file.write(report_content)
        file.close()

        state = self.cbOpenFile.checkState()
        if(state==2):
            webbrowser.open_new_tab(outputFilepath)
