# -*- coding: utf-8 -*-
"""
/***************************************************************************
 autoclass
                                 A QGIS plugin
 deep learning based classifier
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-04-26
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Shourya Shashank
        email                : shouryashashank@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QFileDialog
from qgis.core import QgsProject
import processing, tempfile
import numpy as np
import cv2
import gdal

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .auto_class_dialog import autoclassDialog
import os.path


class autoclass:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'autoclass_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&automatic classifier')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('autoclass', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToRasterMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/auto_class/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'auto-classifier'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginRasterMenu(
                self.tr(u'&automatic classifier'),
                action)
            self.iface.removeToolBarIcon(action)

    def select_input_file(self):
        filename, _filter = QFileDialog.getOpenFileName(self.dlg, "Select input file ","","")
        self.dlg.lineEdit_2.setText(filename)
    def select_output_file(self):
        filename = QFileDialog.getExistingDirectory(self.dlg, "Select output file ","")
        self.dlg.lineEdit.setText(filename)

    
    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = autoclassDialog()

        # Fetch the currently loaded layers
        layers = QgsProject.instance().layerTreeRoot().children()
        # Clear the contents of the comboBox from previous runs
        self.dlg.comboBox.clear()
        # Populate the comboBox with names of all the loaded layers
        self.dlg.comboBox.addItems([layer.name() for layer in layers])
        self.dlg.pushButton_2.clicked.connect(self.select_input_file)
        self.dlg.comboBox_2.addItems(["High","Medium","Low","Extra Low"])
        self.dlg.pushButton.clicked.connect(self.select_output_file)



        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            # pass
            original_image = self.dlg.lineEdit_2.text()
            outputfile = self.dlg.lineEdit.text()
            details= str(self.dlg.comboBox_2.currentText())
            print (original_image)
            print(outputfile)
            original_image = cv2.imread(original_image)

            img=cv2.cvtColor(original_image,cv2.COLOR_BGR2RGB)
            print (1)

            vectorized = img.reshape((-1,3))

            vectorized = np.float32(vectorized)
            criteria = (cv2.TERM_CRITERIA_EPS + cv2.TERM_CRITERIA_MAX_ITER, 10, 1.0)

            K = 3
            if details == 'High':
                K=15
            elif details == 'Medium':
                K=10
            elif details == 'Low':
                K=5
            elif details == 'Extra Low':
                K=3
            print (K)
            attempts=10
            ret,label,center=cv2.kmeans(vectorized,K,None,criteria,attempts,cv2.KMEANS_PP_CENTERS)

            center = np.uint8(center)

            res = center[label.flatten()]
            res2 = res.reshape((img.shape))
            all_rgb_codes = res2.reshape(-1, img.shape[-1])
            unique_rgbs = np.unique(all_rgb_codes, axis=0)

            str_a="r'" + str(self.dlg.lineEdit_2.text()) + "'"
            print (str_a)

            original_ds = gdal.Open(self.dlg.lineEdit_2.text() ,0)
            sr = original_ds.GetProjection()
            print (sr)
            gt = original_ds.GetGeoTransform()
            del original_ds

            # dss = gdal.Open(outputfile+"/5.tif", 1)
            # dss.SetProjection(sr)
            # dss.SetGeoTransform(gt)

            # # save and close target raster
            # del dss
            

            mi=0
            for i in unique_rgbs:
                l=i
                u=i
                mask1=cv2.inRange(res2, l, u)
                out = cv2.bitwise_and(res2,res2, mask= mask1)
                cv2.imwrite(outputfile+"/"+str(mi)+".tif",out)
                dss = gdal.Open(outputfile+"/"+str(mi)+".tif", 1)
                dss.SetProjection(sr)
                dss.SetGeoTransform(gt)
                del dss
                mi=mi+1
            cv2.imwrite(outputfile+"/STACK.tif",res2)
            print ("done")


            

