# -*- coding: utf-8 -*-
"""
/***************************************************************************
 AtlasGridDialog
                                 A QGIS plugin
 This plugin can be used for creating a regular coverage grid for atlas plots
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2024-06-24
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Styrke10 ApS
        email                : morten@styrke10.dk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.PyQt.QtWidgets import QMessageBox, QDialogButtonBox
from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.core import Qgis, QgsProject, QgsLayoutItemRegistry, QgsUnitTypes, QgsVector, QgsRectangle, QgsLayoutMeasurement

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'atlasgrid_dialog_base.ui'))


class AtlasGridDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(AtlasGridDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        
        self.loadLayouts()
        self.loadMapItems()
        self.extentSet = False
        self.rwDimensions = None
        self.nRowsAndCols = None
        self.gridExtent = None
        self.mapScale = 0
        self.button_box.button(QDialogButtonBox.Ok).setEnabled(False)
        self.cmbAOILayer.setFilters(Qgis.LayerFilter.VectorLayer)
        self.gridCreator = None
                    
        # Connect the file changed signal to the enable button slot
        self.cmb_PrintLayouts.currentIndexChanged.connect(self.loadMapItems)
        self.cmb_MapItems.currentIndexChanged.connect(self.setInfo)
        self.mExtentGroupBox.extentChanged.connect(self.setExtentInfo)
        self.horizOverlap.valueChanged.connect(self.setExtentInfo)
        self.vertOverlap.valueChanged.connect(self.setExtentInfo)
        self.cmbCrsSelection.crsChanged.connect(self.setOutputCrs)
        
    def setGC(self, gc):
        self.gridCreator = gc

    def showEvent(self, event):
        super(AtlasGridDialog, self).showEvent(event)
        self.loadLayouts()
        self.loadMapItems()

    def loadLayouts(self):
        project = QgsProject.instance()
        self.maplist = []
        self.cmb_PrintLayouts.clear()
        for layout in project.layoutManager().printLayouts():
            self.cmb_PrintLayouts.addItem(layout.name())
            for item in layout.items():
                if item.type() == QgsLayoutItemRegistry.LayoutMap:
                    self.maplist.append((layout.name(),item.displayName(),item.scale(),item.sizeWithUnits()))
        
        return

    def loadMapItems(self):
        self.cmb_MapItems.clear()
        for item in self.maplist:
            if item[0] == self.cmb_PrintLayouts.currentText():
                self.cmb_MapItems.addItem(item[1])
                
        return

    def setExtentInfo(self):
##
        if not self.mExtentGroupBox.outputExtent().isEmpty():
            self.extentSet = True
            self.setInfo()
        return
        
    def setInfo(self):
        mapFound = False
        for item in self.maplist:
            if item[0] == self.cmb_PrintLayouts.currentText() and item[1] == self.cmb_MapItems.currentText():
                self.mapScale = item[2]
                atlasCellSize = item[3]
                mapFound = True

        if mapFound and self.extentSet:
            extent = self.mExtentGroupBox.outputExtent()
            if QgsUnitTypes.toAbbreviatedString(atlasCellSize.units()) != 'mm':
                msgBox = QMessageBox()
                msgBox.setIcon(QMessageBox.Icon.Warning)
                msgBox.setWindowTitle("Warning")
                msgBox.setText("Map item size units not in millimeters!\nThis is currently not supported.")
                msgBox.setStandardButtons(QMessageBox.StandardButton.Ok)
                msgBox.exec()
                self.infoMapScale.setText("")
                self.infoCellSize.setText("")
                self.infoRows.setText("")
                self.infoCols.setText("")
                self.button_box.button(QDialogButtonBox.Ok).setEnabled(False)
##
            elif extent.isEmpty():
                msgBox = QMessageBox()
                msgBox.setIcon(QMessageBox.Icon.Warning)
                msgBox.setWindowTitle("Warning")
                msgBox.setText("Extent not correctly set!")
                msgBox.setStandardButtons(QMessageBox.StandardButton.Ok)
                msgBox.exec()
                self.infoMapScale.setText("")
                self.infoCellSize.setText("")
                self.infoRows.setText("")
                self.infoCols.setText("")
                self.button_box.button(QDialogButtonBox.Ok).setEnabled(False)
            else:
                self.infoMapScale.setText("1:{:n}".format(int(round(self.mapScale,0))))
                self.infoCellSize.setText("{:.2f} x {:.2f} {}".format(atlasCellSize.width(),atlasCellSize.height(),QgsUnitTypes.toAbbreviatedString(atlasCellSize.units())))
                
                # Calculate rwExtent, row and column number
                (rwDimensions,nRowsAndCols,gridExtent) = self.gridCreator.calcGridMetrics(self.mapScale,extent,atlasCellSize,self.horizOverlap.value(),self.vertOverlap.value())

                self.rwDimensions = rwDimensions
                self.nRowsAndCols = nRowsAndCols
                self.infoCols.setText(str(nRowsAndCols[1]))
                self.infoRows.setText(str(nRowsAndCols[0]))
                
                self.gridExtent = gridExtent

                # Enable the OK button
                self.button_box.button(QDialogButtonBox.Ok).setEnabled(True)
            
        else:
            self.infoMapScale.setText("")
            self.infoCellSize.setText("")
            self.infoRows.setText("")
            self.infoCols.setText("")
            self.button_box.button(QDialogButtonBox.Ok).setEnabled(False)

        return
        
    def setOutputCrs(self):
        self.mExtentGroupBox.setOutputCrs(self.cmbCrsSelection.crs())
        self.gridCreator.setCRS(self.cmbCrsSelection.crs().authid())

