# -*- coding: utf-8 -*-
"""
/***************************************************************************
 AtlasGrid
                                 A QGIS plugin
 This plugin can be used for creating a regular coverage grid for atlas plots
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-06-24
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Styrke10 ApS
        email                : morten@styrke10.dk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os.path
from qgis.PyQt.QtCore import Qt, QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QApplication
from qgis.core import Qgis, QgsApplication, QgsProject, QgsFeature
from qgis import processing
from .grid import GridCreator

# Import the code for the processing plugin
from .atlasgrid_provider import AtlasGridProvider
# Import the code for the dialog
from .atlasgrid_dialog import AtlasGridDialog
# Initialize Qt resources from file resources.py
from .resources import *


class AtlasGrid:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Create provider
        self.provider = AtlasGridProvider()

        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'AtlasGrid_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&AtlasGrid')
        

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('AtlasGrid', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        # Add provider
        QgsApplication.processingRegistry().addProvider(self.provider)

        """Create the menu entries and toolbar icons inside the QGIS GUI."""
        icon_path = ':/plugins/atlasgrid/atlasgrid.png'
        self.add_action(
            icon_path,
            text=self.tr(u'AtlasGrid'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True

    def initProcessing(self):
        QgsApplication.processingRegistry().addProvider(self.provider)

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&AtlasGrid'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = AtlasGridDialog()
            self.dlg.setModal(True)
            self.gridCreator = GridCreator()
            self.dlg.setGC(self.gridCreator)
            # Set default CRS and extent and initialize the GridCreator object
            mapCanvas = self.iface.mapCanvas()
            self.dlg.mExtentGroupBox.setOriginalExtent(mapCanvas.extent(),mapCanvas.mapSettings().destinationCrs())
            self.dlg.cmbCrsSelection.setCrs(mapCanvas.mapSettings().destinationCrs())
            self.gridCreator.setCRS(self.dlg.cmbCrsSelection.crs().authid())

        # show the dialog
        self.dlg.show()   #exec_()   #show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            try:
                QApplication.setOverrideCursor(Qt.WaitCursor)
                gridLayer = self.gridCreator.createGrid(self.dlg.mapScale,self.dlg.gridExtent,self.dlg.rwDimensions,self.dlg.nRowsAndCols,self.dlg.chkboxDeleteNonIntersecting.isChecked(),self.dlg.cmbAOILayer.currentLayer())
                QgsProject.instance().addMapLayer(gridLayer)

            finally:
                QApplication.restoreOverrideCursor()
            
            
