"""
/***************************************************************************
 atlas
                                 A QGIS plugin
 Create map series given a feature layer and a composer template
                              -------------------
        begin                : 2012-01-14
        copyright            : (C) 2012 by Vincent Picavet (Oslandia)
        email                : vincent.picavet@oslandia.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
# Import the PyQt and QGIS libraries
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from math import floor
# Initialize Qt resources from file resources.py
import resources_rc
# Import the code for the dialog
from atlasdialog import atlasDialog
# Import module for about dialog
from atlasabout import aboutDialog
# Import generated help dialog
from ui_atlashelp import Ui_atlasHelp

class atlas:

    def __init__(self, iface):
        # Save reference to the QGIS interface
        self.iface = iface
        # get paths
        self.user_plugin_dir = QFileInfo(QgsApplication.qgisUserDbFilePath()).path() + "/python/plugins"
        self.atlas_plugin_dir = self.user_plugin_dir + "/atlas"

        locale = QSettings().value("locale/userLocale").toString()
        myLocale = locale[0:2]

        if QFileInfo(self.atlas_plugin_dir).exists():
            localePath = self.atlas_plugin_dir + "/i18n/atlas_" + myLocale + ".qm"

        if QFileInfo(localePath).exists():
            self.translator = QTranslator()
            self.translator.load(localePath)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)
        # create the dialog
        self.dlg = atlasDialog(self.iface)

    def initGui(self):
        # Create action that will start plugin configuration
        self.action = QAction(QIcon(":/plugins/atlas/icon.png"), \
            "&Atlas", self.iface.mainWindow())
        # Create action for about dialog
        self.action_about = QAction("A&bout...", self.iface.mainWindow())
        # Create action for help dialog
        self.action_help = QAction(QIcon(":/plugins/atlas/about.png"), "&Help...", self.iface.mainWindow())
        # connect the action to the run method
        QObject.connect(self.action, SIGNAL("triggered()"), self.run)
        # connect about action to about dialog
        QObject.connect(self.action_about, SIGNAL("triggered()"), self.showAbout)
        # connect help action to help dialog
        QObject.connect(self.action_help, SIGNAL("triggered()"), self.showHelp)

        # Add toolbar button and menu item
        self.iface.addToolBarIcon(self.action)
        self.iface.addPluginToMenu("&Atlas", self.action)
        # Add about menu entry
        self.iface.addPluginToMenu("&Atlas", self.action_about)
        # add help menu entry
        self.iface.addPluginToMenu("&Atlas", self.action_help)

    def unload(self):
        # Remove the plugin menu item and icon
        self.iface.removePluginMenu("&Atlas",self.action)
        self.iface.removeToolBarIcon(self.action)
        # Remove about menu entry
        self.iface.removePluginMenu("&Atlas", self.action_about)
        # Remove help menu entry
        self.iface.removePluginMenu("&Atlas", self.action_help)

    def showAbout(self):
        about = aboutDialog()
        about.show()
        result = about.exec_()
        del about

    def showHelp(self):
        hdialog = QDialog()
        hdialog.ui = Ui_atlasHelp()
        hdialog.ui.setupUi(hdialog)
        hdialog.ui.helpContent.setUrl(QUrl(self.atlas_plugin_dir + '/help/atlas_help.html'))
        hdialog.show()
        result = hdialog.exec_()
        del hdialog

    # run method that performs all the real work
    def run(self):

        # show the dialog
        self.dlg.updateBoxes()
        if not self.dlg.isVisible():
            self.dlg.show()
            #result = self.dlg.exec_()
