<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Asphalt Intelligence</title>
</head>
<body>

<h1>Asphalt Intelligence</h1>

<p>
Asphalt Intelligence is a QGIS dock-based plugin that assists with preparing and visualizing
raster imagery for pavement and road-surface screener analysis workflows.
</p>

<p>
The plugin provides guided tools to load, validate, reproject, and convert common raster
formats into a consistent EPSG:3857 coordinate reference system. This helps users reduce
setup time and enforce CRS consistency in GIS projects.
</p>

<h2>Features</h2>

<ul>
  <li>Guided EPSG:3857 project setup</li>
  <li>Raster validation and reprojection</li>
  <li>Support for common imagery formats:
    <ul>
      <li>GeoTIFF</li>
      <li>JPG + JGW (world file)</li>
      <li>MrSID</li>
    </ul>
  </li>
  <li>Easy addition of raster layers alongside a basemap for spatial context</li>
  <li>Designed for repeatable preprocessing workflows</li>
</ul>

<h2>Intended Use</h2>

<p>
This plugin is intended for the use of image analysis as a screener for road and highway
projects where consistent raster reprojection and preparation are required prior to
analysis or export.
</p>

<h2>Requirements</h2>

<ul>
  <li>QGIS 3.28 or newer</li>
  <li>GDAL (included with standard QGIS installations)</li>
</ul>

<h2>Installation</h2>

<p>
The plugin is available through the QGIS Plugin Repository.
</p>

<h2>External Services</h2>

<p>
This plugin operates entirely within QGIS and does not require user accounts, authentication,
or connections to external web services.
</p>

<h2>More Information</h2>

<p>
For general information about the project, visit
<a href="https://www.asphaltintelligence.com">https://www.asphaltintelligence.com</a>.
</p>

<h2>License</h2>

<p>
This plugin is licensed under the GNU General Public License v2 (GPL-2).
</p>

</body>
</html>