# -*- coding: utf-8 -*-
"""
/***************************************************************************
                              Asistente LADM_COL
                             --------------------
        begin                : 2019-09-10
        git sha              : :%H$
        copyright            : (C) 2017 by Germán Carrillo (BSF Swissphoto)
                               (C) 2018 by Sergio Ramírez (Incige SAS)
                               (C) 2018 by Jorge Useche (Incige SAS)
                               (C) 2018 by Jhon Galindo (Incige SAS)
                               (C) 2019 by Leo Cardona (BSF Swissphoto)
                               (C) 2021 by Yesid Polania (BSF Swissphoto)
        email                : gcarrillo@linuxmail.org
                               sergio.ramirez@incige.com
                               naturalmentejorge@gmail.com
                               jhonsigpjc@gmail.com
                               leo.cardona.p@gmail.com
                               yesidpol.3@gmail.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License v3.0 as          *
 *   published by the Free Software Foundation.                            *
 *                                                                         *
 ***************************************************************************/
 """
from qgis.PyQt.QtWidgets import QWizard

from asistente_ladm_col.config.enums import EnumFeatureCreationMode
from asistente_ladm_col.config.general_config import (WIZARD_STRINGS,
                                                      WIZARD_HELP_PAGES,
                                                      WIZARD_HELP2,
                                                      WIZARD_HELP,
                                                      WIZARD_REFACTOR_FIELDS_RECENT_MAPPING_OPTIONS,
                                                      WIZARD_REFACTOR_FIELDS_LAYER_FILTERS,
                                                      WIZARD_SELECT_SOURCE_HELP,
                                                      WIZARD_FINISH_BUTTON_TEXT,
                                                      WIZARD_CREATION_MODE_KEY,
                                                      WIZARD_SELECTED_TYPE_KEY)
from asistente_ladm_col.gui.wizards.controller.controller_args import CreateFeatureArgs
from asistente_ladm_col.gui.wizards.view.common.source_selector import SourceSelector
from asistente_ladm_col.gui.wizards.view.common.view_args import PickFeaturesSelectedArgs
from asistente_ladm_col.gui.wizards.view.pages.features_selector_view import ParcelSelectorView
from asistente_ladm_col.gui.wizards.view.single_wizard_view import SingleWizardView
from asistente_ladm_col.utils.qt_utils import (disable_next_wizard,
                                               enable_next_wizard)
from asistente_ladm_col.utils.utils import show_plugin_help


class ParcelView(SingleWizardView):

    def __init__(self, controller, view_config):
        self.__wizard = QWizard()
        self.__controller = controller
        self.__view_config = view_config

        self.__wp_select_source = self._create_select_source()

        self.__wp_associated_features_selector = ParcelSelectorView(controller, self.__view_config[WIZARD_HELP_PAGES][WIZARD_HELP2])
        # -||
        super().__init__(controller, view_config)
        self.__init_gui()

    def _create_select_source(self) -> SourceSelector:
        return SourceSelector(
            self.__view_config[WIZARD_REFACTOR_FIELDS_RECENT_MAPPING_OPTIONS],
            self.__view_config[WIZARD_REFACTOR_FIELDS_LAYER_FILTERS],
            self.__view_config[WIZARD_STRINGS])

    def load_parcel_types(self, parcel_types: dict):
        self.__wp_associated_features_selector.load_parcel_types(parcel_types)

    def set_spatial_units_options_status(self, spatial_units_status: dict):
        self.__wp_associated_features_selector.set_spatial_units_options_status(spatial_units_status)

    def close(self):
        self.dispose()
        self.__wizard.close()

    def dispose(self):
        self.__wp_select_source.disconnect_signals()
        self.__wp_associated_features_selector.disconnect_signals()
        self.__wp_select_source.option_changed.disconnect()
        self.__wizard.rejected.disconnect()
        self.__wizard.button(QWizard.FinishButton).clicked.disconnect()

    def exec_(self):
        return self.__wizard.exec_()

    def set_visible(self, visible: bool):
        self.__wizard.setVisible(visible)

    def enable_finish_button(self, enable: bool):
        self.__wizard.button(QWizard.FinishButton).setDisabled(not enable)

    def __init_gui(self):
        self.__wp_select_source.option_changed.connect(self.__option_changed)

        self.__wizard.addPage(self.__wp_select_source.get_wizard_page())

        self.__wizard.addPage(self.__wp_associated_features_selector.get_wizard_page())
        self.__wizard.rejected.connect(self.__view_rejected)
        self.__wizard.button(QWizard.FinishButton).clicked.connect(self.__finish_button_click)
        self.__wp_select_source.connect_signals()

        self.__wizard.button(QWizard.NextButton).clicked.connect(self.__next_button_click)
        self.__wizard.button(QWizard.HelpButton).clicked.connect(self._show_help)

    def __finish_button_click(self):
        e = CreateFeatureArgs(self.__wp_select_source.layer_creation_mode)
        self.__controller.create_feature(e)

    # it is multipage
    def __next_button_click(self):
        self.__controller.next_clicked()

    def __view_rejected(self):
        self.__controller.wizard_rejected()

    def __option_changed(self, e: EnumFeatureCreationMode):
        self.__wp_select_source.set_help_text(self.__view_config[WIZARD_SELECT_SOURCE_HELP][e])
        finish_button_text = self.__view_config[WIZARD_FINISH_BUTTON_TEXT][e]

        self.__wizard.setButtonText(QWizard.FinishButton, finish_button_text)

        # new
        self.__wp_select_source.get_wizard_page().setFinalPage(e == EnumFeatureCreationMode.REFACTOR_FIELDS)
        if e == EnumFeatureCreationMode.REFACTOR_FIELDS:
            disable_next_wizard(self.__wizard)
        else:
            enable_next_wizard(self.__wizard)
        # -||

    def _show_help(self):
        show_plugin_help(self.__view_config[WIZARD_HELP])

    def restore_settings(self, settings: dict):
        self.__wp_select_source.layer_creation_mode = settings[WIZARD_CREATION_MODE_KEY]
        self.__wp_associated_features_selector.current_parcel_type = settings[WIZARD_SELECTED_TYPE_KEY]

    def get_settings(self):
        result = {WIZARD_CREATION_MODE_KEY: self.__wp_select_source.layer_creation_mode,
                  WIZARD_SELECTED_TYPE_KEY: self.__wp_associated_features_selector.current_parcel_type}
        return result

    # wizard page 2
    def show_number_of_selected_features(self, feature_count: dict):
        self.__wp_associated_features_selector.show_number_of_selected_features(feature_count)

    def pick_features_selected(self, arg: PickFeaturesSelectedArgs):
        self.__controller.pick_features_selected(arg)
