/*
 * Decompiled with CFR 0.152.
 */
package CrytpoBusiness.business;

import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.springframework.stereotype.Component;

@Component
public class CryptoBusiness {
    private static String factoryInstance = "PBKDF2WithHmacSHA256";
    private static String cipherInstance = "AES/CBC/PKCS5PADDING";
    private static String secretKeyType = "AES";
    private static byte[] ivCode = new byte[16];

    public String encrypt(String secretKey, String salt, String value) throws Exception {
        Cipher cipher = CryptoBusiness.initCipher(secretKey, salt, 1);
        byte[] encrypted = cipher.doFinal(value.getBytes());
        byte[] cipherWithIv = CryptoBusiness.addIVToCipher(encrypted);
        return Base64.encodeBase64String((byte[])cipherWithIv);
    }

    public String decrypt(String secretKey, String salt, String encrypted) throws Exception {
        Cipher cipher = CryptoBusiness.initCipher(secretKey, salt, 2);
        byte[] original = cipher.doFinal(Base64.decodeBase64((String)encrypted));
        byte[] originalWithoutIv = Arrays.copyOfRange(original, 16, original.length);
        return new String(originalWithoutIv);
    }

    private static Cipher initCipher(String secretKey, String salt, int mode) throws Exception {
        SecretKeyFactory factory = SecretKeyFactory.getInstance(factoryInstance);
        PBEKeySpec spec = new PBEKeySpec(secretKey.toCharArray(), salt.getBytes(), 65536, 256);
        SecretKey tmp = factory.generateSecret(spec);
        SecretKeySpec skeySpec = new SecretKeySpec(tmp.getEncoded(), secretKeyType);
        Cipher cipher = Cipher.getInstance(cipherInstance);
        SecureRandom random = new SecureRandom();
        random.nextBytes(ivCode);
        cipher.init(mode, (Key)skeySpec, new IvParameterSpec(ivCode));
        return cipher;
    }

    private static byte[] addIVToCipher(byte[] encrypted) {
        byte[] cipherWithIv = new byte[ivCode.length + encrypted.length];
        System.arraycopy(ivCode, 0, cipherWithIv, 0, ivCode.length);
        System.arraycopy(encrypted, 0, cipherWithIv, encrypted.length, encrypted.length);
        return cipherWithIv;
    }
}

