# -*- coding: utf-8 -*-
"""
/***************************************************************************
 articulacaosistematica
                                 A QGIS plugin
 Gloria vai passar o material
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-03-11
        git sha              : $Format:%H$
        copyright            : (C) 2022 by Antonio Teles
        email                : antoniot.leandro@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtCore import *
from PyQt5.QtGui import *
from qgis.PyQt import QtCore
from qgis.gui import *
from PyQt5 import QtCore, QtGui
import pdb
from qgis.core import *

from qgis.gui import QgsMessageBar, QgsMapCanvas, QgsMapCanvasItem
import qgis.utils
import os
from collections import defaultdict

from shapely.wkb import loads
from osgeo import ogr
import processing

from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QFileDialog, QDialog

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .articulacaosistematica_dialog import articulacaosistematicaDialog
import os.path
import numpy as np
from datetime import *
import math

RE = 0
A2 = 0
b2 = 0
c2 = 0
A4 = 0
B4 = 0
c4 = 0
OTIME = 0
OALT = 0
OLAT = 0
MAXORD = 0
DEC = 0
DIP = 0
ti = 0

a = []
b = []
SP = []
CP = []
p = []
pp = []
PP = []
DP = []
c = []
CD = []
SNORM = []
k = []
fn = []
FM = []
TC = []
MAG = []


i = 0
for i in range(9):
    MAG.append([0, 0, 0])
    i += 0

i = 0
for i in range(13):
    c.append([0]) 
    p.append([0]) 
    DP.append([0]) 
    CD.append([0])
    SNORM.append([0])
    k.append([0])
    fn.append(0)
    FM.append(0)
    SP.append(0)
    CP.append(0)
    PP.append(0)
    TC.append([0])
    ii = 0
    for ii in range(13):
        c[i].append(0)
        p[i].append(0) 
        DP[i].append(0) 
        CD[i].append(0) 
        SNORM[i].append(0)
        k[i].append(0)
        TC[i].append(0)
        ii += 1 
    i += 1

def parametrosEscalas(escala):
    paramentos = []
    if escala == '1:1.000':
        paramentos.append(1000) #Escala
        paramentos.append(0.0052083333333333) #DimenLat
        paramentos.append(0.0052083333333333) #DimenLong
        paramentos.append(2) #DivMenorLat
        paramentos.append(2) #DivMenorLong
    elif escala == '1:2.000':
        paramentos.append(2000)
        paramentos.append(0.0104166666666667)
        paramentos.append(0.0104166666666667)
        paramentos.append(2)
        paramentos.append(3) 
    elif escala == '1:5.000':
        paramentos.append(5000)
        paramentos.append(0.0208333333333334)
        paramentos.append(0.03125)
        paramentos.append(2)
        paramentos.append(2)
    elif escala == '1:10.000':
        paramentos.append(10000)
        paramentos.append(0.0416666666666667)
        paramentos.append(0.0625)
        paramentos.append(3)
        paramentos.append(2)
    elif escala == '1:25.000':
        paramentos.append(25000)
        paramentos.append(0.125)
        paramentos.append(0.125)
        paramentos.append(2)
        paramentos.append(2)
    elif escala == '1:50.000':
        paramentos.append(50000)
        paramentos.append(0.25)
        paramentos.append(0.25)
        paramentos.append(2)
        paramentos.append(2)
    elif escala == '1:100.000':
        paramentos.append(100000)
        paramentos.append(0.5)
        paramentos.append(0.5)
        paramentos.append(2)
        paramentos.append(3)
    elif escala == '1:250.000':
        paramentos.append(250000)
        paramentos.append(1)
        paramentos.append(1.5)
        paramentos.append(2)
        paramentos.append(2)
    elif escala == '1:500.000':
        paramentos.append(500000)
        paramentos.append(2)
        paramentos.append(3)
        paramentos.append(2)
        paramentos.append(2)
    elif escala == '1:1.000.000':
        paramentos.append(1000000)
        paramentos.append(4)
        paramentos.append(6)
        paramentos.append(11)
        paramentos.append(7)
    return paramentos
    
def nomeFolha1(coord):
    dbTamLatLong = []
    iNumDivLatLong = []
    INDLatLong = []
    dbLimiteLatLong = []
    dbAuxLatLong = []

    dbTamLatLong.append(1.04166666666667E-02)
    dbTamLatLong.append(1.04166666666667E-02)
    iNumDivLatLong.append(2)
    iNumDivLatLong.append(2)
    
    MatLetras = []
    MatLetras.append(["B", "A"])
    MatLetras.append(["D", "C"])

    LL = 0
    dbLimiteLatLong.append(1/iNumDivLatLong[LL])
    dbAuxLatLong.append(coord[1] / dbTamLatLong[LL])
    dbAuxLatLong[LL] = abs(dbAuxLatLong[LL] - int(dbAuxLatLong[LL]))
    if iNumDivLatLong[LL] == 2:
        if dbAuxLatLong[LL] <= dbLimiteLatLong[LL]:
            INDLatLong.append(0)
        else:
            INDLatLong.append(1)
    else:
        if dbAuxLatLong[LL] <= dbLimiteLatLong[LL]:
            INDLatLong.append(0)
        elif abs(dbAuxLatLong[LL]) <= 2 * dbLimiteLatLong[LL]:
            INDLatLong.append(1)
        else:
            INDLatLong.append(2)

    LL = 1
    dbLimiteLatLong.append(1 / iNumDivLatLong[LL])
    dbAuxLatLong.append(coord[0] / dbTamLatLong[LL])
    dbAuxLatLong[LL] = abs(dbAuxLatLong[LL] - int(dbAuxLatLong[LL]))
    if iNumDivLatLong[LL] == 2 :
        if dbAuxLatLong[LL] <= dbLimiteLatLong[LL]:
            INDLatLong.append(0)
        else:
            INDLatLong.append(1)
    else:
        if dbAuxLatLong[LL] <= dbLimiteLatLong[LL]:
            INDLatLong.append(0)
        elif dbAuxLatLong[LL] <= 2 * dbLimiteLatLong[LL]:
            INDLatLong.append(1)
        else:
            INDLatLong.append(2)

    NomSup = nomeFolha2(coord)
    NomeFolha1 = NomSup + "-" + MatLetras[INDLatLong[0]][INDLatLong[1]]
    return NomeFolha1

    
def nomeFolha2(coord):
    dbTamLatLong = []
    iNumDivLatLong = []
    INDLatLong = []
    dbLimiteLatLong = []
    dbAuxLatLong = []
    
    dbTamLatLong.append(2.08333333333333E-02)
    dbTamLatLong.append(0.03125)
    iNumDivLatLong.append(2)
    iNumDivLatLong.append(3)
    
    MatLetras = []
    MatLetras.append(["3", "2", "1"])
    MatLetras.append(["6", "5", "4"])
    
    
    LL = 0
    dbLimiteLatLong.append(1 / iNumDivLatLong[LL])
    dbAuxLatLong.append(coord[1] / dbTamLatLong[LL])
    dbAuxLatLong[LL] = abs(dbAuxLatLong[LL] - int(dbAuxLatLong[LL]))
    if iNumDivLatLong[LL] == 2:
        if dbAuxLatLong[LL] <= dbLimiteLatLong[LL]:
            INDLatLong.append(0)
        else:
            INDLatLong.append(1)
    else:
        if dbAuxLatLong[LL] <= dbLimiteLatLong[LL]:
            INDLatLong.append(0)
        elif dbAuxLatLong[LL] <= 2 * dbLimiteLatLong[LL]:
            INDLatLong.append(1)
        else:
            INDLatLong.append(2)
    
    LL = 1
    dbLimiteLatLong.append(1 / iNumDivLatLong[LL])
    dbAuxLatLong.append(coord[0] / dbTamLatLong[LL])
    dbAuxLatLong[LL] = abs(dbAuxLatLong[LL] - int(dbAuxLatLong[LL]))
    if iNumDivLatLong[LL] == 2:
        if dbAuxLatLong[LL] <= dbLimiteLatLong[LL]:
            INDLatLong.append(0)
        else:
            INDLatLong.append(1)
    else:
        if dbAuxLatLong[LL] <= dbLimiteLatLong[LL]:
            INDLatLong.append(0)
        elif dbAuxLatLong[LL] <= 2 * dbLimiteLatLong[LL]:
            INDLatLong.append(1)
        else:
            INDLatLong.append(2)
            
    NomSup = nomeFolha5(coord)
    NomeFolha2 = NomSup + "-" + MatLetras[INDLatLong[0]][INDLatLong[1]]
    return NomeFolha2
 
def nomeFolha5(coord):    
    dbTamLatLong = []
    iNumDivLatLong = []
    INDLatLong = []
    dbLimiteLatLong = []
    dbAuxLatLong = []
    
    dbTamLatLong.append(4.16666666666667E-02)
    dbTamLatLong.append(0.0625)
    iNumDivLatLong.append(2)
    iNumDivLatLong.append(2)
    
    MatLetras = []
    MatLetras.append(["II", "I"]) 
    MatLetras.append(["IV", "III"])
    
    LL = 0
    dbLimiteLatLong.append(1 / iNumDivLatLong[LL])
    dbAuxLatLong.append(coord[1] / dbTamLatLong[LL])
    dbAuxLatLong[LL] = abs(dbAuxLatLong[LL] - int(dbAuxLatLong[LL]))
    if iNumDivLatLong[LL] == 2:
        if dbAuxLatLong[LL] <= dbLimiteLatLong[LL]:
            INDLatLong.append(0)
        else:
            INDLatLong.append(1)
    else:
        if dbAuxLatLong[LL] <= dbLimiteLatLong[LL]:
            INDLatLong.append(0)
        elif dbAuxLatLong[LL] <= 2 * dbLimiteLatLong[LL]:
            INDLatLong.append(1)
        else:
            INDLatLong.append(2)
    
    LL = 1
    dbLimiteLatLong.append(1 / iNumDivLatLong[LL])
    dbAuxLatLong.append(coord[0] / dbTamLatLong[LL])
    dbAuxLatLong[LL] = abs(dbAuxLatLong[LL] - int(dbAuxLatLong[LL]))
    if iNumDivLatLong[LL] == 2:
        if dbAuxLatLong[LL] <= dbLimiteLatLong[LL]:
            INDLatLong.append(0)
        else:
            INDLatLong.append(1)
    else:
        if dbAuxLatLong[LL] <= dbLimiteLatLong[LL]:
            INDLatLong.append(0)
        elif dbAuxLatLong[LL] <= 2 * dbLimiteLatLong[LL]:
            INDLatLong.append(1)
        else:
            INDLatLong.append(2)
         
    NomSup = nomeFolha10(coord)
    NomeFolha5 = NomSup + "-" + MatLetras[INDLatLong[0]][INDLatLong[1]] 
    return NomeFolha5 
    
def nomeFolha10(coord):    
    dbTamLatLong = []
    iNumDivLatLong = []
    INDLatLong = []
    dbLimiteLatLong = []
    dbAuxLatLong = []
    
    dbTamLatLong.append(0.125)
    dbTamLatLong.append(0.125)
    iNumDivLatLong.append(3)
    iNumDivLatLong.append(2)
    
    MatLetras = []
    MatLetras.append(["B", "A"])
    MatLetras.append(["D", "C"]) 
    MatLetras.append(["F", "E"])
    
    LL = 0
    dbLimiteLatLong.append(1 / iNumDivLatLong[LL])
    dbAuxLatLong.append(coord[1] / dbTamLatLong[LL])
    dbAuxLatLong[LL] = abs(dbAuxLatLong[LL] - int(dbAuxLatLong[LL]))
    if iNumDivLatLong[LL] == 2:
        if dbAuxLatLong[LL] <= dbLimiteLatLong[LL]:
            INDLatLong.append(0)
        else:
            INDLatLong.append(1)
    else:
        if dbAuxLatLong[LL] <= dbLimiteLatLong[LL]:
            INDLatLong.append(0)
        elif dbAuxLatLong[LL] <= 2 * dbLimiteLatLong[LL]:
            INDLatLong.append(1)
        else:
            INDLatLong.append(2)
    
    LL = 1
    dbLimiteLatLong.append(1 / iNumDivLatLong[LL])
    dbAuxLatLong.append(coord[0] / dbTamLatLong[LL])
    dbAuxLatLong[LL] = abs(dbAuxLatLong[LL] - int(dbAuxLatLong[LL]))
    if iNumDivLatLong[LL] == 2:
        if dbAuxLatLong[LL] <= dbLimiteLatLong[LL]:
            INDLatLong.append(0)
        else:
            INDLatLong.append(1)
    else:
        if dbAuxLatLong[LL] <= dbLimiteLatLong[LL]:
            INDLatLong.append(0)
        elif dbAuxLatLong[LL] <= 2 * dbLimiteLatLong[LL]:
            INDLatLong.append(1)
        else:
            INDLatLong.append(2)
         
    NomSup = nomeFolha25(coord)
    NomeFolha10 = NomSup + "-" + MatLetras[INDLatLong[0]][INDLatLong[1]]
    return NomeFolha10 
    
def nomeFolha25(coord):    
    dbTamLatLong = []
    iNumDivLatLong = []
    INDLatLong = []
    dbLimiteLatLong = []
    dbAuxLatLong = []
    
    dbTamLatLong.append(0.25)
    dbTamLatLong.append(0.25)
    iNumDivLatLong.append(2)
    iNumDivLatLong.append(2)
    
    MatLetras = []
    MatLetras.append(["NE", "NO"])
    MatLetras.append(["SE", "SO"])
    
    LL = 0
    dbLimiteLatLong.append(1 / iNumDivLatLong[LL])
    dbAuxLatLong.append(coord[1] / dbTamLatLong[LL])
    dbAuxLatLong[LL] = abs(dbAuxLatLong[LL] - int(dbAuxLatLong[LL]))
    if iNumDivLatLong[LL] == 2:
        if dbAuxLatLong[LL] <= dbLimiteLatLong[LL]:
            INDLatLong.append(0)
        else:
            INDLatLong.append(1)
    else:
        if dbAuxLatLong[LL] <= dbLimiteLatLong[LL]:
            INDLatLong.append(0)
        elif dbAuxLatLong[LL] <= 2 * dbLimiteLatLong[LL]:
            INDLatLong.append(1)
        else:
            INDLatLong.append(2)
    
    LL = 1
    dbLimiteLatLong.append(1 / iNumDivLatLong[LL])
    dbAuxLatLong.append(coord[0] / dbTamLatLong[LL])
    dbAuxLatLong[LL] = abs(dbAuxLatLong[LL] - int(dbAuxLatLong[LL]))
    if iNumDivLatLong[LL] == 2:
        if dbAuxLatLong[LL] <= dbLimiteLatLong[LL]:
            INDLatLong.append(0)
        else:
            INDLatLong.append(1)
    else:
        if dbAuxLatLong[LL] <= dbLimiteLatLong[LL]:
            INDLatLong.append(0)
        elif dbAuxLatLong[LL] <= 2 * dbLimiteLatLong[LL]:
            INDLatLong.append(1)
        else:
            INDLatLong.append(2)
         
    NomSup = nomeFolha50(coord)
    NomeFolha25 = NomSup + "-" + MatLetras[INDLatLong[0]][INDLatLong[1]]
    return NomeFolha25 

def nomeFolha50(coord):    
    dbTamLatLong = []
    iNumDivLatLong = []
    INDLatLong = []
    dbLimiteLatLong = []
    dbAuxLatLong = []
    
    dbTamLatLong.append(0.5)
    dbTamLatLong.append(0.5)
    iNumDivLatLong.append(2)
    iNumDivLatLong.append(2)
    
    MatLetras = []
    MatLetras.append(["2", "1"])
    MatLetras.append(["4", "3"])
     
    LL = 0
    dbLimiteLatLong.append(1 / iNumDivLatLong[LL])
    dbAuxLatLong.append(coord[1] / dbTamLatLong[LL])
    dbAuxLatLong[LL] = abs(dbAuxLatLong[LL] - int(dbAuxLatLong[LL]))
    if iNumDivLatLong[LL] == 2:
        if dbAuxLatLong[LL] <= dbLimiteLatLong[LL]:
            INDLatLong.append(0)
        else:
            INDLatLong.append(1)
    else:
        if dbAuxLatLong[LL] <= dbLimiteLatLong[LL]:
            INDLatLong.append(0)
        elif dbAuxLatLong[LL] <= 2 * dbLimiteLatLong[LL]:
            INDLatLong.append(1)
        else:
            INDLatLong.append(2)
    
    LL = 1
    dbLimiteLatLong.append(1 / iNumDivLatLong[LL])
    dbAuxLatLong.append(coord[0] / dbTamLatLong[LL])
    dbAuxLatLong[LL] = abs(dbAuxLatLong[LL] - int(dbAuxLatLong[LL]))
    if iNumDivLatLong[LL] == 2:
        if dbAuxLatLong[LL] <= dbLimiteLatLong[LL]:
            INDLatLong.append(0)
        else:
            INDLatLong.append(1)
    else:
        if dbAuxLatLong[LL] <= dbLimiteLatLong[LL]:
            INDLatLong.append(0)
        elif dbAuxLatLong[LL] <= 2 * dbLimiteLatLong[LL]:
            INDLatLong.append(1)
        else:
            INDLatLong.append(2)
         
    NomSup = nomeFolha100(coord)
    NomeFolha50 = NomSup + "-" + MatLetras[INDLatLong[0]][INDLatLong[1]] 
    return NomeFolha50

def nomeFolha100(coord):    
    dbTamLatLong = []
    iNumDivLatLong = []
    INDLatLong = []
    dbLimiteLatLong = []
    dbAuxLatLong = []
    
    dbTamLatLong.append(1)
    dbTamLatLong.append(1.5)
    iNumDivLatLong.append(2)
    iNumDivLatLong.append(3)
    
    MatLetras = []
    MatLetras.append(["III", "II", "I"]) 
    MatLetras.append(["VI", "V", "IV"])

    LL = 0
    dbLimiteLatLong.append(1 / iNumDivLatLong[LL])
    dbAuxLatLong.append(coord[0] / dbTamLatLong[LL])
    dbAuxLatLong[LL] = abs(dbAuxLatLong[LL] - int(dbAuxLatLong[LL]))
    if iNumDivLatLong[LL] == 2:
        if dbAuxLatLong[LL] <= dbLimiteLatLong[LL]:
            INDLatLong.append(0)
        else:
            INDLatLong.append(1)
    else:
        if dbAuxLatLong[LL] <= dbLimiteLatLong[LL]:
            INDLatLong.append(0)
        elif dbAuxLatLong[LL] <= 2 * dbLimiteLatLong[LL]:
            INDLatLong.append(1)
        else:
            INDLatLong.append(2)
    
    LL = 1
    dbLimiteLatLong.append(1 / iNumDivLatLong[LL])
    dbAuxLatLong.append(coord[0] / dbTamLatLong[LL])
    dbAuxLatLong[LL] = abs(dbAuxLatLong[LL] - int(dbAuxLatLong[LL]))
    if iNumDivLatLong[LL] == 2:
        if dbAuxLatLong[LL] <= dbLimiteLatLong[LL]:
            INDLatLong.append(0)
        else:
            INDLatLong.append(1)
    else:
        if dbAuxLatLong[LL] <= dbLimiteLatLong[LL]:
            INDLatLong.append(0)
        elif dbAuxLatLong[LL] <= 2 * dbLimiteLatLong[LL]:
            INDLatLong.append(1)
        else:
            INDLatLong.append(2)
         
    NomSup = nomeFolha250(coord)
    NomeFolha100 = NomSup + "-" + MatLetras[INDLatLong[0]][INDLatLong[1]] 
    return NomeFolha100

def nomeFolha250(coord):    
    dbTamLatLong = []
    iNumDivLatLong = []
    INDLatLong = []
    dbLimiteLatLong = []
    dbAuxLatLong = []
    
    dbTamLatLong.append(2)
    dbTamLatLong.append(3)
    iNumDivLatLong.append(2)
    iNumDivLatLong.append(2)
    
    MatLetras = []
    MatLetras.append(["B", "A"]) 
    MatLetras.append(["D", "C"])

    LL = 0
    dbLimiteLatLong.append(1 / iNumDivLatLong[LL])
    dbAuxLatLong.append(coord[1] / dbTamLatLong[LL])
    dbAuxLatLong[LL] = abs(dbAuxLatLong[LL] - int(dbAuxLatLong[LL]))
    if iNumDivLatLong[LL] == 2:
        if dbAuxLatLong[LL] <= dbLimiteLatLong[LL]:
            INDLatLong.append(0)
        else:
            INDLatLong.append(1)
    else:
        if dbAuxLatLong[LL] <= dbLimiteLatLong[LL]:
            INDLatLong.append(0)
        elif dbAuxLatLong[LL] <= 2 * dbLimiteLatLong[LL]:
            INDLatLong.append(1)
        else:
            INDLatLong.append(2)
    
    LL = 1
    dbLimiteLatLong.append(1 / iNumDivLatLong[LL])
    dbAuxLatLong.append(coord[0] / dbTamLatLong[LL])
    dbAuxLatLong[LL] = abs(dbAuxLatLong[LL] - int(dbAuxLatLong[LL]))
    if iNumDivLatLong[LL] == 2:
        if dbAuxLatLong[LL] <= dbLimiteLatLong[LL]:
            INDLatLong.append(0)
        else:
            INDLatLong.append(1)
    else:
        if dbAuxLatLong[LL] <= dbLimiteLatLong[LL]:
            INDLatLong.append(0)
        elif dbAuxLatLong[LL] <= 2 * dbLimiteLatLong[LL]:
            INDLatLong.append(1)
        else:
            INDLatLong.append(2)
         
    NomSup = nomeFolha500(coord)
    NomeFolha250 = NomSup + "-" + MatLetras[INDLatLong[0]][INDLatLong[1]] 
    return NomeFolha250

def nomeFolha500(coord):    
    dbTamLatLong = []
    iNumDivLatLong = []
    INDLatLong = []
    dbLimiteLatLong = []
    dbAuxLatLong = []
    
    dbTamLatLong.append(4)
    dbTamLatLong.append(6)
    iNumDivLatLong.append(2)
    iNumDivLatLong.append(2)
    
    MatLetras = []
    MatLetras.append(["X", "V"]) 
    MatLetras.append(["Z", "Y"])   

    LL = 0
    dbLimiteLatLong.append(1 / iNumDivLatLong[LL])
    dbAuxLatLong.append(coord[1] / dbTamLatLong[LL])
    dbAuxLatLong[LL] = abs(dbAuxLatLong[LL] - int(dbAuxLatLong[LL]))
    if iNumDivLatLong[LL] == 2:
        if dbAuxLatLong[LL] <= dbLimiteLatLong[LL]:
            INDLatLong.append(0)
        else:
            INDLatLong.append(1)
    else:
        if dbAuxLatLong[LL] <= dbLimiteLatLong[LL]:
            INDLatLong.append(0)
        elif dbAuxLatLong[LL] <= 2 * dbLimiteLatLong[LL]:
            INDLatLong.append(1)
        else:
            INDLatLong.append(2)
    
    LL = 1
    dbLimiteLatLong.append(1 / iNumDivLatLong[LL])
    dbAuxLatLong.append(coord[0] / dbTamLatLong[LL])
    dbAuxLatLong[LL] = abs(dbAuxLatLong[LL] - int(dbAuxLatLong[LL]))
    if iNumDivLatLong[LL] == 2:
        if dbAuxLatLong[LL] <= dbLimiteLatLong[LL]:
            INDLatLong.append(0)
        else:
            INDLatLong.append(1)
    else:
        if dbAuxLatLong[LL] <= dbLimiteLatLong[LL]:
            INDLatLong.append(0)
        elif dbAuxLatLong[LL] <= 2 * dbLimiteLatLong[LL]:
            INDLatLong.append(1)
        else:
            INDLatLong.append(2)
         
    NomSup = nomeFolha1M(coord)
    NomeFolha500 = NomSup + "-" + MatLetras[INDLatLong[0]][INDLatLong[1]] 
    
    return NomeFolha500

def nomeFolha1M(coord):    
    cAlt = 4
    cLar = 6
    VetLetra = ["A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V"]
    
    if coord[1] < 0 :
        Hemisf = "S"
    else:
        Hemisf = "N"

    Aux = abs(coord[1])
    Aux = Aux / cAlt
    Aux = int(Aux)
    Letra = VetLetra[Aux] 
    
    Aux = abs(coord[0])
    Aux = Aux / cLar
    Aux = int(Aux)
    Aux = 30 - Aux
    
    Fuso = Aux
    NomeFolha1M = Hemisf + Letra + "." + str(Fuso)
    return NomeFolha1M
    
def centro_folha(coord): #lo , la
    parametros = parametrosEscalas(escalafinal)
    dbAuxLatLong = []
    dbTamLatLong = []
    centro = []

    dbTamLatLong.append(parametros[1])
    dbAuxLatLong.append(coord[1])
    
    dbAuxLatLong[0] = np.fix(dbAuxLatLong[0] / dbTamLatLong[0])
    if coord[1] < 0: 
        dbAuxLatLong[0] = dbAuxLatLong[0] - 0.5
    else:
        dbAuxLatLong[0] = dbAuxLatLong[0] - 0.5
        
    dbAuxLatLong[0] = dbAuxLatLong[0] * dbTamLatLong[0]

    dbTamLatLong.append(parametros[2])
    dbAuxLatLong.append(coord[0])
    
    dbAuxLatLong[1] = np.fix(dbAuxLatLong[1] / dbTamLatLong[1])
    if coord[1] < 0 :
        dbAuxLatLong[1] = dbAuxLatLong[1] - 0.5
    else:
        dbAuxLatLong[1] = dbAuxLatLong[1] - 0.5

    dbAuxLatLong[1] = dbAuxLatLong[1] * dbTamLatLong[1]
    
    centro.append(dbAuxLatLong[1])
    centro.append(dbAuxLatLong[0])
    return centro
    
def gerarfolhas(coord, sRs):
    dbTamLat = parametrosEscalas(escalafinal)[1]
    dbTamLong = parametrosEscalas(escalafinal)[2]

    L1mil = parametrosEscalas('1:1.000')[1]       
    
    lQVLat = dbTamLat / L1mil
    lQVLong = dbTamLong / L1mil    
    
    LInla = coord[1] + dbTamLat / 2
    LInlo = coord[0] + dbTamLong / 2  

    LRefla = LInla
    LReflo = LInlo
    
    sVert = []
    j = 1
    
    for j in range(int(lQVLat)):
        LRefla = LRefla - L1mil
        NumRef = LRefla / L1mil

        LRefla = NumRef * L1mil
        sVert.append(QgsPointXY(round(LReflo, 8), round(LRefla, 8)))
        j += 1
    j = 1    
    for j in range(int(lQVLong)):
        LReflo = LReflo - L1mil
        NumRef = LReflo / L1mil
        LReflo = NumRef * L1mil
        sVert.append(QgsPointXY(round(LReflo, 8), round(LRefla, 8)))
        j += 1
    j = 1    
    for j in range(int(lQVLat)):
        LRefla = LRefla + L1mil
        NumRef = LRefla / L1mil
        LRefla = NumRef * L1mil
        sVert.append(QgsPointXY(round(LReflo, 8), round(LRefla, 8)))
        j += 1
    j = 1
    for j in range(int(lQVLong)):
        LReflo = LReflo + L1mil
        NumRef = LReflo / L1mil
        LReflo =NumRef * L1mil
        sVert.append(QgsPointXY(round(LReflo, 8), round(LRefla, 8)))
        j += 1
    if escalafinal == '1:1.000':
        nome_folha = nomeFolha1(coord)
    elif escalafinal == '1:2.000':
        nome_folha = nomeFolha2(coord)
    elif escalafinal == '1:5.000':
        nome_folha = nomeFolha5(coord)
    elif escalafinal == '1:10.000':
        nome_folha = nomeFolha10(coord)
    elif escalafinal == '1:25.000':
        nome_folha = nomeFolha25(coord)
    elif escalafinal == '1:50.000':
        nome_folha = nomeFolha50(coord)
    elif escalafinal == '1:100.000':
        nome_folha = nomeFolha100(coord)
    elif escalafinal == '1:250.000':
        nome_folha = nomeFolha250(coord)
    elif escalafinal == '1:500.000':
        nome_folha = nomeFolha500(coord)
    elif escalafinal == '1:1.000.000':
        nome_folha = nomeFolha1M(coord)
    
    if gerarDados:
        kppa = kappa(coord, sRs)
        dec_vari = declinacao(coord)
        conv = convergencia(coord)
    
    
    if sRs != 4326:
        coords_final = converter_coords_utm(sVert, sRs)
    else:
        coords_final = sVert
        
    feature_Polygon = QgsFeature()
    geom_Polygon =  QgsGeometry.fromPolygonXY([coords_final])
    feature_Polygon.setGeometry(geom_Polygon)
    
    if gerarDados:
        feature_Polygon.setAttributes([nome_folha, kppa, conv, dec_vari[0], dec_vari[1]])
    else:
        feature_Polygon.setAttributes([nome_folha])
    pr_shape_polygon.addFeature(feature_Polygon)

def converter_coords_geo(coord, origem):
    origemCrs = QgsCoordinateReferenceSystem(int(origem))
    destinoCrs = QgsCoordinateReferenceSystem(4326)
    tr = QgsCoordinateTransform(origemCrs, destinoCrs, QgsProject.instance())
    cd = tr.transform(coord)
    return cd

def converter_coords_utm_g(coord, destino):
    origemCrs = QgsCoordinateReferenceSystem(4326)
    destinoCrs = QgsCoordinateReferenceSystem(int(destino))
    tr = QgsCoordinateTransform(origemCrs, destinoCrs, QgsProject.instance())
    cd = tr.transform(coord)
    return cd

def converter_coords_utm(coord, destino):
    coords_atual = []
    for c in coord:
        origemCrs = QgsCoordinateReferenceSystem(4326)
        destinoCrs = QgsCoordinateReferenceSystem(int(destino))
        tr = QgsCoordinateTransform(origemCrs, destinoCrs, QgsProject.instance())
        coords_atual.append(tr.transform(c))
    return coords_atual

def FMcentro(coord): 
    FMcentro = []
    cAlt = 4
    cLar = 6
    
    if coord[1] < 0 :
        Hemisf = "-"
    else:
        Hemisf = ""

    if coord[0] < 0 :
        Hemisfa = "-"
        Hemis = -1
    else:
        Hemisfa = ""
        Hemis = 1

    Aux = abs(coord[0])
    Aux = Aux / cLar
    Aux = int(Aux)
    Aux = 30 - Aux
    FMcentro.append(str(Hemisf + str(Aux)))

    Aux = 180 - (Aux * 6 - 3)
    FMcentro.append(str(Hemisfa + str(Aux)))
    FMcentro.append(Hemis)
    return FMcentro 

def kappa(coord, sRs):
    utmE = coord[0]
    utmN = coord[1]

    fmgt = FMcentro(coord)
    kappa_f = kappa_func(utmN, utmE, sRs) 
    kappa_f = round(kappa_f, 9)
    return kappa_f

def kappa_func(N_UTM, E_UTM, sRs):
    pi = 3.14159265358979
    K0 = 0.9996
    if sistemaProj == "WGS84":
            Achata = 1 / 298.257223563
            EixoMaior = 6378137
            EixoMenor = (EixoMaior - (Achata * EixoMaior))
            codElipsoide = 0
    elif sistemaProj == "SIRGAS":
            Achata = 1 / 298.257222101
            EixoMaior = 6378137
            EixoMenor = EixoMaior - (Achata * EixoMaior)
            codElipsoide = 3
    
    Lon = E_UTM
    Lat = N_UTM

    fi = Lat * pi / 180

    e2 = (math.pow(EixoMaior, 2) - math.pow(EixoMenor, 2)) / math.pow(EixoMaior, 2)
    GNormal = EixoMaior / math.sqrt(math.pow(1 - e2 * (math.sin(fi)), 2))

    RCSMeridiana = (EixoMaior * (1 - e2)) / (math.pow((1 - e2 * math.pow(math.sin(fi), 2)), (3 / 2)))
    RMedio = math.sqrt(GNormal * RCSMeridiana)
    geom = QgsPointXY(Lon,Lat)

    utm = Geo_UTM([E_UTM,N_UTM])

    EE = abs(utm[1] - 500000)
    
    KAPPA = (K0 * (1 + ((math.pow(EE, 2)) / (2 * (math.pow(RMedio, 2)))) + ((math.pow(EE, 4)) / (24 * (math.pow(RMedio, 4))))))
    return KAPPA

def convergencia(coord):
    utmE = coord[0]
    utmN = coord[1]

    fmgt = FMcentro(coord)
    CM = conv_mer(utmN, utmE, fmgt[1])
    
    cm_gr = np.fix(CM / 3600)
    cm_min = abs(np.fix((CM - cm_gr * 3600) / 60))
    cm_sec = (abs(CM) - cm_gr * 3600 - cm_min * 60)
    if int(np.sign(CM)) == -1:
        if int(cm_gr) == 0:
            nf = "-0" 
        else:
            nf = str(int(cm_gr))
    else:
        if int(cm_gr) == 0:
            nf = "-0" 
        else:
            nf = str("-"+ str(int(cm_gr)))

    convergencia_f = str(nf + "°" + str(int(cm_min)) + "'" + str(round(cm_sec, 2)) + '"')
    return convergencia_f

def conv_mer(N_UTM, E_UTM, MC):
    pi = 3.14159265358979
    S1Seg = 4.848136811076E-06 
    if sistemaProj == "WGS84" :
            Achata = 1 / 298.257223563
            EixoMaior = 6378137
            EixoMenor = (EixoMaior - (Achata * EixoMaior))
            codElipsoide = 0
    elif sistemaProj == "SIRGAS":
            Achata = 1 / 298.257222101
            EixoMaior = 6378137
            EixoMenor = EixoMaior - (Achata * EixoMaior)
            codElipsoide = 3

    Lon = E_UTM
    Lat = N_UTM

    dLon = (Lon - int(MC)) * 3600
    
    CM = dLon * math.sin(Lat * pi / 180)
    cm_gr = np.fix(CM / 3600)
    cm_min = abs(np.fix((CM - cm_gr * 3600) / 60))
    cm_sec = (abs(CM) - cm_gr * 3600 - cm_min * 60)
    
    p = 0.0001 * (dLon)
    XII = math.sin(Lat * pi / 180) * 10000
    LatR = Lat * pi / 180
    e2 = 0
    XIII = ((math.pow(S1Seg, 2) * math.sin(LatR) * math.pow((math.cos(LatR)), 2)) / 3) * (1 + 3 * e2 * (math.pow(math.cos(LatR), 2)) + 2 * e2 * math.pow(math.cos(Lat), 4)) * 1000000000000
    
    e2 = (math.pow(EixoMaior, 2) - math.pow(EixoMenor, 2)) / math.pow(EixoMenor, 2)
    
    A1 = (math.pow(S1Seg, 4) * math.sin(LatR) * math.pow((math.cos(LatR)), 4)) / 15
    b1 = (math.pow(2 - (math.sin(LatR) / math.cos(LatR)), 2)) * 1E+20
    C5 = A1 * b1
    
    calc = XII * p + XIII * math.pow(p, 3) + C5 * math.pow(p, 5)
    return calc
    
def declinacao(coord):
    Lon = coord[0]
    Lat = coord[1]
    dbAlt = 1000

    sDia = datadados.day
    sMes = datadados.month
    sAno = datadados.year

    dataC = date(sAno, sMes, sDia)
    dataI = date(sAno, 1, 1)
    dias = dataC - dataI
    dbTime = sAno + dias.days / 365

    decMag = geoMDR(Lat, Lon, dbAlt, dbTime)

    dG = np.fix(decMag[0])
    dm = np.fix((abs(decMag[0]) - abs(dG)) * 60)
    DS = (abs(decMag[0]) - abs(dG) - dm / 60) * 3600

    Decli = str(str(int(dG)) + "°" + f'{int(dm):02d}' + "'" + f'{int(DS):02d}')

    dm = abs(np.fix(decMag[1]))
    DS = (abs(decMag[1]) - abs(dm)) * 60
    if np.sign(decMag[1]) == -1:
        dmg = "-" 
    else:
        dmg = "" 

    varDecli = str(dmg + "0°" + f'{int(dm):02d}' + "'" + f'{int(DS):02d}')
    return [Decli, varDecli]

def geoMDR(GLATS, GLONW, ALT, TIME):
    global SP, CP, p, pp, PP, DP, c, CD, SNORM, k, fn, FM, TC, MAG, a, b, RE, A2, b2, c2, A4, B4, c4, OTIME, OALT, OLAT, MAXORD, DEC, DIP, ti

    MAX_MPTS = 360 * 60
    pi = 3.14159265359
    DTR = pi / 180
    GV = 0

    MAXDEG = 12
    #GEOMAG
    dir_path = os.path.dirname(os.path.realpath(__file__))
    sFile = open(dir_path + "/WMM.COF") 
    content = sFile.readlines()
    EPOCH = int(content[0][4:8])
    if MAXDEG > 12:
        MAXDEG = 12  

    MAXORD = MAXDEG
    SP[0] = 0
    CP[0] = 1
    p[0][0] = 1
    PP[0] = 1
    DP[0][0] = 0
    a = 6378137
    b = 6356752
    b = b + 0.3141
    RE = 6371.2
    A2 = math.pow(divisao(a, 1000), 2)
    b2 = math.pow(divisao(b, 1000), 2)
    c2 = A2 - b2
    A4 = math.pow(A2, 2)
    B4 = math.pow(b2, 2)
    c4 = A4 - B4
    c[0][0] = 0
    CD[0][0] = 0  

    qlinha = 1
    while qlinha < 91:
        N = int(content[qlinha][1:3])
        m = int(content[qlinha][4:6])
        GNM = float(content[qlinha][8:16])
        HNM = float(content[qlinha][19:26])
        DGNM = float(content[qlinha][31:37])
        DHNM = float(content[qlinha][40:48])                           
        if m <= N:
            c[N][m] = GNM
            CD[N][m] = DGNM
            if m != 0:
                c[m - 1][N] = HNM
                CD[m - 1][N] = DHNM
        qlinha += 1
    sFile.close()
    SNORM[0][0] = 1  
    for N in range(1, MAXORD + 1):
        SNORM[N][0] = divisao(SNORM[N - 1][0] * float(2 * N - 1), float(N)) 
        j = 2
        m = 0
        for m in range(m, N + 1):
            k[N][m] = float(((N - 1) * (N - 1)) - (m * m)) / float((2 * N - 1) * (2 * N - 3))
            if m > 0:
                FLNMJ = float((N - m + 1) * j) / float(N + m)
                SNORM[N][m] = SNORM[N][m - 1] * math.sqrt(FLNMJ)
                j = 1
                c[m - 1][N] = SNORM[N][m] * c[m - 1][N]
                CD[m - 1][N] = SNORM[N][m] * CD[m - 1][N]
            c[N][m] = SNORM[N][m] * c[N][m]
            CD[N][m] = SNORM[N][m] * CD[N][m]
        fn[N] = float(N + 1)
        FM[N] = float(N)


    k[1][1] = 0
    OTIME = -1000
    OALT = -1000
    OLAT = -1000

    EPOCH2 = EPOCH
    ALT = ALT / 1000
    GLATN = GLATS
    GLONE = GLONW
    grid = 1
    TIM = TIME + 1
    dt = TIME - EPOCH

    if GLATS > 0:
        GLATSD = "N"
    else:
        GLATSD = "S"

    if GLATN > 0:
        GLATND = "N"
    else:
        GLATND = "S"

    if GLONW > 0:
        GLONWD = "E"
    else:
        GLONWD = "W"

    if GLONE > 0:
        GLONED = "E"
    else:
        GLONED = "W"
    NPTS = (GLATN - GLATS) * 60 / grid + 1
    MPTS = (GLONE - GLONW) * 60 / grid + 1

    for N in range(1, int(NPTS) + 1):
        if N > 0:
            GLAT = GLATS + (N - 1) * grid / 60
            for m in range(1, int(MPTS) + 1):
                if m > 0:
                    GLON = GLONW + (m - 1) * grid/ 60

                    geomg(ALT, GLAT, GLON, TIME, GV, EPOCH, DTR)

                    h = ti * math.cos(DIP * DTR)
                    x = h * math.cos(DEC * DTR)
                    y = h * math.sin(DEC * DTR)
                    Z = ti * math.sin(DIP * DTR)
                    MAG[1][1] = DEC
                    MAG[2][1] = DIP
                    MAG[3][1] = ti
                    MAG[4][1] = h
                    MAG[5][1] = x
                    MAG[6][1] = y
                    MAG[7][1] = Z
                    MAG[8][1] = GV

                    geomg(ALT, GLAT, GLON, TIM, GV, EPOCH, DTR)

                    h = ti * math.cos(DIP * DTR)
                    x = h * math.cos(DEC * DTR)
                    y = h * math.sin(DEC * DTR)
                    Z = ti * math.sin(DIP * DTR)
                    MAG[1][2] = (DEC - MAG[1][1])
                    MAG[2][2] = (DIP - MAG[2][1])
                    MAG[3][2] = ti - MAG[3][1]
                    MAG[4][2] = h - MAG[4][1]
                    MAG[5][2] = x - MAG[5][1]
                    MAG[6][2] = y - MAG[6][1]
                    MAG[7][2] = Z - MAG[7][1]
                    MAG[8][2] = GV - MAG[8][1]

                    if MAG[1][2] > 180:
                        MAG[1][2] = MAG[1][2] - 360
                    if MAG[1][2] <= -180:
                        MAG[1][2] = MAG[1][2] + 360

                    MAG[1][2] = MAG[1][2] * 60
                    if MAG[2][2] > 180:
                        MAG[2][2] = MAG[2][2] - 360
                    if MAG[2][2] <= -180:
                        MAG[2][2] = MAG[2][2] + 360
                    MAG[2][2] = MAG[2][2] * 60
                    if MAG[8][2] > 180:
                        MAG[8][2] = MAG[8][2] - 360
                    if MAG[8][2] <= -180:
                        MAG[8][2] = MAG[8][2] + 360
                    MAG[8][2] = MAG[8][2] * 60          
    decMag = []
    decMag.append(MAG[1][1])
    decMag.append(MAG[1][2])
    return decMag 

def geomg(ALT, GLAT, GLON, TIME, GV, EPOCH, DTR):
    global SP, CP, p, pp, PP, DP, c, CD, SNORM, k, fn, FM, TC, MAG, a, b, RE, A2, b2, c2, A4, B4, c4, OTIME, OALT, OLAT, MAXORD, DEC, DIP, ti
    
    dt = TIME - EPOCH
    RLON = GLON * DTR
    RLAT = GLAT * DTR
    SRLON = math.sin(RLON)
    SRLAT = math.sin(RLAT)
    CRLON = math.cos(RLON)
    CRLAT = math.cos(RLAT)
    SRLON2 = math.pow(SRLON, 2)
    SRLAT2 = math.pow(SRLAT, 2)
    CRLON2 = math.pow(CRLON, 2)
    CRLAT2 = math.pow(CRLAT, 2)
    SP[1] = SRLON
    CP[1] = CRLON

    q = math.sqrt(A2 - c2 * SRLAT2)
    Q1 = ALT * q
    Q2 = math.pow(divisao(Q1 + A2, Q1 + b2), 2)
    CT = SRLAT / math.sqrt(Q2 * CRLAT2 + SRLAT2)
    St = math.sqrt(1 - math.pow(CT, 2))
    R2 = divisao(math.pow(ALT, 2) + 2 * Q1 + (A4 - c4 * SRLAT2), math.pow(q, 2))
    r = math.sqrt(R2)
    d = math.sqrt(A2 * CRLAT2 + b2 * SRLAT2)
    CA = divisao((ALT + d), r)
    SA = divisao(c2 * CRLAT * SRLAT, (r * d)) 
    
    mpf = 2
    for mpf in range(2, MAXORD):
        SP[mpf] = SP[1] * CP[mpf - 1] + CP[1] * SP[mpf - 1]
        CP[mpf] = CP[1] * CP[mpf - 1] - SP[1] * SP[mpf - 1]
        mpf += 1

    AOR = divisao(RE, r)
    AR = math.pow(AOR, 2)
    BR = 0
    BT = 0
    BP = 0
    BPP = 0

    for N in range(1, MAXORD + 1):
        if N > 0:
            AR = AR * AOR
            for m in range(0, N + 1):
                if ALT != OALT or GLAT != OLAT:
                    if N == m:
                        p[N][m] = St * p[N - 1][m - 1]
                        DP[N][m] = St * DP[N - 1][m - 1] + CT * p[N - 1][m - 1]
                    elif N == 1 and m == 0:
                        p[N][m] = CT * p[N - 1][m]
                        DP[N][m] = CT * DP[N - 1][m] - St * p[N - 1][m]
                    elif N > 1 and N != m:
                        if m > N - 2:
                            p[N - 2][m] = 0
                            DP[N - 2][m] = 0
                        p[N][m] = CT * p[N - 1][m] - k[N][m] * p[N - 2][m]
                        DP[N][m] = CT * DP[N - 1][m] - St * p[N - 1][m] - k[N][m] * DP[N - 2][m]

                if TIME != OTIME:
                    TC[N][m] = c[N][m] + dt * CD[N][m]
                    if m != 0:
                        TC[m - 1][N] = c[m - 1][N] + dt * CD[m - 1][N]

                PAR = AR * p[N][m]

                if int(m) == 0:
                    TEMP1 = TC[N][m] * CP[m]
                    TEMP2 = TC[N][m] * SP[m]
                else:
                    TEMP1 = TC[N][m] * CP[m] + TC[m - 1][N] * SP[m]
                    TEMP2 = TC[N][m] * SP[m] - TC[m - 1][N] * CP[m]
                BT = BT - AR * TEMP1 * DP[N][m]
                BP = BP + FM[m] * TEMP2 * PAR
                BR = BR + fn[N] * TEMP1 * PAR

                if int(St) == 0 and int(m) == 1:
                    if int(N) == 1:
                        PP[N] = PP[N - 1]
                    else:
                        PP[N] = CT * PP[N - 1] - k[N][m] * PP[N - 2]
                PARP = AR * PP[N]
                BPP = BPP + FM[m] * TEMP2 * PARP
    if St == 0:
        BP = BPP
    else:
        BP = BP / St
    
    bx = -BT * CA - BR * SA
    by = BP
    BZ = BT * SA - BR * CA

    BH = math.sqrt(math.pow(bx, 2) + math.pow(by, 2))
    ti = math.sqrt(math.pow(BH, 2) + math.pow(BZ, 2))
    DEC = atan2(by, bx) / DTR
    DIP = atan2(BZ, BH) / DTR
    GV = -999
    if abs(GLAT) >= 55:
        if GLAT > 0 and GLON >= 0:
            GV = DEC - GLON
        if GLAT > 0 and GLON < 0:
            GV = DEC + abs(GLON)
        if GLAT < 0 and GLON >= 0:
            GV = DEC + GLON
        if GLAT < 0 and GLON < 0:
            GV = DEC - abs(GLON)
        if GV > 180:
            GV = GV - 360
        if GV < -180:
            GV = GV + 360
    OTIME = TIME
    OALT = ALT
    OLAT = GLAT 

def divisao(x, y):
    try:
        a = x / y
    except:
        return 0
    else:
        return a

def atan2(y, x):
    pi = 3.14159265358979
    atan2 = 0
    if x > 0:
        atan2 = math.atan(divisao(y, x))
    elif x < 0:
        atan2 = np.sign(y) * (pi - math.atan(abs(divisao(y, x))))
    elif y == 0:
        atan2 = 0
    else:
        atan2 = divisao(np.sign(y) * pi, 2)
    return atan2

def Geo_UTM(GEO):

    fmgs = FMcentro(GEO)

    GEOla = GEO[1]
    GEOlo = GEO[0]

    a = 6378137
    b = 6356752.31424518
    K0 = 0.9996
    kPI = 3.14159265358979

    F = (a - b) / a
    F1 = 1 / F
    rm = math.pow((a * b), 0.5)
    E = math.sqrt(1 - math.pow((b / a), 2))
    N = (a - b) / (a + b)
    aa = (a / (1 + N)) * (1 + (1 / 4) * math.pow(N, 2) + (1 / 64) * math.pow(N, 4) + (1 / 256) * math.pow(N, 6) + (25 / 16384) * math.pow(N, 8) + (49 / 65536) * math.pow(N, 10))
    alpha1 = (1 / 2) * N - (2 / 3) * math.pow(N, 2) + (5 / 16) * math.pow(N, 3) + (41 / 180) * math.pow(N, 4) - (127 / 288) * math.pow(N, 5) + (7891 / 37800) * math.pow(N, 6) + (72161 / 387072) * math.pow(N, 7) - (18975107 / 50803200) * math.pow(N, 8) + (60193001 / 290304000) * math.pow(N, 9) + (134592031 / 1026432000) * math.pow(N, 10)
    alpha2 = (13 / 48) * math.pow(N, 2) - (3 / 5) * math.pow(N, 3) + (557 / 1440) * math.pow(N, 4) + (281 / 630) * math.pow(N, 5) - (1983433 / 1935360) * math.pow(N, 6) + (13769 / 28800) * math.pow(N, 7) + (148003883 / 174182400) * math.pow(N, 8) - (705286231 / 465696000) * math.pow(N, 9) + (1703267974087 / 3218890752000) * math.pow(N, 10)
    alpha3 = (61 / 240) * math.pow(N, 3) - (103 / 140) * math.pow(N, 4) + (15061 / 26880) * math.pow(N, 5) + (167603 / 181440) * math.pow(N, 6) - (67102379 / 29030400) * math.pow(N, 7) + (79682431 / 79833600) * math.pow(N, 8) + (6304945039 / 2128896000) * math.pow(N, 9) - (6601904925257 / 1307674368000) * math.pow(N, 10)
    alpha4 = (49561 / 161280) * math.pow(N, 4) - (179 / 168) * math.pow(N, 5) + (6601661 / 7257600) * math.pow(N, 6) + (97445 / 49896) * math.pow(N, 7) - (40176129013 / 7664025600) * math.pow(N, 8) + (138471097 / 66528000) * math.pow(N, 9) + (48087451385201 / 5230697472000) * math.pow(N, 10)
    alpha5 = (34729 / 80640) * math.pow(N, 5) - (3418889 / 1995840) * math.pow(N, 6) + (14644087 / 9123840) * math.pow(N, 7) + (2605413599 / 622702080) * math.pow(N, 8) - (31015475399 / 2583060480) * math.pow(N, 9) + (5820486440369 / 1307674368000) * math.pow(N, 10)
    alpha6 = (212378941 / 319334400) * math.pow(N, 6) - (30705481 / 10378368) * math.pow(N, 7) + (175214326799 / 58118860800) * math.pow(N, 8) + (870492877 / 96096000) * math.pow(N, 9) - (1.328004581729E+15 / 47823519744000) * math.pow(N, 10)
    alpha7 = (1522256789 / 1383782400) * math.pow(N, 7) - (16759934899 / 3113510400) * math.pow(N, 8) + (1315149374443 / 221405184000) * math.pow(N, 9) + (71809987837451 / 3629463552000) * math.pow(N, 10)
    alpha8 = (1424729850961 / 743921418240) * math.pow(N, 8) - (256783708069 / 25204608000) * math.pow(N, 9) + (2.46874929298989E+15 / 203249958912000) * math.pow(N, 10)
    alpha9 = (21091646195357 / 6080126976000) * math.pow(N, 9) - (6.71961821383558E+16 / 3.379030566912E+15) * math.pow(N, 10)
    alpha10 = (7.79115156232328E+16 / 1.2014330904576E+16) * math.pow(N, 10)
    beta1 = (1 / 2) * N - (2 / 3) * math.pow(N, 2) + (37 / 96) * math.pow(N, 3) - (1 / 360) * math.pow(N, 4) - (81 / 512) * math.pow(N, 5) + (96199 / 604800) * math.pow(N, 6) - (5406467 / 38707200) * math.pow(N, 7) + (7944359 / 67737600) * math.pow(N, 8) - (7378753979 / 97542144000) * math.pow(N, 9) + (25123531261 / 804722688000) * math.pow(N, 10)
    beta2 = (1 / 48) * math.pow(N, 2) + (1 / 15) * math.pow(N, 3) - (437 / 1440) * math.pow(N, 4) + (46 / 105) * math.pow(N, 5) - (1118711 / 3870720) * math.pow(N, 6) + (51841 / 1209600) * math.pow(N, 7) + (24749483 / 348364800) * math.pow(N, 8) - (115295683 / 1397088000) * math.pow(N, 9) + (5487737251099 / 51502252032000) * math.pow(N, 10)
    beta3 = (17 / 480) * math.pow(N, 3) - (37 / 840) * math.pow(N, 4) - (209 / 4480) * math.pow(N, 5) + (5569 / 90720) * math.pow(N, 6) + (9261899 / 58060800) * math.pow(N, 7) - (6457463 / 17740800) * math.pow(N, 8) + (2473691167 / 9289728000) * math.pow(N, 9) - (852549456029 / 20922789888000) * math.pow(N, 10)
    beta4 = (4397 / 161280) * math.pow(N, 4) - (11 / 504) * math.pow(N, 5) - (830251 / 7257600) * math.pow(N, 6) + (466511 / 2494800) * math.pow(N, 7) + (324154477 / 7664025600) * math.pow(N, 8) - (937932223 / 3891888000) * math.pow(N, 9) - (89112264211 / 5230697472000) * math.pow(N, 10)
    beta5 = (4583 / 161280) * math.pow(N, 5) - (108847 / 3991680) * math.pow(N, 6) - (8005831 / 63866880) * math.pow(N, 7) + (22894433 / 124540416) * math.pow(N, 8) + (112731569449 / 557941063680) * math.pow(N, 9) - (5391039814733 / 10461394944000) * math.pow(N, 10)
    beta6 = (20648693 / 638668800) * math.pow(N, 6) - (16363163 / 518918400) * math.pow(N, 7) - (2204645983 / 12915302400) * math.pow(N, 8) + (4543317553 / 18162144000) * math.pow(N, 9) + (54894890298749 / 167382319104000) * math.pow(N, 10)
    beta7 = (219941297 / 5535129600) * math.pow(N, 7) - (497323811 / 12454041600) * math.pow(N, 8) - (79431132943 / 332107776000) * math.pow(N, 9) + (4346429528407 / 12703122432000) * math.pow(N, 10)
    beta8 = (191773887257 / 3719607091200) * math.pow(N, 8) - (17822319343 / 336825216000) * math.pow(N, 9) - (497155444501631 / 1.422749712384E+15) * math.pow(N, 10)
    beta9 = (11025641854267 / 158083301376000) * math.pow(N, 9) - (492293158444691 / 6.758061133824E+15) * math.pow(N, 10)
    beta10 = (7.02850453042962E+15 / 7.2085985427456E+16) * math.pow(N, 10)
    MC = int(fmgs[1])

    if GEOla < 0:
        SinalLat = -1
    else:
        SinalLat = 1

    if MC > GEOlo:
        SinalMC = -1
    else:
        SinalMC = 1

    AbsLat = abs(GEOla)
    LatR = AbsLat * kPI / 180
    AbsLong = abs(GEOlo)
    dLong = abs(GEOlo - MC)
    Dlonr = dLong * kPI / 180

    Sigma = math.asinh(E * math.atanh(E * math.atanh(LatR) / math.sqrt(1 + math.pow(math.tan(LatR), 2))))

    ConfLat = math.atan(math.tan(LatR) * math.sqrt(1 + math.pow(Sigma, 2)) - Sigma * math.sqrt(1 + math.pow(math.tan(LatR), 2)))
    Tau = math.tan(LatR)
    Tau_prime = math.tan(ConfLat)
    Xi_prime = math.atan(Tau_prime / math.cos(Dlonr))
    Eta_prime = math.asinh(math.sin(Dlonr) / math.sqrt(math.pow(Tau_prime, 2) + math.pow(math.cos(Dlonr), 2)))
    xi = Xi_prime + alpha1 * math.sin(2 * Xi_prime) * math.cosh(2 * Eta_prime) + alpha2 * math.sin(4 * Xi_prime) * math.cosh(4 * Eta_prime) + alpha3 * math.sin(6 * Xi_prime) * math.cosh(6 * Eta_prime) + alpha4 * math.sin(8 * Xi_prime) * math.cosh(8 * Eta_prime) + alpha5 * math.sin(10 * Xi_prime) * math.cosh(10 * Eta_prime) + alpha6 * math.sin(12 * Xi_prime) * math.cosh(12 * Eta_prime) + alpha7 * math.sin(14 * Xi_prime) * math.cosh(14 * Eta_prime)
    eta = Eta_prime + alpha1 * math.cos(2 * Xi_prime) * math.sinh(2 * Eta_prime) + alpha2 * math.cos(4 * Xi_prime) * math.sinh(4 * Eta_prime) + alpha3 * math.cos(6 * Xi_prime) * math.sinh(6 * Eta_prime) + alpha4 * math.cos(8 * Xi_prime) * math.sinh(8 * Eta_prime) + alpha5 * math.cos(10 * Xi_prime) * math.sinh(10 * Eta_prime) + alpha6 * math.cos(12 * Xi_prime) * math.sinh(12 * Eta_prime) + alpha6 * math.cos(14 * Xi_prime) * math.sinh(14 * Eta_prime)
    easting = K0 * aa * eta
    northing = K0 * aa * xi

    if SinalLat == 1:
        UTMla = northing
    else:
        UTMla = 10000000 - northing

    UTMlo = 500000 + SinalMC * easting
    Geo_UTM = [UTMla, UTMlo]
    return Geo_UTM


  
class articulacaosistematica:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'articulacaosistematica_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.dlg = articulacaosistematicaDialog()
        self.actions = []
        self.menu = self.tr(u'&Articulação Sistemática')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('articulacaosistematica', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToVectorMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/articulacaosistematica/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Gerar Articulação Sistemática'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True

        self.dlg.caminho.clear()
        self.dlg.select_caminho.clicked.connect(self.selecione_caminho)
        self.dlg.salvememoria.clicked.connect(self.verificar_salvememeoria)  
        self.dlg.dadoscartograficos.clicked.connect(self.dados_cartotaficos)   

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginVectorMenu(
                self.tr(u'&Articulação Sistemática'),
                action)
            self.iface.removeToolBarIcon(action)

        self.first_start = True

    def dados_cartotaficos(self):
        verificar = self.dlg.dadoscartograficos.isChecked()
        if verificar: 
            self.dlg.datadados.setEnabled(True)
            self.dlg.label_3.setEnabled(True)
        else: 
            self.dlg.datadados.setEnabled(False)
            self.dlg.label_3.setEnabled(False)

    def verificar_salvememeoria(self):
        verificar = self.dlg.salvememoria.isChecked()
        if verificar: 
            self.dlg.select_caminho.setEnabled(False)
            self.dlg.caminho.setEnabled(False)
            self.dlg.label_5.setEnabled(False)
        else: 
            self.dlg.select_caminho.setEnabled(True)
            self.dlg.caminho.setEnabled(True)
            self.dlg.label_5.setEnabled(True)

    def selecione_escala(self):
        escala = ['1:1.000','1:2.000','1:5.000','1:10.000','1:25.000','1:50.000','1:100.000','1:250.000','1:500.000','1:1.000.000']
        d = 0
        for i in escala:
            self.dlg.select_scala.addItem(i) 

    #def selecione_projecao(self):
    #    self.dlg.select_projecao.addItem('WGS84') 
    #    self.dlg.select_projecao.addItem('SIRGAS')

    def selecione_caminho(self):
        # Abri janela para escolher caminho onde vai salvar o shape
        filtering="Shapefiles (*.shp *.SHP)"
        settings = QSettings()
        dirName = settings.value("/UI/lastShapefileDir")
        encode = settings.value("/UI/encoding")
        fileDialog = QgsEncodingFileDialog(None, QCoreApplication.translate("fTools", "Save output shapefile"), dirName, filtering, encode)
        fileDialog.setDefaultSuffix("shp")
        fileDialog.setFileMode(QFileDialog.AnyFile)
        fileDialog.setAcceptMode(QFileDialog.AcceptSave)
        #fileDialog.setConfirmOverwrite(True)
        if not fileDialog.exec_() == QDialog.Accepted:
            return None, None

        files = fileDialog.selectedFiles()
        settings.setValue("/UI/lastShapefileDir", QFileInfo(unicode(files[0])).absolutePath())
        self.outFilePath = unicode(files[0])
        self.encoding = unicode(fileDialog.encoding())
        self.dlg.caminho.setText(self.outFilePath)
        self.nomeshape = files

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        self.dlg.caminho.clear() 
        self.dlg.select_scala.clear()
        #self.dlg.select_projecao.clear()
        self.selecione_escala()
        #self.selecione_projecao()
        self.dlg.datadados.clear()
        data_atual = date.today()
        self.dlg.datadados.setDate(data_atual)
        # Carrega os Layer que corresponde somente a Shp de polylines
        layers = QgsProject.instance().mapLayers().values()
        self.dlg.select_layer.clear()
        for layer in layers:
            if layer.type() == QgsMapLayer.VectorLayer and layer.geometryType() == QgsWkbTypes.PolygonGeometry:
                self.dlg.select_layer.addItem( layer.name(), layer )  
        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            global sistemaProj
            global gerarDados
            global datadados
            datadados = self.dlg.datadados.date().toPyDate()
            sistemaProj = "WGS84"
            gerarDados = self.dlg.dadoscartograficos.isChecked()

            if not self.dlg.salvememoria.isChecked() and not self.dlg.caminho.text():
                self.iface.messageBar().pushMessage("Alerta", "Existe campos obrigatório sem preenchimento.", level=Qgis.Warning) 
            else: 
                for selectlayer in QgsProject.instance().mapLayers().values():
                    if selectlayer.name() == self.dlg.select_layer.currentText():
                        global escalafinal
                        global pr_shape_polygon

                        layer_selecioado = selectlayer
                        escalafinal = self.dlg.select_scala.currentText()                        
                        extend_l = selectlayer.extent()
                        sRs = selectlayer.crs().authid().split(':')[1]
                        sRs_g = selectlayer.crs()
                        if int(sRs) != 4326:
                            coords_geo = converter_coords_geo(extend_l, sRs)
                        else:
                            coords_geo = extend_l
                        
                        minX = coords_geo.xMinimum()
                        maxX = coords_geo.xMaximum()
                        minY = coords_geo.yMinimum()
                        maxY = coords_geo.yMaximum()
                        shape_polygon = QgsVectorLayer('polygon?crs=epsg:' + sRs , 'Articulacao', 'memory')
                        pr_shape_polygon = shape_polygon.dataProvider()

                        pr_shape_polygon.addAttributes([QgsField("nomeclatura", QVariant.String)])
                        if gerarDados:
                            pr_shape_polygon.addAttributes([QgsField('kappa',QVariant.String)]) 
                            pr_shape_polygon.addAttributes([QgsField('convergencia',QVariant.String)])
                            pr_shape_polygon.addAttributes([QgsField('declinacao',QVariant.String)])
                            pr_shape_polygon.addAttributes([QgsField('variacao',QVariant.String)])
                        shape_polygon.updateFields()

                        CFMin = centro_folha([minX,minY]) #lo, la
                        CFMax = centro_folha([maxX,maxY]) #lo, la   

                        AuxCFla = CFMax[1]
                        while AuxCFla >= CFMin[1] - (0.1 * parametrosEscalas(escalafinal)[1]):
                            AuxCFlo = CFMin[0]
                            while AuxCFlo <= CFMax[0] + (0.1 * parametrosEscalas(escalafinal)[2]):  
                                AuxCF = centro_folha([AuxCFlo,AuxCFla])
                                gerarfolhas(AuxCF, sRs)
                                AuxCFlo = AuxCFlo + parametrosEscalas(escalafinal)[2]
                            AuxCFla = AuxCFla - parametrosEscalas(escalafinal)[1]
                        


                        if self.dlg.salvememoria.isChecked(): 
                            for feat_art in shape_polygon.getFeatures():
                                geom_art = feat_art.geometry()
                                verif = False
                                for feat_sel in layer_selecioado.getFeatures():
                                    geom_sel = feat_sel.geometry()
                                    if geom_art.intersects(geom_sel):
                                        verif = True
                                        break
                                if not verif:
                                    pr_shape_polygon.deleteFeatures([feat_art.id()])
                            QgsProject.instance().addMapLayer(shape_polygon)
                        else:
                            self.Fields = QgsFields()
                            self.Fields.append(QgsField('nomeclatura',QVariant.String)) 
                            if gerarDados:
                                self.Fields.append(QgsField('kappa',QVariant.String)) 
                                self.Fields.append(QgsField('convergencia',QVariant.String))
                                self.Fields.append(QgsField('declinacao',QVariant.String))
                                self.Fields.append(QgsField('variacao',QVariant.String))

                            global SHPCaminho
                            SHPCaminho = self.outFilePath
                            self.shape_articulacao = QgsVectorFileWriter(SHPCaminho, self.encoding, self.Fields, QgsWkbTypes.Polygon, sRs_g, "ESRI Shapefile")
                            
                            for feat_art in shape_polygon.getFeatures():
                                geom_art = feat_art.geometry()
                                verif = False
                                for feat_sel in layer_selecioado.getFeatures():
                                    geom_sel = feat_sel.geometry()
                                    if geom_art.intersects(geom_sel):
                                        verif = True
                                        break
                                if verif:
                                    self.shape_articulacao.addFeature(feat_art)
  
                            pegarNome = self.outFilePath
                            Nomes = pegarNome.split( '/' )
                            contNomes = len(Nomes) - 1
                            nomefinalshp = Nomes[contNomes]
                            nomefinalshp =  nomefinalshp.replace('.shp','')
                            nomefinalshp =  nomefinalshp.replace('.SHP','')
                            self.layer = QgsVectorLayer(self.outFilePath, nomefinalshp, "ogr")
                            if not self.layer.isValid():
                                raise ValueError("Failed to open the layer")
                            self.canvas = QgsMapCanvas()
                            QgsProject.instance().addMapLayer(self.layer)
                            self.canvas.setExtent(self.layer.extent())
                            self.canvas.setLayers([self.layer])
                            del self.shape_articulacao
                            QgsProject.instance().removeMapLayer(self.layer)
                            self.layer = QgsVectorLayer(self.outFilePath, nomefinalshp, "ogr")
                            QgsProject.instance().addMapLayer(self.layer)



