
def pointstocircle(a, b, c):
	""" Calculate circle center and radius from 3 points
	"""
	# AB and BC vectors
	abx = float(b[0] - a[0])
	aby = float(b[1] - a[1])
	bcx = float(c[0] - b[0])
	bcy = float(c[1] - b[1])
	# AB and BC middles
	ab2x = (a[0] + b[0]) / 2.
	ab2y = (a[1] + b[1]) / 2.
	bc2x = (b[0] + c[0]) / 2.
	bc2y = (b[1] + c[1]) / 2.
	
	# Aligned points
	if abs(abx * bcy - aby * bcx) < 0.0001: # Empirical threshold tested for 1E5 order of magnitude coords
	# if abx * bcy - aby * bcx == 0:
		return None
	
	# AB horizontal
	if aby == 0:
		cx = ab2x
		cy = bc2y - (cx - bc2x) * bcx / bcy
	# BC horizontal
	elif bcy == 0:
		cx = bc2x
		cy = ab2y - (cx - ab2x) * abx / aby
	# Otherwise
	else:
		cx = (bc2y - ab2y + bcx * bc2x / bcy - abx * ab2x / aby) / (bcx / bcy - abx / aby)
		cy = bc2y - (cx - bc2x) * bcx / bcy
	# Radius
	r = ((a[0] - cx) ** 2 + (a[1] - cy) ** 2) ** 0.5
	
	return {'x':cx, 'y':cy, 'r':r}

if __name__ == "__main__":
	print pointstocircle((-1,0), (0,1), (1,0))
	print pointstocircle((-1,0), (0,0), (1,0))
	print pointstocircle((0,0), (1,0), (1,1))
