# Калькулятор времени прибытия пожарных автомобилей для QGIS

## Обзор

Этот плагин QGIS предоставляет расширенные инструменты для расчёта времени прибытия пожарных автомобилей на основе данных OpenStreetMap (OSM). Он  расчитывает время в пути с использованием дорожной сети и настраиваемых пределов скорости для различных типов дорог. Плагин позволяет визуализировать расчётные маршруты и поддерживает дополнительный анализ через создание слоёв.

## Возможности

1. **Расчёт времени прибытия**:
   - Вычисляет время в пути между местоположениями пожарной части и заданными конечными точками (или узлами графа).
   - Использует настраиваемую матрицу скорости для различных категорий дорог, что позволяет получить реалистичные оценки времени в пути.

2. **Маршрутизация на основе графов**:
   - Использует данные OSM для построения графа дорожной сети, что обеспечивает точные расчёты маршрутов.
   - Отображает расчётные маршруты и позволяет пользователям сохранять результаты в формате GeoPackage.

3. **Генерация слоя конечных точек**:
   - Создаёт слой целевых точек для дальнейшего анализа.
   - Поддерживает динамическое отображение целевых точек с временем в пути.

4. **Интеграция с графикой QGIS**:
   - Визуализирует маршруты и конечные точки поверх существующего проекта QGIS.
   - Позволяет сохранить как постоянные слои для последующего использования или отчётности.

## Установка

1. **Предварительные условия**:
   - QGIS (версия 3.16 или выше).
   - Библиотеки Python: `osmnx` и `networkx`.

     Установите отсутствующие зависимости с помощью pip в окружении QGIS:
     ```bash
     pip install osmnx networkx
     ```

2. **Установка**:
   - Клонируйте репозиторий или загрузите zip-архив.
   - Поместите папку с плагином в директорию плагинов QGIS, которая обычно находится по пути:
     - `C:\Users\<ВашеИмя>\AppData\Roaming\QGIS\QGIS3\profiles\default\python\plugins` (Windows).
     - `~/.local/share/QGIS/QGIS3/profiles/default/python/plugins/` (Linux/MacOS).
   - Перезапустите QGIS и активируйте плагин через Менеджер плагинов.

## Использование

### 1. **Расчёт времени прибытия пожарных автомобилей**
   - Выберите **"Оценка времени прибытия"** в инструменте обработки.
   - Параметры ввода:
     - **Границы расчётов**: Полигональный слой, определяющий область исследования.
     - **Начальные точки**: Слой точек или полигонов, представляющих местоположения пожарных частей.
     - **Конечные точки** (необязательно): Слой точек или полигонов для целевых мест.
     - **Матрица скорости**: Конфигурация скорости по типам дорог (редактируемая таблица).
   - При необходимости включите визуализацию маршрутов.
   - Выходы:
     - Временный слой, показывающий расчётные маршруты.
     - Возможность сохранить результаты в файл GeoPackage.

### 2. **Генерация слоя конечных точек**
   - Выберите **"Генератор слоя конечных точек"** в инструменте обработки.
   - Параметры ввода:
     - Те же параметры, что и в калькуляторе времени прибытия.
   - Выходы:
     - Слой конечных точек с доступными метаданными, включая рассчитанные времена в пути.

### 3. **Визуализация и анализ**
   - Сгенерированные маршруты и точки накладываются непосредственно на текущий проект QGIS для просмотра.
   - Экспортируйте слои для их интеграции в другие рабочие процессы или отчётные формы.

## Настройка и пределы скорости

Плагин позволяет настраивать скорости движения для категорий дорог. Предустановленные пределы включают:
- **Городские магистрали и основные улицы**: 49 км/ч.
- **Магистральные улицы**: 37 км/ч.
- **Местные дороги**: 26 км/ч.
- **Служебные проезды**: 16 км/ч.
- **Пешеходные зоны, доступные пожарным автомобилям**: 5 км/ч.

Измените эти настройки в параметре матрицы скорости во время обработки для учета местных условий движения.

## Информация для разработчиков

### Реализация алгоритмов

1. **ArrivalTimeCalculatorAlgorithm**:
   - Строит дорожную сеть, используя данные OSM.
   - Вычисляет кратчайшие пути с использованием алгоритма Дейкстры.
   - Поддерживает обратную связь о прогрессе и обработку ошибок.

2. **EndPointsLayerAlgorithm**:
   - Создаёт динамический слой для целевых точек непосредственно в проекте.
   - Полезно для выделения конкретных зон для анализа.

### Используемые библиотеки

- **OSMnx**: Для извлечения и управления данными дорожной сети OSM.
- **NetworkX**: Для выполнения графовых расчётов маршрутов.

### Структура каталогов

- **`utils/`**: Содержит вспомогательные модули для управления скоростью, обработки геометрии, интеграции OSM и управления слоями.
- **`fire_truck_arrival_time_calculator.py`**: Основной скрипт плагина для расчёта времени прибытия.
- **`end_points_layer_creator.py`**: Алгоритм для генерирования слоёв конечных точек.

