# -*- coding: utf-8 -*-
"""
/***************************************************************************
 ArrayPlus
                                 A QGIS plugin
 Functions to manipulate arrays in field calculator
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2018-06-06
        git sha              : $Format:%H$
        copyright            : (C) 2018 by JB Desbas
        email                : jb.desbas@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtCore import QSettings, QTranslator, qVersion, QCoreApplication
from PyQt5.QtGui import QIcon
from PyQt5.QtWidgets import QAction

from qgis.utils import iface,qgsfunction
from qgis.core import QgsExpression,Qgis

# Initialize Qt resources from file resources.py
#from .resources import *
# Import the code for the dialog
from .array_plus_dialog import ArrayPlusDialog
import os.path


def makeList(input):
    if not isinstance(input,list):
        return input.split(',')
    return input


if Qgis.QGIS_VERSION_INT < 31800 :
    @qgsfunction(args='auto', group='Arrays')
    def array_min(arr, feature, parent):
        """
        Return the min value in an array
        <h4>Syntax</h4>
        <p><strong>array_min</strong>(<i>array</i>)
        <h4>Arguments</h4>
        <dl>
        <dt><i>array</i></dt><dd>array or string (comma separated values)</dd>
        </dl>
        """
        return min(makeList(arr))

if Qgis.QGIS_VERSION_INT < 31800 :
    @qgsfunction(args='auto', group='Arrays')
    def array_max(arr, feature, parent):
        """
        Return the max value in an array
        <h4>Syntax</h4>
        <p><strong>array_max</strong>(<i>array</i>)
        <h4>Arguments</h4>
        <dl>
        <dt><i>array</i></dt><dd>array or string (comma separated values)</dd>
        </dl>
        """
        return max(makeList(arr))

if Qgis.QGIS_VERSION_INT < 30500 :
    @qgsfunction(args='auto', group='Arrays')
    def array_sort(arr, feature, parent):
        """
        Sort the values by ascending order (use array_reverse for desc)
        <h4>Syntax</h4>
        <p><strong>array_sort</strong>(<i>array</i>)
        <h4>Arguments</h4>
        <dl>
        <dt><i>array</i></dt><dd>array or string (comma separated values)</dd>
        </dl>
        """
        arr=makeList(arr)
        arr.sort()
        return arr

@qgsfunction(args='auto', group='Arrays')
def array_avg(arr, feature, parent):
    """
    Calculate the avg of the values. Since QGIS 3.18, please use array_mean core function.
    <h4>Syntax</h4>
    <p>array_avg(<i>array</i>)
    <h4>Arguments</h4>
    <dl>
    <dt><i>array</i></dt><dd>array or string (comma separated values)</dd>
    </dl>
    """
    arr=makeList(arr)
    arr=list(map(float,arr))
    return sum(arr)/len(arr)

if Qgis.QGIS_VERSION_INT < 31800 :
    @qgsfunction(args='auto', group='Arrays')
    def array_sum(arr, feature, parent):
        """
        Calculate the sum of the values
        <h4>Syntax</h4>
        <p><strong>array_sum</strong>(<i>array</i>)
        <h4>Arguments</h4>
        <dl>
        <dt><i>array</i></dt><dd>array or string (comma separated values)</dd>
        </dl>
        """
        arr=makeList(arr)
        arr=list(map(float,arr))
        return sum(arr)

if Qgis.QGIS_VERSION_INT < 32000 :
    @qgsfunction(args='auto', group='Arrays')
    def array_count(arr, value, feature, parent):
        """
        Count a given value in an array
        <h4>Syntax</h4>
        <p><strong>array_count</strong>(<i>array</i>,<i>value</i>)
        <h4>Example usage</h4>
        <p>array_count(string_to_array( 'a,b,c,a,a'),'a')->3
        <h4>Arguments</h4>
        <dl>
        <dt><i>array</i></dt><dd>array or string (comma separated values)</dd>
        <dt><i>value</i></dt><dd>the value to count</dd>
        </dl>
        """
        arr=makeList(arr)
        from collections import Counter
        cnt=Counter(arr)
        return cnt[value]

if Qgis.QGIS_VERSION_INT < 31800 :	
    @qgsfunction(args='auto', group='Arrays')
    def array_majority(arr, feature, parent):
        """
        Return the most common value. Return arbitrary value if ex-aequo
        <h4>Syntax</h4>
        <p><strong>array_majority</strong>(<i>array</i>)
        <h4>Arguments</h4>
        <dl>
        <dt><i>array</i></dt><dd>array or string (comma separated values)</dd>
        </dl>
        <h4>Example usage</h4>
        <p>array_majority(string_to_array( 'a,b,c,a,a'))->'a'
        """
        arr=makeList(arr)
        from collections import Counter
        cnt=Counter(arr)
        return cnt.most_common()[0][0]

if Qgis.QGIS_VERSION_INT < 32000 :
    @qgsfunction(args='auto', group='Arrays')
    def array_minority(arr, feature, parent):
        """
        Return the most common value. Return arbitrary value if ex-aequo
        <h4>Syntax</h4>
        <p><strong>array_minority</strong>(<i>array</i>)
        <h4>Arguments</h4>
        <dl>
        <dt><i>array</i></dt><dd>array or string (comma separated values)</dd>
        </dl>
        <h4>Example usage</h4>
        <p>array_minority(string_to_array( 'a,b,c,a,a'))->'c'
        """
        arr=makeList(arr)
        from collections import Counter
        cnt=Counter(arr)
        return cnt.most_common()[-1][0]

@qgsfunction(args='auto', group='Arrays')
def array_replace(arr, old, new, feature, parent):
    """
    Replace old value by new value
    <h4>Syntax</h4>
    <p><strong>array_minority</strong>(<i>array</i>,<i>before</i>,<i>after</i>)
    <h4>Arguments</h4>
    <dl>
    <dt><i>array</i></dt><dd>array or string (comma separated values)</dd>
    <dt><i>before</i></dt><dd>the value to replace</dd>
    <dt><i>after</i></dt><dd>the new value</dd>
    </dl>
    """
    arr=makeList(arr)
    for k,e in enumerate(arr):
        if e==old:
            arr[k]=new
    return arr
    
@qgsfunction(args='auto', group='Arrays')
def array_lambda(arr, lmbd, feature, parent):
    """
    Apply a custom fonction to each element (x)
    <h4>Syntax</h4>
    <p><strong>array_lambda</strong>(<i>array</i>, <i>lambda function</i>)
    <h4>Arguments</h4>
    <dl>
    <dt><i>array</i></dt><dd>array or string (comma separated values)</dd>
    <dt><i>lambda function</i></dt><dd>a string that represents the function to apply. Array element is represented as 'x'</dd>
    </dl>
    <h4>Example usage</h4>
    <p><strong>array_lambda</strong>(array(1,2,3),'x+10') -> <i>&lt;array: 11,12,13&gt;</i>
    """
    arr=makeList(arr)
    out=list(map(lambda x: eval(lmbd),arr))
    return out

if Qgis.QGIS_VERSION_INT < 32000 :
    @qgsfunction(args='auto', group='Arrays')
    def array_prioritize(arr, refarr, feature, parent):
        """
        Sort an array by another. Missing values are added to the end.
        <h4>Syntax</h4>
        <p><strong>array_prioritize</strong>(<i>array</i>,<i>prioritized array</i>)
        <h4>Arguments</h4>
        <dl>
        <dt><i>array</i></dt><dd>array or string (comma separated values)</dd>
        <dt><i>prioritized array</i></dt><dd>array or string (comma separated values) containing the ordered values</dd>
        </dl>
        <h4>Example usage</h4>
        <p>array_priorize( array(1,8,2,5), array(5,4,2,1,3,8) ) -> &lt;array: 5, 2, 1, 8&gt;
        """
        arr,refarr=makeList(arr),makeList(refarr)
        out=sorted(arr,key=lambda x : refarr.index(x) if x in refarr else len(arr)+1)
        return out    

if Qgis.QGIS_VERSION_INT < 30300 :
    @qgsfunction(args='auto', group='Maps')
    def hstore_to_map(string, feature, parent):
        ##TODO : regex
        """
        Convert hstore string to map
        <h4>Syntax</h4>
        <p><strong>hstore_to_map</strong>(<i>string</i>)
        <h4>Arguments</h4>
        <dl>
        <dt><i>string</i></dt><dd>A hstore formatted string</dd>
        </dl>
        """
        out={}
        rows=string.replace('"',"").split(',')
        for e in rows:
            e=e.split('=>')
            out.update({e[0]:e[1]})
        return out
        
    @qgsfunction(args='auto', group='Maps')    
    def json_to_map(string, feature, parent):
        """
        Convert json string to map 
        <h4>Syntax</h4>
        <p><strong>json_to_map</strong>(<i>json string</i>)
        <h4>Arguments</h4>
        <dl>
        <dt><i>string</i></dt><dd>A json formatted string</dd>
        </dl>
        <h4>Example usage</h4>
        <p>json_to_map('{"a":12,"b":["rre","rra"]}') -> <i>&lt;map: a:12,&lt;array: 'rre','rra'&gt;&gt;</i>
        """
        import json
        return json.loads(string)
    
class ArrayPlus:
    def __init__(self, iface):
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'ArrayPlus_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

    def tr(self, message):
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('ArrayPlus', message)

    def initGui(self):
        QgsExpression.registerFunction(array_avg)
        if Qgis.QGIS_VERSION_INT < 30500 :
            QgsExpression.registerFunction(array_sort)
        QgsExpression.registerFunction(array_lambda)
        if Qgis.QGIS_VERSION_INT < 30300 :
            QgsExpression.registerFunction(hstore_to_map)
            QgsExpression.registerFunction(json_to_map)
        if Qgis.QGIS_VERSION_INT < 31800 :
            QgsExpression.registerFunction(array_majority)
            QgsExpression.registerFunction(array_min)
            QgsExpression.registerFunction(array_max)
            QgsExpression.registerFunction(array_sum)
        if Qgis.QGIS_VERSION_INT < 32000 :
            QgsExpression.registerFunction(array_minority)
            QgsExpression.registerFunction(array_count)
            QgsExpression.registerFunction(array_replace)
            QgsExpression.registerFunction(array_prioritize)


    def unload(self):
        QgsExpression.unregisterFunction('array_avg')
        QgsExpression.unregisterFunction('array_lambda')
        if Qgis.QGIS_VERSION_INT < 30500 :
            QgsExpression.unregisterFunction('array_sort')
        if Qgis.QGIS_VERSION_INT < 30300 :
            QgsExpression.unregisterFunction('hstore_to_map')
            QgsExpression.unregisterFunction('json_to_map')
        if Qgis.QGIS_VERSION_INT < 31800 :
            QgsExpression.unregisterFunction('array_majority')
            QgsExpression.unregisterFunction('array_min')
            QgsExpression.unregisterFunction('array_max')
            QgsExpression.unregisterFunction('array_sum')
        if Qgis.QGIS_VERSION_INT < 32000 :
            QgsExpression.unregisterFunction('array_minority')
            QgsExpression.unregisterFunction('array_count')
            QgsExpression.unregisterFunction('array_replace')
            QgsExpression.unregisterFunction('array_prioritize')

