# Copyright 2006-2007 by ARPAT-SIRA (www.arpat.toscana.it http://sira.arpat.toscana.it/sira/)
# Licenced under GNU GPL (General Public License) v2
# Developed by Martin Dobias for Faunalia (www.faunalia.it)
# For details send a mail to PFR_SIRA@arpat.toscana.it
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation (www.fsf.org); version 2 of the License, or any later version.
#
#
# Copyright 2006-2007 di ARPAT-SIRA (www.arpat.toscana.it http://sira.arpat.toscana.it/sira/)
# Rilasciato sotto licenza GNU GPL (General Public License) v2
# Sviluppato da Martin Dobias per Faunalia (www.faunalia.it)
# Per ulteriori informazioni inviare una mail a PFR_SIRA@arpat.toscana.it
#
# Questo programma rientra nel software libero; possibile redistribuirlo e/o modificarlo
# sotto i termini della licenza GNU General Public License come pubblicato da
# Free Software Foundation (www.fsf.org); versione 2 o superiore della licenza.
#


from PyQt4.QtCore import *
from PyQt4.QtGui import *

from qgis.core import *

import resources
from ConfigDialog import ConfigDialog
from SurveyData import *
from SurveyWidget import SurveyWidget
from SurveyDialog import SurveyDialog

class ArpatPlugin:

    def __init__(self, iface):
        self.iface = iface
        self.dataPath = ""
        self.layer = None
        self.store = None
	
    def initGui(self):
        """ called by QGIS when plugin should initialize itself """

        # create action that will start plugin configuration
        self.actionConfig = QAction(QIcon(":/plugins/arpat/icons/config.png"), "ARPAT Configuration", self.iface.mainWindow())
        self.actionConfig.setWhatsThis("Configuration for ARPAT plugin")
        QObject.connect(self.actionConfig, SIGNAL("activated()"), self.configure)

        self.actionShowLayer = QAction(QIcon(":/plugins/arpat/icons/layer.png"), "Load layer", self.iface.mainWindow())
        self.actionShowLayer.setWhatsThis("Load layer")
        QObject.connect(self.actionShowLayer, SIGNAL("activated()"), self.loadLayer)

        self.actionShowSurvey = QAction(QIcon(":/plugins/arpat/icons/survey.png"), "Show survey", self.iface.mainWindow())
        self.actionShowSurvey.setWhatsThis("Display survey")
        QObject.connect(self.actionShowSurvey, SIGNAL("activated()"), self.showSurvey)

        self.actionAbout = QAction(QIcon(":/plugins/arpat/icons/about.png"), "About", self.iface.mainWindow())
        QObject.connect(self.actionAbout, SIGNAL("triggered()"), self.about)

        # add toolbar
        self.toolBar = self.iface.addToolBar("ARPAT")
        self.toolBar.addAction(self.actionConfig)
        self.toolBar.addAction(self.actionShowLayer)
        self.toolBar.addAction(self.actionShowSurvey)
        
        self.iface.addPluginToMenu("&ARPAT", self.actionConfig)
        self.iface.addPluginToMenu("&ARPAT", self.actionShowLayer)
        self.iface.addPluginToMenu("&ARPAT", self.actionShowSurvey)
        self.iface.addPluginToMenu("&ARPAT", self.actionAbout)

        self.loadSettings()

        self.initStore()

    def unload(self):
        """ called by QGIS when plugin is going to be unloaded """

        # remove the plugin menu item and icon
        self.iface.removePluginMenu("&ARPAT",self.actionConfig)
        self.iface.removePluginMenu("&ARPAT",self.actionShowSurvey)
        self.iface.removePluginMenu("&ARPAT",self.actionShowLayer)
        self.iface.removePluginMenu("&ARPAT", self.actionAbout)

        # remove tool bar
        del self.toolBar


    def about(self):
        from DlgAbout import DlgAbout
        DlgAbout(self.iface.mainWindow()).exec_()


    def loadSettings(self):
        settings = QSettings()
        self.dataPath = settings.value("/Plugins/ARPAT/DataPath").toString()

    def saveSettings(self):
        settings = QSettings()
        settings.setValue("/Plugins/ARPAT/DataPath", QVariant(self.dataPath))

    def initStore(self):
        try:
            self.store = SurveyStore(self.dataPath)
        except DataError, e:
            print "Load failed due: " + e.problem
            self.store = None


    def configure(self):
        dlg = ConfigDialog(self.iface.mainWindow())
        dlg.editPath.setText(self.dataPath)

        if dlg.exec_() == QDialog.Accepted:
            self.dataPath = dlg.editPath.text()
            self.saveSettings()
            self.initStore()

    def showSurvey(self):

        if not self.layerExists():
            QMessageBox.warning(None, "Not loaded", "Layer sondaggio.shp is not loaded yet.")
            return

        lyr = QgsMapLayerRegistry.instance().mapLayer(self.layer)

        ids = lyr.selectedFeaturesIds()
        if len(ids) == 0:
            QMessageBox.information(None, "No selection", "No features were selected in sondaggio.shp")
            return

        #print "selected: " + repr(ids)

        if self.store == None:
            QMessageBox.critical(None, "Data problem", "Databases couldn't be opened properly")
            return

        QApplication.setOverrideCursor(Qt.WaitCursor)
        try:
            s = self.store.getData(ids)
        except DataSanityError, e:
            QApplication.restoreOverrideCursor()
            QMessageBox.warning(None, "Data sanity problem", "Sondaggio ID: %d\n%s" % (e.sond_id, e.message))
            return

        QApplication.restoreOverrideCursor()
        #print s

        # show widget
        w = SurveyDialog()
        w.widget.setData(s, self.store.geo, self.store.idro)
        w.show()

        self.w = w # save reference so it doesn't get deleted immediately

    def layerExists(self):
        return (self.layer != None and QgsMapLayerRegistry.instance().mapLayer(self.layer) != None)
	
    def loadLayer(self):

        # do nothing if layer exists already
        if self.layerExists():
            QMessageBox.information(None, "Already loaded", "Layer sondaggio.shp has been already loaded.")
            return
        
        lyr = QgsVectorLayer(self.dataPath + "/sondaggio.shp", "sondaggio", "ogr")
        if not lyr.isValid():
            QMessageBox.critical(None, "Fatal error", "Couldn't load layer sondaggio.shp!")
            return
        QgsMapLayerRegistry.instance().addMapLayer(lyr)
        self.layer = lyr.getLayerID()
	
