# Copyright 2006-2007 by ARPAT-SIRA (www.arpat.toscana.it http://sira.arpat.toscana.it/sira/)
# Licenced under GNU GPL (General Public License) v2
# Developed by Martin Dobias for Faunalia (www.faunalia.it)
# For details send a mail to PFR_SIRA@arpat.toscana.it
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation (www.fsf.org); version 2 of the License, or any later version.
#
#
# Copyright 2006-2007 di ARPAT-SIRA (www.arpat.toscana.it http://sira.arpat.toscana.it/sira/)
# Rilasciato sotto licenza GNU GPL (General Public License) v2
# Sviluppato da Martin Dobias per Faunalia (www.faunalia.it)
# Per ulteriori informazioni inviare una mail a PFR_SIRA@arpat.toscana.it
#
# Questo programma rientra nel software libero; possibile redistribuirlo e/o modificarlo
# sotto i termini della licenza GNU General Public License come pubblicato da
# Free Software Foundation (www.fsf.org); versione 2 o superiore della licenza.
#


from PyQt4 import QtCore, QtGui

from SurveyWidget import SurveyWidget

class SurveyDialog(QtGui.QDialog):
    
    def __init__(self, parent=None):
        QtGui.QDialog.__init__(self, parent)
        
        self.resize(QtCore.QSize(500,250))
        
        self.setWindowTitle("Identify Results")
        
        self.layout = QtGui.QVBoxLayout(self)
        self.layout.setMargin(5)
        
        self.layout2 = QtGui.QHBoxLayout()
        
        self.widget = SurveyWidget()
        self.layout.addWidget(self.widget)
        
        self.radGeo = QtGui.QRadioButton("Geo")
        self.radGeo.setChecked(True)
        self.layout2.addWidget(self.radGeo)
        self.radHydro = QtGui.QRadioButton("Hydro")
        self.layout2.addWidget(self.radHydro)
        
        spacerItem = QtGui.QSpacerItem(100,0)
        self.layout2.addItem(spacerItem)
        
        self.chkShowDesc = QtGui.QCheckBox("Show descriptions")
        self.chkShowDesc.setChecked(True)
        self.layout2.addWidget(self.chkShowDesc)

	self.btnPrint = QtGui.QPushButton("Print")
	self.layout2.addWidget(self.btnPrint)
        
        self.btnClose = QtGui.QPushButton("Close")
        self.layout2.addWidget(self.btnClose)
        
        self.layout.addLayout(self.layout2)
        
        self.connect(self.btnClose, QtCore.SIGNAL("clicked()"), self.close)
	self.connect(self.btnPrint, QtCore.SIGNAL("clicked()"), self.widget.printDiagram)
        self.connect(self.radGeo, QtCore.SIGNAL("toggled(bool)"), self.typeToggled)
        self.connect(self.chkShowDesc, QtCore.SIGNAL("toggled(bool)"), self.widget.setShowDesc)
        
    def close(self):
        self.accept()
    
    def typeToggled(self):
        if self.radGeo.isChecked():
            self.widget.setType(0)
        else:
            self.widget.setType(1)

