# Copyright 2006-2007 by ARPAT-SIRA (www.arpat.toscana.it http://sira.arpat.toscana.it/sira/)
# Licenced under GNU GPL (General Public License) v2
# Developed by Martin Dobias for Faunalia (www.faunalia.it)
# For details send a mail to PFR_SIRA@arpat.toscana.it
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation (www.fsf.org); version 2 of the License, or any later version.
#
#
# Copyright 2006-2007 di ARPAT-SIRA (www.arpat.toscana.it http://sira.arpat.toscana.it/sira/)
# Rilasciato sotto licenza GNU GPL (General Public License) v2
# Sviluppato da Martin Dobias per Faunalia (www.faunalia.it)
# Per ulteriori informazioni inviare una mail a PFR_SIRA@arpat.toscana.it
#
# Questo programma rientra nel software libero; possibile redistribuirlo e/o modificarlo
# sotto i termini della licenza GNU General Public License come pubblicato da
# Free Software Foundation (www.fsf.org); versione 2 o superiore della licenza.
#

from PyQt4 import QtCore, QtGui
from SurveyData import *

class SurveyWidget(QtGui.QFrame):

    def __init__(self, parent = None):
        QtGui.QFrame.__init__(self, parent)
        
        self.setFrameShape(QtGui.QFrame.StyledPanel)
        self.setLineWidth(3)
    
        self.sondaggio = {}
        self.geo = {}
        self.hydro = {}
    
        self.switchGeoHydro = 0
        self.showDesc = True
        
    def setData(self, sondaggio, geo, hydro):
        self.sondaggio = sondaggio
        self.geo = geo
        self.hydro = hydro
        
        # find out whether the overall distance is bigger on x or y axis
        # so columns will be sorted by their x or y coordinate
        inf = 999999999
        (xMin, yMin, xMax, yMax) = (inf, inf, -inf, -inf)
        for s in sondaggio.itervalues():
            (x, y) = (s.coord.x(), s.coord.y())
            if x < xMin: xMin = x
            if y < yMin: yMin = y
            if x > xMax: xMax = x
            if y > yMax: yMax = y
        
        if xMax - xMin > yMax - yMin:
            # sort using x coordinate
            cc = lambda a,b: cmp(a.coord.x(), b.coord.x())
        else:
            # sort using y coordinate
            cc = lambda a,b: cmp(a.coord.y(), b.coord.y())
        
        order = sorted(self.sondaggio.itervalues(), cc)
        
        self.order = []
        for o in order:
            self.order.append(o.id)

                
    def setType(self, switchGeoHydro):
        """ sets whether fill columns with Geo colors (0) or Hydro colors (1) """
        self.switchGeoHydro = switchGeoHydro
        self.update()

    def setShowDesc(self, show):
        self.showDesc = show
        self.update()
                
    def paintEvent(self, event):
        """ redraws the whole widget's area """
        
        QtGui.QFrame.paintEvent(self,event)

        # check whether there's a survey to show
        if len(self.sondaggio) == 0:
            p = QtGui.QPainter(self)
            p.drawText(self.rect(), QtCore.Qt.AlignCenter | QtCore.Qt.AlignVCenter, "No data to display")
            return

        painter = QtGui.QPainter(self)

        self.drawSurveys(self.rect(), painter)
                
    def drawSurveys(self, rect, painter):
        """ draw surveys to specified rect with specified painter """

        surveys = len(self.sondaggio)
        
        surveyWidth = rect.width() / surveys
        surveyHeight = rect.height()
        columnWidth = rect.width() * 0.05
        x = 0
        margin = 4
        
        # find out depth interval
        depthBed, depthTop = 999999, -999999
        for sond_id in self.order:
            sond = self.sondaggio[sond_id]
            dTop = sond.qpc - sond.strata[0].depthTop
            dBed = sond.qpc - sond.strata[-1].depthBed
            
            if dTop > depthTop: depthTop = dTop
            if dBed < depthBed: depthBed = dBed
            
        # draw surveys
        for sond_id in self.order:

            r = QtCore.QRect(x + margin, 0 + margin, surveyWidth - 2*margin, surveyHeight - 2*margin)
            x += surveyWidth

            sond = self.sondaggio[sond_id]
        
            # draw the survey
            self.drawSurvey(painter, sond, r, columnWidth, (depthBed, depthTop))


    def drawSurvey(self, p, sond, sRect, columnWidth, interval):
        """ draws one survey to rectangle in widget specified by sRect """
        
        depthTop = sond.qpc
        depthBed = depthTop - sond.strata[-1].depthBed
        
        fm = QtGui.QFontMetrics(p.font())
        nameHeight = fm.height()
        depthHeight = fm.height()
        
        # name
        labelRect = QtCore.QRect(sRect.left(),sRect.top(),sRect.width(),nameHeight)
        p.drawText(labelRect, QtCore.Qt.AlignVCenter, sond.name)
        
        scale = (sRect.height() - nameHeight - depthHeight*2) / (interval[1]-interval[0])
        
        top = sRect.top()+nameHeight+depthHeight
        yTop = top + (interval[1]-depthTop)*scale
        yBed = top + (interval[1]-depthBed)*scale
        
        # top depth
        depthRect = QtCore.QRect(sRect.left(),yTop-depthHeight,sRect.width(),depthHeight)
        p.drawText(depthRect, QtCore.Qt.AlignVCenter, "%.1f m" % depthTop)
        
        # bed depth
        depthRect = QtCore.QRect(sRect.left(),yBed+1,sRect.width(),depthHeight)
        p.drawText(depthRect, QtCore.Qt.AlignVCenter, "%.1f m" % depthBed)
        
        
        dRect = QtCore.QRect(QtCore.QPoint(sRect.left(), yTop),
                             QtCore.QPoint(sRect.left()+columnWidth, yBed))
    
        p.drawRect(dRect)
    
        scale = dRect.height() / (depthTop - depthBed)
        y = dRect.top()
    
        for layer in sond.strata:
            y2 = (layer.depthBed - layer.depthTop) * scale

            # column rectangle
            cRect = QtCore.QRect(QtCore.QPoint(dRect.left(), y),
                                 QtCore.QPoint(dRect.right(), y+y2-1))

            # text rectangle
            tRect = QtCore.QRect(QtCore.QPoint(dRect.right()+10, y),
                                 QtCore.QPoint(sRect.right(), y+y2))
            
            # select brush pattern depending on the type
            # F ... points
            # T ... vertical lines
            # C ... horizontal lines
            if layer.type == 'F':
                bType = QtCore.Qt.Dense6Pattern
            elif layer.type == 'T':
                bType = QtCore.Qt.VerPattern
            elif layer.type == 'C':
                bType = QtCore.Qt.HorPattern
            else:
                bType = QtCore.Qt.NoBrush

            # select brush pattern depending on usage of geo or hydro
            if self.switchGeoHydro == 0:
                color = self.textToColor(self.geo, layer.geoId)
            else:
                color = self.textToColor(self.hydro, layer.hydroId)

            # draw column with background color
            p.setBrush(color)
            p.drawRect(cRect)

            # draw column with specified hatch
            p.setBrush(QtGui.QBrush(QtCore.Qt.black, bType))
            p.drawRect(cRect)

            # draw associated text
            if self.showDesc:
                p.drawText(tRect, QtCore.Qt.AlignVCenter, layer.description)

            y += y2

    def textToColor(self, db, id):
        """ returns QColor from the specified text """
        colors = {
            'rosso'  : QtCore.Qt.red,
            'giallo' : QtCore.Qt.yellow,
            'verde'  : QtCore.Qt.green,
            'ciano'  : QtCore.Qt.cyan,
            'blu'    : QtCore.Qt.blue,
            'nero'   : QtCore.Qt.black,
            'grigio' : QtCore.Qt.gray,
            'magenta': QtCore.Qt.magenta }

        if not db.has_key(id):
            txtColor = ""
        else:
            txtColor = db[id][1]

        if colors.has_key(txtColor):
            return colors[txtColor]
        else:
            return QtCore.Qt.white
    
    def printDiagram(self):
        """ outputs the diagram to the printer (or PDF) """
        printer = QtGui.QPrinter(QtGui.QPrinter.HighResolution)
        
        # set defaults
        printer.setOrientation(QtGui.QPrinter.Landscape)

	# setting output file name results in not opening print dialog on Win
        #printer.setOutputFileName("arpat.pdf")
        
        # show print dialog
        dlg = QtGui.QPrintDialog(printer, self)
        if dlg.exec_() != QtGui.QDialog.Accepted:
            return
        
        p = QtGui.QPainter()
        p.begin(printer)
        
        rect = printer.pageRect()
        #print "rect: ", rect.left(), rect.top(), rect.width(), rect.height()

        self.drawSurveys(rect, p)
        
        p.end()
