# Copyright 2006-2007 by ARPAT-SIRA (www.arpat.toscana.it http://sira.arpat.toscana.it/sira/)
# Licenced under GNU GPL (General Public License) v2
# Developed by Martin Dobias for Faunalia (www.faunalia.it)
# For details send a mail to PFR_SIRA@arpat.toscana.it
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation (www.fsf.org); version 2 of the License, or any later version.
#
#
# Copyright 2006-2007 di ARPAT-SIRA (www.arpat.toscana.it http://sira.arpat.toscana.it/sira/)
# Rilasciato sotto licenza GNU GPL (General Public License) v2
# Sviluppato da Martin Dobias per Faunalia (www.faunalia.it)
# Per ulteriori informazioni inviare una mail a PFR_SIRA@arpat.toscana.it
#
# Questo programma rientra nel software libero; possibile redistribuirlo e/o modificarlo
# sotto i termini della licenza GNU General Public License come pubblicato da
# Free Software Foundation (www.fsf.org); versione 2 o superiore della licenza.
#


from PyQt4.QtCore import *
from PyQt4.QtGui import *

import os.path

from ui.ConfigDialog_ui import Ui_ConfigDialog

class ConfigDialog(QDialog, Ui_ConfigDialog):

	def __init__(self, parent):
		QDialog.__init__(self, parent)

		self.setupUi(self)

		QObject.connect(self.btnSetPath, SIGNAL("clicked()"), self.setPath)

		QObject.connect(self.editPath, SIGNAL("textChanged(const QString &)"), self.checkFiles)


	def setPath(self):

		path = QFileDialog.getExistingDirectory(self,
		                                        "Select data directory",
							self.editPath.text())
		if not path.isEmpty():
			self.editPath.setText(path)


	def checkFiles(self):
		""" check whether files we need exist in that directory """

		path = str(self.editPath.text()) + "/"

		files = [ "sondaggio.shp", "sondaggio.dbf", "strato.dbf", "geo.dbf", "idro.dbf" ]
		filesNotFound = []

		for file in files:
			if not os.path.exists(path + file):
				filesNotFound.append(file)

		if len(filesNotFound) == 0:
			text = "<font color=green>Correct directory, all files have been found</font>"
		elif len(filesNotFound) == len(files):
			text = "<font color=red>Wrong directory, all files are missing!</font>"
		else:
			text = "<font color=red>Some files are missing:</font><br>"
			for file in filesNotFound:
				text += file + "<br>"

		self.lblDirStatus.setText(text)

