# -*- coding: utf-8 -*-
"""
/***************************************************************************
 ARPAdata
                                 A QGIS plugin
 This plugin downloads the data from ARPA Lombardia API
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-03-15
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Mathilde Puche
        email                : mathilde-puche@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, QVariant, QDateTime, QTime, QDate, Qt, QSizeF
from qgis.PyQt.QtGui import QIcon, QColor, QFont
from qgis.PyQt.QtWidgets import QAction, QApplication, QFileDialog, QProgressBar, QProgressDialog
from qgis.core import Qgis, QgsProject, QgsVectorLayer, QgsFields, QgsFeature, QgsField, QgsGeometry,QgsPoint, QgsPointXY, QgsFeatureRequest,QgsHistogramDiagram
from qgis.core import QgsRuleBasedLabeling, QgsDiagramSettings, QgsLinearlyInterpolatedDiagramRenderer,QgsDiagramLayerSettings,QgsPalLayerSettings,QgsTextFormat


import datetime
import time
"""import pandas as pd"""
import statistics
from sodapy import Socrata

import scipy.stats

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .arpa_data_dialog import ARPAdataDialog
import os.path


class ARPAdata:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'ARPAdata_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&ARPA data')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('ARPAdata', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/arpa_data/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'ARPA Lombardia Data Extractor'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&ARPA data'),
                action)
            self.iface.removeToolBarIcon(action)

    def connect_ARPI_api(self):
        # Unauthenticated client only works with public data sets. Note 'None'
        # in place of application token, and no username or password:
        client = Socrata("www.dati.lombardia.it", None)
        
        # Authenticated client (needed for non-public datasets):
        # client = Socrata(www.dati.lombardia.it,
        #                  MyAppToken,
        #                  userame="user@example.com",
        #                  password="AFakePassword")

        return client
    
    
    #Modify the min and max dateTime proposed to the user and the sensor type list depending on the selected dataset
    def on_dataset_changed(self, value_dataset):
        
        self.dlg.sensor_type_list.clear()
      
        if value_dataset ==1 or value_dataset ==2:
            
            #get the current time to define the available data at current time
            now_date = QDateTime.currentDateTime().date()
            now_day=now_date.day()
            if now_day < 2:
                max_date=now_date.addDays(-now_day)
            else:
                max_date=now_date.addDays(-1)
            now_month=max_date.month() #We take the max_date and not the now_date in case the date is the first day of the month
            now_year=max_date.year()
            
            if value_dataset ==1:
              
                #For weather, only the data of the current month is available
                min_datetime=QDateTime(QDate(now_year, now_month,1),QTime(1, 0, 0, 0))
                max_datetime=QDateTime(max_date, QTime(0, 0, 0, 0))
                
                #Sensor list for Weather
                items = ["Altezza Neve","Direzione Vento","Livello Idrometrico","Precipitazione", "Radiazione Globale", "Temperatura", 
                         "Umidità Relativa","Velocità Vento"]
                
            
            elif value_dataset ==2:
                
                #For the air quality, the data of the current year is available
                min_datetime=QDateTime(QDate(now_year, 1,1), QTime(0, 0, 0, 0))
                max_datetime=QDateTime(max_date, QTime(0, 0, 0, 0))
                
                #Sensor list for Air Quality
                items = ["Ammoniaca","Arsenico","Benzene","Benzo(a)pirene","Biossido di Azoto", "Biossido di Zolfo", 
                                           "BlackCarbon","Cadmio", "Monossido di Azoto", "Monossido di Carbonio", "Nikel", "Ossidi di Azoto", 
                                           "Ozono", "Particelle sospese PM2.5","Particolato Totale Sospeso", "Piombo", "PM10", "PM10 (SM2005)"]
                

            
            self.dlg.dateTime_stop.setMinimumDateTime(min_datetime)
            self.dlg.dateTime_stop.setMaximumDateTime(max_datetime)
            self.dlg.dateTime_stop.setDateTime(max_datetime)
            
            
            self.dlg.dateTime_start.setMinimumDateTime(min_datetime)
            self.dlg.dateTime_start.setMaximumDateTime(max_datetime)
            self.dlg.dateTime_start.setDateTime(min_datetime)
            
            self.dlg.sensor_type_list.addItems(items)
            
        elif value_dataset <=0:
            print("Initial value OK")
            pass
        else:
            print("No valid value for dataset number")
            pass
            

    #Modify the list selection when the user check or uncheck the checkbox for all sensors
    def on_check_changed(self, is_checked):
        if is_checked:
            self.dlg.sensor_type_list.selectAll()
        else:
            self.dlg.sensor_type_list.clearSelection()
            
            
    #Modify the checkbox for no_distinction: make it checkable if the week_days and weekends are checked
    def on_check_day_changed(self, week_days, weekends):
        if week_days and weekends:
            self.dlg.no_distinction.setCheckable(True)
            self.dlg.no_distinction.setChecked(True)
            
        else:
            self.dlg.no_distinction.setChecked(False)
            self.dlg.no_distinction.setCheckable(False)

    
    #Modify the insert line for polygon depending on the choice of the user about the area (all lombardia or insert area)
    def on_area_changed(self, area):
        if area=="Insert area":
            self.dlg.province_list.clear()
            self.dlg.province_list.setEnabled(False)
            self.dlg.line_polygon.setEnabled(True)
            self.dlg.search_button.setEnabled(True)
        elif area == "Lombardia":
            self.dlg.province_list.setEnabled(True)
            self.dlg.province_list.clear()
            self.dlg.province_list.addItems(["All provinces","BG - Bergamo", "BS - Brescia", "CO - Como", "CR - Cremona", "LC - Lecco", 
                                         "LO - Lodi", "MN - Mantova", "MI - Milano", "MB - Monza e della Brianza", "PV - Pavia", 
                                         "SO - Sondrio", "VA - Varese"])
            self.dlg.line_polygon.setEnabled(False)
            self.dlg.search_button.setEnabled(False)



    #Desable/Enable the time filters and the visualization button depending on the check/uncheck of the without data button
    def on_without_data_changed (self, without_data, sensors_list):
        if without_data:
            self.dlg.dateTime_stop.setEnabled(False)
            self.dlg.dateTime_start.setEnabled(False)
            self.dlg.week_days.setEnabled(False)
            self.dlg.weekends.setEnabled(False)
            self.dlg.no_distinction.setEnabled(False)
            self.dlg.visualization.setEnabled(False)
            self.dlg.visualization.setChecked(False)
            self.dlg.raw_data.setEnabled(False)
            self.dlg.raw_data.setChecked(False)
        else:
            self.dlg.dateTime_stop.setEnabled(True)
            self.dlg.dateTime_start.setEnabled(True)
            self.dlg.week_days.setEnabled(True)
            self.dlg.weekends.setEnabled(True)
            self.dlg.no_distinction.setEnabled(True)
            if len(sensors_list)==1:
                self.dlg.visualization.setEnabled(True)
                self.dlg.visualization.setChecked(True)
                self.dlg.raw_data.setEnabled(True)
                
    
    
    #To search the file name (path)of the area of interest when the user click on the search button
    def search_file(self):
        if self.dlg.search_button.isDown():
            pass
        else:
            fname, _ = QFileDialog.getOpenFileName(None, 'Select a file', 
                                            '', "Shapefiles (*.shp);;All Files (*)")
            self.dlg.line_polygon.clear()
            self.dlg.line_polygon.insert(fname)
        
        self.dlg.search_button.setDown(True)
    
    
    #Set the visualization button as enabled/disabled depending on the number of sensors
    def changeVisualization(self, sensors_list, without_data):        
        if len(sensors_list)==1 and not without_data:
            self.dlg.visualization.setEnabled(True)
            self.dlg.visualization.setChecked(True)
            
        else:
            self.dlg.visualization.setChecked(False)
            self.dlg.visualization.setEnabled(False)

    #Set the raw data button as enabled/disabled depending on the number of sensors
    def changeRawdata(self, sensors_list, without_data):        
        if len(sensors_list)==1 and not without_data:
            self.dlg.raw_data.setEnabled(True)
            
        else:
            self.dlg.raw_data.setChecked(False)
            self.dlg.raw_data.setEnabled(False)

    
    #Request ARPA data to get the station location and information from the selected dataset 
    def request_ARPA_stations(self,client, dataset_num, datasetId, sensors, selected_aoi, geom, provinces):
        stations_json={}
        if dataset_num==1 or dataset_num==2:
                
            #For weather data
            if dataset_num == 1:
                query = """
                    select
                        *
                    where (storico='N') and (tipologia=\'{}\'""".format(sensors[0])
                
                for sensor in sensors[1:]:
                    query=query+" or tipologia=\'{}\'".format(sensor)
                    
                query = query+")"
                
                
                
            #For air quality data
            elif dataset_num == 2:
                query = """
                    select
                        *
                    where (storico='N') and (nometiposensore=\'{}\'""".format(sensors[0])
                for sensor in sensors[1:]:
                    query=query+" or nometiposensore=\'{}\'".format(sensor)
                
                query = query+")"
                
                
        
            if selected_aoi == "Insert area":
                polygon=geom.asWkt()
                tolerence=0.005
                while len(polygon)>10000 and tolerence <100:
                    polygon=geom.simplify(tolerence).asWkt()
                    tolerence=tolerence*2
                    
                query=query+" and within_polygon(location, \'{}\')".format(polygon)
                    
            elif selected_aoi == "Lombardia":
                if provinces != "All provinces" and provinces != "":
                    query=query+" and provincia = \'{}\'".format(provinces[0:2])
            
            print("Length of query: "+str(len(query)))
            
            try:
                stations_json = client.get(datasetId, query=query)
            
            except:
                QApplication.beep() 
                self.iface.messageBar().pushMessage("The area selected has too much points", Qgis.Warning)
                stations_json = {}
                    
        
        return stations_json

    
    #Get the areas of interest contained in the shapefile, and create the layer for this aoi
    def get_areas_of_interest(self):
        #get the shapefile name entered by the user
        file_name = self.dlg.line_polygon.text()
        #the geometries of the aoi
        geoms=[]
        #the id of each aoi
        f_ids=[]
        layer_aoi=""
        
        if file_name == '':
            inserted=False
            QApplication.beep() 
            self.iface.messageBar().pushMessage("Area(s) of interest not inserted", Qgis.Warning)
        
        else:
            inserted=True
            #layer of areas of interest
            layer_aoi_inserted = QgsVectorLayer(file_name, 'Inserted shp', 'ogr')
            layer_aoi = self.clone_layer(layer_aoi_inserted, 'Area(s) of interest')
            
            
            #Add the field for id (enable to identify the aoi concerned for each stat in the other layers)
            layer_aoi.startEditing()
            pr_aoi = layer_aoi.dataProvider()
            qgs_f_aoi=QgsFields()
            qgs_f_aoi.append(QgsField('aoi', QVariant.Int))
            pr_aoi.addAttributes(qgs_f_aoi)
            layer_aoi.updateFields()
            layer_aoi.commitChanges()
            
            #get the index of the attribute 'aoi'
            list_fields=pr_aoi.fields()
            index_att = list_fields.indexFromName('aoi')
            
            #stores all the geometries and add the id field
            l_features=layer_aoi.getFeatures(QgsFeatureRequest())
            layer_aoi.startEditing()
            
            for feat in l_features:
                if int(feat.geometry().wkbType())==6:
                    geoms.append(feat.geometry())
                    f_ids.append(feat.id())
                    layer_aoi.changeAttributeValue(feat.id(), index_att, feat.id())
                    
                else:
                    self.iface.messageBar().pushMessage("The geometry has to be a multipolygon!", Qgis.Warning)
            layer_aoi.commitChanges()
            
            if not geoms:
                QApplication.beep() 
                self.iface.messageBar().pushMessage("The inserted geometries are not multipolygons", Qgis.Warning)
    
        ret=(geoms, f_ids, layer_aoi, inserted)
        return ret

    
    def get_polygon (self, area_name):

        if area_name == "All provinces":
            #shapefile for Lombardia
            file_name=os.path.dirname(__file__)+ '/Aoi/Regione_4326.shp'
            name="Lombardia"
        else:
            name=area_name[3:]
            if area_name == "BG - Bergamo":
                #shapefile for Bergamo
                file_name= os.path.dirname(__file__) + '/Aoi/provincia_bergamo_4326.shp'
            if area_name == "BS - Brescia":
                #shapefile for Brescia
                file_name= os.path.dirname(__file__) + '/Aoi/provincia_brescia_4326.shp'
            if area_name == "CO - Como":
                #shapefile for Como
                file_name= os.path.dirname(__file__) + '/Aoi/provincia_como_4326.shp'
            if area_name == "CR - Cremona":
                #shapefile for Cremona
                file_name= os.path.dirname(__file__) + '/Aoi/provincia_cremona_4326.shp'
            if area_name == "LC - Lecco":
                #shapefile for Lecco
                file_name= os.path.dirname(__file__) + '/Aoi/provincia_lecco_4326.shp'
            if area_name == "LO - Lodi":
                #shapefile for Lodi
                file_name= os.path.dirname(__file__) + '/Aoi/provincia_lodi_4326.shp'
            if area_name == "MN - Mantova":
                #shapefile for Mantova
                file_name= os.path.dirname(__file__) + '/Aoi/provincia_mantova_4326.shp'
            if area_name == "MI - Milano":
                #shapefile for Milano
                file_name= os.path.dirname(__file__) + '/Aoi/provincia_milano_4326.shp'
            if area_name == "MB - Monza e della Brianza":
                #shapefile for Monza e della Brianza
                file_name= os.path.dirname(__file__) + '/Aoi/provincia_monza_4326.shp'
            if area_name == "PV - Pavia":
                #shapefile for Pavia
                file_name= os.path.dirname(__file__) + '/Aoi/provincia_pavia_4326.shp'
            if area_name == "SO - Sondrio":
                #shapefile for Sondrio
                file_name= os.path.dirname(__file__) + '/Aoi/provincia_sondrio_4326.shp'
            if area_name == "VA - Varese":
                #shapefile for Varese
                file_name= os.path.dirname(__file__) + '/Aoi/provincia_varese_4326.shp'
        
        
        
        layer_aoi_inserted=QgsVectorLayer(file_name, 'Inserted shp', 'ogr')
        layer_aoi = self.clone_layer(layer_aoi_inserted, 'Area of interest')
        
        #Add the field for id (enable to identify the aoi concerned for each stat in the other layers)
        layer_aoi.startEditing()
        pr_aoi = layer_aoi.dataProvider()
        qgs_f_aoi=QgsFields()
        qgs_f_aoi.append(QgsField('aoi', QVariant.Int))
        pr_aoi.addAttributes(qgs_f_aoi)
        layer_aoi.updateFields()
        layer_aoi.commitChanges()
        
        #get the index of the attribute 'aoi'
        list_fields=pr_aoi.fields()
        index_att = list_fields.indexFromName('aoi')
        
        #stores the geometry and add the id field
        l_features=layer_aoi.getFeatures(QgsFeatureRequest())
        
        layer_aoi.startEditing()
        geoms=[]
        f_ids=[]
        
        for feat in l_features:
            geoms.append(feat.geometry())
            f_ids.append(feat.id())
            layer_aoi.changeAttributeValue(feat.id(), index_att, feat.id())
  
        layer_aoi.commitChanges()
                
        ret=(geoms, f_ids, layer_aoi, name)

        return ret


    #To clone a layer (for us: the layer of aoi)
    def clone_layer(self, layer_to_clone, name_duplicated):
        feats = [feat for feat in layer_to_clone.getFeatures()]
        duplicated = QgsVectorLayer("Polygon?crs=epsg:4326", name_duplicated, "memory")
        duplicated_data = duplicated.dataProvider()
        attr = layer_to_clone.dataProvider().fields().toList()
        duplicated_data.addAttributes(attr)
        duplicated.updateFields()
        duplicated_data.addFeatures(feats)
        return duplicated


    #Request the ARPA data for one particular sensor between start_date and end_date
    def req_ARPA_data_sensor(self,client,id_sensor, dataset_num,start_date,end_date):
        data_sensor = {}
        query = """
            select
                *
            where data between \'{}\' and \'{}\' and idsensore=\'{}\' 
            """.format(start_date,end_date, id_sensor)
        
        if dataset_num == 1 :
            data_sensor = client.get("647i-nhxk",query=query)
        elif dataset_num == 2:
            data_sensor = client.get("nicp-bhqi",query=query)
        elif dataset_num <=0:
            print("Initial value OK")
            
        else:
            print("No valid value for dataset number")
            
        return data_sensor
                 

    def ANOVA_test(self, groups, means,size_groups):
        k=len(groups)
        n=sum(size_groups)

        
        #compute the mean of means
        u=statistics.mean(means)
        
        
        #compute between groups source of variation sigma_w2 
        #and compute within groups source of variation sigma_T2
        sigma_w2=0
        sigma_T2=0
        for i in range (0,k):
            sigma_w2+=size_groups[i]*(means[i]-u)**2
            for j in range (0,size_groups[i]):
                sigma_T2+=(groups[i][j]-means[i])**2
        
        sigma_w2=sigma_w2*1/(k-1)
        sigma_T2=sigma_T2*1/(n-k)
        
        #compute Fisher test with theoretical value with a confidence level of 5%
        if sigma_T2!=0:
            Femp=sigma_w2/sigma_T2
            Fth=scipy.stats.f.ppf(q=1-0.05, dfn=k-1, dfd=n-k)
            
            if Femp < Fth:
                ret = (True, u)
                
                
            else:
                ret = (False, 0)
        
        else:
            #if sigma_T2==0 it means all the means are equal, and the test is not applicable
            ret = (False, 1)
        
        return ret
            
    
    #To generate the diagram for vizaulization
    def histogram(self, layer, attribute_indx, attributes_names, max_value, max_att_name,scale):

        # attribute_names is a list containing the names of the sensor+the stats as follow:
        # [sensor max_value, sensor mean_value, sensor median_value, sensor min_value, sensor stdev]
       
        # attributes_indx is the list of indexes of these values in the same order
        
        # Set histogram and diagram settings:
        hist = QgsHistogramDiagram()
        ds = QgsDiagramSettings()
        dColors = [QColor(255,51,51), #red
                   QColor(153,51,255), #purple
                   QColor(255,128,0), #orange
                   QColor(102,204,0), #green
                   QColor(51,51,255)] #blue

        ds.categoryIndices = attribute_indx
        ds.categoryColors = dColors
        ds.categoryAttributes = attributes_names
        ds.categoryLabels = attributes_names
        ds.font = QFont("Helvetica", 12)
        ds.transparency = 0
        ds.size = QSizeF(40.0, 40.0)
        ds.sizeType = 0
        ds.labelPlacementMethod = 1
        ds.diagramOrientation = 0
        ds.scaleByArea = True
        ds.minimumSize = 0
        ds.transparency = 0
        ds.penColor = QColor("black")
        ds.penWidth = 0
        ds.barWidth = 4.0
        ds.scaleBasedVisibility = True
        if scale == 'small scale':
            ds.minimumScale = 1300000
            ds.maximumScale = 350000
        elif scale == 'large scale':
            ds.minimumScale = 350000

        # Set renderer:
        renderer = QgsLinearlyInterpolatedDiagramRenderer()
        renderer.setUpperValue(max_value)  
        renderer.setUpperSize(QSizeF(30, 30))
        renderer.setLowerValue(0.0)
        renderer.setLowerSize(QSizeF(0, 0))
        renderer.setDiagram(hist)
        renderer.setDiagramSettings(ds)
        renderer.setClassificationField(max_att_name)

        # Set diagram layer settings:
        layer.setDiagramRenderer(renderer)
        dls = QgsDiagramLayerSettings()
        dls.setDistance(-20)
        dls.placement = 1
        dls.setPriority(5)
        dls.xPosColumn = -1
        dls.yPosColumn = -1
        
        
        #Set the labels
        ls = QgsPalLayerSettings()
        ls.isExpression = True
        ls.placement = 1
        ls.quadOffset = 7
        ls.xOffset = 7.0
        ls.yOffset = 4.0
        
        ls.scaleVisibility = True
        if scale == 'small scale':
            ls.minimumScale = 1300000
            ls.maximumScale = 350000
        elif scale == 'large scale':
            ls.minimumScale = 350000
        
        text_format = QgsTextFormat()
        text_format.setFont(QFont("Bahnschrift Condensed", 4))
        text_format.setSize(9)
        ls.setFormat(text_format)
        
        exp="concat(round({},1),'  ',round({},1),'  ',round({},1),'  ',round({},1),'  ',round({},1))".format(attributes_names[0],attributes_names[1],attributes_names[2],attributes_names[3], attributes_names[4])
        ls.fieldName = exp
        ls.enabled = True
        #Create and append a new rule
        root = QgsRuleBasedLabeling.Rule(QgsPalLayerSettings())
        rule = QgsRuleBasedLabeling.Rule(ls)
        rule.setDescription("Statistics label")
        root.appendChild(rule)

        #Apply label configuration
        layer.setLabelsEnabled(True)

        rules = QgsRuleBasedLabeling(root)
        layer.setLabeling(rules)
                
        layer.setDiagramLayerSettings(dls)
        layer.triggerRepaint()

    # To set the progress bar
    def progdialog(self,progress):
        p_dialog = QProgressDialog('Request in process...', 'Cancel', 0, 100)
        p_dialog.setWindowTitle("Progress")
        p_dialog.setWindowModality(Qt.WindowModal)
        bar = QProgressBar(p_dialog)
        bar.setTextVisible(True)
        bar.setValue(progress)
        p_dialog.setBar(bar)
        p_dialog.setMinimumWidth(300)
        p_dialog.show()
        return p_dialog, bar

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = ARPAdataDialog()
        

        # Clear the contents from previous runs
        self.dlg.dataset_list.clear()
        self.dlg.area_list.clear()
        self.dlg.province_list.clear()
        self.dlg.sensor_type_list.clear()
        self.dlg.without_data.setChecked(False)
        self.dlg.all_sensors.setChecked(False)
        self.dlg.week_days.setChecked(True)
        self.dlg.weekends.setChecked(True)
        self.dlg.no_distinction.setChecked(True)
        self.dlg.line_polygon.clear()
        self.dlg.visualization.setChecked(False)
        self.dlg.raw_data.setChecked(False)
        
        
        # Populate the comboBox of datasets with names of all the possible dataset
        self.dlg.dataset_list.addItems(["","Weather", "Air Quality"])
        
        #Set the visualization button as enabled/disabled depending on the number of sensors
        self.dlg.sensor_type_list.itemSelectionChanged.connect(lambda: self.changeVisualization(self.dlg.sensor_type_list.selectedItems(), self.dlg.without_data.isChecked()))
        
        #Set the raw data button as enabled/disabled depending on the number of sensors
        self.dlg.sensor_type_list.itemSelectionChanged.connect(lambda: self.changeRawdata(self.dlg.sensor_type_list.selectedItems(), self.dlg.without_data.isChecked()))
        
        
        #Modify the visualization button depending on the distinction of weekdays/weekends
        self.dlg.no_distinction.stateChanged.connect(lambda: self.changeVisualization(self.dlg.sensor_type_list.selectedItems(), self.dlg.without_data.isChecked()))
        
        
        #Modify the list of sensors, the starting date and the ending date propositions depending on the selected dataset
        self.dlg.dataset_list.currentIndexChanged.connect(self.on_dataset_changed, self.dlg.dataset_list.currentIndex())
        
        #Modify the starting date possibility and ending date possibilities to avoid end < start
        self.dlg.dateTime_stop.dateChanged.connect(lambda: self.dlg.dateTime_start.setMaximumDateTime(self.dlg.dateTime_stop.dateTime()))
        self.dlg.dateTime_start.dateChanged.connect(lambda: self.dlg.dateTime_stop.setMinimumDateTime(self.dlg.dateTime_start.dateTime()))
        
        #Select or Deselect all the sensors if all_sensors is checked/unchecked
        self.dlg.all_sensors.stateChanged.connect(lambda: self.on_check_changed(self.dlg.all_sensors.isChecked()))
        
        #Modify the checkboxes for week_days, weekends or no_distinction
        self.dlg.week_days.stateChanged.connect(lambda: self.on_check_day_changed(self.dlg.week_days.isChecked(), self.dlg.weekends.isChecked()))
        self.dlg.weekends.stateChanged.connect(lambda: self.on_check_day_changed(self.dlg.week_days.isChecked(), self.dlg.weekends.isChecked()))
        
        # Populate the comboBox of area with the possible options
        self.dlg.area_list.addItems(["Lombardia","Insert area"])
        
        # Populate the comboBox of provinces with the possible options
        self.dlg.province_list.clear()
        self.dlg.province_list.addItems(["All provinces","BG - Bergamo", "BS - Brescia", "CO - Como", "CR - Cremona", "LC - Lecco", 
                                           "LO - Lodi", "MN - Mantova", "MI - Milano", "MB - Monza e della Brianza", "PV - Pavia", 
                                           "SO - Sondrio", "VA - Varese"])
        
        #Modify the insert line for polygon depending on the choice of the user about the area (all lombardia or insert area)
        self.dlg.area_list.currentIndexChanged.connect(lambda: self.on_area_changed(self.dlg.area_list.currentText()))
        
        #Desable/Enable the time filters depending on the check/uncheck of the without data button
        self.dlg.without_data.stateChanged.connect(lambda: self.on_without_data_changed(self.dlg.without_data.isChecked(),self.dlg.sensor_type_list.selectedItems()))
        
        #Search the file name (path)of the area of interest when the user click on the search button
        self.dlg.search_button.clicked.connect(lambda: self.search_file())
    
        
    
        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        
        # See if OK was pressed
        if result:
            
            # Progress bar
            p_dialog, bar = self.progdialog(0)
            bar.setMaximum(100)
            bar.setValue(0)
            QApplication.processEvents()
            
            #get the user choices regarding the time
            selected_data_start = self.dlg.dateTime_start.dateTime()
            selected_date_start_str = selected_data_start.toString("yyyy-MM-ddTHH:mm:ss")
            
            selected_date_end = self.dlg.dateTime_stop.dateTime()
            selected_date_end_str = selected_date_end.toString("yyyy-MM-ddTHH:mm:ss")
           
            #to add to the name of the layer
            start_date_str = selected_data_start.toString("dd/MM h:mm")
            end_date_str = selected_date_end.toString("dd/MM h:mm")
            
            
            
            #get the user choices regarding the days of the week
            weekdays = self.dlg.week_days.isChecked()
            weekends = self.dlg.weekends.isChecked()
            no_distinction = self.dlg.no_distinction.isChecked()
            
            #get the user choice regarding the dataset 
            selectedDatasetIndex = self.dlg.dataset_list.currentIndex()
            
            #get the user choice regarding the area of interest
            selectedArea = self.dlg.area_list.currentText()
            
            #get the user choice regarding the provinces
            selectedProvinces = self.dlg.province_list.currentText()
            
            #get the user choice for the sensor types
            selectedSensors = self.dlg.sensor_type_list.selectedItems()
            
            #get the choice of the user regarding the visualization
            vis = self.dlg.visualization.isChecked()
            
            #get the choice of the user regarding the raw data
            rawData = self.dlg.raw_data.isChecked()
            
            if selectedDatasetIndex != 0:
                
                if len(selectedSensors)>0:
                    
                    # Updates the progress bar
                    bar.setValue(10)
                    QApplication.processEvents()
                    
                    without_data = self.dlg.without_data.isChecked() 
                    
                    #variable to check if the needed parameters have been well inserted
                    inserted=True
                    
                    #Define the dataset id according to the user choice
                    if selectedDatasetIndex == 1: 
                        datasetId="nf78-nj6b"
                    elif selectedDatasetIndex==2:
                        datasetId="ib47-atvt"
                    
                    #create the list of selected sensors
                    selectedSensors_list =[]
                    
                    #dictionnary that will contain, for each sensor, a list with the monitoring values (useful to make stat per sensor)
                    for i in selectedSensors:
                        selectedSensors_list.append(i.text())
            
                    #request data for stations
                    client= self.connect_ARPI_api()
                    
                    
                    #get the areas entered by the user and set the aoi field as an integer
                    if selectedArea == "Insert area":
                        (geoms, f_ids, layer_aoi, inserted)=self.get_areas_of_interest()
                        area_name=''
                    
                    #or set the aoi field as a string 
                    elif selectedArea == "Lombardia":
                        (geoms, f_ids, layer_aoi, area_name)=self.get_polygon(selectedProvinces)
                    
                    
                    
                    
                    #Layers characteristics
                    
                    common_stats_fields = [('mean_value',QVariant.Double), ('count',QVariant.Double),  
                              ('min_value', QVariant.Double), ('max_value', QVariant.Double),
                              ('median_value', QVariant.Double), ('stdev', QVariant.Double)]
                    
                    all_stats_fields = [("aoi", QVariant.Int)]
                    
                    
                    
                    
                    #For Weather data
                    if selectedDatasetIndex == 1 :
                        name = "W - Stations "+area_name
                        
                        if no_distinction:
                            data_stat_name= "W - S per sensor "+area_name+" - "+start_date_str+ " to "+ end_date_str
                            stat_all_name= "W - S for each aoi "+area_name+" - "+start_date_str+ " to "+ end_date_str
                        
                        else:
                            data_stat_name_wd= "W - WD- S per sensor "+area_name+" - "+start_date_str+ " to "+ end_date_str
                            stat_all_name_wd= "W -WD - S for each aoi "+area_name+" - "+start_date_str+ " to "+ end_date_str
                            data_stat_name_we= "W - WE- S per sensor "+area_name+" - "+start_date_str+ " to "+ end_date_str
                            stat_all_name_we= "W -WE - S for each aoi "+area_name+" - "+start_date_str+ " to "+ end_date_str
                            
                        fields = [("idsensore",QVariant.Int),("tipologia",QVariant.String),
                              ("unit_dimisura", QVariant.String), ("idstazione", QVariant.Int),
                              ("nomestazione",QVariant.String),("quota", QVariant.Double),
                              ("provincia",QVariant.String), ("datastart",QVariant.String),
                              ("storico", QVariant.String),
                              ("cgb_nord",QVariant.Int),("cgb_est",QVariant.Int), 
                              ("lng", QVariant.Double),("lat", QVariant.Double), ("aoi", QVariant.Int)]
                        data_stats_fields = [("aoi", QVariant.Int),("tipologia",QVariant.String),("unit_dimisura", QVariant.String)]
                        data_stats_fields.extend(common_stats_fields)
                        data_stats_fields.extend([("idsensore",QVariant.Int),
                              ("idstazione", QVariant.Int),("nomestazione",QVariant.String),
                              ("provincia",QVariant.String),("lng", QVariant.Double),("lat", QVariant.Double)])
                        for sensor in selectedSensors_list:
                            all_stats_fields.append((sensor+" unit_dimisura", QVariant.String))
                            all_stats_fields.append((sensor+' mean_value',QVariant.Double))
                            all_stats_fields.append((sensor+' count',QVariant.Double))
                            all_stats_fields.append((sensor+' min_value', QVariant.Double))
                            all_stats_fields.append((sensor+' max_value', QVariant.Double))
                            all_stats_fields.append((sensor+' median_value', QVariant.Double))
                            all_stats_fields.append((sensor+' stdev', QVariant.Double))
                            all_stats_fields.append((sensor+' ANOVA test', QVariant.String))
                            all_stats_fields.append((sensor+' ANOVA value', QVariant.Double))
                        name_type="tipologia"
                        unit_measure="unit_dimisura"
                        raw_data_name="W - Raw data"+area_name+" - "+start_date_str+ " to "+ end_date_str

                        
                    #For Air Quality data
                    elif selectedDatasetIndex == 2 :
                        name = "AQ - Stations "+area_name
                        
                        if no_distinction:
                            data_stat_name= "AQ - S per sensor "+area_name+" - "+start_date_str+ " to "+ end_date_str
                            stat_all_name="AQ - S for each aoi "+area_name+" - "+start_date_str+ " to "+ end_date_str
                        
                        else:
                            data_stat_name_wd= "AQ - WD- S per sensor "+area_name+" - "+start_date_str+ " to "+ end_date_str
                            stat_all_name_wd= "AQ -WD - S for each aoi "+area_name+" - "+start_date_str+ " to "+ end_date_str
                            data_stat_name_we= "AQ - WE- S per sensor "+area_name+" - "+start_date_str+ " to "+ end_date_str
                            stat_all_name_we= "AQ -WE - S for each aoi "+area_name+" - "+start_date_str+ " to "+ end_date_str
                        
                        
                        fields = [("idsensore",QVariant.Int),("nometiposensore",QVariant.String),
                              ("unitamisura", QVariant.String), ("idstazione", QVariant.Int),
                              ("nomestazione",QVariant.String),("quota", QVariant.Double),
                              ("provincia",QVariant.String), ("comune",QVariant.String), 
                              ("datastart",QVariant.String),
                              ("storico", QVariant.String),("utm_nord",QVariant.Int),
                              ("utm_est",QVariant.Int), ("lng", QVariant.Double),
                              ("lat", QVariant.Double), ("aoi", QVariant.Int)]
                        data_stats_fields = [("aoi", QVariant.Int),("nometiposensore",QVariant.String),
                                             ("unitamisura", QVariant.String)]
                        data_stats_fields.extend(common_stats_fields)
                        data_stats_fields.extend([('idsensore',QVariant.Int),
                              ("idstazione", QVariant.Int),("nomestazione",QVariant.String),
                              ("provincia",QVariant.String), ("comune",QVariant.String),
                              ("lng", QVariant.Double), ("lat", QVariant.Double)])
                        
                        for sensor in selectedSensors_list:
                            all_stats_fields.append((sensor+" unitamisura", QVariant.String))
                            all_stats_fields.append((sensor+' mean_value',QVariant.Double))
                            all_stats_fields.append((sensor+' count',QVariant.Double))
                            all_stats_fields.append((sensor+' min_value', QVariant.Double))
                            all_stats_fields.append((sensor+' max_value', QVariant.Double))
                            all_stats_fields.append((sensor+' median_value', QVariant.Double))
                            all_stats_fields.append((sensor+' stdev', QVariant.Double))
                            all_stats_fields.append((sensor+' ANOVA test', QVariant.String))
                            all_stats_fields.append((sensor+' ANOVA value', QVariant.Double))
                            
                        name_type="nometiposensore"
                        unit_measure="unitamisura"
                        raw_data_name="AQ - Raw data"+area_name+" - "+start_date_str+ " to "+ end_date_str
                        
                    
                    if rawData:
                        raw_fields = [("aoi", QVariant.Int),(name_type,QVariant.String),
                          (unit_measure, QVariant.String), ("valore",QVariant.Double),
                          ("data",QVariant.String), ("idsensore",QVariant.Int),
                          ("nomestazione",QVariant.String),("provincia",QVariant.String), 
                          ("lng", QVariant.Double),("lat", QVariant.Double)]
                    
                    
                    #Creation of the layers 
                        
                    #create the vector layer for stations
                    vl = QgsVectorLayer("Point?crs=EPSG:4326", name, "memory")
                    vl.startEditing()
                    pr = vl.dataProvider()
                    
                    #Add the fields
                    qgs_f=QgsFields()
                    for field in fields:
                        qgs_f.append(QgsField(field[0],field[1]))
                    pr.addAttributes(qgs_f)
                    vl.updateFields()
                    vl.commitChanges()
                    
                    if not without_data and inserted:
                        
                        if no_distinction: 
                            # create the layer containing the statatistics of monitoring data for each sensor
                            vl_stat_data = QgsVectorLayer("Point?crs=EPSG:4326", data_stat_name, 'memory')
                            vl_stat_data.startEditing()
                            pr_stat_data = vl_stat_data.dataProvider()
                            
                            #Add the fields
                            qgs_f_data=QgsFields()
                            for field in data_stats_fields:
                                qgs_f_data.append(QgsField(field[0],field[1]))
                            pr_stat_data.addAttributes(qgs_f_data)
                            vl_stat_data.updateFields()
                            vl_stat_data.commitChanges()
                            
                                                
                            #create the layer containing the statistics of monitoring data for the all area of interest
                            vl_stat_all = QgsVectorLayer("Point?crs=EPSG:4326", stat_all_name, 'memory')
                            vl_stat_all.startEditing()
                            pr_stat_all = vl_stat_all.dataProvider()
                        
                            #Add the fields
                            qgs_f_stats_all=QgsFields()
                            for field in all_stats_fields:
                                qgs_f_stats_all.append(QgsField(field[0],field[1]))
                            pr_stat_all.addAttributes(qgs_f_stats_all)
                            vl_stat_all.updateFields()
                            vl_stat_all.commitChanges()
                            
                            #Create the layer for raw_data if the user wants them 
                            if rawData:
                                #create a layer for raw data
                                vl_raw_data = QgsVectorLayer("Point?crs=EPSG:4326", raw_data_name, 'memory')
                                vl_raw_data.startEditing()
                                pr_raw_data = vl_raw_data.dataProvider()
                                
                                #Add the fields
                                qgs_f_raw_data=QgsFields()
                                for field in raw_fields:
                                    qgs_f_raw_data.append(QgsField(field[0],field[1]))
                                pr_raw_data.addAttributes(qgs_f_raw_data)
                                vl_raw_data.updateFields()
                                vl_raw_data.commitChanges()
                        else:
                            #for week_days
                            if weekdays:
                                #create a layer for week days
                                vl_stat_data_weekdays = QgsVectorLayer("Point?crs=EPSG:4326", data_stat_name_wd, 'memory')
                                vl_stat_data_weekdays.startEditing()
                                pr_stat_data_weekdays = vl_stat_data_weekdays.dataProvider()
                                
                                #Add the fields
                                qgs_f_data_weekdays=QgsFields()
                                for field in data_stats_fields:
                                    qgs_f_data_weekdays.append(QgsField(field[0],field[1]))
                                pr_stat_data_weekdays.addAttributes(qgs_f_data_weekdays)
                                vl_stat_data_weekdays.updateFields()
                                vl_stat_data_weekdays.commitChanges()
                                
                                                    
                                #create the layer containing the statistics of monitoring data for the all area of interest for week days
                                vl_stat_all_weekdays = QgsVectorLayer("Point?crs=EPSG:4326", stat_all_name_wd, 'memory')
                                vl_stat_all_weekdays.startEditing()
                                pr_stat_all_weekdays = vl_stat_all_weekdays.dataProvider()
                            
                                #Add the fields
                                qgs_f_stats_all_weekdays=QgsFields()
                                for field in all_stats_fields:
                                    qgs_f_stats_all_weekdays.append(QgsField(field[0],field[1]))
                                pr_stat_all_weekdays.addAttributes(qgs_f_stats_all_weekdays)
                                vl_stat_all_weekdays.updateFields()
                                vl_stat_all_weekdays.commitChanges()
                                
                                if rawData:
                                    #create a layer for raw data in weekdays
                                    vl_raw_data_weekdays = QgsVectorLayer("Point?crs=EPSG:4326", "Raw data WD", 'memory')
                                    vl_raw_data_weekdays.startEditing()
                                    pr_raw_data_weekdays = vl_raw_data_weekdays.dataProvider()
                                    
                                    #Add the fields
                                    qgs_f_raw_data_wd=QgsFields()
                                    for field in raw_fields:
                                        qgs_f_raw_data_wd.append(QgsField(field[0],field[1]))
                                    pr_raw_data_weekdays.addAttributes(qgs_f_raw_data_wd)
                                    vl_raw_data_weekdays.updateFields()
                                    vl_raw_data_weekdays.commitChanges()
                            
                            #for weekends
                            if weekends:
                                #create a layer for weekends
                                vl_stat_data_weekends = QgsVectorLayer("Point?crs=EPSG:4326", data_stat_name_we, 'memory')
                                vl_stat_data_weekends.startEditing()
                                pr_stat_data_weekends = vl_stat_data_weekends.dataProvider()
                                
                                #Add the fields
                                qgs_f_data_weekends=QgsFields()
                                for field in data_stats_fields:
                                    qgs_f_data_weekends.append(QgsField(field[0],field[1]))
                                pr_stat_data_weekends.addAttributes(qgs_f_data_weekends)
                                vl_stat_data_weekends.updateFields()
                                vl_stat_data_weekends.commitChanges()
                                
                                                    
                                #create the layer containing the statistics of monitoring data for the all area of interest for week days
                                vl_stat_all_weekends = QgsVectorLayer("Point?crs=EPSG:4326", stat_all_name_we, 'memory')
                                vl_stat_all_weekends.startEditing()
                                pr_stat_all_weekends = vl_stat_all_weekends.dataProvider()
                            
                                #Add the fields
                                qgs_f_stats_all_weekends=QgsFields()
                                for field in all_stats_fields:
                                    qgs_f_stats_all_weekends.append(QgsField(field[0],field[1]))
                                pr_stat_all_weekends.addAttributes(qgs_f_stats_all_weekends)
                                vl_stat_all_weekends.updateFields()
                                vl_stat_all_weekends.commitChanges()
                        
                                if rawData:
                                    #create a layer for raw data in weekdays
                                    vl_raw_data_weekends = QgsVectorLayer("Point?crs=EPSG:4326", "Raw data WE", 'memory')
                                    vl_raw_data_weekends.startEditing()
                                    pr_raw_data_weekends = vl_raw_data_weekends.dataProvider()
                                    
                                    #Add the fields
                                    qgs_f_raw_data_we=QgsFields()
                                    for field in raw_fields:
                                        qgs_f_raw_data_we.append(QgsField(field[0],field[1]))
                                    pr_raw_data_weekends.addAttributes(qgs_f_raw_data_we)
                                    vl_raw_data_weekends.updateFields()
                                    vl_raw_data_weekends.commitChanges()
                        
                    
                    # Updates the progress bar
                    bar.setValue(15)
                    QApplication.processEvents()
                    
                    #index providing the number of the area if multiple polygons are entered
                    index=0
                    
                    #dictionnary that will contain, for each area, the sensor_dic (see after for def of sensor_dic)
                    area_dic={}
                    
                    #Variable to check if in the end there is no weekend day or week days data in the range of time selected
                    no_weekdays=True
                    no_weekends=True
                                        
                    #We loop on the geoms to have one request per area of interest
                    for geom_area in geoms:
                    
                        index+=1
                        
                        stations = self.request_ARPA_stations(client, selectedDatasetIndex, datasetId, selectedSensors_list, selectedArea, geom_area, selectedProvinces)
                        
                        
                        if stations != {}:
                            
                            #dictionnary that will contain, for each sensor, a list with the monitoring values (useful to make stat per sensor) 
                            #the unit of measure for each sensor, and the values used for ANOVA test
                            sensor_dic = {}
                            
                            for i in selectedSensors:
                                if no_distinction:
                                    sensor_dic[i.text()]= {
                                        "Values":[],
                                        "Unit of measure": "",
                                        "ANOVA": {}
                                        }
                                else:
                                    sensor_dic[i.text()]= {
                                        "Week_days":{
                                            "Values":[],
                                            "Unit of measure":"",
                                            "ANOVA": {}
                                            }, 
                                        "Week_ends":{
                                            "Values":[], 
                                            "Unit of measure":"",
                                            "ANOVA": {}
                                            }
                                        }
                            
                            #Conversion to GEOJSON
                            stations_dic = {
                                "type": "FeatureCollection",
                                "features": [
                                {
                                    "type": "Feature",
                                    "geometry" : {
                                        "type": "Point",
                                        "coordinates": [d["lng"], d["lat"]],
                                        },
                                    "properties" : d,
                                  } for d in stations]
                                }
                            
                            #for the progress bar
                            index_feat=0
                            
                            #Add all the features for the stations
                            for feature in stations_dic['features']:
                                
                                index_feat+=1
                                
                                f = QgsFeature()
                                
                                x=float(feature['geometry']['coordinates'][0])
                                y=float(feature['geometry']['coordinates'][1])
                                geom = QgsGeometry.fromPointXY(QgsPointXY(QgsPoint(x,y)))
                                f.setGeometry(geom)
                                f.setFields(qgs_f)
                                
                                attributes=list(feature['properties'].items())
                                for att in attributes:
                                    if att[0]!= "location" and att[0]!=':@computed_region_6hky_swhk' and att[0]!=':@computed_region_ttgh_9sm5' and att[0]!='datastop':
                                        f[att[0]] = att[1]
                               
                                f["aoi"]=f_ids[index-1]
                                
                                pr.addFeature(f)
                                vl.updateExtents()
                                
                                
                                #get the unit of measure for the layer that doesn't contain it (general layer for each aoi)
                                type_s=feature['properties'][name_type]
                                if no_distinction:
                                    sensor_dic[type_s]['Unit of measure']=feature['properties'][unit_measure]
                                        
                                else:
                                    sensor_dic[type_s]['Week_days']['Unit of measure']=feature['properties'][unit_measure]
                                    sensor_dic[type_s]['Week_ends']['Unit of measure']=feature['properties'][unit_measure]
                                
                                
                                
                                #For each sensor, we request the data and compute the statistics 
                                if not without_data and inserted:
                                    id_sensor = feature['properties']['idsensore']
                                    data_sensor = self.req_ARPA_data_sensor(client, id_sensor, selectedDatasetIndex, selected_date_start_str, selected_date_end_str)
                                    
                                    if len(data_sensor)>0 :
                                        
                                        #if there is no distinction between weekdays and weekends
                                        if no_distinction:
                                            
                                            #Create one new feature per sensor
                                            d = QgsFeature()
                                            d.setFields(qgs_f_data)
                                            
                                            #Add the attributes of the sensor as previously
                                            for att in attributes:
                                                try:
                                                    d[att[0]] = att[1]
                                                except:
                                                    pass
                                            
                                            # Compute the statistics per sensor with all the data acquired
                                            list_val=[]
                                                    
                                            for data in data_sensor:
                                                if float(data['valore']) != -9999:
                                                    list_val.append(float(data['valore']))
                                                    #Add the value to the sensor_dic to compute the stat at the end
                                                    sensor_dic[feature['properties'][name_type]]["Values"].append(float(data['valore']))
                                                    
                                                    #Add the value to the raw data layer if the user wants them
                                                    if rawData:
                                                        #Create one new feature per measure for the raw data
                                                        rd = QgsFeature()
                                                        rd.setFields(qgs_f_raw_data)
                                                    
                                                        # Add the attributes of the sensor as previously
                                                        for att in attributes:
                                                            try:
                                                                rd[att[0]] = att[1]
                                                            except:
                                                                pass
                                                        
                                                        # Add the measurement
                                                        rd["valore"]=float(data['valore'])
                                                        rd["data"]=data['data']
                                                        #Add the aoi
                                                        rd["aoi"]=f_ids[index-1]
                                                        #Add the geometry to the data 
                                                        x=float(feature['geometry']['coordinates'][0])
                                                        y=float(feature['geometry']['coordinates'][1])
                                                        geom_data = QgsGeometry.fromPointXY(QgsPointXY(QgsPoint(x,y)))
                                                        rd.setGeometry(geom_data)
                                                        
                                                        pr_raw_data.addFeature(rd)
                                                        vl_raw_data.updateExtents()
                                                        
                                           
                                            if len(list_val)>0:
                                                d['max_value'] = max(list_val)
                                                d['min_value'] = min(list_val)
                                                d['mean_value'] = statistics.mean(list_val)
                                                d['count'] = len(list_val)
                                                d['median_value'] = statistics.median(list_val)
                                                
                                                if len(list_val)>1:
                                                    d['stdev']= statistics.stdev(list_val)
                                                
                                                d["aoi"]=f_ids[index-1]
                                                
                                                #Add the geometry to the data 
                                                x=float(feature['geometry']['coordinates'][0])
                                                y=float(feature['geometry']['coordinates'][1])
                                                geom_data = QgsGeometry.fromPointXY(QgsPointXY(QgsPoint(x,y)))
                                                d.setGeometry(geom_data)
                                                
                                                pr_stat_data.addFeature(d)
                                                vl_stat_data.updateExtents()
                                            
                                            else:
                                                print("LIST VAL IS EMPTY")
                                                pass
                                            
                                        
                                        #If there is a distinction between weekdays and weekends
                                        else:
                                            
                                            list_val_weekdays=[]
                                            list_val_weekends=[]
                                            
                                            for data in data_sensor:
                                                if float(data['valore']) != -9999:
                                                    data_date=datetime.datetime.strptime(data['data'][0:10], "%Y-%m-%d")
                                                    day=data_date.weekday()
                                                    if weekdays and day >=0 and day <=4:
                                                        list_val_weekdays.append(float(data['valore']))
                                                        #Add the value to the sensor_dic to compute the stat at the end
                                                        sensor_dic[feature['properties'][name_type]]['Week_days']["Values"].append(float(data['valore']))
                                                    
                                                    #Add the value to the raw data layer if the user wants them
                                                    if rawData:
                                                        #Create one new feature per measure for the raw data
                                                        rd_wd = QgsFeature()
                                                        rd_wd.setFields(qgs_f_raw_data_wd)
                                                    
                                                        # Add the attributes of the sensor as previously
                                                        for att in attributes:
                                                            try:
                                                                rd_wd[att[0]] = att[1]
                                                            except:
                                                                pass
                                                        
                                                        # Add the measurement
                                                        rd_wd["valore"]=float(data['valore'])
                                                        rd_wd["data"]=data['data']
                                                        #Add the aoi
                                                        rd_wd["aoi"]=f_ids[index-1]
                                                        #Add the geometry to the data 
                                                        x=float(feature['geometry']['coordinates'][0])
                                                        y=float(feature['geometry']['coordinates'][1])
                                                        geom_data = QgsGeometry.fromPointXY(QgsPointXY(QgsPoint(x,y)))
                                                        rd_wd.setGeometry(geom_data)
                                                        
                                                        pr_raw_data_weekdays.addFeature(rd_wd)
                                                        vl_raw_data_weekdays.updateExtents()
                                                    
                                                    if weekends and day >=5 and day <=6:
                                                        list_val_weekends.append(float(data['valore']))
                                                        #Add the value to the sensor_dic to compute the stat at the end
                                                        sensor_dic[feature['properties'][name_type]]['Week_ends']["Values"].append(float(data['valore']))
                                                        
                                                        #Add the value to the raw data layer if the user wants them
                                                        if rawData:
                                                            #Create one new feature per measure for the raw data
                                                            rd_we = QgsFeature()
                                                            rd_we.setFields(qgs_f_raw_data_we)
                                                        
                                                            # Add the attributes of the sensor as previously
                                                            for att in attributes:
                                                                try:
                                                                    rd_we[att[0]] = att[1]
                                                                except:
                                                                    pass
                                                            
                                                            # Add the measurement
                                                            rd_we["valore"]=float(data['valore'])
                                                            rd_we["data"]=data['data']
                                                            #Add the aoi
                                                            rd_we["aoi"]=f_ids[index-1]
                                                            #Add the geometry to the data 
                                                            x=float(feature['geometry']['coordinates'][0])
                                                            y=float(feature['geometry']['coordinates'][1])
                                                            geom_data = QgsGeometry.fromPointXY(QgsPointXY(QgsPoint(x,y)))
                                                            rd_we.setGeometry(geom_data)
                                                            
                                                            pr_raw_data_weekends.addFeature(rd_we)
                                                            vl_raw_data_weekends.updateExtents()
                                                        
                                            if weekdays:
                                                
                                                if len(list_val_weekdays)>0:
                                                    no_weekdays=False
                                                    #Create one new feature per sensor
                                                    d_weekdays = QgsFeature()
                                                    d_weekdays.setFields(qgs_f_data_weekdays)
                                                    
                                                    #Add the attributes of the sensor as previously
                                                    for att in attributes:
                                                        try:
                                                            d_weekdays[att[0]] = att[1]
                                                        except:
                                                            # print('no_attribute '+att[0])
                                                            pass
                                                
                                                    d_weekdays['max_value'] = max(list_val_weekdays)
                                                    d_weekdays['min_value'] = min(list_val_weekdays)
                                                    d_weekdays['mean_value'] = statistics.mean(list_val_weekdays)
                                                    d_weekdays['count'] = len(list_val_weekdays)
                                                    d_weekdays['median_value'] = statistics.median(list_val_weekdays)
                                                    
                                                    if len(list_val_weekdays)>1:
                                                        d_weekdays['stdev']= statistics.stdev(list_val_weekdays)
                                                    
                                                    d_weekdays["aoi"]=f_ids[index-1]
                                                    
                                                    #Add the geometry to the data 
                                                    x=float(feature['geometry']['coordinates'][0])
                                                    y=float(feature['geometry']['coordinates'][1])
                                                    geom_data = QgsGeometry.fromPointXY(QgsPointXY(QgsPoint(x,y)))
                                                    d_weekdays.setGeometry(geom_data)
                                                    
                                                    pr_stat_data_weekdays.addFeature(d_weekdays)
                                                    vl_stat_data_weekdays.updateExtents()
                                                
                                                else:
                                                    pass
                                                                                
                                            if weekends:
                                                
                                                if len(list_val_weekends)>0:
                                                    no_weekends=False
                                                    #Create one new feature per sensor
                                                    d_weekends = QgsFeature()
                                                    d_weekends.setFields(qgs_f_data_weekends)
                                                    
                                                    #Add the attributes of the sensor as previously
                                                    for att in attributes:
                                                        try:
                                                            d_weekends[att[0]] = att[1]
                                                        except:
                                                            # print('no_attribute '+att[0])
                                                            pass
                                                    
                                                    d_weekends['max_value'] = max(list_val_weekends)
                                                    d_weekends['min_value'] = min(list_val_weekends)
                                                    d_weekends['mean_value'] = statistics.mean(list_val_weekends)
                                                    d_weekends['count'] = len(list_val_weekends)
                                                    d_weekends['median_value'] = statistics.median(list_val_weekends)
                                                    
                                                    if len(list_val_weekends)>1:
                                                        d_weekends['stdev']= statistics.stdev(list_val_weekends)
                                                    
                                                    d_weekends["aoi"]=f_ids[index-1]
                                                    
                                                    #Add the geometry to the data 
                                                    x=float(feature['geometry']['coordinates'][0])
                                                    y=float(feature['geometry']['coordinates'][1])
                                                    geom_data = QgsGeometry.fromPointXY(QgsPointXY(QgsPoint(x,y)))
                                                    d_weekends.setGeometry(geom_data)
                                                    
                                                    pr_stat_data_weekends.addFeature(d_weekends)
                                                    vl_stat_data_weekends.updateExtents()
                                                
                                                else:
                                                    pass
                                
                                # Updates the progress bar
                                bar.setValue(15+((55/len(geoms))*(index-1))+(55/len(geoms))/len(stations_dic['features'])*index_feat)
                                QApplication.processEvents()
                            
                            area_dic['Area '+str(index)]={'Sensor dic':sensor_dic}
                                        
                        else:
                            print("Nothing inside the stations dic")
                            area_dic['Area '+str(index)]={'Sensor dic':{}}
                    
                        # Updates the progress bar
                        bar.setValue(15+(55/len(geoms))*index)
                        QApplication.processEvents()
                    
                    q=QgsProject.instance()
                    
                    # Updates the progress bar
                    bar.setValue(70)
                    QApplication.processEvents()
                    
                                       
                    #Add the layer of aoi
                    if inserted:
                        q.addMapLayer(layer_aoi)
                        #Add the layer containing only stations location
                        q.addMapLayer(vl)
                    else:
                        #Add the layer containing only stations location
                        q.addMapLayer(vl)
                    
                    

                    if not without_data and inserted:
                        
                        #To check if one sensor has no data in none of the areas of interest for the selected filters
                        empty_sensors = {}
                        for s in selectedSensors:
                            if no_distinction:
                                empty_sensors[s.text()]=True
                            else:
                                empty_sensors[s.text()]={"Week_days":True, "Week_ends":True}
                        
                        
                        if no_distinction:
                            
                            #Add the raw data if the user chose to have it 
                            if rawData:
                                q.addMapLayer(vl_raw_data)
                            
                            #Add the layer with the statistics for each sensor 
                            
                            #Build the diagram for the layer if there is only one sensor and the user chose to have it
                            if len(selectedSensors_list)==1 and vis:
                                
                                sensor=selectedSensors_list[0]

                                attributes_stats=[pr_stat_data.fieldNameIndex('max_value'), 
                                                  pr_stat_data.fieldNameIndex('mean_value'), 
                                                  pr_stat_data.fieldNameIndex('median_value'), 
                                                  pr_stat_data.fieldNameIndex('min_value'), 
                                                  pr_stat_data.fieldNameIndex('stdev')]
                                
                                attributes_names=['"max_value"',
                                                  '"mean_value"', 
                                                  '"median_value"', 
                                                  '"min_value"', 
                                                  '"stdev"']
                                
                                #get the max_value of the layer
                                max_att_name = 'max_value'
                                idx = pr_stat_data.fieldNameIndex(max_att_name)
                                max_value=vl_stat_data.maximumValue(idx)
                                
                                if max_value is not None:
                                    self.histogram(vl_stat_data, attributes_stats, attributes_names, max_value, max_att_name,"large scale")
                                    
                            
                            q.addMapLayer(vl_stat_data)
                            
                            
                            
                        
                            # Updates the progress bar
                            bar.setValue(80)
                            QApplication.processEvents()
                            
                            #number of the area
                            index=0
                            
                            #for each area create the only point of the area
                            for geom_area in geoms:
                                
                                index+=1
                                p = QgsFeature()
                                p.setFields(qgs_f_stats_all)
                                
                                
                                for sensor in selectedSensors_list:
                                    
                                    #Compute the general statistics for the whole area
                                    list_values=area_dic['Area '+str(index)]['Sensor dic'][sensor]["Values"]
                                    p["aoi"]=f_ids[index-1]
                                    
                                    if len(list_values)>0:
                                        empty_sensors[sensor]=False
                                        p[sensor+' max_value'] = max(list_values)
                                        p[sensor+' min_value'] = min(list_values)
                                        mean = statistics.mean(list_values)
                                        p[sensor+' mean_value'] = mean
                                        
                                        p[sensor+' count'] = len(list_values)
                                        p[sensor+' median_value'] = statistics.median(list_values)
                                        if len(list_values)>1:
                                                p[sensor+' stdev']= statistics.stdev(list_values)
                                        p[sensor+' '+unit_measure] = area_dic['Area '+str(index)]['Sensor dic'][sensor]['Unit of measure']
                                        
                                        area_dic['Area '+str(index)]['Sensor dic'][sensor]['ANOVA']= { 
                                            'List values': list_values,
                                            'Mean value': mean
                                            }
                                        
                                    else:
                                        self.iface.messageBar().pushMessage("No data for the sensors "+sensor+" in area "+ str(index), Qgis.Warning)
                                        area_dic['Area '+str(index)]['Sensor dic'][sensor]['ANOVA']= { 
                                            'List values': []
                                            }
                                
                                
                                        
                                #Add the geometry to the data 
                                
                                #Coordinates of the centroid
                                point=geom_area.centroid().asPoint()
                                x_p=point.x()
                                y_p=point.y()
                                    
                                geom_data = QgsGeometry.fromPointXY(QgsPointXY(QgsPoint(x_p,y_p)))
                                p.setGeometry(geom_data)
                                
                                #Add the point to the layer
                                pr_stat_all.addFeature(p)
                                vl_stat_all.updateExtents()
                                
                                # Updates the progress bar
                                bar.setValue(80+(10/len(geoms))*index)
                                QApplication.processEvents()
                   
                            vl_stat_all.startEditing()
                            for s in selectedSensors_list:
                                if empty_sensors[s]:
                                    list_fields=pr_stat_all.fields()
                                    pr_stat_all.deleteAttributes([list_fields.indexFromName(s+' max_value'), 
                                                                      list_fields.indexFromName(s+' min_value'),
                                                                      list_fields.indexFromName(s+' count'),
                                                                      list_fields.indexFromName(s+' median_value'),
                                                                      list_fields.indexFromName(s+' stdev'),
                                                                      list_fields.indexFromName(s+' '+unit_measure),
                                                                      list_fields.indexFromName(s+' mean_value'),
                                                                      list_fields.indexFromName(s+' ANOVA test'),
                                                                      list_fields.indexFromName(s+' ANOVA value')])
                                    
                            vl_stat_all.commitChanges()
                            
                            
                            #Compute the ANOVA test if more than one area of interest 
                            if len(geoms) > 1:
                                for sensor in selectedSensors_list:
                                    if not empty_sensors[sensor]:
                                        #number of the area
                                        index=0
                                        #list with the values for each group
                                        groups=[]
                                        means=[]
                                        size_groups=[]
                                        
                                        for geom_area in geoms:
                                            index+=1
                                            values=area_dic['Area '+str(index)]['Sensor dic'][sensor]['ANOVA']['List values']
                                            if len(values)>0:
                                                mean=area_dic['Area '+str(index)]['Sensor dic'][sensor]['ANOVA']['Mean value']
                                                groups.append(values)
                                                means.append(mean)
                                                size_groups.append(len(values))
                                        
                                        if len(groups)>1:
                                            (passes,u)=self.ANOVA_test(groups,means,size_groups)
                                            v_features=vl_stat_all.getFeatures()
                                            list_fields=pr_stat_all.fields()
                                            id_f_test=list_fields.indexFromName(sensor+' ANOVA test')
                                            id_f_value=list_fields.indexFromName(sensor+' ANOVA value')
                                            
                                            if passes:
                                                print("Fisher test passes for sensor "+sensor)
                                                
                                                                                        
                                                vl_stat_all.startEditing()
                                                for v_feat in v_features:
                                                    att_mean=v_feat.attribute(sensor+' mean_value')
                                                    if att_mean != None:
                                                        vl_stat_all.changeAttributeValue(v_feat.id(), id_f_value, u)
                                                        vl_stat_all.changeAttributeValue(v_feat.id(), id_f_test, "Yes")
                                                vl_stat_all.commitChanges()
                                            
                                            else:
                                                if u ==1:
                                                    self.iface.messageBar().pushMessage("Fisher test not applicable for sensor "+sensor, Qgis.Warning)
                                                print("Fisher test doesn't pass for sensor "+sensor)
                                                vl_stat_all.startEditing()
                                                for v_feat in v_features:
                                                    att_mean=v_feat.attribute(sensor+' mean_value')
                                                    if att_mean != None:
                                                        vl_stat_all.changeAttributeValue(v_feat.id(), id_f_test, "No")
                                                        vl_stat_all.changeAttributeValue(v_feat.id(), id_f_value, att_mean)
                                                vl_stat_all.commitChanges()
                                        
                                        else:
                                            self.iface.messageBar().pushMessage("No Fisher test possible for sensor "+sensor+" : to few data", Qgis.Warning)
                                        
                            
                            #Remove the ANOVA test field if there is only one area of interest       
                            else:
                                vl_stat_all.startEditing()
                                for s in selectedSensors_list:
                                    if not empty_sensors[s]:
                                        list_fields=pr_stat_all.fields()
                                        pr_stat_all.deleteAttributes([list_fields.indexFromName(s+' ANOVA test'),
                                                                      list_fields.indexFromName(s+' ANOVA value')])
                                
                                
                                vl_stat_all.commitChanges()
                                
                            # Updates the progress bar
                            bar.setValue(90)
                            QApplication.processEvents()
                            
                            #Build the diagram for the layer if there is only one sensor and the user chose to have it
                            if len(selectedSensors_list)==1 and vis:
                                
                                sensor=selectedSensors_list[0]

                                attributes_stats=[pr_stat_all.fieldNameIndex(sensor+' max_value'), 
                                                  pr_stat_all.fieldNameIndex(sensor+' mean_value'), 
                                                  pr_stat_all.fieldNameIndex(sensor+' median_value'), 
                                                  pr_stat_all.fieldNameIndex(sensor+' min_value'), 
                                                  pr_stat_all.fieldNameIndex(sensor+' stdev')]
                                
                                attributes_names=['"{} max_value"'.format(sensor),
                                                  '"{} mean_value"'.format(sensor), 
                                                  '"{} median_value"'.format(sensor), 
                                                  '"{} min_value"'.format(sensor), 
                                                  '"{} stdev"'.format(sensor)]
                                
                                #get the max_value of the layer
                                max_att_name = sensor+' max_value'
                                idx = pr_stat_all.fieldNameIndex(max_att_name)
                                max_value=vl_stat_all.maximumValue(idx)
                                
                                if max_value is not None:
                                    self.histogram(vl_stat_all, attributes_stats, attributes_names, max_value, max_att_name, 'small scale')
                            
                            #Add the layer with the general statistics for the whole areas
                            q.addMapLayer(vl_stat_all)
                        
                            bar.setValue(100)
                            QApplication.processEvents()
                            
                                
                        else:
                            
                            if weekdays:
                                
                                #Check if there is weekdays data
                                if not no_weekdays:
                                    
                                    #Add the raw data if the user chose to have it 
                                    if rawData:
                                        q.addMapLayer(vl_raw_data_weekdays)
                                        
                                    #Add the layer with the statistics for each sensor in week days
                                    
                                    #Build the diagram for the layer if there is only one sensor and the user chose to have it
                                    if len(selectedSensors_list)==1 and vis:
                                        
                                        sensor=selectedSensors_list[0]
        
                                        attributes_stats=[pr_stat_data_weekdays.fieldNameIndex('max_value'), 
                                                          pr_stat_data_weekdays.fieldNameIndex('mean_value'), 
                                                          pr_stat_data_weekdays.fieldNameIndex('median_value'), 
                                                          pr_stat_data_weekdays.fieldNameIndex('min_value'), 
                                                          pr_stat_data_weekdays.fieldNameIndex('stdev')]
                                        
                                        attributes_names=['"max_value"',
                                                          '"mean_value"', 
                                                          '"median_value"', 
                                                          '"min_value"', 
                                                          '"stdev"']
                                        
                                        #get the max_value of the layer
                                        max_att_name = 'max_value'
                                        idx = pr_stat_data_weekdays.fieldNameIndex(max_att_name)
                                        max_value=vl_stat_data_weekdays.maximumValue(idx)
                                        
                                        if max_value is not None:
                                            self.histogram(vl_stat_data_weekdays, attributes_stats, attributes_names, max_value, max_att_name,"large scale")

                                    
                                    
                                    
                                    q.addMapLayer(vl_stat_data_weekdays)
                                    
                                    
                                    
                                    bar.setValue(80)
                                    QApplication.processEvents()
                                    
                                    index=0
                            
                                    #for each area create the only point of the area
                                    for geom_area in geoms:
                                        
                                        index+=1
                                    
                                        p_weekdays = QgsFeature()
                                        p_weekdays.setFields(qgs_f_stats_all_weekdays)
                                        
                                        for sensor in selectedSensors_list:
                                            
                                            #Compute the general statistics for the whole area
                                            list_values=area_dic['Area '+str(index)]['Sensor dic'][sensor]['Week_days']["Values"]
                                            p_weekdays["aoi"]=f_ids[index-1]
                                            
                                            if len(list_values)>0:
                                                empty_sensors[sensor]['Week_days']=False
                                                p_weekdays[sensor+' max_value'] = max(list_values)
                                                p_weekdays[sensor+' min_value'] = min(list_values)
                                                mean = statistics.mean(list_values)
                                                p_weekdays[sensor+' mean_value'] = mean
                                                p_weekdays[sensor+' count'] = len(list_values)
                                                p_weekdays[sensor+' median_value'] = statistics.median(list_values)
                                                if len(list_values)>1:
                                                        p_weekdays[sensor+' stdev']= statistics.stdev(list_values)
                                                p_weekdays[sensor+' '+unit_measure] = area_dic['Area '+str(index)]['Sensor dic'][sensor]['Week_days']['Unit of measure']
                                        
                                                
                                                area_dic['Area '+str(index)]['Sensor dic'][sensor]['Week_days']['ANOVA'] = { 
                                                    'List values': list_values,
                                                    'Mean value': mean
                                                }
                                            
                                            else:
                                                self.iface.messageBar().pushMessage("No data on the selected weekdays for the sensors "+sensor+" in area "+ str(index), Qgis.Warning)
                                                area_dic['Area '+str(index)]['Sensor dic'][sensor]['Week_days']['ANOVA']= { 
                                                    'List values': []
                                                    }


                                        
                                        #Add the geometry to the data 
                                
                                        #Coordinates of the centroid
                                        point=geom_area.centroid().asPoint()
                                        x_p=point.x()
                                        y_p=point.y()
                                        
                                        geom_data = QgsGeometry.fromPointXY(QgsPointXY(QgsPoint(x_p,y_p)))
                                        p_weekdays.setGeometry(geom_data)
                                        
                                        
                                        #Add the point to the layer
                                        pr_stat_all_weekdays.addFeature(p_weekdays)
                                        vl_stat_all_weekdays.updateExtents()
                                        
                                        # Updates the progress bar
                                        bar.setValue(80+(7/len(geoms))*index)
                                        QApplication.processEvents()
                                    
                                   
                                    vl_stat_all_weekdays.startEditing()
                                    for s in selectedSensors_list:
                                        if empty_sensors[s]['Week_days']:
                                            list_fields=pr_stat_all_weekdays.fields()
                                            pr_stat_all_weekdays.deleteAttributes([list_fields.indexFromName(s+' max_value'), 
                                                                              list_fields.indexFromName(s+' min_value'),
                                                                              list_fields.indexFromName(s+' count'),
                                                                              list_fields.indexFromName(s+' median_value'),
                                                                              list_fields.indexFromName(s+' stdev'),
                                                                              list_fields.indexFromName(s+' '+unit_measure),
                                                                              list_fields.indexFromName(s+' mean_value'),
                                                                              list_fields.indexFromName(s+' ANOVA test'),
                                                                              list_fields.indexFromName(s+' ANOVA value')]
                                                                                  )
                                    vl_stat_all_weekdays.commitChanges()
                                    
                                    #Compute the ANOVA test if more than one area of interest 
                                    if len(geoms) > 1:
                                        for sensor in selectedSensors_list:
                                            if not empty_sensors[sensor]['Week_days']:
                                                #number of the area
                                                index=0
                                                #list with the values for each group
                                                groups=[]
                                                means=[]
                                                size_groups=[]
                                                
                                                
                                                for geom_area in geoms:
                                                    index+=1
                                                    values=area_dic['Area '+str(index)]['Sensor dic'][sensor]['Week_days']['ANOVA']['List values']
                                                    if len(values)>0:
                                                        mean=area_dic['Area '+str(index)]['Sensor dic'][sensor]['Week_days']['ANOVA']['Mean value']
                                                        groups.append(values)
                                                        means.append(mean)
                                                        size_groups.append(len(values))
                                                
                                                if len(groups)>1:
                                                    (passes,u)=self.ANOVA_test(groups,means,size_groups)
                                                    v_features=vl_stat_all_weekdays.getFeatures()
                                                    list_fields=pr_stat_all_weekdays.fields()
                                                    id_f_test=list_fields.indexFromName(sensor+' ANOVA test')
                                                    id_f_value=list_fields.indexFromName(sensor+' ANOVA value')
                                                    
                                                    if passes:
                                                        print("Fisher test passes for sensor "+sensor+" in weekdays")
                                                                                                
                                                        vl_stat_all_weekdays.startEditing()
                                                        for v_feat in v_features:
                                                            att_mean=v_feat.attribute(sensor+' mean_value')
                                                            if att_mean != None:
                                                                vl_stat_all_weekdays.changeAttributeValue(v_feat.id(), id_f_value, u)
                                                                vl_stat_all_weekdays.changeAttributeValue(v_feat.id(), id_f_test, "Yes")
                                                        vl_stat_all_weekdays.commitChanges()
                                                    
                                                    else:
                                                        if u ==1:
                                                            self.iface.messageBar().pushMessage("Fisher test not applicable for sensor "+sensor+" in these weekdays", Qgis.Warning)
                                                        print("Fisher test doesn't pass for sensor "+sensor+ " in weekdays")
                                                        vl_stat_all_weekdays.startEditing()
                                                        for v_feat in v_features:
                                                            att_mean=v_feat.attribute(sensor+' mean_value')
                                                            if att_mean != None:
                                                                vl_stat_all_weekdays.changeAttributeValue(v_feat.id(), id_f_test, "No")
                                                                vl_stat_all_weekdays.changeAttributeValue(v_feat.id(), id_f_value, att_mean)
                                                        vl_stat_all_weekdays.commitChanges()
                                                        
                                                else:
                                                    self.iface.messageBar().pushMessage("No ANOVA possible for sensor "+sensor+" : to few data in these weekdays", Qgis.Warning)

                                    #Remove the ANOVA test field if there is only one area of interest       
                                    else:
                                        vl_stat_all_weekdays.startEditing()
                                        for s in selectedSensors_list:
                                            if not empty_sensors[s]['Week_days']:
                                                list_fields=pr_stat_all_weekdays.fields()
                                                pr_stat_all_weekdays.deleteAttributes([list_fields.indexFromName(s+' ANOVA test'),
                                                                                       list_fields.indexFromName(s+' ANOVA value')])    
                                        
                                        vl_stat_all_weekdays.commitChanges()
                                    
                            
                                    #Build the diagram for the layer if there is only one sensor and the user chose to have it
                                    if len(selectedSensors_list)==1 and vis:
                                        
                                        sensor=selectedSensors_list[0]
        
                                        attributes_stats=[pr_stat_all_weekdays.fieldNameIndex(sensor+' max_value'), 
                                                          pr_stat_all_weekdays.fieldNameIndex(sensor+' mean_value'), 
                                                          pr_stat_all_weekdays.fieldNameIndex(sensor+' median_value'), 
                                                          pr_stat_all_weekdays.fieldNameIndex(sensor+' min_value'), 
                                                          pr_stat_all_weekdays.fieldNameIndex(sensor+' stdev')]
                                        
                                        attributes_names=['"{} max_value"'.format(sensor),
                                                          '"{} mean_value"'.format(sensor), 
                                                          '"{} median_value"'.format(sensor), 
                                                          '"{} min_value"'.format(sensor), 
                                                          '"{} stdev"'.format(sensor)]
                                        
                                        #get the max_value of the layer
                                        max_att_name = sensor+' max_value'
                                        idx = pr_stat_all_weekdays.fieldNameIndex(max_att_name)
                                        max_value=vl_stat_all_weekdays.maximumValue(idx)
                                        
                                        if max_value is not None:
                                            self.histogram(vl_stat_all_weekdays, attributes_stats, attributes_names, max_value, max_att_name, 'small scale')
                                    
                                    
                                    
                                    
                                    #Add the layer with the general statistics for the whole area
                                    q.addMapLayer(vl_stat_all_weekdays)
                                    
                                    #Updates the progress bar
                                    bar.setValue(87)
                                    QApplication.processEvents()
                                
                                else :
                                    self.iface.messageBar().pushMessage("No data for these weekdays", Qgis.Warning)
                            
                            
                            if weekends :
                                
                                #Check if they is weekdays data
                                if not no_weekends:
                                    
                                    #Add the raw data if the user chose to have it 
                                    if rawData:
                                        q.addMapLayer(vl_raw_data_weekends)
                                    
                                    #Add the layer with the statistics for each sensor in weekends
                                    
                                    #Build the diagram for the layer if there is only one sensor and the user chose to have it
                                    if len(selectedSensors_list)==1 and vis:
                                        
                                        sensor=selectedSensors_list[0]
        
                                        attributes_stats=[pr_stat_data_weekends.fieldNameIndex('max_value'), 
                                                          pr_stat_data_weekends.fieldNameIndex('mean_value'), 
                                                          pr_stat_data_weekends.fieldNameIndex('median_value'), 
                                                          pr_stat_data_weekends.fieldNameIndex('min_value'), 
                                                          pr_stat_data_weekends.fieldNameIndex('stdev')]
                                        
                                        attributes_names=['"max_value"',
                                                          '"mean_value"', 
                                                          '"median_value"', 
                                                          '"min_value"', 
                                                          '"stdev"']
                                        
                                        #get the max_value of the layer
                                        max_att_name = 'max_value'
                                        idx = pr_stat_data_weekends.fieldNameIndex(max_att_name)
                                        max_value=vl_stat_data_weekends.maximumValue(idx)
                                        
                                        if max_value is not None:
                                            self.histogram(vl_stat_data_weekends, attributes_stats, attributes_names, max_value, max_att_name,"large scale")

                                    # Updates the progress bar
                                    bar.setValue(87)
                                    QApplication.processEvents()
            
                                    q.addMapLayer(vl_stat_data_weekends)
                                    
                                    
                                    
                                    index=0
                                    
                                    #for each area create the only point of the area
                                    for geom_area in geoms:
                                        
                                        index+=1
                                        
                                        p_weekends = QgsFeature()
                                        p_weekends.setFields(qgs_f_stats_all_weekends)
                                        
                                        for sensor in selectedSensors_list:
                                            
                                            #Compute the general statistics for the whole area
                                            list_values=area_dic['Area '+str(index)]['Sensor dic'][sensor]['Week_ends']["Values"]
                                            p_weekends["aoi"]=f_ids[index-1]
                                            
                                            if len(list_values)>0:
                                                empty_sensors[sensor]['Week_ends']=False
                                                p_weekends[sensor+' max_value'] = max(list_values)
                                                p_weekends[sensor+' min_value'] = min(list_values)
                                                mean = statistics.mean(list_values)
                                                p_weekends[sensor+' mean_value'] = mean
                                                p_weekends[sensor+' count'] = len(list_values)
                                                p_weekends[sensor+' median_value'] = statistics.median(list_values)
                                                if len(list_values)>1:
                                                        p_weekends[sensor+' stdev']= statistics.stdev(list_values)
                                                p_weekends[sensor+' '+unit_measure] = area_dic['Area '+str(index)]['Sensor dic'][sensor]['Week_ends']['Unit of measure']
                                            
                                                
                                                area_dic['Area '+str(index)]['Sensor dic'][sensor]['Week_ends']['ANOVA'] = { 
                                                    'List values': list_values,
                                                    'Mean value': mean
                                                }
                                            
                                                
                                                
                                            else:
                                                self.iface.messageBar().pushMessage("No data on the selected weekends for the sensors "+sensor+" in area "+ str(index), Qgis.Warning)
                                                area_dic['Area '+str(index)]['Sensor dic'][sensor]['Week_ends']['ANOVA'] = { 
                                                    'List values': []
                                                }
                                                
                                        #Add the geometry to the data 
                                
                                        #Coordinates of the centroid
                                        point=geom_area.centroid().asPoint()
                                        x_p=point.x()
                                        y_p=point.y()
                                                
                                        geom_data = QgsGeometry.fromPointXY(QgsPointXY(QgsPoint(x_p,y_p)))
                                        p_weekends.setGeometry(geom_data)
                                        
                                        #Add the point to the layer
                                        pr_stat_all_weekends.addFeature(p_weekends)
                                        vl_stat_all_weekends.updateExtents()
                                    
                                        # Updates the progress bar
                                        bar.setValue(87+(7/len(geoms))*index)
                                        QApplication.processEvents()
                                        
                                    vl_stat_all_weekends.startEditing()
                                    for s in selectedSensors_list:
                                        if empty_sensors[s]['Week_ends']:
                                            list_fields=pr_stat_all_weekends.fields()
                                            pr_stat_all_weekends.deleteAttributes([list_fields.indexFromName(s+' max_value'), 
                                                                              list_fields.indexFromName(s+' min_value'),
                                                                              list_fields.indexFromName(s+' count'),
                                                                              list_fields.indexFromName(s+' median_value'),
                                                                              list_fields.indexFromName(s+' stdev'),
                                                                              list_fields.indexFromName(s+' '+unit_measure),
                                                                              list_fields.indexFromName(s+' mean_value'),
                                                                              list_fields.indexFromName(s+' ANOVA test'),
                                                                              list_fields.indexFromName(s+' ANOVA value')])
                                    vl_stat_all_weekends.commitChanges()
                                    
                                    
                                    #Compute the ANOVA test if more than one area of interest 
                                    if len(geoms) > 1:
                                        for sensor in selectedSensors_list:
                                            if not empty_sensors[sensor]['Week_ends']:
                                                #number of the area
                                                index=0
                                                #list with the values for each group
                                                groups=[]
                                                means=[]
                                                size_groups=[]
                                                
                                                for geom_area in geoms:
                                                    index+=1
                                                    values=area_dic['Area '+str(index)]['Sensor dic'][sensor]['Week_ends']['ANOVA']['List values']
                                                    if len(values)>0:
                                                        mean=area_dic['Area '+str(index)]['Sensor dic'][sensor]['Week_ends']['ANOVA']['Mean value']
                                                        groups.append(values)
                                                        means.append(mean)
                                                        size_groups.append(len(values))
                                                
                                                if len(groups)>1:
                                                    (passes,u)=self.ANOVA_test(groups,means,size_groups)
                                                    v_features=vl_stat_all_weekends.getFeatures()
                                                    list_fields=pr_stat_all_weekends.fields()
                                                    id_f_test=list_fields.indexFromName(sensor+' ANOVA test')
                                                    id_f_value=list_fields.indexFromName(sensor+' ANOVA value')
                                                    
                                                    if passes:
                                                        print("Fisher test passes for sensor "+sensor+" in weekends")
                                         
                                                        vl_stat_all_weekends.startEditing()
                                                        for v_feat in v_features:
                                                            att_mean=v_feat.attribute(sensor+' mean_value')
                                                            if att_mean != None:
                                                                vl_stat_all_weekends.changeAttributeValue(v_feat.id(), id_f_value, u)
                                                                vl_stat_all_weekends.changeAttributeValue(v_feat.id(), id_f_test, "Yes")
                                                        vl_stat_all_weekends.commitChanges()
                                                    
                                                    else:
                                                        if u ==1:
                                                            self.iface.messageBar().pushMessage("Fisher test not applicable for sensor "+sensor+" in these weekends", Qgis.Warning)
                                                        print("Fisher test doesn't pass for sensor "+sensor+" in weekends")
                                                        vl_stat_all_weekends.startEditing()
                                                        for v_feat in v_features:
                                                            att_mean=v_feat.attribute(sensor+' mean_value')
                                                            if att_mean != None:
                                                                vl_stat_all_weekends.changeAttributeValue(v_feat.id(), id_f_test, "No")
                                                                vl_stat_all_weekends.changeAttributeValue(v_feat.id(), id_f_value, att_mean)
                                                            
                                                            
                                                            
                                                        vl_stat_all_weekends.commitChanges()
                                                    
                                                else:
                                                    self.iface.messageBar().pushMessage("No ANOVA possible for sensor "+sensor+" : to few data in these weekends", Qgis.Warning)
                                                
                                    #Remove the ANOVA test field if there is only one area of interest       
                                    else:
                                        vl_stat_all_weekends.startEditing()
                                        for s in selectedSensors_list:
                                            if not empty_sensors[s]['Week_ends']:
                                                list_fields=pr_stat_all_weekends.fields()
                                                pr_stat_all_weekends.deleteAttributes([list_fields.indexFromName(s+' ANOVA test'),
                                                                                           list_fields.indexFromName(s+' ANOVA value')]) 
                                            
                                        vl_stat_all_weekends.commitChanges()
                                    
                                    # Updates the progress bar
                                    bar.setValue(94)
                                    QApplication.processEvents()
                            
                                    #Build the diagram for the layer if there is only one sensor and the user chose to have it 
                                    if len(selectedSensors_list)==1 and vis:
                                        
                                        sensor=selectedSensors_list[0]
        
                                        attributes_stats=[pr_stat_all_weekends.fieldNameIndex(sensor+' max_value'), 
                                                          pr_stat_all_weekends.fieldNameIndex(sensor+' mean_value'), 
                                                          pr_stat_all_weekends.fieldNameIndex(sensor+' median_value'), 
                                                          pr_stat_all_weekends.fieldNameIndex(sensor+' min_value'), 
                                                          pr_stat_all_weekends.fieldNameIndex(sensor+' stdev')]
                                        
                                        attributes_names=['"{} max_value"'.format(sensor),
                                                          '"{} mean_value"'.format(sensor), 
                                                          '"{} median_value"'.format(sensor), 
                                                          '"{} min_value"'.format(sensor), 
                                                          '"{} stdev"'.format(sensor)]
                                        
                                        #get the max_value of the layer
                                        max_att_name = sensor+' max_value'
                                        idx = pr_stat_all_weekends.fieldNameIndex(max_att_name)
                                        max_value=vl_stat_all_weekends.maximumValue(idx)
                                        
                                        if max_value is not None:
                                            self.histogram(vl_stat_all_weekends, attributes_stats, attributes_names, max_value, max_att_name, 'small scale')
                                    
                                    
                                    
                                    #Add the layer with the general statistics for the whole area
                                    q.addMapLayer(vl_stat_all_weekends)
                                    
                                    
                                    
                                else:
                                    self.iface.messageBar().pushMessage("No data for these weekends", Qgis.Warning)
                            
                            #Updates the progress bar
                            bar.setValue(100)
                            QApplication.processEvents()
                    
                
                
                
                else :
                      QApplication.beep() 
                      self.iface.messageBar().pushMessage("No sensor selected", Qgis.Warning)
                        
            else:
                QApplication.beep() 
                self.iface.messageBar().pushMessage("No dataset selected", Qgis.Warning)

