# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Arlula
                                 A QGIS plugin
 arlula
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-06-01
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Arlula
        email                : adamhammo99@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
# non-pip imports
from .resources import *
from .arlula_dialog import ArlulaDialog
from qgis.PyQt.QtWidgets import QAction, QTableWidgetItem
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtCore import QCoreApplication, QSettings, QTranslator, QFileInfo, QDir
from qgis.core import QgsMessageLog, QgsProject, QgsRasterLayer
from pyproj import Proj, transform
import os
import sys
import shutil
import platform
from io import BytesIO
import json
import arlulaapi
import PIL.Image
import requests
import threading

py_version = sys.version.split(' ')[0]
os_version = platform.platform()
def_ua = "qgis-archive-sdk " + '[experimental]' + " python " + py_version + " OS " + os_version

DEFAULT_STATUS = "No pending requests"
VALID_LAYERS = ["img_tiff"]

class Arlula:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)

        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'Arlula_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&arlula')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

        # Set form vars
        self.start_date = None
        self.end_date = None
        self.res = None
        self.lat = -33.87
        self.long = 151.21
        self.south = -33.87
        self.east = 151.21
        self.north = -33.87
        self.west = 151.21
        self.key = None
        self.secret = None
        self.resmap = {
            'Very High (<0.5m)': 'vhigh',
            'High (0.5m-1m)': 'high',
            'Medium (1m-5m)': 'med',
            'Low (5m-20m)': 'low',
            'Very Low (>20m)': 'vlow'
        }
        self.files = []
        self.coords = True
        self.box = False
        self.orders = []
        self.selected_orders = []
        self.resources = []
        self.selected_resources = []
        self.download_folder = QFileInfo(QgsProject.instance().fileName()).dir().absolutePath()
        self.tab = 0
        self.tabs = ['Search', 'Get resource']
        self.add_resource = False
        os.chdir(self.plugin_dir)

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('Arlula', message)

    def add_action(
            self,
            icon_path,
            text,
            callback,
            enabled_flag=True,
            add_to_menu=True,
            add_to_toolbar=True,
            status_tip=None,
            whats_this=None,
            parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/arlula/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Arlula'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&arlula'),
                action)
            self.iface.removeToolBarIcon(action)

        for f in self.files:
            os.remove(f)

    def list_orders(self):
        self.dlg.status.setText("Retrieving account orders...")
        QCoreApplication.processEvents()
        QgsMessageLog.logMessage('Listing orders', 'Arlula')
        with arlulaapi.ArlulaSession(self.key, self.secret, allow_async=False, user_agent=def_ua) as arlula_session:
            self.orders = arlula_session.list_orders()
        for i,order in enumerate(self.orders):
            self.dlg.orderList.insertItem(i, f"{order.id} {order.supplier} {order.status}")
        self.dlg.status.setText(DEFAULT_STATUS)
    
    def list_resources(self):
        QgsMessageLog.logMessage('Listing resources', 'Arlula')
        self.resources = []
        with arlulaapi.ArlulaSession(self.key, self.secret, allow_async=False, user_agent=def_ua) as arlula_session:
            for order in self.selected_orders:
                order_id = order.text().split(' ')[0]
                self.dlg.status.setText(f"Retrieving resources for order {order_id}...")
                QCoreApplication.processEvents()
                self.dlg.orderLabel.setText(order_id)
                order_details = arlula_session.get_order(id=order_id)
                for x in order_details.resources :
                    self.resources.append(x)
        for i,r in enumerate(self.resources):
            self.dlg.resourceList.insertItem(i, f"{r.type} {r.name}")
        self.dlg.status.setText(DEFAULT_STATUS)

    def progress_callback(self):
        while True :
            progress = yield
            if progress is None :
                progress = 0
            self.dlg.progressBar.setValue(progress*100)
            QCoreApplication.processEvents()

    def download_resources(self):
        with arlulaapi.ArlulaSession(self.key, self.secret, allow_async=False, user_agent=def_ua) as arlula_session:
            i = 1
            for resource in self.selected_resources:
                pc = self.progress_callback()
                resource_id = self.resources[resource[0].row()].id
                resource_name = resource[1].text().split(' ')[1]
                resource_type = resource[1].text().split(' ')[0]
                self.dlg.status.setText(f"Downloading {resource_name} (File {i})")
                QCoreApplication.processEvents()
                arlula_session.get_resource(resource_id, filepath=self.download_folder+"/"+resource_name, suppress=True, progress_generator=pc)
                if resource_type in VALID_LAYERS and self.add_resource:
                    rlayer = QgsRasterLayer(self.download_folder+"/"+resource_name, resource_name)
                    QgsProject.instance().addMapLayer(rlayer)
                i+=1
        self.dlg.status.setText(DEFAULT_STATUS)

    def get_resources(self):
        QgsMessageLog.logMessage(f'Downloading resources', 'Arlula')
        self.download_resources()

    def search(self):
        QgsMessageLog.logMessage('Changing button', 'Arlula')
        self.dlg.searchButton.setText("Loading...")
        self.dlg.searchButton.setEnabled(False)
        self.dlg.resultTable.setRowCount(0)
        self.dlg.status.setText("Searching the Arlula archive...")

        QCoreApplication.processEvents()

        QgsMessageLog.logMessage('Searching', 'Arlula')
        QgsMessageLog.logMessage(
            self.start_date.toString('yyyy-MM-dd'), 'Arlula')
        QgsMessageLog.logMessage(
            self.end_date.toString('yyyy-MM-dd'), 'Arlula')
        QgsMessageLog.logMessage(self.res, 'Arlula')

        with arlulaapi.ArlulaSession(self.key, self.secret, allow_async=False, user_agent=def_ua) as arlula_session:
            if self.coords:
                res = arlula_session.search(
                    start=self.start_date.toString('yyyy-MM-dd'),
                    end=self.end_date.toString('yyyy-MM-dd'),
                    res=self.res,
                    lat=self.lat,
                    long=self.long
                )
                QgsMessageLog.logMessage(str(self.lat), 'Arlula')
                QgsMessageLog.logMessage(str(self.long), 'Arlula')
            elif self.box:
                res = arlula_session.search(
                    start=self.start_date.toString('yyyy-MM-dd'),
                    end=self.end_date.toString('yyyy-MM-dd'),
                    res=self.res,
                    south=self.south,
                    north=self.north,
                    east=self.east,
                    west=self.west
                )
                QgsMessageLog.logMessage(str(self.north), 'Arlula')
                QgsMessageLog.logMessage(str(self.south), 'Arlula')
                QgsMessageLog.logMessage(str(self.east), 'Arlula')
                QgsMessageLog.logMessage(str(self.west), 'Arlula')
        QgsMessageLog.logMessage("Found {} results".format(len(res)), 'Arlula')
        for row in res:
            n = self.dlg.resultTable.rowCount()
            self.dlg.resultTable.insertRow(n)
            self.dlg.resultTable.setItem(n, 0, QTableWidgetItem(row.supplier))
            self.dlg.resultTable.setItem(n, 1, QTableWidgetItem(row.date[:10]))
            self.dlg.resultTable.setItem(
                n, 2, QTableWidgetItem(str(row.resolution)))
            self.dlg.resultTable.setItem(n, 3, QTableWidgetItem(
                str(row.area)))
            self.dlg.resultTable.setItem(
                n, 4, QTableWidgetItem("$"+str(row.price.scene.base/100)))
            self.dlg.resultTable.setItem(
                n, 5, QTableWidgetItem(str(row.cloud)+"%"))
            self.dlg.resultTable.setItem(n, 6, QTableWidgetItem(row.thumbnail))
            self.dlg.resultTable.setItem(
                n, 7, QTableWidgetItem(json.dumps(row.bounding)))
            self.dlg.resultTable.setItem(n, 8, QTableWidgetItem("Add layer"))
            self.dlg.resultTable.setItem(n, 9, QTableWidgetItem("Place order"))

        self.dlg.searchButton.setText("Search")
        self.dlg.status.setText(DEFAULT_STATUS)
        self.dlg.searchButton.setEnabled(True)

    def add_layer(self, item):
        self.dlg.status.setText("Adding thumbnail layer...")
        QCoreApplication.processEvents()
        url = self.dlg.resultTable.item(item.row(), 6).text()
        imgname = url.split('/')[-1].split('=')[-1].split('.')[0]
        tfpath = imgname + '-converted.tiff'
        lypath = imgname + '-geo.tiff'
        self.files.append(tfpath)
        self.files.append(lypath)
        QgsMessageLog.logMessage(url, 'Arlula')
        r = requests.get(url)
        img = PIL.Image.open(BytesIO(r.content))
        img.save(tfpath)

        bounding = json.loads(self.dlg.resultTable.item(item.row(), 7).text())
        left = bounding[0][1]
        right = bounding[0][1]
        top = bounding[0][0]
        bottom = bounding[0][0]
        for coord in bounding:
            if coord[1] < left:
                left = coord[1]
            elif coord[1] > right:
                right = coord[1]
            if coord[0] < bottom:
                bottom = coord[0]
            elif coord[0] > top:
                top = coord[0]

        call = f'gdal_translate -of GTiff -a_ullr {left} {top} {right} {bottom} -a_srs EPSG:4326 {tfpath} {lypath}'
        QgsMessageLog.logMessage('Executing {}'.format(call), 'Arlula')
        os.system(call)

        rlayer = QgsRasterLayer(lypath, imgname)

        QgsProject.instance().addMapLayer(rlayer)
        self.dlg.status.setText(DEFAULT_STATUS)

    def table_click_handler(self, val):
        if val.column() == 8:
            self.add_layer(val)

    def change_start_date(self, val):
        QgsMessageLog.logMessage('Changed Start Date', 'Arlula')
        self.start_date = val

    def change_end_date(self, val):
        QgsMessageLog.logMessage('Changed End Date', 'Arlula')
        self.end_date = val

    def change_res(self, val):
        QgsMessageLog.logMessage('Changed Resolution', 'Arlula')
        self.res = self.resmap[val]

    def change_lat(self, val):
        QgsMessageLog.logMessage('Changed Latitude', 'Arlula')
        self.lat = val

    def change_long(self, val):
        QgsMessageLog.logMessage('Changed Longitude', 'Arlula')
        self.long = val

    def change_sth(self, val):
        QgsMessageLog.logMessage('Changed South', 'Arlula')
        self.south = val

    def change_nth(self, val):
        QgsMessageLog.logMessage('Changed North', 'Arlula')
        self.north = val

    def change_est(self, val):
        QgsMessageLog.logMessage('Changed East', 'Arlula')
        self.east = val

    def change_wst(self, val):
        QgsMessageLog.logMessage('Changed West', 'Arlula')
        self.west = val

    def change_key(self, val):
        QgsMessageLog.logMessage('Changed API Key', 'Arlula')
        self.key = val

    def change_secret(self, val):
        QgsMessageLog.logMessage('Changed API Secret', 'Arlula')
        self.secret = val

    def toggle_coord(self):
        QgsMessageLog.logMessage('Changed coord flag', 'Arlula')
        self.coords = not self.coords

    def toggle_box(self):
        QgsMessageLog.logMessage('Changed box flag', 'Arlula')
        self.box = not self.box

    def change_tab(self, ix):
        self.tab = ix
        if self.tabs[ix] == 'Get resource' :
            if self.key is not None and self.secret is not None :
                self.list_orders()

    def change_orders(self):
        self.selected_orders = self.dlg.orderList.selectedItems()
        
    def change_resources(self):
        self.selected_resources = zip(self.dlg.resourceList.selectionModel().selectedIndexes(), self.dlg.resourceList.selectedItems())

    def change_resource_folder(self, folder):
        self.download_folder = QDir(folder).absolutePath()

    def change_add_resource(self, state):
        self.add_resource = state==2

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = ArlulaDialog()
            # Add listeners to each of the inputs

            # Search tab
            self.dlg.searchButton.clicked.connect(self.search)
            self.dlg.start_date.dateChanged.connect(self.change_start_date)
            self.dlg.end_date.dateChanged.connect(self.change_end_date)
            self.dlg.res.currentTextChanged.connect(self.change_res)
            self.dlg.lat.valueChanged.connect(self.change_lat)
            self.dlg.long_2.valueChanged.connect(self.change_long)
            self.dlg.south.valueChanged.connect(self.change_sth)
            self.dlg.north.valueChanged.connect(self.change_nth)
            self.dlg.east.valueChanged.connect(self.change_est)
            self.dlg.west.valueChanged.connect(self.change_wst)
            self.dlg.key.textChanged.connect(self.change_key)
            self.dlg.secret.textChanged.connect(self.change_secret)
            self.dlg.coord_btn.toggled.connect(self.toggle_coord)
            self.dlg.box_btn.toggled.connect(self.toggle_box)
            self.dlg.resultTable.itemClicked.connect(self.table_click_handler)
                        
            # Get resource tab
            self.dlg.tabElement.currentChanged.connect(self.change_tab)
            self.dlg.listButton.clicked.connect(self.list_orders)
            self.dlg.orderList.itemSelectionChanged.connect(self.change_orders)
            self.dlg.selectOrder.clicked.connect(self.list_resources)
            self.dlg.resourceList.itemSelectionChanged.connect(self.change_resources)
            self.dlg.selectResource.clicked.connect(self.get_resources)
            self.dlg.resourceFolder.fileChanged.connect(self.change_resource_folder)
            self.dlg.resourceFolder.setFilePath(self.download_folder)
            self.dlg.addResource.stateChanged.connect(self.change_add_resource)
            
            QgsMessageLog.logMessage(
                f'Plugin loaded in {os.getcwd()}', 'Arlula')
            QgsMessageLog.logMessage(
                f'CRS: {QgsProject.instance().crs().authid()}')

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            QgsMessageLog.logMessage('Plugin closed', 'Arlula')
            # Do something useful here - delete the line containing pass and)
            # substitute with your code.

            # Search with params and put data in le table

        # while True:
        #     pass
