import requests
import re
import pandas as pd
import logging

logger = logging.getLogger(__name__)

def clean_url(url):
    if pd.isna(url):
        return url
    url = re.sub(r'\[(WMS|WFS)\]', '', url)
    url = url.replace('(', '').replace(')', '')
    return url.strip()

def check_service_availability(wms_link, wfs_link):
    wms_status = "N/A"
    wfs_status = "N/A"

    if wms_link:
        wms_status = check_wms_availability(wms_link)
    
    if wfs_link:
        wfs_status = check_wfs_availability(wfs_link)
    
    return f"WMS: {wms_status}, WFS: {wfs_status}"

def check_wms_availability(wms_link):
    try:
        wms_link = clean_url(wms_link)
        get_capabilities_url = f"{wms_link}?SERVICE=WMS&REQUEST=GetCapabilities"
        response = requests.get(get_capabilities_url, timeout=10)
        if response.status_code == 200:
            return "Available"
        else:
            return "Not Available"
    except requests.exceptions.RequestException as e:
        logger.error(f"Error checking WMS availability: {str(e)}")
        return "Not Available"

def check_wfs_availability(wfs_link):
    try:
        wfs_link = clean_url(wfs_link)
        get_capabilities_url = f"{wfs_link}?SERVICE=WFS&REQUEST=GetCapabilities&VERSION=2.0.0"
        response = requests.get(get_capabilities_url, timeout=10)
        if response.status_code == 200:
            return "Available"
        else:
            return "Not Available"
    except requests.exceptions.RequestException as e:
        logger.error(f"Error checking WFS availability: {str(e)}")
        return "Not Available"